#version 330 core
in vec2 UV;
out vec4 color;
uniform sampler2D shadowmap;
uniform vec2 iResolution;

void main() {
  color = vec4(0.0);
  float c = 0.0;
  vec3 m = vec3(0.8);
  mat3 p = mat3(0.5);
  mat3 r = mat3(1.0) / 10.;
  const float df = 1.0;
	for (float i = -2.0; i <= 2.0; i+=1.0) {
    for (float j = -2.0; j <= 2.0; j+=1.0) {
      c+=1.0;
      vec3 y = texture(shadowmap, UV + vec2(i, j) / iResolution).xyz;
      float lambda = 1.0;
      vec3 mp = m;
      mat3 pp = p;
      for (int k = 0; k <= 1; k++) {
        mat3 S = pp + r / lambda;
        mat3 K = pp * inverse(S);
        m = mp + K * (y - mp);
        p = (mat3(1.0) - K) * pp;
        vec3 v = y - mp;
        mat3 tmp = inverse(r) * p;
        lambda = (3. + df) / (df + dot(v, inverse(r) * v) + tmp[0][0] + tmp[1][1] + tmp[2][2]);
      }
    }
  }
  color = vec4(m, 1.0);
  //color = vec4(texture(shadowmap, UV).xyz, 1.0);
}
