#version 330 core
const float Nsamples = 32.0;

// inputz
in vec2 UV;
in vec2 ray;
uniform sampler2D normals;
uniform sampler2D dbuffer;
uniform mat4 projection;
uniform float rad;

const float lowlimit = 0.1;
const float hilimit = 0.7;

// outputz
out vec4 color;

#define HASHSCALE1 .1031
#define HASHSCALE3 vec3(.1031, .1030, .0973)
#define HASHSCALE4 vec4(1031, .1030, .0973, .1099)

// For smaller input rangers like audio tick or 0-1 UVs use these...
//#define HASHSCALE1 443.8975
//#define HASHSCALE3 vec3(443.897, 441.423, 437.195)
//#define HASHSCALE4 vec3(443.897, 441.423, 437.195, 444.129)



//----------------------------------------------------------------------------------------
//  1 out, 1 in...
float hash11(float p)
{
    vec3 p3  = fract(vec3(p) * HASHSCALE1);
    p3 += dot(p3, p3.yzx + 19.19);
    return fract((p3.x + p3.y) * p3.z);
}

//----------------------------------------------------------------------------------------
//  1 out, 2 in...
float hash12(vec2 p)
{
    vec3 p3  = fract(vec3(p.xyx) * HASHSCALE1);
    p3 += dot(p3, p3.yzx + 19.19);
    return fract((p3.x + p3.y) * p3.z);
}

vec3 getPos(vec2 uv) {
  float z = 2.0 * texture(dbuffer, uv).x - 1.0;
  vec4 clipSpace = vec4(2.0*UV-1.0, z, 1.0);
  vec4 homogLoc = inverse(projection) * clipSpace;
  return homogLoc.xyz / homogLoc.w;
}

vec3 rndsample(vec3 o, vec3 n, float i) {
    float p = 3.1415 * hash12(UV + i - o.z*o.y);
    float f = 2.0 * 3.1415 * hash12(UV - i + o.y*o.x);
    float R = rad * hash12(UV + o.zx + vec2(i, o.y));
    vec3 P = o + R * vec3(sin(p) * cos(f), sin(p) * sin(f), cos(p));
    return (-2.0 * float(dot(P - o, n) < 0.0)) * (P - o) + P;
}

float ssao() {
    if (texture(dbuffer, UV).x == 1.0) {
        return 1.0;
    }
    float ao = 0.0;
    float origz = texture(dbuffer, UV).x;
    vec3 origin = getPos(UV);
    vec3 normal = normalize(texture(normals, UV).xyz);

    for (float i = 0.0; i < Nsamples; i += 1.0) {
        vec3 candidate = rndsample(origin, normal, i);
        vec4 projd = projection * vec4(candidate, 1.0);
        vec2 ss = projd.xy / projd.w;
        vec2 sn = ss*0.5 + vec2(0.5);
        vec4 sz = texture(dbuffer, sn);
        ao += 1.0 * float(projd.z / projd.w * 0.5 + 0.5 <= sz.x); // Range check * contribution
    }
    return ao / Nsamples;
}

void main() {
    color = vec4(vec3(smoothstep(lowlimit, hilimit, ssao())), 1.0);
}
