
// This is ammo.js, a port of Bullet Physics to JavaScript. zlib licensed.
var AmmoLib = function(Module) {
  Module = Module || {};

var Module;if(!Module)Module=(typeof AmmoLib!=="undefined"?AmmoLib:null)||{};var moduleOverrides={};for(var key in Module){if(Module.hasOwnProperty(key)){moduleOverrides[key]=Module[key]}}var ENVIRONMENT_IS_NODE=typeof process==="object"&&typeof require==="function";var ENVIRONMENT_IS_WEB=typeof window==="object";var ENVIRONMENT_IS_WORKER=typeof importScripts==="function";var ENVIRONMENT_IS_SHELL=!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_NODE&&!ENVIRONMENT_IS_WORKER;if(ENVIRONMENT_IS_NODE){if(!Module["print"])Module["print"]=function print(x){process["stdout"].write(x+"\n")};if(!Module["printErr"])Module["printErr"]=function printErr(x){process["stderr"].write(x+"\n")};var nodeFS=require("fs");var nodePath=require("path");Module["read"]=function read(filename,binary){filename=nodePath["normalize"](filename);var ret=nodeFS["readFileSync"](filename);if(!ret&&filename!=nodePath["resolve"](filename)){filename=path.join(__dirname,"..","src",filename);ret=nodeFS["readFileSync"](filename)}if(ret&&!binary)ret=ret.toString();return ret};Module["readBinary"]=function readBinary(filename){return Module["read"](filename,true)};Module["load"]=function load(f){globalEval(read(f))};if(!Module["thisProgram"]){if(process["argv"].length>1){Module["thisProgram"]=process["argv"][1].replace(/\\/g,"/")}else{Module["thisProgram"]="unknown-program"}}Module["arguments"]=process["argv"].slice(2);if(typeof module!=="undefined"){module["exports"]=Module}process["on"]("uncaughtException",(function(ex){if(!(ex instanceof ExitStatus)){throw ex}}))}else if(ENVIRONMENT_IS_SHELL){if(!Module["print"])Module["print"]=print;if(typeof printErr!="undefined")Module["printErr"]=printErr;if(typeof read!="undefined"){Module["read"]=read}else{Module["read"]=function read(){throw"no read() available (jsc?)"}}Module["readBinary"]=function readBinary(f){if(typeof readbuffer==="function"){return new Uint8Array(readbuffer(f))}var data=read(f,"binary");assert(typeof data==="object");return data};if(typeof scriptArgs!="undefined"){Module["arguments"]=scriptArgs}else if(typeof arguments!="undefined"){Module["arguments"]=arguments}}else if(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER){Module["read"]=function read(url){var xhr=new XMLHttpRequest;xhr.open("GET",url,false);xhr.send(null);return xhr.responseText};if(typeof arguments!="undefined"){Module["arguments"]=arguments}if(typeof console!=="undefined"){if(!Module["print"])Module["print"]=function print(x){console.log(x)};if(!Module["printErr"])Module["printErr"]=function printErr(x){console.log(x)}}else{var TRY_USE_DUMP=false;if(!Module["print"])Module["print"]=TRY_USE_DUMP&&typeof dump!=="undefined"?(function(x){dump(x)}):(function(x){})}if(ENVIRONMENT_IS_WORKER){Module["load"]=importScripts}if(typeof Module["setWindowTitle"]==="undefined"){Module["setWindowTitle"]=(function(title){document.title=title})}}else{throw"Unknown runtime environment. Where are we?"}function globalEval(x){throw"NO_DYNAMIC_EXECUTION was set, cannot eval"}if(!Module["load"]&&Module["read"]){Module["load"]=function load(f){globalEval(Module["read"](f))}}if(!Module["print"]){Module["print"]=(function(){})}if(!Module["printErr"]){Module["printErr"]=Module["print"]}if(!Module["arguments"]){Module["arguments"]=[]}if(!Module["thisProgram"]){Module["thisProgram"]="./this.program"}Module.print=Module["print"];Module.printErr=Module["printErr"];Module["preRun"]=[];Module["postRun"]=[];for(var key in moduleOverrides){if(moduleOverrides.hasOwnProperty(key)){Module[key]=moduleOverrides[key]}}var Runtime={setTempRet0:(function(value){tempRet0=value}),getTempRet0:(function(){return tempRet0}),stackSave:(function(){return STACKTOP}),stackRestore:(function(stackTop){STACKTOP=stackTop}),getNativeTypeSize:(function(type){switch(type){case"i1":case"i8":return 1;case"i16":return 2;case"i32":return 4;case"i64":return 8;case"float":return 4;case"double":return 8;default:{if(type[type.length-1]==="*"){return Runtime.QUANTUM_SIZE}else if(type[0]==="i"){var bits=parseInt(type.substr(1));assert(bits%8===0);return bits/8}else{return 0}}}}),getNativeFieldSize:(function(type){return Math.max(Runtime.getNativeTypeSize(type),Runtime.QUANTUM_SIZE)}),STACK_ALIGN:16,getAlignSize:(function(type,size,vararg){if(!vararg&&(type=="i64"||type=="double"))return 8;if(!type)return Math.min(size,8);return Math.min(size||(type?Runtime.getNativeFieldSize(type):0),Runtime.QUANTUM_SIZE)}),dynCall:(function(sig,ptr,args){if(args&&args.length){if(!args.splice)args=Array.prototype.slice.call(args);args.splice(0,0,ptr);return Module["dynCall_"+sig].apply(null,args)}else{return Module["dynCall_"+sig].call(null,ptr)}}),functionPointers:[],addFunction:(function(func){for(var i=0;i<Runtime.functionPointers.length;i++){if(!Runtime.functionPointers[i]){Runtime.functionPointers[i]=func;return 2*(1+i)}}throw"Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS."}),removeFunction:(function(index){Runtime.functionPointers[(index-2)/2]=null}),getAsmConst:(function(code,numArgs){if(!Runtime.asmConstCache)Runtime.asmConstCache={};var func=Runtime.asmConstCache[code];if(func)return func;var args=[];for(var i=0;i<numArgs;i++){args.push(String.fromCharCode(36)+i)}var source=Pointer_stringify(code);if(source[0]==='"'){if(source.indexOf('"',1)===source.length-1){source=source.substr(1,source.length-2)}else{abort("invalid EM_ASM input |"+source+"|. Please use EM_ASM(..code..) (no quotes) or EM_ASM({ ..code($0).. }, input) (to input values)")}}abort("NO_DYNAMIC_EXECUTION was set, cannot eval, so EM_ASM is not functional");return Runtime.asmConstCache[code]=evalled}),warnOnce:(function(text){if(!Runtime.warnOnce.shown)Runtime.warnOnce.shown={};if(!Runtime.warnOnce.shown[text]){Runtime.warnOnce.shown[text]=1;Module.printErr(text)}}),funcWrappers:{},getFuncWrapper:(function(func,sig){assert(sig);if(!Runtime.funcWrappers[sig]){Runtime.funcWrappers[sig]={}}var sigCache=Runtime.funcWrappers[sig];if(!sigCache[func]){sigCache[func]=function dynCall_wrapper(){return Runtime.dynCall(sig,func,arguments)}}return sigCache[func]}),getCompilerSetting:(function(name){throw"You must build with -s RETAIN_COMPILER_SETTINGS=1 for Runtime.getCompilerSetting or emscripten_get_compiler_setting to work"}),stackAlloc:(function(size){var ret=STACKTOP;STACKTOP=STACKTOP+size|0;STACKTOP=STACKTOP+15&-16;return ret}),staticAlloc:(function(size){var ret=STATICTOP;STATICTOP=STATICTOP+size|0;STATICTOP=STATICTOP+15&-16;return ret}),dynamicAlloc:(function(size){var ret=DYNAMICTOP;DYNAMICTOP=DYNAMICTOP+size|0;DYNAMICTOP=DYNAMICTOP+15&-16;if(DYNAMICTOP>=TOTAL_MEMORY){var success=enlargeMemory();if(!success)return 0}return ret}),alignMemory:(function(size,quantum){var ret=size=Math.ceil(size/(quantum?quantum:16))*(quantum?quantum:16);return ret}),makeBigInt:(function(low,high,unsigned){var ret=unsigned?+(low>>>0)+ +(high>>>0)*+4294967296:+(low>>>0)+ +(high|0)*+4294967296;return ret}),GLOBAL_BASE:8,QUANTUM_SIZE:4,__dummy__:0};Module["Runtime"]=Runtime;var __THREW__=0;var ABORT=false;var EXITSTATUS=0;var undef=0;var tempValue,tempInt,tempBigInt,tempInt2,tempBigInt2,tempPair,tempBigIntI,tempBigIntR,tempBigIntS,tempBigIntP,tempBigIntD,tempDouble,tempFloat;var tempI64,tempI64b;var tempRet0,tempRet1,tempRet2,tempRet3,tempRet4,tempRet5,tempRet6,tempRet7,tempRet8,tempRet9;function assert(condition,text){if(!condition){abort("Assertion failed: "+text)}}var globalScope=this;function getCFunc(ident){var func=Module["_"+ident];if(!func){abort("NO_DYNAMIC_EXECUTION was set, cannot eval - ccall/cwrap are not functional")}assert(func,"Cannot call unknown function "+ident+" (perhaps LLVM optimizations or closure removed it?)");return func}var cwrap,ccall;((function(){var JSfuncs={"stackSave":(function(){Runtime.stackSave()}),"stackRestore":(function(){Runtime.stackRestore()}),"arrayToC":(function(arr){var ret=Runtime.stackAlloc(arr.length);writeArrayToMemory(arr,ret);return ret}),"stringToC":(function(str){var ret=0;if(str!==null&&str!==undefined&&str!==0){ret=Runtime.stackAlloc((str.length<<2)+1);writeStringToMemory(str,ret)}return ret})};var toC={"string":JSfuncs["stringToC"],"array":JSfuncs["arrayToC"]};ccall=function ccallFunc(ident,returnType,argTypes,args){var func=getCFunc(ident);var cArgs=[];var stack=0;if(args){for(var i=0;i<args.length;i++){var converter=toC[argTypes[i]];if(converter){if(stack===0)stack=Runtime.stackSave();cArgs[i]=converter(args[i])}else{cArgs[i]=args[i]}}}var ret=func.apply(null,cArgs);if(returnType==="string")ret=Pointer_stringify(ret);if(stack!==0)Runtime.stackRestore(stack);return ret};cwrap=function cwrap(ident,returnType,argTypes){return(function(){return ccall(ident,returnType,argTypes,arguments)})}}))();Module["cwrap"]=cwrap;Module["ccall"]=ccall;function setValue(ptr,value,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":HEAP8[ptr>>0]=value;break;case"i8":HEAP8[ptr>>0]=value;break;case"i16":HEAP16[ptr>>1]=value;break;case"i32":HEAP32[ptr>>2]=value;break;case"i64":tempI64=[value>>>0,(tempDouble=value,+Math_abs(tempDouble)>=+1?tempDouble>+0?(Math_min(+Math_floor(tempDouble/+4294967296),+4294967295)|0)>>>0:~~+Math_ceil((tempDouble- +(~~tempDouble>>>0))/+4294967296)>>>0:0)],HEAP32[ptr>>2]=tempI64[0],HEAP32[ptr+4>>2]=tempI64[1];break;case"float":HEAPF32[ptr>>2]=value;break;case"double":HEAPF64[ptr>>3]=value;break;default:abort("invalid type for setValue: "+type)}}Module["setValue"]=setValue;function getValue(ptr,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":return HEAP8[ptr>>0];case"i8":return HEAP8[ptr>>0];case"i16":return HEAP16[ptr>>1];case"i32":return HEAP32[ptr>>2];case"i64":return HEAP32[ptr>>2];case"float":return HEAPF32[ptr>>2];case"double":return HEAPF64[ptr>>3];default:abort("invalid type for setValue: "+type)}return null}Module["getValue"]=getValue;var ALLOC_NORMAL=0;var ALLOC_STACK=1;var ALLOC_STATIC=2;var ALLOC_DYNAMIC=3;var ALLOC_NONE=4;Module["ALLOC_NORMAL"]=ALLOC_NORMAL;Module["ALLOC_STACK"]=ALLOC_STACK;Module["ALLOC_STATIC"]=ALLOC_STATIC;Module["ALLOC_DYNAMIC"]=ALLOC_DYNAMIC;Module["ALLOC_NONE"]=ALLOC_NONE;function allocate(slab,types,allocator,ptr){var zeroinit,size;if(typeof slab==="number"){zeroinit=true;size=slab}else{zeroinit=false;size=slab.length}var singleType=typeof types==="string"?types:null;var ret;if(allocator==ALLOC_NONE){ret=ptr}else{ret=[_malloc,Runtime.stackAlloc,Runtime.staticAlloc,Runtime.dynamicAlloc][allocator===undefined?ALLOC_STATIC:allocator](Math.max(size,singleType?1:types.length))}if(zeroinit){var ptr=ret,stop;assert((ret&3)==0);stop=ret+(size&~3);for(;ptr<stop;ptr+=4){HEAP32[ptr>>2]=0}stop=ret+size;while(ptr<stop){HEAP8[ptr++>>0]=0}return ret}if(singleType==="i8"){if(slab.subarray||slab.slice){HEAPU8.set(slab,ret)}else{HEAPU8.set(new Uint8Array(slab),ret)}return ret}var i=0,type,typeSize,previousType;while(i<size){var curr=slab[i];if(typeof curr==="function"){curr=Runtime.getFunctionIndex(curr)}type=singleType||types[i];if(type===0){i++;continue}if(type=="i64")type="i32";setValue(ret+i,curr,type);if(previousType!==type){typeSize=Runtime.getNativeTypeSize(type);previousType=type}i+=typeSize}return ret}Module["allocate"]=allocate;function Pointer_stringify(ptr,length){if(length===0||!ptr)return"";var hasUtf=0;var t;var i=0;while(1){t=HEAPU8[ptr+i>>0];hasUtf|=t;if(t==0&&!length)break;i++;if(length&&i==length)break}if(!length)length=i;var ret="";if(hasUtf<128){var MAX_CHUNK=1024;var curr;while(length>0){curr=String.fromCharCode.apply(String,HEAPU8.subarray(ptr,ptr+Math.min(length,MAX_CHUNK)));ret=ret?ret+curr:curr;ptr+=MAX_CHUNK;length-=MAX_CHUNK}return ret}return Module["UTF8ToString"](ptr)}Module["Pointer_stringify"]=Pointer_stringify;function AsciiToString(ptr){var str="";while(1){var ch=HEAP8[ptr++>>0];if(!ch)return str;str+=String.fromCharCode(ch)}}Module["AsciiToString"]=AsciiToString;function stringToAscii(str,outPtr){return writeAsciiToMemory(str,outPtr,false)}Module["stringToAscii"]=stringToAscii;function UTF8ArrayToString(u8Array,idx){var u0,u1,u2,u3,u4,u5;var str="";while(1){u0=u8Array[idx++];if(!u0)return str;if(!(u0&128)){str+=String.fromCharCode(u0);continue}u1=u8Array[idx++]&63;if((u0&224)==192){str+=String.fromCharCode((u0&31)<<6|u1);continue}u2=u8Array[idx++]&63;if((u0&240)==224){u0=(u0&15)<<12|u1<<6|u2}else{u3=u8Array[idx++]&63;if((u0&248)==240){u0=(u0&7)<<18|u1<<12|u2<<6|u3}else{u4=u8Array[idx++]&63;if((u0&252)==248){u0=(u0&3)<<24|u1<<18|u2<<12|u3<<6|u4}else{u5=u8Array[idx++]&63;u0=(u0&1)<<30|u1<<24|u2<<18|u3<<12|u4<<6|u5}}}if(u0<65536){str+=String.fromCharCode(u0)}else{var ch=u0-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}}}Module["UTF8ArrayToString"]=UTF8ArrayToString;function UTF8ToString(ptr){return UTF8ArrayToString(HEAPU8,ptr)}Module["UTF8ToString"]=UTF8ToString;function stringToUTF8Array(str,outU8Array,outIdx,maxBytesToWrite){if(!(maxBytesToWrite>0))return 0;var startIdx=outIdx;var endIdx=outIdx+maxBytesToWrite-1;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127){if(outIdx>=endIdx)break;outU8Array[outIdx++]=u}else if(u<=2047){if(outIdx+1>=endIdx)break;outU8Array[outIdx++]=192|u>>6;outU8Array[outIdx++]=128|u&63}else if(u<=65535){if(outIdx+2>=endIdx)break;outU8Array[outIdx++]=224|u>>12;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else if(u<=2097151){if(outIdx+3>=endIdx)break;outU8Array[outIdx++]=240|u>>18;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else if(u<=67108863){if(outIdx+4>=endIdx)break;outU8Array[outIdx++]=248|u>>24;outU8Array[outIdx++]=128|u>>18&63;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else{if(outIdx+5>=endIdx)break;outU8Array[outIdx++]=252|u>>30;outU8Array[outIdx++]=128|u>>24&63;outU8Array[outIdx++]=128|u>>18&63;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}}outU8Array[outIdx]=0;return outIdx-startIdx}Module["stringToUTF8Array"]=stringToUTF8Array;function stringToUTF8(str,outPtr,maxBytesToWrite){return stringToUTF8Array(str,HEAPU8,outPtr,maxBytesToWrite)}Module["stringToUTF8"]=stringToUTF8;function lengthBytesUTF8(str){var len=0;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127){++len}else if(u<=2047){len+=2}else if(u<=65535){len+=3}else if(u<=2097151){len+=4}else if(u<=67108863){len+=5}else{len+=6}}return len}Module["lengthBytesUTF8"]=lengthBytesUTF8;function UTF16ToString(ptr){var i=0;var str="";while(1){var codeUnit=HEAP16[ptr+i*2>>1];if(codeUnit==0)return str;++i;str+=String.fromCharCode(codeUnit)}}Module["UTF16ToString"]=UTF16ToString;function stringToUTF16(str,outPtr,maxBytesToWrite){if(maxBytesToWrite===undefined){maxBytesToWrite=2147483647}if(maxBytesToWrite<2)return 0;maxBytesToWrite-=2;var startPtr=outPtr;var numCharsToWrite=maxBytesToWrite<str.length*2?maxBytesToWrite/2:str.length;for(var i=0;i<numCharsToWrite;++i){var codeUnit=str.charCodeAt(i);HEAP16[outPtr>>1]=codeUnit;outPtr+=2}HEAP16[outPtr>>1]=0;return outPtr-startPtr}Module["stringToUTF16"]=stringToUTF16;function lengthBytesUTF16(str){return str.length*2}Module["lengthBytesUTF16"]=lengthBytesUTF16;function UTF32ToString(ptr){var i=0;var str="";while(1){var utf32=HEAP32[ptr+i*4>>2];if(utf32==0)return str;++i;if(utf32>=65536){var ch=utf32-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}else{str+=String.fromCharCode(utf32)}}}Module["UTF32ToString"]=UTF32ToString;function stringToUTF32(str,outPtr,maxBytesToWrite){if(maxBytesToWrite===undefined){maxBytesToWrite=2147483647}if(maxBytesToWrite<4)return 0;var startPtr=outPtr;var endPtr=startPtr+maxBytesToWrite-4;for(var i=0;i<str.length;++i){var codeUnit=str.charCodeAt(i);if(codeUnit>=55296&&codeUnit<=57343){var trailSurrogate=str.charCodeAt(++i);codeUnit=65536+((codeUnit&1023)<<10)|trailSurrogate&1023}HEAP32[outPtr>>2]=codeUnit;outPtr+=4;if(outPtr+4>endPtr)break}HEAP32[outPtr>>2]=0;return outPtr-startPtr}Module["stringToUTF32"]=stringToUTF32;function lengthBytesUTF32(str){var len=0;for(var i=0;i<str.length;++i){var codeUnit=str.charCodeAt(i);if(codeUnit>=55296&&codeUnit<=57343)++i;len+=4}return len}Module["lengthBytesUTF32"]=lengthBytesUTF32;function demangle(func){var hasLibcxxabi=!!Module["___cxa_demangle"];if(hasLibcxxabi){try{var buf=_malloc(func.length);writeStringToMemory(func.substr(1),buf);var status=_malloc(4);var ret=Module["___cxa_demangle"](buf,0,0,status);if(getValue(status,"i32")===0&&ret){return Pointer_stringify(ret)}}catch(e){}finally{if(buf)_free(buf);if(status)_free(status);if(ret)_free(ret)}}var i=3;var basicTypes={"v":"void","b":"bool","c":"char","s":"short","i":"int","l":"long","f":"float","d":"double","w":"wchar_t","a":"signed char","h":"unsigned char","t":"unsigned short","j":"unsigned int","m":"unsigned long","x":"long long","y":"unsigned long long","z":"..."};var subs=[];var first=true;function dump(x){if(x)Module.print(x);Module.print(func);var pre="";for(var a=0;a<i;a++)pre+=" ";Module.print(pre+"^")}function parseNested(){i++;if(func[i]==="K")i++;var parts=[];while(func[i]!=="E"){if(func[i]==="S"){i++;var next=func.indexOf("_",i);var num=func.substring(i,next)||0;parts.push(subs[num]||"?");i=next+1;continue}if(func[i]==="C"){parts.push(parts[parts.length-1]);i+=2;continue}var size=parseInt(func.substr(i));var pre=size.toString().length;if(!size||!pre){i--;break}var curr=func.substr(i+pre,size);parts.push(curr);subs.push(curr);i+=pre+size}i++;return parts}function parse(rawList,limit,allowVoid){limit=limit||Infinity;var ret="",list=[];function flushList(){return"("+list.join(", ")+")"}var name;if(func[i]==="N"){name=parseNested().join("::");limit--;if(limit===0)return rawList?[name]:name}else{if(func[i]==="K"||first&&func[i]==="L")i++;var size=parseInt(func.substr(i));if(size){var pre=size.toString().length;name=func.substr(i+pre,size);i+=pre+size}}first=false;if(func[i]==="I"){i++;var iList=parse(true);var iRet=parse(true,1,true);ret+=iRet[0]+" "+name+"<"+iList.join(", ")+">"}else{ret=name}paramLoop:while(i<func.length&&limit-->0){var c=func[i++];if(c in basicTypes){list.push(basicTypes[c])}else{switch(c){case"P":list.push(parse(true,1,true)[0]+"*");break;case"R":list.push(parse(true,1,true)[0]+"&");break;case"L":{i++;var end=func.indexOf("E",i);var size=end-i;list.push(func.substr(i,size));i+=size+2;break};case"A":{var size=parseInt(func.substr(i));i+=size.toString().length;if(func[i]!=="_")throw"?";i++;list.push(parse(true,1,true)[0]+" ["+size+"]");break};case"E":break paramLoop;default:ret+="?"+c;break paramLoop}}}if(!allowVoid&&list.length===1&&list[0]==="void")list=[];if(rawList){if(ret){list.push(ret+"?")}return list}else{return ret+flushList()}}var parsed=func;try{if(func=="Object._main"||func=="_main"){return"main()"}if(typeof func==="number")func=Pointer_stringify(func);if(func[0]!=="_")return func;if(func[1]!=="_")return func;if(func[2]!=="Z")return func;switch(func[3]){case"n":return"operator new()";case"d":return"operator delete()"}parsed=parse()}catch(e){parsed+="?"}if(parsed.indexOf("?")>=0&&!hasLibcxxabi){Runtime.warnOnce("warning: a problem occurred in builtin C++ name demangling; build with  -s DEMANGLE_SUPPORT=1  to link in libcxxabi demangling")}return parsed}function demangleAll(text){return text.replace(/__Z[\w\d_]+/g,(function(x){var y=demangle(x);return x===y?x:x+" ["+y+"]"}))}function jsStackTrace(){var err=new Error;if(!err.stack){try{throw new Error(0)}catch(e){err=e}if(!err.stack){return"(no stack trace available)"}}return err.stack.toString()}function stackTrace(){return demangleAll(jsStackTrace())}Module["stackTrace"]=stackTrace;var PAGE_SIZE=4096;function alignMemoryPage(x){if(x%4096>0){x+=4096-x%4096}return x}var HEAP;var HEAP8,HEAPU8,HEAP16,HEAPU16,HEAP32,HEAPU32,HEAPF32,HEAPF64;var STATIC_BASE=0,STATICTOP=0,staticSealed=false;var STACK_BASE=0,STACKTOP=0,STACK_MAX=0;var DYNAMIC_BASE=0,DYNAMICTOP=0;function enlargeMemory(){abort("Cannot enlarge memory arrays. Either (1) compile with -s TOTAL_MEMORY=X with X higher than the current value "+TOTAL_MEMORY+", (2) compile with ALLOW_MEMORY_GROWTH which adjusts the size at runtime but prevents some optimizations, or (3) set Module.TOTAL_MEMORY before the program runs.")}var TOTAL_STACK=Module["TOTAL_STACK"]||5242880;var TOTAL_MEMORY=Module["TOTAL_MEMORY"]||67108864;var totalMemory=64*1024;while(totalMemory<TOTAL_MEMORY||totalMemory<2*TOTAL_STACK){if(totalMemory<16*1024*1024){totalMemory*=2}else{totalMemory+=16*1024*1024}}if(totalMemory!==TOTAL_MEMORY){Module.printErr("increasing TOTAL_MEMORY to "+totalMemory+" to be compliant with the asm.js spec (and given that TOTAL_STACK="+TOTAL_STACK+")");TOTAL_MEMORY=totalMemory}assert(typeof Int32Array!=="undefined"&&typeof Float64Array!=="undefined"&&!!(new Int32Array(1))["subarray"]&&!!(new Int32Array(1))["set"],"JS engine does not provide full typed array support");var buffer=new ArrayBuffer(TOTAL_MEMORY);HEAP8=new Int8Array(buffer);HEAP16=new Int16Array(buffer);HEAP32=new Int32Array(buffer);HEAPU8=new Uint8Array(buffer);HEAPU16=new Uint16Array(buffer);HEAPU32=new Uint32Array(buffer);HEAPF32=new Float32Array(buffer);HEAPF64=new Float64Array(buffer);HEAP32[0]=255;assert(HEAPU8[0]===255&&HEAPU8[3]===0,"Typed arrays 2 must be run on a little-endian system");Module["HEAP"]=HEAP;Module["buffer"]=buffer;Module["HEAP8"]=HEAP8;Module["HEAP16"]=HEAP16;Module["HEAP32"]=HEAP32;Module["HEAPU8"]=HEAPU8;Module["HEAPU16"]=HEAPU16;Module["HEAPU32"]=HEAPU32;Module["HEAPF32"]=HEAPF32;Module["HEAPF64"]=HEAPF64;function callRuntimeCallbacks(callbacks){while(callbacks.length>0){var callback=callbacks.shift();if(typeof callback=="function"){callback();continue}var func=callback.func;if(typeof func==="number"){if(callback.arg===undefined){Runtime.dynCall("v",func)}else{Runtime.dynCall("vi",func,[callback.arg])}}else{func(callback.arg===undefined?null:callback.arg)}}}var __ATPRERUN__=[];var __ATINIT__=[];var __ATMAIN__=[];var __ATEXIT__=[];var __ATPOSTRUN__=[];var runtimeInitialized=false;var runtimeExited=false;function preRun(){if(Module["preRun"]){if(typeof Module["preRun"]=="function")Module["preRun"]=[Module["preRun"]];while(Module["preRun"].length){addOnPreRun(Module["preRun"].shift())}}callRuntimeCallbacks(__ATPRERUN__)}function ensureInitRuntime(){if(runtimeInitialized)return;runtimeInitialized=true;callRuntimeCallbacks(__ATINIT__)}function preMain(){callRuntimeCallbacks(__ATMAIN__)}function exitRuntime(){callRuntimeCallbacks(__ATEXIT__);runtimeExited=true}function postRun(){if(Module["postRun"]){if(typeof Module["postRun"]=="function")Module["postRun"]=[Module["postRun"]];while(Module["postRun"].length){addOnPostRun(Module["postRun"].shift())}}callRuntimeCallbacks(__ATPOSTRUN__)}function addOnPreRun(cb){__ATPRERUN__.unshift(cb)}Module["addOnPreRun"]=Module.addOnPreRun=addOnPreRun;function addOnInit(cb){__ATINIT__.unshift(cb)}Module["addOnInit"]=Module.addOnInit=addOnInit;function addOnPreMain(cb){__ATMAIN__.unshift(cb)}Module["addOnPreMain"]=Module.addOnPreMain=addOnPreMain;function addOnExit(cb){__ATEXIT__.unshift(cb)}Module["addOnExit"]=Module.addOnExit=addOnExit;function addOnPostRun(cb){__ATPOSTRUN__.unshift(cb)}Module["addOnPostRun"]=Module.addOnPostRun=addOnPostRun;function intArrayFromString(stringy,dontAddNull,length){var len=length>0?length:lengthBytesUTF8(stringy)+1;var u8array=new Array(len);var numBytesWritten=stringToUTF8Array(stringy,u8array,0,u8array.length);if(dontAddNull)u8array.length=numBytesWritten;return u8array}Module["intArrayFromString"]=intArrayFromString;function intArrayToString(array){var ret=[];for(var i=0;i<array.length;i++){var chr=array[i];if(chr>255){chr&=255}ret.push(String.fromCharCode(chr))}return ret.join("")}Module["intArrayToString"]=intArrayToString;function writeStringToMemory(string,buffer,dontAddNull){var array=intArrayFromString(string,dontAddNull);var i=0;while(i<array.length){var chr=array[i];HEAP8[buffer+i>>0]=chr;i=i+1}}Module["writeStringToMemory"]=writeStringToMemory;function writeArrayToMemory(array,buffer){for(var i=0;i<array.length;i++){HEAP8[buffer++>>0]=array[i]}}Module["writeArrayToMemory"]=writeArrayToMemory;function writeAsciiToMemory(str,buffer,dontAddNull){for(var i=0;i<str.length;++i){HEAP8[buffer++>>0]=str.charCodeAt(i)}if(!dontAddNull)HEAP8[buffer>>0]=0}Module["writeAsciiToMemory"]=writeAsciiToMemory;function unSign(value,bits,ignore){if(value>=0){return value}return bits<=32?2*Math.abs(1<<bits-1)+value:Math.pow(2,bits)+value}function reSign(value,bits,ignore){if(value<=0){return value}var half=bits<=32?Math.abs(1<<bits-1):Math.pow(2,bits-1);if(value>=half&&(bits<=32||value>half)){value=-2*half+value}return value}if(!Math["imul"]||Math["imul"](4294967295,5)!==-5)Math["imul"]=function imul(a,b){var ah=a>>>16;var al=a&65535;var bh=b>>>16;var bl=b&65535;return al*bl+(ah*bl+al*bh<<16)|0};Math.imul=Math["imul"];if(!Math["clz32"])Math["clz32"]=(function(x){x=x>>>0;for(var i=0;i<32;i++){if(x&1<<31-i)return i}return 32});Math.clz32=Math["clz32"];var Math_abs=Math.abs;var Math_cos=Math.cos;var Math_sin=Math.sin;var Math_tan=Math.tan;var Math_acos=Math.acos;var Math_asin=Math.asin;var Math_atan=Math.atan;var Math_atan2=Math.atan2;var Math_exp=Math.exp;var Math_log=Math.log;var Math_sqrt=Math.sqrt;var Math_ceil=Math.ceil;var Math_floor=Math.floor;var Math_pow=Math.pow;var Math_imul=Math.imul;var Math_fround=Math.fround;var Math_min=Math.min;var Math_clz32=Math.clz32;var runDependencies=0;var runDependencyWatcher=null;var dependenciesFulfilled=null;function addRunDependency(id){runDependencies++;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}}Module["addRunDependency"]=addRunDependency;function removeRunDependency(id){runDependencies--;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}if(runDependencies==0){if(runDependencyWatcher!==null){clearInterval(runDependencyWatcher);runDependencyWatcher=null}if(dependenciesFulfilled){var callback=dependenciesFulfilled;dependenciesFulfilled=null;callback()}}}Module["removeRunDependency"]=removeRunDependency;Module["preloadedImages"]={};Module["preloadedAudios"]={};var memoryInitializer=null;STATIC_BASE=8;STATICTOP=STATIC_BASE+22032;__ATINIT__.push({func:(function(){__GLOBAL__sub_I_btQuickprof_cpp()})});allocate([0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,1,0,0,1,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,49,55,98,116,84,121,112,101,100,67,111,110,115,116,114,97,105,110,116,0,0,0,0,0,49,51,98,116,84,121,112,101,100,79,98,106,101,99,116,0,56,83,0,0,168,1,0,0,192,83,0,0,144,1,0,0,0,0,0,0,1,0,0,0,184,1,0,0,2,4,0,0,0,0,0,0,56,2,0,0,4,0,0,0,5,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,49,57,98,116,71,104,111,115,116,80,97,105,114,67,97,108,108,98,97,99,107,0,0,0,50,53,98,116,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,108,108,98,97,99,107,0,0,0,0,0,56,83,0,0,16,2,0,0,96,83,0,0,248,1,0,0,48,2,0,0,0,0,0,0,49,56,98,116,86,101,104,105,99,108,101,82,97,121,99,97,115,116,101,114,0,0,0,0,56,83,0,0,72,2,0,0,0,0,0,0,224,2,0,0,6,0,0,0,7,0,0,0,1,0,0,0,1,0,0,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,52,67,108,111,115,101,115,116,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,56,83,0,0,176,2,0,0,96,83,0,0,128,2,0,0,216,2,0,0,0,0,0,0,0,0,0,0,56,3,0,0,8,0,0,0,9,0,0,0,1,0,0,0,2,0,0,0,50,48,98,116,68,101,102,97,117,108,116,77,111,116,105,111,110,83,116,97,116,101,0,0,49,51,98,116,77,111,116,105,111,110,83,116,97,116,101,0,56,83,0,0,32,3,0,0,96,83,0,0,8,3,0,0,48,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,4,0,0,10,0,0,0,11,0,0,0,2,0,0,0,2,0,0,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,55,67,108,111,115,101,115,116,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,0,0,0,0,0,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,48,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,0,0,0,0,0,56,83,0,0,24,4,0,0,96,83,0,0,224,3,0,0,72,4,0,0,0,0,0,0,0,0,0,0,208,4,0,0,12,0,0,0,13,0,0,0,3,0,0,0,1,0,0,0,50,57,67,111,110,99,114,101,116,101,67,111,110,116,97,99,116,82,101,115,117,108,116,67,97,108,108,98,97,99,107,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,49,67,111,110,116,97,99,116,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,0,0,0,0,56,83,0,0,152,4,0,0,96,83,0,0,120,4,0,0,200,4,0,0,0,0,0,0,123,32,118,97,114,32,115,101,108,102,32,61,32,77,111,100,117,108,101,91,39,103,101,116,67,97,99,104,101,39,93,40,77,111,100,117,108,101,91,39,67,111,110,99,114,101,116,101,67,111,110,116,97,99,116,82,101,115,117,108,116,67,97,108,108,98,97,99,107,39,93,41,91,36,48,93,59,32,105,102,32,40,33,115,101,108,102,46,104,97,115,79,119,110,80,114,111,112,101,114,116,121,40,39,97,100,100,83,105,110,103,108,101,82,101,115,117,108,116,39,41,41,32,116,104,114,111,119,32,39,97,32,74,83,73,109,112,108,101,109,101,110,116,97,116,105,111,110,32,109,117,115,116,32,105,109,112,108,101,109,101,110,116,32,97,108,108,32,102,117,110,99,116,105,111,110,115,44,32,121,111,117,32,102,111,114,103,111,116,32,67,111,110,99,114,101,116,101,67,111,110,116,97,99,116,82,101,115,117,108,116,67,97,108,108,98,97,99,107,58,58,97,100,100,83,105,110,103,108,101,82,101,115,117,108,116,46,39,59,32,114,101,116,117,114,110,32,115,101,108,102,46,97,100,100,83,105,110,103,108,101,82,101,115,117,108,116,40,36,49,44,36,50,44,36,51,44,36,52,44,36,53,44,36,54,44,36,55,41,59,32,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,6,0,0,4,0,0,0,14,0,0,0,15,0,0,0,3,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,116,82,105,103,105,100,66,111,100,121,70,108,111,97,116,68,97,116,97,0,0,0,0,49,49,98,116,82,105,103,105,100,66,111,100,121,0,0,0,96,83,0,0,88,6,0,0,120,21,0,0,0,0,0,0,0,0,0,0,64,9,0,0,16,0,0,0,17,0,0,0,18,0,0,0,19,0,0,0,5,0,0,0,3,0,0,0,20,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,6,0,0,0,21,0,0,0,7,0,0,0,1,0,0,0,2,0,0,0,8,0,0,0,9,0,0,0,10,0,0,0,11,0,0,0,12,0,0,0,22,0,0,0,13,0,0,0,4,0,0,0,14,0,0,0,15,0,0,0,4,0,0,0,5,0,0,0,5,0,0,0,6,0,0,0,6,0,0,0,23,0,0,0,16,0,0,0,17,0,0,0,18,0,0,0,19,0,0,0,1,0,0,0,2,0,0,0,24,0,0,0,20,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,25,0,0,0,21,0,0,0,6,0,0,0,0,0,0,0,100,101,98,117,103,68,114,97,119,87,111,114,108,100,0,0,115,121,110,99,104,114,111,110,105,122,101,77,111,116,105,111,110,83,116,97,116,101,115,0,115,116,101,112,83,105,109,117,108,97,116,105,111,110,0,0,105,110,116,101,114,110,97,108,83,105,110,103,108,101,83,116,101,112,83,105,109,117,108,97,116,105,111,110,0,0,0,0,117,112,100,97,116,101,65,99,116,105,111,110,115,0,0,0,117,112,100,97,116,101,65,99,116,105,118,97,116,105,111,110,83,116,97,116,101,0,0,0,115,111,108,118,101,67,111,110,115,116,114,97,105,110,116,115,0,0,0,0,0,0,0,0,99,97,108,99,117,108,97,116,101,83,105,109,117,108,97,116,105,111,110,73,115,108,97,110,100,115,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,114,101,97,116,101,80,114,101,100,105,99,116,105,118,101,67,111,110,116,97,99,116,115,0,0,0,0,0,0,0,0,114,101,108,101,97,115,101,32,112,114,101,100,105,99,116,105,118,101,32,99,111,110,116,97,99,116,32,109,97,110,105,102,111,108,100,115,0,0,0,0,112,114,101,100,105,99,116,105,118,101,32,99,111,110,118,101,120,83,119,101,101,112,84,101,115,116,0,0,0,0,0,0,105,110,116,101,103,114,97,116,101,84,114,97,110,115,102,111,114,109,115,0,0,0,0,0,67,67,68,32,109,111,116,105,111,110,32,99,108,97,109,112,105,110,103,0,0,0,0,0,97,112,112,108,121,32,115,112,101,99,117,108,97,116,105,118,101,32,99,111,110,116,97,99,116,32,114,101,115,116,105,116,117,116,105,111,110,0,0,0,112,114,101,100,105,99,116,85,110,99,111,110,115,116,114,97,105,110,116,77,111,116,105,111,110,0,0,0,0,0,0,0,98,116,68,121,110,97,109,105,99,115,87,111,114,108,100,70,108,111,97,116,68,97,116,97,0,0,0,0,0,0,0,0,50,51,98,116,68,105,115,99,114,101,116,101,68,121,110,97,109,105,99,115,87,111,114,108,100,0,0,0,0,0,0,0,49,53,98,116,68,121,110,97,109,105,99,115,87,111,114,108,100,0,0,0,0,0,0,0,96,83,0,0,24,9,0,0,128,33,0,0,0,0,0,0,96,83,0,0,248,8,0,0,48,9,0,0,0,0,0,0,0,0,0,0,144,9,0,0,26,0,0,0,27,0,0,0,7,0,0,0,3,0,0,0,51,52,98,116,67,108,111,115,101,115,116,78,111,116,77,101,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,0,0,0,0,96,83,0,0,104,9,0,0,80,4,0,0,0,0,0,0,0,0,0,0,16,10,0,0,28,0,0,0,29,0,0,0,1,0,0,0,0,0,0,0,50,55,73,110,112,108,97,99,101,83,111,108,118,101,114,73,115,108,97,110,100,67,97,108,108,98,97,99,107,0,0,0,78,50,53,98,116,83,105,109,117,108,97,116,105,111,110,73,115,108,97,110,100,77,97,110,97,103,101,114,49,52,73,115,108,97,110,100,67,97,108,108,98,97,99,107,69,0,0,0,56,83,0,0,216,9,0,0,96,83,0,0,184,9,0,0,8,10,0,0,0,0,0,0,0,0,0,0,120,10,0,0,1,0,0,0,30,0,0,0,31,0,0,0,1,0,0,0,22,0,0,0,23,0,0,0,1,0,0,0,1,0,0,0,4,0,0,0,7,0,0,0,4,0,0,0,32,0,0,0,50,51,98,116,71,101,110,101,114,105,99,54,68,111,102,67,111,110,115,116,114,97,105,110,116,0,0,0,0,0,0,0,96,83,0,0,88,10,0,0,192,1,0,0,0,0,0,0,98,116,71,101,110,101,114,105,99,54,68,111,102,67,111,110,115,116,114,97,105,110,116,68,97,116,97,0,0,0,0,0,0,0,0,0,8,11,0,0,1,0,0,0,33,0,0,0,31,0,0,0,1,0,0,0,22,0,0,0,24,0,0,0,1,0,0,0,1,0,0,0,4,0,0,0,8,0,0,0,5,0,0,0,32,0,0,0,3,0,0,0,0,0,0,0,50,57,98,116,71,101,110,101,114,105,99,54,68,111,102,83,112,114,105,110,103,67,111,110,115,116,114,97,105,110,116,0,96,83,0,0,232,10,0,0,120,10,0,0,0,0,0,0,98,116,71,101,110,101,114,105,99,54,68,111,102,83,112,114,105,110,103,67,111,110,115,116,114,97,105,110,116,68,97,116,97,0,0,0,0,0,0,0,0,0,0,0,152,11,0,0,1,0,0,0,34,0,0,0,35,0,0,0,1,0,0,0,25,0,0,0,26,0,0,0,1,0,0,0,2,0,0,0,5,0,0,0,9,0,0,0,6,0,0,0,0,0,0,0,50,51,98,116,80,111,105,110,116,50,80,111,105,110,116,67,111,110,115,116,114,97,105,110,116,0,0,0,0,0,0,0,96,83,0,0,120,11,0,0,192,1,0,0,0,0,0,0,98,116,80,111,105,110,116,50,80,111,105,110,116,67,111,110,115,116,114,97,105,110,116,70,108,111,97,116,68,97,116,97,0,0,0,0,0,0,0,0,98,116,84,121,112,101,100,67,111,110,115,116,114,97,105,110,116,70,108,111,97,116,68,97,116,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,14,0,0,1,0,0,0,36,0,0,0,3,0,0,0,1,0,0,0,27,0,0,0,28,0,0,0,1,0,0,0,3,0,0,0,6,0,0,0,10,0,0,0,7,0,0,0,0,0,0,0,49,56,98,116,83,108,105,100,101,114,67,111,110,115,116,114,97,105,110,116,0,0,0,0,96,83,0,0,152,14,0,0,192,1,0,0,0,0,0,0,98,116,83,108,105,100,101,114,67,111,110,115,116,114,97,105,110,116,68,97,116,97,0,0,0,0,0,0,40,15,0,0,1,0,0,0,37,0,0,0,38,0,0,0,1,0,0,0,29,0,0,0,30,0,0,0,2,0,0,0,4,0,0,0,7,0,0,0,11,0,0,0,8,0,0,0,4,0,0,0,50,49,98,116,67,111,110,101,84,119,105,115,116,67,111,110,115,116,114,97,105,110,116,0,96,83,0,0,16,15,0,0,192,1,0,0,0,0,0,0,98,116,67,111,110,101,84,119,105,115,116,67,111,110,115,116,114,97,105,110,116,68,97,116,97,0,0,0,0,0,0,0,0,0,0,0,168,15,0,0,1,0,0,0,39,0,0,0,40,0,0,0,1,0,0,0,31,0,0,0,32,0,0,0,1,0,0,0,5,0,0,0,8,0,0,0,12,0,0,0,9,0,0,0,0,0,0,0,49,55,98,116,72,105,110,103,101,67,111,110,115,116,114,97,105,110,116,0,0,0,0,0,96,83,0,0,144,15,0,0,192,1,0,0,0,0,0,0,98,116,72,105,110,103,101,67,111,110,115,116,114,97,105,110,116,70,108,111,97,116,68,97,116,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,16,0,0,41,0,0,0,42,0,0,0,5,0,0,0,1,0,0,0,6,0,0,0,43,0,0,0,13,0,0,0,5,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,115,111,108,118,101,71,114,111,117,112,67,97,99,104,101,70,114,105,101,110,100,108,121,83,101,116,117,112,0,0,0,0,115,111,108,118,101,71,114,111,117,112,67,97,99,104,101,70,114,105,101,110,100,108,121,73,116,101,114,97,116,105,111,110,115,0,0,0,0,0,0,0,115,111,108,118,101,71,114,111,117,112,0,0,0,0,0,0,51,53,98,116,83,101,113,117,101,110,116,105,97,108,73,109,112,117,108,115,101,67,111,110,115,116,114,97,105,110,116,83,111,108,118,101,114,0,0,0,49,56,98,116,67,111,110,115,116,114,97,105,110,116,83,111,108,118,101,114,0,0,0,0,56,83,0,0,160,16,0,0,96,83,0,0,120,16,0,0,184,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,19,0,0,44,0,0,0,45,0,0,0,1,0,0,0,33,0,0,0,7,0,0,0,8,0,0,0,6,0,0,0,0,0,0,0,49,54,98,116,82,97,121,99,97,115,116,86,101,104,105,99,108,101,0,0,0,0,0,0,49,55,98,116,65,99,116,105,111,110,73,110,116,101,114,102,97,99,101,0,0,0,0,0,56,83,0,0,128,19,0,0,96,83,0,0,104,19,0,0,152,19,0,0,0,0,0,0,0,0,0,0,232,19,0,0,46,0,0,0,47,0,0,0,2,0,0,0,0,0,0,0,50,53,98,116,68,101,102,97,117,108,116,86,101,104,105,99,108,101,82,97,121,99,97,115,116,101,114,0,0,0,0,0,96,83,0,0,200,19,0,0,96,2,0,0,0,0,0,0,0,0,0,0,208,20,0,0,48,0,0,0,49,0,0,0,2,0,0,0,34,0,0,0,35,0,0,0,3,0,0,0,36,0,0,0,37,0,0,0,38,0,0,0,4,0,0,0,14,0,0,0,50,0,0,0,15,0,0,0,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,48,98,116,75,105,110,101,109,97,116,105,99,67,104,97,114,97,99,116,101,114,67,111,110,116,114,111,108,108,101,114,0,0,0,0,0,0,0,0,51,48,98,116,67,104,97,114,97,99,116,101,114,67,111,110,116,114,111,108,108,101,114,73,110,116,101,114,102,97,99,101,0,0,0,0,0,0,0,0,96,83,0,0,152,20,0,0,152,19,0,0,0,0,0,0,96,83,0,0,112,20,0,0,192,20,0,0,0,0,0,0,0,0,0,0,40,21,0,0,26,0,0,0,51,0,0,0,2,0,0,0,9,0,0,0,52,51,98,116,75,105,110,101,109,97,116,105,99,67,108,111,115,101,115,116,78,111,116,77,101,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,0,0,0,96,83,0,0,248,20,0,0,80,4,0,0,0,0,0,0,10,215,163,60,0,0,0,0,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,70,108,111,97,116,68,97,116,97,0,0,0,0,0,0,49,55,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,0,0,0,0,0,56,83,0,0,96,21,0,0,0,0,0,0,240,21,0,0,8,0,0,0,52,0,0,0,53,0,0,0,3,0,0,0,16,0,0,0,10,0,0,0,40,0,0,0,7,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,32,22,0,0,8,0,0,0,54,0,0,0,55,0,0,0,3,0,0,0,16,0,0,0,10,0,0,0,40,0,0,0,8,0,0,0,8,0,0,0,0,0,0,0,49,51,98,116,71,104,111,115,116,79,98,106,101,99,116,0,96,83,0,0,224,21,0,0,120,21,0,0,0,0,0,0,50,52,98,116,80,97,105,114,67,97,99,104,105,110,103,71,104,111,115,116,79,98,106,101,99,116,0,0,0,0,0,0,96,83,0,0,0,22,0,0,240,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,22,0,0,56,0,0,0,57,0,0,0,3,0,0,0,11,0,0,0,41,0,0,0,42,0,0,0,12,0,0,0,13,0,0,0,9,0,0,0,17,0,0,0,9,0,0,0,18,0,0,0,19,0,0,0,20,0,0,0,10,0,0,0,43,0,0,0,50,49,98,116,67,111,108,108,105,115,105,111,110,68,105,115,112,97,116,99,104,101,114,0,96,83,0,0,128,22,0,0,0,68,0,0,0,0,0,0,0,0,0,0,0,23,0,0,58,0,0,0,59,0,0,0,11,0,0,0,0,0,0,0,50,51,98,116,67,111,108,108,105,115,105,111,110,80,97,105,114,67,97,108,108,98,97,99,107,0,0,0,0,0,0,0,49,55,98,116,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,0,0,0,0,56,83,0,0,224,22,0,0,96,83,0,0,192,22,0,0,248,22,0,0,0,0,0,0,0,0,0,0,128,23,0,0,60,0,0,0,61,0,0,0,21,0,0,0,22,0,0,0,14,0,0,0,23,0,0,0,51,49,98,116,68,101,102,97,117,108,116,67,111,108,108,105,115,105,111,110,67,111,110,102,105,103,117,114,97,116,105,111,110,0,0,0,0,0,0,0,50,52,98,116,67,111,108,108,105,115,105,111,110,67,111,110,102,105,103,117,114,97,116,105,111,110,0,0,0,0,0,0,56,83,0,0,88,23,0,0,96,83,0,0,48,23,0,0,120,23,0,0,0,0,0,0,0,0,0,0,8,24,0,0,62,0,0,0,63,0,0,0,4,0,0,0,0,0,0,0,78,51,49,98,116,67,111,110,118,101,120,80,108,97,110,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,51,48,98,116,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,67,114,101,97,116,101,70,117,110,99,0,0,0,0,0,0,0,0,56,83,0,0,216,23,0,0,96,83,0,0,168,23,0,0,0,24,0,0,0,0,0,0,0,0,0,0,96,24,0,0,62,0,0,0,64,0,0,0,5,0,0,0,0,0,0,0,78,50,54,98,116,66,111,120,66,111,120,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,0,0,96,83,0,0,48,24,0,0,0,24,0,0,0,0,0,0,0,0,0,0,192,24,0,0,62,0,0,0,65,0,0,0,6,0,0,0,0,0,0,0,78,51,52,98,116,83,112,104,101,114,101,84,114,105,97,110,103,108,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,0,0,96,83,0,0,136,24,0,0,0,24,0,0,0,0,0,0,0,0,0,0,32,25,0,0,62,0,0,0,66,0,0,0,7,0,0,0,0,0,0,0,78,51,50,98,116,83,112,104,101,114,101,83,112,104,101,114,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,0,0,0,0,96,83,0,0,232,24,0,0,0,24,0,0,0,0,0,0,0,0,0,0,112,25,0,0,62,0,0,0,67,0,0,0,8,0,0,0,0,0,0,0,78,49,54,98,116,69,109,112,116,121,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,0,0,0,0,96,83,0,0,72,25,0,0,0,24,0,0,0,0,0,0,0,0,0,0,208,25,0,0,62,0,0,0,68,0,0,0,9,0,0,0,0,0,0,0,78,50,56,98,116,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,55,83,119,97,112,112,101,100,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,0,96,83,0,0,152,25,0,0,0,24,0,0,0,0,0,0,0,0,0,0,48,26,0,0,62,0,0,0,69,0,0,0,10,0,0,0,0,0,0,0,78,51,54,98,116,67,111,109,112,111,117,110,100,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,96,83,0,0,248,25,0,0,0,24,0,0,0,0,0,0,0,0,0,0,136,26,0,0,62,0,0,0,70,0,0,0,11,0,0,0,0,0,0,0,78,50,56,98,116,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,96,83,0,0,88,26,0,0,0,24,0,0,0,0,0,0,0,0,0,0,240,26,0,0,62,0,0,0,71,0,0,0,12,0,0,0,0,0,0,0,78,51,51,98,116,67,111,110,118,101,120,67,111,110,99,97,118,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,55,83,119,97,112,112,101,100,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,0,0,0,0,96,83,0,0,176,26,0,0,0,24,0,0,0,0,0,0,0,0,0,0,80,27,0,0,62,0,0,0,72,0,0,0,13,0,0,0,0,0,0,0,78,51,51,98,116,67,111,110,118,101,120,67,111,110,99,97,118,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,0,0,0,96,83,0,0,24,27,0,0,0,24,0,0,0,0,0,0,0,0,0,0,200,27,0,0,73,0,0,0,74,0,0,0,9,0,0,0,44,0,0,0,105,115,108,97,110,100,85,110,105,111,110,70,105,110,100,65,110,100,81,117,105,99,107,83,111,114,116,0,0,0,0,0,112,114,111,99,101,115,115,73,115,108,97,110,100,115,0,0,50,53,98,116,83,105,109,117,108,97,116,105,111,110,73,115,108,97,110,100,77,97,110,97,103,101,114,0,0,0,0,0,56,83,0,0,168,27,0,0,0,0,0,0,56,28,0,0,75,0,0,0,76,0,0,0,1,0,0,0,1,0,0,0,45,0,0,0,0,0,0,0,51,49,98,116,67,111,110,118,101,120,80,108,97,110,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,0,0,0,0,0,50,48,98,116,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,56,83,0,0,24,28,0,0,96,83,0,0,240,27,0,0,48,28,0,0,0,0,0,0,0,0,0,0,216,28,0,0,77,0,0,0,78,0,0,0,2,0,0,0,2,0,0,0,46,0,0,0,0,0,0,0,0,0,0,0,160,28,0,0,79,0,0,0,80,0,0,0,10,0,0,0,0,0,0,0,50,52,98,116,67,111,110,118,101,120,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,0,0,0,0,0,0,96,83,0,0,128,28,0,0,48,55,0,0,0,0,0,0,51,51,98,116,67,111,110,118,101,120,67,111,110,99,97,118,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,0,0,0,96,83,0,0,176,28,0,0,216,76,0,0,0,0,0,0,0,0,0,0,160,29,0,0,81,0,0,0,82,0,0,0,11,0,0,0,0,0,0,0,90,78,51,51,98,116,67,111,110,118,101,120,67,111,110,99,97,118,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,50,49,99,97,108,99,117,108,97,116,101,84,105,109,101,79,102,73,109,112,97,99,116,69,80,49,55,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,83,49,95,82,75,49,54,98,116,68,105,115,112,97,116,99,104,101,114,73,110,102,111,80,49,54,98,116,77,97,110,105,102,111,108,100,82,101,115,117,108,116,69,51,49,76,111,99,97,108,84,114,105,97,110,103,108,101,83,112,104,101,114,101,67,97,115,116,67,97,108,108,98,97,99,107,0,0,0,96,83,0,0,0,29,0,0,48,55,0,0,0,0,0,0,0,0,0,0,240,29,0,0,9,0,0,0,47,0,0,0,10,0,0,0,83,0,0,0,84,0,0,0,0,0,0,0,78,49,50,98,116,67,111,110,118,101,120,67,97,115,116,49,48,67,97,115,116,82,101,115,117,108,116,69,0,0,0,0,56,83,0,0,208,29,0,0,0,0,0,0,152,30,0,0,85,0,0,0,86,0,0,0,12,0,0,0,11,0,0,0,1,0,0,0,1,0,0,0,48,0,0,0,24,0,0,0,1,0,0,0,25,0,0,0,49,0,0,0,10,0,0,0,2,0,0,0,26,0,0,0,15,0,0,0,50,0,0,0,12,0,0,0,13,0,0,0,3,0,0,0,13,0,0,0,14,0,0,0,27,0,0,0,14,0,0,0,12,0,0,0,28,0,0,0,29,0,0,0,15,0,0,0,15,0,0,0,30,0,0,0,16,0,0,0,1,0,0,0,17,0,0,0,49,53,98,116,84,114,105,97,110,103,108,101,83,104,97,112,101,0,0,0,0,0,0,0,96,83,0,0,128,30,0,0,128,53,0,0,0,0,0,0,98,116,67,111,110,118,101,120,73,110,116,101,114,110,97,108,83,104,97,112,101,68,97,116,97,0,0,0,0,0,0,0,84,114,105,97,110,103,108,101,0,0,0,0,0,0,0,0,0,0,0,0,24,31,0,0,87,0,0,0,88,0,0,0,4,0,0,0,3,0,0,0,51,0,0,0,0,0,0,0,50,54,98,116,66,111,120,66,111,120,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,0,0,96,83,0,0,248,30,0,0,216,76,0,0,0,0,0,0,0,0,0,0,152,31,0,0,89,0,0,0,90,0,0,0,16,0,0,0,17,0,0,0,3,0,0,0,0,0,0,0,49,54,98,116,77,97,110,105,102,111,108,100,82,101,115,117,108,116,0,0,0,0,0,0,78,51,54,98,116,68,105,115,99,114,101,116,101,67,111,108,108,105,115,105,111,110,68,101,116,101,99,116,111,114,73,110,116,101,114,102,97,99,101,54,82,101,115,117,108,116,69,0,56,83,0,0,96,31,0,0,96,83,0,0,72,31,0,0,144,31,0,0,0,0,0,0,0,0,0,0,128,33,0,0,91,0,0,0,92,0,0,0,18,0,0,0,19,0,0,0,5,0,0,0,3,0,0,0,93,0,0,0,1,0,0,0,2,0,0,0,18,0,0,0,52,0,0,0,21,0,0,0,53,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,79,118,101,114,102,108,111,119,32,105,110,32,65,65,66,66,44,32,111,98,106,101,99,116,32,114,101,109,111,118,101,100,32,102,114,111,109,32,115,105,109,117,108,97,116,105,111,110,0,0,0,0,0,0,0,0,73,102,32,121,111,117,32,99,97,110,32,114,101,112,114,111,100,117,99,101,32,116,104,105,115,44,32,112,108,101,97,115,101,32,101,109,97,105,108,32,98,117,103,115,64,99,111,110,116,105,110,117,111,117,115,112,104,121,115,105,99,115,46,99,111,109,10,0,0,0,0,0,80,108,101,97,115,101,32,105,110,99,108,117,100,101,32,97,98,111,118,101,32,105,110,102,111,114,109,97,116,105,111,110,44,32,121,111,117,114,32,80,108,97,116,102,111,114,109,44,32,118,101,114,115,105,111,110,32,111,102,32,79,83,46,10,0,0,0,0,0,0,0,0,84,104,97,110,107,115,46,10,0,0,0,0,0,0,0,0,117,112,100,97,116,101,65,97,98,98,115,0,0,0,0,0,99,97,108,99,117,108,97,116,101,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,115,0,0,0,0,0,0,0,112,101,114,102,111,114,109,68,105,115,99,114,101,116,101,67,111,108,108,105,115,105,111,110,68,101,116,101,99,116,105,111,110,0,0,0,0,0,0,0,100,105,115,112,97,116,99,104,65,108,108,67,111,108,108,105,115,105,111,110,80,97,105,114,115,0,0,0,0,0,0,0,99,111,110,118,101,120,83,119,101,101,112,67,111,109,112,111,117,110,100,0,0,0,0,0,99,111,110,118,101,120,83,119,101,101,112,84,101,115,116,0,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,0,0,0,0,0,0,56,83,0,0,104,33,0,0,0,0,0,0,208,33,0,0,94,0,0,0,95,0,0,0,19,0,0,0,20,0,0,0,252,255,255,255,208,33,0,0,96,0,0,0,97,0,0,0,21,0,0,0,0,0,0,0,49,55,68,101,98,117,103,68,114,97,119,99,97,108,108,98,97,99,107,0,0,0,0,0,192,83,0,0,184,33,0,0,0,0,0,0,2,0,0,0,48,55,0,0,2,0,0,0,96,55,0,0,2,4,0,0,0,0,0,0,48,34,0,0,89,0,0,0,98,0,0,0,16,0,0,0,17,0,0,0,4,0,0,0,0,0,0,0,50,51,98,116,66,114,105,100,103,101,100,77,97,110,105,102,111,108,100,82,101,115,117,108,116,0,0,0,0,0,0,0,96,83,0,0,16,34,0,0,152,31,0,0,0,0,0,0,50,52,98,116,66,114,111,97,100,112,104,97,115,101,65,97,98,98,67,97,108,108,98,97,99,107,0,0,0,0,0,0,56,83,0,0,64,34,0,0,0,0,0,0,200,34,0,0,99,0,0,0,100,0,0,0,13,0,0,0,0,0,0,0,50,49,98,116,83,105,110,103,108,101,83,119,101,101,112,67,97,108,108,98,97,99,107,0,50,51,98,116,66,114,111,97,100,112,104,97,115,101,82,97,121,67,97,108,108,98,97,99,107,0,0,0,0,0,0,0,96,83,0,0,152,34,0,0,96,34,0,0,0,0,0,0,96,83,0,0,128,34,0,0,184,34,0,0,0,0,0,0,0,0,0,0,8,35,0,0,99,0,0,0,101,0,0,0,14,0,0,0,0,0,0,0,49,57,98,116,83,105,110,103,108,101,82,97,121,67,97,108,108,98,97,99,107,0,0,0,96,83,0,0,240,34,0,0,184,34,0,0,0,0,0,0,0,0,0,0,208,35,0,0,26,0,0,0,102,0,0,0,15,0,0,0,10,0,0,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,53,111,98,106,101,99,116,81,117,101,114,121,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,80,75,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,53,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,50,48,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,102,69,49,52,76,111,99,97,108,73,110,102,111,65,100,100,101,114,0,0,0,0,96,83,0,0,48,35,0,0,72,4,0,0,0,0,0,0,0,0,0,0,176,36,0,0,81,0,0,0,103,0,0,0,22,0,0,0,1,0,0,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,53,111,98,106,101,99,116,81,117,101,114,121,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,80,75,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,53,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,50,48,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,102,69,51,50,66,114,105,100,103,101,84,114,105,97,110,103,108,101,67,111,110,118,101,120,99,97,115,116,67,97,108,108,98,97,99,107,95,48,0,0,0,0,0,0,0,0,96,83,0,0,248,35,0,0,32,69,0,0,0,0,0,0,0,0,0,0,136,37,0,0,81,0,0,0,104,0,0,0,22,0,0,0,2,0,0,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,53,111,98,106,101,99,116,81,117,101,114,121,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,80,75,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,53,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,50,48,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,102,69,51,50,66,114,105,100,103,101,84,114,105,97,110,103,108,101,67,111,110,118,101,120,99,97,115,116,67,97,108,108,98,97,99,107,0,0,96,83,0,0,216,36,0,0,32,69,0,0,0,0,0,0,0,0,0,0,56,38,0,0,105,0,0,0,106,0,0,0,16,0,0,0,11,0,0,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,49,114,97,121,84,101,115,116,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,50,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,69,49,53,76,111,99,97,108,73,110,102,111,65,100,100,101,114,50,0,0,0,0,96,83,0,0,176,37,0,0,216,2,0,0,0,0,0,0,0,0,0,0,16,39,0,0,107,0,0,0,108,0,0,0,18,0,0,0,54,0,0,0,5,0,0,0,17,0,0,0,18,0,0,0,0,0,0,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,49,114,97,121,84,101,115,116,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,50,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,69,57,82,97,121,84,101,115,116,101,114,0,0,0,78,54,98,116,68,98,118,116,56,73,67,111,108,108,105,100,101,69,0,0,0,0,0,0,56,83,0,0,240,38,0,0,96,83,0,0,112,38,0,0,8,39,0,0,0,0,0,0,0,0,0,0,208,39,0,0,81,0,0,0,109,0,0,0,23,0,0,0,1,0,0,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,49,114,97,121,84,101,115,116,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,50,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,69,50,57,66,114,105,100,103,101,84,114,105,97,110,103,108,101,82,97,121,99,97,115,116,67,97,108,108,98,97,99,107,95,48,0,0,0,0,96,83,0,0,56,39,0,0,240,68,0,0,0,0,0,0,0,0,0,0,144,40,0,0,81,0,0,0,110,0,0,0,23,0,0,0,2,0,0,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE);allocate([111,114,108,100,50,49,114,97,121,84,101,115,116,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,50,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,69,50,57,66,114,105,100,103,101,84,114,105,97,110,103,108,101,82,97,121,99,97,115,116,67,97,108,108,98,97,99,107,0,0,0,0,0,0,96,83,0,0,248,39,0,0,240,68,0,0,0,0,0,0,0,0,0,0,232,40,0,0,111,0,0,0,112,0,0,0,5,0,0,0,4,0,0,0,55,0,0,0,0,0,0,0,51,52,98,116,83,112,104,101,114,101,84,114,105,97,110,103,108,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,0,0,96,83,0,0,192,40,0,0,216,76,0,0,0,0,0,0,0,0,0,0,88,41,0,0,113,0,0,0,114,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,136,41,0,0,115,0,0,0,116,0,0,0,6,0,0,0,5,0,0,0,56,0,0,0,0,0,0,0,78,50,51,98,116,67,111,110,118,101,120,67,111,110,118,101,120,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,96,83,0,0,48,41,0,0,0,24,0,0,0,0,0,0,50,51,98,116,67,111,110,118,101,120,67,111,110,118,101,120,65,108,103,111,114,105,116,104,109,0,0,0,0,0,0,0,96,83,0,0,104,41,0,0,216,76,0,0,0,0,0,0,0,0,0,0,72,42,0,0,89,0,0,0,117,0,0,0,19,0,0,0,20,0,0,0,5,0,0,0,0,0,0,0,90,78,50,51,98,116,67,111,110,118,101,120,67,111,110,118,101,120,65,108,103,111,114,105,116,104,109,49,54,112,114,111,99,101,115,115,67,111,108,108,105,115,105,111,110,69,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,83,50,95,82,75,49,54,98,116,68,105,115,112,97,116,99,104,101,114,73,110,102,111,80,49,54,98,116,77,97,110,105,102,111,108,100,82,101,115,117,108,116,69,50,49,98,116,87,105,116,104,111,117,116,77,97,114,103,105,110,82,101,115,117,108,116,0,0,0,0,96,83,0,0,184,41,0,0,144,31,0,0,0,0,0,0,0,0,0,0,152,42,0,0,89,0,0,0,118,0,0,0,16,0,0,0,17,0,0,0,6,0,0,0,0,0,0,0,50,52,98,116,80,101,114,116,117,114,98,101,100,67,111,110,116,97,99,116,82,101,115,117,108,116,0,0,0,0,0,0,96,83,0,0,120,42,0,0,152,31,0,0,0,0,0,0,0,0,0,0,80,43,0,0,89,0,0,0,119,0,0,0,21,0,0,0,22,0,0,0,7,0,0,0,0,0,0,0,90,78,50,51,98,116,67,111,110,118,101,120,67,111,110,118,101,120,65,108,103,111,114,105,116,104,109,49,54,112,114,111,99,101,115,115,67,111,108,108,105,115,105,111,110,69,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,83,50,95,82,75,49,54,98,116,68,105,115,112,97,116,99,104,101,114,73,110,102,111,80,49,54,98,116,77,97,110,105,102,111,108,100,82,101,115,117,108,116,69,49,51,98,116,68,117,109,109,121,82,101,115,117,108,116,0,0,0,0,96,83,0,0,200,42,0,0,144,31,0,0,0,0,0,0,0,0,0,0,160,43,0,0,120,0,0,0,121,0,0,0,7,0,0,0,6,0,0,0,57,0,0,0,0,0,0,0,50,56,98,116,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,96,83,0,0,128,43,0,0,216,76,0,0,0,0,0,0,0,0,0,0,248,43,0,0,107,0,0,0,122,0,0,0,18,0,0,0,58,0,0,0,5,0,0,0,17,0,0,0,18,0,0,0,0,0,0,0,50,50,98,116,67,111,109,112,111,117,110,100,76,101,97,102,67,97,108,108,98,97,99,107,0,0,0,0,0,0,0,0,96,83,0,0,216,43,0,0,8,39,0,0,0,0,0,0,0,0,0,0,80,44,0,0,123,0,0,0,124,0,0,0,8,0,0,0,7,0,0,0,59,0,0,0,0,0,0,0,51,54,98,116,67,111,109,112,111,117,110,100,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,96,83,0,0,40,44,0,0,216,76,0,0,0,0,0,0,0,0,0,0,176,44,0,0,107,0,0,0,125,0,0,0,23,0,0,0,60,0,0,0,5,0,0,0,17,0,0,0,18,0,0,0,0,0,0,0,51,48,98,116,67,111,109,112,111,117,110,100,67,111,109,112,111,117,110,100,76,101,97,102,67,97,108,108,98,97,99,107,0,0,0,0,0,0,0,0,96,83,0,0,136,44,0,0,8,39,0,0,0,0,0,0,0,0,0,0,96,45,0,0,126,0,0,0,127,0,0,0,24,0,0,0,11,0,0,0,1,0,0,0,1,0,0,0,61,0,0,0,31,0,0,0,2,0,0,0,32,0,0,0,49,0,0,0,11,0,0,0,3,0,0,0,33,0,0,0,16,0,0,0,50,0,0,0,62,0,0,0,128,0,0,0,98,116,67,111,109,112,111,117,110,100,83,104,97,112,101,67,104,105,108,100,68,97,116,97,0,0,0,0,0,0,0,0,98,116,67,111,109,112,111,117,110,100,83,104,97,112,101,68,97,116,97,0,0,0,0,0,49,53,98,116,67,111,109,112,111,117,110,100,83,104,97,112,101,0,0,0,0,0,0,0,96,83,0,0,72,45,0,0,248,53,0,0,0,0,0,0,67,111,109,112,111,117,110,100,0,0,0,0,0,0,0,0,0,0,0,0,200,46,0,0,129,0,0,0,130,0,0,0,25,0,0,0,11,0,0,0,1,0,0,0,1,0,0,0,63,0,0,0,24,0,0,0,3,0,0,0,34,0,0,0,64,0,0,0,10,0,0,0,2,0,0,0,35,0,0,0,17,0,0,0,50,0,0,0,24,0,0,0,25,0,0,0,3,0,0,0,26,0,0,0,14,0,0,0,36,0,0,0,26,0,0,0,0,0,0,0,0,0,0,0,232,46,0,0,129,0,0,0,131,0,0,0,25,0,0,0,11,0,0,0,1,0,0,0,1,0,0,0,63,0,0,0,24,0,0,0,3,0,0,0,37,0,0,0,65,0,0,0,10,0,0,0,2,0,0,0,35,0,0,0,17,0,0,0,50,0,0,0,24,0,0,0,25,0,0,0,3,0,0,0,26,0,0,0,14,0,0,0,36,0,0,0,26,0,0,0,0,0,0,0,0,0,0,0,8,47,0,0,129,0,0,0,132,0,0,0,25,0,0,0,11,0,0,0,1,0,0,0,1,0,0,0,63,0,0,0,24,0,0,0,3,0,0,0,38,0,0,0,66,0,0,0,10,0,0,0,2,0,0,0,35,0,0,0,17,0,0,0,50,0,0,0,24,0,0,0,25,0,0,0,3,0,0,0,26,0,0,0,14,0,0,0,36,0,0,0,26,0,0,0,0,0,0,0,49,49,98,116,67,111,110,101,83,104,97,112,101,0,0,0,96,83,0,0,184,46,0,0,56,54,0,0,0,0,0,0,49,50,98,116,67,111,110,101,83,104,97,112,101,90,0,0,96,83,0,0,216,46,0,0,200,46,0,0,0,0,0,0,49,50,98,116,67,111,110,101,83,104,97,112,101,88,0,0,96,83,0,0,248,46,0,0,200,46,0,0,0,0,0,0,67,111,110,101,88,0,0,0,67,111,110,101,90,0,0,0,98,116,67,111,110,101,83,104,97,112,101,68,97,116,97,0,67,111,110,101,0,0,0,0,0,0,0,0,184,47,0,0,129,0,0,0,133,0,0,0,27,0,0,0,11,0,0,0,1,0,0,0,1,0,0,0,48,0,0,0,24,0,0,0,4,0,0,0,39,0,0,0,49,0,0,0,12,0,0,0,4,0,0,0,26,0,0,0,15,0,0,0,50,0,0,0,27,0,0,0,28,0,0,0,3,0,0,0,28,0,0,0,14,0,0,0,36,0,0,0,26,0,0,0,0,0,0,0,49,51,98,116,83,112,104,101,114,101,83,104,97,112,101,0,96,83,0,0,168,47,0,0,56,54,0,0,0,0,0,0,83,80,72,69,82,69,0,0,0,0,0,0,104,48,0,0,134,0,0,0,135,0,0,0,29,0,0,0,11,0,0,0,1,0,0,0,1,0,0,0,67,0,0,0,40,0,0,0,5,0,0,0,41,0,0,0,49,0,0,0,13,0,0,0,5,0,0,0,42,0,0,0,18,0,0,0,50,0,0,0,30,0,0,0,29,0,0,0,30,0,0,0,68,0,0,0,69,0,0,0,0,0,0,0,98,116,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,68,97,116,97,0,50,50,98,116,66,118,104,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,0,0,0,0,0,0,0,0,96,83,0,0,72,48,0,0,224,50,0,0,0,0,0,0,66,86,72,84,82,73,65,78,71,76,69,77,69,83,72,0,0,0,0,0,48,49,0,0,136,0,0,0,137,0,0,0,31,0,0,0,0,0,0,0,90,78,75,50,50,98,116,66,118,104,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,49,57,112,114,111,99,101,115,115,65,108,108,84,114,105,97,110,103,108,101,115,69,80,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,50,49,77,121,78,111,100,101,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,0,0,50,49,98,116,78,111,100,101,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,56,83,0,0,16,49,0,0,96,83,0,0,160,48,0,0,40,49,0,0,0,0,0,0,0,0,0,0,208,49,0,0,136,0,0,0,138,0,0,0,32,0,0,0,0,0,0,0,90,78,50,50,98,116,66,118,104,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,49,55,112,101,114,102,111,114,109,67,111,110,118,101,120,99,97,115,116,69,80,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,83,52,95,83,52,95,69,50,49,77,121,78,111,100,101,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,0,0,0,0,0,0,0,96,83,0,0,88,49,0,0,40,49,0,0,0,0,0,0,0,0,0,0,96,50,0,0,136,0,0,0,139,0,0,0,33,0,0,0,0,0,0,0,90,78,50,50,98,116,66,118,104,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,49,52,112,101,114,102,111,114,109,82,97,121,99,97,115,116,69,80,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,50,49,77,121,78,111,100,101,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,96,83,0,0,248,49,0,0,40,49,0,0,0,0,0,0,0,0,0,0,224,50,0,0,140,0,0,0,141,0,0,0,29,0,0,0,11,0,0,0,1,0,0,0,1,0,0,0,70,0,0,0,40,0,0,0,5,0,0,0,43,0,0,0,49,0,0,0,13,0,0,0,5,0,0,0,44,0,0,0,19,0,0,0,50,0,0,0,31,0,0,0,29,0,0,0,30,0,0,0,0,0,0,0,49,57,98,116,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,0,0,0,96,83,0,0,200,50,0,0,136,58,0,0,0,0,0,0,84,82,73,65,78,71,76,69,77,69,83,72,0,0,0,0,0,0,0,0,48,51,0,0,81,0,0,0,142,0,0,0,32,0,0,0,0,0,0,0,50,49,83,117,112,112,111,114,116,86,101,114,116,101,120,67,97,108,108,98,97,99,107,0,96,83,0,0,24,51,0,0,48,55,0,0,0,0,0,0,0,0,0,0,192,51,0,0,143,0,0,0,144,0,0,0,33,0,0,0,0,0,0,0,90,78,75,49,57,98,116,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,49,57,112,114,111,99,101,115,115,65,108,108,84,114,105,97,110,103,108,101,115,69,80,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,49,54,70,105,108,116,101,114,101,100,67,97,108,108,98,97,99,107,0,0,0,96,83,0,0,88,51,0,0,96,55,0,0,0,0,0,0,0,0,0,0,56,52,0,0,145,0,0,0,146,0,0,0,34,0,0,0,11,0,0,0,1,0,0,0,1,0,0,0,71,0,0,0,45,0,0,0,6,0,0,0,46,0,0,0,49,0,0,0,13,0,0,0,5,0,0,0,47,0,0,0,20,0,0,0,50,0,0,0,35,0,0,0,0,0,0,0,49,56,98,116,83,116,97,116,105,99,80,108,97,110,101,83,104,97,112,101,0,0,0,0,96,83,0,0,32,52,0,0,136,58,0,0,0,0,0,0,98,116,83,116,97,116,105,99,80,108,97,110,101,83,104,97,112,101,68,97,116,97,0,0,83,84,65,84,73,67,80,76,65,78,69,0,0,0,0,0,0,0,0,0,128,53,0,0,85,0,0,0,147,0,0,0,25,0,0,0,11,0,0,0,1,0,0,0,1,0,0,0,48,0,0,0,24,0,0,0,7,0,0,0,1,0,0,0,49,0,0,0,10,0,0,0,2,0,0,0,26,0,0,0,15,0,0,0,50,0,0,0,12,0,0,0,34,0,0,0,3,0,0,0,36,0,0,0,14,0,0,0,36,0,0,0,26,0,0,0,12,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,51,98,116,80,111,108,121,104,101,100,114,97,108,67,111,110,118,101,120,83,104,97,112,101,0,0,0,0,0,0,0,96,83,0,0,96,53,0,0,56,54,0,0,0,0,0,0,51,52,98,116,80,111,108,121,104,101,100,114,97,108,67,111,110,118,101,120,65,97,98,98,67,97,99,104,105,110,103,83,104,97,112,101,0,0,0,0,96,83,0,0,144,53,0,0,128,53,0,0,0,0,0,0,98,116,67,111,108,108,105,115,105,111,110,83,104,97,112,101,68,97,116,97,0,0,0,0,49,54,98,116,67,111,108,108,105,115,105,111,110,83,104,97,112,101,0,0,0,0,0,0,56,83,0,0,224,53,0,0,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,0,96,83,0,0,0,54,0,0,248,53,0,0,0,0,0,0,50,49,98,116,67,111,110,118,101,120,73,110,116,101,114,110,97,108,83,104,97,112,101,0,96,83,0,0,32,54,0,0,16,54,0,0,0,0,0,0,0,0,0,0,0,55,0,0,148,0,0,0,149,0,0,0,37,0,0,0,11,0,0,0,1,0,0,0,1,0,0,0,72,0,0,0,24,0,0,0,7,0,0,0,48,0,0,0,49,0,0,0,10,0,0,0,2,0,0,0,49,0,0,0,21,0,0,0,50,0,0,0,35,0,0,0,36,0,0,0,3,0,0,0,38,0,0,0,14,0,0,0,36,0,0,0,26,0,0,0,12,0,0,0,50,0,0,0,51,0,0,0,39,0,0,0,37,0,0,0,52,0,0,0,40,0,0,0,2,0,0,0,1,0,0,0,98,116,67,111,110,118,101,120,72,117,108,108,83,104,97,112,101,68,97,116,97,0,0,0,49,55,98,116,67,111,110,118,101,120,72,117,108,108,83,104,97,112,101,0,0,0,0,0,96,83,0,0,232,54,0,0,184,53,0,0,0,0,0,0,67,111,110,118,101,120,0,0,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,0,0,0,0,56,83,0,0,24,55,0,0,51,49,98,116,73,110,116,101,114,110,97,108,84,114,105,97,110,103,108,101,73,110,100,101,120,67,97,108,108,98,97,99,107,0,0,0,0,0,0,0,56,83,0,0,56,55,0,0,0,0,0,0,184,56,0,0,129,0,0,0,150,0,0,0,41,0,0,0,11,0,0,0,1,0,0,0,1,0,0,0,73,0,0,0,24,0,0,0,8,0,0,0,53,0,0,0,74,0,0,0,14,0,0,0,2,0,0,0,54,0,0,0,22,0,0,0,50,0,0,0,12,0,0,0,38,0,0,0,3,0,0,0,42,0,0,0,14,0,0,0,36,0,0,0,26,0,0,0,0,0,0,0,0,0,0,0,224,56,0,0,129,0,0,0,151,0,0,0,41,0,0,0,11,0,0,0,1,0,0,0,1,0,0,0,73,0,0,0,24,0,0,0,8,0,0,0,55,0,0,0,74,0,0,0,14,0,0,0,2,0,0,0,54,0,0,0,22,0,0,0,50,0,0,0,12,0,0,0,38,0,0,0,3,0,0,0,42,0,0,0,14,0,0,0,36,0,0,0,26,0,0,0,0,0,0,0,0,0,0,0,8,57,0,0,129,0,0,0,152,0,0,0,41,0,0,0,11,0,0,0,1,0,0,0,1,0,0,0,73,0,0,0,24,0,0,0,8,0,0,0,56,0,0,0,74,0,0,0,14,0,0,0,2,0,0,0,54,0,0,0,22,0,0,0,50,0,0,0,12,0,0,0,38,0,0,0,3,0,0,0,42,0,0,0,14,0,0,0,36,0,0,0,26,0,0,0,0,0,0,0,49,52,98,116,67,97,112,115,117,108,101,83,104,97,112,101,0,0,0,0,0,0,0,0,96,83,0,0,160,56,0,0,56,54,0,0,0,0,0,0,49,53,98,116,67,97,112,115,117,108,101,83,104,97,112,101,88,0,0,0,0,0,0,0,96,83,0,0,200,56,0,0,184,56,0,0,0,0,0,0,49,53,98,116,67,97,112,115,117,108,101,83,104,97,112,101,90,0,0,0,0,0,0,0,96,83,0,0,240,56,0,0,184,56,0,0,0,0,0,0,67,97,112,115,117,108,101,90,0,0,0,0,0,0,0,0,67,97,112,115,117,108,101,88,0,0,0,0,0,0,0,0,98,116,67,97,112,115,117,108,101,83,104,97,112,101,68,97,116,97,0,0,0,0,0,0,67,97,112,115,117,108,101,83,104,97,112,101,0,0,0,0,0,0,0,0,8,58,0,0,85,0,0,0,153,0,0,0,37,0,0,0,11,0,0,0,1,0,0,0,1,0,0,0,75,0,0,0,57,0,0,0,7,0,0,0,58,0,0,0,49,0,0,0,10,0,0,0,2,0,0,0,26,0,0,0,15,0,0,0,50,0,0,0,39,0,0,0,40,0,0,0,3,0,0,0,43,0,0,0,14,0,0,0,36,0,0,0,26,0,0,0,12,0,0,0,59,0,0,0,60,0,0,0,44,0,0,0,41,0,0,0,61,0,0,0,45,0,0,0,3,0,0,0,0,0,0,0,50,53,98,116,67,111,110,118,101,120,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,0,0,0,0,0,96,83,0,0,232,57,0,0,184,53,0,0,0,0,0,0,67,111,110,118,101,120,84,114,105,109,101,115,104,0,0,0,0,0,0,0,96,58,0,0,143,0,0,0,154,0,0,0,46,0,0,0,0,0,0,0,50,54,76,111,99,97,108,83,117,112,112,111,114,116,86,101,114,116,101,120,67,97,108,108,98,97,99,107,0,0,0,0,96,83,0,0,64,58,0,0,96,55,0,0,0,0,0,0,49,52,98,116,67,111,110,99,97,118,101,83,104,97,112,101,0,0,0,0,0,0,0,0,96,83,0,0,112,58,0,0,248,53,0,0,0,0,0,0,0,0,0,0,48,59,0,0,85,0,0,0,155,0,0,0,47,0,0,0,11,0,0,0,1,0,0,0,1,0,0,0,76,0,0,0,24,0,0,0,9,0,0,0,62,0,0,0,49,0,0,0,15,0,0,0,2,0,0,0,26,0,0,0,15,0,0,0,50,0,0,0,42,0,0,0,43,0,0,0,3,0,0,0,48,0,0,0,14,0,0,0,63,0,0,0,44,0,0,0,12,0,0,0,64,0,0,0,65,0,0,0,49,0,0,0,45,0,0,0,66,0,0,0,50,0,0,0,4,0,0,0,46,0,0,0,49,48,98,116,66,111,120,83,104,97,112,101,0,0,0,0,96,83,0,0,32,59,0,0,128,53,0,0,0,0,0,0,66,111,120,0,0,0,0,0,0,0,0,0,136,59,0,0,156,0,0,0,157,0,0,0,15,0,0,0,67,0,0,0,23,0,0,0,77,0,0,0,78,0,0,0,16,0,0,0,49,52,98,116,79,112,116,105,109,105,122,101,100,66,118,104,0,0,0,0,0,0,0,0,96,83,0,0,112,59,0,0,176,68,0,0,0,0,0,0,0,0,0,0,24,60,0,0,143,0,0,0,158,0,0,0,51,0,0,0,0,0,0,0,90,78,49,52,98,116,79,112,116,105,109,105,122,101,100,66,118,104,53,98,117,105,108,100,69,80,50,51,98,116,83,116,114,105,100,105,110,103,77,101,115,104,73,110,116,101,114,102,97,99,101,98,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,50,57,81,117,97,110,116,105,122,101,100,78,111,100,101,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,0,0,0,0,0,96,83,0,0,176,59,0,0,96,55,0,0,0,0,0,0,0,0,0,0,160,60,0,0,143,0,0,0,159,0,0,0,52,0,0,0,0,0,0,0,90,78,49,52,98,116,79,112,116,105,109,105,122,101,100,66,118,104,53,98,117,105,108,100,69,80,50,51,98,116,83,116,114,105,100,105,110,103,77,101,115,104,73,110,116,101,114,102,97,99,101,98,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,50,48,78,111,100,101,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,0,0,0,0,0,0,96,83,0,0,64,60,0,0,96,55,0,0,0,0,0,0,0,0,0,0,0,62,0,0,129,0,0,0,160,0,0,0,53,0,0,0,11,0,0,0,1,0,0,0,1,0,0,0,79,0,0,0,24,0,0,0,10,0,0,0,68,0,0,0,80,0,0,0,16,0,0,0,2,0,0,0,69,0,0,0,24,0,0,0,50,0,0,0,47,0,0,0,48,0,0,0,3,0,0,0,54,0,0,0,14,0,0,0,36,0,0,0,26,0,0,0,6,0,0,0,0,0,0,0,40,62,0,0,129,0,0,0,161,0,0,0,53,0,0,0,11,0,0,0,1,0,0,0,1,0,0,0,79,0,0,0,24,0,0,0,10,0,0,0,70,0,0,0,80,0,0,0,16,0,0,0,2,0,0,0,69,0,0,0,24,0,0,0,50,0,0,0,47,0,0,0,49,0,0,0,3,0,0,0,55,0,0,0,14,0,0,0,36,0,0,0,26,0,0,0,7,0,0,0,0,0,0,0,80,62,0,0,129,0,0,0,162,0,0,0,53,0,0,0,11,0,0,0,1,0,0,0,1,0,0,0,79,0,0,0,24,0,0,0,10,0,0,0,71,0,0,0,80,0,0,0,16,0,0,0,2,0,0,0,69,0,0,0,24,0,0,0,50,0,0,0,47,0,0,0,50,0,0,0,3,0,0,0,56,0,0,0,14,0,0,0,36,0,0,0,26,0,0,0,8,0,0,0,49,53,98,116,67,121,108,105,110,100,101,114,83,104,97,112,101,0,0,0,0,0,0,0,96,83,0,0,232,61,0,0,56,54,0,0,0,0,0,0,49,54,98,116,67,121,108,105,110,100,101,114,83,104,97,112,101,88,0,0,0,0,0,0,96,83,0,0,16,62,0,0,0,62,0,0,0,0,0,0,49,54,98,116,67,121,108,105,110,100,101,114,83,104,97,112,101,90,0,0,0,0,0,0,96,83,0,0,56,62,0,0,0,62,0,0,0,0,0,0,67,121,108,105,110,100,101,114,90,0,0,0,0,0,0,0,67,121,108,105,110,100,101,114,88,0,0,0,0,0,0,0,98,116,67,121,108,105,110,100,101,114,83,104,97,112,101,68,97,116,97,0,0,0,0,0,67,121,108,105,110,100,101,114,89,0,0,0,0,0,0,0,0,0,0,0,8,63,0,0,163,0,0,0,164,0,0,0,57,0,0,0,1,0,0,0,2,0,0,0,81,0,0,0,82,0,0,0,72,0,0,0,83,0,0,0,84,0,0,0,73,0,0,0,51,0,0,0,52,0,0,0,74,0,0,0,25,0,0,0,0,0,0,0,49,52,98,116,84,114,105,97,110,103,108,101,77,101,115,104,0,0,0,0,0,0,0,0,96,83,0,0,240,62,0,0,8,79,0,0,0,0,0,0,0,0,0,0,184,63,0,0,165,0,0,0,166,0,0,0,1,0,0,0,53,0,0,0,9,0,0,0,58,0,0,0,2,0,0,0,59,0,0,0,85,0,0,0,75,0,0,0,76,0,0,0,54,0,0,0,86,0,0,0,167,0,0,0,49,50,98,116,65,120,105,115,83,119,101,101,112,51,0,0,50,48,98,116,65,120,105,115,83,119,101,101,112,51,73,110,116,101,114,110,97,108,73,116,69,0,0,0,0,0,0,0,50,49,98,116,66,114,111,97,100,112,104,97,115,101,73,110,116,101,114,102,97,99,101,0,56,83,0,0,136,63,0,0,96,83,0,0,104,63,0,0,160,63,0,0,0,0,0,0,96,83,0,0,88,63,0,0,168,63,0,0,0,0,0,0,0,0,0,0,168,63,0,0,165,0,0,0,168,0,0,0,1,0,0,0,53,0,0,0,9,0,0,0,58,0,0,0,2,0,0,0,59,0,0,0,85,0,0,0,75,0,0,0,76,0,0,0,54,0,0,0,86,0,0,0,167,0,0,0,0,0,0,0,160,64,0,0,169,0,0,0,170,0,0,0,26,0,0,0,17,0,0,0,55,0,0,0,77,0,0,0,78,0,0,0,79,0,0,0,56,0,0,0,80,0,0,0,57,0,0,0,87,0,0,0,58,0,0,0,27,0,0,0,81,0,0,0,88,0,0,0,89,0,0,0,0,0,0,0,49,53,98,116,78,117,108,108,80,97,105,114,67,97,99,104,101,0,0,0,0,0,0,0,50,50,98,116,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,99,104,101,0,0,0,0,0,0,0,0,96,83,0,0,112,64,0,0,48,2,0,0,0,0,0,0,96,83,0,0,88,64,0,0,144,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,65,0,0,171,0,0,0,172,0,0,0,28,0,0,0,18,0,0,0,59,0,0,0,82,0,0,0,83,0,0,0,84,0,0,0,60,0,0,0,85,0,0,0,61,0,0,0,90,0,0,0,62,0,0,0,29,0,0,0,86,0,0,0,91,0,0,0,92,0,0,0,0,0,0,0,50,56,98,116,72,97,115,104,101,100,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,99,104,101,0,0,96,83,0,0,32,65,0,0,144,64,0,0,0,0,0,0,0,0,0,0,240,65,0,0,58,0,0,0,173,0,0,0,19,0,0,0,0,0,0,0,90,78,50,56,98,116,72,97,115,104,101,100,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,99,104,101,51,55,114,101,109,111,118,101,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,115,67,111,110,116,97,105,110,105,110,103,80,114,111,120,121,69,80,49,55,98,116,66,114,111,97,100,112,104,97,115,101,80,114,111,120,121,80,49,50,98,116,68,105,115,112,97,116,99,104,101,114,69,49,56,82,101,109,111,118,101,80,97,105,114,67,97,108,108,98,97,99,107,0,0,0,0,0,0,0,0,96,83,0,0,104,65,0,0,248,22,0,0,0,0,0,0,0,0,0,0,136,66,0,0,58,0,0,0,174,0,0,0,20,0,0,0,0,0,0,0,90,78,50,56,98,116,72,97,115,104,101,100,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,99,104,101,49,57,99,108,101,97,110,80,114,111,120,121,70,114,111,109,80,97,105,114,115,69,80,49,55,98,116,66,114,111,97,100,112,104,97,115,101,80,114,111,120,121,80,49,50,98,116,68,105,115,112,97,116,99,104,101,114,69,49,55,67,108,101,97,110,80,97,105,114,67,97,108,108,98,97,99,107,0,0,0,96,83,0,0,24,66,0,0,248,22,0,0,0,0,0,0,0,0,0,0,240,66,0,0,175,0,0,0,176,0,0,0,2,0,0,0,63,0,0,0,10,0,0,0,60,0,0,0,3,0,0,0,61,0,0,0,93,0,0,0,87,0,0,0,88,0,0,0,64,0,0,0,94,0,0,0,177,0,0,0,49,54,98,116,68,98,118,116,66,114,111,97,100,112,104,97,115,101,0,0,0,0,0,0,96,83,0,0,216,66,0,0,160,63,0,0,0,0,0,0,0,0,0,0,64,67,0,0,107,0,0,0,178,0,0,0,18,0,0,0,95,0,0,0,5,0,0,0,17,0,0,0,18,0,0,0,0,0,0,0,50,48,66,114,111,97,100,112,104,97,115,101,65,97,98,98,84,101,115,116,101,114,0,0,96,83,0,0,40,67,0,0,8,39,0,0,0,0,0,0,0,0,0,0,144,67,0,0,107,0,0,0,179,0,0,0,18,0,0,0,96,0,0,0,5,0,0,0,17,0,0,0,18,0,0,0,0,0,0,0,49,57,66,114,111,97,100,112,104,97,115,101,82,97,121,84,101,115,116,101,114,0,0,0,96,83,0,0,120,67,0,0,8,39,0,0,0,0,0,0,0,0,0,0,224,67,0,0,107,0,0,0,180,0,0,0,65,0,0,0,97,0,0,0,5,0,0,0,17,0,0,0,18,0,0,0,0,0,0,0,49,56,98,116,68,98,118,116,84,114,101,101,67,111,108,108,105,100,101,114,0,0,0,0,96,83,0,0,200,67,0,0,8,39,0,0,0,0,0,0,49,50,98,116,68,105,115,112,97,116,99,104,101,114,0,0,56,83,0,0,240,67,0,0,0,0,0,0,176,68,0,0,181,0,0,0,182,0,0,0,15,0,0,0,67,0,0,0,23,0,0,0,77,0,0,0,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,116,79,112,116,105,109,105,122,101,100,66,118,104,78,111,100,101,68,97,116,97,0,0,98,116,81,117,97,110,116,105,122,101,100,66,118,104,78,111,100,101,68,97,116,97,0,0,98,116,66,118,104,83,117,98,116,114,101,101,73,110,102,111,68,97,116,97,0,0,0,0,98,116,81,117,97,110,116,105,122,101,100,66,118,104,70,108,111,97,116,68,97,116,97,0,49,52,98,116,81,117,97,110,116,105,122,101,100,66,118,104,0,0,0,0,0,0,0,0,56,83,0,0,152,68,0,0,0,0,0,0,32,69,0,0,81,0,0,0,183,0,0,0,22,0,0,0,1,0,0,0,50,53,98,116,84,114,105,97,110,103,108,101,82,97,121,99,97,115,116,67,97,108,108,98,97,99,107,0,0,0,0,0,96,83,0,0,208,68,0,0,48,55,0,0,0,0,0,0,50,56,98,116,84,114,105,97,110,103,108,101,67,111,110,118,101,120,99,97,115,116,67,97,108,108,98,97,99,107,0,0,96,83,0,0,0,69,0,0,48,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,73,0,0,184,0,0,0,185,0,0,0,1,0,0,0,0,0,0,0,51,51,98,116,77,105,110,107,111,119,115,107,105,80,101,110,101,116,114,97,116,105,111,110,68,101,112,116,104,83,111,108,118,101,114,0,0,0,0,0,51,48,98,116,67,111,110,118,101,120,80,101,110,101,116,114,97,116,105,111,110,68,101,112,116,104,83,111,108,118,101,114,0,0,0,0,0,0,0,0,56,83,0,0,88,73,0,0,96,83,0,0,48,73,0,0,128,73,0,0,0,0,0,0,0,0,0,0,104,74,0,0,89,0,0,0,186,0,0,0,66,0,0,0,67,0,0,0,8,0,0,0,0,0,0,0,90,78,51,51,98,116,77,105,110,107,111,119,115,107,105,80,101,110,101,116,114,97,116,105,111,110,68,101,112,116,104,83,111,108,118,101,114,49,50,99,97,108,99,80,101,110,68,101,112,116,104,69,82,50,50,98,116,86,111,114,111,110,111,105,83,105,109,112,108,101,120,83,111,108,118,101,114,80,75,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,83,52,95,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,55,95,82,57,98,116,86,101,99,116,111,114,51,83,57,95,83,57,95,80,49,50,98,116,73,68,101,98,117,103,68,114,97,119,69,50,48,98,116,73,110,116,101,114,109,101,100,105,97,116,101,82,101,115,117,108,116,0,0,0,0,0,0,96,83,0,0,184,73,0,0,144,31,0,0,0,0,0,0,0,0,0,0,176,74,0,0,187,0,0,0,188,0,0,0,1,0,0,0,0,0,0,0,50,50,98,116,83,117,98,115,105,109,112,108,101,120,67,111,110,118,101,120,67,97,115,116,0,0,0,0,0,0,0,0,96,83,0,0,144,74,0,0,168,75,0,0,0,0,0,0,0,0,0,0,0,75,0,0,184,0,0,0,189,0,0,0,2,0,0,0,0,0,0,0,51,48,98,116,71,106,107,69,112,97,80,101,110,101,116,114,97,116,105,111,110,68,101,112,116,104,83,111,108,118,101,114,0,0,0,0,0,0,0,0,96,83,0,0,216,74,0,0,128,73,0,0,0,0,0,0,0,0,0,0,64,75,0,0,187,0,0,0,190,0,0,0,2,0,0,0,0,0,0,0,49,53,98,116,71,106,107,67,111,110,118,101,120,67,97,115,116,0,0,0,0,0,0,0,96,83,0,0,40,75,0,0,168,75,0,0,0,0,0,0,0,0,0,0,136,75,0,0,89,0,0,0,191,0,0,0,68,0,0,0,69,0,0,0,9,0,0,0,0,0,0,0,49,54,98,116,80,111,105,110,116,67,111,108,108,101,99,116,111,114,0,0,0,0,0,0,96,83,0,0,112,75,0,0,144,31,0,0,0,0,0,0,49,50,98,116,67,111,110,118,101,120,67,97,115,116,0,0,56,83,0,0,152,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,0,0,187,0,0,0,192,0,0,0,3,0,0,0,0,0,0,0,50,55,98,116,67,111,110,116,105,110,117,111,117,115,67,111,110,118,101,120,67,111,108,108,105,115,105,111,110,0,0,0,96,83,0,0,224,75,0,0,168,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,76,0,0,193,0,0,0,194,0,0,0,11,0,0,0,0,0,0,0,49,55,98,116,71,106,107,80,97,105,114,68,101,116,101,99,116,111,114,0,0,0,0,0,51,54,98,116,68,105,115,99,114,101,116,101,67,111,108,108,105,115,105,111,110,68,101,116,101,99,116,111,114,73,110,116,101,114,102,97,99,101,0,0,56,83,0,0,80,76,0,0,96,83,0,0,56,76,0,0,120,76,0,0,0,0,0,0,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,51,48,98,116,65,99,116,105,118,97,116,105,110,103,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,0,0,0,0,0,0,96,83,0,0,176,76,0,0,48,28,0,0,0,0,0,0,0,0,0,0,32,77,0,0,195,0,0,0,196,0,0,0,12,0,0,0,8,0,0,0,98,0,0,0,0,0,0,0,49,54,98,116,69,109,112,116,121,65,108,103,111,114,105,116,104,109,0,0,0,0,0,0,96,83,0,0,8,77,0,0,48,28,0,0,0,0,0,0,0,0,0,0,120,77,0,0,197,0,0,0,198,0,0,0,13,0,0,0,9,0,0,0,99,0,0,0,0,0,0,0,51,50,98,116,83,112,104,101,114,101,83,112,104,101,114,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,0,0,0,0,96,83,0,0,80,77,0,0,216,76,0,0,0,0,0,0,0,0,0,0,184,77,0,0,193,0,0,0,199,0,0,0,14,0,0,0,0,0,0,0,49,54,98,116,66,111,120,66,111,120,68,101,116,101,99,116,111,114,0,0,0,0,0,0,96,83,0,0,160,77,0,0,120,76,0,0,0,0,0,0,0,0,0,0,0,78,0,0,193,0,0,0,200,0,0,0,15,0,0,0,0,0,0,0,50,50,83,112,104,101,114,101,84,114,105,97,110,103,108,101,68,101,116,101,99,116,111,114,0,0,0,0,0,0,0,0,96,83,0,0,224,77,0,0,120,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,78,0,0,201,0,0,0,202,0,0,0,30,0,0,0,31,0,0,0,89,0,0,0,0,0,0,0,50,51,98,116,72,97,115,104,101,100,83,105,109,112,108,101,80,97,105,114,67,97,99,104,101,0,0,0,0,0,0,0,56,83,0,0,72,78,0,0,0,0,0,0,152,78,0,0,203,0,0,0,204,0,0,0,49,56,98,116,67,111,110,118,101,120,80,111,108,121,104,101,100,114,111,110,0,0,0,0,56,83,0,0,128,78,0,0,0,0,0,0,8,79,0,0,205,0,0,0,206,0,0,0,57,0,0,0,1,0,0,0,2,0,0,0,81,0,0,0,82,0,0,0,72,0,0,0,100,0,0,0,101,0,0,0,73,0,0,0,51,0,0,0,52,0,0,0,74,0,0,0,25,0,0,0,0,0,0,0,50,54,98,116,84,114,105,97,110,103,108,101,73,110,100,101,120,86,101,114,116,101,120,65,114,114,97,121,0,0,0,0,96,83,0,0,232,78,0,0,224,79,0,0,0,0,0,0,98,116,73,110,116,73,110,100,101,120,68,97,116,97,0,0,98,116,83,104,111,114,116,73,110,116,73,110,100,101,120,84,114,105,112,108,101,116,68,97,116,97,0,0,0,0,0,0,98,116,67,104,97,114,73,110,100,101,120,84,114,105,112,108,101,116,68,97,116,97,0,0,98,116,86,101,99,116,111,114,51,70,108,111,97,116,68,97,116,97,0,0,0,0,0,0,98,116,86,101,99,116,111,114,51,68,111,117,98,108,101,68,97,116,97,0,0,0,0,0,98,116,77,101,115,104,80,97,114,116,68,97,116,97,0,0,98,116,83,116,114,105,100,105,110,103,77,101,115,104,73,110,116,101,114,102,97,99,101,68,97,116,97,0,0,0,0,0,50,51,98,116,83,116,114,105,100,105,110,103,77,101,115,104,73,110,116,101,114,102,97,99,101,0,0,0,0,0,0,0,56,83,0,0,192,79],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+10240);allocate([82,111,111,116,0,0,0,0,240,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,117,110,99,97,117,103,104,116,0,0,0,0,0,0,0,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,101,120,99,101,112,116,105,111,110,32,111,102,32,116,121,112,101,32,37,115,58,32,37,115,0,0,0,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,101,120,99,101,112,116,105,111,110,32,111,102,32,116,121,112,101,32,37,115,0,0,0,0,0,0,0,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,102,111,114,101,105,103,110,32,101,120,99,101,112,116,105,111,110,0,0,0,116,101,114,109,105,110,97,116,105,110,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,116,104,114,101,97,100,95,111,110,99,101,32,102,97,105,108,117,114,101,32,105,110,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,95,102,97,115,116,40,41,0,0,0,0,0,0,0,0,99,97,110,110,111,116,32,99,114,101,97,116,101,32,112,116,104,114,101,97,100,32,107,101,121,32,102,111,114,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,40,41,0,0,0,0,0,0,0,99,97,110,110,111,116,32,122,101,114,111,32,111,117,116,32,116,104,114,101,97,100,32,118,97,108,117,101,32,102,111,114,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,40,41,0,0,0,0,0,0,0,0,224,81,0,0,207,0,0,0,208,0,0,0,90,0,0,0,0,0,0,0,115,116,100,58,58,98,97,100,95,97,108,108,111,99,0,0,83,116,57,98,97,100,95,97,108,108,111,99,0,0,0,0,96,83,0,0,208,81,0,0,48,82,0,0,0,0,0,0,116,101,114,109,105,110,97,116,101,95,104,97,110,100,108,101,114,32,117,110,101,120,112,101,99,116,101,100,108,121,32,114,101,116,117,114,110,101,100,0,0,0,0,0,0,0,0,0,83,116,57,101,120,99,101,112,116,105,111,110,0,0,0,0,56,83,0,0,32,82,0,0,83,116,57,116,121,112,101,95,105,110,102,111,0,0,0,0,56,83,0,0,56,82,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,54,95,95,115,104,105,109,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,0,0,0,96,83,0,0,80,82,0,0,72,82,0,0,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,0,0,96,83,0,0,136,82,0,0,120,82,0,0,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,57,95,95,112,111,105,110,116,101,114,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,112,98,97,115,101,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,0,0,96,83,0,0,232,82,0,0,120,82,0,0,0,0,0,0,96,83,0,0,192,82,0,0,16,83,0,0,0,0,0,0,0,0,0,0,176,82,0,0,209,0,0,0,210,0,0,0,211,0,0,0,212,0,0,0,32,0,0,0,4,0,0,0,16,0,0,0,62,0,0,0,0,0,0,0,168,83,0,0,209,0,0,0,213,0,0,0,211,0,0,0,212,0,0,0,32,0,0,0,5,0,0,0,17,0,0,0,63,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,48,95,95,115,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,96,83,0,0,128,83,0,0,176,82,0,0,0,0,0,0,0,0,0,0,8,84,0,0,209,0,0,0,214,0,0,0,211,0,0,0,212,0,0,0,32,0,0,0,6,0,0,0,18,0,0,0,64,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,49,95,95,118,109,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,0,0,96,83,0,0,224,83,0,0,176,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+20496);var tempDoublePtr=Runtime.alignMemory(allocate(12,"i8",ALLOC_STATIC),8);assert(tempDoublePtr%8==0);function copyTempFloat(ptr){HEAP8[tempDoublePtr]=HEAP8[ptr];HEAP8[tempDoublePtr+1]=HEAP8[ptr+1];HEAP8[tempDoublePtr+2]=HEAP8[ptr+2];HEAP8[tempDoublePtr+3]=HEAP8[ptr+3]}function copyTempDouble(ptr){HEAP8[tempDoublePtr]=HEAP8[ptr];HEAP8[tempDoublePtr+1]=HEAP8[ptr+1];HEAP8[tempDoublePtr+2]=HEAP8[ptr+2];HEAP8[tempDoublePtr+3]=HEAP8[ptr+3];HEAP8[tempDoublePtr+4]=HEAP8[ptr+4];HEAP8[tempDoublePtr+5]=HEAP8[ptr+5];HEAP8[tempDoublePtr+6]=HEAP8[ptr+6];HEAP8[tempDoublePtr+7]=HEAP8[ptr+7]}var _cosf=Math_cos;Module["_i64Subtract"]=_i64Subtract;var _fabsf=Math_abs;var ___errno_state=0;function ___setErrNo(value){HEAP32[___errno_state>>2]=value;return value}var ERRNO_CODES={EPERM:1,ENOENT:2,ESRCH:3,EINTR:4,EIO:5,ENXIO:6,E2BIG:7,ENOEXEC:8,EBADF:9,ECHILD:10,EAGAIN:11,EWOULDBLOCK:11,ENOMEM:12,EACCES:13,EFAULT:14,ENOTBLK:15,EBUSY:16,EEXIST:17,EXDEV:18,ENODEV:19,ENOTDIR:20,EISDIR:21,EINVAL:22,ENFILE:23,EMFILE:24,ENOTTY:25,ETXTBSY:26,EFBIG:27,ENOSPC:28,ESPIPE:29,EROFS:30,EMLINK:31,EPIPE:32,EDOM:33,ERANGE:34,ENOMSG:42,EIDRM:43,ECHRNG:44,EL2NSYNC:45,EL3HLT:46,EL3RST:47,ELNRNG:48,EUNATCH:49,ENOCSI:50,EL2HLT:51,EDEADLK:35,ENOLCK:37,EBADE:52,EBADR:53,EXFULL:54,ENOANO:55,EBADRQC:56,EBADSLT:57,EDEADLOCK:35,EBFONT:59,ENOSTR:60,ENODATA:61,ETIME:62,ENOSR:63,ENONET:64,ENOPKG:65,EREMOTE:66,ENOLINK:67,EADV:68,ESRMNT:69,ECOMM:70,EPROTO:71,EMULTIHOP:72,EDOTDOT:73,EBADMSG:74,ENOTUNIQ:76,EBADFD:77,EREMCHG:78,ELIBACC:79,ELIBBAD:80,ELIBSCN:81,ELIBMAX:82,ELIBEXEC:83,ENOSYS:38,ENOTEMPTY:39,ENAMETOOLONG:36,ELOOP:40,EOPNOTSUPP:95,EPFNOSUPPORT:96,ECONNRESET:104,ENOBUFS:105,EAFNOSUPPORT:97,EPROTOTYPE:91,ENOTSOCK:88,ENOPROTOOPT:92,ESHUTDOWN:108,ECONNREFUSED:111,EADDRINUSE:98,ECONNABORTED:103,ENETUNREACH:101,ENETDOWN:100,ETIMEDOUT:110,EHOSTDOWN:112,EHOSTUNREACH:113,EINPROGRESS:115,EALREADY:114,EDESTADDRREQ:89,EMSGSIZE:90,EPROTONOSUPPORT:93,ESOCKTNOSUPPORT:94,EADDRNOTAVAIL:99,ENETRESET:102,EISCONN:106,ENOTCONN:107,ETOOMANYREFS:109,EUSERS:87,EDQUOT:122,ESTALE:116,ENOTSUP:95,ENOMEDIUM:123,EILSEQ:84,EOVERFLOW:75,ECANCELED:125,ENOTRECOVERABLE:131,EOWNERDEAD:130,ESTRPIPE:86};function _sysconf(name){switch(name){case 30:return PAGE_SIZE;case 132:case 133:case 12:case 137:case 138:case 15:case 235:case 16:case 17:case 18:case 19:case 20:case 149:case 13:case 10:case 236:case 153:case 9:case 21:case 22:case 159:case 154:case 14:case 77:case 78:case 139:case 80:case 81:case 79:case 82:case 68:case 67:case 164:case 11:case 29:case 47:case 48:case 95:case 52:case 51:case 46:return 200809;case 27:case 246:case 127:case 128:case 23:case 24:case 160:case 161:case 181:case 182:case 242:case 183:case 184:case 243:case 244:case 245:case 165:case 178:case 179:case 49:case 50:case 168:case 169:case 175:case 170:case 171:case 172:case 97:case 76:case 32:case 173:case 35:return-1;case 176:case 177:case 7:case 155:case 8:case 157:case 125:case 126:case 92:case 93:case 129:case 130:case 131:case 94:case 91:return 1;case 74:case 60:case 69:case 70:case 4:return 1024;case 31:case 42:case 72:return 32;case 87:case 26:case 33:return 2147483647;case 34:case 1:return 47839;case 38:case 36:return 99;case 43:case 37:return 2048;case 0:return 2097152;case 3:return 65536;case 28:return 32768;case 44:return 32767;case 75:return 16384;case 39:return 1e3;case 89:return 700;case 71:return 256;case 40:return 255;case 2:return 100;case 180:return 64;case 25:return 20;case 5:return 16;case 6:return 6;case 73:return 4;case 84:{if(typeof navigator==="object")return navigator["hardwareConcurrency"]||1;return 1}}___setErrNo(ERRNO_CODES.EINVAL);return-1}function __ZSt18uncaught_exceptionv(){return!!__ZSt18uncaught_exceptionv.uncaught_exception}var EXCEPTIONS={last:0,caught:[],infos:{},deAdjust:(function(adjusted){if(!adjusted||EXCEPTIONS.infos[adjusted])return adjusted;for(var ptr in EXCEPTIONS.infos){var info=EXCEPTIONS.infos[ptr];if(info.adjusted===adjusted){return ptr}}return adjusted}),addRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];info.refcount++}),decRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];assert(info.refcount>0);info.refcount--;if(info.refcount===0){if(info.destructor){Runtime.dynCall("vi",info.destructor,[ptr])}delete EXCEPTIONS.infos[ptr];___cxa_free_exception(ptr)}}),clearRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];info.refcount=0})};function ___resumeException(ptr){if(!EXCEPTIONS.last){EXCEPTIONS.last=ptr}EXCEPTIONS.clearRef(EXCEPTIONS.deAdjust(ptr));throw ptr+" - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch."}function ___cxa_find_matching_catch(){var thrown=EXCEPTIONS.last;if(!thrown){return(asm["setTempRet0"](0),0)|0}var info=EXCEPTIONS.infos[thrown];var throwntype=info.type;if(!throwntype){return(asm["setTempRet0"](0),thrown)|0}var typeArray=Array.prototype.slice.call(arguments);var pointer=Module["___cxa_is_pointer_type"](throwntype);if(!___cxa_find_matching_catch.buffer)___cxa_find_matching_catch.buffer=_malloc(4);HEAP32[___cxa_find_matching_catch.buffer>>2]=thrown;thrown=___cxa_find_matching_catch.buffer;for(var i=0;i<typeArray.length;i++){if(typeArray[i]&&Module["___cxa_can_catch"](typeArray[i],throwntype,thrown)){thrown=HEAP32[thrown>>2];info.adjusted=thrown;return(asm["setTempRet0"](typeArray[i]),thrown)|0}}thrown=HEAP32[thrown>>2];return(asm["setTempRet0"](throwntype),thrown)|0}function ___cxa_throw(ptr,type,destructor){EXCEPTIONS.infos[ptr]={ptr:ptr,adjusted:ptr,type:type,destructor:destructor,refcount:0};EXCEPTIONS.last=ptr;if(!("uncaught_exception"in __ZSt18uncaught_exceptionv)){__ZSt18uncaught_exceptionv.uncaught_exception=1}else{__ZSt18uncaught_exceptionv.uncaught_exception++}throw ptr+" - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch."}Module["_memset"]=_memset;function _abort(){Module["abort"]()}function _pthread_once(ptr,func){if(!_pthread_once.seen)_pthread_once.seen={};if(ptr in _pthread_once.seen)return;Runtime.dynCall("v",func);_pthread_once.seen[ptr]=1}var _acosf=Math_acos;Module["_strlen"]=_strlen;var _sqrtf=Math_sqrt;var FS=undefined;var SOCKFS=undefined;function _send(fd,buf,len,flags){var sock=SOCKFS.getSocket(fd);if(!sock){___setErrNo(ERRNO_CODES.EBADF);return-1}return _write(fd,buf,len)}function _pwrite(fildes,buf,nbyte,offset){var stream=FS.getStream(fildes);if(!stream){___setErrNo(ERRNO_CODES.EBADF);return-1}try{var slab=HEAP8;return FS.write(stream,slab,buf,nbyte,offset)}catch(e){FS.handleFSError(e);return-1}}function _write(fildes,buf,nbyte){var stream=FS.getStream(fildes);if(!stream){___setErrNo(ERRNO_CODES.EBADF);return-1}try{var slab=HEAP8;return FS.write(stream,slab,buf,nbyte)}catch(e){FS.handleFSError(e);return-1}}function _fileno(stream){stream=FS.getStreamFromPtr(stream);if(!stream)return-1;return stream.fd}function _fputc(c,stream){var chr=unSign(c&255);HEAP8[_fputc.ret>>0]=chr;var fd=_fileno(stream);var ret=_write(fd,_fputc.ret,1);if(ret==-1){var streamObj=FS.getStreamFromPtr(stream);if(streamObj)streamObj.error=true;return-1}else{return chr}}var PTHREAD_SPECIFIC={};function _pthread_getspecific(key){return PTHREAD_SPECIFIC[key]||0}Module["_i64Add"]=_i64Add;var PTHREAD_SPECIFIC_NEXT_KEY=1;function _pthread_key_create(key,destructor){if(key==0){return ERRNO_CODES.EINVAL}HEAP32[key>>2]=PTHREAD_SPECIFIC_NEXT_KEY;PTHREAD_SPECIFIC[PTHREAD_SPECIFIC_NEXT_KEY]=0;PTHREAD_SPECIFIC_NEXT_KEY++;return 0}var _llvm_pow_f32=Math_pow;function _pthread_setspecific(key,value){if(!(key in PTHREAD_SPECIFIC)){return ERRNO_CODES.EINVAL}PTHREAD_SPECIFIC[key]=value;return 0}var _atan2f=Math_atan2;function ___cxa_pure_virtual(){ABORT=true;throw"Pure virtual function called!"}function ___cxa_guard_release(){}var _asinf=Math_asin;function ___cxa_guard_acquire(variable){if(!HEAP8[variable>>0]){HEAP8[variable>>0]=1;return 1}return 0}function _gettimeofday(ptr){var now=Date.now();HEAP32[ptr>>2]=now/1e3|0;HEAP32[ptr+4>>2]=now%1e3*1e3|0;return 0}function _emscripten_asm_const_double(code){var args=Array.prototype.slice.call(arguments,1);return+Runtime.getAsmConst(code,args.length).apply(null,args)}function ___cxa_begin_catch(ptr){__ZSt18uncaught_exceptionv.uncaught_exception--;EXCEPTIONS.caught.push(ptr);EXCEPTIONS.addRef(EXCEPTIONS.deAdjust(ptr));return ptr}var _sinf=Math_sin;function _emscripten_memcpy_big(dest,src,num){HEAPU8.set(HEAPU8.subarray(src,src+num),dest);return dest}Module["_memcpy"]=_memcpy;function _sbrk(bytes){var self=_sbrk;if(!self.called){DYNAMICTOP=alignMemoryPage(DYNAMICTOP);self.called=true;assert(Runtime.dynamicAlloc);self.alloc=Runtime.dynamicAlloc;Runtime.dynamicAlloc=(function(){abort("cannot dynamically allocate, sbrk now has control")})}var ret=DYNAMICTOP;if(bytes!=0){var success=self.alloc(bytes);if(!success)return-1>>>0}return ret}Module["_memmove"]=_memmove;function _malloc(bytes){var ptr=Runtime.dynamicAlloc(bytes+8);return ptr+8&4294967288}Module["_malloc"]=_malloc;function ___cxa_allocate_exception(size){return _malloc(size)}function ___errno_location(){return ___errno_state}Module["_llvm_bswap_i32"]=_llvm_bswap_i32;function _llvm_trap(){abort("trap!")}function _time(ptr){var ret=Date.now()/1e3|0;if(ptr){HEAP32[ptr>>2]=ret}return ret}var _UItoF=true;function _fwrite(ptr,size,nitems,stream){var bytesToWrite=nitems*size;if(bytesToWrite==0)return 0;var fd=_fileno(stream);var bytesWritten=_write(fd,ptr,bytesToWrite);if(bytesWritten==-1){var streamObj=FS.getStreamFromPtr(stream);if(streamObj)streamObj.error=true;return 0}else{return bytesWritten/size|0}}function __reallyNegative(x){return x<0||x===0&&1/x===-Infinity}function __formatString(format,varargs){var textIndex=format;var argIndex=0;function getNextArg(type){var ret;if(type==="double"){ret=(HEAP32[tempDoublePtr>>2]=HEAP32[varargs+argIndex>>2],HEAP32[tempDoublePtr+4>>2]=HEAP32[varargs+(argIndex+4)>>2],+HEAPF64[tempDoublePtr>>3])}else if(type=="i64"){ret=[HEAP32[varargs+argIndex>>2],HEAP32[varargs+(argIndex+4)>>2]]}else{type="i32";ret=HEAP32[varargs+argIndex>>2]}argIndex+=Runtime.getNativeFieldSize(type);return ret}var ret=[];var curr,next,currArg;while(1){var startTextIndex=textIndex;curr=HEAP8[textIndex>>0];if(curr===0)break;next=HEAP8[textIndex+1>>0];if(curr==37){var flagAlwaysSigned=false;var flagLeftAlign=false;var flagAlternative=false;var flagZeroPad=false;var flagPadSign=false;flagsLoop:while(1){switch(next){case 43:flagAlwaysSigned=true;break;case 45:flagLeftAlign=true;break;case 35:flagAlternative=true;break;case 48:if(flagZeroPad){break flagsLoop}else{flagZeroPad=true;break};case 32:flagPadSign=true;break;default:break flagsLoop}textIndex++;next=HEAP8[textIndex+1>>0]}var width=0;if(next==42){width=getNextArg("i32");textIndex++;next=HEAP8[textIndex+1>>0]}else{while(next>=48&&next<=57){width=width*10+(next-48);textIndex++;next=HEAP8[textIndex+1>>0]}}var precisionSet=false,precision=-1;if(next==46){precision=0;precisionSet=true;textIndex++;next=HEAP8[textIndex+1>>0];if(next==42){precision=getNextArg("i32");textIndex++}else{while(1){var precisionChr=HEAP8[textIndex+1>>0];if(precisionChr<48||precisionChr>57)break;precision=precision*10+(precisionChr-48);textIndex++}}next=HEAP8[textIndex+1>>0]}if(precision<0){precision=6;precisionSet=false}var argSize;switch(String.fromCharCode(next)){case"h":var nextNext=HEAP8[textIndex+2>>0];if(nextNext==104){textIndex++;argSize=1}else{argSize=2}break;case"l":var nextNext=HEAP8[textIndex+2>>0];if(nextNext==108){textIndex++;argSize=8}else{argSize=4}break;case"L":case"q":case"j":argSize=8;break;case"z":case"t":case"I":argSize=4;break;default:argSize=null}if(argSize)textIndex++;next=HEAP8[textIndex+1>>0];switch(String.fromCharCode(next)){case"d":case"i":case"u":case"o":case"x":case"X":case"p":{var signed=next==100||next==105;argSize=argSize||4;var currArg=getNextArg("i"+argSize*8);var origArg=currArg;var argText;if(argSize==8){currArg=Runtime.makeBigInt(currArg[0],currArg[1],next==117)}if(argSize<=4){var limit=Math.pow(256,argSize)-1;currArg=(signed?reSign:unSign)(currArg&limit,argSize*8)}var currAbsArg=Math.abs(currArg);var prefix="";if(next==100||next==105){if(argSize==8&&i64Math)argText=i64Math.stringify(origArg[0],origArg[1],null);else argText=reSign(currArg,8*argSize,1).toString(10)}else if(next==117){if(argSize==8&&i64Math)argText=i64Math.stringify(origArg[0],origArg[1],true);else argText=unSign(currArg,8*argSize,1).toString(10);currArg=Math.abs(currArg)}else if(next==111){argText=(flagAlternative?"0":"")+currAbsArg.toString(8)}else if(next==120||next==88){prefix=flagAlternative&&currArg!=0?"0x":"";if(argSize==8&&i64Math){if(origArg[1]){argText=(origArg[1]>>>0).toString(16);var lower=(origArg[0]>>>0).toString(16);while(lower.length<8)lower="0"+lower;argText+=lower}else{argText=(origArg[0]>>>0).toString(16)}}else if(currArg<0){currArg=-currArg;argText=(currAbsArg-1).toString(16);var buffer=[];for(var i=0;i<argText.length;i++){buffer.push((15-parseInt(argText[i],16)).toString(16))}argText=buffer.join("");while(argText.length<argSize*2)argText="f"+argText}else{argText=currAbsArg.toString(16)}if(next==88){prefix=prefix.toUpperCase();argText=argText.toUpperCase()}}else if(next==112){if(currAbsArg===0){argText="(nil)"}else{prefix="0x";argText=currAbsArg.toString(16)}}if(precisionSet){while(argText.length<precision){argText="0"+argText}}if(currArg>=0){if(flagAlwaysSigned){prefix="+"+prefix}else if(flagPadSign){prefix=" "+prefix}}if(argText.charAt(0)=="-"){prefix="-"+prefix;argText=argText.substr(1)}while(prefix.length+argText.length<width){if(flagLeftAlign){argText+=" "}else{if(flagZeroPad){argText="0"+argText}else{prefix=" "+prefix}}}argText=prefix+argText;argText.split("").forEach((function(chr){ret.push(chr.charCodeAt(0))}));break};case"f":case"F":case"e":case"E":case"g":case"G":{var currArg=getNextArg("double");var argText;if(isNaN(currArg)){argText="nan";flagZeroPad=false}else if(!isFinite(currArg)){argText=(currArg<0?"-":"")+"inf";flagZeroPad=false}else{var isGeneral=false;var effectivePrecision=Math.min(precision,20);if(next==103||next==71){isGeneral=true;precision=precision||1;var exponent=parseInt(currArg.toExponential(effectivePrecision).split("e")[1],10);if(precision>exponent&&exponent>=-4){next=(next==103?"f":"F").charCodeAt(0);precision-=exponent+1}else{next=(next==103?"e":"E").charCodeAt(0);precision--}effectivePrecision=Math.min(precision,20)}if(next==101||next==69){argText=currArg.toExponential(effectivePrecision);if(/[eE][-+]\d$/.test(argText)){argText=argText.slice(0,-1)+"0"+argText.slice(-1)}}else if(next==102||next==70){argText=currArg.toFixed(effectivePrecision);if(currArg===0&&__reallyNegative(currArg)){argText="-"+argText}}var parts=argText.split("e");if(isGeneral&&!flagAlternative){while(parts[0].length>1&&parts[0].indexOf(".")!=-1&&(parts[0].slice(-1)=="0"||parts[0].slice(-1)==".")){parts[0]=parts[0].slice(0,-1)}}else{if(flagAlternative&&argText.indexOf(".")==-1)parts[0]+=".";while(precision>effectivePrecision++)parts[0]+="0"}argText=parts[0]+(parts.length>1?"e"+parts[1]:"");if(next==69)argText=argText.toUpperCase();if(currArg>=0){if(flagAlwaysSigned){argText="+"+argText}else if(flagPadSign){argText=" "+argText}}}while(argText.length<width){if(flagLeftAlign){argText+=" "}else{if(flagZeroPad&&(argText[0]=="-"||argText[0]=="+")){argText=argText[0]+"0"+argText.slice(1)}else{argText=(flagZeroPad?"0":" ")+argText}}}if(next<97)argText=argText.toUpperCase();argText.split("").forEach((function(chr){ret.push(chr.charCodeAt(0))}));break};case"s":{var arg=getNextArg("i8*");var argLength=arg?_strlen(arg):"(null)".length;if(precisionSet)argLength=Math.min(argLength,precision);if(!flagLeftAlign){while(argLength<width--){ret.push(32)}}if(arg){for(var i=0;i<argLength;i++){ret.push(HEAPU8[arg++>>0])}}else{ret=ret.concat(intArrayFromString("(null)".substr(0,argLength),true))}if(flagLeftAlign){while(argLength<width--){ret.push(32)}}break};case"c":{if(flagLeftAlign)ret.push(getNextArg("i8"));while(--width>0){ret.push(32)}if(!flagLeftAlign)ret.push(getNextArg("i8"));break};case"n":{var ptr=getNextArg("i32*");HEAP32[ptr>>2]=ret.length;break};case"%":{ret.push(curr);break};default:{for(var i=startTextIndex;i<textIndex+2;i++){ret.push(HEAP8[i>>0])}}}textIndex+=2}else{ret.push(curr);textIndex+=1}}return ret}function _fprintf(stream,format,varargs){var result=__formatString(format,varargs);var stack=Runtime.stackSave();var ret=_fwrite(allocate(result,"i8",ALLOC_STACK),1,result.length,stream);Runtime.stackRestore(stack);return ret}function _vfprintf(s,f,va_arg){return _fprintf(s,f,HEAP32[va_arg>>2])}var _stderr=allocate(1,"i32*",ALLOC_STATIC);___errno_state=Runtime.staticAlloc(4);HEAP32[___errno_state>>2]=0;_fputc.ret=allocate([0],"i8",ALLOC_STATIC);STACK_BASE=STACKTOP=Runtime.alignMemory(STATICTOP);staticSealed=true;STACK_MAX=STACK_BASE+TOTAL_STACK;DYNAMIC_BASE=DYNAMICTOP=Runtime.alignMemory(STACK_MAX);assert(DYNAMIC_BASE<TOTAL_MEMORY,"TOTAL_MEMORY not big enough for stack");var cttz_i8=allocate([8,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,7,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0],"i8",ALLOC_DYNAMIC);function invoke_viiiii(index,a1,a2,a3,a4,a5){try{Module["dynCall_viiiii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vid(index,a1,a2){try{Module["dynCall_vid"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vi(index,a1){try{Module["dynCall_vi"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiidii(index,a1,a2,a3,a4,a5,a6){try{Module["dynCall_viiidii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vii(index,a1,a2){try{Module["dynCall_vii"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10){try{return Module["dynCall_iiiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_ii(index,a1){try{return Module["dynCall_ii"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viidi(index,a1,a2,a3,a4){try{Module["dynCall_viidi"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viddiii(index,a1,a2,a3,a4,a5,a6){try{Module["dynCall_viddiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vidii(index,a1,a2,a3,a4){try{Module["dynCall_vidii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiii(index,a1,a2,a3,a4){try{return Module["dynCall_iiiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vidi(index,a1,a2,a3){try{Module["dynCall_vidi"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8){try{return Module["dynCall_diiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiddddiid(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11){try{Module["dynCall_viiiiddddiid"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiiii(index,a1,a2,a3,a4,a5){try{return Module["dynCall_diiiii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiii(index,a1,a2,a3){try{return Module["dynCall_iiii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiii(index,a1,a2,a3,a4,a5,a6){try{Module["dynCall_viiiiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiid(index,a1,a2,a3){try{return Module["dynCall_iiid"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_di(index,a1){try{return Module["dynCall_di"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiiii(index,a1,a2,a3,a4,a5,a6){try{return Module["dynCall_iiiiiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiidii(index,a1,a2,a3,a4,a5,a6){try{return Module["dynCall_diiidii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viidii(index,a1,a2,a3,a4,a5){try{Module["dynCall_viidii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiiii(index,a1,a2,a3,a4,a5,a6,a7){try{Module["dynCall_viiiiiii"](index,a1,a2,a3,a4,a5,a6,a7)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9){try{Module["dynCall_viiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10){try{Module["dynCall_viiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iii(index,a1,a2){try{return Module["dynCall_iii"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diii(index,a1,a2,a3){try{return Module["dynCall_diii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10){try{return Module["dynCall_diiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiid(index,a1,a2,a3,a4,a5){try{Module["dynCall_viiiid"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9){try{return Module["dynCall_diiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_did(index,a1,a2){try{return Module["dynCall_did"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiidddddidi(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12){try{Module["dynCall_viiiidddddidi"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diidii(index,a1,a2,a3,a4,a5){try{return Module["dynCall_diidii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiii(index,a1,a2,a3,a4){try{return Module["dynCall_diiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9){try{return Module["dynCall_iiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiid(index,a1,a2,a3,a4){try{Module["dynCall_viiid"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viii(index,a1,a2,a3){try{Module["dynCall_viii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_v(index){try{Module["dynCall_v"](index)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viid(index,a1,a2,a3){try{Module["dynCall_viid"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iidid(index,a1,a2,a3,a4){try{return Module["dynCall_iidid"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiii(index,a1,a2,a3,a4){try{Module["dynCall_viiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}Module.asmGlobalArg={"Math":Math,"Int8Array":Int8Array,"Int16Array":Int16Array,"Int32Array":Int32Array,"Uint8Array":Uint8Array,"Uint16Array":Uint16Array,"Uint32Array":Uint32Array,"Float32Array":Float32Array,"Float64Array":Float64Array,"NaN":NaN,"Infinity":Infinity};Module.asmLibraryArg={"abort":abort,"assert":assert,"invoke_viiiii":invoke_viiiii,"invoke_vid":invoke_vid,"invoke_vi":invoke_vi,"invoke_viiidii":invoke_viiidii,"invoke_vii":invoke_vii,"invoke_iiiiiiiiiii":invoke_iiiiiiiiiii,"invoke_ii":invoke_ii,"invoke_viidi":invoke_viidi,"invoke_viddiii":invoke_viddiii,"invoke_vidii":invoke_vidii,"invoke_iiiii":invoke_iiiii,"invoke_vidi":invoke_vidi,"invoke_diiiiiiii":invoke_diiiiiiii,"invoke_viiiiddddiid":invoke_viiiiddddiid,"invoke_diiiii":invoke_diiiii,"invoke_iiii":invoke_iiii,"invoke_viiiiii":invoke_viiiiii,"invoke_iiid":invoke_iiid,"invoke_di":invoke_di,"invoke_iiiiiii":invoke_iiiiiii,"invoke_diiidii":invoke_diiidii,"invoke_viidii":invoke_viidii,"invoke_viiiiiii":invoke_viiiiiii,"invoke_viiiiiiiii":invoke_viiiiiiiii,"invoke_viiiiiiiiii":invoke_viiiiiiiiii,"invoke_iii":invoke_iii,"invoke_diii":invoke_diii,"invoke_diiiiiiiiii":invoke_diiiiiiiiii,"invoke_viiiid":invoke_viiiid,"invoke_diiiiiiiii":invoke_diiiiiiiii,"invoke_did":invoke_did,"invoke_viiiidddddidi":invoke_viiiidddddidi,"invoke_diidii":invoke_diidii,"invoke_diiii":invoke_diiii,"invoke_iiiiiiiiii":invoke_iiiiiiiiii,"invoke_viiid":invoke_viiid,"invoke_viii":invoke_viii,"invoke_v":invoke_v,"invoke_viid":invoke_viid,"invoke_iidid":invoke_iidid,"invoke_viiii":invoke_viiii,"_emscripten_asm_const_double":_emscripten_asm_const_double,"_cosf":_cosf,"_send":_send,"_sqrtf":_sqrtf,"___cxa_guard_acquire":___cxa_guard_acquire,"___setErrNo":___setErrNo,"_vfprintf":_vfprintf,"_atan2f":_atan2f,"__ZSt18uncaught_exceptionv":__ZSt18uncaught_exceptionv,"___cxa_guard_release":___cxa_guard_release,"_pwrite":_pwrite,"_acosf":_acosf,"_asinf":_asinf,"_fabsf":_fabsf,"_sbrk":_sbrk,"_llvm_pow_f32":_llvm_pow_f32,"___cxa_begin_catch":___cxa_begin_catch,"_sinf":_sinf,"_fileno":_fileno,"___resumeException":___resumeException,"___cxa_find_matching_catch":___cxa_find_matching_catch,"_sysconf":_sysconf,"__reallyNegative":__reallyNegative,"_pthread_getspecific":_pthread_getspecific,"_emscripten_memcpy_big":_emscripten_memcpy_big,"_pthread_once":_pthread_once,"_pthread_key_create":_pthread_key_create,"_write":_write,"___errno_location":___errno_location,"_pthread_setspecific":_pthread_setspecific,"_fputc":_fputc,"___cxa_throw":___cxa_throw,"_abort":_abort,"___cxa_allocate_exception":___cxa_allocate_exception,"_fwrite":_fwrite,"_time":_time,"_fprintf":_fprintf,"_gettimeofday":_gettimeofday,"__formatString":__formatString,"_llvm_trap":_llvm_trap,"___cxa_pure_virtual":___cxa_pure_virtual,"STACKTOP":STACKTOP,"STACK_MAX":STACK_MAX,"tempDoublePtr":tempDoublePtr,"ABORT":ABORT,"cttz_i8":cttz_i8,"_stderr":_stderr};// EMSCRIPTEN_START_ASM
var asm=(function(global,env,buffer) {
"use asm";var a=new global.Int8Array(buffer);var b=new global.Int16Array(buffer);var c=new global.Int32Array(buffer);var d=new global.Uint8Array(buffer);var e=new global.Uint16Array(buffer);var f=new global.Uint32Array(buffer);var g=new global.Float32Array(buffer);var h=new global.Float64Array(buffer);var i=env.STACKTOP|0;var j=env.STACK_MAX|0;var k=env.tempDoublePtr|0;var l=env.ABORT|0;var m=env.cttz_i8|0;var n=env._stderr|0;var o=0;var p=0;var q=0;var r=0;var s=global.NaN,t=global.Infinity;var u=0,v=0,w=0,x=0,y=0.0,z=0,A=0,B=0,C=0.0;var D=0;var E=0;var F=0;var G=0;var H=0;var I=0;var J=0;var K=0;var L=0;var M=0;var N=global.Math.floor;var O=global.Math.abs;var P=global.Math.sqrt;var Q=global.Math.pow;var R=global.Math.cos;var S=global.Math.sin;var T=global.Math.tan;var U=global.Math.acos;var V=global.Math.asin;var W=global.Math.atan;var X=global.Math.atan2;var Y=global.Math.exp;var Z=global.Math.log;var _=global.Math.ceil;var $=global.Math.imul;var aa=global.Math.min;var ba=global.Math.clz32;var ca=env.abort;var da=env.assert;var ea=env.invoke_viiiii;var fa=env.invoke_vid;var ga=env.invoke_vi;var ha=env.invoke_viiidii;var ia=env.invoke_vii;var ja=env.invoke_iiiiiiiiiii;var ka=env.invoke_ii;var la=env.invoke_viidi;var ma=env.invoke_viddiii;var na=env.invoke_vidii;var oa=env.invoke_iiiii;var pa=env.invoke_vidi;var qa=env.invoke_diiiiiiii;var ra=env.invoke_viiiiddddiid;var sa=env.invoke_diiiii;var ta=env.invoke_iiii;var ua=env.invoke_viiiiii;var va=env.invoke_iiid;var wa=env.invoke_di;var xa=env.invoke_iiiiiii;var ya=env.invoke_diiidii;var za=env.invoke_viidii;var Aa=env.invoke_viiiiiii;var Ba=env.invoke_viiiiiiiii;var Ca=env.invoke_viiiiiiiiii;var Da=env.invoke_iii;var Ea=env.invoke_diii;var Fa=env.invoke_diiiiiiiiii;var Ga=env.invoke_viiiid;var Ha=env.invoke_diiiiiiiii;var Ia=env.invoke_did;var Ja=env.invoke_viiiidddddidi;var Ka=env.invoke_diidii;var La=env.invoke_diiii;var Ma=env.invoke_iiiiiiiiii;var Na=env.invoke_viiid;var Oa=env.invoke_viii;var Pa=env.invoke_v;var Qa=env.invoke_viid;var Ra=env.invoke_iidid;var Sa=env.invoke_viiii;var Ta=env._emscripten_asm_const_double;var Ua=env._cosf;var Va=env._send;var Wa=env._sqrtf;var Xa=env.___cxa_guard_acquire;var Ya=env.___setErrNo;var Za=env._vfprintf;var _a=env._atan2f;var $a=env.__ZSt18uncaught_exceptionv;var ab=env.___cxa_guard_release;var bb=env._pwrite;var cb=env._acosf;var db=env._asinf;var eb=env._fabsf;var fb=env._sbrk;var gb=env._llvm_pow_f32;var hb=env.___cxa_begin_catch;var ib=env._sinf;var jb=env._fileno;var kb=env.___resumeException;var lb=env.___cxa_find_matching_catch;var mb=env._sysconf;var nb=env.__reallyNegative;var ob=env._pthread_getspecific;var pb=env._emscripten_memcpy_big;var qb=env._pthread_once;var rb=env._pthread_key_create;var sb=env._write;var tb=env.___errno_location;var ub=env._pthread_setspecific;var vb=env._fputc;var wb=env.___cxa_throw;var xb=env._abort;var yb=env.___cxa_allocate_exception;var zb=env._fwrite;var Ab=env._time;var Bb=env._fprintf;var Cb=env._gettimeofday;var Db=env.__formatString;var Eb=env._llvm_trap;var Fb=env.___cxa_pure_virtual;var Gb=0.0;
// EMSCRIPTEN_START_FUNCS
function uc(a){a=a|0;var b=0;b=i;i=i+a|0;i=i+15&-16;return b|0}function vc(){return i|0}function wc(a){a=a|0;i=a}function xc(a,b){a=a|0;b=b|0;if(!o){o=a;p=b}}function yc(b){b=b|0;a[k>>0]=a[b>>0];a[k+1>>0]=a[b+1>>0];a[k+2>>0]=a[b+2>>0];a[k+3>>0]=a[b+3>>0]}function zc(b){b=b|0;a[k>>0]=a[b>>0];a[k+1>>0]=a[b+1>>0];a[k+2>>0]=a[b+2>>0];a[k+3>>0]=a[b+3>>0];a[k+4>>0]=a[b+4>>0];a[k+5>>0]=a[b+5>>0];a[k+6>>0]=a[b+6>>0];a[k+7>>0]=a[b+7>>0]}function Ac(a){a=a|0;D=a}function Bc(){return D|0}function Cc(a){a=a|0;return 52}function Dc(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;var e=0.0,f=0.0,h=0.0;e=+R(+b);f=+R(+c);h=+R(+d);b=+S(+b);c=+S(+c);d=+S(+d);g[a>>2]=f*h;g[a+4>>2]=c*(b*h)-e*d;g[a+8>>2]=c*(e*h)+b*d;g[a+12>>2]=0.0;g[a+16>>2]=f*d;g[a+20>>2]=c*(b*d)+e*h;g[a+24>>2]=c*(e*d)-b*h;g[a+28>>2]=0.0;g[a+32>>2]=-c;g[a+36>>2]=f*b;g[a+40>>2]=f*e;g[a+44>>2]=0.0;return}function Ec(a,b){a=a|0;b=b|0;Fc(a,b);return}function Fc(a,b){a=a|0;b=b|0;var c=0,d=0.0,e=0.0,f=0.0,h=0,j=0.0,k=0,l=0;h=i;i=i+16|0;d=+g[a>>2];e=+g[a+20>>2];f=+g[a+40>>2];if(d+e+f>0.0){f=+P(+(d+e+f+1.0));g[h+12>>2]=f*.5;j=(+g[a+36>>2]-+g[a+24>>2])*(.5/f);g[h>>2]=j;d=(+g[a+8>>2]-+g[a+32>>2])*(.5/f);g[h+4>>2]=d;e=(+g[a+16>>2]-+g[a+4>>2])*(.5/f);g[h+8>>2]=e;f=f*.5;g[b>>2]=j;a=b+4|0;g[a>>2]=d;a=b+8|0;g[a>>2]=e;b=b+12|0;g[b>>2]=f;i=h;return}if(d<e)c=e<f?2:1;else c=d<f?2:0;l=((c+1|0)>>>0)%3|0;k=((c+2|0)>>>0)%3|0;d=+P(+(+g[a+(c<<4)+(c<<2)>>2]-+g[a+(l<<4)+(l<<2)>>2]-+g[a+(k<<4)+(k<<2)>>2]+1.0));g[h+(c<<2)>>2]=d*.5;g[h+12>>2]=(+g[a+(k<<4)+(l<<2)>>2]-+g[a+(l<<4)+(k<<2)>>2])*(.5/d);g[h+(l<<2)>>2]=(+g[a+(l<<4)+(c<<2)>>2]+ +g[a+(c<<4)+(l<<2)>>2])*(.5/d);g[h+(k<<2)>>2]=(+g[a+(k<<4)+(c<<2)>>2]+ +g[a+(c<<4)+(k<<2)>>2])*(.5/d);d=+g[h>>2];e=+g[h+4>>2];j=+g[h+8>>2];f=+g[h+12>>2];g[b>>2]=d;a=b+4|0;g[a>>2]=e;a=b+8|0;g[a>>2]=j;b=b+12|0;g[b>>2]=f;i=h;return}function Gc(a){a=a|0;if(!a)return;_E(a);return}function Hc(){var a=0,d=0;a=ZE(8)|0;a:do if(!a){while(1){a=c[5254]|0;c[5254]=a+0;if(!a)break;qc[a&3]();a=ZE(8)|0;if(a)break a}a=yb(4)|0;c[a>>2]=20912;wb(a|0,20960,207)}while(0);d=a;c[d>>2]=0;c[d+4>>2]=0;b[a+4>>1]=1;b[a+6>>1]=-1;c[a>>2]=1128;return a|0}function Ic(a,b,d,e,f,g,h,i){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;return +(+Tb[c[(c[a>>2]|0)+12>>2]&1](a,b,d,e,f,g,h,i))}function Jc(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Kc(a,b){a=a|0;b=b|0;var d=0;c[5132]=(c[5132]|0)+1;d=ZE(95)|0;if(!d)d=0;else{c[(d+19&-16)+-4>>2]=d;d=d+19&-16}Bx(d,a,b,1);return d|0}function Lc(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;hb(a|0)|0;if(qb(20728,3)|0)uE(20736,b);a=ob(c[5180]|0)|0;if(((a|0)!=0?(d=c[a>>2]|0,(d|0)!=0):0)?((c[d+52>>2]|0)==1129074247?(c[d+48>>2]&-256|0)==1126902528:0):0)yE(c[d+12>>2]|0);d=c[5136]|0;c[5136]=d+0;yE(d)}function Mc(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;c[5132]=(c[5132]|0)+1;e=ZE(95)|0;if(!e)e=0;else{c[(e+19&-16)+-4>>2]=e;e=e+19&-16}Bx(e,a,b,d);return e|0}function Nc(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function Oc(a,b,d){a=a|0;b=+b;d=d|0;Sb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function Pc(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Qc(){var a=0;a=ZE(196)|0;a:do if(!a){while(1){a=c[5254]|0;c[5254]=a+0;if(!a)break;qc[a&3]();a=ZE(196)|0;if(a)break a}a=yb(4)|0;c[a>>2]=20912;wb(a|0,20960,207)}while(0);aC(a,0);return a|0}function Rc(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Sc(a){a=a|0;if(!a)return;_E(a);return}function Tc(){var b=0;c[5132]=(c[5132]|0)+1;b=ZE(215)|0;if(!b)b=0;else{c[(b+19&-16)+-4>>2]=b;b=b+19&-16}c[b>>2]=4072;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;a[b+40>>0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;a[b+60>>0]=1;c[b+56>>2]=0;c[b+48>>2]=0;c[b+52>>2]=0;a[b+80>>0]=1;c[b+76>>2]=0;c[b+68>>2]=0;c[b+72>>2]=0;a[b+100>>0]=1;c[b+96>>2]=0;c[b+88>>2]=0;c[b+92>>2]=0;a[b+120>>0]=1;c[b+116>>2]=0;c[b+108>>2]=0;c[b+112>>2]=0;a[b+140>>0]=1;c[b+136>>2]=0;c[b+128>>2]=0;c[b+132>>2]=0;a[b+160>>0]=1;c[b+156>>2]=0;c[b+148>>2]=0;c[b+152>>2]=0;a[b+180>>0]=1;c[b+176>>2]=0;c[b+168>>2]=0;c[b+172>>2]=0;c[b+192>>2]=0;return b|0}function Uc(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Vc(a){a=a|0;return +(+g[a>>2])}function Wc(a,b){a=a|0;b=+b;g[a>>2]=b;return}function Xc(a){a=a|0;return c[a+4>>2]|0}function Yc(a,b){a=a|0;b=b|0;c[a+4>>2]=b;return}function Zc(a){a=a|0;return c[a+8>>2]|0}function _c(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function $c(a){a=a|0;return +(+g[a+12>>2])}function ad(a,b){a=a|0;b=+b;g[a+12>>2]=b;return}function bd(b){b=b|0;return (a[b+16>>0]&1)!=0|0}function cd(b,c){b=b|0;c=c|0;a[b+16>>0]=c&1;return}function dd(b){b=b|0;return (a[b+24>>0]&1)!=0|0}function ed(b,c){b=b|0;c=c|0;a[b+24>>0]=c&1;return}function fd(b){b=b|0;return (a[b+25>>0]&1)!=0|0}function gd(b,c){b=b|0;c=c|0;a[b+25>>0]=c&1;return}function hd(b){b=b|0;return (a[b+26>>0]&1)!=0|0}function id(b,c){b=b|0;c=c|0;a[b+26>>0]=c&1;return}function jd(a){a=a|0;return +(+g[a+28>>2])}function kd(a,b){a=a|0;b=+b;g[a+28>>2]=b;return}function ld(b){b=b|0;return (a[b+32>>0]&1)!=0|0}function md(b,c){b=b|0;c=c|0;a[b+32>>0]=c&1;return}function nd(a){a=a|0;return +(+g[a+36>>2])}function od(a,b){a=a|0;b=+b;g[a+36>>2]=b;return}function pd(a){a=a|0;if(!a)return;_E(a);return}function qd(a,b){a=+a;b=+b;var d=0;c[5132]=(c[5132]|0)+1;d=ZE(75)|0;if(!d)d=0;else{c[(d+19&-16)+-4>>2]=d;d=d+19&-16}c[d+8>>2]=0;g[d+12>>2]=1.0;g[d+16>>2]=1.0;g[d+20>>2]=1.0;g[d+24>>2]=0.0;g[d+44>>2]=.03999999910593033;c[d>>2]=14192;c[d+4>>2]=10;c[d+52>>2]=1;g[d+28>>2]=a;g[d+32>>2]=b*.5;g[d+36>>2]=a;g[d+40>>2]=0.0;return d|0}function rd(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function sd(a,b,d){a=a|0;b=+b;d=d|0;Sb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function td(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function ud(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function vd(a,b){a=a|0;b=b|0;var d=0;c[5132]=(c[5132]|0)+1;d=ZE(135)|0;if(!d)d=0;else{c[(d+19&-16)+-4>>2]=d;d=d+19&-16}VA(d,a,b,16384,0,0);return d|0}function wd(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;c[5132]=(c[5132]|0)+1;e=ZE(135)|0;if(!e)e=0;else{c[(e+19&-16)+-4>>2]=e;e=e+19&-16}VA(e,a,b,d&65535,0,0);return e|0}function xd(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;c[5132]=(c[5132]|0)+1;f=ZE(135)|0;if(!f)f=0;else{c[(f+19&-16)+-4>>2]=f;f=f+19&-16}VA(f,a,b,d&65535,e,0);return f|0}function yd(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0;c[5132]=(c[5132]|0)+1;g=ZE(135)|0;if(!g)g=0;else{c[(g+19&-16)+-4>>2]=g;g=g+19&-16}VA(g,a,b,d&65535,e,f);return g|0}function zd(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Ad(){var b=0,d=0,e=0;c[5132]=(c[5132]|0)+1;b=ZE(307)|0;if(!b)d=0;else{c[(b+19&-16)+-4>>2]=b;d=b+19&-16}g[d+164>>2]=1.0;g[d+168>>2]=1.0;g[d+172>>2]=1.0;g[d+176>>2]=0.0;c[d+180>>2]=0;g[d+184>>2]=999999984306749440.0;b=d+188|0;c[b+0>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;c[d+204>>2]=1;c[d+208>>2]=-1;c[d+212>>2]=-1;c[d+216>>2]=1;g[d+220>>2]=0.0;g[d+224>>2]=.5;g[d+228>>2]=0.0;g[d+232>>2]=0.0;c[d+240>>2]=0;g[d+244>>2]=1.0;b=d+248|0;c[b+0>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;g[d+4>>2]=1.0;b=d+8|0;c[b+0>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;g[d+24>>2]=1.0;b=d+28|0;c[b+0>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;g[d+44>>2]=1.0;b=d+48|0;c[b+0>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;c[b+16>>2]=0;a[d+280>>0]=1;c[d+276>>2]=0;c[d+268>>2]=0;c[d+272>>2]=0;c[d+236>>2]=4;c[d>>2]=5560;c[5132]=(c[5132]|0)+1;b=ZE(95)|0;if(!b){e=0;b=d+284|0;c[b>>2]=e;return d|0}c[(b+19&-16)+-4>>2]=b;if(!(b+19&-16)){b=0;e=d+284|0;c[e>>2]=b;return d|0}FB(b+19&-16);b=b+19&-16;e=d+284|0;c[e>>2]=b;return d|0}function Bd(a,b,d){a=a|0;b=b|0;d=d|0;c[a+164>>2]=c[b+0>>2];c[a+168>>2]=c[b+4>>2];c[a+172>>2]=c[b+8>>2];c[a+176>>2]=c[b+12>>2];if((!(+g[b>>2]!=1.0)?!(+g[b+4>>2]!=1.0):0)?!(+g[b+8>>2]!=1.0):0){d=0;a=a+180|0;c[a>>2]=d;return}a=a+180|0;c[a>>2]=d;return}function Cd(a){a=a|0;return c[a+192>>2]|0}function Dd(a,b){a=a|0;b=+b;g[a+184>>2]=b;return}function Ed(a,b){a=a|0;b=b|0;if((c[a+216>>2]&-2|0)==4)return;c[a+216>>2]=b;return}function Fd(a,b){a=a|0;b=b|0;c[a+216>>2]=b;return}function Gd(a){a=a|0;if(c[a+204>>2]&3)return;if((c[a+216>>2]&-2|0)!=4)c[a+216>>2]=1;g[a+220>>2]=0.0;return}function Hd(a,b){a=a|0;b=b|0;if(!b?(c[a+204>>2]&3|0)!=0:0)return;if((c[a+216>>2]&-2|0)!=4)c[a+216>>2]=1;g[a+220>>2]=0.0;return}function Id(a){a=a|0;a=c[a+216>>2]|0;return ((a|0)==2?0:(a|0)!=5)|0}function Jd(a){a=a|0;return (c[a+204>>2]&2|0)!=0|0}function Kd(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+228>>2]=b;return}function Ld(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+224>>2]=b;return}function Md(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+232>>2]=b;return}function Nd(a){a=a|0;return a+4|0}function Od(a){a=a|0;return c[a+204>>2]|0}function Pd(a,b){a=a|0;b=b|0;c[a+204>>2]=b;return}function Qd(a,b){a=a|0;b=b|0;c[a+260>>2]=(c[a+260>>2]|0)+1;c[a+4>>2]=c[b+0>>2];c[a+8>>2]=c[b+4>>2];c[a+12>>2]=c[b+8>>2];c[a+16>>2]=c[b+12>>2];c[a+20>>2]=c[b+16>>2];c[a+24>>2]=c[b+20>>2];c[a+28>>2]=c[b+24>>2];c[a+32>>2]=c[b+28>>2];c[a+36>>2]=c[b+32>>2];c[a+40>>2]=c[b+36>>2];c[a+44>>2]=c[b+40>>2];c[a+48>>2]=c[b+44>>2];c[a+52>>2]=c[b+48>>2];c[a+56>>2]=c[b+52>>2];c[a+60>>2]=c[b+56>>2];c[a+64>>2]=c[b+60>>2];return}function Rd(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+12>>2]&127](a,b);return}function Sd(a,b){a=a|0;b=+b;g[a+252>>2]=b;return}function Td(a,b){a=a|0;b=+b;g[a+248>>2]=b;return}function Ud(a){a=a|0;return c[a+268>>2]|0}function Vd(a,b){a=a|0;b=b|0;return c[(c[a+276>>2]|0)+(b<<2)>>2]|0}function Wd(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+8>>2]&255](a);return}function Xd(b,d,e){b=+b;d=d|0;e=e|0;var f=0;f=ZE(140)|0;a:do if(!f){while(1){f=c[5254]|0;c[5254]=f+0;if(!f)break;qc[f&3]();f=ZE(140)|0;if(f)break a}e=yb(4)|0;c[e>>2]=20912;wb(e|0,20960,207)}while(0);g[f>>2]=b;c[f+4>>2]=d;c[f+72>>2]=e;e=f+76|0;c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[e+20>>2]=0;g[f+100>>2]=.5;g[f+104>>2]=0.0;g[f+108>>2]=0.0;g[f+112>>2]=.800000011920929;g[f+116>>2]=1.0;a[f+120>>0]=0;g[f+124>>2]=.004999999888241291;g[f+128>>2]=.009999999776482582;g[f+132>>2]=.009999999776482582;g[f+136>>2]=.009999999776482582;Xn(f+8|0);return f|0}function Yd(b,d,e,f){b=+b;d=d|0;e=e|0;f=f|0;var h=0;h=ZE(140)|0;a:do if(!h){while(1){h=c[5254]|0;c[5254]=h+0;if(!h)break;qc[h&3]();h=ZE(140)|0;if(h)break a}f=yb(4)|0;c[f>>2]=20912;wb(f|0,20960,207)}while(0);g[h>>2]=b;c[h+4>>2]=d;c[h+72>>2]=e;e=h+76|0;c[e+0>>2]=c[f+0>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];g[h+92>>2]=0.0;g[h+96>>2]=0.0;g[h+100>>2]=.5;g[h+104>>2]=0.0;g[h+108>>2]=0.0;g[h+112>>2]=.800000011920929;g[h+116>>2]=1.0;a[h+120>>0]=0;g[h+124>>2]=.004999999888241291;g[h+128>>2]=.009999999776482582;g[h+132>>2]=.009999999776482582;g[h+136>>2]=.009999999776482582;Xn(h+8|0);return h|0}function Zd(a){a=a|0;return +(+g[a+92>>2])}function _d(a,b){a=a|0;b=+b;g[a+92>>2]=b;return}function $d(a){a=a|0;return +(+g[a+96>>2])}function ae(a,b){a=a|0;b=+b;g[a+96>>2]=b;return}function be(a){a=a|0;return +(+g[a+100>>2])}function ce(a,b){a=a|0;b=+b;g[a+100>>2]=b;return}function de(a){a=a|0;return +(+g[a+104>>2])}function ee(a,b){a=a|0;b=+b;g[a+104>>2]=b;return}function fe(a){a=a|0;return +(+g[a+108>>2])}function ge(a,b){a=a|0;b=+b;g[a+108>>2]=b;return}function he(a){a=a|0;return +(+g[a+112>>2])}function ie(a,b){a=a|0;b=+b;g[a+112>>2]=b;return}function je(a){a=a|0;return +(+g[a+116>>2])}function ke(a,b){a=a|0;b=+b;g[a+116>>2]=b;return}function le(b){b=b|0;return (a[b+120>>0]&1)!=0|0}function me(b,c){b=b|0;c=c|0;a[b+120>>0]=c&1;return}function ne(a){a=a|0;return +(+g[a+124>>2])}function oe(a,b){a=a|0;b=+b;g[a+124>>2]=b;return}function pe(a){a=a|0;return +(+g[a+128>>2])}function qe(a,b){a=a|0;b=+b;g[a+128>>2]=b;return}function re(a){a=a|0;return +(+g[a+132>>2])}function se(a,b){a=a|0;b=+b;g[a+132>>2]=b;return}function te(a){a=a|0;return +(+g[a+136>>2])}function ue(a,b){a=a|0;b=+b;g[a+136>>2]=b;return}function ve(a){a=a|0;if(!a)return;_E(a);return}function we(a){a=a|0;return a+48|0}function xe(a){a=a|0;return a+32|0}function ye(a){a=a|0;return +(+g[a+80>>2])}function ze(a){a=a|0;return a|0}function Ae(a,b){a=a|0;b=b|0;c[a+0>>2]=c[b+0>>2];c[a+4>>2]=c[b+4>>2];c[a+8>>2]=c[b+8>>2];c[a+12>>2]=c[b+12>>2];return}function Be(a){a=a|0;return a+16|0}function Ce(a,b){a=a|0;b=b|0;c[a+16>>2]=c[b+0>>2];c[a+20>>2]=c[b+4>>2];c[a+24>>2]=c[b+8>>2];c[a+28>>2]=c[b+12>>2];return}function De(a){a=a|0;return a+32|0}function Ee(a,b){a=a|0;b=b|0;c[a+32>>2]=c[b+0>>2];c[a+36>>2]=c[b+4>>2];c[a+40>>2]=c[b+8>>2];c[a+44>>2]=c[b+12>>2];return}function Fe(a){a=a|0;return a+48|0}function Ge(a,b){a=a|0;b=b|0;c[a+48>>2]=c[b+0>>2];c[a+52>>2]=c[b+4>>2];c[a+56>>2]=c[b+8>>2];c[a+60>>2]=c[b+12>>2];return}function He(a){a=a|0;return a+64|0}function Ie(a,b){a=a|0;b=b|0;c[a+64>>2]=c[b+0>>2];c[a+68>>2]=c[b+4>>2];c[a+72>>2]=c[b+8>>2];c[a+76>>2]=c[b+12>>2];return}function Je(a){a=a|0;if(!a)return;_E(a);return}function Ke(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;c[5132]=(c[5132]|0)+1;e=ZE(1331)|0;if(!e)e=0;else{c[(e+19&-16)+-4>>2]=e;e=e+19&-16}Jq(e,a,b,d);return e|0}function Le(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0;c[5132]=(c[5132]|0)+1;g=ZE(1331)|0;if(!g)g=0;else{c[(g+19&-16)+-4>>2]=g;g=g+19&-16}Iq(g,a,b,d,e,f);return g|0}function Me(a,b){a=a|0;b=b|0;c[a+680>>2]=c[b+0>>2];c[a+684>>2]=c[b+4>>2];c[a+688>>2]=c[b+8>>2];c[a+692>>2]=c[b+12>>2];return}function Ne(a,b){a=a|0;b=b|0;c[a+696>>2]=c[b+0>>2];c[a+700>>2]=c[b+4>>2];c[a+704>>2]=c[b+8>>2];c[a+708>>2]=c[b+12>>2];return}function Oe(a,b){a=a|0;b=b|0;var c=0.0,d=0;d=0;while(1){if((d|0)==3)break;c=+$E(+g[b+(d<<2)>>2],6.2831854820251465);if(!(c<-3.1415927410125732)){if(c>3.1415927410125732)c=c+-6.2831854820251465}else c=c+6.2831854820251465;g[a+(d<<6)+868>>2]=c;d=d+1|0}return}function Pe(a,b){a=a|0;b=b|0;var c=0.0,d=0;d=0;while(1){if((d|0)==3)break;c=+$E(+g[b+(d<<2)>>2],6.2831854820251465);if(!(c<-3.1415927410125732)){if(c>3.1415927410125732)c=c+-6.2831854820251465}else c=c+6.2831854820251465;g[a+(d<<6)+872>>2]=c;d=d+1|0}return}function Qe(a){a=a|0;return a+48|0}function Re(b,c){b=b|0;c=c|0;a[b+21>>0]=c&1;return}function Se(a){a=a|0;return +(+g[a+16>>2])}function Te(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function Ue(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Ve(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function We(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Xe(a,b,d){a=a|0;b=b|0;d=d|0;c[a+164>>2]=c[b+0>>2];c[a+168>>2]=c[b+4>>2];c[a+172>>2]=c[b+8>>2];c[a+176>>2]=c[b+12>>2];if((!(+g[b>>2]!=1.0)?!(+g[b+4>>2]!=1.0):0)?!(+g[b+8>>2]!=1.0):0){d=0;a=a+180|0;c[a>>2]=d;return}a=a+180|0;c[a>>2]=d;return}function Ye(a){a=a|0;return c[a+192>>2]|0}function Ze(a,b){a=a|0;b=+b;g[a+184>>2]=b;return}function _e(a,b){a=a|0;b=b|0;if((c[a+216>>2]&-2|0)==4)return;c[a+216>>2]=b;return}function $e(a,b){a=a|0;b=b|0;c[a+216>>2]=b;return}function af(a){a=a|0;if(c[a+204>>2]&3)return;if((c[a+216>>2]&-2|0)!=4)c[a+216>>2]=1;g[a+220>>2]=0.0;return}function bf(a,b){a=a|0;b=b|0;if(!b?(c[a+204>>2]&3|0)!=0:0)return;if((c[a+216>>2]&-2|0)!=4)c[a+216>>2]=1;g[a+220>>2]=0.0;return}function cf(a){a=a|0;a=c[a+216>>2]|0;return ((a|0)==2?0:(a|0)!=5)|0}function df(a){a=a|0;return (c[a+204>>2]&2|0)!=0|0}function ef(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+228>>2]=b;return}function ff(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+224>>2]=b;return}function gf(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+232>>2]=b;return}function hf(a){a=a|0;return a+4|0}function jf(a){a=a|0;return c[a+204>>2]|0}function kf(a,b){a=a|0;b=b|0;c[a+204>>2]=b;return}function lf(a,b){a=a|0;b=b|0;c[a+260>>2]=(c[a+260>>2]|0)+1;c[a+4>>2]=c[b+0>>2];c[a+8>>2]=c[b+4>>2];c[a+12>>2]=c[b+8>>2];c[a+16>>2]=c[b+12>>2];c[a+20>>2]=c[b+16>>2];c[a+24>>2]=c[b+20>>2];c[a+28>>2]=c[b+24>>2];c[a+32>>2]=c[b+28>>2];c[a+36>>2]=c[b+32>>2];c[a+40>>2]=c[b+36>>2];c[a+44>>2]=c[b+40>>2];c[a+48>>2]=c[b+44>>2];c[a+52>>2]=c[b+48>>2];c[a+56>>2]=c[b+52>>2];c[a+60>>2]=c[b+56>>2];c[a+64>>2]=c[b+60>>2];return}function mf(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+12>>2]&127](a,b);return}function nf(a,b){a=a|0;b=+b;g[a+252>>2]=b;return}function of(a,b){a=a|0;b=+b;g[a+248>>2]=b;return}function pf(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+8>>2]&255](a);return}function qf(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,i=0,j=0,k=0;c[5132]=(c[5132]|0)+1;f=ZE(343)|0;if(!f)k=0;else{c[(f+19&-16)+-4>>2]=f;k=f+19&-16}a[k+20>>0]=1;c[k+16>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+24>>2]=b;g[k+28>>2]=0.0;c[k+32>>2]=0;c[k+36>>2]=1;g[k+40>>2]=1.0;a[k+44>>0]=1;c[k+48>>2]=0;a[k+52>>0]=0;a[k+53>>0]=1;a[k+54>>0]=1;g[k+56>>2]=.03999999910593033;a[k+60>>0]=0;g[k+64>>2]=0.0;c[k+68>>2]=d;c[k+72>>2]=0;a[k+76>>0]=1;c[k+80>>2]=0;c[k+84>>2]=0;c[k+88>>2]=0;g[k+92>>2]=.6000000238418579;g[k+96>>2]=1.0;g[k+100>>2]=.30000001192092896;g[k+104>>2]=.01666666753590107;g[k+108>>2]=0.0;g[k+116>>2]=20.0;c[k+112>>2]=10;g[k+124>>2]=.20000000298023224;g[k+128>>2]=.800000011920929;g[k+132>>2]=0.0;g[k+120>>2]=1.0;c[k+136>>2]=1;g[k+140>>2]=-.03999999910593033;g[k+144>>2]=.10000000149011612;g[k+148>>2]=0.0;g[k+152>>2]=.8500000238418579;c[k+156>>2]=260;c[k+160>>2]=2;c[k+164>>2]=128;g[k+168>>2]=100.0;g[k+172>>2]=1000000015047466219876688.0e6;c[k>>2]=1664;a[k+192>>0]=1;c[k+188>>2]=0;c[k+180>>2]=0;c[k+184>>2]=0;i=k+196|0;c[i>>2]=0;j=k+200|0;c[j>>2]=e;a[k+224>>0]=1;c[k+220>>2]=0;c[k+212>>2]=0;c[k+216>>2]=0;a[k+244>>0]=1;c[k+240>>2]=0;c[k+232>>2]=0;c[k+236>>2]=0;g[k+248>>2]=0.0;g[k+252>>2]=-10.0;d=k+256|0;a[k+274>>0]=0;a[k+275>>0]=0;c[d+0>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;a[k+292>>0]=1;c[k+288>>2]=0;c[k+280>>2]=0;c[k+284>>2]=0;c[k+296>>2]=0;a[k+300>>0]=1;a[k+320>>0]=1;c[k+316>>2]=0;c[k+308>>2]=0;c[k+312>>2]=0;if(!e){c[5132]=(c[5132]|0)+1;d=ZE(215)|0;if(!d)d=0;else{c[(d+19&-16)+-4>>2]=d;d=d+19&-16}c[d>>2]=4072;a[d+20>>0]=1;c[d+16>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;a[d+40>>0]=1;c[d+36>>2]=0;c[d+28>>2]=0;c[d+32>>2]=0;a[d+60>>0]=1;c[d+56>>2]=0;c[d+48>>2]=0;c[d+52>>2]=0;a[d+80>>0]=1;c[d+76>>2]=0;c[d+68>>2]=0;c[d+72>>2]=0;a[d+100>>0]=1;c[d+96>>2]=0;c[d+88>>2]=0;c[d+92>>2]=0;a[d+120>>0]=1;c[d+116>>2]=0;c[d+108>>2]=0;c[d+112>>2]=0;a[d+140>>0]=1;c[d+136>>2]=0;c[d+128>>2]=0;c[d+132>>2]=0;a[d+160>>0]=1;c[d+156>>2]=0;c[d+148>>2]=0;c[d+152>>2]=0;a[d+180>>0]=1;c[d+176>>2]=0;c[d+168>>2]=0;c[d+172>>2]=0;c[d+192>>2]=0;c[j>>2]=d;a[k+273>>0]=1}else a[k+273>>0]=0;c[5132]=(c[5132]|0)+1;f=ZE(87)|0;if((f|0)!=0?(h=f+19&-16,c[h+-4>>2]=f,(f+19&-16|0)!=0):0){c[(f+19&-16)>>2]=7016;a[h+20>>0]=1;c[h+16>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;a[h+40>>0]=1;c[h+36>>2]=0;c[h+28>>2]=0;c[h+32>>2]=0;a[h+60>>0]=1;c[h+56>>2]=0;c[h+48>>2]=0;c[h+52>>2]=0;a[h+64>>0]=1;f=f+19&-16}else f=0;c[k+204>>2]=f;a[k+272>>0]=1;c[5132]=(c[5132]|0)+1;f=ZE(107)|0;if(!f){b=0;c[i>>2]=b;return k|0}d=f+19&-16;c[d+-4>>2]=f;if(!(f+19&-16)){b=0;c[i>>2]=b;return k|0}j=c[j>>2]|0;c[(f+19&-16)>>2]=2472;c[d+4>>2]=0;c[d+8>>2]=j;c[d+12>>2]=0;c[d+16>>2]=0;c[d+20>>2]=0;c[d+24>>2]=b;a[d+44>>0]=1;c[d+40>>2]=0;c[d+32>>2]=0;c[d+36>>2]=0;a[d+64>>0]=1;c[d+60>>2]=0;c[d+52>>2]=0;c[d+56>>2]=0;a[d+84>>0]=1;c[d+80>>2]=0;c[d+72>>2]=0;c[d+76>>2]=0;b=f+19&-16;c[i>>2]=b;return k|0}function rf(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+72>>2]&127](a,b);return}function sf(b){b=b|0;var d=0;d=i;i=i+16|0;if((a[24]|0)==0?(Xa(24)|0)!=0:0)ab(24);Lb[c[(c[b>>2]|0)+76>>2]&127](d,b);c[2]=c[d+0>>2];c[3]=c[d+4>>2];c[4]=c[d+8>>2];c[5]=c[d+12>>2];i=d;return 8}function tf(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+84>>2]&127](a,b);return}function uf(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;tc[c[(c[a>>2]|0)+88>>2]&127](a,b,d,e);return}function vf(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+92>>2]&127](a,b);return}function wf(a,b){a=a|0;b=b|0;pc[c[(c[a>>2]|0)+56>>2]&127](a,b,0);return}function xf(a,b,d){a=a|0;b=b|0;d=d|0;pc[c[(c[a>>2]|0)+56>>2]&127](a,b,d);return}function yf(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+60>>2]&127](a,b);return}function zf(a,b){a=a|0;b=+b;return sc[c[(c[a>>2]|0)+52>>2]&1](a,b,1,.01666666753590107)|0}function Af(a,b,d){a=a|0;b=+b;d=d|0;return sc[c[(c[a>>2]|0)+52>>2]&1](a,b,d,.01666666753590107)|0}function Bf(a,b,d,e){a=a|0;b=+b;d=d|0;e=+e;return sc[c[(c[a>>2]|0)+52>>2]&1](a,b,d,e)|0}function Cf(a){a=a|0;return c[a+24>>2]|0}function Df(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;tc[c[(c[a>>2]|0)+32>>2]&127](a,b,d,e);return}function Ef(a){a=a|0;a=c[a+68>>2]|0;return Nb[c[(c[a>>2]|0)+36>>2]&127](a)|0}function Ff(a){a=a|0;return a+28|0}function Gf(a,b){a=a|0;b=b|0;tc[c[(c[a>>2]|0)+36>>2]&127](a,b,2,-3);return}function Hf(a,b,d){a=a|0;b=b|0;d=d|0;tc[c[(c[a>>2]|0)+36>>2]&127](a,b,d,-3);return}function If(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;tc[c[(c[a>>2]|0)+36>>2]&127](a,b,d,e);return}function Jf(a){a=a|0;return c[a+68>>2]|0}function Kf(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=+f;hv(a,b,c,d,e,f);return}function Lf(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;iv(a,b,c,d);return}function Mf(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+64>>2]&127](a,b);return}function Nf(b){b=b|0;var d=0,e=0;if((a[120]|0)==0?(Xa(120)|0)!=0:0){g[8]=.6000000238418579;g[9]=1.0;g[10]=.30000001192092896;g[11]=.01666666753590107;g[12]=0.0;g[14]=20.0;c[13]=10;g[16]=.20000000298023224;g[17]=.800000011920929;g[18]=0.0;g[15]=1.0;c[19]=1;g[20]=-.03999999910593033;g[21]=.10000000149011612;g[22]=0.0;g[23]=.8500000238418579;c[24]=260;c[25]=2;c[26]=128;g[27]=100.0;g[28]=1000000015047466219876688.0e6;ab(120)}e=32;b=b+92|0;d=e+84|0;do{c[e>>2]=c[b>>2];e=e+4|0;b=b+4|0}while((e|0)<(d|0));return 32}function Of(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Pf(b){b=b|0;var d=0;c[5132]=(c[5132]|0)+1;d=ZE(115)|0;if(!d)d=0;else{c[(d+19&-16)+-4>>2]=d;d=d+19&-16}c[d+8>>2]=0;g[d+12>>2]=1.0;g[d+16>>2]=1.0;g[d+20>>2]=1.0;g[d+24>>2]=0.0;g[d+44>>2]=.03999999910593033;c[d+52>>2]=0;g[d+56>>2]=1.0;g[d+60>>2]=1.0;g[d+64>>2]=1.0;g[d+68>>2]=0.0;g[d+72>>2]=-1.0;g[d+76>>2]=-1.0;g[d+80>>2]=-1.0;g[d+84>>2]=0.0;a[d+88>>0]=0;c[d>>2]=14696;c[d+92>>2]=b;c[d+4>>2]=3;xy(d);return d|0}function Qf(b,d){b=b|0;d=d|0;var e=0;c[5132]=(c[5132]|0)+1;e=ZE(115)|0;if(!e)e=0;else{c[(e+19&-16)+-4>>2]=e;e=e+19&-16}c[e+8>>2]=0;g[e+12>>2]=1.0;g[e+16>>2]=1.0;g[e+20>>2]=1.0;g[e+24>>2]=0.0;g[e+44>>2]=.03999999910593033;c[e+52>>2]=0;g[e+56>>2]=1.0;g[e+60>>2]=1.0;g[e+64>>2]=1.0;g[e+68>>2]=0.0;g[e+72>>2]=-1.0;g[e+76>>2]=-1.0;g[e+80>>2]=-1.0;g[e+84>>2]=0.0;a[e+88>>0]=0;c[e>>2]=14696;c[e+92>>2]=b;c[e+4>>2]=3;if(!d)return e|0;xy(e);return e|0}function Rf(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function Sf(a,b,d){a=a|0;b=+b;d=d|0;Sb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function Tf(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Uf(a){a=a|0;return +g[a+4>>2]<1.0|0}function Vf(a){a=a|0;return b[a+8>>1]|0}function Wf(a,c){a=a|0;c=c|0;b[a+8>>1]=c;return}function Xf(a){a=a|0;return b[a+10>>1]|0}function Yf(a,c){a=a|0;c=c|0;b[a+10>>1]=c;return}function Zf(a){a=a|0;return +(+g[a+4>>2])}function _f(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function $f(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function ag(b,d){b=b|0;d=d|0;var e=0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0;c[5132]=(c[5132]|0)+1;e=ZE(379)|0;if(!e)e=0;else{c[(e+19&-16)+-4>>2]=e;e=e+19&-16}c[e+4>>2]=3;c[e>>2]=352;c[e+8>>2]=-1;c[e+12>>2]=-1;g[e+16>>2]=3402823466385288598117041.0e14;a[e+20>>0]=1;a[e+21>>0]=0;c[e+24>>2]=-1;c[e+28>>2]=b;jr();c[e+32>>2]=3056;g[e+36>>2]=0.0;g[e+40>>2]=.30000001192092896;c[e+44>>2]=0;c[e>>2]=2888;l=e+300|0;c[l+0>>2]=c[d+0>>2];c[l+4>>2]=c[d+4>>2];c[l+8>>2]=c[d+8>>2];c[l+12>>2]=c[d+12>>2];k=+g[d>>2];j=+g[d+4>>2];i=+g[d+8>>2];h=k*+g[b+20>>2]+j*+g[b+24>>2]+i*+g[b+28>>2]+ +g[b+56>>2];f=k*+g[b+36>>2]+j*+g[b+40>>2]+i*+g[b+44>>2]+ +g[b+60>>2];g[e+316>>2]=k*+g[b+4>>2]+j*+g[b+8>>2]+i*+g[b+12>>2]+ +g[b+52>>2];g[e+320>>2]=h;g[e+324>>2]=f;g[e+328>>2]=0.0;c[e+332>>2]=0;a[e+344>>0]=0;g[e+348>>2]=.30000001192092896;g[e+352>>2]=1.0;g[e+356>>2]=0.0;return e|0}function bg(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0;c[5132]=(c[5132]|0)+1;h=ZE(379)|0;if(!h)h=0;else{c[(h+19&-16)+-4>>2]=h;h=h+19&-16}c[h+4>>2]=3;c[h+8>>2]=-1;c[h+12>>2]=-1;g[h+16>>2]=3402823466385288598117041.0e14;a[h+20>>0]=1;a[h+21>>0]=0;c[h+24>>2]=-1;c[h+28>>2]=b;c[h+32>>2]=d;g[h+36>>2]=0.0;g[h+40>>2]=.30000001192092896;c[h+44>>2]=0;c[h>>2]=2888;d=h+300|0;c[d+0>>2]=c[e+0>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];e=h+316|0;c[e+0>>2]=c[f+0>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];c[h+332>>2]=0;a[h+344>>0]=0;g[h+348>>2]=.30000001192092896;g[h+352>>2]=1.0;g[h+356>>2]=0.0;return h|0}function cg(a,b){a=a|0;b=b|0;c[a+300>>2]=c[b+0>>2];c[a+304>>2]=c[b+4>>2];c[a+308>>2]=c[b+8>>2];c[a+312>>2]=c[b+12>>2];return}function dg(a,b){a=a|0;b=b|0;c[a+316>>2]=c[b+0>>2];c[a+320>>2]=c[b+4>>2];c[a+324>>2]=c[b+8>>2];c[a+328>>2]=c[b+12>>2];return}function eg(a){a=a|0;return a+300|0}function fg(a){a=a|0;return a+316|0}function gg(b,c){b=b|0;c=c|0;a[b+21>>0]=c&1;return}function hg(a){a=a|0;return +(+g[a+16>>2])}function ig(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function jg(a){a=a|0;return a+348|0}function kg(a,b){a=a|0;b=b|0;c[a+348>>2]=c[b+0>>2];c[a+352>>2]=c[b+4>>2];c[a+356>>2]=c[b+8>>2];return}function lg(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function mg(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+8>>2]&127](a,b);return}function ng(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+12>>2]&127](a,b);return}function og(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function pg(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0,m=0;h=i;i=i+64|0;c[5132]=(c[5132]|0)+1;f=ZE(1147)|0;if(!f)f=0;else{c[(f+19&-16)+-4>>2]=f;f=f+19&-16}jr();c[f+4>>2]=7;c[f+8>>2]=-1;c[f+12>>2]=-1;g[f+16>>2]=3402823466385288598117041.0e14;a[f+20>>0]=1;a[f+21>>0]=0;c[f+24>>2]=-1;k=f+28|0;c[k>>2]=3056;j=f+32|0;c[j>>2]=b;g[f+36>>2]=0.0;g[f+40>>2]=.30000001192092896;c[f+44>>2]=0;c[f>>2]=3688;a[f+48>>0]=0;l=f+116|0;c[l+0>>2]=c[d+0>>2];c[l+4>>2]=c[d+4>>2];c[l+8>>2]=c[d+8>>2];c[l+12>>2]=c[d+12>>2];m=f+132|0;c[m+0>>2]=c[d+16>>2];c[m+4>>2]=c[d+20>>2];c[m+8>>2]=c[d+24>>2];c[m+12>>2]=c[d+28>>2];m=f+148|0;c[m+0>>2]=c[d+32>>2];c[m+4>>2]=c[d+36>>2];c[m+8>>2]=c[d+40>>2];c[m+12>>2]=c[d+44>>2];m=f+164|0;c[m+0>>2]=c[d+48>>2];c[m+4>>2]=c[d+52>>2];c[m+8>>2]=c[d+56>>2];c[m+12>>2]=c[d+60>>2];a[f+180>>0]=e&1;e=f+52|0;rp(h,b+4|0,l);c[e+0>>2]=c[h+0>>2];c[e+4>>2]=c[h+4>>2];c[e+8>>2]=c[h+8>>2];c[e+12>>2]=c[h+12>>2];e=f+68|0;c[e+0>>2]=c[h+16>>2];c[e+4>>2]=c[h+20>>2];c[e+8>>2]=c[h+24>>2];c[e+12>>2]=c[h+28>>2];e=f+84|0;c[e+0>>2]=c[h+32>>2];c[e+4>>2]=c[h+36>>2];c[e+8>>2]=c[h+40>>2];c[e+12>>2]=c[h+44>>2];e=f+100|0;c[e+0>>2]=c[h+48>>2];c[e+4>>2]=c[h+52>>2];c[e+8>>2]=c[h+56>>2];c[e+12>>2]=c[h+60>>2];g[f+184>>2]=1.0;g[f+188>>2]=-1.0;g[f+192>>2]=0.0;g[f+196>>2]=0.0;g[f+200>>2]=1.0;g[f+204>>2]=.699999988079071;g[f+208>>2]=0.0;g[f+212>>2]=0.0;g[f+216>>2]=1.0;g[f+220>>2]=.699999988079071;g[f+224>>2]=0.0;g[f+228>>2]=0.0;g[f+264>>2]=1.0;g[f+268>>2]=.699999988079071;g[f+272>>2]=1.0;g[f+276>>2]=0.0;g[f+280>>2]=1.0;g[f+284>>2]=.699999988079071;g[f+288>>2]=1.0;g[f+292>>2]=0.0;g[f+232>>2]=1.0;g[f+236>>2]=.699999988079071;g[f+240>>2]=1.0;g[f+244>>2]=0.0;g[f+248>>2]=1.0;g[f+252>>2]=.699999988079071;g[f+256>>2]=1.0;g[f+260>>2]=0.0;a[f+1096>>0]=0;e=f+1100|0;g[f+1116>>2]=0.0;g[f+1120>>2]=0.0;g[f+1124>>2]=0.0;c[f+300>>2]=0;c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;a[e+12>>0]=0;a[f+49>>0]=1;lr(f,(c[k>>2]|0)+4|0,(c[j>>2]|0)+4|0);i=h;return f|0}function qg(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0,j=0;c[5132]=(c[5132]|0)+1;i=ZE(1147)|0;if(!i)i=0;else{c[(i+19&-16)+-4>>2]=i;i=i+19&-16}c[i+4>>2]=7;c[i+8>>2]=-1;c[i+12>>2]=-1;g[i+16>>2]=3402823466385288598117041.0e14;a[i+20>>0]=1;a[i+21>>0]=0;c[i+24>>2]=-1;j=i+28|0;c[j>>2]=b;b=i+32|0;c[b>>2]=d;g[i+36>>2]=0.0;g[i+40>>2]=.30000001192092896;c[i+44>>2]=0;c[i>>2]=3688;a[i+48>>0]=0;d=i+52|0;c[d+0>>2]=c[e+0>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];d=i+68|0;c[d+0>>2]=c[e+16>>2];c[d+4>>2]=c[e+20>>2];c[d+8>>2]=c[e+24>>2];c[d+12>>2]=c[e+28>>2];d=i+84|0;c[d+0>>2]=c[e+32>>2];c[d+4>>2]=c[e+36>>2];c[d+8>>2]=c[e+40>>2];c[d+12>>2]=c[e+44>>2];d=i+100|0;c[d+0>>2]=c[e+48>>2];c[d+4>>2]=c[e+52>>2];c[d+8>>2]=c[e+56>>2];c[d+12>>2]=c[e+60>>2];e=i+116|0;c[e+0>>2]=c[f+0>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];e=i+132|0;c[e+0>>2]=c[f+16>>2];c[e+4>>2]=c[f+20>>2];c[e+8>>2]=c[f+24>>2];c[e+12>>2]=c[f+28>>2];e=i+148|0;c[e+0>>2]=c[f+32>>2];c[e+4>>2]=c[f+36>>2];c[e+8>>2]=c[f+40>>2];c[e+12>>2]=c[f+44>>2];e=i+164|0;c[e+0>>2]=c[f+48>>2];c[e+4>>2]=c[f+52>>2];c[e+8>>2]=c[f+56>>2];c[e+12>>2]=c[f+60>>2];a[i+180>>0]=h&1;g[i+184>>2]=1.0;g[i+188>>2]=-1.0;g[i+192>>2]=0.0;g[i+196>>2]=0.0;g[i+200>>2]=1.0;g[i+204>>2]=.699999988079071;g[i+208>>2]=0.0;g[i+212>>2]=0.0;g[i+216>>2]=1.0;g[i+220>>2]=.699999988079071;g[i+224>>2]=0.0;g[i+228>>2]=0.0;g[i+264>>2]=1.0;g[i+268>>2]=.699999988079071;g[i+272>>2]=1.0;g[i+276>>2]=0.0;g[i+280>>2]=1.0;g[i+284>>2]=.699999988079071;g[i+288>>2]=1.0;g[i+292>>2]=0.0;g[i+232>>2]=1.0;g[i+236>>2]=.699999988079071;g[i+240>>2]=1.0;g[i+244>>2]=0.0;g[i+248>>2]=1.0;g[i+252>>2]=.699999988079071;g[i+256>>2]=1.0;g[i+260>>2]=0.0;a[i+1096>>0]=0;h=i+1100|0;g[i+1116>>2]=0.0;g[i+1120>>2]=0.0;g[i+1124>>2]=0.0;c[i+300>>2]=0;c[h+0>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;a[h+12>>0]=0;a[i+49>>0]=1;lr(i,(c[j>>2]|0)+4|0,(c[b>>2]|0)+4|0);return i|0}function rg(a,b){a=a|0;b=+b;g[a+184>>2]=b;return}function sg(a,b){a=a|0;b=+b;g[a+188>>2]=b;return}function tg(a,b){a=a|0;b=+b;b=+$E(b,6.2831854820251465);if(!(b<-3.1415927410125732)){if(b>3.1415927410125732)b=b+-6.2831854820251465}else b=b+6.2831854820251465;g[a+192>>2]=b;return}function ug(a,b){a=a|0;b=+b;b=+$E(b,6.2831854820251465);if(!(b<-3.1415927410125732)){if(b>3.1415927410125732)b=b+-6.2831854820251465}else b=b+6.2831854820251465;g[a+196>>2]=b;return}function vg(b,c){b=b|0;c=c|0;a[b+21>>0]=c&1;return}function wg(a){a=a|0;return +(+g[a+16>>2])}function xg(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function yg(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function zg(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0;c[5132]=(c[5132]|0)+1;e=ZE(627)|0;if(!e)e=0;else{c[(e+19&-16)+-4>>2]=e;e=e+19&-16}c[e+4>>2]=5;c[e>>2]=352;c[e+8>>2]=-1;c[e+12>>2]=-1;g[e+16>>2]=3402823466385288598117041.0e14;a[e+20>>0]=1;a[e+21>>0]=0;c[e+24>>2]=-1;c[e+28>>2]=b;jr();c[e+32>>2]=3056;g[e+36>>2]=0.0;g[e+40>>2]=.30000001192092896;c[e+44>>2]=0;c[e>>2]=3808;h=e+300|0;c[h+0>>2]=c[d+0>>2];c[h+4>>2]=c[d+4>>2];c[h+8>>2]=c[d+8>>2];c[h+12>>2]=c[d+12>>2];f=e+316|0;c[f+0>>2]=c[d+16>>2];c[f+4>>2]=c[d+20>>2];c[f+8>>2]=c[d+24>>2];c[f+12>>2]=c[d+28>>2];b=e+332|0;c[b+0>>2]=c[d+32>>2];c[b+4>>2]=c[d+36>>2];c[b+8>>2]=c[d+40>>2];c[b+12>>2]=c[d+44>>2];i=e+348|0;c[i+0>>2]=c[d+48>>2];c[i+4>>2]=c[d+52>>2];c[i+8>>2]=c[d+56>>2];c[i+12>>2]=c[d+60>>2];d=e+364|0;a[e+527>>0]=0;c[d+0>>2]=c[h+0>>2];c[d+4>>2]=c[h+4>>2];c[d+8>>2]=c[h+8>>2];c[d+12>>2]=c[h+12>>2];d=e+380|0;c[d+0>>2]=c[f+0>>2];c[d+4>>2]=c[f+4>>2];c[d+8>>2]=c[f+8>>2];c[d+12>>2]=c[f+12>>2];d=e+396|0;c[d+0>>2]=c[b+0>>2];c[d+4>>2]=c[b+4>>2];c[d+8>>2]=c[b+8>>2];c[d+12>>2]=c[b+12>>2];d=e+412|0;a[e+524>>0]=0;a[e+525>>0]=0;a[e+526>>0]=0;a[e+552>>0]=0;c[d+0>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;g[e+572>>2]=-1.0;g[e+444>>2]=999999984306749440.0;g[e+448>>2]=999999984306749440.0;g[e+452>>2]=999999984306749440.0;g[e+428>>2]=1.0;g[e+432>>2]=.30000001192092896;g[e+436>>2]=1.0;g[e+440>>2]=.009999999776482582;g[e+456>>2]=.05000000074505806;c[e+592>>2]=0;g[e+596>>2]=0.0;g[e+600>>2]=.699999988079071;g[e+604>>2]=0.0;return e|0}function Ag(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0;c[5132]=(c[5132]|0)+1;h=ZE(627)|0;if(!h)h=0;else{c[(h+19&-16)+-4>>2]=h;h=h+19&-16}c[h+4>>2]=5;c[h+8>>2]=-1;c[h+12>>2]=-1;g[h+16>>2]=3402823466385288598117041.0e14;a[h+20>>0]=1;a[h+21>>0]=0;c[h+24>>2]=-1;c[h+28>>2]=b;c[h+32>>2]=d;g[h+36>>2]=0.0;g[h+40>>2]=.30000001192092896;c[h+44>>2]=0;c[h>>2]=3808;d=h+300|0;c[d+0>>2]=c[e+0>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];d=h+316|0;c[d+0>>2]=c[e+16>>2];c[d+4>>2]=c[e+20>>2];c[d+8>>2]=c[e+24>>2];c[d+12>>2]=c[e+28>>2];d=h+332|0;c[d+0>>2]=c[e+32>>2];c[d+4>>2]=c[e+36>>2];c[d+8>>2]=c[e+40>>2];c[d+12>>2]=c[e+44>>2];d=h+348|0;c[d+0>>2]=c[e+48>>2];c[d+4>>2]=c[e+52>>2];c[d+8>>2]=c[e+56>>2];c[d+12>>2]=c[e+60>>2];e=h+364|0;c[e+0>>2]=c[f+0>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];e=h+380|0;c[e+0>>2]=c[f+16>>2];c[e+4>>2]=c[f+20>>2];c[e+8>>2]=c[f+24>>2];c[e+12>>2]=c[f+28>>2];e=h+396|0;c[e+0>>2]=c[f+32>>2];c[e+4>>2]=c[f+36>>2];c[e+8>>2]=c[f+40>>2];c[e+12>>2]=c[f+44>>2];e=h+412|0;c[e+0>>2]=c[f+48>>2];c[e+4>>2]=c[f+52>>2];c[e+8>>2]=c[f+56>>2];c[e+12>>2]=c[f+60>>2];f=h+524|0;a[h+552>>0]=0;a[f>>0]=0;a[f+1>>0]=0;a[f+2>>0]=0;a[f+3>>0]=0;g[h+572>>2]=-1.0;g[h+444>>2]=999999984306749440.0;g[h+448>>2]=999999984306749440.0;g[h+452>>2]=999999984306749440.0;g[h+428>>2]=1.0;g[h+432>>2]=.30000001192092896;g[h+436>>2]=1.0;g[h+440>>2]=.009999999776482582;g[h+456>>2]=.05000000074505806;c[h+592>>2]=0;g[h+596>>2]=0.0;g[h+600>>2]=.699999988079071;g[h+604>>2]=0.0;return h|0}function Bg(a,b,c){a=a|0;b=b|0;c=+c;if((b|0)==3){g[a+452>>2]=c;return}else if((b|0)==4){g[a+448>>2]=c;return}else if((b|0)==5){g[a+444>>2]=c;return}else return}function Cg(b,c){b=b|0;c=c|0;a[b+524>>0]=c&1;return}function Dg(a,b){a=a|0;b=+b;g[a+440>>2]=b;return}function Eg(b,c){b=b|0;c=c|0;a[b+552>>0]=c&1;return}function Fg(b,c){b=b|0;c=+c;g[b+572>>2]=c;a[b+553>>0]=0;return}function Gg(b,c){b=b|0;c=+c;g[b+572>>2]=c;a[b+553>>0]=1;return}function Hg(a,b){a=a|0;b=b|0;var c=0,d=0.0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0;c=i;i=i+48|0;Fc(a+364|0,c+16|0);h=-+g[c+16>>2];e=-+g[c+20>>2];m=-+g[c+24>>2];l=+g[c+28>>2];f=+g[b>>2];n=+g[b+12>>2];k=+g[b+8>>2];j=+g[b+4>>2];Fc(a+300|0,c);p=+g[c>>2];q=+g[c+12>>2];d=+g[c+8>>2];o=+g[c+4>>2];g[c+32>>2]=p*(l*n-f*h-j*e-k*m)+(l*f+n*h+k*e-j*m)*q+(f*m+(n*e+l*j)-k*h)*d-(n*m+l*k+j*h-f*e)*o;g[c+36>>2]=p*(n*m+l*k+j*h-f*e)+(q*(f*m+(n*e+l*j)-k*h)+(l*n-f*h-j*e-k*m)*o)-(l*f+n*h+k*e-j*m)*d;g[c+40>>2]=q*(n*m+l*k+j*h-f*e)+(l*n-f*h-j*e-k*m)*d+(l*f+n*h+k*e-j*m)*o-p*(f*m+(n*e+l*j)-k*h);g[c+44>>2]=(l*n-f*h-j*e-k*m)*q-p*(l*f+n*h+k*e-j*m)-(f*m+(n*e+l*j)-k*h)*o-(n*m+l*k+j*h-f*e)*d;zr(a,c+32|0);i=c;return}function Ig(a,b){a=a|0;b=b|0;zr(a,b);return}function Jg(b,c){b=b|0;c=c|0;a[b+21>>0]=c&1;return}function Kg(a){a=a|0;return +(+g[a+16>>2])}function Lg(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function Mg(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Ng(a,b){a=+a;b=+b;var d=0;c[5132]=(c[5132]|0)+1;d=ZE(95)|0;if(!d)d=0;else{c[(d+19&-16)+-4>>2]=d;d=d+19&-16}c[d+8>>2]=0;g[d+12>>2]=1.0;g[d+16>>2]=1.0;g[d+20>>2]=1.0;g[d+24>>2]=0.0;g[d+44>>2]=.03999999910593033;c[d>>2]=11656;g[d+56>>2]=a;g[d+60>>2]=b;c[d+4>>2]=11;c[d+64>>2]=0;c[d+68>>2]=1;c[d+72>>2]=2;g[d+28>>2]=a;g[d+32>>2]=b;g[d+36>>2]=a;g[d+52>>2]=a/+P(+(a*a+b*b));return d|0}function Og(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function Pg(a,b,d){a=a|0;b=+b;d=d|0;Sb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function Qg(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Rg(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function Sg(a,b,d){a=a|0;b=+b;d=d|0;Sb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function Tg(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Ug(){var a=0,b=0;b=i;i=i+32|0;a=ZE(92)|0;a:do if(!a){while(1){a=c[5254]|0;c[5254]=a+0;if(!a)break;qc[a&3]();a=ZE(92)|0;if(a)break a}b=yb(4)|0;c[b>>2]=20912;wb(b|0,20960,207)}while(0);c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=4096;c[b+12>>2]=4096;c[b+16>>2]=0;c[b+20>>2]=1;ut(a,b);i=b;return a|0}function Vg(a){a=a|0;var b=0;b=ZE(92)|0;a:do if(!b){while(1){b=c[5254]|0;c[5254]=b+0;if(!b)break;qc[b&3]();b=ZE(92)|0;if(b)break a}a=yb(4)|0;c[a>>2]=20912;wb(a|0,20960,207)}while(0);ut(b,a);return b|0}function Wg(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Xg(a,b,d,e,f,g,h,i){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;return +(+Tb[c[(c[a>>2]|0)+12>>2]&1](a,b,d,e,f,g,h,i))}function Yg(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Zg(a,b){a=+a;b=+b;var d=0;c[5132]=(c[5132]|0)+1;d=ZE(95)|0;if(!d)d=0;else{c[(d+19&-16)+-4>>2]=d;d=d+19&-16}c[d+8>>2]=0;g[d+12>>2]=1.0;g[d+16>>2]=1.0;g[d+20>>2]=1.0;g[d+24>>2]=0.0;g[d+44>>2]=.03999999910593033;g[d+56>>2]=a;g[d+60>>2]=b;c[d+4>>2]=11;g[d+52>>2]=a/+P(+(a*a+b*b));c[d>>2]=11760;c[d+64>>2]=0;c[d+68>>2]=2;c[d+72>>2]=1;g[d+28>>2]=a;g[d+36>>2]=b;g[d+32>>2]=a;return d|0}function _g(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function $g(a,b,d){a=a|0;b=+b;d=d|0;Sb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function ah(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function bh(a,b){a=+a;b=+b;var d=0;c[5132]=(c[5132]|0)+1;d=ZE(95)|0;if(!d)d=0;else{c[(d+19&-16)+-4>>2]=d;d=d+19&-16}c[d+8>>2]=0;g[d+12>>2]=1.0;g[d+16>>2]=1.0;g[d+20>>2]=1.0;g[d+24>>2]=0.0;g[d+44>>2]=.03999999910593033;g[d+56>>2]=a;g[d+60>>2]=b;c[d+4>>2]=11;g[d+52>>2]=a/+P(+(a*a+b*b));c[d>>2]=11864;c[d+64>>2]=1;c[d+68>>2]=0;c[d+72>>2]=2;g[d+32>>2]=a;g[d+28>>2]=b;g[d+36>>2]=a;return d|0}function ch(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function dh(a,b,d){a=a|0;b=+b;d=d|0;Sb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function eh(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function fh(){var a=0;c[5132]=(c[5132]|0)+1;a=ZE(191)|0;if(!a)a=0;else{c[(a+19&-16)+-4>>2]=a;a=a+19&-16}KA(a,1,1);return a|0}function gh(a){a=a|0;var b=0;c[5132]=(c[5132]|0)+1;b=ZE(191)|0;if(!b)b=0;else{c[(b+19&-16)+-4>>2]=b;b=b+19&-16}KA(b,a,1);return b|0}function hh(a,b){a=a|0;b=b|0;var d=0;c[5132]=(c[5132]|0)+1;d=ZE(191)|0;if(!d)d=0;else{c[(d+19&-16)+-4>>2]=d;d=d+19&-16}KA(d,a,b);return d|0}function ih(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=c[a+32>>2]|0;c[f>>2]=(c[f>>2]|0)+1;LA(a,MA(a,b,0)|0);LA(a,MA(a,d,0)|0);LA(a,MA(a,e,0)|0);return}function jh(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0;g=c[a+32>>2]|0;c[g>>2]=(c[g>>2]|0)+1;LA(a,MA(a,b,f)|0);LA(a,MA(a,d,f)|0);LA(a,MA(a,e,f)|0);return}function kh(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function lh(){var b=0;c[5132]=(c[5132]|0)+1;b=ZE(131)|0;if(!b)b=0;else{c[(b+19&-16)+-4>>2]=b;b=b+19&-16}c[b+8>>2]=0;g[b+12>>2]=1.0;g[b+16>>2]=1.0;g[b+20>>2]=1.0;g[b+24>>2]=0.0;g[b+44>>2]=.03999999910593033;c[b+52>>2]=0;g[b+56>>2]=1.0;g[b+60>>2]=1.0;g[b+64>>2]=1.0;g[b+68>>2]=0.0;g[b+72>>2]=-1.0;g[b+76>>2]=-1.0;g[b+80>>2]=-1.0;g[b+84>>2]=0.0;a[b+88>>0]=0;c[b>>2]=13904;a[b+108>>0]=1;c[b+104>>2]=0;c[b+100>>2]=0;c[b+4>>2]=4;c[b+96>>2]=0;xy(b);return b|0}function mh(a,b){a=a|0;b=b|0;Qy(a,b,1);return}function nh(a,b,c){a=a|0;b=b|0;c=c|0;Qy(a,b,c);return}function oh(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function ph(a,b,d){a=a|0;b=+b;d=d|0;Sb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function qh(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function rh(){var b=0,d=0;c[5132]=(c[5132]|0)+1;b=ZE(791)|0;if(!b)b=0;else{c[(b+19&-16)+-4>>2]=b;b=b+19&-16}c[b>>2]=1025;c[b+116>>2]=0;a[b+120>>0]=0;d=b+124|0;c[d+0>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=0;c[d+20>>2]=0;c[d+24>>2]=0;c[d+28>>2]=0;c[b+300>>2]=0;a[b+304>>0]=0;d=b+308|0;c[d+0>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=0;c[d+20>>2]=0;c[d+24>>2]=0;c[d+28>>2]=0;c[b+484>>2]=0;a[b+488>>0]=0;d=b+492|0;c[d+0>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=0;c[d+20>>2]=0;c[d+24>>2]=0;c[d+28>>2]=0;c[b+668>>2]=0;a[b+672>>0]=0;d=b+676|0;c[d+0>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=0;c[d+20>>2]=0;c[d+24>>2]=0;c[d+28>>2]=0;c[b+740>>2]=0;c[b+744>>2]=0;c[b+748>>2]=0;c[b+768>>2]=0;return b|0}function sh(a){a=a|0;return c[a+740>>2]|0}function th(a){a=a|0;return c[a+744>>2]|0}function uh(a){a=a|0;return c[a+748>>2]|0}function vh(a,b){a=a|0;b=b|0;return a+(b*184|0)+4|0}function wh(a){a=a|0;if(!a)return;c[5134]=(c[5134]|0)+1;_E(c[a+-4>>2]|0);return}function xh(a){a=a|0;var b=0,d=0.0,e=0.0,f=0.0,h=0,i=0,j=0,k=0,l=0,m=0,n=0.0,o=0,p=0.0;c[5132]=(c[5132]|0)+1;b=ZE(75)|0;if(!b)l=0;else{c[(b+19&-16)+-4>>2]=b;l=b+19&-16}c[l+8>>2]=0;i=l+12|0;g[i>>2]=1.0;j=l+16|0;g[j>>2]=1.0;k=l+20|0;g[k>>2]=1.0;g[l+24>>2]=0.0;h=l+44|0;g[h>>2]=.03999999910593033;c[l+52>>2]=0;c[l>>2]=15008;c[l+4>>2]=0;d=+g[a>>2];e=+g[a+4>>2];f=+g[a+8>>2];if(d<e)b=d<f?0:2;else b=e<f?1:2;d=+g[a+(b<<2)>>2]*.10000000149011612;if(d<.03999999910593033){p=+Iu(l);n=+Zb[c[(c[l>>2]|0)+48>>2]&15](l);f=+Zb[c[(c[l>>2]|0)+48>>2]&15](l);o=l+28|0;p=p+ +g[o>>2];m=l+32|0;n=n+ +g[m>>2];b=l+36|0;f=f+ +g[b>>2];g[h>>2]=d;d=+Zb[c[(c[l>>2]|0)+48>>2]&15](l);e=+Zb[c[(c[l>>2]|0)+48>>2]&15](l);f=f-+Zb[c[(c[l>>2]|0)+48>>2]&15](l);g[o>>2]=p-d;g[m>>2]=n-e;g[b>>2]=f;g[l+40>>2]=0.0;b=c[l>>2]|0}else b=15008|0;e=+Zb[c[b+48>>2]&15](l);f=+Zb[c[(c[l>>2]|0)+48>>2]&15](l);p=+Zb[c[(c[l>>2]|0)+48>>2]&15](l);f=+g[a+4>>2]*+g[j>>2]-f;p=+g[a+8>>2]*+g[k>>2]-p;g[l+28>>2]=+g[a>>2]*+g[i>>2]-e;g[l+32>>2]=f;g[l+36>>2]=p;g[l+40>>2]=0.0;return l|0}function yh(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function zh(a,b,d){a=a|0;b=+b;d=d|0;Sb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function Ah(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Bh(b){b=b|0;var d=0,e=0,f=0,g=0;d=ZE(5260)|0;a:do if(!d){while(1){d=c[5254]|0;c[5254]=d+0;if(!d)break;qc[d&3]();d=ZE(5260)|0;if(d)break a}f=yb(4)|0;c[f>>2]=20912;wb(f|0,20960,207)}while(0);c[d>>2]=5696;c[d+4>>2]=2;a[d+24>>0]=1;c[d+20>>2]=0;c[d+12>>2]=0;c[d+16>>2]=0;c[d+28>>2]=7984;f=d+5256|0;c[f>>2]=b;c[d+60>>2]=70;c[d+64>>2]=Nb[c[(c[b>>2]|0)+12>>2]&127](b)|0;c[d+68>>2]=Nb[c[(c[b>>2]|0)+8>>2]&127](b)|0;e=0;do{b=0;do{g=c[f>>2]|0;c[d+(e*144|0)+(b<<2)+72>>2]=Wb[c[(c[g>>2]|0)+16>>2]&63](g,e,b)|0;b=b+1|0}while((b|0)<36);e=e+1|0}while((e|0)<36);return d|0}function Ch(a){a=a|0;return Nb[c[(c[a>>2]|0)+36>>2]&127](a)|0}function Dh(a,b){a=a|0;b=b|0;return ec[c[(c[a>>2]|0)+40>>2]&31](a,b)|0}function Eh(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Fh(){var a=0;a=ZE(24)|0;a:do if(!a){while(1){a=c[5254]|0;c[5254]=a+0;if(!a)break;qc[a&3]();a=ZE(24)|0;if(a)break a}a=yb(4)|0;c[a>>2]=20912;wb(a|0,20960,207)}while(0);g[a>>2]=5.880000114440918;g[a+4>>2]=.8299999833106995;g[a+8>>2]=.8799999952316284;g[a+12>>2]=500.0;g[a+16>>2]=10.5;g[a+20>>2]=6.0e3;return a|0}function Gh(a){a=a|0;return +(+g[a>>2])}function Hh(a,b){a=a|0;b=+b;g[a>>2]=b;return}function Ih(a){a=a|0;return +(+g[a+4>>2])}function Jh(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function Kh(a){a=a|0;return +(+g[a+8>>2])}function Lh(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function Mh(a){a=a|0;return +(+g[a+12>>2])}function Nh(a,b){a=a|0;b=+b;g[a+12>>2]=b;return}function Oh(a){a=a|0;return +(+g[a+16>>2])}function Ph(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function Qh(a){a=a|0;return +(+g[a+20>>2])}function Rh(a,b){a=a|0;b=+b;g[a+20>>2]=b;return}function Sh(){var a=0;c[5132]=(c[5132]|0)+1;a=ZE(111)|0;if(!a)a=0;else{c[(a+19&-16)+-4>>2]=a;a=a+19&-16}Nw(a,1);return a|0}function Th(a){a=a|0;var b=0;c[5132]=(c[5132]|0)+1;b=ZE(111)|0;if(!b)b=0;else{c[(b+19&-16)+-4>>2]=b;b=b+19&-16}Nw(b,a);return b|0}function Uh(b,d,e){b=b|0;d=d|0;e=e|0;var f=0.0,h=0,j=0,k=0,l=0,m=0,n=0,o=0.0,p=0,q=0,r=0,s=0;p=i;i=i+128|0;c[b+68>>2]=(c[b+68>>2]|0)+1;c[p+0>>2]=c[d+0>>2];c[p+4>>2]=c[d+4>>2];c[p+8>>2]=c[d+8>>2];c[p+12>>2]=c[d+12>>2];c[p+16>>2]=c[d+16>>2];c[p+20>>2]=c[d+20>>2];c[p+24>>2]=c[d+24>>2];c[p+28>>2]=c[d+28>>2];c[p+32>>2]=c[d+32>>2];c[p+36>>2]=c[d+36>>2];c[p+40>>2]=c[d+40>>2];c[p+44>>2]=c[d+44>>2];c[p+48>>2]=c[d+48>>2];c[p+52>>2]=c[d+52>>2];c[p+56>>2]=c[d+56>>2];c[p+60>>2]=c[d+60>>2];n=c[e+4>>2]|0;o=+Zb[c[(c[e>>2]|0)+48>>2]&15](e);tc[c[(c[e>>2]|0)+8>>2]&127](e,d,p+112|0,p+96|0);f=+g[p+112>>2];if(+g[b+32>>2]>f)g[b+32>>2]=f;f=+g[p+96>>2];if(+g[b+48>>2]<f)g[b+48>>2]=f;f=+g[p+116>>2];if(+g[b+36>>2]>f)g[b+36>>2]=f;f=+g[p+100>>2];if(+g[b+52>>2]<f)g[b+52>>2]=f;f=+g[p+120>>2];if(+g[b+40>>2]>f)g[b+40>>2]=f;f=+g[p+104>>2];if(+g[b+56>>2]<f)g[b+56>>2]=f;l=c[b+64>>2]|0;if(!l){k=b+16|0;l=0}else{c[p+64>>2]=c[p+112>>2];c[p+68>>2]=c[p+116>>2];c[p+72>>2]=c[p+120>>2];c[p+76>>2]=c[p+124>>2];c[p+80>>2]=c[p+96>>2];c[p+84>>2]=c[p+100>>2];c[p+88>>2]=c[p+104>>2];c[p+92>>2]=c[p+108>>2];k=c[b+16>>2]|0;d=c[l+4>>2]|0;if(!d){c[5132]=(c[5132]|0)+1;d=ZE(63)|0;if((d|0)!=0?(c[(d+19&-16)+-4>>2]=d,(d+19&-16|0)!=0):0){h=(d+19&-16)+0|0;j=h+44|0;do{c[h>>2]=0;h=h+4|0}while((h|0)<(j|0));d=d+19&-16}else d=0}else c[l+4>>2]=0;c[d+32>>2]=0;c[d+36>>2]=k;c[d+40>>2]=0;c[d+0>>2]=c[p+64>>2];c[d+4>>2]=c[p+68>>2];c[d+8>>2]=c[p+72>>2];c[d+12>>2]=c[p+76>>2];c[d+16>>2]=c[p+80>>2];c[d+20>>2]=c[p+84>>2];c[d+24>>2]=c[p+88>>2];c[d+28>>2]=c[p+92>>2];NC(l,c[l>>2]|0,d);c[l+12>>2]=(c[l+12>>2]|0)+1;k=b+16|0;l=d}d=c[k>>2]|0;if((d|0)==(c[b+20>>2]|0)?(m=(d|0)==0?1:d<<1,(d|0)<(m|0)):0){if(!m)j=0;else{c[5132]=(c[5132]|0)+1;d=ZE((m*80|3)+16|0)|0;if(!d)d=0;else{c[(d+19&-16)+-4>>2]=d;d=d+19&-16}j=d;d=c[k>>2]|0}if((d|0)>0){h=0;do{q=j+(h*80|0)|0;r=c[b+24>>2]|0;s=r+(h*80|0)|0;c[q+0>>2]=c[s+0>>2];c[q+4>>2]=c[s+4>>2];c[q+8>>2]=c[s+8>>2];c[q+12>>2]=c[s+12>>2];q=j+(h*80|0)+16|0;s=r+(h*80|0)+16|0;c[q+0>>2]=c[s+0>>2];c[q+4>>2]=c[s+4>>2];c[q+8>>2]=c[s+8>>2];c[q+12>>2]=c[s+12>>2];q=j+(h*80|0)+32|0;s=r+(h*80|0)+32|0;c[q+0>>2]=c[s+0>>2];c[q+4>>2]=c[s+4>>2];c[q+8>>2]=c[s+8>>2];c[q+12>>2]=c[s+12>>2];q=j+(h*80|0)+48|0;s=r+(h*80|0)+48|0;c[q+0>>2]=c[s+0>>2];c[q+4>>2]=c[s+4>>2];c[q+8>>2]=c[s+8>>2];c[q+12>>2]=c[s+12>>2];q=j+(h*80|0)+64|0;r=r+(h*80|0)+64|0;c[q+0>>2]=c[r+0>>2];c[q+4>>2]=c[r+4>>2];c[q+8>>2]=c[r+8>>2];c[q+12>>2]=c[r+12>>2];h=h+1|0}while((h|0)!=(d|0))}d=c[b+24>>2]|0;if(d){if(a[b+28>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+24>>2]=0}a[b+28>>0]=1;c[b+24>>2]=j;c[b+20>>2]=m;d=c[k>>2]|0}s=c[b+24>>2]|0;r=s+(d*80|0)|0;c[r+0>>2]=c[p+0>>2];c[r+4>>2]=c[p+4>>2];c[r+8>>2]=c[p+8>>2];c[r+12>>2]=c[p+12>>2];r=s+(d*80|0)+16|0;c[r+0>>2]=c[p+16>>2];c[r+4>>2]=c[p+20>>2];c[r+8>>2]=c[p+24>>2];c[r+12>>2]=c[p+28>>2];r=s+(d*80|0)+32|0;c[r+0>>2]=c[p+32>>2];c[r+4>>2]=c[p+36>>2];c[r+8>>2]=c[p+40>>2];c[r+12>>2]=c[p+44>>2];r=s+(d*80|0)+48|0;c[r+0>>2]=c[p+48>>2];c[r+4>>2]=c[p+52>>2];c[r+8>>2]=c[p+56>>2];c[r+12>>2]=c[p+60>>2];s=s+(d*80|0)+64|0;c[s>>2]=e;c[s+4>>2]=n;g[s+8>>2]=o;c[s+12>>2]=l;c[k>>2]=(c[k>>2]|0)+1;i=p;return}function Vh(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function Wh(a,b,d){a=a|0;b=+b;d=d|0;Sb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function Xh(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Yh(a,d){a=a|0;d=d|0;var e=0,f=0;e=ZE(80)|0;a:do if(!e){while(1){e=c[5254]|0;c[5254]=e+0;if(!e)break;qc[e&3]();e=ZE(80)|0;if(e)break a}d=yb(4)|0;c[d>>2]=20912;wb(d|0,20960,207)}while(0);g[e+4>>2]=1.0;b[e+8>>1]=1;b[e+10>>1]=-1;c[e>>2]=976;f=e+12|0;c[f+0>>2]=c[a+0>>2];c[f+4>>2]=c[a+4>>2];c[f+8>>2]=c[a+8>>2];c[f+12>>2]=c[a+12>>2];a=e+28|0;c[a+0>>2]=c[d+0>>2];c[a+4>>2]=c[d+4>>2];c[a+8>>2]=c[d+8>>2];c[a+12>>2]=c[d+12>>2];c[e+76>>2]=0;return e|0}function Zh(a){a=a|0;return +g[a+4>>2]<1.0|0}function _h(a){a=a|0;return a+12|0}function $h(a,b){a=a|0;b=b|0;c[a+12>>2]=c[b+0>>2];c[a+16>>2]=c[b+4>>2];c[a+20>>2]=c[b+8>>2];c[a+24>>2]=c[b+12>>2];return}function ai(a){a=a|0;return a+28|0}function bi(a,b){a=a|0;b=b|0;c[a+28>>2]=c[b+0>>2];c[a+32>>2]=c[b+4>>2];c[a+36>>2]=c[b+8>>2];c[a+40>>2]=c[b+12>>2];return}function ci(a){a=a|0;return a+44|0}function di(a,b){a=a|0;b=b|0;c[a+44>>2]=c[b+0>>2];c[a+48>>2]=c[b+4>>2];c[a+52>>2]=c[b+8>>2];c[a+56>>2]=c[b+12>>2];return}function ei(a){a=a|0;return a+60|0}function fi(a,b){a=a|0;b=b|0;c[a+60>>2]=c[b+0>>2];c[a+64>>2]=c[b+4>>2];c[a+68>>2]=c[b+8>>2];c[a+72>>2]=c[b+12>>2];return}function gi(a){a=a|0;return b[a+8>>1]|0}function hi(a,c){a=a|0;c=c|0;b[a+8>>1]=c;return}function ii(a){a=a|0;return b[a+10>>1]|0}function ji(a,c){a=a|0;c=c|0;b[a+10>>1]=c;return}function ki(a){a=a|0;return +(+g[a+4>>2])}function li(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function mi(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function ni(){var a=0;c[5132]=(c[5132]|0)+1;a=ZE(219)|0;if(!a)a=0;else{c[(a+19&-16)+-4>>2]=a;a=a+19&-16}oi();oi();pi(a,840,840);return a|0}function oi(){if(a[904]|0)return;if(!(Xa(904)|0))return;if((a[960]|0)==0?(Xa(960)|0)!=0:0){g[228]=1.0;c[229]=0;c[230]=0;c[231]=0;c[232]=0;g[233]=1.0;c[234]=0;c[235]=0;c[236]=0;c[237]=0;g[238]=1.0;g[239]=0.0;ab(960)};c[210]=c[228];c[211]=c[229];c[212]=c[230];c[213]=c[231];c[214]=c[232];c[215]=c[233];c[216]=c[234];c[217]=c[235];c[218]=c[236];c[219]=c[237];c[220]=c[238];c[221]=c[239];c[222]=0;c[223]=0;c[224]=0;c[225]=0;ab(904);return}function pi(a,b,d){a=a|0;b=b|0;d=d|0;c[a>>2]=760;c[a+4>>2]=c[b+0>>2];c[a+8>>2]=c[b+4>>2];c[a+12>>2]=c[b+8>>2];c[a+16>>2]=c[b+12>>2];c[a+20>>2]=c[b+16>>2];c[a+24>>2]=c[b+20>>2];c[a+28>>2]=c[b+24>>2];c[a+32>>2]=c[b+28>>2];c[a+36>>2]=c[b+32>>2];c[a+40>>2]=c[b+36>>2];c[a+44>>2]=c[b+40>>2];c[a+48>>2]=c[b+44>>2];c[a+52>>2]=c[b+48>>2];c[a+56>>2]=c[b+52>>2];c[a+60>>2]=c[b+56>>2];c[a+64>>2]=c[b+60>>2];c[a+68>>2]=c[d+0>>2];c[a+72>>2]=c[d+4>>2];c[a+76>>2]=c[d+8>>2];c[a+80>>2]=c[d+12>>2];c[a+84>>2]=c[d+16>>2];c[a+88>>2]=c[d+20>>2];c[a+92>>2]=c[d+24>>2];c[a+96>>2]=c[d+28>>2];c[a+100>>2]=c[d+32>>2];c[a+104>>2]=c[d+36>>2];c[a+108>>2]=c[d+40>>2];c[a+112>>2]=c[d+44>>2];c[a+116>>2]=c[d+48>>2];c[a+120>>2]=c[d+52>>2];c[a+124>>2]=c[d+56>>2];c[a+128>>2]=c[d+60>>2];c[a+132>>2]=c[b+0>>2];c[a+136>>2]=c[b+4>>2];c[a+140>>2]=c[b+8>>2];c[a+144>>2]=c[b+12>>2];c[a+148>>2]=c[b+16>>2];c[a+152>>2]=c[b+20>>2];c[a+156>>2]=c[b+24>>2];c[a+160>>2]=c[b+28>>2];c[a+164>>2]=c[b+32>>2];c[a+168>>2]=c[b+36>>2];c[a+172>>2]=c[b+40>>2];c[a+176>>2]=c[b+44>>2];c[a+180>>2]=c[b+48>>2];c[a+184>>2]=c[b+52>>2];c[a+188>>2]=c[b+56>>2];c[a+192>>2]=c[b+60>>2];c[a+196>>2]=0;return}function qi(a){a=a|0;var b=0;c[5132]=(c[5132]|0)+1;b=ZE(219)|0;if(!b)b=0;else{c[(b+19&-16)+-4>>2]=b;b=b+19&-16}oi();pi(b,a,840);return b|0}function ri(a,b){a=a|0;b=b|0;var d=0;c[5132]=(c[5132]|0)+1;d=ZE(219)|0;if(!d)d=0;else{c[(d+19&-16)+-4>>2]=d;d=d+19&-16}pi(d,a,b);return d|0}function si(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+8>>2]&127](a,b);return}function ti(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+12>>2]&127](a,b);return}function ui(a){a=a|0;return a+4|0}function vi(a,b){a=a|0;b=b|0;c[a+4>>2]=c[b+0>>2];c[a+8>>2]=c[b+4>>2];c[a+12>>2]=c[b+8>>2];c[a+16>>2]=c[b+12>>2];c[a+20>>2]=c[b+16>>2];c[a+24>>2]=c[b+20>>2];c[a+28>>2]=c[b+24>>2];c[a+32>>2]=c[b+28>>2];c[a+36>>2]=c[b+32>>2];c[a+40>>2]=c[b+36>>2];c[a+44>>2]=c[b+40>>2];c[a+48>>2]=c[b+44>>2];c[a+52>>2]=c[b+48>>2];c[a+56>>2]=c[b+52>>2];c[a+60>>2]=c[b+56>>2];c[a+64>>2]=c[b+60>>2];return}function wi(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function xi(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function yi(a,b,d){a=a|0;b=+b;d=d|0;Sb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function zi(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Ai(a){a=a|0;return Nb[c[(c[a>>2]|0)+36>>2]&127](a)|0}function Bi(a,b){a=a|0;b=b|0;return ec[c[(c[a>>2]|0)+40>>2]&31](a,b)|0}function Ci(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Di(a,d){a=a|0;d=d|0;var e=0,f=0;e=ZE(84)|0;a:do if(!e){while(1){e=c[5254]|0;c[5254]=e+0;if(!e)break;qc[e&3]();e=ZE(84)|0;if(e)break a}d=yb(4)|0;c[d>>2]=20912;wb(d|0,20960,207)}while(0);g[e+4>>2]=1.0;c[e+8>>2]=0;b[e+12>>1]=1;b[e+14>>1]=-1;c[e+16>>2]=0;c[e>>2]=624;f=e+20|0;c[f+0>>2]=c[a+0>>2];c[f+4>>2]=c[a+4>>2];c[f+8>>2]=c[a+8>>2];c[f+12>>2]=c[a+12>>2];a=e+36|0;c[a+0>>2]=c[d+0>>2];c[a+4>>2]=c[d+4>>2];c[a+8>>2]=c[d+8>>2];c[a+12>>2]=c[d+12>>2];return e|0}function Ei(a){a=a|0;return (c[a+8>>2]|0)!=0|0}function Fi(a){a=a|0;return a+20|0}function Gi(a,b){a=a|0;b=b|0;c[a+20>>2]=c[b+0>>2];c[a+24>>2]=c[b+4>>2];c[a+28>>2]=c[b+8>>2];c[a+32>>2]=c[b+12>>2];return}function Hi(a){a=a|0;return a+36|0}function Ii(a,b){a=a|0;b=b|0;c[a+36>>2]=c[b+0>>2];c[a+40>>2]=c[b+4>>2];c[a+44>>2]=c[b+8>>2];c[a+48>>2]=c[b+12>>2];return}function Ji(a){a=a|0;return a+52|0}function Ki(a,b){a=a|0;b=b|0;c[a+52>>2]=c[b+0>>2];c[a+56>>2]=c[b+4>>2];c[a+60>>2]=c[b+8>>2];c[a+64>>2]=c[b+12>>2];return}function Li(a){a=a|0;return a+68|0}function Mi(a,b){a=a|0;b=b|0;c[a+68>>2]=c[b+0>>2];c[a+72>>2]=c[b+4>>2];c[a+76>>2]=c[b+8>>2];c[a+80>>2]=c[b+12>>2];return}function Ni(a){a=a|0;return b[a+12>>1]|0}function Oi(a,c){a=a|0;c=c|0;b[a+12>>1]=c;return}function Pi(a){a=a|0;return b[a+14>>1]|0}function Qi(a,c){a=a|0;c=c|0;b[a+14>>1]=c;return}function Ri(a){a=a|0;return c[a+8>>2]|0}function Si(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function Ti(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Ui(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+64>>2]&127](a,b);return}function Vi(b){b=b|0;var d=0,e=0;if((a[216]|0)==0?(Xa(216)|0)!=0:0){g[32]=.6000000238418579;g[33]=1.0;g[34]=.30000001192092896;g[35]=.01666666753590107;g[36]=0.0;g[38]=20.0;c[37]=10;g[40]=.20000000298023224;g[41]=.800000011920929;g[42]=0.0;g[39]=1.0;c[43]=1;g[44]=-.03999999910593033;g[45]=.10000000149011612;g[46]=0.0;g[47]=.8500000238418579;c[48]=260;c[49]=2;c[50]=128;g[51]=100.0;g[52]=1000000015047466219876688.0e6;ab(216)}e=128;b=b+92|0;d=e+84|0;do{c[e>>2]=c[b>>2];e=e+4|0;b=b+4|0}while((e|0)<(d|0));return 128}function Wi(a){a=a|0;return c[a+24>>2]|0}function Xi(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;tc[c[(c[a>>2]|0)+32>>2]&127](a,b,d,e);return}function Yi(a){a=a|0;a=c[a+68>>2]|0;return Nb[c[(c[a>>2]|0)+36>>2]&127](a)|0}function Zi(a){a=a|0;return a+28|0}function _i(a,b){a=a|0;b=b|0;tc[c[(c[a>>2]|0)+36>>2]&127](a,b,1,-1);return}function $i(a,b,d){a=a|0;b=b|0;d=d|0;tc[c[(c[a>>2]|0)+36>>2]&127](a,b,d,-1);return}function aj(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;tc[c[(c[a>>2]|0)+36>>2]&127](a,b,d,e);return}function bj(a){a=a|0;return c[a+68>>2]|0}function cj(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=+f;hv(a,b,c,d,e,f);return}function dj(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;iv(a,b,c,d);return}function ej(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function fj(a,b){a=+a;b=+b;var d=0;c[5132]=(c[5132]|0)+1;d=ZE(75)|0;if(!d)d=0;else{c[(d+19&-16)+-4>>2]=d;d=d+19&-16}c[d+8>>2]=0;g[d+12>>2]=1.0;g[d+16>>2]=1.0;g[d+20>>2]=1.0;g[d+24>>2]=0.0;g[d+44>>2]=.03999999910593033;c[d+4>>2]=10;c[d>>2]=14296;c[d+52>>2]=0;g[d+28>>2]=b*.5;g[d+32>>2]=a;g[d+36>>2]=a;g[d+40>>2]=0.0;return d|0}function gj(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function hj(a,b,d){a=a|0;b=+b;d=d|0;Sb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function ij(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function jj(a,b,d,e){a=+a;b=+b;d=+d;e=+e;var f=0;f=ZE(16)|0;a:do if(!f){while(1){f=c[5254]|0;c[5254]=f+0;if(!f)break;qc[f&3]();f=ZE(16)|0;if(f)break a}f=yb(4)|0;c[f>>2]=20912;wb(f|0,20960,207)}while(0);g[f>>2]=a;g[f+4>>2]=b;g[f+8>>2]=d;g[f+12>>2]=e;return f|0}function kj(a,b,c,d,e){a=a|0;b=+b;c=+c;d=+d;e=+e;g[a>>2]=b;g[a+4>>2]=c;g[a+8>>2]=d;g[a+12>>2]=e;return}function lj(a){a=a|0;return +(+g[a>>2])}function mj(a){a=a|0;return +(+g[a+4>>2])}function nj(a){a=a|0;return +(+g[a+8>>2])}function oj(a){a=a|0;return +(+g[a+12>>2])}function pj(a,b){a=a|0;b=+b;g[a>>2]=b;return}function qj(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function rj(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function sj(a,b){a=a|0;b=+b;g[a+12>>2]=b;return}function tj(a){a=a|0;if(!a)return;_E(a);return}function uj(a,b){a=+a;b=+b;var d=0;c[5132]=(c[5132]|0)+1;d=ZE(75)|0;if(!d)d=0;else{c[(d+19&-16)+-4>>2]=d;d=d+19&-16}c[d+8>>2]=0;g[d+12>>2]=1.0;g[d+16>>2]=1.0;g[d+20>>2]=1.0;g[d+24>>2]=0.0;g[d+44>>2]=.03999999910593033;c[d+4>>2]=10;c[d>>2]=14400;c[d+52>>2]=2;g[d+28>>2]=a;g[d+32>>2]=a;g[d+36>>2]=b*.5;g[d+40>>2]=0.0;return d|0}function vj(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function wj(a,b,d){a=a|0;b=+b;d=d|0;Sb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function xj(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function yj(a){a=a|0;var b=0;b=ZE(8)|0;a:do if(!b){while(1){b=c[5254]|0;c[5254]=b+0;if(!b)break;qc[b&3]();b=ZE(8)|0;if(b)break a}a=yb(4)|0;c[a>>2]=20912;wb(a|0,20960,207)}while(0);c[b>>2]=5048;c[b+4>>2]=a;return b|0}function zj(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Aj(a){a=a|0;return (c[a+8>>2]|0)!=0|0}function Bj(a){a=a|0;return b[a+12>>1]|0}function Cj(a,c){a=a|0;c=c|0;b[a+12>>1]=c;return}function Dj(a){a=a|0;return b[a+14>>1]|0}function Ej(a,c){a=a|0;c=c|0;b[a+14>>1]=c;return}function Fj(a){a=a|0;return c[a+8>>2]|0}function Gj(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function Hj(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Ij(a){a=a|0;return +(+g[a+216>>2])}function Jj(a,b){a=a|0;b=+b;g[a+216>>2]=b;return}function Kj(a){a=a|0;return +(+g[a+228>>2])}function Lj(a,b){a=a|0;b=+b;g[a+228>>2]=b;return}function Mj(a){a=a|0;return +(+g[a+244>>2])}function Nj(a,b){a=a|0;b=+b;g[a+244>>2]=b;return}function Oj(a){a=a|0;return +(+g[a+204>>2])}function Pj(a,b){a=a|0;b=+b;g[a+204>>2]=b;return}function Qj(a){a=a|0;return +(+g[a+212>>2])}function Rj(a,b){a=a|0;b=+b;g[a+212>>2]=b;return}function Sj(a){a=a|0;return +(+g[a+220>>2])}function Tj(a,b){a=a|0;b=+b;g[a+220>>2]=b;return}function Uj(a){a=a|0;return +(+g[a+224>>2])}function Vj(a,b){a=a|0;b=+b;g[a+224>>2]=b;return}function Wj(a){a=a|0;return +(+g[a+232>>2])}function Xj(a,b){a=a|0;b=+b;g[a+232>>2]=b;return}function Yj(a){a=a|0;return +(+g[a+248>>2])}function Zj(a,b){a=a|0;b=+b;g[a+248>>2]=b;return}function _j(a){a=a|0;return +(+g[a+208>>2])}function $j(a,b){a=a|0;b=+b;g[a+208>>2]=b;return}function ak(a){a=a|0;return +(+g[a+276>>2])}function bk(a,b){a=a|0;b=+b;g[a+276>>2]=b;return}function ck(b){b=b|0;return (a[b+260>>0]&1)!=0|0}function dk(b,c){b=b|0;c=c|0;a[b+260>>0]=c&1;return}function ek(a){a=a|0;return a+156|0}function fk(a,b){a=a|0;b=b|0;c[a+156>>2]=c[b+0>>2];c[a+160>>2]=c[b+4>>2];c[a+164>>2]=c[b+8>>2];c[a+168>>2]=c[b+12>>2];return}function gk(a){a=a|0;if(!a)return;_E(a);return}function hk(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function ik(a,b,d){a=a|0;b=+b;d=d|0;Sb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function jk(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function kk(){var a=0;c[5132]=(c[5132]|0)+1;a=ZE(35)|0;if(!a){a=0;return a|0}c[(a+19&-16)+-4>>2]=a;a=a+19&-16;return a|0}function lk(a,b,d,e){a=+a;b=+b;d=+d;e=+e;var f=0;c[5132]=(c[5132]|0)+1;f=ZE(35)|0;if(!f)f=0;else{c[(f+19&-16)+-4>>2]=f;f=f+19&-16}g[f>>2]=a;g[f+4>>2]=b;g[f+8>>2]=d;g[f+12>>2]=e;return f|0}function mk(a){a=a|0;return +(+g[a+12>>2])}function nk(a,b,c,d,e){a=a|0;b=+b;c=+c;d=+d;e=+e;g[a>>2]=b;g[a+4>>2]=c;g[a+8>>2]=d;g[a+12>>2]=e;return}function ok(a){a=a|0;var b=0.0,c=0.0,d=0.0;d=+g[a>>2];c=+g[a+4>>2];b=+g[a+8>>2];return +(+P(+(d*d+c*c+b*b)))}function pk(a){a=a|0;return +(+g[a>>2])}function qk(a){a=a|0;return +(+g[a+4>>2])}function rk(a){a=a|0;return +(+g[a+8>>2])}function sk(a,b){a=a|0;b=+b;g[a>>2]=b;return}function tk(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function uk(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function vk(a,b){a=a|0;b=+b;g[a>>2]=+g[a>>2]*b;g[a+4>>2]=+g[a+4>>2]*b;g[a+8>>2]=+g[a+8>>2]*b;return a|0}function wk(a){a=a|0;var b=0.0,c=0.0,d=0.0,e=0.0;e=+g[a>>2];d=+g[a+4>>2];c=+g[a+8>>2];b=1.0/+P(+(e*e+d*d+c*c));g[a>>2]=e*b;g[a+4>>2]=d*b;g[a+8>>2]=c*b;return a|0}function xk(a){a=a|0;if(!a)return;c[5134]=(c[5134]|0)+1;_E(c[a+-4>>2]|0);return}function yk(b,d,e){b=b|0;d=d|0;e=+e;var f=0,h=0;c[5132]=(c[5132]|0)+1;f=ZE(203)|0;if(!f)f=0;else{c[(f+19&-16)+-4>>2]=f;f=f+19&-16}c[f>>2]=5120;a[f+144>>0]=1;c[f+140>>2]=0;c[f+132>>2]=0;c[f+136>>2]=0;c[f+176>>2]=1;g[f+56>>2]=.019999999552965164;h=f+60|0;c[h+0>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;a[f+170>>0]=1;c[f+8>>2]=b;g[f+52>>2]=e;g[f+48>>2]=0.0;c[f+12>>2]=d;a[f+171>>0]=1;g[f+172>>2]=0.0;g[f+16>>2]=0.0;g[f+20>>2]=0.0;g[f+44>>2]=29.399999618530273;g[f+24>>2]=55.0;g[f+28>>2]=10.0;a[f+168>>0]=0;a[f+169>>0]=0;a[f+180>>0]=1;g[f+36>>2]=.7853981852531433;g[f+40>>2]=.7071067690849304;g[f+108>>2]=0.0;a[f+181>>0]=0;a[f+182>>0]=0;return f|0}function zk(b,d,e,f){b=b|0;d=d|0;e=+e;f=f|0;var h=0;c[5132]=(c[5132]|0)+1;h=ZE(203)|0;if(!h)h=0;else{c[(h+19&-16)+-4>>2]=h;h=h+19&-16}c[h>>2]=5120;a[h+144>>0]=1;c[h+140>>2]=0;c[h+132>>2]=0;c[h+136>>2]=0;c[h+176>>2]=f;g[h+56>>2]=.019999999552965164;f=h+60|0;c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;a[h+170>>0]=1;c[h+8>>2]=b;g[h+52>>2]=e;g[h+48>>2]=0.0;c[h+12>>2]=d;a[h+171>>0]=1;g[h+172>>2]=0.0;g[h+16>>2]=0.0;g[h+20>>2]=0.0;g[h+44>>2]=29.399999618530273;g[h+24>>2]=55.0;g[h+28>>2]=10.0;a[h+168>>0]=0;a[h+169>>0]=0;a[h+180>>0]=1;g[h+36>>2]=.7853981852531433;g[h+40>>2]=.7071067690849304;g[h+108>>2]=0.0;a[h+181>>0]=0;a[h+182>>0]=0;return h|0}function Ak(a,b){a=a|0;b=b|0;if((b|0)<0)b=0;else b=(b|0)>2?2:b;c[a+176>>2]=b;return}function Bk(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+16>>2]&127](a,b);return}function Ck(a,b,d){a=a|0;b=b|0;d=+d;rc[c[(c[a>>2]|0)+20>>2]&7](a,b,d);return}function Dk(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+28>>2]&127](a,b);return}function Ek(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+32>>2]&127](a,b);return}function Fk(a,b,d){a=a|0;b=b|0;d=+d;rc[c[(c[a>>2]|0)+36>>2]&7](a,b,d);return}function Gk(a,b){a=a|0;b=+b;g[a+24>>2]=b;return}function Hk(a,b){a=a|0;b=+b;g[a+28>>2]=b;return}function Ik(a,b){a=a|0;b=+b;g[a+32>>2]=b;return}function Jk(a){a=a|0;return Nb[c[(c[a>>2]|0)+40>>2]&127](a)|0}function Kk(a){a=a|0;Jb[c[(c[a>>2]|0)+44>>2]&255](a);return}function Lk(a,b){a=a|0;b=+b;g[a+44>>2]=b;return}function Mk(a){a=a|0;return +(+g[a+44>>2])}function Nk(a,b){a=a|0;b=+b;g[a+36>>2]=b;g[a+40>>2]=+R(+b);return}function Ok(a){a=a|0;return +(+g[a+36>>2])}function Pk(a){a=a|0;return c[a+8>>2]|0}function Qk(b,c){b=b|0;c=c|0;a[b+170>>0]=c&1;return}function Rk(a){a=a|0;return Nb[c[(c[a>>2]|0)+48>>2]&127](a)|0}function Sk(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Tk(a,b){a=a|0;b=+b;var d=0,e=0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;c[5132]=(c[5132]|0)+1;d=ZE(103)|0;if(!d)d=0;else{c[(d+19&-16)+-4>>2]=d;d=d+19&-16}e=d+4|0;c[e>>2]=35;c[d+8>>2]=0;g[d+12>>2]=0.0;c[d>>2]=13272;k=+g[a>>2];j=+g[a+4>>2];i=+g[a+8>>2];f=+g[a+12>>2];h=1.0/+P(+(k*k+j*j+i*i));g[d+48>>2]=k*h;g[d+52>>2]=j*h;g[d+56>>2]=i*h;g[d+60>>2]=f;g[d+64>>2]=b;a=d+68|0;c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;c[e>>2]=28;return d|0}function Uk(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function Vk(a,b,d){a=a|0;b=+b;d=d|0;Sb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function Wk(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Xk(a){a=a|0;return (c[a+44>>2]|0)!=0|0}function Yk(a,b){a=a|0;b=b|0;c[a+44>>2]=b&1;return}function Zk(a){a=a|0;return ~~+g[a+48>>2]|0}function _k(a,b){a=a|0;b=b|0;g[a+48>>2]=+(b|0);return}function $k(a){a=a|0;if(!a)return;_E(a);return}function al(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+60>>2]&127](a,b);return}function bl(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function cl(){var a=0;c[5132]=(c[5132]|0)+1;a=ZE(35)|0;if(!a){a=0;return a|0}c[(a+19&-16)+-4>>2]=a;a=a+19&-16;return a|0}function dl(a,b,d){a=+a;b=+b;d=+d;var e=0;c[5132]=(c[5132]|0)+1;e=ZE(35)|0;if(!e)e=0;else{c[(e+19&-16)+-4>>2]=e;e=e+19&-16}g[e>>2]=a;g[e+4>>2]=b;g[e+8>>2]=d;g[e+12>>2]=0.0;return e|0}function el(a){a=a|0;var b=0.0,c=0.0,d=0.0;d=+g[a>>2];c=+g[a+4>>2];b=+g[a+8>>2];return +(+P(+(d*d+c*c+b*b)))}function fl(a){a=a|0;return +(+g[a>>2])}function gl(a){a=a|0;return +(+g[a+4>>2])}function hl(a){a=a|0;return +(+g[a+8>>2])}function il(a,b){a=a|0;b=+b;g[a>>2]=b;return}function jl(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function kl(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function ll(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;g[a>>2]=b;g[a+4>>2]=c;g[a+8>>2]=d;g[a+12>>2]=0.0;return}function ml(a,b){a=a|0;b=+b;g[a>>2]=+g[a>>2]*b;g[a+4>>2]=+g[a+4>>2]*b;g[a+8>>2]=+g[a+8>>2]*b;return a|0}function nl(a){a=a|0;var b=0.0,c=0.0,d=0.0,e=0.0;e=+g[a>>2];d=+g[a+4>>2];c=+g[a+8>>2];b=1.0/+P(+(e*e+d*d+c*c));g[a>>2]=e*b;g[a+4>>2]=d*b;g[a+8>>2]=c*b;return a|0}function ol(a){a=a|0;if(!a)return;c[5134]=(c[5134]|0)+1;_E(c[a+-4>>2]|0);return}function pl(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function ql(a){a=+a;var b=0;c[5132]=(c[5132]|0)+1;b=ZE(71)|0;if(!b)b=0;else{c[(b+19&-16)+-4>>2]=b;b=b+19&-16}c[b+8>>2]=0;g[b+12>>2]=1.0;g[b+16>>2]=1.0;g[b+20>>2]=1.0;g[b+24>>2]=0.0;c[b>>2]=12104;c[b+4>>2]=8;g[b+28>>2]=a;g[b+44>>2]=a;return b|0}function rl(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function sl(a,b,d){a=a|0;b=+b;d=d|0;Sb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function tl(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function ul(){var a=0;a=ZE(24)|0;a:do if(!a){while(1){a=c[5254]|0;c[5254]=a+0;if(!a)break;qc[a&3]();a=ZE(24)|0;if(a)break a}a=yb(4)|0;c[a>>2]=20912;wb(a|0,20960,207)}while(0);c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=4096;c[a+12>>2]=4096;c[a+16>>2]=0;c[a+20>>2]=1;return a|0}function vl(a){a=a|0;if(!a)return;_E(a);return}function wl(a,b){a=a|0;b=b|0;var d=0;c[5132]=(c[5132]|0)+1;d=ZE(783)|0;if(!d)d=0;else{c[(d+19&-16)+-4>>2]=d;d=d+19&-16}Hr(d,a,b,0);return d|0}function xl(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;c[5132]=(c[5132]|0)+1;e=ZE(783)|0;if(!e)e=0;else{c[(e+19&-16)+-4>>2]=e;e=e+19&-16}Hr(e,a,b,d);return e|0}function yl(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0;c[5132]=(c[5132]|0)+1;h=ZE(783)|0;if(!h)h=0;else{c[(h+19&-16)+-4>>2]=h;h=h+19&-16}c[h+4>>2]=4;c[h+8>>2]=-1;c[h+12>>2]=-1;g[h+16>>2]=3402823466385288598117041.0e14;a[h+20>>0]=1;a[h+21>>0]=0;c[h+24>>2]=-1;c[h+28>>2]=b;c[h+32>>2]=d;g[h+36>>2]=0.0;g[h+40>>2]=.30000001192092896;c[h+44>>2]=0;c[h>>2]=3936;d=h+552|0;c[d+0>>2]=c[e+0>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];d=h+568|0;c[d+0>>2]=c[e+16>>2];c[d+4>>2]=c[e+20>>2];c[d+8>>2]=c[e+24>>2];c[d+12>>2]=c[e+28>>2];d=h+584|0;c[d+0>>2]=c[e+32>>2];c[d+4>>2]=c[e+36>>2];c[d+8>>2]=c[e+40>>2];c[d+12>>2]=c[e+44>>2];d=h+600|0;c[d+0>>2]=c[e+48>>2];c[d+4>>2]=c[e+52>>2];c[d+8>>2]=c[e+56>>2];c[d+12>>2]=c[e+60>>2];e=h+616|0;c[e+0>>2]=c[f+0>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];e=h+632|0;c[e+0>>2]=c[f+16>>2];c[e+4>>2]=c[f+20>>2];c[e+8>>2]=c[f+24>>2];c[e+12>>2]=c[f+28>>2];e=h+648|0;c[e+0>>2]=c[f+32>>2];c[e+4>>2]=c[f+36>>2];c[e+8>>2]=c[f+40>>2];c[e+12>>2]=c[f+44>>2];e=h+664|0;c[e+0>>2]=c[f+48>>2];c[e+4>>2]=c[f+52>>2];c[e+8>>2]=c[f+56>>2];c[e+12>>2]=c[f+60>>2];g[h+688>>2]=0.0;g[h+692>>2]=-1.0;g[h+696>>2]=.8999999761581421;g[h+700>>2]=.30000001192092896;g[h+704>>2]=1.0;g[h+708>>2]=0.0;g[h+712>>2]=0.0;a[h+716>>0]=0;a[h+736>>0]=0;a[h+737>>0]=0;a[h+738>>0]=0;a[h+739>>0]=1;a[h+740>>0]=0;c[h+748>>2]=0;g[h+732>>2]=1.0;return h|0}function zl(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0;c[5132]=(c[5132]|0)+1;i=ZE(783)|0;if(!i)i=0;else{c[(i+19&-16)+-4>>2]=i;i=i+19&-16}c[i+4>>2]=4;c[i+8>>2]=-1;c[i+12>>2]=-1;g[i+16>>2]=3402823466385288598117041.0e14;a[i+20>>0]=1;a[i+21>>0]=0;c[i+24>>2]=-1;c[i+28>>2]=b;c[i+32>>2]=d;g[i+36>>2]=0.0;g[i+40>>2]=.30000001192092896;c[i+44>>2]=0;c[i>>2]=3936;d=i+552|0;c[d+0>>2]=c[e+0>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];d=i+568|0;c[d+0>>2]=c[e+16>>2];c[d+4>>2]=c[e+20>>2];c[d+8>>2]=c[e+24>>2];c[d+12>>2]=c[e+28>>2];d=i+584|0;c[d+0>>2]=c[e+32>>2];c[d+4>>2]=c[e+36>>2];c[d+8>>2]=c[e+40>>2];c[d+12>>2]=c[e+44>>2];d=i+600|0;c[d+0>>2]=c[e+48>>2];c[d+4>>2]=c[e+52>>2];c[d+8>>2]=c[e+56>>2];c[d+12>>2]=c[e+60>>2];e=i+616|0;c[e+0>>2]=c[f+0>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];e=i+632|0;c[e+0>>2]=c[f+16>>2];c[e+4>>2]=c[f+20>>2];c[e+8>>2]=c[f+24>>2];c[e+12>>2]=c[f+28>>2];e=i+648|0;c[e+0>>2]=c[f+32>>2];c[e+4>>2]=c[f+36>>2];c[e+8>>2]=c[f+40>>2];c[e+12>>2]=c[f+44>>2];e=i+664|0;c[e+0>>2]=c[f+48>>2];c[e+4>>2]=c[f+52>>2];c[e+8>>2]=c[f+56>>2];c[e+12>>2]=c[f+60>>2];g[i+688>>2]=0.0;g[i+692>>2]=-1.0;g[i+696>>2]=.8999999761581421;g[i+700>>2]=.30000001192092896;g[i+704>>2]=1.0;g[i+708>>2]=0.0;g[i+712>>2]=0.0;a[i+716>>0]=0;a[i+736>>0]=0;a[i+737>>0]=0;a[i+738>>0]=0;a[i+739>>0]=1;a[i+740>>0]=h&1;c[i+748>>2]=0;g[i+732>>2]=h?-1.0:1.0;return i|0}function Al(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0;c[5132]=(c[5132]|0)+1;h=ZE(783)|0;if(!h)h=0;else{c[(h+19&-16)+-4>>2]=h;h=h+19&-16}Gr(h,a,b,d,e,f,g,0);return h|0}function Bl(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0;c[5132]=(c[5132]|0)+1;i=ZE(783)|0;if(!i)i=0;else{c[(i+19&-16)+-4>>2]=i;i=i+19&-16}Gr(i,a,b,d,e,f,g,h);return i|0}function Cl(a,b,c,d,e){a=a|0;b=+b;c=+c;d=+d;e=+e;g[a+692>>2]=(c-b)*.5;b=+$E((c-b)*.5+b,6.2831854820251465);if(!(b<-3.1415927410125732)){if(b>3.1415927410125732)b=b+-6.2831854820251465}else b=b+6.2831854820251465;g[a+688>>2]=b;g[a+696>>2]=d;g[a+700>>2]=e;g[a+704>>2]=1.0;return}function Dl(a,b,c,d,e,f){a=a|0;b=+b;c=+c;d=+d;e=+e;f=+f;g[a+692>>2]=(c-b)*.5;b=+$E((c-b)*.5+b,6.2831854820251465);if(!(b<-3.1415927410125732)){if(b>3.1415927410125732)b=b+-6.2831854820251465}else b=b+6.2831854820251465;g[a+688>>2]=b;g[a+696>>2]=d;g[a+700>>2]=e;g[a+704>>2]=f;return}function El(b,c,d,e){b=b|0;c=c|0;d=+d;e=+e;a[b+737>>0]=c&1;g[b+680>>2]=d;g[b+684>>2]=e;return}function Fl(b,c){b=b|0;c=c|0;a[b+21>>0]=c&1;return}function Gl(a){a=a|0;return +(+g[a+16>>2])}function Hl(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function Il(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Jl(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function Kl(a,b,d){a=a|0;b=+b;d=d|0;Sb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function Ll(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Ml(){var a=0;a=ZE(12)|0;a:do if(!a){while(1){a=c[5254]|0;c[5254]=a+0;if(!a)break;qc[a&3]();a=ZE(12)|0;if(a)break a}a=yb(4)|0;c[a>>2]=20912;wb(a|0,20960,207)}while(0);g[a>>2]=.30000001192092896;g[a+4>>2]=1.0;g[a+8>>2]=0.0;return a|0}function Nl(a){a=a|0;return +(+g[a>>2])}function Ol(a,b){a=a|0;b=+b;g[a>>2]=b;return}function Pl(a){a=a|0;return +(+g[a+4>>2])}function Ql(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function Rl(a){a=a|0;return +(+g[a+8>>2])}function Sl(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function Tl(a){a=a|0;if(!a)return;_E(a);return}function Ul(){var b=0,d=0;c[5132]=(c[5132]|0)+1;b=ZE(303)|0;if(!b)b=0;else{c[(b+19&-16)+-4>>2]=b;b=b+19&-16}g[b+164>>2]=1.0;g[b+168>>2]=1.0;g[b+172>>2]=1.0;g[b+176>>2]=0.0;c[b+180>>2]=0;g[b+184>>2]=999999984306749440.0;d=b+188|0;c[d+0>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[b+204>>2]=1;c[b+208>>2]=-1;c[b+212>>2]=-1;c[b+216>>2]=1;g[b+220>>2]=0.0;g[b+224>>2]=.5;g[b+228>>2]=0.0;g[b+232>>2]=0.0;c[b+240>>2]=0;g[b+244>>2]=1.0;d=b+248|0;c[d+0>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;g[b+4>>2]=1.0;d=b+8|0;c[d+0>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;g[b+24>>2]=1.0;d=b+28|0;c[d+0>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;g[b+44>>2]=1.0;d=b+48|0;c[d+0>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=0;c[b>>2]=5512;a[b+280>>0]=1;c[b+276>>2]=0;c[b+268>>2]=0;c[b+272>>2]=0;c[b+236>>2]=4;return b|0}function Vl(a){a=a|0;return c[a+268>>2]|0}function Wl(a,b){a=a|0;b=b|0;return c[(c[a+276>>2]|0)+(b<<2)>>2]|0}function Xl(a,b,d){a=a|0;b=b|0;d=d|0;c[a+164>>2]=c[b+0>>2];c[a+168>>2]=c[b+4>>2];c[a+172>>2]=c[b+8>>2];c[a+176>>2]=c[b+12>>2];if((!(+g[b>>2]!=1.0)?!(+g[b+4>>2]!=1.0):0)?!(+g[b+8>>2]!=1.0):0){d=0;a=a+180|0;c[a>>2]=d;return}a=a+180|0;c[a>>2]=d;return}function Yl(a){a=a|0;return c[a+192>>2]|0}function Zl(a,b){a=a|0;b=+b;g[a+184>>2]=b;return}function _l(a,b){a=a|0;b=b|0;if((c[a+216>>2]&-2|0)==4)return;c[a+216>>2]=b;return}function $l(a,b){a=a|0;b=b|0;c[a+216>>2]=b;return}function am(a){a=a|0;if(c[a+204>>2]&3)return;if((c[a+216>>2]&-2|0)!=4)c[a+216>>2]=1;g[a+220>>2]=0.0;return}function bm(a,b){a=a|0;b=b|0;if(!b?(c[a+204>>2]&3|0)!=0:0)return;if((c[a+216>>2]&-2|0)!=4)c[a+216>>2]=1;g[a+220>>2]=0.0;return}function cm(a){a=a|0;a=c[a+216>>2]|0;return ((a|0)==2?0:(a|0)!=5)|0}function dm(a){a=a|0;return (c[a+204>>2]&2|0)!=0|0}function em(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+228>>2]=b;return}function fm(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+224>>2]=b;return}function gm(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+232>>2]=b;return}function hm(a){a=a|0;return a+4|0}function im(a){a=a|0;return c[a+204>>2]|0}function jm(a,b){a=a|0;b=b|0;c[a+204>>2]=b;return}function km(a,b){a=a|0;b=b|0;c[a+260>>2]=(c[a+260>>2]|0)+1;c[a+4>>2]=c[b+0>>2];c[a+8>>2]=c[b+4>>2];c[a+12>>2]=c[b+8>>2];c[a+16>>2]=c[b+12>>2];c[a+20>>2]=c[b+16>>2];c[a+24>>2]=c[b+20>>2];c[a+28>>2]=c[b+24>>2];c[a+32>>2]=c[b+28>>2];c[a+36>>2]=c[b+32>>2];c[a+40>>2]=c[b+36>>2];c[a+44>>2]=c[b+40>>2];c[a+48>>2]=c[b+44>>2];c[a+52>>2]=c[b+48>>2];c[a+56>>2]=c[b+52>>2];c[a+60>>2]=c[b+56>>2];c[a+64>>2]=c[b+60>>2];return}function lm(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+12>>2]&127](a,b);return}function mm(a,b){a=a|0;b=+b;g[a+252>>2]=b;return}function nm(a,b){a=a|0;b=+b;g[a+248>>2]=b;return}function om(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+8>>2]&255](a);return}function pm(a){a=a|0;return c[a>>2]|0}function qm(a,b){a=a|0;b=b|0;c[a>>2]=b;return}function rm(a){a=a|0;return c[a+4>>2]|0}function sm(a,b){a=a|0;b=b|0;c[a+4>>2]=b;return}function tm(a){a=a|0;if(!a)return;_E(a);return}function um(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function vm(b,d,e){b=b|0;d=d|0;e=e|0;var f=0;c[5132]=(c[5132]|0)+1;f=ZE(1407)|0;if(!f)f=0;else{c[(f+19&-16)+-4>>2]=f;f=f+19&-16}Jq(f,b,d,e);c[f>>2]=2736;c[f+4>>2]=9;a[f+1309>>0]=0;g[f+1316>>2]=0.0;g[f+1340>>2]=0.0;g[f+1364>>2]=1.0;a[f+1310>>0]=0;g[f+1320>>2]=0.0;g[f+1344>>2]=0.0;g[f+1368>>2]=1.0;a[f+1311>>0]=0;g[f+1324>>2]=0.0;g[f+1348>>2]=0.0;g[f+1372>>2]=1.0;a[f+1312>>0]=0;g[f+1328>>2]=0.0;g[f+1352>>2]=0.0;g[f+1376>>2]=1.0;a[f+1313>>0]=0;g[f+1332>>2]=0.0;g[f+1356>>2]=0.0;g[f+1380>>2]=1.0;a[f+1314>>0]=0;g[f+1336>>2]=0.0;g[f+1360>>2]=0.0;g[f+1384>>2]=1.0;return f|0}function wm(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0;c[5132]=(c[5132]|0)+1;i=ZE(1407)|0;if(!i)i=0;else{c[(i+19&-16)+-4>>2]=i;i=i+19&-16}Iq(i,b,d,e,f,h);c[i>>2]=2736;c[i+4>>2]=9;a[i+1309>>0]=0;g[i+1316>>2]=0.0;g[i+1340>>2]=0.0;g[i+1364>>2]=1.0;a[i+1310>>0]=0;g[i+1320>>2]=0.0;g[i+1344>>2]=0.0;g[i+1368>>2]=1.0;a[i+1311>>0]=0;g[i+1324>>2]=0.0;g[i+1348>>2]=0.0;g[i+1372>>2]=1.0;a[i+1312>>0]=0;g[i+1328>>2]=0.0;g[i+1352>>2]=0.0;g[i+1376>>2]=1.0;a[i+1313>>0]=0;g[i+1332>>2]=0.0;g[i+1356>>2]=0.0;g[i+1380>>2]=1.0;a[i+1314>>0]=0;g[i+1336>>2]=0.0;g[i+1360>>2]=0.0;g[i+1384>>2]=1.0;return i|0}function xm(b,c,d){b=b|0;c=c|0;d=d|0;a[b+c+1309>>0]=d&1;if((c|0)<3){a[b+c+788>>0]=d&1;return}else{a[b+(c+-3<<6)+912>>0]=d&1;return}}function ym(a,b,c){a=a|0;b=b|0;c=+c;g[a+(b<<2)+1340>>2]=c;return}function zm(a,b,c){a=a|0;b=b|0;c=+c;g[a+(b<<2)+1364>>2]=c;return}function Am(a,b){a=a|0;b=b|0;c[a+680>>2]=c[b+0>>2];c[a+684>>2]=c[b+4>>2];c[a+688>>2]=c[b+8>>2];c[a+692>>2]=c[b+12>>2];return}function Bm(a,b){a=a|0;b=b|0;c[a+696>>2]=c[b+0>>2];c[a+700>>2]=c[b+4>>2];c[a+704>>2]=c[b+8>>2];c[a+708>>2]=c[b+12>>2];return}function Cm(a,b){a=a|0;b=b|0;var c=0.0,d=0;d=0;while(1){if((d|0)==3)break;c=+$E(+g[b+(d<<2)>>2],6.2831854820251465);if(!(c<-3.1415927410125732)){if(c>3.1415927410125732)c=c+-6.2831854820251465}else c=c+6.2831854820251465;g[a+(d<<6)+868>>2]=c;d=d+1|0}return}function Dm(a,b){a=a|0;b=b|0;var c=0.0,d=0;d=0;while(1){if((d|0)==3)break;c=+$E(+g[b+(d<<2)>>2],6.2831854820251465);if(!(c<-3.1415927410125732)){if(c>3.1415927410125732)c=c+-6.2831854820251465}else c=c+6.2831854820251465;g[a+(d<<6)+872>>2]=c;d=d+1|0}return}function Em(a){a=a|0;return a+48|0}function Fm(b,c){b=b|0;c=c|0;a[b+21>>0]=c&1;return}function Gm(a){a=a|0;return +(+g[a+16>>2])}function Hm(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function Im(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Jm(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;var h=0;h=ZE(44)|0;a:do if(!h){while(1){h=c[5254]|0;c[5254]=h+0;if(!h)break;qc[h&3]();h=ZE(44)|0;if(h)break a}e=yb(4)|0;c[e>>2]=20912;wb(e|0,20960,207)}while(0);c[h>>2]=a;c[h+4>>2]=b;b=h+8|0;c[b+0>>2]=c[d+0>>2];c[b+4>>2]=c[d+4>>2];c[b+8>>2]=c[d+8>>2];c[b+12>>2]=c[d+12>>2];d=h+24|0;c[d+0>>2]=c[e+0>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];g[h+40>>2]=f;return h|0}function Km(a){a=a|0;return c[a>>2]|0}function Lm(a,b){a=a|0;b=b|0;c[a>>2]=b;return}function Mm(a){a=a|0;return c[a+4>>2]|0}function Nm(a,b){a=a|0;b=b|0;c[a+4>>2]=b;return}function Om(a){a=a|0;return a+8|0}function Pm(a,b){a=a|0;b=b|0;c[a+8>>2]=c[b+0>>2];c[a+12>>2]=c[b+4>>2];c[a+16>>2]=c[b+8>>2];c[a+20>>2]=c[b+12>>2];return}function Qm(a){a=a|0;return a+24|0}function Rm(a,b){a=a|0;b=b|0;c[a+24>>2]=c[b+0>>2];c[a+28>>2]=c[b+4>>2];c[a+32>>2]=c[b+8>>2];c[a+36>>2]=c[b+12>>2];return}function Sm(a){a=a|0;return +(+g[a+40>>2])}function Tm(a,b){a=a|0;b=+b;g[a+40>>2]=b;return}function Um(a){a=a|0;if(!a)return;_E(a);return}function Vm(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Wm(b){b=b|0;var d=0,e=0;c[5132]=(c[5132]|0)+1;d=ZE(635)|0;if(!d)d=0;else{c[(d+19&-16)+-4>>2]=d;d=d+19&-16}g[d+164>>2]=1.0;g[d+168>>2]=1.0;g[d+172>>2]=1.0;g[d+176>>2]=0.0;c[d+180>>2]=0;g[d+184>>2]=999999984306749440.0;e=d+188|0;c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[d+204>>2]=1;c[d+208>>2]=-1;c[d+212>>2]=-1;c[d+216>>2]=1;g[d+220>>2]=0.0;g[d+224>>2]=.5;g[d+228>>2]=0.0;g[d+232>>2]=0.0;c[d+236>>2]=1;c[d+240>>2]=0;g[d+244>>2]=1.0;e=d+248|0;c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;g[d+4>>2]=1.0;e=d+8|0;c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;g[d+24>>2]=1.0;e=d+28|0;c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;g[d+44>>2]=1.0;e=d+48|0;c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[d>>2]=1560;a[d+500>>0]=1;c[d+496>>2]=0;c[d+488>>2]=0;c[d+492>>2]=0;Bp(d,b);return d|0}function Xm(a){a=a|0;return a+4|0}function Ym(a,b){a=a|0;b=b|0;Dp(a,b);return}function Zm(a,b,c){a=a|0;b=+b;c=+c;g[a+472>>2]=b;g[a+476>>2]=c;return}function _m(a,b,c){a=a|0;b=+b;c=+c;if(b<0.0)b=0.0;else b=b>1.0?1.0:b;g[a+444>>2]=b;if(c<0.0)b=0.0;else b=c>1.0?1.0:c;g[a+448>>2]=b;return}function $m(a,b,d){a=a|0;b=+b;d=d|0;var e=0,f=0.0,h=0.0,i=0.0;e=c[a+204>>2]|0;if(b==0.0){c[a+204>>2]=e|1;i=0.0}else{c[a+204>>2]=e&-2;i=1.0/b}g[a+344>>2]=i;f=+g[a+384>>2]*b;h=+g[a+388>>2]*b;g[a+364>>2]=+g[a+380>>2]*b;g[a+368>>2]=f;g[a+372>>2]=h;g[a+376>>2]=0.0;b=+g[d>>2];if(b!=0.0)h=1.0/b;else h=0.0;b=+g[d+4>>2];if(b!=0.0)f=1.0/b;else f=0.0;b=+g[d+8>>2];if(b!=0.0)b=1.0/b;else b=0.0;g[a+396>>2]=h;g[a+400>>2]=f;g[a+404>>2]=b;g[a+408>>2]=0.0;f=i*+g[a+352>>2];h=i*+g[a+356>>2];g[a+560>>2]=+g[a+348>>2]*i;g[a+564>>2]=f;g[a+568>>2]=h;g[a+572>>2]=0.0;return}function an(a,b){a=a|0;b=b|0;var d=0.0,e=0.0,f=0.0;c[a+348>>2]=c[b+0>>2];c[a+352>>2]=c[b+4>>2];c[a+356>>2]=c[b+8>>2];c[a+360>>2]=c[b+12>>2];f=+g[a+344>>2];e=+g[a+352>>2]*f;d=+g[a+356>>2]*f;g[a+560>>2]=+g[a+348>>2]*f;g[a+564>>2]=e;g[a+568>>2]=d;g[a+572>>2]=0.0;return}function bn(a,b){a=a|0;b=b|0;var c=0.0,d=0.0;d=+g[b+4>>2]*+g[a+548>>2];c=+g[b+8>>2]*+g[a+552>>2];g[a+428>>2]=+g[a+428>>2]+ +g[b>>2]*+g[a+544>>2];g[a+432>>2]=+g[a+432>>2]+d;g[a+436>>2]=+g[a+436>>2]+c;return}function cn(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;d=+g[a+348>>2];f=+g[a+352>>2];h=+g[b+4>>2]*f;i=+g[a+356>>2];j=+g[b+8>>2]*i;g[a+412>>2]=+g[a+412>>2]+ +g[b>>2]*d;g[a+416>>2]=+g[a+416>>2]+h;g[a+420>>2]=+g[a+420>>2]+j;d=+g[b>>2]*d;f=+g[b+4>>2]*f;i=+g[b+8>>2]*i;j=+g[c+4>>2];h=+g[c+8>>2];k=+g[c>>2];e=(h*d-k*i)*+g[a+548>>2];d=(k*f-j*d)*+g[a+552>>2];g[a+428>>2]=+g[a+428>>2]+(j*i-h*f)*+g[a+544>>2];g[a+432>>2]=+g[a+432>>2]+e;g[a+436>>2]=+g[a+436>>2]+d;return}function dn(a,b){a=a|0;b=b|0;var c=0.0,d=0.0;d=+g[b+4>>2]*+g[a+352>>2];c=+g[b+8>>2]*+g[a+356>>2];g[a+412>>2]=+g[a+412>>2]+ +g[b>>2]*+g[a+348>>2];g[a+416>>2]=+g[a+416>>2]+d;g[a+420>>2]=+g[a+420>>2]+c;return}function en(a,b){a=a|0;b=b|0;var c=0.0,d=0.0,e=0.0,f=0.0,h=0.0;h=+g[b>>2];f=+g[b+4>>2];e=+g[b+8>>2];d=(+g[a+280>>2]*h+ +g[a+284>>2]*f+ +g[a+288>>2]*e)*+g[a+548>>2];c=(+g[a+296>>2]*h+ +g[a+300>>2]*f+ +g[a+304>>2]*e)*+g[a+552>>2];g[a+328>>2]=+g[a+328>>2]+(+g[a+264>>2]*h+ +g[a+268>>2]*f+ +g[a+272>>2]*e)*+g[a+544>>2];g[a+332>>2]=+g[a+332>>2]+d;g[a+336>>2]=+g[a+336>>2]+c;return}function fn(a,b,c){a=a|0;b=b|0;c=c|0;gn(a,b,c);return}function gn(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0;if(!(+g[a+344>>2]!=0.0))return;jn(a,b);f=+g[b>>2]*+g[a+348>>2];i=+g[b+4>>2]*+g[a+352>>2];k=+g[b+8>>2]*+g[a+356>>2];h=+g[c+4>>2];l=+g[c+8>>2];j=+g[c>>2];e=(+g[a+280>>2]*(h*k-l*i)+ +g[a+284>>2]*(l*f-j*k)+ +g[a+288>>2]*(j*i-h*f))*+g[a+548>>2];d=(+g[a+296>>2]*(h*k-l*i)+ +g[a+300>>2]*(l*f-j*k)+ +g[a+304>>2]*(j*i-h*f))*+g[a+552>>2];g[a+328>>2]=+g[a+328>>2]+(+g[a+264>>2]*(h*k-l*i)+ +g[a+268>>2]*(l*f-j*k)+ +g[a+272>>2]*(j*i-h*f))*+g[a+544>>2];g[a+332>>2]=+g[a+332>>2]+e;g[a+336>>2]=+g[a+336>>2]+d;return}function hn(a,b){a=a|0;b=b|0;jn(a,b);return}function jn(a,b){a=a|0;b=b|0;var c=0.0,d=0.0,e=0.0;e=+g[a+344>>2];d=+g[b+4>>2]*+g[a+352>>2]*e;c=+g[b+8>>2]*+g[a+356>>2]*e;g[a+312>>2]=+g[a+312>>2]+ +g[b>>2]*+g[a+348>>2]*e;g[a+316>>2]=+g[a+316>>2]+d;g[a+320>>2]=+g[a+320>>2]+c;return}function kn(a){a=a|0;var b=0.0,c=0.0,d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0;n=+g[a+4>>2];h=+g[a+396>>2];m=+g[a+8>>2];e=+g[a+400>>2];l=+g[a+12>>2];c=+g[a+404>>2];k=+g[a+20>>2];j=+g[a+24>>2];i=+g[a+28>>2];f=+g[a+36>>2];d=+g[a+40>>2];b=+g[a+44>>2];g[a+264>>2]=n*(n*h)+m*(m*e)+l*(l*c);g[a+268>>2]=n*h*k+m*e*j+l*c*i;g[a+272>>2]=n*h*f+m*e*d+l*c*b;g[a+276>>2]=0.0;g[a+280>>2]=n*(h*k)+m*(e*j)+l*(c*i);g[a+284>>2]=k*(h*k)+j*(e*j)+i*(c*i);g[a+288>>2]=h*k*f+e*j*d+c*i*b;g[a+292>>2]=0.0;g[a+296>>2]=n*(h*f)+m*(e*d)+l*(c*b);g[a+300>>2]=k*(h*f)+j*(e*d)+i*(c*b);g[a+304>>2]=f*(h*f)+d*(e*d)+b*(c*b);g[a+308>>2]=0.0;return}function ln(a){a=a|0;return a+312|0}function mn(a){a=a|0;return a+328|0}function nn(a,b){a=a|0;b=b|0;c[a+260>>2]=(c[a+260>>2]|0)+1;c[a+312>>2]=c[b+0>>2];c[a+316>>2]=c[b+4>>2];c[a+320>>2]=c[b+8>>2];c[a+324>>2]=c[b+12>>2];return}function on(a,b){a=a|0;b=b|0;c[a+260>>2]=(c[a+260>>2]|0)+1;c[a+328>>2]=c[b+0>>2];c[a+332>>2]=c[b+4>>2];c[a+336>>2]=c[b+8>>2];c[a+340>>2]=c[b+12>>2];return}function pn(a){a=a|0;return c[a+480>>2]|0}function qn(a,b){a=a|0;b=b|0;c[a+260>>2]=(c[a+260>>2]|0)+1;c[a+544>>2]=c[b+0>>2];c[a+548>>2]=c[b+4>>2];c[a+552>>2]=c[b+8>>2];c[a+556>>2]=c[b+12>>2];return}function rn(a,b){a=a|0;b=b|0;return ((c[b+236>>2]&2|0)==0?0:b)|0}function sn(a,b,d){a=a|0;b=b|0;d=d|0;c[a+164>>2]=c[b+0>>2];c[a+168>>2]=c[b+4>>2];c[a+172>>2]=c[b+8>>2];c[a+176>>2]=c[b+12>>2];if((!(+g[b>>2]!=1.0)?!(+g[b+4>>2]!=1.0):0)?!(+g[b+8>>2]!=1.0):0){d=0;a=a+180|0;c[a>>2]=d;return}a=a+180|0;c[a>>2]=d;return}function tn(a){a=a|0;return c[a+192>>2]|0}function un(a,b){a=a|0;b=+b;g[a+184>>2]=b;return}function vn(a,b){a=a|0;b=b|0;if((c[a+216>>2]&-2|0)==4)return;c[a+216>>2]=b;return}function wn(a,b){a=a|0;b=b|0;c[a+216>>2]=b;return}function xn(a){a=a|0;if(c[a+204>>2]&3)return;if((c[a+216>>2]&-2|0)!=4)c[a+216>>2]=1;g[a+220>>2]=0.0;return}function yn(a,b){a=a|0;b=b|0;if(!b?(c[a+204>>2]&3|0)!=0:0)return;if((c[a+216>>2]&-2|0)!=4)c[a+216>>2]=1;g[a+220>>2]=0.0;return}function zn(a){a=a|0;a=c[a+216>>2]|0;return ((a|0)==2?0:(a|0)!=5)|0}function An(a){a=a|0;return (c[a+204>>2]&2|0)!=0|0}function Bn(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+228>>2]=b;return}function Cn(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+224>>2]=b;return}function Dn(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+232>>2]=b;return}function En(a){a=a|0;return a+4|0}function Fn(a){a=a|0;return c[a+204>>2]|0}function Gn(a,b){a=a|0;b=b|0;c[a+204>>2]=b;return}function Hn(a,b){a=a|0;b=b|0;c[a+260>>2]=(c[a+260>>2]|0)+1;c[a+4>>2]=c[b+0>>2];c[a+8>>2]=c[b+4>>2];c[a+12>>2]=c[b+8>>2];c[a+16>>2]=c[b+12>>2];c[a+20>>2]=c[b+16>>2];c[a+24>>2]=c[b+20>>2];c[a+28>>2]=c[b+24>>2];c[a+32>>2]=c[b+28>>2];c[a+36>>2]=c[b+32>>2];c[a+40>>2]=c[b+36>>2];c[a+44>>2]=c[b+40>>2];c[a+48>>2]=c[b+44>>2];c[a+52>>2]=c[b+48>>2];c[a+56>>2]=c[b+52>>2];c[a+60>>2]=c[b+56>>2];c[a+64>>2]=c[b+60>>2];return}function In(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+12>>2]&127](a,b);return}function Jn(a,b){a=a|0;b=+b;g[a+252>>2]=b;return}function Kn(a,b){a=a|0;b=+b;g[a+248>>2]=b;return}function Ln(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+8>>2]&255](a);return}function Mn(a){a=a|0;var b=0;c[5132]=(c[5132]|0)+1;b=ZE(75)|0;if(!b)b=0;else{c[(b+19&-16)+-4>>2]=b;b=b+19&-16}mA(b,a);c[b>>2]=15648;c[b+52>>2]=0;return b|0}function Nn(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function On(a,b,d){a=a|0;b=+b;d=d|0;Sb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function Pn(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Qn(a){a=a|0;var b=0;c[5132]=(c[5132]|0)+1;b=ZE(75)|0;if(!b)b=0;else{c[(b+19&-16)+-4>>2]=b;b=b+19&-16}mA(b,a);c[b>>2]=15752;c[b+52>>2]=2;return b|0}function Rn(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function Sn(a,b,d){a=a|0;b=+b;d=d|0;Sb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function Tn(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Un(){var a=0,b=0;a=ZE(64)|0;if(a){b=a;return b|0}while(1){a=c[5254]|0;c[5254]=a+0;if(!a){b=4;break}qc[a&3]();a=ZE(64)|0;if(a){b=5;break}}if((b|0)==4){b=yb(4)|0;c[b>>2]=20912;wb(b|0,20960,207)}else if((b|0)==5)return a|0;return 0}function Vn(a,b){a=a|0;b=b|0;var d=0,e=0;d=ZE(64)|0;a:do if(!d){while(1){d=c[5254]|0;c[5254]=d+0;if(!d)break;qc[d&3]();d=ZE(64)|0;if(d)break a}b=yb(4)|0;c[b>>2]=20912;wb(b|0,20960,207)}while(0);e=d+48|0;gp(d,a);c[e+0>>2]=c[b+0>>2];c[e+4>>2]=c[b+4>>2];c[e+8>>2]=c[b+8>>2];c[e+12>>2]=c[b+12>>2];return d|0}function Wn(a){a=a|0;Xn(a);return}function Xn(a){a=a|0;g[a>>2]=1.0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;c[a+16>>2]=0;g[a+20>>2]=1.0;c[a+24>>2]=0;c[a+28>>2]=0;c[a+32>>2]=0;c[a+36>>2]=0;g[a+40>>2]=1.0;g[a+44>>2]=0.0;c[a+48>>2]=0;c[a+52>>2]=0;c[a+56>>2]=0;c[a+60>>2]=0;return}function Yn(a,b){a=a|0;b=b|0;c[a+48>>2]=c[b+0>>2];c[a+52>>2]=c[b+4>>2];c[a+56>>2]=c[b+8>>2];c[a+60>>2]=c[b+12>>2];return}function Zn(a,b){a=a|0;b=b|0;gp(a,b);return}function _n(a){a=a|0;return a+48|0}function $n(b){b=b|0;var d=0;d=i;i=i+16|0;if((a[240]|0)==0?(Xa(240)|0)!=0:0)ab(240);Fc(b,d);c[56]=c[d+0>>2];c[57]=c[d+4>>2];c[58]=c[d+8>>2];c[59]=c[d+12>>2];i=d;return 224}function ao(a){a=a|0;return a|0}function bo(b){b=b|0;var d=0;d=i;i=i+64|0;if((a[312]|0)==0?(Xa(312)|0)!=0:0)ab(312);co(d,b);c[62]=c[d+0>>2];c[63]=c[d+4>>2];c[64]=c[d+8>>2];c[65]=c[d+12>>2];c[66]=c[d+16>>2];c[67]=c[d+20>>2];c[68]=c[d+24>>2];c[69]=c[d+28>>2];c[70]=c[d+32>>2];c[71]=c[d+36>>2];c[72]=c[d+40>>2];c[73]=c[d+44>>2];c[74]=c[d+48>>2];c[75]=c[d+52>>2];c[76]=c[d+56>>2];c[77]=c[d+60>>2];i=d;return 248}function co(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0;d=i;i=i+48|0;r=+g[b>>2];g[d>>2]=r;q=+g[b+16>>2];g[d+4>>2]=q;p=+g[b+32>>2];g[d+8>>2]=p;g[d+12>>2]=0.0;o=+g[b+4>>2];g[d+16>>2]=o;n=+g[b+20>>2];g[d+20>>2]=n;m=+g[b+36>>2];g[d+24>>2]=m;g[d+28>>2]=0.0;l=+g[b+8>>2];g[d+32>>2]=l;j=+g[b+24>>2];g[d+36>>2]=j;f=+g[b+40>>2];g[d+40>>2]=f;g[d+44>>2]=0.0;k=-+g[b+48>>2];h=-+g[b+52>>2];e=-+g[b+56>>2];c[a+0>>2]=c[d+0>>2];c[a+4>>2]=c[d+4>>2];c[a+8>>2]=c[d+8>>2];c[a+12>>2]=c[d+12>>2];c[a+16>>2]=c[d+16>>2];c[a+20>>2]=c[d+20>>2];c[a+24>>2]=c[d+24>>2];c[a+28>>2]=c[d+28>>2];c[a+32>>2]=c[d+32>>2];c[a+36>>2]=c[d+36>>2];c[a+40>>2]=c[d+40>>2];c[a+44>>2]=c[d+44>>2];g[a+48>>2]=r*k+q*h+p*e;g[a+52>>2]=o*k+n*h+m*e;g[a+56>>2]=l*k+j*h+f*e;g[a+60>>2]=0.0;i=d;return}function eo(b,d){b=b|0;d=d|0;var e=0;e=i;i=i+16|0;if((a[336]|0)==0?(Xa(336)|0)!=0:0)ab(336);fp(e,b,+g[d>>2],+g[d+4>>2],+g[d+8>>2]);c[80]=c[e+0>>2];c[81]=c[e+4>>2];c[82]=c[e+8>>2];c[83]=c[e+12>>2];i=e;return 320}function fo(a){a=a|0;if(!a)return;_E(a);return}function go(a){a=a|0;return c[a+24>>2]|0}function ho(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;tc[c[(c[a>>2]|0)+32>>2]&127](a,b,d,e);return}function io(a){a=a|0;a=c[a+68>>2]|0;return Nb[c[(c[a>>2]|0)+36>>2]&127](a)|0}function jo(a){a=a|0;return a+28|0}function ko(a,b){a=a|0;b=b|0;tc[c[(c[a>>2]|0)+36>>2]&127](a,b,1,-1);return}function lo(a,b,d){a=a|0;b=b|0;d=d|0;tc[c[(c[a>>2]|0)+36>>2]&127](a,b,d,-1);return}function mo(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;tc[c[(c[a>>2]|0)+36>>2]&127](a,b,d,e);return}function no(a){a=a|0;return c[a+68>>2]|0}function oo(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=+f;hv(a,b,c,d,e,f);return}function po(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;iv(a,b,c,d);return}function qo(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function ro(a){a=a|0;return +(+g[a>>2])}function so(a){a=a|0;return +(+g[a+4>>2])}function to(a){a=a|0;return +(+g[a+8>>2])}function uo(a){a=a|0;return +(+g[a+12>>2])}function vo(a,b){a=a|0;b=+b;g[a>>2]=b;return}function wo(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function xo(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function yo(a,b){a=a|0;b=+b;g[a+12>>2]=b;return}function zo(a){a=a|0;if(!a)return;_E(a);return}function Ao(b,d,e){b=b|0;d=d|0;e=e|0;b=ZE(152)|0;a:do if(!b){while(1){b=c[5254]|0;c[5254]=b+0;if(!b)break;qc[b&3]();b=ZE(152)|0;if(b)break a}e=yb(4)|0;c[e>>2]=20912;wb(e|0,20960,207)}while(0);c[b>>2]=4936;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;a[b+40>>0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;a[b+60>>0]=1;c[b+56>>2]=0;c[b+48>>2]=0;c[b+52>>2]=0;a[b+80>>0]=1;c[b+76>>2]=0;c[b+68>>2]=0;c[b+72>>2]=0;c[b+100>>2]=e;g[b+104>>2]=0.0;a[b+148>>0]=1;c[b+144>>2]=0;c[b+136>>2]=0;c[b+140>>2]=0;c[b+116>>2]=d;c[b+120>>2]=0;c[b+124>>2]=2;c[b+128>>2]=1;g[b+112>>2]=0.0;g[b+108>>2]=0.0;return b|0}function Bo(a,b,d){a=a|0;b=+b;d=d|0;g[(c[a+144>>2]|0)+(d*284|0)+252>>2]=b;return}function Co(a,b,d){a=a|0;b=+b;d=d|0;g[(c[a+144>>2]|0)+(d*284|0)+232>>2]=b;return}function Do(a,b){a=a|0;b=b|0;return (c[a+144>>2]|0)+(b*284|0)+92|0}function Eo(a,b,d){a=a|0;b=b|0;d=d|0;os(c[a+116>>2]|0,c[a+144>>2]|0,b,d);return}function Fo(b,d,e,f,h,j,k,l){b=b|0;d=d|0;e=e|0;f=f|0;h=+h;j=+j;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0;x=i;i=i+288|0;c[x+0>>2]=c[d+0>>2];c[x+4>>2]=c[d+4>>2];c[x+8>>2]=c[d+8>>2];c[x+12>>2]=c[d+12>>2];c[x+16>>2]=c[e+0>>2];c[x+20>>2]=c[e+4>>2];c[x+24>>2]=c[e+8>>2];c[x+28>>2]=c[e+12>>2];c[x+32>>2]=c[f+0>>2];c[x+36>>2]=c[f+4>>2];c[x+40>>2]=c[f+8>>2];c[x+44>>2]=c[f+12>>2];t=+g[k>>2];u=+g[k+4>>2];v=+g[k+8>>2];w=+g[k+16>>2];s=+g[k+12>>2];r=+g[k+20>>2];c[x+48>>2]=c[x+0>>2];c[x+52>>2]=c[x+4>>2];c[x+56>>2]=c[x+8>>2];c[x+60>>2]=c[x+12>>2];c[x+64>>2]=c[x+16>>2];c[x+68>>2]=c[x+20>>2];c[x+72>>2]=c[x+24>>2];c[x+76>>2]=c[x+28>>2];c[x+80>>2]=c[x+32>>2];c[x+84>>2]=c[x+36>>2];c[x+88>>2]=c[x+40>>2];c[x+92>>2]=c[x+44>>2];e=c[b+136>>2]|0;if((e|0)==(c[b+140>>2]|0)?(q=(e|0)==0?1:e<<1,(e|0)<(q|0)):0){if(!q)f=0;else{c[5132]=(c[5132]|0)+1;f=ZE((q*284|3)+16|0)|0;if(!f)f=0;else{c[(f+19&-16)+-4>>2]=f;f=f+19&-16}e=c[b+136>>2]|0}if((e|0)>0){m=0;do{k=f+(m*284|0)|0;if(k){d=c[b+144>>2]|0;n=k+0|0;o=d+(m*284|0)+0|0;p=n+92|0;do{c[n>>2]=c[o>>2];n=n+4|0;o=o+4|0}while((n|0)<(p|0));n=f+(m*284|0)+92|0;o=d+(m*284|0)+92|0;c[n+0>>2]=c[o+0>>2];c[n+4>>2]=c[o+4>>2];c[n+8>>2]=c[o+8>>2];c[n+12>>2]=c[o+12>>2];n=f+(m*284|0)+108|0;o=d+(m*284|0)+108|0;c[n+0>>2]=c[o+0>>2];c[n+4>>2]=c[o+4>>2];c[n+8>>2]=c[o+8>>2];c[n+12>>2]=c[o+12>>2];n=f+(m*284|0)+124|0;o=d+(m*284|0)+124|0;c[n+0>>2]=c[o+0>>2];c[n+4>>2]=c[o+4>>2];c[n+8>>2]=c[o+8>>2];c[n+12>>2]=c[o+12>>2];n=f+(m*284|0)+140|0;o=d+(m*284|0)+140|0;c[n+0>>2]=c[o+0>>2];c[n+4>>2]=c[o+4>>2];c[n+8>>2]=c[o+8>>2];c[n+12>>2]=c[o+12>>2];n=f+(m*284|0)+156|0;o=d+(m*284|0)+156|0;p=n+128|0;do{c[n>>2]=c[o>>2];n=n+4|0;o=o+4|0}while((n|0)<(p|0))}m=m+1|0}while((m|0)!=(e|0))}e=c[b+144>>2]|0;if(e){if(a[b+148>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[e+-4>>2]|0)}c[b+144>>2]=0}a[b+148>>0]=1;c[b+144>>2]=f;c[b+140>>2]=q;e=c[b+136>>2]|0}k=c[b+144>>2]|0;f=k+(e*284|0)|0;if(!f){q=e;l=k;p=q+1|0;c[b+136>>2]=p;q=l+(q*284|0)|0;l=b+116|0;p=c[l>>2]|0;ns(p,q,0);p=c[b+136>>2]|0;p=p+-1|0;l=c[l>>2]|0;b=c[b+144>>2]|0;os(l,b,p,0);i=x;return q|0}n=f+0|0;o=x+96|0;p=n+92|0;do{c[n>>2]=c[o>>2];n=n+4|0;o=o+4|0}while((n|0)<(p|0));f=k+(e*284|0)+92|0;c[f+0>>2]=c[x+208>>2];c[f+4>>2]=c[x+212>>2];c[f+8>>2]=c[x+216>>2];c[f+12>>2]=c[x+220>>2];f=k+(e*284|0)+108|0;c[f+0>>2]=c[x+224>>2];c[f+4>>2]=c[x+228>>2];c[f+8>>2]=c[x+232>>2];c[f+12>>2]=c[x+236>>2];f=k+(e*284|0)+124|0;c[f+0>>2]=c[x+240>>2];c[f+4>>2]=c[x+244>>2];c[f+8>>2]=c[x+248>>2];c[f+12>>2]=c[x+252>>2];f=k+(e*284|0)+140|0;c[f+0>>2]=c[x+192>>2];c[f+4>>2]=c[x+196>>2];c[f+8>>2]=c[x+200>>2];c[f+12>>2]=c[x+204>>2];f=k+(e*284|0)+156|0;n=f+0|0;o=x+48|0;p=n+48|0;do{c[n>>2]=c[o>>2];n=n+4|0;o=o+4|0}while((n|0)<(p|0));g[f+48>>2]=h;g[f+52>>2]=s;g[f+56>>2]=j;g[f+60>>2]=t;g[f+64>>2]=u;g[f+68>>2]=v;g[f+72>>2]=w;g[f+76>>2]=0.0;g[f+80>>2]=0.0;g[f+84>>2]=0.0;g[f+88>>2]=.10000000149011612;g[f+92>>2]=r;g[f+96>>2]=0.0;g[f+100>>2]=0.0;a[f+104>>0]=l&1;n=f+105|0;o=x+256|0;p=n+23|0;do{a[n>>0]=a[o>>0]|0;n=n+1|0;o=o+1|0}while((n|0)<(p|0));q=c[b+136>>2]|0;l=c[b+144>>2]|0;p=q+1|0;c[b+136>>2]=p;q=l+(q*284|0)|0;l=b+116|0;p=c[l>>2]|0;ns(p,q,0);p=c[b+136>>2]|0;p=p+-1|0;l=c[l>>2]|0;b=c[b+144>>2]|0;os(l,b,p,0);i=x;return q|0}function Go(a){a=a|0;return c[a+136>>2]|0}function Ho(a){a=a|0;return c[a+116>>2]|0}function Io(a,b){a=a|0;b=b|0;return (c[a+144>>2]|0)+(b*284|0)|0}function Jo(a,b,d){a=a|0;b=+b;d=d|0;g[(c[a+144>>2]|0)+(d*284|0)+256>>2]=b;return}function Ko(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;tc[c[(c[a>>2]|0)+24>>2]&127](a,b,d,e);return}function Lo(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Mo(a){a=a|0;var b=0;c[5132]=(c[5132]|0)+1;b=ZE(75)|0;if(!b)b=0;else{c[(b+19&-16)+-4>>2]=b;b=b+19&-16}mA(b,a);return b|0}function No(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);return}function Oo(a,b,d){a=a|0;b=+b;d=d|0;Sb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);return}function Po(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Qo(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Ro(){var a=0,b=0;a=ZE(4)|0;if(a){b=a;c[b>>2]=480;return b|0}while(1){a=c[5254]|0;c[5254]=a+0;if(!a){b=4;break}qc[a&3]();a=ZE(4)|0;if(a){b=5;break}}if((b|0)==4){b=yb(4)|0;c[b>>2]=20912;wb(b|0,20960,207)}else if((b|0)==5){c[a>>2]=480;return a|0}return 0}function So(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function To(b,c){b=b|0;c=c|0;a[b+21>>0]=c&1;return}function Uo(a){a=a|0;return +(+g[a+16>>2])}function Vo(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function Wo(a){a=a|0;if(!a)return;Jb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Xo(a){a=a|0;return}function Yo(a){a=a|0;if(!a)return;c[5134]=(c[5134]|0)+1;_E(c[a+-4>>2]|0);return}function Zo(a){a=a|0;return}function _o(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;return}function $o(a,b,c,d){a=a|0;b=b|0;c=c|0;d=+d;return}function ap(a){a=a|0;return}function bp(a){a=a|0;_E(a);return}function cp(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;a=c[b>>2]|0;e=c[d>>2]|0;a=(c[a+236>>2]|0)==4?a:0;e=(c[e+236>>2]|0)==4?e:0;if(a)pc[c[(c[a>>2]|0)+28>>2]&127](a,d,b);if(!e)return 0;pc[c[(c[e>>2]|0)+28>>2]&127](e,b,d);return 0}function dp(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;a=c[b>>2]|0;f=c[d>>2]|0;a=(c[a+236>>2]|0)==4?a:0;f=(c[f+236>>2]|0)==4?f:0;if(a)tc[c[(c[a>>2]|0)+32>>2]&127](a,d,e,b);if(!f)return 0;tc[c[(c[f>>2]|0)+32>>2]&127](f,b,e,d);return 0}function ep(a,b,c){a=a|0;b=b|0;c=c|0;return}function fp(a,b,c,d,e){a=a|0;b=b|0;c=+c;d=+d;e=+e;var f=0.0,h=0.0;h=+g[b+16>>2]*c+ +g[b+20>>2]*d+ +g[b+24>>2]*e+ +g[b+52>>2];f=+g[b+32>>2]*c+ +g[b+36>>2]*d+ +g[b+40>>2]*e+ +g[b+56>>2];g[a>>2]=+g[b>>2]*c+ +g[b+4>>2]*d+ +g[b+8>>2]*e+ +g[b+48>>2];g[a+4>>2]=h;g[a+8>>2]=f;g[a+12>>2]=0.0;return}function gp(a,b){a=a|0;b=b|0;var c=0.0,d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;f=+g[b>>2];d=+g[b+4>>2];j=+g[b+8>>2];h=+g[b+12>>2];e=f*(2.0/(f*f+d*d+j*j+h*h));c=d*(2.0/(f*f+d*d+j*j+h*h));i=j*(2.0/(f*f+d*d+j*j+h*h));g[a>>2]=1.0-(d*c+j*i);g[a+4>>2]=f*c-h*i;g[a+8>>2]=f*i+h*c;g[a+12>>2]=0.0;g[a+16>>2]=f*c+h*i;g[a+20>>2]=1.0-(f*e+j*i);g[a+24>>2]=d*i-h*e;g[a+28>>2]=0.0;g[a+32>>2]=f*i-h*c;g[a+36>>2]=d*i+h*e;g[a+40>>2]=1.0-(f*e+d*c);g[a+44>>2]=0.0;return}function hp(a){a=a|0;return}function ip(a){a=a|0;return}function jp(a){a=a|0;_E(a);return}function kp(a,c){a=a|0;c=c|0;if(!((b[c+4>>1]&b[a+14>>1])<<16>>16)){a=0;return a|0}a=(b[a+12>>1]&b[c+6>>1])<<16>>16!=0;return a|0}function lp(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;g[a+4>>2]=+g[b+24>>2];e=c[b>>2]|0;c[a+8>>2]=e;if(d){c[a+52>>2]=c[b+8>>2];c[a+56>>2]=c[b+12>>2];c[a+60>>2]=c[b+16>>2];c[a+64>>2]=c[b+20>>2]}else{k=+g[b+8>>2];j=+g[b+12>>2];i=+g[b+16>>2];h=+g[e+20>>2]*k+ +g[e+24>>2]*j+ +g[e+28>>2]*i;f=+g[e+36>>2]*k+ +g[e+40>>2]*j+ +g[e+44>>2]*i;g[a+52>>2]=+g[e+4>>2]*k+ +g[e+8>>2]*j+ +g[e+12>>2]*i;g[a+56>>2]=h;g[a+60>>2]=f;g[a+64>>2]=0.0}k=+g[b+24>>2];g[a+68>>2]=(1.0-k)*+g[a+20>>2]+ +g[a+36>>2]*k;g[a+72>>2]=(1.0-k)*+g[a+24>>2]+k*+g[a+40>>2];g[a+76>>2]=(1.0-k)*+g[a+28>>2]+k*+g[a+44>>2];return +(+g[b+24>>2])}function mp(a){a=a|0;return}function np(a){a=a|0;return}function op(a){a=a|0;if(!a)return;c[5134]=(c[5134]|0)+1;_E(c[a+-4>>2]|0);return}function pp(a,b){a=a|0;b=b|0;var d=0;d=i;i=i+128|0;co(d,a+68|0);rp(d+64|0,d,a+4|0);c[b+0>>2]=c[d+64>>2];c[b+4>>2]=c[d+68>>2];c[b+8>>2]=c[d+72>>2];c[b+12>>2]=c[d+76>>2];c[b+16>>2]=c[d+80>>2];c[b+20>>2]=c[d+84>>2];c[b+24>>2]=c[d+88>>2];c[b+28>>2]=c[d+92>>2];c[b+32>>2]=c[d+96>>2];c[b+36>>2]=c[d+100>>2];c[b+40>>2]=c[d+104>>2];c[b+44>>2]=c[d+108>>2];c[b+48>>2]=c[d+112>>2];c[b+52>>2]=c[d+116>>2];c[b+56>>2]=c[d+120>>2];c[b+60>>2]=c[d+124>>2];i=d;return}function qp(a,b){a=a|0;b=b|0;var d=0;d=i;i=i+64|0;rp(d,b,a+68|0);c[a+4>>2]=c[d+0>>2];c[a+8>>2]=c[d+4>>2];c[a+12>>2]=c[d+8>>2];c[a+16>>2]=c[d+12>>2];c[a+20>>2]=c[d+16>>2];c[a+24>>2]=c[d+20>>2];c[a+28>>2]=c[d+24>>2];c[a+32>>2]=c[d+28>>2];c[a+36>>2]=c[d+32>>2];c[a+40>>2]=c[d+36>>2];c[a+44>>2]=c[d+40>>2];c[a+48>>2]=c[d+44>>2];c[a+52>>2]=c[d+48>>2];c[a+56>>2]=c[d+52>>2];c[a+60>>2]=c[d+56>>2];c[a+64>>2]=c[d+60>>2];i=d;return}function rp(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0;e=i;i=i+64|0;s=+g[d>>2];y=+g[b>>2];r=+g[d+16>>2];x=+g[b+4>>2];q=+g[d+32>>2];w=+g[b+8>>2];p=+g[d+4>>2];o=+g[d+20>>2];n=+g[d+36>>2];m=+g[d+8>>2];k=+g[d+24>>2];h=+g[d+40>>2];v=+g[b+16>>2];u=+g[b+20>>2];t=+g[b+24>>2];l=+g[b+32>>2];j=+g[b+36>>2];f=+g[b+40>>2];g[e+16>>2]=s*y+r*x+q*w;g[e+20>>2]=p*y+o*x+n*w;g[e+24>>2]=m*y+k*x+h*w;g[e+28>>2]=0.0;g[e+32>>2]=s*v+r*u+q*t;g[e+36>>2]=p*v+o*u+n*t;g[e+40>>2]=m*v+k*u+h*t;g[e+44>>2]=0.0;g[e+48>>2]=s*l+r*j+q*f;g[e+52>>2]=p*l+o*j+n*f;g[e+56>>2]=m*l+k*j+h*f;g[e+60>>2]=0.0;fp(e,b,+g[d+48>>2],+g[d+52>>2],+g[d+56>>2]);c[a+0>>2]=c[e+16>>2];c[a+4>>2]=c[e+20>>2];c[a+8>>2]=c[e+24>>2];c[a+12>>2]=c[e+28>>2];c[a+16>>2]=c[e+32>>2];c[a+20>>2]=c[e+36>>2];c[a+24>>2]=c[e+40>>2];c[a+28>>2]=c[e+44>>2];c[a+32>>2]=c[e+48>>2];c[a+36>>2]=c[e+52>>2];c[a+40>>2]=c[e+56>>2];c[a+44>>2]=c[e+60>>2];c[a+48>>2]=c[e+0>>2];c[a+52>>2]=c[e+4>>2];c[a+56>>2]=c[e+8>>2];c[a+60>>2]=c[e+12>>2];i=e;return}function sp(a){a=a|0;return}function tp(a){a=a|0;_E(a);return}function up(a,c){a=a|0;c=c|0;if(!((b[c+4>>1]&b[a+10>>1])<<16>>16)){a=0;return a|0}a=(b[a+8>>1]&b[c+6>>1])<<16>>16!=0;return a|0}function vp(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;g[a+4>>2]=+g[b+40>>2];e=c[b>>2]|0;c[a+76>>2]=e;if(d){c[a+44>>2]=c[b+8>>2];c[a+48>>2]=c[b+12>>2];c[a+52>>2]=c[b+16>>2];c[a+56>>2]=c[b+20>>2];a=a+60|0;d=b+24|0;c[a+0>>2]=c[d+0>>2];c[a+4>>2]=c[d+4>>2];c[a+8>>2]=c[d+8>>2];c[a+12>>2]=c[d+12>>2];f=+g[b+40>>2];return +f}else{k=+g[b+8>>2];j=+g[b+12>>2];i=+g[b+16>>2];h=+g[e+20>>2]*k+ +g[e+24>>2]*j+ +g[e+28>>2]*i;f=+g[e+36>>2]*k+ +g[e+40>>2]*j+ +g[e+44>>2]*i;g[a+44>>2]=+g[e+4>>2]*k+ +g[e+8>>2]*j+ +g[e+12>>2]*i;g[a+48>>2]=h;g[a+52>>2]=f;g[a+56>>2]=0.0;a=a+60|0;d=b+24|0;c[a+0>>2]=c[d+0>>2];c[a+4>>2]=c[d+4>>2];c[a+8>>2]=c[d+8>>2];c[a+12>>2]=c[d+12>>2];f=+g[b+40>>2];return +f}return 0.0}function wp(a){a=a|0;return}function xp(a){a=a|0;return}function yp(a){a=a|0;_E(a);return}function zp(a,c){a=a|0;c=c|0;if(!((b[c+4>>1]&b[a+6>>1])<<16>>16)){a=0;return a|0}a=(b[a+4>>1]&b[c+6>>1])<<16>>16!=0;return a|0}function Ap(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;return +(+Ta(1248,a|0,b|0,c|0,d|0,e|0,f|0,g|0,h|0))}function Bp(b,d){b=b|0;d=d|0;var e=0.0,f=0,h=0,i=0.0,j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0;c[b+236>>2]=2;c[b+312>>2]=0;c[b+316>>2]=0;c[b+320>>2]=0;c[b+324>>2]=0;c[b+328>>2]=0;c[b+332>>2]=0;c[b+336>>2]=0;c[b+340>>2]=0;g[b+544>>2]=1.0;g[b+548>>2]=1.0;g[b+552>>2]=1.0;g[b+556>>2]=0.0;g[b+348>>2]=1.0;g[b+352>>2]=1.0;g[b+356>>2]=1.0;f=b+360|0;h=f+36|0;do{c[f>>2]=0;f=f+4|0}while((f|0)<(h|0));c[b+412>>2]=0;c[b+416>>2]=0;c[b+420>>2]=0;c[b+424>>2]=0;c[b+428>>2]=0;c[b+432>>2]=0;c[b+436>>2]=0;c[b+440>>2]=0;e=+g[d+92>>2];i=+g[d+96>>2];if(e<0.0)e=0.0;else e=e>1.0?1.0:e;g[b+444>>2]=e;if(i<0.0)e=0.0;else e=i>1.0?1.0:i;g[b+448>>2]=e;g[b+472>>2]=+g[d+112>>2];g[b+476>>2]=+g[d+116>>2];f=c[d+4>>2]|0;c[b+480>>2]=f;c[b+608>>2]=0;c[b+612>>2]=0;a[b+452>>0]=a[d+120>>0]|0;g[b+456>>2]=+g[d+124>>2];g[b+460>>2]=+g[d+128>>2];g[b+464>>2]=+g[d+132>>2];g[b+468>>2]=+g[d+136>>2];if(!f){c[b+4>>2]=c[d+8>>2];c[b+8>>2]=c[d+12>>2];c[b+12>>2]=c[d+16>>2];c[b+16>>2]=c[d+20>>2];c[b+20>>2]=c[d+24>>2];c[b+24>>2]=c[d+28>>2];c[b+28>>2]=c[d+32>>2];c[b+32>>2]=c[d+36>>2];c[b+36>>2]=c[d+40>>2];c[b+40>>2]=c[d+44>>2];c[b+44>>2]=c[d+48>>2];c[b+48>>2]=c[d+52>>2];c[b+52>>2]=c[d+56>>2];c[b+56>>2]=c[d+60>>2];c[b+60>>2]=c[d+64>>2];c[b+64>>2]=c[d+68>>2];h=b+52|0;f=b+20|0;j=b+36|0;k=b+4|0}else{Lb[c[(c[f>>2]|0)+8>>2]&127](f,b+4|0);h=b+52|0;f=b+20|0;j=b+36|0;k=b+4|0}c[b+68>>2]=c[k+0>>2];c[b+72>>2]=c[k+4>>2];c[b+76>>2]=c[k+8>>2];c[b+80>>2]=c[k+12>>2];c[b+84>>2]=c[f+0>>2];c[b+88>>2]=c[f+4>>2];c[b+92>>2]=c[f+8>>2];c[b+96>>2]=c[f+12>>2];c[b+100>>2]=c[j+0>>2];c[b+104>>2]=c[j+4>>2];c[b+108>>2]=c[j+8>>2];c[b+112>>2]=c[j+12>>2];c[b+116>>2]=c[h+0>>2];c[b+120>>2]=c[h+4>>2];c[b+124>>2]=c[h+8>>2];c[b+128>>2]=c[h+12>>2];c[b+132>>2]=0;c[b+136>>2]=0;c[b+140>>2]=0;c[b+144>>2]=0;c[b+148>>2]=0;c[b+152>>2]=0;c[b+156>>2]=0;c[b+160>>2]=0;g[b+224>>2]=+g[d+100>>2];g[b+232>>2]=+g[d+104>>2];g[b+228>>2]=+g[d+108>>2];Lb[c[(c[b>>2]|0)+12>>2]&127](b,c[d+72>>2]|0);f=c[398]|0;c[398]=f+1;c[b+508>>2]=f;i=+g[d>>2];f=c[b+204>>2]|0;if(i==0.0){c[b+204>>2]=f|1;m=0.0}else{c[b+204>>2]=f&-2;m=1.0/i}g[b+344>>2]=m;l=i*+g[b+384>>2];e=i*+g[b+388>>2];g[b+364>>2]=i*+g[b+380>>2];g[b+368>>2]=l;g[b+372>>2]=e;g[b+376>>2]=0.0;e=+g[d+76>>2];if(e!=0.0)l=1.0/e;else l=0.0;e=+g[d+80>>2];if(e!=0.0)i=1.0/e;else i=0.0;e=+g[d+84>>2];if(e!=0.0)e=1.0/e;else e=0.0;g[b+396>>2]=l;g[b+400>>2]=i;g[b+404>>2]=e;g[b+408>>2]=0.0;B=m*+g[b+352>>2];v=m*+g[b+356>>2];g[b+560>>2]=m*+g[b+348>>2];g[b+564>>2]=B;g[b+568>>2]=v;g[b+572>>2]=0.0;v=+g[b+4>>2];B=v*l;u=+g[b+8>>2];A=u*i;t=+g[b+12>>2];z=t*e;s=+g[b+20>>2];y=l*s;r=+g[b+24>>2];x=i*r;q=+g[b+28>>2];w=e*q;p=+g[b+36>>2];o=l*p;n=+g[b+40>>2];m=i*n;l=+g[b+44>>2];i=e*l;g[b+264>>2]=v*B+u*A+t*z;g[b+268>>2]=B*s+A*r+z*q;g[b+272>>2]=B*p+A*n+z*l;g[b+276>>2]=0.0;g[b+280>>2]=v*y+u*x+t*w;g[b+284>>2]=s*y+r*x+q*w;g[b+288>>2]=y*p+x*n+w*l;g[b+292>>2]=0.0;g[b+296>>2]=v*o+u*m+t*i;g[b+300>>2]=s*o+r*m+q*i;g[b+304>>2]=p*o+n*m+l*i;g[b+308>>2]=0.0;c[b+504>>2]=0;c[b+512>>2]=0;c[b+516>>2]=0;c[b+520>>2]=0;c[b+524>>2]=0;c[b+528>>2]=0;c[b+532>>2]=0;c[b+536>>2]=0;c[b+540>>2]=0;i=+g[b+344>>2];l=i*+g[b+352>>2];m=i*+g[b+356>>2];g[b+560>>2]=+g[b+348>>2]*i;g[b+564>>2]=l;g[b+568>>2]=m;f=b+572|0;h=f+36|0;do{c[f>>2]=0;f=f+4|0}while((f|0)<(h|0));return}function Cp(b,d,e,f,h){b=b|0;d=+d;e=e|0;f=f|0;h=h|0;var j=0;j=i;i=i+144|0;g[b+164>>2]=1.0;g[b+168>>2]=1.0;g[b+172>>2]=1.0;g[b+176>>2]=0.0;c[b+180>>2]=0;g[b+184>>2]=999999984306749440.0;c[b+188>>2]=0;c[b+192>>2]=0;c[b+196>>2]=0;c[b+200>>2]=0;c[b+204>>2]=1;c[b+208>>2]=-1;c[b+212>>2]=-1;c[b+216>>2]=1;g[b+220>>2]=0.0;g[b+224>>2]=.5;g[b+228>>2]=0.0;g[b+232>>2]=0.0;c[b+236>>2]=1;c[b+240>>2]=0;g[b+244>>2]=1.0;c[b+248>>2]=0;c[b+252>>2]=0;c[b+256>>2]=0;c[b+260>>2]=0;g[b+4>>2]=1.0;c[b+8>>2]=0;c[b+12>>2]=0;c[b+16>>2]=0;c[b+20>>2]=0;g[b+24>>2]=1.0;c[b+28>>2]=0;c[b+32>>2]=0;c[b+36>>2]=0;c[b+40>>2]=0;g[b+44>>2]=1.0;c[b+48>>2]=0;c[b+52>>2]=0;c[b+56>>2]=0;c[b+60>>2]=0;c[b+64>>2]=0;c[b>>2]=1560;a[b+500>>0]=1;c[b+496>>2]=0;c[b+488>>2]=0;c[b+492>>2]=0;g[j>>2]=d;c[j+4>>2]=e;c[j+72>>2]=f;c[j+76>>2]=c[h+0>>2];c[j+80>>2]=c[h+4>>2];c[j+84>>2]=c[h+8>>2];c[j+88>>2]=c[h+12>>2];g[j+92>>2]=0.0;g[j+96>>2]=0.0;g[j+100>>2]=.5;g[j+104>>2]=0.0;g[j+108>>2]=0.0;g[j+112>>2]=.800000011920929;g[j+116>>2]=1.0;a[j+120>>0]=0;g[j+124>>2]=.004999999888241291;g[j+128>>2]=.009999999776482582;g[j+132>>2]=.009999999776482582;g[j+136>>2]=.009999999776482582;g[j+8>>2]=1.0;c[j+12>>2]=0;c[j+16>>2]=0;c[j+20>>2]=0;c[j+24>>2]=0;g[j+28>>2]=1.0;c[j+32>>2]=0;c[j+36>>2]=0;c[j+40>>2]=0;c[j+44>>2]=0;g[j+48>>2]=1.0;c[j+52>>2]=0;c[j+56>>2]=0;c[j+60>>2]=0;c[j+64>>2]=0;c[j+68>>2]=0;Bp(b,j);i=j;return}function Dp(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,i=0,j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0;if(!(c[a+204>>2]&2)){c[a+68>>2]=c[b+0>>2];c[a+72>>2]=c[b+4>>2];c[a+76>>2]=c[b+8>>2];c[a+80>>2]=c[b+12>>2];c[a+84>>2]=c[b+16>>2];c[a+88>>2]=c[b+20>>2];c[a+92>>2]=c[b+24>>2];c[a+96>>2]=c[b+28>>2];c[a+100>>2]=c[b+32>>2];c[a+104>>2]=c[b+36>>2];c[a+108>>2]=c[b+40>>2];c[a+112>>2]=c[b+44>>2];c[a+116>>2]=c[b+48>>2];c[a+120>>2]=c[b+52>>2];c[a+124>>2]=c[b+56>>2];c[a+128>>2]=c[b+60>>2];d=a+20|0;e=b+16|0;f=a+36|0;h=b+32|0;i=a+52|0;j=b+48|0;k=a+4|0}else{c[a+68>>2]=c[a+4>>2];c[a+72>>2]=c[a+8>>2];c[a+76>>2]=c[a+12>>2];c[a+80>>2]=c[a+16>>2];c[a+84>>2]=c[a+20>>2];c[a+88>>2]=c[a+24>>2];c[a+92>>2]=c[a+28>>2];c[a+96>>2]=c[a+32>>2];c[a+100>>2]=c[a+36>>2];c[a+104>>2]=c[a+40>>2];c[a+108>>2]=c[a+44>>2];c[a+112>>2]=c[a+48>>2];c[a+116>>2]=c[a+52>>2];c[a+120>>2]=c[a+56>>2];c[a+124>>2]=c[a+60>>2];c[a+128>>2]=c[a+64>>2];d=a+20|0;e=b+16|0;f=a+36|0;h=b+32|0;i=a+52|0;j=b+48|0;k=a+4|0}c[a+132>>2]=c[a+312>>2];c[a+136>>2]=c[a+316>>2];c[a+140>>2]=c[a+320>>2];c[a+144>>2]=c[a+324>>2];c[a+148>>2]=c[a+328>>2];c[a+152>>2]=c[a+332>>2];c[a+156>>2]=c[a+336>>2];c[a+160>>2]=c[a+340>>2];c[k+0>>2]=c[b+0>>2];c[k+4>>2]=c[b+4>>2];c[k+8>>2]=c[b+8>>2];c[k+12>>2]=c[b+12>>2];c[d+0>>2]=c[e+0>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];c[f+0>>2]=c[h+0>>2];c[f+4>>2]=c[h+4>>2];c[f+8>>2]=c[h+8>>2];c[f+12>>2]=c[h+12>>2];c[i+0>>2]=c[j+0>>2];c[i+4>>2]=c[j+4>>2];c[i+8>>2]=c[j+8>>2];c[i+12>>2]=c[j+12>>2];w=+g[a+4>>2];q=+g[a+396>>2];v=+g[a+8>>2];o=+g[a+400>>2];u=+g[a+12>>2];m=+g[a+404>>2];t=+g[a+20>>2];s=+g[a+24>>2];r=+g[a+28>>2];p=+g[a+36>>2];n=+g[a+40>>2];l=+g[a+44>>2];g[a+264>>2]=w*(w*q)+v*(v*o)+u*(u*m);g[a+268>>2]=w*q*t+v*o*s+u*m*r;g[a+272>>2]=w*q*p+v*o*n+u*m*l;g[a+276>>2]=0.0;g[a+280>>2]=w*(q*t)+v*(o*s)+u*(m*r);g[a+284>>2]=t*(q*t)+s*(o*s)+r*(m*r);g[a+288>>2]=q*t*p+o*s*n+m*r*l;g[a+292>>2]=0.0;g[a+296>>2]=w*(q*p)+v*(o*n)+u*(m*l);g[a+300>>2]=t*(q*p)+s*(o*n)+r*(m*l);g[a+304>>2]=p*(q*p)+n*(o*n)+l*(m*l);g[a+308>>2]=0.0;return}function Ep(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;f=(c[d+236>>2]&2|0)==0?0:d;if(!f){g=1;return g|0}g=c[b+488>>2]|0;if((g|0)<=0){g=1;return g|0}d=c[b+496>>2]|0;e=0;while(1){b=c[d+(e<<2)>>2]|0;if(a[b+20>>0]|0){if((c[b+28>>2]|0)==(f|0)){d=0;b=8;break}if((c[b+32>>2]|0)==(f|0)){d=0;b=8;break}}e=e+1|0;if((e|0)>=(g|0)){d=1;b=8;break}}if((b|0)==8)return d|0;return 0}function Fp(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;f=c[b+488>>2]|0;a:do if((f|0)>0){e=c[b+496>>2]|0;h=0;while(1){g=h+1|0;if((c[e+(h<<2)>>2]|0)==(d|0))break;if((g|0)<(f|0))h=g;else break a}if((h|0)!=(f|0)){b=b+256|0;c[b>>2]=1;return}}while(0);if((f|0)==(c[b+492>>2]|0)?(i=(f|0)==0?1:f<<1,(f|0)<(i|0)):0){if(!i)g=0;else{c[5132]=(c[5132]|0)+1;e=ZE((i<<2|3)+16|0)|0;if(!e)f=0;else{c[(e+19&-16)+-4>>2]=e;f=e+19&-16}g=f;f=c[b+488>>2]|0}if((f|0)>0){h=0;do{e=g+(h<<2)|0;if(e)c[e>>2]=c[(c[b+496>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(f|0))}e=c[b+496>>2]|0;if(e){if(a[b+500>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[e+-4>>2]|0);f=c[b+488>>2]|0}c[b+496>>2]=0}a[b+500>>0]=1;c[b+496>>2]=g;c[b+492>>2]=i}e=(c[b+496>>2]|0)+(f<<2)|0;if(e)c[e>>2]=d;c[b+488>>2]=f+1;b=b+256|0;c[b>>2]=1;return}function Gp(a){a=a|0;return 488}function Hp(a,b,e){a=a|0;b=b|0;e=e|0;Ps(a,b,e)|0;g[b+256>>2]=+g[a+264>>2];g[b+260>>2]=+g[a+268>>2];g[b+264>>2]=+g[a+272>>2];g[b+268>>2]=+g[a+276>>2];g[b+272>>2]=+g[a+280>>2];g[b+276>>2]=+g[a+284>>2];g[b+280>>2]=+g[a+288>>2];g[b+284>>2]=+g[a+292>>2];g[b+288>>2]=+g[a+296>>2];g[b+292>>2]=+g[a+300>>2];g[b+296>>2]=+g[a+304>>2];g[b+300>>2]=+g[a+308>>2];g[b+304>>2]=+g[a+312>>2];g[b+308>>2]=+g[a+316>>2];g[b+312>>2]=+g[a+320>>2];g[b+316>>2]=+g[a+324>>2];g[b+320>>2]=+g[a+328>>2];g[b+324>>2]=+g[a+332>>2];g[b+328>>2]=+g[a+336>>2];g[b+332>>2]=+g[a+340>>2];g[b+448>>2]=+g[a+344>>2];g[b+336>>2]=+g[a+544>>2];g[b+340>>2]=+g[a+548>>2];g[b+344>>2]=+g[a+552>>2];g[b+348>>2]=+g[a+556>>2];g[b+352>>2]=+g[a+348>>2];g[b+356>>2]=+g[a+352>>2];g[b+360>>2]=+g[a+356>>2];g[b+364>>2]=+g[a+360>>2];g[b+368>>2]=+g[a+364>>2];g[b+372>>2]=+g[a+368>>2];g[b+376>>2]=+g[a+372>>2];g[b+380>>2]=+g[a+376>>2];g[b+384>>2]=+g[a+380>>2];g[b+388>>2]=+g[a+384>>2];g[b+392>>2]=+g[a+388>>2];g[b+396>>2]=+g[a+392>>2];g[b+400>>2]=+g[a+396>>2];g[b+404>>2]=+g[a+400>>2];g[b+408>>2]=+g[a+404>>2];g[b+412>>2]=+g[a+408>>2];g[b+416>>2]=+g[a+412>>2];g[b+420>>2]=+g[a+416>>2];g[b+424>>2]=+g[a+420>>2];g[b+428>>2]=+g[a+424>>2];g[b+432>>2]=+g[a+428>>2];g[b+436>>2]=+g[a+432>>2];g[b+440>>2]=+g[a+436>>2];g[b+444>>2]=+g[a+440>>2];g[b+452>>2]=+g[a+444>>2];g[b+456>>2]=+g[a+448>>2];c[b+484>>2]=d[a+452>>0];g[b+460>>2]=+g[a+456>>2];g[b+464>>2]=+g[a+460>>2];g[b+468>>2]=+g[a+464>>2];g[b+472>>2]=+g[a+468>>2];g[b+476>>2]=+g[a+472>>2];g[b+480>>2]=+g[a+476>>2];return 1600}function Ip(a,b){a=a|0;b=b|0;var d=0,e=0;d=c[(c[b>>2]|0)+16>>2]|0;e=Nb[c[(c[a>>2]|0)+16>>2]&127](a)|0;e=Wb[d&63](b,e,1)|0;d=Wb[c[(c[a>>2]|0)+20>>2]&63](a,c[e+8>>2]|0,b)|0;Hb[c[(c[b>>2]|0)+20>>2]&31](b,e,d,1497645650,a);return}function Jp(a,b,c,d,e,f,h){a=a|0;b=+b;c=+c;d=+d;e=e|0;f=+f;h=h|0;var j=0.0,k=0.0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0;l=i;i=i+16|0;k=c*f+ +g[a+52>>2];j=d*f+ +g[a+56>>2];g[h+48>>2]=b*f+ +g[a+48>>2];g[h+52>>2]=k;g[h+56>>2]=j;g[h+60>>2]=0.0;j=+g[e>>2];k=+g[e+4>>2];c=+g[e+8>>2];b=+P(+(j*j+k*k+c*c));if(b*f>.7853981852531433)b=.7853981852531433/f;if(b<1.0000000474974513e-03)d=f*.5-b*(f*f*f*.02083333395421505*b);else d=+S(+(b*.5*f))/b;o=d*j;k=d*k;d=d*c;q=+R(+(b*f*.5));Fc(a,l);n=+g[l>>2];p=+g[l+12>>2];b=+g[l+8>>2];f=+g[l+4>>2];r=1.0/+P(+((q*p-o*n-k*f-d*b)*(q*p-o*n-k*f-d*b)+((d*p+q*b+o*f-k*n)*(d*p+q*b+o*f-k*n)+((q*n+o*p+k*b-d*f)*(q*n+o*p+k*b-d*f)+(d*n+(k*p+q*f)-o*b)*(d*n+(k*p+q*f)-o*b)))));c=(q*n+o*p+k*b-d*f)*r;j=r*(d*n+(k*p+q*f)-o*b);m=r*(d*p+q*b+o*f-k*n);b=r*(q*p-o*n-k*f-d*b);d=c*(2.0/(b*b+(m*m+(c*c+j*j))));f=2.0/(b*b+(m*m+(c*c+j*j)))*j;k=2.0/(b*b+(m*m+(c*c+j*j)))*m;g[h>>2]=1.0-(m*k+j*f);g[h+4>>2]=c*f-b*k;g[h+8>>2]=c*k+b*f;g[h+12>>2]=0.0;g[h+16>>2]=b*k+c*f;g[h+20>>2]=1.0-(c*d+m*k);g[h+24>>2]=j*k-b*d;g[h+28>>2]=0.0;g[h+32>>2]=c*k-b*f;g[h+36>>2]=b*d+j*k;g[h+40>>2]=1.0-(c*d+j*f);g[h+44>>2]=0.0;i=l;return}function Kp(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0,f=0.0,h=0.0,j=0.0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0;k=i;i=i+64|0;j=+g[a+20>>2];t=+g[a+40>>2];o=+g[a+24>>2];r=+g[a+36>>2];s=+g[a+32>>2];h=+g[a+16>>2];l=+g[a>>2];f=+g[a+4>>2];p=+g[a+8>>2];m=1.0/((j*t-o*r)*l+f*(o*s-t*h)+(r*h-j*s)*p);z=+g[b>>2];y=+g[b+4>>2];x=+g[b+8>>2];w=+g[b+16>>2];v=+g[b+20>>2];u=+g[b+24>>2];q=+g[b+32>>2];n=+g[b+36>>2];e=+g[b+40>>2];g[k+16>>2]=(j*t-o*r)*m*z+(o*s-t*h)*m*y+(r*h-j*s)*m*x;g[k+20>>2]=z*(m*(r*p-t*f))+y*(m*(t*l-s*p))+m*(s*f-r*l)*x;g[k+24>>2]=z*(m*(o*f-j*p))+y*(m*(h*p-o*l))+m*(j*l-h*f)*x;g[k+28>>2]=0.0;g[k+32>>2]=(j*t-o*r)*m*w+(o*s-t*h)*m*v+(r*h-j*s)*m*u;g[k+36>>2]=m*(r*p-t*f)*w+m*(t*l-s*p)*v+m*(s*f-r*l)*u;g[k+40>>2]=m*(o*f-j*p)*w+m*(h*p-o*l)*v+m*(j*l-h*f)*u;g[k+44>>2]=0.0;g[k+48>>2]=(j*t-o*r)*m*q+(o*s-t*h)*m*n+(r*h-j*s)*m*e;g[k+52>>2]=m*(r*p-t*f)*q+m*(t*l-s*p)*n+m*(s*f-r*l)*e;g[k+56>>2]=m*(o*f-j*p)*q+m*(h*p-o*l)*n+m*(j*l-h*f)*e;g[k+60>>2]=0.0;Fc(k+16|0,k);e=+g[k>>2];f=+g[k+4>>2];h=+g[k+8>>2];l=+g[k+12>>2];j=1.0/+P(+(e*e+f*f+h*h+l*l));g[k>>2]=e*j;g[k+4>>2]=f*j;g[k+8>>2]=h*j;g[k+12>>2]=l*j;l=l*j<-1.0?-1.0:l*j;g[d>>2]=+U(+(l>1.0?1.0:l))*2.0;g[c>>2]=e*j;g[c+4>>2]=f*j;g[c+8>>2]=h*j;g[c+12>>2]=0.0;if(e*j*(e*j)+f*j*(f*j)+h*j*(h*j)<1.4210854715202004e-14){g[c>>2]=1.0;g[c+4>>2]=0.0;g[c+8>>2]=0.0;g[c+12>>2]=0.0;i=k;return}else{z=1.0/+P(+(e*j*(e*j)+f*j*(f*j)+h*j*(h*j)));g[c>>2]=e*j*z;g[c+4>>2]=z*(f*j);g[c+8>>2]=z*(h*j);i=k;return}}function Lp(a,b){a=a|0;b=b|0;c[a+260>>2]=(c[a+260>>2]|0)+1;c[a+192>>2]=b;c[a+200>>2]=b;return}function Mp(b){b=b|0;var d=0;c[b>>2]=1560;d=c[b+496>>2]|0;if(!d){a[b+500>>0]=1;c[b+496>>2]=0;c[b+488>>2]=0;c[b+492>>2]=0}else{if(a[b+500>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}a[b+500>>0]=1;c[b+496>>2]=0;c[b+488>>2]=0;c[b+492>>2]=0}c[5134]=(c[5134]|0)+1;_E(c[b+-4>>2]|0);return}function Np(b){b=b|0;var d=0;c[b>>2]=1560;d=c[b+496>>2]|0;if(d){if(a[b+500>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+496>>2]=0}a[b+500>>0]=1;c[b+496>>2]=0;c[b+488>>2]=0;c[b+492>>2]=0;return}function Op(b){b=b|0;var d=0,e=0,f=0;c[b>>2]=1664;if((a[b+272>>0]|0)!=0?(d=c[b+204>>2]|0,Jb[c[c[d>>2]>>2]&255](d),d=c[b+204>>2]|0,(d|0)!=0):0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}d=c[b+196>>2]|0;if((d|0)!=0?(Jb[c[c[d>>2]>>2]&255](d),e=c[b+196>>2]|0,(e|0)!=0):0){c[5134]=(c[5134]|0)+1;_E(c[e+-4>>2]|0)}if((a[b+273>>0]|0)!=0?(f=c[b+200>>2]|0,Jb[c[c[f>>2]>>2]&255](f),f=c[b+200>>2]|0,(f|0)!=0):0){c[5134]=(c[5134]|0)+1;_E(c[f+-4>>2]|0)}d=c[b+316>>2]|0;if(d){if(a[b+320>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+316>>2]=0}a[b+320>>0]=1;c[b+316>>2]=0;c[b+308>>2]=0;c[b+312>>2]=0;d=c[b+288>>2]|0;if(d){if(a[b+292>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+288>>2]=0}a[b+292>>0]=1;c[b+288>>2]=0;c[b+280>>2]=0;c[b+284>>2]=0;d=c[b+240>>2]|0;if(d){if(a[b+244>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+240>>2]=0}a[b+244>>0]=1;c[b+240>>2]=0;c[b+232>>2]=0;c[b+236>>2]=0;d=c[b+220>>2]|0;if(d){if(a[b+224>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+220>>2]=0}a[b+224>>0]=1;c[b+220>>2]=0;c[b+212>>2]=0;c[b+216>>2]=0;d=c[b+188>>2]|0;if(!d){a[b+192>>0]=1;c[b+188>>2]=0;c[b+180>>2]=0;f=b+184|0;c[f>>2]=0;Zu(b);return}if(a[b+192>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+188>>2]=0;a[b+192>>0]=1;c[b+188>>2]=0;c[b+180>>2]=0;f=b+184|0;c[f>>2]=0;Zu(b);return}function Pp(a){a=a|0;Op(a);if(!a)return;c[5134]=(c[5134]|0)+1;_E(c[a+-4>>2]|0);return}function Qp(a,b){a=a|0;b=+b;var d=0,e=0,f=0,h=0,j=0.0,k=0.0,l=0.0;h=i;i=i+32|0;d=c[a+8>>2]|0;if((d|0)<=0){i=h;return}f=0;do{e=c[(c[a+16>>2]|0)+(f<<2)>>2]|0;e=(c[e+236>>2]&2|0)==0?0:e;if(((e|0)!=0?(c[e+216>>2]|0)!=2:0)?!((c[e+204>>2]&2|0)==0|b!=0.0^1):0){d=c[e+480>>2]|0;if(!d)d=e+4|0;else{Lb[c[(c[d>>2]|0)+8>>2]&127](d,e+4|0);d=e+4|0}k=(+g[e+56>>2]-+g[e+120>>2])*(1.0/b);l=1.0/b*(+g[e+60>>2]-+g[e+124>>2]);g[e+312>>2]=(+g[e+52>>2]-+g[e+116>>2])*(1.0/b);g[e+316>>2]=k;g[e+320>>2]=l;g[e+324>>2]=0.0;Kp(e+68|0,d,h+8|0,h);l=+g[h>>2];k=1.0/b*(l*+g[h+12>>2]);j=1.0/b*(l*+g[h+16>>2]);g[e+328>>2]=1.0/b*(+g[h+8>>2]*l);g[e+332>>2]=k;g[e+336>>2]=j;g[e+340>>2]=0.0;c[e+132>>2]=c[e+312>>2];c[e+136>>2]=c[e+316>>2];c[e+140>>2]=c[e+320>>2];c[e+144>>2]=c[e+324>>2];c[e+148>>2]=c[e+328>>2];c[e+152>>2]=c[e+332>>2];c[e+156>>2]=c[e+336>>2];c[e+160>>2]=c[e+340>>2];c[e+68>>2]=c[d+0>>2];c[e+72>>2]=c[d+4>>2];c[e+76>>2]=c[d+8>>2];c[e+80>>2]=c[d+12>>2];c[e+84>>2]=c[e+20>>2];c[e+88>>2]=c[e+24>>2];c[e+92>>2]=c[e+28>>2];c[e+96>>2]=c[e+32>>2];c[e+100>>2]=c[e+36>>2];c[e+104>>2]=c[e+40>>2];c[e+108>>2]=c[e+44>>2];c[e+112>>2]=c[e+48>>2];c[e+116>>2]=c[e+52>>2];c[e+120>>2]=c[e+56>>2];c[e+124>>2]=c[e+60>>2];c[e+128>>2]=c[e+64>>2];d=c[a+8>>2]|0}f=f+1|0}while((f|0)<(d|0));i=h;return}function Rp(b){b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0,l=0,m=0,n=0,o=0,p=0.0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0.0,J=0.0,K=0.0,L=0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,T=0.0;H=i;i=i+1024|0;jE(1848);kv(b);a:do if((Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0)!=0?(G=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0,((Nb[c[(c[G>>2]|0)+48>>2]&127](G)|0)&6144|0)!=0):0){t=H+812|0;u=H+560|0;v=H+576|0;w=H+592|0;x=H+624|0;y=H+128|0;z=H+640|0;A=H+144|0;B=H+656|0;C=H+160|0;D=H+384|0;E=H+400|0;F=H+416|0;q=H+720|0;r=H+736|0;s=H+752|0;d=Nb[c[(c[b>>2]|0)+104>>2]&127](b)|0;b:while(1){G=d+-1|0;if((d|0)<=0)break a;o=ec[c[(c[b>>2]|0)+108>>2]&31](b,G)|0;d=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;d=(Nb[c[(c[d>>2]|0)+48>>2]&127](d)|0)>>>11;n=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;n=(Nb[c[(c[n>>2]|0)+48>>2]&127](n)|0)>>>12;p=+g[o+40>>2];if(p<=0.0){d=G;continue}switch(c[o+4>>2]|0){case 3:{g[H+768>>2]=1.0;c[H+772>>2]=0;c[H+776>>2]=0;c[H+780>>2]=0;c[H+784>>2]=0;g[H+788>>2]=1.0;c[H+792>>2]=0;c[H+796>>2]=0;c[H+800>>2]=0;c[H+804>>2]=0;g[H+808>>2]=1.0;c[t+0>>2]=0;c[t+4>>2]=0;c[t+8>>2]=0;c[t+12>>2]=0;c[t+16>>2]=0;j=+g[o+300>>2];h=+g[o+304>>2];f=+g[o+308>>2];n=c[o+28>>2]|0;e=j*+g[n+20>>2]+h*+g[n+24>>2]+f*+g[n+28>>2]+ +g[n+56>>2];I=j*+g[n+36>>2]+h*+g[n+40>>2]+f*+g[n+44>>2]+ +g[n+60>>2];g[H+816>>2]=j*+g[n+4>>2]+h*+g[n+8>>2]+f*+g[n+12>>2]+ +g[n+52>>2];g[H+820>>2]=e;g[H+824>>2]=I;g[H+828>>2]=0.0;n=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;rc[c[(c[n>>2]|0)+56>>2]&7](n,H+768|0,p);I=+g[o+316>>2];e=+g[o+320>>2];f=+g[o+324>>2];o=c[o+32>>2]|0;h=I*+g[o+20>>2]+e*+g[o+24>>2]+f*+g[o+28>>2]+ +g[o+56>>2];j=I*+g[o+36>>2]+e*+g[o+40>>2]+f*+g[o+44>>2]+ +g[o+60>>2];g[H+816>>2]=I*+g[o+4>>2]+e*+g[o+8>>2]+f*+g[o+12>>2]+ +g[o+52>>2];g[H+820>>2]=h;g[H+824>>2]=j;g[H+828>>2]=0.0;if(!(d&1)){d=G;continue b}d=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;rc[c[(c[d>>2]|0)+56>>2]&7](d,H+768|0,p);d=G;continue b}case 4:{rp(H,(c[o+28>>2]|0)+4|0,o+552|0);if(!(d&1)){rp(H+544|0,(c[o+32>>2]|0)+4|0,o+616|0);c[H+0>>2]=c[H+544>>2];c[H+4>>2]=c[H+548>>2];c[H+8>>2]=c[H+552>>2];c[H+12>>2]=c[H+556>>2];c[H+16>>2]=c[u+0>>2];c[H+20>>2]=c[u+4>>2];c[H+24>>2]=c[u+8>>2];c[H+28>>2]=c[u+12>>2];c[H+32>>2]=c[v+0>>2];c[H+36>>2]=c[v+4>>2];c[H+40>>2]=c[v+8>>2];c[H+44>>2]=c[v+12>>2];c[H+48>>2]=c[w+0>>2];c[H+52>>2]=c[w+4>>2];c[H+56>>2]=c[w+8>>2];c[H+60>>2]=c[w+12>>2]}else{m=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;rc[c[(c[m>>2]|0)+56>>2]&7](m,H,p);rp(H+544|0,(c[o+32>>2]|0)+4|0,o+616|0);c[H+0>>2]=c[H+544>>2];c[H+4>>2]=c[H+548>>2];c[H+8>>2]=c[H+552>>2];c[H+12>>2]=c[H+556>>2];c[H+16>>2]=c[u+0>>2];c[H+20>>2]=c[u+4>>2];c[H+24>>2]=c[u+8>>2];c[H+28>>2]=c[u+12>>2];c[H+32>>2]=c[v+0>>2];c[H+36>>2]=c[v+4>>2];c[H+40>>2]=c[v+8>>2];c[H+44>>2]=c[v+12>>2];c[H+48>>2]=c[w+0>>2];c[H+52>>2]=c[w+4>>2];c[H+56>>2]=c[w+8>>2];c[H+60>>2]=c[w+12>>2];m=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;rc[c[(c[m>>2]|0)+56>>2]&7](m,H,p)}h=+g[o+688>>2];f=+g[o+692>>2];e=+$E(h-f,6.2831854820251465);if(!(e<-3.1415927410125732))if(e>3.1415927410125732)j=e+-6.2831854820251465;else j=e;else j=e+6.2831854820251465;e=+$E(h+f,6.2831854820251465);if(!(e<-3.1415927410125732)){if(e>3.1415927410125732)e=e+-6.2831854820251465}else e=e+6.2831854820251465;if(j==e){d=G;continue b}d=j>e;if(!(n&1)){d=G;continue b}g[H+352>>2]=+g[H+8>>2];g[H+356>>2]=+g[H+24>>2];g[H+360>>2]=+g[H+40>>2];g[H+364>>2]=0.0;g[H+960>>2]=+g[H>>2];g[H+964>>2]=+g[H+16>>2];g[H+968>>2]=+g[H+32>>2];g[H+972>>2]=0.0;o=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;n=c[(c[o>>2]|0)+60>>2]|0;c[H+96>>2]=0;c[H+100>>2]=0;c[H+104>>2]=0;c[H+108>>2]=0;Ub[n&0](o,H+48|0,H+352|0,H+960|0,p,p,d?0.0:j,d?6.2831854820251465:e,H+96|0,d^1,10.0);d=G;continue b}case 5:{rp(H+608|0,(c[o+28>>2]|0)+4|0,o+300|0);if(!(d&1)){rp(H+112|0,(c[o+32>>2]|0)+4|0,o+364|0);c[H+608>>2]=c[H+112>>2];c[H+612>>2]=c[H+116>>2];c[H+616>>2]=c[H+120>>2];c[H+620>>2]=c[H+124>>2];c[x+0>>2]=c[y+0>>2];c[x+4>>2]=c[y+4>>2];c[x+8>>2]=c[y+8>>2];c[x+12>>2]=c[y+12>>2];c[z+0>>2]=c[A+0>>2];c[z+4>>2]=c[A+4>>2];c[z+8>>2]=c[A+8>>2];c[z+12>>2]=c[A+12>>2];c[B+0>>2]=c[C+0>>2];c[B+4>>2]=c[C+4>>2];c[B+8>>2]=c[C+8>>2];c[B+12>>2]=c[C+12>>2]}else{m=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;rc[c[(c[m>>2]|0)+56>>2]&7](m,H+608|0,p);rp(H+112|0,(c[o+32>>2]|0)+4|0,o+364|0);c[H+608>>2]=c[H+112>>2];c[H+612>>2]=c[H+116>>2];c[H+616>>2]=c[H+120>>2];c[H+620>>2]=c[H+124>>2];c[x+0>>2]=c[y+0>>2];c[x+4>>2]=c[y+4>>2];c[x+8>>2]=c[y+8>>2];c[x+12>>2]=c[y+12>>2];c[z+0>>2]=c[A+0>>2];c[z+4>>2]=c[A+4>>2];c[z+8>>2]=c[A+8>>2];c[z+12>>2]=c[A+12>>2];c[B+0>>2]=c[C+0>>2];c[B+4>>2]=c[C+4>>2];c[B+8>>2]=c[C+8>>2];c[B+12>>2]=c[C+12>>2];m=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;rc[c[(c[m>>2]|0)+56>>2]&7](m,H+608|0,p)}if(!(n&1)){d=G;continue b}yr(H+176|0,o,6.0868353843688965,p);e=+g[H+176>>2];f=+g[H+180>>2];h=+g[H+184>>2];j=e*+g[H+624>>2]+f*+g[H+628>>2]+h*+g[H+632>>2]+ +g[H+660>>2];I=e*+g[H+640>>2]+f*+g[H+644>>2]+h*+g[H+648>>2]+ +g[H+664>>2];g[H+176>>2]=e*+g[H+608>>2]+f*+g[H+612>>2]+h*+g[H+616>>2]+ +g[H+656>>2];g[H+180>>2]=j;g[H+184>>2]=I;g[H+188>>2]=0.0;d=0;do{yr(H+192|0,o,+(d|0)*6.283185005187988*.03125,p);e=+g[H+192>>2];f=+g[H+196>>2];h=+g[H+200>>2];j=e*+g[H+624>>2]+f*+g[H+628>>2]+h*+g[H+632>>2]+ +g[H+660>>2];I=e*+g[H+640>>2]+f*+g[H+644>>2]+h*+g[H+648>>2]+ +g[H+664>>2];g[H+192>>2]=e*+g[H+608>>2]+f*+g[H+612>>2]+h*+g[H+616>>2]+ +g[H+656>>2];g[H+196>>2]=j;g[H+200>>2]=I;g[H+204>>2]=0.0;n=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;m=c[(c[n>>2]|0)+8>>2]|0;c[H+208>>2]=0;c[H+212>>2]=0;c[H+216>>2]=0;c[H+220>>2]=0;tc[m&127](n,H+176|0,H+192|0,H+208|0);if(!(d&3)){n=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;m=c[(c[n>>2]|0)+8>>2]|0;c[H+224>>2]=0;c[H+228>>2]=0;c[H+232>>2]=0;c[H+236>>2]=0;tc[m&127](n,B,H+192|0,H+224|0)};c[H+176>>2]=c[H+192>>2];c[H+180>>2]=c[H+196>>2];c[H+184>>2]=c[H+200>>2];c[H+188>>2]=c[H+204>>2];d=d+1|0}while((d|0)!=32);e=+g[o+452>>2];f=+g[o+512>>2];d=c[o+32>>2]|0;if(+g[d+344>>2]>0.0){rp(H+240|0,d+4|0,o+364|0);c[H+608>>2]=c[H+240>>2];c[H+612>>2]=c[H+244>>2];c[H+616>>2]=c[H+248>>2];c[H+620>>2]=c[H+252>>2];c[x+0>>2]=c[H+256>>2];c[x+4>>2]=c[H+260>>2];c[x+8>>2]=c[H+264>>2];c[x+12>>2]=c[H+268>>2];c[z+0>>2]=c[H+272>>2];c[z+4>>2]=c[H+276>>2];c[z+8>>2]=c[H+280>>2];c[z+12>>2]=c[H+284>>2];c[B+0>>2]=c[H+288>>2];c[B+4>>2]=c[H+292>>2];c[B+8>>2]=c[H+296>>2];c[B+12>>2]=c[H+300>>2]}else{rp(H+832|0,(c[o+28>>2]|0)+4|0,o+300|0);c[H+608>>2]=c[H+832>>2];c[H+612>>2]=c[H+836>>2];c[H+616>>2]=c[H+840>>2];c[H+620>>2]=c[H+844>>2];c[x+0>>2]=c[H+848>>2];c[x+4>>2]=c[H+852>>2];c[x+8>>2]=c[H+856>>2];c[x+12>>2]=c[H+860>>2];c[z+0>>2]=c[H+864>>2];c[z+4>>2]=c[H+868>>2];c[z+8>>2]=c[H+872>>2];c[z+12>>2]=c[H+876>>2];c[B+0>>2]=c[H+880>>2];c[B+4>>2]=c[H+884>>2];c[B+8>>2]=c[H+888>>2];c[B+12>>2]=c[H+892>>2]};c[H+912>>2]=c[B+0>>2];c[H+916>>2]=c[B+4>>2];c[H+920>>2]=c[B+8>>2];c[H+924>>2]=c[B+12>>2];g[H+944>>2]=+g[H+608>>2];g[H+948>>2]=+g[H+624>>2];g[H+952>>2]=+g[H+640>>2];g[H+956>>2]=0.0;g[H+976>>2]=+g[H+612>>2];g[H+980>>2]=+g[H+628>>2];g[H+984>>2]=+g[H+644>>2];g[H+988>>2]=0.0;d=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;o=c[(c[d>>2]|0)+60>>2]|0;c[H+1e3>>2]=0;c[H+1004>>2]=0;c[H+1008>>2]=0;c[H+1012>>2]=0;Ub[o&0](d,H+912|0,H+944|0,H+976|0,p,p,-f-e,e-f,H+1e3|0,1,10.0);d=G;continue b}case 6:case 9:{c[H+368>>2]=c[o+1064>>2];c[H+372>>2]=c[o+1068>>2];c[H+376>>2]=c[o+1072>>2];c[H+380>>2]=c[o+1076>>2];k=o+1080|0;c[D+0>>2]=c[k+0>>2];c[D+4>>2]=c[k+4>>2];c[D+8>>2]=c[k+8>>2];c[D+12>>2]=c[k+12>>2];l=o+1096|0;c[E+0>>2]=c[l+0>>2];c[E+4>>2]=c[l+4>>2];c[E+8>>2]=c[l+8>>2];c[E+12>>2]=c[l+12>>2];m=o+1112|0;c[F+0>>2]=c[m+0>>2];c[F+4>>2]=c[m+4>>2];c[F+8>>2]=c[m+8>>2];c[F+12>>2]=c[m+12>>2];if(!(d&1)){c[H+368>>2]=c[o+1128>>2];c[H+372>>2]=c[o+1132>>2];c[H+376>>2]=c[o+1136>>2];c[H+380>>2]=c[o+1140>>2];c[D+0>>2]=c[o+1144>>2];c[D+4>>2]=c[o+1148>>2];c[D+8>>2]=c[o+1152>>2];c[D+12>>2]=c[o+1156>>2];c[E+0>>2]=c[o+1160>>2];c[E+4>>2]=c[o+1164>>2];c[E+8>>2]=c[o+1168>>2];c[E+12>>2]=c[o+1172>>2];c[F+0>>2]=c[o+1176>>2];c[F+4>>2]=c[o+1180>>2];c[F+8>>2]=c[o+1184>>2];c[F+12>>2]=c[o+1188>>2]}else{d=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;rc[c[(c[d>>2]|0)+56>>2]&7](d,H+368|0,p);c[H+368>>2]=c[o+1128>>2];c[H+372>>2]=c[o+1132>>2];c[H+376>>2]=c[o+1136>>2];c[H+380>>2]=c[o+1140>>2];c[D+0>>2]=c[o+1144>>2];c[D+4>>2]=c[o+1148>>2];c[D+8>>2]=c[o+1152>>2];c[D+12>>2]=c[o+1156>>2];c[E+0>>2]=c[o+1160>>2];c[E+4>>2]=c[o+1164>>2];c[E+8>>2]=c[o+1168>>2];c[E+12>>2]=c[o+1172>>2];c[F+0>>2]=c[o+1176>>2];c[F+4>>2]=c[o+1180>>2];c[F+8>>2]=c[o+1184>>2];c[F+12>>2]=c[o+1188>>2];d=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;rc[c[(c[d>>2]|0)+56>>2]&7](d,H+368|0,p)}if(!(n&1)){d=G;continue b};c[H+368>>2]=c[o+1064>>2];c[H+372>>2]=c[o+1068>>2];c[H+376>>2]=c[o+1072>>2];c[H+380>>2]=c[o+1076>>2];c[D+0>>2]=c[k+0>>2];c[D+4>>2]=c[k+4>>2];c[D+8>>2]=c[k+8>>2];c[D+12>>2]=c[k+12>>2];c[E+0>>2]=c[l+0>>2];c[E+4>>2]=c[l+4>>2];c[E+8>>2]=c[l+8>>2];c[E+12>>2]=c[l+12>>2];c[F+0>>2]=c[m+0>>2];c[F+4>>2]=c[m+4>>2];c[F+8>>2]=c[m+8>>2];c[F+12>>2]=c[m+12>>2];d=o+1176|0;g[H+432>>2]=+g[H+376>>2];g[H+436>>2]=+g[H+392>>2];g[H+440>>2]=+g[H+408>>2];g[H+444>>2]=0.0;g[H+448>>2]=+g[H+368>>2];g[H+452>>2]=+g[H+384>>2];g[H+456>>2]=+g[H+400>>2];g[H+460>>2]=0.0;e=+g[o+932>>2];h=+g[o+936>>2];I=+g[o+996>>2];J=+g[o+1e3>>2];n=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;L=c[(c[n>>2]|0)+64>>2]|0;c[H+464>>2]=0;c[H+468>>2]=0;c[H+472>>2]=0;c[H+476>>2]=0;kc[L&0](n,d,H+432|0,H+448|0,p*.8999999761581421,e,h,I,J,H+464|0,10.0,1);J=+g[H+372>>2];I=+g[H+388>>2];h=+g[H+404>>2];g[H+448>>2]=J;g[H+452>>2]=I;g[H+456>>2]=h;g[H+460>>2]=0.0;e=+g[o+1196>>2];f=+g[o+1200>>2];j=+R(+e);e=+S(+e);K=+R(+f);f=+S(+f);g[H+480>>2]=j*K*J+j*f*I-e*h;g[H+484>>2]=K*I-f*J;g[H+488>>2]=e*K*J+e*f*I+j*h;c[H+368>>2]=c[o+1128>>2];c[H+372>>2]=c[o+1132>>2];c[H+376>>2]=c[o+1136>>2];c[H+380>>2]=c[o+1140>>2];c[D+0>>2]=c[o+1144>>2];c[D+4>>2]=c[o+1148>>2];c[D+8>>2]=c[o+1152>>2];c[D+12>>2]=c[o+1156>>2];c[E+0>>2]=c[o+1160>>2];c[E+4>>2]=c[o+1164>>2];c[E+8>>2]=c[o+1168>>2];c[E+12>>2]=c[o+1172>>2];c[F+0>>2]=c[d+0>>2];c[F+4>>2]=c[d+4>>2];c[F+8>>2]=c[d+8>>2];c[F+12>>2]=c[d+12>>2];h=-+g[H+384>>2];j=-+g[H+400>>2];g[H+496>>2]=-+g[H+368>>2];g[H+500>>2]=h;g[H+504>>2]=j;g[H+508>>2]=0.0;j=+g[o+868>>2];h=+g[o+872>>2];if(!(j>h)){if(j<h){L=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;n=c[(c[L>>2]|0)+60>>2]|0;c[H+528>>2]=0;c[H+532>>2]=0;c[H+536>>2]=0;c[H+540>>2]=0;Ub[n&0](L,d,H+496|0,H+480|0,p,p,j,h,H+528|0,1,10.0)}}else{L=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;n=c[(c[L>>2]|0)+60>>2]|0;c[H+512>>2]=0;c[H+516>>2]=0;c[H+520>>2]=0;c[H+524>>2]=0;Ub[n&0](L,d,H+496|0,H+480|0,p,p,-3.1415927410125732,3.1415927410125732,H+512|0,0,10.0)};c[H+368>>2]=c[o+1064>>2];c[H+372>>2]=c[o+1068>>2];c[H+376>>2]=c[o+1072>>2];c[H+380>>2]=c[o+1076>>2];c[D+0>>2]=c[k+0>>2];c[D+4>>2]=c[k+4>>2];c[D+8>>2]=c[k+8>>2];c[D+12>>2]=c[k+12>>2];c[E+0>>2]=c[l+0>>2];c[E+4>>2]=c[l+4>>2];c[E+8>>2]=c[l+8>>2];c[E+12>>2]=c[l+12>>2];c[F+0>>2]=c[m+0>>2];c[F+4>>2]=c[m+4>>2];c[F+8>>2]=c[m+8>>2];c[F+12>>2]=c[m+12>>2];c[H+64>>2]=c[o+680>>2];c[H+68>>2]=c[o+684>>2];c[H+72>>2]=c[o+688>>2];c[H+76>>2]=c[o+692>>2];c[H+688>>2]=c[o+696>>2];c[H+692>>2]=c[o+700>>2];c[H+696>>2]=c[o+704>>2];c[H+700>>2]=c[o+708>>2];d=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;L=c[(c[d>>2]|0)+72>>2]|0;c[H+672>>2]=0;c[H+676>>2]=0;c[H+680>>2]=0;c[H+684>>2]=0;Hb[L&31](d,H+64|0,H+688|0,H+368|0,H+672|0);d=G;continue b}case 7:{c[H+704>>2]=c[o+824>>2];c[H+708>>2]=c[o+828>>2];c[H+712>>2]=c[o+832>>2];c[H+716>>2]=c[o+836>>2];c[q+0>>2]=c[o+840>>2];c[q+4>>2]=c[o+844>>2];c[q+8>>2]=c[o+848>>2];c[q+12>>2]=c[o+852>>2];c[r+0>>2]=c[o+856>>2];c[r+4>>2]=c[o+860>>2];c[r+8>>2]=c[o+864>>2];c[r+12>>2]=c[o+868>>2];c[s+0>>2]=c[o+872>>2];c[s+4>>2]=c[o+876>>2];c[s+8>>2]=c[o+880>>2];c[s+12>>2]=c[o+884>>2];if(!(d&1)){c[H+704>>2]=c[o+888>>2];c[H+708>>2]=c[o+892>>2];c[H+712>>2]=c[o+896>>2];c[H+716>>2]=c[o+900>>2];c[q+0>>2]=c[o+904>>2];c[q+4>>2]=c[o+908>>2];c[q+8>>2]=c[o+912>>2];c[q+12>>2]=c[o+916>>2];c[r+0>>2]=c[o+920>>2];c[r+4>>2]=c[o+924>>2];c[r+8>>2]=c[o+928>>2];c[r+12>>2]=c[o+932>>2];c[s+0>>2]=c[o+936>>2];c[s+4>>2]=c[o+940>>2];c[s+8>>2]=c[o+944>>2];c[s+12>>2]=c[o+948>>2]}else{L=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;rc[c[(c[L>>2]|0)+56>>2]&7](L,H+704|0,p);c[H+704>>2]=c[o+888>>2];c[H+708>>2]=c[o+892>>2];c[H+712>>2]=c[o+896>>2];c[H+716>>2]=c[o+900>>2];c[q+0>>2]=c[o+904>>2];c[q+4>>2]=c[o+908>>2];c[q+8>>2]=c[o+912>>2];c[q+12>>2]=c[o+916>>2];c[r+0>>2]=c[o+920>>2];c[r+4>>2]=c[o+924>>2];c[r+8>>2]=c[o+928>>2];c[r+12>>2]=c[o+932>>2];c[s+0>>2]=c[o+936>>2];c[s+4>>2]=c[o+940>>2];c[s+8>>2]=c[o+944>>2];c[s+12>>2]=c[o+948>>2];L=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;rc[c[(c[L>>2]|0)+56>>2]&7](L,H+704|0,p)}if(!(n&1)){d=G;continue b}d=(a[o+180>>0]|0)!=0?o+824|0:o+888|0;f=+g[d>>2];K=+g[d+4>>2];h=+g[d+16>>2];J=+g[d+20>>2];j=+g[d+32>>2];I=+g[d+36>>2];T=+g[d+48>>2];P=+g[d+52>>2];N=+g[d+56>>2];e=+g[o+184>>2];Q=+g[d+8>>2]*0.0;O=+g[d+24>>2]*0.0;M=+g[d+40>>2]*0.0;g[H+304>>2]=T+(Q+(K*0.0+f*e));g[H+308>>2]=P+(O+(J*0.0+h*e));g[H+312>>2]=N+(M+(I*0.0+j*e));g[H+316>>2]=0.0;e=+g[o+188>>2];g[H+896>>2]=T+(Q+(K*0.0+f*e));g[H+900>>2]=P+(O+(J*0.0+h*e));g[H+904>>2]=N+(M+(I*0.0+j*e));g[H+908>>2]=0.0;d=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;L=c[(c[d>>2]|0)+8>>2]|0;c[H+320>>2]=0;c[H+324>>2]=0;c[H+328>>2]=0;c[H+332>>2]=0;tc[L&127](d,H+304|0,H+896|0,H+320|0);g[H+928>>2]=f;g[H+932>>2]=h;g[H+936>>2]=j;g[H+940>>2]=0.0;g[H+80>>2]=K;g[H+84>>2]=J;g[H+88>>2]=I;g[H+92>>2]=0.0;I=+g[o+192>>2];J=+g[o+196>>2];d=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;L=c[(c[d>>2]|0)+60>>2]|0;c[H+336>>2]=0;c[H+340>>2]=0;c[H+344>>2]=0;c[H+348>>2]=0;Ub[L&0](d,o+936|0,H+928|0,H+80|0,p,p,I,J,H+336|0,1,10.0);d=G;continue b}default:{d=G;continue b}}}}while(0);if(((((Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0)!=0?(L=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0,((Nb[c[(c[L>>2]|0)+48>>2]&127](L)|0)&16387|0)!=0):0)?(Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0)!=0:0)?(L=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0,(Nb[c[(c[L>>2]|0)+48>>2]&127](L)|0)!=0):0)?(c[b+280>>2]|0)>0:0){d=0;do{L=c[(c[b+288>>2]|0)+(d<<2)>>2]|0;Lb[c[(c[L>>2]|0)+12>>2]&127](L,c[b+72>>2]|0);d=d+1|0}while((d|0)<(c[b+280>>2]|0))}d=c[5128]|0;L=(c[d+16>>2]|0)+-1|0;c[d+16>>2]=L;if(L){i=H;return}do if(c[d+4>>2]|0){Cb(H+992|0,0)|0;L=c[5114]|0;g[d+8>>2]=+(((c[H+996>>2]|0)-(c[L+4>>2]|0)+(((c[H+992>>2]|0)-(c[L>>2]|0)|0)*1e6|0)-(c[d+12>>2]|0)|0)>>>0)/1.0e3+ +g[d+8>>2];if(!(c[d+16>>2]|0)){d=c[5128]|0;break}else{i=H;return}}while(0);c[5128]=c[d+20>>2];i=H;return}function Sp(a){a=a|0;var b=0,d=0;if((c[a+232>>2]|0)<=0)return;b=0;do{d=(c[(c[a+240>>2]|0)+(b<<2)>>2]|0)+412|0;c[d+0>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=0;c[d+20>>2]=0;c[d+24>>2]=0;c[d+28>>2]=0;b=b+1|0}while((b|0)<(c[a+232>>2]|0));return}function Tp(a){a=a|0;var b=0,d=0,e=0,f=0,h=0.0,i=0.0;e=c[a+232>>2]|0;if((e|0)<=0)return;a=c[a+240>>2]|0;d=0;do{b=c[a+(d<<2)>>2]|0;f=c[b+216>>2]|0;if(!((f|0)==2|(f|0)==5)?(c[b+204>>2]&3|0)==0:0){i=+g[b+368>>2]*+g[b+352>>2];h=+g[b+372>>2]*+g[b+356>>2];g[b+412>>2]=+g[b+364>>2]*+g[b+348>>2]+ +g[b+412>>2];g[b+416>>2]=i+ +g[b+416>>2];g[b+420>>2]=h+ +g[b+420>>2]}d=d+1|0}while((d|0)!=(e|0));return}function Up(b){b=b|0;var d=0,e=0.0,f=0,h=0,j=0.0,k=0.0,l=0,m=0;l=i;i=i+144|0;jE(1864);if(!(a[b+274>>0]|0)){d=c[b+232>>2]|0;if((d|0)>0){h=0;do{f=c[(c[b+240>>2]|0)+(h<<2)>>2]|0;m=c[f+216>>2]|0;if((!((m|0)==2|(m|0)==5)?(c[f+480>>2]|0)!=0:0)?(c[f+204>>2]&3|0)==0:0){if((a[b+300>>0]|0)!=0?(k=+g[b+268>>2],k!=0.0):0)e=+g[b+264>>2]-k;else e=+g[b+264>>2]*+g[f+244>>2];Jp(f+68|0,+g[f+132>>2],+g[f+136>>2],+g[f+140>>2],f+148|0,e,l);d=c[f+480>>2]|0;Lb[c[(c[d>>2]|0)+12>>2]&127](d,l);d=c[b+232>>2]|0}h=h+1|0}while((h|0)<(d|0))}}else{d=c[b+8>>2]|0;if((d|0)>0){h=0;do{f=c[(c[b+16>>2]|0)+(h<<2)>>2]|0;f=(c[f+236>>2]&2|0)==0?0:f;if(((f|0)!=0?(c[f+480>>2]|0)!=0:0)?(c[f+204>>2]&3|0)==0:0){if((a[b+300>>0]|0)!=0?(j=+g[b+268>>2],j!=0.0):0)e=+g[b+264>>2]-j;else e=+g[b+264>>2]*+g[f+244>>2];Jp(f+68|0,+g[f+132>>2],+g[f+136>>2],+g[f+140>>2],f+148|0,e,l+64|0);d=c[f+480>>2]|0;Lb[c[(c[d>>2]|0)+12>>2]&127](d,l+64|0);d=c[b+8>>2]|0}h=h+1|0}while((h|0)<(d|0))}}d=c[5128]|0;m=(c[d+16>>2]|0)+-1|0;c[d+16>>2]=m;if(m){i=l;return}do if(c[d+4>>2]|0){Cb(l+128|0,0)|0;m=c[5114]|0;g[d+8>>2]=+(((c[l+132>>2]|0)-(c[m+4>>2]|0)+(((c[l+128>>2]|0)-(c[m>>2]|0)|0)*1e6|0)-(c[d+12>>2]|0)|0)>>>0)/1.0e3+ +g[d+8>>2];if(!(c[d+16>>2]|0)){d=c[5128]|0;break}else{i=l;return}}while(0);c[5128]=c[d+20>>2];i=l;return}
function JA(a){a=a|0;if(!a)return;c[5134]=(c[5134]|0)+1;_E(c[a+-4>>2]|0);return}function KA(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,i=0;g[b+4>>2]=1.0;g[b+8>>2]=1.0;g[b+12>>2]=1.0;g[b+16>>2]=0.0;a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;c[b+48>>2]=0;c[b>>2]=16048;a[b+100>>0]=1;c[b+96>>2]=0;c[b+88>>2]=0;c[b+92>>2]=0;a[b+120>>0]=1;c[b+116>>2]=0;c[b+108>>2]=0;c[b+112>>2]=0;a[b+140>>0]=1;c[b+136>>2]=0;c[b+128>>2]=0;c[b+132>>2]=0;a[b+160>>0]=1;c[b+156>>2]=0;c[b+148>>2]=0;c[b+152>>2]=0;a[b+164>>0]=d&1;a[b+165>>0]=e&1;g[b+168>>2]=0.0;c[5132]=(c[5132]|0)+1;d=ZE(51)|0;if(!d)f=0;else{c[(d+19&-16)+-4>>2]=d;f=d+19&-16}e=c[b+24>>2]|0;if((e|0)>0){d=0;do{h=f+(d<<5)|0;i=(c[b+32>>2]|0)+(d<<5)|0;c[h+0>>2]=c[i+0>>2];c[h+4>>2]=c[i+4>>2];c[h+8>>2]=c[i+8>>2];c[h+12>>2]=c[i+12>>2];c[h+16>>2]=c[i+16>>2];c[h+20>>2]=c[i+20>>2];c[h+24>>2]=c[i+24>>2];c[h+28>>2]=c[i+28>>2];d=d+1|0}while((d|0)!=(e|0))}d=c[b+32>>2]|0;if(d){if(a[b+36>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=f;c[b+28>>2]=1;i=c[b+24>>2]|0;c[f+(i<<5)>>2]=0;c[f+(i<<5)+4>>2]=0;c[f+(i<<5)+8>>2]=12;c[f+(i<<5)+12>>2]=0;c[f+(i<<5)+16>>2]=0;c[f+(i<<5)+20>>2]=16;c[f+(i<<5)+24>>2]=2;c[f+(i<<5)+28>>2]=0;c[b+24>>2]=(c[b+24>>2]|0)+1;if(!(a[b+164>>0]|0)){d=c[b+32>>2]|0;c[d>>2]=(c[b+148>>2]|0)/3|0;c[d+4>>2]=0;c[d+24>>2]=3;c[d+8>>2]=6}else{d=c[b+32>>2]|0;c[d>>2]=(c[b+128>>2]|0)/3|0;c[d+4>>2]=0;c[d+24>>2]=2;c[d+8>>2]=12}if(!(a[b+165>>0]|0)){h=12;b=(c[b+108>>2]|0)/3|0;i=d+12|0;c[i>>2]=b;i=d+16|0;c[i>>2]=0;i=d+20|0;c[i>>2]=h;return}else{h=16;b=c[b+88>>2]|0;i=d+12|0;c[i>>2]=b;i=d+16|0;c[i>>2]=0;i=d+20|0;c[i>>2]=h;return}}function LA(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0;if(!(a[d+164>>0]|0)){g=c[d+148>>2]|0;if((g|0)==(c[d+152>>2]|0)?(k=(g|0)==0?1:g<<1,(g|0)<(k|0)):0){if(!k)f=0;else{c[5132]=(c[5132]|0)+1;f=ZE((k<<1)+19|0)|0;if(!f)f=0;else{c[(f+19&-16)+-4>>2]=f;f=f+19&-16}g=c[d+148>>2]|0}if((g|0)>0){i=0;do{h=f+(i<<1)|0;if(h)b[h>>1]=b[(c[d+156>>2]|0)+(i<<1)>>1]|0;i=i+1|0}while((i|0)!=(g|0))}h=c[d+156>>2]|0;if(h){if(a[d+160>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[h+-4>>2]|0);g=c[d+148>>2]|0}c[d+156>>2]=0}a[d+160>>0]=1;c[d+156>>2]=f;c[d+152>>2]=k}f=c[d+156>>2]|0;h=f+(g<<1)|0;if(h)b[h>>1]=e;c[d+148>>2]=g+1;c[(c[d+32>>2]|0)+4>>2]=f;return}else{f=c[d+128>>2]|0;if((f|0)==(c[d+132>>2]|0)?(j=(f|0)==0?1:f<<1,(f|0)<(j|0)):0){if(!j)i=0;else{c[5132]=(c[5132]|0)+1;f=ZE((j<<2|3)+16|0)|0;if(!f)f=0;else{c[(f+19&-16)+-4>>2]=f;f=f+19&-16}i=f;f=c[d+128>>2]|0}if((f|0)>0){g=0;do{h=i+(g<<2)|0;if(h)c[h>>2]=c[(c[d+136>>2]|0)+(g<<2)>>2];g=g+1|0}while((g|0)!=(f|0))}g=c[d+136>>2]|0;if(g){if(a[d+140>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[g+-4>>2]|0)}c[d+136>>2]=0}a[d+140>>0]=1;c[d+136>>2]=i;c[d+132>>2]=j;f=c[d+128>>2]|0}h=c[d+136>>2]|0;g=h+(f<<2)|0;if(g){c[g>>2]=e;f=c[d+128>>2]|0}c[d+128>>2]=f+1;c[(c[d+32>>2]|0)+4>>2]=h;return}}function MA(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,i=0,j=0,k=0.0,l=0.0,m=0.0,n=0.0,o=0,p=0,q=0.0,r=0.0,s=0.0;if(a[b+165>>0]|0){i=c[b+88>>2]|0;a:do if((i|0)>0&e){j=c[b+96>>2]|0;n=+g[d>>2];k=+g[d+4>>2];l=+g[d+8>>2];m=+g[b+168>>2];f=0;while(1){s=+g[j+(f<<4)>>2]-n;r=+g[j+(f<<4)+4>>2]-k;q=+g[j+(f<<4)+8>>2]-l;if(s*s+r*r+q*q<=m)break;f=f+1|0;if((f|0)>=(i|0))break a}return f|0}while(0);p=(c[b+32>>2]|0)+12|0;c[p>>2]=(c[p>>2]|0)+1;if((i|0)==(c[b+92>>2]|0)?(o=(i|0)==0?1:i<<1,(i|0)<(o|0)):0){if(!o)f=0;else{c[5132]=(c[5132]|0)+1;f=ZE((o<<4|3)+16|0)|0;if(!f)f=0;else{c[(f+19&-16)+-4>>2]=f;f=f+19&-16}i=c[b+88>>2]|0}if((i|0)>0){e=0;do{p=f+(e<<4)|0;j=(c[b+96>>2]|0)+(e<<4)|0;c[p+0>>2]=c[j+0>>2];c[p+4>>2]=c[j+4>>2];c[p+8>>2]=c[j+8>>2];c[p+12>>2]=c[j+12>>2];e=e+1|0}while((e|0)!=(i|0))}e=c[b+96>>2]|0;if(e){if(a[b+100>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[e+-4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=f;c[b+92>>2]=o;f=c[b+88>>2]|0}else f=i;p=(c[b+96>>2]|0)+(f<<4)|0;c[p+0>>2]=c[d+0>>2];c[p+4>>2]=c[d+4>>2];c[p+8>>2]=c[d+8>>2];c[p+12>>2]=c[d+12>>2];p=c[b+88>>2]|0;c[b+88>>2]=p+1;c[(c[b+32>>2]|0)+16>>2]=c[b+96>>2];return p|0}o=c[b+108>>2]|0;b:do if((o|0)>0&e){j=c[b+116>>2]|0;n=+g[d>>2];m=+g[d+4>>2];l=+g[d+8>>2];k=+g[b+168>>2];e=0;while(1){q=+g[j+(e<<2)>>2]-n;r=+g[j+(e+1<<2)>>2]-m;s=+g[j+(e+2<<2)>>2]-l;i=e+3|0;if(q*q+r*r+s*s<=k)break;if((i|0)<(o|0))e=i;else{p=d;break b}}p=(e|0)/3|0;return p|0}else p=d;while(0);e=c[b+112>>2]|0;if((o|0)==(e|0)){f=(o|0)==0?1:o<<1;if((o|0)<(f|0)){if(!f){e=0;h=o}else{c[5132]=(c[5132]|0)+1;e=ZE((f<<2|3)+16|0)|0;if(!e)e=0;else{c[(e+19&-16)+-4>>2]=e;e=e+19&-16}h=c[b+108>>2]|0}if((h|0)>0){i=0;do{j=e+(i<<2)|0;if(j)g[j>>2]=+g[(c[b+116>>2]|0)+(i<<2)>>2];i=i+1|0}while((i|0)!=(h|0))}i=c[b+116>>2]|0;if(i){if(a[b+120>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[i+-4>>2]|0);h=c[b+108>>2]|0}c[b+116>>2]=0}a[b+120>>0]=1;c[b+116>>2]=e;c[b+112>>2]=f;j=f}else{h=o;j=o}}else{h=o;j=e}f=c[b+116>>2]|0;i=f+(h<<2)|0;if(i)g[i>>2]=+g[p>>2];e=h+1|0;c[b+108>>2]=e;if((e|0)==(j|0)){h=(j|0)==0?1:j<<1;if((j|0)<(h|0)){if(!h){f=0;e=j}else{c[5132]=(c[5132]|0)+1;f=ZE((h<<2|3)+16|0)|0;if(!f)f=0;else{c[(f+19&-16)+-4>>2]=f;f=f+19&-16}e=c[b+108>>2]|0}if((e|0)>0){j=0;do{i=f+(j<<2)|0;if(i)g[i>>2]=+g[(c[b+116>>2]|0)+(j<<2)>>2];j=j+1|0}while((j|0)!=(e|0))}i=c[b+116>>2]|0;if(i){if(a[b+120>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[i+-4>>2]|0);e=c[b+108>>2]|0}c[b+116>>2]=0}a[b+120>>0]=1;c[b+116>>2]=f;c[b+112>>2]=h}else{e=j;h=j}}else h=j;i=f+(e<<2)|0;if(i)g[i>>2]=+g[d+4>>2];i=e+1|0;c[b+108>>2]=i;if((i|0)==(h|0)){j=(h|0)==0?1:h<<1;if((h|0)<(j|0)){if(!j)f=0;else{c[5132]=(c[5132]|0)+1;f=ZE((j<<2|3)+16|0)|0;if(!f)f=0;else{c[(f+19&-16)+-4>>2]=f;f=f+19&-16}h=c[b+108>>2]|0}if((h|0)>0){e=0;do{i=f+(e<<2)|0;if(i)g[i>>2]=+g[(c[b+116>>2]|0)+(e<<2)>>2];e=e+1|0}while((e|0)!=(h|0))}i=c[b+116>>2]|0;if(i){if(a[b+120>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[i+-4>>2]|0);h=c[b+108>>2]|0}c[b+116>>2]=0}a[b+120>>0]=1;c[b+116>>2]=f;c[b+112>>2]=j}}else h=i;e=f+(h<<2)|0;if(e)g[e>>2]=+g[d+8>>2];p=h+1|0;c[b+108>>2]=p;o=c[b+32>>2]|0;c[o+12>>2]=(c[o+12>>2]|0)+1;c[o+16>>2]=f;p=((p|0)/3|0)+-1|0;return p|0}function NA(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0;if(a[b+165>>0]|0){if((c[b+92>>2]|0)>=(d|0))return;if((d|0)!=0?(c[5132]=(c[5132]|0)+1,e=ZE((d<<4|3)+16|0)|0,(e|0)!=0):0){c[(e+19&-16)+-4>>2]=e;h=e+19&-16}else h=0;f=c[b+88>>2]|0;if((f|0)>0){e=0;do{i=h+(e<<4)|0;j=(c[b+96>>2]|0)+(e<<4)|0;c[i+0>>2]=c[j+0>>2];c[i+4>>2]=c[j+4>>2];c[i+8>>2]=c[j+8>>2];c[i+12>>2]=c[j+12>>2];e=e+1|0}while((e|0)!=(f|0))}e=c[b+96>>2]|0;if(e){if(a[b+100>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[e+-4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=h;c[b+92>>2]=d;return}if((c[b+112>>2]|0)>=(d|0))return;if((d|0)!=0?(c[5132]=(c[5132]|0)+1,f=ZE((d<<2|3)+16|0)|0,(f|0)!=0):0){c[(f+19&-16)+-4>>2]=f;i=f+19&-16}else i=0;h=c[b+108>>2]|0;if((h|0)>0){e=0;do{f=i+(e<<2)|0;if(f)g[f>>2]=+g[(c[b+116>>2]|0)+(e<<2)>>2];e=e+1|0}while((e|0)!=(h|0))}f=c[b+116>>2]|0;if(f){if(a[b+120>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[f+-4>>2]|0)}c[b+116>>2]=0}a[b+120>>0]=1;c[b+116>>2]=i;c[b+112>>2]=d;return}function OA(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,i=0;if(!(a[d+164>>0]|0)){if((c[d+152>>2]|0)>=(e|0))return;if((e|0)!=0?(c[5132]=(c[5132]|0)+1,g=ZE((e<<1)+19|0)|0,(g|0)!=0):0){c[(g+19&-16)+-4>>2]=g;i=g+19&-16}else i=0;g=c[d+148>>2]|0;if((g|0)>0){h=0;do{f=i+(h<<1)|0;if(f)b[f>>1]=b[(c[d+156>>2]|0)+(h<<1)>>1]|0;h=h+1|0}while((h|0)!=(g|0))}g=c[d+156>>2]|0;if(g){if(a[d+160>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[g+-4>>2]|0)}c[d+156>>2]=0}a[d+160>>0]=1;c[d+156>>2]=i;c[d+152>>2]=e;return}else{if((c[d+132>>2]|0)>=(e|0))return;if((e|0)!=0?(c[5132]=(c[5132]|0)+1,f=ZE((e<<2|3)+16|0)|0,(f|0)!=0):0){c[(f+19&-16)+-4>>2]=f;i=f+19&-16}else i=0;g=c[d+128>>2]|0;if((g|0)>0){h=0;do{f=i+(h<<2)|0;if(f)c[f>>2]=c[(c[d+136>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(g|0))}f=c[d+136>>2]|0;if(f){if(a[d+140>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[f+-4>>2]|0)}c[d+136>>2]=0}a[d+140>>0]=1;c[d+136>>2]=i;c[d+132>>2]=e;return}}function PA(a){a=a|0;return 28}function QA(a){a=a|0;return c[a+24>>2]|0}function RA(a,b){a=a|0;b=b|0;return}function SA(a,b){a=a|0;b=b|0;return}function TA(a){a=a|0;UA(a);if(!a)return;c[5134]=(c[5134]|0)+1;_E(c[a+-4>>2]|0);return}function UA(b){b=b|0;var d=0;c[b>>2]=16048;d=c[b+156>>2]|0;if(d){if(a[b+160>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+156>>2]=0}a[b+160>>0]=1;c[b+156>>2]=0;c[b+148>>2]=0;c[b+152>>2]=0;d=c[b+136>>2]|0;if(d){if(a[b+140>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+136>>2]=0}a[b+140>>0]=1;c[b+136>>2]=0;c[b+128>>2]=0;c[b+132>>2]=0;d=c[b+116>>2]|0;if(d){if(a[b+120>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+116>>2]=0}a[b+120>>0]=1;c[b+116>>2]=0;c[b+108>>2]=0;c[b+112>>2]=0;d=c[b+96>>2]|0;if(d){if(a[b+100>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=0;c[b+88>>2]=0;c[b+92>>2]=0;c[b>>2]=20136;d=c[b+32>>2]|0;if(!d){a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;b=b+28|0;c[b>>2]=0;return}if(a[b+36>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+32>>2]=0;a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;b=b+28|0;c[b>>2]=0;return}function VA(d,f,h,i,j,k){d=d|0;f=f|0;h=h|0;i=i|0;j=j|0;k=k|0;var l=0,m=0.0,n=0.0,o=0.0;c[d>>2]=16336;b[d+4>>1]=-2;b[d+6>>1]=-1;c[d+92>>2]=j;c[d+96>>2]=0;a[d+100>>0]=0;c[d+104>>2]=0;c[d+108>>2]=0;if(!j){c[5132]=(c[5132]|0)+1;j=ZE(95)|0;if((j|0)!=0?(c[(j+19&-16)+-4>>2]=j,(j+19&-16|0)!=0):0){FB(j+19&-16);j=j+19&-16}else j=0;c[d+92>>2]=j;a[d+100>>0]=1}if(!k){c[5132]=(c[5132]|0)+1;j=ZE(43)|0;if((j|0)!=0?(l=j+19&-16,c[l+-4>>2]=j,(j+19&-16|0)!=0):0){c[l+0>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;c[l+12>>2]=0;c[l+16>>2]=0;c[l+20>>2]=0;c[(j+19&-16)>>2]=16400;a[l+20>>0]=1;c[l+16>>2]=0;c[l+8>>2]=0;c[l+12>>2]=0;l=j+19&-16}else l=0;c[d+112>>2]=l;c[5132]=(c[5132]|0)+1;l=ZE(215)|0;if((l|0)!=0?(c[(l+19&-16)+-4>>2]=l,(l+19&-16|0)!=0):0){aC(l+19&-16,c[d+112>>2]|0);l=l+19&-16}else l=0;c[d+108>>2]=l;a[l+193>>0]=1};c[d+8>>2]=c[f+0>>2];c[d+12>>2]=c[f+4>>2];c[d+16>>2]=c[f+8>>2];c[d+20>>2]=c[f+12>>2];c[d+24>>2]=c[h+0>>2];c[d+28>>2]=c[h+4>>2];c[d+32>>2]=c[h+8>>2];c[d+36>>2]=c[h+12>>2];o=+(e[d+6>>1]|0);n=o/(+g[d+28>>2]-+g[d+12>>2]);m=o/(+g[d+32>>2]-+g[d+16>>2]);g[d+40>>2]=o/(+g[d+24>>2]-+g[d+8>>2]);g[d+44>>2]=n;g[d+48>>2]=m;g[d+52>>2]=0.0;h=(i&65535)+1&65535;c[5132]=(c[5132]|0)+1;l=ZE(h<<6|19)|0;if(!l)k=0;else{c[(l+19&-16)+-4>>2]=l;k=l+19&-16}if(h){j=k+(h<<6)|0;l=k;do{c[l>>2]=0;c[l+8>>2]=0;l=l+64|0}while((l|0)!=(j|0))}c[d+60>>2]=k;b[d+58>>1]=(i&65535)+1;b[d+56>>1]=0;b[d+64>>1]=1;if(h>>>0>1){l=1;j=1;do{b[k+(l<<6)+48>>1]=l+1;j=j+1<<16>>16;l=j&65535}while(l>>>0<h>>>0)}b[k+(h+-1<<6)+48>>1]=0;c[5132]=(c[5132]|0)+1;l=ZE((h<<3|3)+16|0)|0;if(!l)l=0;else{c[(l+19&-16)+-4>>2]=l;l=l+19&-16}c[d+80>>2]=l;c[d+68>>2]=l;c[5132]=(c[5132]|0)+1;l=ZE((h<<3|3)+16|0)|0;if(!l)l=0;else{c[(l+19&-16)+-4>>2]=l;l=l+19&-16}c[d+84>>2]=l;c[d+72>>2]=l;c[5132]=(c[5132]|0)+1;l=ZE((h<<3|3)+16|0)|0;if(!l){h=0;i=d+88|0;c[i>>2]=h;i=d+76|0;c[i>>2]=h;h=c[d+60>>2]|0;c[h>>2]=0;f=h+48|0;b[f>>1]=0;f=h+54|0;b[f>>1]=1;f=c[d+68>>2]|0;b[f>>1]=0;k=f+2|0;b[k>>1]=0;k=b[d+6>>1]|0;j=f+4|0;b[j>>1]=k;f=f+6|0;b[f>>1]=0;f=h+50|0;b[f>>1]=0;f=h+56|0;b[f>>1]=1;f=c[d+72>>2]|0;b[f>>1]=0;j=f+2|0;b[j>>1]=0;j=b[d+6>>1]|0;k=f+4|0;b[k>>1]=j;f=f+6|0;b[f>>1]=0;f=h+52|0;b[f>>1]=0;h=h+58|0;b[h>>1]=1;i=c[i>>2]|0;b[i>>1]=0;h=i+2|0;b[h>>1]=0;h=b[d+6>>1]|0;f=i+4|0;b[f>>1]=h;i=i+6|0;b[i>>1]=0;c[d>>2]=16160;return}c[(l+19&-16)+-4>>2]=l;h=l+19&-16;i=d+88|0;c[i>>2]=h;i=d+76|0;c[i>>2]=h;h=c[d+60>>2]|0;c[h>>2]=0;f=h+48|0;b[f>>1]=0;f=h+54|0;b[f>>1]=1;f=c[d+68>>2]|0;b[f>>1]=0;k=f+2|0;b[k>>1]=0;k=b[d+6>>1]|0;j=f+4|0;b[j>>1]=k;f=f+6|0;b[f>>1]=0;f=h+50|0;b[f>>1]=0;f=h+56|0;b[f>>1]=1;f=c[d+72>>2]|0;b[f>>1]=0;j=f+2|0;b[j>>1]=0;j=b[d+6>>1]|0;k=f+4|0;b[k>>1]=j;f=f+6|0;b[f>>1]=0;f=h+52|0;b[f>>1]=0;h=h+58|0;b[h>>1]=1;i=c[i>>2]|0;b[i>>1]=0;h=i+2|0;b[h>>1]=0;h=b[d+6>>1]|0;f=i+4|0;b[f>>1]=h;i=i+6|0;b[i>>1]=0;c[d>>2]=16160;return}function WA(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0;i=c[b+4>>2]|0;if(!((i|0)<=(d|0)&(i|0)<(d|0))){c[b+4>>2]=d;return}if((c[b+8>>2]|0)<(d|0)){if(!d){f=0;g=i}else{c[5132]=(c[5132]|0)+1;f=ZE((d<<4|3)+16|0)|0;if(!f)f=0;else{c[(f+19&-16)+-4>>2]=f;f=f+19&-16}g=c[b+4>>2]|0}if((g|0)>0){h=0;do{j=c[b+12>>2]|0;c[f+(h<<4)>>2]=c[j+(h<<4)>>2];c[f+(h<<4)+4>>2]=c[j+(h<<4)+4>>2];c[f+(h<<4)+8>>2]=c[j+(h<<4)+8>>2];c[f+(h<<4)+12>>2]=c[j+(h<<4)+12>>2];h=h+1|0}while((h|0)!=(g|0))}g=c[b+12>>2]|0;if(g){if(a[b+16>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[g+-4>>2]|0)}c[b+12>>2]=0}a[b+16>>0]=1;c[b+12>>2]=f;c[b+8>>2]=d;g=b+12|0}else g=b+12|0;f=i;do{j=c[g>>2]|0;c[j+(f<<4)>>2]=c[e>>2];c[j+(f<<4)+4>>2]=c[e+4>>2];c[j+(f<<4)+8>>2]=c[e+8>>2];c[j+(f<<4)+12>>2]=c[e+12>>2];f=f+1|0}while((f|0)!=(d|0));c[b+4>>2]=d;return}function XA(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;while(1){r=(b+d|0)/2|0;o=c[a+12>>2]|0;p=c[o+(r<<4)>>2]|0;q=c[o+(r<<4)+4>>2]|0;r=c[o+(r<<4)+8>>2]|0;e=b;f=d;while(1){a:do if(!p)while(1){j=c[o+(e<<4)>>2]|0;if(!j)g=-1;else g=c[j+12>>2]|0;k=c[o+(e<<4)+4>>2]|0;if(!k)h=-1;else h=c[k+12>>2]|0;if(!q)i=-1;else i=c[q+12>>2]|0;do if((g|0)<=-1){g=(j|0)==0&(h|0)>(i|0);if(g|(j|0)==0^1)if(g)break;else break a;if((k|0)!=(q|0))break a;if((c[o+(e<<4)+8>>2]|0)>>>0<=r>>>0)break a}while(0);e=e+1|0}else{m=c[p+12>>2]|0;while(1){l=c[o+(e<<4)>>2]|0;if(!l)j=-1;else j=c[l+12>>2]|0;k=c[o+(e<<4)+4>>2]|0;if(!k)i=-1;else i=c[k+12>>2]|0;if(!q)h=-1;else h=c[q+12>>2]|0;do if((j|0)<=(m|0)){g=(l|0)==(p|0)&(i|0)>(h|0);if(g|(l|0)==(p|0)^1)if(g)break;else break a;if((k|0)!=(q|0))break a;if((c[o+(e<<4)+8>>2]|0)>>>0<=r>>>0)break a}while(0);e=e+1|0}}while(0);b:while(1){if(!p)l=-1;else l=c[p+12>>2]|0;m=c[o+(f<<4)>>2]|0;if(!m)j=-1;else j=c[m+12>>2]|0;if(!q)i=-1;else i=c[q+12>>2]|0;n=c[o+(f<<4)+4>>2]|0;if(!n)h=-1;else h=c[n+12>>2]|0;do if((l|0)<=(j|0)){g=(p|0)==(m|0)&(i|0)>(h|0);if(g|(p|0)==(m|0)^1)if(g)break;else break b;if((q|0)!=(n|0))break b;if(r>>>0<=(c[o+(f<<4)+8>>2]|0)>>>0)break b}while(0);f=f+-1|0}if((e|0)<=(f|0)){j=o+(e<<4)|0;l=c[j>>2]|0;m=c[o+(e<<4)+8>>2]|0;n=c[o+(e<<4)+12>>2]|0;o=o+(f<<4)|0;c[j+0>>2]=c[o+0>>2];c[j+4>>2]=c[o+4>>2];c[j+8>>2]=c[o+8>>2];c[j+12>>2]=c[o+12>>2];o=c[a+12>>2]|0;c[o+(f<<4)>>2]=l;c[o+(f<<4)+4>>2]=k;c[o+(f<<4)+8>>2]=m;c[o+(f<<4)+12>>2]=n;e=e+1|0;f=f+-1|0}if((e|0)>(f|0))break;o=c[a+12>>2]|0}if((f|0)>(b|0))XA(a,b,f);if((e|0)<(d|0))b=e;else break}return}function YA(a){a=a|0;return}function ZA(a,d){a=a|0;d=d|0;var e=0,f=0,g=0;if(b[a+56>>1]|0)return;b[a+64>>1]=1;d=b[a+58>>1]|0;g=c[a+60>>2]|0;if((d&65535)>1){e=1;d=1;while(1){b[g+(e<<6)+48>>1]=e+1;f=d+1<<16>>16;d=b[a+58>>1]|0;if((f&65535)<(d&65535)){e=f&65535;d=f}else break}}b[g+((d&65535)+-1<<6)+48>>1]=0;return}function _A(a,b,d){a=a|0;b=b|0;d=d|0;c[b+0>>2]=c[a+8>>2];c[b+4>>2]=c[a+12>>2];c[b+8>>2]=c[a+16>>2];c[b+12>>2]=c[a+20>>2];c[d+0>>2]=c[a+24>>2];c[d+4>>2]=c[a+28>>2];c[d+8>>2]=c[a+32>>2];c[d+12>>2]=c[a+36>>2];return}function $A(a){a=a|0;return c[a+92>>2]|0}function aB(a){a=a|0;return c[a+92>>2]|0}function bB(a,b){a=a|0;b=b|0;var d=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;r=i;i=i+32|0;q=c[a+92>>2]|0;if(!(Nb[c[(c[q>>2]|0)+56>>2]&127](q)|0)){i=r;return}q=c[a+92>>2]|0;q=Nb[c[(c[q>>2]|0)+28>>2]&127](q)|0;d=c[q+4>>2]|0;if((d|0)>1){XA(q,0,d+-1|0);d=c[q+4>>2]|0}f=d-(c[a+104>>2]|0)|0;c[r+16>>2]=0;c[r+20>>2]=0;c[r+24>>2]=0;c[r+28>>2]=0;WA(q,f,r+16|0);c[a+104>>2]=0;f=c[q+4>>2]|0;if((f|0)>0){g=0;k=0;d=0;p=0;while(1){m=c[q+12>>2]|0;l=m+(p<<4)|0;h=c[l>>2]|0;m=m+(p<<4)+4|0;n=c[m>>2]|0;if((h|0)==(g|0))if((n|0)==(k|0)){h=k;o=12}else o=8;else{g=h;o=8}a:do if((o|0)==8){o=0;h=g+54|0;j=g+48|0;k=0;while(1){if((e[h+(k<<1)>>1]|0)<(e[n+48+(k<<1)>>1]|0)){h=n;o=12;break a}if((e[n+54+(k<<1)>>1]|0)<(e[j+(k<<1)>>1]|0)){h=n;o=12;break a}k=k+1|0;if((k|0)>=3){h=n;break}}}while(0);if((o|0)==12){d=c[a+92>>2]|0;pc[c[(c[d>>2]|0)+32>>2]&127](d,l,b);c[l>>2]=0;c[m>>2]=0;d=(c[a+104>>2]|0)+1|0;c[a+104>>2]=d;c[4140]=(c[4140]|0)+-1;f=c[q+4>>2]|0}p=p+1|0;if((p|0)>=(f|0))break;else k=h}if((f|0)>1){XA(q,0,f+-1|0);f=c[q+4>>2]|0;d=c[a+104>>2]|0}}else d=0;c[r+0>>2]=0;c[r+4>>2]=0;c[r+8>>2]=0;c[r+12>>2]=0;WA(q,f-d|0,r);c[a+104>>2]=0;i=r;return}function cB(a,d,f,h){a=a|0;d=d|0;f=f|0;h=h|0;var i=0,j=0,k=0,l=0,m=0;i=c[a+108>>2]|0;if(i){tc[c[(c[i>>2]|0)+28>>2]&127](i,d,f,h);return}i=b[a+56>>1]|0;if((i&65535)<<1>>>0<=1)return;k=1;m=1;do{j=c[a+68>>2]|0;if(b[j+(k<<2)>>1]&1){l=c[a+60>>2]|0;k=e[j+(k<<2)+2>>1]|0;if(!(+g[d>>2]>+g[l+(k<<6)+32>>2])?!(+g[f>>2]<+g[l+(k<<6)+16>>2]):0)j=1;else j=0;if(!(!(+g[d+8>>2]>+g[l+(k<<6)+40>>2])?!(+g[f+8>>2]<+g[l+(k<<6)+24>>2]):0))j=0;if(!(+g[d+4>>2]>+g[l+(k<<6)+36>>2])?!(+g[f+4>>2]<+g[l+(k<<6)+20>>2]|j^1):0){ec[c[(c[h>>2]|0)+8>>2]&31](h,l+(k<<6)|0)|0;i=b[a+56>>1]|0}}m=m+1<<16>>16;k=m&65535}while(k>>>0<((i&65535)<<1|1)>>>0);return}function dB(a,d,f,g,h,i){a=a|0;d=d|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0;j=c[a+108>>2]|0;if(j){Xb[c[(c[j>>2]|0)+24>>2]&7](j,d,f,g,h,i);return}i=b[a+56>>1]|0;if((i&65535)<<1>>>0<=1)return;f=1;h=1;do{j=c[a+68>>2]|0;if(b[j+(f<<2)>>1]&1){ec[c[(c[g>>2]|0)+8>>2]&31](g,(c[a+60>>2]|0)+((e[j+(f<<2)+2>>1]|0)<<6)|0)|0;i=b[a+56>>1]|0}h=h+1<<16>>16;f=h&65535}while(f>>>0<((i&65535)<<1|1)>>>0);return}function eB(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[d+0>>2]=c[b+16>>2];c[d+4>>2]=c[b+20>>2];c[d+8>>2]=c[b+24>>2];c[d+12>>2]=c[b+28>>2];c[e+0>>2]=c[b+32>>2];c[e+4>>2]=c[b+36>>2];c[e+8>>2]=c[b+40>>2];c[e+12>>2]=c[b+44>>2];return}function fB(a,d,f,h,j){a=a|0;d=d|0;f=f|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0;I=i;i=i+16|0;c[d+16>>2]=c[f+0>>2];c[d+20>>2]=c[f+4>>2];c[d+24>>2]=c[f+8>>2];c[d+28>>2]=c[f+12>>2];c[d+32>>2]=c[h+0>>2];c[d+36>>2]=c[h+4>>2];c[d+40>>2]=c[h+8>>2];c[d+44>>2]=c[h+12>>2];D=c[a+60>>2]|0;E=c[d+12>>2]&65535;iB(a,I+6|0,+g[f>>2],+g[f+4>>2],+g[f+8>>2],0);iB(a,I,+g[h>>2],+g[h+4>>2],+g[h+8>>2],1);H=0;do{t=b[D+(E<<6)+(H<<1)+48>>1]|0;w=b[D+(E<<6)+(H<<1)+54>>1]|0;p=b[I+6+(H<<1)>>1]|0;q=a+(H<<2)+68|0;s=c[q>>2]|0;o=(p&65535)-(e[s+((t&65535)<<2)>>1]|0)|0;r=b[I+(H<<1)>>1]|0;y=(r&65535)-(e[s+((w&65535)<<2)>>1]|0)|0;b[s+((t&65535)<<2)>>1]=p;b[s+((w&65535)<<2)>>1]=r;if((o|0)<0)hB(a,H,t);a:do if((y|0)>0?(z=c[q>>2]|0,A=c[a+60>>2]|0,B=e[z+((w&65535)<<2)+2>>1]|0,C=b[z+((w&65535)+1<<2)+2>>1]|0,C<<16>>16!=0):0){n=1<<H&3;m=A+(B<<6)+(H<<1)+54|0;p=C;r=z+((w&65535)<<2)|0;s=z+((w&65535)+1<<2)|0;while(1){l=b[s>>1]|0;if((e[r>>1]|0)<(l&65535))break a;k=c[a+60>>2]|0;p=p&65535;if(!(l&1)){if(((((e[A+(B<<6)+(n<<1)+54>>1]|0)>=(e[k+(p<<6)+(n<<1)+48>>1]|0)?(e[k+(p<<6)+(n<<1)+54>>1]|0)>=(e[A+(B<<6)+(n<<1)+48>>1]|0):0)?(e[A+(B<<6)+((1<<n&3)<<1)+54>>1]|0)>=(e[k+(p<<6)+((1<<n&3)<<1)+48>>1]|0):0)?(e[k+(p<<6)+((1<<n&3)<<1)+54>>1]|0)>=(e[A+(B<<6)+((1<<n&3)<<1)+48>>1]|0):0)?(G=c[a+92>>2]|0,F=k+((e[r+2>>1]|0)<<6)|0,Wb[c[(c[G>>2]|0)+8>>2]&63](G,F,k+(p<<6)|0)|0,G=c[a+96>>2]|0,(G|0)!=0):0)Wb[c[(c[G>>2]|0)+8>>2]&63](G,F,k+(p<<6)|0)|0;p=k+(p<<6)+(H<<1)+48|0;b[p>>1]=(b[p>>1]|0)+-1<<16>>16}else{p=k+(p<<6)+(H<<1)+54|0;b[p>>1]=(b[p>>1]|0)+-1<<16>>16}b[m>>1]=(b[m>>1]|0)+1<<16>>16;p=e[r>>1]|e[r+2>>1]<<16;l=e[s>>1]|e[s+2>>1]<<16;b[r>>1]=l;b[r+2>>1]=l>>>16;b[s>>1]=p;b[s+2>>1]=p>>>16;p=b[s+6>>1]|0;if(!(p<<16>>16))break;else{r=r+4|0;s=s+4|0}}}while(0);b:do if((o|0)>0?(u=c[q>>2]|0,v=b[u+((t&65535)+1<<2)+2>>1]|0,v<<16>>16!=0):0){o=(c[a+60>>2]|0)+((e[u+((t&65535)<<2)+2>>1]|0)<<6)+(H<<1)+48|0;p=1<<H&3;l=v;q=u+((t&65535)<<2)|0;n=u+((t&65535)+1<<2)|0;while(1){k=b[n>>1]|0;if((e[q>>1]|0)<(k&65535))break b;m=c[a+60>>2]|0;l=l&65535;if(!(k&1)){t=m+(l<<6)+(H<<1)+48|0;b[t>>1]=(b[t>>1]|0)+-1<<16>>16}else{k=e[q+2>>1]|0;if(((((e[m+(k<<6)+(p<<1)+54>>1]|0)>=(e[m+(l<<6)+(p<<1)+48>>1]|0)?(e[m+(l<<6)+(p<<1)+54>>1]|0)>=(e[m+(k<<6)+(p<<1)+48>>1]|0):0)?(e[m+(k<<6)+((1<<p&3)<<1)+54>>1]|0)>=(e[m+(l<<6)+((1<<p&3)<<1)+48>>1]|0):0)?(e[m+(l<<6)+((1<<p&3)<<1)+54>>1]|0)>=(e[m+(k<<6)+((1<<p&3)<<1)+48>>1]|0):0)?(x=c[a+92>>2]|0,Rb[c[(c[x>>2]|0)+12>>2]&31](x,m+(k<<6)|0,m+(l<<6)|0,j)|0,x=c[a+96>>2]|0,(x|0)!=0):0)Rb[c[(c[x>>2]|0)+12>>2]&31](x,m+(k<<6)|0,m+(l<<6)|0,j)|0;t=m+(l<<6)+(H<<1)+54|0;b[t>>1]=(b[t>>1]|0)+-1<<16>>16}b[o>>1]=(b[o>>1]|0)+1<<16>>16;l=e[q>>1]|e[q+2>>1]<<16;t=e[n>>1]|e[n+2>>1]<<16;b[q>>1]=t;b[q+2>>1]=t>>>16;b[n>>1]=l;b[n+2>>1]=l>>>16;l=b[n+6>>1]|0;if(!(l<<16>>16))break;else{q=q+4|0;n=n+4|0}}}while(0);if((y|0)<0)gB(a,H,w,j);H=H+1|0}while((H|0)!=3);k=c[a+108>>2]|0;if(!k){i=I;return}Hb[c[(c[k>>2]|0)+16>>2]&31](k,c[d+60>>2]|0,f,h,j);i=I;return}function gB(a,d,f,g){a=a|0;d=d|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;i=c[a+(d<<2)+68>>2]|0;h=b[i+((f&65535)+-1<<2)>>1]|0;if((e[i+((f&65535)<<2)>>1]|0)>=(h&65535))return;k=c[a+60>>2]|0;l=k+((e[i+((f&65535)<<2)+2>>1]|0)<<6)+(d<<1)+54|0;j=i+((f&65535)<<2)|0;f=i+((f&65535)+-1<<2)|0;while(1){i=e[f+2>>1]|0;if(!(h&1)){h=e[j+2>>1]|0;if(((((e[k+(h<<6)+((1<<d&3)<<1)+54>>1]|0)>=(e[k+(i<<6)+((1<<d&3)<<1)+48>>1]|0)?(e[k+(i<<6)+((1<<d&3)<<1)+54>>1]|0)>=(e[k+(h<<6)+((1<<d&3)<<1)+48>>1]|0):0)?(e[k+(h<<6)+((1<<(1<<d&3)&3)<<1)+54>>1]|0)>=(e[k+(i<<6)+((1<<(1<<d&3)&3)<<1)+48>>1]|0):0)?(e[k+(i<<6)+((1<<(1<<d&3)&3)<<1)+54>>1]|0)>=(e[k+(h<<6)+((1<<(1<<d&3)&3)<<1)+48>>1]|0):0)?(o=c[a+92>>2]|0,m=k+(h<<6)|0,n=k+(i<<6)|0,Rb[c[(c[o>>2]|0)+12>>2]&31](o,m,n,g)|0,o=c[a+96>>2]|0,(o|0)!=0):0)Rb[c[(c[o>>2]|0)+12>>2]&31](o,m,n,g)|0;k=k+(i<<6)+(d<<1)+48|0;b[k>>1]=(b[k>>1]|0)+1<<16>>16}else{k=k+(i<<6)+(d<<1)+54|0;b[k>>1]=(b[k>>1]|0)+1<<16>>16}b[l>>1]=(b[l>>1]|0)+-1<<16>>16;i=e[j>>1]|e[j+2>>1]<<16;h=e[f>>1]|e[f+2>>1]<<16;b[j>>1]=h;b[j+2>>1]=h>>>16;b[f>>1]=i;b[f+2>>1]=i>>>16;i=j+-4|0;f=f+-4|0;h=b[f>>1]|0;if((e[i>>1]|0)>=(h&65535))break;k=c[a+60>>2]|0;j=i}return}function hB(a,d,f){a=a|0;d=d|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;h=c[a+(d<<2)+68>>2]|0;m=c[a+60>>2]|0;n=e[h+((f&65535)<<2)+2>>1]|0;g=b[h+((f&65535)+-1<<2)>>1]|0;if((e[h+((f&65535)<<2)>>1]|0)>=(g&65535))return;j=m;i=h+((f&65535)<<2)|0;f=h+((f&65535)+-1<<2)|0;while(1){h=e[f+2>>1]|0;if(!(g&1)){j=j+(h<<6)+(d<<1)+48|0;b[j>>1]=(b[j>>1]|0)+1<<16>>16}else{if(((((e[m+(n<<6)+((1<<d&3)<<1)+54>>1]|0)>=(e[j+(h<<6)+((1<<d&3)<<1)+48>>1]|0)?(e[j+(h<<6)+((1<<d&3)<<1)+54>>1]|0)>=(e[m+(n<<6)+((1<<d&3)<<1)+48>>1]|0):0)?(e[m+(n<<6)+((1<<(1<<d&3)&3)<<1)+54>>1]|0)>=(e[j+(h<<6)+((1<<(1<<d&3)&3)<<1)+48>>1]|0):0)?(e[j+(h<<6)+((1<<(1<<d&3)&3)<<1)+54>>1]|0)>=(e[m+(n<<6)+((1<<(1<<d&3)&3)<<1)+48>>1]|0):0)?(l=c[a+92>>2]|0,k=j+(h<<6)|0,Wb[c[(c[l>>2]|0)+8>>2]&63](l,m+(n<<6)|0,k)|0,l=c[a+96>>2]|0,(l|0)!=0):0)Wb[c[(c[l>>2]|0)+8>>2]&63](l,m+(n<<6)|0,k)|0;j=j+(h<<6)+(d<<1)+54|0;b[j>>1]=(b[j>>1]|0)+1<<16>>16}b[m+(n<<6)+(d<<1)+48>>1]=(b[m+(n<<6)+(d<<1)+48>>1]|0)+-1<<16>>16;h=e[i>>1]|e[i+2>>1]<<16;g=e[f>>1]|e[f+2>>1]<<16;b[i>>1]=g;b[i+2>>1]=g>>>16;b[f>>1]=h;b[f+2>>1]=h>>>16;h=i+-4|0;f=f+-4|0;g=b[f>>1]|0;if((e[h>>1]|0)>=(g&65535))break;j=c[a+60>>2]|0;i=h}return}function iB(a,c,d,e,f,h){a=a|0;c=c|0;d=+d;e=+e;f=+f;h=h|0;var i=0,j=0;d=(d-+g[a+8>>2])*+g[a+40>>2];e=(e-+g[a+12>>2])*+g[a+44>>2];f=(f-+g[a+16>>2])*+g[a+48>>2];do if(!(d<=0.0)){j=b[a+6>>1]|0;i=b[a+4>>1]|0;if(!(d>=+(j&65535|0))){i=i&(~~d&65535)&65535|h;break}else{i=i&j&65535|h;break}}else i=h;while(0);b[c>>1]=i;do if(!(e<=0.0)){j=b[a+6>>1]|0;i=b[a+4>>1]|0;if(!(e>=+(j&65535|0))){i=i&(~~e&65535)&65535|h;break}else{i=i&j&65535|h;break}}else i=h;while(0);b[c+2>>1]=i;if(f<=0.0){h=h&65535;c=c+4|0;b[c>>1]=h;return}j=b[a+6>>1]|0;i=b[a+4>>1]|0;if(!(f>=+(j&65535|0))){h=i&(~~f&65535)&65535|h;h=h&65535;c=c+4|0;b[c>>1]=h;return}else{h=i&j&65535|h;h=h&65535;c=c+4|0;b[c>>1]=h;return}}function jB(a,d,f){a=a|0;d=d|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;g=c[a+108>>2]|0;if(g)pc[c[(c[g>>2]|0)+12>>2]&127](g,c[d+60>>2]|0,f);q=c[d+12>>2]|0;p=c[a+60>>2]|0;o=c[a+92>>2]|0;if(!(Nb[c[(c[o>>2]|0)+56>>2]&127](o)|0)){o=c[a+92>>2]|0;pc[c[(c[o>>2]|0)+16>>2]&127](o,p+((q&65535)<<6)|0,f)}m=e[a+56>>1]|0;f=c[a+60>>2]|0;b[f+54>>1]=(e[f+54>>1]|0)+65534;b[f+56>>1]=(e[f+56>>1]|0)+65534;b[f+58>>1]=(e[f+58>>1]|0)+65534;f=b[a+6>>1]|0;o=0;do{l=a+(o<<2)+68|0;n=c[l>>2]|0;h=e[p+((q&65535)<<6)+(o<<1)+54>>1]|0;b[n+(h<<2)>>1]=f;d=b[n+(h+1<<2)+2>>1]|0;if(!(d<<16>>16))g=n;else{k=(c[a+60>>2]|0)+((e[n+(h<<2)+2>>1]|0)<<6)+(o<<1)+54|0;j=n+(h<<2)|0;g=n+(h+1<<2)|0;while(1){i=b[g>>1]|0;if((e[j>>1]|0)<(i&65535))break;f=c[a+60>>2]|0;h=d&65535;if(!(i&1)){i=f+(h<<6)+(o<<1)+48|0;b[i>>1]=(b[i>>1]|0)+-1<<16>>16}else{i=f+(h<<6)+(o<<1)+54|0;b[i>>1]=(b[i>>1]|0)+-1<<16>>16}b[k>>1]=(b[k>>1]|0)+1<<16>>16;d=e[j>>1]|e[j+2>>1]<<16;i=e[g>>1]|e[g+2>>1]<<16;b[j>>1]=i;b[j+2>>1]=i>>>16;b[g>>1]=d;b[g+2>>1]=d>>>16;d=b[g+6>>1]|0;if(!(d<<16>>16))break;else{j=j+4|0;g=g+4|0}}f=b[a+6>>1]|0;g=c[l>>2]|0}h=e[p+((q&65535)<<6)+(o<<1)+48>>1]|0;b[n+(h<<2)>>1]=f;d=b[g+(h+1<<2)+2>>1]|0;if(d<<16>>16){k=(c[a+60>>2]|0)+((e[g+(h<<2)+2>>1]|0)<<6)+(o<<1)+48|0;j=g+(h<<2)|0;i=g+(h+1<<2)|0;while(1){g=b[i>>1]|0;if((e[j>>1]|0)<(g&65535))break;h=c[a+60>>2]|0;f=d&65535;if(!(g&1)){l=h+(f<<6)+(o<<1)+48|0;b[l>>1]=(b[l>>1]|0)+-1<<16>>16}else{l=h+(f<<6)+(o<<1)+54|0;b[l>>1]=(b[l>>1]|0)+-1<<16>>16}b[k>>1]=(b[k>>1]|0)+1<<16>>16;d=e[j>>1]|e[j+2>>1]<<16;l=e[i>>1]|e[i+2>>1]<<16;b[j>>1]=l;b[j+2>>1]=l>>>16;b[i>>1]=d;b[i+2>>1]=d>>>16;d=b[i+6>>1]|0;if(!(d<<16>>16))break;else{j=j+4|0;i=i+4|0}}f=b[a+6>>1]|0}b[n+((m<<1)+-1<<2)+2>>1]=0;b[n+((m<<1)+-1<<2)>>1]=f;o=o+1|0}while((o|0)!=3);b[(c[a+60>>2]|0)+((q&65535)<<6)+48>>1]=b[a+64>>1]|0;b[a+64>>1]=q;b[a+56>>1]=(b[a+56>>1]|0)+-1<<16>>16;return}function kB(a,d,f,h,j,k,l,m,n){a=a|0;d=d|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;var o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;w=i;i=i+16|0;iB(a,w+6|0,+g[d>>2],+g[d+4>>2],+g[d+8>>2],0);iB(a,w,+g[f>>2],+g[f+4>>2],+g[f+8>>2],1);v=b[a+64>>1]|0;u=c[a+60>>2]|0;b[a+64>>1]=b[u+((v&65535)<<6)+48>>1]|0;p=(b[a+56>>1]|0)+1<<16>>16;b[a+56>>1]=p;c[u+((v&65535)<<6)+12>>2]=v&65535;c[u+((v&65535)<<6)>>2]=j;b[u+((v&65535)<<6)+4>>1]=k;b[u+((v&65535)<<6)+6>>1]=l;c[u+((v&65535)<<6)+8>>2]=n;r=(p&65535)<<1&65534;b[u+54>>1]=(e[u+54>>1]|0)+2;o=c[a+68>>2]|0;n=e[o+(r+-1<<2)>>1]|e[o+(r+-1<<2)+2>>1]<<16;b[o+((r|1)<<2)>>1]=n;b[o+((r|1)<<2)+2>>1]=n>>>16;o=c[a+68>>2]|0;b[o+(r+-1<<2)>>1]=b[w+6>>1]|0;b[o+(r+-1<<2)+2>>1]=v;b[o+(r<<2)>>1]=b[w>>1]|0;b[o+(r<<2)+2>>1]=v;b[u+((v&65535)<<6)+48>>1]=r+-1;b[u+((v&65535)<<6)+54>>1]=(p&65535)<<1;o=(c[a+60>>2]|0)+56|0;b[o>>1]=(e[o>>1]|0)+2;o=c[a+72>>2]|0;n=e[o+(r+-1<<2)>>1]|e[o+(r+-1<<2)+2>>1]<<16;b[o+((r|1)<<2)>>1]=n;b[o+((r|1)<<2)+2>>1]=n>>>16;o=c[a+72>>2]|0;b[o+(r+-1<<2)>>1]=b[w+8>>1]|0;b[o+(r+-1<<2)+2>>1]=v;b[o+(r<<2)>>1]=b[w+2>>1]|0;b[o+(r<<2)+2>>1]=v;b[u+((v&65535)<<6)+50>>1]=r+-1;b[u+((v&65535)<<6)+56>>1]=(p&65535)<<1;o=(c[a+60>>2]|0)+58|0;b[o>>1]=(e[o>>1]|0)+2;o=c[a+76>>2]|0;n=e[o+(r+-1<<2)>>1]|e[o+(r+-1<<2)+2>>1]<<16;b[o+((r|1)<<2)>>1]=n;b[o+((r|1)<<2)+2>>1]=n>>>16;o=c[a+76>>2]|0;b[o+(r+-1<<2)>>1]=b[w+10>>1]|0;b[o+(r+-1<<2)+2>>1]=v;b[o+(r<<2)>>1]=b[w+4>>1]|0;b[o+(r<<2)+2>>1]=v;b[u+((v&65535)<<6)+52>>1]=r+-1;b[u+((v&65535)<<6)+58>>1]=(p&65535)<<1;p=c[a+68>>2]|0;r=e[u+((v&65535)<<6)+48>>1]|0;o=c[a+60>>2]|0;n=b[p+(r+-1<<2)>>1]|0;if((e[p+(r<<2)>>1]|0)<(n&65535)){t=o+((e[p+(r<<2)+2>>1]|0)<<6)+48|0;s=p+(r<<2)|0;q=p+(r+-1<<2)|0;while(1){p=e[q+2>>1]|0;if(!(n&1)){r=o+(p<<6)+48|0;b[r>>1]=(b[r>>1]|0)+1<<16>>16}else{r=o+(p<<6)+54|0;b[r>>1]=(b[r>>1]|0)+1<<16>>16}b[t>>1]=(b[t>>1]|0)+-1<<16>>16;p=e[s>>1]|e[s+2>>1]<<16;n=e[q>>1]|e[q+2>>1]<<16;b[s>>1]=n;b[s+2>>1]=n>>>16;b[q>>1]=p;b[q+2>>1]=p>>>16;p=s+-4|0;q=q+-4|0;n=b[q>>1]|0;if((e[p>>1]|0)>=(n&65535))break;o=c[a+60>>2]|0;s=p}p=c[a+68>>2]|0}o=e[u+((v&65535)<<6)+54>>1]|0;q=p+(o<<2)|0;r=p+(o+-1<<2)|0;n=b[r>>1]|0;a:do if((e[q>>1]|0)<(n&65535)){s=c[a+60>>2]|0;t=s+((e[p+(o<<2)+2>>1]|0)<<6)+54|0;o=r;while(1){p=e[o+2>>1]|0;if(!(n&1)){s=s+(p<<6)+48|0;b[s>>1]=(b[s>>1]|0)+1<<16>>16}else{s=s+(p<<6)+54|0;b[s>>1]=(b[s>>1]|0)+1<<16>>16}b[t>>1]=(b[t>>1]|0)+-1<<16>>16;p=e[q>>1]|e[q+2>>1]<<16;n=e[o>>1]|e[o+2>>1]<<16;b[q>>1]=n;b[q+2>>1]=n>>>16;b[o>>1]=p;b[o+2>>1]=p>>>16;q=q+-4|0;p=o+-4|0;n=b[p>>1]|0;if((e[q>>1]|0)>=(n&65535))break a;s=c[a+60>>2]|0;o=p}}while(0);o=c[a+72>>2]|0;r=e[u+((v&65535)<<6)+50>>1]|0;p=c[a+60>>2]|0;n=b[o+(r+-1<<2)>>1]|0;if((e[o+(r<<2)>>1]|0)<(n&65535)){t=p+((e[o+(r<<2)+2>>1]|0)<<6)+50|0;q=o+(r<<2)|0;r=o+(r+-1<<2)|0;while(1){o=e[r+2>>1]|0;if(!(n&1)){s=p+(o<<6)+50|0;b[s>>1]=(b[s>>1]|0)+1<<16>>16}else{s=p+(o<<6)+56|0;b[s>>1]=(b[s>>1]|0)+1<<16>>16}b[t>>1]=(b[t>>1]|0)+-1<<16>>16;o=e[q>>1]|e[q+2>>1]<<16;n=e[r>>1]|e[r+2>>1]<<16;b[q>>1]=n;b[q+2>>1]=n>>>16;b[r>>1]=o;b[r+2>>1]=o>>>16;q=q+-4|0;o=r+-4|0;n=b[o>>1]|0;if((e[q>>1]|0)>=(n&65535))break;p=c[a+60>>2]|0;r=o}o=c[a+72>>2]|0}p=e[u+((v&65535)<<6)+56>>1]|0;q=o+(p<<2)|0;r=o+(p+-1<<2)|0;n=b[r>>1]|0;b:do if((e[q>>1]|0)<(n&65535)){s=c[a+60>>2]|0;t=s+((e[o+(p<<2)+2>>1]|0)<<6)+56|0;o=r;while(1){p=e[o+2>>1]|0;if(!(n&1)){s=s+(p<<6)+50|0;b[s>>1]=(b[s>>1]|0)+1<<16>>16}else{s=s+(p<<6)+56|0;b[s>>1]=(b[s>>1]|0)+1<<16>>16}b[t>>1]=(b[t>>1]|0)+-1<<16>>16;p=e[q>>1]|e[q+2>>1]<<16;n=e[o>>1]|e[o+2>>1]<<16;b[q>>1]=n;b[q+2>>1]=n>>>16;b[o>>1]=p;b[o+2>>1]=p>>>16;q=q+-4|0;p=o+-4|0;n=b[p>>1]|0;if((e[q>>1]|0)>=(n&65535))break b;s=c[a+60>>2]|0;o=p}}while(0);hB(a,2,b[u+((v&65535)<<6)+52>>1]|0);gB(a,2,b[u+((v&65535)<<6)+58>>1]|0,m);n=c[a+60>>2]|0;o=c[a+108>>2]|0;if(!o){j=n+((v&65535)<<6)|0;i=w;return j|0}c[n+((v&65535)<<6)+60>>2]=nc[c[(c[o>>2]|0)+8>>2]&3](o,d,f,h,j,k,l,m,0)|0;j=n+((v&65535)<<6)|0;i=w;return j|0}function lB(a){a=a|0;mB(a);if(!a)return;c[5134]=(c[5134]|0)+1;_E(c[a+-4>>2]|0);return}function mB(b){b=b|0;var d=0;c[b>>2]=16336;if(c[b+108>>2]|0){d=c[b+112>>2]|0;Jb[c[c[d>>2]>>2]&255](d);d=c[b+112>>2]|0;if(d){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}d=c[b+108>>2]|0;Jb[c[c[d>>2]>>2]&255](d);d=c[b+108>>2]|0;if(d){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}}d=c[b+88>>2]|0;if(d){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}d=c[b+84>>2]|0;if(d){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}d=c[b+80>>2]|0;if(d){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}d=c[b+60>>2]|0;if(d){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}if(!(a[b+100>>0]|0))return;d=c[b+92>>2]|0;Jb[c[c[d>>2]>>2]&255](d);d=c[b+92>>2]|0;if(!d)return;c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0);return}function nB(a){a=a|0;mB(a);if(!a)return;c[5134]=(c[5134]|0)+1;_E(c[a+-4>>2]|0);return}function oB(a,b){a=a|0;b=b|0;return}function pB(a,b){a=a|0;b=b|0;return}function qB(a){a=a|0;return 1}function rB(a,b,c){a=a|0;b=b|0;c=c|0;return 0}function sB(a,b,c){a=a|0;b=b|0;c=c|0;return}function tB(a,b){a=a|0;b=b|0;return}function uB(a,b,c){a=a|0;b=b|0;c=c|0;return}function vB(a){a=a|0;return 0}function wB(a,b,c){a=a|0;b=b|0;c=c|0;return}function xB(a){a=a|0;return a+4|0}function yB(a){a=a|0;return c[a+16>>2]|0}function zB(a){a=a|0;return c[a+16>>2]|0}function AB(a,b,c){a=a|0;b=b|0;c=c|0;return}function BB(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return 0}function CB(a,b,c){a=a|0;b=b|0;c=c|0;return 0}function DB(b){b=b|0;var d=0;c[b>>2]=16400;d=c[b+16>>2]|0;if(!d){_E(b);return}if(!(a[b+20>>0]|0)){_E(b);return}c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0);_E(b);return}function EB(b){b=b|0;var d=0;c[b>>2]=16400;d=c[b+16>>2]|0;if(d){if(a[b+20>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;return}function FB(b){b=b|0;var d=0,e=0,f=0,g=0;c[b>>2]=16600;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;c[b+24>>2]=0;a[b+28>>0]=0;a[b+48>>0]=1;c[b+44>>2]=0;c[b+36>>2]=0;c[b+40>>2]=0;a[b+68>>0]=1;c[b+64>>2]=0;c[b+56>>2]=0;c[b+60>>2]=0;c[b+72>>2]=0;c[5132]=(c[5132]|0)+1;d=ZE(51)|0;if(!d)f=0;else{c[(d+19&-16)+-4>>2]=d;f=d+19&-16}d=c[b+8>>2]|0;if((d|0)>0){e=0;do{g=c[b+16>>2]|0;c[f+(e<<4)>>2]=c[g+(e<<4)>>2];c[f+(e<<4)+4>>2]=c[g+(e<<4)+4>>2];c[f+(e<<4)+8>>2]=c[g+(e<<4)+8>>2];c[f+(e<<4)+12>>2]=c[g+(e<<4)+12>>2];e=e+1|0}while((e|0)!=(d|0))}d=c[b+16>>2]|0;if(!d){a[b+20>>0]=1;c[b+16>>2]=f;c[b+12>>2]=2;GB(b);return}if(a[b+20>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+16>>2]=0;a[b+20>>0]=1;c[b+16>>2]=f;c[b+12>>2]=2;GB(b);return}function GB(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0;i=c[b+12>>2]|0;j=c[b+36>>2]|0;if((j|0)>=(i|0))return;if((j|0)<=(i|0)){if((c[b+40>>2]|0)<(i|0)){if(!i){d=0;g=j}else{c[5132]=(c[5132]|0)+1;d=ZE((i<<2|3)+16|0)|0;if(!d)d=0;else{c[(d+19&-16)+-4>>2]=d;d=d+19&-16}g=c[b+36>>2]|0}if((g|0)>0){e=0;do{f=d+(e<<2)|0;if(f)c[f>>2]=c[(c[b+44>>2]|0)+(e<<2)>>2];e=e+1|0}while((e|0)!=(g|0))}e=c[b+44>>2]|0;if(e){if(a[b+48>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[e+-4>>2]|0)}c[b+44>>2]=0}a[b+48>>0]=1;c[b+44>>2]=d;c[b+40>>2]=i}else d=c[b+44>>2]|0;g=j;do{e=d+(g<<2)|0;if(e)c[e>>2]=0;g=g+1|0}while((g|0)!=(i|0))}c[b+36>>2]=i;g=c[b+56>>2]|0;if((g|0)<(i|0)){if((c[b+60>>2]|0)<(i|0)){if(!i){e=0;f=g}else{c[5132]=(c[5132]|0)+1;e=ZE((i<<2|3)+16|0)|0;if(!e)e=0;else{c[(e+19&-16)+-4>>2]=e;e=e+19&-16}f=c[b+56>>2]|0}if((f|0)>0){h=0;do{d=e+(h<<2)|0;if(d)c[d>>2]=c[(c[b+64>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(f|0))}d=c[b+64>>2]|0;if(d){if(a[b+68>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+64>>2]=0}a[b+68>>0]=1;c[b+64>>2]=e;c[b+60>>2]=i}else e=c[b+64>>2]|0;do{d=e+(g<<2)|0;if(d)c[d>>2]=0;g=g+1|0}while((g|0)!=(i|0))}c[b+56>>2]=i;if((i|0)>0){cF(c[b+44>>2]|0,-1,i<<2|0)|0;cF(c[b+64>>2]|0,-1,i<<2|0)|0}if((j|0)<=0)return;e=c[b+16>>2]|0;d=c[b+44>>2]|0;f=c[b+64>>2]|0;g=0;do{i=c[(c[e+(g<<4)+4>>2]|0)+12>>2]<<16|c[(c[e+(g<<4)>>2]|0)+12>>2];i=(i+~(i<<15)>>10^i+~(i<<15))*9|0;i=d+((((i>>6^i)+~((i>>6^i)<<11)>>16^(i>>6^i)+~((i>>6^i)<<11))&(c[b+12>>2]|0)+-1)<<2)|0;c[f+(g<<2)>>2]=c[i>>2];c[i>>2]=g;g=g+1|0}while((g|0)!=(j|0));return}function HB(b){b=b|0;var d=0;c[b>>2]=16600;d=c[b+64>>2]|0;if(d){if(a[b+68>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+64>>2]=0}a[b+68>>0]=1;c[b+64>>2]=0;c[b+56>>2]=0;c[b+60>>2]=0;d=c[b+44>>2]|0;if(d){if(a[b+48>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+44>>2]=0}a[b+48>>0]=1;c[b+44>>2]=0;c[b+36>>2]=0;c[b+40>>2]=0;d=c[b+16>>2]|0;if(!d){a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;b=b+12|0;c[b>>2]=0;return}if(a[b+20>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+16>>2]=0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;b=b+12|0;c[b>>2]=0;return}function IB(a){a=a|0;HB(a);_E(a);return}function JB(a,b,d){a=a|0;b=b|0;d=d|0;a=c[b+8>>2]|0;if(!((a|0)!=0&(d|0)!=0))return;Jb[c[c[a>>2]>>2]&255](a);Lb[c[(c[d>>2]|0)+60>>2]&127](d,c[b+8>>2]|0);c[b+8>>2]=0;return}function KB(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;i=i+16|0;c[e>>2]=16904;c[e+4>>2]=b;c[e+8>>2]=a;c[e+12>>2]=d;pc[c[(c[a>>2]|0)+48>>2]&127](a,e,d);i=e;return}function LB(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;i=i+16|0;c[e>>2]=16728;c[e+4>>2]=b;pc[c[(c[a>>2]|0)+48>>2]&127](a,e,d);i=e;return}function MB(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;c[4146]=(c[4146]|0)+1;e=(c[b+12>>2]|0)>(c[d+12>>2]|0);f=c[(e?d:b)+12>>2]|0;e=c[(e?b:d)+12>>2]|0;b=((e<<16|f)+~((e<<16|f)<<15)>>10^(e<<16|f)+~((e<<16|f)<<15))*9|0;b=((b>>6^b)+~((b>>6^b)<<11)>>16^(b>>6^b)+~((b>>6^b)<<11))&(c[a+12>>2]|0)+-1;if((b|0)>=(c[a+36>>2]|0)){g=0;return g|0}d=c[(c[a+44>>2]|0)+(b<<2)>>2]|0;if((d|0)==-1){g=0;return g|0}b=c[a+16>>2]|0;while(1){if((c[(c[b+(d<<4)>>2]|0)+12>>2]|0)==(f|0)?(c[(c[b+(d<<4)+4>>2]|0)+12>>2]|0)==(e|0):0)break;d=c[(c[a+64>>2]|0)+(d<<2)>>2]|0;if((d|0)==-1){b=0;g=8;break}}if((g|0)==8)return b|0;g=b+(d<<4)|0;return g|0}function NB(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;c[4142]=(c[4142]|0)+1;j=(c[b+12>>2]|0)>(c[d+12>>2]|0);l=j?d:b;j=j?b:d;g=c[l+12>>2]|0;f=c[j+12>>2]|0;i=((f<<16|g)+~((f<<16|g)<<15)>>10^(f<<16|g)+~((f<<16|g)<<15))*9|0;i=((i>>6^i)+~((i>>6^i)<<11)>>16^(i>>6^i)+~((i>>6^i)<<11))&(c[a+12>>2]|0)+-1;d=c[(c[a+44>>2]|0)+(i<<2)>>2]|0;if((d|0)==-1){o=0;return o|0}h=c[a+16>>2]|0;b=d;while(1){if((c[(c[h+(b<<4)>>2]|0)+12>>2]|0)==(g|0)?(c[(c[h+(b<<4)+4>>2]|0)+12>>2]|0)==(f|0):0)break;d=c[(c[a+64>>2]|0)+(b<<2)>>2]|0;if((d|0)==-1){b=0;o=24;break}else b=d}if((o|0)==24)return b|0;d=h+(b<<4)|0;if(!d){o=0;return o|0}pc[c[(c[a>>2]|0)+32>>2]&127](a,d,e);n=c[h+(b<<4)+12>>2]|0;m=d-(c[a+16>>2]|0)>>4;i=(c[a+44>>2]|0)+(i<<2)|0;d=c[i>>2]|0;f=c[a+64>>2]|0;if((d|0)!=(m|0)){b=d;while(1){h=f+(b<<2)|0;g=c[h>>2]|0;if((g|0)==(m|0))break;else b=g}d=c[f+(m<<2)>>2]|0;if((b|0)==-1)o=12;else c[h>>2]=d}else{d=c[f+(m<<2)>>2]|0;o=12}if((o|0)==12)c[i>>2]=d;k=(c[a+8>>2]|0)+-1|0;d=c[a+72>>2]|0;if(d)Rb[c[(c[d>>2]|0)+12>>2]&31](d,l,j,e)|0;if((k|0)==(m|0)){c[a+8>>2]=(c[a+8>>2]|0)+-1;o=n;return o|0}j=c[a+16>>2]|0;e=c[(c[j+(k<<4)+4>>2]|0)+12>>2]<<16|c[(c[j+(k<<4)>>2]|0)+12>>2];e=(e+~(e<<15)>>10^e+~(e<<15))*9|0;e=((e>>6^e)+~((e>>6^e)<<11)>>16^(e>>6^e)+~((e>>6^e)<<11))&(c[a+12>>2]|0)+-1;i=(c[a+44>>2]|0)+(e<<2)|0;d=c[i>>2]|0;f=c[a+64>>2]|0;if((d|0)!=(k|0)){h=d;while(1){b=f+(h<<2)|0;g=c[b>>2]|0;if((g|0)==(k|0))break;else h=g}d=c[f+(k<<2)>>2]|0;if((h|0)==-1)o=22;else c[b>>2]=d}else{d=c[f+(k<<2)>>2]|0;o=22}if((o|0)==22)c[i>>2]=d;c[j+(m<<4)+0>>2]=c[j+(k<<4)+0>>2];c[j+(m<<4)+4>>2]=c[j+(k<<4)+4>>2];c[j+(m<<4)+8>>2]=c[j+(k<<4)+8>>2];c[j+(m<<4)+12>>2]=c[j+(k<<4)+12>>2];o=(c[a+44>>2]|0)+(e<<2)|0;c[(c[a+64>>2]|0)+(m<<2)>>2]=c[o>>2];c[o>>2]=m;c[a+8>>2]=(c[a+8>>2]|0)+-1;o=n;return o|0}function OB(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;if((c[a+8>>2]|0)<=0)return;g=0;a:while(1){while(1){e=c[a+16>>2]|0;f=e+(g<<4)|0;if(!(ec[c[(c[b>>2]|0)+8>>2]&31](b,f)|0))break;Rb[c[(c[a>>2]|0)+12>>2]&31](a,c[f>>2]|0,c[e+(g<<4)+4>>2]|0,d)|0;c[4140]=(c[4140]|0)+-1;if((g|0)>=(c[a+8>>2]|0)){e=7;break a}}g=g+1|0;if((g|0)>=(c[a+8>>2]|0)){e=7;break}}if((e|0)==7)return}function PB(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;n=i;i=i+32|0;a[n+16>>0]=1;c[n+12>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;e=c[b+8>>2]|0;if((e|0)>0){g=0;h=0;j=0;m=0;do{l=c[b+16>>2]|0;if((h|0)==(j|0)){k=(j|0)==0?1:j<<1;if((j|0)<(k|0)){if(k){c[5132]=(c[5132]|0)+1;g=ZE((k<<4|3)+16|0)|0;if(!g){g=0;f=h}else{c[(g+19&-16)+-4>>2]=g;g=g+19&-16;f=h}}else{g=0;f=j}if((f|0)>0){e=0;do{j=c[n+12>>2]|0;c[g+(e<<4)>>2]=c[j+(e<<4)>>2];c[g+(e<<4)+4>>2]=c[j+(e<<4)+4>>2];c[g+(e<<4)+8>>2]=c[j+(e<<4)+8>>2];c[g+(e<<4)+12>>2]=c[j+(e<<4)+12>>2];e=e+1|0}while((e|0)!=(f|0))}e=c[n+12>>2]|0;if(e){c[5134]=(c[5134]|0)+1;_E(c[e+-4>>2]|0);c[n+12>>2]=0;f=h}a[n+16>>0]=1;c[n+12>>2]=g;c[n+8>>2]=k;j=k;e=c[b+8>>2]|0}else f=j}else f=h;c[g+(f<<4)>>2]=c[l+(m<<4)>>2];c[g+(f<<4)+4>>2]=c[l+(m<<4)+4>>2];c[g+(f<<4)+8>>2]=c[l+(m<<4)+8>>2];c[g+(f<<4)+12>>2]=c[l+(m<<4)+12>>2];h=f+1|0;m=m+1|0}while((m|0)<(e|0));c[n+4>>2]=h;if((f|0)>-1){e=0;do{Rb[c[(c[b>>2]|0)+12>>2]&31](b,c[g+(e<<4)>>2]|0,c[g+(e<<4)+4>>2]|0,d)|0;e=e+1|0}while((e|0)<(h|0))}}else{h=0;g=0}if((c[b+56>>2]|0)>0){e=c[b+64>>2]|0;f=0;do{c[e+(f<<2)>>2]=-1;f=f+1|0}while((f|0)<(c[b+56>>2]|0))}if((h|0)>1)XA(n,0,h+-1|0);if((h|0)>0){e=0;do{Wb[c[(c[b>>2]|0)+8>>2]&63](b,c[g+(e<<4)>>2]|0,c[g+(e<<4)+4>>2]|0)|0;e=e+1|0}while((e|0)<(h|0))}if(!g){i=n;return}c[5134]=(c[5134]|0)+1;_E(c[g+-4>>2]|0);c[n+12>>2]=0;i=n;return}function QB(a,b){a=a|0;b=b|0;c[a+72>>2]=b;return}function RB(a){a=a|0;return 0}function SB(a,b){a=a|0;b=b|0;c[a+24>>2]=b;return}function TB(a){a=a|0;return c[a+8>>2]|0}function UB(a){a=a|0;return a+4|0}function VB(a){a=a|0;return c[a+16>>2]|0}function WB(a){a=a|0;return c[a+16>>2]|0}function XB(d,e,f){d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;c[4144]=(c[4144]|0)+1;g=c[d+24>>2]|0;if(!g){if(!((b[f+6>>1]&b[e+4>>1])<<16>>16)){d=0;return d|0}if(!((b[e+6>>1]&b[f+4>>1])<<16>>16)){d=0;return d|0}}else if(!(Wb[c[(c[g>>2]|0)+8>>2]&63](g,e,f)|0)){d=0;return d|0}l=(c[e+12>>2]|0)>(c[f+12>>2]|0);m=l?f:e;l=l?e:f;h=c[m+12>>2]|0;e=c[l+12>>2]|0;j=((e<<16|h)+~((e<<16|h)<<15)>>10^(e<<16|h)+~((e<<16|h)<<15))*9|0;j=(j>>6^j)+~((j>>6^j)<<11)>>16^(j>>6^j)+~((j>>6^j)<<11);k=c[d+12>>2]|0;f=c[(c[d+44>>2]|0)+((j&k+-1)<<2)>>2]|0;a:do if((f|0)!=-1){g=c[d+16>>2]|0;while(1){if((c[(c[g+(f<<4)>>2]|0)+12>>2]|0)==(h|0)?(c[(c[g+(f<<4)+4>>2]|0)+12>>2]|0)==(e|0):0)break;f=c[(c[d+64>>2]|0)+(f<<2)>>2]|0;if((f|0)==-1)break a}f=g+(f<<4)|0;if(f){d=f;return d|0}}while(0);i=c[d+8>>2]|0;if((i|0)==(k|0)){f=(k|0)==0?1:k<<1;if((k|0)<(f|0)){if(!f){e=0;g=k}else{c[5132]=(c[5132]|0)+1;e=ZE((f<<4|3)+16|0)|0;if(!e)e=0;else{c[(e+19&-16)+-4>>2]=e;e=e+19&-16}g=c[d+8>>2]|0}if((g|0)>0){h=0;do{n=c[d+16>>2]|0;c[e+(h<<4)>>2]=c[n+(h<<4)>>2];c[e+(h<<4)+4>>2]=c[n+(h<<4)+4>>2];c[e+(h<<4)+8>>2]=c[n+(h<<4)+8>>2];c[e+(h<<4)+12>>2]=c[n+(h<<4)+12>>2];h=h+1|0}while((h|0)!=(g|0))}h=c[d+16>>2]|0;if(h){if(a[d+20>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[h+-4>>2]|0);g=c[d+8>>2]|0}c[d+16>>2]=0}a[d+20>>0]=1;c[d+16>>2]=e;c[d+12>>2]=f}else{g=k;f=k}}else{g=i;f=k}c[d+8>>2]=g+1;h=c[d+16>>2]|0;e=c[d+72>>2]|0;if(e){Wb[c[(c[e>>2]|0)+8>>2]&63](e,m,l)|0;f=c[d+12>>2]|0}if((k|0)<(f|0)){GB(d);f=(c[d+12>>2]|0)+-1&j}else f=j&k+-1;n=(c[m+12>>2]|0)<(c[l+12>>2]|0);c[h+(i<<4)>>2]=n?m:l;c[h+(i<<4)+4>>2]=n?l:m;c[h+(i<<4)+8>>2]=0;c[h+(i<<4)+12>>2]=0;n=(c[d+44>>2]|0)+(f<<2)|0;c[(c[d+64>>2]|0)+(i<<2)>>2]=c[n>>2];c[n>>2]=i;n=h+(i<<4)|0;return n|0}function YB(a,b){a=a|0;b=b|0;a=c[a+4>>2]|0;if((c[b>>2]|0)==(a|0)){b=1;return b|0}b=(c[b+4>>2]|0)==(a|0);return b|0}function ZB(a){a=a|0;_E(a);return}function _B(a,b){a=a|0;b=b|0;var d=0;d=c[a+4>>2]|0;if((c[b>>2]|0)!=(d|0)?(c[b+4>>2]|0)!=(d|0):0)return 0;d=c[a+8>>2]|0;pc[c[(c[d>>2]|0)+32>>2]&127](d,b,c[a+12>>2]|0);return 0}function $B(a){a=a|0;_E(a);return}function aC(b,d){b=b|0;d=d|0;var e=0;c[b>>2]=17056;e=b+4|0;do{a[e+36>>0]=1;c[e+32>>2]=0;c[e+24>>2]=0;c[e+28>>2]=0;a[e+56>>0]=1;c[e+52>>2]=0;c[e+44>>2]=0;c[e+48>>2]=0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=-1;c[e+12>>2]=0;c[e+16>>2]=0;e=e+60|0}while((e|0)!=(b+124|0));a[b+193>>0]=0;a[b+194>>0]=1;a[b+192>>0]=(d|0)!=0^1;g[b+140>>2]=0.0;c[b+144>>2]=0;c[b+164>>2]=0;c[b+148>>2]=1;c[b+152>>2]=0;c[b+156>>2]=10;c[b+160>>2]=1;c[b+168>>2]=0;c[b+172>>2]=0;g[b+176>>2]=0.0;if(d){e=d;d=b+136|0;c[d>>2]=e;d=b+188|0;c[d>>2]=0;d=b+180|0;c[d>>2]=0;d=b+184|0;c[d>>2]=0;b=b+124|0;c[b+0>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;return}c[5132]=(c[5132]|0)+1;e=ZE(95)|0;if((e|0)!=0?(c[(e+19&-16)+-4>>2]=e,(e+19&-16|0)!=0):0){FB(e+19&-16);e=e+19&-16}else e=0;d=b+136|0;c[d>>2]=e;d=b+188|0;c[d>>2]=0;d=b+180|0;c[d>>2]=0;d=b+184|0;c[d>>2]=0;b=b+124|0;c[b+0>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;return}function bC(b){b=b|0;var d=0;c[b>>2]=17056;if((a[b+192>>0]|0)!=0?(d=c[b+136>>2]|0,Jb[c[c[d>>2]>>2]&255](d),d=c[b+136>>2]|0,(d|0)!=0):0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}d=b+124|0;do{d=d+-60|0;JC(d)}while((d|0)!=(b+4|0));return}function cC(a){a=a|0;bC(a);_E(a);return}function dC(d,e,f,g,h,j,k,l,m){d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0;o=i;i=i+48|0;c[5132]=(c[5132]|0)+1;l=ZE(83)|0;if(!l)n=0;else{c[(l+19&-16)+-4>>2]=l;n=l+19&-16}c[n>>2]=h;b[n+4>>1]=j;b[n+6>>1]=k;h=n+16|0;c[h+0>>2]=c[e+0>>2];c[h+4>>2]=c[e+4>>2];c[h+8>>2]=c[e+8>>2];c[h+12>>2]=c[e+12>>2];h=n+32|0;c[h+0>>2]=c[f+0>>2];c[h+4>>2]=c[f+4>>2];c[h+8>>2]=c[f+8>>2];c[h+12>>2]=c[f+12>>2];c[n+8>>2]=0;h=n+56|0;c[h>>2]=0;k=n+52|0;c[k>>2]=0;c[o+16>>2]=c[e+0>>2];c[o+20>>2]=c[e+4>>2];c[o+24>>2]=c[e+8>>2];c[o+28>>2]=c[e+12>>2];c[o+32>>2]=c[f+0>>2];c[o+36>>2]=c[f+4>>2];c[o+40>>2]=c[f+8>>2];c[o+44>>2]=c[f+12>>2];c[n+60>>2]=c[d+144>>2];m=(c[d+188>>2]|0)+1|0;c[d+188>>2]=m;c[n+12>>2]=m;m=c[d+8>>2]|0;if(!m){c[5132]=(c[5132]|0)+1;l=ZE(63)|0;if((l|0)!=0?(c[(l+19&-16)+-4>>2]=l,(l+19&-16|0)!=0):0){m=(l+19&-16)+0|0;g=m+44|0;do{c[m>>2]=0;m=m+4|0}while((m|0)<(g|0));m=l+19&-16}else m=0}else c[d+8>>2]=0;c[m+32>>2]=0;c[m+36>>2]=n;c[m+40>>2]=0;c[m+0>>2]=c[o+16>>2];c[m+4>>2]=c[o+20>>2];c[m+8>>2]=c[o+24>>2];c[m+12>>2]=c[o+28>>2];c[m+16>>2]=c[o+32>>2];c[m+20>>2]=c[o+36>>2];c[m+24>>2]=c[o+40>>2];c[m+28>>2]=c[o+44>>2];NC(d+4|0,c[d+4>>2]|0,m);c[d+16>>2]=(c[d+16>>2]|0)+1;c[n+48>>2]=m;l=d+(c[d+144>>2]<<2)+124|0;c[k>>2]=0;c[h>>2]=c[l>>2];m=c[l>>2]|0;if(m)c[m+52>>2]=n;c[l>>2]=n;if(a[d+193>>0]|0){i=o;return n|0}c[o>>2]=17320;c[o+4>>2]=d;c[o+8>>2]=n;Aw(c[d+4>>2]|0,o+16|0,o);Aw(c[d+64>>2]|0,o+16|0,o);i=o;return n|0}function eC(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0;if((c[d+60>>2]|0)==2){g=c[d+48>>2]|0;MC(b+64|0,g)|0;f=c[b+68>>2]|0;if(f){c[5134]=(c[5134]|0)+1;_E(c[f+-4>>2]|0)}c[b+68>>2]=g;c[b+76>>2]=(c[b+76>>2]|0)+-1}else{f=c[d+48>>2]|0;MC(b+4|0,f)|0;g=c[b+8>>2]|0;if(g){c[5134]=(c[5134]|0)+1;_E(c[g+-4>>2]|0)}c[b+8>>2]=f;c[b+16>>2]=(c[b+16>>2]|0)+-1}g=c[d+52>>2]|0;f=c[d+56>>2]|0;if(!g)c[b+(c[d+60>>2]<<2)+124>>2]=f;else c[g+56>>2]=f;f=c[d+56>>2]|0;if(f)c[f+52>>2]=c[d+52>>2];g=c[b+136>>2]|0;pc[c[(c[g>>2]|0)+16>>2]&127](g,d,e);if(!d){b=b+194|0;a[b>>0]=1;return}c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0);b=b+194|0;a[b>>0]=1;return}function fC(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[d+0>>2]=c[b+16>>2];c[d+4>>2]=c[b+20>>2];c[d+8>>2]=c[b+24>>2];c[d+12>>2]=c[b+28>>2];c[e+0>>2]=c[b+32>>2];c[e+4>>2]=c[b+36>>2];c[e+8>>2]=c[b+40>>2];c[e+12>>2]=c[b+44>>2];return}function gC(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;d=i;i=i+16|0;c[d>>2]=17240;c[d+4>>2]=e;pC(a+4|0,c[a+4>>2]|0,b,e+4|0,e+20|0,+g[e+32>>2],f,h,d);pC(a+64|0,c[a+64>>2]|0,b,e+4|0,e+20|0,+g[e+32>>2],f,h,d);i=d;return}function hC(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;i=i+48|0;c[f+32>>2]=17160;c[f+36>>2]=e;c[f+0>>2]=c[b+0>>2];c[f+4>>2]=c[b+4>>2];c[f+8>>2]=c[b+8>>2];c[f+12>>2]=c[b+12>>2];c[f+16>>2]=c[d+0>>2];c[f+20>>2]=c[d+4>>2];c[f+24>>2]=c[d+8>>2];c[f+28>>2]=c[d+12>>2];Aw(c[a+4>>2]|0,f,f+32|0);Aw(c[a+64>>2]|0,f,f+32|0);i=f;return}function iC(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0,E=0.0,F=0.0,G=0,H=0.0;G=i;i=i+16|0;x=+g[e>>2];A=+g[e+4>>2];B=+g[e+8>>2];F=+g[e+12>>2];y=+g[f>>2];z=+g[f+4>>2];C=+g[f+8>>2];E=+g[f+12>>2];do if((c[d+60>>2]|0)==2){k=c[d+48>>2]|0;MC(b+64|0,k)|0;h=c[b+68>>2]|0;if(h){c[5134]=(c[5134]|0)+1;_E(c[h+-4>>2]|0)}c[b+68>>2]=k;c[b+76>>2]=(c[b+76>>2]|0)+-1;k=c[b+8>>2]|0;if(!k){c[5132]=(c[5132]|0)+1;k=ZE(63)|0;if((k|0)!=0?(c[(k+19&-16)+-4>>2]=k,(k+19&-16|0)!=0):0){h=(k+19&-16)+0|0;j=h+44|0;do{c[h>>2]=0;h=h+4|0}while((h|0)<(j|0));k=k+19&-16}else k=0}else c[b+8>>2]=0;c[k+32>>2]=0;c[k+36>>2]=d;c[k+40>>2]=0;g[k>>2]=x;g[k+4>>2]=A;g[k+8>>2]=B;g[k+12>>2]=F;g[k+16>>2]=y;g[k+20>>2]=z;g[k+24>>2]=C;g[k+28>>2]=E;NC(b+4|0,c[b+4>>2]|0,k);c[b+16>>2]=(c[b+16>>2]|0)+1;c[d+48>>2]=k;k=1}else{c[b+168>>2]=(c[b+168>>2]|0)+1;D=c[d+48>>2]|0;r=+g[D>>2];if(((((r<=y?(s=+g[D+16>>2],s>=x):0)?(t=+g[D+4>>2],t<=z):0)?(u=+g[D+20>>2],u>=A):0)?(v=+g[D+8>>2],v<=C):0)?(w=+g[D+24>>2],w>=B):0){H=+g[d+16>>2];n=+g[d+20>>2];m=+g[d+24>>2];q=+g[b+140>>2];o=(+g[d+32>>2]-H)*.5*q;p=q*((+g[d+36>>2]-n)*.5);q=q*((+g[d+40>>2]-m)*.5);if(x-H<0.0)o=-o;if(A-n<0.0)n=-p;else n=p;if(B-m<0.0)m=-q;else m=q;if(!(!(r<=x)|!(t<=A)|!(v<=B)|!(s>=y)|!(u>=z)|!(w>=C))){k=0;break}if(o>0.0){r=x+-.05000000074505806;q=o+(y+.05000000074505806)}else{r=o+(x+-.05000000074505806);q=y+.05000000074505806}if(n>0.0){p=n+(z+.05000000074505806);o=A+-.05000000074505806}else{p=z+.05000000074505806;o=n+(A+-.05000000074505806)}if(m>0.0){n=B+-.05000000074505806;m=m+(C+.05000000074505806)}else{n=m+(B+-.05000000074505806);m=C+.05000000074505806}k=MC(b+4|0,D)|0;a:do if(k){j=c[b+12>>2]|0;if((j|0)<=-1){k=c[b+4>>2]|0;break}if((j|0)>0){l=0;h=k;while(1){k=c[h+32>>2]|0;l=l+1|0;if(!k){k=h;break a}if((l|0)>=(j|0))break;else h=k}}}else k=0;while(0);g[D>>2]=r;g[D+4>>2]=o;g[D+8>>2]=n;g[D+12>>2]=F;g[D+16>>2]=q;g[D+20>>2]=p;g[D+24>>2]=m;g[D+28>>2]=E;NC(b+4|0,k,D);c[b+172>>2]=(c[b+172>>2]|0)+1;k=1;break}k=MC(b+4|0,D)|0;b:do if(k){j=c[b+12>>2]|0;if((j|0)<=-1){k=c[b+4>>2]|0;break}if((j|0)>0){l=0;h=k;while(1){k=c[h+32>>2]|0;l=l+1|0;if(!k){k=h;break b}if((l|0)>=(j|0))break;else h=k}}}else k=0;while(0);g[D>>2]=x;g[D+4>>2]=A;g[D+8>>2]=B;g[D+12>>2]=F;g[D+16>>2]=y;g[D+20>>2]=z;g[D+24>>2]=C;g[D+28>>2]=E;NC(b+4|0,k,D);c[b+172>>2]=(c[b+172>>2]|0)+1;k=1}while(0);h=c[d+52>>2]|0;j=c[d+56>>2]|0;if(!h)c[b+(c[d+60>>2]<<2)+124>>2]=j;else c[h+56>>2]=j;h=c[d+56>>2]|0;if(h)c[h+52>>2]=c[d+52>>2];c[d+16>>2]=c[e+0>>2];c[d+20>>2]=c[e+4>>2];c[d+24>>2]=c[e+8>>2];c[d+28>>2]=c[e+12>>2];c[d+32>>2]=c[f+0>>2];c[d+36>>2]=c[f+4>>2];c[d+40>>2]=c[f+8>>2];c[d+44>>2]=c[f+12>>2];j=c[b+144>>2]|0;c[d+60>>2]=j;c[d+52>>2]=0;c[d+56>>2]=c[b+(j<<2)+124>>2];h=c[b+(j<<2)+124>>2]|0;if(h)c[h+52>>2]=d;c[b+(j<<2)+124>>2]=d;if(!k){i=G;return}a[b+194>>0]=1;if(a[b+193>>0]|0){i=G;return}c[G>>2]=17320;c[G+4>>2]=b;qC(b+64|0,c[b+64>>2]|0,c[d+48>>2]|0,G);qC(b+4|0,c[b+4>>2]|0,c[d+48>>2]|0,G);i=G;return}function jC(b,d){b=b|0;d=d|0;var e=0,f=0,h=0.0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;r=i;i=i+48|0;KC(b+4|0,(($(c[b+152>>2]|0,c[b+16>>2]|0)|0)/100|0)+1|0);if(c[b+164>>2]|0){p=(($(c[b+148>>2]|0,c[b+76>>2]|0)|0)/100|0)+1|0;KC(b+64|0,p);p=(c[b+164>>2]|0)-p|0;c[b+164>>2]=(p|0)<0?0:p}f=((c[b+144>>2]|0)+1|0)%2|0;c[b+144>>2]=f;f=c[b+(f<<2)+124>>2]|0;if(f){do{l=f+56|0;n=f;f=c[l>>2]|0;k=c[n+52>>2]|0;if(!k)c[b+(c[n+60>>2]<<2)+124>>2]=f;else c[k+56>>2]=f;k=c[l>>2]|0;if(k)c[k+52>>2]=c[n+52>>2];c[n+52>>2]=0;c[l>>2]=c[b+132>>2];e=c[b+132>>2]|0;if(e)c[e+52>>2]=n;c[b+132>>2]=n;k=c[n+48>>2]|0;MC(b+4|0,k)|0;l=c[b+8>>2]|0;if(l){c[5134]=(c[5134]|0)+1;_E(c[l+-4>>2]|0)}c[b+8>>2]=k;c[b+16>>2]=(c[b+16>>2]|0)+-1;c[r+16>>2]=c[n+16>>2];c[r+20>>2]=c[n+20>>2];c[r+24>>2]=c[n+24>>2];c[r+28>>2]=c[n+28>>2];c[r+32>>2]=c[n+32>>2];c[r+36>>2]=c[n+36>>2];c[r+40>>2]=c[n+40>>2];c[r+44>>2]=c[n+44>>2];e=c[b+68>>2]|0;if(!e){c[5132]=(c[5132]|0)+1;k=ZE(63)|0;if((k|0)!=0?(c[(k+19&-16)+-4>>2]=k,(k+19&-16|0)!=0):0){l=(k+19&-16)+0|0;e=l+44|0;do{c[l>>2]=0;l=l+4|0}while((l|0)<(e|0));e=k+19&-16}else e=0}else c[b+68>>2]=0;c[e+32>>2]=0;c[e+36>>2]=n;c[e+40>>2]=0;c[e+0>>2]=c[r+16>>2];c[e+4>>2]=c[r+20>>2];c[e+8>>2]=c[r+24>>2];c[e+12>>2]=c[r+28>>2];c[e+16>>2]=c[r+32>>2];c[e+20>>2]=c[r+36>>2];c[e+24>>2]=c[r+40>>2];c[e+28>>2]=c[r+44>>2];NC(b+64|0,c[b+64>>2]|0,e);k=(c[b+76>>2]|0)+1|0;c[b+76>>2]=k;c[n+48>>2]=e;c[n+60>>2]=2}while((f|0)!=0);c[b+164>>2]=k;a[b+194>>0]=1}c[r>>2]=17320;c[r+4>>2]=b;if((a[b+193>>0]|0)!=0?(qC(b+4|0,c[b+4>>2]|0,c[b+64>>2]|0,r),(a[b+193>>0]|0)!=0):0){p=c[b+4>>2]|0;qC(b+4|0,p,p,r)}do if((a[b+194>>0]|0)!=0?(o=c[b+136>>2]|0,o=Nb[c[(c[o>>2]|0)+28>>2]&127](o)|0,j=c[o+4>>2]|0,(j|0)>0):0){f=($(c[b+156>>2]|0,j)|0)/100|0;p=c[b+160>>2]|0;f=(p|0)>(f|0)?p:f;f=(j|0)<(f|0)?j:f;if((f|0)>0){e=0;do{l=((c[b+184>>2]|0)+e|0)%(j|0)|0;n=c[o+12>>2]|0;k=c[n+(l<<4)>>2]|0;l=c[n+(l<<4)+4>>2]|0;n=c[k+48>>2]|0;p=c[l+48>>2]|0;if(!(((((+g[n>>2]<=+g[p+16>>2]?+g[n+16>>2]>=+g[p>>2]:0)?+g[n+4>>2]<=+g[p+20>>2]:0)?+g[n+20>>2]>=+g[p+4>>2]:0)?+g[n+8>>2]<=+g[p+24>>2]:0)?+g[n+24>>2]>=+g[p+8>>2]:0)){j=c[b+136>>2]|0;Rb[c[(c[j>>2]|0)+12>>2]&31](j,k,l,d)|0;j=c[o+4>>2]|0;e=e+-1|0;f=f+-1|0}e=e+1|0}while((e|0)<(f|0));if((j|0)<=0){c[b+184>>2]=0;break}}c[b+184>>2]=((c[b+184>>2]|0)+f|0)%(j|0)|0}while(0);c[b+180>>2]=(c[b+180>>2]|0)+1;c[b+160>>2]=1;a[b+194>>0]=0;e=c[b+168>>2]|0;f=c[b+172>>2]|0;if(!e)h=0.0;else h=+(f>>>0)/+(e>>>0);g[b+176>>2]=h;c[b+172>>2]=f>>>1;c[b+168>>2]=e>>>1;p=c[b+136>>2]|0;if(!(Nb[c[(c[p>>2]|0)+56>>2]&127](p)|0)){i=r;return}p=c[b+136>>2]|0;p=Nb[c[(c[p>>2]|0)+28>>2]&127](p)|0;f=c[p+4>>2]|0;if((f|0)>1){XA(p,0,f+-1|0);j=0;k=0;l=0;e=0;q=44}else{k=0;n=0;l=0;o=0}while(1){if((q|0)==44){f=c[p+4>>2]|0;n=j;o=e}if((l|0)>=(f|0))break;m=c[p+12>>2]|0;e=m+(l<<4)|0;j=c[e>>2]|0;m=m+(l<<4)+4|0;f=c[m>>2]|0;if((j|0)==(k|0))if((f|0)==(n|0)){j=n;q=54}else q=48;else{k=j;q=48}if((q|0)==48){q=0;j=c[k+48>>2]|0;n=c[f+48>>2]|0;if(((((+g[j>>2]<=+g[n+16>>2]?+g[j+16>>2]>=+g[n>>2]:0)?+g[j+4>>2]<=+g[n+20>>2]:0)?+g[j+20>>2]>=+g[n+4>>2]:0)?+g[j+8>>2]<=+g[n+24>>2]:0)?+g[j+24>>2]>=+g[n+8>>2]:0){j=f;f=o}else{j=f;q=54}}if((q|0)==54){f=c[b+136>>2]|0;pc[c[(c[f>>2]|0)+32>>2]&127](f,e,d);c[e>>2]=0;c[m>>2]=0;f=o+1|0}l=l+1|0;e=f;q=44}if((f|0)>1){XA(p,0,f+-1|0);k=c[p+4>>2]|0}else k=f;l=k-o|0;if((o|0)<0){if((c[p+8>>2]|0)<(l|0)){if((k|0)==(o|0)){e=0;f=o}else{c[5132]=(c[5132]|0)+1;e=ZE((l<<4|3)+16|0)|0;if(!e)e=0;else{c[(e+19&-16)+-4>>2]=e;e=e+19&-16}f=c[p+4>>2]|0}if((f|0)>0){j=0;do{b=c[p+12>>2]|0;c[e+(j<<4)>>2]=c[b+(j<<4)>>2];c[e+(j<<4)+4>>2]=c[b+(j<<4)+4>>2];c[e+(j<<4)+8>>2]=c[b+(j<<4)+8>>2];c[e+(j<<4)+12>>2]=c[b+(j<<4)+12>>2];j=j+1|0}while((j|0)!=(f|0))}f=c[p+12>>2]|0;if(f){if(a[p+16>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[f+-4>>2]|0)}c[p+12>>2]=0}a[p+16>>0]=1;c[p+12>>2]=e;c[p+8>>2]=l;f=p+12|0}else f=p+12|0;e=k;do{b=(c[f>>2]|0)+(e<<4)|0;e=e+1|0;c[b+0>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0}while((e|0)!=(l|0))}c[p+4>>2]=l;i=r;return}function kC(a){a=a|0;return c[a+136>>2]|0}function lC(a){a=a|0;return c[a+136>>2]|0}function mC(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0,o=0.0,p=0.0,q=0.0,r=0.0;n=c[a+4>>2]|0;a=c[a+64>>2]|0;do if(!n)if(!a){e=0.0;m=0.0;h=0.0;l=0.0;k=0.0;j=0.0;i=0.0;f=0.0}else{e=+g[a>>2];m=+g[a+4>>2];h=+g[a+8>>2];l=+g[a+12>>2];k=+g[a+16>>2];j=+g[a+20>>2];i=+g[a+24>>2];f=+g[a+28>>2]}else{e=+g[n>>2];f=+g[n+4>>2];h=+g[n+8>>2];k=+g[n+16>>2];j=+g[n+20>>2];i=+g[n+24>>2];if(!a){m=f;l=+g[n+12>>2];f=+g[n+28>>2];break}else{r=+g[a>>2];q=+g[a+16>>2];m=+g[a+4>>2];p=+g[a+20>>2];l=+g[a+8>>2];o=+g[a+24>>2];e=e<r?e:r;m=f<m?f:m;h=h<l?h:l;l=0.0;k=k>q?k:q;j=j>p?j:p;i=i>o?i:o;f=0.0;break}}while(0);g[b>>2]=e;g[b+4>>2]=m;g[b+8>>2]=h;g[b+12>>2]=l;g[d>>2]=k;g[d+4>>2]=j;g[d+8>>2]=i;g[d+12>>2]=f;return}function nC(b,d){b=b|0;d=d|0;if((c[b+16>>2]|0)!=(0-(c[b+76>>2]|0)|0))return;d=c[b+4>>2]|0;if(d)LC(b+4|0,d);d=c[b+8>>2]|0;if(d){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+8>>2]=0;c[b+12>>2]=-1;d=c[b+36>>2]|0;if(d){if(a[b+40>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;c[b+20>>2]=0;d=c[b+64>>2]|0;if(d)LC(b+64|0,d);d=c[b+68>>2]|0;if(d){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+68>>2]=0;c[b+72>>2]=-1;d=c[b+96>>2]|0;if(d){if(a[b+100>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=0;c[b+88>>2]=0;c[b+92>>2]=0;c[b+80>>2]=0;a[b+193>>0]=0;a[b+194>>0]=1;c[b+144>>2]=0;c[b+164>>2]=0;c[b+148>>2]=1;c[b+152>>2]=0;c[b+156>>2]=10;c[b+160>>2]=1;c[b+124>>2]=0;c[b+128>>2]=0;c[b+132>>2]=0;c[b+168>>2]=0;c[b+172>>2]=0;c[b+176>>2]=0;c[b+180>>2]=0;c[b+184>>2]=0;c[b+188>>2]=0;return}function oC(a){a=a|0;return}function pC(b,d,e,f,h,j,k,l,m){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=+j;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0,x=0,y=0,z=0.0,A=0.0,B=0.0,C=0.0,D=0,E=0.0;D=i;i=i+32|0;if(!d){i=D;return}o=c[b+44>>2]|0;if((o|0)<128){if((c[b+48>>2]|0)<128){c[5132]=(c[5132]|0)+1;n=ZE(531)|0;if(!n)r=0;else{c[(n+19&-16)+-4>>2]=n;r=n+19&-16}p=c[b+44>>2]|0;if((p|0)>0){q=0;do{n=r+(q<<2)|0;if(n)c[n>>2]=c[(c[b+52>>2]|0)+(q<<2)>>2];q=q+1|0}while((q|0)!=(p|0))}n=c[b+52>>2]|0;if(n){if(a[b+56>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[n+-4>>2]|0)}c[b+52>>2]=0}a[b+56>>0]=1;c[b+52>>2]=r;c[b+48>>2]=128;p=b+52|0}else p=b+52|0;do{n=(c[p>>2]|0)+(o<<2)|0;if(n)c[n>>2]=0;o=o+1|0}while((o|0)!=128);y=b+48|0}else y=b+48|0;c[b+44>>2]=128;c[c[b+52>>2]>>2]=d;p=1;o=126;do{w=p+-1|0;r=c[b+52>>2]|0;x=c[r+(w<<2)>>2]|0;v=+g[x+4>>2]-+g[l+4>>2];t=+g[x+8>>2]-+g[l+8>>2];g[D>>2]=+g[x>>2]-+g[l>>2];g[D+4>>2]=v;g[D+8>>2]=t;g[D+12>>2]=0.0;t=+g[x+20>>2]-+g[k+4>>2];v=+g[x+24>>2]-+g[k+8>>2];g[D+16>>2]=+g[x+16>>2]-+g[k>>2];g[D+20>>2]=t;g[D+24>>2]=v;g[D+28>>2]=0.0;d=c[h>>2]|0;v=+g[e>>2];t=+g[f>>2];u=(+g[D+(d<<4)>>2]-v)*t;v=t*(+g[D+(1-d<<4)>>2]-v);d=c[h+4>>2]|0;t=+g[e+4>>2];E=+g[f+4>>2];s=(+g[D+(d<<4)+4>>2]-t)*E;t=E*(+g[D+(1-d<<4)+4>>2]-t);do if(((!(u>t|s>v)?(z=s>u?s:u,C=t<v?t:v,d=c[h+8>>2]|0,B=+g[e+8>>2],E=+g[f+8>>2],A=(+g[D+(d<<4)+8>>2]-B)*E,B=E*(+g[D+(1-d<<4)+8>>2]-B),!(z>B|A>C)):0)?(A>z?A:z)<j:0)?(B<C?B:C)>0.0:0){if(!(c[x+40>>2]|0)){Lb[c[(c[m>>2]|0)+12>>2]&127](m,x);p=w;break}if((w|0)>(o|0)){d=c[b+44>>2]|0;if((d|0)<(d<<1|0)){if((c[y>>2]|0)<(d<<1|0)){if(d){c[5132]=(c[5132]|0)+1;o=ZE((d<<3|3)+16|0)|0;if(!o)o=0;else{c[(o+19&-16)+-4>>2]=o;o=o+19&-16}r=c[b+44>>2]|0;if((r|0)>0){n=0;do{q=o+(n<<2)|0;if(q)c[q>>2]=c[(c[b+52>>2]|0)+(n<<2)>>2];n=n+1|0}while((n|0)!=(r|0))}}else o=0;q=c[b+52>>2]|0;if(q){if(a[b+56>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[q+-4>>2]|0)}c[b+52>>2]=0}a[b+56>>0]=1;c[b+52>>2]=o;c[y>>2]=d<<1;q=d}else{o=r;q=d}do{r=o+(q<<2)|0;if(r){c[r>>2]=0;o=c[b+52>>2]|0}q=q+1|0}while((q|0)!=(d<<1|0))}else o=r;c[b+44>>2]=d<<1;r=o;o=(d<<1)+-2|0}c[r+(w<<2)>>2]=c[x+36>>2];c[(c[b+52>>2]|0)+(p<<2)>>2]=c[x+40>>2];p=p+1|0}else p=w;while(0)}while((p|0)!=0);i=D;return}function qC(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;if(!((d|0)!=0&(e|0)!=0))return;if((c[b+24>>2]|0)<128?(c[b+28>>2]|0)<128:0){c[5132]=(c[5132]|0)+1;h=ZE(1043)|0;if(!h)k=0;else{c[(h+19&-16)+-4>>2]=h;k=h+19&-16}h=c[b+24>>2]|0;if((h|0)>0){j=0;do{i=k+(j<<3)|0;if(i){n=(c[b+32>>2]|0)+(j<<3)|0;o=c[n+4>>2]|0;c[i>>2]=c[n>>2];c[i+4>>2]=o}j=j+1|0}while((j|0)!=(h|0))}h=c[b+32>>2]|0;if(h){if(a[b+36>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[h+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=k;c[b+28>>2]=128;o=b+28|0}else o=b+28|0;c[b+24>>2]=128;h=c[b+32>>2]|0;c[h>>2]=d;c[h+4>>2]=e;h=1;k=124;while(1){l=h+-1|0;j=c[b+32>>2]|0;m=c[j+(l<<3)>>2]|0;n=c[j+(l<<3)+4>>2]|0;if((l|0)>(k|0)){i=c[b+24>>2]|0;if((i|0)<(i<<1|0)?(c[o>>2]|0)<(i<<1|0):0){if(i){c[5132]=(c[5132]|0)+1;j=ZE((i<<4|3)+16|0)|0;if(!j)j=0;else{c[(j+19&-16)+-4>>2]=j;j=j+19&-16}e=c[b+24>>2]|0;if((e|0)>0){k=0;do{d=j+(k<<3)|0;if(d){q=(c[b+32>>2]|0)+(k<<3)|0;p=c[q+4>>2]|0;c[d>>2]=c[q>>2];c[d+4>>2]=p}k=k+1|0}while((k|0)!=(e|0))}}else j=0;k=c[b+32>>2]|0;if(k){if(a[b+36>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[k+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=j;c[o>>2]=i<<1}c[b+24>>2]=i<<1;d=(i<<1)+-4|0}else d=k;do if((m|0)==(n|0))if(!(c[m+40>>2]|0))h=l;else{p=c[m+36>>2]|0;q=j+(l<<3)|0;c[q>>2]=p;c[q+4>>2]=p;q=c[m+40>>2]|0;p=(c[b+32>>2]|0)+(h<<3)|0;c[p>>2]=q;c[p+4>>2]=q;p=c[m+40>>2]|0;q=(c[b+32>>2]|0)+(h+1<<3)|0;c[q>>2]=c[m+36>>2];c[q+4>>2]=p;h=h+2|0}else if(((((+g[m>>2]<=+g[n+16>>2]?+g[m+16>>2]>=+g[n>>2]:0)?+g[m+4>>2]<=+g[n+20>>2]:0)?+g[m+20>>2]>=+g[n+4>>2]:0)?+g[m+8>>2]<=+g[n+24>>2]:0)?+g[m+24>>2]>=+g[n+8>>2]:0){e=(c[n+40>>2]|0)!=0;if(!(c[m+40>>2]|0))if(e){q=c[n+36>>2]|0;p=j+(l<<3)|0;c[p>>2]=m;c[p+4>>2]=q;p=c[n+40>>2]|0;q=(c[b+32>>2]|0)+(h<<3)|0;c[q>>2]=m;c[q+4>>2]=p;h=h+1|0;break}else{pc[c[(c[f>>2]|0)+8>>2]&127](f,m,n);h=l;break}else{k=j+(l<<3)|0;j=c[m+36>>2]|0;if(e){p=c[n+36>>2]|0;c[k>>2]=j;c[k+4>>2]=p;p=c[n+36>>2]|0;q=(c[b+32>>2]|0)+(h<<3)|0;c[q>>2]=c[m+40>>2];c[q+4>>2]=p;q=c[n+40>>2]|0;p=(c[b+32>>2]|0)+(h+1<<3)|0;c[p>>2]=c[m+36>>2];c[p+4>>2]=q;p=c[n+40>>2]|0;q=(c[b+32>>2]|0)+(h+2<<3)|0;c[q>>2]=c[m+40>>2];c[q+4>>2]=p;h=h+3|0;break}else{c[k>>2]=j;c[k+4>>2]=n;q=(c[b+32>>2]|0)+(h<<3)|0;c[q>>2]=c[m+40>>2];c[q+4>>2]=n;h=h+1|0;break}}}else h=l;while(0);if(!h)break;else k=d}return}function rC(a,b){a=a|0;b=b|0;a=c[a+4>>2]|0;ec[c[(c[a>>2]|0)+8>>2]&31](a,c[b+36>>2]|0)|0;return}function sC(a){a=a|0;_E(a);return}function tC(a,b){a=a|0;b=b|0;a=c[a+4>>2]|0;ec[c[(c[a>>2]|0)+8>>2]&31](a,c[b+36>>2]|0)|0;return}function uC(a){a=a|0;_E(a);return}function vC(a,b){a=a|0;b=b|0;pc[c[(c[a>>2]|0)+8>>2]&127](a,b,c[(c[a+8>>2]|0)+48>>2]|0);return}function wC(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;if((b|0)==(d|0))return;e=c[(c[a+4>>2]|0)+136>>2]|0;Wb[c[(c[e>>2]|0)+8>>2]&63](e,c[b+36>>2]|0,c[d+36>>2]|0)|0;a=(c[a+4>>2]|0)+160|0;c[a>>2]=(c[a>>2]|0)+1;return}function xC(a){a=a|0;_E(a);return}function yC(d,f,h){d=d|0;f=f|0;h=h|0;var j=0,k=0.0,l=0,m=0.0,n=0.0,o=0,p=0.0,q=0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0,z=0,A=0,B=0,C=0.0,D=0.0,E=0.0,F=0,G=0,H=0,I=0,J=0,K=0,L=0.0,M=0.0,N=0.0;K=i;i=i+128|0;H=c[d+56>>2]|0;if((h-f|0)==1){if(!(a[d+60>>0]|0)){q=(c[d+96>>2]|0)+(H<<6)+0|0;r=(c[d+76>>2]|0)+(f<<6)+0|0;s=q+64|0;do{c[q>>2]=c[r>>2];q=q+4|0;r=r+4|0}while((q|0)<(s|0))}else{I=(c[d+136>>2]|0)+(H<<4)|0;h=(c[d+116>>2]|0)+(f<<4)|0;c[I+0>>2]=c[h+0>>2];c[I+4>>2]=c[h+4>>2];c[I+8>>2]=c[h+8>>2];c[I+12>>2]=c[h+12>>2]}c[d+56>>2]=(c[d+56>>2]|0)+1;i=K;return}if((h|0)>(f|0)){y=(a[d+60>>0]|0)==0;w=0.0;x=0.0;v=0.0;s=f;do{if(y){A=c[d+76>>2]|0;u=+g[A+(s<<6)+16>>2];t=+g[A+(s<<6)>>2];n=+g[A+(s<<6)+20>>2];m=+g[A+(s<<6)+4>>2];p=+g[A+(s<<6)+24>>2];k=+g[A+(s<<6)+8>>2]}else{A=c[d+116>>2]|0;n=+g[d+36>>2];p=+g[d+40>>2];E=+g[d+44>>2];t=+g[d+4>>2];m=+g[d+8>>2];k=+g[d+12>>2];u=+(e[A+(s<<4)+6>>1]|0)/n+t;t=+(e[A+(s<<4)>>1]|0)/n+t;n=+(e[A+(s<<4)+8>>1]|0)/p+m;m=+(e[A+(s<<4)+2>>1]|0)/p+m;p=+(e[A+(s<<4)+10>>1]|0)/E+k;k=+(e[A+(s<<4)+4>>1]|0)/E+k}v=v+(u+t)*.5;w=w+(n+m)*.5;x=x+(p+k)*.5;s=s+1|0}while((s|0)!=(h|0));C=1.0/+(h-f|0);E=v*C;D=w*C;C=x*C;if(y){s=c[d+76>>2]|0;k=0.0;p=0.0;t=0.0;r=f;do{n=(+g[s+(r<<6)+16>>2]+ +g[s+(r<<6)>>2])*.5-E;u=(+g[s+(r<<6)+20>>2]+ +g[s+(r<<6)+4>>2])*.5-D;w=(+g[s+(r<<6)+24>>2]+ +g[s+(r<<6)+8>>2])*.5-C;k=k+n*n;p=p+u*u;t=t+w*w;r=r+1|0}while((r|0)!=(h|0));m=+(h-f|0)}else{y=c[d+116>>2]|0;w=+g[d+36>>2];u=+g[d+40>>2];n=+g[d+44>>2];x=+g[d+4>>2];m=+g[d+8>>2];v=+g[d+12>>2];k=0.0;p=0.0;t=0.0;s=f;do{N=(+(e[y+(s<<4)+6>>1]|0)/w+x+(+(e[y+(s<<4)>>1]|0)/w+x))*.5-E;M=(+(e[y+(s<<4)+8>>1]|0)/u+m+(+(e[y+(s<<4)+2>>1]|0)/u+m))*.5-D;L=(+(e[y+(s<<4)+10>>1]|0)/n+v+(+(e[y+(s<<4)+4>>1]|0)/n+v))*.5-C;k=k+N*N;p=p+M*M;t=t+L*L;s=s+1|0}while((s|0)!=(h|0));m=+(h-f|0)}}else{t=0.0;p=0.0;k=0.0;m=+(h-f|0)}M=1.0/(m+-1.0);n=k*M;m=p*M;k=t*M;if(n<m)r=m<k?2:1;else r=n<k?2:0;c[K+16>>2]=0;c[K+20>>2]=0;c[K+24>>2]=0;c[K+28>>2]=0;if((h|0)>(f|0)){s=(a[d+60>>0]|0)==0;k=0.0;n=0.0;m=0.0;y=f;do{if(s){A=c[d+76>>2]|0;w=+g[A+(y<<6)+16>>2];u=+g[A+(y<<6)>>2];t=+g[A+(y<<6)+20>>2];p=+g[A+(y<<6)+4>>2];v=+g[A+(y<<6)+24>>2];x=+g[A+(y<<6)+8>>2]}else{A=c[d+116>>2]|0;t=+g[d+36>>2];v=+g[d+40>>2];M=+g[d+44>>2];u=+g[d+4>>2];p=+g[d+8>>2];x=+g[d+12>>2];w=+(e[A+(y<<4)+6>>1]|0)/t+u;u=+(e[A+(y<<4)>>1]|0)/t+u;t=+(e[A+(y<<4)+8>>1]|0)/v+p;p=+(e[A+(y<<4)+2>>1]|0)/v+p;v=+(e[A+(y<<4)+10>>1]|0)/M+x;x=+(e[A+(y<<4)+4>>1]|0)/M+x}k=k+(w+u)*.5;n=(t+p)*.5+n;m=(v+x)*.5+m;y=y+1|0}while((y|0)!=(h|0));g[K+16>>2]=k;g[K+20>>2]=n;g[K+24>>2]=m}else{k=0.0;n=0.0;m=0.0}g[K+16>>2]=1.0/+(h-f|0)*k;g[K+20>>2]=1.0/+(h-f|0)*n;g[K+24>>2]=1.0/+(h-f|0)*m;w=+g[K+16+(r<<2)>>2];if((h|0)>(f|0)){y=K+(r<<2)|0;z=f;j=f;do{s=(a[d+60>>0]|0)==0;if(s){A=c[d+76>>2]|0;t=+g[A+(z<<6)+16>>2];n=+g[A+(z<<6)>>2];m=+g[A+(z<<6)+20>>2];p=+g[A+(z<<6)+4>>2];k=+g[A+(z<<6)+24>>2];u=+g[A+(z<<6)+8>>2]}else{A=c[d+116>>2]|0;m=+g[d+36>>2];k=+g[d+40>>2];M=+g[d+44>>2];n=+g[d+4>>2];p=+g[d+8>>2];u=+g[d+12>>2];t=+(e[A+(z<<4)+6>>1]|0)/m+n;n=+(e[A+(z<<4)>>1]|0)/m+n;m=+(e[A+(z<<4)+8>>1]|0)/k+p;p=+(e[A+(z<<4)+2>>1]|0)/k+p;k=+(e[A+(z<<4)+10>>1]|0)/M+u;u=+(e[A+(z<<4)+4>>1]|0)/M+u}g[K>>2]=(t+n)*.5;g[K+4>>2]=(m+p)*.5;g[K+8>>2]=(k+u)*.5;g[K+12>>2]=0.0;if(+g[y>>2]>w){if(s){l=c[d+76>>2]|0;o=l+(z<<6)|0;q=K+32|0;r=o+0|0;s=q+64|0;do{c[q>>2]=c[r>>2];q=q+4|0;r=r+4|0}while((q|0)<(s|0));q=o+0|0;r=l+(j<<6)+0|0;s=q+64|0;do{c[q>>2]=c[r>>2];q=q+4|0;r=r+4|0}while((q|0)<(s|0));q=(c[d+76>>2]|0)+(j<<6)+0|0;r=K+32|0;s=q+64|0;do{c[q>>2]=c[r>>2];q=q+4|0;r=r+4|0}while((q|0)<(s|0))}else{s=c[d+116>>2]|0;A=s+(z<<4)|0;c[K+96>>2]=c[A+0>>2];c[K+100>>2]=c[A+4>>2];c[K+104>>2]=c[A+8>>2];c[K+108>>2]=c[A+12>>2];s=s+(j<<4)|0;c[A+0>>2]=c[s+0>>2];c[A+4>>2]=c[s+4>>2];c[A+8>>2]=c[s+8>>2];c[A+12>>2]=c[s+12>>2];A=(c[d+116>>2]|0)+(j<<4)|0;c[A+0>>2]=c[K+96>>2];c[A+4>>2]=c[K+100>>2];c[A+8>>2]=c[K+104>>2];c[A+12>>2]=c[K+108>>2]}j=j+1|0}z=z+1|0}while((z|0)!=(h|0))}else j=f;if(!((j|0)>(((h-f|0)/3|0)+f|0)?(j|0)<(h+-1-((h-f|0)/3|0)|0):0))j=(h-f>>1)+f|0;G=c[d+56>>2]|0;if(!(a[d+60>>0]|0)){A=(c[d+96>>2]|0)+(G<<6)|0;c[A+0>>2]=c[d+20>>2];c[A+4>>2]=c[d+24>>2];c[A+8>>2]=c[d+28>>2];c[A+12>>2]=c[d+32>>2]}else{A=c[d+136>>2]|0;L=(+g[d+24>>2]-+g[d+8>>2])*+g[d+40>>2];M=(+g[d+28>>2]-+g[d+12>>2])*+g[d+44>>2];b[A+(G<<4)>>1]=~~((+g[d+20>>2]-+g[d+4>>2])*+g[d+36>>2])&65534;b[A+(G<<4)+2>>1]=~~L&65534;b[A+(G<<4)+4>>1]=~~M&65534}l=c[d+56>>2]|0;if(!(a[d+60>>0]|0)){A=(c[d+96>>2]|0)+(l<<6)+16|0;c[A+0>>2]=c[d+4>>2];c[A+4>>2]=c[d+8>>2];c[A+8>>2]=c[d+12>>2];c[A+12>>2]=c[d+16>>2]}else{A=c[d+136>>2]|0;E=+g[d+4>>2];L=+g[d+8>>2];M=+g[d+12>>2];L=(L-L)*+g[d+40>>2];M=(M-M)*+g[d+44>>2];b[A+(l<<4)+6>>1]=~~((E-E)*+g[d+36>>2]+1.0)&65535|1;b[A+(l<<4)+8>>1]=~~(L+1.0)&65535|1;b[A+(l<<4)+10>>1]=~~(M+1.0)&65535|1}F=c[d+56>>2]|0;if((h|0)>(f|0)){A=a[d+60>>0]|0;B=f;do{do if(A<<24>>24){r=c[d+116>>2]|0;m=+g[d+36>>2];N=+g[d+40>>2];D=+g[d+44>>2];x=+g[d+4>>2];u=+g[d+8>>2];E=+g[d+12>>2];n=+g[d+4>>2];w=+g[d+8>>2];L=+g[d+12>>2];t=+g[d+36>>2];C=+g[d+40>>2];M=+g[d+44>>2];q=~~((+(e[r+(B<<4)>>1]|0)/m+x-n)*t)&65534;l=~~((+(e[r+(B<<4)+2>>1]|0)/N+u-w)*C)&65534;s=~~((+(e[r+(B<<4)+4>>1]|0)/D+E-L)*M)&65534;o=(~~((+(e[r+(B<<4)+6>>1]|0)/m+x-n)*t+1.0)&65535|1)&65535;y=(~~((+(e[r+(B<<4)+8>>1]|0)/N+u-w)*C+1.0)&65535|1)&65535;r=(~~((+(e[r+(B<<4)+10>>1]|0)/D+E-L)*M+1.0)&65535|1)&65535;z=c[d+136>>2]|0;if((e[z+(F<<4)>>1]|0)>(q&65535))b[z+(F<<4)>>1]=q;if((e[z+(F<<4)+6>>1]|0)<(o&65535))b[z+(F<<4)+6>>1]=o;if((e[z+(F<<4)+2>>1]|0)>(l&65535))b[z+(F<<4)+2>>1]=l;if((e[z+(F<<4)+8>>1]|0)<(y&65535))b[z+(F<<4)+8>>1]=y;if((e[z+(F<<4)+4>>1]|0)>(s&65535))b[z+(F<<4)+4>>1]=s;if((e[z+(F<<4)+10>>1]|0)<(r&65535))b[z+(F<<4)+10>>1]=r}else{y=c[d+76>>2]|0;w=+g[y+(B<<6)>>2];u=+g[y+(B<<6)+4>>2];t=+g[y+(B<<6)+8>>2];n=+g[y+(B<<6)+12>>2];x=+g[y+(B<<6)+16>>2];m=+g[y+(B<<6)+20>>2];p=+g[y+(B<<6)+24>>2];v=+g[y+(B<<6)+28>>2];y=c[d+96>>2]|0;if(w<+g[y+(F<<6)>>2])g[y+(F<<6)>>2]=w;if(u<+g[y+(F<<6)+4>>2])g[y+(F<<6)+4>>2]=u;if(t<+g[y+(F<<6)+8>>2])g[y+(F<<6)+8>>2]=t;if(n<+g[y+(F<<6)+12>>2])g[y+(F<<6)+12>>2]=n;if(+g[y+(F<<6)+16>>2]<x)g[y+(F<<6)+16>>2]=x;if(+g[y+(F<<6)+20>>2]<m)g[y+(F<<6)+20>>2]=m;if(+g[y+(F<<6)+24>>2]<p)g[y+(F<<6)+24>>2]=p;if(!(+g[y+(F<<6)+28>>2]<v))break;g[y+(F<<6)+28>>2]=v}while(0);B=B+1|0}while((B|0)!=(h|0))}c[d+56>>2]=F+1;yC(d,f,j);z=c[d+56>>2]|0;yC(d,j,h);B=(c[d+56>>2]|0)-H|0;j=a[d+60>>0]|0;if(j<<24>>24!=0&(B<<4|0)>2048){A=c[d+136>>2]|0;s=c[A+(F+1<<4)+12>>2]|0;s=(s|0)>-1?1:0-s|0;q=c[A+(z<<4)+12>>2]|0;q=(q|0)>-1?1:0-q|0;if((s<<4|0)<2049){y=c[d+152>>2]|0;if((y|0)==(c[d+156>>2]|0)?(I=(y|0)==0?1:y<<1,(y|0)<(I|0)):0){if(!I){l=0;o=y}else{c[5132]=(c[5132]|0)+1;l=ZE(I<<5|19)|0;if(!l)l=0;else{c[(l+19&-16)+-4>>2]=l;l=l+19&-16}o=c[d+152>>2]|0}if((o|0)>0){j=0;do{h=l+(j<<5)|0;f=(c[d+160>>2]|0)+(j<<5)|0;c[h+0>>2]=c[f+0>>2];c[h+4>>2]=c[f+4>>2];c[h+8>>2]=c[f+8>>2];c[h+12>>2]=c[f+12>>2];c[h+16>>2]=c[f+16>>2];c[h+20>>2]=c[f+20>>2];c[h+24>>2]=c[f+24>>2];c[h+28>>2]=c[f+28>>2];j=j+1|0}while((j|0)!=(o|0))}o=c[d+160>>2]|0;if(o){if(a[d+164>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[o+-4>>2]|0)}c[d+160>>2]=0}a[d+164>>0]=1;c[d+160>>2]=l;c[d+156>>2]=I;l=c[d+152>>2]|0}else l=y;c[d+152>>2]=l+1;I=(c[d+160>>2]|0)+(y<<5)|0;c[I+0>>2]=c[K+96>>2];c[I+4>>2]=c[K+100>>2];c[I+8>>2]=c[K+104>>2];c[I+12>>2]=c[K+108>>2];c[I+16>>2]=c[K+112>>2];c[I+20>>2]=c[K+116>>2];c[I+24>>2]=c[K+120>>2];c[I+28>>2]=c[K+124>>2];I=c[d+160>>2]|0;b[I+(y<<5)>>1]=b[A+(F+1<<4)>>1]|0;b[I+(y<<5)+2>>1]=b[A+(F+1<<4)+2>>1]|0;b[I+(y<<5)+4>>1]=b[A+(F+1<<4)+4>>1]|0;b[I+(y<<5)+6>>1]=b[A+(F+1<<4)+6>>1]|0;b[I+(y<<5)+8>>1]=b[A+(F+1<<4)+8>>1]|0;b[I+(y<<5)+10>>1]=b[A+(F+1<<4)+10>>1]|0;c[I+(y<<5)+12>>2]=F+1;c[I+(y<<5)+16>>2]=s;s=d+152|0}else s=d+152|0;if((q<<4|0)<2049){r=c[s>>2]|0;if((r|0)==(c[d+156>>2]|0)?(J=(r|0)==0?1:r<<1,(r|0)<(J|0)):0){if(!J){l=0;j=r}else{c[5132]=(c[5132]|0)+1;l=ZE(J<<5|19)|0;if(!l)l=0;else{c[(l+19&-16)+-4>>2]=l;l=l+19&-16}j=c[s>>2]|0}if((j|0)>0){o=0;do{I=l+(o<<5)|0;h=(c[d+160>>2]|0)+(o<<5)|0;c[I+0>>2]=c[h+0>>2];c[I+4>>2]=c[h+4>>2];c[I+8>>2]=c[h+8>>2];c[I+12>>2]=c[h+12>>2];c[I+16>>2]=c[h+16>>2];c[I+20>>2]=c[h+20>>2];c[I+24>>2]=c[h+24>>2];c[I+28>>2]=c[h+28>>2];o=o+1|0}while((o|0)!=(j|0))}j=c[d+160>>2]|0;if(j){if(a[d+164>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[j+-4>>2]|0)}c[d+160>>2]=0}a[d+164>>0]=1;c[d+160>>2]=l;c[d+156>>2]=J;l=c[s>>2]|0}else l=r;c[s>>2]=l+1;I=(c[d+160>>2]|0)+(r<<5)|0;c[I+0>>2]=c[K+32>>2];c[I+4>>2]=c[K+36>>2];c[I+8>>2]=c[K+40>>2];c[I+12>>2]=c[K+44>>2];c[I+16>>2]=c[K+48>>2];c[I+20>>2]=c[K+52>>2];c[I+24>>2]=c[K+56>>2];c[I+28>>2]=c[K+60>>2];I=c[d+160>>2]|0;b[I+(r<<5)>>1]=b[A+(z<<4)>>1]|0;b[I+(r<<5)+2>>1]=b[A+(z<<4)+2>>1]|0;b[I+(r<<5)+4>>1]=b[A+(z<<4)+4>>1]|0;b[I+(r<<5)+6>>1]=b[A+(z<<4)+6>>1]|0;b[I+(r<<5)+8>>1]=b[A+(z<<4)+8>>1]|0;b[I+(r<<5)+10>>1]=b[A+(z<<4)+10>>1]|0;c[I+(r<<5)+12>>2]=z;c[I+(r<<5)+16>>2]=q}c[d+168>>2]=c[s>>2];j=a[d+60>>0]|0}if(!(j<<24>>24)){c[(c[d+96>>2]|0)+(G<<6)+32>>2]=B;i=K;return}else{c[(c[d+136>>2]|0)+(G<<4)+12>>2]=0-B;i=K;return}}function zC(b){b=b|0;var d=0;c[b>>2]=17424;d=c[b+160>>2]|0;if(d){if(a[b+164>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+160>>2]=0}a[b+164>>0]=1;c[b+160>>2]=0;c[b+152>>2]=0;c[b+156>>2]=0;d=c[b+136>>2]|0;if(d){if(a[b+140>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+136>>2]=0}a[b+140>>0]=1;c[b+136>>2]=0;c[b+128>>2]=0;c[b+132>>2]=0;d=c[b+116>>2]|0;if(d){if(a[b+120>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+116>>2]=0}a[b+120>>0]=1;c[b+116>>2]=0;c[b+108>>2]=0;c[b+112>>2]=0;d=c[b+96>>2]|0;if(d){if(a[b+100>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=0;c[b+88>>2]=0;c[b+92>>2]=0;d=c[b+76>>2]|0;if(!d){a[b+80>>0]=1;c[b+76>>2]=0;c[b+68>>2]=0;b=b+72|0;c[b>>2]=0;return}if(a[b+80>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+76>>2]=0;a[b+80>>0]=1;c[b+76>>2]=0;c[b+68>>2]=0;b=b+72|0;c[b>>2]=0;return}function AC(a){a=a|0;zC(a);if(!a)return;c[5134]=(c[5134]|0)+1;_E(c[a+-4>>2]|0);return}function BC(a,b,d,f){a=a|0;b=b|0;d=d|0;f=f|0;var g=0,h=0;while(1){g=c[a+12>>2]|0;if(!(((e[f>>1]|0)>=(e[a>>1]|0)?(e[d>>1]|0)<=(e[a+6>>1]|0):0)&(e[d+4>>1]|0)<=(e[a+10>>1]|0)&(e[f+4>>1]|0)>=(e[a+4>>1]|0)&(e[d+2>>1]|0)<=(e[a+8>>1]|0)&(e[f+2>>1]|0)>=(e[a+2>>1]|0))){h=8;break}if((g|0)>-1)break;BC(a+16|0,b,d,f);g=c[a+28>>2]|0;if((g|0)>-1){a=a+32|0;continue}else{a=a+(1-g<<4)|0;continue}}if((h|0)==8)return;pc[c[(c[b>>2]|0)+8>>2]&127](b,g>>21,g&2097151);return}function CC(a,b,d,e,f,h,j,k){a=a|0;b=b|0;d=d|0;e=+e;f=+f;h=+h;j=j|0;k=k|0;var l=0,m=0,n=0,o=0.0,p=0,q=0.0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0,x=0,y=0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0,V=0,W=0,X=0.0,Y=0;Y=i;i=i+32|0;G=+g[d>>2];N=+g[d+4>>2];Q=+g[d+8>>2];v=+g[j>>2];H=(G>e?e:G)+v;o=+g[j+4>>2];I=(N>f?f:N)+o;q=+g[j+8>>2];J=(Q>h?h:Q)+q;s=+g[k>>2];K=(G<e?e:G)+s;t=+g[k+4>>2];L=(N<f?f:N)+t;u=+g[k+8>>2];M=(Q<h?h:Q)+u;O=1.0/+P(+((e-G)*(e-G)+(f-N)*(f-N)+(h-Q)*(h-Q)));if((e-G)*O==0.0)R=999999984306749440.0;else R=1.0/((e-G)*O);if((f-N)*O==0.0)S=999999984306749440.0;else S=1.0/((f-N)*O);if((h-Q)*O==0.0)T=999999984306749440.0;else T=1.0/((h-Q)*O);U=R<0.0&1;V=S<0.0&1;W=T<0.0&1;m=c[a+56>>2]|0;a:do if((m|0)>0){x=0;y=c[a+96>>2]|0;l=1;while(1){c[Y+0>>2]=c[y+0>>2];c[Y+4>>2]=c[y+4>>2];c[Y+8>>2]=c[y+8>>2];c[Y+12>>2]=c[y+12>>2];p=y+16|0;c[Y+16>>2]=c[p+0>>2];c[Y+20>>2]=c[p+4>>2];c[Y+24>>2]=c[p+8>>2];c[Y+28>>2]=c[p+12>>2];g[Y>>2]=+g[Y>>2]-s;g[Y+4>>2]=+g[Y+4>>2]-t;g[Y+8>>2]=+g[Y+8>>2]-u;g[Y+16>>2]=+g[Y+16>>2]-v;g[Y+20>>2]=+g[Y+20>>2]-o;g[Y+24>>2]=+g[Y+24>>2]-q;if(!(H>+g[p>>2])?!(K<+g[y>>2]):0)n=1;else n=0;if(!(!(J>+g[y+24>>2])?!(M<+g[y+8>>2]):0))n=0;if((((!(I>+g[y+20>>2])?!(L<+g[y+4>>2]|n^1):0)?(A=+g[d>>2],z=R*(+g[Y+(U<<4)>>2]-A),A=R*(+g[Y+((U^1)<<4)>>2]-A),C=+g[d+4>>2],B=S*(+g[Y+(V<<4)+4>>2]-C),C=S*(+g[Y+((V^1)<<4)+4>>2]-C),!(z>C|B>A)):0)?(D=B>z?B:z,X=C<A?C:A,F=+g[d+8>>2],E=T*(+g[Y+(W<<4)+8>>2]-F),F=T*(+g[Y+((W^1)<<4)+8>>2]-F),!(D>F|E>X)):0)?(E>D?E:D)<(h-Q)*((h-Q)*O)+((e-G)*((e-G)*O)+(f-N)*((f-N)*O)):0){n=(F<X?F:X)>0.0;p=c[y+32>>2]|0;if((p|0)==-1&n){pc[c[(c[b>>2]|0)+8>>2]&127](b,c[y+36>>2]|0,c[y+40>>2]|0);m=c[a+56>>2]|0;w=24}else{r=(p|0)==-1;w=23}}else{p=c[y+32>>2]|0;n=0;r=(p|0)==-1;w=23}if((w|0)==23){w=0;if(n|r)w=24;else{n=p+x|0;p=y+(p<<6)|0}}if((w|0)==24){n=x+1|0;p=y+64|0}if((n|0)>=(m|0))break a;o=+g[j+4>>2];q=+g[j+8>>2];s=+g[k>>2];t=+g[k+4>>2];u=+g[k+8>>2];v=+g[j>>2];x=n;y=p;l=l+1|0}}else l=0;while(0);if((c[4364]|0)>=(l|0)){i=Y;return}c[4364]=l;i=Y;return}function DC(a,d,f,h,j,k,l,m,n){a=a|0;d=d|0;f=f|0;h=+h;j=+j;k=+k;l=l|0;m=m|0;n=n|0;var o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,Q=0,R=0.0,S=0,T=0.0,U=0,V=0.0,W=0.0,X=0.0,Y=0,Z=0.0,_=0.0,$=0.0,aa=0.0,ba=0.0,ca=0.0,da=0.0,ea=0.0,fa=0.0,ga=0.0,ha=0.0,ia=0.0,ja=0.0,ka=0.0,la=0.0;Y=i;i=i+32|0;G=+g[f>>2];V=+g[f+4>>2];W=+g[f+8>>2];F=1.0/+P(+((h-G)*(h-G)+(j-V)*(j-V)+(k-W)*(k-W)));if((h-G)*F==0.0)O=999999984306749440.0;else O=1.0/((h-G)*F);if((j-V)*F==0.0)R=999999984306749440.0;else R=1.0/((j-V)*F);if((k-W)*F==0.0)T=999999984306749440.0;else T=1.0/((k-W)*F);Q=O<0.0&1;S=R<0.0&1;U=T<0.0&1;la=(G>h?h:G)+ +g[l>>2];ka=(V>j?j:V)+ +g[l+4>>2];ja=(W>k?k:W)+ +g[l+8>>2];ha=(G<h?h:G)+ +g[m>>2];da=(V<j?j:V)+ +g[m+4>>2];$=(W<k?k:W)+ +g[m+8>>2];ga=+g[a+4>>2];la=la<ga?ga:la;ca=+g[a+8>>2];ka=ka<ca?ca:ka;_=+g[a+12>>2];ja=ja<_?_:ja;ia=+g[a+20>>2];ea=+g[a+24>>2];aa=+g[a+28>>2];fa=+g[a+36>>2];ba=+g[a+40>>2];Z=+g[a+44>>2];B=~~(((ia<la?ia:la)-ga)*fa)&65534;C=~~(((ea<ka?ea:ka)-ca)*ba)&65534;A=~~(((aa<ja?aa:ja)-_)*Z)&65534;ha=ha<ga?ga:ha;da=da<ca?ca:da;$=$<_?_:$;D=(~~(((ia<ha?ia:ha)-ga)*fa+1.0)&65535|1)&65535;E=(~~(((ea<da?ea:da)-ca)*ba+1.0)&65535|1)&65535;z=(~~(((aa<$?aa:$)-_)*Z+1.0)&65535|1)&65535;if((n|0)>0){p=0;q=c[a+136>>2]|0;o=0;do{o=o+1|0;s=q+6|0;r=b[q>>1]|0;t=q+10|0;u=b[q+4>>1]|0;v=q+8|0;w=b[q+2>>1]|0;x=q+12|0;y=(c[x>>2]|0)>-1;if(((((D&65535)>=(r&65535)?(B&65535)<=(e[s>>1]|0):0)&(A&65535)<=(e[t>>1]|0)&(z&65535)>=(u&65535)&(C&65535)<=(e[v>>1]|0)&(E&65535)>=(w&65535)?(ha=+g[a+36>>2],ja=+g[a+40>>2],la=+g[a+44>>2],ia=+g[a+4>>2],ka=+g[a+8>>2],J=+g[a+12>>2],g[Y+12>>2]=0.0,K=+(e[s>>1]|0)/ha+ia,H=+(e[v>>1]|0)/ja+ka,I=+(e[t>>1]|0)/la+J,g[Y+28>>2]=0.0,g[Y>>2]=+(r&65535)/ha+ia-+g[m>>2],g[Y+4>>2]=+(w&65535)/ja+ka-+g[m+4>>2],g[Y+8>>2]=+(u&65535)/la+J-+g[m+8>>2],g[Y+16>>2]=K-+g[l>>2],g[Y+20>>2]=H-+g[l+4>>2],g[Y+24>>2]=I-+g[l+8>>2],I=+g[f>>2],H=O*(+g[Y+(Q<<4)>>2]-I),I=O*(+g[Y+((Q^1)<<4)>>2]-I),K=+g[f+4>>2],J=R*(+g[Y+(S<<4)+4>>2]-K),K=R*(+g[Y+((S^1)<<4)+4>>2]-K),!(H>K|J>I)):0)?(L=J>H?J:H,X=K<I?K:I,N=+g[f+8>>2],M=T*(+g[Y+(U<<4)+8>>2]-N),N=T*(+g[Y+((U^1)<<4)+8>>2]-N),!(L>N|M>X)):0)?(M>L?M:L)<(k-W)*((k-W)*F)+((h-G)*((h-G)*F)+(j-V)*((j-V)*F)):0){r=(N<X?N:X)>0.0;if(y&r){s=c[x>>2]|0;pc[c[(c[d>>2]|0)+8>>2]&127](d,s>>21,s&2097151);s=16}else s=15}else{r=0;s=15}if((s|0)==15){s=0;if(r|y)s=16;else{y=c[x>>2]|0;p=p-y|0;q=q+(0-y<<4)|0}}if((s|0)==16){p=p+1|0;q=q+16|0}}while((p|0)<(n|0))}else o=0;if((c[4364]|0)>=(o|0)){i=Y;return}c[4364]=o;i=Y;return}function EC(d,f,h,i){d=d|0;f=f|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0;c[d+168>>2]=c[d+152>>2];c[f>>2]=17424;c[f+52>>2]=282;a[f+60>>0]=0;a[f+80>>0]=1;c[f+76>>2]=0;c[f+68>>2]=0;c[f+72>>2]=0;a[f+100>>0]=1;c[f+96>>2]=0;c[f+88>>2]=0;c[f+92>>2]=0;a[f+120>>0]=1;c[f+116>>2]=0;c[f+108>>2]=0;c[f+112>>2]=0;a[f+140>>0]=1;c[f+136>>2]=0;c[f+128>>2]=0;c[f+132>>2]=0;c[f+144>>2]=0;a[f+164>>0]=1;c[f+160>>2]=0;c[f+152>>2]=0;c[f+156>>2]=0;c[f+168>>2]=0;g[f+4>>2]=-3402823466385288598117041.0e14;g[f+8>>2]=-3402823466385288598117041.0e14;g[f+12>>2]=-3402823466385288598117041.0e14;g[f+16>>2]=0.0;g[f+20>>2]=3402823466385288598117041.0e14;g[f+24>>2]=3402823466385288598117041.0e14;g[f+28>>2]=3402823466385288598117041.0e14;g[f+32>>2]=0.0;h=c[d+56>>2]|0;if(i){c[f+56>>2]=hF(h|0)|0;a[f+4>>0]=a[d+7>>0]|0;a[f+5>>0]=a[d+6>>0]|0;a[f+6>>0]=a[d+5>>0]|0;a[f+7>>0]=a[d+4>>0]|0;a[f+8>>0]=a[d+11>>0]|0;a[f+9>>0]=a[d+10>>0]|0;a[f+10>>0]=a[d+9>>0]|0;a[f+11>>0]=a[d+8>>0]|0;a[f+12>>0]=a[d+15>>0]|0;a[f+13>>0]=a[d+14>>0]|0;a[f+14>>0]=a[d+13>>0]|0;a[f+15>>0]=a[d+12>>0]|0;a[f+16>>0]=a[d+19>>0]|0;a[f+17>>0]=a[d+18>>0]|0;a[f+18>>0]=a[d+17>>0]|0;a[f+19>>0]=a[d+16>>0]|0;a[f+20>>0]=a[d+23>>0]|0;a[f+21>>0]=a[d+22>>0]|0;a[f+22>>0]=a[d+21>>0]|0;a[f+23>>0]=a[d+20>>0]|0;a[f+24>>0]=a[d+27>>0]|0;a[f+25>>0]=a[d+26>>0]|0;a[f+26>>0]=a[d+25>>0]|0;a[f+27>>0]=a[d+24>>0]|0;a[f+28>>0]=a[d+31>>0]|0;a[f+29>>0]=a[d+30>>0]|0;a[f+30>>0]=a[d+29>>0]|0;a[f+31>>0]=a[d+28>>0]|0;a[f+32>>0]=a[d+35>>0]|0;a[f+33>>0]=a[d+34>>0]|0;a[f+34>>0]=a[d+33>>0]|0;a[f+35>>0]=a[d+32>>0]|0;a[f+36>>0]=a[d+39>>0]|0;a[f+37>>0]=a[d+38>>0]|0;a[f+38>>0]=a[d+37>>0]|0;a[f+39>>0]=a[d+36>>0]|0;a[f+40>>0]=a[d+43>>0]|0;a[f+41>>0]=a[d+42>>0]|0;a[f+42>>0]=a[d+41>>0]|0;a[f+43>>0]=a[d+40>>0]|0;a[f+44>>0]=a[d+47>>0]|0;a[f+45>>0]=a[d+46>>0]|0;a[f+46>>0]=a[d+45>>0]|0;a[f+47>>0]=a[d+44>>0]|0;a[f+48>>0]=a[d+51>>0]|0;a[f+49>>0]=a[d+50>>0]|0;a[f+50>>0]=a[d+49>>0]|0;a[f+51>>0]=a[d+48>>0]|0;c[f+144>>2]=hF(c[d+144>>2]|0)|0;k=hF(c[d+168>>2]|0)|0}else{c[f+56>>2]=h;c[f+4>>2]=c[d+4>>2];c[f+8>>2]=c[d+8>>2];c[f+12>>2]=c[d+12>>2];c[f+16>>2]=c[d+16>>2];c[f+20>>2]=c[d+20>>2];c[f+24>>2]=c[d+24>>2];c[f+28>>2]=c[d+28>>2];c[f+32>>2]=c[d+32>>2];c[f+36>>2]=c[d+36>>2];c[f+40>>2]=c[d+40>>2];c[f+44>>2]=c[d+44>>2];c[f+48>>2]=c[d+48>>2];c[f+144>>2]=c[d+144>>2];k=c[d+168>>2]|0}c[f+168>>2]=k;a[f+60>>0]=a[d+60>>0]|0;m=c[d+56>>2]|0;if(!(a[d+60>>0]|0)){k=c[f+96>>2]|0;if(k){if(a[f+100>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[k+-4>>2]|0)}c[f+96>>2]=0};c[f+88>>2]=0;c[f+92>>2]=0;c[f+96>>2]=0;a[f+100>>0]=0;c[f+96>>2]=f+172;c[f+88>>2]=m;c[f+92>>2]=m;if(i)if((m|0)>0){l=c[d+96>>2]|0;k=f+172|0;j=0;do{h=l+(j<<6)|0;p=k+(j<<6)|0;a[p>>0]=a[h+3>>0]|0;a[p+1>>0]=a[h+2>>0]|0;a[p+2>>0]=a[h+1>>0]|0;a[p+3>>0]=a[h>>0]|0;p=l+(j<<6)+4|0;h=k+(j<<6)+4|0;a[h>>0]=a[p+3>>0]|0;a[h+1>>0]=a[p+2>>0]|0;a[h+2>>0]=a[p+1>>0]|0;a[h+3>>0]=a[p>>0]|0;h=l+(j<<6)+8|0;p=k+(j<<6)+8|0;a[p>>0]=a[h+3>>0]|0;a[p+1>>0]=a[h+2>>0]|0;a[p+2>>0]=a[h+1>>0]|0;a[p+3>>0]=a[h>>0]|0;p=l+(j<<6)+12|0;k=k+(j<<6)+12|0;a[k>>0]=a[p+3>>0]|0;a[k+1>>0]=a[p+2>>0]|0;a[k+2>>0]=a[p+1>>0]|0;a[k+3>>0]=a[p>>0]|0;k=c[d+96>>2]|0;p=k+(j<<6)+16|0;h=c[f+96>>2]|0;o=h+(j<<6)+16|0;a[o>>0]=a[p+3>>0]|0;a[o+1>>0]=a[p+2>>0]|0;a[o+2>>0]=a[p+1>>0]|0;a[o+3>>0]=a[p>>0]|0;o=k+(j<<6)+20|0;p=h+(j<<6)+20|0;a[p>>0]=a[o+3>>0]|0;a[p+1>>0]=a[o+2>>0]|0;a[p+2>>0]=a[o+1>>0]|0;a[p+3>>0]=a[o>>0]|0;p=k+(j<<6)+24|0;o=h+(j<<6)+24|0;a[o>>0]=a[p+3>>0]|0;a[o+1>>0]=a[p+2>>0]|0;a[o+2>>0]=a[p+1>>0]|0;a[o+3>>0]=a[p>>0]|0;k=k+(j<<6)+28|0;h=h+(j<<6)+28|0;a[h>>0]=a[k+3>>0]|0;a[h+1>>0]=a[k+2>>0]|0;a[h+2>>0]=a[k+1>>0]|0;a[h+3>>0]=a[k>>0]|0;l=c[d+96>>2]|0;h=hF(c[l+(j<<6)+32>>2]|0)|0;k=c[f+96>>2]|0;c[k+(j<<6)+32>>2]=h;c[k+(j<<6)+36>>2]=hF(c[l+(j<<6)+36>>2]|0)|0;c[k+(j<<6)+40>>2]=hF(c[l+(j<<6)+40>>2]|0)|0;j=j+1|0}while((j|0)!=(m|0))}else k=f+172|0;else if((m|0)>0){k=f+172|0;l=c[d+96>>2]|0;j=0;do{k=k+(j<<6)|0;p=l+(j<<6)|0;c[k+0>>2]=c[p+0>>2];c[k+4>>2]=c[p+4>>2];c[k+8>>2]=c[p+8>>2];c[k+12>>2]=c[p+12>>2];k=(c[f+96>>2]|0)+(j<<6)+16|0;p=(c[d+96>>2]|0)+(j<<6)+16|0;c[k+0>>2]=c[p+0>>2];c[k+4>>2]=c[p+4>>2];c[k+8>>2]=c[p+8>>2];c[k+12>>2]=c[p+12>>2];l=c[d+96>>2]|0;k=c[f+96>>2]|0;c[k+(j<<6)+32>>2]=c[l+(j<<6)+32>>2];c[k+(j<<6)+36>>2]=c[l+(j<<6)+36>>2];c[k+(j<<6)+40>>2]=c[l+(j<<6)+40>>2];j=j+1|0}while((j|0)!=(m|0))}else k=f+172|0;if(k){if(a[f+100>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[k+-4>>2]|0)}c[f+96>>2]=0};c[f+88>>2]=0;c[f+92>>2]=0;c[f+96>>2]=0;a[f+100>>0]=0;h=m<<6}else{h=c[f+136>>2]|0;if(h){if(a[f+140>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[h+-4>>2]|0)}c[f+136>>2]=0};c[f+128>>2]=0;c[f+132>>2]=0;c[f+136>>2]=0;a[f+140>>0]=0;c[f+136>>2]=f+172;c[f+128>>2]=m;c[f+132>>2]=m;if(i)if((m|0)>0){k=c[d+136>>2]|0;j=0;do{p=e[k+(j<<4)>>1]|0;b[f+172+(j<<4)>>1]=p>>>8|p<<8;p=e[k+(j<<4)+2>>1]|0;b[f+172+(j<<4)+2>>1]=p>>>8|p<<8;p=e[k+(j<<4)+4>>1]|0;b[f+172+(j<<4)+4>>1]=p>>>8|p<<8;p=e[k+(j<<4)+6>>1]|0;b[f+172+(j<<4)+6>>1]=p>>>8|p<<8;p=e[k+(j<<4)+8>>1]|0;b[f+172+(j<<4)+8>>1]=p>>>8|p<<8;p=e[k+(j<<4)+10>>1]|0;b[f+172+(j<<4)+10>>1]=p>>>8|p<<8;c[f+172+(j<<4)+12>>2]=hF(c[k+(j<<4)+12>>2]|0)|0;j=j+1|0}while((j|0)!=(m|0));k=c[f+136>>2]|0;n=18}else{k=f+172|0;n=18}else if((m|0)>0){k=c[d+136>>2]|0;j=0;do{b[f+172+(j<<4)>>1]=b[k+(j<<4)>>1]|0;b[f+172+(j<<4)+2>>1]=b[k+(j<<4)+2>>1]|0;b[f+172+(j<<4)+4>>1]=b[k+(j<<4)+4>>1]|0;b[f+172+(j<<4)+6>>1]=b[k+(j<<4)+6>>1]|0;b[f+172+(j<<4)+8>>1]=b[k+(j<<4)+8>>1]|0;b[f+172+(j<<4)+10>>1]=b[k+(j<<4)+10>>1]|0;c[f+172+(j<<4)+12>>2]=c[k+(j<<4)+12>>2];j=j+1|0}while((j|0)!=(m|0));k=f+172|0;h=m<<4;n=19}else{k=f+172|0;n=18}if((n|0)==18)if(!k)h=m<<4;else{h=m<<4;n=19}if((n|0)==19){if(!((a[f+140>>0]|0)==0|(k|0)==0)){c[5134]=(c[5134]|0)+1;_E(c[k+-4>>2]|0)}c[f+136>>2]=0};c[f+128>>2]=0;c[f+132>>2]=0;c[f+136>>2]=0;a[f+140>>0]=0}h=f+(h+172)|0;k=c[d+168>>2]|0;j=c[f+160>>2]|0;if(j){if(a[f+164>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[j+-4>>2]|0)}c[f+160>>2]=0};c[f+152>>2]=0;c[f+156>>2]=0;c[f+160>>2]=0;a[f+164>>0]=0;c[f+160>>2]=h;c[f+152>>2]=k;c[f+156>>2]=k;l=c[d+168>>2]|0;if(i)if((l|0)>0){j=c[d+160>>2]|0;k=0;do{p=e[j+(k<<5)>>1]|0;b[h+(k<<5)>>1]=p>>>8|p<<8;p=e[j+(k<<5)+2>>1]|0;b[h+(k<<5)+2>>1]=p>>>8|p<<8;p=e[j+(k<<5)+4>>1]|0;b[h+(k<<5)+4>>1]=p>>>8|p<<8;p=e[j+(k<<5)+6>>1]|0;b[h+(k<<5)+6>>1]=p>>>8|p<<8;p=e[j+(k<<5)+8>>1]|0;b[h+(k<<5)+8>>1]=p>>>8|p<<8;p=e[j+(k<<5)+10>>1]|0;b[h+(k<<5)+10>>1]=p>>>8|p<<8;c[h+(k<<5)+12>>2]=hF(c[j+(k<<5)+12>>2]|0)|0;c[h+(k<<5)+16>>2]=hF(c[j+(k<<5)+16>>2]|0)|0;k=k+1|0}while((k|0)!=(l|0));h=c[f+160>>2]|0;n=51}else n=51;else if((l|0)>0){k=c[d+160>>2]|0;j=0;do{b[h+(j<<5)>>1]=b[k+(j<<5)>>1]|0;b[h+(j<<5)+2>>1]=b[k+(j<<5)+2>>1]|0;b[h+(j<<5)+4>>1]=b[k+(j<<5)+4>>1]|0;b[h+(j<<5)+6>>1]=b[k+(j<<5)+6>>1]|0;b[h+(j<<5)+8>>1]=b[k+(j<<5)+8>>1]|0;b[h+(j<<5)+10>>1]=b[k+(j<<5)+10>>1]|0;c[h+(j<<5)+12>>2]=c[k+(j<<5)+12>>2];c[h+(j<<5)+16>>2]=c[k+(j<<5)+16>>2];c[h+(j<<5)+20>>2]=0;c[h+(j<<5)+24>>2]=0;c[h+(j<<5)+28>>2]=0;j=j+1|0}while((j|0)<(c[d+168>>2]|0))}else n=51;if((n|0)==51)if(!h){c[f>>2]=0;c[f+152>>2]=0;c[f+156>>2]=0;c[f+160>>2]=0;a[f+164>>0]=0;return 1}if(!((a[f+164>>0]|0)==0|(h|0)==0)){c[5134]=(c[5134]|0)+1;_E(c[h+-4>>2]|0)}c[f+160>>2]=0;c[f>>2]=0;c[f+152>>2]=0;c[f+156>>2]=0;c[f+160>>2]=0;a[f+164>>0]=0;return 1}function FC(d,e){d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=i;i=i+112|0;g[d+20>>2]=+g[e+16>>2];g[d+24>>2]=+g[e+20>>2];g[d+28>>2]=+g[e+24>>2];g[d+32>>2]=+g[e+28>>2];g[d+4>>2]=+g[e>>2];g[d+8>>2]=+g[e+4>>2];g[d+12>>2]=+g[e+8>>2];g[d+16>>2]=+g[e+12>>2];g[d+36>>2]=+g[e+32>>2];g[d+40>>2]=+g[e+36>>2];g[d+44>>2]=+g[e+40>>2];g[d+48>>2]=+g[e+44>>2];c[d+56>>2]=c[e+48>>2];a[d+60>>0]=(c[e+52>>2]|0)!=0&1;o=c[e+56>>2]|0;l=p+48|0;n=l+64|0;do{c[l>>2]=0;l=l+4|0}while((l|0)<(n|0));k=c[d+88>>2]|0;if((k|0)<(o|0)){if((c[d+92>>2]|0)<(o|0)){if(!o){j=0;h=k}else{c[5132]=(c[5132]|0)+1;h=ZE(o<<6|19)|0;if(!h)j=0;else{c[(h+19&-16)+-4>>2]=h;j=h+19&-16}h=c[d+88>>2]|0}if((h|0)>0){f=0;do{l=j+(f<<6)+0|0;m=(c[d+96>>2]|0)+(f<<6)+0|0;n=l+64|0;do{c[l>>2]=c[m>>2];l=l+4|0;m=m+4|0}while((l|0)<(n|0));f=f+1|0}while((f|0)!=(h|0))}h=c[d+96>>2]|0;if(h){if(a[d+100>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[h+-4>>2]|0)}c[d+96>>2]=0}a[d+100>>0]=1;c[d+96>>2]=j;c[d+92>>2]=o;j=d+96|0}else j=d+96|0;do{l=(c[j>>2]|0)+(k<<6)+0|0;m=p+48|0;n=l+64|0;do{c[l>>2]=c[m>>2];l=l+4|0;m=m+4|0}while((l|0)<(n|0));k=k+1|0}while((k|0)!=(o|0))}c[d+88>>2]=o;if((o|0)>0){j=c[d+96>>2]|0;h=0;f=c[e+64>>2]|0;while(1){g[j+(h<<6)+16>>2]=+g[f+16>>2];g[j+(h<<6)+20>>2]=+g[f+20>>2];g[j+(h<<6)+24>>2]=+g[f+24>>2];g[j+(h<<6)+28>>2]=+g[f+28>>2];g[j+(h<<6)>>2]=+g[f>>2];g[j+(h<<6)+4>>2]=+g[f+4>>2];g[j+(h<<6)+8>>2]=+g[f+8>>2];g[j+(h<<6)+12>>2]=+g[f+12>>2];c[j+(h<<6)+32>>2]=c[f+32>>2];c[j+(h<<6)+36>>2]=c[f+36>>2];c[j+(h<<6)+40>>2]=c[f+40>>2];h=h+1|0;if((h|0)==(o|0))break;else f=f+48|0}}n=c[e+60>>2]|0;c[p+32>>2]=0;c[p+36>>2]=0;c[p+40>>2]=0;c[p+44>>2]=0;h=c[d+128>>2]|0;if((h|0)<(n|0)){if((c[d+132>>2]|0)<(n|0)){if(!n){j=0;f=h}else{c[5132]=(c[5132]|0)+1;f=ZE((n<<4|3)+16|0)|0;if(!f)j=0;else{c[(f+19&-16)+-4>>2]=f;j=f+19&-16}f=c[d+128>>2]|0}if((f|0)>0){k=0;do{o=j+(k<<4)|0;m=(c[d+136>>2]|0)+(k<<4)|0;c[o+0>>2]=c[m+0>>2];c[o+4>>2]=c[m+4>>2];c[o+8>>2]=c[m+8>>2];c[o+12>>2]=c[m+12>>2];k=k+1|0}while((k|0)!=(f|0))}f=c[d+136>>2]|0;if(f){if(a[d+140>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[f+-4>>2]|0)}c[d+136>>2]=0}a[d+140>>0]=1;c[d+136>>2]=j;c[d+132>>2]=n;j=d+136|0}else j=d+136|0;do{o=(c[j>>2]|0)+(h<<4)|0;c[o+0>>2]=c[p+32>>2];c[o+4>>2]=c[p+36>>2];c[o+8>>2]=c[p+40>>2];c[o+12>>2]=c[p+44>>2];h=h+1|0}while((h|0)!=(n|0))}c[d+128>>2]=n;if((n|0)>0){j=c[d+136>>2]|0;h=0;f=c[e+68>>2]|0;while(1){c[j+(h<<4)+12>>2]=c[f+12>>2];b[j+(h<<4)+6>>1]=b[f+6>>1]|0;b[j+(h<<4)+8>>1]=b[f+8>>1]|0;b[j+(h<<4)+10>>1]=b[f+10>>1]|0;b[j+(h<<4)>>1]=b[f>>1]|0;b[j+(h<<4)+2>>1]=b[f+2>>1]|0;b[j+(h<<4)+4>>1]=b[f+4>>1]|0;h=h+1|0;if((h|0)==(n|0))break;else f=f+16|0}}c[d+144>>2]=c[e+76>>2];n=c[e+80>>2]|0;h=c[d+152>>2]|0;if((h|0)<(n|0)){if((c[d+156>>2]|0)<(n|0)){if(!n){j=0;f=h}else{c[5132]=(c[5132]|0)+1;f=ZE(n<<5|19)|0;if(!f)j=0;else{c[(f+19&-16)+-4>>2]=f;j=f+19&-16}f=c[d+152>>2]|0}if((f|0)>0){k=0;do{o=j+(k<<5)|0;m=(c[d+160>>2]|0)+(k<<5)|0;c[o+0>>2]=c[m+0>>2];c[o+4>>2]=c[m+4>>2];c[o+8>>2]=c[m+8>>2];c[o+12>>2]=c[m+12>>2];c[o+16>>2]=c[m+16>>2];c[o+20>>2]=c[m+20>>2];c[o+24>>2]=c[m+24>>2];c[o+28>>2]=c[m+28>>2];k=k+1|0}while((k|0)!=(f|0))}f=c[d+160>>2]|0;if(f){if(a[d+164>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[f+-4>>2]|0)}c[d+160>>2]=0}a[d+164>>0]=1;c[d+160>>2]=j;c[d+156>>2]=n;j=d+160|0}else j=d+160|0;do{o=(c[j>>2]|0)+(h<<5)|0;c[o+0>>2]=c[p+0>>2];c[o+4>>2]=c[p+4>>2];c[o+8>>2]=c[p+8>>2];c[o+12>>2]=c[p+12>>2];c[o+16>>2]=c[p+16>>2];c[o+20>>2]=c[p+20>>2];c[o+24>>2]=c[p+24>>2];c[o+28>>2]=c[p+28>>2];h=h+1|0}while((h|0)!=(n|0))}c[d+152>>2]=n;if((n|0)<=0){i=p;return}h=c[d+160>>2]|0;j=0;f=c[e+72>>2]|0;while(1){b[h+(j<<5)+6>>1]=b[f+14>>1]|0;b[h+(j<<5)+8>>1]=b[f+16>>1]|0;b[h+(j<<5)+10>>1]=b[f+18>>1]|0;b[h+(j<<5)>>1]=b[f+8>>1]|0;b[h+(j<<5)+2>>1]=b[f+10>>1]|0;b[h+(j<<5)+4>>1]=b[f+12>>1]|0;c[h+(j<<5)+12>>2]=c[f>>2];c[h+(j<<5)+16>>2]=c[f+4>>2];j=j+1|0;if((j|0)==(n|0))break;else f=f+20|0}i=p;return}function GC(d,e){d=d|0;e=e|0;var f=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;q=i;i=i+112|0;g[d+20>>2]=+h[e+32>>3];g[d+24>>2]=+h[e+40>>3];g[d+28>>2]=+h[e+48>>3];g[d+32>>2]=+h[e+56>>3];g[d+4>>2]=+h[e>>3];g[d+8>>2]=+h[e+8>>3];g[d+12>>2]=+h[e+16>>3];g[d+16>>2]=+h[e+24>>3];g[d+36>>2]=+h[e+64>>3];g[d+40>>2]=+h[e+72>>3];g[d+44>>2]=+h[e+80>>3];g[d+48>>2]=+h[e+88>>3];c[d+56>>2]=c[e+96>>2];a[d+60>>0]=(c[e+100>>2]|0)!=0&1;p=c[e+104>>2]|0;m=q+48|0;o=m+64|0;do{c[m>>2]=0;m=m+4|0}while((m|0)<(o|0));l=c[d+88>>2]|0;if((l|0)<(p|0)){if((c[d+92>>2]|0)<(p|0)){if(!p){k=0;j=l}else{c[5132]=(c[5132]|0)+1;j=ZE(p<<6|19)|0;if(!j)k=0;else{c[(j+19&-16)+-4>>2]=j;k=j+19&-16}j=c[d+88>>2]|0}if((j|0)>0){f=0;do{m=k+(f<<6)+0|0;n=(c[d+96>>2]|0)+(f<<6)+0|0;o=m+64|0;do{c[m>>2]=c[n>>2];m=m+4|0;n=n+4|0}while((m|0)<(o|0));f=f+1|0}while((f|0)!=(j|0))}j=c[d+96>>2]|0;if(j){if(a[d+100>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[j+-4>>2]|0)}c[d+96>>2]=0}a[d+100>>0]=1;c[d+96>>2]=k;c[d+92>>2]=p;k=d+96|0}else k=d+96|0;do{m=(c[k>>2]|0)+(l<<6)+0|0;n=q+48|0;o=m+64|0;do{c[m>>2]=c[n>>2];m=m+4|0;n=n+4|0}while((m|0)<(o|0));l=l+1|0}while((l|0)!=(p|0))}c[d+88>>2]=p;if((p|0)>0){k=c[d+96>>2]|0;j=0;f=c[e+112>>2]|0;while(1){g[k+(j<<6)+16>>2]=+h[f+32>>3];g[k+(j<<6)+20>>2]=+h[f+40>>3];g[k+(j<<6)+24>>2]=+h[f+48>>3];g[k+(j<<6)+28>>2]=+h[f+56>>3];g[k+(j<<6)>>2]=+h[f>>3];g[k+(j<<6)+4>>2]=+h[f+8>>3];g[k+(j<<6)+8>>2]=+h[f+16>>3];g[k+(j<<6)+12>>2]=+h[f+24>>3];c[k+(j<<6)+32>>2]=c[f+64>>2];c[k+(j<<6)+36>>2]=c[f+68>>2];c[k+(j<<6)+40>>2]=c[f+72>>2];j=j+1|0;if((j|0)==(p|0))break;else f=f+80|0}}o=c[e+108>>2]|0;c[q+32>>2]=0;c[q+36>>2]=0;c[q+40>>2]=0;c[q+44>>2]=0;j=c[d+128>>2]|0;if((j|0)<(o|0)){if((c[d+132>>2]|0)<(o|0)){if(!o){k=0;f=j}else{c[5132]=(c[5132]|0)+1;f=ZE((o<<4|3)+16|0)|0;if(!f)k=0;else{c[(f+19&-16)+-4>>2]=f;k=f+19&-16}f=c[d+128>>2]|0}if((f|0)>0){l=0;do{p=k+(l<<4)|0;n=(c[d+136>>2]|0)+(l<<4)|0;c[p+0>>2]=c[n+0>>2];c[p+4>>2]=c[n+4>>2];c[p+8>>2]=c[n+8>>2];c[p+12>>2]=c[n+12>>2];l=l+1|0}while((l|0)!=(f|0))}f=c[d+136>>2]|0;if(f){if(a[d+140>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[f+-4>>2]|0)}c[d+136>>2]=0}a[d+140>>0]=1;c[d+136>>2]=k;c[d+132>>2]=o;k=d+136|0}else k=d+136|0;do{p=(c[k>>2]|0)+(j<<4)|0;c[p+0>>2]=c[q+32>>2];c[p+4>>2]=c[q+36>>2];c[p+8>>2]=c[q+40>>2];c[p+12>>2]=c[q+44>>2];j=j+1|0}while((j|0)!=(o|0))}c[d+128>>2]=o;if((o|0)>0){k=c[d+136>>2]|0;j=0;f=c[e+116>>2]|0;while(1){c[k+(j<<4)+12>>2]=c[f+12>>2];b[k+(j<<4)+6>>1]=b[f+6>>1]|0;b[k+(j<<4)+8>>1]=b[f+8>>1]|0;b[k+(j<<4)+10>>1]=b[f+10>>1]|0;b[k+(j<<4)>>1]=b[f>>1]|0;b[k+(j<<4)+2>>1]=b[f+2>>1]|0;b[k+(j<<4)+4>>1]=b[f+4>>1]|0;j=j+1|0;if((j|0)==(o|0))break;else f=f+16|0}}c[d+144>>2]=c[e+120>>2];o=c[e+124>>2]|0;j=c[d+152>>2]|0;if((j|0)<(o|0)){if((c[d+156>>2]|0)<(o|0)){if(!o){k=0;f=j}else{c[5132]=(c[5132]|0)+1;f=ZE(o<<5|19)|0;if(!f)k=0;else{c[(f+19&-16)+-4>>2]=f;k=f+19&-16}f=c[d+152>>2]|0}if((f|0)>0){l=0;do{p=k+(l<<5)|0;n=(c[d+160>>2]|0)+(l<<5)|0;c[p+0>>2]=c[n+0>>2];c[p+4>>2]=c[n+4>>2];c[p+8>>2]=c[n+8>>2];c[p+12>>2]=c[n+12>>2];c[p+16>>2]=c[n+16>>2];c[p+20>>2]=c[n+20>>2];c[p+24>>2]=c[n+24>>2];c[p+28>>2]=c[n+28>>2];l=l+1|0}while((l|0)!=(f|0))}f=c[d+160>>2]|0;if(f){if(a[d+164>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[f+-4>>2]|0)}c[d+160>>2]=0}a[d+164>>0]=1;c[d+160>>2]=k;c[d+156>>2]=o;k=d+160|0}else k=d+160|0;do{p=(c[k>>2]|0)+(j<<5)|0;c[p+0>>2]=c[q+0>>2];c[p+4>>2]=c[q+4>>2];c[p+8>>2]=c[q+8>>2];c[p+12>>2]=c[q+12>>2];c[p+16>>2]=c[q+16>>2];c[p+20>>2]=c[q+20>>2];c[p+24>>2]=c[q+24>>2];c[p+28>>2]=c[q+28>>2];j=j+1|0}while((j|0)!=(o|0))}c[d+152>>2]=o;if((o|0)<=0){i=q;return}j=c[d+160>>2]|0;k=0;f=c[e+128>>2]|0;while(1){b[j+(k<<5)+6>>1]=b[f+14>>1]|0;b[j+(k<<5)+8>>1]=b[f+16>>1]|0;b[j+(k<<5)+10>>1]=b[f+18>>1]|0;b[j+(k<<5)>>1]=b[f+8>>1]|0;b[j+(k<<5)+2>>1]=b[f+10>>1]|0;b[j+(k<<5)+4>>1]=b[f+12>>1]|0;c[j+(k<<5)+12>>2]=c[f>>2];c[j+(k<<5)+16>>2]=c[f+4>>2];k=k+1|0;if((k|0)==(o|0))break;else f=f+20|0}i=q;return}function HC(a,e,f){a=a|0;e=e|0;f=f|0;var h=0,i=0,j=0,k=0,l=0;g[e+16>>2]=+g[a+20>>2];g[e+20>>2]=+g[a+24>>2];g[e+24>>2]=+g[a+28>>2];g[e+28>>2]=+g[a+32>>2];g[e>>2]=+g[a+4>>2];g[e+4>>2]=+g[a+8>>2];g[e+8>>2]=+g[a+12>>2];g[e+12>>2]=+g[a+16>>2];g[e+32>>2]=+g[a+36>>2];g[e+36>>2]=+g[a+40>>2];g[e+40>>2]=+g[a+44>>2];g[e+44>>2]=+g[a+48>>2];c[e+48>>2]=c[a+56>>2];c[e+52>>2]=d[a+60>>0];l=c[a+88>>2]|0;c[e+56>>2]=l;if(l){l=ec[c[(c[f>>2]|0)+28>>2]&31](f,c[a+96>>2]|0)|0;c[e+64>>2]=l;if(l){l=c[a+88>>2]|0;i=Wb[c[(c[f>>2]|0)+16>>2]&63](f,48,l)|0;if((l|0)>0){h=c[a+96>>2]|0;k=0;j=c[i+8>>2]|0;while(1){g[j+16>>2]=+g[h+(k<<6)+16>>2];g[j+20>>2]=+g[h+(k<<6)+20>>2];g[j+24>>2]=+g[h+(k<<6)+24>>2];g[j+28>>2]=+g[h+(k<<6)+28>>2];g[j>>2]=+g[h+(k<<6)>>2];g[j+4>>2]=+g[h+(k<<6)+4>>2];g[j+8>>2]=+g[h+(k<<6)+8>>2];g[j+12>>2]=+g[h+(k<<6)+12>>2];c[j+32>>2]=c[h+(k<<6)+32>>2];c[j+36>>2]=c[h+(k<<6)+36>>2];c[j+40>>2]=c[h+(k<<6)+40>>2];k=k+1|0;if((k|0)==(l|0))break;else j=j+48|0}}else h=c[a+96>>2]|0;Hb[c[(c[f>>2]|0)+20>>2]&31](f,i,17464,1497453121,h)}}else c[e+64>>2]=0;l=c[a+128>>2]|0;c[e+60>>2]=l;if(l){l=ec[c[(c[f>>2]|0)+28>>2]&31](f,c[a+136>>2]|0)|0;c[e+68>>2]=l;if(l){k=c[a+128>>2]|0;i=Wb[c[(c[f>>2]|0)+16>>2]&63](f,16,k)|0;if((k|0)>0){h=c[a+136>>2]|0;l=0;j=c[i+8>>2]|0;while(1){c[j+12>>2]=c[h+(l<<4)+12>>2];b[j+6>>1]=b[h+(l<<4)+6>>1]|0;b[j+8>>1]=b[h+(l<<4)+8>>1]|0;b[j+10>>1]=b[h+(l<<4)+10>>1]|0;b[j>>1]=b[h+(l<<4)>>1]|0;b[j+2>>1]=b[h+(l<<4)+2>>1]|0;b[j+4>>1]=b[h+(l<<4)+4>>1]|0;l=l+1|0;if((l|0)==(k|0))break;else j=j+16|0}}else h=c[a+136>>2]|0;Hb[c[(c[f>>2]|0)+20>>2]&31](f,i,17488,1497453121,h)}}else c[e+68>>2]=0;c[e+76>>2]=c[a+144>>2];l=c[a+152>>2]|0;c[e+80>>2]=l;if(!l){c[e+72>>2]=0;return 17536}l=ec[c[(c[f>>2]|0)+28>>2]&31](f,c[a+160>>2]|0)|0;c[e+72>>2]=l;if(!l)return 17536;k=c[a+152>>2]|0;l=Wb[c[(c[f>>2]|0)+16>>2]&63](f,20,k)|0;if((k|0)>0){h=c[a+160>>2]|0;i=0;j=c[l+8>>2]|0;while(1){b[j+14>>1]=b[h+(i<<5)+6>>1]|0;b[j+16>>1]=b[h+(i<<5)+8>>1]|0;b[j+18>>1]=b[h+(i<<5)+10>>1]|0;b[j+8>>1]=b[h+(i<<5)>>1]|0;b[j+10>>1]=b[h+(i<<5)+2>>1]|0;b[j+12>>1]=b[h+(i<<5)+4>>1]|0;c[j>>2]=c[h+(i<<5)+12>>2];c[j+4>>2]=c[h+(i<<5)+16>>2];i=i+1|0;if((i|0)==(k|0))break;else j=j+20|0}}else h=c[a+160>>2]|0;Hb[c[(c[f>>2]|0)+20>>2]&31](f,l,17512,1497453121,h);return 17536}function IC(a){a=a|0;return}function JC(b){b=b|0;var d=0;d=c[b>>2]|0;if(d)LC(b,d);d=c[b+4>>2]|0;if(d){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+4>>2]=0;c[b+8>>2]=-1;d=c[b+32>>2]|0;if(d){if(a[b+36>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;c[b+16>>2]=0;d=c[b+52>>2]|0;if(!d){a[b+56>>0]=1;c[b+52>>2]=0;c[b+44>>2]=0;c[b+48>>2]=0;a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;return}if(!(a[b+56>>0]|0)){a[b+56>>0]=1;c[b+52>>2]=0;c[b+44>>2]=0;c[b+48>>2]=0;a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;return}c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0);d=c[b+32>>2]|0;a[b+56>>0]=1;c[b+52>>2]=0;c[b+44>>2]=0;c[b+48>>2]=0;if(!d){a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;return}if(a[b+36>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+32>>2]=0;a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;return}function KC(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;n=i;i=i+32|0;if((b|0)<0)b=c[a+12>>2]|0;d=c[a>>2]|0;if(!((d|0)!=0&(b|0)>0)){i=n;return}while(1){e=d+40|0;if(c[e>>2]|0){m=0;while(1){l=(c[a+16>>2]|0)>>>m&1;f=d+32|0;g=c[f>>2]|0;if(g>>>0>d>>>0){h=(c[g+40>>2]|0)==(d|0)&1;j=c[g+((h^1)<<2)+36>>2]|0;k=c[g+32>>2]|0;if(!k)c[a>>2]=d;else c[k+(((c[k+40>>2]|0)==(g|0)&1)<<2)+36>>2]=d;c[j+32>>2]=d;c[g+32>>2]=d;c[f>>2]=k;k=d+36|0;c[g+36>>2]=c[k>>2];c[g+40>>2]=c[e>>2];c[(c[k>>2]|0)+32>>2]=g;c[(c[e>>2]|0)+32>>2]=g;c[d+(h<<2)+36>>2]=g;c[d+((h^1)<<2)+36>>2]=j;c[n+0>>2]=c[g+0>>2];c[n+4>>2]=c[g+4>>2];c[n+8>>2]=c[g+8>>2];c[n+12>>2]=c[g+12>>2];c[n+16>>2]=c[g+16>>2];c[n+20>>2]=c[g+20>>2];c[n+24>>2]=c[g+24>>2];c[n+28>>2]=c[g+28>>2];c[g+0>>2]=c[d+0>>2];c[g+4>>2]=c[d+4>>2];c[g+8>>2]=c[d+8>>2];c[g+12>>2]=c[d+12>>2];c[g+16>>2]=c[d+16>>2];c[g+20>>2]=c[d+20>>2];c[g+24>>2]=c[d+24>>2];c[g+28>>2]=c[d+28>>2];c[d+0>>2]=c[n+0>>2];c[d+4>>2]=c[n+4>>2];c[d+8>>2]=c[n+8>>2];c[d+12>>2]=c[n+12>>2];c[d+16>>2]=c[n+16>>2];c[d+20>>2]=c[n+20>>2];c[d+24>>2]=c[n+24>>2];c[d+28>>2]=c[n+28>>2];d=g}d=c[d+(l<<2)+36>>2]|0;e=d+40|0;if(!(c[e>>2]|0))break;else m=m+1&31}}if(!(MC(a,d)|0))e=0;else e=c[a>>2]|0;NC(a,e,d);c[a+16>>2]=(c[a+16>>2]|0)+1;b=b+-1|0;if(!b)break;d=c[a>>2]|0}i=n;return}function LC(a,b){a=a|0;b=b|0;var d=0;if(c[b+40>>2]|0){LC(a,c[b+36>>2]|0);LC(a,c[b+40>>2]|0)}if((c[a>>2]|0)==(b|0))c[a>>2]=0;d=c[a+4>>2]|0;if(!d){c[a+4>>2]=b;return}c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0);c[a+4>>2]=b;return}function MC(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0,v=0,w=0,x=0,y=0;if((c[a>>2]|0)==(b|0)){c[a>>2]=0;a=0;return a|0}e=c[b+32>>2]|0;d=c[e+32>>2]|0;b=c[e+(((c[e+40>>2]|0)!=(b|0)&1)<<2)+36>>2]|0;if(!d){c[a>>2]=b;c[b+32>>2]=0;d=c[a+4>>2]|0;if(!d)d=b;else{c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0);d=c[a>>2]|0}c[a+4>>2]=e;a=d;return a|0}c[d+(((c[d+40>>2]|0)==(e|0)&1)<<2)+36>>2]=b;c[b+32>>2]=d;b=c[a+4>>2]|0;if(b){c[5134]=(c[5134]|0)+1;_E(c[b+-4>>2]|0)}c[a+4>>2]=e;do{s=+g[d>>2];x=d+4|0;q=+g[x>>2];v=d+8|0;o=+g[v>>2];y=d+16|0;m=+g[y>>2];w=d+20|0;k=+g[w>>2];e=d+24|0;i=+g[e>>2];u=c[d+36>>2]|0;b=c[d+40>>2]|0;t=+g[u>>2];r=+g[b>>2];r=t<r?t:r;g[d>>2]=r;t=+g[u+16>>2];l=+g[b+16>>2];l=t>l?t:l;g[y>>2]=l;t=+g[u+4>>2];p=+g[b+4>>2];p=t<p?t:p;g[x>>2]=p;t=+g[u+20>>2];j=+g[b+20>>2];j=t>j?t:j;g[w>>2]=j;t=+g[u+8>>2];n=+g[b+8>>2];n=t<n?t:n;g[v>>2]=n;t=+g[u+24>>2];h=+g[b+24>>2];h=t>h?t:h;g[e>>2]=h;if(!(s!=r|q!=p|o!=n|m!=l)?!(k!=j|i!=h):0){f=14;break}d=c[d+32>>2]|0}while((d|0)!=0);if((f|0)==14)return d|0;x=c[a>>2]|0;return x|0}function NC(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0,o=0,p=0,q=0.0;if(!(c[a>>2]|0)){c[a>>2]=d;c[d+32>>2]=0;return}e=c[b+40>>2]|0;if(!e)n=b;else{j=+g[d>>2]+ +g[d+16>>2];h=+g[d+4>>2]+ +g[d+20>>2];i=+g[d+8>>2]+ +g[d+24>>2];do{n=c[b+36>>2]|0;m=+O(+(j-(+g[n>>2]+ +g[n+16>>2])))+ +O(+(h-(+g[n+4>>2]+ +g[n+20>>2])))+ +O(+(i-(+g[n+8>>2]+ +g[n+24>>2])));b=c[b+((!(m<+O(+(j-(+g[e>>2]+ +g[e+16>>2])))+ +O(+(h-(+g[e+4>>2]+ +g[e+20>>2])))+ +O(+(i-(+g[e+8>>2]+ +g[e+24>>2]))))&1)<<2)+36>>2]|0;e=c[b+40>>2]|0}while((e|0)!=0);n=b}o=n+32|0;p=c[o>>2]|0;b=c[a+4>>2]|0;if(!b){c[5132]=(c[5132]|0)+1;e=ZE(63)|0;if((e|0)!=0?(c[(e+19&-16)+-4>>2]=e,(e+19&-16|0)!=0):0){b=(e+19&-16)+0|0;f=b+44|0;do{c[b>>2]=0;b=b+4|0}while((b|0)<(f|0));b=e+19&-16}else b=0}else c[a+4>>2]=0;c[b+32>>2]=p;f=b+36|0;c[f>>2]=0;e=b+40|0;c[e>>2]=0;q=+g[d>>2];m=+g[n>>2];m=q<m?q:m;g[b>>2]=m;q=+g[d+16>>2];j=+g[n+16>>2];j=q>j?q:j;g[b+16>>2]=j;q=+g[d+4>>2];l=+g[n+4>>2];l=q<l?q:l;g[b+4>>2]=l;q=+g[d+20>>2];i=+g[n+20>>2];i=q>i?q:i;g[b+20>>2]=i;q=+g[d+8>>2];k=+g[n+8>>2];k=q<k?q:k;g[b+8>>2]=k;q=+g[d+24>>2];h=+g[n+24>>2];h=q>h?q:h;g[b+24>>2]=h;if(!p){c[f>>2]=n;c[o>>2]=b;c[e>>2]=d;c[d+32>>2]=b;c[a>>2]=b;return}c[p+(((c[(c[o>>2]|0)+40>>2]|0)==(n|0)&1)<<2)+36>>2]=b;c[f>>2]=n;c[o>>2]=b;c[e>>2]=d;c[d+32>>2]=b;e=p;while(1){b=e+4|0;if(((((+g[e>>2]<=m?+g[b>>2]<=l:0)?+g[e+8>>2]<=k:0)?+g[e+16>>2]>=j:0)?+g[e+20>>2]>=i:0)?+g[e+24>>2]>=h:0){b=21;break}a=c[e+36>>2]|0;n=c[e+40>>2]|0;q=+g[a>>2];m=+g[n>>2];m=q<m?q:m;g[e>>2]=m;q=+g[a+16>>2];j=+g[n+16>>2];j=q>j?q:j;g[e+16>>2]=j;q=+g[a+4>>2];l=+g[n+4>>2];l=q<l?q:l;g[b>>2]=l;q=+g[a+20>>2];i=+g[n+20>>2];i=q>i?q:i;g[e+20>>2]=i;q=+g[a+8>>2];k=+g[n+8>>2];k=q<k?q:k;g[e+8>>2]=k;q=+g[a+24>>2];h=+g[n+24>>2];h=q>h?q:h;g[e+24>>2]=h;e=c[e+32>>2]|0;if(!e){b=21;break}}if((b|0)==21)return}function OC(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0,G=0.0,H=0;H=i;i=i+32|0;k=+g[b+16>>2];j=+g[b>>2];l=+g[b+20>>2];h=+g[b+4>>2];n=+g[b+24>>2];f=+g[b+8>>2];r=+g[b+32>>2];v=+g[b+36>>2];w=+g[b+40>>2];B=(l-h)*(w-f)-(n-f)*(v-h);C=(n-f)*(r-j)-(k-j)*(w-f);D=(k-j)*(v-h)-(l-h)*(r-j);g[H+16>>2]=B;g[H+20>>2]=C;g[H+24>>2]=D;g[H+28>>2]=0.0;o=+g[a+4>>2];s=+g[a+8>>2];x=+g[a+12>>2];E=B*o+C*s+D*x-(j*B+h*C+f*D);p=+g[a+20>>2];t=+g[a+24>>2];y=+g[a+28>>2];if(E*(B*p+C*t+D*y-(j*B+h*C+f*D))>=0.0){i=H;return}F=c[a+36>>2]|0;if((F&1|0)!=0&E<=0.0){i=H;return}G=E/(E-(B*p+C*t+D*y-(j*B+h*C+f*D)));if(!(G<+g[a+40>>2])){i=H;return}A=(B*B+C*C+D*D)*-9.999999747378752e-05;z=j-(p*G+o*(1.0-G));u=h-(t*G+s*(1.0-G));q=f-(y*G+x*(1.0-G));m=k-(p*G+o*(1.0-G));l=l-(t*G+s*(1.0-G));k=n-(y*G+x*(1.0-G));if(!(D*(z*l-u*m)+(B*(u*k-q*l)+C*(q*m-z*k))>=A)){i=H;return}j=r-(p*G+o*(1.0-G));h=v-(t*G+s*(1.0-G));f=w-(y*G+x*(1.0-G));if(!(D*(m*h-l*j)+(B*(l*f-k*h)+C*(k*j-m*f))>=A)){i=H;return}if(!(D*(u*j-z*h)+(B*(q*h-u*f)+C*(z*f-q*j))>=A)){i=H;return}f=1.0/+P(+(B*B+C*C+D*D));g[H+16>>2]=B*f;g[H+20>>2]=C*f;g[H+24>>2]=D*f;b=c[(c[a>>2]|0)+12>>2]|0;if((F&2|0)==0&E<=0.0){g[H>>2]=-(B*f);g[H+4>>2]=-(C*f);g[H+8>>2]=-(D*f);g[H+12>>2]=0.0;g[a+40>>2]=+lc[b&3](a,H,G,d,e);i=H;return}else{g[a+40>>2]=+lc[b&3](a,H+16|0,G,d,e);i=H;return}}function PC(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0,j=0.0,k=0.0,l=0.0,m=0,n=0.0;m=i;i=i+672|0;c[m+576>>2]=0;g[m+580>>2]=1.0;g[m+584>>2]=1.0;g[m+588>>2]=1.0;g[m+592>>2]=0.0;c[m+620>>2]=0;c[m+568>>2]=7680;c[m+572>>2]=1;c[m+624>>2]=c[d+0>>2];c[m+628>>2]=c[d+4>>2];c[m+632>>2]=c[d+8>>2];c[m+636>>2]=c[d+12>>2];c[m+640>>2]=c[d+16>>2];c[m+644>>2]=c[d+20>>2];c[m+648>>2]=c[d+24>>2];c[m+652>>2]=c[d+28>>2];c[m+656>>2]=c[d+32>>2];c[m+660>>2]=c[d+36>>2];c[m+664>>2]=c[d+40>>2];c[m+668>>2]=c[d+44>>2];g[m+612>>2]=+g[b+204>>2];g[m+516>>2]=9.999999747378752e-05;a[m+540>>0]=0;c[m+200>>2]=19144;d=c[b+4>>2]|0;c[m+176>>2]=19408;c[m+180>>2]=m+208;c[m+184>>2]=m+200;c[m+188>>2]=d;c[m+192>>2]=m+568;c[m+196>>2]=0;c[m>>2]=7608;c[m+168>>2]=0;g[m+164>>2]=1.0;g[m+172>>2]=+g[b+208>>2];if((lD(m+176|0,b+8|0,b+72|0,b+136|0,b+136|0,m)|0?(h=+g[m+132>>2],j=+g[m+136>>2],k=+g[m+140>>2],h*h+j*j+k*k>9.999999747378752e-05):0)?(l=+g[m+164>>2],l<+g[b+200>>2]):0){n=1.0/+P(+(h*h+j*j+k*k));g[m+132>>2]=h*n;g[m+136>>2]=j*n;g[m+140>>2]=k*n;+$b[c[(c[b>>2]|0)+12>>2]&3](b,m+132|0,m+148|0,l,e,f)}c[m+568>>2]=13432;e=c[m+620>>2]|0;if(!e){i=m;return}Jb[c[c[e>>2]>>2]&255](e);e=c[m+620>>2]|0;if(!e){i=m;return}c[5134]=(c[5134]|0)+1;_E(c[e+-4>>2]|0);i=m;return}function QC(a){a=a|0;_E(a);return}function RC(b,d,e,f,h,j,k,l,m,n){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;var o=0.0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0,D=0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0;C=i;i=i+4256|0;if(((c[e+4>>2]|0)+-17|0)>>>0<2)w=((c[f+4>>2]|0)+-17|0)>>>0<2;else w=0;b=0;do{SC();t=+g[17712+(b<<4)>>2];u=+g[17716+(b<<4)>>2];v=+g[17720+(b<<4)>>2];z=+g[h+4>>2]*-t+ +g[h+20>>2]*-u+ +g[h+36>>2]*-v;x=+g[h+8>>2]*-t+ +g[h+24>>2]*-u+ +g[h+40>>2]*-v;g[C+16+(b<<4)>>2]=+g[h>>2]*-t+ +g[h+16>>2]*-u+ +g[h+32>>2]*-v;g[C+16+(b<<4)+4>>2]=z;g[C+16+(b<<4)+8>>2]=x;g[C+16+(b<<4)+12>>2]=0.0;x=t*+g[j+4>>2]+u*+g[j+20>>2]+v*+g[j+36>>2];z=t*+g[j+8>>2]+u*+g[j+24>>2]+v*+g[j+40>>2];g[C+1008+(b<<4)>>2]=t*+g[j>>2]+u*+g[j+16>>2]+v*+g[j+32>>2];g[C+1008+(b<<4)+4>>2]=x;g[C+1008+(b<<4)+8>>2]=z;g[C+1008+(b<<4)+12>>2]=0.0;b=b+1|0}while((b|0)!=42);b=Nb[c[(c[e>>2]|0)+84>>2]&127](e)|0;if((b|0)>0){p=0;q=42;while(1){pc[c[(c[e>>2]|0)+88>>2]&127](e,p,C+4240|0);x=+g[C+4240>>2];z=+g[C+4244>>2];v=+g[C+4248>>2];u=x*+g[h+16>>2]+z*+g[h+20>>2]+v*+g[h+24>>2];t=x*+g[h+32>>2]+z*+g[h+36>>2]+v*+g[h+40>>2];g[C+4240>>2]=+g[h>>2]*x+ +g[h+4>>2]*z+ +g[h+8>>2]*v;g[C+4244>>2]=u;g[C+4248>>2]=t;g[C+4252>>2]=0.0;SC();r=17712+(q<<4)|0;c[r+0>>2]=c[C+4240>>2];c[r+4>>2]=c[C+4244>>2];c[r+8>>2]=c[C+4248>>2];c[r+12>>2]=c[C+4252>>2];t=+g[C+4240>>2];u=+g[C+4244>>2];v=+g[C+4248>>2];z=+g[h+4>>2]*-t+ +g[h+20>>2]*-u+ +g[h+36>>2]*-v;x=+g[h+8>>2]*-t+ +g[h+24>>2]*-u+ +g[h+40>>2]*-v;g[C+16+(q<<4)>>2]=+g[h>>2]*-t+ +g[h+16>>2]*-u+ +g[h+32>>2]*-v;g[C+16+(q<<4)+4>>2]=z;g[C+16+(q<<4)+8>>2]=x;g[C+16+(q<<4)+12>>2]=0.0;x=t*+g[j+4>>2]+u*+g[j+20>>2]+v*+g[j+36>>2];z=t*+g[j+8>>2]+u*+g[j+24>>2]+v*+g[j+40>>2];g[C+1008+(q<<4)>>2]=+g[j>>2]*t+ +g[j+16>>2]*u+ +g[j+32>>2]*v;g[C+1008+(q<<4)+4>>2]=x;g[C+1008+(q<<4)+8>>2]=z;g[C+1008+(q<<4)+12>>2]=0.0;p=p+1|0;if((p|0)==(b|0))break;else q=q+1|0}b=b+42|0}else b=42;q=Nb[c[(c[f>>2]|0)+84>>2]&127](f)|0;if((q|0)>0){p=0;r=b;while(1){pc[c[(c[f>>2]|0)+88>>2]&127](f,p,C);x=+g[C>>2];z=+g[C+4>>2];v=+g[C+8>>2];u=x*+g[j+16>>2]+z*+g[j+20>>2]+v*+g[j+24>>2];t=x*+g[j+32>>2]+z*+g[j+36>>2]+v*+g[j+40>>2];g[C>>2]=+g[j>>2]*x+ +g[j+4>>2]*z+ +g[j+8>>2]*v;g[C+4>>2]=u;g[C+8>>2]=t;g[C+12>>2]=0.0;SC();D=17712+(r<<4)|0;c[D+0>>2]=c[C+0>>2];c[D+4>>2]=c[C+4>>2];c[D+8>>2]=c[C+8>>2];c[D+12>>2]=c[C+12>>2];t=+g[C>>2];u=+g[C+4>>2];v=+g[C+8>>2];z=+g[h+4>>2]*-t+ +g[h+20>>2]*-u+ +g[h+36>>2]*-v;x=+g[h+8>>2]*-t+ +g[h+24>>2]*-u+ +g[h+40>>2]*-v;g[C+16+(r<<4)>>2]=+g[h>>2]*-t+ +g[h+16>>2]*-u+ +g[h+32>>2]*-v;g[C+16+(r<<4)+4>>2]=z;g[C+16+(r<<4)+8>>2]=x;g[C+16+(r<<4)+12>>2]=0.0;x=t*+g[j+4>>2]+u*+g[j+20>>2]+v*+g[j+36>>2];z=t*+g[j+8>>2]+u*+g[j+24>>2]+v*+g[j+40>>2];g[C+1008+(r<<4)>>2]=+g[j>>2]*t+ +g[j+16>>2]*u+ +g[j+32>>2]*v;g[C+1008+(r<<4)+4>>2]=x;g[C+1008+(r<<4)+8>>2]=z;g[C+1008+(r<<4)+12>>2]=0.0;p=p+1|0;if((p|0)==(q|0))break;else r=r+1|0}b=q+b|0}tc[c[(c[e>>2]|0)+76>>2]&127](e,C+16|0,C+3248|0,b);tc[c[(c[f>>2]|0)+76>>2]&127](f,C+1008|0,C+2080|0,b);if((b|0)>0)if(w){y=0.0;x=0.0;u=0.0;w=0;t=999999984306749440.0;while(1){SC();v=+g[17712+(w<<4)>>2];o=+g[17716+(w<<4)>>2];s=+g[17724+(w<<4)>>2];if(v*v+o*o+0.0>.01?(z=+g[C+3248+(w<<4)>>2],B=+g[C+3248+(w<<4)+4>>2],A=+g[C+3248+(w<<4)+8>>2],G=+g[C+2080+(w<<4)>>2],F=+g[C+2080+(w<<4)+4>>2],E=+g[C+2080+(w<<4)+8>>2],A=v*(G*+g[j>>2]+F*+g[j+4>>2]+E*+g[j+8>>2]+ +g[j+48>>2]-(z*+g[h>>2]+B*+g[h+4>>2]+A*+g[h+8>>2]+ +g[h+48>>2]))+o*(G*+g[j+16>>2]+F*+g[j+20>>2]+E*+g[j+24>>2]+ +g[j+52>>2]-(z*+g[h+16>>2]+B*+g[h+20>>2]+A*+g[h+24>>2]+ +g[h+52>>2]))+0.0,A<t):0){u=v;t=A}else{s=u;o=x;u=y}w=w+1|0;if((w|0)==(b|0)){v=s;x=0.0;y=o;break}else{y=u;x=o;u=s}}}else{A=0.0;z=0.0;o=0.0;s=0.0;w=0;t=999999984306749440.0;while(1){SC();u=+g[17712+(w<<4)>>2];y=+g[17716+(w<<4)>>2];x=+g[17720+(w<<4)>>2];v=+g[17724+(w<<4)>>2];if(u*u+y*y+x*x>.01?(E=+g[C+3248+(w<<4)>>2],F=+g[C+3248+(w<<4)+4>>2],B=+g[C+3248+(w<<4)+8>>2],I=+g[C+2080+(w<<4)>>2],H=+g[C+2080+(w<<4)+4>>2],G=+g[C+2080+(w<<4)+8>>2],B=u*(I*+g[j>>2]+H*+g[j+4>>2]+G*+g[j+8>>2]+ +g[j+48>>2]-(E*+g[h>>2]+F*+g[h+4>>2]+B*+g[h+8>>2]+ +g[h+48>>2]))+y*(I*+g[j+16>>2]+H*+g[j+20>>2]+G*+g[j+24>>2]+ +g[j+52>>2]-(E*+g[h+16>>2]+F*+g[h+20>>2]+B*+g[h+24>>2]+ +g[h+52>>2]))+x*(I*+g[j+32>>2]+H*+g[j+36>>2]+G*+g[j+40>>2]+ +g[j+56>>2]-(E*+g[h+32>>2]+F*+g[h+36>>2]+B*+g[h+40>>2]+ +g[h+56>>2])),B<t):0){s=y;t=B}else{v=s;x=o;s=z;u=A}w=w+1|0;if((w|0)==(b|0)){y=s;break}else{A=u;z=s;o=x;s=v}}}else{v=0.0;x=0.0;y=0.0;u=0.0;t=999999984306749440.0}switch(c[e+4>>2]|0){case 4:case 5:case 10:case 11:case 13:case 1:case 0:case 8:break;default:+Zb[c[(c[e>>2]|0)+48>>2]&15](e)}switch(c[f+4>>2]|0){case 4:case 5:case 10:case 11:case 13:case 1:case 0:case 8:break;default:+Zb[c[(c[f>>2]|0)+48>>2]&15](f)}if(t<0.0){m=0;i=C;return m|0}switch(c[e+4>>2]|0){case 8:{o=+g[e+28>>2]*+g[e+12>>2];break}case 0:{o=+g[e+44>>2];break}case 1:{o=+g[e+44>>2];break}case 13:{o=+g[e+44>>2];break}case 11:{o=+g[e+44>>2];break}case 10:{o=+g[e+44>>2];break}case 4:case 5:{o=+g[e+44>>2];break}default:o=+Zb[c[(c[e>>2]|0)+48>>2]&15](e)}r=c[f+4>>2]|0;switch(r|0){case 8:{s=+g[f+28>>2]*+g[f+12>>2];r=8;break}case 0:{s=+g[f+44>>2];r=0;break}case 1:{s=+g[f+44>>2];r=1;break}case 13:{s=+g[f+44>>2];r=13;break}case 11:{s=+g[f+44>>2];r=11;break}case 10:{s=+g[f+44>>2];r=10;break}case 4:case 5:{s=+g[f+44>>2];break}default:{s=+Zb[c[(c[f>>2]|0)+48>>2]&15](f);r=c[f+4>>2]|0}}o=t+(o+s+.5);c[C+2e3>>2]=19496;g[C+2004>>2]=0.0;g[C+2008>>2]=1.0;g[C+2012>>2]=0.0;g[C+2016>>2]=0.0;c[C+2020>>2]=0;c[C+2024>>2]=d;c[C+2028>>2]=e;c[C+2032>>2]=f;c[C+2036>>2]=c[e+4>>2];c[C+2040>>2]=r;g[C+2044>>2]=+Zb[c[(c[e>>2]|0)+48>>2]&15](e);g[C+2048>>2]=+Zb[c[(c[f>>2]|0)+48>>2]&15](f);a[C+2052>>0]=0;c[C+2060>>2]=-1;c[C+2072>>2]=1;c[C+2076>>2]=1;B=+g[h+48>>2]+u*o;E=y*o+ +g[h+52>>2];F=x*o+ +g[h+56>>2];c[C+3116>>2]=c[h+0>>2];c[C+3120>>2]=c[h+4>>2];c[C+3124>>2]=c[h+8>>2];c[C+3128>>2]=c[h+12>>2];c[C+3132>>2]=c[h+16>>2];c[C+3136>>2]=c[h+20>>2];c[C+3140>>2]=c[h+24>>2];c[C+3144>>2]=c[h+28>>2];c[C+3148>>2]=c[h+32>>2];c[C+3152>>2]=c[h+36>>2];c[C+3156>>2]=c[h+40>>2];c[C+3160>>2]=c[h+44>>2];g[C+3164>>2]=B;g[C+3168>>2]=E;g[C+3172>>2]=F;g[C+3176>>2]=0.0;c[C+3180>>2]=c[j+0>>2];c[C+3184>>2]=c[j+4>>2];c[C+3188>>2]=c[j+8>>2];c[C+3192>>2]=c[j+12>>2];c[C+3196>>2]=c[j+16>>2];c[C+3200>>2]=c[j+20>>2];c[C+3204>>2]=c[j+24>>2];c[C+3208>>2]=c[j+28>>2];c[C+3212>>2]=c[j+32>>2];c[C+3216>>2]=c[j+36>>2];c[C+3220>>2]=c[j+40>>2];c[C+3224>>2]=c[j+44>>2];c[C+3228>>2]=c[j+48>>2];c[C+3232>>2]=c[j+52>>2];c[C+3236>>2]=c[j+56>>2];c[C+3240>>2]=c[j+60>>2];g[C+3244>>2]=999999984306749440.0;c[C+3072>>2]=18848;a[C+3112>>0]=0;g[C+2004>>2]=-u;g[C+2008>>2]=-y;g[C+2012>>2]=-x;g[C+2016>>2]=0.0;nD(C+2e3|0,C+3116|0,C+3072|0,n,0);o=o-+g[C+3108>>2];b=a[C+3112>>0]|0;if(b<<24>>24){h=C+3092|0;E=+g[C+3096>>2]-y*o;F=+g[C+3100>>2]-x*o;g[l>>2]=+g[h>>2]-u*o;g[l+4>>2]=E;g[l+8>>2]=F;g[l+12>>2]=0.0;c[m+0>>2]=c[h+0>>2];c[m+4>>2]=c[h+4>>2];c[m+8>>2]=c[h+8>>2];c[m+12>>2]=c[h+12>>2];g[k>>2]=u;g[k+4>>2]=y;g[k+8>>2]=x;g[k+12>>2]=v}m=b<<24>>24!=0;i=C;return m|0}function SC(){if(a[18704]|0)return;if(!(Xa(18704)|0))return;g[4428]=0.0;g[4429]=-0.0;g[4430]=-1.0;g[4431]=0.0;g[4432]=.7236080169677734;g[4433]=-.5257250070571899;g[4434]=-.44721901416778564;g[4435]=0.0;g[4436]=-.2763879895210266;g[4437]=-.8506489992141724;g[4438]=-.44721901416778564;g[4439]=0.0;g[4440]=-.8944259881973267;g[4441]=-0.0;g[4442]=-.4472160041332245;g[4443]=0.0;g[4444]=-.2763879895210266;g[4445]=.8506489992141724;g[4446]=-.44721999764442444;g[4447]=0.0;g[4448]=.7236080169677734;g[4449]=.5257250070571899;g[4450]=-.44721901416778564;g[4451]=0.0;g[4452]=.2763879895210266;g[4453]=-.8506489992141724;g[4454]=.44721999764442444;g[4455]=0.0;g[4456]=-.7236080169677734;g[4457]=-.5257250070571899;g[4458]=.44721901416778564;g[4459]=0.0;g[4460]=-.7236080169677734;g[4461]=.5257250070571899;g[4462]=.44721901416778564;g[4463]=0.0;g[4464]=.2763879895210266;g[4465]=.8506489992141724;g[4466]=.44721901416778564;g[4467]=0.0;g[4468]=.8944259881973267;g[4469]=0.0;g[4470]=.4472160041332245;g[4471]=0.0;g[4472]=-0.0;g[4473]=0.0;g[4474]=1.0;g[4475]=0.0;g[4476]=.4253230094909668;g[4477]=-.3090110123157501;g[4478]=-.8506540060043335;g[4479]=0.0;g[4480]=-.16245600581169128;g[4481]=-.49999499320983887;g[4482]=-.8506540060043335;g[4483]=0.0;g[4484]=.2628690004348755;g[4485]=-.8090119957923889;g[4486]=-.525738000869751;g[4487]=0.0;g[4488]=.4253230094909668;g[4489]=.3090110123157501;g[4490]=-.8506540060043335;g[4491]=0.0;g[4492]=.8506479859352112;g[4493]=-0.0;g[4494]=-.5257359743118286;g[4495]=0.0;g[4496]=-.5257300138473511;g[4497]=-0.0;g[4498]=-.8506519794464111;g[4499]=0.0;g[4500]=-.6881899833679199;g[4501]=-.49999698996543884;g[4502]=-.5257359743118286;g[4503]=0.0;g[4504]=-.16245600581169128;g[4505]=.49999499320983887;g[4506]=-.8506540060043335;g[4507]=0.0;g[4508]=-.6881899833679199;g[4509]=.49999698996543884;g[4510]=-.5257359743118286;g[4511]=0.0;g[4512]=.2628690004348755;g[4513]=.8090119957923889;g[4514]=-.525738000869751;g[4515]=0.0;g[4516]=.9510579705238342;g[4517]=.3090130090713501;g[4518]=0.0;g[4519]=0.0;g[4520]=.9510579705238342;g[4521]=-.3090130090713501;g[4522]=0.0;g[4523]=0.0;g[4524]=.5877860188484192;g[4525]=-.80901700258255;g[4526]=0.0;g[4527]=0.0;g[4528]=0.0;g[4529]=-1.0;g[4530]=0.0;g[4531]=0.0;g[4532]=-.5877860188484192;g[4533]=-.80901700258255;g[4534]=0.0;g[4535]=0.0;g[4536]=-.9510579705238342;g[4537]=-.3090130090713501;g[4538]=-0.0;g[4539]=0.0;g[4540]=-.9510579705238342;g[4541]=.3090130090713501;g[4542]=-0.0;g[4543]=0.0;g[4544]=-.5877860188484192;g[4545]=.80901700258255;g[4546]=-0.0;g[4547]=0.0;g[4548]=-0.0;g[4549]=1.0;g[4550]=-0.0;g[4551]=0.0;g[4552]=.5877860188484192;g[4553]=.80901700258255;g[4554]=-0.0;g[4555]=0.0;g[4556]=.6881899833679199;g[4557]=-.49999698996543884;g[4558]=.5257359743118286;g[4559]=0.0;g[4560]=-.2628690004348755;g[4561]=-.8090119957923889;g[4562]=.525738000869751;g[4563]=0.0;g[4564]=-.8506479859352112;g[4565]=0.0;g[4566]=.5257359743118286;g[4567]=0.0;g[4568]=-.2628690004348755;g[4569]=.8090119957923889;g[4570]=.525738000869751;g[4571]=0.0;g[4572]=.6881899833679199;g[4573]=.49999698996543884;g[4574]=.5257359743118286;g[4575]=0.0;g[4576]=.5257300138473511;g[4577]=0.0;g[4578]=.8506519794464111;g[4579]=0.0;g[4580]=.16245600581169128;g[4581]=-.49999499320983887;g[4582]=.8506540060043335;g[4583]=0.0;g[4584]=-.4253230094909668;g[4585]=-.3090110123157501;g[4586]=.8506540060043335;g[4587]=0.0;g[4588]=-.4253230094909668;g[4589]=.3090110123157501;g[4590]=.8506540060043335;g[4591]=0.0;g[4592]=.16245600581169128;g[4593]=.49999499320983887;g[4594]=.8506540060043335;g[4595]=0.0;ab(18704);return}function TC(a){a=a|0;_E(a);return}function UC(a){a=a|0;return}function VC(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;c[b+4>>2]=c[d+0>>2];c[b+8>>2]=c[d+4>>2];c[b+12>>2]=c[d+8>>2];c[b+16>>2]=c[d+12>>2];c[b+20>>2]=c[e+0>>2];c[b+24>>2]=c[e+4>>2];c[b+28>>2]=c[e+8>>2];c[b+32>>2]=c[e+12>>2];g[b+36>>2]=f;a[b+40>>0]=1;return}function WC(a,b,c){a=a|0;b=b|0;c=c|0;return}function XC(a,b,c){a=a|0;b=b|0;c=c|0;return}function YC(a){a=a|0;_E(a);return}function ZC(b,d,e,f,h,j){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0,x=0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0,L=0.0,M=0.0,N=0.0,O=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ba=0.0,ca=0.0,da=0.0,ea=0.0,fa=0,ga=0.0;fa=i;i=i+128|0;K=c[b+4>>2]|0;a[K+312>>0]=0;c[K>>2]=0;a[K+356>>0]=1;g[K+292>>2]=999999984306749440.0;g[K+296>>2]=999999984306749440.0;g[K+300>>2]=999999984306749440.0;g[K+304>>2]=0.0;c[K+336>>2]=0;c[K+340>>2]=0;c[K+344>>2]=0;c[K+348>>2]=0;a[K+352>>0]=0;a[K+332>>0]=a[K+332>>0]&-16;r=+g[d+48>>2];o=+g[d+52>>2];n=+g[d+56>>2];m=+g[f+48>>2];q=+g[f+52>>2];l=+g[f+56>>2];L=+g[d>>2];M=+g[d+4>>2];N=+g[d+8>>2];O=+g[d+16>>2];Q=+g[d+20>>2];R=+g[d+24>>2];S=+g[d+32>>2];T=+g[d+36>>2];U=+g[d+40>>2];V=+g[f>>2];W=+g[f+4>>2];X=+g[f+8>>2];Y=+g[f+16>>2];Z=+g[f+20>>2];_=+g[f+24>>2];$=+g[f+32>>2];aa=+g[f+36>>2];ba=+g[f+40>>2];ca=+g[e+48>>2]-r-(+g[h+48>>2]-m);da=+g[e+52>>2]-o-(+g[h+52>>2]-q);ea=+g[e+56>>2]-n-(+g[h+56>>2]-l);K=c[b+8>>2]|0;k=c[(c[K>>2]|0)+64>>2]|0;g[fa+64>>2]=L*-ca+O*-da+S*-ea;g[fa+68>>2]=M*-ca+Q*-da+T*-ea;g[fa+72>>2]=N*-ca+R*-da+U*-ea;g[fa+76>>2]=0.0;pc[k&127](fa+16|0,K,fa+64|0);G=+g[fa+16>>2];H=+g[fa+20>>2];F=+g[fa+24>>2];s=G*+g[d>>2]+H*+g[d+4>>2]+F*+g[d+8>>2]+ +g[d+48>>2];u=G*+g[d+16>>2]+H*+g[d+20>>2]+F*+g[d+24>>2]+ +g[d+52>>2];F=G*+g[d+32>>2]+H*+g[d+36>>2]+F*+g[d+40>>2]+ +g[d+56>>2];K=c[b+12>>2]|0;k=c[(c[K>>2]|0)+64>>2]|0;H=ca*+g[f+4>>2]+da*+g[f+20>>2]+ea*+g[f+36>>2];G=ca*+g[f+8>>2]+da*+g[f+24>>2]+ea*+g[f+40>>2];g[fa+80>>2]=ca*+g[f>>2]+da*+g[f+16>>2]+ea*+g[f+32>>2];g[fa+84>>2]=H;g[fa+88>>2]=G;g[fa+92>>2]=0.0;pc[k&127](fa+32|0,K,fa+80|0);G=+g[fa+32>>2];H=+g[fa+36>>2];t=+g[fa+40>>2];s=s-(G*+g[f>>2]+H*+g[f+4>>2]+t*+g[f+8>>2]+ +g[f+48>>2]);u=u-(G*+g[f+16>>2]+H*+g[f+20>>2]+t*+g[f+24>>2]+ +g[f+52>>2]);t=F-(G*+g[f+32>>2]+H*+g[f+36>>2]+t*+g[f+40>>2]+ +g[f+56>>2]);a:do if(s*s+u*u+t*t>9.999999747378752e-05){C=r;D=o;B=n;A=q;z=l;l=0.0;q=0.0;r=0.0;y=0.0;n=0.0;K=32;o=0.0;while(1){if(!K){o=y;break a}K=K+-1|0;k=c[b+8>>2]|0;x=c[(c[k>>2]|0)+64>>2]|0;G=-s;ga=-u;v=-t;g[fa>>2]=L*G+O*ga+S*v;g[fa+4>>2]=M*G+Q*ga+T*v;g[fa+8>>2]=N*G+R*ga+U*v;g[fa+12>>2]=0.0;pc[x&127](fa+112|0,k,fa);v=+g[fa+112>>2];ga=+g[fa+116>>2];G=+g[fa+120>>2];E=C+(L*v+M*ga+N*G);F=D+(O*v+Q*ga+R*G);G=B+(S*v+T*ga+U*G);k=c[b+12>>2]|0;x=c[(c[k>>2]|0)+64>>2]|0;g[fa+96>>2]=V*s+Y*u+$*t;g[fa+100>>2]=W*s+Z*u+aa*t;g[fa+104>>2]=X*s+_*u+ba*t;g[fa+108>>2]=0.0;pc[x&127](fa+48|0,k,fa+96|0);ga=+g[fa+48>>2];v=+g[fa+52>>2];J=+g[fa+56>>2];H=m+(V*ga+W*v+X*J);I=A+(Y*ga+Z*v+_*J);J=z+($*ga+aa*v+ba*J);v=s*(E-H)+u*(F-I)+t*(G-J);if(n>1.0){k=0;p=23;break}if(v>0.0){r=ca*s+da*u+ea*t;if(r>=-1.4210854715202004e-14){k=0;p=23;break}n=n-v/r;B=(1.0-n)*+g[d+56>>2]+n*+g[e+56>>2];D=(1.0-n)*+g[d+52>>2]+n*+g[e+52>>2];C=+g[d+48>>2]*(1.0-n)+n*+g[e+48>>2];z=(1.0-n)*+g[f+56>>2]+n*+g[h+56>>2];A=(1.0-n)*+g[f+52>>2]+n*+g[h+52>>2];m=(1.0-n)*+g[f+48>>2]+n*+g[h+48>>2];r=t;q=u;l=s}else o=y;w=c[b+4>>2]|0;x=c[w>>2]|0;if((x|0)>0){v=+g[w+308>>2];k=0;p=0;do{ga=E-H-+g[w+(p<<4)+4>>2];t=F-I-+g[w+(p<<4)+8>>2];u=G-J-+g[w+(p<<4)+12>>2];k=k|ga*ga+t*t+u*u<=v;p=p+1|0}while((p|0)!=(x|0))}else k=0;if((+g[w+304>>2]==0.0?G-J==+g[w+300>>2]:0)?F-I==+g[w+296>>2]:0)p=E-H==+g[w+292>>2];else p=0;if(!(p|k)){g[w+292>>2]=E-H;g[w+296>>2]=F-I;g[w+300>>2]=G-J;g[w+304>>2]=0.0;a[w+356>>0]=1;g[w+(x<<4)+4>>2]=E-H;g[w+(x<<4)+8>>2]=F-I;g[w+(x<<4)+12>>2]=G-J;g[w+(x<<4)+16>>2]=0.0;k=c[w>>2]|0;g[w+(k<<4)+84>>2]=E;g[w+(k<<4)+88>>2]=F;g[w+(k<<4)+92>>2]=G;g[w+(k<<4)+96>>2]=0.0;k=c[w>>2]|0;g[w+(k<<4)+164>>2]=H;g[w+(k<<4)+168>>2]=I;g[w+(k<<4)+172>>2]=J;g[w+(k<<4)+176>>2]=0.0;c[w>>2]=(c[w>>2]|0)+1;w=c[b+4>>2]|0}k=zD(w)|0;s=+g[w+276>>2];u=+g[w+280>>2];t=+g[w+284>>2];if(!k)break a;if(!(s*s+u*u+t*t>9.999999747378752e-05))break a;else{y=o;o=+g[w+288>>2]}}if((p|0)==23){i=fa;return k|0}}else{o=0.0;r=0.0;q=0.0;l=0.0;n=0.0}while(0);g[j+164>>2]=n;m=r*r+(q*q+l*l);if(!(m>=1.4210854715202004e-14)){o=0.0;n=0.0;m=0.0;l=0.0}else{ba=1.0/+P(+m);n=r*ba;m=q*ba;l=l*ba}g[j+132>>2]=l;g[j+136>>2]=m;g[j+140>>2]=n;g[j+144>>2]=o;if(ca*l+da*m+ea*n>=-+g[j+172>>2]){b=0;i=fa;return b|0}b=c[b+4>>2]|0;zD(b)|0;gF(j+148|0,b+260|0,16)|0;b=1;i=fa;return b|0}function _C(a){a=a|0;_E(a);return}
function ax(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0,j=0,k=0.0,l=0,m=0.0,n=0.0,o=0,p=0,q=0;q=i;i=i+16|0;if((e|0)<=0){i=q;return}p=0;do{o=d+(p<<4)|0;f=+g[a+60>>2]*.5;h=c[a+68>>2]|0;m=+g[b+(p<<4)>>2];k=+g[b+(p<<4)+4>>2];n=+g[b+(p<<4)+8>>2];n=+P(+(m*m+k*k+n*n));j=c[a+64>>2]|0;do if(!(+g[b+(p<<4)+(h<<2)>>2]>n*+g[a+52>>2])){k=+g[b+(p<<4)+(j<<2)>>2];l=c[a+72>>2]|0;m=+g[b+(p<<4)+(l<<2)>>2];n=+P(+(k*k+m*m));if(n>1.1920928955078125e-07){n=+g[a+56>>2]/n;g[q+(j<<2)>>2]=k*n;g[q+(h<<2)>>2]=-f;g[q+(l<<2)>>2]=m*n;break}else{g[q+(j<<2)>>2]=0.0;g[q+(h<<2)>>2]=-f;g[q+(l<<2)>>2]=0.0;break}}else{g[q+(j<<2)>>2]=0.0;g[q+(h<<2)>>2]=f;g[q+(c[a+72>>2]<<2)>>2]=0.0}while(0);c[o+0>>2]=c[q+0>>2];c[o+4>>2]=c[q+4>>2];c[o+8>>2]=c[q+8>>2];c[o+12>>2]=c[q+12>>2];p=p+1|0}while((p|0)!=(e|0));i=q;return}function bx(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0,h=0.0,i=0,j=0.0,k=0.0,l=0,m=0.0;e=+g[b+60>>2]*.5;l=c[b+68>>2]|0;k=+g[d>>2];h=+g[d+4>>2];j=+g[d+8>>2];j=+P(+(k*k+h*h+j*j));f=c[b+64>>2]|0;do if(!(+g[d+(l<<2)>>2]>j*+g[b+52>>2])){h=+g[d+(f<<2)>>2];i=c[b+72>>2]|0;j=+g[d+(i<<2)>>2];k=+P(+(h*h+j*j));if(k>1.1920928955078125e-07){k=+g[b+56>>2]/k;g[a+(f<<2)>>2]=h*k;g[a+(l<<2)>>2]=-e;g[a+(i<<2)>>2]=j*k;break}else{g[a+(f<<2)>>2]=0.0;g[a+(l<<2)>>2]=-e;g[a+(i<<2)>>2]=0.0;break}}else{g[a+(f<<2)>>2]=0.0;g[a+(l<<2)>>2]=e;g[a+(c[b+72>>2]<<2)>>2]=0.0}while(0);if(!(+Zb[c[(c[b>>2]|0)+48>>2]&15](b)!=0.0))return;m=+g[d>>2];k=+g[d+4>>2];h=+g[d+8>>2];j=m*m+k*k+h*h<1.4210854715202004e-14?-1.0:h;e=m*m+k*k+h*h<1.4210854715202004e-14?-1.0:k;m=m*m+k*k+h*h<1.4210854715202004e-14?-1.0:m;h=1.0/+P(+(j*j+(m*m+e*e)));k=+Zb[c[(c[b>>2]|0)+48>>2]&15](b);g[a>>2]=h*m*k+ +g[a>>2];g[a+4>>2]=k*(h*e)+ +g[a+4>>2];g[a+8>>2]=k*(h*j)+ +g[a+8>>2];return}function cx(a,b){a=a|0;b=b|0;var d=0.0,e=0.0,f=0.0,h=0,i=0,j=0;j=c[a+68>>2]|0;i=c[a+64>>2]|0;h=c[a+72>>2]|0;e=+g[b+(j<<2)>>2]/+g[a+(j<<2)+12>>2]*+g[a+60>>2];g[a+60>>2]=e;f=+g[a+56>>2]*((+g[b+(i<<2)>>2]/+g[a+(i<<2)+12>>2]+ +g[b+(h<<2)>>2]/+g[a+(h<<2)+12>>2])*.5);g[a+56>>2]=f;g[a+52>>2]=f/+P(+(e*e+f*f));f=+O(+(+g[b>>2]));e=+O(+(+g[b+4>>2]));d=+O(+(+g[b+8>>2]));g[a+12>>2]=f;g[a+16>>2]=e;g[a+20>>2]=d;g[a+24>>2]=0.0;return}function dx(a,b){a=a|0;b=b|0;g[a>>2]=1.0;g[a+4>>2]=0.0;g[a+8>>2]=0.0;g[a+12>>2]=0.0;return}function ex(a){a=a|0;return 12056}function fx(a){a=a|0;if(!a)return;c[5134]=(c[5134]|0)+1;_E(c[a+-4>>2]|0);return}function gx(a,b){a=a|0;b=b|0;g[a>>2]=0.0;g[a+4>>2]=0.0;g[a+8>>2]=1.0;g[a+12>>2]=0.0;return}function hx(a){a=a|0;return 12064}function ix(a){a=a|0;if(!a)return;c[5134]=(c[5134]|0)+1;_E(c[a+-4>>2]|0);return}function jx(a,b,c){a=a|0;b=b|0;c=c|0;return}function kx(a){a=a|0;return 0}function lx(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=ec[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;f=ec[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;c[b>>2]=f;if(f)Lb[c[(c[d>>2]|0)+48>>2]&127](d,e);c[b+4>>2]=c[a+4>>2];g[b+28>>2]=+g[a+28>>2];g[b+32>>2]=+g[a+32>>2];g[b+36>>2]=+g[a+36>>2];g[b+40>>2]=+g[a+40>>2];g[b+12>>2]=+g[a+12>>2];g[b+16>>2]=+g[a+16>>2];g[b+20>>2]=+g[a+20>>2];g[b+24>>2]=+g[a+24>>2];g[b+44>>2]=+g[a+44>>2];c[b+52>>2]=c[a+68>>2];return 12072}function mx(a){a=a|0;return 60}function nx(a,b){a=a|0;b=b|0;g[a>>2]=0.0;g[a+4>>2]=1.0;g[a+8>>2]=0.0;g[a+12>>2]=0.0;return}function ox(a){a=a|0;return 12088}function px(a,b,d){a=a|0;b=+b;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0;e=i;i=i+96|0;g[e+32>>2]=1.0;c[e+36>>2]=0;c[e+40>>2]=0;c[e+44>>2]=0;c[e+48>>2]=0;g[e+52>>2]=1.0;c[e+56>>2]=0;c[e+60>>2]=0;c[e+64>>2]=0;c[e+68>>2]=0;g[e+72>>2]=1.0;l=e+76|0;c[l+0>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;c[l+12>>2]=0;c[l+16>>2]=0;tc[c[(c[a>>2]|0)+8>>2]&127](a,e+32|0,e+16|0,e);j=(+g[e>>2]-+g[e+16>>2])*.5;h=(+g[e+4>>2]-+g[e+20>>2])*.5;k=(+g[e+8>>2]-+g[e+24>>2])*.5;f=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);g[d>>2]=b*.0833333283662796*((h+f)*2.0*((h+f)*2.0)+(k+f)*2.0*((k+f)*2.0));g[d+4>>2]=b*.0833333283662796*((j+f)*2.0*((j+f)*2.0)+(k+f)*2.0*((k+f)*2.0));g[d+8>>2]=b*.0833333283662796*((j+f)*2.0*((j+f)*2.0)+(h+f)*2.0*((h+f)*2.0));g[d+12>>2]=0.0;i=e;return}function qx(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;tc[c[(c[a>>2]|0)+80>>2]&127](a,b,d,e);return}function rx(a){a=a|0;if(!a)return;c[5134]=(c[5134]|0)+1;_E(c[a+-4>>2]|0);return}function sx(a,b,d){a=a|0;b=b|0;d=d|0;c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;return}function tx(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;if((e|0)>0)a=0;else return;do{b=d+(a<<4)|0;a=a+1|0;c[b+0>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0}while((a|0)!=(e|0));return}function ux(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0;e=i;i=i+16|0;pc[c[(c[b>>2]|0)+68>>2]&127](e,b,d);c[a+0>>2]=c[e+0>>2];c[a+4>>2]=c[e+4>>2];c[a+8>>2]=c[e+8>>2];c[a+12>>2]=c[e+12>>2];l=+g[d>>2];j=+g[d+4>>2];h=+g[d+8>>2];f=l*l+j*j+h*h<1.4210854715202004e-14?-1.0:h;k=l*l+j*j+h*h<1.4210854715202004e-14?-1.0:j;l=l*l+j*j+h*h<1.4210854715202004e-14?-1.0:l;h=1.0/+P(+(f*f+(l*l+k*k)));j=+Zb[c[(c[b>>2]|0)+48>>2]&15](b);g[a>>2]=h*l*j+ +g[a>>2];g[a+4>>2]=j*(h*k)+ +g[a+4>>2];g[a+8>>2]=j*(h*f)+ +g[a+8>>2];i=e;return}function vx(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;i=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);h=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);f=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);k=+g[b+52>>2]-h;j=+g[b+56>>2]-f;g[d>>2]=+g[b+48>>2]-i;g[d+4>>2]=k;g[d+8>>2]=j;g[d+12>>2]=0.0;h=h+ +g[b+52>>2];f=f+ +g[b+56>>2];g[e>>2]=i+ +g[b+48>>2];g[e+4>>2]=h;g[e+8>>2]=f;g[e+12>>2]=0.0;return}function wx(a,b,d){a=a|0;b=+b;d=d|0;b=b*.4000000059604645*+Zb[c[(c[a>>2]|0)+48>>2]&15](a);b=b*+Zb[c[(c[a>>2]|0)+48>>2]&15](a);g[d>>2]=b;g[d+4>>2]=b;g[d+8>>2]=b;g[d+12>>2]=0.0;return}function xx(a){a=a|0;return +(+g[a+28>>2]*+g[a+12>>2])}function yx(a,b){a=a|0;b=+b;g[a+44>>2]=b;return}function zx(a){a=a|0;return 12232}function Ax(a){a=a|0;if(!a)return;c[5134]=(c[5134]|0)+1;_E(c[a+-4>>2]|0);return}function Bx(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;Vx(b,d);c[b>>2]=12248;c[b+52>>2]=0;c[b+56>>2]=0;a[b+60>>0]=e&1;a[b+61>>0]=0;c[b+4>>2]=21;if(!f)return;c[5132]=(c[5132]|0)+1;f=ZE(191)|0;if(!f)f=0;else{c[(f+19&-16)+-4>>2]=f;f=f+19&-16}c[f+52>>2]=282;a[f+60>>0]=0;a[f+80>>0]=1;c[f+76>>2]=0;c[f+68>>2]=0;c[f+72>>2]=0;a[f+100>>0]=1;c[f+96>>2]=0;c[f+88>>2]=0;c[f+92>>2]=0;a[f+120>>0]=1;c[f+116>>2]=0;c[f+108>>2]=0;c[f+112>>2]=0;a[f+140>>0]=1;c[f+136>>2]=0;c[f+128>>2]=0;c[f+132>>2]=0;c[f+144>>2]=0;a[f+164>>0]=1;c[f+160>>2]=0;c[f+152>>2]=0;c[f+156>>2]=0;c[f+168>>2]=0;g[f+4>>2]=-3402823466385288598117041.0e14;g[f+8>>2]=-3402823466385288598117041.0e14;g[f+12>>2]=-3402823466385288598117041.0e14;g[f+16>>2]=0.0;g[f+20>>2]=3402823466385288598117041.0e14;g[f+24>>2]=3402823466385288598117041.0e14;g[f+28>>2]=3402823466385288598117041.0e14;g[f+32>>2]=0.0;c[f>>2]=15184;c[b+52>>2]=f;fA(f,c[b+48>>2]|0,(a[b+60>>0]|0)!=0,b+16|0,b+32|0);a[b+61>>0]=1;return}function Cx(b){b=b|0;var d=0;c[b>>2]=12248;if(!(a[b+61>>0]|0))return;d=c[b+52>>2]|0;Jb[c[c[d>>2]>>2]&255](d);b=c[b+52>>2]|0;if(!b)return;c[5134]=(c[5134]|0)+1;_E(c[b+-4>>2]|0);return}function Dx(b){b=b|0;var d=0;c[b>>2]=12248;if(a[b+61>>0]|0){d=c[b+52>>2]|0;Jb[c[c[d>>2]>>2]&255](d);d=c[b+52>>2]|0;if(d){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}if(!b)return}c[5134]=(c[5134]|0)+1;_E(c[b+-4>>2]|0);return}function Ex(d,f,h,j){d=d|0;f=f|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0;w=i;i=i+80|0;v=c[d+48>>2]|0;c[w>>2]=12432;c[w+4>>2]=v;c[w+8>>2]=f;v=c[d+52>>2]|0;if(!(a[v+60>>0]|0)){f=c[v+56>>2]|0;if((f|0)>0){d=f;m=0;p=c[v+96>>2]|0;f=0;while(1){f=f+1|0;if(!(+g[h>>2]>+g[p+16>>2])?!(+g[j>>2]<+g[p>>2]):0)k=1;else k=0;if(!(!(+g[h+8>>2]>+g[p+24>>2])?!(+g[j+8>>2]<+g[p+8>>2]):0))k=0;if(!(+g[h+4>>2]>+g[p+20>>2])?!(+g[j+4>>2]<+g[p+4>>2]):0){l=c[p+32>>2]|0;if((l|0)==-1&k){pc[c[(c[w>>2]|0)+8>>2]&127](w,c[p+36>>2]|0,c[p+40>>2]|0);d=c[v+56>>2]|0;o=43}else{n=(l|0)==-1;o=42}}else{l=c[p+32>>2]|0;k=0;n=(l|0)==-1;o=42}if((o|0)==42){o=0;if(k|n)o=43;else{m=l+m|0;k=p+(l<<6)|0}}if((o|0)==43){m=m+1|0;k=p+64|0}if((m|0)<(d|0))p=k;else break}}else f=0;if((c[4364]|0)>=(f|0)){i=w;return}c[4364]=f;i=w;return}z=+g[h>>2];D=+g[h+4>>2];H=+g[h+8>>2];G=+g[v+4>>2];z=z<G?G:z;C=+g[v+8>>2];D=D<C?C:D;y=+g[v+12>>2];H=H<y?y:H;I=+g[v+20>>2];E=+g[v+24>>2];A=+g[v+28>>2];F=+g[v+36>>2];B=+g[v+40>>2];x=+g[v+44>>2];t=~~(((I<z?I:z)-G)*F)&65534;b[w+66>>1]=t;u=~~(((E<D?E:D)-C)*B)&65534;b[w+68>>1]=u;s=~~(((A<H?A:H)-y)*x)&65534;b[w+70>>1]=s;H=+g[j>>2];D=+g[j+4>>2];z=+g[j+8>>2];H=H<G?G:H;D=D<C?C:D;z=z<y?y:z;q=(~~(((I<H?I:H)-G)*F+1.0)&65535|1)&65535;b[w+60>>1]=q;r=(~~(((E<D?E:D)-C)*B+1.0)&65535|1)&65535;b[w+62>>1]=r;j=(~~(((A<z?A:z)-y)*x+1.0)&65535|1)&65535;b[w+64>>1]=j;d=c[v+144>>2]|0;if(!d){o=c[v+56>>2]|0;if((o|0)>0){m=0;l=c[v+136>>2]|0;f=0;do{f=f+1|0;n=((q&65535)>=(e[l>>1]|0)?(t&65535)<=(e[l+6>>1]|0):0)&(s&65535)<=(e[l+10>>1]|0)&(j&65535)>=(e[l+4>>1]|0)&(u&65535)<=(e[l+8>>1]|0)&(r&65535)>=(e[l+2>>1]|0);k=l+12|0;d=c[k>>2]|0;if((d|0)>-1&n)pc[c[(c[w>>2]|0)+8>>2]&127](w,d>>21,d&2097151);if(n|(d|0)>-1){m=m+1|0;l=l+16|0}else{v=c[k>>2]|0;m=m-v|0;l=l+(0-v<<4)|0}}while((m|0)<(o|0))}else f=0;if((c[4364]|0)>=(f|0)){i=w;return}c[4364]=f;i=w;return}else if((d|0)==2){BC(c[v+136>>2]|0,w,w+66|0,w+60|0);i=w;return}else if((d|0)==1){if((c[v+152>>2]|0)<=0){i=w;return}h=0;do{k=c[v+160>>2]|0;if(((q&65535)>=(e[k+(h<<5)>>1]|0)?(t&65535)<=(e[k+(h<<5)+6>>1]|0):0)&(s&65535)<=(e[k+(h<<5)+10>>1]|0)&(j&65535)>=(e[k+(h<<5)+4>>1]|0)&(u&65535)<=(e[k+(h<<5)+8>>1]|0)&(r&65535)>=(e[k+(h<<5)+2>>1]|0)){p=c[k+(h<<5)+12>>2]|0;f=c[k+(h<<5)+16>>2]|0;a:do if((f|0)>0){n=p;m=(c[v+136>>2]|0)+(p<<4)|0;k=1;while(1){o=((q&65535)>=(e[m>>1]|0)?(t&65535)<=(e[m+6>>1]|0):0)&(s&65535)<=(e[m+10>>1]|0)&(j&65535)>=(e[m+4>>1]|0)&(u&65535)<=(e[m+8>>1]|0)&(r&65535)>=(e[m+2>>1]|0);l=m+12|0;d=c[l>>2]|0;if((d|0)>-1&o)pc[c[(c[w>>2]|0)+8>>2]&127](w,d>>21,d&2097151);if(o|(d|0)>-1){n=n+1|0;m=m+16|0}else{o=c[l>>2]|0;n=n-o|0;m=m+(0-o<<4)|0}if((n|0)>=(f+p|0))break a;k=k+1|0}}else k=0;while(0);if((c[4364]|0)<(k|0))c[4364]=k}h=h+1|0}while((h|0)<(c[v+152>>2]|0));i=w;return}else{i=w;return}}function Fx(b,d){b=b|0;d=d|0;var e=0,f=0.0,h=0.0,i=0.0,j=0;j=Nb[c[(c[b>>2]|0)+28>>2]&127](b)|0;i=+g[j>>2]-+g[d>>2];h=+g[j+4>>2]-+g[d+4>>2];f=+g[j+8>>2]-+g[d+8>>2];if(!(i*i+h*h+f*f>1.1920928955078125e-07))return;Zx(b,d);if((a[b+61>>0]|0)!=0?(e=c[b+52>>2]|0,Jb[c[c[e>>2]>>2]&255](e),e=c[b+52>>2]|0,(e|0)!=0):0){c[5134]=(c[5134]|0)+1;_E(c[e+-4>>2]|0)}c[5132]=(c[5132]|0)+1;e=ZE(191)|0;if(!e)e=0;else{c[(e+19&-16)+-4>>2]=e;e=e+19&-16}c[e+52>>2]=282;a[e+60>>0]=0;a[e+80>>0]=1;c[e+76>>2]=0;c[e+68>>2]=0;c[e+72>>2]=0;a[e+100>>0]=1;c[e+96>>2]=0;c[e+88>>2]=0;c[e+92>>2]=0;a[e+120>>0]=1;c[e+116>>2]=0;c[e+108>>2]=0;c[e+112>>2]=0;a[e+140>>0]=1;c[e+136>>2]=0;c[e+128>>2]=0;c[e+132>>2]=0;c[e+144>>2]=0;a[e+164>>0]=1;c[e+160>>2]=0;c[e+152>>2]=0;c[e+156>>2]=0;c[e+168>>2]=0;g[e+4>>2]=-3402823466385288598117041.0e14;g[e+8>>2]=-3402823466385288598117041.0e14;g[e+12>>2]=-3402823466385288598117041.0e14;g[e+16>>2]=0.0;g[e+20>>2]=3402823466385288598117041.0e14;g[e+24>>2]=3402823466385288598117041.0e14;g[e+28>>2]=3402823466385288598117041.0e14;g[e+32>>2]=0.0;c[e>>2]=15184;c[b+52>>2]=e;fA(e,c[b+48>>2]|0,(a[b+60>>0]|0)!=0,b+16|0,b+32|0);a[b+61>>0]=1;return}function Gx(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0;e=ec[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;h=ec[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;c[b>>2]=h;if(h)Lb[c[(c[d>>2]|0)+48>>2]&127](d,e);c[b+4>>2]=c[a+4>>2];h=c[a+48>>2]|0;Wb[c[(c[h>>2]|0)+56>>2]&63](h,b+12|0,d)|0;g[b+52>>2]=+g[a+12>>2];do if((c[a+52>>2]|0)!=0?((Nb[c[(c[d>>2]|0)+52>>2]&127](d)|0)&1|0)==0:0){e=ec[c[(c[d>>2]|0)+24>>2]&31](d,c[a+52>>2]|0)|0;if(!e){c[b+40>>2]=ec[c[(c[d>>2]|0)+28>>2]&31](d,c[a+52>>2]|0)|0;c[b+44>>2]=0;e=c[a+52>>2]|0;e=Nb[c[(c[e>>2]|0)+12>>2]&127](e)|0;e=Wb[c[(c[d>>2]|0)+16>>2]&63](d,e,1)|0;h=c[a+52>>2]|0;h=Wb[c[(c[h>>2]|0)+16>>2]&63](h,c[e+8>>2]|0,d)|0;Hb[c[(c[d>>2]|0)+20>>2]&31](d,e,h,1213612625,c[a+52>>2]|0);break}else{c[b+40>>2]=e;c[b+44>>2]=0;break}}else f=8;while(0);if((f|0)==8){c[b+40>>2]=0;c[b+44>>2]=0}if((c[a+56>>2]|0)!=0?((Nb[c[(c[d>>2]|0)+52>>2]&127](d)|0)&2|0)==0:0){e=ec[c[(c[d>>2]|0)+24>>2]&31](d,c[a+56>>2]|0)|0;if(!e){c[b+48>>2]=ec[c[(c[d>>2]|0)+28>>2]&31](d,c[a+56>>2]|0)|0;b=c[a+56>>2]|0;b=Nb[c[(c[b>>2]|0)+8>>2]&127](b)|0;b=Wb[c[(c[d>>2]|0)+16>>2]&63](d,b,1)|0;h=c[a+56>>2]|0;h=Wb[c[(c[h>>2]|0)+12>>2]&63](h,c[b+8>>2]|0,d)|0;Hb[c[(c[d>>2]|0)+20>>2]&31](d,b,h,1346456916,c[a+56>>2]|0);return 12336}else{c[b+48>>2]=e;return 12336}}c[b+48>>2]=0;return 12336}function Hx(a,b){a=a|0;b=b|0;var d=0,e=0;d=c[a+52>>2]|0;if(!d)return;e=Nb[c[(c[d>>2]|0)+12>>2]&127](d)|0;e=Wb[c[(c[b>>2]|0)+16>>2]&63](b,e,1)|0;d=c[a+52>>2]|0;d=Wb[c[(c[d>>2]|0)+16>>2]&63](d,c[e+8>>2]|0,b)|0;Hb[c[(c[b>>2]|0)+20>>2]&31](b,e,d,1213612625,c[a+52>>2]|0);return}function Ix(a,b){a=a|0;b=b|0;var d=0,e=0;d=c[a+56>>2]|0;if(!d)return;e=Nb[c[(c[d>>2]|0)+8>>2]&127](d)|0;e=Wb[c[(c[b>>2]|0)+16>>2]&63](b,e,1)|0;d=c[a+56>>2]|0;d=Wb[c[(c[d>>2]|0)+12>>2]&63](d,c[e+8>>2]|0,b)|0;Hb[c[(c[b>>2]|0)+20>>2]&31](b,e,d,1346456916,c[a+56>>2]|0);return}function Jx(a,b,d){a=a|0;b=b|0;d=d|0;pc[c[(c[b>>2]|0)+68>>2]&127](a,b,d);return}function Kx(a){a=a|0;return 60}function Lx(a){a=a|0;return +(+g[a+12>>2])}function Mx(a,b){a=a|0;b=+b;g[a+12>>2]=b;return}function Nx(a){a=a|0;return 12408}function Ox(a,b,f){a=a|0;b=b|0;f=f|0;var j=0,k=0.0,l=0.0,m=0.0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;t=i;i=i+32|0;p=c[a+4>>2]|0;dc[c[(c[p>>2]|0)+16>>2]&3](p,t+4|0,t+16|0,t+8|0,t+20|0,t+28|0,t,t+12|0,t+24|0,b);p=c[t+28>>2]|0;q=$(c[t>>2]|0,f)|0;r=c[a+4>>2]|0;o=c[t+24>>2]|0;s=2;while(1){if((o|0)==3)j=e[p+q+(s<<1)>>1]|0;else if((o|0)==2)j=c[p+q+(s<<2)>>2]|0;else j=d[p+(s+q)>>0]|0;n=c[t+4>>2]|0;j=$(c[t+20>>2]|0,j)|0;if(!(c[t+8>>2]|0)){l=+g[n+(j+8)>>2]*+g[r+12>>2];m=+g[n+(j+4)>>2]*+g[r+8>>2];k=+g[n+j>>2]*+g[r+4>>2]}else{l=+h[n+(j+16)>>3]*+g[r+12>>2];m=+h[n+(j+8)>>3]*+g[r+8>>2];k=+h[n+j>>3]*+g[r+4>>2]}g[a+(s<<4)+12>>2]=k;g[a+(s<<4)+16>>2]=m;g[a+(s<<4)+20>>2]=l;g[a+(s<<4)+24>>2]=0.0;if((s|0)>0)s=s+-1|0;else break}s=c[a+8>>2]|0;tc[c[(c[s>>2]|0)+8>>2]&127](s,a+12|0,b,f);a=c[a+4>>2]|0;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=t;return}function Px(a){a=a|0;_E(a);return}function Qx(a){a=a|0;return}function Rx(a,b,d){a=a|0;b=b|0;d=d|0;var f=0.0,j=0.0,k=0.0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;s=i;i=i+96|0;n=c[a+4>>2]|0;dc[c[(c[n>>2]|0)+16>>2]&3](n,s+16|0,s+4|0,s+8|0,s+80|0,s,s+12|0,s+24|0,s+20|0,b);n=c[s>>2]|0;o=$(c[s+12>>2]|0,d)|0;r=c[a+4>>2]|0;p=(c[s+8>>2]|0)==0;q=c[s+16>>2]|0;if((c[s+20>>2]|0)!=3){l=c[s+80>>2]|0;m=$(l,c[n+(o+8)>>2]|0)|0;if(p){j=+g[q+(m+4)>>2]*+g[r+8>>2];k=+g[q+(m+8)>>2]*+g[r+12>>2];g[s+64>>2]=+g[q+m>>2]*+g[r+4>>2];g[s+68>>2]=j;g[s+72>>2]=k;g[s+76>>2]=0.0;p=$(l,c[n+(o+4)>>2]|0)|0;k=+g[q+(p+4)>>2]*+g[r+8>>2];j=+g[q+(p+8)>>2]*+g[r+12>>2];g[s+48>>2]=+g[q+p>>2]*+g[r+4>>2];g[s+52>>2]=k;g[s+56>>2]=j;g[s+60>>2]=0.0;p=$(l,c[n+o>>2]|0)|0;j=+g[q+(p+4)>>2]*+g[r+8>>2];k=+g[q+(p+8)>>2]*+g[r+12>>2];g[s+32>>2]=+g[q+p>>2]*+g[r+4>>2];g[s+36>>2]=j;g[s+40>>2]=k;g[s+44>>2]=0.0;r=a+8|0;r=c[r>>2]|0;q=c[r>>2]|0;q=q+8|0;q=c[q>>2]|0;tc[q&127](r,s+32|0,b,d);a=c[a+4>>2]|0;d=c[a>>2]|0;d=d+24|0;d=c[d>>2]|0;Lb[d&127](a,b);i=s;return}else{j=+h[q+(m+8)>>3]*+g[r+8>>2];k=+h[q+(m+16)>>3]*+g[r+12>>2];g[s+64>>2]=+h[q+m>>3]*+g[r+4>>2];g[s+68>>2]=j;g[s+72>>2]=k;g[s+76>>2]=0.0;p=$(l,c[n+(o+4)>>2]|0)|0;k=+h[q+(p+8)>>3]*+g[r+8>>2];j=+h[q+(p+16)>>3]*+g[r+12>>2];g[s+48>>2]=+h[q+p>>3]*+g[r+4>>2];g[s+52>>2]=k;g[s+56>>2]=j;g[s+60>>2]=0.0;p=$(l,c[n+o>>2]|0)|0;j=+h[q+(p+8)>>3]*+g[r+8>>2];k=+h[q+(p+16)>>3]*+g[r+12>>2];g[s+32>>2]=+h[q+p>>3]*+g[r+4>>2];g[s+36>>2]=j;g[s+40>>2]=k;g[s+44>>2]=0.0;r=a+8|0;r=c[r>>2]|0;q=c[r>>2]|0;q=q+8|0;q=c[q>>2]|0;tc[q&127](r,s+32|0,b,d);a=c[a+4>>2]|0;d=c[a>>2]|0;d=d+24|0;d=c[d>>2]|0;Lb[d&127](a,b);i=s;return}}l=c[s+80>>2]|0;m=$(l,e[n+(o+4)>>1]|0)|0;if(p){j=+g[q+(m+8)>>2]*+g[r+12>>2];f=+g[q+(m+4)>>2]*+g[r+8>>2];k=+g[q+m>>2]*+g[r+4>>2]}else{j=+h[q+(m+16)>>3]*+g[r+12>>2];f=+h[q+(m+8)>>3]*+g[r+8>>2];k=+h[q+m>>3]*+g[r+4>>2]}g[s+64>>2]=k;g[s+68>>2]=f;g[s+72>>2]=j;g[s+76>>2]=0.0;m=$(l,e[n+(o+2)>>1]|0)|0;if(p){j=+g[q+(m+8)>>2]*+g[r+12>>2];f=+g[q+(m+4)>>2]*+g[r+8>>2];k=+g[q+m>>2]*+g[r+4>>2]}else{j=+h[q+(m+16)>>3]*+g[r+12>>2];f=+h[q+(m+8)>>3]*+g[r+8>>2];k=+h[q+m>>3]*+g[r+4>>2]}g[s+48>>2]=k;g[s+52>>2]=f;g[s+56>>2]=j;g[s+60>>2]=0.0;l=$(l,e[n+o>>1]|0)|0;if(p){j=+g[q+(l+8)>>2]*+g[r+12>>2];k=+g[q+(l+4)>>2]*+g[r+8>>2];f=+g[q+l>>2]*+g[r+4>>2]}else{j=+h[q+(l+16)>>3]*+g[r+12>>2];k=+h[q+(l+8)>>3]*+g[r+8>>2];f=+h[q+l>>3]*+g[r+4>>2]}g[s+32>>2]=f;g[s+36>>2]=k;g[s+40>>2]=j;g[s+44>>2]=0.0;r=a+8|0;r=c[r>>2]|0;q=c[r>>2]|0;q=q+8|0;q=c[q>>2]|0;tc[q&127](r,s+32|0,b,d);a=c[a+4>>2]|0;d=c[a>>2]|0;d=d+24|0;d=c[d>>2]|0;Lb[d&127](a,b);i=s;return}function Sx(a){a=a|0;_E(a);return}function Tx(a,b,d){a=a|0;b=b|0;d=d|0;var f=0,j=0.0,k=0.0,l=0.0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;s=i;i=i+96|0;p=c[a+4>>2]|0;dc[c[(c[p>>2]|0)+16>>2]&3](p,s+16|0,s+4|0,s+8|0,s+80|0,s,s+12|0,s+24|0,s+20|0,b);p=(c[s>>2]|0)+($(c[s+12>>2]|0,d)|0)|0;q=c[a+4>>2]|0;m=(c[s+20>>2]|0)==3;n=(c[s+8>>2]|0)==0;o=c[s+16>>2]|0;r=2;while(1){if(m)f=e[p+(r<<1)>>1]|0;else f=c[p+(r<<2)>>2]|0;f=$(c[s+80>>2]|0,f)|0;if(n){k=+g[o+(f+8)>>2]*+g[q+12>>2];l=+g[o+f>>2]*+g[q+4>>2];j=+g[o+(f+4)>>2]*+g[q+8>>2]}else{k=+h[o+(f+16)>>3]*+g[q+12>>2];l=+h[o+f>>3]*+g[q+4>>2];j=+h[o+(f+8)>>3]*+g[q+8>>2]}g[s+32+(r<<4)>>2]=l;g[s+32+(r<<4)+4>>2]=j;g[s+32+(r<<4)+8>>2]=k;g[s+32+(r<<4)+12>>2]=0.0;if((r|0)>0)r=r+-1|0;else break}r=c[a+8>>2]|0;tc[c[(c[r>>2]|0)+8>>2]&127](r,s+32|0,b,d);a=c[a+4>>2]|0;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=s;return}function Ux(a){a=a|0;_E(a);return}function Vx(a,b){a=a|0;b=b|0;var d=0;d=i;i=i+48|0;c[a+8>>2]=0;g[a+12>>2]=0.0;c[a>>2]=12920;c[a+48>>2]=b;c[a+4>>2]=21;if(Nb[c[(c[b>>2]|0)+40>>2]&127](b)|0){pc[c[(c[b>>2]|0)+48>>2]&127](b,a+16|0,a+32|0);i=d;return}else{c[d+32>>2]=0;c[d+36>>2]=0;c[d+40>>2]=0;c[d+44>>2]=0;g[d+32>>2]=1.0;pc[c[(c[a>>2]|0)+68>>2]&127](d+16|0,a,d+32|0);g[a+32>>2]=+g[d+16>>2]+ +g[a+12>>2];g[d+32>>2]=-1.0;pc[c[(c[a>>2]|0)+68>>2]&127](d,a,d+32|0);c[d+16>>2]=c[d+0>>2];c[d+20>>2]=c[d+4>>2];c[d+24>>2]=c[d+8>>2];c[d+28>>2]=c[d+12>>2];g[a+16>>2]=+g[d+16>>2]-+g[a+12>>2];c[d+32>>2]=0;c[d+36>>2]=0;c[d+40>>2]=0;c[d+44>>2]=0;g[d+36>>2]=1.0;pc[c[(c[a>>2]|0)+68>>2]&127](d+16|0,a,d+32|0);g[a+36>>2]=+g[d+20>>2]+ +g[a+12>>2];g[d+36>>2]=-1.0;pc[c[(c[a>>2]|0)+68>>2]&127](d,a,d+32|0);c[d+16>>2]=c[d+0>>2];c[d+20>>2]=c[d+4>>2];c[d+24>>2]=c[d+8>>2];c[d+28>>2]=c[d+12>>2];g[a+20>>2]=+g[d+20>>2]-+g[a+12>>2];c[d+32>>2]=0;c[d+36>>2]=0;c[d+40>>2]=0;c[d+44>>2]=0;g[d+40>>2]=1.0;pc[c[(c[a>>2]|0)+68>>2]&127](d+16|0,a,d+32|0);g[a+40>>2]=+g[d+24>>2]+ +g[a+12>>2];g[d+40>>2]=-1.0;pc[c[(c[a>>2]|0)+68>>2]&127](d,a,d+32|0);c[d+16>>2]=c[d+0>>2];c[d+20>>2]=c[d+4>>2];c[d+24>>2]=c[d+8>>2];c[d+28>>2]=c[d+12>>2];g[a+24>>2]=+g[d+24>>2]-+g[a+12>>2];i=d;return}}function Wx(a){a=a|0;return}function Xx(a){a=a|0;if(!a)return;c[5134]=(c[5134]|0)+1;_E(c[a+-4>>2]|0);return}function Yx(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0;o=(+g[a+32>>2]-+g[a+16>>2])*.5;l=(+g[a+36>>2]-+g[a+20>>2])*.5;i=(+g[a+40>>2]-+g[a+24>>2])*.5;n=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);k=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);i=i+ +Zb[c[(c[a>>2]|0)+48>>2]&15](a);B=(+g[a+32>>2]+ +g[a+16>>2])*.5;z=(+g[a+36>>2]+ +g[a+20>>2])*.5;x=(+g[a+40>>2]+ +g[a+24>>2])*.5;F=+g[b>>2];w=+O(+F);E=+g[b+4>>2];v=+O(+E);t=+g[b+8>>2];u=+O(+t);D=+g[b+16>>2];s=+O(+D);C=+g[b+20>>2];r=+O(+C);p=+g[b+24>>2];q=+O(+p);A=+g[b+32>>2];m=+O(+A);y=+g[b+36>>2];j=+O(+y);f=+g[b+40>>2];h=+O(+f);t=B*F+z*E+x*t+ +g[b+48>>2];p=B*D+z*C+x*p+ +g[b+52>>2];f=B*A+z*y+x*f+ +g[b+56>>2];g[d>>2]=t-((o+n)*w+(l+k)*v+i*u);g[d+4>>2]=p-((o+n)*s+(l+k)*r+i*q);g[d+8>>2]=f-((o+n)*m+(l+k)*j+i*h);g[d+12>>2]=0.0;g[e>>2]=(o+n)*w+(l+k)*v+i*u+t;g[e+4>>2]=(o+n)*s+(l+k)*r+i*q+p;g[e+8>>2]=(o+n)*m+(l+k)*j+i*h+f;g[e+12>>2]=0.0;return}function Zx(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;i=i+48|0;e=(c[a+48>>2]|0)+4|0;c[e+0>>2]=c[b+0>>2];c[e+4>>2]=c[b+4>>2];c[e+8>>2]=c[b+8>>2];c[e+12>>2]=c[b+12>>2];c[d+32>>2]=0;c[d+36>>2]=0;c[d+40>>2]=0;c[d+44>>2]=0;g[d+32>>2]=1.0;pc[c[(c[a>>2]|0)+68>>2]&127](d+16|0,a,d+32|0);g[a+32>>2]=+g[d+16>>2]+ +g[a+12>>2];g[d+32>>2]=-1.0;pc[c[(c[a>>2]|0)+68>>2]&127](d,a,d+32|0);c[d+16>>2]=c[d+0>>2];c[d+20>>2]=c[d+4>>2];c[d+24>>2]=c[d+8>>2];c[d+28>>2]=c[d+12>>2];g[a+16>>2]=+g[d+16>>2]-+g[a+12>>2];c[d+32>>2]=0;c[d+36>>2]=0;c[d+40>>2]=0;c[d+44>>2]=0;g[d+36>>2]=1.0;pc[c[(c[a>>2]|0)+68>>2]&127](d+16|0,a,d+32|0);g[a+36>>2]=+g[d+20>>2]+ +g[a+12>>2];g[d+36>>2]=-1.0;pc[c[(c[a>>2]|0)+68>>2]&127](d,a,d+32|0);c[d+16>>2]=c[d+0>>2];c[d+20>>2]=c[d+4>>2];c[d+24>>2]=c[d+8>>2];c[d+28>>2]=c[d+12>>2];g[a+20>>2]=+g[d+20>>2]-+g[a+12>>2];c[d+32>>2]=0;c[d+36>>2]=0;c[d+40>>2]=0;c[d+44>>2]=0;g[d+40>>2]=1.0;pc[c[(c[a>>2]|0)+68>>2]&127](d+16|0,a,d+32|0);g[a+40>>2]=+g[d+24>>2]+ +g[a+12>>2];g[d+40>>2]=-1.0;pc[c[(c[a>>2]|0)+68>>2]&127](d,a,d+32|0);c[d+16>>2]=c[d+0>>2];c[d+20>>2]=c[d+4>>2];c[d+24>>2]=c[d+8>>2];c[d+28>>2]=c[d+12>>2];g[a+24>>2]=+g[d+24>>2]-+g[a+12>>2];i=d;return}function _x(a){a=a|0;return (c[a+48>>2]|0)+4|0}function $x(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;i=i+48|0;c[f>>2]=13128;c[f+4>>2]=b;c[f+8>>2]=c[d+0>>2];c[f+12>>2]=c[d+4>>2];c[f+16>>2]=c[d+8>>2];c[f+20>>2]=c[d+12>>2];c[f+24>>2]=c[e+0>>2];c[f+28>>2]=c[e+4>>2];c[f+32>>2]=c[e+8>>2];c[f+36>>2]=c[e+12>>2];a=c[a+48>>2]|0;tc[c[(c[a>>2]|0)+8>>2]&127](a,f,d,e);i=f;return}function ay(a,b,d){a=a|0;b=+b;d=d|0;c[d+0>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;return}function by(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0;e=i;i=i+176|0;c[e+160>>2]=0;c[e+164>>2]=0;c[e+168>>2]=0;c[e+172>>2]=0;c[e+136>>2]=0;c[e+140>>2]=0;c[e+144>>2]=0;c[e+148>>2]=0;c[e+152>>2]=0;c[e+32>>2]=13064;c[e+36>>2]=0;c[e+40>>2]=0;c[e+44>>2]=0;c[e+48>>2]=0;g[e+52>>2]=1.0;c[e+56>>2]=c[e+160>>2];c[e+60>>2]=c[e+164>>2];c[e+64>>2]=c[e+168>>2];c[e+68>>2]=0;g[e+72>>2]=1.0;c[e+76>>2]=0;c[e+80>>2]=0;c[e+84>>2]=0;c[e+88>>2]=0;g[e+92>>2]=1.0;g[e+96>>2]=0.0;c[e+100>>2]=c[e+140>>2];c[e+104>>2]=c[e+144>>2];c[e+108>>2]=c[e+148>>2];c[e+112>>2]=c[e+152>>2];g[e+116>>2]=-999999984306749440.0;l=+g[d>>2];k=+g[d+4>>2];j=+g[d+8>>2];h=l*+g[e+56>>2]+k+j*0.0;f=l*+g[e+60>>2]+k*0.0+j;g[e+120>>2]=l+k*0.0+j*0.0;g[e+124>>2]=h;g[e+128>>2]=f;g[e+132>>2]=0.0;g[e+16>>2]=999999984306749440.0;g[e+20>>2]=999999984306749440.0;g[e+24>>2]=999999984306749440.0;g[e+28>>2]=0.0;d=c[(c[b>>2]|0)+64>>2]|0;g[e>>2]=-999999984306749440.0;g[e+4>>2]=-999999984306749440.0;g[e+8>>2]=-999999984306749440.0;g[e+12>>2]=0.0;tc[d&127](b,e+32|0,e,e+16|0);c[a+0>>2]=c[e+36>>2];c[a+4>>2]=c[e+40>>2];c[a+8>>2]=c[e+44>>2];c[a+12>>2]=c[e+48>>2];i=e;return}function cy(a){a=a|0;return 12}function dy(a){a=a|0;return 13040}function ey(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;j=+g[a+88>>2];k=+g[a+92>>2];i=+g[a+96>>2];f=j*+g[b>>2]+k*+g[b+4>>2]+i*+g[b+8>>2];h=+g[a+84>>2];if(f>h){g[a+84>>2]=f;c[a+4>>2]=c[b+0>>2];c[a+8>>2]=c[b+4>>2];c[a+12>>2]=c[b+8>>2];c[a+16>>2]=c[b+12>>2]}else f=h;h=j*+g[b+16>>2]+k*+g[b+20>>2]+i*+g[b+24>>2];if(h>f){g[a+84>>2]=h;c[a+4>>2]=c[b+16>>2];c[a+8>>2]=c[b+20>>2];c[a+12>>2]=c[b+24>>2];c[a+16>>2]=c[b+28>>2]}else h=f;f=j*+g[b+32>>2]+k*+g[b+36>>2]+i*+g[b+40>>2];if(!(f>h))return;g[a+84>>2]=f;c[a+4>>2]=c[b+32>>2];c[a+8>>2]=c[b+36>>2];c[a+12>>2]=c[b+40>>2];c[a+16>>2]=c[b+44>>2];return}function fy(a){a=a|0;_E(a);return}function gy(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0;f=+g[b>>2];h=+g[b+16>>2];j=f<h?f:h;i=+g[b+32>>2];if((j<i?j:i)>+g[a+24>>2])return;k=f>h?b:b+16|0;if(+g[(+g[k>>2]>i?k:b+32|0)>>2]<+g[a+8>>2])return;h=+g[b+8>>2];f=+g[b+24>>2];j=h<f?h:f;i=+g[b+40>>2];if((j<i?j:i)>+g[a+32>>2])return;k=h>f?b+8|0:b+24|0;if(+g[(+g[k>>2]>i?k:b+40|0)>>2]<+g[a+16>>2])return;i=+g[b+4>>2];h=+g[b+20>>2];j=i<h?i:h;f=+g[b+36>>2];if((j<f?j:f)>+g[a+28>>2])return;k=i>h?b+4|0:b+20|0;if(+g[(+g[k>>2]>f?k:b+36|0)>>2]<+g[a+12>>2])return;a=c[a+4>>2]|0;tc[c[(c[a>>2]|0)+8>>2]&127](a,b,d,e);return}function hy(a){a=a|0;_E(a);return}function iy(a){a=a|0;return}function jy(a){a=a|0;if(!a)return;c[5134]=(c[5134]|0)+1;_E(c[a+-4>>2]|0);return}function ky(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;g[c>>2]=-999999984306749440.0;g[c+4>>2]=-999999984306749440.0;g[c+8>>2]=-999999984306749440.0;g[c+12>>2]=0.0;g[d>>2]=999999984306749440.0;g[d+4>>2]=999999984306749440.0;g[d+8>>2]=999999984306749440.0;g[d+12>>2]=0.0;return}function ly(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0,y=0.0;x=i;i=i+48|0;t=+g[e>>2];u=+g[d>>2];v=+g[e+4>>2];w=+g[d+4>>2];s=+g[e+8>>2];h=+g[d+8>>2];j=+P(+((t-u)*.5*((t-u)*.5)+(v-w)*.5*((v-w)*.5)+(s-h)*.5*((s-h)*.5)));k=+g[a+56>>2];d=+O(+k)>.7071067690849304;l=+g[a+52>>2];if(d){r=1.0/+P(+(k*k+l*l));y=+g[a+48>>2];f=y*-(k*r);m=y;n=0.0;o=-(k*r);p=l*r;q=(k*k+l*l)*r;r=-(y*(l*r))}else{q=+g[a+48>>2];r=1.0/+P(+(q*q+l*l));f=(q*q+l*l)*r;m=q;n=-(l*r);o=q*r;p=0.0;q=-(k*(q*r));r=k*-(l*r)}y=(t+u)*.5*m+(v+w)*.5*l+(s+h)*.5*k-+g[a+64>>2];m=(t+u)*.5-m*y;n=j*n;o=j*o;u=j*p;q=j*q;r=j*r;t=j*f;g[x>>2]=q+(n+m);g[x+4>>2]=r+(o+((v+w)*.5-l*y));g[x+8>>2]=t+(u+((s+h)*.5-k*y));g[x+12>>2]=0.0;g[x+16>>2]=n+m-q;g[x+20>>2]=o+((v+w)*.5-l*y)-r;g[x+24>>2]=u+((s+h)*.5-k*y)-t;g[x+28>>2]=0.0;g[x+32>>2]=m-n-q;g[x+36>>2]=(v+w)*.5-l*y-o-r;g[x+40>>2]=(s+h)*.5-k*y-u-t;g[x+44>>2]=0.0;tc[c[(c[b>>2]|0)+8>>2]&127](b,x,0,0);g[x>>2]=m-n-q;g[x+4>>2]=(v+w)*.5-l*y-o-r;g[x+8>>2]=(s+h)*.5-k*y-u-t;g[x+12>>2]=0.0;g[x+16>>2]=q+(m-n);g[x+20>>2]=r+((v+w)*.5-l*y-o);g[x+24>>2]=t+((s+h)*.5-k*y-u);g[x+28>>2]=0.0;g[x+32>>2]=q+(n+m);g[x+36>>2]=r+(o+((v+w)*.5-l*y));g[x+40>>2]=t+(u+((s+h)*.5-k*y));g[x+44>>2]=0.0;tc[c[(c[b>>2]|0)+8>>2]&127](b,x,0,1);i=x;return}function my(a,b,d){a=a|0;b=+b;d=d|0;c[d+0>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;return}function ny(a,b){a=a|0;b=b|0;c[a+68>>2]=c[b+0>>2];c[a+72>>2]=c[b+4>>2];c[a+76>>2]=c[b+8>>2];c[a+80>>2]=c[b+12>>2];return}function oy(a){a=a|0;return a+68|0}function py(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=ec[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;f=ec[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;c[b>>2]=f;if(f)Lb[c[(c[d>>2]|0)+48>>2]&127](d,e);c[b+4>>2]=c[a+4>>2];g[b+12>>2]=+g[a+68>>2];g[b+16>>2]=+g[a+72>>2];g[b+20>>2]=+g[a+76>>2];g[b+24>>2]=+g[a+80>>2];g[b+28>>2]=+g[a+48>>2];g[b+32>>2]=+g[a+52>>2];g[b+36>>2]=+g[a+56>>2];g[b+40>>2]=+g[a+60>>2];g[b+44>>2]=+g[a+64>>2];return 13384}function qy(a){a=a|0;return 52}function ry(a){a=a|0;return 13408}function sy(a){a=a|0;var b=0;c[a>>2]=13432;b=c[a+52>>2]|0;if(b){Jb[c[c[b>>2]>>2]&255](b);b=c[a+52>>2]|0;if(b){c[5134]=(c[5134]|0)+1;_E(c[b+-4>>2]|0)}if(!a)return}c[5134]=(c[5134]|0)+1;_E(c[a+-4>>2]|0);return}function ty(d,f){d=d|0;f=f|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0,v=0.0,w=0.0,x=0,y=0,z=0,A=0,B=0,C=0,D=0.0,E=0.0,F=0,G=0.0,H=0,I=0.0,J=0,K=0,L=0,M=0,N=0,Q=0,R=0,S=0.0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0.0,ea=0.0,fa=0,ga=0;ca=i;i=i+320|0;h=c[d+52>>2]|0;if((h|0)!=0?(Jb[c[c[h>>2]>>2]&255](h),j=c[d+52>>2]|0,(j|0)!=0):0){c[5134]=(c[5134]|0)+1;_E(c[j+-4>>2]|0)}c[5132]=(c[5132]|0)+1;h=ZE(151)|0;if(!h)h=0;else{c[(h+19&-16)+-4>>2]=h;h=h+19&-16}c[h>>2]=20088;a[h+20>>0]=1;c[h+16>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;a[h+40>>0]=1;c[h+36>>2]=0;c[h+28>>2]=0;c[h+32>>2]=0;a[h+60>>0]=1;c[h+56>>2]=0;c[h+48>>2]=0;c[h+52>>2]=0;c[d+52>>2]=h;j=0;h=0;ba=0;k=0;while(1){if((j|0)>=(Nb[c[(c[d>>2]|0)+96>>2]&127](d)|0))break;if((h|0)==(k|0)){o=(k|0)==0?1:k<<1;if((k|0)<(o|0)){if((o|0)!=0?(c[5132]=(c[5132]|0)+1,u=ZE((o<<4|3)+16|0)|0,(u|0)!=0):0){c[(u+19&-16)+-4>>2]=u;m=u+19&-16}else m=0;if((k|0)>0){n=0;do{aa=m+(n<<4)|0;$=ba+(n<<4)|0;c[aa+0>>2]=c[$+0>>2];c[aa+4>>2]=c[$+4>>2];c[aa+8>>2]=c[$+8>>2];c[aa+12>>2]=c[$+12>>2];n=n+1|0}while((n|0)!=(k|0))}if(!ba){l=k;n=m}else{c[5134]=(c[5134]|0)+1;_E(c[ba+-4>>2]|0);l=k;n=m}}else{l=k;n=ba;o=k}}else{l=h;n=ba;o=k}ba=n+(h<<4)|0;c[ba+0>>2]=c[ca+176>>2];c[ba+4>>2]=c[ca+180>>2];c[ba+8>>2]=c[ca+184>>2];c[ba+12>>2]=c[ca+188>>2];pc[c[(c[d>>2]|0)+108>>2]&127](d,j,ba);j=j+1|0;h=l+1|0;ba=n;k=o}a[ca+132>>0]=1;aa=ca+128|0;c[aa>>2]=0;c[ca+120>>2]=0;c[ca+124>>2]=0;a[ca+152>>0]=1;$=ca+148|0;c[$>>2]=0;c[ca+140>>2]=0;c[ca+144>>2]=0;a[ca+172>>0]=1;_=ca+168|0;c[_>>2]=0;c[ca+160>>2]=0;c[ca+164>>2]=0;if(f){if((h|0)>0){J=0;n=0;m=0;l=0;while(1){o=J;J=J+1|0;if((J|0)<(h|0)){F=ba+(o<<4)|0;j=ba+(o<<4)+4|0;k=ba+(o<<4)+8|0;u=J;o=m;do{m=u;u=u+1|0;if((u|0)<(h|0)){f=ba+(m<<4)|0;H=ba+(m<<4)+4|0;y=ba+(m<<4)+8|0;x=u;do{r=+g[F>>2];I=+g[f>>2]-r;q=+g[j>>2];t=+g[H>>2]-q;p=+g[k>>2];s=+g[y>>2]-p;r=+g[ba+(x<<4)>>2]-r;q=+g[ba+(x<<4)+4>>2]-q;p=+g[ba+(x<<4)+8>>2]-p;E=1.0;z=0;while(1){v=(t*p-s*q)*E;D=(s*r-I*p)*E;G=(I*q-t*r)*E;a:do if(G*G+(v*v+D*D)>9.999999747378752e-05){w=1.0/+P(+(G*G+(v*v+D*D)));if((n|0)>0){C=0;do{if(v*w*+g[l+(C<<4)>>2]+D*w*+g[l+(C<<4)+4>>2]+G*w*+g[l+(C<<4)+8>>2]>.9990000128746033)break a;C=C+1|0}while((C|0)<(n|0))}E=v*w*+g[F>>2]+D*w*+g[j>>2]+G*w*+g[k>>2];C=0;do{if(v*w*+g[ba+(C<<4)>>2]+D*w*+g[ba+(C<<4)+4>>2]+G*w*+g[ba+(C<<4)+8>>2]-E+-.009999999776482582>0.0)break a;C=C+1|0}while((C|0)<(h|0));do if((n|0)==(o|0)){B=(o|0)==0?1:o<<1;if((o|0)<(B|0)){do if(!B)A=0;else{c[5132]=(c[5132]|0)+1;C=ZE((B<<4|3)+16|0)|0;if(!C){A=0;break}c[(C+19&-16)+-4>>2]=C;A=C+19&-16}while(0);if((o|0)>0){C=0;do{X=A+(C<<4)|0;W=l+(C<<4)|0;c[X+0>>2]=c[W+0>>2];c[X+4>>2]=c[W+4>>2];c[X+8>>2]=c[W+8>>2];c[X+12>>2]=c[W+12>>2];C=C+1|0}while((C|0)!=(o|0))}if(!l){C=o;o=B;l=A;break}c[5134]=(c[5134]|0)+1;_E(c[l+-4>>2]|0);C=o;o=B;l=A}else C=o}else C=n;while(0);g[l+(C<<4)>>2]=v*w;g[l+(C<<4)+4>>2]=D*w;g[l+(C<<4)+8>>2]=G*w;g[l+(C<<4)+12>>2]=-E;n=n+1|0}while(0);z=z+1|0;if((z|0)==2)break;else E=-1.0}x=x+1|0}while((x|0)!=(h|0))}}while((u|0)!=(h|0))}else o=m;if((J|0)==(h|0))break;else m=o}if((n|0)>0){u=0;j=0;h=0;while(1){X=l+(u<<4)|0;c[ca+192>>2]=c[X+0>>2];c[ca+196>>2]=c[X+4>>2];c[ca+200>>2]=c[X+8>>2];t=+g[l+(u<<4)+12>>2];t=t-+Zb[c[(c[d>>2]|0)+48>>2]&15](d);if((u|0)==(j|0)){k=(j|0)==0?1:j<<1;if((j|0)<(k|0)){if((k|0)!=0?(c[5132]=(c[5132]|0)+1,K=ZE((k<<4|3)+16|0)|0,(K|0)!=0):0){c[(K+19&-16)+-4>>2]=K;m=K+19&-16}else m=0;if((j|0)>0){o=0;do{X=m+(o<<4)|0;W=h+(o<<4)|0;c[X+0>>2]=c[W+0>>2];c[X+4>>2]=c[W+4>>2];c[X+8>>2]=c[W+8>>2];c[X+12>>2]=c[W+12>>2];o=o+1|0}while((o|0)!=(j|0))}if(!h)o=j;else{c[5134]=(c[5134]|0)+1;_E(c[h+-4>>2]|0);o=j}}else{o=j;k=j;m=h}}else{o=u;k=j;m=h}X=m+(o<<4)|0;c[X+0>>2]=c[ca+192>>2];c[X+4>>2]=c[ca+196>>2];c[X+8>>2]=c[ca+200>>2];g[m+(o<<4)+12>>2]=t;u=u+1|0;if((u|0)<(n|0)){j=k;h=m}else break}if((u|0)>0){F=0;n=0;o=0;k=0;do{z=F;F=F+1|0;if((F|0)<(u|0)){H=F;do{B=H;H=H+1|0;if((H|0)<(u|0)){A=H;C=k;while(1){s=+g[m+(B<<4)+4>>2];w=+g[m+(A<<4)+8>>2];v=+g[m+(B<<4)+8>>2];r=+g[m+(A<<4)+4>>2];q=+g[m+(A<<4)>>2];p=+g[m+(B<<4)>>2];t=+g[m+(z<<4)+8>>2];D=+g[m+(z<<4)+4>>2];E=+g[m+(z<<4)>>2];b:do if((((r*p-s*q)*(r*p-s*q)+((s*w-v*r)*(s*w-v*r)+(v*q-w*p)*(v*q-w*p))>9.999999747378752e-05?(q*D-r*E)*(q*D-r*E)+((r*t-w*D)*(r*t-w*D)+(w*E-q*t)*(w*E-q*t))>9.999999747378752e-05:0)?(s*E-p*D)*(s*E-p*D)+((v*D-s*t)*(v*D-s*t)+(p*t-v*E)*(p*t-v*E))>9.999999747378752e-05:0)?(S=t*(r*p-s*q)+(D*(v*q-w*p)+(s*w-v*r)*E),+O(+S)>9.999999974752427e-07):0){da=+g[m+(z<<4)+12>>2];I=+g[m+(B<<4)+12>>2];ea=+g[m+(A<<4)+12>>2];G=-1.0/S*((v*D-s*t)*ea+((s*w-v*r)*da+(r*t-w*D)*I));w=-1.0/S*((p*t-v*E)*ea+((v*q-w*p)*da+(w*E-q*t)*I));E=-1.0/S*((s*E-p*D)*ea+((r*p-s*q)*da+(q*D-r*E)*I));k=0;do{if(+g[m+(k<<4)+12>>2]+(G*+g[m+(k<<4)>>2]+w*+g[m+(k<<4)+4>>2]+E*+g[m+(k<<4)+8>>2])+-.009999999776482582>0.0){k=C;break b}k=k+1|0}while((k|0)<(u|0));do if((n|0)==(C|0)){k=(C|0)==0?1:C<<1;if((C|0)>=(k|0)){y=C;k=C;break}do if(!k)x=0;else{c[5132]=(c[5132]|0)+1;j=ZE((k<<4|3)+16|0)|0;if(!j){x=0;break}c[(j+19&-16)+-4>>2]=j;x=j+19&-16}while(0);if((C|0)>0){f=0;do{X=x+(f<<4)|0;W=o+(f<<4)|0;c[X+0>>2]=c[W+0>>2];c[X+4>>2]=c[W+4>>2];c[X+8>>2]=c[W+8>>2];c[X+12>>2]=c[W+12>>2];f=f+1|0}while((f|0)!=(C|0))}if(!o){y=C;o=x;break}c[5134]=(c[5134]|0)+1;_E(c[o+-4>>2]|0);y=C;o=x}else{y=n;k=C}while(0);g[o+(y<<4)>>2]=G;g[o+(y<<4)+4>>2]=w;g[o+(y<<4)+8>>2]=E;g[o+(y<<4)+12>>2]=0.0;n=n+1|0}else k=C;while(0);A=A+1|0;if((A|0)==(u|0))break;else C=k}}}while((H|0)!=(u|0))}}while((F|0)!=(u|0))}else{n=0;o=0}}else{m=0;n=0;o=0}}else{l=0;m=0;n=0;o=0}qE(ca+116|0,o,n);if(o){c[5134]=(c[5134]|0)+1;_E(c[o+-4>>2]|0)}if(m){c[5134]=(c[5134]|0)+1;_E(c[m+-4>>2]|0)}if(l){c[5134]=(c[5134]|0)+1;_E(c[l+-4>>2]|0)}}else qE(ca+116|0,ba,h);J=c[ca+160>>2]|0;if((J|0)>0&((J|0)<0^1)){c[5132]=(c[5132]|0)+1;h=ZE((J<<4|3)+16|0)|0;if(!h)n=0;else{c[(h+19&-16)+-4>>2]=h;n=h+19&-16}o=0;do{X=n+(o<<4)|0;c[X+0>>2]=c[ca+208>>2];c[X+4>>2]=c[ca+212>>2];c[X+8>>2]=c[ca+216>>2];c[X+12>>2]=c[ca+220>>2];o=o+1|0}while((o|0)!=(J|0));X=n}else X=0;a[ca+72>>0]=1;V=ca+68|0;c[V>>2]=0;W=ca+60|0;c[W>>2]=0;c[ca+64>>2]=0;z=ca+291|0;B=z+19|0;do{a[z>>0]=0;z=z+1|0}while((z|0)<(B|0));if((J|0)<0)Eb();if((J|0)>0){Ay(ca+56|0,J);n=c[V>>2]|0;m=0;do{o=n+(m*36|0)|0;if(o){a[o+16>>0]=1;c[o+4>>2]=0;c[o+8>>2]=0;c[o+12>>2]=0;z=o+20|0;C=ca+294|0;B=z+16|0;do{a[z>>0]=a[C>>0]|0;z=z+1|0;C=C+1|0}while((z|0)<(B|0))}m=m+1|0}while((m|0)!=(J|0))}c[W>>2]=J;u=c[ca+120>>2]|0;k=c[d+52>>2]|0;l=c[k+8>>2]|0;if((l|0)<(u|0)){if((c[k+12>>2]|0)<(u|0)){if(!u){o=0;n=l}else{c[5132]=(c[5132]|0)+1;o=ZE((u<<4|3)+16|0)|0;if(!o)o=0;else{c[(o+19&-16)+-4>>2]=o;o=o+19&-16}n=c[k+8>>2]|0}if((n|0)>0){m=0;do{U=o+(m<<4)|0;Q=(c[k+16>>2]|0)+(m<<4)|0;c[U+0>>2]=c[Q+0>>2];c[U+4>>2]=c[Q+4>>2];c[U+8>>2]=c[Q+8>>2];c[U+12>>2]=c[Q+12>>2];m=m+1|0}while((m|0)!=(n|0))}n=c[k+16>>2]|0;if(n){if(a[k+20>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[n+-4>>2]|0)}c[k+16>>2]=0}a[k+20>>0]=1;c[k+16>>2]=o;c[k+12>>2]=u;n=k+16|0}else n=k+16|0;o=l;do{U=(c[n>>2]|0)+(o<<4)|0;c[U+0>>2]=c[ca+80>>2];c[U+4>>2]=c[ca+84>>2];c[U+8>>2]=c[ca+88>>2];c[U+12>>2]=c[ca+92>>2];o=o+1|0}while((o|0)!=(u|0))}c[k+8>>2]=u;if((u|0)>0){o=0;do{U=(c[(c[d+52>>2]|0)+16>>2]|0)+(o<<4)|0;Q=(c[aa>>2]|0)+(o<<4)|0;c[U+0>>2]=c[Q+0>>2];c[U+4>>2]=c[Q+4>>2];c[U+8>>2]=c[Q+8>>2];c[U+12>>2]=c[Q+12>>2];o=o+1|0}while((o|0)!=(u|0))}if((J|0)>0){H=0;do{l=(c[$>>2]|0)+((c[(c[_>>2]|0)+(H<<2)>>2]|0)*12|0)|0;u=l;n=0;do{k=u+4|0;z=c[u+((c[k>>2]|0)*12|0)+8>>2]|0;B=c[V>>2]|0;A=B+(H*36|0)+4|0;o=c[A>>2]|0;C=B+(H*36|0)+8|0;if((o|0)==(c[C>>2]|0)?(T=(o|0)==0?1:o<<1,(o|0)<(T|0)):0){if(!T)x=0;else{c[5132]=(c[5132]|0)+1;o=ZE((T<<2|3)+16|0)|0;if(!o)o=0;else{c[(o+19&-16)+-4>>2]=o;o=o+19&-16}x=o;o=c[A>>2]|0}y=B+(H*36|0)+12|0;if((o|0)>0){m=0;do{f=x+(m<<2)|0;if(f)c[f>>2]=c[(c[y>>2]|0)+(m<<2)>>2];m=m+1|0}while((m|0)!=(o|0))}m=c[y>>2]|0;o=B+(H*36|0)+16|0;if(m){if(a[o>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[m+-4>>2]|0)}c[y>>2]=0}a[o>>0]=1;c[y>>2]=x;c[C>>2]=T;o=c[A>>2]|0}m=(c[B+(H*36|0)+12>>2]|0)+(o<<2)|0;if(m){c[m>>2]=z;o=c[A>>2]|0}c[A>>2]=o+1;Q=c[u+8>>2]|0;U=c[aa>>2]|0;r=+g[U+(Q<<4)>>2]-+g[U+(z<<4)>>2];q=+g[U+(Q<<4)+4>>2]-+g[U+(z<<4)+4>>2];t=+g[U+(Q<<4)+8>>2]-+g[U+(z<<4)+8>>2];s=1.0/+P(+(r*r+q*q+t*t));if((n|0)<2){g[ca+224+(n<<4)>>2]=r*s;g[ca+224+(n<<4)+4>>2]=q*s;g[ca+224+(n<<4)+8>>2]=t*s;g[ca+224+(n<<4)+12>>2]=0.0;n=n+1|0}U=c[k>>2]|0;u=u+(((c[u+(U*12|0)>>2]|0)+U|0)*12|0)|0}while((u|0)!=(l|0));o=X+(H<<4)|0;if((n|0)==2){G=+g[ca+228>>2];E=+g[ca+248>>2];I=+g[ca+232>>2];ea=+g[ca+244>>2];w=+g[ca+240>>2];S=+g[ca+224>>2];Q=X+(H<<4)+4|0;U=X+(H<<4)+8|0;g[X+(H<<4)+12>>2]=0.0;da=1.0/+P(+((G*E-I*ea)*(G*E-I*ea)+(I*w-E*S)*(I*w-E*S)+(ea*S-G*w)*(ea*S-G*w)));g[o>>2]=(G*E-I*ea)*da;g[Q>>2]=(I*w-E*S)*da;g[U>>2]=(ea*S-G*w)*da;k=c[V>>2]|0;g[k+(H*36|0)+20>>2]=(G*E-I*ea)*da;g[k+(H*36|0)+24>>2]=+g[Q>>2];g[k+(H*36|0)+28>>2]=+g[U>>2];g[k+(H*36|0)+32>>2]=1000000015047466219876688.0e6}else{c[o+0>>2]=0;c[o+4>>2]=0;c[o+8>>2]=0;c[o+12>>2]=0;k=c[V>>2]|0}m=c[k+(H*36|0)+4>>2]|0;if((m|0)>0){l=c[(c[d+52>>2]|0)+16>>2]|0;w=+g[o>>2];v=+g[X+(H<<4)+4>>2];t=+g[X+(H<<4)+8>>2];o=c[k+(H*36|0)+12>>2]|0;p=1000000015047466219876688.0e6;n=0;do{U=c[o+(n<<2)>>2]|0;da=+g[l+(U<<4)>>2]*w+ +g[l+(U<<4)+4>>2]*v+ +g[l+(U<<4)+8>>2]*t;p=p>da?da:p;n=n+1|0}while((n|0)!=(m|0))}else p=1000000015047466219876688.0e6;g[k+(H*36|0)+32>>2]=-p;H=H+1|0}while((H|0)!=(J|0))}if((c[W>>2]|0)>0){o=0;k=0;u=0;while(1){if((u|0)==(o|0)){o=(u|0)==0?1:u<<1;if((u|0)<(o|0)){if((o|0)!=0?(c[5132]=(c[5132]|0)+1,R=ZE((o<<2|3)+16|0)|0,(R|0)!=0):0){c[(R+19&-16)+-4>>2]=R;l=R+19&-16}else l=0;if((u|0)>0){m=0;do{n=l+(m<<2)|0;if(n)c[n>>2]=c[k+(m<<2)>>2];m=m+1|0}while((m|0)!=(u|0))}if(k){c[5134]=(c[5134]|0)+1;_E(c[k+-4>>2]|0)}}else{o=u;l=k}}else l=k;n=l+(u<<2)|0;if(n)c[n>>2]=u;u=u+1|0;if((u|0)>=(c[W>>2]|0))break;else k=l}if(u){U=ca+112|0;R=ca+108|0;Q=ca+100|0;o=u;while(1){k=o+-1|0;m=c[l+(k<<2)>>2]|0;c[5132]=(c[5132]|0)+1;o=ZE(23)|0;if(o){c[(o+19&-16)+-4>>2]=o;n=o+19&-16;if(o+19&-16)c[n>>2]=m}else n=0;o=c[V>>2]|0;E=+g[o+(m*36|0)+20>>2];G=+g[o+(m*36|0)+24>>2];I=+g[o+(m*36|0)+28>>2];o=k;u=1;x=1;c:while(1){if((o|0)>0)C=n;else{Y=192;break}d:while(1){m=c[V>>2]|0;do{T=k;k=k+-1|0;if((T|0)<=0){n=C;T=x;break c}B=c[l+(k<<2)>>2]|0}while(!(E*+g[m+(B*36|0)+20>>2]+G*+g[m+(B*36|0)+24>>2]+I*+g[m+(B*36|0)+28>>2]>.9990000128746033));do if((x|0)==(u|0)?(M=(u|0)==0?1:u<<1,(u|0)<(M|0)):0){do if(!M)n=0;else{c[5132]=(c[5132]|0)+1;n=ZE((M<<2|3)+16|0)|0;if(!n){n=0;break}c[(n+19&-16)+-4>>2]=n;n=n+19&-16}while(0);if((u|0)>0){j=0;do{m=n+(j<<2)|0;if(m)c[m>>2]=c[C+(j<<2)>>2];j=j+1|0}while((j|0)!=(u|0))}if(!C){u=M;break}c[5134]=(c[5134]|0)+1;_E(c[C+-4>>2]|0);u=M}else n=C;while(0);m=n+(x<<2)|0;if(m)c[m>>2]=B;x=x+1|0;h=0;while(1){m=l+(h<<2)|0;j=h+1|0;if((c[m>>2]|0)==(B|0))break;if((j|0)<(o|0))h=j;else{C=n;continue d}}if((h|0)<(o|0))break;else C=n}T=o+-1|0;L=l+(T<<2)|0;c[m>>2]=c[L>>2];c[L>>2]=B;o=T}e:do if((Y|0)==192)while(1){Y=0;m=c[V>>2]|0;do{T=k;k=k+-1|0;if((T|0)<=0){T=x;break e}A=c[l+(k<<2)>>2]|0}while(!(E*+g[m+(A*36|0)+20>>2]+G*+g[m+(A*36|0)+24>>2]+I*+g[m+(A*36|0)+28>>2]>.9990000128746033));do if((x|0)==(u|0)?(N=(u|0)==0?1:u<<1,(u|0)<(N|0)):0){do if(!N)h=0;else{c[5132]=(c[5132]|0)+1;m=ZE((N<<2|3)+16|0)|0;if(!m){h=0;break}c[(m+19&-16)+-4>>2]=m;h=m+19&-16}while(0);if((u|0)>0){j=0;do{m=h+(j<<2)|0;if(m)c[m>>2]=c[n+(j<<2)>>2];j=j+1|0}while((j|0)!=(u|0))}if(!n){u=N;n=h;break}c[5134]=(c[5134]|0)+1;_E(c[n+-4>>2]|0);u=N;n=h}while(0);m=n+(x<<2)|0;if(m)c[m>>2]=A;x=x+1|0;Y=192}while(0);if((T|0)>1){a[U>>0]=1;c[R>>2]=0;c[Q>>2]=0;c[ca+104>>2]=0;f=0;E=0.0;G=0.0;w=0.0;F=0;do{k=c[n+(F<<2)>>2]|0;E=+g[m+(k*36|0)+20>>2]+E;G=+g[m+(k*36|0)+24>>2]+G;w=+g[m+(k*36|0)+28>>2]+w;u=m+(k*36|0)+4|0;if((c[u>>2]|0)>0){k=m+(k*36|0)+12|0;m=f;A=0;while(1){B=c[(c[k>>2]|0)+(A<<2)>>2]|0;L=(c[(c[d+52>>2]|0)+16>>2]|0)+(B<<4)|0;c[ca+24>>2]=c[L+0>>2];c[ca+28>>2]=c[L+4>>2];c[ca+32>>2]=c[L+8>>2];c[ca+36>>2]=c[L+12>>2];f:do if((m|0)>0){x=c[R>>2]|0;f=0;while(1){if((c[x+(f*24|0)+20>>2]|0)==(B|0))break f;f=f+1|0;if((f|0)>=(m|0)){Y=218;break}}}else Y=218;while(0);if((Y|0)==218){Y=0;c[ca+0>>2]=c[ca+24>>2];c[ca+4>>2]=c[ca+28>>2];c[ca+8>>2]=c[ca+32>>2];c[ca+12>>2]=c[ca+36>>2];do if((m|0)==(c[ca+104>>2]|0)){C=(m|0)==0?1:m<<1;if((m|0)>=(C|0))break;if(!C)f=0;else{c[5132]=(c[5132]|0)+1;f=ZE((C*24|3)+16|0)|0;if(!f)f=0;else{c[(f+19&-16)+-4>>2]=f;f=f+19&-16}m=c[Q>>2]|0}y=c[R>>2]|0;if((m|0)>0){z=0;do{L=f+(z*24|0)|0;K=y+(z*24|0)|0;c[L+0>>2]=c[K+0>>2];c[L+4>>2]=c[K+4>>2];c[L+8>>2]=c[K+8>>2];c[L+12>>2]=c[K+12>>2];c[L+16>>2]=c[K+16>>2];c[L+20>>2]=c[K+20>>2];z=z+1|0}while((z|0)!=(m|0))}if(y){if(a[U>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[y+-4>>2]|0);m=c[Q>>2]|0}c[R>>2]=0}a[U>>0]=1;c[R>>2]=f;c[ca+104>>2]=C}while(0);L=c[R>>2]|0;C=L+(m*24|0)|0;c[C+0>>2]=c[ca+0>>2];c[C+4>>2]=c[ca+4>>2];c[C+8>>2]=c[ca+8>>2];c[C+12>>2]=c[ca+12>>2];c[C+16>>2]=c[ca+16>>2];c[L+(m*24|0)+20>>2]=B;m=(c[Q>>2]|0)+1|0;c[Q>>2]=m}A=A+1|0;if((A|0)>=(c[u>>2]|0)){f=m;break}}}F=F+1|0;m=c[V>>2]|0}while((F|0)!=(T|0));z=ca+275|0;C=m+((c[n>>2]|0)*9<<2)+20|0;B=z+16|0;do{a[z>>0]=a[C>>0]|0;z=z+1|0;C=C+1|0}while((z|0)<(B|0));I=1.0/+P(+(E*E+G*G+w*w));D=E*I;E=G*I;I=w*I;if(+O(+I)>.7071067690849304){s=1.0/+P(+(I*I+E*E));v=0.0;t=-(I*s);s=E*s}else{t=1.0/+P(+(D*D+E*E));v=-(E*t);t=D*t;s=0.0}do if((f|0)<2)if((f|0)>0){m=f;k=0;j=0;y=0;while(1){z=c[R>>2]|0;do if((k|0)==(j|0)){x=(j|0)==0?1:j<<1;if((j|0)>=(x|0)){h=j;u=y;break}do if(!x){f=0;m=j}else{c[5132]=(c[5132]|0)+1;m=ZE((x*24|3)+16|0)|0;if(!m){f=0;m=k;break}c[(m+19&-16)+-4>>2]=m;f=m+19&-16;m=k}while(0);if((m|0)>0){u=0;do{Y=f+(u*24|0)|0;L=y+(u*24|0)|0;c[Y+0>>2]=c[L+0>>2];c[Y+4>>2]=c[L+4>>2];c[Y+8>>2]=c[L+8>>2];c[Y+12>>2]=c[L+12>>2];c[Y+16>>2]=c[L+16>>2];c[Y+20>>2]=c[L+20>>2];u=u+1|0}while((u|0)!=(m|0))}if(y){c[5134]=(c[5134]|0)+1;_E(c[y+-4>>2]|0)}h=k;m=c[Q>>2]|0;j=x;u=f}else{h=k;u=y}while(0);Y=u+(h*24|0)|0;c[Y+0>>2]=c[z+0>>2];c[Y+4>>2]=c[z+4>>2];c[Y+8>>2]=c[z+8>>2];c[Y+12>>2]=c[z+12>>2];c[Y+16>>2]=c[z+16>>2];c[Y+20>>2]=c[z+20>>2];k=k+1|0;if((k|0)<(m|0))y=u;else{Y=282;break}}}else{m=f;F=0;x=0;u=0}else{y=c[R>>2]|0;m=f;k=0;do{if(v*+g[y+(k*24|0)>>2]+t*+g[y+(k*24|0)+4>>2]+s*+g[y+(k*24|0)+8>>2]<v*+g[y>>2]+t*+g[y+4>>2]+s*+g[y+8>>2]){c[ca+224>>2]=c[y+0>>2];c[ca+228>>2]=c[y+4>>2];c[ca+232>>2]=c[y+8>>2];c[ca+236>>2]=c[y+12>>2];c[ca+240>>2]=c[y+16>>2];c[ca+244>>2]=c[y+20>>2];m=y+(k*24|0)|0;c[y+0>>2]=c[m+0>>2];c[y+4>>2]=c[m+4>>2];c[y+8>>2]=c[m+8>>2];c[y+12>>2]=c[m+12>>2];c[y+16>>2]=c[m+16>>2];c[y+20>>2]=c[m+20>>2];m=y+(k*24|0)|0;c[m+0>>2]=c[ca+224>>2];c[m+4>>2]=c[ca+228>>2];c[m+8>>2]=c[ca+232>>2];c[m+12>>2]=c[ca+236>>2];c[m+16>>2]=c[ca+240>>2];c[m+20>>2]=c[ca+244>>2];m=f}k=k+1|0}while((k|0)<(m|0));g[y+16>>2]=-1000000015047466219876688.0e6;if((m|0)>1){w=+g[y+4>>2];f=1;do{G=+g[y+(f*24|0)>>2]-+g[y>>2];ea=+g[y+(f*24|0)+4>>2]-w;da=+g[y+(f*24|0)+8>>2]-+g[y+8>>2];g[y+(f*24|0)+16>>2]=((v*ea-t*G)*I+(D*(t*da-s*ea)+E*(s*G-v*da)))/+P(+(G*G+ea*ea+da*da));f=f+1|0}while((f|0)!=(m|0))};c[ca+40>>2]=c[y+0>>2];c[ca+44>>2]=c[y+4>>2];c[ca+48>>2]=c[y+8>>2];c[ca+52>>2]=c[y+12>>2];By(ca+96|0,ca+40|0,1,m+-1|0);k=c[R>>2]|0;c[5132]=(c[5132]|0)+1;m=ZE(43)|0;if(!m)h=0;else{c[(m+19&-16)+-4>>2]=m;h=m+19&-16}j=c[R>>2]|0;c[h+0>>2]=c[k+0>>2];c[h+4>>2]=c[k+4>>2];c[h+8>>2]=c[k+8>>2];c[h+12>>2]=c[k+12>>2];c[h+16>>2]=c[k+16>>2];c[h+20>>2]=c[k+20>>2];c[5132]=(c[5132]|0)+1;m=ZE(67)|0;if(!m)u=0;else{c[(m+19&-16)+-4>>2]=m;u=m+19&-16}m=0;while(1){Y=u+(m*24|0)|0;L=h+(m*24|0)|0;c[Y+0>>2]=c[L+0>>2];c[Y+4>>2]=c[L+4>>2];c[Y+8>>2]=c[L+8>>2];c[Y+12>>2]=c[L+12>>2];c[Y+16>>2]=c[L+16>>2];c[Y+20>>2]=c[L+20>>2];if(!m)break;else m=m+1|0}if(h){c[5134]=(c[5134]|0)+1;_E(c[h+-4>>2]|0)}m=u+24|0;c[m+0>>2]=c[j+24>>2];c[m+4>>2]=c[j+28>>2];c[m+8>>2]=c[j+32>>2];c[m+12>>2]=c[j+36>>2];c[m+16>>2]=c[j+40>>2];c[m+20>>2]=c[j+44>>2];m=c[Q>>2]|0;if((m|0)==2){k=2;Y=283;break}else{y=2;k=2;f=2;A=2}while(1){g:do if((y|0)>1){Y=c[R>>2]|0;B=Y+(A*24|0)|0;w=+g[B>>2];v=+g[Y+(A*24|0)+4>>2];t=+g[Y+(A*24|0)+8>>2];while(1){Y=y+-2|0;C=y+-1|0;G=+g[u+(Y*24|0)>>2];ea=G-+g[u+(C*24|0)>>2];s=+g[u+(Y*24|0)+4>>2];r=s-+g[u+(C*24|0)+4>>2];da=+g[u+(Y*24|0)+8>>2];S=da-+g[u+(C*24|0)+8>>2];if((ea*(s-v)-r*(G-w))*I+(D*(r*(da-t)-S*(s-v))+E*(S*(G-w)-ea*(da-t)))>0.0)break;if((C|0)>1){y=C;k=C}else{y=C;k=C;break g}}do if((y|0)==(f|0)){C=(f|0)==0?1:f<<1;if((f|0)>=(C|0)){y=f;break}do if(!C)z=0;else{c[5132]=(c[5132]|0)+1;m=ZE((C*24|3)+16|0)|0;if(!m){z=0;f=k;break}c[(m+19&-16)+-4>>2]=m;z=m+19&-16;f=k}while(0);if((f|0)>0){m=0;do{Y=z+(m*24|0)|0;L=u+(m*24|0)|0;c[Y+0>>2]=c[L+0>>2];c[Y+4>>2]=c[L+4>>2];c[Y+8>>2]=c[L+8>>2];c[Y+12>>2]=c[L+12>>2];c[Y+16>>2]=c[L+16>>2];c[Y+20>>2]=c[L+20>>2];m=m+1|0}while((m|0)!=(f|0))}if(u){c[5134]=(c[5134]|0)+1;_E(c[u+-4>>2]|0)}m=c[Q>>2]|0;y=k;f=C;u=z}while(0);y=u+(y*24|0)|0;c[y+0>>2]=c[B+0>>2];c[y+4>>2]=c[B+4>>2];c[y+8>>2]=c[B+8>>2];c[y+12>>2]=c[B+12>>2];c[y+16>>2]=c[B+16>>2];c[y+20>>2]=c[B+20>>2];k=k+1|0;y=k}while(0);A=A+1|0;if((A|0)==(m|0)){Y=282;break}}}while(0);if((Y|0)==282){Y=0;if((k|0)>0)Y=283;else{F=0;x=0}}if((Y|0)==283){Y=0;C=0;y=0;m=0;F=0;while(1){A=u+(F*24|0)+20|0;do if((m|0)==(C|0)){z=(C|0)==0?1:C<<1;if((C|0)>=(z|0)){x=y;f=C;z=C;break}do if(!z)x=0;else{c[5132]=(c[5132]|0)+1;j=ZE((z<<2|3)+16|0)|0;if(!j){x=0;break}c[(j+19&-16)+-4>>2]=j;x=j+19&-16}while(0);if((C|0)>0){j=0;do{f=x+(j<<2)|0;if(f)c[f>>2]=c[y+(j<<2)>>2];j=j+1|0}while((j|0)!=(C|0))}if(!y){f=C;break}c[5134]=(c[5134]|0)+1;_E(c[y+-4>>2]|0);f=C}else{x=y;f=m;z=C}while(0);j=x+(f<<2)|0;if(!j)m=f;else c[j>>2]=c[A>>2];B=m+1|0;m=c[Q>>2]|0;h:do if((m|0)>0){y=c[R>>2]|0;f=c[A>>2]|0;h=0;while(1){j=y+(h*24|0)+20|0;h=h+1|0;if((c[j>>2]|0)==(f|0))break;if((h|0)>=(m|0))break h}c[j>>2]=-1}while(0);F=F+1|0;if((F|0)==(k|0)){F=B;break}else{C=z;y=x;m=B}}}i:do if((m|0)>0){k=c[R>>2]|0;j=c[W>>2]|0;h=c[V>>2]|0;B=0;while(1){A=c[k+(B*24|0)+20>>2]|0;if(!((A|0)==-1|(j|0)<1)){C=0;do{f=0;while(1){if((c[n+(f<<2)>>2]|0)==(C|0))break;f=f+1|0;if((f|0)>=(T|0)){Y=308;break}}do if((Y|0)==308){Y=0;y=c[h+(C*36|0)+4>>2]|0;if((y|0)<=0)break;f=c[h+(C*36|0)+12>>2]|0;z=0;do{if((c[f+(z<<2)>>2]|0)==(A|0)){k=1;break i}z=z+1|0}while((z|0)<(y|0))}while(0);C=C+1|0}while((C|0)<(j|0))}B=B+1|0;if((B|0)>=(m|0)){Y=315;break}}}else Y=315;while(0);if((Y|0)==315){Y=0;A=c[d+52>>2]|0;m=c[A+28>>2]|0;if((m|0)==(c[A+32>>2]|0)){Ay(A+24|0,(m|0)==0?1:m<<1);m=c[A+28>>2]|0}B=(c[A+36>>2]|0)+(m*36|0)|0;if(B){a[B+16>>0]=1;c[B+12>>2]=0;c[B+4>>2]=0;c[B+8>>2]=0;if((F|0)>0){c[5132]=(c[5132]|0)+1;m=ZE((F<<2|3)+16|0)|0;if(!m)C=0;else{c[(m+19&-16)+-4>>2]=m;C=m+19&-16}m=c[B+4>>2]|0;if((m|0)>0){j=0;do{k=C+(j<<2)|0;if(k)c[k>>2]=c[(c[B+12>>2]|0)+(j<<2)>>2];j=j+1|0}while((j|0)!=(m|0))}m=c[B+12>>2]|0;if(m){if(a[B+16>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[m+-4>>2]|0)}c[B+12>>2]=0}a[B+16>>0]=1;c[B+12>>2]=C;c[B+8>>2]=F;k=0;do{m=C+(k<<2)|0;if(m)c[m>>2]=0;k=k+1|0}while((k|0)!=(F|0));c[B+4>>2]=F;k=0;do{m=C+(k<<2)|0;if(m)c[m>>2]=c[x+(k<<2)>>2];k=k+1|0}while((k|0)!=(F|0))}else c[B+4>>2]=F;z=B+20|0;C=ca+275|0;B=z+16|0;do{a[z>>0]=a[C>>0]|0;z=z+1|0;C=C+1|0}while((z|0)<(B|0));m=c[A+28>>2]|0}c[A+28>>2]=m+1;k=0}if(u){c[5134]=(c[5134]|0)+1;_E(c[u+-4>>2]|0)}if(x){c[5134]=(c[5134]|0)+1;_E(c[x+-4>>2]|0)}m=c[R>>2]|0;if(m){if(a[U>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[m+-4>>2]|0)}c[R>>2]=0}a[U>>0]=1;c[R>>2]=0;c[Q>>2]=0;c[ca+104>>2]=0;if(k&(T|0)>0){j=0;Y=350}}else if((T|0)>0){j=0;Y=350}if((Y|0)==350)while(1){Y=0;y=c[n+(j<<2)>>2]|0;x=c[V>>2]|0;F=c[x+(y*36|0)+4>>2]|0;if((F|0)>0){c[5132]=(c[5132]|0)+1;m=ZE((F<<2|3)+16|0)|0;if(!m)f=0;else{c[(m+19&-16)+-4>>2]=m;f=m+19&-16}k=0;do{m=f+(k<<2)|0;if(m)c[m>>2]=0;k=k+1|0}while((k|0)!=(F|0));m=c[x+(y*36|0)+12>>2]|0;u=0;do{k=f+(u<<2)|0;if(k)c[k>>2]=c[m+(u<<2)>>2];u=u+1|0}while((u|0)!=(F|0))}else f=0;z=ca+227|0;C=x+(y*36|0)+20|0;B=z+16|0;do{a[z>>0]=a[C>>0]|0;z=z+1|0;C=C+1|0}while((z|0)<(B|0));A=c[d+52>>2]|0;m=c[A+28>>2]|0;if((m|0)==(c[A+32>>2]|0)){Ay(A+24|0,(m|0)==0?1:m<<1);m=c[A+28>>2]|0}B=(c[A+36>>2]|0)+(m*36|0)|0;if(B){a[B+16>>0]=1;c[B+12>>2]=0;c[B+4>>2]=0;c[B+8>>2]=0;if((F|0)>0){c[5132]=(c[5132]|0)+1;m=ZE((F<<2|3)+16|0)|0;if(!m)C=0;else{c[(m+19&-16)+-4>>2]=m;C=m+19&-16}m=c[B+4>>2]|0;if((m|0)>0){u=0;do{k=C+(u<<2)|0;if(k)c[k>>2]=c[(c[B+12>>2]|0)+(u<<2)>>2];u=u+1|0}while((u|0)!=(m|0))}m=c[B+12>>2]|0;if(m){if(a[B+16>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[m+-4>>2]|0)}c[B+12>>2]=0}a[B+16>>0]=1;c[B+12>>2]=C;c[B+8>>2]=F;k=0;do{m=C+(k<<2)|0;if(m)c[m>>2]=0;k=k+1|0}while((k|0)!=(F|0));c[B+4>>2]=F;k=0;do{m=C+(k<<2)|0;if(m)c[m>>2]=c[f+(k<<2)>>2];k=k+1|0}while((k|0)!=(F|0))}else c[B+4>>2]=F;z=B+20|0;C=ca+227|0;B=z+16|0;do{a[z>>0]=a[C>>0]|0;z=z+1|0;C=C+1|0}while((z|0)<(B|0));m=c[A+28>>2]|0}c[A+28>>2]=m+1;if(f){c[5134]=(c[5134]|0)+1;_E(c[f+-4>>2]|0)}j=j+1|0;if((j|0)>=(T|0))break;else Y=350}if(n){c[5134]=(c[5134]|0)+1;_E(c[n+-4>>2]|0)}if(!o)break}}}else l=0;U=c[d+52>>2]|0;c[U+64>>2]=0;c[U+68>>2]=0;c[U+72>>2]=0;c[U+76>>2]=0;h=c[U+28>>2]|0;if((h|0)>0){f=0;k=0;u=0;z=0;B=0;C=0;m=0;n=0;x=0;A=0;j=0;y=0;T=0;while(1){o=c[U+36>>2]|0;R=c[o+(T*36|0)+4>>2]|0;if((R|0)>0){N=T&65535;Q=T|-65536;d=C;h=n;J=x;F=A;H=j;n=y;x=0;while(1){M=x+1|0;j=c[o+(T*36|0)+12>>2]|0;y=c[j+(x<<2)>>2]&65535;j=c[j+(((M|0)==(R|0)?0:M)<<2)>>2]&65535;K=y<<16>>16<j<<16>>16?y:j;L=y<<16>>16<j<<16>>16?j:y;A=y<<16>>16<j<<16>>16?y:j;y=y<<16>>16<j<<16>>16?j:y;j=h+-1|0;j:do if((((A&65535)<<16)+(y<<16>>16)&j)>>>0<u>>>0?(Z=c[k+((((A&65535)<<16)+(y<<16>>16)&j)<<2)>>2]|0,(Z|0)!=-1):0){C=Z;while(1){if(y<<16>>16==(b[f+(C<<2)>>1]|0)?A<<16>>16==(b[f+(C<<2)+2>>1]|0):0)break;C=c[d+(C<<2)>>2]|0;if((C|0)==-1){x=0;break j}}if((C|0)!=-1)x=J+(C<<2)|0;else x=0}else x=0;while(0);C=c[U+16>>2]|0;D=+g[C+(A<<16>>16<<4)>>2]-+g[C+(y<<16>>16<<4)>>2];t=+g[C+(A<<16>>16<<4)+4>>2]-+g[C+(y<<16>>16<<4)+4>>2];G=+g[C+(A<<16>>16<<4)+8>>2]-+g[C+(y<<16>>16<<4)+8>>2];v=1.0/+P(+(D*D+t*t+G*G));C=c[U+48>>2]|0;k:do if((C|0)>0){A=c[U+56>>2]|0;y=0;while(1){E=+g[A+(y<<4)>>2];w=+g[A+(y<<4)+8>>2];do if(!(+O(+(E-D*v))>1.0e-06)){if(+O(+(+g[A+(y<<4)+4>>2]-t*v))>1.0e-06)break;if(!(+O(+(w-G*v))>1.0e-06))break k}while(0);do if(!(+O(+(D*v+E))>1.0e-06)){if(+O(+(t*v+ +g[A+(y<<4)+4>>2]))>1.0e-06)break;if(!(+O(+(G*v+w))>1.0e-06))break k}while(0);y=y+1|0;if((y|0)>=(C|0)){Y=413;break}}}else Y=413;while(0);if((Y|0)==413){Y=0;do if((C|0)==(c[U+52>>2]|0)){o=(C|0)==0?1:C<<1;if((C|0)>=(o|0))break;if(!o)y=0;else{c[5132]=(c[5132]|0)+1;C=ZE((o<<4|3)+16|0)|0;if(!C)C=0;else{c[(C+19&-16)+-4>>2]=C;C=C+19&-16}y=C;C=c[U+48>>2]|0}if((C|0)>0){A=0;do{fa=y+(A<<4)|0;ga=(c[U+56>>2]|0)+(A<<4)|0;c[fa+0>>2]=c[ga+0>>2];c[fa+4>>2]=c[ga+4>>2];c[fa+8>>2]=c[ga+8>>2];c[fa+12>>2]=c[ga+12>>2];A=A+1|0}while((A|0)!=(C|0))}C=c[U+56>>2]|0;if(C){if(a[U+60>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[C+-4>>2]|0)}c[U+56>>2]=0}a[U+60>>0]=1;c[U+56>>2]=y;c[U+52>>2]=o;C=c[U+48>>2]|0}while(0);A=c[U+56>>2]|0;g[A+(C<<4)>>2]=D*v;g[A+(C<<4)+4>>2]=t*v;g[A+(C<<4)+8>>2]=G*v;g[A+(C<<4)+12>>2]=0.0;c[U+48>>2]=(c[U+48>>2]|0)+1}l:do if(!x){o=((K&65535)<<16)+(L<<16>>16)&j;m:do if(o>>>0<u>>>0){y=c[k+(o<<2)>>2]|0;if((y|0)==-1)break;while(1){if(L<<16>>16==(b[f+(y<<2)>>1]|0)?K<<16>>16==(b[f+(y<<2)+2>>1]|0):0)break;y=c[d+(y<<2)>>2]|0;if((y|0)==-1)break m}if((y|0)==-1)break;C=J+(y<<2)|0;b[C>>1]=Q;b[C+2>>1]=Q>>>16;C=d;j=h;x=J;A=F;y=n;break l}while(0);do if((m|0)==(h|0)){y=(m|0)==0?1:m<<1;if((m|0)>=(y|0)){j=m;x=J;break}do if(!y)x=0;else{c[5132]=(c[5132]|0)+1;A=ZE((y<<2|3)+16|0)|0;if(!A){x=0;break}c[(A+19&-16)+-4>>2]=A;x=A+19&-16}while(0);if((m|0)>0){A=0;do{C=x+(A<<2)|0;if(C){ga=J+(A<<2)|0;ga=e[ga>>1]|e[ga+2>>1]<<16;b[C>>1]=ga;b[C+2>>1]=ga>>>16}A=A+1|0}while((A|0)!=(m|0))}if(!J){j=y;break}c[5134]=(c[5134]|0)+1;_E(c[J+-4>>2]|0);j=y}else{j=h;x=J}while(0);A=x+(m<<2)|0;if(A){b[A>>1]=Q;b[A+2>>1]=Q>>>16}J=m+1|0;do if((H|0)==(n|0)){n=(H|0)==0?1:H<<1;if((H|0)>=(n|0)){n=H;break}do if(!n)C=0;else{c[5132]=(c[5132]|0)+1;C=ZE((n<<2|3)+16|0)|0;if(!C){C=0;break}c[(C+19&-16)+-4>>2]=C;C=C+19&-16}while(0);if((H|0)>0){y=0;do{A=C+(y<<2)|0;if(A){ga=f+(y<<2)|0;ga=e[ga>>1]|e[ga+2>>1]<<16;b[A>>1]=ga;b[A+2>>1]=ga>>>16}y=y+1|0}while((y|0)!=(H|0))}if(!f){f=C;break}c[5134]=(c[5134]|0)+1;_E(c[f+-4>>2]|0);f=C}while(0);C=f+(H<<2)|0;if(C){b[C>>1]=(K&65535)<<16|L&65535;b[C+2>>1]=((K&65535)<<16|L&65535)>>>16}H=H+1|0;if((h|0)<(j|0)){do if((u|0)<(j|0)){if((u|0)<=(j|0)){do if((F|0)<(j|0)){do if(!j)y=0;else{c[5132]=(c[5132]|0)+1;y=ZE((j<<2|3)+16|0)|0;if(!y){y=0;break}c[(y+19&-16)+-4>>2]=y;y=y+19&-16}while(0);if((u|0)>0){o=0;do{A=y+(o<<2)|0;if(A)c[A>>2]=c[k+(o<<2)>>2];o=o+1|0}while((o|0)!=(u|0))}if(!k){C=j;break}c[5134]=(c[5134]|0)+1;_E(c[k+-4>>2]|0);C=j}else{y=k;C=F}while(0);o=u;do{A=y+(o<<2)|0;if(A)c[A>>2]=0;o=o+1|0}while((o|0)!=(j|0));k=y;F=C}if((z|0)<(j|0)){do if((B|0)<(j|0)){do if(!j)C=0;else{c[5132]=(c[5132]|0)+1;y=ZE((j<<2|3)+16|0)|0;if(!y){C=0;break}c[(y+19&-16)+-4>>2]=y;C=y+19&-16}while(0);if((z|0)>0){y=0;do{A=C+(y<<2)|0;if(A)c[A>>2]=c[d+(y<<2)>>2];y=y+1|0}while((y|0)!=(z|0))}if(!d){B=j;break}c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0);B=j}else C=d;while(0);do{y=C+(z<<2)|0;if(y)c[y>>2]=0;z=z+1|0}while((z|0)!=(j|0))}else C=d;if((j|0)>0){d=j<<2;cF(k|0,-1,d|0)|0;cF(C|0,-1,d|0)|0}if((u|0)<=0){y=k;o=j;z=j;A=F;break}y=j+-1|0;z=0;do{d=k+(((e[f+(z<<2)+2>>1]<<16)+(b[f+(z<<2)>>1]|0)&y)<<2)|0;c[C+(z<<2)>>2]=c[d>>2];c[d>>2]=z;z=z+1|0}while((z|0)!=(u|0));y=k;o=j;z=j;A=F}else{y=k;o=u;C=d;A=F}while(0);u=o;o=((K&65535)<<16)+(L<<16>>16)&j+-1}else{y=k;C=d;A=F}k=y+(o<<2)|0;c[C+(m<<2)>>2]=c[k>>2];c[k>>2]=m;k=y;m=J;y=n}else{b[x+2>>1]=N;C=d;j=h;x=J;A=F;y=n}while(0);if((M|0)>=(R|0))break;o=c[U+36>>2]|0;d=C;h=j;J=x;F=A;n=y;x=M}h=c[U+28>>2]|0;F=f;J=k;n=j;o=H}else{F=f;J=k;o=j}T=T+1|0;if((T|0)>=(h|0))break;else{f=F;k=J;j=o}}if((h|0)>0){u=c[U+36>>2]|0;j=c[U+16>>2]|0;p=0.0;f=0;do{n=c[u+(f*36|0)+4>>2]|0;m=c[u+(f*36|0)+12>>2]|0;k=c[m>>2]|0;if((n+-2|0)>=1){w=+g[U+64>>2];v=+g[U+68>>2];t=+g[U+72>>2];o=1;do{Y=c[m+(o<<2)>>2]|0;o=o+1|0;Z=c[m+(((o|0)%(n|0)|0)<<2)>>2]|0;q=+g[j+(k<<4)>>2];r=+g[j+(Y<<4)>>2];D=+g[j+(k<<4)+4>>2];S=+g[j+(Y<<4)+4>>2];E=+g[j+(k<<4)+8>>2];I=+g[j+(Y<<4)+8>>2];s=+g[j+(Z<<4)>>2];G=+g[j+(Z<<4)+4>>2];ea=+g[j+(Z<<4)+8>>2];da=+P(+(((q-r)*(D-G)-(D-S)*(q-s))*((q-r)*(D-G)-(D-S)*(q-s))+(((D-S)*(E-ea)-(E-I)*(D-G))*((D-S)*(E-ea)-(E-I)*(D-G))+((E-I)*(q-s)-(q-r)*(E-ea))*((E-I)*(q-s)-(q-r)*(E-ea)))))*.5;w=w+(q+r+s)*.3333333432674408*da;g[U+64>>2]=w;v=(D+S+G)*.3333333432674408*da+v;g[U+68>>2]=v;t=da*((E+I+ea)*.3333333432674408)+t;g[U+72>>2]=t;p=p+da}while((o|0)!=(n+-1|0))}f=f+1|0}while((f|0)!=(h|0));o=1;B=J}else{p=0.0;o=0;B=J}}else{p=0.0;o=0;F=0;B=0;C=0;x=0}p=1.0/p;t=p*+g[U+64>>2];g[U+64>>2]=t;q=p*+g[U+68>>2];g[U+68>>2]=q;p=p*+g[U+72>>2];g[U+72>>2]=p;g[U+96>>2]=3402823466385288598117041.0e14;if(o){o=c[U+36>>2]|0;r=3402823466385288598117041.0e14;n=0;while(1){s=+O(+(+g[o+(n*36|0)+32>>2]+(+g[o+(n*36|0)+20>>2]*t+ +g[o+(n*36|0)+24>>2]*q+ +g[o+(n*36|0)+28>>2]*p)));if(s<r)g[U+96>>2]=s;else s=r;n=n+1|0;if((n|0)>=(h|0))break;else r=s}}else s=3402823466385288598117041.0e14;o=c[U+8>>2]|0;if((o|0)>0){n=c[U+16>>2]|0;q=-3402823466385288598117041.0e14;v=-3402823466385288598117041.0e14;w=-3402823466385288598117041.0e14;r=3402823466385288598117041.0e14;p=3402823466385288598117041.0e14;t=3402823466385288598117041.0e14;f=0;do{da=+g[n+(f<<4)>>2];r=da<r?da:r;q=da>q?da:q;da=+g[n+(f<<4)+4>>2];p=da<p?da:p;v=da>v?da:v;da=+g[n+(f<<4)+8>>2];t=da<t?da:t;w=da>w?da:w;f=f+1|0}while((f|0)!=(o|0))}else{q=-3402823466385288598117041.0e14;v=-3402823466385288598117041.0e14;w=-3402823466385288598117041.0e14;r=3402823466385288598117041.0e14;p=3402823466385288598117041.0e14;t=3402823466385288598117041.0e14}g[U+100>>2]=q+r;g[U+104>>2]=v+p;g[U+108>>2]=t+w;g[U+112>>2]=0.0;q=q-r;r=v-p;p=w-t;g[U+116>>2]=q;g[U+120>>2]=r;g[U+124>>2]=p;g[U+128>>2]=0.0;t=s/1.7320507764816284;if(q<r)m=r<p?2:1;else m=q<p?2:0;o=U+(m<<2)+116|0;p=(+g[o>>2]*.5-t)*.0009765625;g[U+88>>2]=t;g[U+84>>2]=t;g[U+80>>2]=t;q=+g[o>>2]*.5;o=U+(m<<2)+80|0;g[o>>2]=q;n=0;while(1){if(XD(U)|0){Y=524;break}q=q-p;g[o>>2]=q;n=n+1|0;if((n|0)>=1024){Y=523;break}}n:do if((Y|0)==523){g[U+88>>2]=t;g[U+84>>2]=t;g[U+80>>2]=t}else if((Y|0)==524){s=(+g[U+96>>2]-t)*.0009765625;o=1<<m&3;r=+g[U+((1<<o&3)<<2)+80>>2];n=0;while(1){q=+g[U+(o<<2)+80>>2];g[U+(o<<2)+80>>2]=s+q;p=s+ +g[U+((1<<o&3)<<2)+80>>2];g[U+((1<<o&3)<<2)+80>>2]=p;n=n+1|0;if(!(XD(U)|0))break;if((n|0)>=1024)break n;else r=p}g[U+(o<<2)+80>>2]=q;g[U+((1<<o&3)<<2)+80>>2]=r}while(0);if(F){c[5134]=(c[5134]|0)+1;_E(c[F+-4>>2]|0)}if(x){c[5134]=(c[5134]|0)+1;_E(c[x+-4>>2]|0)}if(C){c[5134]=(c[5134]|0)+1;_E(c[C+-4>>2]|0)}if(B){c[5134]=(c[5134]|0)+1;_E(c[B+-4>>2]|0)}if(l){c[5134]=(c[5134]|0)+1;_E(c[l+-4>>2]|0)}k=c[W>>2]|0;h=c[V>>2]|0;if((k|0)>0){o=0;do{l=h+(o*36|0)+4|0;m=h+(o*36|0)+12|0;n=c[m>>2]|0;j=h+(o*36|0)+16|0;if(n){if(a[j>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[n+-4>>2]|0)}c[m>>2]=0}a[j>>0]=1;c[m>>2]=0;c[l>>2]=0;c[h+(o*36|0)+8>>2]=0;o=o+1|0}while((o|0)!=(k|0))}if(h){if(a[ca+72>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[h+-4>>2]|0)}c[V>>2]=0}a[ca+72>>0]=1;c[V>>2]=0;c[W>>2]=0;c[ca+64>>2]=0;if(X){c[5134]=(c[5134]|0)+1;_E(c[X+-4>>2]|0)}h=c[_>>2]|0;if(h){if(a[ca+172>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[h+-4>>2]|0)}c[_>>2]=0}a[ca+172>>0]=1;c[_>>2]=0;c[ca+160>>2]=0;c[ca+164>>2]=0;h=c[$>>2]|0;if(h){if(a[ca+152>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[h+-4>>2]|0)}c[$>>2]=0}a[ca+152>>0]=1;c[$>>2]=0;c[ca+140>>2]=0;c[ca+144>>2]=0;h=c[aa>>2]|0;if(h){if(a[ca+132>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[h+-4>>2]|0)}c[aa>>2]=0}if(!ba){i=ca;return 1}c[5134]=(c[5134]|0)+1;_E(c[ba+-4>>2]|0);i=ca;return 1}function uy(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,j=0,k=0,l=0,m=0.0,n=0.0,o=0,p=0,q=0.0,r=0;p=i;i=i+2048|0;c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;e=+g[d>>2];f=+g[d+4>>2];h=+g[d+8>>2];if(e*e+f*f+h*h<9.999999747378752e-05){n=1.0;m=0.0;e=0.0}else{q=1.0/+P(+(e*e+f*f+h*h));n=e*q;m=f*q;e=h*q}if((Nb[c[(c[b>>2]|0)+96>>2]&127](b)|0)<=0){i=p;return}l=0;h=-999999984306749440.0;do{if(((Nb[c[(c[b>>2]|0)+96>>2]&127](b)|0)-l|0)<128){d=(Nb[c[(c[b>>2]|0)+96>>2]&127](b)|0)-l|0;if((d|0)>0)o=7;else{f=-3402823466385288598117041.0e14;j=-1}}else{d=128;o=7}if((o|0)==7){o=0;j=0;do{pc[c[(c[b>>2]|0)+108>>2]&127](b,j,p+(j<<4)|0);j=j+1|0}while((j|0)!=(d|0));k=0;f=-3402823466385288598117041.0e14;j=-1;do{q=n*+g[p+(k<<4)>>2]+m*+g[p+(k<<4)+4>>2]+e*+g[p+(k<<4)+8>>2];r=q>f;j=r?k:j;f=r?q:f;k=k+1|0}while((k|0)!=(d|0))}if(f>h){r=p+(j<<4)|0;c[a+0>>2]=c[r+0>>2];c[a+4>>2]=c[r+4>>2];c[a+8>>2]=c[r+8>>2];c[a+12>>2]=c[r+12>>2];h=f}l=l+128|0}while((l|0)<(Nb[c[(c[b>>2]|0)+96>>2]&127](b)|0));i=p;return}function vy(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0.0,y=0;w=i;i=i+2048|0;if((e|0)>0)f=0;else{i=w;return}do{g[d+(f<<4)+12>>2]=-999999984306749440.0;f=f+1|0}while((f|0)!=(e|0));t=0;do{if((Nb[c[(c[a>>2]|0)+96>>2]&127](a)|0)>0){r=b+(t<<4)|0;s=b+(t<<4)+4|0;o=b+(t<<4)+8|0;p=d+(t<<4)+12|0;q=d+(t<<4)|0;u=0;do{if(((Nb[c[(c[a>>2]|0)+96>>2]&127](a)|0)-u|0)<128){f=(Nb[c[(c[a>>2]|0)+96>>2]&127](a)|0)-u|0;if((f|0)>0)v=8;else{j=-3402823466385288598117041.0e14;h=-1}}else{f=128;v=8}if((v|0)==8){v=0;h=0;do{pc[c[(c[a>>2]|0)+108>>2]&127](a,h,w+(h<<4)|0);h=h+1|0}while((h|0)!=(f|0));k=+g[r>>2];l=+g[s>>2];m=+g[o>>2];n=0;j=-3402823466385288598117041.0e14;h=-1;do{x=k*+g[w+(n<<4)>>2]+l*+g[w+(n<<4)+4>>2]+m*+g[w+(n<<4)+8>>2];y=x>j;h=y?n:h;j=y?x:j;n=n+1|0}while((n|0)!=(f|0))}if(j>+g[p>>2]){y=w+(h<<4)|0;c[q+0>>2]=c[y+0>>2];c[q+4>>2]=c[y+4>>2];c[q+8>>2]=c[y+8>>2];c[q+12>>2]=c[y+12>>2];g[p>>2]=j}u=u+128|0}while((u|0)<(Nb[c[(c[a>>2]|0)+96>>2]&127](a)|0))}t=t+1|0}while((t|0)!=(e|0));i=w;return}function wy(a,b,d){a=a|0;b=+b;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0;e=i;i=i+96|0;j=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);g[e+32>>2]=1.0;c[e+36>>2]=0;c[e+40>>2]=0;c[e+44>>2]=0;c[e+48>>2]=0;g[e+52>>2]=1.0;c[e+56>>2]=0;c[e+60>>2]=0;c[e+64>>2]=0;c[e+68>>2]=0;g[e+72>>2]=1.0;k=e+76|0;c[k+0>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;tc[c[(c[a>>2]|0)+8>>2]&127](a,e+32|0,e+16|0,e);h=(j+(+g[e>>2]-+g[e+16>>2])*.5)*2.0;f=(j+(+g[e+4>>2]-+g[e+20>>2])*.5)*2.0;j=(j+(+g[e+8>>2]-+g[e+24>>2])*.5)*2.0;g[d>>2]=b*.0833333283662796*(f*f+j*j);g[d+4>>2]=b*.0833333283662796*(h*h+j*j);g[d+8>>2]=b*.0833333283662796*(h*h+f*f);g[d+12>>2]=0.0;i=e;return}function xy(b){b=b|0;var d=0,e=0,f=0,h=0.0;e=i;i=i+96|0;a[b+88>>0]=1;if((a[13656]|0)==0?(Xa(13656)|0)!=0:0){g[3390]=1.0;c[3391]=0;c[3392]=0;c[3393]=0;c[3394]=0;g[3395]=1.0;c[3396]=0;c[3397]=0;c[3398]=0;c[3399]=0;g[3400]=1.0;g[3401]=0.0;g[3402]=-1.0;c[3403]=0;c[3404]=0;c[3405]=0;c[3406]=0;g[3407]=-1.0;c[3408]=0;c[3409]=0;c[3410]=0;c[3411]=0;g[3412]=-1.0;g[3413]=0.0;ab(13656)}d=e+0|0;f=d+96|0;do{c[d>>2]=0;d=d+4|0}while((d|0)<(f|0));tc[c[(c[b>>2]|0)+76>>2]&127](b,13560,e,6);h=+g[b+44>>2];g[b+72>>2]=+g[e>>2]+h;g[b+56>>2]=+g[e+48>>2]-h;g[b+76>>2]=+g[e+20>>2]+h;g[b+60>>2]=+g[e+68>>2]-h;g[b+80>>2]=+g[e+40>>2]+h;g[b+64>>2]=+g[e+88>>2]-h;i=e;return}function yy(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0;o=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);u=+g[a+72>>2];t=+g[a+56>>2];r=+g[a+76>>2];q=+g[a+60>>2];n=+g[a+80>>2];m=+g[a+64>>2];E=+g[b>>2];y=+O(+E);D=+g[b+4>>2];x=+O(+D);k=+g[b+8>>2];l=+O(+k);C=+g[b+16>>2];w=+O(+C);B=+g[b+20>>2];v=+O(+B);i=+g[b+24>>2];j=+O(+i);A=+g[b+32>>2];s=+O(+A);z=+g[b+36>>2];p=+O(+z);f=+g[b+40>>2];h=+O(+f);k=(u+t)*.5*E+(r+q)*.5*D+(n+m)*.5*k+ +g[b+48>>2];i=(u+t)*.5*C+(r+q)*.5*B+(n+m)*.5*i+ +g[b+52>>2];f=(u+t)*.5*A+(r+q)*.5*z+(n+m)*.5*f+ +g[b+56>>2];l=(o+(u-t)*.5)*y+(o+(r-q)*.5)*x+(o+(n-m)*.5)*l;j=(o+(u-t)*.5)*w+(o+(r-q)*.5)*v+(o+(n-m)*.5)*j;h=(o+(u-t)*.5)*s+(o+(r-q)*.5)*p+(o+(n-m)*.5)*h;g[d>>2]=k-l;g[d+4>>2]=i-j;g[d+8>>2]=f-h;g[d+12>>2]=0.0;g[e>>2]=l+k;g[e+4>>2]=j+i;g[e+8>>2]=h+f;g[e+12>>2]=0.0;return}function zy(a){a=a|0;var b=0;c[a>>2]=13432;b=c[a+52>>2]|0;if(!b)return;Jb[c[c[b>>2]>>2]&255](b);b=c[a+52>>2]|0;if(!b)return;c[5134]=(c[5134]|0)+1;_E(c[b+-4>>2]|0);return}function Ay(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;if((c[b+8>>2]|0)>=(d|0))return;if((d|0)!=0?(c[5132]=(c[5132]|0)+1,e=ZE((d*36|3)+16|0)|0,(e|0)!=0):0){c[(e+19&-16)+-4>>2]=e;o=e+19&-16}else o=0;g=c[b+4>>2]|0;if((g|0)>0){n=0;do{e=o+(n*36|0)|0;if(e){l=c[b+12>>2]|0;a[e+16>>0]=1;c[e+12>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;m=c[l+(n*36|0)+4>>2]|0;if((m|0)>0){c[5132]=(c[5132]|0)+1;f=ZE((m<<2|3)+16|0)|0;if(!f)h=0;else{c[(f+19&-16)+-4>>2]=f;h=f+19&-16}k=c[e+4>>2]|0;if((k|0)>0){i=0;do{j=h+(i<<2)|0;if(j)c[j>>2]=c[(c[e+12>>2]|0)+(i<<2)>>2];i=i+1|0}while((i|0)!=(k|0))}f=c[e+12>>2]|0;if(f){if(a[e+16>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[f+-4>>2]|0)}c[e+12>>2]=0}a[e+16>>0]=1;c[e+12>>2]=h;c[e+8>>2]=m;j=0;do{k=h+(j<<2)|0;if(k)c[k>>2]=0;j=j+1|0}while((j|0)!=(m|0));c[e+4>>2]=m;k=c[l+(n*36|0)+12>>2]|0;i=0;do{j=h+(i<<2)|0;if(j)c[j>>2]=c[k+(i<<2)>>2];i=i+1|0}while((i|0)!=(m|0))}else c[e+4>>2]=m;m=l+(n*36|0)+20|0;c[e+20>>2]=c[m+0>>2];c[e+24>>2]=c[m+4>>2];c[e+28>>2]=c[m+8>>2];c[e+32>>2]=c[m+12>>2]}n=n+1|0}while((n|0)!=(g|0));f=c[b+4>>2]|0;if((f|0)>0){k=0;do{g=c[b+12>>2]|0;h=g+(k*36|0)+4|0;i=g+(k*36|0)+12|0;j=c[i>>2]|0;e=g+(k*36|0)+16|0;if(j){if(a[e>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[j+-4>>2]|0)}c[i>>2]=0}a[e>>0]=1;c[i>>2]=0;c[h>>2]=0;c[g+(k*36|0)+8>>2]=0;k=k+1|0}while((k|0)!=(f|0));e=b+12|0}else e=b+12|0}else e=b+12|0;f=c[e>>2]|0;if(f){if(a[b+16>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[f+-4>>2]|0)}c[e>>2]=0}a[b+16>>0]=1;c[e>>2]=o;c[b+8>>2]=d;return}function By(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0,x=0;w=i;i=i+32|0;s=c[a+12>>2]|0;t=+g[s+(((e+d|0)/2|0)*24|0)>>2];u=+g[s+(((e+d|0)/2|0)*24|0)+4>>2];v=+g[s+(((e+d|0)/2|0)*24|0)+8>>2];q=+g[s+(((e+d|0)/2|0)*24|0)+16>>2];r=c[s+(((e+d|0)/2|0)*24|0)+20>>2]|0;f=d;h=e;while(1){m=+g[b>>2];n=+g[b+4>>2];o=+g[b+8>>2];p=(t-m)*(t-m)+(u-n)*(u-n)+(v-o)*(v-o);a:while(1){j=+g[s+(f*24|0)+16>>2];do if(j!=q){if(!(j<q))break a}else{j=+g[s+(f*24|0)>>2]-m;k=+g[s+(f*24|0)+4>>2]-n;l=+g[s+(f*24|0)+8>>2]-o;if(j*j+k*k+l*l!=p)if(j*j+k*k+l*l<p)break;else break a;else if((c[s+(f*24|0)+20>>2]|0)<(r|0))break;else break a}while(0);f=f+1|0}b:while(1){j=+g[s+(h*24|0)+16>>2];do if(q!=j){if(!(q<j))break b}else{l=+g[s+(h*24|0)>>2]-m;k=+g[s+(h*24|0)+4>>2]-n;j=+g[s+(h*24|0)+8>>2]-o;if(p!=l*l+k*k+j*j)if(p<l*l+k*k+j*j)break;else break b;else if((r|0)<(c[s+(h*24|0)+20>>2]|0))break;else break b}while(0);h=h+-1|0}if((f|0)<=(h|0)){x=s+(f*24|0)|0;c[w+0>>2]=c[x+0>>2];c[w+4>>2]=c[x+4>>2];c[w+8>>2]=c[x+8>>2];c[w+12>>2]=c[x+12>>2];c[w+16>>2]=c[x+16>>2];c[w+20>>2]=c[x+20>>2];s=s+(h*24|0)|0;c[x+0>>2]=c[s+0>>2];c[x+4>>2]=c[s+4>>2];c[x+8>>2]=c[s+8>>2];c[x+12>>2]=c[s+12>>2];c[x+16>>2]=c[s+16>>2];c[x+20>>2]=c[s+20>>2];s=(c[a+12>>2]|0)+(h*24|0)|0;c[s+0>>2]=c[w+0>>2];c[s+4>>2]=c[w+4>>2];c[s+8>>2]=c[w+8>>2];c[s+12>>2]=c[w+12>>2];c[s+16>>2]=c[w+16>>2];c[s+20>>2]=c[w+20>>2];f=f+1|0;h=h+-1|0}if((f|0)>(h|0))break;s=c[a+12>>2]|0}if((h|0)>(d|0))By(a,b,d,h);if((f|0)>=(e|0)){i=w;return}By(a,b,f,e);i=w;return}function Cy(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0;e=i;i=i+96|0;g[e+32>>2]=1.0;c[e+36>>2]=0;c[e+40>>2]=0;c[e+44>>2]=0;c[e+48>>2]=0;g[e+52>>2]=1.0;c[e+56>>2]=0;c[e+60>>2]=0;c[e+64>>2]=0;c[e+68>>2]=0;g[e+72>>2]=1.0;n=e+76|0;c[n+0>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;c[n+16>>2]=0;tc[c[(c[a>>2]|0)+8>>2]&127](a,e+32|0,e+16|0,e);l=+g[e>>2];m=+g[e+16>>2];j=+g[e+4>>2];k=+g[e+20>>2];f=+g[e+8>>2];h=+g[e+24>>2];g[d>>2]=+P(+((l-m)*(l-m)+(j-k)*(j-k)+(f-h)*(f-h)))*.5;g[b>>2]=(m+l)*.5;g[b+4>>2]=(k+j)*.5;g[b+8>>2]=(h+f)*.5;g[b+12>>2]=0.0;i=e;return}function Dy(a,b){a=a|0;b=+b;return +(+Zb[c[(c[a>>2]|0)+16>>2]&15](a)*b)}function Ey(a){a=a|0;var b=0,d=0.0,e=0.0,f=0.0;b=i;i=i+32|0;pc[c[(c[a>>2]|0)+12>>2]&127](a,b+8|0,b);f=+g[b+8>>2];e=+g[b+12>>2];d=+g[b+16>>2];d=+P(+(f*f+e*e+d*d));i=b;return +(d+ +g[b>>2])}function Fy(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0;tc[c[(c[a>>2]|0)+8>>2]&127](a,b,f,h);n=+g[h>>2];k=+g[h+4>>2];i=+g[h+8>>2];l=+g[f>>2];o=+g[f+4>>2];j=+g[f+8>>2];m=+g[d>>2];p=+g[d+4>>2];q=+g[d+8>>2];if(m>0.0)n=n+m;else l=l+m;if(p>0.0){m=o;k=k+p}else m=o+p;if(q>0.0)i=i+q;else j=j+q;o=+g[e>>2];p=+g[e+4>>2];q=+g[e+8>>2];q=+P(+(o*o+p*p+q*q));q=q*+Zb[c[(c[a>>2]|0)+16>>2]&15](a);g[f>>2]=l;g[f+4>>2]=m;g[f+8>>2]=j;g[f+12>>2]=0.0;g[h>>2]=n;g[h+4>>2]=k;g[h+8>>2]=i;g[h+12>>2]=0.0;g[f>>2]=+g[f>>2]-q;g[f+4>>2]=+g[f+4>>2]-q;g[f+8>>2]=+g[f+8>>2]-q;g[h>>2]=q+ +g[h>>2];g[h+4>>2]=q+ +g[h+4>>2];g[h+8>>2]=q+ +g[h+8>>2];return}function Gy(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=ec[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;f=ec[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;c[b>>2]=f;if(f)Lb[c[(c[d>>2]|0)+48>>2]&127](d,e);c[b+4>>2]=c[a+4>>2];return 13768}function Hy(a,b){a=a|0;b=b|0;var d=0,e=0;e=Nb[c[(c[a>>2]|0)+52>>2]&127](a)|0;e=Wb[c[(c[b>>2]|0)+16>>2]&63](b,e,1)|0;d=Wb[c[(c[a>>2]|0)+56>>2]&63](a,c[e+8>>2]|0,b)|0;Hb[c[(c[b>>2]|0)+20>>2]&31](b,e,d,1346455635,a);return}function Iy(a){a=a|0;return}function Jy(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0,j=0.0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0;k=i;i=i+64|0;n=+g[d>>2];o=+g[d+4>>2];m=+g[d+8>>2];p=n*+g[b+4>>2]+o*+g[b+20>>2]+m*+g[b+36>>2];q=n*+g[b+8>>2]+o*+g[b+24>>2]+m*+g[b+40>>2];g[k+48>>2]=+g[b>>2]*n+ +g[b+16>>2]*o+ +g[b+32>>2]*m;g[k+52>>2]=p;g[k+56>>2]=q;g[k+60>>2]=0.0;pc[c[(c[a>>2]|0)+64>>2]&127](k+32|0,a,k+48|0);q=+g[k+32>>2];p=+g[k+36>>2];m=+g[k+40>>2];o=q*+g[b>>2]+p*+g[b+4>>2]+m*+g[b+8>>2]+ +g[b+48>>2];n=q*+g[b+16>>2]+p*+g[b+20>>2]+m*+g[b+24>>2]+ +g[b+52>>2];m=q*+g[b+32>>2]+p*+g[b+36>>2]+m*+g[b+40>>2]+ +g[b+56>>2];r=c[(c[a>>2]|0)+64>>2]|0;p=-+g[k+52>>2];q=-+g[k+56>>2];g[k>>2]=-+g[k+48>>2];g[k+4>>2]=p;g[k+8>>2]=q;g[k+12>>2]=0.0;pc[r&127](k+16|0,a,k);q=+g[k+16>>2];p=+g[k+20>>2];h=+g[k+24>>2];l=q*+g[b>>2]+p*+g[b+4>>2]+h*+g[b+8>>2]+ +g[b+48>>2];j=q*+g[b+16>>2]+p*+g[b+20>>2]+h*+g[b+24>>2]+ +g[b+52>>2];h=q*+g[b+32>>2]+p*+g[b+36>>2]+h*+g[b+40>>2]+ +g[b+56>>2];g[e>>2]=o*+g[d>>2]+n*+g[d+4>>2]+m*+g[d+8>>2];h=l*+g[d>>2]+j*+g[d+4>>2]+h*+g[d+8>>2];g[f>>2]=h;j=+g[e>>2];if(!(j>h)){i=k;return}g[e>>2]=h;g[f>>2]=j;i=k;return}function Ky(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0;x=i;i=i+80|0;switch(c[b+4>>2]|0){case 13:{c[x+64>>2]=c[b+28>>2];c[x+68>>2]=c[b+32>>2];c[x+72>>2]=c[b+36>>2];c[x+76>>2]=c[b+40>>2];g[x+48>>2]=+g[d>>2];h=+g[d+4>>2];g[x+52>>2]=h;j=+g[d+8>>2];g[x+56>>2]=j;g[x+60>>2]=0.0;e=c[b+52>>2]|0;if((e|0)==1){l=0;b=e;d=2}else if((e|0)==2){j=h;l=0;b=e;d=1}else{l=1;b=0;d=2}m=+g[x+64+(l<<2)>>2];f=+g[x+64+(e<<2)>>2];h=+g[x+48+(l<<2)>>2];k=+P(+(h*h+j*j));if(k!=0.0){g[x+32+(l<<2)>>2]=h*(m/k);if(+g[x+48+(b<<2)>>2]<0.0)f=-f;g[x+32+(b<<2)>>2]=f;g[x+32+(d<<2)>>2]=m/k*j;g[a>>2]=+g[x+32>>2];g[a+4>>2]=+g[x+36>>2];g[a+8>>2]=+g[x+40>>2];g[a+12>>2]=0.0;i=x;return}else{g[x+32+(l<<2)>>2]=m;if(+g[x+48+(b<<2)>>2]<0.0)f=-f;g[x+32+(b<<2)>>2]=f;g[x+32+(d<<2)>>2]=0.0;g[a>>2]=+g[x+32>>2];g[a+4>>2]=+g[x+36>>2];g[a+8>>2]=+g[x+40>>2];g[a+12>>2]=0.0;i=x;return}}case 8:{c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;i=x;return}case 4:{q=c[b+104>>2]|0;l=c[b+96>>2]|0;o=+g[b+12>>2];p=+g[b+16>>2];n=+g[b+20>>2];m=+g[d>>2]*o;f=+g[d+4>>2]*p;k=+g[d+8>>2]*n;if((l|0)>0){b=0;h=-3402823466385288598117041.0e14;e=-1;while(1){j=m*+g[q+(b<<4)>>2]+f*+g[q+(b<<4)+4>>2]+k*+g[q+(b<<4)+8>>2];d=j>h;e=d?b:e;b=b+1|0;if((b|0)==(l|0))break;else h=d?j:h}}else e=-1;v=p*+g[q+(e<<4)+4>>2];w=n*+g[q+(e<<4)+8>>2];g[a>>2]=o*+g[q+(e<<4)>>2];g[a+4>>2]=v;g[a+8>>2]=w;g[a+12>>2]=0.0;i=x;return}case 5:{q=c[b+92>>2]|0;l=c[b+96>>2]|0;p=+g[b+12>>2];o=+g[b+16>>2];n=+g[b+20>>2];m=+g[d>>2]*p;f=+g[d+4>>2]*o;k=+g[d+8>>2]*n;if((l|0)>0){b=0;h=-3402823466385288598117041.0e14;e=-1;while(1){j=m*+g[q+(b<<4)>>2]+f*+g[q+(b<<4)+4>>2]+k*+g[q+(b<<4)+8>>2];d=j>h;e=d?b:e;b=b+1|0;if((b|0)==(l|0))break;else h=d?j:h}}else e=-1;v=o*+g[q+(e<<4)+4>>2];w=n*+g[q+(e<<4)+8>>2];g[a>>2]=p*+g[q+(e<<4)>>2];g[a+4>>2]=v;g[a+8>>2]=w;g[a+12>>2]=0.0;i=x;return}case 0:{u=+g[b+28>>2];v=+g[b+32>>2];v=+g[d+4>>2]>=0.0?v:-v;w=+g[b+36>>2];w=+g[d+8>>2]>=0.0?w:-w;g[a>>2]=+g[d>>2]>=0.0?u:-u;g[a+4>>2]=v;g[a+8>>2]=w;g[a+12>>2]=0.0;i=x;return}case 10:{j=+g[d>>2];h=+g[d+4>>2];f=+g[d+8>>2];d=c[b+52>>2]|0;w=+g[b+(d<<2)+28>>2];k=+g[b+(((d+2|0)%3|0)<<2)+28>>2];if(j*j+h*h+f*f<9.999999747378752e-05){v=1.0;u=0.0;t=0.0}else{t=1.0/+P(+(j*j+h*h+f*f));v=j*t;u=h*t;t=f*t}c[x+16>>2]=0;c[x+20>>2]=0;c[x+24>>2]=0;c[x+28>>2]=0;g[x+16+(d<<2)>>2]=w;r=k*v;s=k*u;f=k*t;m=+g[b+44>>2];p=v*m;o=u*m;m=t*m;h=+g[x+16>>2]+r-p;n=s+ +g[x+20>>2]-o;k=f+ +g[x+24>>2]-m;j=t*k+(v*h+u*n);if(!(j>-999999984306749440.0)){k=0.0;n=0.0;h=0.0;j=-999999984306749440.0}c[x+0>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;c[x+12>>2]=0;g[x+(d<<2)>>2]=-w;r=r+ +g[x>>2]-p;p=s+ +g[x+4>>2]-o;w=f+ +g[x+8>>2]-m;d=t*w+(v*r+u*p)>j;g[a>>2]=d?r:h;g[a+4>>2]=d?p:n;g[a+8>>2]=d?w:k;g[a+12>>2]=0.0;i=x;return}case 1:{v=+g[d>>2];w=+g[d+4>>2];j=+g[d+8>>2];f=v*+g[b+56>>2]+w*+g[b+60>>2]+j*+g[b+64>>2];h=v*+g[b+72>>2]+w*+g[b+76>>2]+j*+g[b+80>>2];j=v*+g[b+88>>2]+w*+g[b+92>>2]+j*+g[b+96>>2];if(f<h)e=h<j?2:1;else e=f<j?2:0;v=+g[b+56+(e<<4)+4>>2];w=+g[b+56+(e<<4)+8>>2];g[a>>2]=+g[b+56+(e<<4)>>2];g[a+4>>2]=v;g[a+8>>2]=w;g[a+12>>2]=0.0;i=x;return}default:{pc[c[(c[b>>2]|0)+68>>2]&127](a,b,d);i=x;return}}}function Ly(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,j=0,k=0.0;j=i;i=i+32|0;c[j+16>>2]=c[d+0>>2];c[j+20>>2]=c[d+4>>2];c[j+24>>2]=c[d+8>>2];c[j+28>>2]=c[d+12>>2];e=+g[j+16>>2];h=+g[j+20>>2];f=+g[j+24>>2];if(e*e+h*h+f*f<1.4210854715202004e-14){g[j+16>>2]=-1.0;g[j+20>>2]=-1.0;g[j+24>>2]=-1.0;g[j+28>>2]=0.0;e=-1.0;h=-1.0;f=-1.0}k=1.0/+P(+(e*e+h*h+f*f));g[j+16>>2]=e*k;g[j+20>>2]=h*k;g[j+24>>2]=f*k;Ky(j,b,j+16|0);switch(c[b+4>>2]|0){case 8:{e=+g[b+28>>2]*+g[b+12>>2];break}case 4:case 5:{e=+g[b+44>>2];break}case 0:{e=+g[b+44>>2];break}case 11:{e=+g[b+44>>2];break}case 10:{e=+g[b+44>>2];break}case 1:{e=+g[b+44>>2];break}case 13:{e=+g[b+44>>2];break}default:e=+Zb[c[(c[b>>2]|0)+48>>2]&15](b)}k=e*+g[j+20>>2]+ +g[j+4>>2];h=e*+g[j+24>>2]+ +g[j+8>>2];g[a>>2]=e*+g[j+16>>2]+ +g[j>>2];g[a+4>>2]=k;g[a+8>>2]=h;g[a+12>>2]=0.0;i=j;return}function My(a,b){a=a|0;b=b|0;var c=0.0,d=0.0,e=0.0;e=+O(+(+g[b>>2]));d=+O(+(+g[b+4>>2]));c=+O(+(+g[b+8>>2]));g[a+12>>2]=e;g[a+16>>2]=d;g[a+20>>2]=c;g[a+24>>2]=0.0;return}function Ny(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0,j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0;j=i;i=i+96|0;f=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);h=0;do{q=j+80+(h<<2)|0;c[j+80>>2]=0;c[j+84>>2]=0;c[j+88>>2]=0;c[j+92>>2]=0;g[q>>2]=1.0;k=c[(c[a>>2]|0)+64>>2]|0;l=+g[j+80>>2];m=+g[j+84>>2];n=+g[j+88>>2];o=l*+g[b+4>>2]+m*+g[b+20>>2]+n*+g[b+36>>2];p=l*+g[b+8>>2]+m*+g[b+24>>2]+n*+g[b+40>>2];g[j+48>>2]=+g[b>>2]*l+ +g[b+16>>2]*m+ +g[b+32>>2]*n;g[j+52>>2]=o;g[j+56>>2]=p;g[j+60>>2]=0.0;pc[k&127](j+64|0,a,j+48|0);p=+g[j+64>>2];o=+g[j+68>>2];n=+g[j+72>>2];m=p*+g[b+16>>2]+o*+g[b+20>>2]+n*+g[b+24>>2]+ +g[b+52>>2];l=p*+g[b+32>>2]+o*+g[b+36>>2]+n*+g[b+40>>2]+ +g[b+56>>2];g[j+32>>2]=p*+g[b>>2]+o*+g[b+4>>2]+n*+g[b+8>>2]+ +g[b+48>>2];g[j+36>>2]=m;g[j+40>>2]=l;g[j+44>>2]=0.0;k=j+32+(h<<2)|0;g[e+(h<<2)>>2]=f+ +g[k>>2];g[q>>2]=-1.0;q=c[(c[a>>2]|0)+64>>2]|0;l=+g[j+80>>2];m=+g[j+84>>2];n=+g[j+88>>2];o=l*+g[b+4>>2]+m*+g[b+20>>2]+n*+g[b+36>>2];p=l*+g[b+8>>2]+m*+g[b+24>>2]+n*+g[b+40>>2];g[j>>2]=+g[b>>2]*l+ +g[b+16>>2]*m+ +g[b+32>>2]*n;g[j+4>>2]=o;g[j+8>>2]=p;g[j+12>>2]=0.0;pc[q&127](j+16|0,a,j);p=+g[j+16>>2];o=+g[j+20>>2];n=+g[j+24>>2];m=p*+g[b+16>>2]+o*+g[b+20>>2]+n*+g[b+24>>2]+ +g[b+52>>2];l=p*+g[b+32>>2]+o*+g[b+36>>2]+n*+g[b+40>>2]+ +g[b+56>>2];g[j+32>>2]=p*+g[b>>2]+o*+g[b+4>>2]+n*+g[b+8>>2]+ +g[b+48>>2];g[j+36>>2]=m;g[j+40>>2]=l;g[j+44>>2]=0.0;g[d+(h<<2)>>2]=+g[k>>2]-f;h=h+1|0}while((h|0)!=3);i=j;return}function Oy(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;pc[c[(c[b>>2]|0)+68>>2]&127](a,b,d);if(!(+Zb[c[(c[b>>2]|0)+48>>2]&15](b)!=0.0))return;j=+g[d>>2];h=+g[d+4>>2];f=+g[d+8>>2];e=j*j+h*h+f*f<1.4210854715202004e-14?-1.0:f;i=j*j+h*h+f*f<1.4210854715202004e-14?-1.0:h;j=j*j+h*h+f*f<1.4210854715202004e-14?-1.0:j;f=1.0/+P(+(e*e+(j*j+i*i)));h=+Zb[c[(c[b>>2]|0)+48>>2]&15](b);g[a>>2]=f*j*h+ +g[a>>2];g[a+4>>2]=h*(f*i)+ +g[a+4>>2];g[a+8>>2]=h*(f*e)+ +g[a+8>>2];return}function Py(a,b){a=a|0;b=b|0;c[a+12>>2]=c[b+0>>2];c[a+16>>2]=c[b+4>>2];c[a+20>>2]=c[b+8>>2];c[a+24>>2]=c[b+12>>2];xy(a);return}function Qy(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0;f=c[b+96>>2]|0;if((f|0)==(c[b+100>>2]|0)?(i=(f|0)==0?1:f<<1,(f|0)<(i|0)):0){if(!i)h=0;else{c[5132]=(c[5132]|0)+1;f=ZE((i<<4|3)+16|0)|0;if(!f)f=0;else{c[(f+19&-16)+-4>>2]=f;f=f+19&-16}h=f;f=c[b+96>>2]|0}if((f|0)>0){g=0;do{j=h+(g<<4)|0;k=(c[b+104>>2]|0)+(g<<4)|0;c[j+0>>2]=c[k+0>>2];c[j+4>>2]=c[k+4>>2];c[j+8>>2]=c[k+8>>2];c[j+12>>2]=c[k+12>>2];g=g+1|0}while((g|0)!=(f|0))}f=c[b+104>>2]|0;if(f){if(a[b+108>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[f+-4>>2]|0)}c[b+104>>2]=0}a[b+108>>0]=1;c[b+104>>2]=h;c[b+100>>2]=i;f=c[b+96>>2]|0}k=(c[b+104>>2]|0)+(f<<4)|0;c[k+0>>2]=c[d+0>>2];c[k+4>>2]=c[d+4>>2];c[k+8>>2]=c[d+8>>2];c[k+12>>2]=c[d+12>>2];c[b+96>>2]=(c[b+96>>2]|0)+1;if(!e)return;xy(b);return}function Ry(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0,h=0.0,i=0,j=0.0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0;k=c[b+96>>2]|0;if((k|0)<=0){c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;return}o=+g[b+12>>2];p=+g[d>>2]*o;l=+g[b+16>>2];m=+g[d+4>>2]*l;n=+g[b+20>>2];j=+g[d+8>>2]*n;b=c[b+104>>2]|0;f=0;h=-3402823466385288598117041.0e14;i=-1;while(1){e=p*+g[b+(f<<4)>>2]+m*+g[b+(f<<4)+4>>2]+j*+g[b+(f<<4)+8>>2];d=e>h;i=d?f:i;f=f+1|0;if((f|0)==(k|0))break;else h=d?e:h}l=+g[b+(i<<4)+4>>2]*l;p=+g[b+(i<<4)+8>>2]*n;g[a>>2]=+g[b+(i<<4)>>2]*o;g[a+4>>2]=l;g[a+8>>2]=p;g[a+12>>2]=0.0;return}function Sy(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0,o=0,p=0,q=0.0,r=0,s=0.0,t=0;if((e|0)>0)f=0;else return;do{g[d+(f<<4)+12>>2]=-999999984306749440.0;f=f+1|0}while((f|0)!=(e|0));p=0;do{h=+g[a+12>>2];i=+g[b+(p<<4)>>2]*h;j=+g[a+16>>2];k=+g[b+(p<<4)+4>>2]*j;l=+g[a+20>>2];m=+g[b+(p<<4)+8>>2]*l;f=c[a+96>>2]|0;if((f|0)>0){n=c[a+104>>2]|0;o=0;q=-3402823466385288598117041.0e14;r=-1;do{s=i*+g[n+(o<<4)>>2]+k*+g[n+(o<<4)+4>>2]+m*+g[n+(o<<4)+8>>2];t=s>q;r=t?o:r;q=t?s:q;o=o+1|0}while((o|0)!=(f|0));s=+g[n+(r<<4)+4>>2]*j;m=+g[n+(r<<4)+8>>2]*l;g[d+(p<<4)>>2]=+g[n+(r<<4)>>2]*h;g[d+(p<<4)+4>>2]=s;g[d+(p<<4)+8>>2]=m;g[d+(p<<4)+12>>2]=q}else g[d+(p<<4)+12>>2]=-999999984306749440.0;p=p+1|0}while((p|0)!=(e|0));return}function Ty(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;pc[c[(c[b>>2]|0)+68>>2]&127](a,b,d);if(!(+Zb[c[(c[b>>2]|0)+48>>2]&15](b)!=0.0))return;j=+g[d>>2];h=+g[d+4>>2];f=+g[d+8>>2];e=j*j+h*h+f*f<1.4210854715202004e-14?-1.0:f;i=j*j+h*h+f*f<1.4210854715202004e-14?-1.0:h;j=j*j+h*h+f*f<1.4210854715202004e-14?-1.0:j;f=1.0/+P(+(e*e+(j*j+i*i)));h=+Zb[c[(c[b>>2]|0)+48>>2]&15](b);g[a>>2]=f*j*h+ +g[a>>2];g[a+4>>2]=h*(f*i)+ +g[a+4>>2];g[a+8>>2]=h*(f*e)+ +g[a+8>>2];return}function Uy(a){a=a|0;return c[a+96>>2]|0}function Vy(a){a=a|0;return c[a+96>>2]|0}function Wy(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0,j=0;i=c[a+96>>2]|0;j=c[a+104>>2]|0;f=+g[j+(((b|0)%(i|0)|0)<<4)+4>>2]*+g[a+16>>2];h=+g[j+(((b|0)%(i|0)|0)<<4)+8>>2]*+g[a+20>>2];g[d>>2]=+g[j+(((b|0)%(i|0)|0)<<4)>>2]*+g[a+12>>2];g[d+4>>2]=f;g[d+8>>2]=h;g[d+12>>2]=0.0;d=c[a+104>>2]|0;h=+g[d+(((b+1|0)%(i|0)|0)<<4)+4>>2]*+g[a+16>>2];f=+g[d+(((b+1|0)%(i|0)|0)<<4)+8>>2]*+g[a+20>>2];g[e>>2]=+g[d+(((b+1|0)%(i|0)|0)<<4)>>2]*+g[a+12>>2];g[e+4>>2]=h;g[e+8>>2]=f;g[e+12>>2]=0.0;return}function Xy(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0;h=c[a+104>>2]|0;f=+g[h+(b<<4)+4>>2]*+g[a+16>>2];e=+g[h+(b<<4)+8>>2]*+g[a+20>>2];g[d>>2]=+g[h+(b<<4)>>2]*+g[a+12>>2];g[d+4>>2]=f;g[d+8>>2]=e;g[d+12>>2]=0.0;return}function Yy(a){a=a|0;return 0}function Zy(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return}function _y(a,b,c){a=a|0;b=b|0;c=+c;return 0}function $y(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0;e=ec[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;h=ec[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;c[b>>2]=h;if(h)Lb[c[(c[d>>2]|0)+48>>2]&127](d,e);c[b+4>>2]=c[a+4>>2];g[b+28>>2]=+g[a+28>>2];g[b+32>>2]=+g[a+32>>2];g[b+36>>2]=+g[a+36>>2];g[b+40>>2]=+g[a+40>>2];g[b+12>>2]=+g[a+12>>2];g[b+16>>2]=+g[a+16>>2];g[b+20>>2]=+g[a+20>>2];g[b+24>>2]=+g[a+24>>2];g[b+44>>2]=+g[a+44>>2];f=c[a+96>>2]|0;c[b+60>>2]=f;if(!f){c[b+52>>2]=0;c[b+56>>2]=0;return 14032}c[b+52>>2]=ec[c[(c[d>>2]|0)+28>>2]&31](d,c[a+104>>2]|0)|0;c[b+56>>2]=0;h=Wb[c[(c[d>>2]|0)+16>>2]&63](d,16,f)|0;if((f|0)>0){e=c[a+104>>2]|0;b=0;a=c[h+8>>2]|0;while(1){g[a>>2]=+g[e+(b<<4)>>2];g[a+4>>2]=+g[e+(b<<4)+4>>2];g[a+8>>2]=+g[e+(b<<4)+8>>2];g[a+12>>2]=+g[e+(b<<4)+12>>2];b=b+1|0;if((b|0)==(f|0))break;else a=a+16|0}}else e=c[a+104>>2]|0;Hb[c[(c[d>>2]|0)+20>>2]&31](d,h,20320,1497453121,e);return 14032}function az(a,b,d,e,f,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0.0,l=0.0,m=0,n=0.0,o=0.0,p=0,q=0,r=0.0,s=0;q=i;i=i+16|0;g[e>>2]=3402823466385288598117041.0e14;g[f>>2]=-3402823466385288598117041.0e14;m=c[a+96>>2]|0;if((m|0)>0){p=0;do{s=c[a+104>>2]|0;r=+g[s+(p<<4)>>2]*+g[a+12>>2];o=+g[s+(p<<4)+4>>2]*+g[a+16>>2];n=+g[s+(p<<4)+8>>2]*+g[a+20>>2];l=r*+g[b>>2]+o*+g[b+4>>2]+n*+g[b+8>>2]+ +g[b+48>>2];k=r*+g[b+16>>2]+o*+g[b+20>>2]+n*+g[b+24>>2]+ +g[b+52>>2];n=r*+g[b+32>>2]+o*+g[b+36>>2]+n*+g[b+40>>2]+ +g[b+56>>2];o=l*+g[d>>2]+k*+g[d+4>>2]+n*+g[d+8>>2];if(o<+g[e>>2]){g[e>>2]=o;g[h>>2]=l;g[h+4>>2]=k;g[h+8>>2]=n;g[h+12>>2]=0.0}if(o>+g[f>>2]){g[f>>2]=o;g[j>>2]=l;g[j+4>>2]=k;g[j+8>>2]=n;g[j+12>>2]=0.0}p=p+1|0}while((p|0)!=(m|0));l=+g[f>>2]}else l=-3402823466385288598117041.0e14;k=+g[e>>2];if(!(k>l)){i=q;return}g[e>>2]=l;g[f>>2]=k;c[q+0>>2]=c[h+0>>2];c[q+4>>2]=c[h+4>>2];c[q+8>>2]=c[h+8>>2];c[q+12>>2]=c[h+12>>2];c[h+0>>2]=c[j+0>>2];c[h+4>>2]=c[j+4>>2];c[h+8>>2]=c[j+8>>2];c[h+12>>2]=c[j+12>>2];c[j+0>>2]=c[q+0>>2];c[j+4>>2]=c[q+4>>2];c[j+8>>2]=c[q+8>>2];c[j+12>>2]=c[q+12>>2];i=q;return}function bz(a){a=a|0;return 68}function cz(a){a=a|0;return 14096}function dz(b){b=b|0;var d=0,e=0;c[b>>2]=13904;d=c[b+104>>2]|0;if(d){if(a[b+108>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+104>>2]=0}a[b+108>>0]=1;c[b+104>>2]=0;c[b+96>>2]=0;c[b+100>>2]=0;c[b>>2]=13432;d=c[b+52>>2]|0;if((d|0)!=0?(Jb[c[c[d>>2]>>2]&255](d),e=c[b+52>>2]|0,(e|0)!=0):0){c[5134]=(c[5134]|0)+1;_E(c[e+-4>>2]|0)}if(!b)return;c[5134]=(c[5134]|0)+1;_E(c[b+-4>>2]|0);return}function ez(b){b=b|0;var d=0;c[b>>2]=13904;d=c[b+104>>2]|0;if(d){if(a[b+108>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+104>>2]=0}a[b+108>>0]=1;c[b+104>>2]=0;c[b+96>>2]=0;c[b+100>>2]=0;c[b>>2]=13432;d=c[b+52>>2]|0;if(!d)return;Jb[c[c[d>>2]>>2]&255](d);d=c[b+52>>2]|0;if(!d)return;c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0);return}function fz(a){a=a|0;return}function gz(a){a=a|0;return}function hz(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0;q=i;i=i+32|0;c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;e=+g[d>>2];f=+g[d+4>>2];h=+g[d+8>>2];if(e*e+f*f+h*h<9.999999747378752e-05){p=1.0;o=0.0;n=0.0}else{n=1.0/+P(+(e*e+f*f+h*h));p=e*n;o=f*n;n=h*n}d=c[b+52>>2]|0;m=+g[b+(((d+2|0)%3|0)<<2)+28>>2];c[q+16>>2]=0;c[q+20>>2]=0;c[q+24>>2]=0;c[q+28>>2]=0;g[q+16+(d<<2)>>2]=+g[b+(d<<2)+28>>2];k=p*m;l=o*m;m=n*m;h=k+ +g[q+16>>2];f=l+ +g[q+20>>2];j=m+ +g[q+24>>2];e=+Zb[c[(c[b>>2]|0)+48>>2]&15](b);h=h-p*e;f=f-o*e;e=j-n*e;j=n*e+(p*h+o*f);if(j>-999999984306749440.0){g[a>>2]=h;g[a+4>>2]=f;g[a+8>>2]=e;g[a+12>>2]=0.0}else j=-999999984306749440.0;c[q+0>>2]=0;c[q+4>>2]=0;c[q+8>>2]=0;c[q+12>>2]=0;d=c[b+52>>2]|0;g[q+(d<<2)>>2]=-+g[b+(d<<2)+28>>2];h=k+ +g[q>>2];f=l+ +g[q+4>>2];m=m+ +g[q+8>>2];e=+Zb[c[(c[b>>2]|0)+48>>2]&15](b);h=h-p*e;f=f-o*e;e=m-n*e;if(!(n*e+(p*h+o*f)>j)){i=q;return}g[a>>2]=h;g[a+4>>2]=f;g[a+8>>2]=e;g[a+12>>2]=0.0;i=q;return}function iz(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0,v=0,w=0.0,x=0,y=0;x=i;i=i+32|0;f=c[a+52>>2]|0;w=+g[a+(((f+2|0)%3|0)<<2)+28>>2];if((e|0)<=0){i=x;return}h=0;while(1){c[x+16>>2]=0;c[x+20>>2]=0;c[x+24>>2]=0;c[x+28>>2]=0;g[x+16+(f<<2)>>2]=+g[a+(f<<2)+28>>2];f=b+(h<<4)|0;u=b+(h<<4)+4|0;v=b+(h<<4)+8|0;o=w*+g[f>>2]+ +g[x+16>>2];n=w*+g[u>>2]+ +g[x+20>>2];m=w*+g[v>>2]+ +g[x+24>>2];l=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);k=+g[f>>2];j=+g[u>>2];p=+g[v>>2];if(k*(o-l*k)+j*(n-l*j)+p*(m-l*p)>-999999984306749440.0){g[d+(h<<4)>>2]=o-l*k;g[d+(h<<4)+4>>2]=n-l*j;g[d+(h<<4)+8>>2]=m-l*p;g[d+(h<<4)+12>>2]=0.0;q=+g[f>>2];s=+g[u>>2];t=+g[v>>2];r=k*(o-l*k)+j*(n-l*j)+p*(m-l*p)}else{q=k;s=j;t=p;r=-999999984306749440.0};c[x+0>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;c[x+12>>2]=0;y=c[a+52>>2]|0;g[x+(y<<2)>>2]=-+g[a+(y<<2)+28>>2];p=w*q+ +g[x>>2];o=w*s+ +g[x+4>>2];m=w*t+ +g[x+8>>2];n=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);l=+g[f>>2];k=+g[u>>2];j=+g[v>>2];if(l*(p-n*l)+k*(o-n*k)+j*(m-n*j)>r){g[d+(h<<4)>>2]=p-n*l;g[d+(h<<4)+4>>2]=o-n*k;g[d+(h<<4)+8>>2]=m-n*j;g[d+(h<<4)+12>>2]=0.0}h=h+1|0;if((h|0)==(e|0))break;f=c[a+52>>2]|0}i=x;return}function jz(a,b,d){a=a|0;b=+b;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0;e=i;i=i+16|0;k=c[a+52>>2]|0;h=+g[a+(((k+2|0)%3|0)<<2)+28>>2];g[e>>2]=h;g[e+4>>2]=h;g[e+8>>2]=h;g[e+12>>2]=0.0;g[e+(k<<2)>>2]=+g[a+(k<<2)+28>>2]+ +g[e+(k<<2)>>2];h=(+g[e>>2]+.03999999910593033)*2.0;f=(+g[e+4>>2]+.03999999910593033)*2.0;j=(+g[e+8>>2]+.03999999910593033)*2.0;g[d>>2]=b*.0833333283662796*(f*f+j*j);g[d+4>>2]=b*.0833333283662796*(h*h+j*j);g[d+8>>2]=b*.0833333283662796*(h*h+f*f);i=e;return}function kz(a){a=a|0;return 14616}function lz(a){a=a|0;if(!a)return;c[5134]=(c[5134]|0)+1;_E(c[a+-4>>2]|0);return}function mz(a){a=a|0;return 14632}function nz(a){a=a|0;if(!a)return;c[5134]=(c[5134]|0)+1;_E(c[a+-4>>2]|0);return}function oz(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=ec[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;f=ec[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;c[b>>2]=f;if(f)Lb[c[(c[d>>2]|0)+48>>2]&127](d,e);c[b+4>>2]=c[a+4>>2];g[b+28>>2]=+g[a+28>>2];g[b+32>>2]=+g[a+32>>2];g[b+36>>2]=+g[a+36>>2];g[b+40>>2]=+g[a+40>>2];g[b+12>>2]=+g[a+12>>2];g[b+16>>2]=+g[a+16>>2];g[b+20>>2]=+g[a+20>>2];g[b+24>>2]=+g[a+24>>2];g[b+44>>2]=+g[a+44>>2];c[b+52>>2]=c[a+52>>2];return 14648}function pz(a){a=a|0;return 60}function qz(a,b){a=a|0;b=+b;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0;h=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);e=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);i=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);h=h+ +g[a+28>>2];e=e+ +g[a+32>>2];i=i+ +g[a+36>>2];g[a+44>>2]=b;f=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);d=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);b=i-+Zb[c[(c[a>>2]|0)+48>>2]&15](a);g[a+28>>2]=h-f;g[a+32>>2]=e-d;g[a+36>>2]=b;g[a+40>>2]=0.0;return}function rz(a,b){a=a|0;b=b|0;c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;g[a+(c[b+52>>2]<<2)>>2]=1.0;return}function sz(a){a=a|0;return 14672}function tz(a,b){a=a|0;b=b|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0;k=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);h=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);d=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);m=(k+ +g[a+28>>2])/+g[a+12>>2];j=(h+ +g[a+32>>2])/+g[a+16>>2];f=(d+ +g[a+36>>2])/+g[a+20>>2];l=+O(+(+g[b>>2]));i=+O(+(+g[b+4>>2]));e=+O(+(+g[b+8>>2]));g[a+12>>2]=l;g[a+16>>2]=i;g[a+20>>2]=e;g[a+24>>2]=0.0;g[a+28>>2]=m*l-k;g[a+32>>2]=j*i-h;g[a+36>>2]=f*e-d;g[a+40>>2]=0.0;return}function uz(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0;f=i;i=i+16|0;x=c[a+52>>2]|0;k=+g[a+(((x+2|0)%3|0)<<2)+28>>2];g[f>>2]=k;g[f+4>>2]=k;g[f+8>>2]=k;g[f+12>>2]=0.0;g[f+(x<<2)>>2]=k+ +g[a+(x<<2)+28>>2];k=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);h=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);n=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);k=k+ +g[f>>2];g[f>>2]=k;h=h+ +g[f+4>>2];g[f+4>>2]=h;n=n+ +g[f+8>>2];u=+O(+(+g[b>>2]));t=+O(+(+g[b+4>>2]));v=+O(+(+g[b+8>>2]));q=+O(+(+g[b+16>>2]));p=+O(+(+g[b+20>>2]));r=+O(+(+g[b+24>>2]));l=+O(+(+g[b+32>>2]));j=+O(+(+g[b+36>>2]));m=+O(+(+g[b+40>>2]));w=+g[b+48>>2];s=+g[b+52>>2];o=+g[b+56>>2];g[d>>2]=w-(n*v+(u*k+t*h));g[d+4>>2]=s-(n*r+(q*k+p*h));g[d+8>>2]=o-(n*m+(l*k+j*h));g[d+12>>2]=0.0;g[e>>2]=w+(n*v+(u*k+t*h));g[e+4>>2]=s+(n*r+(q*k+p*h));g[e+8>>2]=o+(n*m+(l*k+j*h));g[e+12>>2]=0.0;i=f;return}function vz(a){a=a|0;if(!a)return;c[5134]=(c[5134]|0)+1;_E(c[a+-4>>2]|0);return}function wz(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0,m=0.0;l=i;i=i+80|0;c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;e=+g[d>>2];f=+g[d+4>>2];j=+g[d+8>>2];if(e*e+f*f+j*j<9.999999747378752e-05){k=1.0;h=0.0;f=0.0;e=0.0}else{m=1.0/+P(+(e*e+f*f+j*j));k=e*m;h=f*m;f=j*m;e=+g[d+12>>2]}c[l+32>>2]=14896;c[l+36>>2]=0;c[l+40>>2]=0;c[l+44>>2]=0;c[l+48>>2]=0;g[l+52>>2]=-999999984306749440.0;g[l+56>>2]=k;g[l+60>>2]=h;g[l+64>>2]=f;g[l+68>>2]=e;g[l+16>>2]=999999984306749440.0;g[l+20>>2]=999999984306749440.0;g[l+24>>2]=999999984306749440.0;g[l+28>>2]=0.0;b=c[b+92>>2]|0;d=c[(c[b>>2]|0)+8>>2]|0;g[l>>2]=-999999984306749440.0;g[l+4>>2]=-999999984306749440.0;g[l+8>>2]=-999999984306749440.0;g[l+12>>2]=0.0;tc[d&127](b,l+32|0,l,l+16|0);c[a+0>>2]=c[l+36>>2];c[a+4>>2]=c[l+40>>2];c[a+8>>2]=c[l+44>>2];c[a+12>>2]=c[l+48>>2];i=l;return}function xz(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0;h=i;i=i+80|0;if((e|0)>0)f=0;else{i=h;return}do{g[d+(f<<4)+12>>2]=-999999984306749440.0;f=f+1|0}while((f|0)!=(e|0));f=0;do{j=b+(f<<4)|0;c[h+32>>2]=14896;c[h+36>>2]=0;c[h+40>>2]=0;c[h+44>>2]=0;c[h+48>>2]=0;g[h+52>>2]=-999999984306749440.0;c[h+56>>2]=c[j+0>>2];c[h+60>>2]=c[j+4>>2];c[h+64>>2]=c[j+8>>2];c[h+68>>2]=c[j+12>>2];g[h+16>>2]=999999984306749440.0;g[h+20>>2]=999999984306749440.0;g[h+24>>2]=999999984306749440.0;g[h+28>>2]=0.0;j=c[a+92>>2]|0;k=c[(c[j>>2]|0)+8>>2]|0;g[h>>2]=-999999984306749440.0;g[h+4>>2]=-999999984306749440.0;g[h+8>>2]=-999999984306749440.0;g[h+12>>2]=0.0;tc[k&127](j,h+32|0,h,h+16|0);j=d+(f<<4)|0;c[j+0>>2]=c[h+36>>2];c[j+4>>2]=c[h+40>>2];c[j+8>>2]=c[h+44>>2];c[j+12>>2]=c[h+48>>2];f=f+1|0}while((f|0)<(e|0));i=h;return}function yz(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;pc[c[(c[b>>2]|0)+68>>2]&127](a,b,d);if(!(+Zb[c[(c[b>>2]|0)+48>>2]&15](b)!=0.0))return;j=+g[d>>2];h=+g[d+4>>2];f=+g[d+8>>2];e=j*j+h*h+f*f<1.4210854715202004e-14?-1.0:f;i=j*j+h*h+f*f<1.4210854715202004e-14?-1.0:h;j=j*j+h*h+f*f<1.4210854715202004e-14?-1.0:j;f=1.0/+P(+(e*e+(j*j+i*i)));h=+Zb[c[(c[b>>2]|0)+48>>2]&15](b);g[a>>2]=f*j*h+ +g[a>>2];g[a+4>>2]=h*(f*i)+ +g[a+4>>2];g[a+8>>2]=h*(f*e)+ +g[a+8>>2];return}function zz(a){a=a|0;return 0}function Az(a){a=a|0;return 0}function Bz(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return}function Cz(a,b,c){a=a|0;b=b|0;c=c|0;return}function Dz(a){a=a|0;return 0}function Ez(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return}function Fz(a,b,c){a=a|0;b=b|0;c=+c;return 0}function Gz(a,b){a=a|0;b=b|0;var d=0;d=(c[a+92>>2]|0)+4|0;c[d+0>>2]=c[b+0>>2];c[d+4>>2]=c[b+4>>2];c[d+8>>2]=c[b+8>>2];c[d+12>>2]=c[b+12>>2];xy(a);return}function Hz(a){a=a|0;return (c[a+92>>2]|0)+4|0}function Iz(a){a=a|0;return 14872}function Jz(a){a=a|0;var b=0;c[a>>2]=13432;b=c[a+52>>2]|0;if(b){Jb[c[c[b>>2]>>2]&255](b);b=c[a+52>>2]|0;if(b){c[5134]=(c[5134]|0)+1;_E(c[b+-4>>2]|0)}if(!a)return}c[5134]=(c[5134]|0)+1;_E(c[a+-4>>2]|0);return}function Kz(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;j=+g[a+24>>2];k=+g[a+28>>2];i=+g[a+32>>2];f=j*+g[b>>2]+k*+g[b+4>>2]+i*+g[b+8>>2];h=+g[a+20>>2];if(f>h){g[a+20>>2]=f;c[a+4>>2]=c[b+0>>2];c[a+8>>2]=c[b+4>>2];c[a+12>>2]=c[b+8>>2];c[a+16>>2]=c[b+12>>2]}else f=h;h=j*+g[b+16>>2]+k*+g[b+20>>2]+i*+g[b+24>>2];if(h>f){g[a+20>>2]=h;c[a+4>>2]=c[b+16>>2];c[a+8>>2]=c[b+20>>2];c[a+12>>2]=c[b+24>>2];c[a+16>>2]=c[b+28>>2]}else h=f;f=j*+g[b+32>>2]+k*+g[b+36>>2]+i*+g[b+40>>2];if(!(f>h))return;g[a+20>>2]=f;c[a+4>>2]=c[b+32>>2];c[a+8>>2]=c[b+36>>2];c[a+12>>2]=c[b+40>>2];c[a+16>>2]=c[b+44>>2];return}function Lz(a){a=a|0;_E(a);return}function Mz(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0;i=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);m=i+ +g[a+28>>2];k=i+ +g[a+32>>2];i=i+ +g[a+36>>2];u=+O(+(+g[b>>2]));t=+O(+(+g[b+4>>2]));s=+O(+(+g[b+8>>2]));q=+O(+(+g[b+16>>2]));p=+O(+(+g[b+20>>2]));o=+O(+(+g[b+24>>2]));l=+O(+(+g[b+32>>2]));j=+O(+(+g[b+36>>2]));h=+O(+(+g[b+40>>2]));r=+g[b+48>>2];n=+g[b+52>>2];f=+g[b+56>>2];g[d>>2]=r-(m*u+k*t+i*s);g[d+4>>2]=n-(m*q+k*p+i*o);g[d+8>>2]=f-(m*l+k*j+i*h);g[d+12>>2]=0.0;g[e>>2]=m*u+k*t+i*s+r;g[e+4>>2]=m*q+k*p+i*o+n;g[e+8>>2]=m*l+k*j+i*h+f;g[e+12>>2]=0.0;return}function Nz(a,b,d){a=a|0;b=+b;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;i=+g[a+28>>2];f=+g[a+32>>2];j=+g[a+36>>2];h=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);e=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);j=(j+ +Zb[c[(c[a>>2]|0)+48>>2]&15](a))*2.0;g[d>>2]=b/12.0*((f+e)*2.0*((f+e)*2.0)+j*j);g[d+4>>2]=b/12.0*((i+h)*2.0*((i+h)*2.0)+j*j);g[d+8>>2]=b/12.0*((i+h)*2.0*((i+h)*2.0)+(f+e)*2.0*((f+e)*2.0));g[d+12>>2]=0.0;return}function Oz(a,b){a=a|0;b=+b;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0;h=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);e=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);i=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);h=h+ +g[a+28>>2];e=e+ +g[a+32>>2];i=i+ +g[a+36>>2];g[a+44>>2]=b;f=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);d=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);b=i-+Zb[c[(c[a>>2]|0)+48>>2]&15](a);g[a+28>>2]=h-f;g[a+32>>2]=e-d;g[a+36>>2]=b;g[a+40>>2]=0.0;return}function Pz(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0;e=+g[a+28>>2];f=+g[a+32>>2];d=+g[a+36>>2];switch(c|0){case 2:{g[b>>2]=0.0;g[b+4>>2]=1.0;g[b+8>>2]=0.0;g[b+12>>2]=-f;return}case 0:{g[b>>2]=1.0;g[b+4>>2]=0.0;g[b+8>>2]=0.0;g[b+12>>2]=-e;return}case 5:{g[b>>2]=0.0;g[b+4>>2]=0.0;g[b+8>>2]=-1.0;g[b+12>>2]=-d;return}case 4:{g[b>>2]=0.0;g[b+4>>2]=0.0;g[b+8>>2]=1.0;g[b+12>>2]=-d;return}case 1:{g[b>>2]=-1.0;g[b+4>>2]=0.0;g[b+8>>2]=0.0;g[b+12>>2]=-e;return}case 3:{g[b>>2]=0.0;g[b+4>>2]=-1.0;g[b+8>>2]=0.0;g[b+12>>2]=-f;return}default:return}}function Qz(a,b,c){a=a|0;b=b|0;c=+c;var d=0.0,e=0.0,f=0.0,h=0.0;e=+g[a+28>>2];f=+g[a+32>>2];h=+g[a+36>>2];d=+g[b>>2];if(!(d<=e+c)){b=0;return b|0}if(!(d>=-e-c)){b=0;return b|0}d=+g[b+4>>2];if(!(d<=f+c)){b=0;return b|0}if(!(d>=-f-c)){b=0;return b|0}d=+g[b+8>>2];if(!(d<=h+c)){b=0;return b|0}b=d>=-h-c;return b|0}function Rz(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0,k=0.0;f=i;i=i+48|0;pc[c[(c[a>>2]|0)+124>>2]&127](a,f+32|0,e);k=+g[f+32>>2];j=+g[f+36>>2];h=+g[f+40>>2];g[b>>2]=k;g[b+4>>2]=j;g[b+8>>2]=h;g[b+12>>2]=0.0;b=c[(c[a>>2]|0)+64>>2]|0;g[f>>2]=-k;g[f+4>>2]=-j;g[f+8>>2]=-h;g[f+12>>2]=0.0;pc[b&127](f+16|0,a,f);c[d+0>>2]=c[f+16>>2];c[d+4>>2]=c[f+20>>2];c[d+8>>2]=c[f+24>>2];c[d+12>>2]=c[f+28>>2];i=f;return}function Sz(a){a=a|0;return 6}function Tz(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;j=+g[a+28>>2];h=+g[a+32>>2];e=+g[a+36>>2];i=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);f=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);e=e+ +Zb[c[(c[a>>2]|0)+48>>2]&15](a);g[d>>2]=+(b&1^1|0)*(j+i)-+(b&1|0)*(j+i);g[d+4>>2]=+(b>>>1&1^1|0)*(h+f)-+(b>>>1&1|0)*(h+f);g[d+8>>2]=+(b>>>2&1^1|0)*e-+(b>>>2&1|0)*e;g[d+12>>2]=0.0;return}function Uz(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;do switch(b|0){case 0:{f=0;b=1;break}case 9:{f=4;b=6;break}case 3:{f=2;break}case 2:{f=1;b=3;break}case 7:{f=3;break}case 5:{f=1;break}case 4:{f=0;break}case 11:{f=6;b=7;break}case 6:{f=2;break}case 1:{f=0;b=2;break}case 10:{f=5;b=7;break}case 8:{f=4;b=5;break}default:{f=0;b=0}}while(0);pc[c[(c[a>>2]|0)+108>>2]&127](a,f,d);pc[c[(c[a>>2]|0)+108>>2]&127](a,b,e);return}function Vz(a){a=a|0;return 12}function Wz(a){a=a|0;return 8}function Xz(a,b,c){a=a|0;b=b|0;c=c|0;switch(b|0){case 5:{g[c>>2]=0.0;g[c+4>>2]=0.0;g[c+8>>2]=-1.0;g[c+12>>2]=0.0;return}case 3:{g[c>>2]=0.0;g[c+4>>2]=-1.0;g[c+8>>2]=0.0;g[c+12>>2]=0.0;return}case 4:{g[c>>2]=0.0;g[c+4>>2]=0.0;g[c+8>>2]=1.0;g[c+12>>2]=0.0;return}case 2:{g[c>>2]=0.0;g[c+4>>2]=1.0;g[c+8>>2]=0.0;g[c+12>>2]=0.0;return}case 0:{g[c>>2]=1.0;g[c+4>>2]=0.0;g[c+8>>2]=0.0;g[c+12>>2]=0.0;return}case 1:{g[c>>2]=-1.0;g[c+4>>2]=0.0;g[c+8>>2]=0.0;g[c+12>>2]=0.0;return}default:return}}function Yz(a){a=a|0;return 6}function Zz(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0.0,h=0.0,i=0.0;if((d|0)<=0)return;e=0;do{i=+g[a+28>>2];h=+g[a+32>>2];h=+g[b+(e<<4)+4>>2]>=0.0?h:-h;f=+g[a+36>>2];f=+g[b+(e<<4)+8>>2]>=0.0?f:-f;g[c+(e<<4)>>2]=+g[b+(e<<4)>>2]>=0.0?i:-i;g[c+(e<<4)+4>>2]=h;g[c+(e<<4)+8>>2]=f;g[c+(e<<4)+12>>2]=0.0;e=e+1|0}while((e|0)!=(d|0));return}function _z(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0;f=+g[b+28>>2];e=+g[b+32>>2];e=+g[c+4>>2]>=0.0?e:-e;d=+g[b+36>>2];d=+g[c+8>>2]>=0.0?d:-d;g[a>>2]=+g[c>>2]>=0.0?f:-f;g[a+4>>2]=e;g[a+8>>2]=d;g[a+12>>2]=0.0;return}function $z(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;i=+g[b+28>>2];j=+g[b+32>>2];e=+g[b+36>>2];h=+Zb[c[(c[b>>2]|0)+48>>2]&15](b);f=+Zb[c[(c[b>>2]|0)+48>>2]&15](b);e=e+ +Zb[c[(c[b>>2]|0)+48>>2]&15](b);f=+g[d+4>>2]>=0.0?j+f:-(j+f);e=+g[d+8>>2]>=0.0?e:-e;g[a>>2]=+g[d>>2]>=0.0?i+h:-(i+h);g[a+4>>2]=f;g[a+8>>2]=e;g[a+12>>2]=0.0;return}function aA(a){a=a|0;return 15168}function bA(a,b){a=a|0;b=b|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0;k=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);h=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);d=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);m=(k+ +g[a+28>>2])/+g[a+12>>2];j=(h+ +g[a+32>>2])/+g[a+16>>2];f=(d+ +g[a+36>>2])/+g[a+20>>2];l=+O(+(+g[b>>2]));i=+O(+(+g[b+4>>2]));e=+O(+(+g[b+8>>2]));g[a+12>>2]=l;g[a+16>>2]=i;g[a+20>>2]=e;g[a+24>>2]=0.0;g[a+28>>2]=m*l-k;g[a+32>>2]=j*i-h;g[a+36>>2]=f*e-d;g[a+40>>2]=0.0;return}function cA(a){a=a|0;var b=0;c[a>>2]=13432;b=c[a+52>>2]|0;if(b){Jb[c[c[b>>2]>>2]&255](b);b=c[a+52>>2]|0;if(b){c[5134]=(c[5134]|0)+1;_E(c[b+-4>>2]|0)}if(!a)return}c[5134]=(c[5134]|0)+1;_E(c[a+-4>>2]|0);return}function dA(a){a=a|0;zC(a);return}function eA(a){a=a|0;zC(a);if(!a)return;c[5134]=(c[5134]|0)+1;_E(c[a+-4>>2]|0);return}function fA(d,e,f,h,j){d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0,l=0.0,m=0,n=0.0,o=0.0,p=0,q=0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0;z=i;i=i+176|0;a[d+60>>0]=f&1;if(f){s=+g[h>>2]+-1.0;w=+g[h+4>>2]+-1.0;u=+g[h+8>>2]+-1.0;g[d+4>>2]=s;g[d+8>>2]=w;g[d+12>>2]=u;g[d+16>>2]=0.0;x=+g[j>>2]+1.0;n=+g[j+4>>2]+1.0;l=+g[j+8>>2]+1.0;g[d+20>>2]=x;g[d+24>>2]=n;g[d+28>>2]=l;g[d+32>>2]=0.0;g[d+36>>2]=65533.0/(x-s);g[d+40>>2]=65533.0/(n-w);g[d+44>>2]=65533.0/(l-u);g[d+48>>2]=0.0;a[d+60>>0]=1;o=s+ +(~~((s-s)*(65533.0/(x-s)))&65534)/(65533.0/(x-s))+-1.0;r=w+ +(~~((w-w)*(65533.0/(n-w)))&65534)/(65533.0/(n-w))+-1.0;t=u+ +(~~((u-u)*(65533.0/(l-u)))&65534)/(65533.0/(l-u))+-1.0;if(o<s)g[d+4>>2]=o;else o=s;if(r<w){g[d+8>>2]=r;y=r}else y=w;if(t<u){g[d+12>>2]=t;v=t}else v=u;r=o+ +((~~((x-o)*(65533.0/(x-s))+1.0)&65535|1)&65535)/(65533.0/(x-s))+1.0;s=y+ +((~~((n-y)*(65533.0/(n-w))+1.0)&65535|1)&65535)/(65533.0/(n-w))+1.0;t=v+ +((~~((l-v)*(65533.0/(l-u))+1.0)&65535|1)&65535)/(65533.0/(l-u))+1.0;if(x<r)g[d+20>>2]=r;else r=x;if(n<s){g[d+24>>2]=s;n=s}if(l<t){g[d+28>>2]=t;l=t}g[d+36>>2]=65533.0/(r-o);g[d+40>>2]=65533.0/(n-y);g[d+44>>2]=65533.0/(l-v);g[d+48>>2]=0.0;c[z+80>>2]=15264;c[z+84>>2]=d+104;c[z+88>>2]=d;tc[c[(c[e>>2]|0)+8>>2]&127](e,z+80|0,d+4|0,d+20|0);k=c[d+108>>2]|0;c[z+128>>2]=0;c[z+132>>2]=0;c[z+136>>2]=0;c[z+140>>2]=0;m=c[d+128>>2]|0;if((m|0)<(k<<1|0)){if((c[d+132>>2]|0)<(k<<1|0)){if(!k){j=0;f=m}else{c[5132]=(c[5132]|0)+1;j=ZE(k<<5|19)|0;if(!j)j=0;else{c[(j+19&-16)+-4>>2]=j;j=j+19&-16}f=c[d+128>>2]|0}if((f|0)>0){h=0;do{e=j+(h<<4)|0;q=(c[d+136>>2]|0)+(h<<4)|0;c[e+0>>2]=c[q+0>>2];c[e+4>>2]=c[q+4>>2];c[e+8>>2]=c[q+8>>2];c[e+12>>2]=c[q+12>>2];h=h+1|0}while((h|0)!=(f|0))}f=c[d+136>>2]|0;if(f){if(a[d+140>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[f+-4>>2]|0)}c[d+136>>2]=0}a[d+140>>0]=1;c[d+136>>2]=j;c[d+132>>2]=k<<1;f=d+136|0}else f=d+136|0;j=m;do{e=(c[f>>2]|0)+(j<<4)|0;c[e+0>>2]=c[z+128>>2];c[e+4>>2]=c[z+132>>2];c[e+8>>2]=c[z+136>>2];c[e+12>>2]=c[z+140>>2];j=j+1|0}while((j|0)!=(k<<1|0))}c[d+128>>2]=k<<1}else{c[z+144>>2]=15408;c[z+148>>2]=d+64;g[z+152>>2]=-999999984306749440.0;g[z+156>>2]=-999999984306749440.0;g[z+160>>2]=-999999984306749440.0;g[z+164>>2]=0.0;g[z+64>>2]=999999984306749440.0;g[z+68>>2]=999999984306749440.0;g[z+72>>2]=999999984306749440.0;g[z+76>>2]=0.0;tc[c[(c[e>>2]|0)+8>>2]&127](e,z+144|0,z+152|0,z+64|0);k=c[d+68>>2]|0;p=z+0|0;e=p+64|0;do{c[p>>2]=0;p=p+4|0}while((p|0)<(e|0));h=c[d+88>>2]|0;if((h|0)<(k<<1|0)){if((c[d+92>>2]|0)<(k<<1|0)){if(!k){j=0;f=h}else{c[5132]=(c[5132]|0)+1;j=ZE(k<<7|19)|0;if(!j)j=0;else{c[(j+19&-16)+-4>>2]=j;j=j+19&-16}f=c[d+88>>2]|0}if((f|0)>0){m=0;do{p=j+(m<<6)+0|0;q=(c[d+96>>2]|0)+(m<<6)+0|0;e=p+64|0;do{c[p>>2]=c[q>>2];p=p+4|0;q=q+4|0}while((p|0)<(e|0));m=m+1|0}while((m|0)!=(f|0))}f=c[d+96>>2]|0;if(f){if(a[d+100>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[f+-4>>2]|0)}c[d+96>>2]=0}a[d+100>>0]=1;c[d+96>>2]=j;c[d+92>>2]=k<<1;f=d+96|0}else f=d+96|0;do{p=(c[f>>2]|0)+(h<<6)+0|0;q=z+0|0;e=p+64|0;do{c[p>>2]=c[q>>2];p=p+4|0;q=q+4|0}while((p|0)<(e|0));h=h+1|0}while((h|0)!=(k<<1|0))}c[d+88>>2]=k<<1}c[d+56>>2]=0;yC(d,0,k);if((a[d+60>>0]|0)!=0?(c[d+152>>2]|0)==0:0){if(!(c[d+156>>2]|0)){c[5132]=(c[5132]|0)+1;k=ZE(51)|0;if(!k)h=0;else{c[(k+19&-16)+-4>>2]=k;h=k+19&-16}k=c[d+152>>2]|0;if((k|0)>0){j=0;do{e=h+(j<<5)|0;q=(c[d+160>>2]|0)+(j<<5)|0;c[e+0>>2]=c[q+0>>2];c[e+4>>2]=c[q+4>>2];c[e+8>>2]=c[q+8>>2];c[e+12>>2]=c[q+12>>2];c[e+16>>2]=c[q+16>>2];c[e+20>>2]=c[q+20>>2];c[e+24>>2]=c[q+24>>2];c[e+28>>2]=c[q+28>>2];j=j+1|0}while((j|0)!=(k|0))}k=c[d+160>>2]|0;if(k){if(a[d+164>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[k+-4>>2]|0)}c[d+160>>2]=0}a[d+164>>0]=1;c[d+160>>2]=h;c[d+156>>2]=1;j=(c[d+152>>2]|0)+1|0;k=h}else{j=1;k=c[d+160>>2]|0}c[d+152>>2]=j;c[k+0>>2]=c[z+96>>2];c[k+4>>2]=c[z+100>>2];c[k+8>>2]=c[z+104>>2];c[k+12>>2]=c[z+108>>2];c[k+16>>2]=c[z+112>>2];c[k+20>>2]=c[z+116>>2];c[k+24>>2]=c[z+120>>2];c[k+28>>2]=c[z+124>>2];e=c[d+160>>2]|0;q=c[d+136>>2]|0;b[e>>1]=b[q>>1]|0;b[e+2>>1]=b[q+2>>1]|0;b[e+4>>1]=b[q+4>>1]|0;b[e+6>>1]=b[q+6>>1]|0;b[e+8>>1]=b[q+8>>1]|0;b[e+10>>1]=b[q+10>>1]|0;c[e+12>>2]=0;q=c[q+12>>2]|0;c[e+16>>2]=(q|0)>-1?1:0-q|0}c[d+168>>2]=c[d+152>>2];k=c[d+116>>2]|0;if(k){if(a[d+120>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[k+-4>>2]|0)}c[d+116>>2]=0}a[d+120>>0]=1;c[d+116>>2]=0;c[d+108>>2]=0;c[d+112>>2]=0;k=c[d+76>>2]|0;if(!k){a[d+80>>0]=1;c[d+76>>2]=0;c[d+68>>2]=0;e=d+72|0;c[e>>2]=0;i=z;return}if(a[d+80>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[k+-4>>2]|0)}c[d+76>>2]=0;a[d+80>>0]=1;c[d+76>>2]=0;c[d+68>>2]=0;e=d+72|0;c[e>>2]=0;i=z;return}function gA(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;EC(a,b,c,d)|0;return 1}function hA(a){a=a|0;return 84}function iA(d,e,f,h){d=d|0;e=e|0;f=f|0;h=h|0;var i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0,o=0.0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0,E=0;i=+g[e>>2];j=i<999999984306749440.0?i:999999984306749440.0;k=+g[e+4>>2];m=k<999999984306749440.0?k:999999984306749440.0;o=+g[e+8>>2];l=o<999999984306749440.0?o:999999984306749440.0;i=i>-999999984306749440.0?i:-999999984306749440.0;k=k>-999999984306749440.0?k:-999999984306749440.0;o=o>-999999984306749440.0?o:-999999984306749440.0;x=+g[e+16>>2];j=x<j?x:j;y=+g[e+20>>2];m=y<m?y:m;z=+g[e+24>>2];l=z<l?z:l;i=i<x?x:i;k=k<y?y:k;o=o<z?z:o;z=+g[e+32>>2];j=z<j?z:j;y=+g[e+36>>2];m=y<m?y:m;x=+g[e+40>>2];l=x<l?x:l;i=i<z?z:i;k=k<y?y:k;o=o<x?x:o;if(i-j<2.0000000949949026e-03){i=i+1.0000000474974513e-03;j=j+-1.0000000474974513e-03}if(k-m<2.0000000949949026e-03){k=k+1.0000000474974513e-03;m=m+-1.0000000474974513e-03}if(o-l<2.0000000949949026e-03){o=o+1.0000000474974513e-03;l=l+-1.0000000474974513e-03}v=c[d+8>>2]|0;C=+g[v+4>>2];A=+g[v+8>>2];y=+g[v+12>>2];B=+g[v+36>>2];x=+g[v+40>>2];z=+g[v+44>>2];v=~~((j-C)*B)&65534;u=~~((m-A)*x)&65534;t=~~((l-y)*z)&65534;s=(~~((i-C)*B+1.0)&65535|1)&65535;r=(~~((k-A)*x+1.0)&65535|1)&65535;q=(~~((o-y)*z+1.0)&65535|1)&65535;d=c[d+4>>2]|0;e=c[d+4>>2]|0;if((e|0)==(c[d+8>>2]|0)?(w=(e|0)==0?1:e<<1,(e|0)<(w|0)):0){if(!w)p=0;else{c[5132]=(c[5132]|0)+1;e=ZE((w<<4|3)+16|0)|0;if(!e)e=0;else{c[(e+19&-16)+-4>>2]=e;e=e+19&-16}p=e;e=c[d+4>>2]|0}if((e|0)>0){n=0;do{D=p+(n<<4)|0;E=(c[d+12>>2]|0)+(n<<4)|0;c[D+0>>2]=c[E+0>>2];c[D+4>>2]=c[E+4>>2];c[D+8>>2]=c[E+8>>2];c[D+12>>2]=c[E+12>>2];n=n+1|0}while((n|0)!=(e|0))}e=c[d+12>>2]|0;if(e){if(a[d+16>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[e+-4>>2]|0)}c[d+12>>2]=0}a[d+16>>0]=1;c[d+12>>2]=p;c[d+8>>2]=w;e=c[d+4>>2]|0}E=c[d+12>>2]|0;b[E+(e<<4)>>1]=v;b[E+(e<<4)+2>>1]=u;b[E+(e<<4)+4>>1]=t;b[E+(e<<4)+6>>1]=s;b[E+(e<<4)+8>>1]=r;b[E+(e<<4)+10>>1]=q;c[E+(e<<4)+12>>2]=f<<21|h;c[d+4>>2]=(c[d+4>>2]|0)+1;return}function jA(a){a=a|0;_E(a);return}function kA(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0,x=0.0,y=0.0,z=0.0,A=0.0;w=i;i=i+32|0;p=+g[d>>2];t=p<999999984306749440.0?p:999999984306749440.0;q=+g[d+4>>2];u=q<999999984306749440.0?q:999999984306749440.0;r=+g[d+8>>2];v=r<999999984306749440.0?r:999999984306749440.0;s=+g[d+12>>2];o=s<0.0?s:0.0;p=p>-999999984306749440.0?p:-999999984306749440.0;q=q>-999999984306749440.0?q:-999999984306749440.0;r=r>-999999984306749440.0?r:-999999984306749440.0;s=s>0.0?s:0.0;x=+g[d+16>>2];t=x<t?x:t;y=+g[d+20>>2];u=y<u?y:u;z=+g[d+24>>2];v=z<v?z:v;A=+g[d+28>>2];o=A<o?A:o;p=p<x?x:p;q=q<y?y:q;r=r<z?z:r;s=s<A?A:s;A=+g[d+32>>2];t=A<t?A:t;z=+g[d+36>>2];u=z<u?z:u;y=+g[d+40>>2];v=y<v?y:v;x=+g[d+44>>2];o=x<o?x:o;p=p<A?A:p;q=q<z?z:q;r=r<y?y:r;s=s<x?x:s;m=c[b+4>>2]|0;d=c[m+4>>2]|0;if((d|0)==(c[m+8>>2]|0)?(n=(d|0)==0?1:d<<1,(d|0)<(n|0)):0){if(!n)l=0;else{c[5132]=(c[5132]|0)+1;d=ZE(n<<6|19)|0;if(!d)d=0;else{c[(d+19&-16)+-4>>2]=d;d=d+19&-16}l=d;d=c[m+4>>2]|0}if((d|0)>0){b=0;do{h=l+(b<<6)+0|0;j=(c[m+12>>2]|0)+(b<<6)+0|0;k=h+64|0;do{c[h>>2]=c[j>>2];h=h+4|0;j=j+4|0}while((h|0)<(k|0));b=b+1|0}while((b|0)!=(d|0))}b=c[m+12>>2]|0;if(b){if(a[m+16>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[b+-4>>2]|0)}c[m+12>>2]=0}a[m+16>>0]=1;c[m+12>>2]=l;c[m+8>>2]=n;d=c[m+4>>2]|0}n=c[m+12>>2]|0;g[n+(d<<6)>>2]=t;g[n+(d<<6)+4>>2]=u;g[n+(d<<6)+8>>2]=v;g[n+(d<<6)+12>>2]=o;g[n+(d<<6)+16>>2]=p;g[n+(d<<6)+20>>2]=q;g[n+(d<<6)+24>>2]=r;g[n+(d<<6)+28>>2]=s;c[n+(d<<6)+32>>2]=-1;c[n+(d<<6)+36>>2]=e;c[n+(d<<6)+40>>2]=f;n=n+(d<<6)+44|0;c[n+0>>2]=c[w+0>>2];c[n+4>>2]=c[w+4>>2];c[n+8>>2]=c[w+8>>2];c[n+12>>2]=c[w+12>>2];c[n+16>>2]=c[w+16>>2];c[m+4>>2]=(c[m+4>>2]|0)+1;i=w;return}function lA(a){a=a|0;_E(a);return}function mA(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;c[a+4>>2]=35;c[a+8>>2]=0;g[a+12>>2]=1.0;g[a+16>>2]=1.0;g[a+20>>2]=1.0;g[a+24>>2]=0.0;g[a+44>>2]=.03999999910593033;c[a>>2]=15544;c[a+52>>2]=1;h=+g[b>>2];e=+g[b+4>>2];f=+g[b+8>>2];if(h<e)d=h<f?0:2;else d=e<f?1:2;e=+g[b+(d<<2)>>2]*.10000000149011612;if(e<.03999999910593033){j=+Iu(a);i=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);h=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);j=j+ +g[a+28>>2];i=i+ +g[a+32>>2];h=h+ +g[a+36>>2];g[a+44>>2]=e;e=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);f=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);h=h-+Zb[c[(c[a>>2]|0)+48>>2]&15](a);g[a+28>>2]=j-e;g[a+32>>2]=i-f;g[a+36>>2]=h;g[a+40>>2]=0.0;d=c[a>>2]|0}else d=15544|0;f=+Zb[c[d+48>>2]&15](a);j=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);h=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);j=+g[b+4>>2]*+g[a+16>>2]-j;h=+g[b+8>>2]*+g[a+20>>2]-h;g[a+28>>2]=+g[b>>2]*+g[a+12>>2]-f;g[a+32>>2]=j;g[a+36>>2]=h;g[a+40>>2]=0.0;c[a+4>>2]=13;return}function nA(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0;i=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);m=i+ +g[a+28>>2];k=i+ +g[a+32>>2];i=i+ +g[a+36>>2];u=+O(+(+g[b>>2]));t=+O(+(+g[b+4>>2]));s=+O(+(+g[b+8>>2]));q=+O(+(+g[b+16>>2]));p=+O(+(+g[b+20>>2]));o=+O(+(+g[b+24>>2]));l=+O(+(+g[b+32>>2]));j=+O(+(+g[b+36>>2]));h=+O(+(+g[b+40>>2]));r=+g[b+48>>2];n=+g[b+52>>2];f=+g[b+56>>2];g[d>>2]=r-(m*u+k*t+i*s);g[d+4>>2]=n-(m*q+k*p+i*o);g[d+8>>2]=f-(m*l+k*j+i*h);g[d+12>>2]=0.0;g[e>>2]=m*u+k*t+i*s+r;g[e+4>>2]=m*q+k*p+i*o+n;g[e+8>>2]=m*l+k*j+i*h+f;g[e+12>>2]=0.0;return}function oA(a,b,d){a=a|0;b=+b;d=d|0;var e=0.0,f=0.0,h=0,j=0,k=0,l=0.0;k=i;i=i+16|0;c[k+0>>2]=c[a+28>>2];c[k+4>>2]=c[a+32>>2];c[k+8>>2]=c[a+36>>2];c[k+12>>2]=c[a+40>>2];l=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);e=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);f=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);g[k>>2]=l+ +g[k>>2];g[k+4>>2]=e+ +g[k+4>>2];g[k+8>>2]=f+ +g[k+8>>2];j=c[a+52>>2]|0;if((j|0)==2){h=2;a=0}else if(!j){h=0;a=1}else{h=1;a=0}f=+g[k+(a<<2)>>2];e=+g[k+(h<<2)>>2];e=b*.25*(f*f)+b/12.0*(e*(e*4.0));if((j|0)==2){g[d>>2]=e;g[d+4>>2]=e;g[d+8>>2]=b*.5*(f*f);g[d+12>>2]=0.0;i=k;return}else if(!j){g[d>>2]=b*.5*(f*f);g[d+4>>2]=e;g[d+8>>2]=e;g[d+12>>2]=0.0;i=k;return}else{g[d>>2]=e;g[d+4>>2]=b*.5*(f*f);g[d+8>>2]=e;g[d+12>>2]=0.0;i=k;return}}function pA(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0;i=+g[b+32>>2];d=+g[b+28>>2];e=+g[c+4>>2];h=+g[c+8>>2];f=+P(+(e*e+h*h));if(f!=0.0){g[a+4>>2]=e*(i/f);if(+g[c>>2]<0.0)d=-d;g[a>>2]=d;g[a+8>>2]=h*(i/f);return}else{g[a+4>>2]=i;if(+g[c>>2]<0.0)d=-d;g[a>>2]=d;g[a+8>>2]=0.0;return}}function qA(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0;i=+g[b+28>>2];d=+g[b+36>>2];e=+g[c>>2];h=+g[c+4>>2];f=+P(+(e*e+h*h));if(f!=0.0){g[a>>2]=e*(i/f);if(+g[c+8>>2]<0.0)d=-d;g[a+8>>2]=d;g[a+4>>2]=h*(i/f);return}else{g[a>>2]=i;if(+g[c+8>>2]<0.0)d=-d;g[a+8>>2]=d;g[a+4>>2]=0.0;return}}function rA(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0;i=+g[b+28>>2];d=+g[b+32>>2];e=+g[c>>2];h=+g[c+8>>2];f=+P(+(e*e+h*h));if(f!=0.0){g[a>>2]=e*(i/f);if(+g[c+4>>2]<0.0)d=-d;g[a+4>>2]=d;g[a+8>>2]=h*(i/f);return}else{g[a>>2]=i;if(+g[c+4>>2]<0.0)d=-d;g[a+4>>2]=d;g[a+8>>2]=0.0;return}}function sA(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0;if((d|0)<=0)return;l=0;do{j=+g[a+28>>2];f=+g[a+32>>2];e=+g[b+(l<<4)>>2];k=+g[b+(l<<4)+8>>2];h=+P(+(e*e+k*k));if(!(h!=0.0))if(+g[b+(l<<4)+4>>2]<0.0){i=j;f=-f;e=0.0}else{i=j;e=0.0}else{if(+g[b+(l<<4)+4>>2]<0.0)f=-f;i=e*(j/h);e=k*(j/h)}g[c+(l<<4)>>2]=i;g[c+(l<<4)+4>>2]=f;g[c+(l<<4)+8>>2]=e;l=l+1|0}while((l|0)!=(d|0));return}function tA(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0;if((d|0)<=0)return;l=0;do{i=+g[a+28>>2];e=+g[a+36>>2];f=+g[b+(l<<4)>>2];j=+g[b+(l<<4)+4>>2];h=+P(+(f*f+j*j));if(!(h!=0.0))if(+g[b+(l<<4)+8>>2]<0.0){k=i;f=0.0;e=-e}else{k=i;f=0.0}else{if(+g[b+(l<<4)+8>>2]<0.0)e=-e;k=f*(i/h);f=j*(i/h)}g[c+(l<<4)>>2]=k;g[c+(l<<4)+4>>2]=f;g[c+(l<<4)+8>>2]=e;l=l+1|0}while((l|0)!=(d|0));return}function uA(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0,f=0.0,h=0,i=0.0,j=0.0,k=0.0,l=0.0,m=0;if((d|0)<=0)return;m=0;do{l=+g[a+32>>2];e=+g[a+28>>2];h=b+(m<<4)|0;f=+g[b+(m<<4)+4>>2];j=+g[b+(m<<4)+8>>2];k=+P(+(f*f+j*j));if(!(k!=0.0))if(+g[h>>2]<0.0){i=-e;f=l;e=0.0}else{i=e;f=l;e=0.0}else{if(+g[h>>2]<0.0)e=-e;i=e;f=f*(l/k);e=j*(l/k)}g[c+(m<<4)>>2]=i;g[c+(m<<4)+4>>2]=f;g[c+(m<<4)+8>>2]=e;m=m+1|0}while((m|0)!=(d|0));return}function vA(a,b){a=a|0;b=+b;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0;h=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);e=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);i=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);h=h+ +g[a+28>>2];e=e+ +g[a+32>>2];i=i+ +g[a+36>>2];g[a+44>>2]=b;f=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);d=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);b=i-+Zb[c[(c[a>>2]|0)+48>>2]&15](a);g[a+28>>2]=h-f;g[a+32>>2]=e-d;g[a+36>>2]=b;g[a+40>>2]=0.0;return}function wA(a){a=a|0;var b=0.0,d=0.0;d=+g[a+28>>2];b=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);+Zb[c[(c[a>>2]|0)+48>>2]&15](a);+Zb[c[(c[a>>2]|0)+48>>2]&15](a);return +(d+b)}function xA(a){a=a|0;return 15968}function yA(a){a=a|0;if(!a)return;c[5134]=(c[5134]|0)+1;_E(c[a+-4>>2]|0);return}function zA(a){a=a|0;var b=0.0,d=0.0;d=+g[a+32>>2];+Zb[c[(c[a>>2]|0)+48>>2]&15](a);b=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);+Zb[c[(c[a>>2]|0)+48>>2]&15](a);return +(d+b)}function AA(a){a=a|0;return 15984}function BA(a){a=a|0;if(!a)return;c[5134]=(c[5134]|0)+1;_E(c[a+-4>>2]|0);return}function CA(a){a=a|0;var b=0.0,d=0.0;d=+g[a+28>>2];b=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);+Zb[c[(c[a>>2]|0)+48>>2]&15](a);+Zb[c[(c[a>>2]|0)+48>>2]&15](a);return +(d+b)}function DA(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0;e=i;i=i+16|0;pc[c[(c[b>>2]|0)+68>>2]&127](e,b,d);c[a+0>>2]=c[e+0>>2];c[a+4>>2]=c[e+4>>2];c[a+8>>2]=c[e+8>>2];c[a+12>>2]=c[e+12>>2];if(!(+Zb[c[(c[b>>2]|0)+48>>2]&15](b)!=0.0)){i=e;return}l=+g[d>>2];j=+g[d+4>>2];h=+g[d+8>>2];f=l*l+j*j+h*h<1.4210854715202004e-14?-1.0:h;k=l*l+j*j+h*h<1.4210854715202004e-14?-1.0:j;l=l*l+j*j+h*h<1.4210854715202004e-14?-1.0:l;h=1.0/+P(+(f*f+(l*l+k*k)));j=+Zb[c[(c[b>>2]|0)+48>>2]&15](b);g[a>>2]=h*l*j+ +g[a>>2];g[a+4>>2]=j*(h*k)+ +g[a+4>>2];g[a+8>>2]=j*(h*f)+ +g[a+8>>2];i=e;return}function EA(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=ec[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;f=ec[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;c[b>>2]=f;if(f)Lb[c[(c[d>>2]|0)+48>>2]&127](d,e);c[b+4>>2]=c[a+4>>2];g[b+28>>2]=+g[a+28>>2];g[b+32>>2]=+g[a+32>>2];g[b+36>>2]=+g[a+36>>2];g[b+40>>2]=+g[a+40>>2];g[b+12>>2]=+g[a+12>>2];g[b+16>>2]=+g[a+16>>2];g[b+20>>2]=+g[a+20>>2];g[b+24>>2]=+g[a+24>>2];g[b+44>>2]=+g[a+44>>2];c[b+52>>2]=c[a+52>>2];return 16e3}function FA(a){a=a|0;return 60}function GA(a,b){a=a|0;b=b|0;c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;g[a+(c[b+52>>2]<<2)>>2]=1.0;return}function HA(a){a=a|0;return 16024}function IA(a,b){a=a|0;b=b|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0;k=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);h=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);d=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);m=(k+ +g[a+28>>2])/+g[a+12>>2];j=(h+ +g[a+32>>2])/+g[a+16>>2];f=(d+ +g[a+36>>2])/+g[a+20>>2];l=+O(+(+g[b>>2]));i=+O(+(+g[b+4>>2]));e=+O(+(+g[b+8>>2]));g[a+12>>2]=l;g[a+16>>2]=i;g[a+20>>2]=e;g[a+24>>2]=0.0;g[a+28>>2]=m*l-k;g[a+32>>2]=j*i-h;g[a+36>>2]=f*e-d;g[a+40>>2]=0.0;return}
function ls(b){b=b|0;var d=0;c[b>>2]=4936;d=c[b+144>>2]|0;if(d){if(a[b+148>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+144>>2]=0}a[b+148>>0]=1;c[b+144>>2]=0;c[b+136>>2]=0;c[b+140>>2]=0;d=c[b+76>>2]|0;if(d){if(a[b+80>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+76>>2]=0}a[b+80>>0]=1;c[b+76>>2]=0;c[b+68>>2]=0;c[b+72>>2]=0;d=c[b+56>>2]|0;if(d){if(a[b+60>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+56>>2]=0}a[b+60>>0]=1;c[b+56>>2]=0;c[b+48>>2]=0;c[b+52>>2]=0;d=c[b+36>>2]|0;if(d){if(a[b+40>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;d=c[b+16>>2]|0;if(!d){a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;b=b+12|0;c[b>>2]=0;return}if(a[b+20>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+16>>2]=0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;b=b+12|0;c[b>>2]=0;return}function ms(a){a=a|0;ls(a);_E(a);return}function ns(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0;h=i;i=i+64|0;a[d+84>>0]=0;c[h+0>>2]=c[b+4>>2];c[h+4>>2]=c[b+8>>2];c[h+8>>2]=c[b+12>>2];c[h+12>>2]=c[b+16>>2];c[h+16>>2]=c[b+20>>2];c[h+20>>2]=c[b+24>>2];c[h+24>>2]=c[b+28>>2];c[h+28>>2]=c[b+32>>2];c[h+32>>2]=c[b+36>>2];c[h+36>>2]=c[b+40>>2];c[h+40>>2]=c[b+44>>2];c[h+44>>2]=c[b+48>>2];c[h+48>>2]=c[b+52>>2];c[h+52>>2]=c[b+56>>2];c[h+56>>2]=c[b+60>>2];c[h+60>>2]=c[b+64>>2];if(e?(f=c[b+480>>2]|0,(f|0)!=0):0)Lb[c[(c[f>>2]|0)+8>>2]&127](f,h);w=+g[d+156>>2];u=+g[h>>2];v=+g[d+160>>2];t=+g[h+4>>2];o=+g[d+164>>2];s=+g[h+8>>2];r=+g[h+16>>2];q=+g[h+20>>2];p=+g[h+24>>2];n=+g[h+32>>2];l=+g[h+36>>2];j=+g[h+40>>2];m=w*r+v*q+o*p+ +g[h+52>>2];k=w*n+v*l+o*j+ +g[h+56>>2];g[d+36>>2]=w*u+v*t+o*s+ +g[h+48>>2];g[d+40>>2]=m;g[d+44>>2]=k;g[d+48>>2]=0.0;k=+g[d+172>>2];m=+g[d+176>>2];o=+g[d+180>>2];g[d+52>>2]=u*k+t*m+s*o;g[d+56>>2]=k*r+m*q+o*p;g[d+60>>2]=k*n+m*l+o*j;g[d+64>>2]=0.0;o=+g[d+188>>2];m=+g[d+192>>2];k=+g[d+196>>2];g[d+68>>2]=u*o+t*m+s*k;g[d+72>>2]=o*r+m*q+k*p;g[d+76>>2]=o*n+m*l+k*j;g[d+80>>2]=0.0;i=h;return}function os(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0;ns(a,b+(c*284|0)|0,d);m=+g[b+(c*284|0)+52>>2];h=+g[b+(c*284|0)+56>>2];q=+g[b+(c*284|0)+60>>2];G=+g[b+(c*284|0)+76>>2];z=+g[b+(c*284|0)+72>>2];y=+g[b+(c*284|0)+68>>2];w=1.0/+P(+((z*-m-y*-h)*(z*-m-y*-h)+((G*-h-z*-q)*(G*-h-z*-q)+(y*-q-G*-m)*(y*-q-G*-m))));v=(G*-h-z*-q)*w;u=w*(y*-q-G*-m);w=w*(z*-m-y*-h);e=+g[b+(c*284|0)+232>>2]*.5;k=+S(+e)/+P(+(m*m+h*h+q*q));e=+R(+e);l=2.0/(e*e+(k*-q*(k*-q)+(k*-m*(k*-m)+k*-h*(k*-h))));E=1.0-(k*-h*(k*-h*l)+k*-q*(k*-q*l));D=k*-m*(k*-h*l)-e*(k*-q*l);F=k*-m*(k*-q*l)+e*(k*-h*l);B=k*-m*(k*-h*l)+e*(k*-q*l);A=1.0-(k*-m*(k*-m*l)+k*-q*(k*-q*l));C=k*-h*(k*-q*l)-e*(k*-m*l);j=k*-m*(k*-q*l)-e*(k*-h*l);e=k*-h*(k*-q*l)+e*(k*-m*l);l=1.0-(k*-m*(k*-m*l)+k*-h*(k*-h*l));k=+g[b+(c*284|0)+236>>2]*-.5;x=+S(+k)/+P(+(G*G+(z*z+y*y)));k=+R(+k);r=2.0/(k*k+(G*x*(G*x)+(y*x*(y*x)+z*x*(z*x))));n=1.0-(z*x*(z*x*r)+G*x*(G*x*r));i=y*x*(z*x*r)-k*(G*x*r);t=y*x*(G*x*r)+k*(z*x*r);o=y*x*(z*x*r)+k*(G*x*r);f=1.0-(y*x*(y*x*r)+G*x*(G*x*r));s=z*x*(G*x*r)-k*(y*x*r);p=y*x*(G*x*r)-k*(z*x*r);k=z*x*(G*x*r)+k*(y*x*r);r=1.0-(y*x*(y*x*r)+z*x*(z*x*r));x=+g[b+(c*284|0)+72>>2];z=+g[b+(c*284|0)+76>>2];g[b+(c*284|0)+92>>2]=z*(E*t+D*s+F*r)+(y*(F*p+(D*o+E*n))+x*(F*k+(E*i+D*f)));g[b+(c*284|0)+96>>2]=w*(E*t+D*s+F*r)+(v*(F*p+(D*o+E*n))+u*(F*k+(E*i+D*f)));g[b+(c*284|0)+100>>2]=(E*t+D*s+F*r)*-q+((F*p+(D*o+E*n))*-m+(F*k+(E*i+D*f))*-h);g[b+(c*284|0)+104>>2]=0.0;g[b+(c*284|0)+108>>2]=z*(B*t+A*s+C*r)+(y*(C*p+(A*o+B*n))+x*(C*k+(B*i+A*f)));g[b+(c*284|0)+112>>2]=w*(B*t+A*s+C*r)+(v*(C*p+(A*o+B*n))+u*(C*k+(B*i+A*f)));g[b+(c*284|0)+116>>2]=(B*t+A*s+C*r)*-q+((C*p+(A*o+B*n))*-m+(C*k+(B*i+A*f))*-h);g[b+(c*284|0)+120>>2]=0.0;g[b+(c*284|0)+124>>2]=z*(j*t+e*s+l*r)+(y*(l*p+(e*o+j*n))+x*(l*k+(j*i+e*f)));g[b+(c*284|0)+128>>2]=w*(j*t+e*s+l*r)+(v*(l*p+(e*o+j*n))+u*(l*k+(j*i+e*f)));g[b+(c*284|0)+132>>2]=(j*t+e*s+l*r)*-q+((l*p+(e*o+j*n))*-m+(l*k+(j*i+e*f))*-h);g[b+(c*284|0)+136>>2]=0.0;h=+g[b+(c*284|0)+32>>2];f=h*+g[b+(c*284|0)+56>>2]+ +g[b+(c*284|0)+40>>2];e=h*+g[b+(c*284|0)+60>>2]+ +g[b+(c*284|0)+44>>2];g[b+(c*284|0)+140>>2]=+g[b+(c*284|0)+52>>2]*h+ +g[b+(c*284|0)+36>>2];g[b+(c*284|0)+144>>2]=f;g[b+(c*284|0)+148>>2]=e;g[b+(c*284|0)+152>>2]=0.0;return}function ps(b,d){b=b|0;d=+d;var e=0,f=0,h=0.0,j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0.0,G=0.0;D=i;i=i+96|0;e=c[b+136>>2]|0;if((e|0)>0){f=0;do{os(c[b+116>>2]|0,c[b+144>>2]|0,f,0);f=f+1|0;e=c[b+136>>2]|0}while((f|0)<(e|0));C=b+116|0}else C=b+116|0;f=c[C>>2]|0;s=+g[f+312>>2];u=+g[f+316>>2];h=+g[f+320>>2];h=+P(+(s*s+u*u+h*h))*3.5999999046325684;g[b+112>>2]=h;B=c[b+128>>2]|0;if(+g[f+(B<<2)+4>>2]*+g[f+312>>2]+ +g[f+(B<<2)+20>>2]*+g[f+316>>2]+ +g[f+(B<<2)+36>>2]*+g[f+320>>2]<0.0)g[b+112>>2]=-h;a:do if((e|0)>0){B=0;e=f;do{A=c[b+144>>2]|0;l=A+(B*284|0)|0;ns(e,l,0);f=A+(B*284|0)+204|0;k=A+(B*284|0)+212|0;q=+g[f>>2]+ +g[k>>2];e=A+(B*284|0)+52|0;v=A+(B*284|0)+56|0;w=A+(B*284|0)+60|0;E=A+(B*284|0)+36|0;x=A+(B*284|0)+16|0;s=q*+g[v>>2]+ +g[A+(B*284|0)+40>>2];u=q*+g[w>>2]+ +g[A+(B*284|0)+44>>2];g[A+(B*284|0)+16>>2]=+g[e>>2]*q+ +g[E>>2];y=A+(B*284|0)+20|0;g[y>>2]=s;z=A+(B*284|0)+24|0;g[z>>2]=u;g[A+(B*284|0)+28>>2]=0.0;g[D+64>>2]=-1.0;j=c[b+100>>2]|0;E=Rb[c[(c[j>>2]|0)+8>>2]&31](j,E,x,D+32|0)|0;j=A+(B*284|0)+88|0;c[j>>2]=0;do if(E){q=q*+g[D+64>>2];c[l+0>>2]=c[D+48>>2];c[l+4>>2]=c[D+52>>2];c[l+8>>2]=c[D+56>>2];c[l+12>>2]=c[D+60>>2];a[A+(B*284|0)+84>>0]=1;if((a[4920]|0)==0?(Xa(4920)|0)!=0:0){c[D+72>>2]=0;c[D+76>>2]=0;c[D+80>>2]=0;c[D+84>>2]=0;Cp(4304,0.0,0,0,D+72|0);ab(4920)}c[1127]=c[1127]|1;g[1162]=0.0;p=+g[1172]*0.0;o=+g[1173]*0.0;g[1167]=+g[1171]*0.0;g[1168]=p;g[1169]=o;g[1170]=0.0;c[1175]=0;c[1176]=0;c[1177]=0;c[1178]=0;o=+g[1164]*0.0;p=+g[1165]*0.0;g[1216]=+g[1163]*0.0;g[1217]=o;g[1218]=p;g[1219]=0.0;c[j>>2]=4304;q=q-+g[k>>2];k=A+(B*284|0)+32|0;g[k>>2]=q;p=+g[f>>2];o=+g[A+(B*284|0)+208>>2]*.009999999776482582;if(q<p-o){g[k>>2]=p-o;q=p-o}if(q>p+o)g[k>>2]=p+o;c[x+0>>2]=c[D+32>>2];c[x+4>>2]=c[D+36>>2];c[x+8>>2]=c[D+40>>2];c[x+12>>2]=c[D+44>>2];s=+g[l>>2];t=+g[A+(B*284|0)+4>>2];u=+g[A+(B*284|0)+8>>2];r=s*+g[e>>2]+t*+g[v>>2]+u*+g[w>>2];k=c[C>>2]|0;h=+g[x>>2]-+g[k+52>>2];n=+g[y>>2]-+g[k+56>>2];q=+g[z>>2]-+g[k+60>>2];p=+g[k+332>>2];o=+g[k+336>>2];m=+g[k+328>>2];if(!(r>=-.10000000149011612)){g[A+(B*284|0)+272>>2]=-1.0/r*(s*(p*q-n*o+ +g[k+312>>2])+t*(h*o-q*m+ +g[k+316>>2])+u*(n*m-h*p+ +g[k+320>>2]));g[A+(B*284|0)+268>>2]=-1.0/r;break}else{g[A+(B*284|0)+272>>2]=0.0;g[A+(B*284|0)+268>>2]=10.0;break}}else{g[A+(B*284|0)+32>>2]=+g[f>>2];g[A+(B*284|0)+272>>2]=0.0;s=-+g[v>>2];u=-+g[w>>2];g[l>>2]=-+g[e>>2];g[A+(B*284|0)+4>>2]=s;g[A+(B*284|0)+8>>2]=u;g[A+(B*284|0)+12>>2]=0.0;g[A+(B*284|0)+268>>2]=1.0}while(0);B=B+1|0;l=c[b+136>>2]|0;e=c[C>>2]|0}while((B|0)<(l|0));h=1.0/+g[e+344>>2];if((l|0)>0){j=c[b+144>>2]|0;k=0;do{if(a[j+(k*284|0)+84>>0]|0){u=+g[j+(k*284|0)+272>>2];u=h*(+g[j+(k*284|0)+216>>2]*(+g[j+(k*284|0)+204>>2]-+g[j+(k*284|0)+32>>2])*+g[j+(k*284|0)+268>>2]-u*+g[(u<0.0?j+(k*284|0)+220|0:j+(k*284|0)+224|0)>>2]);f=j+(k*284|0)+276|0;g[f>>2]=u;if(u<0.0)g[f>>2]=0.0}else g[j+(k*284|0)+276>>2]=0.0;k=k+1|0}while((k|0)!=(l|0));f=0;while(1){r=+g[j+(f*284|0)+276>>2];u=+g[j+(f*284|0)+248>>2];r=r>u?u:r;u=r*+g[j+(f*284|0)+4>>2]*d;s=r*+g[j+(f*284|0)+8>>2]*d;g[D+16>>2]=+g[j+(f*284|0)>>2]*r*d;g[D+20>>2]=u;g[D+24>>2]=s;g[D+28>>2]=0.0;s=+g[j+(f*284|0)+20>>2]-+g[e+56>>2];u=+g[j+(f*284|0)+24>>2]-+g[e+60>>2];g[D>>2]=+g[j+(f*284|0)+16>>2]-+g[e+52>>2];g[D+4>>2]=s;g[D+8>>2]=u;g[D+12>>2]=0.0;gn(e,D+16|0,D);f=f+1|0;if((f|0)>=(c[b+136>>2]|0))break a;j=c[b+144>>2]|0;e=c[C>>2]|0}}}while(0);Ib[c[(c[b>>2]|0)+20>>2]&31](b,d);f=c[b+136>>2]|0;if((f|0)<=0){i=D;return}l=c[b+144>>2]|0;k=c[C>>2]|0;j=0;do{h=+g[l+(j*284|0)+36>>2]-+g[k+52>>2];m=+g[l+(j*284|0)+40>>2]-+g[k+56>>2];n=+g[l+(j*284|0)+44>>2]-+g[k+60>>2];o=+g[k+332>>2];p=+g[k+336>>2];q=+g[k+328>>2];if(!(a[l+(j*284|0)+84>>0]|0)){h=+g[l+(j*284|0)+240>>2];C=l+(j*284|0)+236|0;g[C>>2]=h+ +g[C>>2]}else{C=c[b+128>>2]|0;G=+g[k+(C<<2)+4>>2];t=+g[k+(C<<2)+20>>2];s=+g[k+(C<<2)+36>>2];F=+g[l+(j*284|0)>>2];r=+g[l+(j*284|0)+4>>2];u=+g[l+(j*284|0)+8>>2];h=((m*q-h*o+ +g[k+320>>2])*(s-u*(G*F+t*r+s*u))+((o*n-m*p+ +g[k+312>>2])*(G-F*(G*F+t*r+s*u))+(h*p-n*q+ +g[k+316>>2])*(t-r*(G*F+t*r+s*u))))*d/+g[l+(j*284|0)+212>>2];g[l+(j*284|0)+240>>2]=h;C=l+(j*284|0)+236|0;g[C>>2]=h+ +g[C>>2]}g[l+(j*284|0)+240>>2]=h*.9900000095367432;j=j+1|0}while((j|0)!=(f|0));i=D;return}function qs(b,d){b=b|0;d=+d;var e=0,f=0,h=0,j=0,k=0.0,l=0,m=0.0,n=0,o=0,p=0.0,q=0.0,r=0,s=0,t=0.0,u=0,v=0.0,w=0.0,x=0.0,y=0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,Q=0.0,R=0.0;u=i;i=i+384|0;o=c[b+136>>2]|0;if(!o){i=u;return}l=c[b+8>>2]|0;if((l|0)<(o|0)){if((c[b+12>>2]|0)<(o|0)){c[5132]=(c[5132]|0)+1;e=ZE((o<<4|3)+16|0)|0;if(!e)f=0;else{c[(e+19&-16)+-4>>2]=e;f=e+19&-16}j=c[b+8>>2]|0;if((j|0)>0){h=0;do{n=f+(h<<4)|0;r=(c[b+16>>2]|0)+(h<<4)|0;c[n+0>>2]=c[r+0>>2];c[n+4>>2]=c[r+4>>2];c[n+8>>2]=c[r+8>>2];c[n+12>>2]=c[r+12>>2];h=h+1|0}while((h|0)!=(j|0))}h=c[b+16>>2]|0;if(h){if(a[b+20>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[h+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=f;c[b+12>>2]=o;f=b+16|0}else f=b+16|0;e=l;do{n=(c[f>>2]|0)+(e<<4)|0;c[n+0>>2]=c[u+328>>2];c[n+4>>2]=c[u+332>>2];c[n+8>>2]=c[u+336>>2];c[n+12>>2]=c[u+340>>2];e=e+1|0}while((e|0)!=(o|0))}c[b+8>>2]=o;l=c[b+28>>2]|0;if((l|0)<(o|0)){if((c[b+32>>2]|0)<(o|0)){c[5132]=(c[5132]|0)+1;e=ZE((o<<4|3)+16|0)|0;if(!e)f=0;else{c[(e+19&-16)+-4>>2]=e;f=e+19&-16}j=c[b+28>>2]|0;if((j|0)>0){h=0;do{n=f+(h<<4)|0;r=(c[b+36>>2]|0)+(h<<4)|0;c[n+0>>2]=c[r+0>>2];c[n+4>>2]=c[r+4>>2];c[n+8>>2]=c[r+8>>2];c[n+12>>2]=c[r+12>>2];h=h+1|0}while((h|0)!=(j|0))}h=c[b+36>>2]|0;if(h){if(a[b+40>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[h+-4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=f;c[b+32>>2]=o;f=b+36|0}else f=b+36|0;e=l;do{n=(c[f>>2]|0)+(e<<4)|0;c[n+0>>2]=c[u+360>>2];c[n+4>>2]=c[u+364>>2];c[n+8>>2]=c[u+368>>2];c[n+12>>2]=c[u+372>>2];e=e+1|0}while((e|0)!=(o|0))}c[b+28>>2]=o;j=c[b+48>>2]|0;if((j|0)<(o|0)){if((c[b+52>>2]|0)<(o|0)){c[5132]=(c[5132]|0)+1;e=ZE((o<<2|3)+16|0)|0;if(!e)h=0;else{c[(e+19&-16)+-4>>2]=e;h=e+19&-16}f=c[b+48>>2]|0;if((f|0)>0){l=0;do{e=h+(l<<2)|0;if(e)g[e>>2]=+g[(c[b+56>>2]|0)+(l<<2)>>2];l=l+1|0}while((l|0)!=(f|0))}f=c[b+56>>2]|0;if(f){if(a[b+60>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[f+-4>>2]|0)}c[b+56>>2]=0}a[b+60>>0]=1;c[b+56>>2]=h;c[b+52>>2]=o}else h=c[b+56>>2]|0;do{f=h+(j<<2)|0;if(f)g[f>>2]=0.0;j=j+1|0}while((j|0)!=(o|0))}c[b+48>>2]=o;j=c[b+68>>2]|0;if((j|0)<(o|0)){if((c[b+72>>2]|0)<(o|0)){c[5132]=(c[5132]|0)+1;e=ZE((o<<2|3)+16|0)|0;if(!e)h=0;else{c[(e+19&-16)+-4>>2]=e;h=e+19&-16}f=c[b+68>>2]|0;if((f|0)>0){l=0;do{e=h+(l<<2)|0;if(e)g[e>>2]=+g[(c[b+76>>2]|0)+(l<<2)>>2];l=l+1|0}while((l|0)!=(f|0))}f=c[b+76>>2]|0;if(f){if(a[b+80>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[f+-4>>2]|0)}c[b+76>>2]=0}a[b+80>>0]=1;c[b+76>>2]=h;c[b+72>>2]=o}else h=c[b+76>>2]|0;do{f=h+(j<<2)|0;if(f)g[f>>2]=0.0;j=j+1|0}while((j|0)!=(o|0))}c[b+68>>2]=o;e=c[b+136>>2]|0;if((e|0)<=0){i=u;return}f=c[b+76>>2]|0;h=c[b+56>>2]|0;j=0;do{g[f+(j<<2)>>2]=0.0;g[h+(j<<2)>>2]=0.0;j=j+1|0}while((j|0)!=(e|0));r=0;do{n=c[b+144>>2]|0;o=c[n+(r*284|0)+88>>2]|0;if(o){j=n+(r*284|0)+92|0;c[u+168>>2]=c[j+0>>2];c[u+172>>2]=c[j+4>>2];c[u+176>>2]=c[j+8>>2];c[u+180>>2]=c[j+12>>2];j=n+(r*284|0)+108|0;c[u+184>>2]=c[j+0>>2];c[u+188>>2]=c[j+4>>2];c[u+192>>2]=c[j+8>>2];c[u+196>>2]=c[j+12>>2];j=n+(r*284|0)+124|0;c[u+200>>2]=c[j+0>>2];c[u+204>>2]=c[j+4>>2];c[u+208>>2]=c[j+8>>2];c[u+212>>2]=c[j+12>>2];j=c[b+36>>2]|0;y=c[b+120>>2]|0;p=+g[u+168+(y<<2)+16>>2];z=+g[u+168+(y<<2)+32>>2];g[j+(r<<4)>>2]=+g[u+168+(y<<2)>>2];g[j+(r<<4)+4>>2]=p;g[j+(r<<4)+8>>2]=z;g[j+(r<<4)+12>>2]=0.0;j=c[b+36>>2]|0;y=j+(r<<4)|0;z=+g[y>>2];h=n+(r*284|0)|0;p=+g[h>>2];l=j+(r<<4)+4|0;x=+g[l>>2];f=n+(r*284|0)+4|0;m=+g[f>>2];j=j+(r<<4)+8|0;k=+g[j>>2];e=n+(r*284|0)+8|0;w=+g[e>>2];q=z-p*(z*p+x*m+k*w);v=x-m*(z*p+x*m+k*w);w=k-w*(z*p+x*m+k*w);k=1.0/+P(+(q*q+v*v+w*w));g[y>>2]=q*k;g[l>>2]=v*k;g[j>>2]=w*k;j=c[b+16>>2]|0;m=+g[f>>2];x=+g[e>>2];p=+g[h>>2];g[j+(r<<4)>>2]=m*(w*k)-x*(v*k);g[j+(r<<4)+4>>2]=x*(q*k)-w*k*p;g[j+(r<<4)+8>>2]=v*k*p-m*(q*k);g[j+(r<<4)+12>>2]=0.0;j=c[b+16>>2]|0;h=j+(r<<4)|0;k=+g[h>>2];e=j+(r<<4)+4|0;q=+g[e>>2];j=j+(r<<4)+8|0;m=+g[j>>2];p=1.0/+P(+(k*k+q*q+m*m));g[h>>2]=k*p;g[e>>2]=q*p;g[j>>2]=m*p;j=c[b+116>>2]|0;e=c[b+36>>2]|0;h=e+(r<<4)|0;f=(c[b+76>>2]|0)+(r<<2)|0;p=+g[h>>2];l=e+(r<<4)+4|0;m=+g[l>>2];e=e+(r<<4)+8|0;q=+g[e>>2];if(p*p+m*m+q*q>1.100000023841858)g[f>>2]=0.0;else{x=+g[n+(r*284|0)+16>>2];p=x-+g[j+52>>2];m=+g[n+(r*284|0)+20>>2];B=m-+g[j+56>>2];w=+g[n+(r*284|0)+24>>2];D=w-+g[j+60>>2];g[u+344>>2]=p;g[u+348>>2]=B;g[u+352>>2]=D;g[u+356>>2]=0.0;x=x-+g[o+52>>2];m=m-+g[o+56>>2];w=w-+g[o+60>>2];g[u+312>>2]=x;g[u+316>>2]=m;g[u+320>>2]=w;g[u+324>>2]=0.0;k=+g[j+332>>2];E=+g[j+336>>2];A=+g[j+328>>2];q=+g[o+332>>2];C=+g[o+336>>2];v=+g[o+328>>2];z=k*D-E*B+ +g[j+312>>2]-(q*w-C*m+ +g[o+312>>2]);w=+g[j+316>>2]+(E*p-D*A)-(+g[o+316>>2]+(C*x-w*v));x=B*A-k*p+ +g[j+320>>2]-(m*v-q*x+ +g[o+320>>2]);g[u+32>>2]=+g[j+4>>2];g[u+36>>2]=+g[j+20>>2];g[u+40>>2]=+g[j+36>>2];g[u+44>>2]=0.0;g[u+48>>2]=+g[j+8>>2];g[u+52>>2]=+g[j+24>>2];g[u+56>>2]=+g[j+40>>2];g[u+60>>2]=0.0;g[u+64>>2]=+g[j+12>>2];g[u+68>>2]=+g[j+28>>2];g[u+72>>2]=+g[j+44>>2];g[u+76>>2]=0.0;g[u+264>>2]=+g[o+4>>2];g[u+268>>2]=+g[o+20>>2];g[u+272>>2]=+g[o+36>>2];g[u+276>>2]=0.0;g[u+280>>2]=+g[o+8>>2];g[u+284>>2]=+g[o+24>>2];g[u+288>>2]=+g[o+40>>2];g[u+292>>2]=0.0;g[u+296>>2]=+g[o+12>>2];g[u+300>>2]=+g[o+28>>2];g[u+304>>2]=+g[o+44>>2];g[u+308>>2]=0.0;Tq(u+80|0,u+32|0,u+264|0,u+344|0,u+312|0,h,j+396|0,+g[j+344>>2],o+396|0,+g[o+344>>2]);g[f>>2]=1.0/+g[u+160>>2]*((z*+g[h>>2]+w*+g[l>>2]+x*+g[e>>2])*-.20000000298023224)}e=c[b+136>>2]|0}r=r+1|0}while((r|0)<(e|0));if((e|0)<=0){i=u;return}h=c[b+144>>2]|0;l=0;r=0;while(1){j=c[h+(r*284|0)+88>>2]|0;if(j){m=+g[h+(r*284|0)+252>>2];if(m!=0.0){n=c[b+56>>2]|0;o=n+(r<<2)|0;g[o>>2]=0.0;j=h+(r*284|0)+280|0;g[j>>2]=1.0;f=h;q=m*d}else{E=+g[h+(r*284|0)+256>>2];E=E!=0.0?E:0.0;f=c[b+116>>2]|0;n=c[b+16>>2]|0;w=+g[h+(r*284|0)+16>>2];v=+g[h+(r*284|0)+20>>2];F=+g[h+(r*284|0)+24>>2];H=+g[n+(r<<4)>>2];m=+g[n+(r<<4)+4>>2];q=+g[n+(r<<4)+8>>2];O=w-+g[f+52>>2];Q=v-+g[f+56>>2];M=F-+g[f+60>>2];L=+g[f+264>>2]*(Q*q-M*m)+ +g[f+280>>2]*(M*H-O*q)+(O*m-Q*H)*+g[f+296>>2];R=(Q*q-M*m)*+g[f+268>>2]+(M*H-O*q)*+g[f+284>>2]+(O*m-Q*H)*+g[f+300>>2];N=(Q*q-M*m)*+g[f+272>>2]+(M*H-O*q)*+g[f+288>>2]+(O*m-Q*H)*+g[f+304>>2];C=w-+g[j+52>>2];A=v-+g[j+56>>2];p=F-+g[j+60>>2];I=(m*C-H*A)*+g[j+296>>2]+(+g[j+264>>2]*(q*A-m*p)+ +g[j+280>>2]*(H*p-q*C));K=(q*A-m*p)*+g[j+268>>2]+(H*p-q*C)*+g[j+284>>2]+(m*C-H*A)*+g[j+300>>2];J=(q*A-m*p)*+g[j+272>>2]+(H*p-q*C)*+g[j+288>>2]+(m*C-H*A)*+g[j+304>>2];w=w-+g[f+52>>2];v=v-+g[f+56>>2];F=F-+g[f+60>>2];x=+g[f+332>>2];G=+g[f+336>>2];z=+g[f+328>>2];D=+g[j+332>>2];k=+g[j+336>>2];B=+g[j+328>>2];q=-(1.0/(+g[f+344>>2]+(q*(Q*L-O*R)+(H*(M*R-Q*N)+m*(O*N-M*L)))+(+g[j+344>>2]+(q*(A*I-C*K)+(H*(p*K-A*J)+m*(C*J-p*I)))))*((F*x-v*G+ +g[f+312>>2]-(p*D-A*k+ +g[j+312>>2]))*H+(+g[f+316>>2]+(w*G-F*z)-(+g[j+316>>2]+(C*k-p*B)))*m+(v*z-w*x+ +g[f+320>>2]-(A*B-C*D+ +g[j+320>>2]))*q));q=E<q?E:q;f=c[b+144>>2]|0;n=c[b+56>>2]|0;o=n+(r<<2)|0;g[o>>2]=0.0;j=f+(r*284|0)+280|0;g[j>>2]=1.0;q=q<-E?-E:q}g[j>>2]=1.0;p=+g[h+(r*284|0)+276>>2]*d*+g[h+(r*284|0)+228>>2];g[o>>2]=q;k=q*.5;m=+g[(c[b+76>>2]|0)+(r<<2)>>2];if(k*k+m*m>p*p){R=p/+P(+(k*k+m*m));g[j>>2]=R*+g[j>>2];o=f;j=1}else{o=f;j=l}}else{n=c[b+56>>2]|0;g[n+(r<<2)>>2]=0.0;g[h+(r*284|0)+280>>2]=1.0;o=h;j=l}r=r+1|0;l=c[b+136>>2]|0;if((r|0)>=(l|0))break;else{h=o;l=j}}if(j){if((l|0)<=0){i=u;return}j=c[b+76>>2]|0;f=0;do{h=j+(f<<2)|0;if(+g[h>>2]!=0.0?(s=o+(f*284|0)+280|0,t=+g[s>>2],t<1.0):0){y=n+(f<<2)|0;g[y>>2]=t*+g[y>>2];g[h>>2]=+g[s>>2]*+g[h>>2]}f=f+1|0}while((f|0)!=(l|0))}if((l|0)<=0){i=u;return}l=o;h=n;e=0;while(1){j=c[b+116>>2]|0;o=l+(e*284|0)+16|0;m=+g[o>>2]-+g[j+52>>2];n=l+(e*284|0)+20|0;p=+g[n>>2]-+g[j+56>>2];f=l+(e*284|0)+24|0;q=+g[f>>2]-+g[j+60>>2];g[u>>2]=m;g[u+4>>2]=p;g[u+8>>2]=q;g[u+12>>2]=0.0;k=+g[h+(e<<2)>>2];if(k!=0.0){y=c[b+16>>2]|0;Q=k*+g[y+(e<<4)+4>>2];R=k*+g[y+(e<<4)+8>>2];g[u+232>>2]=k*+g[y+(e<<4)>>2];g[u+236>>2]=Q;g[u+240>>2]=R;g[u+244>>2]=0.0;gn(j,u+232|0,u)}k=+g[(c[b+76>>2]|0)+(e<<2)>>2];if(k!=0.0){y=c[(c[b+144>>2]|0)+(e*284|0)+88>>2]|0;Q=+g[n>>2]-+g[y+56>>2];O=+g[f>>2]-+g[y+60>>2];g[u+16>>2]=+g[o>>2]-+g[y+52>>2];g[u+20>>2]=Q;g[u+24>>2]=O;g[u+28>>2]=0.0;o=c[b+36>>2]|0;O=+g[o+(e<<4)>>2]*k;Q=k*+g[o+(e<<4)+4>>2];R=k*+g[o+(e<<4)+8>>2];g[u+248>>2]=O;g[u+252>>2]=Q;g[u+256>>2]=R;g[u+260>>2]=0.0;o=c[b+116>>2]|0;n=c[b+124>>2]|0;I=+g[o+(n<<2)+4>>2];J=+g[o+(n<<2)+20>>2];M=+g[o+(n<<2)+36>>2];N=(I*m+J*p+M*q)*(1.0-+g[l+(e*284|0)+244>>2]);g[u>>2]=m-I*N;g[u+4>>2]=p-J*N;g[u+8>>2]=q-M*N;gn(o,u+248|0,u);g[u+216>>2]=-O;g[u+220>>2]=-Q;g[u+224>>2]=-R;g[u+228>>2]=0.0;gn(y,u+216|0,u+16|0)}e=e+1|0;if((e|0)>=(c[b+136>>2]|0))break;l=c[b+144>>2]|0;h=c[b+56>>2]|0}i=u;return}function rs(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0.0,k=0.0,l=0,m=0;f=i;i=i+48|0;if((c[b+136>>2]|0)<=0){i=f;return}e=0;do{m=c[b+144>>2]|0;g[f+32>>2]=(a[m+(e*284|0)+84>>0]|0)==0?1.0:0.0;g[f+36>>2]=0.0;g[f+40>>2]=1.0;g[f+44>>2]=0.0;l=m+(e*284|0)+140|0;c[f+16>>2]=c[l+0>>2];c[f+20>>2]=c[l+4>>2];c[f+24>>2]=c[l+8>>2];c[f+28>>2]=c[l+12>>2];l=c[b+120>>2]|0;h=c[(c[d>>2]|0)+8>>2]|0;k=+g[m+(e*284|0)+(l<<2)+108>>2]+ +g[f+20>>2];j=+g[m+(e*284|0)+(l<<2)+124>>2]+ +g[f+24>>2];g[f>>2]=+g[m+(e*284|0)+(l<<2)+92>>2]+ +g[f+16>>2];g[f+4>>2]=k;g[f+8>>2]=j;g[f+12>>2]=0.0;tc[h&127](d,f+16|0,f,f+32|0);tc[c[(c[d>>2]|0)+8>>2]&127](d,f+16|0,(c[b+144>>2]|0)+(e*284|0)+16|0,f+32|0);e=e+1|0}while((e|0)<(c[b+136>>2]|0));i=f;return}function ss(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;var h=0,j=0.0,k=0.0,l=0.0,m=0.0;h=i;i=i+96|0;g[h+4>>2]=1.0;c[h+8>>2]=0;b[h+12>>1]=1;b[h+14>>1]=-1;c[h+16>>2]=0;c[h>>2]=624;c[h+20>>2]=c[d+0>>2];c[h+24>>2]=c[d+4>>2];c[h+28>>2]=c[d+8>>2];c[h+32>>2]=c[d+12>>2];c[h+36>>2]=c[e+0>>2];c[h+40>>2]=c[e+4>>2];c[h+44>>2]=c[e+8>>2];c[h+48>>2]=c[e+12>>2];a=c[a+4>>2]|0;tc[c[(c[a>>2]|0)+32>>2]&127](a,d,e,h);d=c[h+8>>2]|0;if(!d){f=0;i=h;return f|0}d=(c[d+236>>2]&2|0)==0?0:d;if(!d){f=0;i=h;return f|0}if(c[d+204>>2]&4){f=0;i=h;return f|0}c[f+0>>2]=c[h+68>>2];c[f+4>>2]=c[h+72>>2];c[f+8>>2]=c[h+76>>2];c[f+12>>2]=c[h+80>>2];c[f+16>>2]=c[h+52>>2];c[f+20>>2]=c[h+56>>2];c[f+24>>2]=c[h+60>>2];c[f+28>>2]=c[h+64>>2];m=+g[f+16>>2];l=+g[f+20>>2];k=+g[f+24>>2];j=1.0/+P(+(m*m+l*l+k*k));g[f+16>>2]=m*j;g[f+20>>2]=l*j;g[f+24>>2]=k*j;g[f+32>>2]=+g[h+4>>2];f=d;i=h;return f|0}function ts(a){a=a|0;_E(a);return}function us(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[a+120>>2]=b;c[a+124>>2]=d;c[a+128>>2]=e;return}function vs(a,b,d){a=a|0;b=b|0;d=+d;Ib[c[(c[a>>2]|0)+16>>2]&31](a,d);return}function ws(b){b=b|0;var d=0;c[b>>2]=5120;d=c[b+140>>2]|0;if(d){if(a[b+144>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+140>>2]=0}a[b+144>>0]=1;c[b+140>>2]=0;c[b+132>>2]=0;c[b+136>>2]=0;return}function xs(b){b=b|0;var d=0;c[b>>2]=5120;d=c[b+140>>2]|0;if(d){if(a[b+144>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}a[b+144>>0]=1;c[b+140>>2]=0;c[b+132>>2]=0;c[b+136>>2]=0;if(!b)return}else{a[b+144>>0]=1;c[b+140>>2]=0;c[b+132>>2]=0;c[b+136>>2]=0}c[5134]=(c[5134]|0)+1;_E(c[b+-4>>2]|0);return}function ys(d,e,f,h,j){d=d|0;e=e|0;f=+f;h=+h;j=+j;var k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0;q=i;i=i+240|0;o=+g[d+96>>2]+h;p=+g[d+100>>2]+j;g[d+112>>2]=+g[d+92>>2]+f;g[d+116>>2]=o;g[d+120>>2]=p;g[d+124>>2]=0.0;g[q+168>>2]=1.0;c[q+172>>2]=0;c[q+176>>2]=0;c[q+180>>2]=0;c[q+184>>2]=0;g[q+188>>2]=1.0;c[q+192>>2]=0;c[q+196>>2]=0;c[q+200>>2]=0;c[q+204>>2]=0;g[q+208>>2]=1.0;k=q+212|0;c[k+0>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;g[q+104>>2]=1.0;c[q+108>>2]=0;c[q+112>>2]=0;c[q+116>>2]=0;c[q+120>>2]=0;g[q+124>>2]=1.0;c[q+128>>2]=0;c[q+132>>2]=0;c[q+136>>2]=0;c[q+140>>2]=0;g[q+144>>2]=1.0;k=q+148|0;c[k+0>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;p=1.0;k=10;while(1){if((k|0)<=0){k=13;break};k=k+-1|0;c[q+216>>2]=c[d+92>>2];c[q+220>>2]=c[d+96>>2];c[q+224>>2]=c[d+100>>2];c[q+228>>2]=c[d+104>>2];c[q+152>>2]=c[d+112>>2];c[q+156>>2]=c[d+116>>2];c[q+160>>2]=c[d+120>>2];c[q+164>>2]=c[d+124>>2];n=+g[d+92>>2]-+g[d+112>>2];o=+g[d+96>>2]-+g[d+116>>2];f=+g[d+100>>2]-+g[d+120>>2];r=c[d+8>>2]|0;g[q+4>>2]=1.0;c[q+76>>2]=0;c[q+12>>2]=0;c[q+16>>2]=0;c[q+20>>2]=0;c[q+24>>2]=0;c[q+28>>2]=0;c[q+32>>2]=0;c[q+36>>2]=0;c[q+40>>2]=0;c[q>>2]=5352;c[q+80>>2]=r;g[q+84>>2]=n;g[q+88>>2]=o;g[q+92>>2]=f;g[q+96>>2]=0.0;g[q+100>>2]=0.0;r=c[r+188>>2]|0;b[q+8>>1]=b[r+4>>1]|0;b[q+10>>1]=b[r+6>>1]|0;r=c[d+12>>2]|0;f=+Zb[c[(c[r>>2]|0)+48>>2]&15](r);r=c[d+12>>2]|0;Ib[c[(c[r>>2]|0)+44>>2]&31](r,f+ +g[d+56>>2]);if(!(a[d+170>>0]|0))hv(e,c[d+12>>2]|0,q+168|0,q+104|0,q,+g[e+56>>2]);else $s(c[d+8>>2]|0,c[d+12>>2]|0,q+168|0,q+104|0,q,+g[e+56>>2]);r=c[d+12>>2]|0;Ib[c[(c[r>>2]|0)+44>>2]&31](r,f);o=+g[q+4>>2];p=p-o;if(o<1.0){h=+g[d+112>>2];m=+g[d+92>>2];f=+g[d+116>>2];n=+g[d+96>>2];l=+g[d+120>>2];o=+g[d+100>>2];j=+P(+((h-m)*(h-m)+(f-n)*(f-n)+(l-o)*(l-o)));if(j>1.1920928955078125e-07){v=+g[q+44>>2];t=+g[q+48>>2];x=+g[q+52>>2];w=((h-m)*(1.0/j)*v+(f-n)*(1.0/j)*t+(l-o)*(1.0/j)*x)*2.0;u=(h-m)*(1.0/j)-v*w;s=(f-n)*(1.0/j)-t*w;w=(l-o)*(1.0/j)-x*w;l=1.0/+P(+(w*w+(u*u+s*s)));c[d+112>>2]=c[d+92>>2];c[d+116>>2]=c[d+96>>2];c[d+120>>2]=c[d+100>>2];c[d+124>>2]=c[d+104>>2];h=j*(l*u-v*(x*(l*w)+(v*(l*u)+t*(l*s))))+ +g[d+112>>2];g[d+112>>2]=h;f=j*(l*s-t*(x*(l*w)+(v*(l*u)+t*(l*s))))+ +g[d+116>>2];g[d+116>>2]=f;l=j*(l*w-x*(x*(l*w)+(v*(l*u)+t*(l*s))))+ +g[d+120>>2];g[d+120>>2]=l;j=f}else j=f;f=h-m;h=j-n;j=l-o;if(!(f*f+h*h+j*j>1.1920928955078125e-07)){k=13;break}x=1.0/+P(+(f*f+h*h+j*j));if(f*x*+g[d+76>>2]+h*x*+g[d+80>>2]+j*x*+g[d+84>>2]<=0.0){k=13;break}}else{c[d+92>>2]=c[d+112>>2];c[d+96>>2]=c[d+116>>2];c[d+100>>2]=c[d+120>>2];c[d+104>>2]=c[d+124>>2]}if(!(p>.009999999776482582)){k=13;break}}if((k|0)==13){i=q;return}}function zs(b,d){b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;a[b+171>>0]=1;c[b+60>>2]=c[d+0>>2];c[b+64>>2]=c[d+4>>2];c[b+68>>2]=c[d+8>>2];c[b+72>>2]=c[d+12>>2];e=+g[b+60>>2];f=+g[b+64>>2];j=+g[b+68>>2];h=1.0/+P(+(e*e+f*f+j*j));if(+P(+(j*h*(j*h)+(e*h*(e*h)+f*h*(f*h))))<1.1920928955078125e-07){k=0.0;i=0.0;e=0.0;f=0.0}else{k=e*h;i=f*h;e=j*h;f=+g[b+72>>2]}g[b+76>>2]=k;g[b+80>>2]=i;g[b+84>>2]=e;g[b+88>>2]=f;return}function As(b,d,e){b=b|0;d=d|0;e=+e;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0;a[b+171>>0]=0;c[b+60>>2]=c[d+0>>2];c[b+64>>2]=c[d+4>>2];c[b+68>>2]=c[d+8>>2];c[b+72>>2]=c[d+12>>2];f=+g[b+60>>2];h=+g[b+64>>2];k=+g[b+68>>2];i=1.0/+P(+(f*f+h*h+k*k));if(+P(+(k*i*(k*i)+(f*i*(f*i)+h*i*(h*i))))<1.1920928955078125e-07){l=0.0;j=0.0;f=0.0;h=0.0}else{l=f*i;j=h*i;f=k*i;h=+g[b+72>>2]}g[b+76>>2]=l;g[b+80>>2]=j;g[b+84>>2]=f;g[b+88>>2]=h;g[b+172>>2]=+g[b+172>>2]+e;return}function Bs(b,d){b=b|0;d=d|0;var e=0,f=0,h=0;g[b+16>>2]=0.0;g[b+20>>2]=0.0;a[b+168>>0]=0;a[b+169>>0]=0;g[b+172>>2]=0.0;c[b+60>>2]=0;c[b+64>>2]=0;c[b+68>>2]=0;c[b+72>>2]=0;b=c[(c[b+8>>2]|0)+284>>2]|0;if((c[(Nb[c[(c[b>>2]|0)+28>>2]&127](b)|0)+4>>2]|0)<=0)return;do{f=c[b>>2]|0;h=c[f+12>>2]|0;f=c[c[(Nb[c[f+28>>2]&127](b)|0)+12>>2]>>2]|0;e=c[(c[(Nb[c[(c[b>>2]|0)+28>>2]&127](b)|0)+12>>2]|0)+4>>2]|0;Rb[h&31](b,f,e,c[d+24>>2]|0)|0}while((c[(Nb[c[(c[b>>2]|0)+28>>2]&127](b)|0)+4>>2]|0)>0);return}function Cs(a,b){a=a|0;b=b|0;var d=0;d=i;i=i+32|0;c[d+16>>2]=0;c[d+20>>2]=0;c[d+24>>2]=0;c[d+28>>2]=0;c[d+0>>2]=c[b+0>>2];c[d+4>>2]=c[b+4>>2];c[d+8>>2]=c[b+8>>2];c[d+12>>2]=c[b+12>>2];a=c[a+8>>2]|0;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+4>>2]=1.0;c[a+8>>2]=c[d+16>>2];c[a+12>>2]=c[d+20>>2];c[a+16>>2]=c[d+24>>2];c[a+20>>2]=0;g[a+24>>2]=1.0;c[a+28>>2]=0;c[a+32>>2]=0;c[a+36>>2]=0;c[a+40>>2]=0;g[a+44>>2]=1.0;g[a+48>>2]=0.0;c[a+52>>2]=c[d+0>>2];c[a+56>>2]=c[d+4>>2];c[a+60>>2]=c[d+8>>2];c[a+64>>2]=c[d+12>>2];i=d;return}function Ds(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0.0,k=0,l=0.0,m=0,n=0,o=0.0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0.0,y=0.0;w=i;i=i+96|0;a[b+148>>0]=0;u=0;while(1){q=c[b+12>>2]|0;tc[c[(c[q>>2]|0)+8>>2]&127](q,(c[b+8>>2]|0)+4|0,w+80|0,w+64|0);q=c[d+68>>2]|0;Hb[c[(c[q>>2]|0)+16>>2]&31](q,c[(c[b+8>>2]|0)+188>>2]|0,w+80|0,w+64|0,c[d+24>>2]|0);q=c[d+24>>2]|0;tc[c[(c[q>>2]|0)+32>>2]&127](q,c[(c[b+8>>2]|0)+284>>2]|0,d+28|0,q);q=c[b+8>>2]|0;c[b+92>>2]=c[q+52>>2];c[b+96>>2]=c[q+56>>2];c[b+100>>2]=c[q+60>>2];c[b+104>>2]=c[q+64>>2];q=c[q+284>>2]|0;if((Nb[c[(c[q>>2]|0)+36>>2]&127](q)|0)>0){t=0;j=0.0;e=0;do{f=c[b+132>>2]|0;if((f|0)<0){if((c[b+136>>2]|0)<0){h=c[b+140>>2]|0;if(h){if(a[b+144>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[h+-4>>2]|0)}c[b+140>>2]=0}a[b+144>>0]=1;c[b+140>>2]=0;c[b+136>>2]=0}do{h=(c[b+140>>2]|0)+(f<<2)|0;if(h)c[h>>2]=0;f=f+1|0}while((f|0)!=0)}c[b+132>>2]=0;h=c[(c[b+8>>2]|0)+284>>2]|0;h=c[(Nb[c[(c[h>>2]|0)+28>>2]&127](h)|0)+12>>2]|0;q=c[c[h+(t<<4)>>2]>>2]|0;f=c[c[h+(t<<4)+4>>2]>>2]|0;if(!((q|0)!=0?(c[q+204>>2]&4|0)!=0:0))v=15;do if((v|0)==15){v=0;if((f|0)!=0?(c[f+204>>2]&4|0)!=0:0)break;f=c[h+(t<<4)+8>>2]|0;if(f)Lb[c[(c[f>>2]|0)+16>>2]&127](f,b+128|0);r=c[b+132>>2]|0;if((r|0)>0){p=c[b+140>>2]|0;q=c[b+8>>2]|0;s=0;do{n=c[p+(s<<2)>>2]|0;o=(c[n+740>>2]|0)==(q|0)?-1.0:1.0;h=c[n+748>>2]|0;if((h|0)>0){m=0;do{l=+g[n+(m*184|0)+84>>2];if(l<0.0){k=n+(m*184|0)+68|0;if(l<j){f=n+(m*184|0)+72|0;x=o*+g[f>>2];e=n+(m*184|0)+76|0;j=o*+g[e>>2];g[b+152>>2]=o*+g[k>>2];g[b+156>>2]=x;g[b+160>>2]=j;g[b+164>>2]=0.0;h=c[n+748>>2]|0;j=l}else{f=n+(m*184|0)+72|0;e=n+(m*184|0)+76|0}y=l*(o*+g[f>>2])*.20000000298023224;x=l*(o*+g[e>>2])*.20000000298023224;g[b+92>>2]=l*(o*+g[k>>2])*.20000000298023224+ +g[b+92>>2];g[b+96>>2]=y+ +g[b+96>>2];g[b+100>>2]=x+ +g[b+100>>2];e=1}m=m+1|0}while((m|0)<(h|0))}s=s+1|0}while((s|0)!=(r|0))}}while(0);t=t+1|0;q=c[(c[b+8>>2]|0)+284>>2]|0}while((t|0)<(Nb[c[(c[q>>2]|0)+36>>2]&127](q)|0))}else e=0;q=c[b+8>>2]|0;c[w+0>>2]=c[q+4>>2];c[w+4>>2]=c[q+8>>2];c[w+8>>2]=c[q+12>>2];c[w+12>>2]=c[q+16>>2];c[w+16>>2]=c[q+20>>2];c[w+20>>2]=c[q+24>>2];c[w+24>>2]=c[q+28>>2];c[w+28>>2]=c[q+32>>2];c[w+32>>2]=c[q+36>>2];c[w+36>>2]=c[q+40>>2];c[w+40>>2]=c[q+44>>2];c[w+44>>2]=c[q+48>>2];c[w+48>>2]=c[b+92>>2];c[w+52>>2]=c[b+96>>2];c[w+56>>2]=c[b+100>>2];c[w+60>>2]=c[b+104>>2];c[q+260>>2]=(c[q+260>>2]|0)+1;c[q+4>>2]=c[w+0>>2];c[q+8>>2]=c[w+4>>2];c[q+12>>2]=c[w+8>>2];c[q+16>>2]=c[w+12>>2];c[q+20>>2]=c[w+16>>2];c[q+24>>2]=c[w+20>>2];c[q+28>>2]=c[w+24>>2];c[q+32>>2]=c[w+28>>2];c[q+36>>2]=c[w+32>>2];c[q+40>>2]=c[w+36>>2];c[q+44>>2]=c[w+40>>2];c[q+48>>2]=c[w+44>>2];c[q+52>>2]=c[w+48>>2];c[q+56>>2]=c[w+52>>2];c[q+60>>2]=c[w+56>>2];c[q+64>>2]=c[w+60>>2];if(!e){v=32;break}a[b+148>>0]=1;if((u|0)>3){v=32;break}else u=u+1|0}if((v|0)==32){v=(c[b+8>>2]|0)+52|0;c[b+92>>2]=c[v+0>>2];c[b+96>>2]=c[v+4>>2];c[b+100>>2]=c[v+8>>2];c[b+104>>2]=c[v+12>>2];gF(b+112|0,v|0,16)|0;i=w;return}}function Es(d,e,f){d=d|0;e=e|0;f=+f;var h=0,j=0.0,k=0.0,l=0.0,m=0,n=0.0,o=0,p=0,q=0.0,r=0.0,s=0.0,t=0,u=0,v=0,w=0;w=i;i=i+528|0;if((a[d+171>>0]|0)==0?+g[d+172>>2]<=0.0:0){i=w;return}a[d+168>>0]=(Nb[c[(c[d>>2]|0)+48>>2]&127](d)|0)&1;j=+g[d+16>>2]-+g[d+44>>2]*f;g[d+16>>2]=j;if(j>0.0?(k=+g[d+28>>2],j>k):0){g[d+16>>2]=k;j=k}if(j<0.0?(s=+O(+j),l=+O(+(+g[d+24>>2])),s>l):0){g[d+16>>2]=-l;j=-l}g[d+20>>2]=j*f;h=c[d+8>>2]|0;c[w+272>>2]=c[h+4>>2];c[w+276>>2]=c[h+8>>2];c[w+280>>2]=c[h+12>>2];c[w+284>>2]=c[h+16>>2];t=w+288|0;c[t+0>>2]=c[h+20>>2];c[t+4>>2]=c[h+24>>2];c[t+8>>2]=c[h+28>>2];c[t+12>>2]=c[h+32>>2];u=w+304|0;c[u+0>>2]=c[h+36>>2];c[u+4>>2]=c[h+40>>2];c[u+8>>2]=c[h+44>>2];c[u+12>>2]=c[h+48>>2];v=w+320|0;c[v+0>>2]=c[h+52>>2];c[v+4>>2]=c[h+56>>2];c[v+8>>2]=c[h+60>>2];c[v+12>>2]=c[h+64>>2];h=c[d+176>>2]|0;if((a[5224]|0)==0?(Xa(5224)|0)!=0:0){g[1294]=1.0;c[1295]=0;c[1296]=0;c[1297]=0;c[1298]=0;g[1299]=1.0;c[1300]=0;c[1301]=0;c[1302]=0;c[1303]=0;g[1304]=1.0;g[1305]=0.0;ab(5224)}q=+g[d+20>>2];q=+g[d+52>>2]+(q>0.0?q:0.0);r=+g[5180+(h<<4)>>2]*q+ +g[d+96>>2];s=q*+g[5184+(h<<4)>>2]+ +g[d+100>>2];g[d+112>>2]=+g[d+92>>2]+ +g[5176+(h<<4)>>2]*q;g[d+116>>2]=r;g[d+120>>2]=s;g[d+124>>2]=0.0;g[w+208>>2]=1.0;c[w+212>>2]=0;c[w+216>>2]=0;c[w+220>>2]=0;c[w+224>>2]=0;g[w+228>>2]=1.0;c[w+232>>2]=0;c[w+236>>2]=0;c[w+240>>2]=0;c[w+244>>2]=0;g[w+248>>2]=1.0;h=w+252|0;c[h+0>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[h+16>>2]=0;g[w+336>>2]=1.0;c[w+340>>2]=0;c[w+344>>2]=0;c[w+348>>2]=0;c[w+352>>2]=0;g[w+356>>2]=1.0;c[w+360>>2]=0;c[w+364>>2]=0;c[w+368>>2]=0;c[w+372>>2]=0;g[w+376>>2]=1.0;h=w+380|0;c[h+0>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[h+16>>2]=0;h=c[d+176>>2]|0;if((a[5224]|0)==0?(Xa(5224)|0)!=0:0){g[1294]=1.0;c[1295]=0;c[1296]=0;c[1297]=0;c[1298]=0;g[1299]=1.0;c[1300]=0;c[1301]=0;c[1302]=0;c[1303]=0;g[1304]=1.0;g[1305]=0.0;ab(5224)}m=c[d+12>>2]|0;q=+Zb[c[(c[m>>2]|0)+48>>2]&15](m);q=q+ +g[d+56>>2];r=q*+g[5180+(h<<4)>>2]+ +g[d+96>>2];s=q*+g[5184+(h<<4)>>2]+ +g[d+100>>2];g[w+256>>2]=+g[5176+(h<<4)>>2]*q+ +g[d+92>>2];g[w+260>>2]=r;g[w+264>>2]=s;g[w+268>>2]=0.0;c[w+384>>2]=c[d+112>>2];c[w+388>>2]=c[d+116>>2];c[w+392>>2]=c[d+120>>2];c[w+396>>2]=c[d+124>>2];h=c[d+8>>2]|0;m=c[d+176>>2]|0;if((a[5224]|0)==0?(Xa(5224)|0)!=0:0){g[1294]=1.0;c[1295]=0;c[1296]=0;c[1297]=0;c[1298]=0;g[1299]=1.0;c[1300]=0;c[1301]=0;c[1302]=0;c[1303]=0;g[1304]=1.0;g[1305]=0.0;ab(5224)}q=-+g[5176+(m<<4)>>2];r=-+g[5180+(m<<4)>>2];s=-+g[5184+(m<<4)>>2];g[w+404>>2]=1.0;p=w+412|0;c[w+476>>2]=0;c[p+0>>2]=0;c[p+4>>2]=0;c[p+8>>2]=0;c[p+12>>2]=0;c[p+16>>2]=0;c[p+20>>2]=0;c[p+24>>2]=0;c[p+28>>2]=0;c[w+400>>2]=5352;c[w+480>>2]=h;g[w+484>>2]=q;g[w+488>>2]=r;g[w+492>>2]=s;g[w+496>>2]=0.0;g[w+500>>2]=.707099974155426;h=c[d+8>>2]|0;p=c[h+188>>2]|0;b[w+408>>1]=b[p+4>>1]|0;b[w+410>>1]=b[p+6>>1]|0;if(!(a[d+170>>0]|0))hv(e,c[d+12>>2]|0,w+208|0,w+336|0,w+400|0,0.0);else $s(h,c[d+12>>2]|0,w+208|0,w+336|0,w+400|0,+g[e+56>>2]);if(+g[w+404>>2]<1.0){h=c[d+176>>2]|0;if((a[5224]|0)==0?(Xa(5224)|0)!=0:0){g[1294]=1.0;c[1295]=0;c[1296]=0;c[1297]=0;c[1298]=0;g[1299]=1.0;c[1300]=0;c[1301]=0;c[1302]=0;c[1303]=0;g[1304]=1.0;g[1305]=0.0;ab(5224)}do if(+g[w+444>>2]*+g[5176+(h<<4)>>2]+ +g[w+448>>2]*+g[5180+(h<<4)>>2]+ +g[w+452>>2]*+g[5184+(h<<4)>>2]>0.0){k=+g[w+404>>2];g[d+108>>2]=+g[d+52>>2]*k;if(!(a[d+180>>0]|0)){c[d+92>>2]=c[d+112>>2];c[d+96>>2]=c[d+116>>2];c[d+100>>2]=c[d+120>>2];c[d+104>>2]=c[d+124>>2];break}else{g[d+92>>2]=(1.0-k)*+g[d+92>>2]+k*+g[d+112>>2];g[d+96>>2]=(1.0-k)*+g[d+96>>2]+k*+g[d+116>>2];g[d+100>>2]=(1.0-k)*+g[d+100>>2]+k*+g[d+120>>2];break}}while(0);g[d+16>>2]=0.0;g[d+20>>2]=0.0}else{g[d+108>>2]=+g[d+52>>2];c[d+92>>2]=c[d+112>>2];c[d+96>>2]=c[d+116>>2];c[d+100>>2]=c[d+120>>2];c[d+104>>2]=c[d+124>>2]}if(!(a[d+171>>0]|0)){r=+g[d+172>>2];s=r>f?f:r;g[d+172>>2]=r-f;ys(d,e,+g[d+60>>2]*s,s*+g[d+64>>2],s*+g[d+68>>2])}else ys(d,e,+g[d+60>>2],+g[d+64>>2],+g[d+68>>2]);c[w+504>>2]=c[d+112>>2];c[w+508>>2]=c[d+116>>2];c[w+512>>2]=c[d+120>>2];c[w+516>>2]=c[d+124>>2];k=+g[d+16>>2];if(k<0.0)k=-k;else k=0.0;k=k*f;do if(k>0.0?(n=+g[d+24>>2],k>n):0){if((a[d+168>>0]|0)==0?(a[d+169>>0]|0)!=0:0)break;k=n}while(0);m=c[d+176>>2]|0;if((a[5224]|0)==0?(Xa(5224)|0)!=0:0){g[1294]=1.0;c[1295]=0;c[1296]=0;c[1297]=0;c[1298]=0;g[1299]=1.0;c[1300]=0;c[1301]=0;c[1302]=0;c[1303]=0;g[1304]=1.0;g[1305]=0.0;ab(5224)}q=k+ +g[d+108>>2];r=+g[5176+(m<<4)>>2]*q;s=q*+g[5180+(m<<4)>>2];q=q*+g[5184+(m<<4)>>2];g[d+112>>2]=+g[d+112>>2]-r;g[d+116>>2]=+g[d+116>>2]-s;g[d+120>>2]=+g[d+120>>2]-q;m=c[d+8>>2]|0;h=c[d+176>>2]|0;if((a[5224]|0)==0?(Xa(5224)|0)!=0:0){g[1294]=1.0;c[1295]=0;c[1296]=0;c[1297]=0;c[1298]=0;g[1299]=1.0;c[1300]=0;c[1301]=0;c[1302]=0;c[1303]=0;g[1304]=1.0;g[1305]=0.0;ab(5224)}n=+g[d+40>>2];p=w+108|0;g[p>>2]=1.0;o=w+116|0;c[w+180>>2]=0;c[o+0>>2]=0;c[o+4>>2]=0;c[o+8>>2]=0;c[o+12>>2]=0;c[o+16>>2]=0;c[o+20>>2]=0;c[o+24>>2]=0;c[o+28>>2]=0;c[w+104>>2]=5352;c[w+184>>2]=m;c[w+188>>2]=c[5176+(h<<4)>>2];c[w+192>>2]=c[5180+(h<<4)>>2];c[w+196>>2]=c[5184+(h<<4)>>2];c[w+200>>2]=c[5188+(h<<4)>>2];g[w+204>>2]=n;m=c[d+8>>2]|0;h=c[m+188>>2]|0;b[w+112>>1]=b[h+4>>1]|0;b[w+114>>1]=b[h+6>>1]|0;h=c[d+176>>2]|0;if((a[5224]|0)==0?(Xa(5224)|0)!=0:0){g[1294]=1.0;c[1295]=0;c[1296]=0;c[1297]=0;c[1298]=0;g[1299]=1.0;c[1300]=0;c[1301]=0;c[1302]=0;c[1303]=0;g[1304]=1.0;g[1305]=0.0;ab(5224)}l=+g[d+40>>2];g[w+4>>2]=1.0;c[w+76>>2]=0;c[w+12>>2]=0;c[w+16>>2]=0;c[w+20>>2]=0;c[w+24>>2]=0;c[w+28>>2]=0;c[w+32>>2]=0;c[w+36>>2]=0;c[w+40>>2]=0;c[w>>2]=5352;c[w+80>>2]=m;c[w+84>>2]=c[5176+(h<<4)>>2];c[w+88>>2]=c[5180+(h<<4)>>2];c[w+92>>2]=c[5184+(h<<4)>>2];c[w+96>>2]=c[5188+(h<<4)>>2];g[w+100>>2]=l;m=c[(c[d+8>>2]|0)+188>>2]|0;b[w+8>>1]=b[m+4>>1]|0;b[w+10>>1]=b[m+6>>1]|0;l=+g[d+112>>2];k=+g[d+116>>2];j=+g[d+120>>2];m=0;while(1){g[w+208>>2]=1.0;c[w+212>>2]=0;c[w+216>>2]=0;c[w+220>>2]=0;c[w+224>>2]=0;g[w+228>>2]=1.0;c[w+232>>2]=0;c[w+236>>2]=0;c[w+240>>2]=0;c[w+244>>2]=0;g[w+248>>2]=1.0;c[w+252>>2]=0;g[w+336>>2]=1.0;c[w+340>>2]=0;c[w+344>>2]=0;c[w+348>>2]=0;c[w+352>>2]=0;g[w+356>>2]=1.0;c[w+360>>2]=0;c[w+364>>2]=0;c[w+368>>2]=0;c[w+372>>2]=0;g[w+376>>2]=1.0;c[w+380>>2]=0;g[w+400>>2]=1.0;c[w+404>>2]=0;c[w+408>>2]=0;c[w+412>>2]=0;c[w+416>>2]=0;g[w+420>>2]=1.0;c[w+424>>2]=0;c[w+428>>2]=0;c[w+432>>2]=0;c[w+436>>2]=0;g[w+440>>2]=1.0;c[w+444>>2]=0;c[w+448>>2]=0;c[w+452>>2]=0;c[w+256>>2]=c[d+92>>2];c[w+260>>2]=c[d+96>>2];c[w+264>>2]=c[d+100>>2];c[w+268>>2]=c[d+104>>2];c[w+384>>2]=c[d+112>>2];c[w+388>>2]=c[d+116>>2];c[w+392>>2]=c[d+120>>2];c[w+396>>2]=c[d+124>>2];g[w+448>>2]=l-r;g[w+452>>2]=k-s;g[w+456>>2]=j-q;g[w+460>>2]=0.0;if(!(a[d+170>>0]|0)){hv(e,c[d+12>>2]|0,w+208|0,w+336|0,w+104|0,+g[e+56>>2]);if(!(+g[p>>2]<1.0))hv(e,c[d+12>>2]|0,w+208|0,w+400|0,w,+g[e+56>>2])}else{$s(c[d+8>>2]|0,c[d+12>>2]|0,w+208|0,w+336|0,w+104|0,+g[e+56>>2]);if(!(+g[p>>2]<1.0))$s(c[d+8>>2]|0,c[d+12>>2]|0,w+208|0,w+400|0,w,+g[e+56>>2])}n=+g[d+16>>2];if(n<0.0)l=-n;else l=0.0;l=l*f;o=(a[d+182>>0]|0)==0;if(!o?+g[p>>2]<1.0:0)h=1;else h=+g[w+4>>2]<1.0;if(!(l>0.0))break;k=+g[d+52>>2];if(!(l<k)|h^1|m)break;if((a[d+168>>0]|0)==0?(a[d+169>>0]|0)!=0:0){m=0;break};c[d+112>>2]=c[w+504>>2];c[d+116>>2]=c[w+508>>2];c[d+120>>2]=c[w+512>>2];c[d+124>>2]=c[w+516>>2];m=c[d+176>>2]|0;do if(!(a[5224]|0)){if(!(Xa(5224)|0))break;g[1294]=1.0;c[1295]=0;c[1296]=0;c[1297]=0;c[1298]=0;g[1299]=1.0;c[1300]=0;c[1301]=0;c[1302]=0;c[1303]=0;g[1304]=1.0;g[1305]=0.0;ab(5224)}while(0);l=k+ +g[d+108>>2];k=l*+g[5180+(m<<4)>>2];j=l*+g[5184+(m<<4)>>2];l=+g[d+112>>2]-+g[5176+(m<<4)>>2]*l;g[d+112>>2]=l;k=+g[d+116>>2]-k;g[d+116>>2]=k;j=+g[d+120>>2]-j;g[d+120>>2]=j;m=1}j=+g[p>>2];if(j<1.0|m){l=+g[d+96>>2];k=(l-+g[w+168>>2])*.5;do if(!o)if(!(a[d+181>>0]|0)){g[d+92>>2]=(1.0-k)*+g[d+92>>2]+k*+g[d+112>>2];g[d+96>>2]=(1.0-k)*l+k*+g[d+116>>2];g[d+100>>2]=(1.0-k)*+g[d+100>>2]+k*+g[d+120>>2];h=d+181|0;break}else{g[d+92>>2]=(1.0-j)*+g[d+92>>2]+j*+g[d+112>>2];g[d+96>>2]=(1.0-j)*l+j*+g[d+116>>2];g[d+100>>2]=(1.0-j)*+g[d+100>>2]+j*+g[d+120>>2];h=d+181|0;break}else{g[d+92>>2]=(1.0-j)*+g[d+92>>2]+j*+g[d+112>>2];g[d+96>>2]=(1.0-j)*l+j*+g[d+116>>2];g[d+100>>2]=(1.0-j)*+g[d+100>>2]+j*+g[d+120>>2];h=d+181|0}while(0);a[h>>0]=0;g[d+16>>2]=0.0;g[d+20>>2]=0.0;a[d+169>>0]=0}else{a[d+181>>0]=1;do if(!o){if(n<0.0)l=-n;else l=0.0;k=+g[d+24>>2];if(l*f>k){if((a[d+168>>0]|0)==0?(a[d+169>>0]|0)!=0:0)break;g[d+112>>2]=r+ +g[d+112>>2];g[d+116>>2]=s+ +g[d+116>>2];g[d+120>>2]=q+ +g[d+120>>2];h=c[d+176>>2]|0;do if(!(a[5224]|0)){if(!(Xa(5224)|0))break;g[1294]=1.0;c[1295]=0;c[1296]=0;c[1297]=0;c[1298]=0;g[1299]=1.0;c[1300]=0;c[1301]=0;c[1302]=0;c[1303]=0;g[1304]=1.0;g[1305]=0.0;ab(5224)}while(0);r=k+ +g[d+108>>2];s=r*+g[5180+(h<<4)>>2];f=r*+g[5184+(h<<4)>>2];g[d+112>>2]=+g[d+112>>2]-+g[5176+(h<<4)>>2]*r;g[d+116>>2]=+g[d+116>>2]-s;g[d+120>>2]=+g[d+120>>2]-f}}while(0);c[d+92>>2]=c[d+112>>2];c[d+96>>2]=c[d+116>>2];c[d+100>>2]=c[d+120>>2];c[d+104>>2]=c[d+124>>2]};c[v+0>>2]=c[d+92>>2];c[v+4>>2]=c[d+96>>2];c[v+8>>2]=c[d+100>>2];c[v+12>>2]=c[d+104>>2];d=c[d+8>>2]|0;c[d+260>>2]=(c[d+260>>2]|0)+1;c[d+4>>2]=c[w+272>>2];c[d+8>>2]=c[w+276>>2];c[d+12>>2]=c[w+280>>2];c[d+16>>2]=c[w+284>>2];c[d+20>>2]=c[t+0>>2];c[d+24>>2]=c[t+4>>2];c[d+28>>2]=c[t+8>>2];c[d+32>>2]=c[t+12>>2];c[d+36>>2]=c[u+0>>2];c[d+40>>2]=c[u+4>>2];c[d+44>>2]=c[u+8>>2];c[d+48>>2]=c[u+12>>2];c[d+52>>2]=c[v+0>>2];c[d+56>>2]=c[v+4>>2];c[d+60>>2]=c[v+8>>2];c[d+64>>2]=c[v+12>>2];i=w;return}function Fs(a){a=a|0;return Nb[c[(c[a>>2]|0)+48>>2]&127](a)|0}function Gs(b){b=b|0;if(!(Nb[c[(c[b>>2]|0)+40>>2]&127](b)|0))return;g[b+16>>2]=+g[b+28>>2];a[b+169>>0]=1;return}function Hs(a){a=a|0;if(!(+g[a+16>>2]==0.0)){a=0;return a|0}a=+g[a+20>>2]==0.0;return a|0}function Is(a,b){a=a|0;b=b|0;return}function Js(b,c){b=b|0;c=c|0;a[b+180>>0]=c&1;return}function Ks(a,b,d){a=a|0;b=b|0;d=+d;Lb[c[(c[a>>2]|0)+32>>2]&127](a,b);rc[c[(c[a>>2]|0)+36>>2]&7](a,b,d);return}function Ls(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0,j=0.0,k=0.0;i=c[b>>2]|0;if((i|0)==(c[a+80>>2]|0)){j=1.0;return +j}if(c[i+204>>2]&4){j=1.0;return +j}h=+g[b+8>>2];f=+g[b+12>>2];e=+g[b+16>>2];if(d){j=h;k=f}else{j=+g[i+4>>2]*h+ +g[i+8>>2]*f+ +g[i+12>>2]*e;k=h*+g[i+20>>2]+f*+g[i+24>>2]+e*+g[i+28>>2];e=h*+g[i+36>>2]+f*+g[i+40>>2]+e*+g[i+44>>2]}if(j*+g[a+84>>2]+k*+g[a+88>>2]+e*+g[a+92>>2]<+g[a+100>>2]){j=1.0;return +j}g[a+4>>2]=+g[b+40>>2];c[a+76>>2]=i;if(d){c[a+44>>2]=c[b+8>>2];c[a+48>>2]=c[b+12>>2];c[a+52>>2]=c[b+16>>2];c[a+56>>2]=c[b+20>>2]}else{e=+g[b+8>>2];k=+g[b+12>>2];f=+g[b+16>>2];h=e*+g[i+20>>2]+k*+g[i+24>>2]+f*+g[i+28>>2];j=e*+g[i+36>>2]+k*+g[i+40>>2]+f*+g[i+44>>2];g[a+44>>2]=+g[i+4>>2]*e+ +g[i+8>>2]*k+ +g[i+12>>2]*f;g[a+48>>2]=h;g[a+52>>2]=j;g[a+56>>2]=0.0}c[a+60>>2]=c[b+24>>2];c[a+64>>2]=c[b+28>>2];c[a+68>>2]=c[b+32>>2];c[a+72>>2]=c[b+36>>2];j=+g[b+40>>2];return +j}function Ms(a){a=a|0;_E(a);return}function Ns(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0,x=0,y=0.0,z=0.0,A=0.0,B=0.0;d=c[a+748>>2]|0;if((d|0)!=4){c[a+748>>2]=d+1;x=d;w=(x|0)<0;x=w?0:x;a=a+(x*184|0)+4|0;fF(a|0,b|0,184)|0;return x|0}y=+g[b+80>>2];v=+g[a+84>>2];u=v<y?v:y;t=+g[a+268>>2];s=t<u?t:u;r=+g[a+452>>2];w=+g[a+636>>2]<(r<s?r:s);d=w?3:r<s?2:t<u?1:(v<y^1)<<31>>31;y=+g[b>>2];if(d){h=+g[a+188>>2];k=+g[b+4>>2];e=+g[a+192>>2];f=+g[b+8>>2];j=+g[a+196>>2];l=+g[a+556>>2];t=+g[a+372>>2];p=+g[a+560>>2];q=+g[a+376>>2];s=+g[a+564>>2];m=+g[a+380>>2];i=((y-h)*(p-q)-(k-e)*(l-t))*((y-h)*(p-q)-(k-e)*(l-t))+(((k-e)*(s-m)-(f-j)*(p-q))*((k-e)*(s-m)-(f-j)*(p-q))+((f-j)*(l-t)-(y-h)*(s-m))*((f-j)*(l-t)-(y-h)*(s-m)));if((d|0)==1){o=+g[a+12>>2];r=l;v=h;u=p;p=e;h=0.0;n=+g[a+4>>2];l=+g[a+8>>2];x=7}else{u=h;r=l;x=6}}else{u=+g[a+188>>2];e=+g[a+192>>2];j=+g[a+196>>2];i=0.0;k=+g[b+4>>2];f=+g[b+8>>2];r=+g[a+556>>2];t=+g[a+372>>2];p=+g[a+560>>2];q=+g[a+376>>2];s=+g[a+564>>2];m=+g[a+380>>2];x=6}if((x|0)==6){n=+g[a+4>>2];l=+g[a+8>>2];B=k-l;o=+g[a+12>>2];z=f-o;v=r-t;A=p-q;h=s-m;h=((y-n)*A-B*v)*((y-n)*A-B*v)+((B*h-z*A)*(B*h-z*A)+(z*v-(y-n)*h)*(z*v-(y-n)*h));if((d|0)==2){r=t;s=u;p=e;e=0.0;x=8}else{v=u;u=p;p=e;x=7}}if((x|0)==7){z=y-n;A=k-l;B=f-o;r=r-v;u=u-p;e=s-j;e=(z*u-A*r)*(z*u-A*r)+((A*e-B*u)*(A*e-B*u)+(B*r-z*e)*(B*r-z*e));if(w)f=0.0;else{r=t;s=v;x=8}}if((x|0)==8){z=y-n;t=k-l;v=f-o;y=r-s;u=q-p;f=m-j;f=(z*u-t*y)*(z*u-t*y)+((t*f-v*u)*(t*f-v*u)+(v*y-z*f)*(v*y-z*f))}z=+O(+i);v=+O(+h);t=+O(+e);s=+O(+f);y=z>-999999984306749440.0?z:-999999984306749440.0;u=v>y?v:y;x=s>(t>u?t:u)?3:t>u?2:v>y?1:(z>-999999984306749440.0^1)<<31>>31;w=(x|0)<0;x=w?0:x;a=a+(x*184|0)+4|0;fF(a|0,b|0,184)|0;return x|0}function Os(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0.0,i=0.0,j=0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0;f=c[b+748>>2]|0;if((f|0)<=0)return;do{f=f+-1|0;o=+g[b+(f*184|0)+4>>2];p=+g[b+(f*184|0)+8>>2];h=+g[b+(f*184|0)+12>>2];n=o*+g[d>>2]+p*+g[d+4>>2]+h*+g[d+8>>2]+ +g[d+48>>2];l=o*+g[d+16>>2]+p*+g[d+20>>2]+h*+g[d+24>>2]+ +g[d+52>>2];h=o*+g[d+32>>2]+p*+g[d+36>>2]+h*+g[d+40>>2]+ +g[d+56>>2];g[b+(f*184|0)+52>>2]=n;g[b+(f*184|0)+56>>2]=l;g[b+(f*184|0)+60>>2]=h;g[b+(f*184|0)+64>>2]=0.0;p=+g[b+(f*184|0)+20>>2];o=+g[b+(f*184|0)+24>>2];i=+g[b+(f*184|0)+28>>2];m=p*+g[e>>2]+o*+g[e+4>>2]+i*+g[e+8>>2]+ +g[e+48>>2];k=p*+g[e+16>>2]+o*+g[e+20>>2]+i*+g[e+24>>2]+ +g[e+52>>2];i=p*+g[e+32>>2]+o*+g[e+36>>2]+i*+g[e+40>>2]+ +g[e+56>>2];g[b+(f*184|0)+36>>2]=m;g[b+(f*184|0)+40>>2]=k;g[b+(f*184|0)+44>>2]=i;g[b+(f*184|0)+48>>2]=0.0;g[b+(f*184|0)+84>>2]=(n-m)*+g[b+(f*184|0)+68>>2]+(l-k)*+g[b+(f*184|0)+72>>2]+(h-i)*+g[b+(f*184|0)+76>>2];j=b+(f*184|0)+152|0;c[j>>2]=(c[j>>2]|0)+1}while((f|0)>0);f=c[b+748>>2]|0;if((f|0)<=0)return;d=f;j=f;while(1){j=j+-1|0;e=b+(j*184|0)+4|0;h=+g[b+(j*184|0)+84>>2];i=+g[b+752>>2];if(h<=i){n=+g[b+(j*184|0)+36>>2]-(+g[b+(j*184|0)+52>>2]-+g[b+(j*184|0)+68>>2]*h);o=+g[b+(j*184|0)+40>>2]-(+g[b+(j*184|0)+56>>2]-h*+g[b+(j*184|0)+72>>2]);p=+g[b+(j*184|0)+44>>2]-(+g[b+(j*184|0)+60>>2]-h*+g[b+(j*184|0)+76>>2]);if(n*n+o*o+p*p>i*i){f=d+-1|0;if((f|0)==(j|0))f=d;else{fF(e|0,b+(f*184|0)+4|0,184)|0;c[b+(f*184|0)+116>>2]=0;g[b+(f*184|0)+124>>2]=0.0;a[b+(f*184|0)+120>>0]=0;g[b+(f*184|0)+128>>2]=0.0;g[b+(f*184|0)+132>>2]=0.0;c[b+(f*184|0)+152>>2]=0;f=c[b+748>>2]|0}f=f+-1|0;c[b+748>>2]=f}else f=d}else{f=d+-1|0;if((f|0)==(j|0))f=d;else{fF(e|0,b+(f*184|0)+4|0,184)|0;c[b+(f*184|0)+116>>2]=0;g[b+(f*184|0)+124>>2]=0.0;a[b+(f*184|0)+120>>0]=0;g[b+(f*184|0)+128>>2]=0.0;g[b+(f*184|0)+132>>2]=0.0;c[b+(f*184|0)+152>>2]=0;f=c[b+748>>2]|0}f=f+-1|0;c[b+748>>2]=f}if((j|0)<=0)break;else d=f}return}function Ps(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0.0;g[b+16>>2]=+g[a+4>>2];g[b+20>>2]=+g[a+8>>2];g[b+24>>2]=+g[a+12>>2];g[b+28>>2]=+g[a+16>>2];g[b+32>>2]=+g[a+20>>2];g[b+36>>2]=+g[a+24>>2];g[b+40>>2]=+g[a+28>>2];g[b+44>>2]=+g[a+32>>2];g[b+48>>2]=+g[a+36>>2];g[b+52>>2]=+g[a+40>>2];g[b+56>>2]=+g[a+44>>2];g[b+60>>2]=+g[a+48>>2];g[b+64>>2]=+g[a+52>>2];g[b+68>>2]=+g[a+56>>2];g[b+72>>2]=+g[a+60>>2];g[b+76>>2]=+g[a+64>>2];g[b+80>>2]=+g[a+68>>2];g[b+84>>2]=+g[a+72>>2];g[b+88>>2]=+g[a+76>>2];g[b+92>>2]=+g[a+80>>2];g[b+96>>2]=+g[a+84>>2];g[b+100>>2]=+g[a+88>>2];g[b+104>>2]=+g[a+92>>2];g[b+108>>2]=+g[a+96>>2];g[b+112>>2]=+g[a+100>>2];g[b+116>>2]=+g[a+104>>2];g[b+120>>2]=+g[a+108>>2];g[b+124>>2]=+g[a+112>>2];g[b+128>>2]=+g[a+116>>2];g[b+132>>2]=+g[a+120>>2];g[b+136>>2]=+g[a+124>>2];g[b+140>>2]=+g[a+128>>2];g[b+144>>2]=+g[a+132>>2];g[b+148>>2]=+g[a+136>>2];g[b+152>>2]=+g[a+140>>2];g[b+156>>2]=+g[a+144>>2];g[b+160>>2]=+g[a+148>>2];g[b+164>>2]=+g[a+152>>2];g[b+168>>2]=+g[a+156>>2];g[b+172>>2]=+g[a+160>>2];g[b+176>>2]=+g[a+164>>2];g[b+180>>2]=+g[a+168>>2];g[b+184>>2]=+g[a+172>>2];g[b+188>>2]=+g[a+176>>2];c[b+224>>2]=c[a+180>>2];g[b+192>>2]=+g[a+184>>2];c[b>>2]=0;c[b+4>>2]=ec[c[(c[d>>2]|0)+28>>2]&31](d,c[a+192>>2]|0)|0;c[b+8>>2]=0;c[b+228>>2]=c[a+204>>2];c[b+232>>2]=c[a+208>>2];c[b+236>>2]=c[a+212>>2];c[b+240>>2]=c[a+216>>2];g[b+196>>2]=+g[a+220>>2];g[b+200>>2]=+g[a+224>>2];g[b+204>>2]=+g[a+232>>2];g[b+208>>2]=+g[a+228>>2];c[b+244>>2]=c[a+236>>2];e=ec[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;f=ec[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;c[b+12>>2]=f;if(!f){f=a+244|0;h=+g[f>>2];f=b+212|0;g[f>>2]=h;f=a+248|0;h=+g[f>>2];f=b+216|0;g[f>>2]=h;f=a+252|0;h=+g[f>>2];f=b+220|0;g[f>>2]=h;a=a+256|0;a=c[a>>2]|0;f=b+248|0;c[f>>2]=a;return 5440}Lb[c[(c[d>>2]|0)+48>>2]&127](d,e);f=a+244|0;h=+g[f>>2];f=b+212|0;g[f>>2]=h;f=a+248|0;h=+g[f>>2];f=b+216|0;g[f>>2]=h;f=a+252|0;h=+g[f>>2];f=b+220|0;g[f>>2]=h;a=a+256|0;a=c[a>>2]|0;f=b+248|0;c[f>>2]=a;return 5440}function Qs(a,b){a=a|0;b=b|0;var d=0,e=0;e=Nb[c[(c[a>>2]|0)+16>>2]&127](a)|0;e=Wb[c[(c[b>>2]|0)+16>>2]&63](b,e,1)|0;d=Wb[c[(c[a>>2]|0)+20>>2]&63](a,c[e+8>>2]|0,b)|0;Hb[c[(c[b>>2]|0)+20>>2]&31](b,e,d,1245859651,a);return}function Rs(a){a=a|0;return 256}function Ss(a,b){a=a|0;b=b|0;return 1}function Ts(b){b=b|0;var d=0;c[b>>2]=5512;d=c[b+276>>2]|0;if(d){if(a[b+280>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+276>>2]=0}a[b+280>>0]=1;c[b+276>>2]=0;c[b+268>>2]=0;c[b+272>>2]=0;return}function Us(b){b=b|0;var d=0;c[b>>2]=5512;d=c[b+276>>2]|0;if(!d){a[b+280>>0]=1;c[b+276>>2]=0;c[b+268>>2]=0;c[b+272>>2]=0}else{if(a[b+280>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}a[b+280>>0]=1;c[b+276>>2]=0;c[b+268>>2]=0;c[b+272>>2]=0}c[5134]=(c[5134]|0)+1;_E(c[b+-4>>2]|0);return}function Vs(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;i=c[d>>2]|0;d=c[b+268>>2]|0;a:do if((d|0)>0){e=c[b+276>>2]|0;g=0;while(1){f=g+1|0;if((c[e+(g<<2)>>2]|0)==(i|0))break;if((f|0)<(d|0))g=f;else break a}if((g|0)!=(d|0))return}while(0);if((d|0)==(c[b+272>>2]|0)?(h=(d|0)==0?1:d<<1,(d|0)<(h|0)):0){if(!h)f=0;else{c[5132]=(c[5132]|0)+1;e=ZE((h<<2|3)+16|0)|0;if(!e)d=0;else{c[(e+19&-16)+-4>>2]=e;d=e+19&-16}f=d;d=c[b+268>>2]|0}if((d|0)>0){g=0;do{e=f+(g<<2)|0;if(e)c[e>>2]=c[(c[b+276>>2]|0)+(g<<2)>>2];g=g+1|0}while((g|0)!=(d|0))}e=c[b+276>>2]|0;if(e){if(a[b+280>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[e+-4>>2]|0);d=c[b+268>>2]|0}c[b+276>>2]=0}a[b+280>>0]=1;c[b+276>>2]=f;c[b+272>>2]=h}e=(c[b+276>>2]|0)+(d<<2)|0;if(e)c[e>>2]=i;c[b+268>>2]=d+1;return}function Ws(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;e=c[b>>2]|0;b=c[a+268>>2]|0;if((b|0)<=0)return;d=c[a+276>>2]|0;h=0;while(1){g=d+(h<<2)|0;f=h+1|0;if((c[g>>2]|0)==(e|0))break;if((f|0)<(b|0))h=f;else{i=7;break}}if((i|0)==7)return;if((h|0)>=(b|0))return;c[g>>2]=c[d+(b+-1<<2)>>2];c[a+268>>2]=b+-1;return}function Xs(b){b=b|0;var d=0;c[b>>2]=5560;d=c[b+284>>2]|0;Jb[c[c[d>>2]>>2]&255](d);d=c[b+284>>2]|0;if(d){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b>>2]=5512;d=c[b+276>>2]|0;if(!d){a[b+280>>0]=1;c[b+276>>2]=0;c[b+268>>2]=0;b=b+272|0;c[b>>2]=0;return}if(a[b+280>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+276>>2]=0;a[b+280>>0]=1;c[b+276>>2]=0;c[b+268>>2]=0;b=b+272|0;c[b>>2]=0;return}function Ys(a){a=a|0;Xs(a);if(!a)return;c[5134]=(c[5134]|0)+1;_E(c[a+-4>>2]|0);return}function Zs(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0;if(!e)e=c[b+188>>2]|0;k=c[d>>2]|0;g=c[b+268>>2]|0;a:do if((g|0)>0){h=c[b+276>>2]|0;i=0;while(1){f=i+1|0;if((c[h+(i<<2)>>2]|0)==(k|0))break;if((f|0)<(g|0))i=f;else break a}if((i|0)!=(g|0))return}while(0);if((g|0)==(c[b+272>>2]|0)?(j=(g|0)==0?1:g<<1,(g|0)<(j|0)):0){if(!j)h=0;else{c[5132]=(c[5132]|0)+1;f=ZE((j<<2|3)+16|0)|0;if(!f)g=0;else{c[(f+19&-16)+-4>>2]=f;g=f+19&-16}h=g;g=c[b+268>>2]|0}if((g|0)>0){i=0;do{f=h+(i<<2)|0;if(f)c[f>>2]=c[(c[b+276>>2]|0)+(i<<2)>>2];i=i+1|0}while((i|0)!=(g|0))}f=c[b+276>>2]|0;if(f){if(a[b+280>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[f+-4>>2]|0);g=c[b+268>>2]|0}c[b+276>>2]=0}a[b+280>>0]=1;c[b+276>>2]=h;c[b+272>>2]=j}f=(c[b+276>>2]|0)+(g<<2)|0;if(f)c[f>>2]=k;c[b+268>>2]=g+1;b=c[b+284>>2]|0;Wb[c[(c[b>>2]|0)+8>>2]&63](b,e,d)|0;return}function _s(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0;k=c[b>>2]|0;if(!e)e=c[a+188>>2]|0;h=c[a+268>>2]|0;if((h|0)<=0)return;i=c[a+276>>2]|0;j=0;while(1){g=i+(j<<2)|0;f=j+1|0;if((c[g>>2]|0)==(k|0))break;if((f|0)<(h|0))j=f;else{l=9;break}}if((l|0)==9)return;if((j|0)>=(h|0))return;c[g>>2]=c[i+(h+-1<<2)>>2];c[a+268>>2]=h+-1;l=c[a+284>>2]|0;Rb[c[(c[l>>2]|0)+12>>2]&31](l,e,b,d)|0;return}function $s(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=+h;var j=0.0,k=0.0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0,z=0,A=0,B=0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0;B=i;i=i+320|0;c[B+0>>2]=c[d+0>>2];c[B+4>>2]=c[d+4>>2];c[B+8>>2]=c[d+8>>2];c[B+12>>2]=c[d+12>>2];c[B+16>>2]=c[d+16>>2];c[B+20>>2]=c[d+20>>2];c[B+24>>2]=c[d+24>>2];c[B+28>>2]=c[d+28>>2];c[B+32>>2]=c[d+32>>2];c[B+36>>2]=c[d+36>>2];c[B+40>>2]=c[d+40>>2];c[B+44>>2]=c[d+44>>2];c[B+48>>2]=c[d+48>>2];c[B+52>>2]=c[d+52>>2];c[B+56>>2]=c[d+56>>2];c[B+60>>2]=c[d+60>>2];c[B+152>>2]=c[e+0>>2];c[B+156>>2]=c[e+4>>2];c[B+160>>2]=c[e+8>>2];c[B+164>>2]=c[e+12>>2];c[B+168>>2]=c[e+16>>2];c[B+172>>2]=c[e+20>>2];c[B+176>>2]=c[e+24>>2];c[B+180>>2]=c[e+28>>2];c[B+184>>2]=c[e+32>>2];c[B+188>>2]=c[e+36>>2];c[B+192>>2]=c[e+40>>2];c[B+196>>2]=c[e+44>>2];c[B+200>>2]=c[e+48>>2];c[B+204>>2]=c[e+52>>2];c[B+208>>2]=c[e+56>>2];c[B+212>>2]=c[e+60>>2];j=+g[B+204>>2]-+g[B+52>>2];G=+g[B+208>>2]-+g[B+56>>2];g[B+96>>2]=+g[B+200>>2]-+g[B+48>>2];g[B+100>>2]=j;g[B+104>>2]=G;g[B+108>>2]=0.0;Kp(B,B+152|0,B+232|0,B+112|0);G=+g[B+112>>2];j=G*+g[B+236>>2];D=G*+g[B+240>>2];g[B+136>>2]=+g[B+232>>2]*G;g[B+140>>2]=j;g[B+144>>2]=D;g[B+148>>2]=0.0;c[B+236>>2]=0;c[B+240>>2]=0;c[B+256>>2]=0;c[B+260>>2]=0;A=B+276|0;c[A+0>>2]=0;c[A+4>>2]=0;c[A+8>>2]=0;c[A+12>>2]=0;c[A+16>>2]=0;Fc(B,B+120|0);D=+g[B+120>>2];j=+g[B+124>>2];G=+g[B+128>>2];E=+g[B+132>>2];C=D*(2.0/(D*D+j*j+G*G+E*E));k=j*(2.0/(D*D+j*j+G*G+E*E));F=G*(2.0/(D*D+j*j+G*G+E*E));g[B+232>>2]=1.0-(j*k+G*F);g[B+236>>2]=D*k-E*F;g[B+240>>2]=D*F+E*k;g[B+244>>2]=0.0;g[B+248>>2]=D*k+E*F;g[B+252>>2]=1.0-(D*C+G*F);g[B+256>>2]=j*F-E*C;g[B+260>>2]=0.0;g[B+264>>2]=D*F-E*k;g[B+268>>2]=j*F+E*C;g[B+272>>2]=1.0-(D*C+j*k);g[A>>2]=0.0;Fy(b,B+232|0,B+96|0,B+136|0,B+216|0,B+296|0);if((c[a+268>>2]|0)<=0){i=B;return}A=0;do{l=c[(c[a+276>>2]|0)+(A<<2)>>2]|0;if(ec[c[(c[f>>2]|0)+8>>2]&31](f,c[l+188>>2]|0)|0?(y=c[l+192>>2]|0,tc[c[(c[y>>2]|0)+8>>2]&127](y,l+4|0,B+80|0,B+64|0),m=+g[B+80>>2]+ +g[B+216>>2],n=+g[B+84>>2]+ +g[B+220>>2],o=+g[B+88>>2]+ +g[B+224>>2],g[B+80>>2]=m,g[B+84>>2]=n,g[B+88>>2]=o,g[B+92>>2]=0.0,p=+g[B+64>>2]+ +g[B+296>>2],q=+g[B+68>>2]+ +g[B+300>>2],r=+g[B+72>>2]+ +g[B+304>>2],g[B+64>>2]=p,g[B+68>>2]=q,g[B+72>>2]=r,g[B+76>>2]=0.0,s=+g[d+48>>2]-(p+m)*.5,t=+g[d+52>>2]-(q+n)*.5,u=+g[d+56>>2]-(r+o)*.5,v=+g[e+48>>2]-(p+m)*.5,w=+g[e+52>>2]-(q+n)*.5,x=+g[e+56>>2]-(r+o)*.5,y=s<-((p-m)*.5)|(s>(p-m)*.5?8:0)|(t>(q-n)*.5?16:0)|(t<-((q-n)*.5)?2:0)|(u>(r-o)*.5?32:0)|(u<-((r-o)*.5)?4:0),z=v<-((p-m)*.5)|(v>(p-m)*.5?8:0)|(w>(q-n)*.5?16:0)|(w<-((q-n)*.5)?2:0)|(x>(r-o)*.5?32:0)|(x<-((r-o)*.5)?4:0),(y&z|0)==0):0){if(s<-((p-m)*.5))if(!((-s-(p-m)*.5)/(v-s)>=0.0)){j=1.0;k=0.0}else{j=1.0;k=(-s-(p-m)*.5)/(v-s)}else if(v<-((p-m)*.5)?(-s-(p-m)*.5)/(v-s)<1.0:0){j=(-s-(p-m)*.5)/(v-s);k=0.0}else{j=1.0;k=0.0}if(t<-((q-n)*.5)){if(k<=(-t-(q-n)*.5)/(w-t))k=(-t-(q-n)*.5)/(w-t)}else if(w<-((q-n)*.5)?(-t-(q-n)*.5)/(w-t)<j:0)j=(-t-(q-n)*.5)/(w-t);if(!(y&4)){if((z&4|0)!=0?(-u-(r-o)*.5)/(x-u)<j:0)j=(-u-(r-o)*.5)/(x-u)}else if(k<=(-u-(r-o)*.5)/(x-u))k=(-u-(r-o)*.5)/(x-u);if(s>(p-m)*.5){if(k<=((p-m)*.5-s)/(v-s))k=((p-m)*.5-s)/(v-s)}else if(v>(p-m)*.5?((p-m)*.5-s)/(v-s)<j:0)j=((p-m)*.5-s)/(v-s);if(t>(q-n)*.5){if(k<=((q-n)*.5-t)/(w-t))k=((q-n)*.5-t)/(w-t)}else if(w>(q-n)*.5?((q-n)*.5-t)/(w-t)<j:0)j=((q-n)*.5-t)/(w-t);if(u>(r-o)*.5){if(k<=((r-o)*.5-u)/(x-u))k=((r-o)*.5-u)/(x-u)}else if(x>(r-o)*.5?((r-o)*.5-u)/(x-u)<j:0)j=((r-o)*.5-u)/(x-u);if(k<=j){H=c[l+192>>2]|0;c[B+232>>2]=0;c[B+236>>2]=H;c[B+240>>2]=l;c[B+244>>2]=l+4;c[B+248>>2]=-1;c[B+252>>2]=-1;fv(b,B,B+152|0,B+232|0,f,h)}}A=A+1|0}while((A|0)<(c[a+268>>2]|0));i=B;return}function at(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0,h=0,j=0,k=0;k=i;i=i+80|0;h=c[c[a>>2]>>2]|0;j=c[c[a+4>>2]>>2]|0;if(!(Wb[c[(c[b>>2]|0)+24>>2]&63](b,h,j)|0)){i=k;return}f=c[h+192>>2]|0;c[k+56>>2]=0;c[k+60>>2]=f;c[k+64>>2]=h;c[k+68>>2]=h+4;c[k+72>>2]=-1;c[k+76>>2]=-1;f=c[j+192>>2]|0;c[k+32>>2]=0;c[k+36>>2]=f;c[k+40>>2]=j;c[k+44>>2]=j+4;c[k+48>>2]=-1;c[k+52>>2]=-1;f=c[a+8>>2]|0;if(!f){f=Rb[c[(c[b>>2]|0)+8>>2]&31](b,k+56|0,k+32|0,0)|0;c[a+8>>2]=f;if(!f){i=k;return}}c[k>>2]=7984;c[k+4>>2]=0;c[k+8>>2]=k+56;c[k+12>>2]=k+32;if((c[d+8>>2]|0)==1){Hb[c[(c[f>>2]|0)+8>>2]&31](f,k+56|0,k+32|0,d,k);i=k;return}e=+Vb[c[(c[f>>2]|0)+12>>2]&15](f,h,j,d,k);if(!(+g[d+12>>2]>e)){i=k;return}g[d+12>>2]=e;i=k;return}function bt(b){b=b|0;var d=0;c[b>>2]=5696;d=c[b+20>>2]|0;if(d){if(a[b+24>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+20>>2]=0}a[b+24>>0]=1;c[b+20>>2]=0;c[b+12>>2]=0;c[b+16>>2]=0;return}function ct(b){b=b|0;var d=0;c[b>>2]=5696;d=c[b+20>>2]|0;if(d){if(a[b+24>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+20>>2]=0}a[b+24>>0]=1;c[b+20>>2]=0;c[b+12>>2]=0;c[b+16>>2]=0;_E(b);return}function dt(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0.0,k=0.0,l=0,m=0,n=0,o=0.0;n=i;i=i+16|0;c[1420]=(c[1420]|0)+1;if(!(c[b+4>>2]&2))f=5432;else{f=c[d+192>>2]|0;j=+jc[c[(c[f>>2]|0)+20>>2]&1](f,.019999999552965164);g[n+4>>2]=j;f=c[e+192>>2]|0;k=+jc[c[(c[f>>2]|0)+20>>2]&1](f,.019999999552965164);g[n>>2]=k;f=j<k?n+4|0:n}j=+g[f>>2];o=+g[d+184>>2];k=+g[e+184>>2];k=o<k?o:k;h=c[b+68>>2]|0;f=c[h+8>>2]|0;if(!f){if(c[b+4>>2]&4){b=0;i=n;return b|0}c[5132]=(c[5132]|0)+1;f=ZE(791)|0;if(!f)l=0;else{c[(f+19&-16)+-4>>2]=f;l=f+19&-16}}else{l=c[h+12>>2]|0;c[h+12>>2]=c[l>>2];c[h+8>>2]=f+-1}c[l>>2]=1025;c[l+116>>2]=0;a[l+120>>0]=0;f=l+124|0;c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;c[f+20>>2]=0;c[f+24>>2]=0;c[f+28>>2]=0;c[l+300>>2]=0;a[l+304>>0]=0;f=l+308|0;c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;c[f+20>>2]=0;c[f+24>>2]=0;c[f+28>>2]=0;c[l+484>>2]=0;a[l+488>>0]=0;f=l+492|0;c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;c[f+20>>2]=0;c[f+24>>2]=0;c[f+28>>2]=0;c[l+668>>2]=0;a[l+672>>0]=0;f=l+676|0;c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;c[f+20>>2]=0;c[f+24>>2]=0;c[f+28>>2]=0;c[l+740>>2]=d;c[l+744>>2]=e;c[l+748>>2]=0;g[l+752>>2]=j;g[l+756>>2]=k;f=c[b+12>>2]|0;c[l+768>>2]=f;if((f|0)==(c[b+16>>2]|0)?(m=(f|0)==0?1:f<<1,(f|0)<(m|0)):0){if(!m)d=0;else{c[5132]=(c[5132]|0)+1;f=ZE((m<<2|3)+16|0)|0;if(!f)f=0;else{c[(f+19&-16)+-4>>2]=f;f=f+19&-16}d=f;f=c[b+12>>2]|0}if((f|0)>0){h=0;do{e=d+(h<<2)|0;if(e)c[e>>2]=c[(c[b+20>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(f|0))}e=c[b+20>>2]|0;if(e){if(a[b+24>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[e+-4>>2]|0);f=c[b+12>>2]|0}c[b+20>>2]=0}a[b+24>>0]=1;c[b+20>>2]=d;c[b+16>>2]=m}e=(c[b+20>>2]|0)+(f<<2)|0;if(e)c[e>>2]=l;c[b+12>>2]=f+1;b=l;i=n;return b|0}function et(a,b){a=a|0;b=b|0;c[b+748>>2]=0;return}function ft(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;c[1420]=(c[1420]|0)+-1;Lb[c[(c[a>>2]|0)+20>>2]&127](a,b);e=c[b+768>>2]|0;d=(c[a+12>>2]|0)+-1|0;g=c[a+20>>2]|0;f=c[g+(e<<2)>>2]|0;c[g+(e<<2)>>2]=c[g+(d<<2)>>2];c[(c[a+20>>2]|0)+(d<<2)>>2]=f;c[(c[(c[a+20>>2]|0)+(e<<2)>>2]|0)+768>>2]=e;c[a+12>>2]=d;a=c[a+68>>2]|0;if(!b)return;g=c[a+16>>2]|0;if(g>>>0<=b>>>0?(g+($(c[a>>2]|0,c[a+4>>2]|0)|0)|0)>>>0>b>>>0:0){c[b>>2]=c[a+12>>2];c[a+12>>2]=b;c[a+8>>2]=(c[a+8>>2]|0)+1;return}c[5134]=(c[5134]|0)+1;_E(c[b+-4>>2]|0);return}function gt(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;i=i+16|0;c[f>>2]=a;c[f+4>>2]=e;a=c[a+((c[(c[b+4>>2]|0)+4>>2]|0)*144|0)+(c[(c[d+4>>2]|0)+4>>2]<<2)+72>>2]|0;a=Rb[c[(c[a>>2]|0)+8>>2]&31](a,f,b,d)|0;i=f;return a|0}function ht(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;b=c[b+204>>2]|0;if((b&4|0)==0?(e=c[d+204>>2]|0,(e&4|0)==0):0)if(!(b&3))b=1;else b=(e&3|0)==0;else b=0;return b|0}function it(a,b,d){a=a|0;b=b|0;d=d|0;a=c[b+216>>2]|0;if((a|0)==2|(a|0)==5?(a=c[d+216>>2]|0,(a|0)==2|(a|0)==5):0){a=0;return a|0}if(!(c[b+256>>2]|0)){a=1;return a|0}a=ec[c[c[b>>2]>>2]&31](b,d)|0;return a|0}function jt(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;i=i+16|0;c[f>>2]=5808;c[f+4>>2]=d;c[f+8>>2]=a;pc[c[(c[b>>2]|0)+48>>2]&127](b,f,e);i=f;return}function kt(a,b){a=a|0;b=b|0;var d=0;a=c[a+64>>2]|0;d=c[a+8>>2]|0;if(d){b=c[a+12>>2]|0;c[a+12>>2]=c[b>>2];c[a+8>>2]=d+-1;return b|0}c[5132]=(c[5132]|0)+1;a=ZE(b+19|0)|0;if(!a){b=0;return b|0}c[(a+19&-16)+-4>>2]=a;b=a+19&-16;return b|0}function lt(a,b){a=a|0;b=b|0;var d=0;a=c[a+64>>2]|0;if(!b)return;d=c[a+16>>2]|0;if(d>>>0<=b>>>0?(d+($(c[a>>2]|0,c[a+4>>2]|0)|0)|0)>>>0>b>>>0:0){c[b>>2]=c[a+12>>2];c[a+12>>2]=b;c[a+8>>2]=(c[a+8>>2]|0)+1;return}c[5134]=(c[5134]|0)+1;_E(c[b+-4>>2]|0);return}function mt(a){a=a|0;return c[a+68>>2]|0}function nt(a){a=a|0;return c[a+68>>2]|0}function ot(a){a=a|0;if(!(c[a+12>>2]|0)){a=0;return a|0}a=c[a+20>>2]|0;return a|0}function pt(a,b){a=a|0;b=b|0;return c[(c[a+20>>2]|0)+(b<<2)>>2]|0}function qt(a){a=a|0;return c[a+12>>2]|0}function rt(a){a=a|0;return}function st(a,b){a=a|0;b=b|0;var d=0;d=c[a+8>>2]|0;pc[c[d+60>>2]&127](b,d,c[a+4>>2]|0);return 0}function tt(a){a=a|0;_E(a);return}function ut(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0,k=0,l=0,m=0;c[b>>2]=5912;c[5132]=(c[5132]|0)+1;e=ZE(379)|0;if(!e)e=0;else{c[(e+19&-16)+-4>>2]=e;e=e+19&-16}g[e+308>>2]=9.999999747378752e-05;j=e+332|0;a[j>>0]=a[j>>0]&-16;c[b+24>>2]=e;j=(c[d+20>>2]|0)==0;c[5132]=(c[5132]|0)+1;e=ZE(23)|0;if(!e)e=0;else{c[(e+19&-16)+-4>>2]=e;e=e+19&-16}i=(e|0)==0;if(j){if(i)e=0;else c[e>>2]=18720;c[b+28>>2]=e}else{if(i)e=0;else c[e>>2]=19144;c[b+28>>2]=e}c[5132]=(c[5132]|0)+1;e=ZE(43)|0;if((e|0)!=0?(k=e+19&-16,c[k+-4>>2]=e,(e+19&-16|0)!=0):0){i=c[b+24>>2]|0;j=c[b+28>>2]|0;a[k+4>>0]=0;c[(e+19&-16)>>2]=10496;c[k+16>>2]=0;c[k+20>>2]=3;c[k+12>>2]=i;c[k+8>>2]=j;e=e+19&-16}else e=0;c[b+32>>2]=e;c[5132]=(c[5132]|0)+1;e=ZE(27)|0;if((e|0)!=0?(c[(e+19&-16)+-4>>2]=e,(e+19&-16|0)!=0):0){a[(e+19&-16)+4>>0]=0;c[(e+19&-16)>>2]=6920;e=e+19&-16}else e=0;c[b+36>>2]=e;c[5132]=(c[5132]|0)+1;e=ZE(27)|0;if((e|0)!=0?(c[(e+19&-16)+-4>>2]=e,(e+19&-16|0)!=0):0){a[(e+19&-16)+4>>0]=0;c[(e+19&-16)>>2]=6816;e=e+19&-16}else e=0;c[b+40>>2]=e;c[5132]=(c[5132]|0)+1;e=ZE(27)|0;if((e|0)!=0?(c[(e+19&-16)+-4>>2]=e,(e+19&-16|0)!=0):0){a[(e+19&-16)+4>>0]=0;c[(e+19&-16)>>2]=6728;e=e+19&-16}else e=0;c[b+44>>2]=e;c[5132]=(c[5132]|0)+1;e=ZE(27)|0;if((e|0)!=0?(c[(e+19&-16)+-4>>2]=e,(e+19&-16|0)!=0):0){a[(e+19&-16)+4>>0]=0;c[(e+19&-16)>>2]=6632;e=e+19&-16}else e=0;c[b+48>>2]=e;c[5132]=(c[5132]|0)+1;e=ZE(27)|0;if((e|0)!=0?(c[(e+19&-16)+-4>>2]=e,(e+19&-16|0)!=0):0){a[(e+19&-16)+4>>0]=0;c[(e+19&-16)>>2]=6536;e=e+19&-16}else e=0;c[b+52>>2]=e;c[5132]=(c[5132]|0)+1;e=ZE(27)|0;if((e|0)!=0?(c[(e+19&-16)+-4>>2]=e,(e+19&-16|0)!=0):0){a[(e+19&-16)+4>>0]=0;c[(e+19&-16)>>2]=6456;e=e+19&-16}else e=0;c[b+56>>2]=e;c[5132]=(c[5132]|0)+1;e=ZE(27)|0;if((e|0)!=0?(c[(e+19&-16)+-4>>2]=e,(e+19&-16|0)!=0):0){a[(e+19&-16)+4>>0]=0;c[(e+19&-16)>>2]=6360;e=e+19&-16}else e=0;c[b+60>>2]=e;c[5132]=(c[5132]|0)+1;e=ZE(27)|0;if((e|0)!=0?(c[(e+19&-16)+-4>>2]=e,(e+19&-16|0)!=0):0){a[(e+19&-16)+4>>0]=0;c[(e+19&-16)>>2]=6264;e=e+19&-16}else e=0;c[b+76>>2]=e;c[5132]=(c[5132]|0)+1;e=ZE(27)|0;if((e|0)!=0?(c[(e+19&-16)+-4>>2]=e,(e+19&-16|0)!=0):0){a[(e+19&-16)+4>>0]=0;c[(e+19&-16)>>2]=6264;e=e+19&-16}else e=0;c[b+80>>2]=e;a[e+4>>0]=1;c[5132]=(c[5132]|0)+1;e=ZE(27)|0;if((e|0)!=0?(c[(e+19&-16)+-4>>2]=e,(e+19&-16|0)!=0):0){a[(e+19&-16)+4>>0]=0;c[(e+19&-16)>>2]=6176;e=e+19&-16}else e=0;c[b+72>>2]=e;c[5132]=(c[5132]|0)+1;e=ZE(35)|0;if((e|0)!=0?(l=e+19&-16,c[l+-4>>2]=e,(e+19&-16|0)!=0):0){a[l+4>>0]=0;c[(e+19&-16)>>2]=6040;c[l+8>>2]=1;c[l+12>>2]=0;e=e+19&-16}else e=0;c[b+88>>2]=e;c[5132]=(c[5132]|0)+1;e=ZE(35)|0;if((e|0)!=0?(h=e+19&-16,c[h+-4>>2]=e,(e+19&-16|0)!=0):0){a[h+4>>0]=0;c[(e+19&-16)>>2]=6040;c[h+8>>2]=1;c[h+12>>2]=0;e=e+19&-16}else e=0;c[b+84>>2]=e;a[e+4>>0]=1;l=c[d+16>>2]|0;l=(l|0)>80?l:80;e=c[d>>2]|0;if(!e){a[b+12>>0]=1;c[5132]=(c[5132]|0)+1;k=ZE(39)|0;do if(!k)e=0;else{i=k+19&-16;c[i+-4>>2]=k;if(!(k+19&-16)){e=0;break}e=c[d+8>>2]|0;c[(k+19&-16)>>2]=772;c[i+4>>2]=e;c[5132]=(c[5132]|0)+1;e=ZE((e*772|3)+16|0)|0;if(!e)e=0;else{c[(e+19&-16)+-4>>2]=e;e=e+19&-16}c[i+16>>2]=e;c[i+12>>2]=e;f=c[i+4>>2]|0;c[i+8>>2]=f;if(f+-1|0){j=c[(k+19&-16)>>2]|0;i=f+-1|0;h=e;do{m=h;h=h+j|0;c[m>>2]=h;i=i+-1|0}while((i|0)!=0);e=e+($(j,f+-1|0)|0)|0}c[e>>2]=0;e=k+19&-16}while(0);c[b+8>>2]=e}else{a[b+12>>0]=0;c[b+8>>2]=e}e=c[d+4>>2]|0;if(e){a[b+20>>0]=0;c[b+16>>2]=e;return}a[b+20>>0]=1;c[5132]=(c[5132]|0)+1;k=ZE(39)|0;do if(!k)e=0;else{i=k+19&-16;c[i+-4>>2]=k;if(!(k+19&-16)){e=0;break}e=c[d+12>>2]|0;c[(k+19&-16)>>2]=l;c[i+4>>2]=e;e=$(e,l)|0;c[5132]=(c[5132]|0)+1;e=ZE(e+19|0)|0;if(!e)e=0;else{c[(e+19&-16)+-4>>2]=e;e=e+19&-16}c[i+16>>2]=e;c[i+12>>2]=e;j=c[i+4>>2]|0;c[i+8>>2]=j;if(j+-1|0){f=c[(k+19&-16)>>2]|0;h=j+-1|0;i=e;do{m=i;i=i+f|0;c[m>>2]=i;h=h+-1|0}while((h|0)!=0);e=e+($(f,j+-1|0)|0)|0}c[e>>2]=0;e=k+19&-16}while(0);c[b+16>>2]=e;return}function vt(b){b=b|0;var d=0,e=0;c[b>>2]=5912;if(a[b+20>>0]|0){d=c[b+16>>2]|0;e=c[d+16>>2]|0;if(e){c[5134]=(c[5134]|0)+1;_E(c[e+-4>>2]|0);d=c[b+16>>2]|0}if(d){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}}if(a[b+12>>0]|0){d=c[b+8>>2]|0;e=c[d+16>>2]|0;if(e){c[5134]=(c[5134]|0)+1;_E(c[e+-4>>2]|0);d=c[b+8>>2]|0}if(d){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}}d=c[b+32>>2]|0;Jb[c[c[d>>2]>>2]&255](d);d=c[b+32>>2]|0;if(d){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}d=c[b+36>>2]|0;Jb[c[c[d>>2]>>2]&255](d);d=c[b+36>>2]|0;if(d){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}d=c[b+40>>2]|0;Jb[c[c[d>>2]>>2]&255](d);d=c[b+40>>2]|0;if(d){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}d=c[b+44>>2]|0;Jb[c[c[d>>2]>>2]&255](d);d=c[b+44>>2]|0;if(d){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}d=c[b+48>>2]|0;Jb[c[c[d>>2]>>2]&255](d);d=c[b+48>>2]|0;if(d){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}d=c[b+52>>2]|0;Jb[c[c[d>>2]>>2]&255](d);d=c[b+52>>2]|0;if(d){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}d=c[b+56>>2]|0;Jb[c[c[d>>2]>>2]&255](d);d=c[b+56>>2]|0;if(d){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}d=c[b+60>>2]|0;Jb[c[c[d>>2]>>2]&255](d);d=c[b+60>>2]|0;if(d){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}d=c[b+76>>2]|0;Jb[c[c[d>>2]>>2]&255](d);d=c[b+76>>2]|0;if(d){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}d=c[b+80>>2]|0;Jb[c[c[d>>2]>>2]&255](d);d=c[b+80>>2]|0;if(d){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}d=c[b+72>>2]|0;Jb[c[c[d>>2]>>2]&255](d);d=c[b+72>>2]|0;if(d){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}d=c[b+88>>2]|0;Jb[c[c[d>>2]>>2]&255](d);d=c[b+88>>2]|0;if(d){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}d=c[b+84>>2]|0;Jb[c[c[d>>2]>>2]&255](d);d=c[b+84>>2]|0;if(d){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}d=c[b+24>>2]|0;if(d){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}d=c[b+28>>2]|0;Jb[c[c[d>>2]>>2]&255](d);d=c[b+28>>2]|0;if(!d)return;c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0);return}function wt(a){a=a|0;vt(a);_E(a);return}function xt(a,b,d){a=a|0;b=b|0;d=d|0;do if(!((b|0)==8&(d|0)==8)){if((b|0)==8&(d|0)==1){b=a+76|0;break}if((b|0)==1&(d|0)==8){b=a+80|0;break}if(!(d|b)){b=a+72|0;break}if((b|0)<20&(d|0)==28){b=a+88|0;break}if((d|0)<20&(b|0)==28){b=a+84|0;break}if((b|0)<20){if((d|0)<20){b=a+32|0;break}if((d+-21|0)>>>0<9){b=a+36|0;break}}else if((d|0)<20&(b+-21|0)>>>0<9){b=a+40|0;break}if((b|0)==31)if((d|0)==31){b=a+48|0;break}else{b=a+44|0;break}else if((d|0)==31){b=a+52|0;break}else{b=a+56|0;break}}else b=a+60|0;while(0);return c[b>>2]|0}function yt(a){a=a|0;return c[a+24>>2]|0}function zt(a){a=a|0;return c[a+16>>2]|0}function At(a){a=a|0;return c[a+8>>2]|0}function Bt(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0;g=c[d>>2]|0;g=ec[c[(c[g>>2]|0)+56>>2]&31](g,28)|0;if(!(a[b+4>>0]|0)){if(!g){b=0;return b|0}i=c[b+8>>2]|0;h=c[b+12>>2]|0;b=c[d>>2]|0;c[g+4>>2]=b;c[g>>2]=7128;a[g+8>>0]=0;c[g+12>>2]=0;a[g+16>>0]=0;c[g+20>>2]=i;c[g+24>>2]=h;if(!(Wb[c[(c[b>>2]|0)+24>>2]&63](b,c[e+8>>2]|0,c[f+8>>2]|0)|0)){i=g;return i|0}i=c[g+4>>2]|0;c[g+12>>2]=Wb[c[(c[i>>2]|0)+12>>2]&63](i,c[e+8>>2]|0,c[f+8>>2]|0)|0;a[g+8>>0]=1;i=g;return i|0}else{if(!g){i=0;return i|0}j=c[b+8>>2]|0;h=c[b+12>>2]|0;i=c[d>>2]|0;c[g+4>>2]=i;c[g>>2]=7128;a[g+8>>0]=0;c[g+12>>2]=0;a[g+16>>0]=1;c[g+20>>2]=j;c[g+24>>2]=h;if(!(Wb[c[(c[i>>2]|0)+24>>2]&63](i,c[f+8>>2]|0,c[e+8>>2]|0)|0)){j=g;return j|0}j=c[g+4>>2]|0;c[g+12>>2]=Wb[c[(c[j>>2]|0)+12>>2]&63](j,c[f+8>>2]|0,c[e+8>>2]|0)|0;a[g+8>>0]=1;j=g;return j|0}return 0}function Ct(a){a=a|0;_E(a);return}function Dt(a){a=a|0;return}function Et(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;b=c[d>>2]|0;b=ec[c[(c[b>>2]|0)+56>>2]&31](b,16)|0;if(!b){d=0;return d|0}d=c[d>>2]|0;c[b+4>>2]=d;c[b>>2]=7904;a[b+8>>0]=0;c[b+12>>2]=0;if(!(Wb[c[(c[d>>2]|0)+24>>2]&63](d,c[e+8>>2]|0,c[f+8>>2]|0)|0)){d=b;return d|0}d=c[b+4>>2]|0;c[b+12>>2]=Wb[c[(c[d>>2]|0)+12>>2]&63](d,c[e+8>>2]|0,c[f+8>>2]|0)|0;a[b+8>>0]=1;d=b;return d|0}function Ft(a){a=a|0;_E(a);return}function Gt(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0;g=c[d>>2]|0;g=ec[c[(c[g>>2]|0)+56>>2]&31](g,20)|0;if(!g){f=0;return f|0}h=c[d+4>>2]|0;b=a[b+4>>0]|0;d=c[d>>2]|0;c[g+4>>2]=d;c[g>>2]=10408;a[g+8>>0]=0;c[g+12>>2]=h;a[g+16>>0]=b;if(h){h=g;return h|0}c[g+12>>2]=Wb[c[(c[d>>2]|0)+12>>2]&63](d,c[e+8>>2]|0,c[f+8>>2]|0)|0;a[g+8>>0]=1;h=g;return h|0}function Ht(a){a=a|0;_E(a);return}function It(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;b=c[d>>2]|0;b=ec[c[(c[b>>2]|0)+56>>2]&31](b,16)|0;if(!b){f=0;return f|0}d=c[d>>2]|0;c[b+4>>2]=d;c[b>>2]=19768;a[b+8>>0]=0;c[b+12>>2]=0;c[b+12>>2]=Wb[c[(c[d>>2]|0)+12>>2]&63](d,c[e+8>>2]|0,c[f+8>>2]|0)|0;a[b+8>>0]=1;f=b;return f|0}function Jt(a){a=a|0;_E(a);return}function Kt(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;d=c[b>>2]|0;d=ec[c[(c[d>>2]|0)+56>>2]&31](d,8)|0;if(!d){b=0;return b|0}c[d+4>>2]=c[b>>2];c[d>>2]=19696;b=d;return b|0}function Lt(a){a=a|0;_E(a);return}function Mt(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;a=c[b>>2]|0;a=ec[c[(c[a>>2]|0)+56>>2]&31](a,44)|0;if(!a){b=0;return b|0}uw(a,c[b>>2]|0,c[b+4>>2]|0,d,e,1);b=a;return b|0}function Nt(a){a=a|0;_E(a);return}function Ot(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0;k=c[d>>2]|0;k=ec[c[(c[k>>2]|0)+56>>2]&31](k,48)|0;if(!k){f=0;return f|0}c[k+4>>2]=c[d>>2];c[k>>2]=11280;a[k+28>>0]=1;c[k+24>>2]=0;c[k+16>>2]=0;c[k+20>>2]=0;c[k+32>>2]=c[d+4>>2];a[k+36>>0]=0;c[5132]=(c[5132]|0)+1;i=ZE(87)|0;if((i|0)!=0?(j=i+19&-16,c[j+-4>>2]=i,(i+19&-16|0)!=0):0){c[(i+19&-16)>>2]=20016;a[j+20>>0]=1;c[j+16>>2]=0;c[j+8>>2]=0;c[j+12>>2]=0;a[j+24>>0]=0;a[j+44>>0]=1;c[j+40>>2]=0;c[j+32>>2]=0;c[j+36>>2]=0;a[j+64>>0]=1;c[j+60>>2]=0;c[j+52>>2]=0;c[j+56>>2]=0;c[5132]=(c[5132]|0)+1;b=ZE(43)|0;if(!b)h=0;else{c[(b+19&-16)+-4>>2]=b;h=b+19&-16}d=c[j+8>>2]|0;if((d|0)>0){g=0;do{b=h+(g*12|0)|0;if(b){l=(c[j+16>>2]|0)+(g*12|0)|0;c[b+0>>2]=c[l+0>>2];c[b+4>>2]=c[l+4>>2];c[b+8>>2]=c[l+8>>2]}g=g+1|0}while((g|0)!=(d|0))}d=c[j+16>>2]|0;if(d){if(a[j+20>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[j+16>>2]=0}a[j+20>>0]=1;c[j+16>>2]=h;c[j+12>>2]=2;OD(i+19&-16);b=i+19&-16}else b=0;c[k+8>>2]=b;c[k+40>>2]=c[(c[e+4>>2]|0)+68>>2];c[k+44>>2]=c[(c[f+4>>2]|0)+68>>2];l=k;return l|0}function Pt(a){a=a|0;_E(a);return}function Qt(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;a=c[b>>2]|0;a=ec[c[(c[a>>2]|0)+56>>2]&31](a,44)|0;if(!a){b=0;return b|0}uw(a,c[b>>2]|0,c[b+4>>2]|0,d,e,0);b=a;return b|0}function Rt(a){a=a|0;_E(a);return}function St(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;b=c[d>>2]|0;b=ec[c[(c[b>>2]|0)+56>>2]&31](b,80)|0;if(!b){d=0;return d|0}d=c[d>>2]|0;c[b+4>>2]=d;c[b>>2]=7248;a[b+8>>0]=1;c[b+12>>2]=7280;c[b+60>>2]=d;c[b+64>>2]=0;c[b+16>>2]=f;c[b+20>>2]=e;d=Wb[c[(c[d>>2]|0)+12>>2]&63](d,c[f+8>>2]|0,c[e+8>>2]|0)|0;c[b+76>>2]=d;f=c[b+60>>2]|0;Lb[c[(c[f>>2]|0)+20>>2]&127](f,d);d=b;return d|0}function Tt(a){a=a|0;_E(a);return}function Ut(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;b=c[d>>2]|0;b=ec[c[(c[b>>2]|0)+56>>2]&31](b,80)|0;if(!b){d=0;return d|0}d=c[d>>2]|0;c[b+4>>2]=d;c[b>>2]=7248;a[b+8>>0]=0;c[b+12>>2]=7280;c[b+60>>2]=d;c[b+64>>2]=0;c[b+16>>2]=e;c[b+20>>2]=f;d=Wb[c[(c[d>>2]|0)+12>>2]&63](d,c[e+8>>2]|0,c[f+8>>2]|0)|0;c[b+76>>2]=d;f=c[b+60>>2]|0;Lb[c[(c[f>>2]|0)+20>>2]&127](f,d);d=b;return d|0}function Vt(a){a=a|0;_E(a);return}function Wt(b){b=b|0;var d=0;c[b>>2]=7016;d=c[b+56>>2]|0;if(d){if(a[b+60>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+56>>2]=0}a[b+60>>0]=1;c[b+56>>2]=0;c[b+48>>2]=0;c[b+52>>2]=0;d=c[b+36>>2]|0;if(d){if(a[b+40>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;d=c[b+16>>2]|0;if(!d){d=b+12|0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;c[d>>2]=0;return}if(a[b+20>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+16>>2]=0;d=b+12|0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;c[d>>2]=0;return}function Xt(a){a=a|0;Wt(a);_E(a);return}function Yt(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,i=0,j=0,k=0,l=0,m=0;f=c[d+8>>2]|0;if((f|0)>0){e=c[d+16>>2]|0;j=0;h=0;do{i=c[e+(j<<2)>>2]|0;if(!(c[i+204>>2]&3)){c[i+208>>2]=h;h=h+1|0}c[i+212>>2]=-1;g[i+244>>2]=1.0;j=j+1|0}while((j|0)!=(f|0));k=h}else k=0;i=c[b+8>>2]|0;if((i|0)<(k|0)){if((c[b+12>>2]|0)<(k|0)){if(!k){f=0;h=i}else{c[5132]=(c[5132]|0)+1;e=ZE((k<<3|3)+16|0)|0;if(!e)f=0;else{c[(e+19&-16)+-4>>2]=e;f=e+19&-16}h=c[b+8>>2]|0}if((h|0)>0){j=0;do{e=f+(j<<3)|0;if(e){m=(c[b+16>>2]|0)+(j<<3)|0;l=c[m+4>>2]|0;c[e>>2]=c[m>>2];c[e+4>>2]=l}j=j+1|0}while((j|0)!=(h|0))}e=c[b+16>>2]|0;if(e){if(a[b+20>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[e+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=f;c[b+12>>2]=k;h=b+16|0}else h=b+16|0;e=i;do{f=(c[h>>2]|0)+(e<<3)|0;if(f){c[f>>2]=0;c[f+4>>2]=0}e=e+1|0}while((e|0)!=(k|0))}c[b+8>>2]=k;if((k|0)>0){e=c[b+16>>2]|0;f=0;do{c[e+(f<<3)>>2]=f;c[e+(f<<3)+4>>2]=1;f=f+1|0}while((f|0)!=(k|0))}e=c[d+68>>2]|0;e=Nb[c[(c[e>>2]|0)+36>>2]&127](e)|0;d=Nb[c[(c[e>>2]|0)+36>>2]&127](e)|0;if(!d)return;e=Nb[c[(c[e>>2]|0)+20>>2]&127](e)|0;if((d|0)<=0)return;l=0;do{f=c[c[e+(l<<4)>>2]>>2]|0;h=c[c[e+(l<<4)+4>>2]>>2]|0;if(((f|0)!=0?((h|0)!=0?(c[f+204>>2]&7|0)==0:0):0)?(c[h+204>>2]&7|0)==0:0){i=c[f+208>>2]|0;f=c[h+208>>2]|0;k=c[b+16>>2]|0;h=c[k+(i<<3)>>2]|0;if((h|0)!=(i|0)){j=k+(i<<3)|0;do{i=k+(h<<3)|0;c[j>>2]=c[i>>2];i=c[i>>2]|0;j=k+(i<<3)|0;h=c[j>>2]|0}while((i|0)!=(h|0))}h=c[k+(f<<3)>>2]|0;if((h|0)!=(f|0)){j=k+(f<<3)|0;do{f=k+(h<<3)|0;c[j>>2]=c[f>>2];f=c[f>>2]|0;j=k+(f<<3)|0;h=c[j>>2]|0}while((f|0)!=(h|0))}if((i|0)!=(f|0)){c[k+(i<<3)>>2]=f;m=k+(f<<3)+4|0;c[m>>2]=(c[m>>2]|0)+(c[k+(i<<3)+4>>2]|0)}}l=l+1|0}while((l|0)!=(d|0));return}function Zt(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;k=c[b+8>>2]|0;if((k|0)<=0)return;i=c[b+16>>2]|0;j=0;b=0;do{h=c[i+(j<<2)>>2]|0;if(!(c[h+204>>2]&3)){g=c[a+16>>2]|0;e=g+(b<<3)|0;d=c[e>>2]|0;if((d|0)==(b|0))d=b;else{f=d;do{d=g+(f<<3)|0;c[e>>2]=c[d>>2];d=c[d>>2]|0;e=g+(d<<3)|0;f=c[e>>2]|0}while((d|0)!=(f|0))}c[h+208>>2]=d;c[g+(b<<3)+4>>2]=j;c[h+212>>2]=-1;b=b+1|0}else{c[h+208>>2]=-1;c[h+212>>2]=-2}j=j+1|0}while((j|0)!=(k|0));return}function _t(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;while(1){k=c[a+12>>2]|0;l=c[k+(((b+d|0)/2|0)<<2)>>2]|0;e=b;f=d;while(1){j=c[(c[l+740>>2]|0)+208>>2]|0;if((j|0)>-1)while(1){h=c[k+(e<<2)>>2]|0;g=c[(c[h+740>>2]|0)+208>>2]|0;if((g|0)<=-1)g=c[(c[h+744>>2]|0)+208>>2]|0;if((g|0)<(j|0))e=e+1|0;else break}else{i=c[(c[l+744>>2]|0)+208>>2]|0;while(1){h=c[k+(e<<2)>>2]|0;g=c[(c[h+740>>2]|0)+208>>2]|0;if((g|0)<=-1)g=c[(c[h+744>>2]|0)+208>>2]|0;if((g|0)<(i|0))e=e+1|0;else break}}if((j|0)>-1)while(1){i=c[k+(f<<2)>>2]|0;g=c[(c[i+740>>2]|0)+208>>2]|0;if((g|0)<=-1)g=c[(c[i+744>>2]|0)+208>>2]|0;if((j|0)<(g|0))f=f+-1|0;else{g=i;break}}else{j=c[(c[l+744>>2]|0)+208>>2]|0;while(1){i=c[k+(f<<2)>>2]|0;g=c[(c[i+740>>2]|0)+208>>2]|0;if((g|0)<=-1)g=c[(c[i+744>>2]|0)+208>>2]|0;if((j|0)<(g|0))f=f+-1|0;else{g=i;break}}}if((e|0)<=(f|0)){c[k+(e<<2)>>2]=g;c[(c[a+12>>2]|0)+(f<<2)>>2]=h;e=e+1|0;f=f+-1|0}if((e|0)>(f|0))break;k=c[a+12>>2]|0}if((f|0)>(b|0))_t(a,b,f);if((e|0)<(d|0))b=e;else break}return}function $t(b){b=b|0;var d=0;c[b>>2]=7128;if(!(a[b+8>>0]|0))return;d=c[b+12>>2]|0;if(!d)return;b=c[b+4>>2]|0;Lb[c[(c[b>>2]|0)+16>>2]&127](b,d);return}function au(b){b=b|0;var d=0,e=0;c[b>>2]=7128;if(!(a[b+8>>0]|0)){_E(b);return}d=c[b+12>>2]|0;if(!d){_E(b);return}e=c[b+4>>2]|0;Lb[c[(c[e>>2]|0)+16>>2]&127](e,d);_E(b);return}function bu(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0,K=0,L=0.0,M=0.0,N=0.0,Q=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0,aa=0.0,ba=0.0,ca=0.0,da=0.0,ea=0.0,fa=0.0,ga=0.0;J=i;i=i+128|0;if(!(c[b+12>>2]|0)){i=J;return}l=(a[b+16>>0]|0)!=0;K=l?e:d;l=l?d:e;k=c[K+4>>2]|0;j=c[l+4>>2]|0;K=c[K+12>>2]|0;C=+g[K>>2];B=+g[K+16>>2];A=+g[K+32>>2];y=+g[K+4>>2];x=+g[K+20>>2];w=+g[K+36>>2];u=+g[K+8>>2];s=+g[K+24>>2];q=+g[K+40>>2];F=+g[K+48>>2];G=+g[K+52>>2];H=+g[K+56>>2];K=c[l+12>>2]|0;Q=+g[K>>2];N=+g[K+16>>2];o=+g[K+32>>2];M=+g[K+4>>2];L=+g[K+20>>2];n=+g[K+36>>2];t=+g[K+8>>2];r=+g[K+24>>2];p=+g[K+40>>2];I=-+g[K+48>>2];E=-+g[K+52>>2];D=-+g[K+56>>2];K=c[(c[k>>2]|0)+64>>2]|0;m=-+g[j+48>>2];v=-+g[j+52>>2];z=-+g[j+56>>2];g[J>>2]=(C*Q+B*N+A*o)*m+(C*M+B*L+A*n)*v+(C*t+B*r+A*p)*z;g[J+4>>2]=(y*Q+x*N+w*o)*m+(y*M+x*L+w*n)*v+(y*t+x*r+w*p)*z;g[J+8>>2]=(u*Q+s*N+q*o)*m+(u*M+s*L+q*n)*v+(u*t+s*r+q*p)*z;g[J+12>>2]=0.0;pc[K&127](J+112|0,k,J);z=+g[J+112>>2];v=+g[J+116>>2];m=+g[J+120>>2];o=F*Q+G*N+H*o+(Q*I+N*E+o*D)+((C*Q+B*N+A*o)*z+(y*Q+x*N+w*o)*v+(u*Q+s*N+q*o)*m);n=F*M+G*L+H*n+(M*I+L*E+n*D)+((C*M+B*L+A*n)*z+(y*M+x*L+w*n)*v+(u*M+s*L+q*n)*m);m=F*t+G*r+H*p+(t*I+r*E+p*D)+((C*t+B*r+A*p)*z+(y*t+x*r+w*p)*v+(u*t+s*r+q*p)*m);p=+g[j+48>>2];q=+g[j+52>>2];r=+g[j+56>>2];s=r*m+(p*o+q*n)-+g[j+64>>2];K=c[l+12>>2]|0;t=+g[K>>2];u=+g[K+4>>2];v=+g[K+8>>2];w=+g[K+16>>2];x=+g[K+20>>2];y=+g[K+24>>2];z=+g[K+32>>2];A=+g[K+36>>2];B=+g[K+40>>2];C=+g[K+48>>2];D=+g[K+52>>2];E=+g[K+56>>2];K=c[b+12>>2]|0;f=s<+g[K+752>>2];c[h+4>>2]=K;if(f){K=c[l+12>>2]|0;N=p*+g[K+16>>2]+q*+g[K+20>>2]+r*+g[K+24>>2];Q=p*+g[K+32>>2]+q*+g[K+36>>2]+r*+g[K+40>>2];g[J+48>>2]=+g[K>>2]*p+ +g[K+4>>2]*q+ +g[K+8>>2]*r;g[J+52>>2]=N;g[J+56>>2]=Q;g[J+60>>2]=0.0;g[J+96>>2]=v*(m-r*s)+(t*(o-p*s)+u*(n-q*s))+C;g[J+100>>2]=(o-p*s)*w+(n-q*s)*x+(m-r*s)*y+D;g[J+104>>2]=(o-p*s)*z+(n-q*s)*A+(m-r*s)*B+E;g[J+108>>2]=0.0;oc[c[(c[h>>2]|0)+16>>2]&15](h,J+48|0,J+96|0,s)}if((c[k+4>>2]|0)<7?(c[(c[h+4>>2]|0)+748>>2]|0)<(c[b+24>>2]|0):0){m=+g[j+56>>2];if(+O(+m)>.7071067690849304){Q=+g[j+52>>2];o=1.0/+P(+(m*m+Q*Q));n=0.0;m=-(m*o);o=Q*o}else{o=+g[j+48>>2];n=+g[j+52>>2];m=1.0/+P(+(o*o+n*n));n=-(n*m);m=o*m;o=0.0}G=.019999999552965164/+Zb[c[(c[k>>2]|0)+16>>2]&15](k);F=+P(+(o*o+(m*m+n*n)));G=G>.39269909262657166?.19634954631328583:G*.5;F=+S(+G)/F;I=n*F;H=m*F;F=o*F;G=+R(+G);l=c[b+20>>2]|0;if((l|0)>0){k=0;do{u=+g[j+48>>2];Q=+g[j+52>>2];o=+g[j+56>>2];q=+(k|0)*(6.2831854820251465/+(l|0))*.5;N=+S(+q)/+P(+(u*u+Q*Q+o*o));q=+R(+q);p=F*-(Q*N)+(I*q+G*-(u*N))-H*-(o*N);s=I*-(o*N)+(H*q+G*-(Q*N))-F*-(u*N);fa=H*-(u*N)+(F*q+G*-(o*N))-I*-(Q*N);m=G*q-I*-(u*N)-H*-(Q*N)-F*-(o*N);C=o*N*s+(u*N*m+q*p)-Q*N*fa;D=u*N*fa+(q*s+Q*N*m)-o*N*p;ba=Q*N*p+(o*N*m+q*fa)-u*N*s;fa=q*m-u*N*p-Q*N*s-o*N*fa;l=(a[b+16>>0]|0)!=0;$=l?e:d;l=l?d:e;K=c[$+4>>2]|0;f=c[l+4>>2]|0;$=c[$+12>>2]|0;N=+g[$>>2];o=+g[$+4>>2];s=+g[$+8>>2];Q=+g[$+16>>2];p=+g[$+20>>2];u=+g[$+24>>2];m=+g[$+32>>2];q=+g[$+36>>2];w=+g[$+40>>2];W=+g[$+48>>2];V=+g[$+52>>2];U=+g[$+56>>2];$=c[l+12>>2]|0;_=+g[$>>2];Z=+g[$+16>>2];A=+g[$+32>>2];Y=+g[$+4>>2];X=+g[$+20>>2];z=+g[$+36>>2];t=+g[$+8>>2];v=+g[$+24>>2];x=+g[$+40>>2];T=-+g[$+48>>2];L=-+g[$+52>>2];M=-+g[$+56>>2];n=C*(2.0/(C*C+D*D+ba*ba+fa*fa));E=D*(2.0/(C*C+D*D+ba*ba+fa*fa));ga=ba*(2.0/(C*C+D*D+ba*ba+fa*fa));da=s*(C*ga-fa*E)+(o*(C*E+fa*ga)+N*(1.0-(D*E+ba*ga)));aa=s*(D*ga+fa*n)+(N*(C*E-fa*ga)+o*(1.0-(C*n+ba*ga)));y=N*(C*ga+fa*E)+o*(D*ga-fa*n)+s*(1.0-(C*n+D*E));ca=u*(C*ga-fa*E)+(p*(C*E+fa*ga)+Q*(1.0-(D*E+ba*ga)));B=u*(D*ga+fa*n)+(Q*(C*E-fa*ga)+p*(1.0-(C*n+ba*ga)));r=Q*(C*ga+fa*E)+p*(D*ga-fa*n)+u*(1.0-(C*n+D*E));ea=w*(C*ga-fa*E)+(q*(C*E+fa*ga)+m*(1.0-(D*E+ba*ga)));ba=w*(D*ga+fa*n)+(m*(C*E-fa*ga)+q*(1.0-(C*n+ba*ga)));E=m*(C*ga+fa*E)+q*(D*ga-fa*n)+w*(1.0-(C*n+D*E));$=c[(c[K>>2]|0)+64>>2]|0;D=-+g[f+48>>2];n=-+g[f+52>>2];C=-+g[f+56>>2];g[J+64>>2]=(x*ea+(t*da+v*ca))*C+((A*ea+(_*da+Z*ca))*D+(z*ea+(Y*da+X*ca))*n);g[J+68>>2]=(x*ba+(t*aa+v*B))*C+((A*ba+(_*aa+Z*B))*D+(z*ba+(Y*aa+X*B))*n);g[J+72>>2]=(x*E+(t*y+v*r))*C+((A*E+(_*y+Z*r))*D+(z*E+(Y*y+X*r))*n);g[J+76>>2]=0.0;pc[$&127](J+16|0,K,J+64|0);n=+g[J+16>>2];r=+g[J+20>>2];y=+g[J+24>>2];E=+g[f+48>>2];D=+g[f+52>>2];C=+g[f+56>>2];B=C*(W*t+V*v+U*x+(t*T+v*L+x*M)+((N*t+Q*v+m*x)*n+(o*t+p*v+q*x)*r+(s*t+u*v+w*x)*y))+(E*(W*_+V*Z+U*A+(_*T+Z*L+A*M)+((N*_+Q*Z+m*A)*n+(o*_+p*Z+q*A)*r+(s*_+u*Z+w*A)*y))+D*(W*Y+V*X+U*z+(Y*T+X*L+z*M)+((N*Y+Q*X+m*z)*n+(o*Y+p*X+q*z)*r+(s*Y+u*X+w*z)*y)))-+g[f+64>>2];A=W*_+V*Z+U*A+(_*T+Z*L+A*M)+((N*_+Q*Z+m*A)*n+(o*_+p*Z+q*A)*r+(s*_+u*Z+w*A)*y)-E*B;z=W*Y+V*X+U*z+(Y*T+X*L+z*M)+((N*Y+Q*X+m*z)*n+(o*Y+p*X+q*z)*r+(s*Y+u*X+w*z)*y)-D*B;y=W*t+V*v+U*x+(t*T+v*L+x*M)+((N*t+Q*v+m*x)*n+(o*t+p*v+q*x)*r+(s*t+u*v+w*x)*y)-C*B;f=c[l+12>>2]|0;x=+g[f>>2];w=+g[f+4>>2];v=+g[f+8>>2];u=+g[f+16>>2];t=+g[f+20>>2];s=+g[f+24>>2];r=+g[f+32>>2];q=+g[f+36>>2];p=+g[f+40>>2];o=+g[f+48>>2];n=+g[f+52>>2];m=+g[f+56>>2];f=c[b+12>>2]|0;K=B<+g[f+752>>2];c[h+4>>2]=f;if(K){K=c[l+12>>2]|0;da=E*+g[K+16>>2]+D*+g[K+20>>2]+C*+g[K+24>>2];ea=E*+g[K+32>>2]+D*+g[K+36>>2]+C*+g[K+40>>2];g[J+32>>2]=+g[K>>2]*E+ +g[K+4>>2]*D+ +g[K+8>>2]*C;g[J+36>>2]=da;g[J+40>>2]=ea;g[J+44>>2]=0.0;g[J+80>>2]=v*y+(x*A+w*z)+o;g[J+84>>2]=A*u+z*t+y*s+n;g[J+88>>2]=A*r+z*q+y*p+m;g[J+92>>2]=0.0;oc[c[(c[h>>2]|0)+16>>2]&15](h,J+32|0,J+80|0,B)}k=k+1|0;l=c[b+20>>2]|0}while((k|0)<(l|0))}}if(!(a[b+8>>0]|0)){i=J;return}if(!(c[(c[b+12>>2]|0)+748>>2]|0)){i=J;return}j=c[h+4>>2]|0;if(!(c[j+748>>2]|0)){i=J;return}k=c[j+740>>2]|0;l=c[(c[h+8>>2]|0)+8>>2]|0;f=c[(c[h+12>>2]|0)+8>>2]|0;if((k|0)==(l|0)){Os(j,k+4|0,f+4|0);i=J;return}else{Os(j,f+4|0,l+4|0);i=J;return}}function cu(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return 1.0}function du(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;if(!(c[b+12>>2]|0))return;if(!(a[b+8>>0]|0))return;f=c[d+4>>2]|0;if((f|0)==(c[d+8>>2]|0)?(i=(f|0)==0?1:f<<1,(f|0)<(i|0)):0){if(!i)h=0;else{c[5132]=(c[5132]|0)+1;e=ZE((i<<2|3)+16|0)|0;if(!e)f=0;else{c[(e+19&-16)+-4>>2]=e;f=e+19&-16}h=f;f=c[d+4>>2]|0}if((f|0)>0){g=0;do{e=h+(g<<2)|0;if(e)c[e>>2]=c[(c[d+12>>2]|0)+(g<<2)>>2];g=g+1|0}while((g|0)!=(f|0))}e=c[d+12>>2]|0;if(e){if(a[d+16>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[e+-4>>2]|0);f=c[d+4>>2]|0}c[d+12>>2]=0}a[d+16>>0]=1;c[d+12>>2]=h;c[d+8>>2]=i}e=(c[d+12>>2]|0)+(f<<2)|0;if(e)c[e>>2]=c[b+12>>2];c[d+4>>2]=f+1;return}function eu(a){a=a|0;var b=0;c[a>>2]=7248;c[a+12>>2]=7280;b=c[a+60>>2]|0;Lb[c[(c[b>>2]|0)+20>>2]&127](b,c[a+76>>2]|0);b=c[a+60>>2]|0;Lb[c[(c[b>>2]|0)+16>>2]&127](b,c[a+76>>2]|0);return}function fu(a){a=a|0;var b=0;c[a>>2]=7248;c[a+12>>2]=7280;b=c[a+60>>2]|0;Lb[c[(c[b>>2]|0)+20>>2]&127](b,c[a+76>>2]|0);b=c[a+60>>2]|0;Lb[c[(c[b>>2]|0)+16>>2]&127](b,c[a+76>>2]|0);_E(a);return}function gu(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;if(!(c[b+76>>2]|0))return;f=c[d+4>>2]|0;if((f|0)==(c[d+8>>2]|0)?(i=(f|0)==0?1:f<<1,(f|0)<(i|0)):0){if(!i)h=0;else{c[5132]=(c[5132]|0)+1;e=ZE((i<<2|3)+16|0)|0;if(!e)f=0;else{c[(e+19&-16)+-4>>2]=e;f=e+19&-16}h=f;f=c[d+4>>2]|0}if((f|0)>0){g=0;do{e=h+(g<<2)|0;if(e)c[e>>2]=c[(c[d+12>>2]|0)+(g<<2)>>2];g=g+1|0}while((g|0)!=(f|0))}e=c[d+12>>2]|0;if(e){if(a[d+16>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[e+-4>>2]|0);f=c[d+4>>2]|0}c[d+12>>2]=0}a[d+16>>0]=1;c[d+12>>2]=h;c[d+8>>2]=i}e=(c[d+12>>2]|0)+(f<<2)|0;if(e)c[e>>2]=c[b+76>>2];c[d+4>>2]=f+1;return}function hu(a){a=a|0;var b=0;c[a>>2]=7280;b=c[a+48>>2]|0;Lb[c[(c[b>>2]|0)+20>>2]&127](b,c[a+64>>2]|0);b=c[a+48>>2]|0;Lb[c[(c[b>>2]|0)+16>>2]&127](b,c[a+64>>2]|0);return}function iu(a){a=a|0;var b=0;c[a>>2]=7280;b=c[a+48>>2]|0;Lb[c[(c[b>>2]|0)+20>>2]&127](b,c[a+64>>2]|0);b=c[a+48>>2]|0;Lb[c[(c[b>>2]|0)+16>>2]&127](b,c[a+64>>2]|0);_E(a);return}function ju(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0.0,k=0.0,l=0.0,m=0,n=0,o=0.0,p=0;n=i;i=i+128|0;j=+g[b>>2];k=+g[b+16>>2];o=j<k?j:k;l=+g[b+32>>2];if((o<l?o:l)>+g[a+28>>2]){i=n;return}m=j>k?b:b+16|0;if(+g[(+g[m>>2]>l?m:b+32|0)>>2]<+g[a+12>>2]){i=n;return}k=+g[b+8>>2];j=+g[b+24>>2];o=k<j?k:j;l=+g[b+40>>2];if((o<l?o:l)>+g[a+36>>2]){i=n;return}m=k>j?b+8|0:b+24|0;if(+g[(+g[m>>2]>l?m:b+40|0)>>2]<+g[a+20>>2]){i=n;return}l=+g[b+4>>2];k=+g[b+20>>2];o=l<k?l:k;j=+g[b+36>>2];if((o<j?o:j)>+g[a+32>>2]){i=n;return}m=l>k?b+4|0:b+20|0;if(+g[(+g[m>>2]>j?m:b+36|0)>>2]<+g[a+16>>2]){i=n;return}m=c[a+48>>2]|0;h=c[a+4>>2]|0;if((c[(c[h+4>>2]|0)+4>>2]|0)>=20){i=n;return}c[n+32>>2]=0;g[n+36>>2]=1.0;g[n+40>>2]=1.0;g[n+44>>2]=1.0;g[n+48>>2]=0.0;c[n+76>>2]=0;c[n+24>>2]=7680;c[n+28>>2]=1;c[n+80>>2]=c[b+0>>2];c[n+84>>2]=c[b+4>>2];c[n+88>>2]=c[b+8>>2];c[n+92>>2]=c[b+12>>2];c[n+96>>2]=c[b+16>>2];c[n+100>>2]=c[b+20>>2];c[n+104>>2]=c[b+24>>2];c[n+108>>2]=c[b+28>>2];c[n+112>>2]=c[b+32>>2];c[n+116>>2]=c[b+36>>2];c[n+120>>2]=c[b+40>>2];c[n+124>>2]=c[b+44>>2];g[n+68>>2]=+g[a+56>>2];p=c[a+8>>2]|0;f=c[p+8>>2]|0;b=c[p+12>>2]|0;c[n>>2]=p;c[n+4>>2]=n+24;c[n+8>>2]=f;c[n+12>>2]=b;c[n+16>>2]=d;c[n+20>>2]=e;b=Rb[c[(c[m>>2]|0)+8>>2]&31](m,h,n,c[a+64>>2]|0)|0;f=c[a+44>>2]|0;h=c[f+8>>2]|0;if((c[h+8>>2]|0)==(c[(c[a+8>>2]|0)+8>>2]|0)){c[f+8>>2]=n;pc[c[(c[f>>2]|0)+8>>2]&127](f,d,e)}else{h=c[f+12>>2]|0;c[f+12>>2]=n;pc[c[(c[f>>2]|0)+12>>2]&127](f,d,e)}Hb[c[(c[b>>2]|0)+8>>2]&31](b,c[a+4>>2]|0,n,c[a+52>>2]|0,c[a+44>>2]|0);f=c[a+44>>2]|0;if((c[(c[f+8>>2]|0)+8>>2]|0)==(c[(c[a+8>>2]|0)+8>>2]|0))c[f+8>>2]=h;else c[f+12>>2]=h;Jb[c[c[b>>2]>>2]&255](b);Lb[c[(c[m>>2]|0)+60>>2]&127](m,b);c[n+24>>2]=13432;f=c[n+76>>2]|0;if(!f){i=n;return}Jb[c[c[f>>2]>>2]&255](f);f=c[n+76>>2]|0;if(!f){i=n;return}c[5134]=(c[5134]|0)+1;_E(c[f+-4>>2]|0);i=n;return}function ku(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0;k=i;i=i+64|0;l=(a[b+8>>0]|0)!=0;j=l?e:d;d=l?d:e;e=c[d+4>>2]|0;if(((c[e+4>>2]|0)+-21|0)>>>0>=9){i=k;return}if((c[(c[j+4>>2]|0)+4>>2]|0)>=20){i=k;return}m=+Zb[c[(c[e>>2]|0)+48>>2]&15](e);c[h+4>>2]=c[b+76>>2];c[b+16>>2]=j;c[b+20>>2]=d;c[b+64>>2]=f;g[b+68>>2]=m;c[b+56>>2]=h;l=c[d+12>>2]|0;B=+g[l>>2];A=+g[l+16>>2];z=+g[l+32>>2];y=+g[l+4>>2];x=+g[l+20>>2];w=+g[l+36>>2];s=+g[l+8>>2];q=+g[l+24>>2];o=+g[l+40>>2];v=-+g[l+48>>2];u=-+g[l+52>>2];t=-+g[l+56>>2];l=c[j+12>>2]|0;K=+g[l>>2];J=+g[l+16>>2];I=+g[l+32>>2];H=+g[l+4>>2];G=+g[l+20>>2];F=+g[l+36>>2];E=+g[l+8>>2];D=+g[l+24>>2];C=+g[l+40>>2];r=+g[l+48>>2];p=+g[l+52>>2];n=+g[l+56>>2];g[k>>2]=B*K+A*J+z*I;g[k+4>>2]=B*H+A*G+z*F;g[k+8>>2]=B*E+A*D+z*C;g[k+12>>2]=0.0;g[k+16>>2]=y*K+x*J+w*I;g[k+20>>2]=y*H+x*G+w*F;g[k+24>>2]=y*E+x*D+w*C;g[k+28>>2]=0.0;g[k+32>>2]=s*K+q*J+o*I;g[k+36>>2]=s*H+q*G+o*F;g[k+40>>2]=s*E+q*D+o*C;g[k+44>>2]=0.0;g[k+48>>2]=B*v+A*u+z*t+(B*r+A*p+z*n);g[k+52>>2]=y*v+x*u+w*t+(y*r+x*p+w*n);g[k+56>>2]=s*v+q*u+o*t+(s*r+q*p+o*n);g[k+60>>2]=0.0;l=c[(c[b+16>>2]|0)+4>>2]|0;tc[c[(c[l>>2]|0)+8>>2]&127](l,k,b+24|0,b+40|0);g[b+40>>2]=+g[b+40>>2]+m;g[b+44>>2]=+g[b+44>>2]+m;g[b+48>>2]=+g[b+48>>2]+m;g[b+24>>2]=+g[b+24>>2]-m;g[b+28>>2]=+g[b+28>>2]-m;g[b+32>>2]=+g[b+32>>2]-m;l=c[b+76>>2]|0;d=c[d+8>>2]|0;c[l+740>>2]=c[j+8>>2];c[l+744>>2]=d;tc[c[(c[e>>2]|0)+64>>2]&127](e,b+12|0,b+24|0,b+40|0);j=c[h+4>>2]|0;do if(c[j+748>>2]|0){e=c[j+740>>2]|0;d=c[(c[h+8>>2]|0)+8>>2]|0;f=c[(c[h+12>>2]|0)+8>>2]|0;if((e|0)==(d|0)){Os(j,e+4|0,f+4|0);break}else{Os(j,f+4|0,d+4|0);break}}while(0);c[b+16>>2]=0;c[b+20>>2]=0;i=k;return}function lu(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0;h=i;i=i+240|0;f=(a[b+8>>0]|0)!=0;b=f?e:d;e=f?d:e;S=+g[b+116>>2]-+g[b+52>>2];T=+g[b+120>>2]-+g[b+56>>2];U=+g[b+124>>2]-+g[b+60>>2];V=+g[b+252>>2];if(S*S+T*T+U*U<V*V){V=1.0;i=h;return +V}F=+g[e+4>>2];G=+g[e+20>>2];H=+g[e+36>>2];I=+g[e+8>>2];J=+g[e+24>>2];K=+g[e+40>>2];L=+g[e+12>>2];M=+g[e+28>>2];N=+g[e+44>>2];k=-+g[e+52>>2];l=-+g[e+56>>2];m=-+g[e+60>>2];O=+g[b+4>>2];P=+g[b+20>>2];Q=+g[b+36>>2];R=+g[b+8>>2];S=+g[b+24>>2];T=+g[b+40>>2];U=+g[b+12>>2];V=+g[b+28>>2];p=+g[b+44>>2];u=+g[b+52>>2];t=+g[b+56>>2];s=+g[b+60>>2];q=F*k+G*l+H*m+(F*u+G*t+H*s);r=I*k+J*l+K*m+(I*u+J*t+K*s);s=L*k+M*l+N*m+(L*u+M*t+N*s);t=+g[b+68>>2];u=+g[b+84>>2];v=+g[b+100>>2];w=+g[b+72>>2];x=+g[b+88>>2];y=+g[b+104>>2];z=+g[b+76>>2];A=+g[b+92>>2];B=+g[b+108>>2];n=+g[b+116>>2];o=+g[b+120>>2];E=+g[b+124>>2];C=F*k+G*l+H*m+(F*n+G*o+H*E);D=I*k+J*l+K*m+(I*n+J*o+K*E);E=L*k+M*l+N*m+(L*n+M*o+N*E);e=c[e+192>>2]|0;if(((c[e+4>>2]|0)+-21|0)>>>0>=9){V=1.0;i=h;return +V}g[h+224>>2]=q;g[h+228>>2]=r;g[h+232>>2]=s;g[h+236>>2]=0.0;if(C<q){g[h+224>>2]=C;j=C}else j=q;if(D<r){g[h+228>>2]=D;k=D}else k=r;if(E<s){g[h+232>>2]=E;l=E}else l=s;g[h+208>>2]=q;g[h+212>>2]=r;g[h+216>>2]=s;g[h+220>>2]=0.0;if(q<C){g[h+208>>2]=C;m=C}else m=q;if(r<D){g[h+212>>2]=D;n=D}else n=r;if(s<E){g[h+216>>2]=E;o=E}else o=s;W=+g[b+248>>2];g[h+224>>2]=j-W;g[h+228>>2]=k-W;g[h+232>>2]=l-W;g[h+208>>2]=W+m;g[h+212>>2]=W+n;g[h+216>>2]=W+o;c[h>>2]=7408;g[h+4>>2]=F*O+G*P+H*Q;g[h+8>>2]=F*R+G*S+H*T;g[h+12>>2]=F*U+G*V+H*p;g[h+16>>2]=0.0;g[h+20>>2]=I*O+J*P+K*Q;g[h+24>>2]=I*R+J*S+K*T;g[h+28>>2]=I*U+J*V+K*p;g[h+32>>2]=0.0;g[h+36>>2]=L*O+M*P+N*Q;g[h+40>>2]=L*R+M*S+N*T;g[h+44>>2]=L*U+M*V+N*p;g[h+48>>2]=0.0;g[h+52>>2]=q;g[h+56>>2]=r;g[h+60>>2]=s;g[h+64>>2]=0.0;g[h+68>>2]=F*t+G*u+H*v;g[h+72>>2]=F*w+G*x+H*y;g[h+76>>2]=F*z+G*A+H*B;g[h+80>>2]=0.0;g[h+84>>2]=I*t+J*u+K*v;g[h+88>>2]=I*w+J*x+K*y;g[h+92>>2]=I*z+J*A+K*B;g[h+96>>2]=0.0;g[h+100>>2]=L*t+M*u+N*v;g[h+104>>2]=L*w+M*x+N*y;g[h+108>>2]=L*z+M*A+N*B;g[h+112>>2]=0.0;g[h+116>>2]=C;g[h+120>>2]=D;g[h+124>>2]=E;g[h+128>>2]=0.0;g[h+196>>2]=W;g[h+200>>2]=+g[b+244>>2];if(!e){W=1.0;i=h;return +W}tc[c[(c[e>>2]|0)+64>>2]&127](e,h,h+224|0,h+208|0);j=+g[h+200>>2];if(!(j<+g[b+244>>2])){W=1.0;i=h;return +W}g[b+244>>2]=j;W=j;i=h;return +W}function mu(a,b){a=a|0;b=+b;g[a+44>>2]=b;return}function nu(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0,j=0.0;f=i;i=i+784|0;g[f+712>>2]=1.0;c[f+716>>2]=0;c[f+720>>2]=0;c[f+724>>2]=0;c[f+728>>2]=0;g[f+732>>2]=1.0;c[f+736>>2]=0;c[f+740>>2]=0;c[f+744>>2]=0;c[f+748>>2]=0;g[f+752>>2]=1.0;e=f+756|0;c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[f+536>>2]=7608;c[f+704>>2]=0;g[f+708>>2]=0.0;g[f+700>>2]=+g[b+200>>2];j=+g[b+196>>2];c[f+488>>2]=0;g[f+492>>2]=1.0;g[f+496>>2]=1.0;g[f+500>>2]=1.0;g[f+504>>2]=0.0;c[f+480>>2]=12104;c[f+484>>2]=8;g[f+508>>2]=j;g[f+524>>2]=j;c[f+384>>2]=0;g[f+388>>2]=1.0;g[f+392>>2]=1.0;g[f+396>>2]=1.0;g[f+400>>2]=0.0;g[f+420>>2]=.03999999910593033;c[f+428>>2]=0;c[f+376>>2]=7680;c[f+380>>2]=1;c[f+432>>2]=c[d+0>>2];c[f+436>>2]=c[d+4>>2];c[f+440>>2]=c[d+8>>2];c[f+444>>2]=c[d+12>>2];c[f+448>>2]=c[d+16>>2];c[f+452>>2]=c[d+20>>2];c[f+456>>2]=c[d+24>>2];c[f+460>>2]=c[d+28>>2];c[f+464>>2]=c[d+32>>2];c[f+468>>2]=c[d+36>>2];c[f+472>>2]=c[d+40>>2];c[f+476>>2]=c[d+44>>2];g[f+324>>2]=9.999999747378752e-05;a[f+348>>0]=0;c[f>>2]=19072;c[f+4>>2]=f+16;c[f+8>>2]=f+480;c[f+12>>2]=f+376;if(ZC(f,b+4|0,b+68|0,f+712|0,f+712|0,f+536|0)|0?(h=+g[f+700>>2],+g[b+200>>2]>h):0)g[b+200>>2]=h;c[f+376>>2]=13432;e=c[f+428>>2]|0;if(!e){i=f;return}Jb[c[c[e>>2]>>2]&255](e);e=c[f+428>>2]|0;if(!e){i=f;return}c[5134]=(c[5134]|0)+1;_E(c[e+-4>>2]|0);i=f;return}function ou(a){a=a|0;return}function pu(a){a=a|0;_E(a);return}function qu(a,b,c){a=a|0;b=b|0;c=c|0;return}function ru(a,b){a=a|0;b=b|0;return}function su(a,b){a=a|0;b=+b;return}function tu(a){a=a|0;_E(a);return}function uu(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0;h=+g[a+56>>2];k=+g[a+72>>2]-h;j=+g[a+60>>2];i=+g[a+76>>2]-j;l=+g[a+64>>2];m=+g[a+80>>2]-l;h=+g[a+88>>2]-h;j=+g[a+92>>2]-j;l=+g[a+96>>2]-l;g[d+12>>2]=0.0;f=1.0/+P(+((k*j-i*h)*(k*j-i*h)+((i*l-m*j)*(i*l-m*j)+(m*h-k*l)*(m*h-k*l))));g[d>>2]=f*(i*l-m*j);g[d+4>>2]=f*(m*h-k*l);g[d+8>>2]=(k*j-i*h)*f;c[e+0>>2]=c[a+56>>2];c[e+4>>2]=c[a+60>>2];c[e+8>>2]=c[a+64>>2];c[e+12>>2]=c[a+68>>2];return}function vu(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0.0,h=0.0,j=0.0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0;k=i;i=i+32|0;n=+g[a+56>>2];r=+g[a+72>>2]-n;m=+g[a+60>>2];p=+g[a+76>>2]-m;l=+g[a+64>>2];s=+g[a+80>>2]-l;o=+g[a+88>>2]-n;q=+g[a+92>>2]-m;h=+g[a+96>>2]-l;j=1.0/+P(+((r*q-p*o)*(r*q-p*o)+((p*h-s*q)*(p*h-s*q)+(s*o-r*h)*(s*o-r*h))));f=j*(p*h-s*q);h=j*(s*o-r*h);j=(r*q-p*o)*j;l=+g[b>>2]*f+ +g[b+4>>2]*h+j*+g[b+8>>2]-(f*n+h*m+j*l);if(!(l>=-d)|!(l<=d)){e=0;i=k;return e|0}e=0;while(1){tc[c[(c[a>>2]|0)+104>>2]&127](a,e,k+16|0,k);l=+g[k+16>>2];s=+g[k>>2]-l;n=+g[k+20>>2];m=+g[k+4>>2]-n;r=+g[k+24>>2];p=+g[k+8>>2]-r;o=1.0/+P(+((h*s-f*m)*(h*s-f*m)+((j*m-h*p)*(j*m-h*p)+(f*p-j*s)*(f*p-j*s))));e=e+1|0;if(+g[b>>2]*(o*(j*m-h*p))+ +g[b+4>>2]*(o*(f*p-j*s))+(h*s-f*m)*o*+g[b+8>>2]-(r*((h*s-f*m)*o)+(l*(o*(j*m-h*p))+n*(o*(f*p-j*s))))<-d){b=0;e=5;break}if((e|0)>=3){b=1;e=5;break}}if((e|0)==5){i=k;return b|0}return 0}function wu(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;tc[c[(c[a>>2]|0)+124>>2]&127](a,e,b,d);return}function xu(a){a=a|0;return 1}function yu(a,b,d){a=a|0;b=b|0;d=d|0;c[d+0>>2]=c[a+(b<<4)+56>>2];c[d+4>>2]=c[a+(b<<4)+60>>2];c[d+8>>2]=c[a+(b<<4)+64>>2];c[d+12>>2]=c[a+(b<<4)+68>>2];return}function zu(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;pc[c[(c[a>>2]|0)+108>>2]&127](a,b,d);pc[c[(c[a>>2]|0)+108>>2]&127](a,(b+1|0)%3|0,e);return}function Au(a){a=a|0;return 3}function Bu(a){a=a|0;return 3}function Cu(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;h=+g[a+56>>2];j=+g[a+72>>2]-h;i=+g[a+60>>2];k=+g[a+76>>2]-i;d=+g[a+64>>2];f=+g[a+80>>2]-d;h=+g[a+88>>2]-h;i=+g[a+92>>2]-i;d=+g[a+96>>2]-d;g[c+12>>2]=0.0;e=1.0/+P(+((j*i-k*h)*(j*i-k*h)+((k*d-f*i)*(k*d-f*i)+(f*h-j*d)*(f*h-j*d))));g[c>>2]=e*(k*d-f*i);g[c+4>>2]=e*(f*h-j*d);g[c+8>>2]=(j*i-k*h)*e;if(!b)return;g[c>>2]=-(e*(k*d-f*i));g[c+4>>2]=-(e*(f*h-j*d));g[c+8>>2]=-((j*i-k*h)*e);return}function Du(a){a=a|0;return 2}function Eu(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,i=0.0,j=0.0,k=0,l=0,m=0.0,n=0.0;if((e|0)<=0)return;l=0;do{n=+g[b+(l<<4)>>2];m=+g[b+(l<<4)+4>>2];j=+g[b+(l<<4)+8>>2];h=n*+g[a+56>>2]+m*+g[a+60>>2]+j*+g[a+64>>2];i=n*+g[a+72>>2]+m*+g[a+76>>2]+j*+g[a+80>>2];j=n*+g[a+88>>2]+m*+g[a+92>>2]+j*+g[a+96>>2];k=d+(l<<4)|0;if(h<i)f=i<j?2:1;else f=h<j?2:0;f=a+(f<<4)+56|0;c[k+0>>2]=c[f+0>>2];c[k+4>>2]=c[f+4>>2];c[k+8>>2]=c[f+8>>2];c[k+12>>2]=c[f+12>>2];l=l+1|0}while((l|0)!=(e|0));return}function Fu(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;j=+g[d>>2];i=+g[d+4>>2];h=+g[d+8>>2];e=j*+g[b+56>>2]+i*+g[b+60>>2]+h*+g[b+64>>2];f=j*+g[b+72>>2]+i*+g[b+76>>2]+h*+g[b+80>>2];h=j*+g[b+88>>2]+i*+g[b+92>>2]+h*+g[b+96>>2];if(e<f)d=f<h?2:1;else d=e<h?2:0;b=b+(d<<4)+56|0;c[a+0>>2]=c[b+0>>2];c[a+4>>2]=c[b+4>>2];c[a+8>>2]=c[b+8>>2];c[a+12>>2]=c[b+12>>2];return}function Gu(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=ec[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;f=ec[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;c[b>>2]=f;if(f)Lb[c[(c[d>>2]|0)+48>>2]&127](d,e);c[b+4>>2]=c[a+4>>2];g[b+28>>2]=+g[a+28>>2];g[b+32>>2]=+g[a+32>>2];g[b+36>>2]=+g[a+36>>2];g[b+40>>2]=+g[a+40>>2];g[b+12>>2]=+g[a+12>>2];g[b+16>>2]=+g[a+16>>2];g[b+20>>2]=+g[a+20>>2];g[b+24>>2]=+g[a+24>>2];g[b+44>>2]=+g[a+44>>2];return 7848}function Hu(a){a=a|0;return 52}function Iu(a){a=a|0;return +(+g[a+44>>2])}function Ju(a,b){a=a|0;b=b|0;g[a>>2]=1.0;g[a+4>>2]=1.0;g[a+8>>2]=1.0;g[a+12>>2]=0.0;return}function Ku(a){a=a|0;return 7880}function Lu(a,b,d){a=a|0;b=+b;d=d|0;c[d+0>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;return}function Mu(a){a=a|0;return a+12|0}function Nu(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;tc[c[(c[a>>2]|0)+80>>2]&127](a,b,d,e);return}function Ou(a){a=a|0;var b=0;c[a>>2]=13432;b=c[a+52>>2]|0;if(b){Jb[c[c[b>>2]>>2]&255](b);b=c[a+52>>2]|0;if(b){c[5134]=(c[5134]|0)+1;_E(c[b+-4>>2]|0)}if(!a)return}c[5134]=(c[5134]|0)+1;_E(c[a+-4>>2]|0);return}function Pu(b){b=b|0;var d=0;c[b>>2]=7904;if(!(a[b+8>>0]|0))return;d=c[b+12>>2]|0;if(!d)return;b=c[b+4>>2]|0;Lb[c[(c[b>>2]|0)+16>>2]&127](b,d);return}function Qu(b){b=b|0;var d=0,e=0;c[b>>2]=7904;if(!(a[b+8>>0]|0)){_E(b);return}d=c[b+12>>2]|0;if(!d){_E(b);return}e=c[b+4>>2]|0;Lb[c[(c[e>>2]|0)+16>>2]&127](e,d);_E(b);return}function Ru(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0;k=i;i=i+144|0;j=c[b+12>>2]|0;if(!j){i=k;return}m=c[d+4>>2]|0;l=c[e+4>>2]|0;c[h+4>>2]=j;g[k+140>>2]=999999984306749440.0;j=c[d+12>>2]|0;c[k+12>>2]=c[j+0>>2];c[k+16>>2]=c[j+4>>2];c[k+20>>2]=c[j+8>>2];c[k+24>>2]=c[j+12>>2];c[k+28>>2]=c[j+16>>2];c[k+32>>2]=c[j+20>>2];c[k+36>>2]=c[j+24>>2];c[k+40>>2]=c[j+28>>2];c[k+44>>2]=c[j+32>>2];c[k+48>>2]=c[j+36>>2];c[k+52>>2]=c[j+40>>2];c[k+56>>2]=c[j+44>>2];c[k+60>>2]=c[j+48>>2];c[k+64>>2]=c[j+52>>2];c[k+68>>2]=c[j+56>>2];c[k+72>>2]=c[j+60>>2];j=c[e+12>>2]|0;c[k+76>>2]=c[j+0>>2];c[k+80>>2]=c[j+4>>2];c[k+84>>2]=c[j+8>>2];c[k+88>>2]=c[j+12>>2];c[k+92>>2]=c[j+16>>2];c[k+96>>2]=c[j+20>>2];c[k+100>>2]=c[j+24>>2];c[k+104>>2]=c[j+28>>2];c[k+108>>2]=c[j+32>>2];c[k+112>>2]=c[j+36>>2];c[k+116>>2]=c[j+40>>2];c[k+120>>2]=c[j+44>>2];c[k+124>>2]=c[j+48>>2];c[k+128>>2]=c[j+52>>2];c[k+132>>2]=c[j+56>>2];c[k+136>>2]=c[j+60>>2];c[k>>2]=19856;c[k+4>>2]=m;c[k+8>>2]=l;KD(k,k+12|0,h,c[f+20>>2]|0,0);if(!(a[b+8>>0]|0)){i=k;return}e=c[h+4>>2]|0;if(!(c[e+748>>2]|0)){i=k;return}d=c[e+740>>2]|0;j=c[(c[h+8>>2]|0)+8>>2]|0;f=c[(c[h+12>>2]|0)+8>>2]|0;if((d|0)==(j|0)){Os(e,d+4|0,f+4|0);i=k;return}else{Os(e,f+4|0,j+4|0);i=k;return}}function Su(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return 1.0}function Tu(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;if(!(c[b+12>>2]|0))return;if(!(a[b+8>>0]|0))return;f=c[d+4>>2]|0;if((f|0)==(c[d+8>>2]|0)?(i=(f|0)==0?1:f<<1,(f|0)<(i|0)):0){if(!i)h=0;else{c[5132]=(c[5132]|0)+1;e=ZE((i<<2|3)+16|0)|0;if(!e)f=0;else{c[(e+19&-16)+-4>>2]=e;f=e+19&-16}h=f;f=c[d+4>>2]|0}if((f|0)>0){g=0;do{e=h+(g<<2)|0;if(e)c[e>>2]=c[(c[d+12>>2]|0)+(g<<2)>>2];g=g+1|0}while((g|0)!=(f|0))}e=c[d+12>>2]|0;if(e){if(a[d+16>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[e+-4>>2]|0);f=c[d+4>>2]|0}c[d+12>>2]=0}a[d+16>>0]=1;c[d+12>>2]=h;c[d+8>>2]=i}e=(c[d+12>>2]|0)+(f<<2)|0;if(e)c[e>>2]=c[b+12>>2];c[d+4>>2]=f+1;return}function Uu(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;var h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0,v=0,w=0,x=0,y=0,z=0,A=0.0,B=0.0,C=0.0;z=i;i=i+192|0;y=c[b+4>>2]|0;if(+g[y+752>>2]<f){i=z;return}x=c[y+740>>2]|0;v=(c[b+8>>2]|0)+8|0;w=c[v>>2]|0;l=+g[e>>2];o=+g[d>>2]*f+l;k=+g[e+4>>2];p=+g[d+4>>2]*f+k;j=+g[e+8>>2];q=+g[d+8>>2]*f+j;u=(c[b+12>>2]|0)+8|0;n=c[u>>2]|0;if((x|0)!=(w|0)){C=o-+g[n+52>>2];m=p-+g[n+56>>2];t=q-+g[n+60>>2];B=l-+g[w+52>>2];A=k-+g[w+56>>2];l=j-+g[w+60>>2];r=C*+g[n+4>>2]+m*+g[n+20>>2]+t*+g[n+36>>2];s=C*+g[n+8>>2]+m*+g[n+24>>2]+t*+g[n+40>>2];t=C*+g[n+12>>2]+m*+g[n+28>>2]+t*+g[n+44>>2];m=B*+g[w+4>>2]+A*+g[w+20>>2]+l*+g[w+36>>2];k=B*+g[w+8>>2]+A*+g[w+24>>2]+l*+g[w+40>>2];l=B*+g[w+12>>2]+A*+g[w+28>>2]+l*+g[w+44>>2]}else{A=o-+g[x+52>>2];m=p-+g[x+56>>2];t=q-+g[x+60>>2];B=l-+g[n+52>>2];C=k-+g[n+56>>2];l=j-+g[n+60>>2];r=A*+g[x+4>>2]+m*+g[x+20>>2]+t*+g[x+36>>2];s=A*+g[x+8>>2]+m*+g[x+24>>2]+t*+g[x+40>>2];t=A*+g[x+12>>2]+m*+g[x+28>>2]+t*+g[x+44>>2];m=B*+g[n+4>>2]+C*+g[n+20>>2]+l*+g[n+36>>2];k=B*+g[n+8>>2]+C*+g[n+24>>2]+l*+g[n+40>>2];l=B*+g[n+12>>2]+C*+g[n+28>>2]+l*+g[n+44>>2]}g[z>>2]=r;g[z+4>>2]=s;g[z+8>>2]=t;g[z+12>>2]=0.0;g[z+16>>2]=m;g[z+20>>2]=k;g[z+24>>2]=l;g[z+28>>2]=0.0;c[z+64>>2]=c[d+0>>2];c[z+68>>2]=c[d+4>>2];c[z+72>>2]=c[d+8>>2];c[z+76>>2]=c[d+12>>2];g[z+80>>2]=f;g[z+84>>2]=0.0;g[z+88>>2]=0.0;g[z+92>>2]=0.0;c[z+112>>2]=0;a[z+116>>0]=0;c[z+120>>2]=0;c[z+124>>2]=0;c[z+128>>2]=0;c[z+132>>2]=0;c[z+136>>2]=0;c[z+140>>2]=0;c[z+144>>2]=0;c[z+148>>2]=0;g[z+48>>2]=o;g[z+52>>2]=p;g[z+56>>2]=q;g[z+60>>2]=0.0;c[z+32>>2]=c[e+0>>2];c[z+36>>2]=c[e+4>>2];c[z+40>>2]=c[e+8>>2];c[z+44>>2]=c[e+12>>2];l=+g[y+752>>2];h=c[y+748>>2]|0;if((h|0)>0){n=0;e=-1;m=l*l;while(1){l=+g[y+(n*184|0)+4>>2]-r;k=+g[y+(n*184|0)+8>>2]-s;j=+g[y+(n*184|0)+12>>2]-t;d=l*l+k*k+j*j<m;e=d?n:e;n=n+1|0;if((n|0)==(h|0))break;else m=d?l*l+k*k+j*j:m}}else e=-1;d=c[v>>2]|0;n=c[u>>2]|0;j=+g[d+224>>2]*+g[n+224>>2];j=j<-10.0?-10.0:j;g[z+84>>2]=j>10.0?10.0:j;g[z+92>>2]=+g[d+228>>2]*+g[n+228>>2];j=+g[d+232>>2]*+g[n+232>>2];j=j<-10.0?-10.0:j;g[z+88>>2]=j>10.0?10.0:j;j=+g[z+72>>2];n=+O(+j)>.7071067690849304;k=+g[z+68>>2];if(n){C=1.0/+P(+(j*j+k*k));g[z+152>>2]=0.0;g[z+156>>2]=-(C*j);g[z+160>>2]=C*k;g[z+168>>2]=(j*j+k*k)*C;B=+g[z+64>>2];l=B*-(C*j);j=-(B*(C*k))}else{l=+g[z+64>>2];C=1.0/+P(+(l*l+k*k));g[z+152>>2]=-(k*C);g[z+156>>2]=C*l;g[z+160>>2]=0.0;g[z+168>>2]=-(j*(C*l));l=(l*l+k*k)*C;j=j*-(k*C)}g[z+172>>2]=j;g[z+176>>2]=l;if((x|0)!=(w|0)){c[z+96>>2]=c[b+20>>2];c[z+100>>2]=c[b+16>>2];d=b+24|0;h=b+28|0}else{c[z+96>>2]=c[b+16>>2];c[z+100>>2]=c[b+20>>2];d=b+28|0;h=b+24|0}c[z+104>>2]=c[h>>2];c[z+108>>2]=c[d>>2];if((e|0)>-1){b=y+(e*184|0)+152|0;w=c[b>>2]|0;d=y+(e*184|0)+124|0;A=+g[d>>2];n=y+(e*184|0)+128|0;B=+g[n>>2];x=y+(e*184|0)+132|0;C=+g[x>>2];u=y+(e*184|0)+116|0;v=c[u>>2]|0;fF(y+(e*184|0)+4|0,z|0,184)|0;c[u>>2]=v;g[d>>2]=A;g[n>>2]=B;g[x>>2]=C;c[b>>2]=w;i=z;return}else{Ns(y,z)|0;i=z;return}}function Vu(a,b,d){a=a|0;b=b|0;d=d|0;c[a+20>>2]=b;c[a+28>>2]=d;return}function Wu(a,b,d){a=a|0;b=b|0;d=d|0;c[a+16>>2]=b;c[a+24>>2]=d;return}function Xu(a){a=a|0;_E(a);return}function Yu(a){a=a|0;return}function Zu(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;c[b>>2]=8112;e=c[b+8>>2]|0;d=c[b+16>>2]|0;if((e|0)>0){h=0;do{f=(c[d+(h<<2)>>2]|0)+188|0;g=c[f>>2]|0;if(g){e=c[b+68>>2]|0;e=Nb[c[(c[e>>2]|0)+36>>2]&127](e)|0;pc[c[(c[e>>2]|0)+40>>2]&127](e,g,c[b+24>>2]|0);e=c[b+68>>2]|0;pc[c[(c[e>>2]|0)+12>>2]&127](e,g,c[b+24>>2]|0);c[f>>2]=0;e=c[b+8>>2]|0;d=c[b+16>>2]|0}h=h+1|0}while((h|0)<(e|0))}if(!d){a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;b=b+12|0;c[b>>2]=0;return}if(a[b+20>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+16>>2]=0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;b=b+12|0;c[b>>2]=0;return}function _u(a){a=a|0;Zu(a);_E(a);return}function $u(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0;m=i;i=i+96|0;h=c[b+8>>2]|0;if((h|0)==(c[b+12>>2]|0)?(l=(h|0)==0?1:h<<1,(h|0)<(l|0)):0){if(!l)k=0;else{c[5132]=(c[5132]|0)+1;g=ZE((l<<2|3)+16|0)|0;if(!g)h=0;else{c[(g+19&-16)+-4>>2]=g;h=g+19&-16}k=h;h=c[b+8>>2]|0}if((h|0)>0){j=0;do{g=k+(j<<2)|0;if(g)c[g>>2]=c[(c[b+16>>2]|0)+(j<<2)>>2];j=j+1|0}while((j|0)!=(h|0))}g=c[b+16>>2]|0;if(g){if(a[b+20>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[g+-4>>2]|0);h=c[b+8>>2]|0}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=k;c[b+12>>2]=l}g=(c[b+16>>2]|0)+(h<<2)|0;if(g)c[g>>2]=d;c[b+8>>2]=h+1;c[m+32>>2]=c[d+4>>2];c[m+36>>2]=c[d+8>>2];c[m+40>>2]=c[d+12>>2];c[m+44>>2]=c[d+16>>2];c[m+48>>2]=c[d+20>>2];c[m+52>>2]=c[d+24>>2];c[m+56>>2]=c[d+28>>2];c[m+60>>2]=c[d+32>>2];c[m+64>>2]=c[d+36>>2];c[m+68>>2]=c[d+40>>2];c[m+72>>2]=c[d+44>>2];c[m+76>>2]=c[d+48>>2];c[m+80>>2]=c[d+52>>2];c[m+84>>2]=c[d+56>>2];c[m+88>>2]=c[d+60>>2];c[m+92>>2]=c[d+64>>2];l=c[d+192>>2]|0;tc[c[(c[l>>2]|0)+8>>2]&127](l,m+32|0,m+16|0,m);l=c[b+68>>2]|0;c[d+188>>2]=nc[c[(c[l>>2]|0)+8>>2]&3](l,m+16|0,m,c[(c[d+192>>2]|0)+4>>2]|0,d,e,f,c[b+24>>2]|0,0)|0;i=m;return}function av(b){b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0,p=0,q=0,r=0,s=0;r=i;i=i+64|0;jE(8392);d=c[b+8>>2]|0;if((d|0)>0){p=0;do{o=c[(c[b+16>>2]|0)+(p<<2)>>2]|0;if(!((a[b+76>>0]|0)==0?(s=c[o+216>>2]|0,(s|0)==2|(s|0)==5):0)){s=c[o+192>>2]|0;tc[c[(c[s>>2]|0)+8>>2]&127](s,o+4|0,r+48|0,r+32|0);h=+g[r+48>>2]+-.019999999552965164;g[r+48>>2]=h;e=+g[r+52>>2]+-.019999999552965164;g[r+52>>2]=e;j=+g[r+56>>2]+-.019999999552965164;g[r+56>>2]=j;k=+g[r+32>>2]+.019999999552965164;g[r+32>>2]=k;l=+g[r+36>>2]+.019999999552965164;g[r+36>>2]=l;f=+g[r+40>>2]+.019999999552965164;g[r+40>>2]=f;if(((a[b+44>>0]|0)!=0?(c[o+236>>2]|0)==2:0)?(c[o+204>>2]&3|0)==0:0){s=c[o+192>>2]|0;tc[c[(c[s>>2]|0)+8>>2]&127](s,o+68|0,r+16|0,r);h=+g[r+16>>2]+-.019999999552965164;g[r+16>>2]=h;e=+g[r+20>>2]+-.019999999552965164;g[r+20>>2]=e;m=+g[r+24>>2]+-.019999999552965164;g[r+24>>2]=m;l=+g[r>>2]+.019999999552965164;g[r>>2]=l;n=+g[r+4>>2]+.019999999552965164;g[r+4>>2]=n;f=+g[r+8>>2]+.019999999552965164;g[r+8>>2]=f;j=+g[r+48>>2];if(h<j)g[r+48>>2]=h;else h=j;j=+g[r+52>>2];if(e<j)g[r+52>>2]=e;else e=j;j=+g[r+56>>2];if(m<j){g[r+56>>2]=m;j=m}k=+g[r+28>>2];if(k<+g[r+60>>2])g[r+60>>2]=k;k=+g[r+32>>2];if(k<l){g[r+32>>2]=l;k=l}l=+g[r+36>>2];if(l<n){g[r+36>>2]=n;l=n}m=+g[r+40>>2];if(m<f)g[r+40>>2]=f;else f=m;m=+g[r+12>>2];if(+g[r+44>>2]<m)g[r+44>>2]=m}d=c[b+68>>2]|0;if((c[o+204>>2]&1|0)==0?(k=k-h,m=l-e,n=f-j,!(k*k+m*m+n*n<999999995904.0)):0){if((c[o+216>>2]&-2|0)!=4)c[o+216>>2]=5;if((a[8168]|0)!=0?(q=c[b+72>>2]|0,(q|0)!=0):0){a[8168]=0;Lb[c[(c[q>>2]|0)+36>>2]&127](q,8176);s=c[b+72>>2]|0;Lb[c[(c[s>>2]|0)+36>>2]&127](s,8232);s=c[b+72>>2]|0;Lb[c[(c[s>>2]|0)+36>>2]&127](s,8304);s=c[b+72>>2]|0;Lb[c[(c[s>>2]|0)+36>>2]&127](s,8376)}}else Hb[c[(c[d>>2]|0)+16>>2]&31](d,c[o+188>>2]|0,r+48|0,r+32|0,c[b+24>>2]|0);d=c[b+8>>2]|0}p=p+1|0}while((p|0)<(d|0))}d=c[5128]|0;s=(c[d+16>>2]|0)+-1|0;c[d+16>>2]=s;if(s){i=r;return}do if(c[d+4>>2]|0){Cb(r+48|0,0)|0;s=c[5114]|0;g[d+8>>2]=+(((c[r+52>>2]|0)-(c[s+4>>2]|0)+(((c[r+48>>2]|0)-(c[s>>2]|0)|0)*1e6|0)-(c[d+12>>2]|0)|0)>>>0)/1.0e3+ +g[d+8>>2];if(!(c[d+16>>2]|0)){d=c[5128]|0;break}else{i=r;return}}while(0);c[5128]=c[d+20>>2];i=r;return}function bv(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;jE(8408);d=c[a+68>>2]|0;Lb[c[(c[d>>2]|0)+32>>2]&127](d,c[a+24>>2]|0);a=c[5128]|0;d=(c[a+16>>2]|0)+-1|0;c[a+16>>2]=d;if(d){i=b;return}do if(c[a+4>>2]|0){Cb(b|0,0)|0;d=c[5114]|0;g[a+8>>2]=+(((c[b+4>>2]|0)-(c[d+4>>2]|0)+(((c[b>>2]|0)-(c[d>>2]|0)|0)*1e6|0)-(c[a+12>>2]|0)|0)>>>0)/1.0e3+ +g[a+8>>2];if(!(c[a+16>>2]|0)){a=c[5128]|0;break}else{i=b;return}}while(0);c[5128]=c[a+20>>2];i=b;return}function cv(a){a=a|0;var b=0,d=0,e=0,f=0;d=i;i=i+16|0;jE(8440);Jb[c[(c[a>>2]|0)+8>>2]&255](a);Jb[c[(c[a>>2]|0)+12>>2]&255](a);b=c[a+24>>2]|0;jE(8480);if(b){f=c[(c[b>>2]|0)+32>>2]|0;e=c[a+68>>2]|0;e=Nb[c[(c[e>>2]|0)+36>>2]&127](e)|0;tc[f&127](b,e,a+28|0,c[a+24>>2]|0)}b=c[5128]|0;f=(c[b+16>>2]|0)+-1|0;c[b+16>>2]=f;do if(!f){if(c[b+4>>2]|0){Cb(d|0,0)|0;a=c[5114]|0;g[b+8>>2]=+(((c[d+4>>2]|0)-(c[a+4>>2]|0)+(((c[d>>2]|0)-(c[a>>2]|0)|0)*1e6|0)-(c[b+12>>2]|0)|0)>>>0)/1.0e3+ +g[b+8>>2];a=c[5128]|0;if(c[b+16>>2]|0)break}else a=b;a=c[a+20>>2]|0;c[5128]=a}else a=b;while(0);b=a+16|0;f=(c[b>>2]|0)+-1|0;c[b>>2]=f;if(f){i=d;return}do if(c[a+4>>2]|0){Cb(d|0,0)|0;e=c[5114]|0;f=a+8|0;g[f>>2]=+(((c[d+4>>2]|0)-(c[e+4>>2]|0)+(((c[d>>2]|0)-(c[e>>2]|0)|0)*1e6|0)-(c[a+12>>2]|0)|0)>>>0)/1.0e3+ +g[f>>2];if(!(c[b>>2]|0)){a=c[5128]|0;break}else{i=d;return}}while(0);c[5128]=c[a+20>>2];i=d;return}function dv(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0;d=c[b+188>>2]|0;if(d){h=c[a+68>>2]|0;h=Nb[c[(c[h>>2]|0)+36>>2]&127](h)|0;pc[c[(c[h>>2]|0)+40>>2]&127](h,d,c[a+24>>2]|0);h=c[a+68>>2]|0;pc[c[(c[h>>2]|0)+12>>2]&127](h,d,c[a+24>>2]|0);c[b+188>>2]=0}d=c[a+8>>2]|0;if((d|0)<=0)return;e=c[a+16>>2]|0;h=0;while(1){g=e+(h<<2)|0;f=h+1|0;if((c[g>>2]|0)==(b|0))break;if((f|0)<(d|0))h=f;else{i=9;break}}if((i|0)==9)return;if((h|0)>=(d|0))return;c[g>>2]=c[e+(d+-1<<2)>>2];c[(c[a+16>>2]|0)+(d+-1<<2)>>2]=b;c[a+8>>2]=d+-1;return}function ev(d,e,f,h){d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0.0,m=0.0,n=0.0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0,y=0,z=0,A=0,B=0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0,K=0.0,L=0.0,M=0.0;J=i;i=i+1392|0;c[J+424>>2]=0;g[J+428>>2]=1.0;g[J+432>>2]=1.0;g[J+436>>2]=1.0;g[J+440>>2]=0.0;c[J+416>>2]=12104;c[J+420>>2]=8;g[J+444>>2]=0.0;g[J+460>>2]=0.0;k=c[f+4>>2]|0;j=c[f+12>>2]|0;o=c[k+4>>2]|0;if((o|0)<20){c[J+184>>2]=7608;c[J+352>>2]=0;g[J+356>>2]=0.0;g[J+348>>2]=+g[h+4>>2];g[J+1140>>2]=9.999999747378752e-05;a[J+1164>>0]=0;c[J+1208>>2]=19072;c[J+1212>>2]=J+832;c[J+1216>>2]=J+416;c[J+1220>>2]=k;c[J+1288>>2]=19224;c[J+1292>>2]=J+832;c[J+1296>>2]=J+416;c[J+1300>>2]=k;B=(c[h+16>>2]&4|0)==0?J+1288|0:J+1208|0;if(!(_b[c[(c[B>>2]|0)+8>>2]&3](B,d,e,j,j,J+184|0)|0)){i=J;return}k=J+316|0;l=+g[k>>2];m=+g[J+320>>2];n=+g[J+324>>2];if(!(l*l+m*m+n*n>9.999999747378752e-05)){i=J;return}p=+g[J+348>>2];if(!(p<+g[h+4>>2])){i=J;return}I=1.0/+P(+(l*l+m*m+n*n));g[k>>2]=l*I;g[J+320>>2]=m*I;g[J+324>>2]=n*I;c[J+1336>>2]=c[f+8>>2];c[J+1340>>2]=0;c[J+1344>>2]=c[k+0>>2];c[J+1348>>2]=c[k+4>>2];c[J+1352>>2]=c[k+8>>2];c[J+1356>>2]=c[k+12>>2];g[J+1360>>2]=p;+fc[c[(c[h>>2]|0)+12>>2]&15](h,J+1336|0,1);i=J;return}if((o+-21|0)>>>0<9){F=+g[j>>2];q=+g[j+16>>2];p=+g[j+32>>2];G=+g[j+4>>2];H=+g[j+20>>2];n=+g[j+36>>2];E=+g[j+8>>2];I=+g[j+24>>2];m=+g[j+40>>2];r=-+g[j+48>>2];C=-+g[j+52>>2];D=-+g[j+56>>2];s=+g[d+48>>2];t=+g[d+52>>2];l=+g[d+56>>2];g[J+1368>>2]=F*r+q*C+p*D+(F*s+q*t+p*l);g[J+1372>>2]=G*r+H*C+n*D+(G*s+H*t+n*l);g[J+1376>>2]=E*r+I*C+m*D+(E*s+I*t+m*l);g[J+1380>>2]=0.0;v=+g[e+48>>2];w=+g[e+52>>2];u=+g[e+56>>2];p=F*r+q*C+p*D+(F*v+q*w+p*u);n=G*r+H*C+n*D+(G*v+H*w+n*u);m=E*r+I*C+m*D+(E*v+I*w+m*u);g[J+536>>2]=p;g[J+540>>2]=n;g[J+544>>2]=m;g[J+548>>2]=0.0;o=c[k+4>>2]|0;if((o|0)==21){d=c[f+8>>2]|0;B=c[h+16>>2]|0;c[J+580>>2]=c[J+1368>>2];c[J+584>>2]=c[J+1372>>2];c[J+588>>2]=c[J+1376>>2];c[J+592>>2]=c[J+1380>>2];c[J+596>>2]=c[J+536>>2];c[J+600>>2]=c[J+540>>2];c[J+604>>2]=c[J+544>>2];c[J+608>>2]=c[J+548>>2];c[J+612>>2]=B;g[J+616>>2]=1.0;c[J+576>>2]=10216;c[J+620>>2]=h;c[J+624>>2]=d;c[J+628>>2]=k;c[J+632>>2]=c[j+0>>2];c[J+636>>2]=c[j+4>>2];c[J+640>>2]=c[j+8>>2];c[J+644>>2]=c[j+12>>2];c[J+648>>2]=c[j+16>>2];c[J+652>>2]=c[j+20>>2];c[J+656>>2]=c[j+24>>2];c[J+660>>2]=c[j+28>>2];c[J+664>>2]=c[j+32>>2];c[J+668>>2]=c[j+36>>2];c[J+672>>2]=c[j+40>>2];c[J+676>>2]=c[j+44>>2];c[J+680>>2]=c[j+48>>2];c[J+684>>2]=c[j+52>>2];c[J+688>>2]=c[j+56>>2];c[J+692>>2]=c[j+60>>2];g[J+616>>2]=+g[h+4>>2];d=c[k+48>>2]|0;c[J+360>>2]=12776;c[J+364>>2]=d;c[J+368>>2]=J+576;d=c[k+52>>2]|0;c[J+472>>2]=0;c[J+476>>2]=0;c[J+480>>2]=0;c[J+484>>2]=0;c[J+552>>2]=0;c[J+556>>2]=0;c[J+560>>2]=0;c[J+564>>2]=0;if(!(a[d+60>>0]|0)){CC(d,J+360|0,J+1368|0,p,n,m,J+472|0,J+552|0);i=J;return}else{DC(d,J+360|0,J+1368|0,p,n,m,J+472|0,J+552|0,c[d+56>>2]|0);i=J;return}}else if((o|0)==25){B=c[f+8>>2]|0;A=c[h+16>>2]|0;c[J+700>>2]=c[J+1368>>2];c[J+704>>2]=c[J+1372>>2];c[J+708>>2]=c[J+1376>>2];c[J+712>>2]=c[J+1380>>2];c[J+716>>2]=c[J+536>>2];c[J+720>>2]=c[J+540>>2];c[J+724>>2]=c[J+544>>2];c[J+728>>2]=c[J+548>>2];c[J+732>>2]=A;g[J+736>>2]=1.0;c[J+696>>2]=10216;c[J+740>>2]=h;c[J+744>>2]=B;c[J+748>>2]=k;c[J+752>>2]=c[j+0>>2];c[J+756>>2]=c[j+4>>2];c[J+760>>2]=c[j+8>>2];c[J+764>>2]=c[j+12>>2];c[J+768>>2]=c[j+16>>2];c[J+772>>2]=c[j+20>>2];c[J+776>>2]=c[j+24>>2];c[J+780>>2]=c[j+28>>2];c[J+784>>2]=c[j+32>>2];c[J+788>>2]=c[j+36>>2];c[J+792>>2]=c[j+40>>2];c[J+796>>2]=c[j+44>>2];c[J+800>>2]=c[j+48>>2];c[J+804>>2]=c[j+52>>2];c[J+808>>2]=c[j+56>>2];c[J+812>>2]=c[j+60>>2];g[J+736>>2]=+g[h+4>>2];tc[c[(c[k>>2]|0)+144>>2]&127](k,J+696|0,J+1368|0,J+536|0);i=J;return}else{M=+g[j>>2];L=+g[j+16>>2];m=+g[j+32>>2];K=+g[j+4>>2];F=+g[j+20>>2];G=+g[j+36>>2];E=+g[j+8>>2];I=+g[j+24>>2];p=+g[j+40>>2];H=-+g[j+48>>2];C=-+g[j+52>>2];D=-+g[j+56>>2];q=M*H+L*C+m*D+(M*s+L*t+m*l);r=K*H+F*C+G*D+(K*s+F*t+G*l);n=E*H+I*C+p*D+(E*s+I*t+p*l);m=M*H+L*C+m*D+(M*v+L*w+m*u);l=K*H+F*C+G*D+(K*v+F*w+G*u);p=E*H+I*C+p*D+(E*v+I*w+p*u);B=c[f+8>>2]|0;A=c[h+16>>2]|0;g[J+4>>2]=q;g[J+8>>2]=r;g[J+12>>2]=n;g[J+16>>2]=0.0;g[J+20>>2]=m;g[J+24>>2]=l;g[J+28>>2]=p;g[J+32>>2]=0.0;c[J+36>>2]=A;g[J+40>>2]=1.0;c[J>>2]=10024;c[J+44>>2]=h;c[J+48>>2]=B;c[J+52>>2]=k;c[J+56>>2]=c[j+0>>2];c[J+60>>2]=c[j+4>>2];c[J+64>>2]=c[j+8>>2];c[J+68>>2]=c[j+12>>2];c[J+72>>2]=c[j+16>>2];c[J+76>>2]=c[j+20>>2];c[J+80>>2]=c[j+24>>2];c[J+84>>2]=c[j+28>>2];c[J+88>>2]=c[j+32>>2];c[J+92>>2]=c[j+36>>2];c[J+96>>2]=c[j+40>>2];c[J+100>>2]=c[j+44>>2];c[J+104>>2]=c[j+48>>2];c[J+108>>2]=c[j+52>>2];c[J+112>>2]=c[j+56>>2];c[J+116>>2]=c[j+60>>2];g[J+40>>2]=+g[h+4>>2];g[J+816>>2]=q;g[J+820>>2]=r;g[J+824>>2]=n;g[J+828>>2]=0.0;if(m<q)g[J+816>>2]=m;if(l<r)g[J+820>>2]=l;if(p<n)g[J+824>>2]=p;g[J+1192>>2]=q;g[J+1196>>2]=r;g[J+1200>>2]=n;g[J+1204>>2]=0.0;if(q<m)g[J+1192>>2]=m;if(r<l)g[J+1196>>2]=l;if(n<p)g[J+1200>>2]=p;tc[c[(c[k>>2]|0)+64>>2]&127](k,J,J+816|0,J+1192|0);i=J;return}}if((o|0)!=31){i=J;return}o=c[k+64>>2]|0;B=c[f+8>>2]|0;c[J+388>>2]=9808;c[J+392>>2]=B;c[J+396>>2]=k;c[J+400>>2]=j;c[J+404>>2]=d;c[J+408>>2]=e;c[J+412>>2]=h;if(!o){o=c[k+16>>2]|0;if((o|0)<=0){i=J;return}d=0;while(1){B=c[k+24>>2]|0;A=c[B+(d*80|0)+64>>2]|0;rp(J+472|0,j,B+(d*80|0)|0);B=c[J+392>>2]|0;c[J+552>>2]=0;c[J+556>>2]=A;c[J+560>>2]=B;c[J+564>>2]=J+472;c[J+568>>2]=-1;c[J+572>>2]=d;B=c[J+412>>2]|0;g[J+364>>2]=1.0;c[J+368>>2]=0;b[J+372>>1]=1;b[J+374>>1]=-1;c[J+376>>2]=0;c[J+360>>2]=9632;c[J+380>>2]=B;c[J+384>>2]=d;g[J+364>>2]=+g[B+4>>2];c[J+376>>2]=c[B+16>>2];ev(c[J+404>>2]|0,c[J+408>>2]|0,J+552|0,J+360|0);d=d+1|0;if((d|0)>=(o|0))break;k=c[J+396>>2]|0;j=c[J+400>>2]|0}i=J;return}nv(J+1224|0,j,d);C=+g[J+1272>>2];D=+g[J+1276>>2];E=+g[J+1280>>2];nv(J+120|0,j,e);e=c[o>>2]|0;if(!e){i=J;return}r=+g[J+168>>2]-C;p=+g[J+172>>2]-D;n=+g[J+176>>2]-E;m=1.0/+P(+(r*r+p*p+n*n));if(r*m==0.0)q=999999984306749440.0;else q=1.0/(r*m);if(p*m==0.0)w=999999984306749440.0;else w=1.0/(p*m);if(n*m==0.0)l=999999984306749440.0;else l=1.0/(n*m);z=q<0.0&1;A=w<0.0&1;B=l<0.0&1;c[5132]=(c[5132]|0)+1;k=ZE(531)|0;if(!k)j=0;else{c[(k+19&-16)+-4>>2]=k;j=k+19&-16}o=0;do{k=j+(o<<2)|0;if(k)c[k>>2]=0;o=o+1|0}while((o|0)!=128);c[j>>2]=e;e=128;k=128;y=1;o=126;while(1){x=y+-1|0;h=c[j+(x<<2)>>2]|0;c[J+1304>>2]=c[h+0>>2];c[J+1308>>2]=c[h+4>>2];c[J+1312>>2]=c[h+8>>2];c[J+1316>>2]=c[h+12>>2];c[J+1320>>2]=c[h+16>>2];c[J+1324>>2]=c[h+20>>2];c[J+1328>>2]=c[h+24>>2];c[J+1332>>2]=c[h+28>>2];v=q*(+g[J+1304+(z<<4)>>2]-C);u=q*(+g[J+1304+((z^1)<<4)>>2]-C);t=w*(+g[J+1304+(A<<4)+4>>2]-D);s=w*(+g[J+1304+((A^1)<<4)+4>>2]-D);do if(((!(v>s|t>u)?(F=t>v?t:v,I=s<u?s:u,G=l*(+g[J+1304+(B<<4)+8>>2]-E),H=l*(+g[J+1304+((B^1)<<4)+8>>2]-E),!(F>H|G>I)):0)?(G>F?G:F)<r*m*r+p*m*p+n*m*n:0)?(H<I?H:I)>0.0:0){if(!(c[h+40>>2]|0)){Lb[c[(c[J+388>>2]|0)+12>>2]&127](J+388|0,h);d=x;break}if((x|0)>(o|0)){f=e<<1;if((e|0)<(f|0)){do if((k|0)<(f|0)){do if(!e)k=0;else{c[5132]=(c[5132]|0)+1;k=ZE((e<<3|3)+16|0)|0;if(!k)k=0;else{c[(k+19&-16)+-4>>2]=k;k=k+19&-16}if((e|0)>0)d=0;else break;do{o=k+(d<<2)|0;if(o)c[o>>2]=c[j+(d<<2)>>2];d=d+1|0}while((d|0)!=(e|0))}while(0);if(!j){j=k;k=f;break}c[5134]=(c[5134]|0)+1;_E(c[j+-4>>2]|0);j=k;k=f}while(0);do{o=j+(e<<2)|0;if(o)c[o>>2]=0;e=e+1|0}while((e|0)!=(f|0))}e=f;o=f+-2|0}c[j+(x<<2)>>2]=c[h+36>>2];c[j+(y<<2)>>2]=c[h+40>>2];d=y+1|0}else d=x;while(0);if(!d)break;else y=d}if(!j){i=J;return}c[5134]=(c[5134]|0)+1;_E(c[j+-4>>2]|0);i=J;return}
function fv(d,e,f,h,j,k){d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=+k;var l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0,C=0,D=0,E=0,F=0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0;D=i;i=i+1664|0;C=c[h+4>>2]|0;B=c[h+12>>2]|0;l=c[C+4>>2]|0;if((l|0)<20){c[D+944>>2]=7608;c[D+1112>>2]=0;g[D+1116>>2]=k;g[D+1108>>2]=+g[j+4>>2];g[D+308>>2]=9.999999747378752e-05;a[D+332>>0]=0;c[D+1464>>2]=19144;c[D+480>>2]=19408;c[D+484>>2]=D;c[D+488>>2]=D+1464;c[D+492>>2]=d;c[D+496>>2]=C;c[D+500>>2]=0;if(!(lD(D+480|0,e,f,B,B,D+944|0)|0)){i=D;return}l=D+1076|0;m=+g[l>>2];n=+g[D+1080>>2];o=+g[D+1084>>2];if(!(m*m+n*n+o*o>9.999999747378752e-05)){i=D;return}p=+g[D+1108>>2];if(!(p<+g[j+4>>2])){i=D;return}k=1.0/+P(+(m*m+n*n+o*o));g[l>>2]=m*k;g[D+1080>>2]=n*k;g[D+1084>>2]=o*k;c[D+376>>2]=c[h+8>>2];c[D+380>>2]=0;c[D+384>>2]=c[l+0>>2];c[D+388>>2]=c[l+4>>2];c[D+392>>2]=c[l+8>>2];c[D+396>>2]=c[l+12>>2];c[D+400>>2]=c[D+1092>>2];c[D+404>>2]=c[D+1096>>2];c[D+408>>2]=c[D+1100>>2];c[D+412>>2]=c[D+1104>>2];g[D+416>>2]=p;+fc[c[(c[j>>2]|0)+12>>2]&15](j,D+376|0,1);i=D;return}if((l+-21|0)>>>0>=9){if((l|0)!=31){i=D;return}jE(8512);if((c[C+16>>2]|0)>0){l=0;do{F=c[C+24>>2]|0;m=+g[F+(l*80|0)>>2];p=+g[F+(l*80|0)+4>>2];s=+g[F+(l*80|0)+8>>2];n=+g[F+(l*80|0)+16>>2];q=+g[F+(l*80|0)+20>>2];u=+g[F+(l*80|0)+24>>2];o=+g[F+(l*80|0)+32>>2];r=+g[F+(l*80|0)+36>>2];w=+g[F+(l*80|0)+40>>2];N=+g[F+(l*80|0)+48>>2];M=+g[F+(l*80|0)+52>>2];A=+g[F+(l*80|0)+56>>2];F=c[F+(l*80|0)+64>>2]|0;L=+g[B>>2];K=+g[B+4>>2];J=+g[B+8>>2];I=+g[B+16>>2];H=+g[B+20>>2];G=+g[B+24>>2];t=+g[B+32>>2];v=+g[B+36>>2];x=+g[B+40>>2];y=N*L+M*K+A*J+ +g[B+48>>2];z=N*I+M*H+A*G+ +g[B+52>>2];A=N*t+M*v+A*x+ +g[B+56>>2];g[D+504>>2]=m*L+n*K+o*J;g[D+508>>2]=p*L+q*K+r*J;g[D+512>>2]=s*L+u*K+w*J;g[D+516>>2]=0.0;g[D+520>>2]=m*I+n*H+o*G;g[D+524>>2]=p*I+q*H+r*G;g[D+528>>2]=s*I+u*H+w*G;g[D+532>>2]=0.0;g[D+536>>2]=m*t+n*v+o*x;g[D+540>>2]=p*t+q*v+r*x;g[D+544>>2]=s*t+u*v+w*x;g[D+548>>2]=0.0;g[D+552>>2]=y;g[D+556>>2]=z;g[D+560>>2]=A;g[D+564>>2]=0.0;b[D+464>>1]=1;b[D+466>>1]=-1;c[D+456>>2]=8992;c[D+468>>2]=j;c[D+472>>2]=l;g[D+460>>2]=+g[j+4>>2];E=c[h+8>>2]|0;c[D+1424>>2]=h;c[D+1428>>2]=F;c[D+1432>>2]=E;c[D+1436>>2]=D+504;c[D+1440>>2]=-1;c[D+1444>>2]=l;fv(d,e,f,D+1424|0,D+456|0,k);l=l+1|0}while((l|0)<(c[C+16>>2]|0))}l=c[5128]|0;F=(c[l+16>>2]|0)+-1|0;c[l+16>>2]=F;if(F){i=D;return}do if(c[l+4>>2]|0){Cb(D+504|0,0)|0;F=c[5114]|0;g[l+8>>2]=+(((c[D+508>>2]|0)-(c[F+4>>2]|0)+(((c[D+504>>2]|0)-(c[F>>2]|0)|0)*1e6|0)-(c[l+12>>2]|0)|0)>>>0)/1.0e3+ +g[l+8>>2];if(!(c[l+16>>2]|0)){l=c[5128]|0;break}else{i=D;return}}while(0);c[5128]=c[l+20>>2];i=D;return}if((l|0)==28){c[D+1488>>2]=7608;c[D+1656>>2]=0;g[D+1660>>2]=k;g[D+1652>>2]=+g[j+4>>2];c[D+568>>2]=19408;c[D+572>>2]=0;c[D+576>>2]=0;c[D+580>>2]=d;c[D+584>>2]=0;c[D+588>>2]=C;if(!(lD(D+568|0,e,f,B,B,D+1488|0)|0)){i=D;return}l=D+1620|0;n=+g[l>>2];o=+g[D+1624>>2];m=+g[D+1628>>2];if(!(n*n+o*o+m*m>9.999999747378752e-05)){i=D;return}p=+g[D+1652>>2];if(!(p<+g[j+4>>2])){i=D;return}N=1.0/+P(+(n*n+o*o+m*m));g[l>>2]=n*N;g[D+1624>>2]=o*N;g[D+1628>>2]=m*N;c[D+592>>2]=c[h+8>>2];c[D+596>>2]=0;c[D+600>>2]=c[l+0>>2];c[D+604>>2]=c[l+4>>2];c[D+608>>2]=c[l+8>>2];c[D+612>>2]=c[l+12>>2];c[D+616>>2]=c[D+1636>>2];c[D+620>>2]=c[D+1640>>2];c[D+624>>2]=c[D+1644>>2];c[D+628>>2]=c[D+1648>>2];g[D+632>>2]=p;+fc[c[(c[j>>2]|0)+12>>2]&15](j,D+592|0,1);i=D;return}else if((l|0)==21){r=+g[B>>2];q=+g[B+16>>2];p=+g[B+32>>2];o=+g[B+4>>2];n=+g[B+20>>2];m=+g[B+36>>2];v=+g[B+8>>2];w=+g[B+24>>2];x=+g[B+40>>2];y=-+g[B+48>>2];z=-+g[B+52>>2];A=-+g[B+56>>2];s=+g[e+48>>2];t=+g[e+52>>2];u=+g[e+56>>2];g[D+424>>2]=r*y+q*z+p*A+(r*s+q*t+p*u);g[D+428>>2]=o*y+n*z+m*A+(o*s+n*t+m*u);g[D+432>>2]=v*y+w*z+x*A+(v*s+w*t+x*u);g[D+436>>2]=0.0;u=+g[f+48>>2];t=+g[f+52>>2];s=+g[f+56>>2];O=+g[f>>2];G=+g[f+16>>2];H=+g[f+32>>2];I=+g[f+4>>2];J=+g[f+20>>2];K=+g[f+36>>2];L=+g[f+8>>2];M=+g[f+24>>2];N=+g[f+40>>2];g[D+1120>>2]=r*O+q*G+p*H;g[D+1124>>2]=r*I+q*J+p*K;g[D+1128>>2]=r*L+q*M+p*N;g[D+1132>>2]=0.0;g[D+1136>>2]=o*O+n*G+m*H;g[D+1140>>2]=o*I+n*J+m*K;g[D+1144>>2]=o*L+n*M+m*N;g[D+1148>>2]=0.0;g[D+1152>>2]=v*O+w*G+x*H;g[D+1156>>2]=v*I+w*J+x*K;g[D+1160>>2]=v*L+w*M+x*N;l=D+1164|0;c[l+0>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;c[l+12>>2]=0;c[l+16>>2]=0;l=c[h+8>>2]|0;N=+Zb[c[(c[C>>2]|0)+48>>2]&15](C);c[D+1200>>2]=17600;c[D+1204>>2]=d;c[D+1208>>2]=c[e+0>>2];c[D+1212>>2]=c[e+4>>2];c[D+1216>>2]=c[e+8>>2];c[D+1220>>2]=c[e+12>>2];c[D+1224>>2]=c[e+16>>2];c[D+1228>>2]=c[e+20>>2];c[D+1232>>2]=c[e+24>>2];c[D+1236>>2]=c[e+28>>2];c[D+1240>>2]=c[e+32>>2];c[D+1244>>2]=c[e+36>>2];c[D+1248>>2]=c[e+40>>2];c[D+1252>>2]=c[e+44>>2];c[D+1256>>2]=c[e+48>>2];c[D+1260>>2]=c[e+52>>2];c[D+1264>>2]=c[e+56>>2];c[D+1268>>2]=c[e+60>>2];c[D+1272>>2]=c[f+0>>2];c[D+1276>>2]=c[f+4>>2];c[D+1280>>2]=c[f+8>>2];c[D+1284>>2]=c[f+12>>2];c[D+1288>>2]=c[f+16>>2];c[D+1292>>2]=c[f+20>>2];c[D+1296>>2]=c[f+24>>2];c[D+1300>>2]=c[f+28>>2];c[D+1304>>2]=c[f+32>>2];c[D+1308>>2]=c[f+36>>2];c[D+1312>>2]=c[f+40>>2];c[D+1316>>2]=c[f+44>>2];c[D+1320>>2]=c[f+48>>2];c[D+1324>>2]=c[f+52>>2];c[D+1328>>2]=c[f+56>>2];c[D+1332>>2]=c[f+60>>2];c[D+1336>>2]=c[B+0>>2];c[D+1340>>2]=c[B+4>>2];c[D+1344>>2]=c[B+8>>2];c[D+1348>>2]=c[B+12>>2];c[D+1352>>2]=c[B+16>>2];c[D+1356>>2]=c[B+20>>2];c[D+1360>>2]=c[B+24>>2];c[D+1364>>2]=c[B+28>>2];c[D+1368>>2]=c[B+32>>2];c[D+1372>>2]=c[B+36>>2];c[D+1376>>2]=c[B+40>>2];c[D+1380>>2]=c[B+44>>2];c[D+1384>>2]=c[B+48>>2];c[D+1388>>2]=c[B+52>>2];c[D+1392>>2]=c[B+56>>2];c[D+1396>>2]=c[B+60>>2];g[D+1404>>2]=N;c[D+1200>>2]=9416;c[D+1412>>2]=j;c[D+1416>>2]=l;c[D+1420>>2]=C;g[D+1400>>2]=+g[j+4>>2];g[D+1408>>2]=k;tc[c[(c[d>>2]|0)+8>>2]&127](d,D+1120|0,D+1448|0,D+1472|0);l=c[C+48>>2]|0;c[D+504>>2]=12616;c[D+508>>2]=l;c[D+512>>2]=D+1200;l=c[C+52>>2]|0;if(!(a[l+60>>0]|0)){CC(l,D+504|0,D+424|0,r*y+q*z+p*A+(r*u+q*t+p*s),o*y+n*z+m*A+(o*u+n*t+m*s),v*y+w*z+x*A+(v*u+w*t+x*s),D+1448|0,D+1472|0);i=D;return}else{DC(l,D+504|0,D+424|0,r*y+q*z+p*A+(r*u+q*t+p*s),o*y+n*z+m*A+(o*u+n*t+m*s),v*y+w*z+x*A+(v*u+w*t+x*s),D+1448|0,D+1472|0,c[l+56>>2]|0);i=D;return}}else{m=+g[B>>2];G=+g[B+16>>2];q=+g[B+32>>2];H=+g[B+4>>2];r=+g[B+20>>2];I=+g[B+36>>2];x=+g[B+8>>2];z=+g[B+24>>2];N=+g[B+40>>2];M=-+g[B+48>>2];v=-+g[B+52>>2];L=-+g[B+56>>2];J=+g[e+48>>2];K=+g[e+52>>2];p=+g[e+56>>2];n=m*M+G*v+q*L+(m*J+G*K+q*p);o=H*M+r*v+I*L+(H*J+r*K+I*p);p=x*M+z*v+N*L+(x*J+z*K+N*p);K=+g[f+48>>2];J=+g[f+52>>2];u=+g[f+56>>2];s=m*M+G*v+q*L+(m*K+G*J+q*u);t=H*M+r*v+I*L+(H*K+r*J+I*u);u=x*M+z*v+N*L+(x*K+z*J+N*u);J=+g[f>>2];K=+g[f+16>>2];L=+g[f+32>>2];v=+g[f+4>>2];M=+g[f+20>>2];w=+g[f+36>>2];y=+g[f+8>>2];A=+g[f+24>>2];O=+g[f+40>>2];g[D+656>>2]=m*J+G*K+q*L;g[D+660>>2]=m*v+G*M+q*w;g[D+664>>2]=m*y+G*A+q*O;g[D+668>>2]=0.0;g[D+672>>2]=H*J+r*K+I*L;g[D+676>>2]=H*v+r*M+I*w;g[D+680>>2]=H*y+r*A+I*O;g[D+684>>2]=0.0;g[D+688>>2]=x*J+z*K+N*L;g[D+692>>2]=x*v+z*M+N*w;g[D+696>>2]=x*y+z*A+N*O;F=D+700|0;c[F+0>>2]=0;c[F+4>>2]=0;c[F+8>>2]=0;c[F+12>>2]=0;c[F+16>>2]=0;F=c[h+8>>2]|0;O=+Zb[c[(c[C>>2]|0)+48>>2]&15](C);c[D+720>>2]=17600;c[D+724>>2]=d;c[D+728>>2]=c[e+0>>2];c[D+732>>2]=c[e+4>>2];c[D+736>>2]=c[e+8>>2];c[D+740>>2]=c[e+12>>2];c[D+744>>2]=c[e+16>>2];c[D+748>>2]=c[e+20>>2];c[D+752>>2]=c[e+24>>2];c[D+756>>2]=c[e+28>>2];c[D+760>>2]=c[e+32>>2];c[D+764>>2]=c[e+36>>2];c[D+768>>2]=c[e+40>>2];c[D+772>>2]=c[e+44>>2];c[D+776>>2]=c[e+48>>2];c[D+780>>2]=c[e+52>>2];c[D+784>>2]=c[e+56>>2];c[D+788>>2]=c[e+60>>2];c[D+792>>2]=c[f+0>>2];c[D+796>>2]=c[f+4>>2];c[D+800>>2]=c[f+8>>2];c[D+804>>2]=c[f+12>>2];c[D+808>>2]=c[f+16>>2];c[D+812>>2]=c[f+20>>2];c[D+816>>2]=c[f+24>>2];c[D+820>>2]=c[f+28>>2];c[D+824>>2]=c[f+32>>2];c[D+828>>2]=c[f+36>>2];c[D+832>>2]=c[f+40>>2];c[D+836>>2]=c[f+44>>2];c[D+840>>2]=c[f+48>>2];c[D+844>>2]=c[f+52>>2];c[D+848>>2]=c[f+56>>2];c[D+852>>2]=c[f+60>>2];c[D+856>>2]=c[B+0>>2];c[D+860>>2]=c[B+4>>2];c[D+864>>2]=c[B+8>>2];c[D+868>>2]=c[B+12>>2];c[D+872>>2]=c[B+16>>2];c[D+876>>2]=c[B+20>>2];c[D+880>>2]=c[B+24>>2];c[D+884>>2]=c[B+28>>2];c[D+888>>2]=c[B+32>>2];c[D+892>>2]=c[B+36>>2];c[D+896>>2]=c[B+40>>2];c[D+900>>2]=c[B+44>>2];c[D+904>>2]=c[B+48>>2];c[D+908>>2]=c[B+52>>2];c[D+912>>2]=c[B+56>>2];c[D+916>>2]=c[B+60>>2];g[D+924>>2]=O;c[D+720>>2]=9192;c[D+932>>2]=j;c[D+936>>2]=F;c[D+940>>2]=C;g[D+920>>2]=+g[j+4>>2];g[D+928>>2]=k;tc[c[(c[d>>2]|0)+8>>2]&127](d,D+656|0,D+640|0,D+440|0);g[D+1184>>2]=n;g[D+1188>>2]=o;g[D+1192>>2]=p;g[D+1196>>2]=0.0;if(s<n){g[D+1184>>2]=s;m=s}else m=n;if(t<o){g[D+1188>>2]=t;q=t}else q=o;if(u<p){g[D+1192>>2]=u;r=u}else r=p;g[D+360>>2]=n;g[D+364>>2]=o;g[D+368>>2]=p;g[D+372>>2]=0.0;if(n<s){g[D+360>>2]=s;n=s}if(o<t){g[D+364>>2]=t;o=t}if(p<u){g[D+368>>2]=u;p=u}g[D+1184>>2]=+g[D+640>>2]+m;g[D+1188>>2]=+g[D+644>>2]+q;g[D+1192>>2]=+g[D+648>>2]+r;g[D+360>>2]=+g[D+440>>2]+n;g[D+364>>2]=+g[D+444>>2]+o;g[D+368>>2]=+g[D+448>>2]+p;tc[c[(c[C>>2]|0)+64>>2]&127](C,D+720|0,D+1184|0,D+360|0);i=D;return}}function gv(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0,p=0,q=0;q=i;i=i+256|0;c[q+32>>2]=8928;o=q+68|0;c[o+0>>2]=c[b+0>>2];c[o+4>>2]=c[b+4>>2];c[o+8>>2]=c[b+8>>2];c[o+12>>2]=c[b+12>>2];p=q+84|0;c[p+0>>2]=c[d+0>>2];c[p+4>>2]=c[d+4>>2];c[p+8>>2]=c[d+8>>2];c[p+12>>2]=c[d+12>>2];c[q+244>>2]=a;c[q+248>>2]=e;g[q+100>>2]=1.0;c[q+104>>2]=0;c[q+108>>2]=0;c[q+112>>2]=0;c[q+116>>2]=0;g[q+120>>2]=1.0;c[q+124>>2]=0;c[q+128>>2]=0;c[q+132>>2]=0;c[q+136>>2]=0;g[q+140>>2]=1.0;c[q+144>>2]=0;c[q+148>>2]=c[o+0>>2];c[q+152>>2]=c[o+4>>2];c[q+156>>2]=c[o+8>>2];c[q+160>>2]=c[o+12>>2];g[q+164>>2]=1.0;c[q+168>>2]=0;c[q+172>>2]=0;c[q+176>>2]=0;c[q+180>>2]=0;g[q+184>>2]=1.0;c[q+188>>2]=0;c[q+192>>2]=0;c[q+196>>2]=0;c[q+200>>2]=0;g[q+204>>2]=1.0;c[q+208>>2]=0;c[q+212>>2]=c[d+0>>2];c[q+216>>2]=c[d+4>>2];c[q+220>>2]=c[d+8>>2];c[q+224>>2]=c[d+12>>2];f=+g[d>>2]-+g[b>>2];h=+g[d+4>>2]-+g[b+4>>2];j=+g[d+8>>2]-+g[b+8>>2];k=1.0/+P(+(f*f+h*h+j*j));if(f*k==0.0)l=999999984306749440.0;else l=1.0/(f*k);g[q+36>>2]=l;if(h*k==0.0)m=999999984306749440.0;else m=1.0/(h*k);g[q+40>>2]=m;if(j*k==0.0)n=999999984306749440.0;else n=1.0/(j*k);g[q+44>>2]=n;c[q+52>>2]=l<0.0&1;c[q+56>>2]=m<0.0&1;c[q+60>>2]=n<0.0&1;g[q+64>>2]=f*k*(+g[p>>2]-+g[o>>2])+h*k*(+g[q+88>>2]-+g[q+72>>2])+j*k*(+g[q+92>>2]-+g[q+76>>2]);a=c[a+68>>2]|0;e=c[(c[a>>2]|0)+24>>2]|0;c[q+16>>2]=0;c[q+20>>2]=0;c[q+24>>2]=0;c[q+28>>2]=0;c[q+0>>2]=0;c[q+4>>2]=0;c[q+8>>2]=0;c[q+12>>2]=0;Xb[e&7](a,b,d,q+32|0,q+16|0,q);i=q;return}function hv(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=+h;var j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0,q=0,r=0,s=0,t=0.0;r=i;i=i+416|0;jE(8536);c[r+16>>2]=c[d+0>>2];c[r+20>>2]=c[d+4>>2];c[r+24>>2]=c[d+8>>2];c[r+28>>2]=c[d+12>>2];c[r+32>>2]=c[d+16>>2];c[r+36>>2]=c[d+20>>2];c[r+40>>2]=c[d+24>>2];c[r+44>>2]=c[d+28>>2];c[r+48>>2]=c[d+32>>2];c[r+52>>2]=c[d+36>>2];c[r+56>>2]=c[d+40>>2];c[r+60>>2]=c[d+44>>2];q=r+64|0;c[q+0>>2]=c[d+48>>2];c[q+4>>2]=c[d+52>>2];c[q+8>>2]=c[d+56>>2];c[q+12>>2]=c[d+60>>2];c[r+80>>2]=c[e+0>>2];c[r+84>>2]=c[e+4>>2];c[r+88>>2]=c[e+8>>2];c[r+92>>2]=c[e+12>>2];c[r+96>>2]=c[e+16>>2];c[r+100>>2]=c[e+20>>2];c[r+104>>2]=c[e+24>>2];c[r+108>>2]=c[e+28>>2];c[r+112>>2]=c[e+32>>2];c[r+116>>2]=c[e+36>>2];c[r+120>>2]=c[e+40>>2];c[r+124>>2]=c[e+44>>2];p=r+128|0;c[p+0>>2]=c[e+48>>2];c[p+4>>2]=c[e+52>>2];c[p+8>>2]=c[e+56>>2];c[p+12>>2]=c[e+60>>2];Kp(r+16|0,r+80|0,r+200|0,r+160|0);t=+g[r+160>>2];j=t*+g[r+204>>2];n=t*+g[r+208>>2];g[r+144>>2]=+g[r+200>>2]*t;g[r+148>>2]=j;g[r+152>>2]=n;g[r+156>>2]=0.0;c[r+184>>2]=0;c[r+188>>2]=0;c[r+192>>2]=0;c[r+196>>2]=0;c[r+204>>2]=0;c[r+208>>2]=0;c[r+224>>2]=0;c[r+228>>2]=0;s=r+244|0;c[s+0>>2]=0;c[s+4>>2]=0;c[s+8>>2]=0;c[s+12>>2]=0;c[s+16>>2]=0;Fc(r+16|0,r+168|0);n=+g[r+168>>2];j=+g[r+172>>2];t=+g[r+176>>2];m=+g[r+180>>2];k=n*(2.0/(n*n+j*j+t*t+m*m));o=j*(2.0/(n*n+j*j+t*t+m*m));l=t*(2.0/(n*n+j*j+t*t+m*m));g[r+200>>2]=1.0-(j*o+t*l);g[r+204>>2]=n*o-m*l;g[r+208>>2]=n*l+m*o;g[r+212>>2]=0.0;g[r+216>>2]=n*o+m*l;g[r+220>>2]=1.0-(n*k+t*l);g[r+224>>2]=j*l-m*k;g[r+228>>2]=0.0;g[r+232>>2]=n*l-m*o;g[r+236>>2]=j*l+m*k;g[r+240>>2]=1.0-(n*k+j*o);g[s>>2]=0.0;Fy(b,r+200|0,r+184|0,r+144|0,r+400|0,r);c[r+200>>2]=8816;c[r+236>>2]=c[d+0>>2];c[r+240>>2]=c[d+4>>2];c[r+244>>2]=c[d+8>>2];c[r+248>>2]=c[d+12>>2];c[r+252>>2]=c[d+16>>2];c[r+256>>2]=c[d+20>>2];c[r+260>>2]=c[d+24>>2];c[r+264>>2]=c[d+28>>2];c[r+268>>2]=c[d+32>>2];c[r+272>>2]=c[d+36>>2];c[r+276>>2]=c[d+40>>2];c[r+280>>2]=c[d+44>>2];s=r+284|0;c[s+0>>2]=c[d+48>>2];c[s+4>>2]=c[d+52>>2];c[s+8>>2]=c[d+56>>2];c[s+12>>2]=c[d+60>>2];c[r+300>>2]=c[e+0>>2];c[r+304>>2]=c[e+4>>2];c[r+308>>2]=c[e+8>>2];c[r+312>>2]=c[e+12>>2];c[r+316>>2]=c[e+16>>2];c[r+320>>2]=c[e+20>>2];c[r+324>>2]=c[e+24>>2];c[r+328>>2]=c[e+28>>2];c[r+332>>2]=c[e+32>>2];c[r+336>>2]=c[e+36>>2];c[r+340>>2]=c[e+40>>2];c[r+344>>2]=c[e+44>>2];d=r+348|0;c[d+0>>2]=c[e+48>>2];c[d+4>>2]=c[e+52>>2];c[d+8>>2]=c[e+56>>2];c[d+12>>2]=c[e+60>>2];c[r+380>>2]=a;c[r+384>>2]=f;g[r+388>>2]=h;c[r+392>>2]=b;o=+g[d>>2]-+g[s>>2];h=+g[r+352>>2]-+g[r+288>>2];j=+g[r+356>>2]-+g[r+292>>2];k=1.0/+P(+(o*o+h*h+j*j));if(o*k==0.0)l=999999984306749440.0;else l=1.0/(o*k);g[r+204>>2]=l;if(h*k==0.0)m=999999984306749440.0;else m=1.0/(h*k);g[r+208>>2]=m;if(j*k==0.0)n=999999984306749440.0;else n=1.0/(j*k);g[r+212>>2]=n;c[r+220>>2]=l<0.0&1;c[r+224>>2]=m<0.0&1;c[r+228>>2]=n<0.0&1;g[r+232>>2]=j*(j*k)+(o*(o*k)+h*(h*k));b=c[a+68>>2]|0;Xb[c[(c[b>>2]|0)+24>>2]&7](b,q,p,r+200|0,r+400|0,r);b=c[5128]|0;q=(c[b+16>>2]|0)+-1|0;c[b+16>>2]=q;if(q){i=r;return}do if(c[b+4>>2]|0){Cb(r+200|0,0)|0;q=c[5114]|0;g[b+8>>2]=+(((c[r+204>>2]|0)-(c[q+4>>2]|0)+(((c[r+200>>2]|0)-(c[q>>2]|0)|0)*1e6|0)-(c[b+12>>2]|0)|0)>>>0)/1.0e3+ +g[b+8>>2];if(!(c[b+16>>2]|0)){b=c[5128]|0;break}else{i=r;return}}while(0);c[5128]=c[b+20>>2];i=r;return}function iv(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;f=i;i=i+96|0;g=c[b+192>>2]|0;c[f+64>>2]=0;c[f+68>>2]=g;c[f+72>>2]=b;c[f+76>>2]=b+4;c[f+80>>2]=-1;c[f+84>>2]=-1;b=c[d+192>>2]|0;c[f+40>>2]=0;c[f+44>>2]=b;c[f+48>>2]=d;c[f+52>>2]=d+4;c[f+56>>2]=-1;c[f+60>>2]=-1;b=c[a+24>>2]|0;b=Rb[c[(c[b>>2]|0)+8>>2]&31](b,f+64|0,f+40|0,0)|0;if(!b){i=f;return}c[f+4>>2]=0;c[f+8>>2]=f+64;c[f+12>>2]=f+40;c[f>>2]=8696;c[f+32>>2]=e;Hb[c[(c[b>>2]|0)+8>>2]&31](b,f+64|0,f+40|0,a+28|0,f);Jb[c[c[b>>2]>>2]&255](b);g=c[a+24>>2]|0;Lb[c[(c[g>>2]|0)+60>>2]&127](g,b);i=f;return}function jv(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0,k=0.0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0;s=i;i=i+480|0;f=Nb[c[(c[a>>2]|0)+20>>2]&127](a)|0;rc[c[(c[f>>2]|0)+56>>2]&7](f,b,1.0);f=c[d+4>>2]|0;switch(f|0){case 8:{k=+Zb[c[(c[d>>2]|0)+48>>2]&15](d);a=Nb[c[(c[a>>2]|0)+20>>2]&127](a)|0;Qb[c[(c[a>>2]|0)+16>>2]&0](a,k,b,e);i=s;return}case 9:{f=c[d+92>>2]|0;if((f|0)<=0){i=s;return}do{f=f+-1|0;r=c[d+100>>2]|0;E=+g[r+(f<<4)>>2];D=+g[r+(f<<4)+4>>2];j=+g[r+(f<<4)+8>>2];r=Nb[c[(c[a>>2]|0)+20>>2]&127](a)|0;q=c[(c[r>>2]|0)+16>>2]|0;k=+g[(c[d+120>>2]|0)+(f<<2)>>2];B=+g[b>>2];A=+g[b+4>>2];C=+g[b+8>>2];y=+g[b+16>>2];x=+g[b+20>>2];z=+g[b+24>>2];v=+g[b+32>>2];u=+g[b+36>>2];w=+g[b+40>>2];t=E*B+D*A+j*C+ +g[b+48>>2];h=E*y+D*x+j*z+ +g[b+52>>2];j=E*v+D*u+j*w+ +g[b+56>>2];g[s+80>>2]=B+A*0.0+C*0.0;g[s+84>>2]=B*0.0+A+C*0.0;g[s+88>>2]=C+(B*0.0+A*0.0);g[s+92>>2]=0.0;g[s+96>>2]=y+x*0.0+z*0.0;g[s+100>>2]=y*0.0+x+z*0.0;g[s+104>>2]=z+(y*0.0+x*0.0);g[s+108>>2]=0.0;g[s+112>>2]=v+u*0.0+w*0.0;g[s+116>>2]=v*0.0+u+w*0.0;g[s+120>>2]=w+(v*0.0+u*0.0);g[s+124>>2]=0.0;g[s+128>>2]=t;g[s+132>>2]=h;g[s+136>>2]=j;g[s+140>>2]=0.0;Qb[q&0](r,k,s+80|0,e)}while((f|0)>0);i=s;return}case 0:{c[s+224>>2]=c[d+28>>2];c[s+228>>2]=c[d+32>>2];c[s+232>>2]=c[d+36>>2];c[s+236>>2]=c[d+40>>2];y=+Zb[c[(c[d>>2]|0)+48>>2]&15](d);z=+Zb[c[(c[d>>2]|0)+48>>2]&15](d);E=+Zb[c[(c[d>>2]|0)+48>>2]&15](d);y=y+ +g[s+224>>2];g[s+224>>2]=y;z=z+ +g[s+228>>2];g[s+228>>2]=z;E=E+ +g[s+232>>2];g[s+232>>2]=E;a=Nb[c[(c[a>>2]|0)+20>>2]&127](a)|0;d=c[(c[a>>2]|0)+72>>2]|0;g[s+160>>2]=-y;g[s+164>>2]=-z;g[s+168>>2]=-E;g[s+172>>2]=0.0;Hb[d&31](a,s+160|0,s+224|0,b,e);i=s;return}case 31:{f=c[d+16>>2]|0;if((f|0)<=0){i=s;return}do{f=f+-1|0;r=c[d+24>>2]|0;h=+g[r+(f*80|0)>>2];t=+g[r+(f*80|0)+4>>2];u=+g[r+(f*80|0)+8>>2];B=+g[r+(f*80|0)+16>>2];j=+g[r+(f*80|0)+20>>2];D=+g[r+(f*80|0)+24>>2];A=+g[r+(f*80|0)+32>>2];C=+g[r+(f*80|0)+36>>2];w=+g[r+(f*80|0)+40>>2];M=+g[r+(f*80|0)+48>>2];L=+g[r+(f*80|0)+52>>2];E=+g[r+(f*80|0)+56>>2];r=c[r+(f*80|0)+64>>2]|0;q=c[(c[a>>2]|0)+28>>2]|0;K=+g[b>>2];J=+g[b+4>>2];I=+g[b+8>>2];H=+g[b+16>>2];G=+g[b+20>>2];F=+g[b+24>>2];k=+g[b+32>>2];v=+g[b+36>>2];x=+g[b+40>>2];y=M*K+L*J+E*I+ +g[b+48>>2];z=M*H+L*G+E*F+ +g[b+52>>2];E=M*k+L*v+E*x+ +g[b+56>>2];g[s+400>>2]=h*K+B*J+A*I;g[s+404>>2]=t*K+j*J+C*I;g[s+408>>2]=u*K+D*J+w*I;g[s+412>>2]=0.0;g[s+416>>2]=h*H+B*G+A*F;g[s+420>>2]=t*H+j*G+C*F;g[s+424>>2]=u*H+D*G+w*F;g[s+428>>2]=0.0;g[s+432>>2]=h*k+B*v+A*x;g[s+436>>2]=t*k+j*v+C*x;g[s+440>>2]=u*k+D*v+w*x;g[s+444>>2]=0.0;g[s+448>>2]=y;g[s+452>>2]=z;g[s+456>>2]=E;g[s+460>>2]=0.0;tc[q&127](a,s+400|0,r,e)}while((f|0)>0);i=s;return}case 10:{r=c[d+52>>2]|0;L=+g[d+(((r+2|0)%3|0)<<2)+28>>2];M=+g[d+(r<<2)+28>>2];a=Nb[c[(c[a>>2]|0)+20>>2]&127](a)|0;Pb[c[(c[a>>2]|0)+76>>2]&0](a,L,M,r,b,e);i=s;return}case 11:{L=+g[d+56>>2];M=+g[d+60>>2];d=c[d+68>>2]|0;a=Nb[c[(c[a>>2]|0)+20>>2]&127](a)|0;Pb[c[(c[a>>2]|0)+84>>2]&0](a,L,M,d,b,e);i=s;return}case 13:{r=c[d+52>>2]|0;L=+Zb[c[(c[d>>2]|0)+92>>2]&15](d);c[s+16>>2]=c[d+28>>2];c[s+20>>2]=c[d+32>>2];c[s+24>>2]=c[d+36>>2];c[s+28>>2]=c[d+40>>2];J=+Zb[c[(c[d>>2]|0)+48>>2]&15](d);K=+Zb[c[(c[d>>2]|0)+48>>2]&15](d);M=+Zb[c[(c[d>>2]|0)+48>>2]&15](d);g[s+16>>2]=J+ +g[s+16>>2];g[s+20>>2]=K+ +g[s+20>>2];g[s+24>>2]=M+ +g[s+24>>2];M=+g[s+16+(r<<2)>>2];a=Nb[c[(c[a>>2]|0)+20>>2]&127](a)|0;Pb[c[(c[a>>2]|0)+80>>2]&0](a,L,M,r,b,e);i=s;return}case 28:{M=+g[d+64>>2];a=Nb[c[(c[a>>2]|0)+20>>2]&127](a)|0;ac[c[(c[a>>2]|0)+88>>2]&0](a,d+48|0,M,b,e);i=s;return}default:{a:do if((f|0)<7){q=c[d+52>>2]|0;if(!q){if((Nb[c[(c[d>>2]|0)+100>>2]&127](d)|0)<=0)break;f=0;while(1){tc[c[(c[d>>2]|0)+104>>2]&127](d,f,s+144|0,s+176|0);K=+g[s+144>>2];D=+g[b>>2];I=+g[s+148>>2];v=+g[b+4>>2];G=+g[s+152>>2];w=+g[b+8>>2];y=+g[b+16>>2];z=+g[b+20>>2];E=+g[b+24>>2];H=+g[b+32>>2];J=+g[b+36>>2];L=+g[b+40>>2];x=+g[b+48>>2];F=+g[b+52>>2];M=+g[b+56>>2];g[s+192>>2]=K*D+I*v+G*w+x;g[s+196>>2]=K*y+I*z+G*E+F;g[s+200>>2]=K*H+I*J+G*L+M;g[s+204>>2]=0.0;G=+g[s+176>>2];I=+g[s+180>>2];K=+g[s+184>>2];g[s>>2]=G*D+I*v+K*w+x;g[s+4>>2]=G*y+I*z+K*E+F;g[s+8>>2]=G*H+I*J+K*L+M;g[s+12>>2]=0.0;r=Nb[c[(c[a>>2]|0)+20>>2]&127](a)|0;tc[c[(c[r>>2]|0)+8>>2]&127](r,s+192|0,s,e);f=f+1|0;if((f|0)>=(Nb[c[(c[d>>2]|0)+100>>2]&127](d)|0))break a}}if((c[q+28>>2]|0)>0){r=0;do{f=c[q+36>>2]|0;p=c[f+(r*36|0)+4>>2]|0;b:do if((p|0)>0){n=c[f+(r*36|0)+12>>2]|0;l=n;k=0.0;j=0.0;h=0.0;n=c[n+(p+-1<<2)>>2]|0;f=0;while(1){o=c[l+(f<<2)>>2]|0;m=c[q+16>>2]|0;k=k+ +g[m+(o<<4)>>2];j=j+ +g[m+(o<<4)+4>>2];h=h+ +g[m+(o<<4)+8>>2];m=Nb[c[(c[a>>2]|0)+20>>2]&127](a)|0;l=c[(c[m>>2]|0)+8>>2]|0;N=c[q+16>>2]|0;K=+g[N+(n<<4)>>2];D=+g[b>>2];I=+g[N+(n<<4)+4>>2];v=+g[b+4>>2];G=+g[N+(n<<4)+8>>2];w=+g[b+8>>2];y=+g[b+16>>2];z=+g[b+20>>2];E=+g[b+24>>2];H=+g[b+32>>2];J=+g[b+36>>2];L=+g[b+40>>2];x=+g[b+48>>2];F=+g[b+52>>2];M=+g[b+56>>2];g[s+32>>2]=K*D+I*v+G*w+x;g[s+36>>2]=K*y+I*z+G*E+F;g[s+40>>2]=K*H+I*J+G*L+M;g[s+44>>2]=0.0;G=+g[N+(o<<4)>>2];I=+g[N+(o<<4)+4>>2];K=+g[N+(o<<4)+8>>2];g[s+240>>2]=G*D+I*v+K*w+x;g[s+244>>2]=G*y+I*z+K*E+F;g[s+248>>2]=G*H+I*J+K*L+M;g[s+252>>2]=0.0;tc[l&127](m,s+32|0,s+240|0,e);m=f+1|0;f=c[q+36>>2]|0;if((m|0)>=(c[f+(r*36|0)+4>>2]|0))break b;l=c[f+(r*36|0)+12>>2]|0;n=o;f=m}}else{k=0.0;j=0.0;h=0.0}while(0);k=k*(1.0/+(p|0));j=j*(1.0/+(p|0));h=h*(1.0/+(p|0));N=Nb[c[(c[a>>2]|0)+20>>2]&127](a)|0;if((Nb[c[(c[N>>2]|0)+48>>2]&127](N)|0)&16384){g[s+352>>2]=1.0;g[s+356>>2]=1.0;g[s+360>>2]=0.0;g[s+364>>2]=0.0;N=c[q+36>>2]|0;G=+g[N+(r*36|0)+20>>2];I=+g[N+(r*36|0)+24>>2];K=+g[N+(r*36|0)+28>>2];N=Nb[c[(c[a>>2]|0)+20>>2]&127](a)|0;p=c[(c[N>>2]|0)+8>>2]|0;D=+g[b>>2];v=+g[b+4>>2];w=+g[b+8>>2];y=+g[b+16>>2];z=+g[b+20>>2];E=+g[b+24>>2];H=+g[b+32>>2];J=+g[b+36>>2];L=+g[b+40>>2];x=+g[b+48>>2];F=+g[b+52>>2];M=+g[b+56>>2];g[s+384>>2]=k*D+j*v+h*w+x;g[s+388>>2]=k*y+j*z+h*E+F;g[s+392>>2]=k*H+j*J+h*L+M;g[s+396>>2]=0.0;g[s+464>>2]=(k+G)*D+(j+I)*v+(h+K)*w+x;g[s+468>>2]=(k+G)*y+(j+I)*z+(h+K)*E+F;g[s+472>>2]=(k+G)*H+(j+I)*J+(h+K)*L+M;g[s+476>>2]=0.0;tc[p&127](N,s+384|0,s+464|0,s+352|0)}r=r+1|0}while((r|0)<(c[q+28>>2]|0))}}while(0);f=c[d+4>>2]|0;if((f+-21|0)>>>0<9){g[s+208>>2]=999999984306749440.0;g[s+212>>2]=999999984306749440.0;g[s+216>>2]=999999984306749440.0;g[s+220>>2]=0.0;g[s+48>>2]=-999999984306749440.0;g[s+52>>2]=-999999984306749440.0;g[s+56>>2]=-999999984306749440.0;g[s+60>>2]=0.0;f=Nb[c[(c[a>>2]|0)+20>>2]&127](a)|0;c[s+256>>2]=8592;c[s+260>>2]=8616;c[s+264>>2]=f;c[s+268>>2]=c[e+0>>2];c[s+272>>2]=c[e+4>>2];c[s+276>>2]=c[e+8>>2];c[s+280>>2]=c[e+12>>2];c[s+284>>2]=c[b+0>>2];c[s+288>>2]=c[b+4>>2];c[s+292>>2]=c[b+8>>2];c[s+296>>2]=c[b+12>>2];c[s+300>>2]=c[b+16>>2];c[s+304>>2]=c[b+20>>2];c[s+308>>2]=c[b+24>>2];c[s+312>>2]=c[b+28>>2];c[s+316>>2]=c[b+32>>2];c[s+320>>2]=c[b+36>>2];c[s+324>>2]=c[b+40>>2];c[s+328>>2]=c[b+44>>2];c[s+332>>2]=c[b+48>>2];c[s+336>>2]=c[b+52>>2];c[s+340>>2]=c[b+56>>2];c[s+344>>2]=c[b+60>>2];tc[c[(c[d>>2]|0)+64>>2]&127](d,s+256|0,s+48|0,s+208|0);f=c[d+4>>2]|0}if((f|0)!=3){i=s;return}g[s+64>>2]=999999984306749440.0;g[s+68>>2]=999999984306749440.0;g[s+72>>2]=999999984306749440.0;g[s+76>>2]=0.0;g[s+368>>2]=-999999984306749440.0;g[s+372>>2]=-999999984306749440.0;g[s+376>>2]=-999999984306749440.0;g[s+380>>2]=0.0;N=Nb[c[(c[a>>2]|0)+20>>2]&127](a)|0;c[s+256>>2]=8592;c[s+260>>2]=8616;c[s+264>>2]=N;c[s+268>>2]=c[e+0>>2];c[s+272>>2]=c[e+4>>2];c[s+276>>2]=c[e+8>>2];c[s+280>>2]=c[e+12>>2];c[s+284>>2]=c[b+0>>2];c[s+288>>2]=c[b+4>>2];c[s+292>>2]=c[b+8>>2];c[s+296>>2]=c[b+12>>2];c[s+300>>2]=c[b+16>>2];c[s+304>>2]=c[b+20>>2];c[s+308>>2]=c[b+24>>2];c[s+312>>2]=c[b+28>>2];c[s+316>>2]=c[b+32>>2];c[s+320>>2]=c[b+36>>2];c[s+324>>2]=c[b+40>>2];c[s+328>>2]=c[b+44>>2];c[s+332>>2]=c[b+48>>2];c[s+336>>2]=c[b+52>>2];c[s+340>>2]=c[b+56>>2];c[s+344>>2]=c[b+60>>2];b=c[d+92>>2]|0;tc[c[(c[b>>2]|0)+8>>2]&127](b,s+260|0,s+368|0,s+64|0);i=s;return}}}function kv(b){b=b|0;var d=0.0,e=0,f=0,h=0,j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0,r=0;r=i;i=i+112|0;if(((Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0)!=0?(q=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0,((Nb[c[(c[q>>2]|0)+48>>2]&127](q)|0)&8|0)!=0):0)?(e=c[b+24>>2]|0,e=Nb[c[(c[e>>2]|0)+36>>2]&127](e)|0,g[r+32>>2]=1.0,g[r+36>>2]=1.0,g[r+40>>2]=0.0,g[r+44>>2]=0.0,(e|0)>0):0){j=0;do{f=c[b+24>>2]|0;f=ec[c[(c[f>>2]|0)+40>>2]&31](f,j)|0;h=c[f+748>>2]|0;if((h|0)>0){k=0;do{q=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;Kb[c[(c[q>>2]|0)+32>>2]&0](q,f+(k*184|0)+36|0,f+(k*184|0)+68|0,+g[f+(k*184|0)+84>>2],c[f+(k*184|0)+152>>2]|0,r+32|0);k=k+1|0}while((k|0)!=(h|0))}j=j+1|0}while((j|0)!=(e|0))}if(!(Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0)){i=r;return}q=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;if(!((Nb[c[(c[q>>2]|0)+48>>2]&127](q)|0)&3)){i=r;return}if((c[b+8>>2]|0)<=0){i=r;return}h=r+68|0;f=r+72|0;e=r+76|0;q=0;do{j=c[(c[b+16>>2]|0)+(q<<2)>>2]|0;if(!(c[j+204>>2]&32)){if((Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0)!=0?(k=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0,((Nb[c[(c[k>>2]|0)+48>>2]&127](k)|0)&1|0)!=0):0){g[r+64>>2]=1.0;g[h>>2]=1.0;g[f>>2]=1.0;g[e>>2]=0.0;switch(c[j+216>>2]|0){case 4:{g[r+64>>2]=1.0;g[h>>2]=0.0;g[f>>2]=0.0;g[e>>2]=0.0;break}case 5:{g[r+64>>2]=1.0;g[h>>2]=1.0;g[f>>2]=0.0;g[e>>2]=0.0;break}case 2:{g[r+64>>2]=0.0;g[h>>2]=1.0;g[f>>2]=0.0;g[e>>2]=0.0;break}case 3:{g[r+64>>2]=0.0;g[h>>2]=1.0;g[f>>2]=1.0;g[e>>2]=0.0;break}case 1:{g[r+64>>2]=1.0;g[h>>2]=1.0;g[f>>2]=1.0;g[e>>2]=0.0;break}default:{g[r+64>>2]=1.0;g[h>>2]=0.0;g[f>>2]=0.0;g[e>>2]=0.0}}tc[c[(c[b>>2]|0)+28>>2]&127](b,j+4|0,c[j+192>>2]|0,r+64|0)}k=c[b+72>>2]|0;if((k|0)!=0?((Nb[c[(c[k>>2]|0)+48>>2]&127](k)|0)&2|0)!=0:0){g[r+16>>2]=1.0;g[r+20>>2]=0.0;g[r+24>>2]=0.0;g[r+28>>2]=0.0;k=c[j+192>>2]|0;tc[c[(c[k>>2]|0)+8>>2]&127](k,j+4|0,r+80|0,r+96|0);g[r+80>>2]=+g[r+80>>2]+-.019999999552965164;g[r+84>>2]=+g[r+84>>2]+-.019999999552965164;g[r+88>>2]=+g[r+88>>2]+-.019999999552965164;g[r+96>>2]=+g[r+96>>2]+.019999999552965164;g[r+100>>2]=+g[r+100>>2]+.019999999552965164;g[r+104>>2]=+g[r+104>>2]+.019999999552965164;do if(((a[b+44>>0]|0)!=0?(c[j+236>>2]|0)==2:0)?(c[j+204>>2]&3|0)==0:0){k=c[j+192>>2]|0;tc[c[(c[k>>2]|0)+8>>2]&127](k,j+68|0,r,r+48|0);d=+g[r>>2]+-.019999999552965164;g[r>>2]=d;l=+g[r+4>>2]+-.019999999552965164;g[r+4>>2]=l;m=+g[r+8>>2]+-.019999999552965164;g[r+8>>2]=m;n=+g[r+48>>2]+.019999999552965164;g[r+48>>2]=n;o=+g[r+52>>2]+.019999999552965164;g[r+52>>2]=o;p=+g[r+56>>2]+.019999999552965164;g[r+56>>2]=p;if(d<+g[r+80>>2])g[r+80>>2]=d;if(l<+g[r+84>>2])g[r+84>>2]=l;if(m<+g[r+88>>2])g[r+88>>2]=m;d=+g[r+12>>2];if(d<+g[r+92>>2])g[r+92>>2]=d;if(+g[r+96>>2]<n)g[r+96>>2]=n;if(+g[r+100>>2]<o)g[r+100>>2]=o;if(+g[r+104>>2]<p)g[r+104>>2]=p;d=+g[r+60>>2];if(!(+g[r+108>>2]<d))break;g[r+108>>2]=d}while(0);k=c[b+72>>2]|0;tc[c[(c[k>>2]|0)+52>>2]&127](k,r+80|0,r+96|0,r+16|0)}}q=q+1|0}while((q|0)<(c[b+8>>2]|0));i=r;return}function lv(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;x=i;i=i+80|0;e=c[b+8>>2]|0;if((e|0)>0){g=0;do{f=c[(c[b+16>>2]|0)+(g<<2)>>2]|0;if((c[f+236>>2]|0)==1){Lb[c[(c[f>>2]|0)+24>>2]&127](f,d);e=c[b+8>>2]|0}g=g+1|0}while((g|0)<(e|0))}a[x+16>>0]=1;c[x+12>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;a[x+36>>0]=1;c[x+32>>2]=0;c[x+24>>2]=0;c[x+28>>2]=0;a[x+56>>0]=1;c[x+52>>2]=0;c[x+44>>2]=0;c[x+48>>2]=0;a[x+76>>0]=1;c[x+72>>2]=0;c[x+64>>2]=0;c[x+68>>2]=0;if((e|0)<=0){pv(x);i=x;return}k=-1;l=0;h=0;f=0;m=0;q=0;while(1){p=c[(c[(c[b+16>>2]|0)+(q<<2)>>2]|0)+192>>2]|0;o=(p+~(p<<15)>>10^p+~(p<<15))*9|0;o=(o>>6^o)+~((o>>6^o)<<11)>>16^(o>>6^o)+~((o>>6^o)<<11);g=o&k;a:do if(g>>>0<l>>>0?(u=c[h+(g<<2)>>2]|0,(u|0)!=-1):0){g=c[x+72>>2]|0;j=u;while(1){if((p|0)==(c[g+(j<<3)>>2]|0))break;j=c[f+(j<<2)>>2]|0;if((j|0)==-1){w=15;break a}}if((j|0)!=-1?((c[x+52>>2]|0)+(j<<2)|0)!=0:0)g=m;else w=15}else w=15;while(0);if((w|0)==15){w=0;g=o&m+-1;b:do if(g>>>0<l>>>0?(v=c[h+(g<<2)>>2]|0,(v|0)!=-1):0){j=c[x+72>>2]|0;e=v;while(1){if((p|0)==(c[j+(e<<3)>>2]|0))break;e=c[f+(e<<2)>>2]|0;if((e|0)==-1){w=22;break b}}if((e|0)!=-1){c[(c[x+52>>2]|0)+(e<<2)>>2]=p;g=m}else w=22}else w=22;while(0);if((w|0)==22){w=0;n=c[x+44>>2]|0;if((n|0)==(m|0)){f=(m|0)==0?1:m<<1;if((m|0)<(f|0)){if((f|0)!=0?(c[5132]=(c[5132]|0)+1,t=ZE((f<<2|3)+16|0)|0,(t|0)!=0):0){c[(t+19&-16)+-4>>2]=t;e=t+19&-16}else e=0;if((m|0)>0){j=0;do{h=e+(j<<2)|0;if(h)c[h>>2]=c[(c[x+52>>2]|0)+(j<<2)>>2];j=j+1|0}while((j|0)!=(m|0))}h=c[x+52>>2]|0;if(h){if(a[x+56>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[h+-4>>2]|0)}c[x+52>>2]=0}a[x+56>>0]=1;c[x+52>>2]=e;c[x+48>>2]=f;e=m}else e=m}else e=n;f=(c[x+52>>2]|0)+(e<<2)|0;if(f)c[f>>2]=p;c[x+44>>2]=e+1;f=c[x+64>>2]|0;if((f|0)==(c[x+68>>2]|0)?(r=(f|0)==0?1:f<<1,(f|0)<(r|0)):0){if((r|0)!=0?(c[5132]=(c[5132]|0)+1,s=ZE((r<<3|3)+16|0)|0,(s|0)!=0):0){c[(s+19&-16)+-4>>2]=s;e=s+19&-16}else e=0;if((f|0)>0){j=0;do{h=e+(j<<3)|0;if(h){k=(c[x+72>>2]|0)+(j<<3)|0;l=c[k+4>>2]|0;c[h>>2]=c[k>>2];c[h+4>>2]=l}j=j+1|0}while((j|0)!=(f|0))}f=c[x+72>>2]|0;if(f){if(a[x+76>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[f+-4>>2]|0)}c[x+72>>2]=0}a[x+76>>0]=1;c[x+72>>2]=e;c[x+68>>2]=r;f=c[x+64>>2]|0}e=(c[x+72>>2]|0)+(f<<3)|0;if(e){c[e>>2]=p;c[e+4>>2]=0}c[x+64>>2]=f+1;f=c[x+48>>2]|0;if((m|0)<(f|0)){l=c[x+4>>2]|0;do if((l|0)<(f|0)){if((l|0)<=(f|0)){if((c[x+8>>2]|0)<(f|0)){do if(!f)e=0;else{c[5132]=(c[5132]|0)+1;g=ZE((f<<2|3)+16|0)|0;if(!g){e=0;break}c[(g+19&-16)+-4>>2]=g;e=g+19&-16}while(0);g=c[x+12>>2]|0;if((l|0)>0){j=0;do{h=e+(j<<2)|0;if(h)c[h>>2]=c[g+(j<<2)>>2];j=j+1|0}while((j|0)!=(l|0))}if(g){if(a[x+16>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[g+-4>>2]|0)}c[x+12>>2]=0}a[x+16>>0]=1;c[x+12>>2]=e;c[x+8>>2]=f;g=e}else g=c[x+12>>2]|0;e=l;do{h=g+(e<<2)|0;if(h)c[h>>2]=0;e=e+1|0}while((e|0)!=(f|0))}c[x+4>>2]=f;k=c[x+24>>2]|0;if((k|0)<(f|0)){if((c[x+28>>2]|0)<(f|0)){do if(!f)e=0;else{c[5132]=(c[5132]|0)+1;g=ZE((f<<2|3)+16|0)|0;if(!g){e=0;break}c[(g+19&-16)+-4>>2]=g;e=g+19&-16}while(0);h=c[x+32>>2]|0;if((k|0)>0){g=0;do{j=e+(g<<2)|0;if(j)c[j>>2]=c[h+(g<<2)>>2];g=g+1|0}while((g|0)!=(k|0))}if(h){if(a[x+36>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[h+-4>>2]|0)}c[x+32>>2]=0}a[x+36>>0]=1;c[x+32>>2]=e;c[x+28>>2]=f}else e=c[x+32>>2]|0;g=k;do{h=e+(g<<2)|0;if(h)c[h>>2]=0;g=g+1|0}while((g|0)!=(f|0))}c[x+24>>2]=f;if((f|0)>0){cF(c[x+12>>2]|0,-1,f<<2|0)|0;cF(c[x+32>>2]|0,-1,f<<2|0)|0}if((l|0)<=0){g=c[x+48>>2]|0;break}h=c[x+72>>2]|0;f=c[x+12>>2]|0;e=c[x+32>>2]|0;g=c[x+48>>2]|0;j=0;do{m=c[h+(j<<3)>>2]|0;m=(m+~(m<<15)>>10^m+~(m<<15))*9|0;m=f+((((m>>6^m)+~((m>>6^m)<<11)>>16^(m>>6^m)+~((m>>6^m)<<11))&g+-1)<<2)|0;c[e+(j<<2)>>2]=c[m>>2];c[m>>2]=j;j=j+1|0}while((j|0)!=(l|0))}else g=f;while(0);f=g;g=o&g+-1}h=c[x+12>>2]|0;g=h+(g<<2)|0;o=c[x+32>>2]|0;c[o+(n<<2)>>2]=c[g>>2];c[g>>2]=n;g=f;f=o}Lb[c[(c[p>>2]|0)+60>>2]&127](p,d);e=c[b+8>>2]|0}j=q+1|0;if((j|0)>=(e|0))break;k=g+-1|0;l=c[x+4>>2]|0;m=g;q=j}pv(x);i=x;return}function mv(a,b){a=a|0;b=b|0;Jb[c[(c[b>>2]|0)+32>>2]&255](b);lv(a,b);Jb[c[(c[b>>2]|0)+36>>2]&255](b);return}function nv(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0;j=+g[c+48>>2]-+g[b+48>>2];h=+g[c+52>>2]-+g[b+52>>2];e=+g[c+56>>2]-+g[b+56>>2];p=+g[b>>2];y=+g[c>>2];o=+g[b+16>>2];x=+g[c+16>>2];n=+g[b+32>>2];w=+g[c+32>>2];v=+g[c+4>>2];u=+g[c+20>>2];t=+g[c+36>>2];s=+g[c+8>>2];r=+g[c+24>>2];q=+g[c+40>>2];m=+g[b+4>>2];l=+g[b+20>>2];k=+g[b+36>>2];i=+g[b+8>>2];f=+g[b+24>>2];d=+g[b+40>>2];g[a>>2]=p*y+o*x+n*w;g[a+4>>2]=p*v+o*u+n*t;g[a+8>>2]=p*s+o*r+n*q;g[a+12>>2]=0.0;g[a+16>>2]=y*m+x*l+w*k;g[a+20>>2]=v*m+u*l+t*k;g[a+24>>2]=s*m+r*l+q*k;g[a+28>>2]=0.0;g[a+32>>2]=y*i+x*f+w*d;g[a+36>>2]=v*i+u*f+t*d;g[a+40>>2]=s*i+r*f+q*d;g[a+44>>2]=0.0;g[a+48>>2]=j*p+h*o+e*n;g[a+52>>2]=j*m+h*l+e*k;g[a+56>>2]=j*i+h*f+e*d;g[a+60>>2]=0.0;return}function ov(a){a=a|0;return}function pv(b){b=b|0;var d=0;d=c[b+72>>2]|0;if(d){if(a[b+76>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+72>>2]=0}a[b+76>>0]=1;c[b+72>>2]=0;c[b+64>>2]=0;c[b+68>>2]=0;d=c[b+52>>2]|0;if(d){if(a[b+56>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+52>>2]=0}a[b+56>>0]=1;c[b+52>>2]=0;c[b+44>>2]=0;c[b+48>>2]=0;d=c[b+32>>2]|0;if(d){if(a[b+36>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;d=c[b+12>>2]|0;if(!d){a[b+16>>0]=1;c[b+12>>2]=0;c[b+4>>2]=0;b=b+8|0;c[b>>2]=0;return}if(a[b+16>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+12>>2]=0;a[b+16>>0]=1;c[b+12>>2]=0;c[b+4>>2]=0;b=b+8|0;c[b>>2]=0;return}function qv(a){a=a|0;return}function rv(a){a=a|0;_E(a+-4|0);return}function sv(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;tc[c[(c[a+-4>>2]|0)+8>>2]&127](a+-4|0,b,d,e);return}function tv(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;tc[c[(c[a>>2]|0)+8>>2]&127](a,b,d,e);return}function uv(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0,G=0.0,H=0.0;e=i;i=i+96|0;l=+g[b>>2];s=+g[a+28>>2];B=+g[b+4>>2];D=+g[a+32>>2];m=+g[b+8>>2];n=+g[a+36>>2];o=+g[a+44>>2];p=+g[a+48>>2];q=+g[a+52>>2];r=+g[a+60>>2];t=+g[a+64>>2];u=+g[a+68>>2];v=+g[a+76>>2];w=+g[a+80>>2];x=+g[a+84>>2];g[e+80>>2]=l*s+B*D+m*n+v;g[e+84>>2]=l*o+B*p+m*q+w;g[e+88>>2]=l*r+B*t+m*u+x;g[e+92>>2]=0.0;y=+g[b+16>>2];z=+g[b+20>>2];A=+g[b+24>>2];g[e+64>>2]=y*s+z*D+A*n+v;g[e+68>>2]=y*o+z*p+A*q+w;g[e+72>>2]=y*r+z*t+A*u+x;g[e+76>>2]=0.0;C=+g[b+32>>2];E=+g[b+36>>2];k=+g[b+40>>2];g[e+48>>2]=C*s+E*D+k*n+v;g[e+52>>2]=C*o+E*p+k*q+w;g[e+56>>2]=C*r+E*t+k*u+x;g[e+60>>2]=0.0;f=(l*s+B*D+m*n+v+(y*s+z*D+A*n+v)+(C*s+E*D+k*n+v))*.3333333432674408;h=(l*o+B*p+m*q+w+(y*o+z*p+A*q+w)+(C*o+E*p+k*q+w))*.3333333432674408;j=(l*r+B*t+m*u+x+(y*r+z*t+A*u+x)+(C*r+E*t+k*u+x))*.3333333432674408;g[e+32>>2]=f;g[e+36>>2]=h;g[e+40>>2]=j;g[e+44>>2]=0.0;b=c[a+8>>2]|0;if(!((Nb[c[(c[b>>2]|0)+48>>2]&127](b)|0)&16384)){d=c[a+8>>2]|0;F=c[d>>2]|0;F=F+8|0;F=c[F>>2]|0;b=a+12|0;tc[F&127](d,e+80|0,e+64|0,b);d=c[a+8>>2]|0;F=c[d>>2]|0;F=F+8|0;F=c[F>>2]|0;tc[F&127](d,e+64|0,e+48|0,b);a=c[a+8>>2]|0;d=c[a>>2]|0;d=d+8|0;d=c[d>>2]|0;tc[d&127](a,e+48|0,e+80|0,b);i=e;return}H=y*s+z*D+A*n+v-(l*s+B*D+m*n+v);G=y*o+z*p+A*q+w-(l*o+B*p+m*q+w);z=y*r+z*t+A*u+x-(l*r+B*t+m*u+x);D=C*s+E*D+k*n+v-(l*s+B*D+m*n+v);A=C*o+E*p+k*q+w-(l*o+B*p+m*q+w);C=C*r+E*t+k*u+x-(l*r+B*t+m*u+x);E=1.0/+P(+((H*A-G*D)*(H*A-G*D)+((G*C-z*A)*(G*C-z*A)+(z*D-H*C)*(z*D-H*C))));g[e+16>>2]=1.0;g[e+20>>2]=1.0;g[e+24>>2]=0.0;g[e+28>>2]=0.0;b=c[a+8>>2]|0;d=c[(c[b>>2]|0)+8>>2]|0;g[e>>2]=E*(G*C-z*A)+f;g[e+4>>2]=E*(z*D-H*C)+h;g[e+8>>2]=E*(H*A-G*D)+j;g[e+12>>2]=0.0;tc[d&127](b,e+32|0,e,e+16|0);b=c[a+8>>2]|0;d=c[b>>2]|0;d=d+8|0;d=c[d>>2]|0;F=a+12|0;tc[d&127](b,e+80|0,e+64|0,F);b=c[a+8>>2]|0;d=c[b>>2]|0;d=d+8|0;d=c[d>>2]|0;tc[d&127](b,e+64|0,e+48|0,F);a=c[a+8>>2]|0;b=c[a>>2]|0;b=b+8|0;b=c[b>>2]|0;tc[b&127](a,e+48|0,e+80|0,F);i=e;return}function vv(a){a=a|0;_E(a);return}function wv(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;var h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0,p=0.0,q=0.0,r=0.0,s=0,t=0,u=0,v=0.0,w=0.0,x=0,y=0,z=0;u=i;i=i+192|0;s=c[(c[b+4>>2]|0)+740>>2]|0;t=c[(c[b+8>>2]|0)+8>>2]|0;h=+g[e>>2];p=+g[d>>2]*f+h;j=+g[e+4>>2];q=+g[d+4>>2]*f+j;k=+g[e+8>>2];r=+g[d+8>>2]*f+k;o=c[(c[b+12>>2]|0)+8>>2]|0;if((s|0)!=(t|0)){n=p-+g[o+52>>2];m=q-+g[o+56>>2];l=r-+g[o+60>>2];w=h-+g[t+52>>2];v=j-+g[t+56>>2];k=k-+g[t+60>>2];j=n*+g[o+4>>2]+m*+g[o+20>>2]+l*+g[o+36>>2];h=n*+g[o+8>>2]+m*+g[o+24>>2]+l*+g[o+40>>2];l=n*+g[o+12>>2]+m*+g[o+28>>2]+l*+g[o+44>>2];m=w*+g[t+4>>2]+v*+g[t+20>>2]+k*+g[t+36>>2];n=w*+g[t+8>>2]+v*+g[t+24>>2]+k*+g[t+40>>2];k=w*+g[t+12>>2]+v*+g[t+28>>2]+k*+g[t+44>>2]}else{n=p-+g[s+52>>2];m=q-+g[s+56>>2];l=r-+g[s+60>>2];v=h-+g[o+52>>2];w=j-+g[o+56>>2];k=k-+g[o+60>>2];j=n*+g[s+4>>2]+m*+g[s+20>>2]+l*+g[s+36>>2];h=n*+g[s+8>>2]+m*+g[s+24>>2]+l*+g[s+40>>2];l=n*+g[s+12>>2]+m*+g[s+28>>2]+l*+g[s+44>>2];m=v*+g[o+4>>2]+w*+g[o+20>>2]+k*+g[o+36>>2];n=v*+g[o+8>>2]+w*+g[o+24>>2]+k*+g[o+40>>2];k=v*+g[o+12>>2]+w*+g[o+28>>2]+k*+g[o+44>>2]}g[u>>2]=j;g[u+4>>2]=h;g[u+8>>2]=l;g[u+12>>2]=0.0;g[u+16>>2]=m;g[u+20>>2]=n;g[u+24>>2]=k;g[u+28>>2]=0.0;c[u+64>>2]=c[d+0>>2];c[u+68>>2]=c[d+4>>2];c[u+72>>2]=c[d+8>>2];c[u+76>>2]=c[d+12>>2];g[u+80>>2]=f;g[u+84>>2]=0.0;g[u+88>>2]=0.0;g[u+92>>2]=0.0;c[u+112>>2]=0;a[u+116>>0]=0;c[u+120>>2]=0;c[u+124>>2]=0;c[u+128>>2]=0;c[u+132>>2]=0;c[u+136>>2]=0;c[u+140>>2]=0;c[u+144>>2]=0;c[u+148>>2]=0;g[u+48>>2]=p;g[u+52>>2]=q;g[u+56>>2]=r;g[u+60>>2]=0.0;c[u+32>>2]=c[e+0>>2];c[u+36>>2]=c[e+4>>2];c[u+40>>2]=c[e+8>>2];c[u+44>>2]=c[e+12>>2];if((s|0)!=(t|0)){x=c[b+20>>2]|0;c[u+96>>2]=x;d=c[b+16>>2]|0;c[u+100>>2]=d;e=b+24|0;o=c[b+28>>2]|0;y=u+104|0;c[y>>2]=o;e=c[e>>2]|0;y=u+108|0;c[y>>2]=e;y=(s|0)!=(t|0)?b+12|0:b+8|0;y=c[y>>2]|0;s=(s|0)!=(t|0)?b+8|0:b+12|0;s=c[s>>2]|0;b=b+32|0;b=c[b>>2]|0;t=c[b>>2]|0;t=t+12|0;t=c[t>>2]|0;+Tb[t&1](b,u,y,x,o,s,d,e);i=u;return}else{o=c[b+16>>2]|0;c[u+96>>2]=o;x=c[b+20>>2]|0;c[u+100>>2]=x;y=b+28|0;d=c[b+24>>2]|0;z=u+104|0;c[z>>2]=d;y=c[y>>2]|0;z=u+108|0;c[z>>2]=y;z=(s|0)!=(t|0)?b+12|0:b+8|0;z=c[z>>2]|0;e=(s|0)!=(t|0)?b+8|0:b+12|0;e=c[e>>2]|0;b=b+32|0;b=c[b>>2]|0;s=c[b>>2]|0;s=s+12|0;s=c[s>>2]|0;+Tb[s&1](b,u,z,o,d,e,x,y);i=u;return}}function xv(a){a=a|0;_E(a);return}function yv(a){a=a|0;return}function zv(a,b){a=a|0;b=b|0;var d=0,e=0,f=0.0,h=0,j=0;e=i;i=i+32|0;d=c[a+184>>2]|0;if(+g[d+4>>2]==0.0){a=0;i=e;return a|0}b=c[b>>2]|0;if(!(ec[c[(c[d>>2]|0)+8>>2]&31](d,c[b+188>>2]|0)|0)){a=1;i=e;return a|0}h=c[a+192>>2]|0;j=c[b+192>>2]|0;d=c[a+184>>2]|0;f=+g[a+188>>2];c[e>>2]=0;c[e+4>>2]=j;c[e+8>>2]=b;c[e+12>>2]=b+4;c[e+16>>2]=-1;c[e+20>>2]=-1;fv(h,a+36|0,a+100|0,e,d,f);a=1;i=e;return a|0}function Av(a){a=a|0;_E(a);return}function Bv(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;e=i;i=i+32|0;d=c[a+216>>2]|0;if(+g[d+4>>2]==0.0){a=0;i=e;return a|0}b=c[b>>2]|0;if(!(ec[c[(c[d>>2]|0)+8>>2]&31](d,c[b+188>>2]|0)|0)){a=1;i=e;return a|0}f=c[b+192>>2]|0;d=c[a+216>>2]|0;c[e>>2]=0;c[e+4>>2]=f;c[e+8>>2]=b;c[e+12>>2]=b+4;c[e+16>>2]=-1;c[e+20>>2]=-1;ev(a+68|0,a+132|0,e,d);a=1;i=e;return a|0}function Cv(a){a=a|0;_E(a);return}function Dv(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0;e=i;i=i+16|0;c[e>>2]=-1;c[e+4>>2]=c[a+16>>2];if(!(c[b+4>>2]|0))c[b+4>>2]=e;h=c[a+12>>2]|0;f=+fc[c[(c[h>>2]|0)+12>>2]&15](h,b,d);g[a+4>>2]=+g[(c[a+12>>2]|0)+4>>2];i=e;return +f}function Ev(a,b){a=a|0;b=b|0;a=c[a+12>>2]|0;return ec[c[(c[a>>2]|0)+8>>2]&31](a,b)|0}function Fv(a){a=a|0;_E(a);return}function Gv(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=+e;f=f|0;h=h|0;var j=0;j=i;i=i+64|0;c[j+48>>2]=f;c[j+52>>2]=h;f=c[a+212>>2]|0;if(!(+g[f+4>>2]>=e)){i=j;return +e}c[j>>2]=c[a+216>>2];c[j+4>>2]=j+48;c[j+8>>2]=c[b+0>>2];c[j+12>>2]=c[b+4>>2];c[j+16>>2]=c[b+8>>2];c[j+20>>2]=c[b+12>>2];c[j+24>>2]=c[d+0>>2];c[j+28>>2]=c[d+4>>2];c[j+32>>2]=c[d+8>>2];c[j+36>>2]=c[d+12>>2];g[j+40>>2]=e;e=+fc[c[(c[f>>2]|0)+12>>2]&15](f,j,0);i=j;return +e}function Hv(a){a=a|0;_E(a);return}function Iv(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=+e;f=f|0;h=h|0;var j=0;j=i;i=i+64|0;c[j+48>>2]=f;c[j+52>>2]=h;f=c[a+212>>2]|0;if(!(+g[f+4>>2]>=e)){i=j;return +e}c[j>>2]=c[a+216>>2];c[j+4>>2]=j+48;c[j+8>>2]=c[b+0>>2];c[j+12>>2]=c[b+4>>2];c[j+16>>2]=c[b+8>>2];c[j+20>>2]=c[b+12>>2];c[j+24>>2]=c[d+0>>2];c[j+28>>2]=c[d+4>>2];c[j+32>>2]=c[d+8>>2];c[j+36>>2]=c[d+12>>2];g[j+40>>2]=e;e=+fc[c[(c[f>>2]|0)+12>>2]&15](f,j,1);i=j;return +e}function Jv(a){a=a|0;_E(a);return}function Kv(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0;e=i;i=i+16|0;c[e>>2]=-1;c[e+4>>2]=c[a+24>>2];if(!(c[b+4>>2]|0))c[b+4>>2]=e;h=c[a+20>>2]|0;f=+fc[c[(c[h>>2]|0)+12>>2]&15](h,b,d);g[a+4>>2]=+g[(c[a+20>>2]|0)+4>>2];i=e;return +f}function Lv(a,b){a=a|0;b=b|0;a=c[a+20>>2]|0;return ec[c[(c[a>>2]|0)+8>>2]&31](a,b)|0}function Mv(a){a=a|0;_E(a);return}function Nv(a,b){a=a|0;b=b|0;return 1}function Ov(a,b){a=a|0;b=b|0;return 1}function Pv(a,b,d){a=a|0;b=b|0;d=+d;Lb[c[(c[a>>2]|0)+12>>2]&127](a,b);return}function Qv(a,d){a=a|0;d=d|0;var e=0,f=0,h=0;e=i;i=i+128|0;f=c[d+36>>2]|0;d=c[(c[a+8>>2]|0)+24>>2]|0;h=c[d+(f*80|0)+64>>2]|0;rp(e+56|0,c[a+12>>2]|0,d+(f*80|0)|0);d=c[a+4>>2]|0;c[e+32>>2]=0;c[e+36>>2]=h;c[e+40>>2]=d;c[e+44>>2]=e+56;c[e+48>>2]=-1;c[e+52>>2]=f;d=c[a+24>>2]|0;g[e+4>>2]=1.0;c[e+8>>2]=0;b[e+12>>1]=1;b[e+14>>1]=-1;c[e+16>>2]=0;c[e>>2]=9632;c[e+20>>2]=d;c[e+24>>2]=f;g[e+4>>2]=+g[d+4>>2];c[e+16>>2]=c[d+16>>2];ev(c[a+16>>2]|0,c[a+20>>2]|0,e+32|0,e);i=e;return}function Rv(a,b,c){a=a|0;b=b|0;c=c|0;return}function Sv(a){a=a|0;_E(a);return}function Tv(a){a=a|0;return}function Uv(a,b,d,e,f){a=a|0;b=b|0;d=+d;e=e|0;f=f|0;var h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0;h=i;i=i+48|0;c[h+32>>2]=e;c[h+36>>2]=f;n=+g[b>>2];m=+g[b+4>>2];j=+g[b+8>>2];l=+g[a+56>>2]*n+ +g[a+60>>2]*m+ +g[a+64>>2]*j;k=n*+g[a+72>>2]+m*+g[a+76>>2]+j*+g[a+80>>2];j=n*+g[a+88>>2]+m*+g[a+92>>2]+j*+g[a+96>>2];c[h>>2]=c[a+48>>2];c[h+4>>2]=h+32;g[h+8>>2]=l;g[h+12>>2]=k;g[h+16>>2]=j;g[h+20>>2]=0.0;g[h+24>>2]=d;f=c[a+44>>2]|0;d=+fc[c[(c[f>>2]|0)+12>>2]&15](f,h,1);i=h;return +d}function Vv(a){a=a|0;_E(a);return}function Wv(a,b,d,e,f){a=a|0;b=b|0;d=+d;e=e|0;f=f|0;var h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0;h=i;i=i+48|0;c[h+32>>2]=e;c[h+36>>2]=f;n=+g[b>>2];m=+g[b+4>>2];j=+g[b+8>>2];l=+g[a+56>>2]*n+ +g[a+60>>2]*m+ +g[a+64>>2]*j;k=n*+g[a+72>>2]+m*+g[a+76>>2]+j*+g[a+80>>2];j=n*+g[a+88>>2]+m*+g[a+92>>2]+j*+g[a+96>>2];c[h>>2]=c[a+48>>2];c[h+4>>2]=h+32;g[h+8>>2]=l;g[h+12>>2]=k;g[h+16>>2]=j;g[h+20>>2]=0.0;g[h+24>>2]=d;f=c[a+44>>2]|0;d=+fc[c[(c[f>>2]|0)+12>>2]&15](f,h,1);i=h;return +d}function Xv(a){a=a|0;_E(a);return}function Yv(b){b=b|0;var d=0;c[b>>2]=10408;if(!(a[b+8>>0]|0))return;d=c[b+12>>2]|0;if(!d)return;b=c[b+4>>2]|0;Lb[c[(c[b>>2]|0)+16>>2]&127](b,d);return}function Zv(b){b=b|0;var d=0,e=0;c[b>>2]=10408;if(!(a[b+8>>0]|0)){_E(b);return}d=c[b+12>>2]|0;if(!d){_E(b);return}e=c[b+4>>2]|0;Lb[c[(c[e>>2]|0)+16>>2]&127](e,d);_E(b);return}function _v(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0,n=0.0,o=0;k=i;i=i+160|0;j=c[b+12>>2]|0;if(!j){i=k;return}l=(a[b+16>>0]|0)!=0;m=l?e:d;d=l?d:e;o=c[m+4>>2]|0;e=c[d+4>>2]|0;c[h+4>>2]=j;n=+g[j+752>>2];c[k+136>>2]=19920;c[k+140>>2]=o;c[k+144>>2]=e;g[k+148>>2]=n;g[k+128>>2]=999999984306749440.0;j=c[m+12>>2]|0;c[k+0>>2]=c[j+0>>2];c[k+4>>2]=c[j+4>>2];c[k+8>>2]=c[j+8>>2];c[k+12>>2]=c[j+12>>2];c[k+16>>2]=c[j+16>>2];c[k+20>>2]=c[j+20>>2];c[k+24>>2]=c[j+24>>2];c[k+28>>2]=c[j+28>>2];c[k+32>>2]=c[j+32>>2];c[k+36>>2]=c[j+36>>2];c[k+40>>2]=c[j+40>>2];c[k+44>>2]=c[j+44>>2];c[k+48>>2]=c[j+48>>2];c[k+52>>2]=c[j+52>>2];c[k+56>>2]=c[j+56>>2];c[k+60>>2]=c[j+60>>2];j=c[d+12>>2]|0;c[k+64>>2]=c[j+0>>2];c[k+68>>2]=c[j+4>>2];c[k+72>>2]=c[j+8>>2];c[k+76>>2]=c[j+12>>2];c[k+80>>2]=c[j+16>>2];c[k+84>>2]=c[j+20>>2];c[k+88>>2]=c[j+24>>2];c[k+92>>2]=c[j+28>>2];c[k+96>>2]=c[j+32>>2];c[k+100>>2]=c[j+36>>2];c[k+104>>2]=c[j+40>>2];c[k+108>>2]=c[j+44>>2];c[k+112>>2]=c[j+48>>2];c[k+116>>2]=c[j+52>>2];c[k+120>>2]=c[j+56>>2];c[k+124>>2]=c[j+60>>2];MD(k+136|0,k,h,c[f+20>>2]|0,l);if(!(a[b+8>>0]|0)){i=k;return}e=c[h+4>>2]|0;if(!(c[e+748>>2]|0)){i=k;return}d=c[e+740>>2]|0;j=c[(c[h+8>>2]|0)+8>>2]|0;f=c[(c[h+12>>2]|0)+8>>2]|0;if((d|0)==(j|0)){Os(e,d+4|0,f+4|0);i=k;return}else{Os(e,f+4|0,j+4|0);i=k;return}}function $v(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return 1.0}function aw(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;if(!(c[b+12>>2]|0))return;if(!(a[b+8>>0]|0))return;f=c[d+4>>2]|0;if((f|0)==(c[d+8>>2]|0)?(i=(f|0)==0?1:f<<1,(f|0)<(i|0)):0){if(!i)h=0;else{c[5132]=(c[5132]|0)+1;e=ZE((i<<2|3)+16|0)|0;if(!e)f=0;else{c[(e+19&-16)+-4>>2]=e;f=e+19&-16}h=f;f=c[d+4>>2]|0}if((f|0)>0){g=0;do{e=h+(g<<2)|0;if(e)c[e>>2]=c[(c[d+12>>2]|0)+(g<<2)>>2];g=g+1|0}while((g|0)!=(f|0))}e=c[d+12>>2]|0;if(e){if(a[d+16>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[e+-4>>2]|0);f=c[d+4>>2]|0}c[d+12>>2]=0}a[d+16>>0]=1;c[d+12>>2]=h;c[d+8>>2]=i}e=(c[d+12>>2]|0)+(f<<2)|0;if(e)c[e>>2]=c[b+12>>2];c[d+4>>2]=f+1;return}function bw(a){a=a|0;return}function cw(a){a=a|0;_E(a);return}function dw(b){b=b|0;var d=0;c[b>>2]=10520;if(!(a[b+16>>0]|0))return;d=c[b+20>>2]|0;if(!d)return;b=c[b+4>>2]|0;Lb[c[(c[b>>2]|0)+16>>2]&127](b,d);return}function ew(b){b=b|0;var d=0,e=0;c[b>>2]=10520;if(!(a[b+16>>0]|0)){_E(b);return}d=c[b+20>>2]|0;if(!d){_E(b);return}e=c[b+4>>2]|0;Lb[c[(c[e>>2]|0)+16>>2]&127](e,d);_E(b);return}function fw(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0,u=0.0,v=0.0,w=0,x=0.0,y=0.0,z=0.0,A=0.0,B=0,C=0.0,D=0.0,E=0,F=0.0,G=0,H=0.0,I=0,J=0.0,K=0,L=0.0,M=0.0,N=0,Q=0,T=0.0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0.0,$=0.0,aa=0,ba=0.0,ca=0.0,da=0.0,ea=0.0,fa=0.0,ga=0.0,ha=0,ia=0.0,ja=0.0,ka=0.0,la=0,ma=0.0,na=0.0,oa=0.0,pa=0.0,qa=0.0,ra=0.0,sa=0,ta=0.0,ua=0.0,va=0.0,wa=0,xa=0.0,ya=0,za=0,Aa=0;Aa=i;i=i+816|0;m=c[b+20>>2]|0;if(!m){m=c[b+4>>2]|0;m=Wb[c[(c[m>>2]|0)+12>>2]&63](m,c[d+8>>2]|0,c[e+8>>2]|0)|0;c[b+20>>2]=m;a[b+16>>0]=1}c[h+4>>2]=m;ya=c[d+4>>2]|0;za=c[e+4>>2]|0;B=c[ya+4>>2]|0;I=c[za+4>>2]|0;if((B|0)==10&(I|0)==10){z=+g[m+752>>2];wa=c[ya+52>>2]|0;v=+g[ya+(wa<<2)+28>>2];A=+g[ya+(((wa+2|0)%3|0)<<2)+28>>2];ya=c[za+52>>2]|0;p=+g[za+(ya<<2)+28>>2];C=+g[za+(((ya+2|0)%3|0)<<2)+28>>2];d=c[d+12>>2]|0;B=c[e+12>>2]|0;F=+g[d+(wa<<2)>>2];H=+g[d+(wa<<2)+16>>2];D=+g[d+(wa<<2)+32>>2];u=+g[B+(ya<<2)>>2];s=+g[B+(ya<<2)+16>>2];o=+g[B+(ya<<2)+32>>2];n=+g[B+48>>2]-+g[d+48>>2];x=+g[B+52>>2]-+g[d+52>>2];y=+g[B+56>>2]-+g[d+56>>2];q=1.0-(F*u+H*s+D*o)*(F*u+H*s+D*o);if(!(q==0.0)){q=(F*n+H*x+D*y-(F*u+H*s+D*o)*(u*n+s*x+o*y))/q;if(!(q<-v)){if(q>v)q=v}else q=-v}else q=0.0;r=(F*u+H*s+D*o)*q-(u*n+s*x+o*y);if(r<-p){q=(F*u+H*s+D*o)*-p+(F*n+H*x+D*y);if(!(q<-v))if(q>v){q=v;p=-p}else p=-p;else{q=-v;p=-p}}else if(r>p){q=p*(F*u+H*s+D*o)+(F*n+H*x+D*y);if(!(q<-v)){if(q>v)q=v}else q=-v}else p=r;v=u*p;u=s*p;s=o*p;o=v+(n-F*q);n=u+(x-H*q);p=s+(y-D*q);r=+P(+(p*p+(o*o+n*n)));if(!(r-A-C>z)){do if(p*p+(o*o+n*n)<=1.4210854715202004e-14)if(+O(+D)>.7071067690849304){n=1.0/+P(+(H*H+D*D));g[Aa+544>>2]=0.0;g[Aa+548>>2]=-(D*n);g[Aa+552>>2]=H*n;o=0.0;q=-(D*n);n=H*n;break}else{q=1.0/+P(+(F*F+H*H));g[Aa+544>>2]=-(H*q);g[Aa+548>>2]=F*q;g[Aa+552>>2]=0.0;o=-(H*q);q=F*q;n=0.0;break}else{g[Aa+544>>2]=o*-(1.0/r);g[Aa+548>>2]=n*-(1.0/r);g[Aa+552>>2]=p*-(1.0/r);g[Aa+556>>2]=0.0;o=o*-(1.0/r);q=n*-(1.0/r);n=p*-(1.0/r)}while(0);pa=C*q+(u+ +g[B+52>>2]);xa=C*n+(s+ +g[B+56>>2]);g[Aa+560>>2]=C*o+(v+ +g[B+48>>2]);g[Aa+564>>2]=pa;g[Aa+568>>2]=xa;g[Aa+572>>2]=0.0}if(r-A-C<z){oc[c[(c[h>>2]|0)+16>>2]&15](h,Aa+544|0,Aa+560|0,r-A-C);m=c[h+4>>2]|0}if(!(c[m+748>>2]|0)){i=Aa;return}l=c[m+740>>2]|0;k=c[(c[h+8>>2]|0)+8>>2]|0;j=c[(c[h+12>>2]|0)+8>>2]|0;if((l|0)==(k|0)){Os(m,l+4|0,j+4|0);i=Aa;return}else{Os(m,j+4|0,k+4|0);i=Aa;return}}g[Aa+128>>2]=999999984306749440.0;m=c[b+8>>2]|0;sa=c[b+12>>2]|0;c[Aa+600>>2]=19496;g[Aa+604>>2]=0.0;g[Aa+608>>2]=1.0;g[Aa+612>>2]=0.0;g[Aa+616>>2]=0.0;c[Aa+620>>2]=sa;c[Aa+624>>2]=m;c[Aa+628>>2]=ya;c[Aa+632>>2]=za;c[Aa+636>>2]=B;c[Aa+640>>2]=I;g[Aa+644>>2]=+Zb[c[(c[ya>>2]|0)+48>>2]&15](ya);g[Aa+648>>2]=+Zb[c[(c[za>>2]|0)+48>>2]&15](za);a[Aa+652>>0]=0;c[Aa+660>>2]=-1;c[Aa+672>>2]=1;c[Aa+676>>2]=1;c[Aa+628>>2]=ya;c[Aa+632>>2]=za;pa=+Zb[c[(c[ya>>2]|0)+48>>2]&15](ya);xa=+Zb[c[(c[za>>2]|0)+48>>2]&15](za);xa=pa+xa+ +g[(c[b+20>>2]|0)+752>>2];g[Aa+128>>2]=xa*xa;B=c[d+12>>2]|0;c[Aa+0>>2]=c[B+0>>2];c[Aa+4>>2]=c[B+4>>2];c[Aa+8>>2]=c[B+8>>2];c[Aa+12>>2]=c[B+12>>2];c[Aa+16>>2]=c[B+16>>2];c[Aa+20>>2]=c[B+20>>2];c[Aa+24>>2]=c[B+24>>2];c[Aa+28>>2]=c[B+28>>2];c[Aa+32>>2]=c[B+32>>2];c[Aa+36>>2]=c[B+36>>2];c[Aa+40>>2]=c[B+40>>2];c[Aa+44>>2]=c[B+44>>2];c[Aa+48>>2]=c[B+48>>2];c[Aa+52>>2]=c[B+52>>2];c[Aa+56>>2]=c[B+56>>2];c[Aa+60>>2]=c[B+60>>2];B=c[e+12>>2]|0;c[Aa+64>>2]=c[B+0>>2];c[Aa+68>>2]=c[B+4>>2];c[Aa+72>>2]=c[B+8>>2];c[Aa+76>>2]=c[B+12>>2];c[Aa+80>>2]=c[B+16>>2];c[Aa+84>>2]=c[B+20>>2];c[Aa+88>>2]=c[B+24>>2];c[Aa+92>>2]=c[B+28>>2];c[Aa+96>>2]=c[B+32>>2];c[Aa+100>>2]=c[B+36>>2];c[Aa+104>>2]=c[B+40>>2];c[Aa+108>>2]=c[B+44>>2];c[Aa+112>>2]=c[B+48>>2];c[Aa+116>>2]=c[B+52>>2];c[Aa+120>>2]=c[B+56>>2];c[Aa+124>>2]=c[B+60>>2];B=c[ya+4>>2]|0;do if((B|0)<7?(w=c[za+4>>2]|0,(w|0)<7):0){c[Aa+184>>2]=10928;if(!B){B=w;F=0.0}else{F=+Zb[c[(c[ya>>2]|0)+48>>2]&15](ya);B=c[za+4>>2]|0}if(!B)H=0.0;else H=+Zb[c[(c[za>>2]|0)+48>>2]&15](za);c[Aa+696>>2]=10656;c[Aa+700>>2]=h;g[Aa+720>>2]=F;g[Aa+724>>2]=H;a[Aa+732>>0]=0;w=c[ya+52>>2]|0;if(w){sa=c[za+52>>2]|0;if(!sa){if((c[za+4>>2]|0)!=1)break;B=Aa+148|0;a[B>>0]=1;I=Aa+144|0;c[I>>2]=0;w=Aa+136|0;c[w>>2]=0;G=Aa+140|0;c[G>>2]=0;m=c[e+12>>2]|0;pa=+g[za+56>>2];xa=+g[za+60>>2];p=+g[za+64>>2];r=pa*+g[m>>2]+xa*+g[m+4>>2]+p*+g[m+8>>2]+ +g[m+48>>2];q=pa*+g[m+16>>2]+xa*+g[m+20>>2]+p*+g[m+24>>2]+ +g[m+52>>2];p=pa*+g[m+32>>2]+xa*+g[m+36>>2]+p*+g[m+40>>2]+ +g[m+56>>2];c[5132]=(c[5132]|0)+1;m=ZE(35)|0;if(!m)k=0;else{c[(m+19&-16)+-4>>2]=m;k=m+19&-16}m=c[w>>2]|0;if((m|0)>0){l=0;do{wa=k+(l<<4)|0;Z=(c[I>>2]|0)+(l<<4)|0;c[wa+0>>2]=c[Z+0>>2];c[wa+4>>2]=c[Z+4>>2];c[wa+8>>2]=c[Z+8>>2];c[wa+12>>2]=c[Z+12>>2];l=l+1|0}while((l|0)!=(m|0))}m=c[I>>2]|0;if(m){if(a[B>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[m+-4>>2]|0)}c[I>>2]=0}a[B>>0]=1;c[I>>2]=k;c[G>>2]=1;m=c[w>>2]|0;g[k+(m<<4)>>2]=r;g[k+(m<<4)+4>>2]=q;g[k+(m<<4)+8>>2]=p;g[k+(m<<4)+12>>2]=0.0;m=(c[w>>2]|0)+1|0;c[w>>2]=m;wa=c[e+12>>2]|0;pa=+g[za+72>>2];xa=+g[za+76>>2];q=+g[za+80>>2];s=pa*+g[wa>>2]+xa*+g[wa+4>>2]+q*+g[wa+8>>2]+ +g[wa+48>>2];r=pa*+g[wa+16>>2]+xa*+g[wa+20>>2]+q*+g[wa+24>>2]+ +g[wa+52>>2];q=pa*+g[wa+32>>2]+xa*+g[wa+36>>2]+q*+g[wa+40>>2]+ +g[wa+56>>2];if((m|0)==(c[G>>2]|0)?(aa=(m|0)==0?1:m<<1,(m|0)<(aa|0)):0){if(!aa)k=0;else{c[5132]=(c[5132]|0)+1;m=ZE((aa<<4|3)+16|0)|0;if(!m)m=0;else{c[(m+19&-16)+-4>>2]=m;m=m+19&-16}k=m;m=c[w>>2]|0}if((m|0)>0){l=0;do{wa=k+(l<<4)|0;Z=(c[I>>2]|0)+(l<<4)|0;c[wa+0>>2]=c[Z+0>>2];c[wa+4>>2]=c[Z+4>>2];c[wa+8>>2]=c[Z+8>>2];c[wa+12>>2]=c[Z+12>>2];l=l+1|0}while((l|0)!=(m|0))}m=c[I>>2]|0;if(m){if(a[B>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[m+-4>>2]|0)}c[I>>2]=0}a[B>>0]=1;c[I>>2]=k;c[G>>2]=aa;m=c[w>>2]|0}wa=c[I>>2]|0;g[wa+(m<<4)>>2]=s;g[wa+(m<<4)+4>>2]=r;g[wa+(m<<4)+8>>2]=q;g[wa+(m<<4)+12>>2]=0.0;m=(c[w>>2]|0)+1|0;c[w>>2]=m;wa=c[e+12>>2]|0;pa=+g[za+88>>2];xa=+g[za+92>>2];q=+g[za+96>>2];r=pa*+g[wa>>2]+xa*+g[wa+4>>2]+q*+g[wa+8>>2]+ +g[wa+48>>2];s=pa*+g[wa+16>>2]+xa*+g[wa+20>>2]+q*+g[wa+24>>2]+ +g[wa+52>>2];q=pa*+g[wa+32>>2]+xa*+g[wa+36>>2]+q*+g[wa+40>>2]+ +g[wa+56>>2];if((m|0)==(c[G>>2]|0)?(ha=(m|0)==0?1:m<<1,(m|0)<(ha|0)):0){if(!ha)k=0;else{c[5132]=(c[5132]|0)+1;m=ZE((ha<<4|3)+16|0)|0;if(!m)m=0;else{c[(m+19&-16)+-4>>2]=m;m=m+19&-16}k=m;m=c[w>>2]|0}if((m|0)>0){l=0;do{wa=k+(l<<4)|0;Z=(c[I>>2]|0)+(l<<4)|0;c[wa+0>>2]=c[Z+0>>2];c[wa+4>>2]=c[Z+4>>2];c[wa+8>>2]=c[Z+8>>2];c[wa+12>>2]=c[Z+12>>2];l=l+1|0}while((l|0)!=(m|0))}m=c[I>>2]|0;if(m){if(a[B>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[m+-4>>2]|0)}c[I>>2]=0}a[B>>0]=1;c[I>>2]=k;c[G>>2]=ha;m=c[w>>2]|0}wa=c[I>>2]|0;g[wa+(m<<4)>>2]=r;g[wa+(m<<4)+4>>2]=s;g[wa+(m<<4)+8>>2]=q;g[wa+(m<<4)+12>>2]=0.0;c[w>>2]=(c[w>>2]|0)+1;q=+g[(c[b+20>>2]|0)+752>>2];nD(Aa+600|0,Aa,Aa+184|0,c[f+20>>2]|0,0);n=+g[Aa+604>>2];o=+g[Aa+608>>2];p=+g[Aa+612>>2];if(n*n+o*o+p*p>1.1920928955078125e-07){pa=1.0/(n*n+o*o+p*p);g[Aa+192>>2]=n*pa;g[Aa+196>>2]=o*pa;g[Aa+200>>2]=p*pa;g[Aa+204>>2]=0.0;pa=+g[Aa+656>>2];xa=+Zb[c[(c[ya>>2]|0)+48>>2]&15](ya);xa=pa-xa-+Zb[c[(c[za>>2]|0)+48>>2]&15](za);jD(Aa+192|0,c[ya+52>>2]|0,c[d+12>>2]|0,Aa+132|0,xa-q,q,h)}do if((a[b+16>>0]|0)!=0?(la=c[h+4>>2]|0,(c[la+748>>2]|0)!=0):0){l=c[la+740>>2]|0;k=c[(c[h+8>>2]|0)+8>>2]|0;m=c[(c[h+12>>2]|0)+8>>2]|0;if((l|0)==(k|0)){Os(la,l+4|0,m+4|0);break}else{Os(la,m+4|0,k+4|0);break}}while(0);j=c[I>>2]|0;if(j){if(a[B>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[j+-4>>2]|0)}c[I>>2]=0}a[B>>0]=1;c[I>>2]=0;c[w>>2]=0;c[G>>2]=0;i=Aa;return}xa=+g[(c[b+20>>2]|0)+752>>2];if(!(a[f+24>>0]|0)){nD(Aa+600|0,Aa,Aa+696|0,c[f+20>>2]|0,0);n=+g[Aa+728>>2];if((a[Aa+732>>0]|0)!=0&n<0.0){p=+g[Aa+704>>2];o=+g[Aa+712>>2];r=+g[Aa+716>>2];q=+g[Aa+708>>2];wa=104}}else{Y=c[d+12>>2]|0;W=c[e+12>>2]|0;c[4848]=(c[4848]|0)+1;da=+g[w+64>>2];ea=+g[w+68>>2];v=+g[Y+4>>2];fa=+g[w+72>>2];u=+g[Y+8>>2];s=+g[Y+16>>2];x=+g[Y+20>>2];C=+g[Y+24>>2];D=+g[Y+32>>2];F=+g[Y+36>>2];H=+g[Y+40>>2];ga=+g[sa+64>>2];pa=+g[sa+68>>2];va=+g[sa+72>>2];ta=da*+g[Y>>2]+ea*v+fa*u+ +g[Y+48>>2]-(ga*+g[W>>2]+pa*+g[W+4>>2]+va*+g[W+8>>2]+ +g[W+48>>2]);ua=da*s+ea*x+fa*C+ +g[Y+52>>2]-(ga*+g[W+16>>2]+pa*+g[W+20>>2]+va*+g[W+24>>2]+ +g[W+52>>2]);va=da*D+ea*F+fa*H+ +g[Y+56>>2]-(ga*+g[W+32>>2]+pa*+g[W+36>>2]+va*+g[W+40>>2]+ +g[W+56>>2]);K=c[w+28>>2]|0;a:do if((K|0)>0){J=0.0;A=v;v=3402823466385288598117041.0e14;I=0;z=0.0;y=0.0;r=0.0;n=0.0;while(1){f=c[w+36>>2]|0;ga=+g[f+(I*36|0)+20>>2];pa=+g[f+(I*36|0)+24>>2];o=+g[f+(I*36|0)+28>>2];p=ga*+g[Y>>2]+pa*A+o*u;q=ga*s+pa*x+o*C;o=ga*D+pa*F+o*H;g[Aa+736>>2]=p;g[Aa+740>>2]=q;g[Aa+744>>2]=o;g[Aa+748>>2]=0.0;if(ta*p+ua*q+va*o<0.0){g[Aa+736>>2]=-p;g[Aa+740>>2]=-q;g[Aa+744>>2]=-o;p=-p;q=-q;o=-o}c[4844]=(c[4844]|0)+1;if(iD(Y,W,ta,ua,va,p,q,o,w,sa,v)|0){c[4846]=(c[4846]|0)+1;YD(w,Y,Aa+736|0,Aa+784|0,Aa+576|0,Aa+752|0,Aa+152|0);YD(sa,W,Aa+736|0,Aa+480|0,Aa+208|0,Aa+168|0,Aa+680|0);C=+g[Aa+576>>2];A=+g[Aa+480>>2];if(!(C<A)?(ja=+g[Aa+208>>2],ia=+g[Aa+784>>2],!(ja<ia)):0){B=1;x=C-A<ja-ia?C-A:ja-ia}else{B=0;x=J}if(!B){m=0;p=z;o=y;q=n;break a}if(x<v){H=x;v=x;r=0.0}else{H=x;p=z;o=y;q=n}}else{H=J;p=z;o=y;q=n}B=I+1|0;if((B|0)>=(K|0)){wa=51;break a}J=H;A=+g[Y+4>>2];u=+g[Y+8>>2];s=+g[Y+16>>2];x=+g[Y+20>>2];C=+g[Y+24>>2];D=+g[Y+32>>2];F=+g[Y+36>>2];H=+g[Y+40>>2];I=B;z=p;y=o;n=q}}else{v=3402823466385288598117041.0e14;p=0.0;o=0.0;r=0.0;q=0.0;wa=51}while(0);b:do if((wa|0)==51){m=c[sa+28>>2]|0;if((m|0)>0){u=0.0;I=0;H=p;F=o;z=q;while(1){f=c[sa+36>>2]|0;ja=+g[f+(I*36|0)+20>>2];pa=+g[f+(I*36|0)+24>>2];o=+g[f+(I*36|0)+28>>2];p=ja*+g[W>>2]+pa*+g[W+4>>2]+o*+g[W+8>>2];q=ja*+g[W+16>>2]+pa*+g[W+20>>2]+o*+g[W+24>>2];o=ja*+g[W+32>>2]+pa*+g[W+36>>2]+o*+g[W+40>>2];g[Aa+768>>2]=p;g[Aa+772>>2]=q;g[Aa+776>>2]=o;g[Aa+780>>2]=0.0;if(ta*p+ua*q+va*o<0.0){g[Aa+768>>2]=-p;g[Aa+772>>2]=-q;g[Aa+776>>2]=-o;p=-p;q=-q;o=-o}c[4844]=(c[4844]|0)+1;do if(iD(Y,W,ta,ua,va,p,q,o,w,sa,v)|0){c[4846]=(c[4846]|0)+1;YD(w,Y,Aa+768|0,Aa+784|0,Aa+576|0,Aa+752|0,Aa+152|0);YD(sa,W,Aa+768|0,Aa+480|0,Aa+208|0,Aa+168|0,Aa+680|0);C=+g[Aa+576>>2];A=+g[Aa+480>>2];do if(C<A)B=0;else{x=+g[Aa+208>>2];s=+g[Aa+784>>2];if(x<s){B=0;break}B=1;u=C-A<x-s?C-A:x-s}while(0);if(!B){m=0;p=H;o=F;q=z;break b}if(!(u<v)){D=u;p=H;o=F;q=z;break}D=u;v=u;r=0.0}else{D=u;p=H;o=F;q=z}while(0);I=I+1|0;if((I|0)>=(m|0))break;else{u=D;H=p;F=o;z=q}}}m=c[w+48>>2]|0;if((m|0)>0){C=0.0;y=0.0;n=0.0;L=0.0;A=0.0;x=0.0;u=0.0;H=0.0;F=0.0;D=0.0;da=0.0;ca=0.0;ba=0.0;z=0.0;J=0.0;M=0.0;T=0.0;_=0.0;$=0.0;Z=c[sa+48>>2]|0;la=0;I=-1;B=-1;do{f=c[w+56>>2]|0;ia=+g[f+(la<<4)>>2];ja=+g[f+(la<<4)+4>>2];ra=+g[f+(la<<4)+8>>2];pa=ia*+g[Y>>2]+ja*+g[Y+4>>2]+ra*+g[Y+8>>2];qa=ia*+g[Y+16>>2]+ja*+g[Y+20>>2]+ra*+g[Y+24>>2];ra=ia*+g[Y+32>>2]+ja*+g[Y+36>>2]+ra*+g[Y+40>>2];if((Z|0)>0){oa=C;ga=A;fa=x;ea=u;ka=z;ia=J;ja=M;f=0;ma=p;na=o;while(1){Z=c[sa+56>>2]|0;A=+g[Z+(f<<4)>>2];C=+g[Z+(f<<4)+4>>2];M=+g[Z+(f<<4)+8>>2];z=A*+g[W>>2]+C*+g[W+4>>2]+M*+g[W+8>>2];J=A*+g[W+16>>2]+C*+g[W+20>>2]+M*+g[W+24>>2];M=A*+g[W+32>>2]+C*+g[W+36>>2]+M*+g[W+40>>2];g[Aa+800>>2]=qa*M-ra*J;g[Aa+804>>2]=ra*z-pa*M;g[Aa+808>>2]=pa*J-qa*z;g[Aa+812>>2]=0.0;do if(!(+O(+(qa*M-ra*J))>1.0e-06)){if(+O(+(ra*z-pa*M))>1.0e-06){wa=69;break}if(!(+O(+(pa*J-qa*z))>1.0e-06)){M=ja;J=ia;z=ka;ia=ba;ja=ca;ka=da;s=ea;x=fa;A=ga;ga=oa;p=ma;o=na}else wa=69}else wa=69;while(0);do if((wa|0)==69){wa=0;o=1.0/+P(+((qa*M-ra*J)*(qa*M-ra*J)+(ra*z-pa*M)*(ra*z-pa*M)+(pa*J-qa*z)*(pa*J-qa*z)));p=(qa*M-ra*J)*o;g[Aa+800>>2]=p;C=(ra*z-pa*M)*o;g[Aa+804>>2]=C;o=(pa*J-qa*z)*o;g[Aa+808>>2]=o;if(ta*p+ua*C+va*o<0.0){g[Aa+800>>2]=-p;g[Aa+804>>2]=-C;g[Aa+808>>2]=-o;p=-p;C=-C;o=-o}c[4844]=(c[4844]|0)+1;if(!(iD(Y,W,ta,ua,va,p,C,o,w,sa,v)|0)){M=ja;J=ia;z=ka;ia=ba;ja=ca;ka=da;s=ea;x=fa;A=ga;ga=oa;p=ma;o=na;break}c[4846]=(c[4846]|0)+1;YD(w,Y,Aa+800|0,Aa+784|0,Aa+576|0,Aa+752|0,Aa+152|0);YD(sa,W,Aa+800|0,Aa+480|0,Aa+208|0,Aa+168|0,Aa+680|0);A=+g[Aa+576>>2];x=+g[Aa+480>>2];do if(!(A<x)){u=+g[Aa+208>>2];s=+g[Aa+784>>2];if(u<s){Z=0;u=oa;break}if(A-x<u-s){Z=1;ba=+g[Aa+160>>2];ca=+g[Aa+156>>2];da=+g[Aa+152>>2];ea=+g[Aa+176>>2];fa=+g[Aa+172>>2];ga=+g[Aa+168>>2];u=A-x;break}else{Z=1;ba=+g[Aa+760>>2];ca=+g[Aa+756>>2];da=+g[Aa+752>>2];ea=+g[Aa+688>>2];fa=+g[Aa+684>>2];ga=+g[Aa+680>>2];u=u-s;break}}else{Z=0;u=oa}while(0);if(!Z){m=0;p=ma;o=na;break b}if(!(u<v)){M=ja;J=ia;z=ka;ia=ba;ja=ca;ka=da;s=ea;x=fa;A=ga;ga=u;p=ma;o=na;break}$=ra;_=qa;T=pa;ia=ba;ja=ca;ka=da;D=ba;F=ca;H=da;s=ea;x=fa;A=ga;L=ea;n=fa;y=ga;ga=u;v=u;I=la;B=f;r=0.0;q=C}while(0);f=f+1|0;Z=c[sa+48>>2]|0;if((f|0)>=(Z|0))break;else{oa=ga;ga=A;fa=x;ea=s;da=ka;ca=ja;ba=ia;ka=z;ia=J;ja=M;ma=p;na=o}}ba=ia;ca=ja;da=ka;u=s;C=ga;m=c[w+48>>2]|0}la=la+1|0}while((la|0)<(m|0))}else{$=0.0;_=0.0;T=0.0;M=0.0;J=0.0;z=0.0;D=0.0;F=0.0;H=0.0;L=0.0;n=0.0;y=0.0;I=-1;B=-1}if((B|I|0)>-1){v=y-H;u=n-F;s=L-D;A=T*z+_*J+$*M;x=T*v+_*u+$*s;C=z*v+J*u+M*s;do if(!(1.0-A*A==0.0))if((x-A*C)/(1.0-A*A)<-1000000015047466219876688.0e6)F=-1000000015047466219876688.0e6;else{if(!((x-A*C)/(1.0-A*A)>1000000015047466219876688.0e6)){F=(x-A*C)/(1.0-A*A);break}F=1000000015047466219876688.0e6}else F=0.0;while(0);D=A*F-C;do if(D<-1000000015047466219876688.0e6){if(A*-1000000015047466219876688.0e6+x<-1000000015047466219876688.0e6){F=-1000000015047466219876688.0e6;D=-1000000015047466219876688.0e6;break}if(!(A*-1000000015047466219876688.0e6+x>1000000015047466219876688.0e6)){F=A*-1000000015047466219876688.0e6+x;D=-1000000015047466219876688.0e6;break}F=1000000015047466219876688.0e6;D=-1000000015047466219876688.0e6}else{if(!(D>1000000015047466219876688.0e6))break;if(A*1000000015047466219876688.0e6+x<-1000000015047466219876688.0e6){F=-1000000015047466219876688.0e6;D=1000000015047466219876688.0e6;break}if(!(A*1000000015047466219876688.0e6+x>1000000015047466219876688.0e6)){F=A*1000000015047466219876688.0e6+x;D=1000000015047466219876688.0e6;break}F=1000000015047466219876688.0e6;D=1000000015047466219876688.0e6}while(0);C=z*D;H=D*J;D=D*M;x=v-T*F+C;v=u-F*_+H;u=s-F*$+D;g[Aa+448>>2]=x;g[Aa+452>>2]=v;g[Aa+456>>2]=u;g[Aa+460>>2]=0.0;if(x*x+v*v+u*u>1.1920928955078125e-07){s=+P(+(x*x+v*v+u*u));g[Aa+448>>2]=x*(1.0/s);g[Aa+452>>2]=1.0/s*v;g[Aa+456>>2]=1.0/s*u;if(x*(1.0/s)*ta+1.0/s*v*ua+1.0/s*u*va<0.0){g[Aa+448>>2]=-(x*(1.0/s));g[Aa+452>>2]=-(1.0/s*v);g[Aa+456>>2]=-(1.0/s*u)}g[Aa+464>>2]=y+C;g[Aa+468>>2]=n+H;g[Aa+472>>2]=L+D;g[Aa+476>>2]=0.0;oc[c[(c[h>>2]|0)+16>>2]&15](h,Aa+448|0,Aa+464|0,-s)}}if(ta*p+ua*q+va*o<0.0){m=1;p=-p;o=-o;r=0.0;q=-q}else m=1}while(0);if(m){n=-1000000015047466219876688.0e6;wa=104}}if((wa|0)==104){Z=c[ya+52>>2]|0;N=c[za+52>>2]|0;Q=c[d+12>>2]|0;K=c[e+12>>2]|0;J=n-xa;D=1.0/+P(+(p*p+q*q+o*o));H=p*D;F=q*D;D=o*D;g[Aa+784>>2]=H;g[Aa+788>>2]=F;g[Aa+792>>2]=D;g[Aa+796>>2]=r;w=c[N+28>>2]|0;k=c[N+36>>2]|0;if((w|0)>0){x=+g[K>>2];v=+g[K+4>>2];u=+g[K+8>>2];s=+g[K+16>>2];r=+g[K+20>>2];q=+g[K+24>>2];p=+g[K+32>>2];o=+g[K+36>>2];y=+g[K+40>>2];m=-1;C=-3402823466385288598117041.0e14;B=0;while(1){n=+g[k+(B*36|0)+20>>2];z=+g[k+(B*36|0)+24>>2];A=+g[k+(B*36|0)+28>>2];l=(n*x+z*v+A*u)*H+(n*s+z*r+A*q)*F+(n*p+z*o+A*y)*D>C;m=l?B:m;B=B+1|0;if((B|0)==(w|0)){G=m;break}else C=l?(n*x+z*v+A*u)*H+(n*s+z*r+A*q)*F+(n*p+z*o+A*y)*D:C}}else G=-1;a[Aa+592>>0]=1;I=Aa+588|0;c[I>>2]=0;c[Aa+580>>2]=0;c[Aa+584>>2]=0;E=c[k+(G*36|0)+4>>2]|0;c:do if((E|0)>0){B=k+(G*36|0)+12|0;m=0;k=0;w=0;l=0;while(1){d=c[(c[B>>2]|0)+(l<<2)>>2]|0;za=c[N+16>>2]|0;ja=+g[za+(d<<4)>>2];pa=+g[za+(d<<4)+4>>2];s=+g[za+(d<<4)+8>>2];v=ja*+g[K>>2]+pa*+g[K+4>>2]+s*+g[K+8>>2]+ +g[K+48>>2];u=ja*+g[K+16>>2]+pa*+g[K+20>>2]+s*+g[K+24>>2]+ +g[K+52>>2];s=ja*+g[K+32>>2]+pa*+g[K+36>>2]+s*+g[K+40>>2]+ +g[K+56>>2];if((m|0)==(w|0)){t=(w|0)==0?1:w<<1;if((w|0)<(t|0)){do if(!t){j=0;m=k}else{c[5132]=(c[5132]|0)+1;m=ZE((t<<4|3)+16|0)|0;if(!m){j=0;m=k;break}c[(m+19&-16)+-4>>2]=m;j=m+19&-16;m=c[I>>2]|0}while(0);if((w|0)>0){k=0;do{d=j+(k<<4)|0;za=m+(k<<4)|0;c[d+0>>2]=c[za+0>>2];c[d+4>>2]=c[za+4>>2];c[d+8>>2]=c[za+8>>2];c[d+12>>2]=c[za+12>>2];k=k+1|0}while((k|0)!=(w|0))}if(!m)m=w;else{if(!(a[Aa+592>>0]|0))m=w;else{c[5134]=(c[5134]|0)+1;_E(c[m+-4>>2]|0);m=c[Aa+580>>2]|0}c[I>>2]=0}a[Aa+592>>0]=1;c[I>>2]=j;c[Aa+584>>2]=t}else{j=k;m=w}}else j=k;g[j+(m<<4)>>2]=v;g[j+(m<<4)+4>>2]=u;g[j+(m<<4)+8>>2]=s;g[j+(m<<4)+12>>2]=0.0;m=(c[Aa+580>>2]|0)+1|0;c[Aa+580>>2]=m;l=l+1|0;if((l|0)>=(E|0))break c;k=j;w=c[Aa+584>>2]|0}}else j=0;while(0);if((G|0)>-1){jD(Aa+784|0,Z,Q,Aa+576|0,J,xa,h);j=c[I>>2]|0}if(j){if(a[Aa+592>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[j+-4>>2]|0)}c[I>>2]=0}}if(!(a[b+16>>0]|0)){i=Aa;return}m=c[h+4>>2]|0;if(!(c[m+748>>2]|0)){i=Aa;return}l=c[m+740>>2]|0;k=c[(c[h+8>>2]|0)+8>>2]|0;j=c[(c[h+12>>2]|0)+8>>2]|0;if((l|0)==(k|0)){Os(m,l+4|0,j+4|0);i=Aa;return}else{Os(m,j+4|0,k+4|0);i=Aa;return}}}while(0);nD(Aa+600|0,Aa,h,c[f+20>>2]|0,0);if(((c[b+28>>2]|0)!=0?(c[(c[h+4>>2]|0)+748>>2]|0)<(c[b+32>>2]|0):0)?(J=+g[Aa+604>>2],T=+g[Aa+608>>2],q=+g[Aa+612>>2],J*J+T*T+q*q>1.1920928955078125e-07):0){s=1.0/(J*J+T*T+q*q);if(+O(+(q*s))>.7071067690849304){C=1.0/+P(+(q*s*(q*s)+T*s*(T*s)));F=0.0;D=-(q*s*C);C=T*s*C}else{D=1.0/+P(+(J*s*(J*s)+T*s*(T*s)));F=-(T*s*D);D=J*s*D;C=0.0}u=+Zb[c[(c[ya>>2]|0)+16>>2]&15](ya);v=+Zb[c[(c[za>>2]|0)+16>>2]&15](za);H=.019999999552965164/(u<v?u:v);if(u<v){c[Aa+480>>2]=c[Aa+0>>2];c[Aa+484>>2]=c[Aa+4>>2];c[Aa+488>>2]=c[Aa+8>>2];c[Aa+492>>2]=c[Aa+12>>2];c[Aa+496>>2]=c[Aa+16>>2];c[Aa+500>>2]=c[Aa+20>>2];c[Aa+504>>2]=c[Aa+24>>2];c[Aa+508>>2]=c[Aa+28>>2];c[Aa+512>>2]=c[Aa+32>>2];c[Aa+516>>2]=c[Aa+36>>2];c[Aa+520>>2]=c[Aa+40>>2];c[Aa+524>>2]=c[Aa+44>>2];c[Aa+528>>2]=c[Aa+48>>2];c[Aa+532>>2]=c[Aa+52>>2];c[Aa+536>>2]=c[Aa+56>>2];c[Aa+540>>2]=c[Aa+60>>2]}else{c[Aa+480>>2]=c[Aa+64>>2];c[Aa+484>>2]=c[Aa+68>>2];c[Aa+488>>2]=c[Aa+72>>2];c[Aa+492>>2]=c[Aa+76>>2];c[Aa+496>>2]=c[Aa+80>>2];c[Aa+500>>2]=c[Aa+84>>2];c[Aa+504>>2]=c[Aa+88>>2];c[Aa+508>>2]=c[Aa+92>>2];c[Aa+512>>2]=c[Aa+96>>2];c[Aa+516>>2]=c[Aa+100>>2];c[Aa+520>>2]=c[Aa+104>>2];c[Aa+524>>2]=c[Aa+108>>2];c[Aa+528>>2]=c[Aa+112>>2];c[Aa+532>>2]=c[Aa+116>>2];c[Aa+536>>2]=c[Aa+120>>2];c[Aa+540>>2]=c[Aa+124>>2]}B=c[b+28>>2]|0;if((B|0)>0?(A=C*C+(D*D+F*F),r=H>.39269909262657166?.19634954631328583:H*.5,Q=Aa+244|0,N=Aa+260|0,K=Aa+276|0,l=Aa+292|0,j=Aa+308|0,G=Aa+324|0,k=Aa+340|0,E=Aa+356|0,t=Aa+372|0,U=Aa+388|0,V=Aa+496|0,W=Aa+404|0,X=Aa+512|0,Y=Aa+420|0,Z=Aa+528|0,A>1.1920928955078125e-07):0){H=+S(+r)/+P(+A);x=F*H;A=D*H;D=C*H;H=+R(+r);F=+P(+(q*s*(q*s)+(J*s*(J*s)+T*s*(T*s))));if(u<v){I=0;do{ra=+(I|0)*(6.2831854820251465/+(B|0))*.5;ia=+S(+ra)/F;ra=+R(+ra);da=D*-(T*s*ia)+(x*ra+H*-(J*s*ia))-A*-(q*s*ia);pa=x*-(q*s*ia)+(A*ra+H*-(T*s*ia))-D*-(J*s*ia);ea=A*-(J*s*ia)+(D*ra+H*-(q*s*ia))-x*-(T*s*ia);qa=H*ra-x*-(J*s*ia)-A*-(T*s*ia)-D*-(q*s*ia);ga=q*s*ia*pa+(J*s*ia*qa+ra*da)-T*s*ia*ea;ja=J*s*ia*ea+(ra*pa+T*s*ia*qa)-q*s*ia*da;oa=T*s*ia*da+(q*s*ia*qa+ra*ea)-J*s*ia*pa;ea=ra*qa-J*s*ia*da-T*s*ia*pa-q*s*ia*ea;ia=ga*(2.0/(ea*ea+(oa*oa+(ga*ga+ja*ja))));pa=ja*(2.0/(ea*ea+(oa*oa+(ga*ga+ja*ja))));da=oa*(2.0/(ea*ea+(oa*oa+(ga*ga+ja*ja))));za=c[d+12>>2]|0;qa=+g[za>>2];ra=+g[za+16>>2];ta=+g[za+32>>2];$=+g[za+4>>2];C=+g[za+20>>2];ba=+g[za+36>>2];ca=+g[za+8>>2];fa=+g[za+24>>2];xa=+g[za+40>>2];g[Aa>>2]=(ga*da+ea*pa)*ta+(ra*(ga*pa-ea*da)+qa*(1.0-(ja*pa+oa*da)));g[Aa+4>>2]=(1.0-(ja*pa+oa*da))*$+(ga*pa-ea*da)*C+(ga*da+ea*pa)*ba;g[Aa+8>>2]=(1.0-(ja*pa+oa*da))*ca+(ga*pa-ea*da)*fa+(ga*da+ea*pa)*xa;g[Aa+12>>2]=0.0;g[Aa+16>>2]=(ja*da-ea*ia)*ta+(qa*(ga*pa+ea*da)+ra*(1.0-(ga*ia+oa*da)));g[Aa+20>>2]=(ga*pa+ea*da)*$+(1.0-(ga*ia+oa*da))*C+(ja*da-ea*ia)*ba;g[Aa+24>>2]=(ga*pa+ea*da)*ca+(1.0-(ga*ia+oa*da))*fa+(ja*da-ea*ia)*xa;g[Aa+28>>2]=0.0;g[Aa+32>>2]=qa*(ga*da-ea*pa)+ra*(ja*da+ea*ia)+ta*(1.0-(ga*ia+ja*pa));g[Aa+36>>2]=(ga*da-ea*pa)*$+(ja*da+ea*ia)*C+(1.0-(ga*ia+ja*pa))*ba;g[Aa+40>>2]=(ga*da-ea*pa)*ca+(ja*da+ea*ia)*fa+(1.0-(ga*ia+ja*pa))*xa;g[Aa+44>>2]=0.0;za=c[e+12>>2]|0;c[Aa+64>>2]=c[za+0>>2];c[Aa+68>>2]=c[za+4>>2];c[Aa+72>>2]=c[za+8>>2];c[Aa+76>>2]=c[za+12>>2];c[Aa+80>>2]=c[za+16>>2];c[Aa+84>>2]=c[za+20>>2];c[Aa+88>>2]=c[za+24>>2];c[Aa+92>>2]=c[za+28>>2];c[Aa+96>>2]=c[za+32>>2];c[Aa+100>>2]=c[za+36>>2];c[Aa+104>>2]=c[za+40>>2];c[Aa+108>>2]=c[za+44>>2];c[Aa+112>>2]=c[za+48>>2];c[Aa+116>>2]=c[za+52>>2];c[Aa+120>>2]=c[za+56>>2];c[Aa+124>>2]=c[za+60>>2];za=c[f+20>>2]|0;c[Aa+208>>2]=10848;c[Aa+240>>2]=h;c[Q+0>>2]=c[Aa+0>>2];c[Q+4>>2]=c[Aa+4>>2];c[Q+8>>2]=c[Aa+8>>2];c[Q+12>>2]=c[Aa+12>>2];c[N+0>>2]=c[Aa+16>>2];c[N+4>>2]=c[Aa+20>>2];c[N+8>>2]=c[Aa+24>>2];c[N+12>>2]=c[Aa+28>>2];c[K+0>>2]=c[Aa+32>>2];c[K+4>>2]=c[Aa+36>>2];c[K+8>>2]=c[Aa+40>>2];c[K+12>>2]=c[Aa+44>>2];c[l+0>>2]=c[Aa+48>>2];c[l+4>>2]=c[Aa+52>>2];c[l+8>>2]=c[Aa+56>>2];c[l+12>>2]=c[Aa+60>>2];c[j+0>>2]=c[Aa+64>>2];c[j+4>>2]=c[Aa+68>>2];c[j+8>>2]=c[Aa+72>>2];c[j+12>>2]=c[Aa+76>>2];c[G+0>>2]=c[Aa+80>>2];c[G+4>>2]=c[Aa+84>>2];c[G+8>>2]=c[Aa+88>>2];c[G+12>>2]=c[Aa+92>>2];c[k+0>>2]=c[Aa+96>>2];c[k+4>>2]=c[Aa+100>>2];c[k+8>>2]=c[Aa+104>>2];c[k+12>>2]=c[Aa+108>>2];c[E+0>>2]=c[Aa+112>>2];c[E+4>>2]=c[Aa+116>>2];c[E+8>>2]=c[Aa+120>>2];c[E+12>>2]=c[Aa+124>>2];c[t+0>>2]=c[Aa+480>>2];c[t+4>>2]=c[Aa+484>>2];c[t+8>>2]=c[Aa+488>>2];c[t+12>>2]=c[Aa+492>>2];c[U+0>>2]=c[V+0>>2];c[U+4>>2]=c[V+4>>2];c[U+8>>2]=c[V+8>>2];c[U+12>>2]=c[V+12>>2];c[W+0>>2]=c[X+0>>2];c[W+4>>2]=c[X+4>>2];c[W+8>>2]=c[X+8>>2];c[W+12>>2]=c[X+12>>2];c[Y+0>>2]=c[Z+0>>2];c[Y+4>>2]=c[Z+4>>2];c[Y+8>>2]=c[Z+8>>2];c[Y+12>>2]=c[Z+12>>2];a[Aa+436>>0]=u<v&1;c[Aa+440>>2]=za;nD(Aa+600|0,Aa,Aa+208|0,za,0);B=c[b+28>>2]|0;I=I+1|0}while((I|0)<(B|0))}else{I=0;do{ra=+(I|0)*(6.2831854820251465/+(B|0))*.5;ia=+S(+ra)/F;ra=+R(+ra);za=c[d+12>>2]|0;c[Aa+0>>2]=c[za+0>>2];c[Aa+4>>2]=c[za+4>>2];c[Aa+8>>2]=c[za+8>>2];c[Aa+12>>2]=c[za+12>>2];c[Aa+16>>2]=c[za+16>>2];c[Aa+20>>2]=c[za+20>>2];c[Aa+24>>2]=c[za+24>>2];c[Aa+28>>2]=c[za+28>>2];c[Aa+32>>2]=c[za+32>>2];c[Aa+36>>2]=c[za+36>>2];c[Aa+40>>2]=c[za+40>>2];c[Aa+44>>2]=c[za+44>>2];c[Aa+48>>2]=c[za+48>>2];c[Aa+52>>2]=c[za+52>>2];c[Aa+56>>2]=c[za+56>>2];c[Aa+60>>2]=c[za+60>>2];da=D*-(T*s*ia)+(x*ra+H*-(J*s*ia))-A*-(q*s*ia);pa=x*-(q*s*ia)+(A*ra+H*-(T*s*ia))-D*-(J*s*ia);ea=A*-(J*s*ia)+(D*ra+H*-(q*s*ia))-x*-(T*s*ia);qa=H*ra-x*-(J*s*ia)-A*-(T*s*ia)-D*-(q*s*ia);ga=q*s*ia*pa+(J*s*ia*qa+ra*da)-T*s*ia*ea;ja=J*s*ia*ea+(ra*pa+T*s*ia*qa)-q*s*ia*da;oa=T*s*ia*da+(q*s*ia*qa+ra*ea)-J*s*ia*pa;ea=ra*qa-J*s*ia*da-T*s*ia*pa-q*s*ia*ea;ia=ga*(2.0/(ea*ea+(oa*oa+(ga*ga+ja*ja))));pa=ja*(2.0/(ea*ea+(oa*oa+(ga*ga+ja*ja))));da=oa*(2.0/(ea*ea+(oa*oa+(ga*ga+ja*ja))));za=c[e+12>>2]|0;qa=+g[za>>2];ra=+g[za+16>>2];ta=+g[za+32>>2];$=+g[za+4>>2];C=+g[za+20>>2];ba=+g[za+36>>2];ca=+g[za+8>>2];fa=+g[za+24>>2];xa=+g[za+40>>2];g[Aa+64>>2]=(ga*da+ea*pa)*ta+(ra*(ga*pa-ea*da)+qa*(1.0-(ja*pa+oa*da)));g[Aa+68>>2]=(1.0-(ja*pa+oa*da))*$+(ga*pa-ea*da)*C+(ga*da+ea*pa)*ba;g[Aa+72>>2]=(1.0-(ja*pa+oa*da))*ca+(ga*pa-ea*da)*fa+(ga*da+ea*pa)*xa;g[Aa+76>>2]=0.0;g[Aa+80>>2]=(ja*da-ea*ia)*ta+(qa*(ga*pa+ea*da)+ra*(1.0-(ga*ia+oa*da)));g[Aa+84>>2]=(ga*pa+ea*da)*$+(1.0-(ga*ia+oa*da))*C+(ja*da-ea*ia)*ba;g[Aa+88>>2]=(ga*pa+ea*da)*ca+(1.0-(ga*ia+oa*da))*fa+(ja*da-ea*ia)*xa;g[Aa+92>>2]=0.0;g[Aa+96>>2]=qa*(ga*da-ea*pa)+ra*(ja*da+ea*ia)+ta*(1.0-(ga*ia+ja*pa));g[Aa+100>>2]=(ga*da-ea*pa)*$+(ja*da+ea*ia)*C+(1.0-(ga*ia+ja*pa))*ba;g[Aa+104>>2]=(ga*da-ea*pa)*ca+(ja*da+ea*ia)*fa+(1.0-(ga*ia+ja*pa))*xa;g[Aa+108>>2]=0.0;za=c[f+20>>2]|0;c[Aa+208>>2]=10848;c[Aa+240>>2]=h;c[Q+0>>2]=c[Aa+0>>2];c[Q+4>>2]=c[Aa+4>>2];c[Q+8>>2]=c[Aa+8>>2];c[Q+12>>2]=c[Aa+12>>2];c[N+0>>2]=c[Aa+16>>2];c[N+4>>2]=c[Aa+20>>2];c[N+8>>2]=c[Aa+24>>2];c[N+12>>2]=c[Aa+28>>2];c[K+0>>2]=c[Aa+32>>2];c[K+4>>2]=c[Aa+36>>2];c[K+8>>2]=c[Aa+40>>2];c[K+12>>2]=c[Aa+44>>2];c[l+0>>2]=c[Aa+48>>2];c[l+4>>2]=c[Aa+52>>2];c[l+8>>2]=c[Aa+56>>2];c[l+12>>2]=c[Aa+60>>2];c[j+0>>2]=c[Aa+64>>2];c[j+4>>2]=c[Aa+68>>2];c[j+8>>2]=c[Aa+72>>2];c[j+12>>2]=c[Aa+76>>2];c[G+0>>2]=c[Aa+80>>2];c[G+4>>2]=c[Aa+84>>2];c[G+8>>2]=c[Aa+88>>2];c[G+12>>2]=c[Aa+92>>2];c[k+0>>2]=c[Aa+96>>2];c[k+4>>2]=c[Aa+100>>2];c[k+8>>2]=c[Aa+104>>2];c[k+12>>2]=c[Aa+108>>2];c[E+0>>2]=c[Aa+112>>2];c[E+4>>2]=c[Aa+116>>2];c[E+8>>2]=c[Aa+120>>2];c[E+12>>2]=c[Aa+124>>2];c[t+0>>2]=c[Aa+480>>2];c[t+4>>2]=c[Aa+484>>2];c[t+8>>2]=c[Aa+488>>2];c[t+12>>2]=c[Aa+492>>2];c[U+0>>2]=c[V+0>>2];c[U+4>>2]=c[V+4>>2];c[U+8>>2]=c[V+8>>2];c[U+12>>2]=c[V+12>>2];c[W+0>>2]=c[X+0>>2];c[W+4>>2]=c[X+4>>2];c[W+8>>2]=c[X+8>>2];c[W+12>>2]=c[X+12>>2];c[Y+0>>2]=c[Z+0>>2];c[Y+4>>2]=c[Z+4>>2];c[Y+8>>2]=c[Z+8>>2];c[Y+12>>2]=c[Z+12>>2];a[Aa+436>>0]=u<v&1;c[Aa+440>>2]=za;nD(Aa+600|0,Aa,Aa+208|0,za,0);B=c[b+28>>2]|0;I=I+1|0}while((I|0)<(B|0))}}}if(!(a[b+16>>0]|0)){i=Aa;return}k=c[h+4>>2]|0;if(!(c[k+748>>2]|0)){i=Aa;return}l=c[k+740>>2]|0;m=c[(c[h+8>>2]|0)+8>>2]|0;j=c[(c[h+12>>2]|0)+8>>2]|0;if((l|0)==(m|0)){Os(k,l+4|0,j+4|0);i=Aa;return}else{Os(k,j+4|0,m+4|0);i=Aa;return}}function gw(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0;b=i;i=i+624|0;p=+g[d+116>>2]-+g[d+52>>2];o=+g[d+120>>2]-+g[d+56>>2];n=+g[d+124>>2]-+g[d+60>>2];k=+g[e+116>>2]-+g[e+52>>2];j=+g[e+120>>2]-+g[e+56>>2];l=+g[e+124>>2]-+g[e+60>>2];m=+g[d+252>>2];if(p*p+o*o+n*n<m*m?(o=+g[e+252>>2],k*k+j*j+l*l<o*o):0){o=1.0;i=b;return +o}h=c[d+192>>2]|0;o=+g[e+248>>2];c[b+576>>2]=0;g[b+580>>2]=1.0;g[b+584>>2]=1.0;g[b+588>>2]=1.0;g[b+592>>2]=0.0;c[b+568>>2]=12104;c[b+572>>2]=8;g[b+596>>2]=o;g[b+612>>2]=o;c[b+392>>2]=7608;g[b+556>>2]=999999984306749440.0;c[b+560>>2]=0;g[b+564>>2]=0.0;g[b+340>>2]=9.999999747378752e-05;a[b+364>>0]=0;c[b+16>>2]=19224;c[b+20>>2]=b+32;c[b+24>>2]=h;c[b+28>>2]=b+568;if(bD(b+16|0,d+4|0,d+68|0,e+4|0,e+68|0,b+392|0)|0){j=+g[b+556>>2];if(+g[d+244>>2]>j)g[d+244>>2]=j;if(+g[e+244>>2]>j)g[e+244>>2]=j;if(!(j<1.0))j=1.0}else j=1.0;h=c[e+192>>2]|0;o=+g[d+248>>2];c[b+576>>2]=0;g[b+580>>2]=1.0;g[b+584>>2]=1.0;g[b+588>>2]=1.0;g[b+592>>2]=0.0;c[b+568>>2]=12104;c[b+572>>2]=8;g[b+596>>2]=o;g[b+612>>2]=o;c[b+392>>2]=7608;g[b+556>>2]=999999984306749440.0;c[b+560>>2]=0;g[b+564>>2]=0.0;g[b+340>>2]=9.999999747378752e-05;a[b+364>>0]=0;c[b>>2]=19224;c[b+4>>2]=b+32;c[b+8>>2]=b+568;c[b+12>>2]=h;if(!(bD(b,d+4|0,d+68|0,e+4|0,e+68|0,b+392|0)|0)){o=j;i=b;return +o}k=+g[b+556>>2];if(+g[d+244>>2]>k)g[d+244>>2]=k;if(+g[e+244>>2]>k)g[e+244>>2]=k;if(!(j>k)){o=j;i=b;return +o}o=k;i=b;return +o}function hw(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;if(!(c[b+20>>2]|0))return;if(!(a[b+16>>0]|0))return;f=c[d+4>>2]|0;if((f|0)==(c[d+8>>2]|0)?(i=(f|0)==0?1:f<<1,(f|0)<(i|0)):0){if(!i)h=0;else{c[5132]=(c[5132]|0)+1;e=ZE((i<<2|3)+16|0)|0;if(!e)f=0;else{c[(e+19&-16)+-4>>2]=e;f=e+19&-16}h=f;f=c[d+4>>2]|0}if((f|0)>0){g=0;do{e=h+(g<<2)|0;if(e)c[e>>2]=c[(c[d+12>>2]|0)+(g<<2)>>2];g=g+1|0}while((g|0)!=(f|0))}e=c[d+12>>2]|0;if(e){if(a[d+16>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[e+-4>>2]|0);f=c[d+4>>2]|0}c[d+12>>2]=0}a[d+16>>0]=1;c[d+12>>2]=h;c[d+8>>2]=i}e=(c[d+12>>2]|0)+(f<<2)|0;if(e)c[e>>2]=c[b+20>>2];c[d+4>>2]=f+1;return}function iw(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0;e=c[d>>2]|0;e=ec[c[(c[e>>2]|0)+56>>2]&31](e,36)|0;if(!e){b=0;return b|0}g=c[d+4>>2]|0;i=c[b+12>>2]|0;h=c[b+8>>2]|0;f=c[b+16>>2]|0;b=c[b+20>>2]|0;c[e+4>>2]=c[d>>2];c[e>>2]=10520;c[e+8>>2]=i;c[e+12>>2]=h;a[e+16>>0]=0;c[e+20>>2]=g;a[e+24>>0]=0;c[e+28>>2]=f;c[e+32>>2]=b;b=e;return b|0}function jw(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;var h=0,j=0.0,k=0.0,l=0.0;h=i;i=i+16|0;g[b+32>>2]=f;c[b+8>>2]=c[d+0>>2];c[b+12>>2]=c[d+4>>2];c[b+16>>2]=c[d+8>>2];c[b+20>>2]=c[d+12>>2];j=+g[b+28>>2];l=+g[e+4>>2]-j*+g[d+4>>2];k=+g[e+8>>2]-j*+g[d+8>>2];g[h>>2]=+g[e>>2]-+g[d>>2]*j;g[h+4>>2]=l;g[h+8>>2]=k;g[h+12>>2]=0.0;f=+g[b+24>>2]+j+f;g[b+32>>2]=f;if(!(f<0.0)){b=b+4|0;b=c[b>>2]|0;e=c[b>>2]|0;e=e+16|0;e=c[e>>2]|0;oc[e&15](b,d,h,f);i=h;return}a[b+36>>0]=1;b=b+4|0;b=c[b>>2]|0;e=c[b>>2]|0;e=e+16|0;e=c[e>>2]|0;oc[e&15](b,d,h,f);i=h;return}function kw(a,b,c){a=a|0;b=b|0;c=c|0;return}function lw(a,b,c){a=a|0;b=b|0;c=c|0;return}function mw(a){a=a|0;_E(a);return}function nw(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;var h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0;o=i;i=i+16|0;l=+g[d>>2];m=+g[d+4>>2];n=+g[d+8>>2];j=+g[e>>2];k=+g[e+4>>2];h=+g[e+8>>2];if(!(a[b+228>>0]|0)){z=+g[b+100>>2];w=+g[b+116>>2];C=+g[b+132>>2];y=+g[b+104>>2];u=+g[b+120>>2];B=+g[b+136>>2];x=+g[b+108>>2];s=+g[b+124>>2];A=+g[b+140>>2];F=-+g[b+148>>2];E=-+g[b+152>>2];D=-+g[b+156>>2];I=+g[b+164>>2];r=+g[b+168>>2];J=+g[b+172>>2];H=+g[b+180>>2];G=+g[b+184>>2];q=+g[b+188>>2];v=+g[b+196>>2];t=+g[b+200>>2];p=+g[b+204>>2];r=h*(C*I+B*r+A*J)+(j*(z*I+y*r+x*J)+k*(w*I+u*r+s*J))+((x*F+s*E+A*D)*J+(I*(z*F+w*E+C*D)+r*(y*F+u*E+B*D))+ +g[b+212>>2]);q=h*(C*H+B*G+A*q)+(j*(z*H+y*G+x*q)+k*(w*H+u*G+s*q))+((z*F+w*E+C*D)*H+(y*F+u*E+B*D)*G+(x*F+s*E+A*D)*q+ +g[b+216>>2]);p=(z*F+w*E+C*D)*v+(y*F+u*E+B*D)*t+(x*F+s*E+A*D)*p+ +g[b+220>>2]+(h*(C*v+B*t+A*p)+(j*(z*v+y*t+x*p)+k*(w*v+u*t+s*p)));g[o>>2]=r;g[o+4>>2]=q;g[o+8>>2]=p;g[o+12>>2]=0.0;f=(l*f+j-r)*+g[d>>2]+(m*f+k-q)*+g[d+4>>2]+(n*f+h-p)*+g[d+8>>2];b=b+32|0;b=c[b>>2]|0;e=c[b>>2]|0;e=e+16|0;e=c[e>>2]|0;oc[e&15](b,d,o,f);i=o;return}else{w=+g[b+36>>2];z=+g[b+52>>2];t=+g[b+68>>2];x=+g[b+40>>2];C=+g[b+56>>2];u=+g[b+72>>2];y=+g[b+44>>2];G=+g[b+60>>2];v=+g[b+76>>2];E=-+g[b+84>>2];s=-+g[b+88>>2];q=-+g[b+92>>2];p=+g[b+164>>2];H=+g[b+168>>2];B=+g[b+172>>2];D=+g[b+180>>2];r=+g[b+184>>2];I=+g[b+188>>2];A=+g[b+196>>2];F=+g[b+200>>2];J=+g[b+204>>2];H=(n*f+h)*(t*p+u*H+v*B)+((l*f+j)*(w*p+x*H+y*B)+(m*f+k)*(z*p+C*H+G*B))+((y*E+G*s+v*q)*B+(p*(w*E+z*s+t*q)+H*(x*E+C*s+u*q))+ +g[b+212>>2]);I=(n*f+h)*(t*D+u*r+v*I)+((l*f+j)*(w*D+x*r+y*I)+(m*f+k)*(z*D+C*r+G*I))+((w*E+z*s+t*q)*D+(x*E+C*s+u*q)*r+(y*E+G*s+v*q)*I+ +g[b+216>>2]);J=(w*E+z*s+t*q)*A+(x*E+C*s+u*q)*F+(y*E+G*s+v*q)*J+ +g[b+220>>2]+((n*f+h)*(t*A+u*F+v*J)+((l*f+j)*(w*A+x*F+y*J)+(m*f+k)*(z*A+C*F+G*J)));g[o>>2]=H+l*(l*(H-j)+m*(I-k)+n*(J-h));g[o+4>>2]=I+m*(l*(H-j)+m*(I-k)+n*(J-h));g[o+8>>2]=J+n*(l*(H-j)+m*(I-k)+n*(J-h));g[o+12>>2]=0.0;J=l*(H-j)+m*(I-k)+n*(J-h);b=b+32|0;b=c[b>>2]|0;e=c[b>>2]|0;e=e+16|0;e=c[e>>2]|0;oc[e&15](b,d,o,J);i=o;return}}function ow(a){a=a|0;_E(a);return}function pw(a,b,c,d){a=a|0;b=b|0;c=c|0;d=+d;return}function qw(a,b,c){a=a|0;b=b|0;c=c|0;return}function rw(a,b,c){a=a|0;b=b|0;c=c|0;return}function sw(a){a=a|0;_E(a);return}function tw(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;while(1){j=c[a+12>>2]|0;k=c[j+(((b+d|0)/2|0)<<3)>>2]|0;e=b;f=d;while(1){i=e;while(1){e=i+1|0;if((c[j+(i<<3)>>2]|0)<(k|0))i=e;else break}while(1){g=j+(f<<3)|0;h=f+-1|0;if((k|0)<(c[g>>2]|0))f=h;else break}if((i|0)>(f|0))e=i;else{l=j+(i<<3)|0;i=c[l>>2]|0;j=c[l+4>>2]|0;m=c[g+4>>2]|0;c[l>>2]=c[g>>2];c[l+4>>2]=m;f=(c[a+12>>2]|0)+(f<<3)|0;c[f>>2]=i;c[f+4>>2]=j;f=h}if((e|0)>(f|0))break;j=c[a+12>>2]|0}if((f|0)>(b|0))tw(a,b,f);if((e|0)<(d|0))b=e;else break}return}function uw(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;c[b+4>>2]=d;c[b>>2]=11112;a[b+24>>0]=1;c[b+20>>2]=0;c[b+12>>2]=0;c[b+16>>2]=0;a[b+28>>0]=h&1;c[b+32>>2]=e;a[b+36>>0]=0;c[b+40>>2]=c[(c[(h?g:f)+4>>2]|0)+68>>2];vw(b,f,g);return}function vw(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;n=i;i=i+32|0;j=(a[b+28>>0]|0)!=0;m=j?e:d;j=j?d:e;k=c[m+4>>2]|0;l=c[k+16>>2]|0;h=c[b+12>>2]|0;if((h|0)<(l|0)){if((c[b+16>>2]|0)<(l|0)){if(!l){e=0;f=h}else{c[5132]=(c[5132]|0)+1;e=ZE((l<<2|3)+16|0)|0;if(!e)e=0;else{c[(e+19&-16)+-4>>2]=e;e=e+19&-16}f=c[b+12>>2]|0}if((f|0)>0){g=0;do{d=e+(g<<2)|0;if(d)c[d>>2]=c[(c[b+20>>2]|0)+(g<<2)>>2];g=g+1|0}while((g|0)!=(f|0))}d=c[b+20>>2]|0;if(d){if(a[b+24>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+20>>2]=0}a[b+24>>0]=1;c[b+20>>2]=e;c[b+16>>2]=l;f=b+20|0}else f=b+20|0;d=h;do{e=(c[f>>2]|0)+(d<<2)|0;if(e)c[e>>2]=0;d=d+1|0}while((d|0)!=(l|0))}c[b+12>>2]=l;if((l|0)<=0){i=n;return}e=0;do{if(!(c[k+64>>2]|0)){f=c[(c[k+24>>2]|0)+(e*80|0)+64>>2]|0;g=c[m+8>>2]|0;h=c[m+12>>2]|0;c[n>>2]=m;c[n+4>>2]=f;c[n+8>>2]=g;c[n+12>>2]=h;c[n+16>>2]=-1;c[n+20>>2]=e;h=c[b+4>>2]|0;h=Rb[c[(c[h>>2]|0)+8>>2]&31](h,n,j,c[b+32>>2]|0)|0;c[(c[b+20>>2]|0)+(e<<2)>>2]=h}else c[(c[b+20>>2]|0)+(e<<2)>>2]=0;e=e+1|0}while((e|0)!=(l|0));i=n;return}function ww(b){b=b|0;var d=0,e=0,f=0;c[b>>2]=11112;d=c[b+12>>2]|0;if((d|0)>0){f=0;do{e=c[(c[b+20>>2]|0)+(f<<2)>>2]|0;if(e){Jb[c[c[e>>2]>>2]&255](e);e=c[b+4>>2]|0;Lb[c[(c[e>>2]|0)+60>>2]&127](e,c[(c[b+20>>2]|0)+(f<<2)>>2]|0)}f=f+1|0}while((f|0)!=(d|0))}d=c[b+20>>2]|0;if(!d){a[b+24>>0]=1;c[b+20>>2]=0;c[b+12>>2]=0;b=b+16|0;c[b>>2]=0;return}if(a[b+24>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+20>>2]=0;a[b+24>>0]=1;c[b+20>>2]=0;c[b+12>>2]=0;b=b+16|0;c[b>>2]=0;return}function xw(a){a=a|0;ww(a);_E(a);return}function yw(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0;v=i;i=i+320|0;t=(a[b+28>>0]|0)!=0;s=t?e:d;t=t?d:e;u=c[s+4>>2]|0;if((c[u+68>>2]|0)!=(c[b+40>>2]|0)){k=c[b+12>>2]|0;if((k|0)>0){l=0;do{j=c[(c[b+20>>2]|0)+(l<<2)>>2]|0;if(j){Jb[c[c[j>>2]>>2]&255](j);p=c[b+4>>2]|0;Lb[c[(c[p>>2]|0)+60>>2]&127](p,c[(c[b+20>>2]|0)+(l<<2)>>2]|0)}l=l+1|0}while((l|0)!=(k|0))}vw(b,d,e)}p=c[u+64>>2]|0;n=c[b+4>>2]|0;l=c[b+20>>2]|0;m=c[b+32>>2]|0;c[v+248>>2]=11192;c[v+252>>2]=s;c[v+256>>2]=t;c[v+260>>2]=n;c[v+264>>2]=f;c[v+268>>2]=h;c[v+272>>2]=l;c[v+276>>2]=m;m=v+128|0;a[m>>0]=1;n=v+124|0;c[n>>2]=0;o=v+116|0;c[o>>2]=0;c[v+120>>2]=0;k=c[b+12>>2]|0;if((k|0)>0){e=l;d=0;while(1){l=c[e+(d<<2)>>2]|0;if(l){Lb[c[(c[l>>2]|0)+16>>2]&127](l,v+112|0);k=c[o>>2]|0;if((k|0)>0){j=0;do{e=c[(c[n>>2]|0)+(j<<2)>>2]|0;if(c[e+748>>2]|0){c[h+4>>2]=e;f=c[e+740>>2]|0;l=c[(c[h+8>>2]|0)+8>>2]|0;if((f|0)==(l|0))Os(e,f+4|0,(c[(c[h+12>>2]|0)+8>>2]|0)+4|0);else Os(e,(c[(c[h+12>>2]|0)+8>>2]|0)+4|0,l+4|0);c[h+4>>2]=0;k=c[o>>2]|0}j=j+1|0}while((j|0)<(k|0));if((k|0)<=0){q=k;r=19}}else{q=k;r=19}if((r|0)==19?(r=0,(q|0)<0):0){if((c[v+120>>2]|0)<0){k=c[n>>2]|0;if(k){if(a[m>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[k+-4>>2]|0)}c[n>>2]=0}a[m>>0]=1;c[n>>2]=0;c[v+120>>2]=0;e=q}else e=q;do{l=(c[n>>2]|0)+(e<<2)|0;if(l)c[l>>2]=0;e=e+1|0}while((e|0)!=0)}c[o>>2]=0;k=c[b+12>>2]|0}l=d+1|0;if((l|0)>=(k|0))break;e=c[b+20>>2]|0;d=l}k=c[n>>2]|0;if(k){if(a[m>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[k+-4>>2]|0)}c[n>>2]=0}}a[m>>0]=1;c[n>>2]=0;c[o>>2]=0;c[v+120>>2]=0;if(!p){d=c[b+12>>2]|0;if((d|0)>0){j=0;do{Bw(v+248|0,c[(c[u+24>>2]|0)+(j*80|0)+64>>2]|0,j);j=j+1|0}while((j|0)<(d|0))}else{i=v;return}}else{r=c[s+12>>2]|0;K=+g[r>>2];J=+g[r+16>>2];I=+g[r+32>>2];H=+g[r+4>>2];G=+g[r+20>>2];F=+g[r+36>>2];B=+g[r+8>>2];z=+g[r+24>>2];x=+g[r+40>>2];E=-+g[r+48>>2];D=-+g[r+52>>2];C=-+g[r+56>>2];r=c[t+12>>2]|0;T=+g[r>>2];S=+g[r+16>>2];R=+g[r+32>>2];Q=+g[r+4>>2];P=+g[r+20>>2];O=+g[r+36>>2];N=+g[r+8>>2];M=+g[r+24>>2];L=+g[r+40>>2];A=+g[r+48>>2];y=+g[r+52>>2];w=+g[r+56>>2];g[v+184>>2]=K*T+J*S+I*R;g[v+188>>2]=K*Q+J*P+I*O;g[v+192>>2]=K*N+J*M+I*L;g[v+196>>2]=0.0;g[v+200>>2]=H*T+G*S+F*R;g[v+204>>2]=H*Q+G*P+F*O;g[v+208>>2]=H*N+G*M+F*L;g[v+212>>2]=0.0;g[v+216>>2]=B*T+z*S+x*R;g[v+220>>2]=B*Q+z*P+x*O;g[v+224>>2]=B*N+z*M+x*L;g[v+228>>2]=0.0;g[v+232>>2]=K*E+J*D+I*C+(K*A+J*y+I*w);g[v+236>>2]=H*E+G*D+F*C+(H*A+G*y+F*w);g[v+240>>2]=B*E+z*D+x*C+(B*A+z*y+x*w);g[v+244>>2]=0.0;r=c[t+4>>2]|0;tc[c[(c[r>>2]|0)+8>>2]&127](r,v+184|0,v,v+168|0);c[v+280>>2]=c[v+0>>2];c[v+284>>2]=c[v+4>>2];c[v+288>>2]=c[v+8>>2];c[v+292>>2]=c[v+12>>2];c[v+296>>2]=c[v+168>>2];c[v+300>>2]=c[v+172>>2];c[v+304>>2]=c[v+176>>2];c[v+308>>2]=c[v+180>>2];Aw(c[p>>2]|0,v+280|0,v+248|0)}d=c[b+12>>2]|0;if((d|0)<=0){i=v;return}k=0;do{do if(c[(c[b+20>>2]|0)+(k<<2)>>2]|0){q=c[u+24>>2]|0;r=c[q+(k*80|0)+64>>2]|0;h=c[s+12>>2]|0;z=+g[h>>2];A=+g[h+4>>2];B=+g[h+8>>2];C=+g[h+16>>2];D=+g[h+20>>2];E=+g[h+24>>2];L=+g[h+32>>2];N=+g[h+36>>2];P=+g[h+40>>2];F=+g[q+(k*80|0)>>2];G=+g[q+(k*80|0)+16>>2];H=+g[q+(k*80|0)+32>>2];I=+g[q+(k*80|0)+4>>2];J=+g[q+(k*80|0)+20>>2];K=+g[q+(k*80|0)+36>>2];M=+g[q+(k*80|0)+8>>2];O=+g[q+(k*80|0)+24>>2];Q=+g[q+(k*80|0)+40>>2];x=+g[q+(k*80|0)+48>>2];y=+g[q+(k*80|0)+52>>2];T=+g[q+(k*80|0)+56>>2];R=+g[h+48>>2]+(z*x+A*y+B*T);S=+g[h+52>>2]+(C*x+D*y+E*T);T=+g[h+56>>2]+(L*x+N*y+P*T);g[v+48>>2]=z*F+A*G+B*H;g[v+52>>2]=z*I+A*J+B*K;g[v+56>>2]=z*M+A*O+B*Q;g[v+60>>2]=0.0;g[v+64>>2]=C*F+D*G+E*H;g[v+68>>2]=C*I+D*J+E*K;g[v+72>>2]=C*M+D*O+E*Q;g[v+76>>2]=0.0;g[v+80>>2]=L*F+N*G+P*H;g[v+84>>2]=L*I+N*J+P*K;g[v+88>>2]=L*M+N*O+P*Q;g[v+92>>2]=0.0;g[v+96>>2]=R;g[v+100>>2]=S;g[v+104>>2]=T;g[v+108>>2]=0.0;tc[c[(c[r>>2]|0)+8>>2]&127](r,v+48|0,v+152|0,v+136|0);r=c[t+4>>2]|0;tc[c[(c[r>>2]|0)+8>>2]&127](r,c[t+12>>2]|0,v+32|0,v+16|0);if(!(+g[v+152>>2]>+g[v+16>>2])?!(+g[v+136>>2]<+g[v+32>>2]):0)j=1;else j=0;if(!(!(+g[v+160>>2]>+g[v+24>>2])?!(+g[v+144>>2]<+g[v+40>>2]):0))j=0;if(!(+g[v+156>>2]>+g[v+20>>2])?!(+g[v+140>>2]<+g[v+36>>2]|j^1):0)break;r=c[(c[b+20>>2]|0)+(k<<2)>>2]|0;Jb[c[c[r>>2]>>2]&255](r);r=c[b+4>>2]|0;Lb[c[(c[r>>2]|0)+60>>2]&127](r,c[(c[b+20>>2]|0)+(k<<2)>>2]|0);c[(c[b+20>>2]|0)+(k<<2)>>2]=0}while(0);k=k+1|0}while((k|0)<(d|0));i=v;return}function zw(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0,A=0,B=0,C=0,D=0.0,E=0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0;z=(a[b+28>>0]|0)!=0;C=z?e:d;z=z?d:e;A=c[b+12>>2]|0;if((A|0)<=0){y=1.0;return +y}d=(c[C+192>>2]|0)+24|0;j=+g[C+4>>2];v=+g[C+8>>2];w=+g[C+12>>2];x=+g[C+16>>2];y=+g[C+20>>2];k=+g[C+24>>2];l=+g[C+28>>2];m=+g[C+32>>2];n=+g[C+36>>2];o=+g[C+40>>2];p=+g[C+44>>2];q=+g[C+48>>2];r=+g[C+52>>2];s=+g[C+56>>2];t=+g[C+60>>2];u=+g[C+64>>2];e=c[C+260>>2]|0;i=1.0;B=0;do{E=c[d>>2]|0;P=+g[E+(B*80|0)>>2];O=+g[E+(B*80|0)+16>>2];N=+g[E+(B*80|0)+32>>2];M=+g[E+(B*80|0)+4>>2];L=+g[E+(B*80|0)+20>>2];K=+g[E+(B*80|0)+36>>2];J=+g[E+(B*80|0)+8>>2];I=+g[E+(B*80|0)+24>>2];H=+g[E+(B*80|0)+40>>2];G=+g[E+(B*80|0)+48>>2];F=+g[E+(B*80|0)+52>>2];D=+g[E+(B*80|0)+56>>2];c[C+260>>2]=e+1;g[C+4>>2]=j*P+v*O+w*N;g[C+8>>2]=j*M+v*L+w*K;g[C+12>>2]=j*J+v*I+w*H;g[C+16>>2]=0.0;g[C+20>>2]=y*P+k*O+l*N;g[C+24>>2]=y*M+k*L+l*K;g[C+28>>2]=y*J+k*I+l*H;g[C+32>>2]=0.0;g[C+36>>2]=n*P+o*O+p*N;g[C+40>>2]=n*M+o*L+p*K;g[C+44>>2]=n*J+o*I+p*H;g[C+48>>2]=0.0;g[C+52>>2]=r+(j*G+v*F+w*D);g[C+56>>2]=s+(y*G+k*F+l*D);g[C+60>>2]=t+(n*G+o*F+p*D);g[C+64>>2]=0.0;E=c[(c[b+20>>2]|0)+(B<<2)>>2]|0;D=+Vb[c[(c[E>>2]|0)+12>>2]&15](E,C,z,f,h);i=D<i?D:i;e=(c[C+260>>2]|0)+1|0;c[C+260>>2]=e;g[C+4>>2]=j;g[C+8>>2]=v;g[C+12>>2]=w;g[C+16>>2]=x;g[C+20>>2]=y;g[C+24>>2]=k;g[C+28>>2]=l;g[C+32>>2]=m;g[C+36>>2]=n;g[C+40>>2]=o;g[C+44>>2]=p;g[C+48>>2]=q;g[C+52>>2]=r;g[C+56>>2]=s;g[C+60>>2]=t;g[C+64>>2]=u;B=B+1|0}while((B|0)!=(A|0));return +i}function Aw(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0,k=0,l=0,m=0.0,n=0,o=0.0,p=0.0,q=0.0,r=0,s=0.0,t=0.0,u=0;if(!a)return;o=+g[b>>2];p=+g[b+4>>2];q=+g[b+8>>2];s=+g[b+16>>2];t=+g[b+20>>2];m=+g[b+24>>2];c[5132]=(c[5132]|0)+1;e=ZE(275)|0;if(e){c[(e+19&-16)+-4>>2]=e;b=e+19&-16;if(e+19&-16)c[b>>2]=a}else b=0;l=1;a=64;while(1){e=l+-1|0;j=c[b+(e<<2)>>2]|0;do if(((((+g[j>>2]<=s?+g[j+16>>2]>=o:0)?+g[j+4>>2]<=t:0)?+g[j+20>>2]>=p:0)?+g[j+8>>2]<=m:0)?+g[j+24>>2]>=q:0){if(!(c[j+40>>2]|0)){Lb[c[(c[d>>2]|0)+12>>2]&127](d,j);break}k=c[j+36>>2]|0;if((e|0)==(a|0)?(n=(a|0)==0?1:a<<1,(l|0)<=(n|0)):0){if((n|0)!=0?(c[5132]=(c[5132]|0)+1,r=ZE((n<<2|3)+16|0)|0,(r|0)!=0):0){c[(r+19&-16)+-4>>2]=r;f=r+19&-16}else f=0;if((a|0)>0){i=0;do{h=f+(i<<2)|0;if(h)c[h>>2]=c[b+(i<<2)>>2];i=i+1|0}while((i|0)!=(a|0))}if(!b){h=f;a=n}else{c[5134]=(c[5134]|0)+1;_E(c[b+-4>>2]|0);h=f;a=n}}else h=b;e=h+(e<<2)|0;if(e)c[e>>2]=k;i=c[j+40>>2]|0;if((l|0)==(a|0)){f=(l|0)==0?1:l<<1;if((l|0)<(f|0)){if((f|0)!=0?(c[5132]=(c[5132]|0)+1,u=ZE((f<<2|3)+16|0)|0,(u|0)!=0):0){c[(u+19&-16)+-4>>2]=u;b=u+19&-16}else b=0;if((l|0)>0){e=0;do{a=b+(e<<2)|0;if(a)c[a>>2]=c[h+(e<<2)>>2];e=e+1|0}while((e|0)!=(l|0))}if(h){c[5134]=(c[5134]|0)+1;_E(c[h+-4>>2]|0)}}else{b=h;f=l}}else{b=h;f=a}a=b+(l<<2)|0;if(a)c[a>>2]=i;e=l+1|0;a=f}while(0);if((e|0)>0)l=e;else break}if(!b)return;c[5134]=(c[5134]|0)+1;_E(c[b+-4>>2]|0);return}function Bw(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0;h=i;i=i+160|0;e=c[a+4>>2]|0;f=c[e+12>>2]|0;D=+g[f>>2];C=+g[f+4>>2];B=+g[f+8>>2];A=+g[f+16>>2];z=+g[f+20>>2];y=+g[f+24>>2];r=+g[f+32>>2];p=+g[f+36>>2];n=+g[f+40>>2];e=c[(c[e+4>>2]|0)+24>>2]|0;x=+g[e+(d*80|0)>>2];w=+g[e+(d*80|0)+16>>2];v=+g[e+(d*80|0)+32>>2];u=+g[e+(d*80|0)+4>>2];t=+g[e+(d*80|0)+20>>2];s=+g[e+(d*80|0)+36>>2];q=+g[e+(d*80|0)+8>>2];o=+g[e+(d*80|0)+24>>2];m=+g[e+(d*80|0)+40>>2];F=+g[e+(d*80|0)+48>>2];E=+g[e+(d*80|0)+52>>2];j=+g[e+(d*80|0)+56>>2];l=+g[f+48>>2]+(D*F+C*E+B*j);k=+g[f+52>>2]+(A*F+z*E+y*j);j=+g[f+56>>2]+(r*F+p*E+n*j);g[h+88>>2]=D*x+C*w+B*v;g[h+92>>2]=D*u+C*t+B*s;g[h+96>>2]=D*q+C*o+B*m;g[h+100>>2]=0.0;g[h+104>>2]=A*x+z*w+y*v;g[h+108>>2]=A*u+z*t+y*s;g[h+112>>2]=A*q+z*o+y*m;g[h+116>>2]=0.0;g[h+120>>2]=r*x+p*w+n*v;g[h+124>>2]=r*u+p*t+n*s;g[h+128>>2]=r*q+p*o+n*m;g[h+132>>2]=0.0;g[h+136>>2]=l;g[h+140>>2]=k;g[h+144>>2]=j;g[h+148>>2]=0.0;tc[c[(c[b>>2]|0)+8>>2]&127](b,h+88|0,h+72|0,h+56|0);f=c[a+8>>2]|0;e=c[f+4>>2]|0;tc[c[(c[e>>2]|0)+8>>2]&127](e,c[f+12>>2]|0,h+40|0,h+24|0);if(!(+g[h+72>>2]>+g[h+24>>2])?!(+g[h+56>>2]<+g[h+40>>2]):0)e=1;else e=0;if(!(!(+g[h+80>>2]>+g[h+32>>2])?!(+g[h+64>>2]<+g[h+48>>2]):0))e=0;if(+g[h+76>>2]>+g[h+28>>2]){i=h;return}if(+g[h+60>>2]<+g[h+44>>2]|e^1){i=h;return}e=c[a+4>>2]|0;f=c[e+8>>2]|0;c[h>>2]=e;c[h+4>>2]=b;c[h+8>>2]=f;c[h+12>>2]=h+88;c[h+16>>2]=-1;c[h+20>>2]=d;if(!(c[(c[a+24>>2]|0)+(d<<2)>>2]|0)){e=c[a+12>>2]|0;e=Rb[c[(c[e>>2]|0)+8>>2]&31](e,h,c[a+8>>2]|0,c[a+28>>2]|0)|0;c[(c[a+24>>2]|0)+(d<<2)>>2]=e;e=c[a+4>>2]|0}b=c[a+20>>2]|0;f=c[b+8>>2]|0;if((c[f+8>>2]|0)==(c[e+8>>2]|0)){c[b+8>>2]=h;pc[c[(c[b>>2]|0)+8>>2]&127](b,-1,d)}else{f=c[b+12>>2]|0;c[b+12>>2]=h;pc[c[(c[b>>2]|0)+12>>2]&127](b,-1,d)}e=c[(c[a+24>>2]|0)+(d<<2)>>2]|0;Hb[c[(c[e>>2]|0)+8>>2]&31](e,h,c[a+8>>2]|0,c[a+16>>2]|0,c[a+20>>2]|0);e=c[a+20>>2]|0;if((c[(c[e+8>>2]|0)+8>>2]|0)==(c[(c[a+4>>2]|0)+8>>2]|0)){c[e+8>>2]=f;i=h;return}else{c[e+12>>2]=f;i=h;return}}function Cw(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=c[a+12>>2]|0;if((d|0)<=0)return;f=0;do{e=c[(c[a+20>>2]|0)+(f<<2)>>2]|0;if(e){Lb[c[(c[e>>2]|0)+16>>2]&127](e,b);d=c[a+12>>2]|0}f=f+1|0}while((f|0)<(d|0));return}function Dw(a,b){a=a|0;b=b|0;b=c[b+36>>2]|0;Bw(a,c[(c[(c[(c[a+4>>2]|0)+4>>2]|0)+24>>2]|0)+(b*80|0)+64>>2]|0,b);return}function Ew(a){a=a|0;_E(a);return}function Fw(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;c[b>>2]=11280;d=c[b+8>>2]|0;e=c[d+8>>2]|0;if((e|0)>0){g=0;do{f=c[(c[d+16>>2]|0)+(g*12|0)+8>>2]|0;if(f){Jb[c[c[f>>2]>>2]&255](f);h=c[b+4>>2]|0;Lb[c[(c[h>>2]|0)+60>>2]&127](h,f)}g=g+1|0}while((g|0)!=(e|0));d=c[b+8>>2]|0}RD(d);d=c[b+8>>2]|0;Jb[c[c[d>>2]>>2]&255](d);d=c[b+8>>2]|0;if(d){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}d=c[b+24>>2]|0;if(!d){a[b+28>>0]=1;c[b+24>>2]=0;c[b+16>>2]=0;h=b+20|0;c[h>>2]=0;return}if(a[b+28>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+24>>2]=0;a[b+28>>0]=1;c[b+24>>2]=0;c[b+16>>2]=0;h=b+20|0;c[h>>2]=0;return}function Gw(a){a=a|0;Fw(a);_E(a);return}function Hw(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;f=c[a+8>>2]|0;a=c[f+8>>2]|0;if((a|0)<=0)return;e=0;do{d=c[(c[f+16>>2]|0)+(e*12|0)+8>>2]|0;if(d){Lb[c[(c[d>>2]|0)+16>>2]&127](d,b);a=c[f+8>>2]|0}e=e+1|0}while((e|0)<(a|0));return}function Iw(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0.0,ga=0.0,ha=0.0,ia=0.0,ja=0.0,ka=0.0,la=0.0,ma=0.0,na=0.0,oa=0.0,pa=0.0;ea=i;i=i+192|0;ca=c[d+4>>2]|0;da=c[e+4>>2]|0;if((c[ca+68>>2]|0)==(c[b+40>>2]|0)?(c[da+68>>2]|0)==(c[b+44>>2]|0):0)aa=b+8|0;else{l=c[b+8>>2]|0;k=c[l+8>>2]|0;if((k|0)>0){m=0;do{j=c[(c[l+16>>2]|0)+(m*12|0)+8>>2]|0;if(j){Jb[c[c[j>>2]>>2]&255](j);r=c[b+4>>2]|0;Lb[c[(c[r>>2]|0)+60>>2]&127](r,j)}m=m+1|0}while((m|0)!=(k|0));l=c[b+8>>2]|0}RD(l);aa=b+8|0}n=ea+48|0;a[n>>0]=1;j=ea+44|0;c[j>>2]=0;r=ea+36|0;c[r>>2]=0;c[ea+40>>2]=0;p=c[aa>>2]|0;m=c[p+8>>2]|0;if((m|0)>0){q=0;do{l=c[(c[p+16>>2]|0)+(q*12|0)+8>>2]|0;if(l){Lb[c[(c[l>>2]|0)+16>>2]&127](l,ea+32|0);m=c[r>>2]|0;if((m|0)>0){o=0;do{k=c[(c[j>>2]|0)+(o<<2)>>2]|0;if(c[k+748>>2]|0){c[h+4>>2]=k;m=c[k+740>>2]|0;l=c[(c[h+8>>2]|0)+8>>2]|0;if((m|0)==(l|0))Os(k,m+4|0,(c[(c[h+12>>2]|0)+8>>2]|0)+4|0);else Os(k,(c[(c[h+12>>2]|0)+8>>2]|0)+4|0,l+4|0);c[h+4>>2]=0;m=c[r>>2]|0}o=o+1|0}while((o|0)<(m|0));if((m|0)<=0){s=m;t=22}}else{s=m;t=22}if((t|0)==22?(t=0,(s|0)<0):0){if((c[ea+40>>2]|0)<0){m=c[j>>2]|0;if(m){if(a[n>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[m+-4>>2]|0)}c[j>>2]=0}a[n>>0]=1;c[j>>2]=0;c[ea+40>>2]=0;l=s}else l=s;do{m=(c[j>>2]|0)+(l<<2)|0;if(m)c[m>>2]=0;l=l+1|0}while((l|0)!=0)}c[r>>2]=0;m=c[p+8>>2]|0}q=q+1|0}while((q|0)<(m|0));l=c[j>>2]|0;if(l){if(a[n>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[l+-4>>2]|0)}c[j>>2]=0}}a[n>>0]=1;c[j>>2]=0;c[r>>2]=0;c[ea+40>>2]=0;r=c[ca+64>>2]|0;q=c[da+64>>2]|0;p=c[b+4>>2]|0;s=c[aa>>2]|0;t=c[b+32>>2]|0;c[ea+120>>2]=11368;c[ea+124>>2]=0;c[ea+128>>2]=d;c[ea+132>>2]=e;c[ea+136>>2]=p;c[ea+140>>2]=f;c[ea+144>>2]=h;c[ea+148>>2]=s;c[ea+152>>2]=t;h=c[d+12>>2]|0;D=+g[h>>2];E=+g[h+16>>2];F=+g[h+32>>2];G=+g[h+4>>2];H=+g[h+20>>2];I=+g[h+36>>2];J=+g[h+8>>2];K=+g[h+24>>2];L=+g[h+40>>2];M=-+g[h+48>>2];N=-+g[h+52>>2];P=-+g[h+56>>2];h=c[e+12>>2]|0;Q=+g[h>>2];R=+g[h+16>>2];S=+g[h+32>>2];T=+g[h+4>>2];U=+g[h+20>>2];V=+g[h+36>>2];W=+g[h+8>>2];X=+g[h+24>>2];Y=+g[h+40>>2];Z=+g[h+48>>2];_=+g[h+52>>2];$=+g[h+56>>2];r=c[r>>2]|0;q=c[q>>2]|0;if((r|0)!=0&(q|0)!=0){c[5132]=(c[5132]|0)+1;s=ZE(1043)|0;c[(s+19&-16)+-4>>2]=s;c[(s+19&-16)>>2]=r;c[(s+19&-16)+4>>2]=q;u=+O(+(D*Q+E*R+F*S));v=+O(+(D*T+E*U+F*V));w=+O(+(D*W+E*X+F*Y));x=+O(+(G*Q+H*R+I*S));y=+O(+(G*T+H*U+I*V));z=+O(+(G*W+H*X+I*Y));A=+O(+(J*Q+K*R+L*S));B=+O(+(J*T+K*U+L*V));C=+O(+(J*W+K*X+L*Y));q=s+19&-16;s=128;f=128;l=1;t=124;while(1){r=l+-1|0;n=c[q+(r<<3)>>2]|0;m=c[q+(r<<3)+4>>2]|0;pa=+g[m+16>>2];oa=+g[m>>2];na=+g[m+20>>2];ma=+g[m+4>>2];la=+g[m+24>>2];fa=+g[m+8>>2];ka=D*M+E*N+F*P+(D*Z+E*_+F*$)+((D*Q+E*R+F*S)*((pa+oa)*.5)+(D*T+E*U+F*V)*((na+ma)*.5)+(D*W+E*X+F*Y)*((la+fa)*.5));ia=G*M+H*N+I*P+(G*Z+H*_+I*$)+((G*Q+H*R+I*S)*((pa+oa)*.5)+(G*T+H*U+I*V)*((na+ma)*.5)+(G*W+H*X+I*Y)*((la+fa)*.5));ga=J*M+K*N+L*P+(J*Z+K*_+L*$)+((J*Q+K*R+L*S)*((pa+oa)*.5)+(J*T+K*U+L*V)*((na+ma)*.5)+(J*W+K*X+L*Y)*((la+fa)*.5));ja=((pa-oa)*.5+0.0)*u+((na-ma)*.5+0.0)*v+((la-fa)*.5+0.0)*w;ha=((pa-oa)*.5+0.0)*x+((na-ma)*.5+0.0)*y+((la-fa)*.5+0.0)*z;fa=((pa-oa)*.5+0.0)*A+((na-ma)*.5+0.0)*B+((la-fa)*.5+0.0)*C;do if(((((+g[n>>2]<=ja+ka?+g[n+16>>2]>=ka-ja:0)?+g[n+4>>2]<=ia+ha:0)?+g[n+20>>2]>=ia-ha:0)?+g[n+8>>2]<=ga+fa:0)?+g[n+24>>2]>=ga-fa:0){if((r|0)>(t|0)){o=s<<1;if((s|0)<(o|0)&(f|0)<(o|0)){if(s){c[5132]=(c[5132]|0)+1;h=ZE((s<<4|3)+16|0)|0;if(!h)h=0;else{c[(h+19&-16)+-4>>2]=h;h=h+19&-16}if((s|0)>0){t=0;do{f=h+(t<<3)|0;if(f){k=q+(t<<3)|0;p=c[k+4>>2]|0;c[f>>2]=c[k>>2];c[f+4>>2]=p}t=t+1|0}while((t|0)!=(s|0))}}else h=0;if(!q)f=o;else{c[5134]=(c[5134]|0)+1;_E(c[q+-4>>2]|0);f=o}}else h=q;p=o;t=o+-4|0}else{h=q;p=s}q=(c[m+40>>2]|0)!=0;if(!(c[n+40>>2]|0))if(q){s=c[m+36>>2]|0;r=h+(r<<3)|0;c[r>>2]=n;c[r+4>>2]=s;r=c[m+40>>2]|0;s=h+(l<<3)|0;c[s>>2]=n;c[s+4>>2]=r;s=p;r=l+1|0;break}else{pc[c[(c[ea+120>>2]|0)+8>>2]&127](ea+120|0,n,m);s=p;break}else{s=h+(r<<3)|0;r=c[n+36>>2]|0;if(q){q=c[m+36>>2]|0;c[s>>2]=r;c[s+4>>2]=q;r=c[m+36>>2]|0;s=h+(l<<3)|0;c[s>>2]=c[n+40>>2];c[s+4>>2]=r;s=c[m+40>>2]|0;r=h+(l+1<<3)|0;c[r>>2]=c[n+36>>2];c[r+4>>2]=s;r=c[m+40>>2]|0;s=h+(l+2<<3)|0;c[s>>2]=c[n+40>>2];c[s+4>>2]=r;s=p;r=l+3|0;break}else{c[s>>2]=r;c[s+4>>2]=m;s=h+(l<<3)|0;c[s>>2]=c[n+40>>2];c[s+4>>2]=m;s=p;r=l+1|0;break}}}else h=q;while(0);if(!r)break;else{q=h;l=r}}if(h){c[5134]=(c[5134]|0)+1;_E(c[h+-4>>2]|0)}}p=c[aa>>2]|0;if((c[p+8>>2]|0)>0){q=0;do{l=c[p+16>>2]|0;k=c[l+(q*12|0)+8>>2]|0;do if(k){h=c[l+(q*12|0)>>2]|0;f=c[ca+24>>2]|0;t=c[f+(h*80|0)+64>>2]|0;s=c[d+12>>2]|0;ka=+g[s>>2];L=+g[s+4>>2];K=+g[s+8>>2];ha=+g[s+16>>2];fa=+g[s+20>>2];_=+g[s+24>>2];ga=+g[s+32>>2];Z=+g[s+36>>2];R=+g[s+40>>2];Y=+g[f+(h*80|0)>>2];X=+g[f+(h*80|0)+16>>2];W=+g[f+(h*80|0)+32>>2];V=+g[f+(h*80|0)+4>>2];U=+g[f+(h*80|0)+20>>2];T=+g[f+(h*80|0)+36>>2];$=+g[f+(h*80|0)+8>>2];S=+g[f+(h*80|0)+24>>2];Q=+g[f+(h*80|0)+40>>2];ja=+g[f+(h*80|0)+48>>2];ia=+g[f+(h*80|0)+52>>2];M=+g[f+(h*80|0)+56>>2];P=+g[s+48>>2]+(ka*ja+L*ia+K*M);N=+g[s+52>>2]+(ha*ja+fa*ia+_*M);M=+g[s+56>>2]+(ga*ja+Z*ia+R*M);g[ea+56>>2]=ka*Y+L*X+K*W;g[ea+60>>2]=ka*V+L*U+K*T;g[ea+64>>2]=ka*$+L*S+K*Q;g[ea+68>>2]=0.0;g[ea+72>>2]=ha*Y+fa*X+_*W;g[ea+76>>2]=ha*V+fa*U+_*T;g[ea+80>>2]=ha*$+fa*S+_*Q;g[ea+84>>2]=0.0;g[ea+88>>2]=ga*Y+Z*X+R*W;g[ea+92>>2]=ga*V+Z*U+R*T;g[ea+96>>2]=ga*$+Z*S+R*Q;g[ea+100>>2]=0.0;g[ea+104>>2]=P;g[ea+108>>2]=N;g[ea+112>>2]=M;g[ea+116>>2]=0.0;tc[c[(c[t>>2]|0)+8>>2]&127](t,ea+56|0,ea+160|0,ea+176|0);t=c[(c[p+16>>2]|0)+(q*12|0)+4>>2]|0;s=c[da+24>>2]|0;h=c[s+(t*80|0)+64>>2]|0;f=c[e+12>>2]|0;M=+g[f>>2];N=+g[f+4>>2];P=+g[f+8>>2];Q=+g[f+16>>2];R=+g[f+20>>2];S=+g[f+24>>2];Z=+g[f+32>>2];$=+g[f+36>>2];ga=+g[f+40>>2];T=+g[s+(t*80|0)>>2];U=+g[s+(t*80|0)+16>>2];V=+g[s+(t*80|0)+32>>2];W=+g[s+(t*80|0)+4>>2];X=+g[s+(t*80|0)+20>>2];Y=+g[s+(t*80|0)+36>>2];_=+g[s+(t*80|0)+8>>2];fa=+g[s+(t*80|0)+24>>2];ha=+g[s+(t*80|0)+40>>2];K=+g[s+(t*80|0)+48>>2];L=+g[s+(t*80|0)+52>>2];ka=+g[s+(t*80|0)+56>>2];ia=+g[f+48>>2]+(M*K+N*L+P*ka);ja=+g[f+52>>2]+(Q*K+R*L+S*ka);ka=+g[f+56>>2]+(Z*K+$*L+ga*ka);g[ea+56>>2]=M*T+N*U+P*V;g[ea+60>>2]=M*W+N*X+P*Y;g[ea+64>>2]=M*_+N*fa+P*ha;g[ea+68>>2]=0.0;g[ea+72>>2]=Q*T+R*U+S*V;g[ea+76>>2]=Q*W+R*X+S*Y;g[ea+80>>2]=Q*_+R*fa+S*ha;g[ea+84>>2]=0.0;g[ea+88>>2]=Z*T+$*U+ga*V;g[ea+92>>2]=Z*W+$*X+ga*Y;g[ea+96>>2]=Z*_+$*fa+ga*ha;g[ea+100>>2]=0.0;g[ea+104>>2]=ia;g[ea+108>>2]=ja;g[ea+112>>2]=ka;g[ea+116>>2]=0.0;tc[c[(c[h>>2]|0)+8>>2]&127](h,ea+56|0,ea+16|0,ea);if(!(+g[ea+160>>2]>+g[ea>>2])?!(+g[ea+176>>2]<+g[ea+16>>2]):0)l=1;else l=0;if(!(!(+g[ea+168>>2]>+g[ea+8>>2])?!(+g[ea+184>>2]<+g[ea+24>>2]):0))l=0;if(!(+g[ea+164>>2]>+g[ea+4>>2])?!(+g[ea+180>>2]<+g[ea+20>>2]|l^1):0)break;Jb[c[c[k>>2]>>2]&255](k);o=c[b+4>>2]|0;Lb[c[(c[o>>2]|0)+60>>2]&127](o,k);o=c[p+16>>2]|0;n=c[o+(q*12|0)>>2]|0;o=c[o+(q*12|0)+4>>2]|0;l=c[b+16>>2]|0;if((l|0)==(c[b+20>>2]|0)?(ba=(l|0)==0?1:l<<1,(l|0)<(ba|0)):0){if(!ba)j=0;else{c[5132]=(c[5132]|0)+1;l=ZE((ba*12|3)+16|0)|0;if(!l)l=0;else{c[(l+19&-16)+-4>>2]=l;l=l+19&-16}j=l;l=c[b+16>>2]|0}if((l|0)>0){k=0;do{m=j+(k*12|0)|0;if(m){h=(c[b+24>>2]|0)+(k*12|0)|0;c[m+0>>2]=c[h+0>>2];c[m+4>>2]=c[h+4>>2];c[m+8>>2]=c[h+8>>2]}k=k+1|0}while((k|0)!=(l|0))}l=c[b+24>>2]|0;if(l){if(a[b+28>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[l+-4>>2]|0)}c[b+24>>2]=0}a[b+28>>0]=1;c[b+24>>2]=j;c[b+20>>2]=ba;l=c[b+16>>2]|0}k=c[b+24>>2]|0;j=k+(l*12|0)|0;if(j){c[j>>2]=n;c[k+(l*12|0)+4>>2]=o;c[k+(l*12|0)+8>>2]=0;l=c[b+16>>2]|0}c[b+16>>2]=l+1}while(0);q=q+1|0}while((q|0)<(c[p+8>>2]|0));k=b+24|0;l=b+16|0}else{k=b+24|0;l=b+16|0}if((c[l>>2]|0)>0){j=0;do{f=c[aa>>2]|0;h=c[k>>2]|0;Wb[c[(c[f>>2]|0)+8>>2]&63](f,c[h+(j*12|0)>>2]|0,c[h+(j*12|0)+4>>2]|0)|0;j=j+1|0}while((j|0)<(c[l>>2]|0))}j=c[k>>2]|0;if(!j){a[b+28>>0]=1;c[k>>2]=0;c[l>>2]=0;h=b+20|0;c[h>>2]=0;i=ea;return}if(a[b+28>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[j+-4>>2]|0)}c[k>>2]=0;a[b+28>>0]=1;c[k>>2]=0;c[l>>2]=0;h=b+20|0;c[h>>2]=0;i=ea;return}function Jw(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return 0.0}function Kw(a,b){a=a|0;b=b|0;return}function Lw(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0,K=0;l=i;i=i+240|0;c[a+4>>2]=(c[a+4>>2]|0)+1;j=c[b+36>>2]|0;h=c[d+36>>2]|0;d=c[a+8>>2]|0;K=c[(c[d+4>>2]|0)+24>>2]|0;b=c[K+(j*80|0)+64>>2]|0;J=(c[(c[a+12>>2]|0)+4>>2]|0)+24|0;e=c[(c[J>>2]|0)+(h*80|0)+64>>2]|0;d=c[d+12>>2]|0;m=+g[d>>2];H=+g[d+4>>2];I=+g[d+8>>2];p=+g[d+16>>2];r=+g[d+20>>2];t=+g[d+24>>2];q=+g[d+32>>2];u=+g[d+36>>2];C=+g[d+40>>2];v=+g[K+(j*80|0)>>2];w=+g[K+(j*80|0)+16>>2];x=+g[K+(j*80|0)+32>>2];y=+g[K+(j*80|0)+4>>2];z=+g[K+(j*80|0)+20>>2];A=+g[K+(j*80|0)+36>>2];s=+g[K+(j*80|0)+8>>2];B=+g[K+(j*80|0)+24>>2];D=+g[K+(j*80|0)+40>>2];n=+g[K+(j*80|0)+48>>2];o=+g[K+(j*80|0)+52>>2];G=+g[K+(j*80|0)+56>>2];E=+g[d+48>>2]+(m*n+H*o+I*G);F=+g[d+52>>2]+(p*n+r*o+t*G);G=+g[d+56>>2]+(q*n+u*o+C*G);g[l+16>>2]=m*v+H*w+I*x;g[l+20>>2]=m*y+H*z+I*A;g[l+24>>2]=m*s+H*B+I*D;g[l+28>>2]=0.0;g[l+32>>2]=p*v+r*w+t*x;g[l+36>>2]=p*y+r*z+t*A;g[l+40>>2]=p*s+r*B+t*D;g[l+44>>2]=0.0;g[l+48>>2]=q*v+u*w+C*x;g[l+52>>2]=q*y+u*z+C*A;g[l+56>>2]=q*s+u*B+C*D;g[l+60>>2]=0.0;g[l+64>>2]=E;g[l+68>>2]=F;g[l+72>>2]=G;g[l+76>>2]=0.0;d=c[(c[a+12>>2]|0)+12>>2]|0;G=+g[d>>2];F=+g[d+4>>2];E=+g[d+8>>2];D=+g[d+16>>2];C=+g[d+20>>2];B=+g[d+24>>2];u=+g[d+32>>2];s=+g[d+36>>2];q=+g[d+40>>2];J=c[J>>2]|0;A=+g[J+(h*80|0)>>2];z=+g[J+(h*80|0)+16>>2];y=+g[J+(h*80|0)+32>>2];x=+g[J+(h*80|0)+4>>2];w=+g[J+(h*80|0)+20>>2];v=+g[J+(h*80|0)+36>>2];t=+g[J+(h*80|0)+8>>2];r=+g[J+(h*80|0)+24>>2];p=+g[J+(h*80|0)+40>>2];I=+g[J+(h*80|0)+48>>2];H=+g[J+(h*80|0)+52>>2];m=+g[J+(h*80|0)+56>>2];o=+g[d+48>>2]+(G*I+F*H+E*m);n=+g[d+52>>2]+(D*I+C*H+B*m);m=+g[d+56>>2]+(u*I+s*H+q*m);g[l+120>>2]=G*A+F*z+E*y;g[l+124>>2]=G*x+F*w+E*v;g[l+128>>2]=G*t+F*r+E*p;g[l+132>>2]=0.0;g[l+136>>2]=D*A+C*z+B*y;g[l+140>>2]=D*x+C*w+B*v;g[l+144>>2]=D*t+C*r+B*p;g[l+148>>2]=0.0;g[l+152>>2]=u*A+s*z+q*y;g[l+156>>2]=u*x+s*w+q*v;g[l+160>>2]=u*t+s*r+q*p;g[l+164>>2]=0.0;g[l+168>>2]=o;g[l+172>>2]=n;g[l+176>>2]=m;g[l+180>>2]=0.0;tc[c[(c[b>>2]|0)+8>>2]&127](b,l+16|0,l+80|0,l+184|0);tc[c[(c[e>>2]|0)+8>>2]&127](e,l+120|0,l+224|0,l);if(!(+g[l+80>>2]>+g[l>>2])?!(+g[l+184>>2]<+g[l+224>>2]):0)d=1;else d=0;if(!(!(+g[l+88>>2]>+g[l+8>>2])?!(+g[l+192>>2]<+g[l+232>>2]):0))d=0;if(+g[l+84>>2]>+g[l+4>>2]){i=l;return}if(+g[l+188>>2]<+g[l+228>>2]|d^1){i=l;return}J=c[a+8>>2]|0;d=c[J+8>>2]|0;c[l+96>>2]=J;c[l+100>>2]=b;c[l+104>>2]=d;c[l+108>>2]=l+16;c[l+112>>2]=-1;c[l+116>>2]=j;d=c[a+12>>2]|0;b=c[d+8>>2]|0;c[l+200>>2]=d;c[l+204>>2]=e;c[l+208>>2]=b;c[l+212>>2]=l+120;c[l+216>>2]=-1;c[l+220>>2]=h;b=c[a+28>>2]|0;c[5e3]=(c[5e3]|0)+1;d=((h<<16|j)+~((h<<16|j)<<15)>>10^(h<<16|j)+~((h<<16|j)<<15))*9|0;d=(c[b+12>>2]|0)+-1&((d>>6^d)+~((d>>6^d)<<11)>>16^(d>>6^d)+~((d>>6^d)<<11));a:do if((d|0)<(c[b+32>>2]|0)?(f=c[(c[b+40>>2]|0)+(d<<2)>>2]|0,(f|0)!=-1):0){e=c[b+16>>2]|0;d=f;while(1){if((c[e+(d*12|0)>>2]|0)==(j|0)?(c[e+(d*12|0)+4>>2]|0)==(h|0):0)break;d=c[(c[b+60>>2]|0)+(d<<2)>>2]|0;if((d|0)==-1){k=17;break a}}if(e+(d*12|0)|0)b=c[e+(d*12|0)+8>>2]|0;else k=17}else k=17;while(0);if((k|0)==17){b=c[a+16>>2]|0;b=Rb[c[(c[b>>2]|0)+8>>2]&31](b,l+96|0,l+200|0,c[a+32>>2]|0)|0;J=c[a+28>>2]|0;c[(Wb[c[(c[J>>2]|0)+12>>2]&63](J,j,h)|0)+8>>2]=b}J=c[a+24>>2]|0;f=c[J+8>>2]|0;k=c[J+12>>2]|0;c[J+8>>2]=l+96;c[J+12>>2]=l+200;pc[c[(c[J>>2]|0)+8>>2]&127](J,-1,j);J=c[a+24>>2]|0;pc[c[(c[J>>2]|0)+12>>2]&127](J,-1,h);Hb[c[(c[b>>2]|0)+8>>2]&31](b,l+96|0,l+200|0,c[a+20>>2]|0,c[a+24>>2]|0);J=c[a+24>>2]|0;c[J+8>>2]=f;c[J+12>>2]=k;i=l;return}function Mw(a){a=a|0;_E(a);return}function Nw(b,d){b=b|0;d=d|0;var e=0;c[b+8>>2]=0;c[b>>2]=11464;a[b+28>>0]=1;c[b+24>>2]=0;c[b+16>>2]=0;c[b+20>>2]=0;g[b+32>>2]=999999984306749440.0;g[b+36>>2]=999999984306749440.0;g[b+40>>2]=999999984306749440.0;g[b+44>>2]=0.0;g[b+48>>2]=-999999984306749440.0;g[b+52>>2]=-999999984306749440.0;g[b+56>>2]=-999999984306749440.0;g[b+60>>2]=0.0;c[b+64>>2]=0;c[b+68>>2]=1;g[b+72>>2]=0.0;g[b+76>>2]=1.0;g[b+80>>2]=1.0;g[b+84>>2]=1.0;g[b+88>>2]=0.0;c[b+4>>2]=31;if(!d)return;c[5132]=(c[5132]|0)+1;d=ZE(79)|0;if((d|0)!=0?(e=d+19&-16,c[e+-4>>2]=d,(d+19&-16|0)!=0):0){a[e+36>>0]=1;c[e+32>>2]=0;c[e+24>>2]=0;c[e+28>>2]=0;a[e+56>>0]=1;c[e+52>>2]=0;c[e+44>>2]=0;c[e+48>>2]=0;c[(d+19&-16)>>2]=0;c[e+4>>2]=0;c[e+8>>2]=-1;c[e+12>>2]=0;c[e+16>>2]=0;d=d+19&-16}else d=0;c[b+64>>2]=d;return}function Ow(b){b=b|0;var d=0,e=0;c[b>>2]=11464;d=c[b+64>>2]|0;if((d|0)!=0?(JC(d),e=c[b+64>>2]|0,(e|0)!=0):0){c[5134]=(c[5134]|0)+1;_E(c[e+-4>>2]|0)}d=c[b+24>>2]|0;if(!d){a[b+28>>0]=1;c[b+24>>2]=0;c[b+16>>2]=0;b=b+20|0;c[b>>2]=0;return}if(a[b+28>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+24>>2]=0;a[b+28>>0]=1;c[b+24>>2]=0;c[b+16>>2]=0;b=b+20|0;c[b>>2]=0;return}function Pw(a){a=a|0;Ow(a);if(!a)return;c[5134]=(c[5134]|0)+1;_E(c[a+-4>>2]|0);return}function Qw(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;h=i;i=i+80|0;c[a+68>>2]=(c[a+68>>2]|0)+1;d=c[a+16>>2]|0;if((d|0)<=0){b=c[a>>2]|0;b=b+68|0;b=c[b>>2]|0;Jb[b&255](a);i=h;return}e=d;g=d;while(1){g=g+-1|0;d=c[a+24>>2]|0;if((c[d+(g*80|0)+64>>2]|0)==(b|0)){c[a+68>>2]=(c[a+68>>2]|0)+1;f=c[a+64>>2]|0;if(f){d=c[d+(g*80|0)+76>>2]|0;MC(f,d)|0;e=c[f+4>>2]|0;if(e){c[5134]=(c[5134]|0)+1;_E(c[e+-4>>2]|0)}c[f+4>>2]=d;c[f+12>>2]=(c[f+12>>2]|0)+-1;e=c[a+16>>2]|0;d=c[a+24>>2]|0}f=e+-1|0;m=d+(g*80|0)|0;c[h+0>>2]=c[m+0>>2];c[h+4>>2]=c[m+4>>2];c[h+8>>2]=c[m+8>>2];c[h+12>>2]=c[m+12>>2];l=d+(g*80|0)+16|0;c[h+16>>2]=c[l+0>>2];c[h+20>>2]=c[l+4>>2];c[h+24>>2]=c[l+8>>2];c[h+28>>2]=c[l+12>>2];k=d+(g*80|0)+32|0;c[h+32>>2]=c[k+0>>2];c[h+36>>2]=c[k+4>>2];c[h+40>>2]=c[k+8>>2];c[h+44>>2]=c[k+12>>2];j=d+(g*80|0)+48|0;c[h+48>>2]=c[j+0>>2];c[h+52>>2]=c[j+4>>2];c[h+56>>2]=c[j+8>>2];c[h+60>>2]=c[j+12>>2];e=d+(g*80|0)+64|0;c[h+64>>2]=c[e+0>>2];c[h+68>>2]=c[e+4>>2];c[h+72>>2]=c[e+8>>2];c[h+76>>2]=c[e+12>>2];n=d+(f*80|0)|0;c[m+0>>2]=c[n+0>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2];c[m+12>>2]=c[n+12>>2];m=d+(f*80|0)+16|0;c[l+0>>2]=c[m+0>>2];c[l+4>>2]=c[m+4>>2];c[l+8>>2]=c[m+8>>2];c[l+12>>2]=c[m+12>>2];l=d+(f*80|0)+32|0;c[k+0>>2]=c[l+0>>2];c[k+4>>2]=c[l+4>>2];c[k+8>>2]=c[l+8>>2];c[k+12>>2]=c[l+12>>2];k=d+(f*80|0)+48|0;c[j+0>>2]=c[k+0>>2];c[j+4>>2]=c[k+4>>2];c[j+8>>2]=c[k+8>>2];c[j+12>>2]=c[k+12>>2];d=d+(f*80|0)+64|0;c[e+0>>2]=c[d+0>>2];c[e+4>>2]=c[d+4>>2];c[e+8>>2]=c[d+8>>2];c[e+12>>2]=c[d+12>>2];e=c[a+24>>2]|0;c[e+(f*80|0)+0>>2]=c[h+0>>2];c[e+(f*80|0)+4>>2]=c[h+4>>2];c[e+(f*80|0)+8>>2]=c[h+8>>2];c[e+(f*80|0)+12>>2]=c[h+12>>2];c[e+(f*80|0)+16>>2]=c[h+16>>2];c[e+(f*80|0)+20>>2]=c[h+20>>2];c[e+(f*80|0)+24>>2]=c[h+24>>2];c[e+(f*80|0)+28>>2]=c[h+28>>2];c[e+(f*80|0)+32>>2]=c[h+32>>2];c[e+(f*80|0)+36>>2]=c[h+36>>2];c[e+(f*80|0)+40>>2]=c[h+40>>2];c[e+(f*80|0)+44>>2]=c[h+44>>2];c[e+(f*80|0)+48>>2]=c[h+48>>2];c[e+(f*80|0)+52>>2]=c[h+52>>2];c[e+(f*80|0)+56>>2]=c[h+56>>2];c[e+(f*80|0)+60>>2]=c[h+60>>2];c[e+(f*80|0)+64>>2]=c[h+64>>2];c[e+(f*80|0)+68>>2]=c[h+68>>2];c[e+(f*80|0)+72>>2]=c[h+72>>2];c[e+(f*80|0)+76>>2]=c[h+76>>2];if(c[a+64>>2]|0)c[(c[(c[a+24>>2]|0)+(g*80|0)+76>>2]|0)+36>>2]=g;d=(c[a+16>>2]|0)+-1|0;c[a+16>>2]=d}else d=e;if((g|0)<=0)break;else e=d}n=c[a>>2]|0;n=n+68|0;n=c[n>>2]|0;Jb[n&255](a);i=h;return}function Rw(a){a=a|0;var b=0.0,d=0,e=0,f=0,h=0;e=i;i=i+32|0;g[a+32>>2]=999999984306749440.0;g[a+36>>2]=999999984306749440.0;g[a+40>>2]=999999984306749440.0;g[a+44>>2]=0.0;g[a+48>>2]=-999999984306749440.0;g[a+52>>2]=-999999984306749440.0;g[a+56>>2]=-999999984306749440.0;g[a+60>>2]=0.0;if((c[a+16>>2]|0)<=0){i=e;return}d=0;do{f=c[a+24>>2]|0;h=c[f+(d*80|0)+64>>2]|0;tc[c[(c[h>>2]|0)+8>>2]&127](h,f+(d*80|0)|0,e+16|0,e);b=+g[e+16>>2];if(+g[a+32>>2]>b)g[a+32>>2]=b;b=+g[e>>2];if(+g[a+48>>2]<b)g[a+48>>2]=b;b=+g[e+20>>2];if(+g[a+36>>2]>b)g[a+36>>2]=b;b=+g[e+4>>2];if(+g[a+52>>2]<b)g[a+52>>2]=b;b=+g[e+24>>2];if(+g[a+40>>2]>b)g[a+40>>2]=b;b=+g[e+8>>2];if(+g[a+56>>2]<b)g[a+56>>2]=b;d=d+1|0}while((d|0)<(c[a+16>>2]|0));i=e;return}function Sw(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0;r=+g[a+48>>2];t=+g[a+32>>2];C=+g[a+52>>2];u=+g[a+36>>2];D=+g[a+56>>2];i=+g[a+40>>2];E=(c[a+16>>2]|0)==0;v=E?0.0:(D+i)*.5;x=E?0.0:(C+u)*.5;z=E?0.0:(r+t)*.5;m=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);k=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);m=(E?0.0:(r-t)*.5)+m;k=(E?0.0:(C-u)*.5)+k;i=(E?0.0:(D-i)*.5)+ +Zb[c[(c[a>>2]|0)+48>>2]&15](a);D=+g[b>>2];u=+O(+D);C=+g[b+4>>2];t=+O(+C);r=+g[b+8>>2];s=+O(+r);B=+g[b+16>>2];q=+O(+B);A=+g[b+20>>2];p=+O(+A);n=+g[b+24>>2];o=+O(+n);y=+g[b+32>>2];l=+O(+y);w=+g[b+36>>2];j=+O(+w);f=+g[b+40>>2];h=+O(+f);r=z*D+x*C+v*r+ +g[b+48>>2];n=z*B+x*A+v*n+ +g[b+52>>2];f=z*y+x*w+v*f+ +g[b+56>>2];g[d>>2]=r-(m*u+k*t+i*s);g[d+4>>2]=n-(m*q+k*p+i*o);g[d+8>>2]=f-(m*l+k*j+i*h);g[d+12>>2]=0.0;g[e>>2]=m*u+k*t+i*s+r;g[e+4>>2]=m*q+k*p+i*o+n;g[e+8>>2]=m*l+k*j+i*h+f;g[e+12>>2]=0.0;return}function Tw(a,b,d){a=a|0;b=+b;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0;e=i;i=i+96|0;g[e+32>>2]=1.0;c[e+36>>2]=0;c[e+40>>2]=0;c[e+44>>2]=0;c[e+48>>2]=0;g[e+52>>2]=1.0;c[e+56>>2]=0;c[e+60>>2]=0;c[e+64>>2]=0;c[e+68>>2]=0;g[e+72>>2]=1.0;k=e+76|0;c[k+0>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;tc[c[(c[a>>2]|0)+8>>2]&127](a,e+32|0,e+16|0,e);h=(+g[e>>2]-+g[e+16>>2])*.5*2.0;f=(+g[e+4>>2]-+g[e+20>>2])*.5*2.0;j=(+g[e+8>>2]-+g[e+24>>2])*.5*2.0;g[d>>2]=b/12.0*(f*f+j*j);g[d+4>>2]=b/12.0*(h*h+j*j);g[d+8>>2]=b/12.0*(h*h+f*f);i=e;return}function Uw(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0.0,r=0.0;p=i;i=i+144|0;if((c[a+16>>2]|0)<=0){o=a+76|0;c[o+0>>2]=c[b+0>>2];c[o+4>>2]=c[b+4>>2];c[o+8>>2]=c[b+8>>2];c[o+12>>2]=c[b+12>>2];b=c[a>>2]|0;b=b+68|0;b=c[b>>2]|0;Jb[b&255](a);i=p;return}j=p+32|0;k=p+48|0;l=p+64|0;o=0;do{n=c[a+24>>2]|0;m=n+(o*80|0)|0;c[p+16>>2]=c[m+0>>2];c[p+20>>2]=c[m+4>>2];c[p+24>>2]=c[m+8>>2];c[p+28>>2]=c[m+12>>2];m=n+(o*80|0)+16|0;c[j+0>>2]=c[m+0>>2];c[j+4>>2]=c[m+4>>2];c[j+8>>2]=c[m+8>>2];c[j+12>>2]=c[m+12>>2];m=n+(o*80|0)+32|0;c[k+0>>2]=c[m+0>>2];c[k+4>>2]=c[m+4>>2];c[k+8>>2]=c[m+8>>2];c[k+12>>2]=c[m+12>>2];m=n+(o*80|0)+48|0;c[l+0>>2]=c[m+0>>2];c[l+4>>2]=c[m+4>>2];c[l+8>>2]=c[m+8>>2];c[l+12>>2]=c[m+12>>2];n=c[n+(o*80|0)+64>>2]|0;n=Nb[c[(c[n>>2]|0)+28>>2]&127](n)|0;c[p+0>>2]=c[n+0>>2];c[p+4>>2]=c[n+4>>2];c[p+8>>2]=c[n+8>>2];q=+g[p+4>>2]*+g[b+4>>2]/+g[a+80>>2];r=+g[p+8>>2]*+g[b+8>>2]/+g[a+84>>2];g[p>>2]=+g[p>>2]*+g[b>>2]/+g[a+76>>2];g[p+4>>2]=q;g[p+8>>2]=r;g[p+12>>2]=0.0;n=c[(c[a+24>>2]|0)+(o*80|0)+64>>2]|0;Lb[c[(c[n>>2]|0)+24>>2]&127](n,p);r=+g[p+68>>2]*+g[b+4>>2]/+g[a+80>>2];q=+g[p+72>>2]*+g[b+8>>2]/+g[a+84>>2];g[p+64>>2]=+g[l>>2]*+g[b>>2]/+g[a+76>>2];g[p+68>>2]=r;g[p+72>>2]=q;g[p+76>>2]=0.0;n=c[a+24>>2]|0;m=n+(o*80|0)|0;c[m+0>>2]=c[p+16>>2];c[m+4>>2]=c[p+20>>2];c[m+8>>2]=c[p+24>>2];c[m+12>>2]=c[p+28>>2];m=n+(o*80|0)+16|0;c[m+0>>2]=c[j+0>>2];c[m+4>>2]=c[j+4>>2];c[m+8>>2]=c[j+8>>2];c[m+12>>2]=c[j+12>>2];m=n+(o*80|0)+32|0;c[m+0>>2]=c[k+0>>2];c[m+4>>2]=c[k+4>>2];c[m+8>>2]=c[k+8>>2];c[m+12>>2]=c[k+12>>2];n=n+(o*80|0)+48|0;c[n+0>>2]=c[l+0>>2];c[n+4>>2]=c[l+4>>2];c[n+8>>2]=c[l+8>>2];c[n+12>>2]=c[l+12>>2];if(c[a+64>>2]|0){m=c[(c[a+24>>2]|0)+(o*80|0)+64>>2]|0;tc[c[(c[m>>2]|0)+8>>2]&127](m,p+16|0,p+128|0,p+112|0);c[p+80>>2]=c[p+128>>2];c[p+84>>2]=c[p+132>>2];c[p+88>>2]=c[p+136>>2];c[p+92>>2]=c[p+140>>2];c[p+96>>2]=c[p+112>>2];c[p+100>>2]=c[p+116>>2];c[p+104>>2]=c[p+120>>2];c[p+108>>2]=c[p+124>>2];m=c[a+64>>2]|0;n=c[(c[a+24>>2]|0)+(o*80|0)+76>>2]|0;d=MC(m,n)|0;a:do if(d){f=c[m+8>>2]|0;if((f|0)<=-1){d=c[m>>2]|0;break}if((f|0)>0){h=0;e=d;while(1){d=c[e+32>>2]|0;h=h+1|0;if(!d){d=e;break a}if((h|0)>=(f|0))break;else e=d}}}else d=0;while(0);c[n+0>>2]=c[p+80>>2];c[n+4>>2]=c[p+84>>2];c[n+8>>2]=c[p+88>>2];c[n+12>>2]=c[p+92>>2];c[n+16>>2]=c[p+96>>2];c[n+20>>2]=c[p+100>>2];c[n+24>>2]=c[p+104>>2];c[n+28>>2]=c[p+108>>2];NC(m,d,n)}o=o+1|0}while((o|0)<(c[a+16>>2]|0));o=a+76|0;c[o+0>>2]=c[b+0>>2];c[o+4>>2]=c[b+4>>2];c[o+8>>2]=c[b+8>>2];c[o+12>>2]=c[b+12>>2];b=c[a>>2]|0;b=b+68|0;b=c[b>>2]|0;Jb[b&255](a);i=p;return}function Vw(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0;e=ec[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;i=ec[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;c[b>>2]=i;if(i)Lb[c[(c[d>>2]|0)+48>>2]&127](d,e);c[b+4>>2]=c[a+4>>2];g[b+20>>2]=+g[a+72>>2];e=c[a+16>>2]|0;c[b+16>>2]=e;c[b+12>>2]=0;if(!e)return 11568;i=Wb[c[(c[d>>2]|0)+16>>2]&63](d,76,e)|0;e=c[i+8>>2]|0;c[b+12>>2]=ec[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;if((c[b+16>>2]|0)>0){f=c[a+24>>2]|0;h=0;while(1){g[e+72>>2]=+g[f+(h*80|0)+72>>2];c[e+64>>2]=ec[c[(c[d>>2]|0)+28>>2]&31](d,c[f+(h*80|0)+64>>2]|0)|0;if(!(ec[c[(c[d>>2]|0)+24>>2]&31](d,c[(c[a+24>>2]|0)+(h*80|0)+64>>2]|0)|0)){f=c[(c[d>>2]|0)+16>>2]|0;j=c[(c[a+24>>2]|0)+(h*80|0)+64>>2]|0;j=Nb[c[(c[j>>2]|0)+52>>2]&127](j)|0;j=Wb[f&63](d,j,1)|0;f=c[(c[a+24>>2]|0)+(h*80|0)+64>>2]|0;f=Wb[c[(c[f>>2]|0)+56>>2]&63](f,c[j+8>>2]|0,d)|0;Hb[c[(c[d>>2]|0)+20>>2]&31](d,j,f,1346455635,c[(c[a+24>>2]|0)+(h*80|0)+64>>2]|0)}f=c[a+24>>2]|0;c[e+68>>2]=c[f+(h*80|0)+68>>2];g[e>>2]=+g[f+(h*80|0)>>2];g[e+4>>2]=+g[f+(h*80|0)+4>>2];g[e+8>>2]=+g[f+(h*80|0)+8>>2];g[e+12>>2]=+g[f+(h*80|0)+12>>2];g[e+16>>2]=+g[f+(h*80|0)+16>>2];g[e+20>>2]=+g[f+(h*80|0)+20>>2];g[e+24>>2]=+g[f+(h*80|0)+24>>2];g[e+28>>2]=+g[f+(h*80|0)+28>>2];g[e+32>>2]=+g[f+(h*80|0)+32>>2];g[e+36>>2]=+g[f+(h*80|0)+36>>2];g[e+40>>2]=+g[f+(h*80|0)+40>>2];g[e+44>>2]=+g[f+(h*80|0)+44>>2];g[e+48>>2]=+g[f+(h*80|0)+48>>2];g[e+52>>2]=+g[f+(h*80|0)+52>>2];g[e+56>>2]=+g[f+(h*80|0)+56>>2];g[e+60>>2]=+g[f+(h*80|0)+60>>2];h=h+1|0;if((h|0)>=(c[b+16>>2]|0)){e=d;break}else e=e+76|0}}else e=d;Hb[c[(c[e>>2]|0)+20>>2]&31](d,i,11536,1497453121,c[i+8>>2]|0);return 11568}function Ww(a){a=a|0;return 24}function Xw(a){a=a|0;return +(+g[a+72>>2])}function Yw(a,b){a=a|0;b=+b;g[a+72>>2]=b;return}function Zw(a){a=a|0;return 11632}function _w(a){a=a|0;return a+76|0}function $w(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0,j=0.0,k=0,l=0;h=+g[b+60>>2]*.5;l=c[b+68>>2]|0;e=+g[d>>2];f=+g[d+4>>2];j=+g[d+8>>2];j=+P(+(e*e+f*f+j*j));i=c[b+64>>2]|0;if(+g[d+(l<<2)>>2]>j*+g[b+52>>2]){g[a+(i<<2)>>2]=0.0;g[a+(l<<2)>>2]=h;g[a+(c[b+72>>2]<<2)>>2]=0.0;return}j=+g[d+(i<<2)>>2];k=c[b+72>>2]|0;e=+g[d+(k<<2)>>2];f=+P(+(j*j+e*e));if(f>1.1920928955078125e-07){f=+g[b+56>>2]/f;g[a+(i<<2)>>2]=j*f;g[a+(l<<2)>>2]=-h;g[a+(k<<2)>>2]=e*f;return}else{g[a+(i<<2)>>2]=0.0;g[a+(l<<2)>>2]=-h;g[a+(k<<2)>>2]=0.0;return}}
function $C(b,e,f,h,j,k,l,m,n,o){b=b|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;var p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0,w=0.0,x=0.0,y=0.0,z=0,A=0,B=0.0,C=0.0,D=0,E=0,F=0,G=0,H=0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0;H=i;i=i+10240|0;Q=+g[k+52>>2]-+g[j+52>>2];B=+g[k+56>>2]-+g[j+56>>2];g[H+9328>>2]=+g[k+48>>2]-+g[j+48>>2];g[H+9332>>2]=Q;g[H+9336>>2]=B;g[H+9340>>2]=0.0;c[H+9344>>2]=f;c[H+9348>>2]=h;B=+g[k>>2];Q=+g[j>>2];q=+g[k+16>>2];y=+g[j+16>>2];s=+g[k+32>>2];R=+g[j+32>>2];p=+g[j+4>>2];S=+g[j+20>>2];I=+g[j+36>>2];w=+g[j+8>>2];t=+g[j+24>>2];r=+g[j+40>>2];O=+g[k+4>>2];N=+g[k+20>>2];M=+g[k+36>>2];L=+g[k+8>>2];K=+g[k+24>>2];J=+g[k+40>>2];g[H+9352>>2]=B*Q+q*y+s*R;g[H+9356>>2]=B*p+q*S+s*I;g[H+9360>>2]=B*w+q*t+s*r;g[H+9364>>2]=0.0;g[H+9368>>2]=Q*O+y*N+R*M;g[H+9372>>2]=p*O+S*N+I*M;g[H+9376>>2]=w*O+t*N+r*M;g[H+9380>>2]=0.0;g[H+9384>>2]=Q*L+y*K+R*J;g[H+9388>>2]=p*L+S*K+I*J;g[H+9392>>2]=w*L+t*K+r*J;g[H+9396>>2]=0.0;r=+g[k+48>>2]-+g[j+48>>2];t=+g[k+52>>2]-+g[j+52>>2];w=+g[k+56>>2]-+g[j+56>>2];I=+g[j>>2];S=+g[k>>2];p=+g[j+16>>2];R=+g[k+16>>2];y=+g[j+32>>2];Q=+g[k+32>>2];s=+g[j+4>>2];q=+g[j+20>>2];B=+g[j+36>>2];C=+g[j+8>>2];x=+g[j+24>>2];u=+g[j+40>>2];g[H+9400>>2]=I*S+p*R+y*Q;g[H+9404>>2]=I*O+p*N+y*M;g[H+9408>>2]=I*L+p*K+y*J;g[H+9412>>2]=0.0;g[H+9416>>2]=S*s+R*q+Q*B;g[H+9420>>2]=O*s+N*q+M*B;g[H+9424>>2]=L*s+K*q+J*B;g[H+9428>>2]=0.0;g[H+9432>>2]=S*C+R*x+Q*u;g[H+9436>>2]=O*C+N*x+M*u;g[H+9440>>2]=L*C+K*x+J*u;g[H+9444>>2]=0.0;g[H+9448>>2]=r*I+t*p+w*y;g[H+9452>>2]=r*s+t*q+w*B;g[H+9456>>2]=r*C+t*x+w*u;g[H+9460>>2]=0.0;c[H+9464>>2]=71;c[H+9468>>2]=0;c[H+9836>>2]=0;c[H+9600>>2]=0;c[H+9604>>2]=0;c[H+9608>>2]=0;c[H+9612>>2]=0;c[H+9848>>2]=2;c[H+9840>>2]=0;g[H+9616>>2]=0.0;u=+g[H+9328>>2];w=+g[H+9332>>2];x=+g[H+9336>>2];g[H+9852>>2]=-u;g[H+9856>>2]=-w;g[H+9860>>2]=-x;g[H+9864>>2]=0.0;do if((qD(H+9472|0,H+9344|0,H+9852|0)|0)==1){c[H+9280>>2]=0;c[H+9284>>2]=0;c[H+9288>>2]=0;c[H+9292>>2]=0;c[H>>2]=9;c[H+9276>>2]=0;c[H+40>>2]=0;c[H+44>>2]=0;c[H+48>>2]=0;c[H+52>>2]=0;c[H+56>>2]=0;o=0;do{b=128-o+-1|0;c[H+(b*56|0)+2152>>2]=0;e=c[H+9288>>2]|0;c[H+(b*56|0)+2156>>2]=e;if(e)c[e+44>>2]=H+(b*56|0)+2108;c[H+9288>>2]=H+(b*56|0)+2108;c[H+9292>>2]=(c[H+9292>>2]|0)+1;o=o+1|0}while((o|0)!=128);E=c[H+9844>>2]|0;if((c[E+32>>2]|0)>>>0>1?vD(H+9472|0)|0:0){b=c[H+9280>>2]|0;if(b){z=c[H+9284>>2]|0;A=c[H+9292>>2]|0;do{o=b+48|0;v=c[o>>2]|0;e=b+44|0;if(v)c[v+44>>2]=c[e>>2];v=c[e>>2]|0;if(v)c[v+48>>2]=c[o>>2];if((c[H+9280>>2]|0)==(b|0))c[H+9280>>2]=c[o>>2];z=z+-1|0;c[e>>2]=0;c[o>>2]=c[H+9288>>2];e=c[H+9288>>2]|0;if(e)c[e+44>>2]=b;c[H+9288>>2]=b;A=A+1|0;b=c[H+9280>>2]|0}while((b|0)!=0);c[H+9284>>2]=z;c[H+9292>>2]=A}c[H>>2]=0;c[H+9276>>2]=0;e=c[E>>2]|0;b=c[E+12>>2]|0;R=+g[b+16>>2];C=+g[e+16>>2]-R;J=+g[b+20>>2];K=+g[e+20>>2]-J;N=+g[b+24>>2];L=+g[e+24>>2]-N;b=c[E+4>>2]|0;M=+g[b+16>>2]-R;Q=+g[b+20>>2]-J;t=+g[b+24>>2]-N;o=c[E+8>>2]|0;R=+g[o+16>>2]-R;J=+g[o+20>>2]-J;N=+g[o+24>>2]-N;if(C*Q*N+(K*t*R+L*M*J-C*t*J-K*M*N)-L*Q*R<0.0){c[E>>2]=b;c[E+4>>2]=e;R=+g[E+16>>2];g[E+16>>2]=+g[E+20>>2];g[E+20>>2]=R;v=b;b=e}else v=e;z=tD(H,v,b,o,1)|0;A=tD(H,c[E+4>>2]|0,c[E>>2]|0,c[E+12>>2]|0,1)|0;o=tD(H,c[E+8>>2]|0,c[E+4>>2]|0,c[E+12>>2]|0,1)|0;D=tD(H,c[E>>2]|0,c[E+8>>2]|0,c[E+12>>2]|0,1)|0;if((c[H+9284>>2]|0)==4){v=c[H+9280>>2]|0;t=+g[v+16>>2];b=c[v+48>>2]|0;if(b){x=t*t;e=v;while(1){u=+g[b+16>>2];v=u*u<x;e=v?b:e;b=c[b+48>>2]|0;if(!b)break;else x=v?u*u:x}t=+g[e+16>>2];v=e}x=+g[v>>2];w=+g[v+4>>2];C=+g[v+8>>2];u=+g[v+12>>2];F=c[v+20>>2]|0;E=c[v+24>>2]|0;b=c[v+28>>2]|0;a[z+52>>0]=0;c[z+32>>2]=A;a[A+52>>0]=0;c[A+32>>2]=z;a[z+53>>0]=0;c[z+36>>2]=o;a[o+52>>0]=1;c[o+32>>2]=z;a[z+54>>0]=0;c[z+40>>2]=D;a[D+52>>0]=2;c[D+32>>2]=z;a[A+53>>0]=2;c[A+36>>2]=D;a[D+54>>0]=1;c[D+40>>2]=A;a[A+54>>0]=1;c[A+40>>2]=o;a[o+53>>0]=2;c[o+36>>2]=A;a[o+54>>0]=1;c[o+40>>2]=D;a[D+53>>0]=2;c[D+36>>2]=o;c[H>>2]=0;D=F;o=E;E=0;F=1;while(1){e=c[H+9276>>2]|0;if(e>>>0>=64){G=47;break}c[H+9312>>2]=0;c[H+9316>>2]=0;c[H+9320>>2]=0;c[H+9276>>2]=e+1;a[v+55>>0]=F;A=v+4|0;z=v+8|0;sD(H+9472|0,+g[v>>2],+g[A>>2],+g[z>>2],H+(e<<5)+60|0);if(+g[v>>2]*+g[H+(e<<5)+76>>2]+ +g[A>>2]*+g[H+(e<<5)+80>>2]+ +g[z>>2]*+g[H+(e<<5)+84>>2]-+g[v+16>>2]>9.999999747378752e-05){z=0;A=1}else{G=46;break}do{A=A&(rD(H,F,H+(e<<5)+60|0,c[v+(z<<2)+32>>2]|0,d[v+z+52>>0]|0,H+9312|0)|0);z=z+1|0}while(!(z>>>0>2|A^1));if(!(A&(c[H+9320>>2]|0)>>>0>2)){G=45;break}b=c[H+9312>>2]|0;o=c[H+9316>>2]|0;a[b+53>>0]=2;c[b+36>>2]=o;a[o+54>>0]=1;c[o+40>>2]=b;o=v+48|0;b=c[o>>2]|0;e=v+44|0;if(b)c[b+44>>2]=c[e>>2];b=c[e>>2]|0;if(b)c[b+48>>2]=c[o>>2];if((c[H+9280>>2]|0)==(v|0))c[H+9280>>2]=c[o>>2];c[H+9284>>2]=(c[H+9284>>2]|0)+-1;c[e>>2]=0;c[o>>2]=c[H+9288>>2];b=c[H+9288>>2]|0;if(b)c[b+44>>2]=v;c[H+9288>>2]=v;c[H+9292>>2]=(c[H+9292>>2]|0)+1;e=c[H+9280>>2]|0;t=+g[e+16>>2];b=c[e+48>>2]|0;if(b){t=t*t;o=e;while(1){u=+g[b+16>>2];e=u*u<t;o=e?b:o;b=c[b+48>>2]|0;if(!b)break;else t=e?u*u:t}t=+g[o+16>>2];e=o}x=+g[e>>2];w=+g[e+4>>2];C=+g[e+8>>2];u=+g[e+12>>2];D=c[e+20>>2]|0;v=c[e+24>>2]|0;b=c[e+28>>2]|0;E=E+1|0;if(E>>>0>=255){e=D;break}else{o=v;v=e;F=F+1|0}}if((G|0)==45){c[H>>2]=4;e=D;v=o}else if((G|0)==46){c[H>>2]=7;e=D;v=o}else if((G|0)==47){c[H>>2]=6;e=D;v=o}r=t*x;J=t*w;L=t*C;g[H+40>>2]=x;g[H+44>>2]=w;g[H+48>>2]=C;g[H+52>>2]=u;g[H+56>>2]=t;c[H+36>>2]=3;c[H+4>>2]=e;c[H+8>>2]=v;c[H+12>>2]=b;D=v+16|0;N=+g[D>>2]-r;E=v+20|0;x=+g[E>>2]-J;F=v+24|0;M=+g[F>>2]-L;v=b+16|0;w=+g[v>>2]-r;z=b+20|0;K=+g[z>>2]-J;A=b+24|0;Q=+g[A>>2]-L;Q=+P(+((N*K-x*w)*(N*K-x*w)+((x*Q-M*K)*(x*Q-M*K)+(M*w-N*Q)*(M*w-N*Q))));g[H+20>>2]=Q;N=+g[v>>2]-r;w=+g[z>>2]-J;M=+g[A>>2]-L;A=e+16|0;K=+g[A>>2]-r;z=e+20|0;x=+g[z>>2]-J;v=e+24|0;R=+g[v>>2]-L;R=+P(+((N*x-w*K)*(N*x-w*K)+((w*R-M*x)*(w*R-M*x)+(M*K-N*R)*(M*K-N*R))));g[H+24>>2]=R;N=+g[A>>2]-r;K=+g[z>>2]-J;M=+g[v>>2]-L;x=+g[D>>2]-r;w=+g[E>>2]-J;L=+g[F>>2]-L;L=+P(+((N*w-K*x)*(N*w-K*x)+((K*L-M*w)*(K*L-M*w)+(M*x-N*L)*(M*x-N*L))));g[H+20>>2]=Q/(L+(Q+R));g[H+24>>2]=R/(L+(Q+R));g[H+28>>2]=L/(L+(Q+R));if((c[H>>2]|0)==9){v=0;x=0.0;w=0.0;q=0.0;s=0.0;y=0.0;p=0.0;B=0.0;C=0.0;u=0.0;break}if(!(c[H+36>>2]|0)){t=0.0;u=0.0;r=0.0}else{o=H+36|0;G=53}}else G=48}else G=48;if((G|0)==48){c[H>>2]=8;g[H+40>>2]=u;g[H+44>>2]=w;g[H+48>>2]=x;g[H+52>>2]=0.0;t=+P(+(u*u+w*w+x*x));if(t>0.0){s=1.0/t*x;r=1.0/t*w;q=1.0/t*u}else{s=0.0;r=0.0;q=1.0}g[H+40>>2]=q;g[H+44>>2]=r;g[H+48>>2]=s;g[H+52>>2]=0.0;g[H+56>>2]=0.0;c[H+36>>2]=1;c[H+4>>2]=c[E>>2];g[H+20>>2]=1.0;o=H+36|0;G=53}if((G|0)==53){r=0.0;u=0.0;t=0.0;v=0;do{b=c[H+9464>>2]|0;F=c[H+9468>>2]|0;e=(c[H+9344>>2]|0)+(F>>1)|0;if(F&1)b=c[(c[e>>2]|0)+b>>2]|0;pc[b&127](H+9296|0,e,c[H+(v<<2)+4>>2]|0);R=+g[H+(v<<2)+20>>2];r=r+ +g[H+9296>>2]*R;u=u+R*+g[H+9300>>2];t=t+R*+g[H+9304>>2];v=v+1|0}while(v>>>0<(c[o>>2]|0)>>>0)}O=+g[j>>2];I=+g[j+4>>2];S=+g[j+8>>2];N=+g[j+16>>2];L=+g[j+20>>2];Q=+g[j+24>>2];J=+g[j+32>>2];K=+g[j+36>>2];M=+g[j+40>>2];B=+g[j+48>>2];R=+g[j+52>>2];C=+g[j+56>>2];s=+g[H+40>>2];q=+g[H+56>>2];y=+g[H+44>>2];p=+g[H+48>>2];U=r-s*q;T=u-q*y;q=t-q*p;v=1;x=U*O+T*I+q*S+B;w=U*N+T*L+q*Q+R;q=U*J+T*K+q*M+C;s=-s;y=-y;p=-p;B=r*O+u*I+t*S+B;C=r*J+u*K+t*M+C;u=r*N+u*L+t*Q+R}else{v=0;x=0.0;w=0.0;q=0.0;s=0.0;y=0.0;p=0.0;B=0.0;C=0.0;u=0.0}while(0);if(v){g[m>>2]=B;g[m+4>>2]=u;g[m+8>>2]=C;g[m+12>>2]=0.0;g[n>>2]=x;g[n+4>>2]=w;g[n+8>>2]=q;g[n+12>>2]=0.0;g[l>>2]=s;g[l+4>>2]=y;g[l+8>>2]=p;g[l+12>>2]=0.0;n=1;i=H;return n|0}c[H+9472>>2]=f;c[H+9476>>2]=h;O=+g[k>>2];t=+g[j>>2];s=+g[k+16>>2];J=+g[j+16>>2];I=+g[k+32>>2];u=+g[j+32>>2];K=+g[j+4>>2];w=+g[j+20>>2];M=+g[j+36>>2];N=+g[j+8>>2];Q=+g[j+24>>2];U=+g[j+40>>2];q=+g[k+4>>2];B=+g[k+20>>2];S=+g[k+36>>2];r=+g[k+8>>2];C=+g[k+24>>2];T=+g[k+40>>2];g[H+9480>>2]=O*t+s*J+I*u;g[H+9484>>2]=O*K+s*w+I*M;g[H+9488>>2]=O*N+s*Q+I*U;g[H+9492>>2]=0.0;g[H+9496>>2]=t*q+J*B+u*S;g[H+9500>>2]=K*q+w*B+M*S;g[H+9504>>2]=N*q+Q*B+U*S;g[H+9508>>2]=0.0;g[H+9512>>2]=t*r+J*C+u*T;g[H+9516>>2]=K*r+w*C+M*T;g[H+9520>>2]=N*r+Q*C+U*T;g[H+9524>>2]=0.0;x=+g[k+48>>2]-+g[j+48>>2];L=+g[k+52>>2]-+g[j+52>>2];R=+g[k+56>>2]-+g[j+56>>2];g[H+9528>>2]=O*t+s*J+I*u;g[H+9532>>2]=t*q+J*B+u*S;g[H+9536>>2]=t*r+J*C+u*T;g[H+9540>>2]=0.0;g[H+9544>>2]=O*K+s*w+I*M;g[H+9548>>2]=K*q+w*B+M*S;g[H+9552>>2]=K*r+w*C+M*T;g[H+9556>>2]=0.0;g[H+9560>>2]=O*N+s*Q+I*U;g[H+9564>>2]=N*q+Q*B+U*S;g[H+9568>>2]=N*r+Q*C+U*T;g[H+9572>>2]=0.0;g[H+9576>>2]=x*t+L*J+R*u;g[H+9580>>2]=x*K+L*w+R*M;g[H+9584>>2]=x*N+L*Q+R*U;g[H+9588>>2]=0.0;c[H+9592>>2]=72;c[H+9596>>2]=0;c[H+10216>>2]=0;c[H+9980>>2]=0;c[H+9984>>2]=0;c[H+9988>>2]=0;c[H+9992>>2]=0;c[H+10228>>2]=2;c[H+10220>>2]=0;g[H+9996>>2]=0.0;if(qD(H+9852|0,H+9472|0,H+9328|0)|0){n=0;i=H;return n|0}o=c[H+10224>>2]|0;if(!(c[o+32>>2]|0)){u=0.0;t=0.0;s=0.0;r=0.0;q=0.0;p=0.0}else{s=0.0;t=0.0;u=0.0;p=0.0;q=0.0;r=0.0;D=0;do{C=+g[o+(D<<2)+16>>2];b=c[H+9592>>2]|0;h=c[H+9596>>2]|0;e=(c[H+9472>>2]|0)+(h>>1)|0;if(h&1)b=c[(c[e>>2]|0)+b>>2]|0;pc[b&127](H+9296|0,e,c[o+(D<<2)>>2]|0);s=s+C*+g[H+9296>>2];t=t+C*+g[H+9300>>2];u=u+C*+g[H+9304>>2];v=c[(c[H+10224>>2]|0)+(D<<2)>>2]|0;w=-+g[v>>2];x=-+g[v+4>>2];y=-+g[v+8>>2];v=c[H+9592>>2]|0;h=c[H+9596>>2]|0;b=(c[H+9476>>2]|0)+(h>>1)|0;if(h&1)v=c[(c[b>>2]|0)+v>>2]|0;R=+g[H+9496>>2]*w+ +g[H+9500>>2]*x+ +g[H+9504>>2]*y;Q=+g[H+9512>>2]*w+ +g[H+9516>>2]*x+ +g[H+9520>>2]*y;g[H+9344>>2]=+g[H+9480>>2]*w+ +g[H+9484>>2]*x+ +g[H+9488>>2]*y;g[H+9348>>2]=R;g[H+9352>>2]=Q;g[H+9356>>2]=0.0;pc[v&127](H+9312|0,b,H+9344|0);Q=+g[H+9312>>2];R=+g[H+9316>>2];U=+g[H+9320>>2];p=p+C*(Q*+g[H+9528>>2]+R*+g[H+9532>>2]+U*+g[H+9536>>2]+ +g[H+9576>>2]);q=q+C*(Q*+g[H+9544>>2]+R*+g[H+9548>>2]+U*+g[H+9552>>2]+ +g[H+9580>>2]);r=r+C*(Q*+g[H+9560>>2]+R*+g[H+9564>>2]+U*+g[H+9568>>2]+ +g[H+9584>>2]);D=D+1|0;o=c[H+10224>>2]|0}while(D>>>0<(c[o+32>>2]|0)>>>0)}O=+g[j>>2];I=+g[j+4>>2];B=+g[j+8>>2];C=+g[j+16>>2];T=+g[j+20>>2];J=+g[j+24>>2];w=+g[j+32>>2];M=+g[j+36>>2];x=+g[j+40>>2];S=+g[j+48>>2];K=+g[j+52>>2];N=+g[j+56>>2];L=s-p;Q=t-q;U=u-r;R=+P(+(L*L+Q*Q+U*U));R=R>9.999999747378752e-05?1.0/R:1.0;g[m>>2]=s*O+t*I+u*B+S;g[m+4>>2]=s*C+t*T+u*J+K;g[m+8>>2]=s*w+t*M+u*x+N;g[m+12>>2]=0.0;g[n>>2]=p*O+q*I+r*B+S;g[n+4>>2]=p*C+q*T+r*J+K;g[n+8>>2]=p*w+q*M+r*x+N;g[n+12>>2]=0.0;g[l>>2]=R*L;g[l+4>>2]=R*Q;g[l+8>>2]=R*U;g[l+12>>2]=0.0;n=0;i=H;return n|0}function aD(a){a=a|0;_E(a);return}function bD(b,d,e,f,h,j){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0,q=0.0,r=0.0,s=0.0,t=0,u=0,v=0.0;t=i;i=i+288|0;u=c[b+4>>2]|0;a[u+312>>0]=0;c[u>>2]=0;a[u+356>>0]=1;g[u+292>>2]=999999984306749440.0;g[u+296>>2]=999999984306749440.0;g[u+300>>2]=999999984306749440.0;g[u+304>>2]=0.0;c[u+336>>2]=0;c[u+340>>2]=0;c[u+344>>2]=0;c[u+348>>2]=0;a[u+352>>0]=0;a[u+332>>0]=a[u+332>>0]&-16;q=+g[e+48>>2]-+g[d+48>>2]-(+g[h+48>>2]-+g[f+48>>2]);r=+g[e+52>>2]-+g[d+52>>2]-(+g[h+52>>2]-+g[f+52>>2]);s=+g[e+56>>2]-+g[d+56>>2]-(+g[h+56>>2]-+g[f+56>>2]);c[t+216>>2]=19288;g[t+252>>2]=999999984306749440.0;a[t+256>>0]=0;u=c[b+8>>2]|0;p=c[b+12>>2]|0;b=c[b+4>>2]|0;c[t+136>>2]=19496;g[t+140>>2]=0.0;g[t+144>>2]=1.0;g[t+148>>2]=0.0;g[t+152>>2]=0.0;c[t+156>>2]=0;c[t+160>>2]=b;c[t+164>>2]=u;c[t+168>>2]=p;c[t+172>>2]=c[u+4>>2];c[t+176>>2]=c[p+4>>2];g[t+180>>2]=+Zb[c[(c[u>>2]|0)+48>>2]&15](u);g[t+184>>2]=+Zb[c[(c[p>>2]|0)+48>>2]&15](p);a[t+188>>0]=0;c[t+196>>2]=-1;c[t+208>>2]=1;c[t+212>>2]=1;g[t+128>>2]=999999984306749440.0;c[t+0>>2]=c[d+0>>2];c[t+4>>2]=c[d+4>>2];c[t+8>>2]=c[d+8>>2];c[t+12>>2]=c[d+12>>2];c[t+16>>2]=c[d+16>>2];c[t+20>>2]=c[d+20>>2];c[t+24>>2]=c[d+24>>2];c[t+28>>2]=c[d+28>>2];c[t+32>>2]=c[d+32>>2];c[t+36>>2]=c[d+36>>2];c[t+40>>2]=c[d+40>>2];c[t+44>>2]=c[d+44>>2];c[t+48>>2]=c[d+48>>2];c[t+52>>2]=c[d+52>>2];c[t+56>>2]=c[d+56>>2];c[t+60>>2]=c[d+60>>2];c[t+64>>2]=c[f+0>>2];c[t+68>>2]=c[f+4>>2];c[t+72>>2]=c[f+8>>2];c[t+76>>2]=c[f+12>>2];c[t+80>>2]=c[f+16>>2];c[t+84>>2]=c[f+20>>2];c[t+88>>2]=c[f+24>>2];c[t+92>>2]=c[f+28>>2];c[t+96>>2]=c[f+32>>2];c[t+100>>2]=c[f+36>>2];c[t+104>>2]=c[f+40>>2];c[t+108>>2]=c[f+44>>2];c[t+112>>2]=c[f+48>>2];c[t+116>>2]=c[f+52>>2];c[t+120>>2]=c[f+56>>2];c[t+124>>2]=c[f+60>>2];nD(t+136|0,t,t+216|0,0,0);b=(a[t+256>>0]|0)==0;p=t+236|0;c[t+264>>2]=c[p+0>>2];c[t+268>>2]=c[p+4>>2];c[t+272>>2]=c[p+8>>2];c[t+276>>2]=c[p+12>>2];if(b){u=0;i=t;return u|0}o=+g[t+252>>2];l=+g[t+220>>2];m=+g[t+224>>2];n=+g[t+228>>2];k=+g[t+232>>2];do if(o>1.0000000474974513e-03){k=0.0;b=1;while(1){if((b|0)>32){b=0;d=13;break}v=k;k=k-o/(s*n+(r*m+q*l));if(!(!(k<0.0)&!(k>1.0)&!(k<=v))){b=0;d=13;break}Ib[c[c[j>>2]>>2]&31](j,k);v=1.0-k;g[t+48>>2]=v*+g[d+48>>2]+k*+g[e+48>>2];g[t+52>>2]=v*+g[d+52>>2]+k*+g[e+52>>2];g[t+56>>2]=v*+g[d+56>>2]+k*+g[e+56>>2];g[t+112>>2]=v*+g[f+48>>2]+k*+g[h+48>>2];g[t+116>>2]=v*+g[f+52>>2]+k*+g[h+52>>2];g[t+120>>2]=v*+g[f+56>>2]+k*+g[h+56>>2];nD(t+136|0,t,t+216|0,0,0);if(!(a[t+256>>0]|0)){b=0;d=13;break}o=+g[t+252>>2];if(o<0.0){d=8;break};c[t+264>>2]=c[p+0>>2];c[t+268>>2]=c[p+4>>2];c[t+272>>2]=c[p+8>>2];c[t+276>>2]=c[p+12>>2];l=+g[t+220>>2];m=+g[t+224>>2];n=+g[t+228>>2];if(!(o>1.0000000474974513e-03)){d=10;break}else b=b+1|0}if((d|0)==8){g[j+164>>2]=k;o=+g[t+224>>2];q=+g[t+228>>2];v=+g[t+232>>2];g[j+132>>2]=+g[t+220>>2];g[j+136>>2]=o;g[j+140>>2]=q;g[j+144>>2]=v;c[j+148>>2]=c[p+0>>2];c[j+152>>2]=c[p+4>>2];c[j+156>>2]=c[p+8>>2];c[j+160>>2]=c[p+12>>2];u=1;i=t;return u|0}else if((d|0)==10){o=+g[t+232>>2];break}else if((d|0)==13){i=t;return b|0}}else{o=k;k=0.0}while(0);if(s*n+(r*m+q*l)>=-+g[j+172>>2]){u=0;i=t;return u|0}g[j+164>>2]=k;g[j+132>>2]=l;g[j+136>>2]=m;g[j+140>>2]=n;g[j+144>>2]=o;c[j+148>>2]=c[t+264>>2];c[j+152>>2]=c[t+268>>2];c[j+156>>2]=c[t+272>>2];c[j+160>>2]=c[t+276>>2];u=1;i=t;return u|0}function cD(a){a=a|0;_E(a);return}function dD(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;if(!(+g[b+36>>2]>f))return;a[b+40>>0]=1;c[b+4>>2]=c[d+0>>2];c[b+8>>2]=c[d+4>>2];c[b+12>>2]=c[d+8>>2];c[b+16>>2]=c[d+12>>2];c[b+20>>2]=c[e+0>>2];c[b+24>>2]=c[e+4>>2];c[b+28>>2]=c[e+8>>2];c[b+32>>2]=c[e+12>>2];g[b+36>>2]=f;return}function eD(a,b,c){a=a|0;b=b|0;c=c|0;return}function fD(a,b,c){a=a|0;b=b|0;c=c|0;return}function gD(a){a=a|0;_E(a);return}function hD(a){a=a|0;return}function iD(a,b,c,d,e,f,h,i,j,k,l){a=a|0;b=b|0;c=+c;d=+d;e=+e;f=+f;h=+h;i=+i;j=j|0;k=k|0;l=+l;var m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0;w=+g[a>>2]*f+ +g[a+16>>2]*h+ +g[a+32>>2]*i;x=+g[a+4>>2]*f+ +g[a+20>>2]*h+ +g[a+36>>2]*i;t=+g[a+8>>2]*f+ +g[a+24>>2]*h+ +g[a+40>>2]*i;u=+g[b>>2]*f+ +g[b+16>>2]*h+ +g[b+32>>2]*i;v=+g[b+4>>2]*f+ +g[b+20>>2]*h+ +g[b+36>>2]*i;s=+g[b+8>>2]*f+ +g[b+24>>2]*h+ +g[b+40>>2]*i;m=+g[j+80>>2];if(w<0.0)m=-m;n=+g[j+84>>2];if(x<0.0)n=-n;o=+g[j+88>>2];if(t<0.0)o=-o;p=+g[k+80>>2];if(u<0.0)p=-p;q=+g[k+84>>2];if(v<0.0)q=-q;r=+g[k+88>>2];if(!(s<0.0)){w=w*m;x=x*n;x=w+x;t=t*o;t=x+t;u=u*p;x=v*q;x=u+x;u=s*r;u=x+u;j=j+96|0;x=+g[j>>2];j=t>x;x=j?t:x;k=k+96|0;v=+g[k>>2];k=u>v;v=k?u:v;v=x+v;x=c*f+d*h+e*i+v;e=v-(c*f+d*h+e*i);k=x<e;e=k?x:e;k=!(e>l);return k|0}r=-r;w=w*m;x=x*n;x=w+x;t=t*o;t=x+t;u=u*p;x=v*q;x=u+x;u=s*r;u=x+u;j=j+96|0;x=+g[j>>2];j=t>x;x=j?t:x;k=k+96|0;v=+g[k>>2];k=u>v;v=k?u:v;v=x+v;x=c*f+d*h+e*i+v;e=v-(c*f+d*h+e*i);k=x<e;e=k?x:e;k=!(e>l);return k|0}function jD(b,d,e,f,h,j,k){b=b|0;d=d|0;e=e|0;f=f|0;h=+h;j=+j;k=k|0;var l=0,m=0,n=0.0,o=0,p=0.0,q=0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0,D=0,E=0.0,F=0.0,G=0.0,H=0,I=0,J=0,K=0,L=0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0;da=i;i=i+64|0;a[da+48>>0]=1;c[da+44>>2]=0;c[da+36>>2]=0;c[da+40>>2]=0;m=c[f+4>>2]|0;if((m|0)>0){c[5132]=(c[5132]|0)+1;l=ZE((m<<4|3)+16|0)|0;if(!l)l=0;else{c[(l+19&-16)+-4>>2]=l;l=l+19&-16}a[da+48>>0]=1;c[da+44>>2]=l;c[da+40>>2]=m}else l=0;o=c[d+28>>2]|0;if((o|0)>0){ba=c[d+36>>2]|0;A=+g[e>>2];B=+g[e+4>>2];E=+g[e+8>>2];F=+g[e+16>>2];G=+g[e+20>>2];s=+g[e+24>>2];n=+g[e+32>>2];r=+g[e+36>>2];p=+g[e+40>>2];t=+g[b>>2];u=+g[b+4>>2];v=+g[b+8>>2];ca=-1;z=3402823466385288598117041.0e14;m=0;while(1){w=+g[ba+(m*36|0)+20>>2];x=+g[ba+(m*36|0)+24>>2];y=+g[ba+(m*36|0)+28>>2];q=(w*A+x*B+y*E)*t+(w*F+x*G+y*s)*u+(w*n+x*r+y*p)*v<z;ca=q?m:ca;m=m+1|0;if((m|0)==(o|0))break;else z=q?(w*A+x*B+y*E)*t+(w*F+x*G+y*s)*u+(w*n+x*r+y*p)*v:z}if((ca|0)>=0){T=c[ba+(ca*36|0)+4>>2]|0;if((T|0)>0){U=ba+(ca*36|0)+12|0;X=ba+(ca*36|0)+20|0;V=ba+(ca*36|0)+24|0;W=ba+(ca*36|0)+28|0;z=A;v=B;w=E;y=F;u=G;S=0;R=f;Y=da+32|0;while(1){L=c[U>>2]|0;m=c[L+(S<<2)>>2]|0;f=c[d+16>>2]|0;S=S+1|0;L=c[L+(((S|0)==(T|0)?0:S)<<2)>>2]|0;E=+g[f+(m<<4)>>2];B=E-+g[f+(L<<4)>>2];F=+g[f+(m<<4)+4>>2];A=F-+g[f+(L<<4)+4>>2];G=+g[f+(m<<4)+8>>2];N=G-+g[f+(L<<4)+8>>2];x=B*z+A*v+N*w;M=B*y+A*u+N*s;N=B*n+A*r+N*p;A=+g[X>>2];B=+g[V>>2];Q=+g[W>>2];O=z*A+v*B+w*Q;P=y*A+u*B+s*Q;Q=n*A+r*B+p*Q;w=(E*z+F*v+G*w+ +g[e+48>>2])*-(M*Q-N*P)+(E*y+F*u+G*s+ +g[e+52>>2])*-(N*O-x*Q)+(E*n+F*r+G*p+ +g[e+56>>2])*-(x*P-M*O);L=R+4|0;f=c[L>>2]|0;if((f|0)>=2){H=R+12|0;q=c[H>>2]|0;F=+g[q+(f+-1<<4)>>2];G=+g[q+(f+-1<<4)+4>>2];A=+g[q+(f+-1<<4)+8>>2];I=Y+4|0;J=Y+8|0;K=Y+12|0;l=Y+16|0;B=F;z=G;E=A;A=F*-(M*Q-N*P)+G*-(N*O-x*Q)+A*-(x*P-M*O)-w;C=0;while(1){v=+g[q+(C<<4)>>2];u=+g[q+(C<<4)+4>>2];t=+g[q+(C<<4)+8>>2];y=+g[q+(C<<4)+12>>2];s=v*-(M*Q-N*P)+u*-(N*O-x*Q)+t*-(x*P-M*O)-w;do if(A<0.0)if(s<0.0){o=c[I>>2]|0;if((o|0)==(c[J>>2]|0)?(aa=(o|0)==0?1:o<<1,(o|0)<(aa|0)):0){if(!aa)m=0;else{c[5132]=(c[5132]|0)+1;o=ZE((aa<<4|3)+16|0)|0;if(!o)o=0;else{c[(o+19&-16)+-4>>2]=o;o=o+19&-16}m=o;o=c[I>>2]|0}if((o|0)>0){q=0;do{D=m+(q<<4)|0;ea=(c[K>>2]|0)+(q<<4)|0;c[D+0>>2]=c[ea+0>>2];c[D+4>>2]=c[ea+4>>2];c[D+8>>2]=c[ea+8>>2];c[D+12>>2]=c[ea+12>>2];q=q+1|0}while((q|0)!=(o|0))}o=c[K>>2]|0;if(o){if(a[l>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[o+-4>>2]|0)}c[K>>2]=0}a[l>>0]=1;c[K>>2]=m;c[J>>2]=aa;o=c[I>>2]|0}ea=c[K>>2]|0;g[ea+(o<<4)>>2]=v;g[ea+(o<<4)+4>>2]=u;g[ea+(o<<4)+8>>2]=t;g[ea+(o<<4)+12>>2]=y;c[I>>2]=(c[I>>2]|0)+1;break}else{G=A/(A-s);B=B+(v-B)*G;F=z+(u-z)*G;E=E+(t-E)*G;o=c[I>>2]|0;if((o|0)==(c[J>>2]|0)?($=(o|0)==0?1:o<<1,(o|0)<($|0)):0){if(!$)m=0;else{c[5132]=(c[5132]|0)+1;o=ZE(($<<4|3)+16|0)|0;if(!o)o=0;else{c[(o+19&-16)+-4>>2]=o;o=o+19&-16}m=o;o=c[I>>2]|0}if((o|0)>0){q=0;do{ea=m+(q<<4)|0;D=(c[K>>2]|0)+(q<<4)|0;c[ea+0>>2]=c[D+0>>2];c[ea+4>>2]=c[D+4>>2];c[ea+8>>2]=c[D+8>>2];c[ea+12>>2]=c[D+12>>2];q=q+1|0}while((q|0)!=(o|0))}o=c[K>>2]|0;if(o){if(a[l>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[o+-4>>2]|0)}c[K>>2]=0}a[l>>0]=1;c[K>>2]=m;c[J>>2]=$;o=c[I>>2]|0}ea=c[K>>2]|0;g[ea+(o<<4)>>2]=B;g[ea+(o<<4)+4>>2]=F;g[ea+(o<<4)+8>>2]=E;g[ea+(o<<4)+12>>2]=0.0;c[I>>2]=(c[I>>2]|0)+1;break}else if(s<0.0){F=A/(A-s);B=B+(v-B)*F;G=z+(u-z)*F;F=E+(t-E)*F;o=c[I>>2]|0;if((o|0)==(c[J>>2]|0)?(_=(o|0)==0?1:o<<1,(o|0)<(_|0)):0){if(!_)D=0;else{c[5132]=(c[5132]|0)+1;o=ZE((_<<4|3)+16|0)|0;if(!o)o=0;else{c[(o+19&-16)+-4>>2]=o;o=o+19&-16}D=o;o=c[I>>2]|0}if((o|0)>0){q=0;do{ea=D+(q<<4)|0;m=(c[K>>2]|0)+(q<<4)|0;c[ea+0>>2]=c[m+0>>2];c[ea+4>>2]=c[m+4>>2];c[ea+8>>2]=c[m+8>>2];c[ea+12>>2]=c[m+12>>2];q=q+1|0}while((q|0)!=(o|0))}o=c[K>>2]|0;if(o){if(a[l>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[o+-4>>2]|0)}c[K>>2]=0}a[l>>0]=1;c[K>>2]=D;c[J>>2]=_;o=c[I>>2]|0}ea=c[K>>2]|0;g[ea+(o<<4)>>2]=B;g[ea+(o<<4)+4>>2]=G;g[ea+(o<<4)+8>>2]=F;g[ea+(o<<4)+12>>2]=0.0;o=(c[I>>2]|0)+1|0;c[I>>2]=o;if((o|0)==(c[J>>2]|0)?(Z=(o|0)==0?1:o<<1,(o|0)<(Z|0)):0){if(!Z)m=0;else{c[5132]=(c[5132]|0)+1;o=ZE((Z<<4|3)+16|0)|0;if(!o)o=0;else{c[(o+19&-16)+-4>>2]=o;o=o+19&-16}m=o;o=c[I>>2]|0}if((o|0)>0){q=0;do{ea=m+(q<<4)|0;D=(c[K>>2]|0)+(q<<4)|0;c[ea+0>>2]=c[D+0>>2];c[ea+4>>2]=c[D+4>>2];c[ea+8>>2]=c[D+8>>2];c[ea+12>>2]=c[D+12>>2];q=q+1|0}while((q|0)!=(o|0))}o=c[K>>2]|0;if(o){if(a[l>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[o+-4>>2]|0)}c[K>>2]=0}a[l>>0]=1;c[K>>2]=m;c[J>>2]=Z;o=c[I>>2]|0}ea=c[K>>2]|0;g[ea+(o<<4)>>2]=v;g[ea+(o<<4)+4>>2]=u;g[ea+(o<<4)+8>>2]=t;g[ea+(o<<4)+12>>2]=y;c[I>>2]=(c[I>>2]|0)+1}while(0);o=C+1|0;if((o|0)==(f|0))break;q=c[H>>2]|0;B=v;z=u;E=t;A=s;C=o}f=c[L>>2]|0}if((f|0)<0){m=R+8|0;l=R+12|0;if((c[m>>2]|0)<0){q=c[l>>2]|0;o=R+16|0;if(q){if(a[o>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[q+-4>>2]|0)}c[l>>2]=0}a[o>>0]=1;c[l>>2]=0;c[m>>2]=0}do{ea=(c[l>>2]|0)+(f<<4)|0;c[ea+0>>2]=c[da+16>>2];c[ea+4>>2]=c[da+20>>2];c[ea+8>>2]=c[da+24>>2];c[ea+12>>2]=c[da+28>>2];f=f+1|0}while((f|0)!=0)}c[L>>2]=0;z=+g[e>>2];v=+g[e+4>>2];w=+g[e+8>>2];y=+g[e+16>>2];u=+g[e+20>>2];s=+g[e+24>>2];n=+g[e+32>>2];r=+g[e+36>>2];p=+g[e+40>>2];if((S|0)>=(T|0)){m=V;q=W;C=e+48|0;D=e+52|0;l=e+56|0;o=X;f=Y;break}else{ea=Y;Y=R;R=ea}}}else{m=ba+(ca*36|0)+24|0;q=ba+(ca*36|0)+28|0;C=e+48|0;D=e+52|0;l=e+56|0;o=ba+(ca*36|0)+20|0;z=A;v=B;w=E;y=F;u=G}F=+g[o>>2];G=+g[m>>2];N=+g[q>>2];t=F*z+G*v+N*w;s=F*y+G*u+N*s;r=F*n+G*r+N*p;p=+g[ba+(ca*36|0)+32>>2]-(t*+g[C>>2]+s*+g[D>>2]+r*+g[l>>2]);q=f+4|0;l=c[q>>2]|0;if((l|0)>0){f=f+12|0;o=0;do{ea=c[f>>2]|0;m=ea+(o<<4)|0;n=p+(t*+g[m>>2]+s*+g[ea+(o<<4)+4>>2]+r*+g[ea+(o<<4)+8>>2]);n=!(n<=h)?n:h;if(n<=j){c[da+0>>2]=c[m+0>>2];c[da+4>>2]=c[m+4>>2];c[da+8>>2]=c[m+8>>2];c[da+12>>2]=c[m+12>>2];oc[c[(c[k>>2]|0)+16>>2]&15](k,b,da,n);l=c[q>>2]|0}o=o+1|0}while((o|0)<(l|0))}l=c[da+44>>2]|0}}if(!l){i=da;return}if(a[da+48>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[l+-4>>2]|0)}c[da+44>>2]=0;i=da;return}function kD(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0,L=0,M=0,N=0,O=0;h=i;i=i+288|0;if(!(c[b+16>>2]|0)){K=c[b+12>>2]|0;b=c[b+20>>2]|0;n=+g[d>>2];q=+g[d+4>>2];u=+g[d+8>>2];k=+g[d+16>>2];r=+g[d+20>>2];j=+g[d+24>>2];m=+g[d+32>>2];s=+g[d+36>>2];l=+g[d+40>>2];F=+g[d+48>>2];E=+g[d+52>>2];D=+g[d+56>>2];J=+g[e>>2];I=+g[e+16>>2];y=+g[e+32>>2];H=+g[e+4>>2];G=+g[e+20>>2];w=+g[e+36>>2];v=+g[e+8>>2];z=+g[e+24>>2];x=+g[e+40>>2];C=-+g[e+48>>2];B=-+g[e+52>>2];p=-+g[e+56>>2];d=c[(c[K>>2]|0)+64>>2]|0;A=-+g[b+48>>2];t=-+g[b+52>>2];o=-+g[b+56>>2];g[h+32>>2]=(n*J+k*I+m*y)*A+(n*H+k*G+m*w)*t+(n*v+k*z+m*x)*o;g[h+36>>2]=(q*J+r*I+s*y)*A+(q*H+r*G+s*w)*t+(q*v+r*z+s*x)*o;g[h+40>>2]=(u*J+j*I+l*y)*A+(u*H+j*G+l*w)*t+(u*v+j*z+l*x)*o;g[h+44>>2]=0.0;pc[d&127](h+48|0,K,h+32|0);o=+g[h+48>>2];t=+g[h+52>>2];A=+g[h+56>>2];y=F*J+E*I+D*y+(J*C+I*B+y*p)+((n*J+k*I+m*y)*o+(q*J+r*I+s*y)*t+(u*J+j*I+l*y)*A);w=F*H+E*G+D*w+(H*C+G*B+w*p)+((n*H+k*G+m*w)*o+(q*H+r*G+s*w)*t+(u*H+j*G+l*w)*A);A=F*v+E*z+D*x+(v*C+z*B+x*p)+((n*v+k*z+m*x)*o+(q*v+r*z+s*x)*t+(u*v+j*z+l*x)*A);x=+g[b+48>>2];l=+g[b+52>>2];z=+g[b+56>>2];j=z*A+(x*y+l*w)-+g[b+64>>2];v=+g[e>>2];u=+g[e+4>>2];t=+g[e+8>>2];s=+g[e+16>>2];r=+g[e+20>>2];q=+g[e+24>>2];o=+g[e+32>>2];m=+g[e+36>>2];k=+g[e+40>>2];n=s*(y-x*j)+(w-l*j)*r+(A-z*j)*q+ +g[e+52>>2];p=(y-x*j)*o+(w-l*j)*m+(A-z*j)*k+ +g[e+56>>2];g[h+16>>2]=t*(A-z*j)+(v*(y-x*j)+u*(w-l*j))+ +g[e+48>>2];g[h+20>>2]=n;g[h+24>>2]=p;g[h+28>>2]=0.0;p=+g[b+48>>2];n=+g[b+52>>2];l=+g[b+56>>2];g[h>>2]=v*p+u*n+t*l;g[h+4>>2]=p*s+n*r+l*q;g[h+8>>2]=p*o+n*m+l*k;g[h+12>>2]=0.0;oc[c[(c[f>>2]|0)+16>>2]&15](f,h,h+16|0,j);i=h;return}else{N=c[b+4>>2]|0;a[N+312>>0]=0;c[N>>2]=0;a[N+356>>0]=1;g[N+292>>2]=999999984306749440.0;g[N+296>>2]=999999984306749440.0;g[N+300>>2]=999999984306749440.0;g[N+304>>2]=0.0;c[N+336>>2]=0;c[N+340>>2]=0;c[N+344>>2]=0;c[N+348>>2]=0;a[N+352>>0]=0;a[N+332>>0]=a[N+332>>0]&-16;N=c[b+12>>2]|0;M=c[b+16>>2]|0;L=c[N+4>>2]|0;K=c[M+4>>2]|0;I=+Zb[c[(c[N>>2]|0)+48>>2]&15](N);O=c[b+16>>2]|0;J=+Zb[c[(c[O>>2]|0)+48>>2]&15](O);O=c[b+4>>2]|0;b=c[b+8>>2]|0;c[h+200>>2]=19496;g[h+204>>2]=0.0;g[h+208>>2]=1.0;g[h+212>>2]=0.0;g[h+216>>2]=0.0;c[h+220>>2]=b;c[h+224>>2]=O;c[h+228>>2]=N;c[h+232>>2]=M;c[h+236>>2]=L;c[h+240>>2]=K;g[h+244>>2]=I;g[h+248>>2]=J;a[h+252>>0]=0;c[h+260>>2]=-1;c[h+272>>2]=1;c[h+276>>2]=1;g[h+192>>2]=999999984306749440.0;c[h+64>>2]=c[d+0>>2];c[h+68>>2]=c[d+4>>2];c[h+72>>2]=c[d+8>>2];c[h+76>>2]=c[d+12>>2];c[h+80>>2]=c[d+16>>2];c[h+84>>2]=c[d+20>>2];c[h+88>>2]=c[d+24>>2];c[h+92>>2]=c[d+28>>2];c[h+96>>2]=c[d+32>>2];c[h+100>>2]=c[d+36>>2];c[h+104>>2]=c[d+40>>2];c[h+108>>2]=c[d+44>>2];c[h+112>>2]=c[d+48>>2];c[h+116>>2]=c[d+52>>2];c[h+120>>2]=c[d+56>>2];c[h+124>>2]=c[d+60>>2];c[h+128>>2]=c[e+0>>2];c[h+132>>2]=c[e+4>>2];c[h+136>>2]=c[e+8>>2];c[h+140>>2]=c[e+12>>2];c[h+144>>2]=c[e+16>>2];c[h+148>>2]=c[e+20>>2];c[h+152>>2]=c[e+24>>2];c[h+156>>2]=c[e+28>>2];c[h+160>>2]=c[e+32>>2];c[h+164>>2]=c[e+36>>2];c[h+168>>2]=c[e+40>>2];c[h+172>>2]=c[e+44>>2];c[h+176>>2]=c[e+48>>2];c[h+180>>2]=c[e+52>>2];c[h+184>>2]=c[e+56>>2];c[h+188>>2]=c[e+60>>2];nD(h+200|0,h+64|0,f,0,0);i=h;return}}function lD(b,d,e,f,h,j){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0;z=i;i=i+304|0;y=+g[e+48>>2]-+g[d+48>>2];w=+g[e+52>>2]-+g[d+52>>2];x=+g[e+56>>2]-+g[d+56>>2];Kp(d,e,z+240|0,z+112|0);r=+g[z+112>>2];p=+g[z+240>>2]*r;q=r*+g[z+244>>2];r=r*+g[z+248>>2];g[z+16>>2]=p;g[z+20>>2]=q;g[z+24>>2]=r;g[z+28>>2]=0.0;t=+g[h+48>>2]-+g[f+48>>2];u=+g[h+52>>2]-+g[f+52>>2];v=+g[h+56>>2]-+g[f+56>>2];Kp(f,h,z+240|0,z+112|0);n=+g[z+112>>2];l=+g[z+240>>2]*n;k=n*+g[z+244>>2];n=n*+g[z+248>>2];g[z+32>>2]=l;g[z+36>>2]=k;g[z+40>>2]=n;g[z+44>>2]=0.0;h=c[b+12>>2]|0;o=+Zb[c[(c[h>>2]|0)+16>>2]&15](h);h=c[b+16>>2]|0;if(!h)m=0.0;else m=+Zb[c[(c[h>>2]|0)+16>>2]&15](h);n=o*+P(+(p*p+q*q+r*r))+m*+P(+(l*l+k*k+n*n));if(n+ +P(+((t-y)*(t-y)+(u-w)*(u-w)+(v-x)*(v-x)))==0.0){j=0;i=z;return j|0}c[z+240>>2]=19288;g[z+276>>2]=999999984306749440.0;a[z+280>>0]=0;kD(b,d,f,z+240|0);h=(a[z+280>>0]|0)==0;c[z+288>>2]=c[z+260>>2];c[z+292>>2]=c[z+264>>2];c[z+296>>2]=c[z+268>>2];c[z+300>>2]=c[z+272>>2];if(h){j=0;i=z;return j|0}k=+g[z+244>>2];l=+g[z+248>>2];m=+g[z+252>>2];if(n+((t-y)*k+(u-w)*l+(v-x)*m)<=1.1920928955078125e-07){j=0;i=z;return j|0}q=+g[z+256>>2];p=+g[z+276>>2]+ +g[j+172>>2];o=0.0;s=0;while(1){if(!(p>1.0000000474974513e-03)){h=18;break}h=c[j+168>>2]|0;if(h){e=c[(c[h>>2]|0)+20>>2]|0;g[z>>2]=1.0;g[z+4>>2]=1.0;g[z+8>>2]=1.0;g[z+12>>2]=0.0;Ob[e&7](h,z+288|0,.20000000298023224,z)}l=n+((v-x)*m+((u-w)*l+(t-y)*k));if(l<=1.1920928955078125e-07){e=0;h=19;break}r=o+p/l;if(!(!(r<0.0)&!(r>1.0)&!(r<=o))){e=0;h=19;break}Jp(d,y,w,x,z+16|0,r,z+112|0);Jp(f,t,u,v,z+32|0,r,z+48|0);h=c[j+168>>2]|0;if(h){e=c[(c[h>>2]|0)+20>>2]|0;g[z+224>>2]=1.0;g[z+228>>2]=0.0;g[z+232>>2]=0.0;g[z+236>>2]=0.0;Ob[e&7](h,z+160|0,.20000000298023224,z+224|0)}Ib[c[c[j>>2]>>2]&31](j,r);c[z+176>>2]=19288;g[z+212>>2]=999999984306749440.0;a[z+216>>0]=0;kD(b,z+112|0,z+48|0,z+176|0);if(!(a[z+216>>0]|0)){h=16;break}p=+g[z+212>>2]+ +g[j+172>>2];c[z+288>>2]=c[z+196>>2];c[z+292>>2]=c[z+200>>2];c[z+296>>2]=c[z+204>>2];c[z+300>>2]=c[z+208>>2];e=s+1|0;if((s|0)>63){h=17;break}else{k=+g[z+180>>2];l=+g[z+184>>2];m=+g[z+188>>2];q=+g[z+192>>2];o=r;s=e}}if((h|0)==16){pc[c[(c[j>>2]|0)+8>>2]&127](j,-1,s);j=0;i=z;return j|0}else if((h|0)==17){pc[c[(c[j>>2]|0)+8>>2]&127](j,-2,e);j=0;i=z;return j|0}else if((h|0)==18){g[j+164>>2]=o;g[j+132>>2]=k;g[j+136>>2]=l;g[j+140>>2]=m;g[j+144>>2]=q;c[j+148>>2]=c[z+288>>2];c[j+152>>2]=c[z+292>>2];c[j+156>>2]=c[z+296>>2];c[j+160>>2]=c[z+300>>2];j=1;i=z;return j|0}else if((h|0)==19){i=z;return e|0}return 0}function mD(a){a=a|0;_E(a);return}function nD(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0,v=0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0,L=0.0,M=0.0,N=0.0,O=0;K=i;i=i+288|0;g[b+56>>2]=0.0;c[K+0>>2]=0;c[K+4>>2]=0;c[K+8>>2]=0;c[K+12>>2]=0;c[K+32>>2]=c[d+0>>2];c[K+36>>2]=c[d+4>>2];c[K+40>>2]=c[d+8>>2];c[K+44>>2]=c[d+12>>2];c[K+48>>2]=c[d+16>>2];c[K+52>>2]=c[d+20>>2];c[K+56>>2]=c[d+24>>2];c[K+60>>2]=c[d+28>>2];c[K+64>>2]=c[d+32>>2];c[K+68>>2]=c[d+36>>2];c[K+72>>2]=c[d+40>>2];c[K+76>>2]=c[d+44>>2];u=K+80|0;c[u+0>>2]=c[d+48>>2];c[u+4>>2]=c[d+52>>2];c[u+8>>2]=c[d+56>>2];c[u+12>>2]=c[d+60>>2];c[K+192>>2]=c[d+64>>2];c[K+196>>2]=c[d+68>>2];c[K+200>>2]=c[d+72>>2];c[K+204>>2]=c[d+76>>2];c[K+208>>2]=c[d+80>>2];c[K+212>>2]=c[d+84>>2];c[K+216>>2]=c[d+88>>2];c[K+220>>2]=c[d+92>>2];c[K+224>>2]=c[d+96>>2];c[K+228>>2]=c[d+100>>2];c[K+232>>2]=c[d+104>>2];c[K+236>>2]=c[d+108>>2];v=K+240|0;c[v+0>>2]=c[d+112>>2];c[v+4>>2]=c[d+116>>2];c[v+8>>2]=c[d+120>>2];c[v+12>>2]=c[d+124>>2];E=+g[u>>2];F=+g[v>>2];G=+g[K+84>>2];H=+g[K+244>>2];I=+g[K+88>>2];J=+g[K+248>>2];g[u>>2]=E-(E+F)*.5;g[K+84>>2]=G-(G+H)*.5;g[K+88>>2]=I-(I+J)*.5;g[v>>2]=F-(E+F)*.5;g[K+244>>2]=H-(G+H)*.5;g[K+248>>2]=J-(I+J)*.5;if(((c[(c[b+28>>2]|0)+4>>2]|0)+-17|0)>>>0<2)h=((c[(c[b+32>>2]|0)+4>>2]|0)+-17|0)>>>0<2;else h=0;C=+g[b+44>>2];D=+g[b+48>>2];c[4870]=(c[4870]|0)+1;v=(a[b+52>>0]|0)==0;D=v?D:0.0;c[b+64>>2]=0;g[b+4>>2]=0.0;g[b+8>>2]=1.0;g[b+12>>2]=0.0;g[b+16>>2]=0.0;c[b+68>>2]=0;c[b+60>>2]=-1;C=(v?C:0.0)+D;v=c[b+24>>2]|0;a[v+312>>0]=0;c[v>>2]=0;a[v+356>>0]=1;g[v+292>>2]=999999984306749440.0;g[v+296>>2]=999999984306749440.0;g[v+300>>2]=999999984306749440.0;g[v+304>>2]=0.0;c[v+336>>2]=0;c[v+340>>2]=0;c[v+344>>2]=0;c[v+348>>2]=0;a[v+352>>0]=0;a[v+332>>0]=a[v+332>>0]&-16;k=+g[b+4>>2];j=+g[b+8>>2];l=+g[b+12>>2];a:do if(h){m=j;z=999999984306749440.0;while(1){n=-k;t=-m;s=-l;r=+g[d+4>>2]*n+ +g[d+20>>2]*t+ +g[d+36>>2]*s;A=+g[d+8>>2]*n+ +g[d+24>>2]*t+ +g[d+40>>2]*s;g[K+112>>2]=+g[d>>2]*n+ +g[d+16>>2]*t+ +g[d+32>>2]*s;g[K+116>>2]=r;g[K+120>>2]=A;g[K+124>>2]=0.0;A=k*+g[d+68>>2]+m*+g[d+84>>2]+l*+g[d+100>>2];r=k*+g[d+72>>2]+m*+g[d+88>>2]+l*+g[d+104>>2];g[K+176>>2]=+g[d+64>>2]*k+ +g[d+80>>2]*m+ +g[d+96>>2]*l;g[K+180>>2]=A;g[K+184>>2]=r;g[K+188>>2]=0.0;Ky(K+256|0,c[b+28>>2]|0,K+112|0);Ky(K+272|0,c[b+32>>2]|0,K+176|0);r=+g[K+256>>2];A=+g[K+260>>2];s=+g[K+264>>2];t=r*+g[K+32>>2]+A*+g[K+36>>2]+s*+g[K+40>>2]+ +g[K+80>>2];s=r*+g[K+48>>2]+A*+g[K+52>>2]+s*+g[K+56>>2]+ +g[K+84>>2];A=+g[K+272>>2];r=+g[K+276>>2];n=+g[K+280>>2];p=A*+g[K+192>>2]+r*+g[K+196>>2]+n*+g[K+200>>2]+ +g[K+240>>2];n=A*+g[K+208>>2]+r*+g[K+212>>2]+n*+g[K+216>>2]+ +g[K+244>>2];r=+g[b+4>>2]*(t-p)+ +g[b+8>>2]*(s-n)+ +g[b+12>>2]*0.0;if(r>0.0?r*r>z*+g[d+128>>2]:0){j=z;O=22;break a}u=c[b+24>>2]|0;v=c[u>>2]|0;if((v|0)>0){q=+g[u+308>>2];o=0;h=0;do{x=t-p-+g[u+(h<<4)+4>>2];y=s-n-+g[u+(h<<4)+8>>2];A=0.0-+g[u+(h<<4)+12>>2];o=o|x*x+y*y+A*A<=q;h=h+1|0}while((h|0)!=(v|0))}else o=0;if((+g[u+304>>2]==0.0?+g[u+300>>2]==0.0:0)?s-n==+g[u+296>>2]:0)h=t-p==+g[u+292>>2];else h=0;if(h|o){j=z;O=31;break a}k=z-r;if(k<=z*9.999999974752427e-07){j=z;O=33;break a}g[u+292>>2]=t-p;g[u+296>>2]=s-n;g[u+300>>2]=0.0;g[u+304>>2]=0.0;a[u+356>>0]=1;g[u+(v<<4)+4>>2]=t-p;g[u+(v<<4)+8>>2]=s-n;g[u+(v<<4)+12>>2]=0.0;g[u+(v<<4)+16>>2]=0.0;v=c[u>>2]|0;g[u+(v<<4)+84>>2]=t;g[u+(v<<4)+88>>2]=s;g[u+(v<<4)+92>>2]=0.0;g[u+(v<<4)+96>>2]=0.0;v=c[u>>2]|0;g[u+(v<<4)+164>>2]=p;g[u+(v<<4)+168>>2]=n;g[u+(v<<4)+172>>2]=0.0;g[u+(v<<4)+176>>2]=0.0;c[u>>2]=(c[u>>2]|0)+1;u=c[b+24>>2]|0;v=zD(u)|0;k=+g[u+276>>2];m=+g[u+280>>2];l=+g[u+284>>2];n=+g[u+288>>2];if(!v){j=z;O=35;break a}j=z;z=k*k+m*m+l*l;if(z<9.999999974752427e-07){O=37;break a}if(j-z<=j*1.1920928955078125e-07){j=z;O=39;break a}g[b+4>>2]=k;g[b+8>>2]=m;g[b+12>>2]=l;g[b+16>>2]=n;v=c[b+64>>2]|0;c[b+64>>2]=v+1;if((v|0)>1e3){A=0.0;u=0;n=0.0;l=0.0;p=0.0;break a}if((c[c[b+24>>2]>>2]|0)==4){O=42;break}}}else{m=j;w=999999984306749440.0;while(1){x=-k;z=-m;t=-l;y=+g[d+4>>2]*x+ +g[d+20>>2]*z+ +g[d+36>>2]*t;A=+g[d+8>>2]*x+ +g[d+24>>2]*z+ +g[d+40>>2]*t;g[K+112>>2]=+g[d>>2]*x+ +g[d+16>>2]*z+ +g[d+32>>2]*t;g[K+116>>2]=y;g[K+120>>2]=A;g[K+124>>2]=0.0;A=k*+g[d+68>>2]+m*+g[d+84>>2]+l*+g[d+100>>2];y=k*+g[d+72>>2]+m*+g[d+88>>2]+l*+g[d+104>>2];g[K+176>>2]=+g[d+64>>2]*k+ +g[d+80>>2]*m+ +g[d+96>>2]*l;g[K+180>>2]=A;g[K+184>>2]=y;g[K+188>>2]=0.0;Ky(K+256|0,c[b+28>>2]|0,K+112|0);Ky(K+272|0,c[b+32>>2]|0,K+176|0);y=+g[K+256>>2];A=+g[K+260>>2];t=+g[K+264>>2];z=y*+g[K+32>>2]+A*+g[K+36>>2]+t*+g[K+40>>2]+ +g[K+80>>2];x=y*+g[K+48>>2]+A*+g[K+52>>2]+t*+g[K+56>>2]+ +g[K+84>>2];t=y*+g[K+64>>2]+A*+g[K+68>>2]+t*+g[K+72>>2]+ +g[K+88>>2];A=+g[K+272>>2];y=+g[K+276>>2];p=+g[K+280>>2];s=A*+g[K+192>>2]+y*+g[K+196>>2]+p*+g[K+200>>2]+ +g[K+240>>2];q=A*+g[K+208>>2]+y*+g[K+212>>2]+p*+g[K+216>>2]+ +g[K+244>>2];p=A*+g[K+224>>2]+y*+g[K+228>>2]+p*+g[K+232>>2]+ +g[K+248>>2];y=+g[b+4>>2]*(z-s)+ +g[b+8>>2]*(x-q)+ +g[b+12>>2]*(t-p);if(y>0.0?y*y>w*+g[d+128>>2]:0){j=w;O=22;break a}v=c[b+24>>2]|0;u=c[v>>2]|0;if((u|0)>0){r=+g[v+308>>2];h=0;o=0;do{m=z-s-+g[v+(o<<4)+4>>2];n=x-q-+g[v+(o<<4)+8>>2];A=t-p-+g[v+(o<<4)+12>>2];h=h|m*m+n*n+A*A<=r;o=o+1|0}while((o|0)!=(u|0))}else h=0;if((+g[v+304>>2]==0.0?t-p==+g[v+300>>2]:0)?x-q==+g[v+296>>2]:0)o=z-s==+g[v+292>>2];else o=0;if(o|h){j=w;O=31;break a}k=w-y;if(k<=w*9.999999974752427e-07){j=w;O=33;break a}g[v+292>>2]=z-s;g[v+296>>2]=x-q;g[v+300>>2]=t-p;g[v+304>>2]=0.0;a[v+356>>0]=1;g[v+(u<<4)+4>>2]=z-s;g[v+(u<<4)+8>>2]=x-q;g[v+(u<<4)+12>>2]=t-p;g[v+(u<<4)+16>>2]=0.0;u=c[v>>2]|0;g[v+(u<<4)+84>>2]=z;g[v+(u<<4)+88>>2]=x;g[v+(u<<4)+92>>2]=t;g[v+(u<<4)+96>>2]=0.0;u=c[v>>2]|0;g[v+(u<<4)+164>>2]=s;g[v+(u<<4)+168>>2]=q;g[v+(u<<4)+172>>2]=p;g[v+(u<<4)+176>>2]=0.0;c[v>>2]=(c[v>>2]|0)+1;u=c[b+24>>2]|0;v=zD(u)|0;k=+g[u+276>>2];m=+g[u+280>>2];l=+g[u+284>>2];n=+g[u+288>>2];if(!v){j=w;O=35;break a}j=w;w=k*k+m*m+l*l;if(w<9.999999974752427e-07){O=37;break a}if(j-w<=j*1.1920928955078125e-07){j=w;O=39;break a}g[b+4>>2]=k;g[b+8>>2]=m;g[b+12>>2]=l;g[b+16>>2]=n;v=c[b+64>>2]|0;c[b+64>>2]=v+1;if((v|0)>1e3){A=0.0;u=0;n=0.0;l=0.0;p=0.0;break a}if((c[c[b+24>>2]>>2]|0)==4){O=42;break}}}while(0);if((O|0)==22){c[b+68>>2]=10;O=43}else if((O|0)==31){c[b+68>>2]=1;O=43}else if((O|0)==33){c[b+68>>2]=!(k<=0.0)?11:2;O=43}else if((O|0)==35){c[b+68>>2]=3;O=43}else if((O|0)==37){g[b+4>>2]=k;g[b+8>>2]=m;g[b+12>>2]=l;g[b+16>>2]=n;c[b+68>>2]=6;O=43}else if((O|0)==39){c[b+68>>2]=12;O=43}else if((O|0)==42){c[b+68>>2]=13;A=0.0;u=0;n=0.0;l=0.0;p=0.0}do if((O|0)==43){v=c[b+24>>2]|0;zD(v)|0;n=+g[v+260>>2];l=+g[v+264>>2];p=+g[v+268>>2];c[K+0>>2]=c[b+4>>2];c[K+4>>2]=c[b+8>>2];c[K+8>>2]=c[b+12>>2];c[K+12>>2]=c[b+16>>2];m=+g[b+4>>2];k=+g[b+8>>2];q=+g[b+12>>2];if(m*m+k*k+q*q<.0001)c[b+68>>2]=5;if(m*m+k*k+q*q>1.4210854715202004e-14){A=1.0/+P(+(m*m+k*k+q*q));g[K>>2]=A*+g[K>>2];g[K+4>>2]=A*+g[K+4>>2];g[K+8>>2]=A*+g[K+8>>2];z=D/+P(+j);c[b+60>>2]=1;A=1.0/A-C;u=1;n=z*m+n;l=z*k+l;p=z*q+p;break}else{c[b+60>>2]=2;A=0.0;u=0;break}}while(0);if(((c[b+72>>2]|0)!=0?(c[b+20>>2]|0)!=0:0)?(c[b+68>>2]|0)!=0:0)h=C+A<.01;else h=0;v=u^1;do if(h|v?(B=c[b+20>>2]|0,(B|0)!=0):0){c[4868]=(c[4868]|0)+1;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;c[b+16>>2]=0;if(!(Mb[c[(c[B>>2]|0)+8>>2]&3](B,c[b+24>>2]|0,c[b+28>>2]|0,c[b+32>>2]|0,K+32|0,K+192|0,b+4|0,K+144|0,K+128|0,f)|0)){q=+g[b+4>>2];j=+g[b+8>>2];s=+g[b+12>>2];if(!(q*q+j*j+s*s>0.0)){O=66;break}k=+g[K+128>>2];y=+g[K+144>>2]-k;r=+g[K+132>>2];z=+g[K+148>>2]-r;t=+g[K+136>>2];m=+g[K+152>>2]-t;m=+P(+(y*y+z*z+m*m))-C;if(m<A|v){c[K+0>>2]=c[b+4>>2];c[K+4>>2]=c[b+8>>2];c[K+8>>2]=c[b+12>>2];c[K+12>>2]=c[b+16>>2];z=+g[K>>2];A=+g[K+4>>2];C=+g[K+8>>2];n=1.0/+P(+(z*z+A*A+C*C));g[K>>2]=z*n;g[K+4>>2]=A*n;g[K+8>>2]=C*n;c[b+60>>2]=6;n=D*q+k;k=D*j+r;j=D*s+t;break}c[b+60>>2]=5;if(u){m=A;k=l;j=p;break}i=K;return}z=+g[K+128>>2];q=+g[K+144>>2];k=+g[K+132>>2];m=+g[K+148>>2];j=+g[K+136>>2];s=+g[K+152>>2];if(!((z-q)*(z-q)+(k-m)*(k-m)+(j-s)*(j-s)<=1.4210854715202004e-14)){t=j-s;w=k-m;x=z-q;y=0.0;r=(z-q)*(z-q)+(k-m)*(k-m)+(j-s)*(j-s)}else{C=+g[b+4>>2];D=+g[b+8>>2];r=+g[b+12>>2];t=r;w=D;x=C;y=+g[b+16>>2];r=C*C+D*D+r*r}if(!(r>1.4210854715202004e-14)){c[b+60>>2]=9;if(u){m=A;k=l;j=p;break}i=K;return}r=1.0/+P(+r);m=-+P(+((q-z)*(q-z)+(m-k)*(m-k)+(s-j)*(s-j)));if(A>m|v){g[K>>2]=x*r;g[K+4>>2]=w*r;g[K+8>>2]=t*r;g[K+12>>2]=y;c[b+60>>2]=3;n=z;break}c[b+60>>2]=8;if(u){m=A;k=l;j=p}else{i=K;return}}else O=66;while(0);if((O|0)==66)if(u){m=A;k=l;j=p}else{i=K;return}if(!(m<0.0)?!(m*m<+g[d+128>>2]):0){i=K;return}if((c[b+76>>2]|0)!=0?(O=c[b+28>>2]|0,tc[c[(c[O>>2]|0)+8>>2]&127](O,K+32|0,K+96|0,K+16|0),A=(+g[K+16>>2]+ +g[K+96>>2])*.5,C=(+g[K+20>>2]+ +g[K+100>>2])*.5,D=(+g[K+24>>2]+ +g[K+104>>2])*.5,O=c[b+32>>2]|0,tc[c[(c[O>>2]|0)+8>>2]&127](O,K+192|0,K+96|0,K+16|0),L=+g[K>>2],M=+g[K+4>>2],N=+g[K+8>>2],(A-(+g[K+96>>2]+ +g[K+16>>2])*.5)*L+(C-(+g[K+100>>2]+ +g[K+20>>2])*.5)*M+(D-(+g[K+104>>2]+ +g[K+24>>2])*.5)*N<0.0):0){g[K>>2]=-L;g[K+4>>2]=-M;g[K+8>>2]=-N};c[b+4>>2]=c[K+0>>2];c[b+8>>2]=c[K+4>>2];c[b+12>>2]=c[K+8>>2];c[b+16>>2]=c[K+12>>2];g[b+56>>2]=m;O=c[(c[e>>2]|0)+16>>2]|0;g[K+160>>2]=(E+F)*.5+n;g[K+164>>2]=(G+H)*.5+k;g[K+168>>2]=(I+J)*.5+j;g[K+172>>2]=0.0;oc[O&15](e,K,K+160|0,m);i=K;return}function oD(a){a=a|0;_E(a);return}function pD(a){a=a|0;return}function qD(b,e,f){b=b|0;e=e|0;f=f|0;var h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0,p=0,q=0,r=0.0,s=0.0,t=0,u=0.0,v=0,w=0.0,x=0,y=0,z=0.0,A=0,B=0,C=0.0,D=0.0,E=0.0,F=0.0,G=0;B=i;i=i+176|0;c[b+348>>2]=b+220;c[b+352>>2]=b+252;c[b+356>>2]=b+284;c[b+360>>2]=b+316;c[b+364>>2]=4;c[b+368>>2]=0;c[b+376>>2]=0;x=c[e+4>>2]|0;c[b>>2]=c[e>>2];c[b+4>>2]=x;c[b+8>>2]=c[e+8>>2];c[b+12>>2]=c[e+12>>2];c[b+16>>2]=c[e+16>>2];c[b+20>>2]=c[e+20>>2];c[b+24>>2]=c[e+24>>2];c[b+28>>2]=c[e+28>>2];c[b+32>>2]=c[e+32>>2];c[b+36>>2]=c[e+36>>2];c[b+40>>2]=c[e+40>>2];c[b+44>>2]=c[e+44>>2];c[b+48>>2]=c[e+48>>2];c[b+52>>2]=c[e+52>>2];c[b+56>>2]=c[e+56>>2];c[b+60>>2]=c[e+60>>2];c[b+64>>2]=c[e+64>>2];c[b+68>>2]=c[e+68>>2];c[b+72>>2]=c[e+72>>2];c[b+76>>2]=c[e+76>>2];c[b+80>>2]=c[e+80>>2];c[b+84>>2]=c[e+84>>2];c[b+88>>2]=c[e+88>>2];c[b+92>>2]=c[e+92>>2];c[b+96>>2]=c[e+96>>2];c[b+100>>2]=c[e+100>>2];c[b+104>>2]=c[e+104>>2];c[b+108>>2]=c[e+108>>2];c[b+112>>2]=c[e+112>>2];c[b+116>>2]=c[e+116>>2];x=d[e+120>>0]|d[e+121>>0]<<8|d[e+122>>0]<<16|d[e+123>>0]<<24;y=d[e+124>>0]|d[e+125>>0]<<8|d[e+126>>0]<<16|d[e+127>>0]<<24;a[b+120>>0]=x;a[b+121>>0]=x>>8;a[b+122>>0]=x>>16;a[b+123>>0]=x>>24;a[b+124>>0]=y;a[b+125>>0]=y>>8;a[b+126>>0]=y>>16;a[b+127>>0]=y>>24;g[b+144>>2]=0.0;c[b+180>>2]=0;c[b+128>>2]=c[f+0>>2];c[b+132>>2]=c[f+4>>2];c[b+136>>2]=c[f+8>>2];c[b+140>>2]=c[f+12>>2];l=+g[b+128>>2];m=+g[b+132>>2];n=+g[b+136>>2];if(l*l+m*m+n*n>0.0){h=-n;j=-m;k=-l}else{h=0.0;j=0.0;k=1.0}g[b+164>>2]=0.0;c[b+364>>2]=3;c[b+148>>2]=b+316;c[b+180>>2]=1;sD(b,k,j,h,b+316|0);g[b+164>>2]=1.0;x=(c[b+148>>2]|0)+16|0;c[b+128>>2]=c[x+0>>2];c[b+132>>2]=c[x+4>>2];c[b+136>>2]=c[x+8>>2];c[b+140>>2]=c[x+12>>2];c[B+64>>2]=c[x+0>>2];c[B+68>>2]=c[x+4>>2];c[B+72>>2]=c[x+8>>2];c[B+76>>2]=c[x+12>>2];c[B+48>>2]=c[x+0>>2];c[B+52>>2]=c[x+4>>2];c[B+56>>2]=c[x+8>>2];c[B+60>>2]=c[x+12>>2];c[B+32>>2]=c[x+0>>2];c[B+36>>2]=c[x+4>>2];c[B+40>>2]=c[x+8>>2];c[B+44>>2]=c[x+12>>2];c[B+16>>2]=c[x+0>>2];c[B+20>>2]=c[x+4>>2];c[B+24>>2]=c[x+8>>2];c[B+28>>2]=c[x+12>>2];w=0.0;x=0;y=0;j=l*l+m*m+n*n;a:while(1){v=c[b+368>>2]|0;n=+g[b+128>>2];m=+g[b+132>>2];l=+g[b+136>>2];k=+P(+(n*n+m*m+l*l));if(k<9.999999747378752e-05){A=5;break}g[b+(v*36|0)+(c[b+(v*36|0)+180>>2]<<2)+164>>2]=0.0;p=(c[b+364>>2]|0)+-1|0;c[b+364>>2]=p;c[b+(v*36|0)+(c[b+(v*36|0)+180>>2]<<2)+148>>2]=c[b+(p<<2)+348>>2];p=c[b+(v*36|0)+180>>2]|0;c[b+(v*36|0)+180>>2]=p+1;sD(b,-n,-m,-l,c[b+(v*36|0)+(p<<2)+148>>2]|0);p=c[b+(v*36|0)+180>>2]|0;o=c[b+(v*36|0)+(p+-1<<2)+148>>2]|0;n=+g[o+16>>2];m=+g[o+20>>2];l=+g[o+24>>2];e=0;do{u=n-+g[B+16+(e<<4)>>2];r=m-+g[B+16+(e<<4)+4>>2];s=l-+g[B+16+(e<<4)+8>>2];e=e+1|0;if(u*u+r*r+s*s<9.999999747378752e-05){A=9;break a}}while(e>>>0<4);x=x+1&3;t=B+16+(x<<4)|0;c[t+0>>2]=c[o+16>>2];c[t+4>>2]=c[o+20>>2];c[t+8>>2]=c[o+24>>2];c[t+12>>2]=c[o+28>>2];s=(+g[b+128>>2]*n+ +g[b+132>>2]*m+ +g[b+136>>2]*l)/k;w=s>w?s:w;if(k-w-k*9.999999747378752e-05<=0.0){A=11;break}c[B+96>>2]=0;if((p|0)==3)n=+wD((c[b+(v*36|0)+148>>2]|0)+16|0,(c[b+(v*36|0)+152>>2]|0)+16|0,(c[b+(v*36|0)+156>>2]|0)+16|0,B,B+96|0);else if((p|0)==4){e=c[b+(v*36|0)+148>>2]|0;q=c[b+(v*36|0)+152>>2]|0;f=c[b+(v*36|0)+156>>2]|0;t=c[b+(v*36|0)+160>>2]|0;c[B+80>>2]=e+16;c[B+84>>2]=q+16;c[B+88>>2]=f+16;c[B+92>>2]=t+16;l=+g[e+16>>2];k=+g[t+16>>2];n=+g[e+20>>2];j=+g[t+20>>2];m=+g[e+24>>2];h=+g[t+24>>2];g[B+104>>2]=l-k;g[B+108>>2]=n-j;g[B+112>>2]=m-h;g[B+116>>2]=0.0;C=+g[q+16>>2];E=+g[q+20>>2];s=+g[q+24>>2];g[B+120>>2]=C-k;g[B+124>>2]=E-j;g[B+128>>2]=s-h;g[B+132>>2]=0.0;r=+g[f+16>>2];F=+g[f+20>>2];D=+g[f+24>>2];g[B+136>>2]=r-k;g[B+140>>2]=F-j;g[B+144>>2]=D-h;g[B+148>>2]=0.0;u=(n-j)*(s-h)*(r-k)+(m-h)*(C-k)*(F-j)-(F-j)*((s-h)*(l-k))-(n-j)*(C-k)*(D-h)+(D-h)*((l-k)*(E-j))-(r-k)*((m-h)*(E-j));if(!(!(u*(m*((C-r)*(n-E)-(E-F)*(l-C))+(l*((E-F)*(m-s)-(s-D)*(n-E))+n*((s-D)*(l-C)-(C-r)*(m-s))))<=0.0)|(u!=u|0.0!=0.0|u==0.0))){c[B+152>>2]=0;c[B+156>>2]=0;c[B+160>>2]=0;c[B+164>>2]=0;s=n-j;r=m-h;m=l-k;p=0;n=-1.0;while(1){o=c[19616+(p<<2)>>2]|0;l=+g[B+104+(o<<4)+8>>2];C=+g[B+104+(o<<4)+4>>2];D=+g[B+104+(o<<4)>>2];if(u*((s*l-r*C)*k+j*(r*D-l*m)+(C*m-s*D)*h)>0.0?(z=+wD(c[B+80+(p<<2)>>2]|0,c[B+80+(o<<2)>>2]|0,t+16|0,B+152|0,B+164|0),n<0.0|z<n):0){G=c[B+164>>2]|0;c[B+96>>2]=((G&2|0)==0?0:1<<o)+(G<<1&8)+((G&1|0)==0?0:1<<p);g[B+(p<<2)>>2]=+g[B+152>>2];g[B+(o<<2)>>2]=+g[B+156>>2];g[B+(c[19616+(o<<2)>>2]<<2)>>2]=0.0;g[B+12>>2]=+g[B+160>>2];n=z}p=p+1|0;if((p|0)==3)break;s=+g[B+104+(p<<4)+4>>2];r=+g[B+104+(p<<4)+8>>2];m=+g[B+104+(p<<4)>>2];k=+g[t+16>>2];j=+g[t+20>>2];h=+g[t+24>>2]}if(n<0.0){c[B+96>>2]=15;n=+g[f+20>>2];h=+g[q+24>>2];C=+g[t+16>>2];k=+g[f+24>>2];E=+g[q+16>>2];F=+g[t+20>>2];m=+g[f+16>>2];r=+g[t+24>>2];j=+g[q+20>>2];g[B>>2]=(n*h*C+k*E*F-F*(h*m)-n*E*r+r*(m*j)-C*(k*j))/u;l=+g[e+20>>2];D=+g[e+24>>2];s=+g[e+16>>2];g[B+4>>2]=(l*k*C+D*m*F-F*(k*s)-l*m*r+r*(s*n)-C*(D*n))/u;g[B+8>>2]=(j*D*C+h*s*F-F*(D*E)-j*s*r+r*(E*l)-C*(h*l))/u;g[B+12>>2]=1.0-((j*D*C+h*s*F-F*(D*E)-j*s*r+r*(E*l)-C*(h*l))/u+((n*h*C+k*E*F-F*(h*m)-n*E*r+r*(m*j)-C*(k*j))/u+(l*k*C+D*m*F-F*(k*s)-l*m*r+r*(s*n)-C*(D*n))/u));n=0.0}}else n=-1.0}else if((p|0)==2)n=+xD((c[b+(v*36|0)+148>>2]|0)+16|0,(c[b+(v*36|0)+152>>2]|0)+16|0,B,B+96|0);else n=j;if(!(n>=0.0)){A=32;break}c[b+((1-v|0)*36|0)+180>>2]=0;c[b+128>>2]=0;c[b+132>>2]=0;c[b+136>>2]=0;c[b+140>>2]=0;c[b+368>>2]=1-v;e=c[b+(v*36|0)+180>>2]|0;f=c[B+96>>2]|0;if(e){q=0;do{o=b+(v*36|0)+(q<<2)+148|0;p=c[o>>2]|0;if(!(f&1<<q)){G=c[b+364>>2]|0;c[b+364>>2]=G+1;c[b+(G<<2)+348>>2]=p}else{c[b+((1-v|0)*36|0)+(c[b+((1-v|0)*36|0)+180>>2]<<2)+148>>2]=p;s=+g[B+(q<<2)>>2];G=c[b+((1-v|0)*36|0)+180>>2]|0;c[b+((1-v|0)*36|0)+180>>2]=G+1;g[b+((1-v|0)*36|0)+(G<<2)+164>>2]=s;G=c[o>>2]|0;C=s*+g[G+20>>2];D=s*+g[G+24>>2];g[b+128>>2]=+g[G+16>>2]*s+ +g[b+128>>2];g[b+132>>2]=C+ +g[b+132>>2];g[b+136>>2]=D+ +g[b+136>>2]}q=q+1|0}while((q|0)!=(e|0))}if((f|0)==15)c[b+376>>2]=1;y=y+1|0;if(y>>>0>=128){A=34;break}if(c[b+376>>2]|0)break;else j=n}if((A|0)==5)c[b+376>>2]=1;else if((A|0)==9){G=c[b+368>>2]|0;y=(c[b+(G*36|0)+180>>2]|0)+-1|0;c[b+(G*36|0)+180>>2]=y;y=c[b+(G*36|0)+(y<<2)+148>>2]|0;G=c[b+364>>2]|0;c[b+364>>2]=G+1;c[b+(G<<2)+348>>2]=y}else if((A|0)==11){G=c[b+368>>2]|0;y=(c[b+(G*36|0)+180>>2]|0)+-1|0;c[b+(G*36|0)+180>>2]=y;y=c[b+(G*36|0)+(y<<2)+148>>2]|0;G=c[b+364>>2]|0;c[b+364>>2]=G+1;c[b+(G<<2)+348>>2]=y}else if((A|0)==32){G=c[b+368>>2]|0;y=(c[b+(G*36|0)+180>>2]|0)+-1|0;c[b+(G*36|0)+180>>2]=y;y=c[b+(G*36|0)+(y<<2)+148>>2]|0;G=c[b+364>>2]|0;c[b+364>>2]=G+1;c[b+(G<<2)+348>>2]=y}else if((A|0)==34)c[b+376>>2]=2;c[b+372>>2]=b+((c[b+368>>2]|0)*36|0)+148;f=c[b+376>>2]|0;if(!f){z=+g[b+128>>2];C=+g[b+132>>2];D=+g[b+136>>2];g[b+144>>2]=+P(+(z*z+C*C+D*D));i=B;return f|0}else if((f|0)==1){g[b+144>>2]=0.0;i=B;return f|0}else{i=B;return f|0}return 0}function rD(b,e,f,h,i,j){b=b|0;e=e|0;f=f|0;h=h|0;i=i|0;j=j|0;var k=0,l=0;if((d[h+55>>0]|0|0)==(e|0)){h=0;return h|0}k=c[19616+(i<<2)>>2]|0;if(+g[h>>2]*+g[f+16>>2]+ +g[h+4>>2]*+g[f+20>>2]+ +g[h+8>>2]*+g[f+24>>2]-+g[h+16>>2]<-9.999999747378752e-06){l=tD(b,c[h+(k<<2)+20>>2]|0,c[h+(i<<2)+20>>2]|0,f,0)|0;if(!l){h=0;return h|0}a[l+52>>0]=i;c[l+32>>2]=h;a[h+i+52>>0]=0;c[h+(i<<2)+32>>2]=l;k=c[j>>2]|0;if(!k)c[j+4>>2]=l;else{a[k+53>>0]=2;c[k+36>>2]=l;a[l+54>>0]=1;c[l+40>>2]=k}c[j>>2]=l;c[j+8>>2]=(c[j+8>>2]|0)+1;h=1;return h|0}l=c[19600+(i<<2)>>2]|0;a[h+55>>0]=e;if(!(rD(b,e,f,c[h+(k<<2)+32>>2]|0,d[h+k+52>>0]|0,j)|0)){h=0;return h|0}if(!(rD(b,e,f,c[h+(l<<2)+32>>2]|0,d[h+l+52>>0]|0,j)|0)){h=0;return h|0}k=c[h+48>>2]|0;if(k)c[k+44>>2]=c[h+44>>2];k=c[h+44>>2]|0;if(k)c[k+48>>2]=c[h+48>>2];if((c[b+9280>>2]|0)==(h|0))c[b+9280>>2]=c[h+48>>2];c[b+9284>>2]=(c[b+9284>>2]|0)+-1;c[h+44>>2]=0;c[h+48>>2]=c[b+9288>>2];k=c[b+9288>>2]|0;if(k)c[k+44>>2]=h;c[b+9288>>2]=h;c[b+9292>>2]=(c[b+9292>>2]|0)+1;h=1;return h|0}function sD(a,b,e,f,h){a=a|0;b=+b;e=+e;f=+f;h=h|0;var j=0,k=0,l=0,m=0,n=0.0,o=0.0;l=i;i=i+48|0;n=1.0/+P(+(b*b+e*e+f*f));g[h>>2]=n*b;g[h+4>>2]=n*e;g[h+8>>2]=n*f;g[h+12>>2]=0.0;j=d[a+120>>0]|d[a+121>>0]<<8|d[a+122>>0]<<16|d[a+123>>0]<<24;m=d[a+124>>0]|d[a+125>>0]<<8|d[a+126>>0]<<16|d[a+127>>0]<<24;k=(c[a>>2]|0)+(m>>1)|0;if(m&1)j=c[(c[k>>2]|0)+j>>2]|0;pc[j&127](l,k,h);f=-+g[h>>2];e=-+g[h+4>>2];b=-+g[h+8>>2];k=d[a+120>>0]|d[a+121>>0]<<8|d[a+122>>0]<<16|d[a+123>>0]<<24;m=d[a+124>>0]|d[a+125>>0]<<8|d[a+126>>0]<<16|d[a+127>>0]<<24;j=(c[a+4>>2]|0)+(m>>1)|0;if(m&1)k=c[(c[j>>2]|0)+k>>2]|0;n=+g[a+24>>2]*f+ +g[a+28>>2]*e+ +g[a+32>>2]*b;o=+g[a+40>>2]*f+ +g[a+44>>2]*e+ +g[a+48>>2]*b;g[l+16>>2]=+g[a+8>>2]*f+ +g[a+12>>2]*e+ +g[a+16>>2]*b;g[l+20>>2]=n;g[l+24>>2]=o;g[l+28>>2]=0.0;pc[k&127](l+32|0,j,l+16|0);o=+g[l+32>>2];b=+g[l+36>>2];e=+g[l+40>>2];f=+g[l+4>>2]-(o*+g[a+72>>2]+b*+g[a+76>>2]+e*+g[a+80>>2]+ +g[a+108>>2]);n=+g[l+8>>2]-(o*+g[a+88>>2]+b*+g[a+92>>2]+e*+g[a+96>>2]+ +g[a+112>>2]);g[h+16>>2]=+g[l>>2]-(o*+g[a+56>>2]+b*+g[a+60>>2]+e*+g[a+64>>2]+ +g[a+104>>2]);g[h+20>>2]=f;g[h+24>>2]=n;g[h+28>>2]=0.0;i=l;return}function tD(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0;q=c[b+9288>>2]|0;if(!q){c[b>>2]=5;b=0;return b|0}i=c[q+48>>2]|0;if(i)c[i+44>>2]=c[q+44>>2];i=c[q+44>>2]|0;if(i)c[i+48>>2]=c[q+48>>2];if((c[b+9288>>2]|0)==(q|0))c[b+9288>>2]=c[q+48>>2];c[b+9292>>2]=(c[b+9292>>2]|0)+-1;c[q+44>>2]=0;c[q+48>>2]=c[b+9280>>2];i=c[b+9280>>2]|0;if(i)c[i+44>>2]=q;c[b+9280>>2]=q;c[b+9284>>2]=(c[b+9284>>2]|0)+1;a[q+55>>0]=0;c[q+20>>2]=d;c[q+24>>2]=e;c[q+28>>2]=f;m=+g[d+16>>2];j=+g[e+16>>2]-m;n=+g[d+20>>2];k=+g[e+20>>2]-n;o=+g[d+24>>2];l=+g[e+24>>2]-o;m=+g[f+16>>2]-m;n=+g[f+20>>2]-n;o=+g[f+24>>2]-o;g[q>>2]=k*o-l*n;g[q+4>>2]=l*m-j*o;g[q+8>>2]=j*n-k*m;g[q+12>>2]=0.0;p=+P(+((k*o-l*n)*(k*o-l*n)+(l*m-j*o)*(l*m-j*o)+(j*n-k*m)*(j*n-k*m)));do if(p>9.999999747378752e-05){if((!(uD(k*o-l*n,l*m-j*o,j*n-k*m,+g[d+16>>2],+g[d+20>>2],+g[d+24>>2],+g[e+16>>2],+g[e+20>>2],+g[e+24>>2],q+16|0)|0)?!(uD(+g[q>>2],+g[q+4>>2],+g[q+8>>2],+g[e+16>>2],+g[e+20>>2],+g[e+24>>2],+g[f+16>>2],+g[f+20>>2],+g[f+24>>2],q+16|0)|0):0)?!(uD(+g[q>>2],+g[q+4>>2],+g[q+8>>2],+g[f+16>>2],+g[f+20>>2],+g[f+24>>2],+g[d+16>>2],+g[d+20>>2],+g[d+24>>2],q+16|0)|0):0)g[q+16>>2]=(+g[d+16>>2]*+g[q>>2]+ +g[d+20>>2]*+g[q+4>>2]+ +g[d+24>>2]*+g[q+8>>2])/p;g[q>>2]=1.0/p*+g[q>>2];g[q+4>>2]=1.0/p*+g[q+4>>2];g[q+8>>2]=1.0/p*+g[q+8>>2];if(h){b=q;return b|0}if(!(+g[q+16>>2]>=-9.999999747378752e-06)){c[b>>2]=3;break}else{b=q;return b|0}}else c[b>>2]=2;while(0);i=c[q+48>>2]|0;if(i)c[i+44>>2]=c[q+44>>2];i=c[q+44>>2]|0;if(i)c[i+48>>2]=c[q+48>>2];if((c[b+9280>>2]|0)==(q|0))c[b+9280>>2]=c[q+48>>2];c[b+9284>>2]=(c[b+9284>>2]|0)+-1;c[q+44>>2]=0;c[q+48>>2]=c[b+9288>>2];i=c[b+9288>>2]|0;if(i)c[i+44>>2]=q;c[b+9288>>2]=q;c[b+9292>>2]=(c[b+9292>>2]|0)+1;b=0;return b|0}function uD(a,b,c,d,e,f,h,i,j,k){a=+a;b=+b;c=+c;d=+d;e=+e;f=+f;h=+h;i=+i;j=+j;k=k|0;if(!(((h-d)*b-(i-e)*a)*f+(((i-e)*c-(j-f)*b)*d+((j-f)*a-(h-d)*c)*e)<0.0)){k=0;return k|0}if((h-d)*d+(i-e)*e+(j-f)*f>0.0){g[k>>2]=+P(+(d*d+e*e+f*f));k=1;return k|0}if((h-d)*h+(i-e)*i+(j-f)*j<0.0){g[k>>2]=+P(+(h*h+i*i+j*j));k=1;return k|0}else{c=((h*h+i*i+j*j)*(d*d+e*e+f*f)-(h*d+i*e+j*f)*(h*d+i*e+j*f))/((h-d)*(h-d)+(i-e)*(i-e)+(j-f)*(j-f));g[k>>2]=+P(+(c>0.0?c:0.0));k=1;return k|0}return 0}function vD(a){a=a|0;var b=0,d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0,n=0,o=0,p=0.0,q=0.0,r=0.0;n=i;i=i+32|0;m=c[a+372>>2]|0;d=c[m+32>>2]|0;a:do if((d|0)==1){b=1;d=0;while(1){c[n+16>>2]=0;c[n+20>>2]=0;c[n+24>>2]=0;c[n+28>>2]=0;g[n+16+(d<<2)>>2]=1.0;o=m+32|0;g[m+(b<<2)+16>>2]=0.0;b=(c[a+364>>2]|0)+-1|0;c[a+364>>2]=b;c[m+(c[o>>2]<<2)>>2]=c[a+(b<<2)+348>>2];b=c[o>>2]|0;c[o>>2]=b+1;e=+g[n+16>>2];f=+g[n+20>>2];h=+g[n+24>>2];sD(a,e,f,h,c[m+(b<<2)>>2]|0);if(vD(a)|0){b=1;d=19;break}o=c[a+372>>2]|0;m=(c[o+32>>2]|0)+-1|0;c[o+32>>2]=m;m=c[o+(m<<2)>>2]|0;o=c[a+364>>2]|0;c[a+364>>2]=o+1;c[a+(o<<2)+348>>2]=m;o=c[a+372>>2]|0;g[o+(c[o+32>>2]<<2)+16>>2]=0.0;m=(c[a+364>>2]|0)+-1|0;c[a+364>>2]=m;c[o+(c[o+32>>2]<<2)>>2]=c[a+(m<<2)+348>>2];m=c[o+32>>2]|0;c[o+32>>2]=m+1;sD(a,-e,-f,-h,c[o+(m<<2)>>2]|0);if(vD(a)|0){b=1;d=19;break}m=c[a+372>>2]|0;o=(c[m+32>>2]|0)+-1|0;c[m+32>>2]=o;o=c[m+(o<<2)>>2]|0;m=c[a+364>>2]|0;c[a+364>>2]=m+1;c[a+(m<<2)+348>>2]=o;d=d+1|0;if(d>>>0>=3)break a;m=c[a+372>>2]|0;b=c[m+32>>2]|0}if((d|0)==19){i=n;return b|0}}else if((d|0)==4){a=c[m>>2]|0;d=c[m+12>>2]|0;l=+g[d+16>>2];r=+g[a+16>>2]-l;p=+g[d+20>>2];e=+g[a+20>>2]-p;h=+g[d+24>>2];j=+g[a+24>>2]-h;a=c[m+4>>2]|0;f=+g[a+16>>2]-l;k=+g[a+20>>2]-p;q=+g[a+24>>2]-h;a=c[m+8>>2]|0;l=+g[a+16>>2]-l;p=+g[a+20>>2]-p;h=+g[a+24>>2]-h;if(!((0.0!=0.0?1:r*k*h+(e*q*l+j*f*p-r*q*p-e*f*h)-j*k*l!=r*k*h+(e*q*l+j*f*p-r*q*p-e*f*h)-j*k*l)|r*k*h+(e*q*l+j*f*p-r*q*p-e*f*h)-j*k*l==0.0)){a=1;i=n;return a|0}}else if((d|0)==3){d=c[m+4>>2]|0;o=c[m>>2]|0;j=+g[o+16>>2];h=+g[d+16>>2]-j;k=+g[o+20>>2];f=+g[d+20>>2]-k;l=+g[o+24>>2];e=+g[d+24>>2]-l;d=c[m+8>>2]|0;j=+g[d+16>>2]-j;k=+g[d+20>>2]-k;l=+g[d+24>>2]-l;if((f*l-e*k)*(f*l-e*k)+(e*j-h*l)*(e*j-h*l)+(h*k-f*j)*(h*k-f*j)>0.0){g[m+28>>2]=0.0;d=(c[a+364>>2]|0)+-1|0;c[a+364>>2]=d;c[m+12>>2]=c[a+(d<<2)+348>>2];d=c[m+32>>2]|0;c[m+32>>2]=d+1;sD(a,f*l-e*k,e*j-h*l,h*k-f*j,c[m+(d<<2)>>2]|0);if(vD(a)|0){a=1;i=n;return a|0}d=c[a+372>>2]|0;m=(c[d+32>>2]|0)+-1|0;c[d+32>>2]=m;m=c[d+(m<<2)>>2]|0;d=c[a+364>>2]|0;c[a+364>>2]=d+1;c[a+(d<<2)+348>>2]=m;d=c[a+372>>2]|0;g[d+(c[d+32>>2]<<2)+16>>2]=0.0;m=(c[a+364>>2]|0)+-1|0;c[a+364>>2]=m;c[d+(c[d+32>>2]<<2)>>2]=c[a+(m<<2)+348>>2];m=c[d+32>>2]|0;c[d+32>>2]=m+1;sD(a,-(f*l-e*k),-(e*j-h*l),-(h*k-f*j),c[d+(m<<2)>>2]|0);if(vD(a)|0){a=1;i=n;return a|0}else{m=c[a+372>>2]|0;d=(c[m+32>>2]|0)+-1|0;c[m+32>>2]=d;d=c[m+(d<<2)>>2]|0;m=c[a+364>>2]|0;c[a+364>>2]=m+1;c[a+(m<<2)+348>>2]=d;break}}}else if((d|0)==2){d=c[m+4>>2]|0;m=c[m>>2]|0;l=+g[d+16>>2]-+g[m+16>>2];k=+g[d+20>>2]-+g[m+20>>2];j=+g[d+24>>2]-+g[m+24>>2];m=0;while(1){c[n+0>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;g[n+(m<<2)>>2]=1.0;h=+g[n+8>>2];f=+g[n+4>>2];e=+g[n>>2];if((k*h-j*f)*(k*h-j*f)+(j*e-l*h)*(j*e-l*h)+(l*f-k*e)*(l*f-k*e)>0.0){o=c[a+372>>2]|0;g[o+(c[o+32>>2]<<2)+16>>2]=0.0;d=(c[a+364>>2]|0)+-1|0;c[a+364>>2]=d;c[o+(c[o+32>>2]<<2)>>2]=c[a+(d<<2)+348>>2];d=c[o+32>>2]|0;c[o+32>>2]=d+1;sD(a,k*h-j*f,j*e-l*h,l*f-k*e,c[o+(d<<2)>>2]|0);if(vD(a)|0){b=1;d=19;break}o=c[a+372>>2]|0;d=(c[o+32>>2]|0)+-1|0;c[o+32>>2]=d;d=c[o+(d<<2)>>2]|0;o=c[a+364>>2]|0;c[a+364>>2]=o+1;c[a+(o<<2)+348>>2]=d;o=c[a+372>>2]|0;g[o+(c[o+32>>2]<<2)+16>>2]=0.0;d=(c[a+364>>2]|0)+-1|0;c[a+364>>2]=d;c[o+(c[o+32>>2]<<2)>>2]=c[a+(d<<2)+348>>2];d=c[o+32>>2]|0;c[o+32>>2]=d+1;sD(a,-(k*h-j*f),-(j*e-l*h),-(l*f-k*e),c[o+(d<<2)>>2]|0);if(vD(a)|0){b=1;d=19;break}d=c[a+372>>2]|0;o=(c[d+32>>2]|0)+-1|0;c[d+32>>2]=o;o=c[d+(o<<2)>>2]|0;d=c[a+364>>2]|0;c[a+364>>2]=d+1;c[a+(d<<2)+348>>2]=o}m=m+1|0;if(m>>>0>=3)break a}if((d|0)==19){i=n;return b|0}}while(0);a=0;i=n;return a|0}function wD(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0,C=0.0,D=0,E=0.0,F=0;F=i;i=i+80|0;c[F+64>>2]=a;c[F+68>>2]=b;c[F+72>>2]=d;n=+g[a>>2];q=+g[b>>2];v=+g[a+4>>2];C=+g[b+4>>2];k=+g[a+8>>2];l=+g[b+8>>2];g[F+16>>2]=n-q;g[F+20>>2]=v-C;g[F+24>>2]=k-l;g[F+28>>2]=0.0;m=+g[d>>2];o=+g[d+4>>2];p=+g[d+8>>2];g[F+32>>2]=q-m;g[F+36>>2]=C-o;g[F+40>>2]=l-p;g[F+44>>2]=0.0;g[F+48>>2]=m-n;g[F+52>>2]=o-v;g[F+56>>2]=p-k;g[F+60>>2]=0.0;r=(v-C)*(l-p)-(k-l)*(C-o);s=(k-l)*(q-m)-(l-p)*(n-q);t=(C-o)*(n-q)-(v-C)*(q-m);if(!(t*t+(r*r+s*s)>0.0)){E=-1.0;i=F;return +E}c[F>>2]=0;c[F+4>>2]=0;c[F+8>>2]=0;u=v-C;w=k-l;x=n-q;y=n;z=v;A=k;D=a;h=0;j=-1.0;while(1){if(y*(t*u-s*w)+z*(r*w-t*x)+(s*x-r*u)*A>0.0?(B=c[19616+(h<<2)>>2]|0,E=+xD(D,c[F+64+(B<<2)>>2]|0,F,F+8|0),j<0.0|E<j):0){D=c[F+8>>2]|0;c[f>>2]=((D&1|0)==0?0:1<<h)+((D&2|0)==0?0:1<<B);g[e+(h<<2)>>2]=+g[F>>2];g[e+(B<<2)>>2]=+g[F+4>>2];g[e+(c[19616+(B<<2)>>2]<<2)>>2]=0.0;j=E}h=h+1|0;if((h|0)==3)break;D=c[F+64+(h<<2)>>2]|0;u=+g[F+16+(h<<4)+4>>2];w=+g[F+16+(h<<4)+8>>2];x=+g[F+16+(h<<4)>>2];y=+g[D>>2];z=+g[D+4>>2];A=+g[D+8>>2]}if(!(j<0.0)){E=j;i=F;return +E}A=+P(+(t*t+(r*r+s*s)));E=(r*+g[a>>2]+s*+g[a+4>>2]+t*+g[a+8>>2])/(t*t+(r*r+s*s));c[f>>2]=7;x=+g[b>>2]-r*E;z=+g[b+4>>2]-s*E;y=+g[b+8>>2]-t*E;C=+P(+((z*(q-m)-x*(C-o))*(z*(q-m)-x*(C-o))+(((C-o)*y-z*(l-p))*((C-o)*y-z*(l-p))+(x*(l-p)-y*(q-m))*(x*(l-p)-y*(q-m)))))/A;g[e>>2]=C;y=+g[d>>2]-r*E;x=+g[d+4>>2]-s*E;z=+g[d+8>>2]-t*E;A=+P(+((x*(m-n)-y*(o-v))*(x*(m-n)-y*(o-v))+(((o-v)*z-x*(p-k))*((o-v)*z-x*(p-k))+(y*(p-k)-z*(m-n))*(y*(p-k)-z*(m-n)))))/A;g[e+4>>2]=A;g[e+8>>2]=1.0-(A+C);E=t*E*(t*E)+(r*E*(r*E)+s*E*(s*E));i=F;return +E}function xD(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0;f=+g[a>>2];k=+g[b>>2]-f;i=+g[a+4>>2];l=+g[b+4>>2]-i;h=+g[a+8>>2];j=+g[b+8>>2]-h;if(!(k*k+l*l+j*j>0.0)){l=-1.0;return +l}f=-(f*k+i*l+h*j)/(k*k+l*l+j*j);if(f>=1.0){g[d>>2]=0.0;g[d+4>>2]=1.0;c[e>>2]=2;j=+g[b>>2];k=+g[b+4>>2];l=+g[b+8>>2];l=j*j+k*k+l*l;return +l}if(!(f<=0.0)){g[d+4>>2]=f;g[d>>2]=1.0-f;c[e>>2]=3;i=k*f+ +g[a>>2];k=l*f+ +g[a+4>>2];l=j*f+ +g[a+8>>2];l=i*i+k*k+l*l;return +l}else{g[d>>2]=1.0;g[d+4>>2]=0.0;c[e>>2]=1;j=+g[a>>2];k=+g[a+4>>2];l=+g[a+8>>2];l=j*j+k*k+l*l;return +l}return 0.0}function yD(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;f=c[b>>2]|0;if((f|0)>3){e=a[d>>0]|0;if(!(e&8)){c[b>>2]=f+-1;g=b+(f+-1<<4)+4|0;c[b+52>>2]=c[g+0>>2];c[b+56>>2]=c[g+4>>2];c[b+60>>2]=c[g+8>>2];c[b+64>>2]=c[g+12>>2];g=b+(f+-1<<4)+84|0;c[b+132>>2]=c[g+0>>2];c[b+136>>2]=c[g+4>>2];c[b+140>>2]=c[g+8>>2];c[b+144>>2]=c[g+12>>2];g=b+(f+-1<<4)+164|0;c[b+212>>2]=c[g+0>>2];c[b+216>>2]=c[g+4>>2];c[b+220>>2]=c[g+8>>2];c[b+224>>2]=c[g+12>>2];f=f+-1|0;g=4}else g=6}else g=4;if((g|0)==4)if((f|0)>2){e=a[d>>0]|0;g=6}else e=f;if((g|0)==6)if(!(e&4)){e=f+-1|0;c[b>>2]=e;c[b+36>>2]=c[b+(e<<4)+4>>2];c[b+40>>2]=c[b+(e<<4)+8>>2];c[b+44>>2]=c[b+(e<<4)+12>>2];c[b+48>>2]=c[b+(e<<4)+16>>2];c[b+116>>2]=c[b+(e<<4)+84>>2];c[b+120>>2]=c[b+(e<<4)+88>>2];c[b+124>>2]=c[b+(e<<4)+92>>2];c[b+128>>2]=c[b+(e<<4)+96>>2];c[b+196>>2]=c[b+(e<<4)+164>>2];c[b+200>>2]=c[b+(e<<4)+168>>2];c[b+204>>2]=c[b+(e<<4)+172>>2];c[b+208>>2]=c[b+(e<<4)+176>>2]}else e=f;if((e|0)>1){f=a[d>>0]|0;if(!(f&2)){e=e+-1|0;c[b>>2]=e;c[b+20>>2]=c[b+(e<<4)+4>>2];c[b+24>>2]=c[b+(e<<4)+8>>2];c[b+28>>2]=c[b+(e<<4)+12>>2];c[b+32>>2]=c[b+(e<<4)+16>>2];c[b+100>>2]=c[b+(e<<4)+84>>2];c[b+104>>2]=c[b+(e<<4)+88>>2];c[b+108>>2]=c[b+(e<<4)+92>>2];c[b+112>>2]=c[b+(e<<4)+96>>2];c[b+180>>2]=c[b+(e<<4)+164>>2];c[b+184>>2]=c[b+(e<<4)+168>>2];c[b+188>>2]=c[b+(e<<4)+172>>2];c[b+192>>2]=c[b+(e<<4)+176>>2];g=11}}else g=11;do if((g|0)==11)if((e|0)>0){f=a[d>>0]|0;break}else return;while(0);if(f&1)return;g=e+-1|0;c[b>>2]=g;c[b+4>>2]=c[b+(g<<4)+4>>2];c[b+8>>2]=c[b+(g<<4)+8>>2];c[b+12>>2]=c[b+(g<<4)+12>>2];c[b+16>>2]=c[b+(g<<4)+16>>2];c[b+84>>2]=c[b+(g<<4)+84>>2];c[b+88>>2]=c[b+(g<<4)+88>>2];c[b+92>>2]=c[b+(g<<4)+92>>2];c[b+96>>2]=c[b+(g<<4)+96>>2];c[b+164>>2]=c[b+(g<<4)+164>>2];c[b+168>>2]=c[b+(g<<4)+168>>2];c[b+172>>2]=c[b+(g<<4)+172>>2];c[b+176>>2]=c[b+(g<<4)+176>>2];return}function zD(b){b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0,n=0,o=0,p=0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0,R=0.0,S=0.0,T=0.0,U=0;U=i;i=i+80|0;if(!(a[b+356>>0]|0)){Q=a[b+312>>0]|0;Q=Q<<24>>24!=0;i=U;return Q|0}c[b+336>>2]=0;c[b+340>>2]=0;c[b+344>>2]=0;c[b+348>>2]=0;a[b+352>>0]=0;d=a[b+332>>0]|0;a[b+332>>0]=d&-16;a[b+356>>0]=0;switch(c[b>>2]|0){case 0:{a[b+312>>0]=0;Q=0;Q=Q<<24>>24!=0;i=U;return Q|0}case 3:{c[U+16>>2]=0;c[U+20>>2]=0;c[U+24>>2]=0;c[U+28>>2]=0;AD(U+16|0,b+4|0,b+20|0,b+36|0,b+316|0);L=+g[b+336>>2];M=+g[b+340>>2];T=+g[b+344>>2];N=+g[b+84>>2]*L+ +g[b+100>>2]*M+ +g[b+116>>2]*T;P=L*+g[b+88>>2]+M*+g[b+104>>2]+T*+g[b+120>>2];S=L*+g[b+92>>2]+M*+g[b+108>>2]+T*+g[b+124>>2];g[b+244>>2]=N;g[b+248>>2]=P;g[b+252>>2]=S;g[b+256>>2]=0.0;O=+g[b+164>>2]*L+ +g[b+180>>2]*M+ +g[b+196>>2]*T;R=L*+g[b+168>>2]+M*+g[b+184>>2]+T*+g[b+200>>2];T=L*+g[b+172>>2]+M*+g[b+188>>2]+T*+g[b+204>>2];g[b+260>>2]=O;g[b+264>>2]=R;g[b+268>>2]=T;g[b+272>>2]=0.0;g[b+276>>2]=N-O;g[b+280>>2]=P-R;g[b+284>>2]=S-T;g[b+288>>2]=0.0;yD(b,b+332|0);if((+g[b+336>>2]>=0.0?+g[b+340>>2]>=0.0:0)?+g[b+344>>2]>=0.0:0)d=+g[b+348>>2]>=0.0&1;else d=0;a[b+312>>0]=d;Q=d;Q=Q<<24>>24!=0;i=U;return Q|0}case 4:{c[U+0>>2]=0;c[U+4>>2]=0;c[U+8>>2]=0;c[U+12>>2]=0;Q=U+48|0;a[Q>>0]=0;c[b+316>>2]=c[U+0>>2];c[b+320>>2]=c[U+4>>2];c[b+324>>2]=c[U+8>>2];c[b+328>>2]=c[U+12>>2];a[b+332>>0]=d|15;f=+g[b+20>>2];k=+g[b+4>>2];e=+g[b+24>>2];j=+g[b+8>>2];q=+g[b+28>>2];h=+g[b+12>>2];r=+g[b+36>>2];s=+g[b+40>>2];t=+g[b+44>>2];u=+g[b+52>>2];v=+g[b+56>>2];w=+g[b+60>>2];l=(u-k)*((e-j)*(t-h)-(q-h)*(s-j))+(v-j)*((q-h)*(r-k)-(f-k)*(t-h))+((f-k)*(s-j)-(e-j)*(r-k))*(w-h);if(l*l<9.99999905104687e-09)x=-1;else x=l*(((e-j)*(t-h)-(q-h)*(s-j))*(0.0-k)+((q-h)*(r-k)-(f-k)*(t-h))*(0.0-j)+((f-k)*(s-j)-(e-j)*(r-k))*(0.0-h))<0.0&1;l=(f-k)*((s-j)*(w-h)-(t-h)*(v-j))+(e-j)*((t-h)*(u-k)-(r-k)*(w-h))+((r-k)*(v-j)-(s-j)*(u-k))*(q-h);if(l*l<9.99999905104687e-09)o=-1;else o=l*(((s-j)*(w-h)-(t-h)*(v-j))*(0.0-k)+((t-h)*(u-k)-(r-k)*(w-h))*(0.0-j)+((r-k)*(v-j)-(s-j)*(u-k))*(0.0-h))<0.0&1;l=(r-k)*((v-j)*(q-h)-(w-h)*(e-j))+(s-j)*((w-h)*(f-k)-(u-k)*(q-h))+((u-k)*(e-j)-(v-j)*(f-k))*(t-h);if(l*l<9.99999905104687e-09)p=-1;else p=l*(((v-j)*(q-h)-(w-h)*(e-j))*(0.0-k)+((w-h)*(f-k)-(u-k)*(q-h))*(0.0-j)+((u-k)*(e-j)-(v-j)*(f-k))*(0.0-h))<0.0&1;l=(k-f)*((v-e)*(t-q)-(w-q)*(s-e))+(j-e)*((w-q)*(r-f)-(u-f)*(t-q))+((u-f)*(s-e)-(v-e)*(r-f))*(h-q);if(l*l<9.99999905104687e-09)d=-1;else d=l*(((v-e)*(t-q)-(w-q)*(s-e))*(0.0-f)+((w-q)*(r-f)-(u-f)*(t-q))*(0.0-e)+((u-f)*(s-e)-(v-e)*(r-f))*(0.0-q))<0.0&1;m=o|x|p|d;if((m|0)<0){a[b+352>>0]=1;a[b+312>>0]=0;Q=0;Q=Q<<24>>24!=0;i=U;return Q|0}n=(o|0)==0;o=(p|0)==0;d=(d|0)==0;if(!m){a[b+312>>0]=1;c[b+276>>2]=0;c[b+280>>2]=0;c[b+284>>2]=0;c[b+288>>2]=0;Q=1;Q=Q<<24>>24!=0;i=U;return Q|0}if((x|0)!=0?(AD(U,b+4|0,b+20|0,b+36|0,U+32|0),y=+g[U+32>>2],z=+g[U+36>>2],A=+g[U+40>>2],B=y-+g[U>>2],C=z-+g[U+4>>2],D=A-+g[U+8>>2],B*B+C*C+D*D<3402823466385288598117041.0e14):0){e=+g[U+44>>2];g[b+316>>2]=y;g[b+320>>2]=z;g[b+324>>2]=A;g[b+328>>2]=e;x=a[Q>>0]|0;a[b+332>>0]=x&1|a[b+332>>0]&-16|x&2|x&4;A=+g[U+56>>2];e=+g[U+60>>2];g[b+336>>2]=+g[U+52>>2];g[b+340>>2]=A;g[b+344>>2]=e;g[b+348>>2]=0.0;e=B*B+C*C+D*D}else e=3402823466385288598117041.0e14;if(!n?(AD(U,b+4|0,b+36|0,b+52|0,U+32|0),E=+g[U+32>>2],F=+g[U+36>>2],G=+g[U+40>>2],H=E-+g[U>>2],I=F-+g[U+4>>2],J=G-+g[U+8>>2],H*H+I*I+J*J<e):0){C=+g[U+44>>2];g[b+316>>2]=E;g[b+320>>2]=F;g[b+324>>2]=G;g[b+328>>2]=C;n=a[Q>>0]|0;a[b+332>>0]=n<<1&4|(n&1|a[b+332>>0]&-16)|n<<1&8;C=+g[U+56>>2];e=+g[U+60>>2];g[b+336>>2]=+g[U+52>>2];g[b+340>>2]=0.0;g[b+344>>2]=C;g[b+348>>2]=e;e=H*H+I*I+J*J}if(!o?(AD(U,b+4|0,b+52|0,b+20|0,U+32|0),K=+g[U+32>>2],L=+g[U+36>>2],M=+g[U+40>>2],N=K-+g[U>>2],O=L-+g[U+4>>2],P=M-+g[U+8>>2],N*N+O*O+P*P<e):0){e=+g[U+44>>2];g[b+316>>2]=K;g[b+320>>2]=L;g[b+324>>2]=M;g[b+328>>2]=e;o=a[Q>>0]|0;a[b+332>>0]=(o&255)>>>1&2|(o&1|a[b+332>>0]&-16)|o<<2&8;M=+g[U+60>>2];e=+g[U+56>>2];g[b+336>>2]=+g[U+52>>2];g[b+340>>2]=M;g[b+344>>2]=0.0;g[b+348>>2]=e;e=N*N+O*O+P*P}if(!d?(AD(U,b+20|0,b+52|0,b+36|0,U+32|0),R=+g[U+32>>2],S=+g[U+36>>2],T=+g[U+40>>2],N=R-+g[U>>2],O=S-+g[U+4>>2],P=T-+g[U+8>>2],N*N+O*O+P*P<e):0){P=+g[U+44>>2];g[b+316>>2]=R;g[b+320>>2]=S;g[b+324>>2]=T;g[b+328>>2]=P;Q=a[Q>>0]|0;a[b+332>>0]=Q<<1&2|a[b+332>>0]&-16|Q&4|Q<<2&8;R=+g[U+52>>2];S=+g[U+60>>2];T=+g[U+56>>2];g[b+336>>2]=0.0;g[b+340>>2]=R;g[b+344>>2]=S;g[b+348>>2]=T}K=+g[b+336>>2];L=+g[b+340>>2];M=+g[b+344>>2];T=+g[b+348>>2];N=+g[b+84>>2]*K+ +g[b+100>>2]*L+ +g[b+116>>2]*M+ +g[b+132>>2]*T;P=K*+g[b+88>>2]+L*+g[b+104>>2]+M*+g[b+120>>2]+T*+g[b+136>>2];S=K*+g[b+92>>2]+L*+g[b+108>>2]+M*+g[b+124>>2]+T*+g[b+140>>2];g[b+244>>2]=N;g[b+248>>2]=P;g[b+252>>2]=S;g[b+256>>2]=0.0;O=+g[b+164>>2]*K+ +g[b+180>>2]*L+ +g[b+196>>2]*M+ +g[b+212>>2]*T;R=K*+g[b+168>>2]+L*+g[b+184>>2]+M*+g[b+200>>2]+T*+g[b+216>>2];T=K*+g[b+172>>2]+L*+g[b+188>>2]+M*+g[b+204>>2]+T*+g[b+220>>2];g[b+260>>2]=O;g[b+264>>2]=R;g[b+268>>2]=T;g[b+272>>2]=0.0;g[b+276>>2]=N-O;g[b+280>>2]=P-R;g[b+284>>2]=S-T;g[b+288>>2]=0.0;yD(b,b+332|0);if((+g[b+336>>2]>=0.0?+g[b+340>>2]>=0.0:0)?+g[b+344>>2]>=0.0:0)d=+g[b+348>>2]>=0.0&1;else d=0;a[b+312>>0]=d;Q=d;Q=Q<<24>>24!=0;i=U;return Q|0}case 2:{e=+g[b+4>>2];f=+g[b+8>>2];h=+g[b+12>>2];j=+g[b+20>>2]-e;k=+g[b+24>>2]-f;l=+g[b+28>>2]-h;do if((0.0-e)*j+(0.0-f)*k+(0.0-h)*l>0.0)if((0.0-e)*j+(0.0-f)*k+(0.0-h)*l<j*j+k*k+l*l){a[b+332>>0]=d&-16|3;e=((0.0-e)*j+(0.0-f)*k+(0.0-h)*l)/(j*j+k*k+l*l);break}else{a[b+332>>0]=d&-16|2;e=1.0;break}else{a[b+332>>0]=d&-16|1;e=0.0}while(0);g[b+336>>2]=1.0-e;g[b+340>>2]=e;g[b+344>>2]=0.0;g[b+348>>2]=0.0;N=+g[b+84>>2];P=+g[b+88>>2];S=+g[b+92>>2];N=N+e*(+g[b+100>>2]-N);P=P+e*(+g[b+104>>2]-P);S=S+e*(+g[b+108>>2]-S);g[b+244>>2]=N;g[b+248>>2]=P;g[b+252>>2]=S;g[b+256>>2]=0.0;O=+g[b+164>>2];R=+g[b+168>>2];T=+g[b+172>>2];O=O+e*(+g[b+180>>2]-O);R=R+e*(+g[b+184>>2]-R);T=T+e*(+g[b+188>>2]-T);g[b+260>>2]=O;g[b+264>>2]=R;g[b+268>>2]=T;g[b+272>>2]=0.0;g[b+276>>2]=N-O;g[b+280>>2]=P-R;g[b+284>>2]=S-T;g[b+288>>2]=0.0;yD(b,b+332|0);if((+g[b+336>>2]>=0.0?+g[b+340>>2]>=0.0:0)?+g[b+344>>2]>=0.0:0)d=+g[b+348>>2]>=0.0&1;else d=0;a[b+312>>0]=d;Q=d;Q=Q<<24>>24!=0;i=U;return Q|0}case 1:{c[b+244>>2]=c[b+84>>2];c[b+248>>2]=c[b+88>>2];c[b+252>>2]=c[b+92>>2];c[b+256>>2]=c[b+96>>2];c[b+260>>2]=c[b+164>>2];c[b+264>>2]=c[b+168>>2];c[b+268>>2]=c[b+172>>2];c[b+272>>2]=c[b+176>>2];S=+g[b+248>>2]-+g[b+264>>2];T=+g[b+252>>2]-+g[b+268>>2];g[b+276>>2]=+g[b+244>>2]-+g[b+260>>2];g[b+280>>2]=S;g[b+284>>2]=T;g[b+288>>2]=0.0;c[b+336>>2]=0;c[b+340>>2]=0;c[b+344>>2]=0;c[b+348>>2]=0;a[b+352>>0]=0;a[b+332>>0]=d&-16;g[b+336>>2]=1.0;g[b+340>>2]=0.0;g[b+344>>2]=0.0;g[b+348>>2]=0.0;a[b+312>>0]=1;Q=1;Q=Q<<24>>24!=0;i=U;return Q|0}default:{a[b+312>>0]=0;Q=0;Q=Q<<24>>24!=0;i=U;return Q|0}}return 0}function AD(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0;u=a[h+16>>0]&-16;a[h+16>>0]=u;w=+g[e>>2];x=+g[d>>2];y=+g[e+4>>2];z=+g[d+4>>2];q=+g[e+8>>2];r=+g[d+8>>2];s=+g[f>>2];t=+g[f+4>>2];v=+g[f+8>>2];m=+g[b>>2];n=+g[b+4>>2];i=+g[b+8>>2];o=(w-x)*(m-x)+(y-z)*(n-z)+(q-r)*(i-r);p=(s-x)*(m-x)+(t-z)*(n-z)+(v-r)*(i-r);if(o<=0.0&p<=0.0){c[h+0>>2]=c[d+0>>2];c[h+4>>2]=c[d+4>>2];c[h+8>>2]=c[d+8>>2];c[h+12>>2]=c[d+12>>2];a[h+16>>0]=u|1;g[h+20>>2]=1.0;g[h+24>>2]=0.0;g[h+28>>2]=0.0;g[h+32>>2]=0.0;return}k=(w-x)*(m-w)+(y-z)*(n-y)+(q-r)*(i-q);l=(s-x)*(m-w)+(t-z)*(n-y)+(v-r)*(i-q);if(!(!(k>=0.0)|!(l<=k))){c[h+0>>2]=c[e+0>>2];c[h+4>>2]=c[e+4>>2];c[h+8>>2]=c[e+8>>2];c[h+12>>2]=c[e+12>>2];a[h+16>>0]=u|2;g[h+20>>2]=0.0;g[h+24>>2]=1.0;g[h+28>>2]=0.0;g[h+32>>2]=0.0;return}if((o>=0.0?o*l-k*p<=0.0:0)&k<=0.0){g[h>>2]=x+(w-x)*(o/(o-k));g[h+4>>2]=z+(y-z)*(o/(o-k));g[h+8>>2]=r+(q-r)*(o/(o-k));g[h+12>>2]=0.0;a[h+16>>0]=u|3;g[h+20>>2]=1.0-o/(o-k);g[h+24>>2]=o/(o-k);g[h+28>>2]=0.0;g[h+32>>2]=0.0;return}j=(w-x)*(m-s)+(y-z)*(n-t)+(q-r)*(i-v);i=(s-x)*(m-s)+(t-z)*(n-t)+(v-r)*(i-v);if(!(!(i>=0.0)|!(j<=i))){c[h+0>>2]=c[f+0>>2];c[h+4>>2]=c[f+4>>2];c[h+8>>2]=c[f+8>>2];c[h+12>>2]=c[f+12>>2];a[h+16>>0]=u|4;g[h+20>>2]=0.0;g[h+24>>2]=0.0;g[h+28>>2]=1.0;g[h+32>>2]=0.0;return}if((p>=0.0?j*p-o*i<=0.0:0)&i<=0.0){g[h>>2]=x+(s-x)*(p/(p-i));g[h+4>>2]=z+(t-z)*(p/(p-i));g[h+8>>2]=r+(v-r)*(p/(p-i));g[h+12>>2]=0.0;a[h+16>>0]=u|5;g[h+20>>2]=1.0-p/(p-i);g[h+24>>2]=0.0;g[h+28>>2]=p/(p-i);g[h+32>>2]=0.0;return}if((k*i-j*l<=0.0?l-k>=0.0:0)?j-i>=0.0:0){z=(l-k)/(l-k+(j-i));g[h>>2]=w+(s-w)*z;g[h+4>>2]=y+(t-y)*z;g[h+8>>2]=q+(v-q)*z;g[h+12>>2]=0.0;a[h+16>>0]=u|6;g[h+20>>2]=0.0;g[h+24>>2]=1.0-z;g[h+28>>2]=z;g[h+32>>2]=0.0;return}m=1.0/(o*l-k*p+(k*i-j*l+(j*p-o*i)));n=(j*p-o*i)*m;p=(o*l-k*p)*m;g[h>>2]=(s-x)*p+(x+(w-x)*n);g[h+4>>2]=(t-z)*p+(z+(y-z)*n);g[h+8>>2]=(v-r)*p+((q-r)*n+r);g[h+12>>2]=0.0;a[h+16>>0]=u|7;g[h+20>>2]=1.0-n-p;g[h+24>>2]=n;g[h+28>>2]=p;g[h+32>>2]=0.0;return}function BD(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return}function CD(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return 1.0}function DD(a,b){a=a|0;b=b|0;return}function ED(a){a=a|0;_E(a);return}function FD(b){b=b|0;var d=0;c[b>>2]=19768;if(!(a[b+8>>0]|0))return;d=c[b+12>>2]|0;if(!d)return;b=c[b+4>>2]|0;Lb[c[(c[b>>2]|0)+16>>2]&127](b,d);return}function GD(b){b=b|0;var d=0,e=0;c[b>>2]=19768;if(!(a[b+8>>0]|0)){_E(b);return}d=c[b+12>>2]|0;if(!d){_E(b);return}e=c[b+4>>2]|0;Lb[c[(c[e>>2]|0)+16>>2]&127](e,d);_E(b);return}function HD(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0,q=0,r=0;q=i;i=i+32|0;p=c[a+12>>2]|0;if(!p){i=q;return}c[f+4>>2]=p;e=c[b+4>>2]|0;r=c[d+4>>2]|0;b=c[b+12>>2]|0;a=c[d+12>>2]|0;h=+g[b+48>>2]-+g[a+48>>2];j=+g[b+52>>2]-+g[a+52>>2];l=+g[b+56>>2]-+g[a+56>>2];m=+P(+(h*h+j*j+l*l));n=+g[r+28>>2]*+g[r+12>>2];o=+g[e+28>>2]*+g[e+12>>2]+n;if(m>o){if(!(c[p+748>>2]|0)){i=q;return}d=c[p+740>>2]|0;b=c[(c[f+8>>2]|0)+8>>2]|0;e=c[(c[f+12>>2]|0)+8>>2]|0;if((d|0)==(b|0)){Os(p,d+4|0,e+4|0);i=q;return}else{Os(p,e+4|0,b+4|0);i=q;return}}g[q+16>>2]=1.0;g[q+20>>2]=0.0;g[q+24>>2]=0.0;g[q+28>>2]=0.0;if(m>1.1920928955078125e-07){g[q+16>>2]=h*(1.0/m);g[q+20>>2]=j*(1.0/m);g[q+24>>2]=l*(1.0/m);g[q+28>>2]=0.0;k=h*(1.0/m);j=j*(1.0/m);h=l*(1.0/m)}else{k=1.0;j=0.0;h=0.0}j=n*j+ +g[a+52>>2];l=n*h+ +g[a+56>>2];g[q>>2]=n*k+ +g[a+48>>2];g[q+4>>2]=j;g[q+8>>2]=l;g[q+12>>2]=0.0;oc[c[(c[f>>2]|0)+16>>2]&15](f,q+16|0,q,m-o);b=c[f+4>>2]|0;if(!(c[b+748>>2]|0)){i=q;return}d=c[b+740>>2]|0;a=c[(c[f+8>>2]|0)+8>>2]|0;e=c[(c[f+12>>2]|0)+8>>2]|0;if((d|0)==(a|0)){Os(b,d+4|0,e+4|0);i=q;return}else{Os(b,e+4|0,a+4|0);i=q;return}}function ID(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return 1.0}function JD(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;if(!(c[b+12>>2]|0))return;if(!(a[b+8>>0]|0))return;f=c[d+4>>2]|0;if((f|0)==(c[d+8>>2]|0)?(i=(f|0)==0?1:f<<1,(f|0)<(i|0)):0){if(!i)h=0;else{c[5132]=(c[5132]|0)+1;e=ZE((i<<2|3)+16|0)|0;if(!e)f=0;else{c[(e+19&-16)+-4>>2]=e;f=e+19&-16}h=f;f=c[d+4>>2]|0}if((f|0)>0){g=0;do{e=h+(g<<2)|0;if(e)c[e>>2]=c[(c[d+12>>2]|0)+(g<<2)>>2];g=g+1|0}while((g|0)!=(f|0))}e=c[d+12>>2]|0;if(e){if(a[d+16>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[e+-4>>2]|0);f=c[d+4>>2]|0}c[d+12>>2]=0}a[d+16>>0]=1;c[d+12>>2]=h;c[d+8>>2]=i}e=(c[d+12>>2]|0)+(f<<2)|0;if(e)c[e>>2]=c[b+12>>2];c[d+4>>2]=f+1;return}function KD(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0,j=0.0,k=0.0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0,s=0.0,t=0.0,u=0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0.0,N=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,Y=0.0,Z=0.0,_=0,$=0.0,aa=0.0,ba=0.0,ca=0.0,da=0,ea=0.0,fa=0,ga=0.0,ha=0.0,ia=0.0,ja=0.0,ka=0.0,la=0.0,ma=0,na=0,oa=0,pa=0.0,qa=0.0,ra=0.0,sa=0.0,ta=0.0,ua=0.0,va=0.0,wa=0.0,xa=0.0,ya=0.0,za=0.0,Aa=0.0,Ba=0.0,Ca=0.0,Da=0.0,Ea=0.0,Fa=0.0,Ga=0.0,Ha=0.0,Ia=0;Ia=i;i=i+672|0;g[Ia+344>>2]=+g[b>>2];g[Ia+96>>2]=+g[b+64>>2];na=Ia+348|0;g[na>>2]=+g[b+4>>2];g[Ia+100>>2]=+g[b+68>>2];g[Ia+352>>2]=+g[b+8>>2];g[Ia+104>>2]=+g[b+72>>2];g[Ia+360>>2]=+g[b+16>>2];g[Ia+112>>2]=+g[b+80>>2];g[Ia+364>>2]=+g[b+20>>2];g[Ia+116>>2]=+g[b+84>>2];g[Ia+368>>2]=+g[b+24>>2];g[Ia+120>>2]=+g[b+88>>2];g[Ia+376>>2]=+g[b+32>>2];g[Ia+128>>2]=+g[b+96>>2];g[Ia+380>>2]=+g[b+36>>2];g[Ia+132>>2]=+g[b+100>>2];g[Ia+384>>2]=+g[b+40>>2];g[Ia+136>>2]=+g[b+104>>2];oa=c[a+4>>2]|0;pa=+g[oa+28>>2];qa=+g[oa+32>>2];ta=+g[oa+36>>2];ra=+Zb[c[(c[oa>>2]|0)+48>>2]&15](oa);sa=+Zb[c[(c[oa>>2]|0)+48>>2]&15](oa);ta=(ta+ +Zb[c[(c[oa>>2]|0)+48>>2]&15](oa))*2.0;oa=c[a+8>>2]|0;wa=+g[oa+28>>2];xa=+g[oa+32>>2];Ca=+g[oa+36>>2];ya=+Zb[c[(c[oa>>2]|0)+48>>2]&15](oa);va=+Zb[c[(c[oa>>2]|0)+48>>2]&15](oa);Ca=(Ca+ +Zb[c[(c[oa>>2]|0)+48>>2]&15](oa))*2.0;t=+g[b+112>>2]-+g[b+48>>2];m=+g[b+116>>2]-+g[b+52>>2];Q=+g[b+120>>2]-+g[b+56>>2];la=+g[Ia+344>>2];ja=+g[Ia+360>>2];ka=+g[Ia+376>>2];ia=+g[na>>2];ga=+g[Ia+364>>2];ha=+g[Ia+380>>2];k=+g[Ia+352>>2];q=+g[Ia+368>>2];j=+g[Ia+384>>2];g[Ia>>2]=(pa+ra)*2.0*.5;g[Ia+4>>2]=(qa+sa)*2.0*.5;g[Ia+8>>2]=ta*.5;g[Ia+144>>2]=(wa+ya)*2.0*.5;g[Ia+148>>2]=(xa+va)*2.0*.5;g[Ia+152>>2]=Ca*.5;Fa=+g[Ia+96>>2];za=+g[Ia+112>>2];Ba=+g[Ia+128>>2];Ea=+g[Ia+100>>2];ua=+g[Ia+116>>2];Aa=+g[Ia+132>>2];Da=+g[Ia+104>>2];Ga=+g[Ia+120>>2];Ha=+g[Ia+136>>2];Z=+O(+(la*Fa+ja*za+ka*Ba));T=+O(+(la*Ea+ja*ua+ka*Aa));s=+O(+(la*Da+ja*Ga+ka*Ha));Y=+O(+(Fa*ia+za*ga+Ba*ha));M=+O(+(Ea*ia+ua*ga+Aa*ha));ca=+O(+(Da*ia+Ga*ga+Ha*ha));h=+O(+(Fa*k+za*q+Ba*j));ea=+O(+(Ea*k+ua*q+Aa*j));R=+O(+(Da*k+Ga*q+Ha*j));y=+O(+(t*la+m*ja+Q*ka))-(Ca*.5*s+((pa+ra)*2.0*.5+Z*((wa+ya)*2.0*.5)+T*((xa+va)*2.0*.5)));if(y>0.0){i=Ia;return}if(y>-3402823466385288598117041.0e14){f=1;u=t*la+m*ja+Q*ka<0.0&1;r=Ia+344|0}else{f=0;u=0;r=0;y=-3402823466385288598117041.0e14}z=+O(+(t*ia+m*ga+Q*ha))-((qa+sa)*2.0*.5+Y*((wa+ya)*2.0*.5)+M*((xa+va)*2.0*.5)+ca*(Ca*.5));if(z>0.0){i=Ia;return}if(z>y){f=2;u=t*ia+m*ga+Q*ha<0.0&1;r=na;y=z}z=+O(+(t*k+m*q+Q*j))-(ta*.5+h*((wa+ya)*2.0*.5)+ea*((xa+va)*2.0*.5)+R*(Ca*.5));if(z>0.0){i=Ia;return}if(z>y){f=3;u=t*k+m*q+Q*j<0.0&1;r=Ia+352|0;y=z}z=+O(+(t*Fa+m*za+Q*Ba))-((wa+ya)*2.0*.5+(Z*((pa+ra)*2.0*.5)+Y*((qa+sa)*2.0*.5)+h*(ta*.5)));if(z>0.0){i=Ia;return}if(z>y){f=4;u=t*Fa+m*za+Q*Ba<0.0&1;r=Ia+96|0;y=z}z=+O(+(t*Ea+m*ua+Q*Aa))-((xa+va)*2.0*.5+(T*((pa+ra)*2.0*.5)+M*((qa+sa)*2.0*.5)+ea*(ta*.5)));if(z>0.0){i=Ia;return}if(z>y){f=5;u=t*Ea+m*ua+Q*Aa<0.0&1;r=Ia+100|0}else z=y;y=+O(+(t*Da+m*Ga+Q*Ha))-(Ca*.5+(s*((pa+ra)*2.0*.5)+ca*((qa+sa)*2.0*.5)+R*(ta*.5)));if(y>0.0){i=Ia;return}if(y>z){f=6;u=t*Da+m*Ga+Q*Ha<0.0&1;r=Ia+104|0}else y=z;z=(t*k+m*q+Q*j)*(Fa*ia+za*ga+Ba*ha)-(t*ia+m*ga+Q*ha)*(Fa*k+za*q+Ba*j);w=+O(+z)-((h+9.999999747378752e-06)*((qa+sa)*2.0*.5)+(Y+9.999999747378752e-06)*(ta*.5)+(s+9.999999747378752e-06)*((xa+va)*2.0*.5)+(T+9.999999747378752e-06)*(Ca*.5));if(w>1.1920928955078125e-07){i=Ia;return}n=(Fa*k+za*q+Ba*j)*(Fa*k+za*q+Ba*j)+0.0;ba=(Fa*ia+za*ga+Ba*ha)*(Fa*ia+za*ga+Ba*ha);v=+P(+(ba+n));if(v>1.1920928955078125e-07?w/v*1.0499999523162842>y:0){x=(Fa*ia+za*ga+Ba*ha)/v;p=-(Fa*k+za*q+Ba*j)/v;o=0.0/v;f=7;u=z<0.0&1;r=0;y=w/v}else{x=0.0;p=0.0;o=0.0}z=(t*k+m*q+Q*j)*(Ea*ia+ua*ga+Aa*ha)-(t*ia+m*ga+Q*ha)*(Ea*k+ua*q+Aa*j);w=+O(+z)-((ea+9.999999747378752e-06)*((qa+sa)*2.0*.5)+(M+9.999999747378752e-06)*(ta*.5)+(s+9.999999747378752e-06)*((wa+ya)*2.0*.5)+(Z+9.999999747378752e-06)*(Ca*.5));if(w>1.1920928955078125e-07){i=Ia;return}S=(Ea*k+ua*q+Aa*j)*(Ea*k+ua*q+Aa*j)+0.0;aa=(Ea*ia+ua*ga+Aa*ha)*(Ea*ia+ua*ga+Aa*ha);v=+P(+(aa+S));if(v>1.1920928955078125e-07?w/v*1.0499999523162842>y:0){x=(Ea*ia+ua*ga+Aa*ha)/v;p=-(Ea*k+ua*q+Aa*j)/v;o=0.0/v;f=8;u=z<0.0&1;r=0;y=w/v}z=(t*k+m*q+Q*j)*(Da*ia+Ga*ga+Ha*ha)-(t*ia+m*ga+Q*ha)*(Da*k+Ga*q+Ha*j);w=+O(+z)-((R+9.999999747378752e-06)*((qa+sa)*2.0*.5)+(ca+9.999999747378752e-06)*(ta*.5)+(T+9.999999747378752e-06)*((wa+ya)*2.0*.5)+(Z+9.999999747378752e-06)*((xa+va)*2.0*.5));if(w>1.1920928955078125e-07){i=Ia;return}W=(Da*k+Ga*q+Ha*j)*(Da*k+Ga*q+Ha*j)+0.0;$=(Da*ia+Ga*ga+Ha*ha)*(Da*ia+Ga*ga+Ha*ha);v=+P(+($+W));if(v>1.1920928955078125e-07?w/v*1.0499999523162842>y:0){x=(Da*ia+Ga*ga+Ha*ha)/v;p=-(Da*k+Ga*q+Ha*j)/v;o=0.0/v;f=9;u=z<0.0&1;r=0;y=w/v}z=(t*la+m*ja+Q*ka)*(Fa*k+za*q+Ba*j)-(t*k+m*q+Q*j)*(la*Fa+ja*za+ka*Ba);v=+O(+z)-((h+9.999999747378752e-06)*((pa+ra)*2.0*.5)+(Z+9.999999747378752e-06)*(ta*.5)+(ca+9.999999747378752e-06)*((xa+va)*2.0*.5)+(M+9.999999747378752e-06)*(Ca*.5));if(v>1.1920928955078125e-07){i=Ia;return}U=(la*Fa+ja*za+ka*Ba)*(la*Fa+ja*za+ka*Ba);w=+P(+(U+n));do if(w>1.1920928955078125e-07){if(!(v/w*1.0499999523162842>y))break;x=-(la*Fa+ja*za+ka*Ba)/w;p=0.0/w;o=(Fa*k+za*q+Ba*j)/w;f=10;u=z<0.0&1;r=0;y=v/w}while(0);z=(t*la+m*ja+Q*ka)*(Ea*k+ua*q+Aa*j)-(t*k+m*q+Q*j)*(la*Ea+ja*ua+ka*Aa);v=+O(+z)-((ea+9.999999747378752e-06)*((pa+ra)*2.0*.5)+(T+9.999999747378752e-06)*(ta*.5)+(ca+9.999999747378752e-06)*((wa+ya)*2.0*.5)+(Y+9.999999747378752e-06)*(Ca*.5));if(v>1.1920928955078125e-07){i=Ia;return}V=(la*Ea+ja*ua+ka*Aa)*(la*Ea+ja*ua+ka*Aa);w=+P(+(V+S));do if(w>1.1920928955078125e-07){if(!(v/w*1.0499999523162842>y))break;x=-(la*Ea+ja*ua+ka*Aa)/w;p=0.0/w;o=(Ea*k+ua*q+Aa*j)/w;f=11;u=z<0.0&1;r=0;y=v/w}while(0);z=(t*la+m*ja+Q*ka)*(Da*k+Ga*q+Ha*j)-(t*k+m*q+Q*j)*(la*Da+ja*Ga+ka*Ha);v=+O(+z)-((R+9.999999747378752e-06)*((pa+ra)*2.0*.5)+(s+9.999999747378752e-06)*(ta*.5)+(M+9.999999747378752e-06)*((wa+ya)*2.0*.5)+(Y+9.999999747378752e-06)*((xa+va)*2.0*.5));if(v>1.1920928955078125e-07){i=Ia;return}N=(la*Da+ja*Ga+ka*Ha)*(la*Da+ja*Ga+ka*Ha);w=+P(+(N+W));do if(w>1.1920928955078125e-07){if(!(v/w*1.0499999523162842>y))break;x=-(la*Da+ja*Ga+ka*Ha)/w;p=0.0/w;o=(Da*k+Ga*q+Ha*j)/w;f=12;u=z<0.0&1;r=0;y=v/w}while(0);w=(t*ia+m*ga+Q*ha)*(la*Fa+ja*za+ka*Ba)-(t*la+m*ja+Q*ka)*(Fa*ia+za*ga+Ba*ha);v=+O(+w)-((Y+9.999999747378752e-06)*((pa+ra)*2.0*.5)+(Z+9.999999747378752e-06)*((qa+sa)*2.0*.5)+(R+9.999999747378752e-06)*((xa+va)*2.0*.5)+(ea+9.999999747378752e-06)*(Ca*.5));if(v>1.1920928955078125e-07){i=Ia;return}z=+P(+(U+ba+0.0));do if(z>1.1920928955078125e-07){if(!(v/z*1.0499999523162842>y))break;x=0.0/z;p=(la*Fa+ja*za+ka*Ba)/z;o=-(Fa*ia+za*ga+Ba*ha)/z;f=13;u=w<0.0&1;r=0;y=v/z}while(0);v=(t*ia+m*ga+Q*ha)*(la*Ea+ja*ua+ka*Aa)-(t*la+m*ja+Q*ka)*(Ea*ia+ua*ga+Aa*ha);w=+O(+v)-((M+9.999999747378752e-06)*((pa+ra)*2.0*.5)+(T+9.999999747378752e-06)*((qa+sa)*2.0*.5)+(R+9.999999747378752e-06)*((wa+ya)*2.0*.5)+(h+9.999999747378752e-06)*(Ca*.5));if(w>1.1920928955078125e-07){i=Ia;return}z=+P(+(V+aa+0.0));do if(z>1.1920928955078125e-07){if(!(w/z*1.0499999523162842>y))break;x=0.0/z;p=(la*Ea+ja*ua+ka*Aa)/z;o=-(Ea*ia+ua*ga+Aa*ha)/z;f=14;u=v<0.0&1;r=0;y=w/z}while(0);z=(t*ia+m*ga+Q*ha)*(la*Da+ja*Ga+ka*Ha)-(t*la+m*ja+Q*ka)*(Da*ia+Ga*ga+Ha*ha);v=+O(+z)-((ca+9.999999747378752e-06)*((pa+ra)*2.0*.5)+(s+9.999999747378752e-06)*((qa+sa)*2.0*.5)+(ea+9.999999747378752e-06)*((wa+ya)*2.0*.5)+(h+9.999999747378752e-06)*((xa+va)*2.0*.5));if(v>1.1920928955078125e-07){i=Ia;return}w=+P(+(N+$+0.0));do if(w>1.1920928955078125e-07){if(!(v/w*1.0499999523162842>y)){oa=55;break}o=-(Da*ia+Ga*ga+Ha*ha)/w;p=(la*Da+ja*Ga+ka*Ha)/w;x=0.0/w;f=15;u=z<0.0&1;y=v/w;oa=58}else oa=55;while(0);do if((oa|0)==55){if(!f){i=Ia;return}if(!r){oa=58;break}L=f;w=+g[r>>2];v=+g[r+16>>2];x=+g[r+32>>2];z=y}while(0);if((oa|0)==58){L=f;w=o*+g[Ia+344>>2]+p*+g[na>>2]+x*k;v=o*+g[Ia+360>>2]+p*+g[Ia+364>>2]+x*q;x=o*+g[Ia+376>>2]+p*+g[Ia+380>>2]+x*j;z=y}if(!u){ga=w;la=v;ka=x}else{ga=-w;la=-v;ka=-x}if((L|0)>6){o=+g[Ia+344>>2];n=+g[Ia+360>>2];s=+g[Ia+376>>2];h=(ga*o+la*n+ka*s>0.0?1.0:-1.0)*((pa+ra)*2.0*.5);y=+g[na>>2];x=+g[Ia+364>>2];v=+g[Ia+380>>2];t=(ga*y+la*x+ka*v>0.0?1.0:-1.0)*((qa+sa)*2.0*.5);w=(ga*k+la*q+ka*j>0.0?1.0:-1.0)*(ta*.5);y=+g[b+48>>2]+h*o+t*y+w*k;x=+g[b+52>>2]+h*n+t*x+w*q;w=+g[b+56>>2]+h*s+t*v+w*j;c[Ia+456>>2]=c[b+112>>2];c[Ia+460>>2]=c[b+116>>2];c[Ia+464>>2]=c[b+120>>2];k=(ga*Fa+la*za+ka*Ba>0.0?-1.0:1.0)*((wa+ya)*2.0*.5);q=(ga*Ea+la*ua+ka*Aa>0.0?-1.0:1.0)*((xa+va)*2.0*.5);v=+g[Ia+460>>2]+k*za+q*ua;t=+g[Ia+464>>2]+k*Ba+q*Aa;s=(ga*Da+la*Ga+ka*Ha>0.0?-1.0:1.0)*(Ca*.5);q=+g[Ia+456>>2]+k*Fa+q*Ea+s*Da;g[Ia+456>>2]=q;g[Ia+460>>2]=v+s*Ga;g[Ia+464>>2]=t+s*Ha;oa=L+-7|0;k=+g[Ia+344+(((oa|0)/3|0)<<2)>>2];j=+g[Ia+344+(((oa|0)/3|0)+4<<2)>>2];h=+g[Ia+344+(((oa|0)/3|0)+8<<2)>>2];n=+g[Ia+96+(((oa|0)%3|0)<<2)>>2];o=+g[Ia+96+(((oa|0)%3|0)+4<<2)>>2];p=+g[Ia+96+(((oa|0)%3|0)+8<<2)>>2];m=1.0-(k*n+j*o+h*p)*(k*n+j*o+h*p);if(!(m<=9.999999747378752e-05))k=(((q-y)*k+(v+s*Ga-x)*j+(t+s*Ha-w)*h)*(k*n+j*o+h*p)-((q-y)*n+(v+s*Ga-x)*o+(t+s*Ha-w)*p))*(1.0/m);else k=0.0;g[Ia+456>>2]=q+k*n;g[Ia+460>>2]=v+s*Ga+k*o;g[Ia+464>>2]=t+s*Ha+k*p;oa=c[(c[d>>2]|0)+16>>2]|0;g[Ia+32>>2]=-ga;g[Ia+36>>2]=-la;g[Ia+40>>2]=-ka;g[Ia+44>>2]=0.0;oc[oa&15](d,Ia+32|0,Ia+456|0,z);i=Ia;return}ma=(L|0)<4;if(ma){q=Ga;j=Ha;k=+g[Ia+104>>2];e=Ia+96|0;aa=ga;ba=la;ca=ka;B=Ia+144|0;f=b+112|0;na=b+48|0;r=Ia+344|0;_=Ia;l=Ia+96|0}else{e=Ia+344|0;aa=-ga;ba=-la;ca=-ka;B=Ia;f=b+48|0;na=b+112|0;r=Ia+96|0;_=Ia+144|0;l=Ia+344|0}Ga=aa*+g[l>>2]+ba*+g[e+16>>2]+ca*+g[e+32>>2];g[Ia+48>>2]=Ga;Ha=aa*+g[e+4>>2]+ba*+g[e+20>>2]+ca*+g[e+36>>2];g[Ia+52>>2]=Ha;m=aa*k+ba*q+ca*j;g[Ia+56>>2]=m;k=+O(+Ga);j=+O(+Ha);m=+O(+m);if(j>k){l=j>m;a=0;u=j>m?1:2}else{l=k>m;a=k>m&1;u=k>m?0:2}A=l?2:1;t=+g[B+(u<<2)>>2];q=+g[f>>2]-+g[na>>2];p=t*+g[e+(u<<2)>>2];v=+g[f+4>>2];fa=na+4|0;o=+g[fa>>2];k=+g[f+8>>2];da=na+8|0;n=+g[da>>2];if(+g[Ia+48+(u<<2)>>2]<0.0){$=q+p;Z=v-o+t*+g[e+((u|4)<<2)>>2];Y=k-n+t*+g[e+((u|8)<<2)>>2]}else{$=q-p;Z=v-o-t*+g[e+((u|4)<<2)>>2];Y=k-n-t*+g[e+((u|8)<<2)>>2]}H=(ma?-1:-4)+L|0;if((H|0)==1){u=0;f=2}else if(!H){u=1;f=2}else{u=0;f=1}V=+g[r+(u<<2)>>2];S=+g[r+((u|4)<<2)>>2];T=+g[r+((u|8)<<2)>>2];W=$*V+Z*S+Y*T;U=+g[r+(f<<2)>>2];R=+g[r+((f|4)<<2)>>2];h=+g[r+((f|8)<<2)>>2];Q=$*U+Z*R+Y*h;G=e+(a<<2)|0;N=+g[G>>2];J=e+((a|4)<<2)|0;m=+g[J>>2];L=e+((a|8)<<2)|0;s=+g[L>>2];I=e+(A<<2)|0;M=+g[I>>2];K=e+((A|4)<<2)|0;j=+g[K>>2];b=e+((A|8)<<2)|0;t=+g[b>>2];Ga=+g[B+(a<<2)>>2];Ha=+g[B+(A<<2)>>2];Fa=(V*M+S*j+T*t)*Ha;Ha=(U*M+R*j+h*t)*Ha;g[Ia+208>>2]=W-(V*N+S*m+T*s)*Ga-Fa;g[Ia+212>>2]=Q-(U*N+R*m+h*s)*Ga-Ha;g[Ia+216>>2]=W-(V*N+S*m+T*s)*Ga+Fa;g[Ia+220>>2]=Q-(U*N+R*m+h*s)*Ga+Ha;g[Ia+224>>2]=W+(V*N+S*m+T*s)*Ga+Fa;g[Ia+228>>2]=Q+(U*N+R*m+h*s)*Ga+Ha;g[Ia+232>>2]=W+(V*N+S*m+T*s)*Ga-Fa;g[Ia+236>>2]=Q+(U*N+R*m+h*s)*Ga-Ha;g[Ia+336>>2]=+g[_+(u<<2)>>2];g[Ia+340>>2]=+g[_+(f<<2)>>2];u=0;f=4;r=Ia+208|0;l=Ia+392|0;a:while(1){E=Ia+336+(u<<2)|0;F=1-u|0;C=r;r=l;D=-1;while(1){if((f|0)>0){w=+(D|0);l=0;B=C;a=r;while(1){e=B+(u<<2)|0;z=+g[e>>2];y=+g[E>>2];if(w*z<y){g[a>>2]=+g[B>>2];g[a+4>>2]=+g[B+4>>2];l=l+1|0;if(l&8)break a;z=+g[e>>2];y=+g[E>>2];a=a+8|0}A=B;B=B+8|0;e=(f|0)>1?B:C;x=+g[e+(u<<2)>>2];if(w*z<y^w*x<y){Ha=+g[A+(F<<2)>>2];g[a+(F<<2)>>2]=Ha+(w*y-z)*((+g[e+(F<<2)>>2]-Ha)/(x-z));g[a+(u<<2)>>2]=w*+g[E>>2];l=l+1|0;if(!(l&8))a=a+8|0;else break a}f=f+-1|0;if((f|0)<=0){f=l;break}}}else f=0;l=(r|0)==(Ia+392|0)?Ia+568|0:Ia+392|0;if((D|0)<0){C=r;r=l;D=D+2|0}else break}u=u+1|0;if((u|0)>=2){l=f;break}}if((r|0)!=(Ia+392|0))fF(Ia+392|0,r|0,l<<3|0)|0;if((l|0)<1){i=Ia;return}z=1.0/((V*N+S*m+T*s)*(U*M+R*j+h*t)-(U*N+R*m+h*s)*(V*M+S*j+T*t));n=+g[_+(H<<2)>>2];k=+g[G>>2];o=+g[I>>2];p=+g[J>>2];q=+g[K>>2];v=+g[L>>2];w=+g[b>>2];u=0;f=0;do{r=f<<1;y=+g[Ia+392+(r<<2)>>2];x=+g[Ia+392+((r|1)<<2)>>2];Ea=(U*M+R*j+h*t)*z*(y-W)-(V*M+S*j+T*t)*z*(x-Q);Ha=(V*N+S*m+T*s)*z*(x-Q)-(U*N+R*m+h*s)*z*(y-W);r=u*3|0;Fa=$+Ea*k+Ha*o;g[Ia+472+(r<<2)>>2]=Fa;Ga=Z+Ea*p+Ha*q;g[Ia+472+(r+1<<2)>>2]=Ga;Ha=Y+Ea*v+Ha*w;g[Ia+472+(r+2<<2)>>2]=Ha;Ha=n-(aa*Fa+ba*Ga+ca*Ha);g[Ia+632+(u<<2)>>2]=Ha;if(Ha>=0.0){r=u<<1;g[Ia+392+(r<<2)>>2]=y;g[Ia+392+((r|1)<<2)>>2]=x;u=u+1|0}f=f+1|0}while((f|0)!=(l|0));if((u|0)<1){i=Ia;return}B=(u|0)<4?u:4;B=(B|0)<1?1:B;if((u|0)<=(B|0)){f=(u|0)>0;if(ma){if(!f){i=Ia;return}k=-ga;j=-la;h=-ka;f=0;do{oa=f*3|0;g[Ia+160>>2]=+g[Ia+472+(oa<<2)>>2]+ +g[na>>2];g[Ia+164>>2]=+g[Ia+472+(oa+1<<2)>>2]+ +g[fa>>2];g[Ia+168>>2]=+g[Ia+472+(oa+2<<2)>>2]+ +g[da>>2];oa=c[(c[d>>2]|0)+16>>2]|0;g[Ia+176>>2]=k;g[Ia+180>>2]=j;g[Ia+184>>2]=h;g[Ia+188>>2]=0.0;oc[oa&15](d,Ia+176|0,Ia+160|0,-+g[Ia+632+(f<<2)>>2]);f=f+1|0}while((f|0)!=(u|0));i=Ia;return}else{if(!f){i=Ia;return}k=-ga;j=-la;h=-ka;f=0;do{oa=f*3|0;Ha=+g[Ia+632+(f<<2)>>2];g[Ia+192>>2]=+g[Ia+472+(oa<<2)>>2]+ +g[na>>2]-ga*Ha;g[Ia+196>>2]=+g[Ia+472+(oa+1<<2)>>2]+ +g[fa>>2]-la*Ha;g[Ia+200>>2]=+g[Ia+472+(oa+2<<2)>>2]+ +g[da>>2]-ka*Ha;oa=c[(c[d>>2]|0)+16>>2]|0;g[Ia+240>>2]=k;g[Ia+244>>2]=j;g[Ia+248>>2]=h;g[Ia+252>>2]=0.0;oc[oa&15](d,Ia+240|0,Ia+192|0,-Ha);f=f+1|0}while((f|0)!=(u|0));i=Ia;return}}if((u|0)>1){l=1;f=0;j=+g[Ia+632>>2];while(1){k=+g[Ia+632+(l<<2)>>2];a=k>j;f=a?l:f;l=l+1|0;if((l|0)==(u|0)){A=f;break}else j=a?k:j}}else A=0;if((u|0)==1){l=1;j=+g[Ia+392>>2];k=+g[Ia+396>>2];oa=116}else if((u|0)!=2){l=u+-1|0;if((l|0)>0){k=0.0;j=0.0;h=0.0;f=0;do{r=f<<1;Ea=+g[Ia+392+(r<<2)>>2];Fa=+g[Ia+392+(r+3<<2)>>2];Ga=+g[Ia+392+(r+2<<2)>>2];Ha=+g[Ia+392+((r|1)<<2)>>2];k=k+(Ea*Fa-Ga*Ha);j=j+(Ea+Ga)*(Ea*Fa-Ga*Ha);h=h+(Fa+Ha)*(Ea*Fa-Ga*Ha);f=f+1|0}while((f|0)!=(l|0))}else{k=0.0;j=0.0;h=0.0}r=u<<1;p=+g[Ia+392+(r+-2<<2)>>2];o=+g[Ia+396>>2];n=+g[Ia+392>>2];m=+g[Ia+392+(r+-1<<2)>>2];k=k+(p*o-n*m);if(+O(+k)>1.1920928955078125e-07)k=1.0/(k*3.0);else k=999999984306749440.0;if((u|0)>0){l=u;j=k*(j+(p*o-n*m)*(p+n));k=k*(h+(p*o-n*m)*(m+o));oa=116}else f=0}else{l=2;j=(+g[Ia+392>>2]+ +g[Ia+400>>2])*.5;k=(+g[Ia+396>>2]+ +g[Ia+404>>2])*.5;oa=116}if((oa|0)==116){f=0;do{oa=f<<1;g[Ia+568+(f<<2)>>2]=+X(+(+g[Ia+392+((oa|1)<<2)>>2]-k),+(+g[Ia+392+(oa<<2)>>2]-j));f=f+1|0}while((f|0)!=(l|0));f=0;do{c[Ia+256+(f<<2)>>2]=1;f=f+1|0}while((f|0)!=(l|0));f=1;u=l}l=Ia+256+(A<<2)|0;c[l>>2]=0;c[Ia+288>>2]=A;b:do if((B|0)>1){q=+g[Ia+568+(A<<2)>>2];if(f){a=Ia+292|0;e=Ia+288|0;r=1}else{f=Ia+292|0;a=Ia+288|0;e=1;while(1){c[f>>2]=A;c[l>>2]=0;e=e+1|0;if((e|0)==(B|0))break b;else{oa=f;f=a+8|0;a=oa}}}while(1){k=+(r|0)*(6.2831854820251465/+(B|0))+q;if(k>3.1415927410125732)k=k+-6.2831854820251465;c[a>>2]=A;l=A;f=0;p=1.0e9;while(1){do if(!(c[Ia+256+(f<<2)>>2]|0))j=p;else{j=+O(+(+g[Ia+568+(f<<2)>>2]-k));if(j>3.1415927410125732)j=6.2831854820251465-j;if(!(j<p)){j=p;break}c[a>>2]=f;l=f}while(0);f=f+1|0;if((f|0)==(u|0))break;else p=j}c[Ia+256+(l<<2)>>2]=0;r=r+1|0;if((r|0)==(B|0))break;else{oa=a;a=e+8|0;e=oa}}}while(0);if((B|0)<=0){i=Ia;return}k=-ka;j=-la;h=-ga;if(ma){f=0;do{oa=c[Ia+288+(f<<2)>>2]|0;g[Ia+64>>2]=+g[Ia+472+(oa*3<<2)>>2]+ +g[na>>2];g[Ia+68>>2]=+g[Ia+472+((oa*3|0)+1<<2)>>2]+ +g[fa>>2];g[Ia+72>>2]=+g[Ia+472+((oa*3|0)+2<<2)>>2]+ +g[da>>2];r=c[(c[d>>2]|0)+16>>2]|0;g[Ia+320>>2]=h;g[Ia+324>>2]=j;g[Ia+328>>2]=k;g[Ia+332>>2]=0.0;oc[r&15](d,Ia+320|0,Ia+64|0,-+g[Ia+632+(oa<<2)>>2]);f=f+1|0}while((f|0)<(B|0));i=Ia;return}else{f=0;do{r=c[Ia+288+(f<<2)>>2]|0;Ea=+g[Ia+472+(r*3<<2)>>2]+ +g[na>>2];g[Ia+64>>2]=Ea;Fa=+g[Ia+472+((r*3|0)+1<<2)>>2]+ +g[fa>>2];g[Ia+68>>2]=Fa;Ga=+g[Ia+472+((r*3|0)+2<<2)>>2]+ +g[da>>2];g[Ia+72>>2]=Ga;oa=c[(c[d>>2]|0)+16>>2]|0;g[Ia+16>>2]=h;g[Ia+20>>2]=j;g[Ia+24>>2]=k;g[Ia+28>>2]=0.0;Ha=+g[Ia+632+(r<<2)>>2];g[Ia+80>>2]=Ea-ga*Ha;g[Ia+84>>2]=Fa-Ha*la;g[Ia+88>>2]=Ga-Ha*ka;g[Ia+92>>2]=0.0;oc[oa&15](d,Ia+16|0,Ia+80|0,-Ha);f=f+1|0}while((f|0)<(B|0));i=Ia;return}}function LD(a){a=a|0;_E(a);return}function MD(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0,B=0.0,C=0.0,D=0.0,E=0.0,F=0,G=0;F=i;i=i+96|0;B=+g[b+48>>2]-+g[b+112>>2];h=+g[b+52>>2]-+g[b+116>>2];E=+g[b+56>>2]-+g[b+120>>2];C=B*+g[b+64>>2]+h*+g[b+80>>2]+E*+g[b+96>>2];D=B*+g[b+68>>2]+h*+g[b+84>>2]+E*+g[b+100>>2];E=B*+g[b+72>>2]+h*+g[b+88>>2]+E*+g[b+104>>2];e=c[a+8>>2]|0;A=c[a+4>>2]|0;h=+g[A+28>>2]*+g[A+12>>2];B=h+ +g[a+12>>2];v=+g[e+72>>2];u=+g[e+56>>2];o=+g[e+76>>2];n=+g[e+60>>2];m=+g[e+80>>2];w=+g[e+64>>2];x=+g[e+88>>2];y=+g[e+92>>2];z=+g[e+96>>2];t=(o-n)*(z-w)-(m-w)*(y-n);r=(m-w)*(x-u)-(v-u)*(z-w);s=(v-u)*(y-n)-(o-n)*(x-u);p=1.0/+P(+(s*s+(t*t+r*r)));q=(C-u)*(p*t)+p*r*(D-n)+p*s*(E-w);if(q<0.0){q=-q;j=-(p*s);k=-(p*r);l=-(p*t)}else{j=p*s;k=p*r;l=p*t}if(!(q<B)){i=F;return}t=(E-w)*((v-u)*k-(o-n)*l)+((C-u)*((o-n)*j-(m-w)*k)+(D-n)*((m-w)*l-(v-u)*j));v=(E-m)*((x-v)*k-(y-o)*l)+((C-v)*((y-o)*j-(z-m)*k)+(D-o)*((z-m)*l-(x-v)*j));z=(E-z)*((u-x)*k-(n-y)*l)+((C-x)*((n-y)*j-(w-z)*k)+(D-y)*((w-z)*l-(u-x)*j));if(!(t>0.0&v>0.0&z>0.0)?!(t<=0.0&v<=0.0&z<=0.0):0){if((Nb[c[(c[e>>2]|0)+100>>2]&127](e)|0)<=0){i=F;return}o=0.0;r=0.0;q=0.0;e=0;A=0;do{G=c[a+8>>2]|0;tc[c[(c[G>>2]|0)+104>>2]&127](G,A,F+80|0,F+64|0);z=+g[F+80>>2];u=+g[F+84>>2];s=+g[F+88>>2];y=+g[F+64>>2]-z;v=+g[F+68>>2]-u;p=+g[F+72>>2]-s;do if((C-z)*y+(D-u)*v+(E-s)*p>0.0)if((C-z)*y+(D-u)*v+(E-s)*p<y*y+v*v+p*p){x=((C-z)*y+(D-u)*v+(E-s)*p)/(y*y+v*v+p*p);n=C-z-y*x;m=D-u-v*x;t=E-s-p*x;break}else{n=C-z-y;m=D-u-v;t=E-s-p;x=1.0;break}else{n=C-z;m=D-u;t=E-s;x=0.0}while(0);if(t*t+(m*m+n*n)<B*B){q=s+p*x;r=u+v*x;o=z+y*x;e=1}A=A+1|0;G=c[a+8>>2]|0}while((A|0)<(Nb[c[(c[G>>2]|0)+100>>2]&127](G)|0));if(!(e&1)){i=F;return}else{p=B*B;s=o}}else{p=B*B;s=C-l*q;r=D-k*q;q=E-j*q}m=C-s;n=D-r;o=E-q;if(!(m*m+n*n+o*o<p)){i=F;return}if(m*m+n*n+o*o>1.1920928955078125e-07){j=+P(+(m*m+n*n+o*o));h=h-j;l=m*(1.0/j);k=n*(1.0/j);j=o*(1.0/j)}h=-h;if(f){x=+g[b+64>>2];y=+g[b+68>>2];z=+g[b+72>>2];B=x*l+y*k+z*j;o=+g[b+80>>2];p=+g[b+84>>2];t=+g[b+88>>2];C=l*o+k*p+j*t;u=+g[b+96>>2];v=+g[b+100>>2];w=+g[b+104>>2];D=l*u+k*v+j*w;g[F+48>>2]=-B;g[F+52>>2]=-C;g[F+56>>2]=-D;g[F+60>>2]=0.0;C=s*o+r*p+q*t+ +g[b+116>>2]+C*h;D=s*u+r*v+q*w+ +g[b+120>>2]+D*h;g[F+32>>2]=s*x+r*y+q*z+ +g[b+112>>2]+B*h;g[F+36>>2]=C;g[F+40>>2]=D;g[F+44>>2]=0.0;oc[c[(c[d>>2]|0)+16>>2]&15](d,F+48|0,F+32|0,h);i=F;return}else{G=c[(c[d>>2]|0)+16>>2]|0;y=+g[b+64>>2];z=+g[b+68>>2];B=+g[b+72>>2];u=+g[b+80>>2];v=+g[b+84>>2];C=+g[b+88>>2];w=+g[b+96>>2];x=+g[b+100>>2];D=+g[b+104>>2];g[F+16>>2]=y*l+z*k+B*j;g[F+20>>2]=l*u+k*v+j*C;g[F+24>>2]=l*w+k*x+j*D;g[F+28>>2]=0.0;C=s*u+r*v+q*C+ +g[b+116>>2];D=s*w+r*x+q*D+ +g[b+120>>2];g[F>>2]=s*y+r*z+q*B+ +g[b+112>>2];g[F+4>>2]=C;g[F+8>>2]=D;g[F+12>>2]=0.0;oc[G&15](d,F+16|0,F,h);i=F;return}}function ND(a){a=a|0;_E(a);return}function OD(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0;i=c[b+12>>2]|0;j=c[b+32>>2]|0;if((j|0)>=(i|0))return;if((j|0)<=(i|0)){if((c[b+36>>2]|0)<(i|0)){if(!i){d=0;g=j}else{c[5132]=(c[5132]|0)+1;d=ZE((i<<2|3)+16|0)|0;if(!d)d=0;else{c[(d+19&-16)+-4>>2]=d;d=d+19&-16}g=c[b+32>>2]|0}if((g|0)>0){e=0;do{f=d+(e<<2)|0;if(f)c[f>>2]=c[(c[b+40>>2]|0)+(e<<2)>>2];e=e+1|0}while((e|0)!=(g|0))}e=c[b+40>>2]|0;if(e){if(a[b+44>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[e+-4>>2]|0)}c[b+40>>2]=0}a[b+44>>0]=1;c[b+40>>2]=d;c[b+36>>2]=i}else d=c[b+40>>2]|0;g=j;do{e=d+(g<<2)|0;if(e)c[e>>2]=0;g=g+1|0}while((g|0)!=(i|0))}c[b+32>>2]=i;g=c[b+52>>2]|0;if((g|0)<(i|0)){if((c[b+56>>2]|0)<(i|0)){if(!i){e=0;f=g}else{c[5132]=(c[5132]|0)+1;e=ZE((i<<2|3)+16|0)|0;if(!e)e=0;else{c[(e+19&-16)+-4>>2]=e;e=e+19&-16}f=c[b+52>>2]|0}if((f|0)>0){h=0;do{d=e+(h<<2)|0;if(d)c[d>>2]=c[(c[b+60>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(f|0))}d=c[b+60>>2]|0;if(d){if(a[b+64>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+60>>2]=0}a[b+64>>0]=1;c[b+60>>2]=e;c[b+56>>2]=i}else e=c[b+60>>2]|0;do{d=e+(g<<2)|0;if(d)c[d>>2]=0;g=g+1|0}while((g|0)!=(i|0))}c[b+52>>2]=i;if((i|0)>0){cF(c[b+40>>2]|0,-1,i<<2|0)|0;cF(c[b+60>>2]|0,-1,i<<2|0)|0}if((j|0)<=0)return;e=c[b+16>>2]|0;d=c[b+40>>2]|0;f=c[b+60>>2]|0;g=0;do{i=c[e+(g*12|0)+4>>2]<<16|c[e+(g*12|0)>>2];i=(i+~(i<<15)>>10^i+~(i<<15))*9|0;i=d+((((i>>6^i)+~((i>>6^i)<<11)>>16^(i>>6^i)+~((i>>6^i)<<11))&(c[b+12>>2]|0)+-1)<<2)|0;c[f+(g<<2)>>2]=c[i>>2];c[i>>2]=g;g=g+1|0}while((g|0)!=(j|0));return}function PD(b){b=b|0;var d=0;c[b>>2]=20016;d=c[b+60>>2]|0;if(d){if(a[b+64>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+60>>2]=0}a[b+64>>0]=1;c[b+60>>2]=0;c[b+52>>2]=0;c[b+56>>2]=0;d=c[b+40>>2]|0;if(d){if(a[b+44>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+40>>2]=0}a[b+44>>0]=1;c[b+40>>2]=0;c[b+32>>2]=0;c[b+36>>2]=0;d=c[b+16>>2]|0;if(!d){a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;b=b+12|0;c[b>>2]=0;return}if(a[b+20>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+16>>2]=0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;b=b+12|0;c[b>>2]=0;return}function QD(a){a=a|0;PD(a);_E(a);return}function RD(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;d=c[b+16>>2]|0;if(d){if(a[b+20>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;d=c[b+40>>2]|0;if(d){if(a[b+44>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+40>>2]=0}a[b+44>>0]=1;c[b+40>>2]=0;c[b+32>>2]=0;c[b+36>>2]=0;d=c[b+60>>2]|0;if(d){if(a[b+64>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+60>>2]=0}a[b+64>>0]=1;c[b+60>>2]=0;c[b+52>>2]=0;c[b+56>>2]=0;if((c[b+12>>2]|0)>=2){OD(b);return}c[5132]=(c[5132]|0)+1;d=ZE(43)|0;if(!d)g=0;else{c[(d+19&-16)+-4>>2]=d;g=d+19&-16}d=c[b+8>>2]|0;if((d|0)>0){f=0;do{e=g+(f*12|0)|0;if(e){h=(c[b+16>>2]|0)+(f*12|0)|0;c[e+0>>2]=c[h+0>>2];c[e+4>>2]=c[h+4>>2];c[e+8>>2]=c[h+8>>2]}f=f+1|0}while((f|0)!=(d|0))}d=c[b+16>>2]|0;if(d){if(a[b+20>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=g;c[b+12>>2]=2;OD(b);return}function SD(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;c[4996]=(c[4996]|0)+1;h=((d<<16|b)+~((d<<16|b)<<15)>>10^(d<<16|b)+~((d<<16|b)<<15))*9|0;l=c[a+40>>2]|0;h=l+(((c[a+12>>2]|0)+-1&((h>>6^h)+~((h>>6^h)<<11)>>16^(h>>6^h)+~((h>>6^h)<<11)))<<2)|0;f=c[h>>2]|0;if((f|0)==-1){n=0;return n|0}m=c[a+16>>2]|0;e=f;while(1){if((c[m+(e*12|0)>>2]|0)==(b|0)?(c[m+(e*12|0)+4>>2]|0)==(d|0):0)break;e=c[(c[a+60>>2]|0)+(e<<2)>>2]|0;if((e|0)==-1){e=0;n=22;break}}if((n|0)==22)return e|0;if(!(m+(e*12|0)|0)){n=0;return n|0}k=c[m+(e*12|0)+8>>2]|0;j=(e*12|0)/12|0;i=c[a+60>>2]|0;if((f|0)!=(j|0)){while(1){b=i+(f<<2)|0;d=c[b>>2]|0;if((d|0)==(j|0))break;else f=d}e=c[i+(j<<2)>>2]|0;if((f|0)==-1)n=12;else c[b>>2]=e}else{e=c[i+(f<<2)>>2]|0;n=12}if((n|0)==12)c[h>>2]=e;g=(c[a+8>>2]|0)+-1|0;if((g|0)==(j|0)){c[a+8>>2]=j;n=k;return n|0}h=c[m+(g*12|0)+4>>2]<<16|c[m+(g*12|0)>>2];h=(h+~(h<<15)>>10^h+~(h<<15))*9|0;h=((h>>6^h)+~((h>>6^h)<<11)>>16^(h>>6^h)+~((h>>6^h)<<11))&(c[a+12>>2]|0)+-1;e=c[l+(h<<2)>>2]|0;if((e|0)!=(g|0)){b=e;while(1){d=i+(b<<2)|0;f=c[d>>2]|0;if((f|0)==(g|0))break;else b=f}e=c[i+(g<<2)>>2]|0;if((b|0)==-1)n=20;else c[d>>2]=e}else{e=c[i+(g<<2)>>2]|0;n=20}if((n|0)==20)c[l+(h<<2)>>2]=e;c[m+(j*12|0)+0>>2]=c[m+(g*12|0)+0>>2];c[m+(j*12|0)+4>>2]=c[m+(g*12|0)+4>>2];c[m+(j*12|0)+8>>2]=c[m+(g*12|0)+8>>2];n=(c[a+40>>2]|0)+(h<<2)|0;c[(c[a+60>>2]|0)+(j<<2)>>2]=c[n>>2];c[n>>2]=j;c[a+8>>2]=(c[a+8>>2]|0)+-1;n=k;return n|0}function TD(a){a=a|0;return c[a+16>>2]|0}function UD(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;c[4998]=(c[4998]|0)+1;l=((e<<16|d)+~((e<<16|d)<<15)>>10^(e<<16|d)+~((e<<16|d)<<15))*9|0;l=(l>>6^l)+~((l>>6^l)<<11)>>16^(l>>6^l)+~((l>>6^l)<<11);m=c[b+12>>2]|0;f=c[(c[b+40>>2]|0)+((m+-1&l)<<2)>>2]|0;a:do if((f|0)!=-1){g=c[b+16>>2]|0;while(1){if((c[g+(f*12|0)>>2]|0)==(d|0)?(c[g+(f*12|0)+4>>2]|0)==(e|0):0)break;f=c[(c[b+60>>2]|0)+(f<<2)>>2]|0;if((f|0)==-1)break a}f=g+(f*12|0)|0;if(f){b=f;return b|0}}while(0);k=c[b+8>>2]|0;if((k|0)==(m|0)){j=(m|0)==0?1:m<<1;if((m|0)<(j|0)){if(!j){f=0;g=m}else{c[5132]=(c[5132]|0)+1;f=ZE((j*12|3)+16|0)|0;if(!f)f=0;else{c[(f+19&-16)+-4>>2]=f;f=f+19&-16}g=c[b+8>>2]|0}if((g|0)>0){i=0;do{h=f+(i*12|0)|0;if(h){n=(c[b+16>>2]|0)+(i*12|0)|0;c[h+0>>2]=c[n+0>>2];c[h+4>>2]=c[n+4>>2];c[h+8>>2]=c[n+8>>2]}i=i+1|0}while((i|0)!=(g|0))}g=c[b+16>>2]|0;if(g){if(a[b+20>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[g+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=f;c[b+12>>2]=j;g=c[b+8>>2]|0;f=j}else{g=m;f=m}}else{g=k;f=m}c[b+8>>2]=g+1;g=c[b+16>>2]|0;if((m|0)<(f|0)){OD(b);f=(c[b+12>>2]|0)+-1&l}else f=m+-1&l;c[g+(k*12|0)>>2]=d;c[g+(k*12|0)+4>>2]=e;c[g+(k*12|0)+8>>2]=0;n=(c[b+40>>2]|0)+(f<<2)|0;c[(c[b+60>>2]|0)+(k<<2)>>2]=c[n>>2];c[n>>2]=k;n=g+(k*12|0)|0;return n|0}function VD(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0;c[b>>2]=20088;d=c[b+56>>2]|0;if(d){if(a[b+60>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+56>>2]=0}a[b+60>>0]=1;c[b+56>>2]=0;c[b+48>>2]=0;c[b+52>>2]=0;e=c[b+28>>2]|0;if((e|0)>0){j=0;do{f=c[b+36>>2]|0;g=f+(j*36|0)+4|0;h=f+(j*36|0)+12|0;i=c[h>>2]|0;d=f+(j*36|0)+16|0;if(i){if(a[d>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[i+-4>>2]|0)}c[h>>2]=0}a[d>>0]=1;c[h>>2]=0;c[g>>2]=0;c[f+(j*36|0)+8>>2]=0;j=j+1|0}while((j|0)!=(e|0))}d=c[b+36>>2]|0;if(d){if(a[b+40>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;d=c[b+16>>2]|0;if(!d){a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;b=b+12|0;c[b>>2]=0;return}if(a[b+20>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+16>>2]=0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;b=b+12|0;c[b>>2]=0;return}function WD(a){a=a|0;VD(a);if(!a)return;c[5134]=(c[5134]|0)+1;_E(c[a+-4>>2]|0);return}function XD(a){a=a|0;var b=0,d=0,e=0.0,f=0.0,h=0.0,i=0,j=0;i=c[a+28>>2]|0;if((i|0)<=0){a=1;return a|0}b=c[a+36>>2]|0;f=0.0;h=0.0;e=0.0;j=0;a:while(1){switch(j|0){case 4:{e=+g[a+88>>2]+ +g[a+72>>2];h=+g[a+84>>2]+ +g[a+68>>2];f=+g[a+64>>2]-+g[a+80>>2];break}case 2:{e=+g[a+88>>2]+ +g[a+72>>2];h=+g[a+68>>2]-+g[a+84>>2];f=+g[a+80>>2]+ +g[a+64>>2];break}case 1:{e=+g[a+72>>2]-+g[a+88>>2];h=+g[a+84>>2]+ +g[a+68>>2];f=+g[a+80>>2]+ +g[a+64>>2];break}case 3:{e=+g[a+72>>2]-+g[a+88>>2];h=+g[a+68>>2]-+g[a+84>>2];f=+g[a+80>>2]+ +g[a+64>>2];break}case 5:{e=+g[a+72>>2]-+g[a+88>>2];h=+g[a+84>>2]+ +g[a+68>>2];f=+g[a+64>>2]-+g[a+80>>2];break}case 6:{e=+g[a+88>>2]+ +g[a+72>>2];h=+g[a+68>>2]-+g[a+84>>2];f=+g[a+64>>2]-+g[a+80>>2];break}case 0:{e=+g[a+88>>2]+ +g[a+72>>2];h=+g[a+84>>2]+ +g[a+68>>2];f=+g[a+80>>2]+ +g[a+64>>2];break}case 7:{e=+g[a+72>>2]-+g[a+88>>2];h=+g[a+68>>2]-+g[a+84>>2];f=+g[a+64>>2]-+g[a+80>>2];break}default:{}}d=0;do{if(+g[b+(d*36|0)+32>>2]+(f*+g[b+(d*36|0)+20>>2]+h*+g[b+(d*36|0)+24>>2]+e*+g[b+(d*36|0)+28>>2])>0.0){b=0;d=16;break a}d=d+1|0}while((d|0)<(i|0));j=j+1|0;if((j|0)>=8){b=1;d=16;break}}if((d|0)==16)return b|0;return 0}function YD(a,b,d,e,f,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0.0,l=0.0,m=0,n=0.0,o=0.0,p=0,q=0,r=0.0,s=0;q=i;i=i+16|0;g[e>>2]=3402823466385288598117041.0e14;g[f>>2]=-3402823466385288598117041.0e14;m=c[a+8>>2]|0;if((m|0)>0){p=0;do{s=c[a+16>>2]|0;r=+g[s+(p<<4)>>2];o=+g[s+(p<<4)+4>>2];n=+g[s+(p<<4)+8>>2];l=r*+g[b>>2]+o*+g[b+4>>2]+n*+g[b+8>>2]+ +g[b+48>>2];k=r*+g[b+16>>2]+o*+g[b+20>>2]+n*+g[b+24>>2]+ +g[b+52>>2];n=r*+g[b+32>>2]+o*+g[b+36>>2]+n*+g[b+40>>2]+ +g[b+56>>2];o=l*+g[d>>2]+k*+g[d+4>>2]+n*+g[d+8>>2];if(o<+g[e>>2]){g[e>>2]=o;g[h>>2]=l;g[h+4>>2]=k;g[h+8>>2]=n;g[h+12>>2]=0.0}if(o>+g[f>>2]){g[f>>2]=o;g[j>>2]=l;g[j+4>>2]=k;g[j+8>>2]=n;g[j+12>>2]=0.0}p=p+1|0}while((p|0)!=(m|0));l=+g[f>>2]}else l=-3402823466385288598117041.0e14;k=+g[e>>2];if(!(k>l)){i=q;return}g[e>>2]=l;g[f>>2]=k;c[q+0>>2]=c[h+0>>2];c[q+4>>2]=c[h+4>>2];c[q+8>>2]=c[h+8>>2];c[q+12>>2]=c[h+12>>2];c[h+0>>2]=c[j+0>>2];c[h+4>>2]=c[j+4>>2];c[h+8>>2]=c[j+8>>2];c[h+12>>2]=c[j+12>>2];c[j+0>>2]=c[q+0>>2];c[j+4>>2]=c[q+4>>2];c[j+8>>2]=c[q+8>>2];c[j+12>>2]=c[q+12>>2];i=q;return}function ZD(b){b=b|0;var d=0;c[b>>2]=20136;d=c[b+32>>2]|0;if(d){if(a[b+36>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;return}function _D(b){b=b|0;var d=0;c[b>>2]=20136;d=c[b+32>>2]|0;if(!d){a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0}else{if(a[b+36>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0}c[5134]=(c[5134]|0)+1;_E(c[b+-4>>2]|0);return}function $D(a,b,d,e,f,g,h,i,j,k){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;a=c[a+32>>2]|0;c[d>>2]=c[a+(k<<5)+12>>2];c[b>>2]=c[a+(k<<5)+16>>2];c[e>>2]=c[a+(k<<5)+28>>2];c[f>>2]=c[a+(k<<5)+20>>2];c[i>>2]=c[a+(k<<5)>>2];c[g>>2]=c[a+(k<<5)+4>>2];c[h>>2]=c[a+(k<<5)+8>>2];c[j>>2]=c[a+(k<<5)+24>>2];return}function aE(a,b,d,e,f,g,h,i,j,k){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;a=c[a+32>>2]|0;c[d>>2]=c[a+(k<<5)+12>>2];c[b>>2]=c[a+(k<<5)+16>>2];c[e>>2]=c[a+(k<<5)+28>>2];c[f>>2]=c[a+(k<<5)+20>>2];c[i>>2]=c[a+(k<<5)>>2];c[g>>2]=c[a+(k<<5)+4>>2];c[h>>2]=c[a+(k<<5)+8>>2];c[j>>2]=c[a+(k<<5)+24>>2];return}function bE(a){a=a|0;return (c[a+48>>2]|0)==1|0}function cE(a,b,d){a=a|0;b=b|0;d=d|0;c[a+52>>2]=c[b+0>>2];c[a+56>>2]=c[b+4>>2];c[a+60>>2]=c[b+8>>2];c[a+64>>2]=c[b+12>>2];c[a+68>>2]=c[d+0>>2];c[a+72>>2]=c[d+4>>2];c[a+76>>2]=c[d+8>>2];c[a+80>>2]=c[d+12>>2];c[a+48>>2]=1;return}function dE(a,b,d){a=a|0;b=b|0;d=d|0;c[b+0>>2]=c[a+52>>2];c[b+4>>2]=c[a+56>>2];c[b+8>>2]=c[a+60>>2];c[b+12>>2]=c[a+64>>2];c[d+0>>2]=c[a+68>>2];c[d+4>>2]=c[a+72>>2];c[d+8>>2]=c[a+76>>2];c[d+12>>2]=c[a+80>>2];return}function eE(a,b){a=a|0;b=b|0;return}function fE(a,b){a=a|0;b=b|0;return}function gE(a,b,f,j){a=a|0;b=b|0;f=f|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0.0,w=0.0,x=0.0,y=0,z=0,A=0.0,B=0.0,C=0,D=0,E=0,F=0,G=0;z=i;i=i+96|0;u=Nb[c[(c[a>>2]|0)+28>>2]&127](a)|0;v=+g[a+4>>2];w=+g[a+8>>2];x=+g[a+12>>2];if((u|0)<=0){i=z;return}j=z+28|0;k=z+32|0;l=z+36|0;m=z+40|0;n=z+44|0;o=z+48|0;p=z+52|0;q=z+56|0;r=z+60|0;s=z+64|0;t=z+68|0;y=0;do{dc[c[(c[a>>2]|0)+16>>2]&3](a,z+76|0,z+12|0,z+8|0,z,z+16|0,z+4|0,z+72|0,z+80|0,y);f=c[z+8>>2]|0;do if((f|0)==1){f=c[z+80>>2]|0;if((f|0)==5){if((c[z+72>>2]|0)>0)f=0;else break;do{F=c[z+16>>2]|0;E=$(c[z+4>>2]|0,f)|0;D=c[z+76>>2]|0;C=c[z>>2]|0;G=$(d[F+E>>0]|0,C)|0;B=w*+h[D+(G+8)>>3];A=x*+h[D+(G+16)>>3];g[z+24>>2]=v*+h[D+G>>3];g[j>>2]=B;g[k>>2]=A;g[l>>2]=0.0;G=$(d[F+(E+1)>>0]|0,C)|0;A=w*+h[D+(G+8)>>3];B=x*+h[D+(G+16)>>3];g[m>>2]=v*+h[D+G>>3];g[n>>2]=A;g[o>>2]=B;g[p>>2]=0.0;C=$(d[F+(E+2)>>0]|0,C)|0;B=w*+h[D+(C+8)>>3];A=x*+h[D+(C+16)>>3];g[q>>2]=v*+h[D+C>>3];g[r>>2]=B;g[s>>2]=A;g[t>>2]=0.0;tc[c[(c[b>>2]|0)+8>>2]&127](b,z+24|0,y,f);f=f+1|0}while((f|0)<(c[z+72>>2]|0))}else if((f|0)==3){if((c[z+72>>2]|0)>0)f=0;else break;do{E=c[z+16>>2]|0;F=$(c[z+4>>2]|0,f)|0;G=c[z+76>>2]|0;C=c[z>>2]|0;D=$(e[E+F>>1]|0,C)|0;A=w*+h[G+(D+8)>>3];B=x*+h[G+(D+16)>>3];g[z+24>>2]=v*+h[G+D>>3];g[j>>2]=A;g[k>>2]=B;g[l>>2]=0.0;D=$(e[E+(F+2)>>1]|0,C)|0;B=w*+h[G+(D+8)>>3];A=x*+h[G+(D+16)>>3];g[m>>2]=v*+h[G+D>>3];g[n>>2]=B;g[o>>2]=A;g[p>>2]=0.0;C=$(e[E+(F+4)>>1]|0,C)|0;A=w*+h[G+(C+8)>>3];B=x*+h[G+(C+16)>>3];g[q>>2]=v*+h[G+C>>3];g[r>>2]=A;g[s>>2]=B;g[t>>2]=0.0;tc[c[(c[b>>2]|0)+8>>2]&127](b,z+24|0,y,f);f=f+1|0}while((f|0)<(c[z+72>>2]|0))}else if((f|0)==2){if((c[z+72>>2]|0)>0)f=0;else break;do{F=c[z+16>>2]|0;C=$(c[z+4>>2]|0,f)|0;G=c[z+76>>2]|0;E=c[z>>2]|0;D=$(E,c[F+C>>2]|0)|0;A=w*+h[G+(D+8)>>3];B=x*+h[G+(D+16)>>3];g[z+24>>2]=v*+h[G+D>>3];g[j>>2]=A;g[k>>2]=B;g[l>>2]=0.0;D=$(E,c[F+(C+4)>>2]|0)|0;B=w*+h[G+(D+8)>>3];A=x*+h[G+(D+16)>>3];g[m>>2]=v*+h[G+D>>3];g[n>>2]=B;g[o>>2]=A;g[p>>2]=0.0;C=$(E,c[F+(C+8)>>2]|0)|0;A=w*+h[G+(C+8)>>3];B=x*+h[G+(C+16)>>3];g[q>>2]=v*+h[G+C>>3];g[r>>2]=A;g[s>>2]=B;g[t>>2]=0.0;tc[c[(c[b>>2]|0)+8>>2]&127](b,z+24|0,y,f);f=f+1|0}while((f|0)<(c[z+72>>2]|0))}else break}else if(!f){f=c[z+80>>2]|0;if((f|0)==3){if((c[z+72>>2]|0)>0)f=0;else break;do{E=c[z+16>>2]|0;F=$(c[z+4>>2]|0,f)|0;G=c[z+76>>2]|0;C=c[z>>2]|0;D=$(e[E+F>>1]|0,C)|0;A=w*+g[G+(D+4)>>2];B=x*+g[G+(D+8)>>2];g[z+24>>2]=v*+g[G+D>>2];g[j>>2]=A;g[k>>2]=B;g[l>>2]=0.0;D=$(e[E+(F+2)>>1]|0,C)|0;B=w*+g[G+(D+4)>>2];A=x*+g[G+(D+8)>>2];g[m>>2]=v*+g[G+D>>2];g[n>>2]=B;g[o>>2]=A;g[p>>2]=0.0;C=$(e[E+(F+4)>>1]|0,C)|0;A=w*+g[G+(C+4)>>2];B=x*+g[G+(C+8)>>2];g[q>>2]=v*+g[G+C>>2];g[r>>2]=A;g[s>>2]=B;g[t>>2]=0.0;tc[c[(c[b>>2]|0)+8>>2]&127](b,z+24|0,y,f);f=f+1|0}while((f|0)<(c[z+72>>2]|0))}else if((f|0)==2){if((c[z+72>>2]|0)>0)f=0;else break;do{F=c[z+16>>2]|0;C=$(c[z+4>>2]|0,f)|0;G=c[z+76>>2]|0;E=c[z>>2]|0;D=$(E,c[F+C>>2]|0)|0;A=w*+g[G+(D+4)>>2];B=x*+g[G+(D+8)>>2];g[z+24>>2]=v*+g[G+D>>2];g[j>>2]=A;g[k>>2]=B;g[l>>2]=0.0;D=$(E,c[F+(C+4)>>2]|0)|0;B=w*+g[G+(D+4)>>2];A=x*+g[G+(D+8)>>2];g[m>>2]=v*+g[G+D>>2];g[n>>2]=B;g[o>>2]=A;g[p>>2]=0.0;C=$(E,c[F+(C+8)>>2]|0)|0;A=w*+g[G+(C+4)>>2];B=x*+g[G+(C+8)>>2];g[q>>2]=v*+g[G+C>>2];g[r>>2]=A;g[s>>2]=B;g[t>>2]=0.0;tc[c[(c[b>>2]|0)+8>>2]&127](b,z+24|0,y,f);f=f+1|0}while((f|0)<(c[z+72>>2]|0))}else if((f|0)==5){if((c[z+72>>2]|0)>0)f=0;else break;do{E=c[z+16>>2]|0;F=$(c[z+4>>2]|0,f)|0;G=c[z+76>>2]|0;C=c[z>>2]|0;D=$(d[E+F>>0]|0,C)|0;A=w*+g[G+(D+4)>>2];B=x*+g[G+(D+8)>>2];g[z+24>>2]=v*+g[G+D>>2];g[j>>2]=A;g[k>>2]=B;g[l>>2]=0.0;D=$(d[E+(F+1)>>0]|0,C)|0;B=w*+g[G+(D+4)>>2];A=x*+g[G+(D+8)>>2];g[m>>2]=v*+g[G+D>>2];g[n>>2]=B;g[o>>2]=A;g[p>>2]=0.0;C=$(d[E+(F+2)>>0]|0,C)|0;A=w*+g[G+(C+4)>>2];B=x*+g[G+(C+8)>>2];g[q>>2]=v*+g[G+C>>2];g[r>>2]=A;g[s>>2]=B;g[t>>2]=0.0;tc[c[(c[b>>2]|0)+8>>2]&127](b,z+24|0,y,f);f=f+1|0}while((f|0)<(c[z+72>>2]|0))}else break}while(0);Lb[c[(c[a>>2]|0)+24>>2]&127](a,y);y=y+1|0}while((y|0)!=(u|0));i=z;return}function hE(d,e,f){d=d|0;e=e|0;f=f|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0.0,y=0;w=i;i=i+32|0;j=Nb[c[(c[d>>2]|0)+28>>2]&127](d)|0;c[e+20>>2]=j;c[e>>2]=0;if(!j){f=e+4|0;v=d+4|0;x=+g[v>>2];g[f>>2]=x;f=d+8|0;x=+g[f>>2];f=e+8|0;g[f>>2]=x;f=d+12|0;x=+g[f>>2];f=e+12|0;g[f>>2]=x;d=d+16|0;x=+g[d>>2];d=e+16|0;g[d>>2]=x;i=w;return 20384}v=Wb[c[(c[f>>2]|0)+16>>2]&63](f,32,j)|0;j=c[v+8>>2]|0;c[e>>2]=ec[c[(c[f>>2]|0)+28>>2]&31](f,j)|0;s=Nb[c[(c[d>>2]|0)+28>>2]&127](d)|0;if((s|0)>0){r=0;while(1){dc[c[(c[d>>2]|0)+16>>2]&3](d,w+4|0,w+12|0,w+20|0,w,w+16|0,w+8|0,w+24|0,w+28|0,r);c[j+24>>2]=c[w+24>>2];c[j+28>>2]=c[w+12>>2];l=j+8|0;p=j+12|0;o=j+16|0;q=j+4|0;c[j+0>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;c[j+12>>2]=0;c[j+16>>2]=0;c[j+20>>2]=0;m=c[w+28>>2]|0;if((m|0)==2){k=c[w+24>>2]|0;if(k){o=Wb[c[(c[f>>2]|0)+16>>2]&63](f,4,k*3|0)|0;n=c[o+8>>2]|0;c[l>>2]=ec[c[(c[f>>2]|0)+28>>2]&31](f,n)|0;if((c[w+24>>2]|0)>0){m=c[w+16>>2]|0;l=0;do{k=$(c[w+8>>2]|0,l)|0;p=l*3|0;c[n+(p<<2)>>2]=c[m+k>>2];c[n+(p+1<<2)>>2]=c[m+(k+4)>>2];c[n+(p+2<<2)>>2]=c[m+(k+8)>>2];l=l+1|0}while((l|0)<(c[w+24>>2]|0))}Hb[c[(c[f>>2]|0)+20>>2]&31](f,o,20248,1497453121,c[o+8>>2]|0)}}else if((m|0)==5){k=c[w+24>>2]|0;if(k){l=Wb[c[(c[f>>2]|0)+16>>2]&63](f,4,k)|0;m=c[l+8>>2]|0;c[o>>2]=ec[c[(c[f>>2]|0)+28>>2]&31](f,m)|0;if((c[w+24>>2]|0)>0){k=0;do{o=c[w+16>>2]|0;p=$(c[w+8>>2]|0,k)|0;a[m+(k<<2)>>0]=a[o+p>>0]|0;a[m+(k<<2)+1>>0]=a[o+(p+1)>>0]|0;a[m+(k<<2)+2>>0]=a[o+(p+2)>>0]|0;k=k+1|0}while((k|0)<(c[w+24>>2]|0))}Hb[c[(c[f>>2]|0)+20>>2]&31](f,l,20296,1497453121,c[l+8>>2]|0)}}else if((m|0)==3?(u=c[w+24>>2]|0,(u|0)!=0):0){l=Wb[c[(c[f>>2]|0)+16>>2]&63](f,8,u)|0;k=c[l+8>>2]|0;c[p>>2]=ec[c[(c[f>>2]|0)+28>>2]&31](f,k)|0;p=c[w+24>>2]|0;if((p|0)>0){o=c[w+16>>2]|0;n=c[w+8>>2]|0;m=0;do{y=$(n,m)|0;b[k+(m<<3)>>1]=b[o+y>>1]|0;b[k+(m<<3)+2>>1]=b[o+(y+2)>>1]|0;b[k+(m<<3)+4>>1]=b[o+(y+4)>>1]|0;m=m+1|0}while((m|0)!=(p|0))}Hb[c[(c[f>>2]|0)+20>>2]&31](f,l,20264,1497453121,c[l+8>>2]|0)}k=c[w+20>>2]|0;if((k|0)==1){k=c[w+12>>2]|0;if(k){l=Wb[c[(c[f>>2]|0)+16>>2]&63](f,32,k)|0;k=c[l+8>>2]|0;c[q>>2]=ec[c[(c[f>>2]|0)+28>>2]&31](f,k)|0;o=c[w+12>>2]|0;if((o|0)>0){n=c[w+4>>2]|0;m=c[w>>2]|0;p=0;do{y=$(m,p)|0;h[k+(p<<5)>>3]=+h[n+y>>3];h[k+(p<<5)+8>>3]=+h[n+(y+8)>>3];h[k+(p<<5)+16>>3]=+h[n+(y+16)>>3];p=p+1|0}while((p|0)!=(o|0))}Hb[c[(c[f>>2]|0)+20>>2]&31](f,l,20344,1497453121,c[l+8>>2]|0)}}else if((k|0)==0?(t=c[w+12>>2]|0,(t|0)!=0):0){m=Wb[c[(c[f>>2]|0)+16>>2]&63](f,16,t)|0;l=c[m+8>>2]|0;c[j>>2]=ec[c[(c[f>>2]|0)+28>>2]&31](f,l)|0;k=c[w+12>>2]|0;if((k|0)>0){n=c[w+4>>2]|0;o=c[w>>2]|0;p=0;do{y=$(o,p)|0;g[l+(p<<4)>>2]=+g[n+y>>2];g[l+(p<<4)+4>>2]=+g[n+(y+4)>>2];g[l+(p<<4)+8>>2]=+g[n+(y+8)>>2];p=p+1|0}while((p|0)!=(k|0))}Hb[c[(c[f>>2]|0)+20>>2]&31](f,m,20320,1497453121,c[m+8>>2]|0)}Lb[c[(c[d>>2]|0)+24>>2]&127](d,r);r=r+1|0;if((r|0)==(s|0)){j=f;break}else j=j+32|0}}else j=f;Hb[c[(c[j>>2]|0)+20>>2]&31](f,v,20368,1497453121,c[v+8>>2]|0);y=e+4|0;f=d+4|0;x=+g[f>>2];g[y>>2]=x;y=d+8|0;x=+g[y>>2];y=e+8|0;g[y>>2]=x;y=d+12|0;x=+g[y>>2];y=e+12|0;g[y>>2]=x;y=d+16|0;x=+g[y>>2];y=e+16|0;g[y>>2]=x;i=w;return 20384}function iE(a){a=a|0;var b=0;do{c[a+4>>2]=0;g[a+8>>2]=0.0;b=c[a+24>>2]|0;if(b)iE(b);a=c[a+28>>2]|0}while((a|0)!=0);return}function jE(a){a=a|0;var b=0,d=0,e=0,f=0;f=i;i=i+16|0;e=c[5128]|0;if((c[e>>2]|0)==(a|0))b=e;else{b=c[e+24>>2]|0;a:do if(!b)d=5;else while(1){if((c[b>>2]|0)==(a|0))break a;b=c[b+28>>2]|0;if(!b){d=5;break}}while(0);if((d|0)==5){b=ZE(36)|0;b:do if(!b){while(1){b=c[5254]|0;c[5254]=b+0;if(!b)break;qc[b&3]();b=ZE(36)|0;if(b)break b}f=yb(4)|0;c[f>>2]=20912;wb(f|0,20960,207)}while(0);c[b>>2]=a;a=b+4|0;c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;c[b+20>>2]=e;c[b+24>>2]=0;a=b+28|0;c[a>>2]=0;c[b+32>>2]=0;iE(b);c[a>>2]=c[e+24>>2];c[e+24>>2]=b}c[5128]=b}e=b+4|0;c[e>>2]=(c[e>>2]|0)+1;e=b+16|0;a=c[e>>2]|0;c[e>>2]=a+1;if(a){i=f;return}Cb(f|0,0)|0;a=c[5114]|0;c[b+12>>2]=(c[f+4>>2]|0)-(c[a+4>>2]|0)+(((c[f>>2]|0)-(c[a>>2]|0)|0)*1e6|0);i=f;return}function kE(){var a=0;a=ZE(8)|0;a:do if(!a){while(1){a=c[5254]|0;c[5254]=a+0;if(!a)break;qc[a&3]();a=ZE(8)|0;if(a)break a}a=yb(4)|0;c[a>>2]=20912;wb(a|0,20960,207)}while(0);c[5114]=a;Cb(a|0,0)|0;c[5116]=20504;c[5117]=0;c[5118]=0;c[5119]=0;c[5120]=0;c[5121]=0;c[5122]=0;c[5123]=0;c[5124]=0;iE(20464);return}function lE(a,b,c,d,e,f,g,h,i,j){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0,m=0,n=0,o=0;if((e|0)!=(j|0)){e=e-j|0;return e|0}if(!e){e=0;return e|0}m=pF(h|0,0,a|0,0)|0;n=D;l=pF(i|0,0,a|0,0)|0;o=D;j=pF(h|0,0,b|0,0)|0;a=D;k=pF(i|0,0,b|0,0)|0;b=D;j=eF(l|0,0,j|0,0)|0;l=D;b=eF(o|0,0,k|0,b|0)|0;b=eF(b|0,D|0,a|0,0)|0;a=D;j=eF(m|0,n|0,0,j|0)|0;k=D;m=eF(b|0,a|0,(k>>>0<n>>>0|(k|0)==(n|0)&j>>>0<m>>>0)&1|0,0)|0;l=eF(m|0,D|0,l|0,0)|0;m=D;a=pF(f|0,0,c|0,0)|0;n=D;b=pF(g|0,0,c|0,0)|0;c=D;i=pF(f|0,0,d|0,0)|0;f=D;h=pF(g|0,0,d|0,0)|0;g=D;i=eF(b|0,0,i|0,0)|0;b=D;g=eF(c|0,0,h|0,g|0)|0;f=eF(g|0,D|0,f|0,0)|0;g=D;i=eF(a|0,n|0,0,i|0)|0;h=D;a=eF(f|0,g|0,(h>>>0<n>>>0|(h|0)==(n|0)&i>>>0<a>>>0)&1|0,0)|0;b=eF(a|0,D|0,b|0,0)|0;a=D;if(!(m>>>0<a>>>0|(m|0)==(a|0)&l>>>0<b>>>0))if(!(m>>>0>a>>>0|(m|0)==(a|0)&l>>>0>b>>>0))if(k>>>0<h>>>0|(k|0)==(h|0)&j>>>0<i>>>0)i=-1;else i=(k>>>0>h>>>0|(k|0)==(h|0)&j>>>0>i>>>0)&1;else i=1;else i=-1;o=$(i,e)|0;return o|0}function mE(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0;e=c[a+56>>2]|0;if(!e){e=c[a+52>>2]|0;if(!e){c[5132]=(c[5132]|0)+1;f=ZE(31)|0;if((f|0)!=0?(g=f+19&-16,c[g+-4>>2]=f,(f+19&-16|0)!=0):0){e=c[a+60>>2]|0;c[g+4>>2]=e;c[g+8>>2]=0;c[5132]=(c[5132]|0)+1;e=ZE((e*24|3)+16|0)|0;if(!e)e=0;else{c[(e+19&-16)+-4>>2]=e;e=e+19&-16}c[(f+19&-16)>>2]=e;e=f+19&-16}else e=0;c[e+8>>2]=c[a+48>>2];c[a+48>>2]=e}else c[a+52>>2]=c[e+8>>2];h=c[e+4>>2]|0;i=c[e>>2]|0;if((h|0)>0){g=0;f=i;do{g=g+1|0;e=f;f=f+24|0;c[e>>2]=(g|0)<(h|0)?f:0}while((g|0)!=(h|0))}e=c[i>>2]|0;c[a+56>>2]=e;if(!i)h=0;else{e=i;k=14}}else{c[a+56>>2]=c[e>>2];k=14}if((k|0)==14){c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[e+20>>2]=0;h=e;e=c[a+56>>2]|0}if(!e){e=c[a+52>>2]|0;if(!e){c[5132]=(c[5132]|0)+1;g=ZE(31)|0;if((g|0)!=0?(j=g+19&-16,c[j+-4>>2]=g,(g+19&-16|0)!=0):0){e=c[a+60>>2]|0;c[j+4>>2]=e;c[j+8>>2]=0;c[5132]=(c[5132]|0)+1;e=ZE((e*24|3)+16|0)|0;if(!e)e=0;else{c[(e+19&-16)+-4>>2]=e;e=e+19&-16}c[(g+19&-16)>>2]=e;e=g+19&-16}else e=0;c[e+8>>2]=c[a+48>>2];c[a+48>>2]=e}else c[a+52>>2]=c[e+8>>2];i=c[e+4>>2]|0;e=c[e>>2]|0;if((i|0)>0){g=0;f=e;do{g=g+1|0;j=f;f=f+24|0;c[j>>2]=(g|0)<(i|0)?f:0}while((g|0)!=(i|0))}c[a+56>>2]=c[e>>2];if(!e)e=0;else k=28}else{c[a+56>>2]=c[e>>2];k=28}if((k|0)==28){c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[e+20>>2]=0}c[h+8>>2]=e;c[e+8>>2]=h;k=c[a+100>>2]|0;c[h+20>>2]=k;c[e+20>>2]=k;c[h+12>>2]=d;c[e+12>>2]=b;c[h+16>>2]=0;c[e+16>>2]=0;e=c[a+116>>2]|0;c[a+116>>2]=e+1;if((e|0)<(c[a+120>>2]|0))return h|0;c[a+120>>2]=e+1;return h|0}
function Vp(b,d,e,f){b=b|0;d=+d;e=e|0;f=+f;var h=0,j=0.0,k=0,l=0;l=i;i=i+16|0;Cb(c[5114]|0,0)|0;iE(20464);c[5117]=(c[5117]|0)+1;k=c[5120]|0;c[5120]=k+1;if(!k){Cb(l|0,0)|0;k=c[5114]|0;c[5119]=(c[l+4>>2]|0)-(c[k+4>>2]|0)+(((c[l>>2]|0)-(c[k>>2]|0)|0)*1e6|0)}c[5130]=0;Cb(l|0,0)|0;jE(1888);if(e){g[b+268>>2]=f;j=+g[b+264>>2]+d;g[b+264>>2]=j;if(!(j>=f)){d=f;k=0}else{g[b+264>>2]=j-+(~~(j/f)|0)*f;d=f;k=~~(j/f)}}else{g[b+264>>2]=(a[b+300>>0]|0)!=0?0.0:d;g[b+268>>2]=0.0;k=!(+O(+d)<1.1920928955078125e-07)&1;e=k}if(Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0){h=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;a[1544]=(Nb[c[(c[h>>2]|0)+48>>2]&127](h)|0)>>>4&1}if(k){h=(k|0)>(e|0)?e:k;Ib[c[(c[b>>2]|0)+164>>2]&31](b,d*+(h|0));Jb[c[(c[b>>2]|0)+168>>2]&255](b);if((h|0)>0){e=0;do{Ib[c[(c[b>>2]|0)+160>>2]&31](b,d);Jb[c[(c[b>>2]|0)+80>>2]&255](b);e=e+1|0}while((e|0)<(h|0))}}else Jb[c[(c[b>>2]|0)+80>>2]&255](b);Jb[c[(c[b>>2]|0)+120>>2]&255](b);c[5130]=(c[5130]|0)+1;h=c[5128]|0;b=(c[h+16>>2]|0)+-1|0;c[h+16>>2]=b;if(b){i=l;return k|0}do if(c[h+4>>2]|0){Cb(l|0,0)|0;b=c[5114]|0;g[h+8>>2]=+(((c[l+4>>2]|0)-(c[b+4>>2]|0)+(((c[l>>2]|0)-(c[b>>2]|0)|0)*1e6|0)-(c[h+12>>2]|0)|0)>>>0)/1.0e3+ +g[h+8>>2];if(!(c[h+16>>2]|0)){h=c[5128]|0;break}else{i=l;return k|0}}while(0);c[5128]=c[h+20>>2];i=l;return k|0}function Wp(d,e){d=d|0;e=+e;var f=0,h=0,j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0,r=0,s=0,t=0,u=0,v=0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0;D=i;i=i+464|0;jE(1904);f=c[d+84>>2]|0;if(f)Ib[f&31](d,e);Ib[c[(c[d>>2]|0)+140>>2]&31](d,e);g[d+28>>2]=e;c[d+32>>2]=0;c[d+48>>2]=Nb[c[(c[d>>2]|0)+20>>2]&127](d)|0;jE(2040);jE(2072);f=c[d+316>>2]|0;if((c[d+308>>2]|0)>0){h=0;do{r=c[d+24>>2]|0;Lb[c[(c[r>>2]|0)+16>>2]&127](r,c[f+(h<<2)>>2]|0);h=h+1|0;f=c[d+316>>2]|0}while((h|0)<(c[d+308>>2]|0))}if(f){if(a[d+320>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[f+-4>>2]|0)}c[d+316>>2]=0}a[d+320>>0]=1;c[d+316>>2]=0;c[d+308>>2]=0;c[d+312>>2]=0;f=c[5128]|0;r=(c[f+16>>2]|0)+-1|0;c[f+16>>2]=r;do if(!r){if(c[f+4>>2]|0){Cb(D+280|0,0)|0;r=c[5114]|0;g[f+8>>2]=+(((c[D+284>>2]|0)-(c[r+4>>2]|0)+(((c[D+280>>2]|0)-(c[r>>2]|0)|0)*1e6|0)-(c[f+12>>2]|0)|0)>>>0)/1.0e3+ +g[f+8>>2];if(c[f+16>>2]|0)break;f=c[5128]|0}c[5128]=c[f+20>>2]}while(0);if((c[d+232>>2]|0)>0){s=D+264|0;t=D+164|0;r=D+400|0;u=0;do{l=c[(c[d+240>>2]|0)+(u<<2)>>2]|0;g[l+244>>2]=1.0;q=c[l+216>>2]|0;do if(((!((q|0)==2|(q|0)==5)?(c[l+204>>2]&3|0)==0:0)?(Jp(l+4|0,+g[l+312>>2],+g[l+316>>2],+g[l+320>>2],l+328|0,e,D+216|0),w=+g[s>>2],x=w-+g[l+52>>2],y=+g[D+268>>2],z=y-+g[l+56>>2],A=+g[D+272>>2],B=A-+g[l+60>>2],(a[d+44>>0]|0)!=0):0)?(p=+g[l+252>>2],p*p!=0.0?p*p<x*x+z*z+B*B:0):0){jE(2112);if((c[(c[l+192>>2]|0)+4>>2]|0)<20?(c[508]=(c[508]|0)+1,k=c[d+68>>2]|0,k=Nb[c[(c[k>>2]|0)+36>>2]&127](k)|0,q=c[d+24>>2]|0,g[D+124>>2]=1.0,b[D+128>>1]=1,b[D+130>>1]=-1,c[D+120>>2]=976,c[D+132>>2]=c[l+52>>2],c[D+136>>2]=c[l+56>>2],c[D+140>>2]=c[l+60>>2],c[D+144>>2]=c[l+64>>2],c[D+148>>2]=c[s+0>>2],c[D+152>>2]=c[s+4>>2],c[D+156>>2]=c[s+8>>2],c[D+160>>2]=c[s+12>>2],c[D+196>>2]=0,c[D+120>>2]=2392,c[D+200>>2]=l,c[D+208>>2]=k,c[D+212>>2]=q,C=+g[l+248>>2],c[D+72>>2]=0,g[D+76>>2]=1.0,g[D+80>>2]=1.0,g[D+84>>2]=1.0,g[D+88>>2]=0.0,c[D+64>>2]=12104,c[D+68>>2]=8,g[D+92>>2]=C,g[D+108>>2]=C,g[D+204>>2]=+g[d+56>>2],q=c[l+188>>2]|0,b[D+128>>1]=b[q+4>>1]|0,b[D+130>>1]=b[q+6>>1]|0,c[D+48>>2]=c[s+0>>2],c[D+52>>2]=c[s+4>>2],c[D+56>>2]=c[s+8>>2],c[D+60>>2]=c[s+12>>2],c[D+0>>2]=c[l+4>>2],c[D+4>>2]=c[l+8>>2],c[D+8>>2]=c[l+12>>2],c[D+12>>2]=c[l+16>>2],c[D+16>>2]=c[l+20>>2],c[D+20>>2]=c[l+24>>2],c[D+24>>2]=c[l+28>>2],c[D+28>>2]=c[l+32>>2],c[D+32>>2]=c[l+36>>2],c[D+36>>2]=c[l+40>>2],c[D+40>>2]=c[l+44>>2],c[D+44>>2]=c[l+48>>2],hv(d,D+64|0,l+4|0,D,D+120|0,0.0),C=+g[D+124>>2],C<1.0):0){m=C*(w-+g[l+52>>2]);n=C*(y-+g[l+56>>2]);o=C*(A-+g[l+60>>2]);p=-(n*+g[D+168>>2])-m*+g[t>>2]-o*+g[D+172>>2];q=c[d+24>>2]|0;q=Wb[c[(c[q>>2]|0)+12>>2]&63](q,l,c[D+196>>2]|0)|0;f=c[d+308>>2]|0;if((f|0)==(c[d+312>>2]|0)?(v=(f|0)==0?1:f<<1,(f|0)<(v|0)):0){if(!v)h=0;else{c[5132]=(c[5132]|0)+1;h=ZE((v<<2|3)+16|0)|0;if(!h)h=0;else{c[(h+19&-16)+-4>>2]=h;h=h+19&-16}f=c[d+308>>2]|0}if((f|0)>0){k=0;do{j=h+(k<<2)|0;if(j)c[j>>2]=c[(c[d+316>>2]|0)+(k<<2)>>2];k=k+1|0}while((k|0)!=(f|0))}j=c[d+316>>2]|0;if(j){if(a[d+320>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[j+-4>>2]|0);f=c[d+308>>2]|0}c[d+316>>2]=0}a[d+320>>0]=1;c[d+316>>2]=h;c[d+312>>2]=v}h=(c[d+316>>2]|0)+(f<<2)|0;if(h)c[h>>2]=q;c[d+308>>2]=f+1;m=m+ +g[l+52>>2];n=n+ +g[l+56>>2];o=o+ +g[l+60>>2];k=c[D+196>>2]|0;P=+g[k+4>>2];O=+g[k+20>>2];N=+g[k+36>>2];M=+g[k+8>>2];L=+g[k+24>>2];K=+g[k+40>>2];J=+g[k+12>>2];H=+g[k+28>>2];F=+g[k+44>>2];I=-+g[k+52>>2];G=-+g[k+56>>2];E=-+g[k+60>>2];c[D+280>>2]=0;c[D+284>>2]=0;c[D+288>>2]=0;c[D+292>>2]=0;g[D+296>>2]=m*P+n*O+o*N+(P*I+O*G+N*E);g[D+300>>2]=m*M+n*L+o*K+(M*I+L*G+K*E);g[D+304>>2]=m*J+n*H+o*F+(J*I+H*G+F*E);g[D+308>>2]=0.0;c[D+344>>2]=c[t+0>>2];c[D+348>>2]=c[t+4>>2];c[D+352>>2]=c[t+8>>2];c[D+356>>2]=c[t+12>>2];g[D+360>>2]=p;g[D+364>>2]=0.0;g[D+368>>2]=0.0;g[D+372>>2]=0.0;c[D+392>>2]=0;a[D+396>>0]=0;c[r+0>>2]=0;c[r+4>>2]=0;c[r+8>>2]=0;c[r+12>>2]=0;c[r+16>>2]=0;c[r+20>>2]=0;c[r+24>>2]=0;c[r+28>>2]=0;k=Ns(q,D+280|0)|0;g[q+(k*184|0)+96>>2]=0.0;p=+g[l+224>>2]*+g[(c[D+196>>2]|0)+224>>2];p=p<-10.0?-10.0:p;g[q+(k*184|0)+88>>2]=p>10.0?10.0:p;c[q+(k*184|0)+52>>2]=c[l+52>>2];c[q+(k*184|0)+56>>2]=c[l+56>>2];c[q+(k*184|0)+60>>2]=c[l+60>>2];c[q+(k*184|0)+64>>2]=c[l+64>>2];g[q+(k*184|0)+36>>2]=m;g[q+(k*184|0)+40>>2]=n;g[q+(k*184|0)+44>>2]=o;g[q+(k*184|0)+48>>2]=0.0}h=c[5128]|0;q=(c[h+16>>2]|0)+-1|0;c[h+16>>2]=q;if(!q){if(c[h+4>>2]|0){Cb(D+280|0,0)|0;q=c[5114]|0;g[h+8>>2]=+(((c[D+284>>2]|0)-(c[q+4>>2]|0)+(((c[D+280>>2]|0)-(c[q>>2]|0)|0)*1e6|0)-(c[h+12>>2]|0)|0)>>>0)/1.0e3+ +g[h+8>>2];if(c[h+16>>2]|0)break;h=c[5128]|0}c[5128]=c[h+20>>2]}}while(0);u=u+1|0}while((u|0)<(c[d+232>>2]|0))}f=c[5128]|0;r=(c[f+16>>2]|0)+-1|0;c[f+16>>2]=r;do if(!r){if(c[f+4>>2]|0){Cb(D+280|0,0)|0;r=c[5114]|0;g[f+8>>2]=+(((c[D+284>>2]|0)-(c[r+4>>2]|0)+(((c[D+280>>2]|0)-(c[r>>2]|0)|0)*1e6|0)-(c[f+12>>2]|0)|0)>>>0)/1.0e3+ +g[f+8>>2];if(c[f+16>>2]|0)break;f=c[5128]|0}c[5128]=c[f+20>>2]}while(0);Jb[c[(c[d>>2]|0)+44>>2]&255](d);Jb[c[(c[d>>2]|0)+148>>2]&255](d);g[d+104>>2]=e;Lb[c[(c[d>>2]|0)+152>>2]&127](d,d+92|0);Ib[c[(c[d>>2]|0)+144>>2]&31](d,e);jE(1936);if((c[d+280>>2]|0)>0){f=0;do{r=c[(c[d+288>>2]|0)+(f<<2)>>2]|0;rc[c[(c[r>>2]|0)+8>>2]&7](r,d,e);f=f+1|0}while((f|0)<(c[d+280>>2]|0))}f=c[5128]|0;r=(c[f+16>>2]|0)+-1|0;c[f+16>>2]=r;do if(!r){if(c[f+4>>2]|0){Cb(D+280|0,0)|0;r=c[5114]|0;g[f+8>>2]=+(((c[D+284>>2]|0)-(c[r+4>>2]|0)+(((c[D+280>>2]|0)-(c[r>>2]|0)|0)*1e6|0)-(c[f+12>>2]|0)|0)>>>0)/1.0e3+ +g[f+8>>2];if(c[f+16>>2]|0)break;f=c[5128]|0}c[5128]=c[f+20>>2]}while(0);Ib[c[(c[d>>2]|0)+156>>2]&31](d,e);f=c[d+80>>2]|0;if(f)Ib[f&31](d,e);f=c[5128]|0;d=(c[f+16>>2]|0)+-1|0;c[f+16>>2]=d;if(d){i=D;return}do if(c[f+4>>2]|0){Cb(D+280|0,0)|0;d=c[5114]|0;g[f+8>>2]=+(((c[D+284>>2]|0)-(c[d+4>>2]|0)+(((c[D+280>>2]|0)-(c[d>>2]|0)|0)*1e6|0)-(c[f+12>>2]|0)|0)>>>0)/1.0e3+ +g[f+8>>2];if(!(c[f+16>>2]|0)){f=c[5128]|0;break}else{i=D;return}}while(0);c[5128]=c[f+20>>2];i=D;return}function Xp(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0,h=0,i=0,j=0.0,k=0.0;c[a+248>>2]=c[b+0>>2];c[a+252>>2]=c[b+4>>2];c[a+256>>2]=c[b+8>>2];c[a+260>>2]=c[b+12>>2];d=c[a+232>>2]|0;if((d|0)<=0)return;h=0;do{f=c[(c[a+240>>2]|0)+(h<<2)>>2]|0;i=c[f+216>>2]|0;if(!((i|0)==2|(i|0)==5)?(c[f+504>>2]&1|0)==0:0){e=+g[f+344>>2];if(e!=0.0){k=1.0/e*+g[b+4>>2];j=1.0/e*+g[b+8>>2];g[f+364>>2]=1.0/e*+g[b>>2];g[f+368>>2]=k;g[f+372>>2]=j;g[f+376>>2]=0.0}c[f+380>>2]=c[b+0>>2];c[f+384>>2]=c[b+4>>2];c[f+388>>2]=c[b+8>>2];c[f+392>>2]=c[b+12>>2];d=c[a+232>>2]|0}h=h+1|0}while((h|0)<(d|0));return}function Yp(a,b){a=a|0;b=b|0;c[a+0>>2]=c[b+248>>2];c[a+4>>2]=c[b+252>>2];c[a+8>>2]=c[b+256>>2];c[a+12>>2]=c[b+260>>2];return}function Zp(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;$u(a,b,c,d);return}function _p(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0;d=(c[b+236>>2]&2|0)==0?0:b;if(d){Lb[c[(c[a>>2]|0)+92>>2]&127](a,d);return}d=c[b+188>>2]|0;if(d){h=c[a+68>>2]|0;h=Nb[c[(c[h>>2]|0)+36>>2]&127](h)|0;pc[c[(c[h>>2]|0)+40>>2]&127](h,d,c[a+24>>2]|0);h=c[a+68>>2]|0;pc[c[(c[h>>2]|0)+12>>2]&127](h,d,c[a+24>>2]|0);c[b+188>>2]=0}d=c[a+8>>2]|0;if((d|0)<=0)return;e=c[a+16>>2]|0;h=0;while(1){g=e+(h<<2)|0;f=h+1|0;if((c[g>>2]|0)==(b|0))break;if((f|0)<(d|0))h=f;else{i=11;break}}if((i|0)==11)return;if((h|0)>=(d|0))return;c[g>>2]=c[e+(d+-1<<2)>>2];c[(c[a+16>>2]|0)+(d+-1<<2)>>2]=b;c[a+8>>2]=d+-1;return}function $p(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0;d=c[a+232>>2]|0;a:do if((d|0)>0){e=c[a+240>>2]|0;h=0;while(1){f=e+(h<<2)|0;g=h+1|0;if((c[f>>2]|0)==(b|0))break;if((g|0)<(d|0))h=g;else break a}if((h|0)<(d|0)){c[f>>2]=c[e+(d+-1<<2)>>2];c[(c[a+240>>2]|0)+(d+-1<<2)>>2]=b;c[a+232>>2]=d+-1}}while(0);d=c[b+188>>2]|0;if(d){h=c[a+68>>2]|0;h=Nb[c[(c[h>>2]|0)+36>>2]&127](h)|0;pc[c[(c[h>>2]|0)+40>>2]&127](h,d,c[a+24>>2]|0);h=c[a+68>>2]|0;pc[c[(c[h>>2]|0)+12>>2]&127](h,d,c[a+24>>2]|0);c[b+188>>2]=0}d=c[a+8>>2]|0;if((d|0)<=0)return;e=c[a+16>>2]|0;h=0;while(1){g=e+(h<<2)|0;f=h+1|0;if((c[g>>2]|0)==(b|0))break;if((f|0)<(d|0))h=f;else{i=15;break}}if((i|0)==15)return;if((h|0)>=(d|0))return;c[g>>2]=c[e+(d+-1<<2)>>2];c[(c[a+16>>2]|0)+(d+-1<<2)>>2]=b;c[a+8>>2]=d+-1;return}function aq(b,d){b=b|0;d=d|0;var e=0,f=0,h=0.0,i=0,j=0,k=0,l=0.0,m=0.0;e=c[d+204>>2]|0;if((e&3|0)==0?(c[d+504>>2]&1|0)==0:0){h=+g[d+344>>2];if(h!=0.0){m=1.0/h*+g[b+252>>2];l=1.0/h*+g[b+256>>2];g[d+364>>2]=1.0/h*+g[b+248>>2];g[d+368>>2]=m;g[d+372>>2]=l;g[d+376>>2]=0.0}c[d+380>>2]=c[b+248>>2];c[d+384>>2]=c[b+252>>2];c[d+388>>2]=c[b+256>>2];c[d+392>>2]=c[b+260>>2]}if(!(c[d+192>>2]|0))return;if(e&1){if((c[d+216>>2]&-2|0)!=4)c[d+216>>2]=2}else{f=c[b+232>>2]|0;if((f|0)==(c[b+236>>2]|0)?(k=(f|0)==0?1:f<<1,(f|0)<(k|0)):0){if(!k)j=0;else{c[5132]=(c[5132]|0)+1;e=ZE((k<<2|3)+16|0)|0;if(!e)f=0;else{c[(e+19&-16)+-4>>2]=e;f=e+19&-16}j=f;f=c[b+232>>2]|0}if((f|0)>0){i=0;do{e=j+(i<<2)|0;if(e)c[e>>2]=c[(c[b+240>>2]|0)+(i<<2)>>2];i=i+1|0}while((i|0)!=(f|0))}e=c[b+240>>2]|0;if(e){if(a[b+244>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[e+-4>>2]|0);f=c[b+232>>2]|0}c[b+240>>2]=0}a[b+244>>0]=1;c[b+240>>2]=j;c[b+236>>2]=k}e=(c[b+240>>2]|0)+(f<<2)|0;if(e)c[e>>2]=d;c[b+232>>2]=f+1;e=c[d+204>>2]|0}if(!(e&1))e=(e&2|0)==0;else e=0;tc[c[(c[b>>2]|0)+36>>2]&127](b,d,e?1:2,e?-1:-3);return}function bq(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,i=0,j=0.0,k=0,l=0,m=0,n=0.0,o=0.0;i=c[d+204>>2]|0;if((i&3|0)==0?(c[d+504>>2]&1|0)==0:0){j=+g[d+344>>2];if(j!=0.0){o=1.0/j*+g[b+252>>2];n=1.0/j*+g[b+256>>2];g[d+364>>2]=1.0/j*+g[b+248>>2];g[d+368>>2]=o;g[d+372>>2]=n;g[d+376>>2]=0.0}c[d+380>>2]=c[b+248>>2];c[d+384>>2]=c[b+252>>2];c[d+388>>2]=c[b+256>>2];c[d+392>>2]=c[b+260>>2]}if(!(c[d+192>>2]|0))return;if(i&1){if((c[d+216>>2]&-2|0)!=4)c[d+216>>2]=2}else{i=c[b+232>>2]|0;if((i|0)==(c[b+236>>2]|0)?(m=(i|0)==0?1:i<<1,(i|0)<(m|0)):0){if(!m)l=0;else{c[5132]=(c[5132]|0)+1;h=ZE((m<<2|3)+16|0)|0;if(!h)i=0;else{c[(h+19&-16)+-4>>2]=h;i=h+19&-16}l=i;i=c[b+232>>2]|0}if((i|0)>0){k=0;do{h=l+(k<<2)|0;if(h)c[h>>2]=c[(c[b+240>>2]|0)+(k<<2)>>2];k=k+1|0}while((k|0)!=(i|0))}h=c[b+240>>2]|0;if(h){if(a[b+244>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[h+-4>>2]|0);i=c[b+232>>2]|0}c[b+240>>2]=0}a[b+244>>0]=1;c[b+240>>2]=l;c[b+236>>2]=m}h=(c[b+240>>2]|0)+(i<<2)|0;if(h)c[h>>2]=d;c[b+232>>2]=i+1}tc[c[(c[b>>2]|0)+36>>2]&127](b,d,e,f);return}function cq(b,d){b=b|0;d=+d;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0.0,p=0.0,q=0.0,r=0.0;n=i;i=i+16|0;jE(1952);e=c[b+232>>2]|0;if((e|0)>0){l=(a[1544]|0)==0;k=0;do{j=c[(c[b+240>>2]|0)+(k<<2)>>2]|0;a:do if(j){f=c[j+216>>2]|0;do if(!((f|0)==4|(f|0)==2)){r=+g[j+312>>2];q=+g[j+316>>2];p=+g[j+320>>2];o=+g[j+472>>2];if(r*r+q*q+p*p<o*o?(q=+g[j+328>>2],o=+g[j+332>>2],p=+g[j+336>>2],r=+g[j+476>>2],q*q+o*o+p*p<r*r):0){g[j+220>>2]=+g[j+220>>2]+d;m=10;break}g[j+220>>2]=0.0;if((f&-2|0)!=4){c[j+216>>2]=0;h=0}else m=10}else m=10;while(0);if((m|0)==10){m=0;if((f|0)==4)break;else h=f}f=h&-2;do if(l){if((f|0)!=2?!(+g[j+220>>2]>2.0):0)break;if(c[j+204>>2]&3){if((f|0)==4)break a;c[j+216>>2]=2;break a}if((h|0)==1){if((f|0)==4)break a;c[j+216>>2]=3;break a}else{if((h|0)!=2)break a;e=(c[j+260>>2]|0)+2|0;c[j+328>>2]=0;c[j+332>>2]=0;c[j+336>>2]=0;c[j+340>>2]=0;c[j+260>>2]=e;c[j+312>>2]=0;c[j+316>>2]=0;c[j+320>>2]=0;c[j+324>>2]=0;e=c[b+232>>2]|0;break a}}while(0);if((f|0)!=4)c[j+216>>2]=1}while(0);k=k+1|0}while((k|0)<(e|0))}e=c[5128]|0;m=(c[e+16>>2]|0)+-1|0;c[e+16>>2]=m;if(m){i=n;return}do if(c[e+4>>2]|0){Cb(n|0,0)|0;m=c[5114]|0;g[e+8>>2]=+(((c[n+4>>2]|0)-(c[m+4>>2]|0)+(((c[n>>2]|0)-(c[m>>2]|0)|0)*1e6|0)-(c[e+12>>2]|0)|0)>>>0)/1.0e3+ +g[e+8>>2];if(!(c[e+16>>2]|0)){e=c[5128]|0;break}else{i=n;return}}while(0);c[5128]=c[e+20>>2];i=n;return}function dq(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0;g=c[b+212>>2]|0;if((g|0)==(c[b+216>>2]|0)?(j=(g|0)==0?1:g<<1,(g|0)<(j|0)):0){if(!j)i=0;else{c[5132]=(c[5132]|0)+1;f=ZE((j<<2|3)+16|0)|0;if(!f)g=0;else{c[(f+19&-16)+-4>>2]=f;g=f+19&-16}i=g;g=c[b+212>>2]|0}if((g|0)>0){h=0;do{f=i+(h<<2)|0;if(f)c[f>>2]=c[(c[b+220>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(g|0))}f=c[b+220>>2]|0;if(f){if(a[b+224>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[f+-4>>2]|0);g=c[b+212>>2]|0}c[b+220>>2]=0}a[b+224>>0]=1;c[b+220>>2]=i;c[b+216>>2]=j}f=(c[b+220>>2]|0)+(g<<2)|0;if(f)c[f>>2]=d;c[b+212>>2]=g+1;if(!e)return;Fp(c[d+28>>2]|0,d);Fp(c[d+32>>2]|0,d);return}function eq(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0;d=c[a+212>>2]|0;a:do if((d|0)>0){g=c[a+220>>2]|0;h=0;while(1){e=g+(h<<2)|0;f=h+1|0;if((c[e>>2]|0)==(b|0))break;if((f|0)<(d|0))h=f;else break a}if((h|0)<(d|0)){c[e>>2]=c[g+(d+-1<<2)>>2];c[(c[a+220>>2]|0)+(d+-1<<2)>>2]=b;c[a+212>>2]=d+-1}}while(0);a=c[b+28>>2]|0;d=c[a+488>>2]|0;b:do if((d|0)>0){e=c[a+496>>2]|0;h=0;while(1){g=e+(h<<2)|0;f=h+1|0;if((c[g>>2]|0)==(b|0))break;if((f|0)<(d|0))h=f;else break b}if((h|0)<(d|0)){c[g>>2]=c[e+(d+-1<<2)>>2];c[(c[a+496>>2]|0)+(d+-1<<2)>>2]=b;c[a+488>>2]=d+-1;d=d+-1|0}}while(0);c[a+256>>2]=(d|0)>0&1;a=c[b+32>>2]|0;d=c[a+488>>2]|0;if((d|0)<=0){b=d;b=(b|0)>0;b=b&1;i=a+256|0;c[i>>2]=b;return}g=c[a+496>>2]|0;h=0;while(1){e=g+(h<<2)|0;f=h+1|0;if((c[e>>2]|0)==(b|0))break;if((f|0)<(d|0))h=f;else{i=19;break}}if((i|0)==19){b=(d|0)>0;b=b&1;i=a+256|0;c[i>>2]=b;return}if((h|0)>=(d|0)){b=d;b=(b|0)>0;b=b&1;i=a+256|0;c[i>>2]=b;return}c[e>>2]=c[g+(d+-1<<2)>>2];c[(c[a+496>>2]|0)+(d+-1<<2)>>2]=b;c[a+488>>2]=d+-1;b=d+-1|0;b=(b|0)>0;b=b&1;i=a+256|0;c[i>>2]=b;return}function fq(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;f=c[b+280>>2]|0;if((f|0)==(c[b+284>>2]|0)?(i=(f|0)==0?1:f<<1,(f|0)<(i|0)):0){if(!i)h=0;else{c[5132]=(c[5132]|0)+1;e=ZE((i<<2|3)+16|0)|0;if(!e)f=0;else{c[(e+19&-16)+-4>>2]=e;f=e+19&-16}h=f;f=c[b+280>>2]|0}if((f|0)>0){g=0;do{e=h+(g<<2)|0;if(e)c[e>>2]=c[(c[b+288>>2]|0)+(g<<2)>>2];g=g+1|0}while((g|0)!=(f|0))}e=c[b+288>>2]|0;if(e){if(a[b+292>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[e+-4>>2]|0);f=c[b+280>>2]|0}c[b+288>>2]=0}a[b+292>>0]=1;c[b+288>>2]=h;c[b+284>>2]=i}e=(c[b+288>>2]|0)+(f<<2)|0;if(!e){d=f+1|0;c[b+280>>2]=d;return}c[e>>2]=d;d=f+1|0;c[b+280>>2]=d;return}function gq(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0;d=c[a+280>>2]|0;if((d|0)<=0)return;e=c[a+288>>2]|0;h=0;while(1){g=e+(h<<2)|0;f=h+1|0;if((c[g>>2]|0)==(b|0))break;if((f|0)<(d|0))h=f;else{i=7;break}}if((i|0)==7)return;if((h|0)>=(d|0))return;c[g>>2]=c[e+(d+-1<<2)>>2];c[(c[a+288>>2]|0)+(d+-1<<2)>>2]=b;c[a+280>>2]=d+-1;return}function hq(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+64>>2]&127](a,b);return}function iq(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+68>>2]&127](a,b);return}function jq(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+64>>2]&127](a,b);return}function kq(a,b){a=a|0;b=b|0;Lb[c[(c[a>>2]|0)+68>>2]&127](a,b);return}function lq(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;v=i;i=i+16|0;jE(1976);l=c[b+212>>2]|0;k=c[b+180>>2]|0;if((k|0)<(l|0)){if((c[b+184>>2]|0)<(l|0)){if(!l){f=0;h=k}else{c[5132]=(c[5132]|0)+1;f=ZE((l<<2|3)+16|0)|0;if(!f)f=0;else{c[(f+19&-16)+-4>>2]=f;f=f+19&-16}h=c[b+180>>2]|0}if((h|0)>0){j=0;do{e=f+(j<<2)|0;if(e)c[e>>2]=c[(c[b+188>>2]|0)+(j<<2)>>2];j=j+1|0}while((j|0)!=(h|0))}e=c[b+188>>2]|0;if(e){if(a[b+192>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[e+-4>>2]|0)}c[b+188>>2]=0}a[b+192>>0]=1;c[b+188>>2]=f;c[b+184>>2]=l;h=b+188|0}else h=b+188|0;e=k;do{f=(c[h>>2]|0)+(e<<2)|0;if(f)c[f>>2]=0;e=e+1|0}while((e|0)!=(l|0))}c[b+180>>2]=l;e=0;while(1){if((e|0)>=(Nb[c[(c[b>>2]|0)+104>>2]&127](b)|0))break;c[(c[b+188>>2]|0)+(e<<2)>>2]=c[(c[b+220>>2]|0)+(e<<2)>>2];e=e+1|0}e=c[b+180>>2]|0;if((e|0)>1)vq(b+176|0,0,e+-1|0);if(!(Nb[c[(c[b>>2]|0)+104>>2]&127](b)|0))e=0;else e=c[b+188>>2]|0;m=c[b+196>>2]|0;u=c[b+180>>2]|0;f=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;c[m+4>>2]=d;c[m+12>>2]=e;c[m+16>>2]=u;c[m+20>>2]=f;f=c[m+32>>2]|0;if((f|0)<0){if((c[m+36>>2]|0)<0){e=c[m+40>>2]|0;if(e){if(a[m+44>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[e+-4>>2]|0)}c[m+40>>2]=0}a[m+44>>0]=1;c[m+40>>2]=0;c[m+36>>2]=0}do{e=(c[m+40>>2]|0)+(f<<2)|0;if(e)c[e>>2]=0;f=f+1|0}while((f|0)!=0)}c[m+32>>2]=0;f=c[m+52>>2]|0;if((f|0)<0){if((c[m+56>>2]|0)<0){e=c[m+60>>2]|0;if(e){if(a[m+64>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[e+-4>>2]|0)}c[m+60>>2]=0}a[m+64>>0]=1;c[m+60>>2]=0;c[m+56>>2]=0}do{e=(c[m+60>>2]|0)+(f<<2)|0;if(e)c[e>>2]=0;f=f+1|0}while((f|0)!=0)}c[m+52>>2]=0;e=c[m+72>>2]|0;if((e|0)<0){if((c[m+76>>2]|0)<0){f=c[m+80>>2]|0;if(f){if(a[m+84>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[f+-4>>2]|0)}c[m+80>>2]=0}a[m+84>>0]=1;c[m+80>>2]=0;c[m+76>>2]=0}do{f=(c[m+80>>2]|0)+(e<<2)|0;if(f)c[f>>2]=0;e=e+1|0}while((e|0)!=0)}c[m+72>>2]=0;u=c[b+200>>2]|0;h=c[(c[u>>2]|0)+8>>2]|0;r=c[b+8>>2]|0;t=c[b+24>>2]|0;t=Nb[c[(c[t>>2]|0)+36>>2]&127](t)|0;pc[h&127](u,r,t);t=c[b+204>>2]|0;r=c[b+24>>2]|0;u=c[b+196>>2]|0;jE(7032);h=c[t+28>>2]|0;if((h|0)<0){if((c[t+32>>2]|0)<0){f=c[t+36>>2]|0;if(f){if(a[t+40>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[f+-4>>2]|0)}c[t+36>>2]=0}a[t+40>>0]=1;c[t+36>>2]=0;c[t+32>>2]=0}do{f=(c[t+36>>2]|0)+(h<<2)|0;if(f)c[f>>2]=0;h=h+1|0}while((h|0)!=0)}c[t+28>>2]=0;k=c[t+8>>2]|0;if((k|0)>0){e=c[t+16>>2]|0;m=0;do{l=e+(m<<3)|0;j=c[l>>2]|0;if((j|0)==(m|0))j=m;else{h=j;f=l;do{j=e+(h<<3)|0;c[f>>2]=c[j>>2];j=c[j>>2]|0;f=e+(j<<3)|0;h=c[f>>2]|0}while((j|0)!=(h|0))}c[l>>2]=j;m=m+1|0}while((m|0)!=(k|0));if((k|0)>1){tw(t+4|0,0,k+-1|0);k=c[t+8>>2]|0}if((k|0)>0){p=c[t+16>>2]|0;j=p;m=0;while(1){e=c[p+(m<<3)>>2]|0;q=m;while(1){q=q+1|0;if((q|0)>=(k|0)){o=0;break}if((c[p+(q<<3)>>2]|0)!=(e|0)){o=1;break}}if((m|0)<(q|0)){n=c[b+16>>2]|0;l=1;f=m;do{h=c[n+(c[p+(f<<3)+4>>2]<<2)>>2]|0;if((c[h+208>>2]|0)==(e|0)){h=c[h+216>>2]|0;l=l&(h|0)!=1&(h|0)!=4}f=f+1|0}while((f|0)!=(q|0));if(l){l=p;while(1){l=c[n+(c[l+(m<<3)+4>>2]<<2)>>2]|0;if((c[l+208>>2]|0)==(e|0)?(c[l+216>>2]&-2|0)!=4:0)c[l+216>>2]=2;m=m+1|0;if((m|0)>=(q|0))break;else l=j}}else while(1){l=c[n+(c[p+(m<<3)+4>>2]<<2)>>2]|0;if((c[l+208>>2]|0)==(e|0)?(c[l+216>>2]|0)==2:0){c[l+216>>2]=3;g[l+220>>2]=0.0}m=m+1|0;if((m|0)>=(q|0))break;else j=p}}if(o)m=q;else break}}}p=Nb[c[(c[r>>2]|0)+36>>2]&127](r)|0;if((p|0)>0){q=0;do{o=ec[c[(c[r>>2]|0)+40>>2]&31](r,q)|0;h=c[o+740>>2]|0;f=c[o+744>>2]|0;if((h|0)!=0?(c[h+216>>2]|0)!=2:0)j=101;else j=99;if(((j|0)==99?(j=0,(f|0)!=0):0)?(c[f+216>>2]|0)!=2:0)j=101;if((j|0)==101){j=c[h+204>>2]|0;if(((j&2|0)!=0?((j&4|0)==0?(c[h+216>>2]|0)!=2:0):0)?(c[f+204>>2]&3|0)==0:0){if((c[f+216>>2]&-2|0)!=4)c[f+216>>2]=1;g[f+220>>2]=0.0}n=c[f+204>>2]|0;if((n&2|0)!=0?((n&4|0)==0?(c[f+216>>2]|0)!=2:0)&(j&3|0)==0:0){if((c[h+216>>2]&-2|0)!=4)c[h+216>>2]=1;g[h+220>>2]=0.0}if((a[t+64>>0]|0)!=0?Wb[c[(c[r>>2]|0)+28>>2]&63](r,h,f)|0:0){h=c[t+28>>2]|0;if((h|0)==(c[t+32>>2]|0)?(s=(h|0)==0?1:h<<1,(h|0)<(s|0)):0){if(!s)j=0;else{c[5132]=(c[5132]|0)+1;j=ZE((s<<2|3)+16|0)|0;if(!j)j=0;else{c[(j+19&-16)+-4>>2]=j;j=j+19&-16}h=c[t+28>>2]|0}if((h|0)>0){k=0;do{f=j+(k<<2)|0;if(f)c[f>>2]=c[(c[t+36>>2]|0)+(k<<2)>>2];k=k+1|0}while((k|0)!=(h|0))}f=c[t+36>>2]|0;if(f){if(a[t+40>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[f+-4>>2]|0);h=c[t+28>>2]|0}c[t+36>>2]=0}a[t+40>>0]=1;c[t+36>>2]=j;c[t+32>>2]=s}j=(c[t+36>>2]|0)+(h<<2)|0;if(j)c[j>>2]=o;c[t+28>>2]=h+1}}q=q+1|0}while((q|0)<(p|0))}f=c[5128]|0;s=(c[f+16>>2]|0)+-1|0;c[f+16>>2]=s;do if(!s){if(c[f+4>>2]|0){Cb(v|0,0)|0;s=c[5114]|0;g[f+8>>2]=+(((c[v+4>>2]|0)-(c[s+4>>2]|0)+(((c[v>>2]|0)-(c[s>>2]|0)|0)*1e6|0)-(c[f+12>>2]|0)|0)>>>0)/1.0e3+ +g[f+8>>2];if(c[f+16>>2]|0)break;f=c[5128]|0}c[5128]=c[f+20>>2]}while(0);s=c[t+8>>2]|0;jE(7064);if(a[t+64>>0]|0){n=c[t+28>>2]|0;if((n|0)>1)_t(t+24|0,0,n+-1|0);if((s|0)>0){q=1;k=0;r=0;while(1){j=c[t+16>>2]|0;o=c[j+(k<<3)>>2]|0;a:do if((k|0)<(s|0)){m=o;e=1;while(1){if((m|0)!=(o|0))break a;p=c[(c[b+16>>2]|0)+(c[j+(k<<3)+4>>2]<<2)>>2]|0;h=c[t+48>>2]|0;do if((h|0)==(c[t+52>>2]|0)){f=(h|0)==0?1:h<<1;if((h|0)>=(f|0))break;if(!f)j=0;else{c[5132]=(c[5132]|0)+1;j=ZE((f<<2|3)+16|0)|0;if(!j)j=0;else{c[(j+19&-16)+-4>>2]=j;j=j+19&-16}h=c[t+48>>2]|0}if((h|0)>0){l=0;do{m=j+(l<<2)|0;if(m)c[m>>2]=c[(c[t+56>>2]|0)+(l<<2)>>2];l=l+1|0}while((l|0)!=(h|0))}m=c[t+56>>2]|0;if(m){if(a[t+60>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[m+-4>>2]|0);h=c[t+48>>2]|0}c[t+56>>2]=0}a[t+60>>0]=1;c[t+56>>2]=j;c[t+52>>2]=f}while(0);j=(c[t+56>>2]|0)+(h<<2)|0;if(j)c[j>>2]=p;c[t+48>>2]=h+1;h=c[p+216>>2]|0;h=e&((h|0)==2|(h|0)==5);k=k+1|0;if((k|0)>=(s|0)){e=h;break a}j=c[t+16>>2]|0;m=c[j+(k<<3)>>2]|0;e=h}}else e=1;while(0);if((r|0)<(n|0)){f=c[t+36>>2]|0;j=f+(r<<2)|0;l=c[j>>2]|0;h=c[(c[l+740>>2]|0)+208>>2]|0;if((h|0)<=-1)h=c[(c[l+744>>2]|0)+208>>2]|0;if((h|0)==(o|0)){m=r;do{m=m+1|0;if((m|0)>=(n|0))break;l=c[f+(m<<2)>>2]|0;h=c[(c[l+740>>2]|0)+208>>2]|0;if((h|0)<=-1)h=c[(c[l+744>>2]|0)+208>>2]|0}while((o|0)==(h|0));l=m;h=m-r|0}else{l=q;h=0;j=0}}else{l=q;h=0;j=0}if(!e)Xb[c[(c[u>>2]|0)+8>>2]&7](u,c[t+56>>2]|0,c[t+48>>2]|0,j,h,o);r=(h|0)==0?r:l;j=c[t+48>>2]|0;if((j|0)<0){if((c[t+52>>2]|0)<0){h=c[t+56>>2]|0;if(h){if(a[t+60>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[h+-4>>2]|0)}c[t+56>>2]=0}a[t+60>>0]=1;c[t+56>>2]=0;c[t+52>>2]=0}do{h=(c[t+56>>2]|0)+(j<<2)|0;if(h)c[h>>2]=0;j=j+1|0}while((j|0)!=0)}c[t+48>>2]=0;if((k|0)>=(s|0))break;else q=l}}}else{s=Nb[c[(c[r>>2]|0)+44>>2]&127](r)|0;t=Nb[c[(c[r>>2]|0)+36>>2]&127](r)|0;Xb[c[(c[u>>2]|0)+8>>2]&7](u,c[b+16>>2]|0,c[b+8>>2]|0,s,t,-1)}e=c[5128]|0;u=(c[e+16>>2]|0)+-1|0;c[e+16>>2]=u;do if(!u){if(c[e+4>>2]|0){Cb(v|0,0)|0;u=c[5114]|0;g[e+8>>2]=+(((c[v+4>>2]|0)-(c[u+4>>2]|0)+(((c[v>>2]|0)-(c[u>>2]|0)|0)*1e6|0)-(c[e+12>>2]|0)|0)>>>0)/1.0e3+ +g[e+8>>2];if(c[e+16>>2]|0)break;e=c[5128]|0}c[5128]=c[e+20>>2]}while(0);wq(c[b+196>>2]|0);e=c[b+200>>2]|0;pc[c[(c[e>>2]|0)+16>>2]&127](e,d,c[b+72>>2]|0);e=c[5128]|0;b=(c[e+16>>2]|0)+-1|0;c[e+16>>2]=b;if(b){i=v;return}do if(c[e+4>>2]|0){Cb(v|0,0)|0;b=c[5114]|0;g[e+8>>2]=+(((c[v+4>>2]|0)-(c[b+4>>2]|0)+(((c[v>>2]|0)-(c[b>>2]|0)|0)*1e6|0)-(c[e+12>>2]|0)|0)>>>0)/1.0e3+ +g[e+8>>2];if(!(c[e+16>>2]|0)){e=c[5128]|0;break}else{i=v;return}}while(0);c[5128]=c[e+20>>2];i=v;return}function mq(b){b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=i;i=i+16|0;jE(2e3);l=c[b+204>>2]|0;pc[c[(c[l>>2]|0)+8>>2]&127](l,b,c[b+24>>2]|0);l=c[b+308>>2]|0;if((l|0)>0){m=c[b+316>>2]|0;k=0;do{e=c[m+(k<<2)>>2]|0;d=c[e+740>>2]|0;e=c[e+744>>2]|0;if(((d|0)!=0?((e|0)!=0?(c[d+204>>2]&3|0)==0:0):0)?(c[e+204>>2]&3|0)==0:0){h=c[d+208>>2]|0;d=c[e+208>>2]|0;j=c[(c[b+204>>2]|0)+16>>2]|0;e=c[j+(h<<3)>>2]|0;if((e|0)!=(h|0)){f=j+(h<<3)|0;do{h=j+(e<<3)|0;c[f>>2]=c[h>>2];h=c[h>>2]|0;f=j+(h<<3)|0;e=c[f>>2]|0}while((h|0)!=(e|0))}e=c[j+(d<<3)>>2]|0;if((e|0)!=(d|0)){f=j+(d<<3)|0;do{d=j+(e<<3)|0;c[f>>2]=c[d>>2];d=c[d>>2]|0;f=j+(d<<3)|0;e=c[f>>2]|0}while((d|0)!=(e|0))}if((h|0)!=(d|0)){c[j+(h<<3)>>2]=d;f=j+(d<<3)+4|0;c[f>>2]=(c[f>>2]|0)+(c[j+(h<<3)+4>>2]|0)}}k=k+1|0}while((k|0)!=(l|0))}l=c[b+212>>2]|0;if((l|0)>0){k=c[b+220>>2]|0;m=0;do{d=c[k+(m<<2)>>2]|0;if(((a[d+20>>0]|0)!=0?(n=c[d+28>>2]|0,(c[n+204>>2]&3|0)==0):0)?(o=c[d+32>>2]|0,(c[o+204>>2]&3|0)==0):0){h=c[n+208>>2]|0;d=c[o+208>>2]|0;j=c[(c[b+204>>2]|0)+16>>2]|0;e=c[j+(h<<3)>>2]|0;if((e|0)!=(h|0)){f=j+(h<<3)|0;do{h=j+(e<<3)|0;c[f>>2]=c[h>>2];h=c[h>>2]|0;f=j+(h<<3)|0;e=c[f>>2]|0}while((h|0)!=(e|0))}e=c[j+(d<<3)>>2]|0;if((e|0)!=(d|0)){f=j+(d<<3)|0;do{d=j+(e<<3)|0;c[f>>2]=c[d>>2];d=c[d>>2]|0;f=j+(d<<3)|0;e=c[f>>2]|0}while((d|0)!=(e|0))}if((h|0)!=(d|0)){c[j+(h<<3)>>2]=d;f=j+(d<<3)+4|0;c[f>>2]=(c[f>>2]|0)+(c[j+(h<<3)+4>>2]|0)}}m=m+1|0}while((m|0)!=(l|0))}d=c[b+204>>2]|0;Lb[c[(c[d>>2]|0)+12>>2]&127](d,b);d=c[5128]|0;b=(c[d+16>>2]|0)+-1|0;c[d+16>>2]=b;if(b){i=p;return}do if(c[d+4>>2]|0){Cb(p|0,0)|0;b=c[5114]|0;g[d+8>>2]=+(((c[p+4>>2]|0)-(c[b+4>>2]|0)+(((c[p>>2]|0)-(c[b>>2]|0)|0)*1e6|0)-(c[d+12>>2]|0)|0)>>>0)/1.0e3+ +g[d+8>>2];if(!(c[d+16>>2]|0)){d=c[5128]|0;break}else{i=p;return}}while(0);c[5128]=c[d+20>>2];i=p;return}function nq(d,e){d=d|0;e=+e;var f=0,h=0,j=0.0,k=0.0,l=0.0,m=0,n=0,o=0,p=0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0,z=0.0,A=0;y=i;i=i+352|0;jE(2144);if((c[d+232>>2]|0)>0){n=y+232|0;m=0;do{o=c[(c[d+240>>2]|0)+(m<<2)>>2]|0;g[o+244>>2]=1.0;h=c[o+216>>2]|0;do if(!((h|0)==2|(h|0)==5)?(c[o+204>>2]&3|0)==0:0){Jp(o+4|0,+g[o+312>>2],+g[o+316>>2],+g[o+320>>2],o+328|0,e,y+184|0);j=+g[n>>2]-+g[o+52>>2];k=+g[y+236>>2]-+g[o+56>>2];l=+g[y+240>>2]-+g[o+60>>2];if((a[d+44>>0]|0)!=0?(z=+g[o+252>>2],z*z!=0.0?z*z<j*j+k*k+l*l:0):0){jE(2168);if((c[(c[o+192>>2]|0)+4>>2]|0)<20){c[508]=(c[508]|0)+1;f=c[d+68>>2]|0;f=Nb[c[(c[f>>2]|0)+36>>2]&127](f)|0;h=c[d+24>>2]|0;g[y+20>>2]=1.0;b[y+24>>1]=1;b[y+26>>1]=-1;c[y+16>>2]=976;c[y+28>>2]=c[o+52>>2];c[y+32>>2]=c[o+56>>2];c[y+36>>2]=c[o+60>>2];c[y+40>>2]=c[o+64>>2];c[y+44>>2]=c[n+0>>2];c[y+48>>2]=c[n+4>>2];c[y+52>>2]=c[n+8>>2];c[y+56>>2]=c[n+12>>2];c[y+92>>2]=0;c[y+16>>2]=2392;c[y+96>>2]=o;c[y+104>>2]=f;c[y+108>>2]=h;j=+g[o+248>>2];c[y+120>>2]=0;g[y+124>>2]=1.0;g[y+128>>2]=1.0;g[y+132>>2]=1.0;g[y+136>>2]=0.0;c[y+112>>2]=12104;c[y+116>>2]=8;g[y+140>>2]=j;g[y+156>>2]=j;g[y+100>>2]=+g[d+56>>2];h=c[o+188>>2]|0;b[y+24>>1]=b[h+4>>1]|0;b[y+26>>1]=b[h+6>>1]|0;c[y+296>>2]=c[n+0>>2];c[y+300>>2]=c[n+4>>2];c[y+304>>2]=c[n+8>>2];c[y+308>>2]=c[n+12>>2];c[y+248>>2]=c[o+4>>2];c[y+252>>2]=c[o+8>>2];c[y+256>>2]=c[o+12>>2];c[y+260>>2]=c[o+16>>2];c[y+264>>2]=c[o+20>>2];c[y+268>>2]=c[o+24>>2];c[y+272>>2]=c[o+28>>2];c[y+276>>2]=c[o+32>>2];c[y+280>>2]=c[o+36>>2];c[y+284>>2]=c[o+40>>2];c[y+288>>2]=c[o+44>>2];c[y+292>>2]=c[o+48>>2];hv(d,y+112|0,o+4|0,y+248|0,y+16|0,0.0);j=+g[y+20>>2];if(j<1.0){g[o+244>>2]=j;Jp(o+4|0,+g[o+312>>2],+g[o+316>>2],+g[o+320>>2],o+328|0,j*e,y+184|0);g[o+244>>2]=0.0;Dp(o,y+184|0);f=4}else f=0;if(!f)p=11}else p=11;if((p|0)==11){p=0;f=0}h=c[5128]|0;A=(c[h+16>>2]|0)+-1|0;c[h+16>>2]=A;do if(!A){if(c[h+4>>2]|0){Cb(y+16|0,0)|0;A=c[5114]|0;g[h+8>>2]=+(((c[y+20>>2]|0)-(c[A+4>>2]|0)+(((c[y+16>>2]|0)-(c[A>>2]|0)|0)*1e6|0)-(c[h+12>>2]|0)|0)>>>0)/1.0e3+ +g[h+8>>2];if(c[h+16>>2]|0)break;h=c[5128]|0}c[5128]=c[h+20>>2]}while(0);if((f|0)==4)break}Dp(o,y+184|0)}while(0);m=m+1|0}while((m|0)<(c[d+232>>2]|0))}do if(a[d+275>>0]|0){jE(2192);f=c[d+308>>2]|0;if((f|0)>0){p=0;do{o=c[(c[d+316>>2]|0)+(p<<2)>>2]|0;n=c[o+740>>2]|0;n=(c[n+236>>2]&2|0)==0?0:n;m=c[o+744>>2]|0;m=(c[m+236>>2]&2|0)==0?0:m;h=c[o+748>>2]|0;if((h|0)>0){if(!n){f=0;do{j=+g[57]*+g[m+228>>2];if((j>0.0?(q=+g[o+(f*184|0)+124>>2],q!=0.0):0)?(r=j*(q*+g[o+(f*184|0)+68>>2]),s=j*(q*+g[o+(f*184|0)+72>>2]),t=j*(q*+g[o+(f*184|0)+76>>2]),g[y+328>>2]=-r,g[y+332>>2]=-s,g[y+336>>2]=-t,g[y+340>>2]=0.0,z=+g[o+(f*184|0)+56>>2]-+g[n+56>>2],e=+g[o+(f*184|0)+60>>2]-+g[n+60>>2],g[y>>2]=+g[o+(f*184|0)+52>>2]-+g[n+52>>2],g[y+4>>2]=z,g[y+8>>2]=e,g[y+12>>2]=0.0,e=+g[o+(f*184|0)+40>>2]-+g[m+56>>2],z=+g[o+(f*184|0)+44>>2]-+g[m+60>>2],g[y+168>>2]=+g[o+(f*184|0)+36>>2]-+g[m+52>>2],g[y+172>>2]=e,g[y+176>>2]=z,g[y+180>>2]=0.0,(m|0)!=0):0){g[y+312>>2]=r;g[y+316>>2]=s;g[y+320>>2]=t;g[y+324>>2]=0.0;gn(m,y+312|0,y+168|0);h=c[o+748>>2]|0}f=f+1|0}while((f|0)<(h|0))}else{h=0;do{j=+g[n+228>>2]*+g[m+228>>2];if((j>0.0?(u=+g[o+(h*184|0)+124>>2],u!=0.0):0)?(v=j*(u*+g[o+(h*184|0)+68>>2]),w=j*(u*+g[o+(h*184|0)+72>>2]),x=j*(u*+g[o+(h*184|0)+76>>2]),g[y+328>>2]=-v,g[y+332>>2]=-w,g[y+336>>2]=-x,g[y+340>>2]=0.0,z=+g[o+(h*184|0)+56>>2]-+g[n+56>>2],e=+g[o+(h*184|0)+60>>2]-+g[n+60>>2],g[y>>2]=+g[o+(h*184|0)+52>>2]-+g[n+52>>2],g[y+4>>2]=z,g[y+8>>2]=e,g[y+12>>2]=0.0,e=+g[o+(h*184|0)+40>>2]-+g[m+56>>2],z=+g[o+(h*184|0)+44>>2]-+g[m+60>>2],g[y+168>>2]=+g[o+(h*184|0)+36>>2]-+g[m+52>>2],g[y+172>>2]=e,g[y+176>>2]=z,g[y+180>>2]=0.0,gn(n,y+328|0,y),(m|0)!=0):0){g[y+312>>2]=v;g[y+316>>2]=w;g[y+320>>2]=x;g[y+324>>2]=0.0;gn(m,y+312|0,y+168|0)}h=h+1|0}while((h|0)<(c[o+748>>2]|0))}f=c[d+308>>2]|0}p=p+1|0}while((p|0)<(f|0))}f=c[5128]|0;A=(c[f+16>>2]|0)+-1|0;c[f+16>>2]=A;if(!A){if(c[f+4>>2]|0){Cb(y+16|0,0)|0;A=c[5114]|0;g[f+8>>2]=+(((c[y+20>>2]|0)-(c[A+4>>2]|0)+(((c[y+16>>2]|0)-(c[A>>2]|0)|0)*1e6|0)-(c[f+12>>2]|0)|0)>>>0)/1.0e3+ +g[f+8>>2];if(c[f+16>>2]|0)break;f=c[5128]|0}c[5128]=c[f+20>>2]}}while(0);f=c[5128]|0;A=(c[f+16>>2]|0)+-1|0;c[f+16>>2]=A;if(A){i=y;return}do if(c[f+4>>2]|0){Cb(y+16|0,0)|0;A=c[5114]|0;g[f+8>>2]=+(((c[y+20>>2]|0)-(c[A+4>>2]|0)+(((c[y+16>>2]|0)-(c[A>>2]|0)|0)*1e6|0)-(c[f+12>>2]|0)|0)>>>0)/1.0e3+ +g[f+8>>2];if(!(c[f+16>>2]|0)){f=c[5128]|0;break}else{i=y;return}}while(0);c[5128]=c[f+20>>2];i=y;return}function oq(b,d){b=b|0;d=+d;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0,r=0,s=0,t=0.0;s=i;i=i+16|0;jE(2232);e=c[b+232>>2]|0;if((e|0)>0){r=0;do{q=c[(c[b+240>>2]|0)+(r<<2)>>2]|0;if(!(c[q+204>>2]&3)){n=+g[q+444>>2];f=+Q(+(1.0-n),+d);j=f*+g[q+312>>2];g[q+312>>2]=j;h=f*+g[q+316>>2];g[q+316>>2]=h;f=f*+g[q+320>>2];g[q+320>>2]=f;p=+g[q+448>>2];m=+Q(+(1.0-p),+d);k=m*+g[q+328>>2];g[q+328>>2]=k;l=m*+g[q+332>>2];g[q+332>>2]=l;m=m*+g[q+336>>2];g[q+336>>2]=m;do if(a[q+452>>0]|0){if(m*m+(k*k+l*l)<+g[q+464>>2]?j*j+h*h+f*f<+g[q+460>>2]:0){t=+g[q+456>>2];g[q+328>>2]=k*t;g[q+332>>2]=t*l;g[q+336>>2]=t*m;g[q+312>>2]=t*j;g[q+316>>2]=t*h;g[q+320>>2]=t*f;j=t*j;h=t*h;f=t*f;o=k*t;l=t*l;m=t*m}else o=k;k=+P(+(j*j+h*h+f*f));do if(k<n)if(k>.004999999888241291){j=j-j*(1.0/k)*.004999999888241291;g[q+312>>2]=j;h=h-h*(1.0/k)*.004999999888241291;g[q+316>>2]=h;f=f-f*(1.0/k)*.004999999888241291;g[q+320>>2]=f;break}else{c[q+312>>2]=0;c[q+316>>2]=0;c[q+320>>2]=0;c[q+324>>2]=0;j=0.0;h=0.0;f=0.0;break}while(0);k=+P(+(o*o+l*l+m*m));if(k<p)if(k>.004999999888241291){g[q+328>>2]=o-o*(1.0/k)*.004999999888241291;g[q+332>>2]=l-l*(1.0/k)*.004999999888241291;g[q+336>>2]=m-m*(1.0/k)*.004999999888241291;break}else{c[q+328>>2]=0;c[q+332>>2]=0;c[q+336>>2]=0;c[q+340>>2]=0;break}}while(0);Jp(q+4|0,j,h,f,q+328|0,d,q+68|0);e=c[b+232>>2]|0}r=r+1|0}while((r|0)<(e|0))}e=c[5128]|0;b=(c[e+16>>2]|0)+-1|0;c[e+16>>2]=b;if(b){i=s;return}do if(c[e+4>>2]|0){Cb(s|0,0)|0;b=c[5114]|0;g[e+8>>2]=+(((c[s+4>>2]|0)-(c[b+4>>2]|0)+(((c[s>>2]|0)-(c[b>>2]|0)|0)*1e6|0)-(c[e+12>>2]|0)|0)>>>0)/1.0e3+ +g[e+8>>2];if(!(c[e+16>>2]|0)){e=c[5128]|0;break}else{i=s;return}}while(0);c[5128]=c[e+20>>2];i=s;return}function pq(b,d){b=b|0;d=d|0;var e=0;if((a[b+273>>0]|0)!=0?(e=c[b+200>>2]|0,(e|0)!=0):0){c[5134]=(c[5134]|0)+1;_E(c[e+-4>>2]|0)}a[b+273>>0]=0;c[b+200>>2]=d;c[(c[b+196>>2]|0)+8>>2]=d;return}function qq(a){a=a|0;return c[a+200>>2]|0}function rq(a){a=a|0;return c[a+212>>2]|0}function sq(a,b){a=a|0;b=b|0;return c[(c[a+220>>2]|0)+(b<<2)>>2]|0}function tq(a,b){a=a|0;b=b|0;return c[(c[a+220>>2]|0)+(b<<2)>>2]|0}function uq(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0;Jb[c[(c[b>>2]|0)+32>>2]&255](b);e=Wb[c[(c[b>>2]|0)+16>>2]&63](b,104,1)|0;d=c[e+8>>2]|0;f=d+0|0;h=f+104|0;do{c[f>>2]=0;f=f+4|0}while((f|0)<(h|0));g[d+88>>2]=+g[a+248>>2];g[d+92>>2]=+g[a+252>>2];g[d+96>>2]=+g[a+256>>2];g[d+100>>2]=+g[a+260>>2];g[d>>2]=+g[a+92>>2];g[d+4>>2]=+g[a+96>>2];g[d+8>>2]=+g[a+100>>2];g[d+12>>2]=+g[a+104>>2];g[d+16>>2]=+g[a+108>>2];g[d+20>>2]=+g[a+116>>2];g[d+24>>2]=+g[a+120>>2];g[d+28>>2]=+g[a+124>>2];g[d+32>>2]=+g[a+128>>2];g[d+36>>2]=+g[a+132>>2];g[d+40>>2]=+g[a+140>>2];g[d+44>>2]=+g[a+144>>2];g[d+48>>2]=+g[a+148>>2];g[d+52>>2]=+g[a+152>>2];g[d+56>>2]=+g[a+168>>2];g[d+60>>2]=+g[a+172>>2];c[d+64>>2]=c[a+112>>2];c[d+68>>2]=c[a+156>>2];c[d+72>>2]=c[a+160>>2];c[d+76>>2]=c[a+164>>2];c[d+80>>2]=c[a+136>>2];Hb[c[(c[b>>2]|0)+20>>2]&31](b,e,2264,1145853764,d);d=c[a+8>>2]|0;if((d|0)>0){f=0;do{e=c[(c[a+16>>2]|0)+(f<<2)>>2]|0;if(c[e+236>>2]&2){h=Nb[c[(c[e>>2]|0)+16>>2]&127](e)|0;h=Wb[c[(c[b>>2]|0)+16>>2]&63](b,h,1)|0;d=Wb[c[(c[e>>2]|0)+20>>2]&63](e,c[h+8>>2]|0,b)|0;Hb[c[(c[b>>2]|0)+20>>2]&31](b,h,d,1497645650,e);d=c[a+8>>2]|0}f=f+1|0}while((f|0)<(d|0))}if((c[a+212>>2]|0)<=0){lv(a,b);a=c[b>>2]|0;a=a+36|0;a=c[a>>2]|0;Jb[a&255](b);return}d=0;do{h=c[(c[a+220>>2]|0)+(d<<2)>>2]|0;e=Nb[c[(c[h>>2]|0)+36>>2]&127](h)|0;e=Wb[c[(c[b>>2]|0)+16>>2]&63](b,e,1)|0;f=Wb[c[(c[h>>2]|0)+40>>2]&63](h,c[e+8>>2]|0,b)|0;Hb[c[(c[b>>2]|0)+20>>2]&31](b,e,f,1397641027,h);d=d+1|0}while((d|0)<(c[a+212>>2]|0));lv(a,b);a=c[b>>2]|0;a=a+36|0;a=c[a>>2]|0;Jb[a&255](b);return}function vq(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;while(1){k=c[a+12>>2]|0;l=c[k+(((b+d|0)/2|0)<<2)>>2]|0;e=b;f=d;while(1){j=c[(c[l+28>>2]|0)+208>>2]|0;if((j|0)>-1)while(1){h=c[k+(e<<2)>>2]|0;g=c[(c[h+28>>2]|0)+208>>2]|0;if((g|0)<=-1)g=c[(c[h+32>>2]|0)+208>>2]|0;if((g|0)<(j|0))e=e+1|0;else break}else{i=c[(c[l+32>>2]|0)+208>>2]|0;while(1){h=c[k+(e<<2)>>2]|0;g=c[(c[h+28>>2]|0)+208>>2]|0;if((g|0)<=-1)g=c[(c[h+32>>2]|0)+208>>2]|0;if((g|0)<(i|0))e=e+1|0;else break}}if((j|0)>-1)while(1){i=c[k+(f<<2)>>2]|0;g=c[(c[i+28>>2]|0)+208>>2]|0;if((g|0)<=-1)g=c[(c[i+32>>2]|0)+208>>2]|0;if((j|0)<(g|0))f=f+-1|0;else{g=i;break}}else{j=c[(c[l+32>>2]|0)+208>>2]|0;while(1){i=c[k+(f<<2)>>2]|0;g=c[(c[i+28>>2]|0)+208>>2]|0;if((g|0)<=-1)g=c[(c[i+32>>2]|0)+208>>2]|0;if((j|0)<(g|0))f=f+-1|0;else{g=i;break}}}if((e|0)<=(f|0)){c[k+(e<<2)>>2]=g;c[(c[a+12>>2]|0)+(f<<2)>>2]=h;e=e+1|0;f=f+-1|0}if((e|0)>(f|0))break;k=c[a+12>>2]|0}if((f|0)>(b|0))vq(a,b,f);if((e|0)<(d|0))b=e;else break}return}function wq(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0;e=c[b+32>>2]|0;if(!e)f=0;else f=c[b+40>>2]|0;i=c[b+52>>2]|0;if(!i)g=0;else g=c[b+60>>2]|0;d=c[b+72>>2]|0;if(!d)h=0;else h=c[b+80>>2]|0;j=c[b+8>>2]|0;+gc[c[(c[j>>2]|0)+12>>2]&3](j,f,e,g,i,h,d,c[b+4>>2]|0,c[b+20>>2]|0,c[b+24>>2]|0);d=c[b+32>>2]|0;if((d|0)<0){if((c[b+36>>2]|0)<0){e=c[b+40>>2]|0;if(e){if(a[b+44>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[e+-4>>2]|0)}c[b+40>>2]=0}a[b+44>>0]=1;c[b+40>>2]=0;c[b+36>>2]=0}do{e=(c[b+40>>2]|0)+(d<<2)|0;if(e)c[e>>2]=0;d=d+1|0}while((d|0)!=0)}c[b+32>>2]=0;e=c[b+52>>2]|0;if((e|0)<0){if((c[b+56>>2]|0)<0){d=c[b+60>>2]|0;if(d){if(a[b+64>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+60>>2]=0}a[b+64>>0]=1;c[b+60>>2]=0;c[b+56>>2]=0}do{d=(c[b+60>>2]|0)+(e<<2)|0;if(d)c[d>>2]=0;e=e+1|0}while((e|0)!=0)}c[b+52>>2]=0;e=c[b+72>>2]|0;if((e|0)>=0){c[b+72>>2]=0;return}if((c[b+76>>2]|0)<0){d=c[b+80>>2]|0;if(d){if(a[b+84>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+80>>2]=0}a[b+84>>0]=1;c[b+80>>2]=0;c[b+76>>2]=0}do{d=(c[b+80>>2]|0)+(e<<2)|0;if(d)c[d>>2]=0;e=e+1|0}while((e|0)!=0);c[b+72>>2]=0;return}function xq(a,b){a=a|0;b=+b;var d=0,e=0,f=0;e=i;i=i+16|0;jE(1936);if((c[a+280>>2]|0)>0){d=0;do{f=c[(c[a+288>>2]|0)+(d<<2)>>2]|0;rc[c[(c[f>>2]|0)+8>>2]&7](f,a,b);d=d+1|0}while((d|0)<(c[a+280>>2]|0))}d=c[5128]|0;f=(c[d+16>>2]|0)+-1|0;c[d+16>>2]=f;if(f){i=e;return}do if(c[d+4>>2]|0){Cb(e|0,0)|0;f=c[5114]|0;g[d+8>>2]=+(((c[e+4>>2]|0)-(c[f+4>>2]|0)+(((c[e>>2]|0)-(c[f>>2]|0)|0)*1e6|0)-(c[d+12>>2]|0)|0)>>>0)/1.0e3+ +g[d+8>>2];if(!(c[d+16>>2]|0)){d=c[5128]|0;break}else{i=e;return}}while(0);c[5128]=c[d+20>>2];i=e;return}function yq(a,b){a=a|0;b=b|0;return}function zq(a){a=a|0;return 2}function Aq(a){a=a|0;return c[a+72>>2]|0}function Bq(a,b){a=a|0;b=b|0;c[a+72>>2]=b;return}function Cq(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;e=c[b>>2]|0;if((e|0)==(c[a+80>>2]|0)){f=1.0;return +f}if(c[e+204>>2]&4){f=1.0;return +f}if((+g[a+28>>2]-+g[a+12>>2])*+g[b+8>>2]+(+g[a+32>>2]-+g[a+16>>2])*+g[b+12>>2]+(+g[a+36>>2]-+g[a+20>>2])*+g[b+16>>2]>=-+g[a+84>>2]){f=1.0;return +f}g[a+4>>2]=+g[b+40>>2];c[a+76>>2]=e;if(d){c[a+44>>2]=c[b+8>>2];c[a+48>>2]=c[b+12>>2];c[a+52>>2]=c[b+16>>2];c[a+56>>2]=c[b+20>>2]}else{k=+g[b+8>>2];j=+g[b+12>>2];i=+g[b+16>>2];h=k*+g[e+20>>2]+j*+g[e+24>>2]+i*+g[e+28>>2];f=k*+g[e+36>>2]+j*+g[e+40>>2]+i*+g[e+44>>2];g[a+44>>2]=+g[e+4>>2]*k+ +g[e+8>>2]*j+ +g[e+12>>2]*i;g[a+48>>2]=h;g[a+52>>2]=f;g[a+56>>2]=0.0}c[a+60>>2]=c[b+24>>2];c[a+64>>2]=c[b+28>>2];c[a+68>>2]=c[b+32>>2];c[a+72>>2]=c[b+36>>2];k=+g[b+40>>2];return +k}function Dq(a,d){a=a|0;d=d|0;var e=0,f=0;e=c[d>>2]|0;f=c[a+80>>2]|0;if((e|0)==(f|0)){a=0;return a|0}if(!((b[a+10>>1]&b[d+4>>1])<<16>>16)){a=0;return a|0}if(!((b[d+6>>1]&b[a+8>>1])<<16>>16)){a=0;return a|0}a=c[a+92>>2]|0;a=Wb[c[(c[a>>2]|0)+28>>2]&63](a,f,e)|0;return a|0}function Eq(a){a=a|0;_E(a);return}function Fq(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;if((h|0)<0){p=c[b+8>>2]|0;+gc[c[(c[p>>2]|0)+12>>2]&3](p,d,e,f,g,c[b+12>>2]|0,c[b+16>>2]|0,c[b+4>>2]|0,c[b+20>>2]|0,c[b+24>>2]|0);return}o=c[b+16>>2]|0;a:do if((o|0)>0){l=c[b+12>>2]|0;i=0;while(1){m=l+(i<<2)|0;k=c[m>>2]|0;j=c[(c[k+28>>2]|0)+208>>2]|0;if((j|0)<=-1)j=c[(c[k+32>>2]|0)+208>>2]|0;k=i+1|0;if((j|0)==(h|0)){k=i;break a}if((k|0)<(o|0))i=k;else{m=0;break}}}else{k=0;m=0}while(0);if((k|0)<(o|0)){n=c[b+12>>2]|0;i=k;k=0;do{l=c[n+(i<<2)>>2]|0;j=c[(c[l+28>>2]|0)+208>>2]|0;if((j|0)<=-1)j=c[(c[l+32>>2]|0)+208>>2]|0;k=((j|0)==(h|0)&1)+k|0;i=i+1|0}while((i|0)!=(o|0));p=k}else p=0;j=c[b+4>>2]|0;if((c[j+72>>2]|0)<2){o=c[b+8>>2]|0;+gc[c[(c[o>>2]|0)+12>>2]&3](o,d,e,f,g,m,p,j,c[b+20>>2]|0,c[b+24>>2]|0);return}if((e|0)>0){k=c[b+32>>2]|0;j=c[b+36>>2]|0;n=0;do{o=d+(n<<2)|0;if((k|0)==(j|0)){h=(j|0)==0?1:j<<1;if((j|0)<(h|0)){if(!h)k=0;else{c[5132]=(c[5132]|0)+1;k=ZE((h<<2|3)+16|0)|0;if(!k)k=0;else{c[(k+19&-16)+-4>>2]=k;k=k+19&-16}j=c[b+32>>2]|0}if((j|0)>0){i=0;do{l=k+(i<<2)|0;if(l)c[l>>2]=c[(c[b+40>>2]|0)+(i<<2)>>2];i=i+1|0}while((i|0)!=(j|0))}l=c[b+40>>2]|0;if(l){if(a[b+44>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[l+-4>>2]|0);j=c[b+32>>2]|0}c[b+40>>2]=0}a[b+44>>0]=1;c[b+40>>2]=k;c[b+36>>2]=h;l=j;j=h}else l=j}else l=k;k=(c[b+40>>2]|0)+(l<<2)|0;if(k)c[k>>2]=c[o>>2];k=l+1|0;c[b+32>>2]=k;n=n+1|0}while((n|0)!=(e|0))}if((g|0)>0){j=c[b+52>>2]|0;i=c[b+56>>2]|0;h=0;do{o=f+(h<<2)|0;if((j|0)==(i|0)){n=(i|0)==0?1:i<<1;if((i|0)<(n|0)){if(!n)j=0;else{c[5132]=(c[5132]|0)+1;j=ZE((n<<2|3)+16|0)|0;if(!j)j=0;else{c[(j+19&-16)+-4>>2]=j;j=j+19&-16}i=c[b+52>>2]|0}if((i|0)>0){l=0;do{k=j+(l<<2)|0;if(k)c[k>>2]=c[(c[b+60>>2]|0)+(l<<2)>>2];l=l+1|0}while((l|0)!=(i|0))}k=c[b+60>>2]|0;if(k){if(a[b+64>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[k+-4>>2]|0);i=c[b+52>>2]|0}c[b+60>>2]=0}a[b+64>>0]=1;c[b+60>>2]=j;c[b+56>>2]=n;j=i;i=n}else j=i}k=(c[b+60>>2]|0)+(j<<2)|0;if(k)c[k>>2]=c[o>>2];j=j+1|0;c[b+52>>2]=j;h=h+1|0}while((h|0)!=(g|0))}if((p|0)>0){i=c[b+72>>2]|0;k=c[b+76>>2]|0;o=0;do{h=m+(o<<2)|0;if((i|0)==(k|0)){n=(k|0)==0?1:k<<1;if((k|0)<(n|0)){if(!n){l=0;i=k}else{c[5132]=(c[5132]|0)+1;i=ZE((n<<2|3)+16|0)|0;if(!i)i=0;else{c[(i+19&-16)+-4>>2]=i;i=i+19&-16}l=i;i=c[b+72>>2]|0}if((i|0)>0){j=0;do{k=l+(j<<2)|0;if(k)c[k>>2]=c[(c[b+80>>2]|0)+(j<<2)>>2];j=j+1|0}while((j|0)!=(i|0))}j=c[b+80>>2]|0;if(j){if(a[b+84>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[j+-4>>2]|0);i=c[b+72>>2]|0}c[b+80>>2]=0}a[b+84>>0]=1;c[b+80>>2]=l;c[b+76>>2]=n;k=n}else i=k}j=(c[b+80>>2]|0)+(i<<2)|0;if(j)c[j>>2]=c[h>>2];i=i+1|0;c[b+72>>2]=i;o=o+1|0}while((o|0)!=(p|0))}else i=c[b+72>>2]|0;if(((c[b+52>>2]|0)+i|0)<=(c[(c[b+4>>2]|0)+72>>2]|0))return;wq(b);return}function Gq(a){a=a|0;Hq(a);_E(a);return}function Hq(b){b=b|0;var d=0;c[b>>2]=2472;d=c[b+80>>2]|0;if(d){if(a[b+84>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+80>>2]=0}a[b+84>>0]=1;c[b+80>>2]=0;c[b+72>>2]=0;c[b+76>>2]=0;d=c[b+60>>2]|0;if(d){if(a[b+64>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+60>>2]=0}a[b+64>>0]=1;c[b+60>>2]=0;c[b+52>>2]=0;c[b+56>>2]=0;d=c[b+40>>2]|0;if(!d){a[b+44>>0]=1;c[b+40>>2]=0;c[b+32>>2]=0;b=b+36|0;c[b>>2]=0;return}if(a[b+44>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+40>>2]=0;a[b+44>>0]=1;c[b+40>>2]=0;c[b+32>>2]=0;b=b+36|0;c[b>>2]=0;return}function Iq(b,d,e,f,h,i){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;c[b+4>>2]=6;c[b+8>>2]=-1;c[b+12>>2]=-1;g[b+16>>2]=3402823466385288598117041.0e14;a[b+20>>0]=1;a[b+21>>0]=0;c[b+24>>2]=-1;c[b+28>>2]=d;c[b+32>>2]=e;g[b+36>>2]=0.0;g[b+40>>2]=.30000001192092896;c[b+44>>2]=0;c[b>>2]=2600;c[b+48>>2]=c[f+0>>2];c[b+52>>2]=c[f+4>>2];c[b+56>>2]=c[f+8>>2];c[b+60>>2]=c[f+12>>2];c[b+64>>2]=c[f+16>>2];c[b+68>>2]=c[f+20>>2];c[b+72>>2]=c[f+24>>2];c[b+76>>2]=c[f+28>>2];c[b+80>>2]=c[f+32>>2];c[b+84>>2]=c[f+36>>2];c[b+88>>2]=c[f+40>>2];c[b+92>>2]=c[f+44>>2];c[b+96>>2]=c[f+48>>2];c[b+100>>2]=c[f+52>>2];c[b+104>>2]=c[f+56>>2];c[b+108>>2]=c[f+60>>2];c[b+112>>2]=c[h+0>>2];c[b+116>>2]=c[h+4>>2];c[b+120>>2]=c[h+8>>2];c[b+124>>2]=c[h+12>>2];c[b+128>>2]=c[h+16>>2];c[b+132>>2]=c[h+20>>2];c[b+136>>2]=c[h+24>>2];c[b+140>>2]=c[h+28>>2];c[b+144>>2]=c[h+32>>2];c[b+148>>2]=c[h+36>>2];c[b+152>>2]=c[h+40>>2];c[b+156>>2]=c[h+44>>2];c[b+160>>2]=c[h+48>>2];c[b+164>>2]=c[h+52>>2];c[b+168>>2]=c[h+56>>2];c[b+172>>2]=c[h+60>>2];h=b+680|0;f=h+48|0;do{c[h>>2]=0;h=h+4|0}while((h|0)<(f|0));c[b+740>>2]=0;c[b+744>>2]=0;c[b+748>>2]=0;c[b+752>>2]=0;g[b+756>>2]=.20000000298023224;g[b+760>>2]=.20000000298023224;g[b+764>>2]=.20000000298023224;c[b+768>>2]=0;c[b+772>>2]=0;c[b+776>>2]=0;c[b+780>>2]=0;c[b+784>>2]=0;g[b+728>>2]=.699999988079071;g[b+732>>2]=1.0;g[b+736>>2]=.5;a[b+788>>0]=0;g[b+792>>2]=0.0;g[b+808>>2]=0.0;a[b+789>>0]=0;g[b+796>>2]=0.0;g[b+812>>2]=0.0;a[b+790>>0]=0;g[b+800>>2]=0.0;g[b+816>>2]=0.0;g[b+928>>2]=0.0;g[b+876>>2]=0.0;g[b+880>>2]=.10000000149011612;g[b+884>>2]=300.0;g[b+868>>2]=1.0;g[b+872>>2]=-1.0;g[b+896>>2]=0.0;g[b+900>>2]=.20000000298023224;g[b+904>>2]=0.0;g[b+908>>2]=0.0;g[b+888>>2]=1.0;g[b+892>>2]=.5;c[b+924>>2]=0;g[b+916>>2]=0.0;a[b+912>>0]=0;g[b+992>>2]=0.0;g[b+940>>2]=0.0;g[b+944>>2]=.10000000149011612;g[b+948>>2]=300.0;g[b+932>>2]=1.0;g[b+936>>2]=-1.0;g[b+960>>2]=0.0;g[b+964>>2]=.20000000298023224;g[b+968>>2]=0.0;g[b+972>>2]=0.0;g[b+952>>2]=1.0;g[b+956>>2]=.5;c[b+988>>2]=0;g[b+980>>2]=0.0;a[b+976>>0]=0;g[b+1056>>2]=0.0;g[b+1004>>2]=0.0;g[b+1008>>2]=.10000000149011612;g[b+1012>>2]=300.0;g[b+996>>2]=1.0;g[b+1e3>>2]=-1.0;g[b+1024>>2]=0.0;g[b+1028>>2]=.20000000298023224;g[b+1032>>2]=0.0;g[b+1036>>2]=0.0;g[b+1016>>2]=1.0;g[b+1020>>2]=.5;c[b+1052>>2]=0;g[b+1044>>2]=0.0;a[b+1040>>0]=0;a[b+1300>>0]=i&1;a[b+1301>>0]=1;c[b+1304>>2]=0;a[b+1308>>0]=0;Kq(b,(c[b+28>>2]|0)+4|0,(c[b+32>>2]|0)+4|0);return}function Jq(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0;j=i;i=i+64|0;jr();c[b+4>>2]=6;c[b+8>>2]=-1;c[b+12>>2]=-1;g[b+16>>2]=3402823466385288598117041.0e14;a[b+20>>0]=1;a[b+21>>0]=0;c[b+24>>2]=-1;c[b+28>>2]=3056;c[b+32>>2]=d;g[b+36>>2]=0.0;g[b+40>>2]=.30000001192092896;c[b+44>>2]=0;c[b>>2]=2600;c[b+112>>2]=c[e+0>>2];c[b+116>>2]=c[e+4>>2];c[b+120>>2]=c[e+8>>2];c[b+124>>2]=c[e+12>>2];c[b+128>>2]=c[e+16>>2];c[b+132>>2]=c[e+20>>2];c[b+136>>2]=c[e+24>>2];c[b+140>>2]=c[e+28>>2];c[b+144>>2]=c[e+32>>2];c[b+148>>2]=c[e+36>>2];c[b+152>>2]=c[e+40>>2];c[b+156>>2]=c[e+44>>2];c[b+160>>2]=c[e+48>>2];c[b+164>>2]=c[e+52>>2];c[b+168>>2]=c[e+56>>2];c[b+172>>2]=c[e+60>>2];e=b+680|0;h=e+48|0;do{c[e>>2]=0;e=e+4|0}while((e|0)<(h|0));c[b+740>>2]=0;c[b+744>>2]=0;c[b+748>>2]=0;c[b+752>>2]=0;g[b+756>>2]=.20000000298023224;g[b+760>>2]=.20000000298023224;g[b+764>>2]=.20000000298023224;c[b+768>>2]=0;c[b+772>>2]=0;c[b+776>>2]=0;c[b+780>>2]=0;c[b+784>>2]=0;g[b+728>>2]=.699999988079071;g[b+732>>2]=1.0;g[b+736>>2]=.5;a[b+788>>0]=0;g[b+792>>2]=0.0;g[b+808>>2]=0.0;a[b+789>>0]=0;g[b+796>>2]=0.0;g[b+812>>2]=0.0;a[b+790>>0]=0;g[b+800>>2]=0.0;g[b+816>>2]=0.0;g[b+928>>2]=0.0;g[b+876>>2]=0.0;g[b+880>>2]=.10000000149011612;g[b+884>>2]=300.0;g[b+868>>2]=1.0;g[b+872>>2]=-1.0;g[b+896>>2]=0.0;g[b+900>>2]=.20000000298023224;g[b+904>>2]=0.0;g[b+908>>2]=0.0;g[b+888>>2]=1.0;g[b+892>>2]=.5;c[b+924>>2]=0;g[b+916>>2]=0.0;a[b+912>>0]=0;g[b+992>>2]=0.0;g[b+940>>2]=0.0;g[b+944>>2]=.10000000149011612;g[b+948>>2]=300.0;g[b+932>>2]=1.0;g[b+936>>2]=-1.0;g[b+960>>2]=0.0;g[b+964>>2]=.20000000298023224;g[b+968>>2]=0.0;g[b+972>>2]=0.0;g[b+952>>2]=1.0;g[b+956>>2]=.5;c[b+988>>2]=0;g[b+980>>2]=0.0;a[b+976>>0]=0;g[b+1056>>2]=0.0;g[b+1004>>2]=0.0;g[b+1008>>2]=.10000000149011612;g[b+1012>>2]=300.0;g[b+996>>2]=1.0;g[b+1e3>>2]=-1.0;g[b+1024>>2]=0.0;g[b+1028>>2]=.20000000298023224;g[b+1032>>2]=0.0;g[b+1036>>2]=0.0;g[b+1016>>2]=1.0;g[b+1020>>2]=.5;c[b+1052>>2]=0;g[b+1044>>2]=0.0;a[b+1040>>0]=0;a[b+1300>>0]=f&1;a[b+1301>>0]=1;c[b+1304>>2]=0;a[b+1308>>0]=0;rp(j,d+4|0,b+112|0);c[b+48>>2]=c[j+0>>2];c[b+52>>2]=c[j+4>>2];c[b+56>>2]=c[j+8>>2];c[b+60>>2]=c[j+12>>2];c[b+64>>2]=c[j+16>>2];c[b+68>>2]=c[j+20>>2];c[b+72>>2]=c[j+24>>2];c[b+76>>2]=c[j+28>>2];c[b+80>>2]=c[j+32>>2];c[b+84>>2]=c[j+36>>2];c[b+88>>2]=c[j+40>>2];c[b+92>>2]=c[j+44>>2];c[b+96>>2]=c[j+48>>2];c[b+100>>2]=c[j+52>>2];c[b+104>>2]=c[j+56>>2];c[b+108>>2]=c[j+60>>2];Kq(b,(c[b+28>>2]|0)+4|0,(c[b+32>>2]|0)+4|0);i=j;return}function Kq(b,d,e){b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0;C=i;i=i+128|0;rp(C+64|0,d,b+48|0);c[b+1064>>2]=c[C+64>>2];c[b+1068>>2]=c[C+68>>2];c[b+1072>>2]=c[C+72>>2];c[b+1076>>2]=c[C+76>>2];c[b+1080>>2]=c[C+80>>2];c[b+1084>>2]=c[C+84>>2];c[b+1088>>2]=c[C+88>>2];c[b+1092>>2]=c[C+92>>2];c[b+1096>>2]=c[C+96>>2];c[b+1100>>2]=c[C+100>>2];c[b+1104>>2]=c[C+104>>2];c[b+1108>>2]=c[C+108>>2];c[b+1112>>2]=c[C+112>>2];c[b+1116>>2]=c[C+116>>2];c[b+1120>>2]=c[C+120>>2];c[b+1124>>2]=c[C+124>>2];rp(C,e,b+112|0);c[b+1128>>2]=c[C+0>>2];c[b+1132>>2]=c[C+4>>2];c[b+1136>>2]=c[C+8>>2];c[b+1140>>2]=c[C+12>>2];c[b+1144>>2]=c[C+16>>2];c[b+1148>>2]=c[C+20>>2];c[b+1152>>2]=c[C+24>>2];c[b+1156>>2]=c[C+28>>2];c[b+1160>>2]=c[C+32>>2];c[b+1164>>2]=c[C+36>>2];c[b+1168>>2]=c[C+40>>2];c[b+1172>>2]=c[C+44>>2];c[b+1176>>2]=c[C+48>>2];c[b+1180>>2]=c[C+52>>2];c[b+1184>>2]=c[C+56>>2];c[b+1188>>2]=c[C+60>>2];j=+g[b+1176>>2]-+g[b+1112>>2];f=+g[b+1180>>2]-+g[b+1116>>2];l=+g[b+1184>>2]-+g[b+1120>>2];r=+g[b+1084>>2];s=+g[b+1104>>2];t=+g[b+1088>>2];u=+g[b+1100>>2];v=+g[b+1096>>2];w=+g[b+1080>>2];x=+g[b+1064>>2];y=+g[b+1068>>2];z=+g[b+1072>>2];A=1.0/((r*s-t*u)*x+y*(t*v-s*w)+(u*w-r*v)*z);B=(u*w-r*v)*A;h=(r*s-t*u)*A*j+A*(u*z-s*y)*f+A*(t*y-r*z)*l;k=j*((t*v-s*w)*A)+f*(A*(s*x-v*z))+A*(w*z-t*x)*l;l=j*B+A*(v*y-u*x)*f+A*(r*x-w*y)*l;g[b+1256>>2]=h;g[b+1260>>2]=k;g[b+1264>>2]=l;g[b+1268>>2]=0.0;g[b+840>>2]=h;f=+g[b+680>>2];j=+g[b+696>>2];do if(!(f>j)){if(f>h){c[b+856>>2]=2;g[b+824>>2]=h-f;break}if(j<h){c[b+856>>2]=1;g[b+824>>2]=h-j;break}else{c[b+856>>2]=0;g[b+824>>2]=0.0;break}}else{c[b+856>>2]=0;g[b+824>>2]=0.0}while(0);g[b+844>>2]=k;h=+g[b+684>>2];f=+g[b+700>>2];do if(!(h>f)){if(h>k){c[b+860>>2]=2;g[b+828>>2]=k-h;break}if(f<k){c[b+860>>2]=1;g[b+828>>2]=k-f;break}else{c[b+860>>2]=0;g[b+828>>2]=0.0;break}}else{c[b+860>>2]=0;g[b+828>>2]=0.0}while(0);g[b+848>>2]=l;h=+g[b+688>>2];f=+g[b+704>>2];do if(!(h>f)){if(h>l){c[b+864>>2]=2;g[b+832>>2]=l-h;break}if(f<l){c[b+864>>2]=1;g[b+832>>2]=l-f;break}else{c[b+864>>2]=0;g[b+832>>2]=0.0;break}}else{c[b+864>>2]=0;g[b+832>>2]=0.0}while(0);l=+g[b+1128>>2];j=+g[b+1144>>2];h=+g[b+1160>>2];k=+g[b+1132>>2];f=+g[b+1148>>2];m=+g[b+1164>>2];n=(r*s-t*u)*A*k+A*(u*z-s*y)*f+A*(t*y-r*z)*m;o=(t*v-s*w)*A*k+A*(s*x-v*z)*f+A*(w*z-t*x)*m;p=l*B+A*(v*y-u*x)*j+A*(r*x-w*y)*h;q=B*+g[b+1136>>2]+A*(v*y-u*x)*+g[b+1152>>2]+A*(r*x-w*y)*+g[b+1168>>2];do if(p<1.0)if(p>-1.0){g[b+1192>>2]=+X(+-(B*k+A*(v*y-u*x)*f+A*(r*x-w*y)*m),+q);B=p<-1.0?-1.0:p;g[b+1196>>2]=+V(+(B>1.0?1.0:B));g[b+1200>>2]=+X(+-(l*((t*v-s*w)*A)+j*(A*(s*x-v*z))+A*(w*z-t*x)*h),+(l*((r*s-t*u)*A)+j*(A*(u*z-s*y))+A*(t*y-r*z)*h));break}else{g[b+1192>>2]=-+X(+n,+o);g[b+1196>>2]=-1.5707963705062866;g[b+1200>>2]=0.0;break}else{g[b+1192>>2]=+X(+n,+o);g[b+1196>>2]=1.5707963705062866;g[b+1200>>2]=0.0}while(0);g[b+1236>>2]=0.0;u=s*(l*s-h*z)-t*(j*z-l*t);v=z*(j*z-l*t)-s*(h*t-j*s);w=t*(h*t-j*s)-z*(l*s-h*z);g[b+1220>>2]=0.0;x=j*(j*z-l*t)-h*(l*s-h*z);y=h*(h*t-j*s)-l*(j*z-l*t);A=l*(l*s-h*z)-j*(h*t-j*s);g[b+1252>>2]=0.0;B=1.0/+P(+(u*u+v*v+w*w));g[b+1208>>2]=u*B;g[b+1212>>2]=v*B;g[b+1216>>2]=w*B;B=1.0/+P(+((h*t-j*s)*(h*t-j*s)+(l*s-h*z)*(l*s-h*z)+(j*z-l*t)*(j*z-l*t)));g[b+1224>>2]=(h*t-j*s)*B;g[b+1228>>2]=(l*s-h*z)*B;g[b+1232>>2]=(j*z-l*t)*B;B=1.0/+P(+(x*x+y*y+A*A));g[b+1240>>2]=x*B;g[b+1244>>2]=y*B;g[b+1248>>2]=A*B;if(!(a[b+1301>>0]|0)){i=C;return}f=+g[(c[b+28>>2]|0)+344>>2];h=+g[(c[b+32>>2]|0)+344>>2];if(f<1.1920928955078125e-07)e=1;else e=h<1.1920928955078125e-07&1;a[b+1280>>0]=e;if(f+h>0.0)f=h/(f+h);else f=.5;g[b+1272>>2]=f;g[b+1276>>2]=1.0-f;i=C;return}function Lq(b){b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0,k=0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0;m=i;i=i+144|0;if(!(a[b+1308>>0]|0)){i=m;return}g[b+928>>2]=0.0;g[b+992>>2]=0.0;g[b+1056>>2]=0.0;c[b+712>>2]=0;c[b+716>>2]=0;c[b+720>>2]=0;c[b+724>>2]=0;Kq(b,(c[b+28>>2]|0)+4|0,(c[b+32>>2]|0)+4|0);Jb[c[(c[b>>2]|0)+44>>2]&255](b);h=+g[b+1284>>2];f=+g[b+1288>>2];e=+g[b+1292>>2];d=0;do{if(+g[b+(d<<2)+696>>2]>=+g[b+(d<<2)+680>>2]){if(!(a[b+1300>>0]|0)){j=b+(d<<2)+1160|0;k=b+(d<<2)+1144|0;l=b+(d<<2)+1128|0}else{j=b+(d<<2)+1096|0;k=b+(d<<2)+1080|0;l=b+(d<<2)+1064|0}n=+g[j>>2];o=+g[k>>2];g[m>>2]=+g[l>>2];g[m+4>>2]=o;g[m+8>>2]=n;g[m+12>>2]=0.0;j=c[b+28>>2]|0;g[m+96>>2]=+g[j+4>>2];g[m+100>>2]=+g[j+20>>2];g[m+104>>2]=+g[j+36>>2];g[m+108>>2]=0.0;g[m+112>>2]=+g[j+8>>2];g[m+116>>2]=+g[j+24>>2];g[m+120>>2]=+g[j+40>>2];g[m+124>>2]=0.0;g[m+128>>2]=+g[j+12>>2];g[m+132>>2]=+g[j+28>>2];g[m+136>>2]=+g[j+44>>2];g[m+140>>2]=0.0;l=c[b+32>>2]|0;g[m+48>>2]=+g[l+4>>2];g[m+52>>2]=+g[l+20>>2];g[m+56>>2]=+g[l+36>>2];g[m+60>>2]=0.0;g[m+64>>2]=+g[l+8>>2];g[m+68>>2]=+g[l+24>>2];g[m+72>>2]=+g[l+40>>2];g[m+76>>2]=0.0;g[m+80>>2]=+g[l+12>>2];g[m+84>>2]=+g[l+28>>2];g[m+88>>2]=+g[l+44>>2];g[m+92>>2]=0.0;n=f-+g[j+56>>2];o=e-+g[j+60>>2];g[m+32>>2]=h-+g[j+52>>2];g[m+36>>2]=n;g[m+40>>2]=o;g[m+44>>2]=0.0;o=f-+g[l+56>>2];n=e-+g[l+60>>2];g[m+16>>2]=h-+g[l+52>>2];g[m+20>>2]=o;g[m+24>>2]=n;g[m+28>>2]=0.0;Tq(b+(d*84|0)+176|0,m+96|0,m+48|0,m+32|0,m+16|0,m,j+396|0,+g[j+344>>2],l+396|0,+g[l+344>>2])}d=d+1|0}while((d|0)!=3);l=0;do{e=+g[b+(l<<6)+868>>2];f=+g[b+(l<<6)+872>>2];h=+Uq(+g[b+(l<<2)+1192>>2],e,f);g[b+(l<<6)+920>>2]=h;do if(!(e>f)){if(e>h){c[b+(l<<6)+924>>2]=1;d=b+(l<<6)+916|0;g[d>>2]=h-e;if(h-e>3.1415927410125732){g[d>>2]=h-e+-6.2831854820251465;d=24;break}if(!(h-e<-3.1415927410125732)){d=24;break}g[d>>2]=h-e+6.2831854820251465;d=24;break}d=b+(l<<6)+924|0;if(!(f<h)){c[d>>2]=0;d=23;break}c[d>>2]=2;d=b+(l<<6)+916|0;g[d>>2]=h-f;if(h-f>3.1415927410125732){g[d>>2]=h-f+-6.2831854820251465;d=24;break}if(h-f<-3.1415927410125732){g[d>>2]=h-f+6.2831854820251465;d=24}else d=24}else{c[b+(l<<6)+924>>2]=0;d=23}while(0);if((d|0)==23?(d=0,(a[b+(l<<6)+912>>0]|0)!=0):0)d=24;if((d|0)==24){d=b+(l<<4)+1208|0;c[m+0>>2]=c[d+0>>2];c[m+4>>2]=c[d+4>>2];c[m+8>>2]=c[d+8>>2];c[m+12>>2]=c[d+12>>2];d=b+(l*84|0)+428|0;k=c[b+28>>2]|0;K=+g[k+4>>2];J=+g[k+20>>2];I=+g[k+36>>2];G=+g[k+8>>2];F=+g[k+24>>2];E=+g[k+40>>2];C=+g[k+12>>2];B=+g[k+28>>2];A=+g[k+44>>2];j=c[b+32>>2]|0;y=+g[j+4>>2];x=+g[j+20>>2];w=+g[j+36>>2];u=+g[j+8>>2];t=+g[j+24>>2];s=+g[j+40>>2];q=+g[j+12>>2];e=+g[j+28>>2];h=+g[j+44>>2];c[d+0>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;p=+g[m>>2];f=+g[m+4>>2];n=+g[m+8>>2];g[b+(l*84|0)+444>>2]=K*p+J*f+I*n;g[b+(l*84|0)+448>>2]=G*p+F*f+E*n;g[b+(l*84|0)+452>>2]=C*p+B*f+A*n;g[b+(l*84|0)+456>>2]=0.0;g[b+(l*84|0)+460>>2]=y*-p+x*-f+w*-n;g[b+(l*84|0)+464>>2]=u*-p+t*-f+s*-n;g[b+(l*84|0)+468>>2]=q*-p+e*-f+h*-n;g[b+(l*84|0)+472>>2]=0.0;H=(K*p+J*f+I*n)*+g[k+396>>2];D=(G*p+F*f+E*n)*+g[k+400>>2];z=(C*p+B*f+A*n)*+g[k+404>>2];g[b+(l*84|0)+476>>2]=H;g[b+(l*84|0)+480>>2]=D;g[b+(l*84|0)+484>>2]=z;g[b+(l*84|0)+488>>2]=0.0;v=(y*-p+x*-f+w*-n)*+g[j+396>>2];r=(u*-p+t*-f+s*-n)*+g[j+400>>2];o=(q*-p+e*-f+h*-n)*+g[j+404>>2];g[b+(l*84|0)+492>>2]=v;g[b+(l*84|0)+496>>2]=r;g[b+(l*84|0)+500>>2]=o;g[b+(l*84|0)+504>>2]=0.0;g[b+(l*84|0)+508>>2]=(K*p+J*f+I*n)*H+(G*p+F*f+E*n)*D+(C*p+B*f+A*n)*z+((y*-p+x*-f+w*-n)*v+(u*-p+t*-f+s*-n)*r+(q*-p+e*-f+h*-n)*o)}l=l+1|0}while((l|0)!=3);i=m;return}function Mq(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0.0,j=0.0,k=0.0,l=0;if(a[b+1308>>0]|0){c[d>>2]=0;c[d+4>>2]=0;return}Kq(b,(c[b+28>>2]|0)+4|0,(c[b+32>>2]|0)+4|0);c[d>>2]=0;c[d+4>>2]=6;if((c[b+856>>2]|0)==0?(a[b+788>>0]|0)==0:0){e=0;f=6}else{c[d>>2]=1;c[d+4>>2]=5;e=1;f=5}if(!((c[b+860>>2]|0)==0?(a[b+789>>0]|0)==0:0)){e=e+1|0;c[d>>2]=e;f=f+-1|0;c[d+4>>2]=f}if((c[b+864>>2]|0)==0?(a[b+790>>0]|0)==0:0)l=0;else{e=e+1|0;c[d>>2]=e;f=f+-1|0;c[d+4>>2]=f;l=0}do{i=+g[b+(l<<6)+868>>2];j=+g[b+(l<<6)+872>>2];k=+Uq(+g[b+(l<<2)+1192>>2],i,j);g[b+(l<<6)+920>>2]=k;do if(!(i>j)){if(i>k){c[b+(l<<6)+924>>2]=1;h=b+(l<<6)+916|0;g[h>>2]=k-i;if(k-i>3.1415927410125732){g[h>>2]=k-i+-6.2831854820251465;h=21;break}if(!(k-i<-3.1415927410125732)){h=21;break}g[h>>2]=k-i+6.2831854820251465;h=21;break}h=b+(l<<6)+924|0;if(!(j<k)){c[h>>2]=0;h=20;break}c[h>>2]=2;h=b+(l<<6)+916|0;g[h>>2]=k-j;if(k-j>3.1415927410125732){g[h>>2]=k-j+-6.2831854820251465;h=21;break}if(k-j<-3.1415927410125732){g[h>>2]=k-j+6.2831854820251465;h=21}else h=21}else{c[b+(l<<6)+924>>2]=0;h=20}while(0);if((h|0)==20){h=0;if(a[b+(l<<6)+912>>0]|0)h=21}if((h|0)==21){e=e+1|0;c[d>>2]=e;f=f+-1|0;c[d+4>>2]=f}l=l+1|0}while((l|0)!=3);return}function Nq(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0;m=i;i=i+16|0;k=c[b+28>>2]|0;l=c[b+32>>2]|0;if(!(a[b+1301>>0]|0)){j=0;e=Oq(b,d,0,k+4|0,l+4|0,k+312|0,l+312|0,k+328|0,l+328|0)|0;do{h=b+(j<<6)+868|0;if(!((c[b+(j<<6)+924>>2]|0)==0?(a[b+(j<<6)+912>>0]|0)==0:0)){f=b+(j<<4)+1208|0;c[m+0>>2]=c[f+0>>2];c[m+4>>2]=c[f+4>>2];c[m+8>>2]=c[f+8>>2];c[m+12>>2]=c[f+12>>2];f=c[b+1304>>2]>>(j*3|0)+9;if(!(f&1))g[b+(j<<6)+896>>2]=+g[c[d+32>>2]>>2];if(!(f&2))g[b+(j<<6)+904>>2]=+g[c[d+32>>2]>>2];if(!(f&4))g[b+(j<<6)+900>>2]=+g[d+4>>2];e=(Pq(b,h,k+4|0,l+4|0,k+312|0,l+312|0,k+328|0,l+328|0,d,e,m,1,0)|0)+e|0}j=j+1|0}while((j|0)!=3);i=m;return}j=0;e=0;do{f=b+(j<<6)+868|0;if(!((c[b+(j<<6)+924>>2]|0)==0?(a[b+(j<<6)+912>>0]|0)==0:0)){h=b+(j<<4)+1208|0;c[m+0>>2]=c[h+0>>2];c[m+4>>2]=c[h+4>>2];c[m+8>>2]=c[h+8>>2];c[m+12>>2]=c[h+12>>2];h=c[b+1304>>2]>>(j*3|0)+9;if(!(h&1))g[b+(j<<6)+896>>2]=+g[c[d+32>>2]>>2];if(!(h&2))g[b+(j<<6)+904>>2]=+g[c[d+32>>2]>>2];if(!(h&4))g[b+(j<<6)+900>>2]=+g[d+4>>2];e=(Pq(b,f,k+4|0,l+4|0,k+312|0,l+312|0,k+328|0,l+328|0,d,e,m,1,0)|0)+e|0}j=j+1|0}while((j|0)!=3);Oq(b,d,e,k+4|0,l+4|0,k+312|0,l+312|0,k+328|0,l+328|0)|0;i=m;return}function Oq(b,d,e,f,h,j,k,l,m){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0,q=0;q=i;i=i+80|0;g[q+76>>2]=0.0;g[q+24>>2]=0.0;g[q+28>>2]=.10000000149011612;g[q+32>>2]=300.0;g[q+16>>2]=1.0;g[q+20>>2]=-1.0;g[q+44>>2]=0.0;g[q+48>>2]=.20000000298023224;g[q+52>>2]=0.0;g[q+56>>2]=0.0;g[q+36>>2]=1.0;g[q+40>>2]=.5;c[q+72>>2]=0;g[q+64>>2]=0.0;a[q+60>>0]=0;p=0;do{n=c[b+(p<<2)+856>>2]|0;o=a[b+p+788>>0]|0;do if(!((n|0)==0&o<<24>>24==0)){g[q+56>>2]=0.0;c[q+72>>2]=n;g[q+68>>2]=+g[b+(p<<2)+840>>2];g[q+64>>2]=+g[b+(p<<2)+824>>2];g[q+36>>2]=+g[b+732>>2];a[q+60>>0]=o;g[q+20>>2]=+g[b+(p<<2)+696>>2];g[q+40>>2]=+g[b+728>>2];g[q+16>>2]=+g[b+(p<<2)+680>>2];g[q+32>>2]=0.0;g[q+28>>2]=+g[b+(p<<2)+808>>2];g[q+24>>2]=+g[b+(p<<2)+792>>2];g[q>>2]=+g[b+(p<<2)+1064>>2];g[q+4>>2]=+g[b+(p<<2)+1080>>2];g[q+8>>2]=+g[b+(p<<2)+1096>>2];g[q+12>>2]=0.0;o=c[b+1304>>2]>>p*3;if(!(o&1))n=c[d+32>>2]|0;else n=b+(p<<2)+740|0;g[q+44>>2]=+g[n>>2];if(!(o&2))n=c[d+32>>2]|0;else n=b+(p<<2)+772|0;g[q+52>>2]=+g[n>>2];if(!(o&4))n=d+4|0;else n=b+(p<<2)+756|0;g[q+48>>2]=+g[n>>2];if(!(a[b+1301>>0]|0)){e=(Pq(b,q+16|0,f,h,j,k,l,m,d,e,q,0,0)|0)+e|0;break}o=p+1|0;if(!(c[b+(((o|0)==3?0:o)<<6)+924>>2]|0))n=1;else n=(c[b+(((p+2|0)%3|0)<<6)+924>>2]|0)==0&1;e=(Pq(b,q+16|0,f,h,j,k,l,m,d,e,q,0,n)|0)+e|0}while(0);p=p+1|0}while((p|0)!=3);i=q;return e|0}function Pq(b,d,e,f,h,i,j,k,l,m,n,o,p){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;p=p|0;var q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0,z=0,A=0,B=0,C=0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0;A=$(c[l+24>>2]|0,m)|0;y=a[d+44>>0]|0;B=c[d+56>>2]|0;if(!(y<<24>>24!=0|(B|0)!=0)){o=0;return o|0}C=c[((o|0)!=0?l+12|0:l+8|0)>>2]|0;m=c[((o|0)!=0?l+20|0:l+16|0)>>2]|0;g[C+(A<<2)>>2]=+g[n>>2];g[C+(A+1<<2)>>2]=+g[n+4>>2];g[C+(A+2<<2)>>2]=+g[n+8>>2];g[m+(A<<2)>>2]=-+g[n>>2];g[m+(A+1<<2)>>2]=-+g[n+4>>2];g[m+(A+2<<2)>>2]=-+g[n+8>>2];do if(!o){r=+g[b+1176>>2];if(!(a[b+1301>>0]|0)){x=r-+g[e+48>>2];v=+g[b+1180>>2]-+g[e+52>>2];w=+g[b+1184>>2]-+g[e+56>>2];t=+g[n+8>>2];r=+g[n+4>>2];s=+g[n>>2];p=c[l+12>>2]|0;g[p+(A<<2)>>2]=v*t-w*r;g[p+(A+1<<2)>>2]=w*s-x*t;g[p+(A+2<<2)>>2]=x*r-v*s;s=+g[b+1176>>2]-+g[f+48>>2];v=+g[b+1180>>2]-+g[f+52>>2];r=+g[b+1184>>2]-+g[f+56>>2];x=+g[n+8>>2];t=+g[n+4>>2];w=+g[n>>2];p=c[l+20>>2]|0;g[p+(A<<2)>>2]=-(v*x-r*t);g[p+(A+1<<2)>>2]=-(r*w-s*x);g[p+(A+2<<2)>>2]=-(s*t-v*w);break}I=r-+g[f+48>>2];G=+g[b+1180>>2]-+g[f+52>>2];E=+g[b+1184>>2]-+g[f+56>>2];H=+g[n>>2];F=+g[n+4>>2];D=+g[n+8>>2];K=+g[b+1112>>2]-+g[e+48>>2];r=+g[b+1116>>2]-+g[e+52>>2];t=+g[b+1120>>2]-+g[e+56>>2];q=+g[d+52>>2]-+g[d+48>>2];J=H*(H*K+F*r+D*t)+H*q-H*(I*H+G*F+E*D);u=F*(H*K+F*r+D*t)+F*q-F*(I*H+G*F+E*D);q=D*(H*K+F*r+D*t)+D*q-D*(I*H+G*F+E*D);x=+g[b+1272>>2];w=+g[b+1276>>2];s=D*(r-F*(H*K+F*r+D*t)+x*u)-F*(t-D*(H*K+F*r+D*t)+x*q);v=H*(t-D*(H*K+F*r+D*t)+x*q)-D*(K-H*(H*K+F*r+D*t)+x*J);t=F*(K-H*(H*K+F*r+D*t)+x*J)-H*(r-F*(H*K+F*r+D*t)+x*u);r=D*(G-F*(I*H+G*F+E*D)-w*u)-F*(E-D*(I*H+G*F+E*D)-w*q);q=H*(E-D*(I*H+G*F+E*D)-w*q)-D*(I-H*(I*H+G*F+E*D)-w*J);u=F*(I-H*(I*H+G*F+E*D)-w*J)-H*(G-F*(I*H+G*F+E*D)-w*u);if(!((a[b+1280>>0]|0)==0|(p|0)!=0)){r=w*r;q=w*q;u=w*u;s=x*s;v=x*v;t=x*t}p=c[l+12>>2]|0;g[p+(A<<2)>>2]=s;g[p+(A+1<<2)>>2]=v;g[p+(A+2<<2)>>2]=t;p=c[l+20>>2]|0;g[p+(A<<2)>>2]=-r;g[p+(A+1<<2)>>2]=-q;g[p+(A+2<<2)>>2]=-u}while(0);if((B|0)!=0?+g[d>>2]==+g[d+4>>2]:0){m=c[l+28>>2]|0;g[m+(A<<2)>>2]=0.0}else z=11;do if((z|0)==11){m=c[l+28>>2]|0;g[m+(A<<2)>>2]=0.0;if(y<<24>>24){g[(c[l+32>>2]|0)+(A<<2)>>2]=+g[d+28>>2];if(B)break;v=+g[d+8>>2];if(o)q=v;else q=-v;s=+g[d+52>>2];t=+g[d>>2];u=+g[d+4>>2];r=+g[l>>2]*+g[d+32>>2];do if(!(t>u))if(!(t==u)){r=q/r;if(r<0.0)if(s>=t&t-r>s){r=(t-s)/r;break}else{r=s<t?0.0:1.0;break}if(r>0.0)if(s<=u&u-r<s){r=(u-s)/r;break}else{r=s>u?0.0:1.0;break}else r=0.0}else r=0.0;else r=1.0;while(0);g[m+(A<<2)>>2]=r*v+ +g[m+(A<<2)>>2];g[(c[l+36>>2]|0)+(A<<2)>>2]=-+g[d+12>>2];g[(c[l+40>>2]|0)+(A<<2)>>2]=+g[d+12>>2]}if(!B){o=1;return o|0}}while(0);q=+g[l>>2]*+g[d+32>>2]*+g[d+48>>2];e=m+(A<<2)|0;r=+g[e>>2];if(o)r=r-q;else r=q+r;g[e>>2]=r;g[(c[l+32>>2]|0)+(A<<2)>>2]=+g[d+36>>2];if(+g[d>>2]==+g[d+4>>2]){g[(c[l+36>>2]|0)+(A<<2)>>2]=-3402823466385288598117041.0e14;g[(c[l+40>>2]|0)+(A<<2)>>2]=3402823466385288598117041.0e14;o=1;return o|0}m=(c[l+36>>2]|0)+(A<<2)|0;if((B|0)==1){g[m>>2]=0.0;g[(c[l+40>>2]|0)+(A<<2)>>2]=3402823466385288598117041.0e14}else{g[m>>2]=-3402823466385288598117041.0e14;g[(c[l+40>>2]|0)+(A<<2)>>2]=0.0}r=+g[d+40>>2];if(!(r>0.0)){o=1;return o|0}if(o){H=+g[n>>2];K=+g[n+4>>2];q=+g[n+8>>2];q=+g[j>>2]*H+ +g[j+4>>2]*K+ +g[j+8>>2]*q-(H*+g[k>>2]+K*+g[k+4>>2]+q*+g[k+8>>2])}else{H=+g[n>>2];K=+g[n+4>>2];q=+g[n+8>>2];q=+g[h>>2]*H+ +g[h+4>>2]*K+ +g[h+8>>2]*q-(H*+g[i>>2]+K*+g[i+4>>2]+q*+g[i+8>>2])}if((B|0)==1){if(!(q<0.0)){o=1;return o|0}q=-(q*r);if(!(+g[e>>2]<q)){o=1;return o|0}g[e>>2]=q;o=1;return o|0}else{if(!(q>0.0)){o=1;return o|0}q=-(q*r);if(!(+g[e>>2]>q)){o=1;return o|0}g[e>>2]=q;o=1;return o|0}return 0}function Qq(a){a=a|0;var b=0.0,d=0.0,e=0.0,f=0.0;b=+g[(c[a+28>>2]|0)+344>>2];d=+g[(c[a+32>>2]|0)+344>>2];if(d==0.0)b=1.0;else b=b/(b+d);f=1.0-b;e=b*+g[a+1116>>2]+f*+g[a+1180>>2];d=b*+g[a+1120>>2]+f*+g[a+1184>>2];g[a+1284>>2]=b*+g[a+1112>>2]+f*+g[a+1176>>2];g[a+1288>>2]=e;g[a+1292>>2]=d;g[a+1296>>2]=0.0;return}function Rq(a,b,d,e){a=a|0;b=b|0;d=+d;e=e|0;if(e>>>0<3)if((b|0)==4){g[a+(e<<2)+772>>2]=d;c[a+1304>>2]=c[a+1304>>2]|2<<e*3;return}else if((b|0)==3){g[a+(e<<2)+740>>2]=d;c[a+1304>>2]=c[a+1304>>2]|1<<e*3;return}else if((b|0)==2){g[a+(e<<2)+756>>2]=d;c[a+1304>>2]=c[a+1304>>2]|4<<e*3;return}else return;if((e+-3|0)>>>0>=3)return;if((b|0)==4){g[a+(e+-3<<6)+904>>2]=d;c[a+1304>>2]=c[a+1304>>2]|2<<e*3;return}else if((b|0)==3){g[a+(e+-3<<6)+896>>2]=d;c[a+1304>>2]=c[a+1304>>2]|1<<e*3;return}else if((b|0)==2){g[a+(e+-3<<6)+900>>2]=d;c[a+1304>>2]=c[a+1304>>2]|4<<e*3;return}else return}function Sq(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0;do if(c>>>0<3)if((b|0)==2){d=+g[a+(c<<2)+756>>2];break}else if((b|0)==4){d=+g[a+(c<<2)+772>>2];break}else if((b|0)==3){d=+g[a+(c<<2)+740>>2];break}else{d=0.0;break}else if((c+-3|0)>>>0<3)if((b|0)==2){d=+g[a+(c+-3<<6)+900>>2];break}else if((b|0)==3){d=+g[a+(c+-3<<6)+896>>2];break}else if((b|0)==4){d=+g[a+(c+-3<<6)+904>>2];break}else{d=0.0;break}else d=0.0;while(0);return +d}function Tq(a,b,d,e,f,h,i,j,k,l){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;j=+j;k=k|0;l=+l;var m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0;c[a+0>>2]=c[h+0>>2];c[a+4>>2]=c[h+4>>2];c[a+8>>2]=c[h+8>>2];c[a+12>>2]=c[h+12>>2];s=+g[e+4>>2];v=+g[a+8>>2];w=+g[e+8>>2];p=+g[a+4>>2];m=+g[a>>2];r=+g[e>>2];u=(s*v-w*p)*+g[b>>2]+ +g[b+4>>2]*(w*m-v*r)+(p*r-s*m)*+g[b+8>>2];t=(s*v-w*p)*+g[b+16>>2]+(w*m-v*r)*+g[b+20>>2]+(p*r-s*m)*+g[b+24>>2];s=(s*v-w*p)*+g[b+32>>2]+(w*m-v*r)*+g[b+36>>2]+(p*r-s*m)*+g[b+40>>2];g[a+16>>2]=u;g[a+20>>2]=t;g[a+24>>2]=s;g[a+28>>2]=0.0;r=+g[f+4>>2];w=+g[f+8>>2];n=+g[f>>2];q=+g[d>>2]*(r*-v-w*-p)+ +g[d+4>>2]*(w*-m-n*-v)+(n*-p-r*-m)*+g[d+8>>2];o=(r*-v-w*-p)*+g[d+16>>2]+(w*-m-n*-v)*+g[d+20>>2]+(n*-p-r*-m)*+g[d+24>>2];m=(r*-v-w*-p)*+g[d+32>>2]+(w*-m-n*-v)*+g[d+36>>2]+(n*-p-r*-m)*+g[d+40>>2];g[a+32>>2]=q;g[a+36>>2]=o;g[a+40>>2]=m;g[a+44>>2]=0.0;u=+g[i>>2]*u;t=+g[i+4>>2]*t;s=+g[i+8>>2]*s;g[a+48>>2]=u;g[a+52>>2]=t;g[a+56>>2]=s;g[a+60>>2]=0.0;r=+g[k>>2]*q;p=+g[k+4>>2]*o;n=+g[k+8>>2]*m;g[a+64>>2]=r;g[a+68>>2]=p;g[a+72>>2]=n;g[a+76>>2]=0.0;g[a+80>>2]=u*+g[a+16>>2]+t*+g[a+20>>2]+s*+g[a+24>>2]+j+l+(r*q+p*o+n*m);return}function Uq(a,b,c){a=+a;b=+b;c=+c;var d=0.0,e=0.0;if(b>=c)return +a;if(a<b){d=+$E(b-a,6.2831854820251465);if(!(d<-3.1415927410125732)){if(d>3.1415927410125732)d=d+-6.2831854820251465}else d=d+6.2831854820251465;e=+O(+d);d=+$E(c-a,6.2831854820251465);if(!(d<-3.1415927410125732)){if(d>3.1415927410125732)d=d+-6.2831854820251465}else d=d+6.2831854820251465;if(e<+O(+d))return +a;a=a+6.2831854820251465;return +a}if(!(a>c))return +a;d=+$E(a-c,6.2831854820251465);if(!(d<-3.1415927410125732)){if(d>3.1415927410125732)d=d+-6.2831854820251465}else d=d+6.2831854820251465;e=+O(+d);d=+$E(a-b,6.2831854820251465);if(!(d<-3.1415927410125732)){if(d>3.1415927410125732)d=d+-6.2831854820251465}else d=d+6.2831854820251465;if(!(+O(+d)<e))return +a;a=a+-6.2831854820251465;return +a}function Vq(a,b,e){a=a|0;b=b|0;e=e|0;kr(a,b,e)|0;g[b+52>>2]=+g[a+48>>2];g[b+56>>2]=+g[a+52>>2];g[b+60>>2]=+g[a+56>>2];g[b+64>>2]=+g[a+60>>2];g[b+68>>2]=+g[a+64>>2];g[b+72>>2]=+g[a+68>>2];g[b+76>>2]=+g[a+72>>2];g[b+80>>2]=+g[a+76>>2];g[b+84>>2]=+g[a+80>>2];g[b+88>>2]=+g[a+84>>2];g[b+92>>2]=+g[a+88>>2];g[b+96>>2]=+g[a+92>>2];g[b+100>>2]=+g[a+96>>2];g[b+104>>2]=+g[a+100>>2];g[b+108>>2]=+g[a+104>>2];g[b+112>>2]=+g[a+108>>2];g[b+116>>2]=+g[a+112>>2];g[b+120>>2]=+g[a+116>>2];g[b+124>>2]=+g[a+120>>2];g[b+128>>2]=+g[a+124>>2];g[b+132>>2]=+g[a+128>>2];g[b+136>>2]=+g[a+132>>2];g[b+140>>2]=+g[a+136>>2];g[b+144>>2]=+g[a+140>>2];g[b+148>>2]=+g[a+144>>2];g[b+152>>2]=+g[a+148>>2];g[b+156>>2]=+g[a+152>>2];g[b+160>>2]=+g[a+156>>2];g[b+164>>2]=+g[a+160>>2];g[b+168>>2]=+g[a+164>>2];g[b+172>>2]=+g[a+168>>2];g[b+176>>2]=+g[a+172>>2];g[b+228>>2]=+g[a+868>>2];g[b+212>>2]=+g[a+872>>2];g[b+196>>2]=+g[a+680>>2];g[b+180>>2]=+g[a+696>>2];g[b+232>>2]=+g[a+932>>2];g[b+216>>2]=+g[a+936>>2];g[b+200>>2]=+g[a+684>>2];g[b+184>>2]=+g[a+700>>2];g[b+236>>2]=+g[a+996>>2];g[b+220>>2]=+g[a+1e3>>2];g[b+204>>2]=+g[a+688>>2];g[b+188>>2]=+g[a+704>>2];c[b+244>>2]=d[a+1300>>0];c[b+248>>2]=d[a+1301>>0];return 2696}function Wq(a){a=a|0;return 252}function Xq(a){a=a|0;if(!a)return;c[5134]=(c[5134]|0)+1;_E(c[a+-4>>2]|0);return}function Yq(b,d){b=b|0;d=d|0;var e=0.0,f=0.0;if(a[b+1309>>0]|0){e=(+g[b+1256>>2]-+g[b+1316>>2])*+g[b+1340>>2];g[b+792>>2]=e*(+g[d>>2]*+g[b+1364>>2]/+(c[d+48>>2]|0));e=+O(+e);g[b+808>>2]=e/+g[d>>2]}if(a[b+1310>>0]|0){e=(+g[b+1260>>2]-+g[b+1320>>2])*+g[b+1344>>2];g[b+796>>2]=e*(+g[d>>2]*+g[b+1368>>2]/+(c[d+48>>2]|0));e=+O(+e);g[b+812>>2]=e/+g[d>>2]}if(a[b+1311>>0]|0){e=(+g[b+1264>>2]-+g[b+1324>>2])*+g[b+1348>>2];g[b+800>>2]=e*(+g[d>>2]*+g[b+1372>>2]/+(c[d+48>>2]|0));e=+O(+e);g[b+816>>2]=e/+g[d>>2]}if(a[b+1312>>0]|0){f=-((+g[b+1192>>2]-+g[b+1328>>2])*+g[b+1352>>2]);e=+g[d>>2];g[b+876>>2]=e*+g[b+1376>>2]/+(c[d+48>>2]|0)*f;g[b+880>>2]=+O(+f)/e}if(a[b+1313>>0]|0){e=-((+g[b+1196>>2]-+g[b+1332>>2])*+g[b+1356>>2]);f=+g[d>>2];g[b+940>>2]=f*+g[b+1380>>2]/+(c[d+48>>2]|0)*e;g[b+944>>2]=+O(+e)/f}if(!(a[b+1314>>0]|0)){Nq(b,d);return}e=-((+g[b+1200>>2]-+g[b+1336>>2])*+g[b+1360>>2]);f=+g[d>>2];g[b+1004>>2]=f*+g[b+1384>>2]/+(c[d+48>>2]|0)*e;g[b+1008>>2]=+O(+e)/f;Nq(b,d);return}function Zq(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0;u=+g[b>>2];t=+g[b+4>>2];s=+g[b+8>>2];r=1.0/+P(+(u*u+t*t+s*s));y=+g[d>>2];x=+g[d+4>>2];w=+g[d+8>>2];v=1.0/+P(+(y*y+x*x+w*w));B=s*r*(x*v)-t*r*(w*v);A=u*r*(w*v)-s*r*(y*v);z=t*r*(y*v)-u*r*(x*v);d=c[a+28>>2]|0;e=+g[d+4>>2];h=+g[d+20>>2];j=+g[d+36>>2];f=+g[d+8>>2];i=+g[d+24>>2];k=+g[d+40>>2];l=+g[d+12>>2];n=+g[d+28>>2];p=+g[d+44>>2];m=-+g[d+52>>2];o=-+g[d+56>>2];q=-+g[d+60>>2];g[a+48>>2]=e*B+A*h+z*j;g[a+52>>2]=y*v*e+x*v*h+w*v*j;g[a+56>>2]=u*r*e+t*r*h+s*r*j;g[a+60>>2]=0.0;g[a+64>>2]=B*f+A*i+z*k;g[a+68>>2]=y*v*f+x*v*i+w*v*k;g[a+72>>2]=u*r*f+t*r*i+s*r*k;g[a+76>>2]=0.0;g[a+80>>2]=B*l+A*n+z*p;g[a+84>>2]=y*v*l+x*v*n+w*v*p;g[a+88>>2]=u*r*l+t*r*n+s*r*p;g[a+92>>2]=0.0;g[a+96>>2]=e*0.0+h*0.0+j*0.0+(e*m+h*o+j*q);g[a+100>>2]=f*0.0+i*0.0+k*0.0+(f*m+i*o+k*q);g[a+104>>2]=l*0.0+n*0.0+p*0.0+(l*m+n*o+p*q);g[a+108>>2]=0.0;d=c[a+32>>2]|0;q=+g[d+4>>2];p=+g[d+20>>2];o=+g[d+36>>2];n=+g[d+8>>2];m=+g[d+24>>2];l=+g[d+40>>2];k=+g[d+12>>2];i=+g[d+28>>2];f=+g[d+44>>2];j=-+g[d+52>>2];h=-+g[d+56>>2];e=-+g[d+60>>2];g[a+112>>2]=B*q+A*p+z*o;g[a+116>>2]=y*v*q+x*v*p+w*v*o;g[a+120>>2]=u*r*q+t*r*p+s*r*o;g[a+124>>2]=0.0;g[a+128>>2]=B*n+A*m+z*l;g[a+132>>2]=y*v*n+x*v*m+w*v*l;g[a+136>>2]=u*r*n+t*r*m+s*r*l;g[a+140>>2]=0.0;g[a+144>>2]=B*k+A*i+z*f;g[a+148>>2]=y*v*k+x*v*i+w*v*f;g[a+152>>2]=u*r*k+t*r*i+s*r*f;g[a+156>>2]=0.0;g[a+160>>2]=q*0.0+p*0.0+o*0.0+(q*j+p*h+o*e);g[a+164>>2]=n*0.0+m*0.0+l*0.0+(n*j+m*h+l*e);g[a+168>>2]=k*0.0+i*0.0+f*0.0+(k*j+i*h+f*e);g[a+172>>2]=0.0;Kq(a,(c[a+28>>2]|0)+4|0,(c[a+32>>2]|0)+4|0);return}function _q(a,b,e){a=a|0;b=b|0;e=e|0;Vq(a,b,e)|0;g[b+276>>2]=+g[a+1316>>2];g[b+324>>2]=+g[a+1364>>2];c[b+252>>2]=d[a+1309>>0];g[b+300>>2]=+g[a+1340>>2];g[b+280>>2]=+g[a+1320>>2];g[b+328>>2]=+g[a+1368>>2];c[b+256>>2]=d[a+1310>>0];g[b+304>>2]=+g[a+1344>>2];g[b+284>>2]=+g[a+1324>>2];g[b+332>>2]=+g[a+1372>>2];c[b+260>>2]=d[a+1311>>0];g[b+308>>2]=+g[a+1348>>2];g[b+288>>2]=+g[a+1328>>2];g[b+336>>2]=+g[a+1376>>2];c[b+264>>2]=d[a+1312>>0];g[b+312>>2]=+g[a+1352>>2];g[b+292>>2]=+g[a+1332>>2];g[b+340>>2]=+g[a+1380>>2];c[b+268>>2]=d[a+1313>>0];g[b+316>>2]=+g[a+1356>>2];g[b+296>>2]=+g[a+1336>>2];g[b+344>>2]=+g[a+1384>>2];c[b+272>>2]=d[a+1314>>0];g[b+320>>2]=+g[a+1360>>2];return 2840}function $q(a){a=a|0;return 348}function ar(a){a=a|0;if(!a)return;c[5134]=(c[5134]|0)+1;_E(c[a+-4>>2]|0);return}function br(a){a=a|0;var b=0,d=0,e=0,f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0;d=i;i=i+144|0;g[a+36>>2]=0.0;c[d+128>>2]=0;c[d+132>>2]=0;c[d+136>>2]=0;c[d+140>>2]=0;b=0;do{e=d+128+(b<<2)|0;g[e>>2]=1.0;f=c[a+28>>2]|0;G=+g[f+4>>2];g[d+80>>2]=G;C=+g[f+20>>2];g[d+84>>2]=C;j=+g[f+36>>2];g[d+88>>2]=j;g[d+92>>2]=0.0;F=+g[f+8>>2];g[d+96>>2]=F;B=+g[f+24>>2];g[d+100>>2]=B;u=+g[f+40>>2];g[d+104>>2]=u;g[d+108>>2]=0.0;E=+g[f+12>>2];g[d+112>>2]=E;A=+g[f+28>>2];g[d+116>>2]=A;n=+g[f+44>>2];g[d+120>>2]=n;g[d+124>>2]=0.0;h=c[a+32>>2]|0;x=+g[h+4>>2];g[d+32>>2]=x;t=+g[h+20>>2];g[d+36>>2]=t;o=+g[h+36>>2];g[d+40>>2]=o;g[d+44>>2]=0.0;w=+g[h+8>>2];g[d+48>>2]=w;s=+g[h+24>>2];g[d+52>>2]=s;m=+g[h+40>>2];g[d+56>>2]=m;g[d+60>>2]=0.0;v=+g[h+12>>2];g[d+64>>2]=v;r=+g[h+28>>2];g[d+68>>2]=r;k=+g[h+44>>2];g[d+72>>2]=k;g[d+76>>2]=0.0;y=+g[a+300>>2];q=+g[a+304>>2];l=+g[a+308>>2];D=+g[f+52>>2];z=+g[f+56>>2];p=+g[f+60>>2];g[d+16>>2]=y*G+q*F+l*E+D-D;g[d+20>>2]=y*C+q*B+l*A+z-z;g[d+24>>2]=y*j+q*u+l*n+p-p;g[d+28>>2]=0.0;p=+g[a+316>>2];n=+g[a+320>>2];l=+g[a+324>>2];u=+g[h+52>>2];q=+g[h+56>>2];j=+g[h+60>>2];g[d>>2]=p*x+n*w+l*v+u-u;g[d+4>>2]=p*t+n*s+l*r+q-q;g[d+8>>2]=p*o+n*m+l*k+j-j;g[d+12>>2]=0.0;h=c[a+28>>2]|0;f=c[a+32>>2]|0;Tq(a+(b*84|0)+48|0,d+80|0,d+32|0,d+16|0,d,d+128|0,h+396|0,+g[h+344>>2],f+396|0,+g[f+344>>2]);g[e>>2]=0.0;b=b+1|0}while((b|0)!=3);i=d;return}function cr(b,d){b=b|0;d=d|0;b=(a[b+344>>0]|0)==0?3:0;c[d>>2]=b;c[d+4>>2]=b;return}function dr(a,b){a=a|0;b=b|0;var d=0.0,e=0,f=0.0,h=0,i=0,j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0;j=c[a+28>>2]|0;k=c[a+32>>2]|0;e=c[b+8>>2]|0;g[e>>2]=1.0;h=c[b+24>>2]|0;g[e+(h+1<<2)>>2]=1.0;g[e+((h<<1)+2<<2)>>2]=1.0;l=+g[a+300>>2];q=+g[a+304>>2];f=+g[a+308>>2];o=+g[j+4>>2]*l+ +g[j+8>>2]*q+ +g[j+12>>2]*f;m=l*+g[j+20>>2]+q*+g[j+24>>2]+f*+g[j+28>>2];f=l*+g[j+36>>2]+q*+g[j+40>>2]+f*+g[j+44>>2];e=c[b+12>>2]|0;g[e>>2]=0.0;g[e+4>>2]=f;g[e+8>>2]=-m;g[e+12>>2]=0.0;g[e+(h<<2)>>2]=-f;g[e+(h+1<<2)>>2]=0.0;g[e+(h+2<<2)>>2]=o;g[e+(h+3<<2)>>2]=0.0;g[e+(h<<1<<2)>>2]=m;g[e+((h<<1|1)<<2)>>2]=-o;g[e+((h<<1)+2<<2)>>2]=0.0;g[e+((h<<1)+3<<2)>>2]=0.0;e=c[b+16>>2]|0;g[e>>2]=-1.0;g[e+(h+1<<2)>>2]=-1.0;g[e+((h<<1)+2<<2)>>2]=-1.0;q=+g[a+316>>2];l=+g[a+320>>2];d=+g[a+324>>2];p=+g[k+4>>2]*q+ +g[k+8>>2]*l+ +g[k+12>>2]*d;n=q*+g[k+20>>2]+l*+g[k+24>>2]+d*+g[k+28>>2];d=q*+g[k+36>>2]+l*+g[k+40>>2]+d*+g[k+44>>2];h=c[b+20>>2]|0;e=c[b+24>>2]|0;g[h>>2]=0.0;g[h+4>>2]=-d;g[h+8>>2]=n;g[h+12>>2]=0.0;g[h+(e<<2)>>2]=d;g[h+(e+1<<2)>>2]=0.0;g[h+(e+2<<2)>>2]=-p;g[h+(e+3<<2)>>2]=0.0;g[h+(e<<1<<2)>>2]=-n;g[h+((e<<1|1)<<2)>>2]=p;g[h+((e<<1)+2<<2)>>2]=0.0;g[h+((e<<1)+3<<2)>>2]=0.0;h=c[a+332>>2]|0;l=+g[((h&1|0)==0?b+4|0:a+336|0)>>2]*+g[b>>2];i=c[b+28>>2]|0;g[i>>2]=l*(p+ +g[k+52>>2]-o-+g[j+52>>2]);g[i+(e<<2)>>2]=l*(n+ +g[k+56>>2]-m-+g[j+56>>2]);g[i+(e<<1<<2)>>2]=l*(d+ +g[k+60>>2]-f-+g[j+60>>2]);if(h&2){k=c[b+32>>2]|0;g[k>>2]=+g[a+340>>2];g[k+(e<<2)>>2]=+g[a+340>>2];g[k+(e<<1<<2)>>2]=+g[a+340>>2]}f=+g[a+356>>2];if(f>0.0){g[c[b+36>>2]>>2]=-f;g[c[b+40>>2]>>2]=f;d=+g[a+356>>2]}else d=f;if(d>0.0){g[(c[b+36>>2]|0)+(e<<2)>>2]=-f;g[(c[b+40>>2]|0)+(e<<2)>>2]=f;d=+g[a+356>>2]}if(!(d>0.0)){k=a+352|0;q=+g[k>>2];k=b+52|0;g[k>>2]=q;return}g[(c[b+36>>2]|0)+(e<<1<<2)>>2]=-f;g[(c[b+40>>2]|0)+(e<<1<<2)>>2]=f;k=a+352|0;q=+g[k>>2];k=b+52|0;g[k>>2]=q;return}function er(a,b,d,e){a=a|0;b=b|0;d=+d;e=e|0;if((e|0)!=-1)return;if((b|0)==2|(b|0)==1){g[a+336>>2]=d;c[a+332>>2]=c[a+332>>2]|1;return}else if((b|0)==4|(b|0)==3){g[a+340>>2]=d;c[a+332>>2]=c[a+332>>2]|2;return}else return}function fr(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0;do if((c|0)==-1)if((b|0)==4|(b|0)==3){d=+g[a+340>>2];break}else if((b|0)==2|(b|0)==1){d=+g[a+336>>2];break}else{d=3402823466385288598117041.0e14;break}else d=3402823466385288598117041.0e14;while(0);return +d}function gr(a,b,c){a=a|0;b=b|0;c=c|0;kr(a,b,c)|0;g[b+52>>2]=+g[a+300>>2];g[b+56>>2]=+g[a+304>>2];g[b+60>>2]=+g[a+308>>2];g[b+64>>2]=+g[a+312>>2];g[b+68>>2]=+g[a+316>>2];g[b+72>>2]=+g[a+320>>2];g[b+76>>2]=+g[a+324>>2];g[b+80>>2]=+g[a+328>>2];return 2984}function hr(a){a=a|0;return 84}function ir(a){a=a|0;if(!a)return;c[5134]=(c[5134]|0)+1;_E(c[a+-4>>2]|0);return}function jr(){var b=0,d=0.0,e=0.0;b=i;i=i+16|0;if((a[3672]|0)==0?(Xa(3672)|0)!=0:0){c[b+0>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;Cp(3056,0.0,0,0,b);ab(3672)}c[815]=c[815]|1;g[850]=0.0;d=+g[860]*0.0;e=+g[861]*0.0;g[855]=+g[859]*0.0;g[856]=d;g[857]=e;g[858]=0.0;c[863]=0;c[864]=0;c[865]=0;c[866]=0;e=+g[852]*0.0;d=+g[853]*0.0;g[904]=+g[851]*0.0;g[905]=e;g[906]=d;g[907]=0.0;i=b;return}function kr(a,b,e){a=a|0;b=b|0;e=e|0;var f=0,h=0;c[b>>2]=ec[c[(c[e>>2]|0)+28>>2]&31](e,c[a+28>>2]|0)|0;c[b+4>>2]=ec[c[(c[e>>2]|0)+28>>2]&31](e,c[a+32>>2]|0)|0;f=ec[c[(c[e>>2]|0)+40>>2]&31](e,a)|0;h=ec[c[(c[e>>2]|0)+28>>2]&31](e,f)|0;c[b+8>>2]=h;if(h)Lb[c[(c[e>>2]|0)+48>>2]&127](e,f);c[b+12>>2]=c[a+4>>2];c[b+24>>2]=d[a+21>>0];c[b+40>>2]=c[a+24>>2];g[b+44>>2]=+g[a+16>>2];c[b+48>>2]=d[a+20>>0];c[b+20>>2]=c[a+12>>2];c[b+16>>2]=c[a+8>>2];g[b+28>>2]=+g[a+36>>2];g[b+32>>2]=+g[a+40>>2];c[b+36>>2]=0;f=c[a+28>>2]|0;if((c[f+488>>2]|0)>0){e=0;do{if((c[(c[f+496>>2]|0)+(e<<2)>>2]|0)==(a|0)){c[b+36>>2]=1;f=c[a+28>>2]|0}e=e+1|0}while((e|0)<(c[f+488>>2]|0))}f=c[a+32>>2]|0;if((c[f+488>>2]|0)>0)e=0;else return 3024;do{if((c[(c[f+496>>2]|0)+(e<<2)>>2]|0)==(a|0)){c[b+36>>2]=1;f=c[a+32>>2]|0}e=e+1|0}while((e|0)<(c[f+488>>2]|0));return 3024}function lr(b,d,e){b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,j=0.0,k=0,l=0.0,m=0.0,n=0.0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0;k=i;i=i+256|0;if((a[b+180>>0]|0)==0?(a[b+48>>0]|0)!=0:0){rp(k+64|0,e,b+116|0);c[b+824>>2]=c[k+64>>2];c[b+828>>2]=c[k+68>>2];c[b+832>>2]=c[k+72>>2];c[b+836>>2]=c[k+76>>2];c[b+840>>2]=c[k+80>>2];c[b+844>>2]=c[k+84>>2];c[b+848>>2]=c[k+88>>2];c[b+852>>2]=c[k+92>>2];c[b+856>>2]=c[k+96>>2];c[b+860>>2]=c[k+100>>2];c[b+864>>2]=c[k+104>>2];c[b+868>>2]=c[k+108>>2];c[b+872>>2]=c[k+112>>2];c[b+876>>2]=c[k+116>>2];c[b+880>>2]=c[k+120>>2];c[b+884>>2]=c[k+124>>2];rp(k,d,b+52|0);c[b+888>>2]=c[k+0>>2];c[b+892>>2]=c[k+4>>2];c[b+896>>2]=c[k+8>>2];c[b+900>>2]=c[k+12>>2];c[b+904>>2]=c[k+16>>2];c[b+908>>2]=c[k+20>>2];c[b+912>>2]=c[k+24>>2];c[b+916>>2]=c[k+28>>2];c[b+920>>2]=c[k+32>>2];c[b+924>>2]=c[k+36>>2];c[b+928>>2]=c[k+40>>2];c[b+932>>2]=c[k+44>>2];c[b+936>>2]=c[k+48>>2];c[b+940>>2]=c[k+52>>2];c[b+944>>2]=c[k+56>>2];c[b+948>>2]=c[k+60>>2]}else{rp(k+192|0,d,b+52|0);c[b+824>>2]=c[k+192>>2];c[b+828>>2]=c[k+196>>2];c[b+832>>2]=c[k+200>>2];c[b+836>>2]=c[k+204>>2];c[b+840>>2]=c[k+208>>2];c[b+844>>2]=c[k+212>>2];c[b+848>>2]=c[k+216>>2];c[b+852>>2]=c[k+220>>2];c[b+856>>2]=c[k+224>>2];c[b+860>>2]=c[k+228>>2];c[b+864>>2]=c[k+232>>2];c[b+868>>2]=c[k+236>>2];c[b+872>>2]=c[k+240>>2];c[b+876>>2]=c[k+244>>2];c[b+880>>2]=c[k+248>>2];c[b+884>>2]=c[k+252>>2];rp(k+128|0,e,b+116|0);c[b+888>>2]=c[k+128>>2];c[b+892>>2]=c[k+132>>2];c[b+896>>2]=c[k+136>>2];c[b+900>>2]=c[k+140>>2];c[b+904>>2]=c[k+144>>2];c[b+908>>2]=c[k+148>>2];c[b+912>>2]=c[k+152>>2];c[b+916>>2]=c[k+156>>2];c[b+920>>2]=c[k+160>>2];c[b+924>>2]=c[k+164>>2];c[b+928>>2]=c[k+168>>2];c[b+932>>2]=c[k+172>>2];c[b+936>>2]=c[k+176>>2];c[b+940>>2]=c[k+180>>2];c[b+944>>2]=c[k+184>>2];c[b+948>>2]=c[k+188>>2]}c[b+968>>2]=c[b+872>>2];c[b+972>>2]=c[b+876>>2];c[b+976>>2]=c[b+880>>2];c[b+980>>2]=c[b+884>>2];c[b+984>>2]=c[b+936>>2];c[b+988>>2]=c[b+940>>2];c[b+992>>2]=c[b+944>>2];c[b+996>>2]=c[b+948>>2];f=+g[b+824>>2];h=+g[b+840>>2];j=+g[b+856>>2];g[b+952>>2]=f;g[b+956>>2]=h;g[b+960>>2]=j;g[b+964>>2]=0.0;if((a[b+180>>0]|0)==0?(a[b+48>>0]|0)==0:0){s=+g[b+968>>2];n=s-+g[b+984>>2];r=+g[b+972>>2];m=r-+g[b+988>>2];q=+g[b+976>>2];l=q-+g[b+992>>2];g[b+1016>>2]=n;g[b+1020>>2]=m;g[b+1024>>2]=l;g[b+1028>>2]=0.0;p=f*n;t=h*m;t=p+t;p=j*l;p=t+p;f=f*p;h=h*p;j=j*p;f=s+f;h=r+h;j=q+j;e=b+1e3|0;g[e>>2]=f;e=b+1004|0;g[e>>2]=h;e=b+1008|0;g[e>>2]=j;e=b+1012|0;g[e>>2]=0.0;e=b+1032|0;g[e>>2]=p;e=b+828|0;d=b+844|0;o=b+860|0;j=+g[e>>2];h=+g[d>>2];f=+g[o>>2];j=j*n;h=h*m;h=j+h;f=f*l;f=h+f;o=b+1036|0;g[o>>2]=f;o=b+832|0;d=b+848|0;e=b+864|0;f=+g[o>>2];h=+g[d>>2];j=+g[e>>2];f=f*n;h=h*m;h=f+h;j=j*l;j=h+j;e=b+1040|0;g[e>>2]=j;i=k;return}u=+g[b+968>>2];t=+g[b+984>>2]-u;r=+g[b+972>>2];p=+g[b+988>>2]-r;l=+g[b+976>>2];q=+g[b+992>>2]-l;g[b+1016>>2]=t;g[b+1020>>2]=p;g[b+1024>>2]=q;g[b+1028>>2]=0.0;n=f*t;s=h*p;s=n+s;n=j*q;n=s+n;s=f*n;m=h*n;j=j*n;s=u+s;m=r+m;j=l+j;e=b+1e3|0;g[e>>2]=s;e=b+1004|0;g[e>>2]=m;e=b+1008|0;g[e>>2]=j;e=b+1012|0;g[e>>2]=0.0;e=b+1032|0;g[e>>2]=n;e=b+828|0;o=b+844|0;d=b+860|0;n=+g[e>>2];j=+g[o>>2];m=+g[d>>2];n=n*t;j=j*p;j=n+j;m=m*q;m=j+m;d=b+1036|0;g[d>>2]=m;d=b+832|0;o=b+848|0;e=b+864|0;m=+g[d>>2];j=+g[o>>2];n=+g[e>>2];t=m*t;p=j*p;p=t+p;q=n*q;q=p+q;e=b+1040|0;g[e>>2]=q;i=k;return}function mr(b,d){b=b|0;d=d|0;var e=0,f=0.0,h=0.0,i=0.0,j=0,k=0.0,l=0.0;if(a[b+48>>0]|0){c[d>>2]=0;c[d+4>>2]=0;return}c[d>>2]=4;c[d+4>>2]=2;lr(b,(c[b+28>>2]|0)+4|0,(c[b+32>>2]|0)+4|0);g[b+1088>>2]=0.0;a[b+297>>0]=0;f=+g[b+192>>2];h=+g[b+196>>2];do if(f<=h){l=+g[b+892>>2];k=+g[b+908>>2];i=+g[b+924>>2];i=+Uq(+X(+(+g[b+832>>2]*l+ +g[b+848>>2]*k+ +g[b+864>>2]*i),+(+g[b+828>>2]*l+ +g[b+844>>2]*k+ +g[b+860>>2]*i)),f,h);g[b+1084>>2]=i;if(i<f){g[b+1088>>2]=i-f;a[b+297>>0]=1;j=1;break}if(i>h){g[b+1088>>2]=i-h;a[b+297>>0]=1;j=1}else j=0}else j=0;while(0);a[b+296>>0]=0;i=+g[b+1032>>2];g[b+1080>>2]=i;h=+g[b+184>>2];f=+g[b+188>>2];do if(h<=f){if(i>f){g[b+1032>>2]=i-f;a[b+296>>0]=1;e=14;break}if(i<h){g[b+1032>>2]=i-h;a[b+296>>0]=1;e=14}else e=13}else e=13;while(0);if((e|0)==13?(g[b+1032>>2]=0.0,(a[b+1096>>0]|0)!=0):0)e=14;if((e|0)==14){c[d>>2]=(c[d>>2]|0)+1;c[d+4>>2]=(c[d+4>>2]|0)+-1}if(j<<24>>24==0?(a[b+1112>>0]|0)==0:0)return;c[d>>2]=(c[d>>2]|0)+1;c[d+4>>2]=(c[d+4>>2]|0)+-1;return}function nr(b,d){b=b|0;d=d|0;var e=0.0,f=0,h=0.0,i=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0,q=0.0,r=0,s=0,t=0,u=0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,Q=0.0,R=0,S=0,T=0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0,_=0,aa=0.0,ba=0,ca=0.0,da=0.0,ea=0.0;_=c[b+28>>2]|0;ba=c[b+32>>2]|0;h=+g[_+344>>2];e=+g[ba+344>>2];s=c[d+24>>2]|0;aa=(a[b+180>>0]|0)!=0?1.0:-1.0;U=+g[b+936>>2]-+g[b+872>>2];V=+g[b+940>>2]-+g[b+876>>2];W=+g[b+944>>2]-+g[b+880>>2];if(h<1.1920928955078125e-07)Z=1;else Z=e<1.1920928955078125e-07;if(h+e>0.0)Y=e/(h+e);else Y=.5;X=1.0-Y;j=+g[b+824>>2];h=+g[b+840>>2];k=+g[b+856>>2];q=+g[b+888>>2];e=+g[b+904>>2];v=+g[b+920>>2];f=(a[b+49>>0]|0)==0;do if(!f){o=Y*j+X*q;n=Y*h+X*e;m=Y*k+X*v;l=1.0/+P(+(o*o+n*n+m*m));if(+O(+(m*l))>.7071067690849304){B=1.0/+P(+(m*l*(m*l)+n*l*(n*l)));z=0.0;A=-(m*l*B);C=n*l*B;D=(m*l*(m*l)+n*l*(n*l))*B;E=-(o*l*(n*l*B));ca=o*l;da=n*l;ea=m*l;B=o*l*-(m*l*B);break}else{B=1.0/+P(+(o*l*(o*l)+n*l*(n*l)));z=-(n*l*B);A=o*l*B;C=0.0;D=-(m*l*(o*l*B));E=m*l*-(n*l*B);ca=o*l;da=n*l;ea=m*l;B=(o*l*(o*l)+n*l*(n*l))*B;break}}else{z=+g[b+828>>2];A=+g[b+844>>2];C=+g[b+860>>2];D=+g[b+832>>2];E=+g[b+848>>2];ca=j;da=h;ea=k;B=+g[b+864>>2]}while(0);p=c[d+12>>2]|0;g[p>>2]=z;g[p+4>>2]=A;g[p+8>>2]=C;g[p+(s<<2)>>2]=D;g[p+(s+1<<2)>>2]=E;g[p+(s+2<<2)>>2]=B;n=-z;r=c[d+20>>2]|0;g[r>>2]=n;m=-A;g[r+4>>2]=m;l=-C;g[r+8>>2]=l;w=-D;g[r+(s<<2)>>2]=w;x=-E;g[r+(s+1<<2)>>2]=x;y=-B;g[r+(s+2<<2)>>2]=y;u=c[b+300>>2]|0;o=+g[b+280>>2];if(!(u&128))o=o*+g[d+4>>2];Q=o*+g[d>>2];T=c[d+28>>2]|0;g[T>>2]=Q*((h*v-k*e)*z+(k*q-j*v)*A+(j*e-h*q)*C);g[T+(s<<2)>>2]=Q*((h*v-k*e)*D+(k*q-j*v)*E+(j*e-h*q)*B);if(u&64){T=c[d+32>>2]|0;g[T>>2]=+g[b+292>>2];g[T+(s<<2)>>2]=+g[b+292>>2]}I=+g[_+52>>2];e=+g[_+56>>2];G=+g[_+60>>2];j=+g[ba+52>>2];o=+g[ba+56>>2];h=+g[ba+60>>2];if(f){v=(o-e)*C-(h-G)*A;k=(h-G)*z-(j-I)*C;q=(j-I)*A-(o-e)*z;g[p+(s<<1<<2)>>2]=Y*v;g[p+((s<<1|1)<<2)>>2]=Y*k;g[p+((s<<1)+2<<2)>>2]=Y*q;g[r+(s<<1<<2)>>2]=X*v;g[r+((s<<1|1)<<2)>>2]=X*k;g[r+((s<<1)+2<<2)>>2]=X*q;q=(o-e)*B-(h-G)*E;k=(h-G)*D-(j-I)*B;v=(j-I)*E-(o-e)*D;g[p+(s*3<<2)>>2]=Y*q;g[p+((s*3|0)+1<<2)>>2]=Y*k;g[p+((s*3|0)+2<<2)>>2]=Y*v;g[r+(s*3<<2)>>2]=X*q;g[r+((s*3|0)+1<<2)>>2]=X*k;g[r+((s*3|0)+2<<2)>>2]=X*v;p=c[d+8>>2]|0;g[p+(s<<1<<2)>>2]=z;g[p+((s<<1|1)<<2)>>2]=A;g[p+((s<<1)+2<<2)>>2]=C;g[p+(s*3<<2)>>2]=D;g[p+((s*3|0)+1<<2)>>2]=E;g[p+((s*3|0)+2<<2)>>2]=B;i=c[d+16>>2]|0;g[i+(s<<1<<2)>>2]=n;g[i+((s<<1|1)<<2)>>2]=m;g[i+((s<<1)+2<<2)>>2]=l;g[i+(s*3<<2)>>2]=w;g[i+((s*3|0)+1<<2)>>2]=x;g[i+((s*3|0)+2<<2)>>2]=y;T=u;v=z;y=A;w=C;k=E;q=B;H=0.0;F=0.0;z=0.0;A=0.0;B=0.0;l=0.0;R=r;x=o-e;m=h-G;n=j-I}else{Q=+g[b+936>>2]-j;K=+g[b+940>>2]-o;L=+g[b+944>>2]-h;M=ca*Q+da*K+ea*L;N=ca*M;J=da*M;M=ea*M;y=+g[b+872>>2]-I;D=+g[b+876>>2]-e;F=+g[b+880>>2]-G;o=ca*y+da*D+ea*F;m=ca*o;n=da*o;o=ea*o;C=+g[b+1080>>2]-+g[b+1032>>2];G=m+ca*C-N;E=n+da*C-J;C=o+ea*C-M;z=y-m+Y*G;B=D-n+Y*E;A=F-o+Y*C;m=Y*(Q-N)+X*(y-m);n=Y*(K-J)+X*(D-n);o=Y*(L-M)+X*(F-o);if(m*m+n*n+o*o>1.1920928955078125e-07){v=1.0/+P(+(m*m+n*n+o*o));w=v*o;y=v*n;v=m*v}else{w=+g[b+860>>2];y=+g[b+844>>2];v=+g[b+828>>2]}x=da*w-ea*y;k=ea*v-ca*w;q=ca*y-da*v;g[p+(s<<1<<2)>>2]=B*w-A*y;g[p+((s<<1|1)<<2)>>2]=A*v-z*w;g[p+((s<<1)+2<<2)>>2]=z*y-B*v;u=c[d+20>>2]|0;g[u+(s<<1<<2)>>2]=-((K-J-X*E)*w-(L-M-X*C)*y);g[u+((s<<1|1)<<2)>>2]=-((L-M-X*C)*v-(Q-N-X*G)*w);g[u+((s<<1)+2<<2)>>2]=-((Q-N-X*G)*y-(K-J-X*E)*v);o=(K-J-X*E)*q-(L-M-X*C)*k;n=(L-M-X*C)*x-(Q-N-X*G)*q;m=(Q-N-X*G)*k-(K-J-X*E)*x;if(Z?(a[b+297>>0]|0)!=0:0){o=X*o;n=X*n;m=X*m;l=Y*(B*q-A*k);j=Y*(z*k-B*x);h=Y*(A*x-z*q)}else{l=B*q-A*k;j=z*k-B*x;h=A*x-z*q}R=c[d+12>>2]|0;g[R+(s*3<<2)>>2]=l;g[R+((s*3|0)+1<<2)>>2]=h;g[R+((s*3|0)+2<<2)>>2]=j;R=c[d+20>>2]|0;g[R+(s*3<<2)>>2]=-o;g[R+((s*3|0)+1<<2)>>2]=-n;g[R+((s*3|0)+2<<2)>>2]=-m;p=c[d+8>>2]|0;g[p+(s<<1<<2)>>2]=v;g[p+((s<<1|1)<<2)>>2]=y;g[p+((s<<1)+2<<2)>>2]=w;g[p+(s*3<<2)>>2]=x;g[p+((s*3|0)+1<<2)>>2]=k;g[p+((s*3|0)+2<<2)>>2]=q;i=c[d+16>>2]|0;g[i+(s<<1<<2)>>2]=-v;g[i+((s<<1|1)<<2)>>2]=-y;g[i+((s<<1)+2<<2)>>2]=-w;g[i+(s*3<<2)>>2]=-x;g[i+((s*3|0)+1<<2)>>2]=-k;g[i+((s*3|0)+2<<2)>>2]=-q;T=c[b+300>>2]|0;D=x;H=B;F=A;A=K-J-X*E;B=L-M-X*C;l=Q-N-X*G;x=0.0;m=0.0;n=0.0}o=+g[b+264>>2];if(!(T&32))o=o*+g[d+4>>2];Q=o*+g[d>>2];S=c[d+28>>2]|0;g[S+(s<<1<<2)>>2]=Q*(U*v+V*y+W*w);g[S+(s*3<<2)>>2]=Q*(U*D+V*k+W*q);if(T&16){u=c[d+32>>2]|0;g[u+(s<<1<<2)>>2]=+g[b+276>>2];g[u+(s*3<<2)>>2]=+g[b+276>>2]}if(!(a[b+296>>0]|0)){u=0;k=0.0}else{k=aa*+g[b+1032>>2];u=k>0.0?2:1}s=a[b+1096>>0]|0;f=(u|0)!=0;if(s&255|u){t=c[d+24>>2]<<2;g[p+(t<<2)>>2]=ca;g[p+((t|1)<<2)>>2]=da;g[p+((t|2)<<2)>>2]=ea;g[i+(t<<2)>>2]=-ca;g[i+((t|1)<<2)>>2]=-da;g[i+((t|2)<<2)>>2]=-ea;if(a[b+49>>0]|0){if(!Z){Z=c[d+12>>2]|0;g[Z+(t<<2)>>2]=ea*H-da*F;g[Z+((t|1)<<2)>>2]=ca*F-ea*z;g[Z+((t|2)<<2)>>2]=da*z-ca*H;g[R+(t<<2)>>2]=-(ea*A-da*B);g[R+((t|1)<<2)>>2]=-(ca*B-ea*l);g[R+((t|2)<<2)>>2]=-(da*l-ca*A)}}else{U=ea*x-da*m;V=ca*m-ea*n;W=da*n-ca*x;Z=c[d+12>>2]|0;g[Z+(t<<2)>>2]=Y*U;g[Z+((t|1)<<2)>>2]=Y*V;g[Z+((t|2)<<2)>>2]=Y*W;g[R+(t<<2)>>2]=X*U;g[R+((t|1)<<2)>>2]=X*V;g[R+((t|2)<<2)>>2]=X*W}r=+g[b+184>>2]==+g[b+188>>2];g[S+(t<<2)>>2]=0.0;p=(c[d+36>>2]|0)+(t<<2)|0;g[p>>2]=0.0;i=(c[d+40>>2]|0)+(t<<2)|0;g[i>>2]=0.0;h=+g[((T&512|0)==0?d+4|0:b+232|0)>>2];if(!(f&r|s<<24>>24==0)){if(T&1)g[(c[d+32>>2]|0)+(t<<2)>>2]=+g[b+212>>2];j=+g[b+1100>>2];o=+g[b+1080>>2];n=+g[b+184>>2];m=+g[b+188>>2];l=h*+g[d>>2];do if(!(n>m))if(!(n==m)){if(j/l<0.0)if(o>=n?n-j/l>o:0){l=(n-o)/(j/l);break}else{l=o<n?0.0:1.0;break}if(j/l>0.0)if(o<=m?m-j/l<o:0){l=(m-o)/(j/l);break}else{l=o>m?0.0:1.0;break}else l=0.0}else l=0.0;else l=1.0;while(0);g[S+(t<<2)>>2]=+g[S+(t<<2)>>2]-aa*l*j;g[p>>2]=+g[p>>2]-+g[b+1104>>2]*+g[d>>2];g[i>>2]=+g[b+1104>>2]*+g[d>>2]+ +g[i>>2]}if(f){g[S+(t<<2)>>2]=+g[S+(t<<2)>>2]+k*(h*+g[d>>2]);if(T&256)g[(c[d+32>>2]|0)+(t<<2)>>2]=+g[b+244>>2];do if(!r)if((u|0)==1){g[p>>2]=-3402823466385288598117041.0e14;g[i>>2]=0.0;break}else{g[p>>2]=0.0;g[i>>2]=3402823466385288598117041.0e14;break}else{g[p>>2]=-3402823466385288598117041.0e14;g[i>>2]=3402823466385288598117041.0e14}while(0);Y=1.0-+g[b+240>>2];e=+O(+Y);do if(!(Y!=Y|0.0!=0.0|Y==0.0)){h=aa*(ca*+g[_+312>>2]+da*+g[_+316>>2]+ea*+g[_+320>>2]-(ca*+g[ba+312>>2]+da*+g[ba+316>>2]+ea*+g[ba+320>>2]));if((u|0)==1){if(!(h<0.0))break;if(!(+g[S+(t<<2)>>2]<-(e*h)))break;g[S+(t<<2)>>2]=-(e*h);break}else{if(!(h>0.0))break;if(!(+g[S+(t<<2)>>2]>-(e*h)))break;g[S+(t<<2)>>2]=-(e*h);break}}while(0);g[S+(t<<2)>>2]=+g[b+232>>2]*+g[S+(t<<2)>>2];f=5}else f=5}else f=4;if(!(a[b+297>>0]|0)){s=0;q=0.0}else{q=+g[b+1088>>2];s=q>0.0?1:2}i=a[b+1112>>0]|0;p=(s|0)!=0;if(!(i&255|s))return;r=$(c[d+24>>2]|0,f)|0;_=c[d+12>>2]|0;g[_+(r<<2)>>2]=ca;g[_+(r+1<<2)>>2]=da;g[_+(r+2<<2)>>2]=ea;g[R+(r<<2)>>2]=-ca;g[R+(r+1<<2)>>2]=-da;g[R+(r+2<<2)>>2]=-ea;m=+g[b+192>>2];n=+g[b+196>>2];o=+g[((T&2048|0)==0?d+4|0:b+248|0)>>2];if(!(p&m==n|i<<24>>24==0)){if(!(T&4)){j=m;k=n}else{g[(c[d+32>>2]|0)+(r<<2)>>2]=+g[b+228>>2];j=+g[b+192>>2];k=+g[b+196>>2]}h=+g[b+1084>>2];l=+g[b+1116>>2];e=o*+g[d>>2];do if(!(j>k))if(!(j==k)){if(l/e<0.0)if(h>=j?j-l/e>h:0){h=(j-h)/(l/e);break}else{h=h<j?0.0:1.0;break}if(l/e>0.0)if(h<=k?k-l/e<h:0){h=(k-h)/(l/e);break}else{h=h>k?0.0:1.0;break}else h=0.0}else h=0.0;else h=1.0;while(0);g[S+(r<<2)>>2]=h*l;g[(c[d+36>>2]|0)+(r<<2)>>2]=-(+g[b+1120>>2]*+g[d>>2]);g[(c[d+40>>2]|0)+(r<<2)>>2]=+g[b+1120>>2]*+g[d>>2]}if(!p)return;g[S+(r<<2)>>2]=+g[S+(r<<2)>>2]+q*(o*+g[d>>2]);if(T&1024)g[(c[d+32>>2]|0)+(r<<2)>>2]=+g[b+260>>2];do if(!(m==n)){f=(c[d+36>>2]|0)+(r<<2)|0;if((s|0)==1){g[f>>2]=0.0;g[(c[d+40>>2]|0)+(r<<2)>>2]=3402823466385288598117041.0e14;break}else{g[f>>2]=-3402823466385288598117041.0e14;g[(c[d+40>>2]|0)+(r<<2)>>2]=0.0;break}}else{g[(c[d+36>>2]|0)+(r<<2)>>2]=-3402823466385288598117041.0e14;g[(c[d+40>>2]|0)+(r<<2)>>2]=3402823466385288598117041.0e14}while(0);aa=1.0-+g[b+256>>2];h=+O(+aa);do if(!(aa!=aa|0.0!=0.0|aa==0.0)){_=c[b+28>>2]|0;d=c[b+32>>2]|0;e=ca*+g[_+328>>2]+da*+g[_+332>>2]+ea*+g[_+336>>2]-(ca*+g[d+328>>2]+da*+g[d+332>>2]+ea*+g[d+336>>2]);if((s|0)==1){if(!(e<0.0))break;if(!(+g[S+(r<<2)>>2]<-(h*e)))break;g[S+(r<<2)>>2]=-(h*e);break}else{if(!(e>0.0))break;if(!(+g[S+(r<<2)>>2]>-(h*e)))break;g[S+(r<<2)>>2]=-(h*e);break}}while(0);g[S+(r<<2)>>2]=+g[b+248>>2]*+g[S+(r<<2)>>2];return}function or(a,b,d,e){a=a|0;b=b|0;d=+d;e=e|0;if((b|0)==3){if((e|0)<1){g[a+212>>2]=d;c[a+300>>2]=c[a+300>>2]|1;return}if((e|0)!=3)return;g[a+228>>2]=d;c[a+300>>2]=c[a+300>>2]|4;return}else if((b|0)==2){if((e|0)<1){g[a+232>>2]=d;c[a+300>>2]=c[a+300>>2]|512;return}if((e|0)<3){g[a+264>>2]=d;c[a+300>>2]=c[a+300>>2]|32;return}if((e|0)==3){g[a+248>>2]=d;c[a+300>>2]=c[a+300>>2]|2048;return}if((e|0)>=6)return;g[a+280>>2]=d;c[a+300>>2]=c[a+300>>2]|128;return}else if((b|0)==4){if((e|0)<1){g[a+244>>2]=d;c[a+300>>2]=c[a+300>>2]|256;return}if((e|0)<3){g[a+276>>2]=d;c[a+300>>2]=c[a+300>>2]|16;return}if((e|0)==3){g[a+260>>2]=d;c[a+300>>2]=c[a+300>>2]|1024;return}if((e|0)>=6)return;g[a+292>>2]=d;c[a+300>>2]=c[a+300>>2]|64;return}else return}function pr(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0;do if((b|0)==4){if((c|0)<1){d=+g[a+244>>2];break}if((c|0)<3){d=+g[a+276>>2];break}if((c|0)==3){d=+g[a+260>>2];break}if((c|0)<6)d=+g[a+292>>2];else d=3402823466385288598117041.0e14}else if((b|0)==3){if((c|0)<1){d=+g[a+212>>2];break}if((c|0)==3)d=+g[a+228>>2];else d=3402823466385288598117041.0e14}else if((b|0)==2){if((c|0)<1){d=+g[a+232>>2];break}if((c|0)<3){d=+g[a+264>>2];break}if((c|0)==3){d=+g[a+248>>2];break}if((c|0)<6)d=+g[a+280>>2];else d=3402823466385288598117041.0e14}else d=3402823466385288598117041.0e14;while(0);return +d}function qr(a,b,e){a=a|0;b=b|0;e=e|0;kr(a,b,e)|0;g[b+52>>2]=+g[a+52>>2];g[b+56>>2]=+g[a+56>>2];g[b+60>>2]=+g[a+60>>2];g[b+64>>2]=+g[a+64>>2];g[b+68>>2]=+g[a+68>>2];g[b+72>>2]=+g[a+72>>2];g[b+76>>2]=+g[a+76>>2];g[b+80>>2]=+g[a+80>>2];g[b+84>>2]=+g[a+84>>2];g[b+88>>2]=+g[a+88>>2];g[b+92>>2]=+g[a+92>>2];g[b+96>>2]=+g[a+96>>2];g[b+100>>2]=+g[a+100>>2];g[b+104>>2]=+g[a+104>>2];g[b+108>>2]=+g[a+108>>2];g[b+112>>2]=+g[a+112>>2];g[b+116>>2]=+g[a+116>>2];g[b+120>>2]=+g[a+120>>2];g[b+124>>2]=+g[a+124>>2];g[b+128>>2]=+g[a+128>>2];g[b+132>>2]=+g[a+132>>2];g[b+136>>2]=+g[a+136>>2];g[b+140>>2]=+g[a+140>>2];g[b+144>>2]=+g[a+144>>2];g[b+148>>2]=+g[a+148>>2];g[b+152>>2]=+g[a+152>>2];g[b+156>>2]=+g[a+156>>2];g[b+160>>2]=+g[a+160>>2];g[b+164>>2]=+g[a+164>>2];g[b+168>>2]=+g[a+168>>2];g[b+172>>2]=+g[a+172>>2];g[b+176>>2]=+g[a+176>>2];g[b+180>>2]=+g[a+188>>2];g[b+184>>2]=+g[a+184>>2];g[b+188>>2]=+g[a+196>>2];g[b+192>>2]=+g[a+192>>2];c[b+196>>2]=d[a+180>>0];c[b+200>>2]=d[a+49>>0];return 3776}function rr(a){a=a|0;return 204}function sr(a){a=a|0;if(!a)return;c[5134]=(c[5134]|0)+1;_E(c[a+-4>>2]|0);return}function tr(b,d){b=b|0;d=d|0;var e=0,f=0,h=0.0,i=0,j=0;if(a[b+527>>0]|0){c[d>>2]=0;c[d+4>>2]=0;return}c[d>>2]=3;c[d+4>>2]=3;j=c[b+28>>2]|0;i=c[b+32>>2]|0;ur(b,j+4|0,i+4|0,j+264|0,i+264|0);if(((a[b+526>>0]|0)!=0?(e=c[d>>2]|0,c[d>>2]=e+1,f=c[d+4>>2]|0,c[d+4>>2]=f+-1,h=+g[b+456>>2],+g[b+444>>2]<h):0)?+g[b+448>>2]<h:0){c[d>>2]=e+2;c[d+4>>2]=f+-2}if(!(a[b+525>>0]|0))return;c[d>>2]=(c[d>>2]|0)+1;c[d+4>>2]=(c[d+4>>2]|0)+-1;return}function ur(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0,Q=0.0,T=0.0,V=0.0,W=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ba=0.0,ca=0.0,da=0.0,ea=0.0,fa=0.0,ga=0.0,ha=0.0,ia=0.0,ja=0.0,ka=0.0,la=0.0,ma=0;ma=i;i=i+272|0;g[b+504>>2]=0.0;g[b+500>>2]=0.0;a[b+525>>0]=0;a[b+526>>0]=0;if((a[b+552>>0]|0)!=0?(a[b+527>>0]|0)==0:0){ea=+g[b+556>>2];Z=+g[b+560>>2];fa=+g[b+564>>2];_=+g[b+568>>2];aa=ea*(2.0/(ea*ea+Z*Z+fa*fa+_*_));ka=Z*(2.0/(ea*ea+Z*Z+fa*fa+_*_));ba=fa*(2.0/(ea*ea+Z*Z+fa*fa+_*_));rp(ma+16|0,d,b+300|0);rp(ma+160|0,e,b+364|0);C=+g[ma+160>>2];D=+g[ma+164>>2];l=+g[ma+168>>2];M=(1.0-(Z*ka+fa*ba))*C+(ea*ka+_*ba)*D+(ea*ba-_*ka)*l;Q=(ea*ka-_*ba)*C+(1.0-(ea*aa+fa*ba))*D+(Z*ba+_*aa)*l;T=(ea*ba+_*ka)*C+(Z*ba-_*aa)*D+(1.0-(ea*aa+Z*ka))*l;E=+g[ma+176>>2];F=+g[ma+180>>2];k=+g[ma+184>>2];V=(1.0-(Z*ka+fa*ba))*E+(ea*ka+_*ba)*F+(ea*ba-_*ka)*k;W=(ea*ka-_*ba)*E+(1.0-(ea*aa+fa*ba))*F+(Z*ba+_*aa)*k;Y=(ea*ba+_*ka)*E+(Z*ba-_*aa)*F+(1.0-(ea*aa+Z*ka))*k;H=+g[ma+192>>2];I=+g[ma+196>>2];J=+g[ma+200>>2];da=(1.0-(Z*ka+fa*ba))*H+(ea*ka+_*ba)*I+(ea*ba-_*ka)*J;fa=(ea*ka-_*ba)*H+(1.0-(ea*aa+fa*ba))*I+(Z*ba+_*aa)*J;ka=(ea*ba+_*ka)*H+(Z*ba-_*aa)*I+(1.0-(ea*aa+Z*ka))*J;Z=+g[ma+16>>2];aa=+g[ma+32>>2];ea=+g[ma+48>>2];_=+g[ma+20>>2];ba=+g[ma+36>>2];ga=+g[ma+52>>2];$=+g[ma+24>>2];ca=+g[ma+40>>2];la=+g[ma+56>>2];K=-+g[ma+64>>2];L=-+g[ma+68>>2];j=-+g[ma+72>>2];l=C*0.0+D*0.0+l*0.0+ +g[ma+208>>2]+(T*($*K+ca*L+la*j)+(M*(Z*K+aa*L+ea*j)+Q*(_*K+ba*L+ga*j)));k=E*0.0+F*0.0+k*0.0+ +g[ma+212>>2]+(Y*($*K+ca*L+la*j)+(V*(Z*K+aa*L+ea*j)+W*(_*K+ba*L+ga*j)));j=H*0.0+I*0.0+J*0.0+ +g[ma+216>>2]+(ka*($*K+ca*L+la*j)+(da*(Z*K+aa*L+ea*j)+fa*(_*K+ba*L+ga*j)));g[ma+80>>2]=M*Z+Q*_+T*$;g[ma+84>>2]=M*aa+Q*ba+T*ca;g[ma+88>>2]=M*ea+Q*ga+T*la;g[ma+92>>2]=0.0;g[ma+96>>2]=V*Z+W*_+Y*$;g[ma+100>>2]=V*aa+W*ba+Y*ca;g[ma+104>>2]=V*ea+W*ga+Y*la;g[ma+108>>2]=0.0;g[ma+112>>2]=da*Z+fa*_+ka*$;g[ma+116>>2]=da*aa+fa*ba+ka*ca;g[ma+120>>2]=da*ea+fa*ga+ka*la;g[ma+124>>2]=0.0;g[ma+128>>2]=l;g[ma+132>>2]=k;g[ma+136>>2]=j;g[ma+140>>2]=0.0;Fc(ma+80|0,ma+224|0);j=+g[ma+224>>2];k=+g[ma+228>>2];l=+g[ma+232>>2];if(+O(+(j*j+k*k+l*l))<1.1920928955078125e-07){i=ma;return}g[b+472>>2]=0.0;la=1.0/+P(+(j*j+k*k+l*l));g[b+460>>2]=j*la;g[b+464>>2]=k*la;g[b+468>>2]=l*la;la=+g[ma+236>>2];la=la<-1.0?-1.0:la;la=+U(+(la>1.0?1.0:la))*2.0;g[b+504>>2]=la;if(+O(+la)<1.1920928955078125e-07){i=ma;return}a[b+526>>0]=1;i=ma;return}Fc(d,ma+256|0);Fc(b+300|0,ma);T=+g[ma+268>>2];V=+g[ma>>2];W=+g[ma+256>>2];Y=+g[ma+12>>2];Z=+g[ma+260>>2];_=+g[ma+8>>2];$=+g[ma+264>>2];aa=+g[ma+4>>2];Fc(e,ma+144|0);Fc(b+364|0,ma+240|0);ba=+g[ma+156>>2];ca=+g[ma+240>>2];da=+g[ma+144>>2];ea=+g[ma+252>>2];fa=+g[ma+148>>2];ga=+g[ma+248>>2];ha=+g[ma+152>>2];ia=+g[ma+244>>2];ja=-(ba*ca+da*ea+fa*ga-ha*ia);ka=-(ca*ha+(ea*fa+ba*ia)-da*ga);la=-(ba*ga+ea*ha+da*ia-ca*fa);t=(T*V+W*Y+Z*_-$*aa)*(ba*ea-ca*da-fa*ia-ga*ha)+(T*Y-V*W-Z*aa-_*$)*ja+(T*_+Y*$+W*aa-V*Z)*ka-(V*$+(Y*Z+T*aa)-W*_)*la;r=(T*V+W*Y+Z*_-$*aa)*la+((V*$+(Y*Z+T*aa)-W*_)*(ba*ea-ca*da-fa*ia-ga*ha)+(T*Y-V*W-Z*aa-_*$)*ka)-(T*_+Y*$+W*aa-V*Z)*ja;u=(V*$+(Y*Z+T*aa)-W*_)*ja+((T*_+Y*$+W*aa-V*Z)*(ba*ea-ca*da-fa*ia-ga*ha)+(T*Y-V*W-Z*aa-_*$)*la)-(T*V+W*Y+Z*_-$*aa)*ka;v=(T*Y-V*W-Z*aa-_*$)*(ba*ea-ca*da-fa*ia-ga*ha)-(T*V+W*Y+Z*_-$*aa)*ja-(V*$+(Y*Z+T*aa)-W*_)*ka-(T*_+Y*$+W*aa-V*Z)*la;p=-t-r*0.0-u*0.0;o=(u+v*0.0-t*0.0)*-u+(v*(v+r*0.0-u*0.0)+p*-t)-(v*0.0+t*0.0-r)*-r;n=(v*0.0+t*0.0-r)*-t+(v*(u+v*0.0-t*0.0)+p*-r)-(v+r*0.0-u*0.0)*-u;p=(v+r*0.0-u*0.0)*-r+(v*(v*0.0+t*0.0-r)+p*-u)-(u+v*0.0-t*0.0)*-t;m=1.0/+P(+(p*p+(o*o+n*n)));if(m*p*0.0+(m*n*0.0+m*o)<-.9999998807907104)if(+O(0.0)>.7071067690849304){q=0.0;l=s;p=s;o=0.0}else{q=-0.0;l=1.0;p=0.0;o=0.0}else{Q=+P(+((m*p*0.0+(m*n*0.0+m*o)+1.0)*2.0));q=(m*p*0.0-m*n*0.0)*(1.0/Q);l=(m*o*0.0-m*p)*(1.0/Q);p=(m*n-m*o*0.0)*(1.0/Q);o=Q*.5}Q=1.0/+P(+(o*o+(p*p+(l*l+q*q))));w=q*Q;n=l*Q;l=p*Q;q=o*Q;Q=1.0/+P(+((v*q-t*-w-r*-n-u*-l)*(v*q-t*-w-r*-n-u*-l)+((r*-w+(u*q+v*-l)-t*-n)*(r*-w+(u*q+v*-l)-t*-n)+((u*-n+(t*q+v*-w)-r*-l)*(u*-n+(t*q+v*-w)-r*-l)+(t*-l+(r*q+v*-n)-u*-w)*(t*-l+(r*q+v*-n)-u*-w)))));k=Q*(u*-n+(t*q+v*-w)-r*-l);j=Q*(t*-l+(r*q+v*-n)-u*-w);m=Q*(r*-w+(u*q+v*-l)-t*-n);Q=Q*(v*q-t*-w-r*-n-u*-l);v=+g[b+444>>2];p=+g[b+456>>2];if(v>=p?(x=+g[b+448>>2],x>=p):0){t=q<-1.0?-1.0:q;t=+U(+(t>1.0?1.0:t))*2.0;if(t>1.1920928955078125e-07){p=1.0/+P(+(l*l+(w*w+n*n)));if(+O(+(n*p))>1.1920928955078125e-07){r=+P(+((l*p*(l*p)/(n*p*(n*p))+1.0)/(1.0/(x*x)+l*p*(l*p)/(n*p*(n*p))/(v*v))));o=n*p;n=l*p;p=w*p}else{r=v;o=n*p;n=l*p;p=w*p}}else{r=0.0;o=0.0;n=0.0;p=0.0}l=+g[b+428>>2];q=r*l;if(t>q){a[b+526>>0]=1;if(t<r&l<.9999998807907104)l=(t-q)/(r-q);else l=1.0;g[b+528>>2]=l;g[b+504>>2]=t-q;if(+O(+o)>1.1920928955078125e-07){l=+O(+(o*(-n/o*(x/v))));if(!(n<-0.0))l=-l;n=1.0/+P(+(o*o+p*p+l*l));p=p*n;o=o*n;n=-(l*n)}L=-p;K=-o;J=-n;H=(ca*ha+(ea*fa+ba*ia)-da*ga)*J+(ba*ea-ca*da-fa*ia-ga*ha)*L-(ba*ga+ea*ha+da*ia-ca*fa)*K;M=(ba*ea-ca*da-fa*ia-ga*ha)*K+(ba*ga+ea*ha+da*ia-ca*fa)*L-(ba*ca+da*ea+fa*ga-ha*ia)*J;I=(ba*ea-ca*da-fa*ia-ga*ha)*J+(ba*ca+da*ea+fa*ga-ha*ia)*K-(ca*ha+(ea*fa+ba*ia)-da*ga)*L;J=-((ba*ca+da*ea+fa*ga-ha*ia)*L)-(ca*ha+(ea*fa+ba*ia)-da*ga)*K-(ba*ga+ea*ha+da*ia-ca*fa)*J;K=M*la+((ba*ea-ca*da-fa*ia-ga*ha)*H+J*ja)-I*ka;L=I*ja+((ba*ea-ca*da-fa*ia-ga*ha)*M+J*ka)-H*la;M=H*ka+((ba*ea-ca*da-fa*ia-ga*ha)*I+J*la)-M*ja;g[b+460>>2]=K;g[b+464>>2]=L;g[b+468>>2]=M;g[b+472>>2]=0.0;c[b+536>>2]=0;c[b+540>>2]=0;c[b+544>>2]=0;c[b+548>>2]=0;g[b+492>>2]=1.0/(K*(+g[f>>2]*K+ +g[f+16>>2]*L+ +g[f+32>>2]*M)+L*(K*+g[f+4>>2]+L*+g[f+20>>2]+M*+g[f+36>>2])+M*(K*+g[f+8>>2]+L*+g[f+24>>2]+M*+g[f+40>>2])+(K*(K*+g[h>>2]+L*+g[h+16>>2]+M*+g[h+32>>2])+L*(K*+g[h+4>>2]+L*+g[h+20>>2]+M*+g[h+36>>2])+M*(K*+g[h+8>>2]+L*+g[h+24>>2]+M*+g[h+40>>2])))}}else N=23;a:do if((N|0)==23){C=+g[b+300>>2];D=+g[b+316>>2];E=+g[b+332>>2];F=+g[d>>2];G=+g[d+4>>2];H=+g[d+8>>2];I=+g[d+16>>2];J=+g[d+20>>2];K=+g[d+24>>2];L=+g[d+32>>2];M=+g[d+36>>2];q=+g[d+40>>2];p=+g[b+304>>2];o=+g[b+320>>2];n=+g[b+336>>2];l=+g[b+308>>2];y=+g[b+324>>2];z=+g[b+340>>2];v=+g[b+364>>2];r=+g[b+380>>2];x=+g[b+396>>2];A=v*+g[e>>2]+r*+g[e+4>>2]+x*+g[e+8>>2];B=v*+g[e+16>>2]+r*+g[e+20>>2]+x*+g[e+24>>2];x=v*+g[e+32>>2]+r*+g[e+36>>2]+x*+g[e+40>>2];r=(C*F+D*G+E*H)*A+(C*I+D*J+E*K)*B+(C*L+D*M+E*q)*x;v=(F*p+G*o+H*n)*A+(I*p+J*o+K*n)*B+(L*p+M*o+q*n)*x;w=(F*l+G*y+H*z)*A+(I*l+J*y+K*z)*B+(L*l+M*y+q*z)*x;t=+g[b+444>>2];u=+g[b+456>>2];do if(t<u){t=+g[b+448>>2];if(t<u){if(+O(+v)<1.1920928955078125e-07?+O(+w)<1.1920928955078125e-07:0)break a;a[b+526>>0]=1;g[b+460>>2]=-((C*L+D*M+E*q)*B-(C*I+D*J+E*K)*x);g[b+464>>2]=-((C*F+D*G+E*H)*x-(C*L+D*M+E*q)*A);g[b+468>>2]=-((C*I+D*J+E*K)*A-(C*F+D*G+E*H)*B);g[b+472>>2]=0.0;break a}if(+O(+r)<1.1920928955078125e-07?+O(+w)<1.1920928955078125e-07:0){u=r;break}a[b+526>>0]=1;if(t>=u){v=+X(+w,+r);if(v>t){u=+R(+t);v=0.0;w=+S(+t);break}if(v<-t){u=+R(+t);v=0.0;w=-+S(+t)}else{u=r;v=0.0}}else u=r}else{if(+O(+r)<1.1920928955078125e-07?+O(+v)<1.1920928955078125e-07:0){u=r;break}a[b+526>>0]=1;if(t>=u){w=+X(+v,+r);if(w>t){u=+R(+t);v=+S(+t);w=0.0;break}if(w<-t){u=+R(+t);v=-+S(+t);w=0.0}else{u=r;w=0.0}}else u=r}while(0);H=(F*l+G*y+H*z)*w+((F*p+G*o+H*n)*v+(C*F+D*G+E*H)*u);K=(I*l+J*y+K*z)*w+((I*p+J*o+K*n)*v+(C*I+D*J+E*K)*u);J=(L*l+M*y+q*z)*w+((L*p+M*o+q*n)*v+(C*L+D*M+E*q)*u);L=1.0/+P(+(J*J+(H*H+K*K)));g[b+472>>2]=0.0;M=+P(+((B*(L*J)-x*(L*K))*(B*(L*J)-x*(L*K))+(x*(L*H)-A*(L*J))*(x*(L*H)-A*(L*J))+(A*(L*K)-B*(L*H))*(A*(L*K)-B*(L*H))));g[b+504>>2]=M;g[b+460>>2]=-((B*(L*J)-x*(L*K))*(1.0/M));g[b+464>>2]=-((x*(L*H)-A*(L*J))*(1.0/M));g[b+468>>2]=-((A*(L*K)-B*(L*H))*(1.0/M))}while(0);q=+g[b+452>>2];if(!(q>=0.0)){g[b+512>>2]=0.0;i=ma;return}l=Q<-1.0?-1.0:Q;l=+U(+(l>1.0?1.0:l))*2.0;if(l>3.1415927410125732){l=Q>1.0?-1.0:-Q;l=+U(+(l>1.0?1.0:l))*2.0;k=-k;j=-j;m=-m}g[b+512>>2]=l;if(l>1.1920928955078125e-07){Q=1.0/+P(+(m*m+(j*j+k*k)));o=k*Q;j=j*Q;m=m*Q}else o=k;k=+g[b+428>>2];if(l>q*k){a[b+525>>0]=1;n=l-q*k;if(l<q&k<.9999998807907104)l=n/(q-q*k);else l=1.0;g[b+532>>2]=l;g[b+508>>2]=n;Q=-o;M=-j;K=-m;I=(ca*ha+(ea*fa+ba*ia)-da*ga)*K+(ba*ea-ca*da-fa*ia-ga*ha)*Q-(ba*ga+ea*ha+da*ia-ca*fa)*M;L=(ba*ea-ca*da-fa*ia-ga*ha)*M+(ba*ga+ea*ha+da*ia-ca*fa)*Q-(ba*ca+da*ea+fa*ga-ha*ia)*K;J=(ba*ea-ca*da-fa*ia-ga*ha)*K+(ba*ca+da*ea+fa*ga-ha*ia)*M-(ca*ha+(ea*fa+ba*ia)-da*ga)*Q;K=-((ba*ca+da*ea+fa*ga-ha*ia)*Q)-(ca*ha+(ea*fa+ba*ia)-da*ga)*M-(ba*ga+ea*ha+da*ia-ca*fa)*K;M=L*la+((ba*ea-ca*da-fa*ia-ga*ha)*I+K*ja)-J*ka;Q=J*ja+((ba*ea-ca*da-fa*ia-ga*ha)*L+K*ka)-I*la;la=I*ka+((ba*ea-ca*da-fa*ia-ga*ha)*J+K*la)-L*ja;g[b+476>>2]=M;g[b+480>>2]=Q;g[b+484>>2]=la;g[b+488>>2]=0.0;g[b+496>>2]=1.0/(M*(+g[f>>2]*M+ +g[f+16>>2]*Q+ +g[f+32>>2]*la)+Q*(M*+g[f+4>>2]+Q*+g[f+20>>2]+la*+g[f+36>>2])+la*(M*+g[f+8>>2]+Q*+g[f+24>>2]+la*+g[f+40>>2])+(M*(M*+g[h>>2]+Q*+g[h+16>>2]+la*+g[h+32>>2])+Q*(M*+g[h+4>>2]+Q*+g[h+20>>2]+la*+g[h+36>>2])+la*(M*+g[h+8>>2]+Q*+g[h+24>>2]+la*+g[h+40>>2])))}if(!(a[b+526>>0]|0)){i=ma;return}da=-o;la=-j;fa=-m;ca=(V*$+(Y*Z+T*aa)-W*_)*fa+(T*Y-V*W-Z*aa-_*$)*da-(T*_+Y*$+W*aa-V*Z)*la;ka=(T*Y-V*W-Z*aa-_*$)*la+(T*_+Y*$+W*aa-V*Z)*da-(T*V+W*Y+Z*_-$*aa)*fa;ea=(T*Y-V*W-Z*aa-_*$)*fa+(T*V+W*Y+Z*_-$*aa)*la-(V*$+(Y*Z+T*aa)-W*_)*da;fa=-((T*V+W*Y+Z*_-$*aa)*da)-(V*$+(Y*Z+T*aa)-W*_)*la-(T*_+Y*$+W*aa-V*Z)*fa;la=-(T*V+W*Y+Z*_-$*aa);da=-(V*$+(Y*Z+T*aa)-W*_);ga=-(T*_+Y*$+W*aa-V*Z);g[b+536>>2]=ka*ga+((T*Y-V*W-Z*aa-_*$)*ca+fa*la)-ea*da;g[b+540>>2]=ea*la+((T*Y-V*W-Z*aa-_*$)*ka+fa*da)-ca*ga;g[b+544>>2]=ca*da+((T*Y-V*W-Z*aa-_*$)*ea+fa*ga)-ka*la;g[b+548>>2]=0.0;i=ma;return}function vr(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0,q=0,r=0,s=0,t=0,u=0.0,v=0.0,w=0.0,x=0;t=i;i=i+64|0;p=c[b+28>>2]|0;f=c[b+32>>2]|0;ur(b,p+4|0,f+4|0,p+264|0,f+264|0);s=c[d+8>>2]|0;g[s>>2]=1.0;q=c[d+24>>2]|0;g[s+(q+1<<2)>>2]=1.0;g[s+((q<<1)+2<<2)>>2]=1.0;m=+g[b+348>>2];w=+g[b+352>>2];o=+g[b+356>>2];u=+g[p+4>>2]*m+ +g[p+8>>2]*w+ +g[p+12>>2]*o;n=m*+g[p+20>>2]+w*+g[p+24>>2]+o*+g[p+28>>2];o=m*+g[p+36>>2]+w*+g[p+40>>2]+o*+g[p+44>>2];s=c[d+12>>2]|0;g[s>>2]=0.0;g[s+4>>2]=o;g[s+8>>2]=-n;g[s+12>>2]=0.0;g[s+(q<<2)>>2]=-o;g[s+(q+1<<2)>>2]=0.0;g[s+(q+2<<2)>>2]=u;g[s+(q+3<<2)>>2]=0.0;g[s+(q<<1<<2)>>2]=n;g[s+((q<<1|1)<<2)>>2]=-u;g[s+((q<<1)+2<<2)>>2]=0.0;g[s+((q<<1)+3<<2)>>2]=0.0;s=c[d+16>>2]|0;g[s>>2]=-1.0;g[s+(q+1<<2)>>2]=-1.0;g[s+((q<<1)+2<<2)>>2]=-1.0;w=+g[b+412>>2];m=+g[b+416>>2];l=+g[b+420>>2];v=+g[f+4>>2]*w+ +g[f+8>>2]*m+ +g[f+12>>2]*l;k=w*+g[f+20>>2]+m*+g[f+24>>2]+l*+g[f+28>>2];l=w*+g[f+36>>2]+m*+g[f+40>>2]+l*+g[f+44>>2];q=c[d+20>>2]|0;s=c[d+24>>2]|0;g[q>>2]=0.0;g[q+4>>2]=-l;g[q+8>>2]=k;g[q+12>>2]=0.0;g[q+(s<<2)>>2]=l;g[q+(s+1<<2)>>2]=0.0;g[q+(s+2<<2)>>2]=-v;g[q+(s+3<<2)>>2]=0.0;g[q+(s<<1<<2)>>2]=-k;g[q+((s<<1|1)<<2)>>2]=v;g[q+((s<<1)+2<<2)>>2]=0.0;g[q+((s<<1)+3<<2)>>2]=0.0;r=c[b+592>>2]|0;m=+g[((r&2|0)==0?d+4|0:b+600|0)>>2]*+g[d>>2];j=c[d+28>>2]|0;e=c[d+36>>2]|0;h=c[d+40>>2]|0;g[j>>2]=m*(v+ +g[f+52>>2]-u-+g[p+52>>2]);g[e>>2]=-3402823466385288598117041.0e14;g[h>>2]=3402823466385288598117041.0e14;if(!(r&1)){g[j+(s<<2)>>2]=m*(k+ +g[f+56>>2]-n-+g[p+56>>2]);g[e+(s<<2)>>2]=-3402823466385288598117041.0e14;g[h+(s<<2)>>2]=3402823466385288598117041.0e14;g[j+(s<<1<<2)>>2]=m*(l+ +g[f+60>>2]-o-+g[p+60>>2]);g[e+(s<<1<<2)>>2]=-3402823466385288598117041.0e14;g[h+(s<<1<<2)>>2]=3402823466385288598117041.0e14}else{x=c[d+32>>2]|0;g[x>>2]=+g[b+596>>2];g[j+(s<<2)>>2]=m*(k+ +g[f+56>>2]-n-+g[p+56>>2]);g[e+(s<<2)>>2]=-3402823466385288598117041.0e14;g[h+(s<<2)>>2]=3402823466385288598117041.0e14;g[x+(s<<2)>>2]=+g[b+596>>2];g[j+(s<<1<<2)>>2]=m*(l+ +g[f+60>>2]-o-+g[p+60>>2]);g[e+(s<<1<<2)>>2]=-3402823466385288598117041.0e14;g[h+(s<<1<<2)>>2]=3402823466385288598117041.0e14;g[x+(s<<1<<2)>>2]=+g[b+596>>2]}do if(!(a[b+526>>0]|0))f=s*3|0;else{f=c[d+12>>2]|0;o=+g[b+456>>2];if(+g[b+444>>2]<o?+g[b+448>>2]<o:0){rp(t,p+4|0,b+300|0);l=+g[t+4>>2];u=+g[t+20>>2];m=+g[t+36>>2];n=+g[t+8>>2];w=+g[t+24>>2];o=+g[t+40>>2];p=c[d+24>>2]|0;x=p+(s*3|0)|0;g[f+(s*3<<2)>>2]=l;g[f+((s*3|0)+1<<2)>>2]=u;g[f+((s*3|0)+2<<2)>>2]=m;g[f+(x<<2)>>2]=n;g[f+(x+1<<2)>>2]=w;g[f+(x+2<<2)>>2]=o;g[q+(s*3<<2)>>2]=-l;g[q+((s*3|0)+1<<2)>>2]=-u;g[q+((s*3|0)+2<<2)>>2]=-m;g[q+(x<<2)>>2]=-n;g[q+(x+1<<2)>>2]=-w;g[q+(x+2<<2)>>2]=-o;v=+g[d>>2]*+g[b+436>>2];j=c[d+28>>2]|0;g[j+(s*3<<2)>>2]=v*(l*+g[b+460>>2]+u*+g[b+464>>2]+m*+g[b+468>>2]);g[j+(x<<2)>>2]=v*(n*+g[b+460>>2]+w*+g[b+464>>2]+o*+g[b+468>>2]);e=c[d+36>>2]|0;g[e+(s*3<<2)>>2]=-3402823466385288598117041.0e14;h=c[d+40>>2]|0;g[h+(s*3<<2)>>2]=3402823466385288598117041.0e14;g[e+(x<<2)>>2]=-3402823466385288598117041.0e14;g[h+(x<<2)>>2]=3402823466385288598117041.0e14;f=p+x|0;break}o=+g[b+436>>2];n=o*(+g[b+460>>2]*o);w=o*(o*+g[b+464>>2]);o=o*(o*+g[b+468>>2]);g[f+(s*3<<2)>>2]=n;g[f+((s*3|0)+1<<2)>>2]=w;g[f+((s*3|0)+2<<2)>>2]=o;g[q+(s*3<<2)>>2]=-n;g[q+((s*3|0)+1<<2)>>2]=-w;g[q+((s*3|0)+2<<2)>>2]=-o;g[j+(s*3<<2)>>2]=+g[d>>2]*+g[b+432>>2]*+g[b+504>>2];if(r&4)g[(c[d+32>>2]|0)+(s*3<<2)>>2]=+g[b+604>>2];g[e+(s*3<<2)>>2]=0.0;g[h+(s*3<<2)>>2]=3402823466385288598117041.0e14;f=s<<2}while(0);if(!(a[b+525>>0]|0)){i=t;return}o=+g[b+436>>2];n=o*(+g[b+476>>2]*o);w=o*(o*+g[b+480>>2]);o=o*(o*+g[b+484>>2]);s=c[d+12>>2]|0;q=c[d+20>>2]|0;g[s+(f<<2)>>2]=n;p=f+1|0;g[s+(p<<2)>>2]=w;x=f+2|0;g[s+(x<<2)>>2]=o;g[q+(f<<2)>>2]=-n;g[q+(p<<2)>>2]=-w;g[q+(x<<2)>>2]=-o;g[j+(f<<2)>>2]=+g[d>>2]*+g[b+432>>2]*+g[b+508>>2];if(c[b+592>>2]&4)g[(c[d+32>>2]|0)+(f<<2)>>2]=+g[b+604>>2];if(!(+g[b+452>>2]>0.0)){g[e+(f<<2)>>2]=-3402823466385288598117041.0e14;g[h+(f<<2)>>2]=3402823466385288598117041.0e14;i=t;return}e=e+(f<<2)|0;if(+g[b+508>>2]>0.0){g[e>>2]=0.0;g[h+(f<<2)>>2]=3402823466385288598117041.0e14;i=t;return}else{g[e>>2]=-3402823466385288598117041.0e14;g[h+(f<<2)>>2]=0.0;i=t;return}}function wr(b){b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0,M=0;L=i;i=i+176|0;if(!(a[b+527>>0]|0)){i=L;return}g[b+36>>2]=0.0;g[b+520>>2]=0.0;g[b+516>>2]=0.0;c[b+576>>2]=0;c[b+580>>2]=0;c[b+584>>2]=0;c[b+588>>2]=0;a:do if(!(a[b+524>>0]|0)){d=c[b+28>>2]|0;h=+g[b+348>>2];e=+g[b+352>>2];v=+g[b+356>>2];w=h*+g[d+20>>2]+e*+g[d+24>>2]+v*+g[d+28>>2]+ +g[d+56>>2];m=c[b+32>>2]|0;x=+g[b+412>>2];y=+g[m+4>>2];z=+g[b+416>>2];A=+g[m+8>>2];B=+g[b+420>>2];C=+g[m+12>>2];D=+g[m+20>>2];E=+g[m+24>>2];F=+g[m+28>>2];G=+g[m+36>>2];H=+g[m+40>>2];I=+g[m+44>>2];J=+g[m+52>>2];K=+g[m+56>>2];t=+g[m+60>>2];f=x*D+z*E+B*F+K-w;u=h*+g[d+4>>2]+e*+g[d+8>>2]+v*+g[d+12>>2]+ +g[d+52>>2];v=h*+g[d+36>>2]+e*+g[d+40>>2]+v*+g[d+44>>2]+ +g[d+60>>2];e=x*y+z*A+B*C+J-u;h=x*G+z*H+B*I+t-v;if(e*e+f*f+h*h>1.1920928955078125e-07){s=1.0/+P(+(e*e+f*f+h*h));j=e*s;f=f*s;h=h*s}else{j=1.0;f=0.0;h=0.0}g[L+128>>2]=j;g[L+132>>2]=f;g[L+136>>2]=h;g[L+140>>2]=0.0;if(+O(+h)>.7071067690849304){q=h*h+f*f;s=1.0/+P(+q);e=-(s*h);f=s*f;l=-(j*f);k=j*e;h=q*s;j=0.0}else{q=j*j+f*f;k=1.0/+P(+q);s=-(f*k);e=k*j;l=h*s;k=q*k;h=-(h*e);f=0.0;j=s}g[L+144>>2]=j;g[L+148>>2]=e;g[L+152>>2]=f;g[L+160>>2]=h;g[L+164>>2]=l;g[L+168>>2]=k;l=y;k=D;j=G;h=A;f=E;e=H;n=C;o=F;p=I;q=J;r=K;s=t;d=0;while(1){M=c[b+28>>2]|0;g[L+80>>2]=+g[M+4>>2];g[L+84>>2]=+g[M+20>>2];g[L+88>>2]=+g[M+36>>2];g[L+92>>2]=0.0;g[L+96>>2]=+g[M+8>>2];g[L+100>>2]=+g[M+24>>2];g[L+104>>2]=+g[M+40>>2];g[L+108>>2]=0.0;g[L+112>>2]=+g[M+12>>2];g[L+116>>2]=+g[M+28>>2];g[L+120>>2]=+g[M+44>>2];g[L+124>>2]=0.0;g[L+32>>2]=l;g[L+36>>2]=k;g[L+40>>2]=j;g[L+44>>2]=0.0;g[L+48>>2]=h;g[L+52>>2]=f;g[L+56>>2]=e;g[L+60>>2]=0.0;g[L+64>>2]=n;g[L+68>>2]=o;g[L+72>>2]=p;g[L+76>>2]=0.0;o=w-+g[M+56>>2];p=v-+g[M+60>>2];g[L+16>>2]=u-+g[M+52>>2];g[L+20>>2]=o;g[L+24>>2]=p;g[L+28>>2]=0.0;g[L>>2]=x*y+z*A+B*C+J-q;g[L+4>>2]=x*D+z*E+B*F+K-r;g[L+8>>2]=x*G+z*H+B*I+t-s;g[L+12>>2]=0.0;Tq(b+(d*84|0)+48|0,L+80|0,L+32|0,L+16|0,L,L+128+(d<<4)|0,M+396|0,+g[M+344>>2],m+396|0,+g[m+344>>2]);d=d+1|0;if((d|0)==3){d=b+32|0;break a}m=c[b+32>>2]|0;l=+g[m+4>>2];k=+g[m+20>>2];j=+g[m+36>>2];h=+g[m+8>>2];f=+g[m+24>>2];e=+g[m+40>>2];n=+g[m+12>>2];o=+g[m+28>>2];p=+g[m+44>>2];q=+g[m+52>>2];r=+g[m+56>>2];s=+g[m+60>>2]}}else d=b+32|0;while(0);m=c[b+28>>2]|0;M=c[d>>2]|0;ur(b,m+4|0,M+4|0,m+264|0,M+264|0);i=L;return}
function xr(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;var h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0,o=0.0,p=0.0,q=0.0,r=0,s=0,t=0,u=0.0,v=0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0;O=i;i=i+448|0;if(!(a[b+527>>0]|0)){i=O;return}N=c[b+28>>2]|0;C=+g[b+348>>2];z=+g[b+352>>2];D=+g[b+356>>2];l=+g[N+52>>2];k=C*+g[N+4>>2]+z*+g[N+8>>2]+D*+g[N+12>>2]+l;o=+g[N+56>>2];u=C*+g[N+20>>2]+z*+g[N+24>>2]+D*+g[N+28>>2]+o;j=+g[N+60>>2];D=C*+g[N+36>>2]+z*+g[N+40>>2]+D*+g[N+44>>2]+j;N=c[b+32>>2]|0;z=+g[b+412>>2];C=+g[b+416>>2];A=+g[b+420>>2];E=+g[N+52>>2];F=z*+g[N+4>>2]+C*+g[N+8>>2]+A*+g[N+12>>2]+E;G=+g[N+56>>2];H=z*+g[N+20>>2]+C*+g[N+24>>2]+A*+g[N+28>>2]+G;B=+g[N+60>>2];A=z*+g[N+36>>2]+C*+g[N+40>>2]+A*+g[N+44>>2]+B;if(!(a[b+524>>0]|0)){x=+g[d+192>>2]+ +g[d+80>>2];p=+g[d+196>>2]+ +g[d+84>>2];m=+g[d+200>>2]+ +g[d+88>>2];C=+g[e+192>>2]+ +g[e+80>>2];q=+g[e+196>>2]+ +g[e+84>>2];y=+g[e+200>>2]+ +g[e+88>>2];z=+g[d+176>>2]+ +g[d+64>>2]+((D-j)*p-(u-o)*m)-(+g[e+176>>2]+ +g[e+64>>2]+((A-B)*q-(H-G)*y));y=+g[d+180>>2]+ +g[d+68>>2]+((k-l)*m-(D-j)*x)-(+g[e+180>>2]+ +g[e+68>>2]+((F-E)*y-(A-B)*C));q=+g[d+184>>2]+ +g[d+72>>2]+((u-o)*x-(k-l)*p)-(+g[e+184>>2]+ +g[e+72>>2]+((H-G)*C-(F-E)*q));h=(c[d+240>>2]|0)==0;n=0;do{w=1.0/+g[b+(n*84|0)+128>>2];t=b+(n*84|0)+48|0;m=+g[t>>2];r=b+(n*84|0)+52|0;x=+g[r>>2];s=b+(n*84|0)+56|0;p=+g[s>>2];p=w*(((k-F)*m+(u-H)*x+(D-A)*p)*-.30000001192092896/f)-w*(z*m+y*x+q*p);g[b+36>>2]=+g[b+36>>2]+p;x=+g[s>>2];m=+g[r>>2];w=+g[t>>2];v=c[b+28>>2]|0;C=+g[v+344>>2];if(!h){S=((u-o)*x-(D-j)*m)*+g[v+296>>2]+((D-j)*w-(k-l)*x)*+g[v+300>>2]+((k-l)*m-(u-o)*w)*+g[v+304>>2];Q=((u-o)*x-(D-j)*m)*+g[v+280>>2]+((D-j)*w-(k-l)*x)*+g[v+284>>2]+((k-l)*m-(u-o)*w)*+g[v+288>>2];R=((u-o)*x-(D-j)*m)*+g[v+264>>2]+((D-j)*w-(k-l)*x)*+g[v+268>>2]+((k-l)*m-(u-o)*w)*+g[v+272>>2];U=p*(m*C)*+g[d+116>>2];T=p*(x*C)*+g[d+120>>2];g[d+64>>2]=p*(w*C)*+g[d+112>>2]+ +g[d+64>>2];g[d+68>>2]=U+ +g[d+68>>2];g[d+72>>2]=T+ +g[d+72>>2];Q=Q*(p*+g[d+100>>2]);C=S*(p*+g[d+104>>2]);g[d+80>>2]=R*(p*+g[d+96>>2])+ +g[d+80>>2];g[d+84>>2]=Q+ +g[d+84>>2];g[d+88>>2]=C+ +g[d+88>>2]}v=c[b+32>>2]|0;C=+g[v+344>>2];if(c[e+240>>2]|0){U=((H-G)*x-(A-B)*m)*+g[v+296>>2]+((A-B)*w-(F-E)*x)*+g[v+300>>2]+((F-E)*m-(H-G)*w)*+g[v+304>>2];T=((H-G)*x-(A-B)*m)*+g[v+280>>2]+((A-B)*w-(F-E)*x)*+g[v+284>>2]+((F-E)*m-(H-G)*w)*+g[v+288>>2];S=((H-G)*x-(A-B)*m)*+g[v+264>>2]+((A-B)*w-(F-E)*x)*+g[v+268>>2]+((F-E)*m-(H-G)*w)*+g[v+272>>2];x=C*+g[r>>2]*-p*+g[e+116>>2];R=C*+g[s>>2]*-p*+g[e+120>>2];g[e+64>>2]=+g[e+112>>2]*(C*+g[t>>2]*-p)+ +g[e+64>>2];g[e+68>>2]=x+ +g[e+68>>2];g[e+72>>2]=R+ +g[e+72>>2];T=T*(+g[e+100>>2]*-p);U=U*(+g[e+104>>2]*-p);g[e+80>>2]=S*(+g[e+96>>2]*-p)+ +g[e+80>>2];g[e+84>>2]=T+ +g[e+84>>2];g[e+88>>2]=U+ +g[e+88>>2]}n=n+1|0}while((n|0)!=3)}do if(!(a[b+552>>0]|0)){q=+g[b+440>>2];if(!(q>1.1920928955078125e-07)){I=d+80|0;n=d+196|0;J=d+84|0;r=d+200|0;K=d+88|0;s=e+192|0;L=e+80|0;t=e+196|0;M=e+84|0;v=e+200|0;N=e+88|0;h=d+192|0;break}p=+g[e+192>>2]+ +g[e+80>>2]-(+g[d+192>>2]+ +g[d+80>>2]);m=+g[e+196>>2]+ +g[e+84>>2]-(+g[d+196>>2]+ +g[d+84>>2]);l=+g[e+200>>2]+ +g[e+88>>2]-(+g[d+200>>2]+ +g[d+88>>2]);if(p*p+m*m+l*l>1.1920928955078125e-07){C=1.0/+P(+(p*p+m*m+l*l));h=c[b+28>>2]|0;w=+g[h+264>>2];o=+g[h+280>>2];u=+g[h+296>>2];j=+g[h+268>>2];x=+g[h+284>>2];y=+g[h+300>>2];z=+g[h+272>>2];A=+g[h+288>>2];B=+g[h+304>>2];h=c[b+32>>2]|0;q=q*(1.0/(p*C*(p*C*w+m*C*o+l*C*u)+m*C*(p*C*j+m*C*x+l*C*y)+l*C*(p*C*z+m*C*A+l*C*B)+(p*C*(p*C*+g[h+264>>2]+m*C*+g[h+280>>2]+l*C*+g[h+296>>2])+m*C*(p*C*+g[h+268>>2]+m*C*+g[h+284>>2]+l*C*+g[h+300>>2])+l*C*(p*C*+g[h+272>>2]+m*C*+g[h+288>>2]+l*C*+g[h+304>>2]))));C=+P(+(l*q*(l*q)+(p*q*(p*q)+m*q*(m*q))));k=1.0/C*(p*q);p=1.0/C*(m*q);q=1.0/C*(l*q);if(c[d+240>>2]|0){U=C*0.0*+g[d+116>>2];T=C*0.0*+g[d+120>>2];g[d+64>>2]=C*0.0*+g[d+112>>2]+ +g[d+64>>2];g[d+68>>2]=U+ +g[d+68>>2];g[d+72>>2]=T+ +g[d+72>>2];T=(k*o+p*x+q*A)*(C*+g[d+100>>2]);U=(k*u+p*y+q*B)*(C*+g[d+104>>2]);g[d+80>>2]=(k*w+p*j+q*z)*(C*+g[d+96>>2])+ +g[d+80>>2];g[d+84>>2]=T+ +g[d+84>>2];g[d+88>>2]=U+ +g[d+88>>2];h=c[b+32>>2]|0}if(c[e+240>>2]|0){U=k*+g[h+296>>2]+p*+g[h+300>>2]+q*+g[h+304>>2];T=k*+g[h+280>>2]+p*+g[h+284>>2]+q*+g[h+288>>2];S=k*+g[h+264>>2]+p*+g[h+268>>2]+q*+g[h+272>>2];E=C*-0.0*+g[e+116>>2];F=C*-0.0*+g[e+120>>2];g[e+64>>2]=C*-0.0*+g[e+112>>2]+ +g[e+64>>2];g[e+68>>2]=E+ +g[e+68>>2];g[e+72>>2]=F+ +g[e+72>>2];T=T*(+g[e+100>>2]*-C);U=U*(+g[e+104>>2]*-C);g[e+80>>2]=S*(+g[e+96>>2]*-C)+ +g[e+80>>2];g[e+84>>2]=T+ +g[e+84>>2];g[e+88>>2]=U+ +g[e+88>>2];I=d+80|0;n=d+196|0;J=d+84|0;r=d+200|0;K=d+88|0;s=e+192|0;L=e+80|0;t=e+196|0;M=e+84|0;v=e+200|0;N=e+88|0;h=d+192|0}else{I=d+80|0;n=d+196|0;J=d+84|0;r=d+200|0;K=d+88|0;s=e+192|0;L=e+80|0;t=e+196|0;M=e+84|0;v=e+200|0;N=e+88|0;h=d+192|0}}else{I=d+80|0;n=d+196|0;J=d+84|0;r=d+200|0;K=d+88|0;s=e+192|0;L=e+80|0;t=e+196|0;M=e+84|0;v=e+200|0;N=e+88|0;h=d+192|0}}else{M=c[b+28>>2]|0;c[O+344>>2]=c[M+4>>2];c[O+348>>2]=c[M+8>>2];c[O+352>>2]=c[M+12>>2];c[O+356>>2]=c[M+16>>2];c[O+360>>2]=c[M+20>>2];c[O+364>>2]=c[M+24>>2];c[O+368>>2]=c[M+28>>2];c[O+372>>2]=c[M+32>>2];c[O+376>>2]=c[M+36>>2];c[O+380>>2]=c[M+40>>2];c[O+384>>2]=c[M+44>>2];c[O+388>>2]=c[M+48>>2];c[O+392>>2]=c[M+52>>2];c[O+396>>2]=c[M+56>>2];c[O+400>>2]=c[M+60>>2];c[O+404>>2]=c[M+64>>2];M=c[b+32>>2]|0;c[O+16>>2]=c[M+4>>2];c[O+20>>2]=c[M+8>>2];c[O+24>>2]=c[M+12>>2];c[O+28>>2]=c[M+16>>2];c[O+32>>2]=c[M+20>>2];c[O+36>>2]=c[M+24>>2];c[O+40>>2]=c[M+28>>2];c[O+44>>2]=c[M+32>>2];c[O+48>>2]=c[M+36>>2];c[O+52>>2]=c[M+40>>2];c[O+56>>2]=c[M+44>>2];c[O+60>>2]=c[M+48>>2];c[O+64>>2]=c[M+52>>2];c[O+68>>2]=c[M+56>>2];c[O+72>>2]=c[M+60>>2];c[O+76>>2]=c[M+64>>2];S=+g[d+196>>2]+ +g[d+84>>2];w=+g[d+200>>2]+ +g[d+88>>2];g[O+408>>2]=+g[d+192>>2]+ +g[d+80>>2];g[O+412>>2]=S;g[O+416>>2]=w;g[O+420>>2]=0.0;w=+g[e+196>>2]+ +g[e+84>>2];S=+g[e+200>>2]+ +g[e+88>>2];g[O+424>>2]=+g[e+192>>2]+ +g[e+80>>2];g[O+428>>2]=w;g[O+432>>2]=S;g[O+436>>2]=0.0;g[O+144>>2]=1.0;M=O+148|0;c[M+0>>2]=0;c[M+4>>2]=0;c[M+8>>2]=0;c[M+12>>2]=0;g[O+164>>2]=1.0;N=O+168|0;c[N+0>>2]=0;c[N+4>>2]=0;c[N+8>>2]=0;c[N+12>>2]=0;g[O+184>>2]=1.0;n=O+188|0;c[n+0>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;c[n+16>>2]=0;Jp(O+344|0,0.0,0.0,0.0,O+408|0,f,O+144|0);g[O+280>>2]=1.0;n=O+284|0;c[n+0>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;g[O+300>>2]=1.0;L=O+304|0;c[L+0>>2]=0;c[L+4>>2]=0;c[L+8>>2]=0;c[L+12>>2]=0;g[O+320>>2]=1.0;K=O+324|0;c[K+0>>2]=0;c[K+4>>2]=0;c[K+8>>2]=0;c[K+12>>2]=0;c[K+16>>2]=0;Jp(O+16|0,0.0,0.0,0.0,O+424|0,f,O+280|0);S=+g[b+556>>2];w=+g[b+560>>2];T=+g[b+564>>2];Q=+g[b+568>>2];p=S*(2.0/(S*S+w*w+T*T+Q*Q));z=w*(2.0/(S*S+w*w+T*T+Q*Q));q=T*(2.0/(S*S+w*w+T*T+Q*Q));W=+g[b+364>>2];V=+g[b+368>>2];Z=+g[b+372>>2];G=(S*q-Q*z)*Z+(V*(S*z+Q*q)+W*(1.0-(w*z+T*q)));u=Z*(w*q+Q*p)+(W*(S*z-Q*q)+V*(1.0-(S*p+T*q)));o=W*(S*q+Q*z)+V*(w*q-Q*p)+Z*(1.0-(S*p+w*z));j=+g[b+380>>2];R=+g[b+384>>2];y=+g[b+388>>2];k=(1.0-(w*z+T*q))*j+(S*z+Q*q)*R+(S*q-Q*z)*y;H=(S*z-Q*q)*j+(1.0-(S*p+T*q))*R+(w*q+Q*p)*y;l=(S*q+Q*z)*j+(w*q-Q*p)*R+(1.0-(S*p+w*z))*y;E=+g[b+396>>2];x=+g[b+400>>2];A=+g[b+404>>2];F=(1.0-(w*z+T*q))*E+(S*z+Q*q)*x+(S*q-Q*z)*A;T=(S*z-Q*q)*E+(1.0-(S*p+T*q))*x+(w*q+Q*p)*A;z=(S*q+Q*z)*E+(w*q-Q*p)*x+(1.0-(S*p+w*z))*A;w=+g[b+300>>2];p=+g[b+316>>2];S=+g[b+332>>2];Q=+g[b+304>>2];q=+g[b+320>>2];U=+g[b+336>>2];m=+g[b+308>>2];D=+g[b+324>>2];B=+g[b+340>>2];C=-+g[b+348>>2];aa=-+g[b+352>>2];Y=-+g[b+356>>2];Z=W*0.0+V*0.0+Z*0.0+ +g[b+412>>2]+(o*(m*C+D*aa+B*Y)+(G*(w*C+p*aa+S*Y)+u*(Q*C+q*aa+U*Y)));y=j*0.0+R*0.0+y*0.0+ +g[b+416>>2]+(l*(m*C+D*aa+B*Y)+(k*(w*C+p*aa+S*Y)+H*(Q*C+q*aa+U*Y)));Y=E*0.0+x*0.0+A*0.0+ +g[b+420>>2]+(z*(m*C+D*aa+B*Y)+(F*(w*C+p*aa+S*Y)+T*(Q*C+q*aa+U*Y)));aa=+g[O+280>>2];C=+g[n>>2];A=+g[O+288>>2];x=+g[O+296>>2];E=+g[O+300>>2];R=+g[L>>2];j=+g[O+312>>2];V=+g[O+316>>2];W=+g[O+320>>2];X=A*Y+(aa*Z+C*y)+ +g[O+328>>2];_=Y*R+(x*Z+E*y)+ +g[O+332>>2];$=Z*j+y*V+Y*W+ +g[O+336>>2];g[O+216>>2]=(G*w+u*Q+o*m)*aa+(k*w+H*Q+l*m)*C+(F*w+T*Q+z*m)*A;g[O+220>>2]=(G*p+u*q+o*D)*aa+(k*p+H*q+l*D)*C+(F*p+T*q+z*D)*A;g[O+224>>2]=(G*S+u*U+o*B)*aa+(k*S+H*U+l*B)*C+(F*S+T*U+z*B)*A;g[O+228>>2]=0.0;g[O+232>>2]=(G*w+u*Q+o*m)*x+(k*w+H*Q+l*m)*E+(F*w+T*Q+z*m)*R;g[O+236>>2]=(G*p+u*q+o*D)*x+(k*p+H*q+l*D)*E+(F*p+T*q+z*D)*R;g[O+240>>2]=(G*S+u*U+o*B)*x+(k*S+H*U+l*B)*E+(F*S+T*U+z*B)*R;g[O+244>>2]=0.0;g[O+248>>2]=(G*w+u*Q+o*m)*j+(k*w+H*Q+l*m)*V+(F*w+T*Q+z*m)*W;g[O+252>>2]=(G*p+u*q+o*D)*j+(k*p+H*q+l*D)*V+(F*p+T*q+z*D)*W;g[O+256>>2]=(G*S+u*U+o*B)*j+(k*S+H*U+l*B)*V+(F*S+T*U+z*B)*W;g[O+260>>2]=0.0;g[O+264>>2]=X;g[O+268>>2]=_;g[O+272>>2]=$;g[O+276>>2]=0.0;$=(F*w+T*Q+z*m)*-Y+((G*w+u*Q+o*m)*-Z+(k*w+H*Q+l*m)*-y);_=(F*p+T*q+z*D)*-Y+((G*p+u*q+o*D)*-Z+(k*p+H*q+l*D)*-y);y=(F*S+T*U+z*B)*-Y+((G*S+u*U+o*B)*-Z+(k*S+H*U+l*B)*-y);Z=+g[O+144>>2];Y=+g[M>>2];X=+g[O+152>>2];W=+g[O+160>>2];V=+g[O+164>>2];j=+g[N>>2];R=+g[O+176>>2];E=+g[O+180>>2];x=+g[O+184>>2];A=$*Z+_*Y+y*X+ +g[O+192>>2];C=$*W+_*V+y*j+ +g[O+196>>2];y=$*R+_*E+y*x+ +g[O+200>>2];g[O+80>>2]=(G*w+u*Q+o*m)*Z+(G*p+u*q+o*D)*Y+(G*S+u*U+o*B)*X;g[O+84>>2]=(k*w+H*Q+l*m)*Z+(k*p+H*q+l*D)*Y+(k*S+H*U+l*B)*X;g[O+88>>2]=(F*w+T*Q+z*m)*Z+(F*p+T*q+z*D)*Y+(F*S+T*U+z*B)*X;g[O+92>>2]=0.0;g[O+96>>2]=(G*w+u*Q+o*m)*W+(G*p+u*q+o*D)*V+(G*S+u*U+o*B)*j;g[O+100>>2]=(k*w+H*Q+l*m)*W+(k*p+H*q+l*D)*V+(k*S+H*U+l*B)*j;g[O+104>>2]=(F*w+T*Q+z*m)*W+(F*p+T*q+z*D)*V+(F*S+T*U+z*B)*j;g[O+108>>2]=0.0;g[O+112>>2]=(G*w+u*Q+o*m)*R+(G*p+u*q+o*D)*E+(G*S+u*U+o*B)*x;g[O+116>>2]=(k*w+H*Q+l*m)*R+(k*p+H*q+l*D)*E+(k*S+H*U+l*B)*x;g[O+120>>2]=(F*w+T*Q+z*m)*R+(F*p+T*q+z*D)*E+(F*S+T*U+z*B)*x;g[O+124>>2]=0.0;g[O+128>>2]=A;g[O+132>>2]=C;g[O+136>>2]=y;g[O+140>>2]=0.0;Kp(O+344|0,O+216|0,O,O+208|0);y=+g[O+208>>2];C=1.0/f*(+g[O>>2]*y);A=1.0/f*(y*+g[O+4>>2]);y=1.0/f*(y*+g[O+8>>2]);Kp(O+16|0,O+80|0,O,O+208|0);x=+g[O+208>>2];C=C-+g[O+408>>2];A=A-+g[O+412>>2];y=y-+g[O+416>>2];B=1.0/f*(+g[O>>2]*x)-+g[O+424>>2];z=1.0/f*(x*+g[O+4>>2])-+g[O+428>>2];x=1.0/f*(x*+g[O+8>>2])-+g[O+432>>2];if(C*C+A*A+y*y>1.1920928955078125e-07){o=1.0/+P(+(C*C+A*A+y*y));N=c[b+28>>2]|0;q=C*o;k=C*o*(C*o*+g[N+264>>2]+A*o*+g[N+280>>2]+y*o*+g[N+296>>2])+A*o*(C*o*+g[N+268>>2]+A*o*+g[N+284>>2]+y*o*+g[N+300>>2])+y*o*(C*o*+g[N+272>>2]+A*o*+g[N+288>>2]+y*o*+g[N+304>>2]);m=A*o;o=y*o}else{q=0.0;k=0.0;m=0.0;o=0.0}if(B*B+z*z+x*x>1.1920928955078125e-07){u=1.0/+P(+(B*B+z*z+x*x));N=c[b+32>>2]|0;p=B*u;j=B*u*(B*u*+g[N+264>>2]+z*u*+g[N+280>>2]+x*u*+g[N+296>>2])+z*u*(B*u*+g[N+268>>2]+z*u*+g[N+284>>2]+x*u*+g[N+300>>2])+x*u*(B*u*+g[N+272>>2]+z*u*+g[N+288>>2]+x*u*+g[N+304>>2]);l=z*u;u=x*u}else{p=0.0;j=0.0;l=0.0;u=0.0}w=q*k+p*j;q=m*k+l*j;m=o*k+u*j;if(m*m+(w*w+q*q)>1.1920928955078125e-07){u=1.0/+P(+(m*m+(w*w+q*q)));v=c[b+28>>2]|0;p=w*u*(w*u*+g[v+264>>2]+q*u*+g[v+280>>2]+m*u*+g[v+296>>2])+q*u*(w*u*+g[v+268>>2]+q*u*+g[v+284>>2]+m*u*+g[v+300>>2])+m*u*(w*u*+g[v+272>>2]+q*u*+g[v+288>>2]+m*u*+g[v+304>>2]);h=c[b+32>>2]|0;u=w*u*(w*u*+g[h+264>>2]+q*u*+g[h+280>>2]+m*u*+g[h+296>>2])+q*u*(w*u*+g[h+268>>2]+q*u*+g[h+284>>2]+m*u*+g[h+300>>2])+m*u*(w*u*+g[h+272>>2]+q*u*+g[h+288>>2]+m*u*+g[h+304>>2]);l=1.0/((p+u)*(p+u))*(C*p-B*u);k=1.0/((p+u)*(p+u))*(A*p-z*u);u=1.0/((p+u)*(p+u))*(y*p-x*u);j=+g[b+572>>2];if(!(j>=0.0))j=u;else{if(a[b+553>>0]|0)j=j/p;o=+g[b+576>>2];p=+g[b+580>>2];q=+g[b+584>>2];m=+P(+((l+o)*(l+o)+(k+p)*(k+p)+(u+q)*(u+q)));if(m>j){l=j*((l+o)*(1.0/m))-o;k=j*((k+p)*(1.0/m))-p;j=j*((u+q)*(1.0/m))-q}else j=u;g[b+576>>2]=l+o;g[b+580>>2]=k+p;g[b+584>>2]=j+q}m=+P(+(j*j+(k*k+l*l)));l=l*(1.0/m);k=k*(1.0/m);j=j*(1.0/m);if(c[d+240>>2]|0){_=l*+g[v+296>>2]+k*+g[v+300>>2]+j*+g[v+304>>2];Z=l*+g[v+280>>2]+k*+g[v+284>>2]+j*+g[v+288>>2];Y=l*+g[v+264>>2]+k*+g[v+268>>2]+j*+g[v+272>>2];W=m*0.0*+g[d+116>>2];X=m*0.0*+g[d+120>>2];g[d+64>>2]=m*0.0*+g[d+112>>2]+ +g[d+64>>2];g[d+68>>2]=W+ +g[d+68>>2];g[d+72>>2]=X+ +g[d+72>>2];Z=Z*(m*+g[d+100>>2]);_=_*(m*+g[d+104>>2]);g[d+80>>2]=Y*(m*+g[d+96>>2])+ +g[d+80>>2];g[d+84>>2]=Z+ +g[d+84>>2];g[d+88>>2]=_+ +g[d+88>>2];h=c[b+32>>2]|0}if(c[e+240>>2]|0){_=l*+g[h+296>>2]+k*+g[h+300>>2]+j*+g[h+304>>2];Z=l*+g[h+280>>2]+k*+g[h+284>>2]+j*+g[h+288>>2];Y=l*+g[h+264>>2]+k*+g[h+268>>2]+j*+g[h+272>>2];W=m*-0.0*+g[e+116>>2];X=m*-0.0*+g[e+120>>2];g[e+64>>2]=m*-0.0*+g[e+112>>2]+ +g[e+64>>2];g[e+68>>2]=W+ +g[e+68>>2];g[e+72>>2]=X+ +g[e+72>>2];Z=Z*(+g[e+100>>2]*-m);_=_*(+g[e+104>>2]*-m);g[e+80>>2]=Y*(+g[e+96>>2]*-m)+ +g[e+80>>2];g[e+84>>2]=Z+ +g[e+84>>2];g[e+88>>2]=_+ +g[e+88>>2];I=d+80|0;n=d+196|0;J=d+84|0;r=d+200|0;K=d+88|0;s=e+192|0;L=e+80|0;t=e+196|0;M=e+84|0;v=e+200|0;N=e+88|0;h=d+192|0}else{I=d+80|0;n=d+196|0;J=d+84|0;r=d+200|0;K=d+88|0;s=e+192|0;L=e+80|0;t=e+196|0;M=e+84|0;v=e+200|0;N=e+88|0;h=d+192|0}}else{I=d+80|0;n=d+196|0;J=d+84|0;r=d+200|0;K=d+88|0;s=e+192|0;L=e+80|0;t=e+196|0;M=e+84|0;v=e+200|0;N=e+88|0;h=d+192|0}}while(0);H=+g[h>>2]+ +g[I>>2];w=+g[n>>2]+ +g[J>>2];x=+g[r>>2]+ +g[K>>2];D=+g[s>>2]+ +g[L>>2];E=+g[t>>2]+ +g[M>>2];F=+g[v>>2]+ +g[N>>2];if(a[b+526>>0]|0){p=+g[b+528>>2];q=p*+g[b+504>>2]*+g[b+432>>2]/f;C=+g[b+460>>2];B=+g[b+464>>2];z=+g[b+468>>2];if((D-H)*C+(E-w)*B+(F-x)*z>0.0)q=q+p*((D-H)*C+(E-w)*B+(F-x)*z)*+g[b+436>>2];Y=+g[b+516>>2];X=Y+q*+g[b+492>>2];X=X>0.0?X:0.0;g[b+516>>2]=X;A=+g[b+536>>2];W=+g[b+540>>2];Z=+g[b+544>>2];_=A*(C*(X-Y))+B*(X-Y)*W+z*(X-Y)*Z;y=+P(+((z*(X-Y)-Z*_)*(z*(X-Y)-Z*_)+((C*(X-Y)-A*_)*(C*(X-Y)-A*_)+(B*(X-Y)-W*_)*(B*(X-Y)-W*_))));A=1.0/y*(C*(X-Y)-A*_);B=1.0/y*(B*(X-Y)-W*_);C=1.0/y*(z*(X-Y)-Z*_);v=c[b+28>>2]|0;if(c[d+240>>2]|0){_=A*+g[v+296>>2]+B*+g[v+300>>2]+C*+g[v+304>>2];Z=A*+g[v+280>>2]+B*+g[v+284>>2]+C*+g[v+288>>2];Y=A*+g[v+264>>2]+B*+g[v+268>>2]+C*+g[v+272>>2];W=y*0.0*+g[d+116>>2];X=y*0.0*+g[d+120>>2];g[d+64>>2]=y*0.0*+g[d+112>>2]+ +g[d+64>>2];g[d+68>>2]=W+ +g[d+68>>2];g[d+72>>2]=X+ +g[d+72>>2];Z=Z*(y*+g[d+100>>2]);_=_*(y*+g[d+104>>2]);g[I>>2]=Y*(y*+g[d+96>>2])+ +g[I>>2];g[J>>2]=Z+ +g[J>>2];g[K>>2]=_+ +g[K>>2]}v=c[b+32>>2]|0;if(c[e+240>>2]|0){_=A*+g[v+296>>2]+B*+g[v+300>>2]+C*+g[v+304>>2];Z=A*+g[v+280>>2]+B*+g[v+284>>2]+C*+g[v+288>>2];Y=A*+g[v+264>>2]+B*+g[v+268>>2]+C*+g[v+272>>2];W=y*-0.0*+g[e+116>>2];X=y*-0.0*+g[e+120>>2];g[e+64>>2]=y*-0.0*+g[e+112>>2]+ +g[e+64>>2];g[e+68>>2]=W+ +g[e+68>>2];g[e+72>>2]=X+ +g[e+72>>2];Z=Z*(+g[e+100>>2]*-y);_=_*(+g[e+104>>2]*-y);g[L>>2]=Y*(+g[e+96>>2]*-y)+ +g[L>>2];g[M>>2]=Z+ +g[M>>2];g[N>>2]=_+ +g[N>>2]}}if(!(a[b+525>>0]|0)){i=O;return}q=+g[b+532>>2];m=q*+g[b+508>>2]*+g[b+432>>2]/f;l=+g[b+476>>2];k=+g[b+480>>2];j=+g[b+484>>2];if((D-H)*l+(E-w)*k+(F-x)*j>0.0)m=m+q*((D-H)*l+(E-w)*k+(F-x)*j)*+g[b+436>>2];p=+g[b+520>>2];q=p+m*+g[b+496>>2];q=q>0.0?q:0.0;g[b+520>>2]=q;h=c[b+28>>2]|0;if(c[d+240>>2]|0){_=l*+g[h+296>>2]+k*+g[h+300>>2]+j*+g[h+304>>2];Z=l*+g[h+280>>2]+k*+g[h+284>>2]+j*+g[h+288>>2];j=l*+g[h+264>>2]+k*+g[h+268>>2]+j*+g[h+272>>2];l=(q-p)*0.0*+g[d+116>>2];k=(q-p)*0.0*+g[d+120>>2];g[d+64>>2]=(q-p)*0.0*+g[d+112>>2]+ +g[d+64>>2];g[d+68>>2]=l+ +g[d+68>>2];g[d+72>>2]=k+ +g[d+72>>2];k=Z*((q-p)*+g[d+100>>2]);l=_*((q-p)*+g[d+104>>2]);g[I>>2]=j*((q-p)*+g[d+96>>2])+ +g[I>>2];g[J>>2]=k+ +g[J>>2];g[K>>2]=l+ +g[K>>2];l=+g[b+476>>2];k=+g[b+480>>2];j=+g[b+484>>2]}h=c[b+32>>2]|0;if(!(c[e+240>>2]|0)){i=O;return}_=l*+g[h+296>>2]+k*+g[h+300>>2]+j*+g[h+304>>2];Z=l*+g[h+280>>2]+k*+g[h+284>>2]+j*+g[h+288>>2];Y=l*+g[h+264>>2]+k*+g[h+268>>2]+j*+g[h+272>>2];W=(q-p)*-0.0*+g[e+116>>2];X=(q-p)*-0.0*+g[e+120>>2];g[e+64>>2]=(q-p)*-0.0*+g[e+112>>2]+ +g[e+64>>2];g[e+68>>2]=W+ +g[e+68>>2];g[e+72>>2]=X+ +g[e+72>>2];Z=Z*(+g[e+100>>2]*-(q-p));_=_*(+g[e+104>>2]*-(q-p));g[L>>2]=Y*(+g[e+96>>2]*-(q-p))+ +g[L>>2];g[M>>2]=Z+ +g[M>>2];g[N>>2]=_+ +g[N>>2];i=O;return}function yr(a,b,c,d){a=a|0;b=b|0;c=+c;d=+d;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;i=+R(+c);h=+S(+c);c=+g[b+444>>2];if(+O(+i)>1.1920928955078125e-07){j=+g[b+448>>2];e=h*h;f=i*i;c=+P(+((h*h/(i*i)+1.0)/(1.0/(j*j)+h*h/(i*i)/(c*c))))}else{e=h*h;f=i*i}c=c*.5;j=+S(+c)/+P(+(f+0.0+e));c=+R(+c);k=c*d+i*j*0.0-h*j*-0.0;f=c*0.0-h*j*d-j*0.0*0.0;e=c*0.0+j*0.0*0.0-i*j*d;d=-(j*0.0*d)-i*j*0.0-h*j*-0.0;g[a>>2]=h*j*f+(c*k+d*-(j*0.0))-e*-(i*j);g[a+4>>2]=e*-(j*0.0)+(c*f+d*-(i*j))-h*j*k;g[a+8>>2]=k*-(i*j)+(c*e+h*j*d)-f*-(j*0.0);g[a+12>>2]=0.0;return}function zr(a,b){a=a|0;b=b|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,t=0.0;c[a+556>>2]=c[b+0>>2];c[a+560>>2]=c[b+4>>2];c[a+564>>2]=c[b+8>>2];c[a+568>>2]=c[b+12>>2];j=+g[a+568>>2];i=+g[a+560>>2];l=+g[a+564>>2];k=+g[a+556>>2];d=-k-i*0.0-l*0.0;e=(l+j*0.0-k*0.0)*-l+(j*(j+i*0.0-l*0.0)+d*-k)-(j*0.0+k*0.0-i)*-i;f=(j*0.0+k*0.0-i)*-k+(j*(l+j*0.0-k*0.0)+d*-i)-(j+i*0.0-l*0.0)*-l;d=(j+i*0.0-l*0.0)*-i+(j*(j*0.0+k*0.0-i)+d*-l)-(l+j*0.0-k*0.0)*-k;if(d*0.0+(f*0.0+e)<-.9999998807907104)if(+O(0.0)>.7071067690849304){h=0.0;d=s;f=s;e=0.0}else{h=-0.0;d=1.0;f=0.0;e=0.0}else{t=+P(+((d*0.0+(f*0.0+e)+1.0)*2.0));h=(d*0.0-f*0.0)*(1.0/t);d=(e*0.0-d)*(1.0/t);f=(f-e*0.0)*(1.0/t);e=t*.5}m=1.0/+P(+(e*e+(f*f+(d*d+h*h))));o=h*m;p=d*m;q=f*m;m=e*m;f=1.0/+P(+((m*j-k*-o-i*-p-l*-q)*(m*j-k*-o-i*-p-l*-q)+((j*-q+m*l+i*-o-k*-p)*(j*-q+m*l+i*-o-k*-p)+((m*k+j*-o+l*-p-i*-q)*(m*k+j*-o+l*-p-i*-q)+(k*-q+(j*-p+m*i)-l*-o)*(k*-q+(j*-p+m*i)-l*-o)))));r=(m*k+j*-o+l*-p-i*-q)*f;t=f*(k*-q+(j*-p+m*i)-l*-o);e=f*(j*-q+m*l+i*-o-k*-p);f=f*(m*j-k*-o-i*-p-l*-q);d=+g[a+444>>2];if(d>=.05000000074505806?(n=+g[a+448>>2],n>=.05000000074505806):0){j=m<-1.0?-1.0:m;j=+U(+(j>1.0?1.0:j))*2.0;if(j>1.1920928955078125e-07){i=1.0/+P(+(q*q+(o*o+p*p)));if(+O(+(p*i))>1.1920928955078125e-07){d=+P(+((q*i*(q*i)/(p*i*(p*i))+1.0)/(1.0/(n*n)+q*i*(q*i)/(p*i*(p*i))/(d*d))));h=o*i;k=p*i;i=q*i}else{h=o*i;k=p*i;i=q*i}}else{d=0.0;h=0.0;k=0.0;i=0.0}if(+O(+j)>1.1920928955078125e-07){if(!(j>d)){d=-d;if(!(j<d))d=j}m=d*.5;l=+S(+m)/+P(+(i*i+(k*k+h*h)));m=+R(+m);o=h*l;n=k*l;l=i*l}else{n=p;l=q}}else{n=p;l=q}k=+g[a+452>>2];if(k>=.05000000074505806){d=f<-1.0?-1.0:f;d=+U(+(d>1.0?1.0:d))*2.0;if(d>3.1415927410125732){d=f>1.0?-1.0:-f;d=+U(+(d>1.0?1.0:d))*2.0;h=-r;i=-t;j=-e}else{h=r;i=t;j=e}if(d>1.1920928955078125e-07){q=1.0/+P(+(j*j+(i*i+h*h)));h=h*q;i=i*q;j=j*q}if(+O(+d)>1.1920928955078125e-07){if(!(d>k)){if(d<-k)d=-k}else d=k;f=d*.5;d=+S(+f)/+P(+(j*j+(i*i+h*h)));h=h*d;f=+R(+f);e=j*d;d=i*d}else{h=r;d=t}}else{h=r;d=t}g[a+556>>2]=n*e+(o*f+m*h)-l*d;g[a+560>>2]=l*h+(n*f+m*d)-o*e;g[a+564>>2]=l*f+m*e+o*d-n*h;g[a+568>>2]=m*f-o*h-n*d-l*e;return}function Ar(a,b,d,e){a=a|0;b=b|0;d=+d;e=e|0;if((b|0)==2|(b|0)==1)if(e>>>0<3){g[a+600>>2]=d;c[a+592>>2]=c[a+592>>2]|2;return}else{g[a+432>>2]=d;return}else if((b|0)==4|(b|0)==3)if(e>>>0<3){g[a+596>>2]=d;c[a+592>>2]=c[a+592>>2]|1;return}else{g[a+604>>2]=d;c[a+592>>2]=c[a+592>>2]|4;return}else return}function Br(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0;do if((b|0)==2|(b|0)==1){if(c>>>0<3){d=+g[a+600>>2];break}if((c+-3|0)>>>0<3)d=+g[a+432>>2];else d=0.0}else if((b|0)==4|(b|0)==3){if(c>>>0<3){d=+g[a+596>>2];break}if((c+-3|0)>>>0<3)d=+g[a+604>>2];else d=0.0}else d=0.0;while(0);return +d}function Cr(a,b,d){a=a|0;b=b|0;d=d|0;c[a+300>>2]=c[b+0>>2];c[a+304>>2]=c[b+4>>2];c[a+308>>2]=c[b+8>>2];c[a+312>>2]=c[b+12>>2];c[a+316>>2]=c[b+16>>2];c[a+320>>2]=c[b+20>>2];c[a+324>>2]=c[b+24>>2];c[a+328>>2]=c[b+28>>2];c[a+332>>2]=c[b+32>>2];c[a+336>>2]=c[b+36>>2];c[a+340>>2]=c[b+40>>2];c[a+344>>2]=c[b+44>>2];c[a+348>>2]=c[b+48>>2];c[a+352>>2]=c[b+52>>2];c[a+356>>2]=c[b+56>>2];c[a+360>>2]=c[b+60>>2];c[a+364>>2]=c[d+0>>2];c[a+368>>2]=c[d+4>>2];c[a+372>>2]=c[d+8>>2];c[a+376>>2]=c[d+12>>2];c[a+380>>2]=c[d+16>>2];c[a+384>>2]=c[d+20>>2];c[a+388>>2]=c[d+24>>2];c[a+392>>2]=c[d+28>>2];c[a+396>>2]=c[d+32>>2];c[a+400>>2]=c[d+36>>2];c[a+404>>2]=c[d+40>>2];c[a+408>>2]=c[d+44>>2];c[a+412>>2]=c[d+48>>2];c[a+416>>2]=c[d+52>>2];c[a+420>>2]=c[d+56>>2];c[a+424>>2]=c[d+60>>2];Jb[c[(c[a>>2]|0)+8>>2]&255](a);return}function Dr(a,b,c){a=a|0;b=b|0;c=c|0;kr(a,b,c)|0;g[b+52>>2]=+g[a+300>>2];g[b+56>>2]=+g[a+304>>2];g[b+60>>2]=+g[a+308>>2];g[b+64>>2]=+g[a+312>>2];g[b+68>>2]=+g[a+316>>2];g[b+72>>2]=+g[a+320>>2];g[b+76>>2]=+g[a+324>>2];g[b+80>>2]=+g[a+328>>2];g[b+84>>2]=+g[a+332>>2];g[b+88>>2]=+g[a+336>>2];g[b+92>>2]=+g[a+340>>2];g[b+96>>2]=+g[a+344>>2];g[b+100>>2]=+g[a+348>>2];g[b+104>>2]=+g[a+352>>2];g[b+108>>2]=+g[a+356>>2];g[b+112>>2]=+g[a+360>>2];g[b+116>>2]=+g[a+364>>2];g[b+120>>2]=+g[a+368>>2];g[b+124>>2]=+g[a+372>>2];g[b+128>>2]=+g[a+376>>2];g[b+132>>2]=+g[a+380>>2];g[b+136>>2]=+g[a+384>>2];g[b+140>>2]=+g[a+388>>2];g[b+144>>2]=+g[a+392>>2];g[b+148>>2]=+g[a+396>>2];g[b+152>>2]=+g[a+400>>2];g[b+156>>2]=+g[a+404>>2];g[b+160>>2]=+g[a+408>>2];g[b+164>>2]=+g[a+412>>2];g[b+168>>2]=+g[a+416>>2];g[b+172>>2]=+g[a+420>>2];g[b+176>>2]=+g[a+424>>2];g[b+180>>2]=+g[a+444>>2];g[b+184>>2]=+g[a+448>>2];g[b+188>>2]=+g[a+452>>2];g[b+192>>2]=+g[a+428>>2];g[b+196>>2]=+g[a+432>>2];g[b+200>>2]=+g[a+436>>2];g[b+204>>2]=+g[a+440>>2];return 3896}function Er(a){a=a|0;return 212}function Fr(a){a=a|0;if(!a)return;c[5134]=(c[5134]|0)+1;_E(c[a+-4>>2]|0);return}function Gr(b,d,e,f,h,i,j,k){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;j=j|0;k=k|0;var l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0;c[b+4>>2]=4;c[b+8>>2]=-1;c[b+12>>2]=-1;g[b+16>>2]=3402823466385288598117041.0e14;a[b+20>>0]=1;a[b+21>>0]=0;c[b+24>>2]=-1;c[b+28>>2]=d;c[b+32>>2]=e;g[b+36>>2]=0.0;g[b+40>>2]=.30000001192092896;c[b+44>>2]=0;c[b>>2]=3936;g[b+688>>2]=0.0;g[b+692>>2]=-1.0;g[b+696>>2]=.8999999761581421;g[b+700>>2]=.30000001192092896;g[b+704>>2]=1.0;g[b+708>>2]=0.0;g[b+712>>2]=0.0;a[b+716>>0]=0;a[b+736>>0]=0;a[b+737>>0]=0;a[b+738>>0]=0;a[b+739>>0]=1;a[b+740>>0]=k&1;c[b+748>>2]=0;c[b+600>>2]=c[f+0>>2];c[b+604>>2]=c[f+4>>2];c[b+608>>2]=c[f+8>>2];c[b+612>>2]=c[f+12>>2];q=+g[d+4>>2];p=+g[d+20>>2];o=+g[d+36>>2];n=+g[i>>2];m=+g[i+4>>2];l=+g[i+8>>2];do if(!(q*n+p*m+o*l>=.9999998807907104))if(!(q*n+p*m+o*l<=-.9999998807907104)){r=q*l-o*n;v=m*(o*m-p*l)-n*(q*l-o*n);s=p*n-q*m;w=l*(q*l-o*n)-m*(p*n-q*m);t=o*m-p*l;u=n*(p*n-q*m)-l*(o*m-p*l);break}else{r=+g[d+24>>2];v=+g[d+44>>2];s=+g[d+40>>2];w=+g[d+12>>2];t=+g[d+8>>2];u=+g[d+28>>2];break}else{r=+g[d+24>>2];v=-+g[d+44>>2];s=+g[d+40>>2];w=-+g[d+12>>2];t=+g[d+8>>2];u=-+g[d+28>>2]}while(0);g[b+552>>2]=w;g[b+556>>2]=t;g[b+560>>2]=+g[i>>2];g[b+564>>2]=0.0;g[b+568>>2]=u;g[b+572>>2]=r;g[b+576>>2]=+g[i+4>>2];g[b+580>>2]=0.0;g[b+584>>2]=v;g[b+588>>2]=s;g[b+592>>2]=+g[i+8>>2];g[b+596>>2]=0.0;n=+g[i+4>>2];s=+g[j+8>>2];o=+g[i+8>>2];r=+g[j+4>>2];t=+g[j>>2];l=+g[i>>2];do if(s*o+(n*r+t*l)<-.9999998807907104)if(+O(+o)>.7071067690849304){m=1.0/+P(+(n*n+o*o));p=0.0;q=-(o*m);m=n*m;l=0.0;break}else{o=1.0/+P(+(n*n+l*l));p=0.0;q=l*o;m=0.0;l=-(n*o);break}else{x=+P(+((s*o+(n*r+t*l)+1.0)*2.0));p=x*.5;q=(o*t-s*l)*(1.0/x);m=(r*l-n*t)*(1.0/x);l=(n*s-o*r)*(1.0/x)}while(0);z=w*p+v*q-u*m;o=u*p+w*m-v*l;y=v*p+u*l-w*q;n=-(w*l)-u*q-v*m;u=-l;v=-q;q=-m;x=o*q+(p*z+n*u)-y*v;w=y*u+(p*o+n*v)-z*q;u=z*v+(p*y+n*q)-o*u;c[b+664>>2]=c[h+0>>2];c[b+668>>2]=c[h+4>>2];c[b+672>>2]=c[h+8>>2];c[b+676>>2]=c[h+12>>2];g[b+616>>2]=x;g[b+620>>2]=r*u-s*w;g[b+624>>2]=+g[j>>2];g[b+628>>2]=0.0;g[b+632>>2]=w;g[b+636>>2]=s*x-t*u;g[b+640>>2]=+g[j+4>>2];g[b+644>>2]=0.0;g[b+648>>2]=u;g[b+652>>2]=t*w-r*x;g[b+656>>2]=+g[j+8>>2];g[b+660>>2]=0.0;g[b+732>>2]=k?-1.0:1.0;return}function Hr(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0,i=0.0,j=0.0,k=0.0,l=0.0;c[b+4>>2]=4;c[b>>2]=352;c[b+8>>2]=-1;c[b+12>>2]=-1;g[b+16>>2]=3402823466385288598117041.0e14;a[b+20>>0]=1;a[b+21>>0]=0;c[b+24>>2]=-1;c[b+28>>2]=d;jr();c[b+32>>2]=3056;g[b+36>>2]=0.0;g[b+40>>2]=.30000001192092896;c[b+44>>2]=0;c[b>>2]=3936;c[b+552>>2]=c[e+0>>2];c[b+556>>2]=c[e+4>>2];c[b+560>>2]=c[e+8>>2];c[b+564>>2]=c[e+12>>2];c[b+568>>2]=c[e+16>>2];c[b+572>>2]=c[e+20>>2];c[b+576>>2]=c[e+24>>2];c[b+580>>2]=c[e+28>>2];c[b+584>>2]=c[e+32>>2];c[b+588>>2]=c[e+36>>2];c[b+592>>2]=c[e+40>>2];c[b+596>>2]=c[e+44>>2];c[b+600>>2]=c[e+48>>2];c[b+604>>2]=c[e+52>>2];c[b+608>>2]=c[e+56>>2];c[b+612>>2]=c[e+60>>2];c[b+616>>2]=c[e+0>>2];c[b+620>>2]=c[e+4>>2];c[b+624>>2]=c[e+8>>2];c[b+628>>2]=c[e+12>>2];c[b+632>>2]=c[e+16>>2];c[b+636>>2]=c[e+20>>2];c[b+640>>2]=c[e+24>>2];c[b+644>>2]=c[e+28>>2];c[b+648>>2]=c[e+32>>2];c[b+652>>2]=c[e+36>>2];c[b+656>>2]=c[e+40>>2];c[b+660>>2]=c[e+44>>2];c[b+664>>2]=c[e+48>>2];c[b+668>>2]=c[e+52>>2];c[b+672>>2]=c[e+56>>2];c[b+676>>2]=c[e+60>>2];g[b+688>>2]=0.0;g[b+692>>2]=-1.0;g[b+696>>2]=.8999999761581421;g[b+700>>2]=.30000001192092896;g[b+704>>2]=1.0;g[b+708>>2]=0.0;g[b+712>>2]=0.0;a[b+716>>0]=0;a[b+736>>0]=0;a[b+737>>0]=0;a[b+738>>0]=0;a[b+739>>0]=1;a[b+740>>0]=f&1;c[b+748>>2]=0;e=c[b+28>>2]|0;l=+g[b+600>>2];k=+g[b+604>>2];j=+g[b+608>>2];i=l*+g[e+20>>2]+k*+g[e+24>>2]+j*+g[e+28>>2]+ +g[e+56>>2];h=l*+g[e+36>>2]+k*+g[e+40>>2]+j*+g[e+44>>2]+ +g[e+60>>2];g[b+664>>2]=l*+g[e+4>>2]+k*+g[e+8>>2]+j*+g[e+12>>2]+ +g[e+52>>2];g[b+668>>2]=i;g[b+672>>2]=h;g[b+676>>2]=0.0;g[b+732>>2]=f?-1.0:1.0;return}function Ir(b){b=b|0;var d=0.0,e=0,f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0,M=0,N=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0;L=i;i=i+176|0;if(!(a[b+738>>0]|0)){i=L;return}g[b+36>>2]=0.0;g[b+744>>2]=0.0;a:do if(!(a[b+736>>0]|0)){f=c[b+28>>2]|0;n=+g[b+600>>2];p=+g[b+604>>2];u=+g[b+608>>2];v=n*+g[f+20>>2]+p*+g[f+24>>2]+u*+g[f+28>>2]+ +g[f+56>>2];e=c[b+32>>2]|0;w=+g[b+664>>2];x=+g[e+4>>2];y=+g[b+668>>2];z=+g[e+8>>2];A=+g[b+672>>2];B=+g[e+12>>2];C=+g[e+20>>2];D=+g[e+24>>2];E=+g[e+28>>2];F=+g[e+36>>2];G=+g[e+40>>2];H=+g[e+44>>2];I=+g[e+52>>2];J=+g[e+56>>2];K=+g[e+60>>2];o=w*C+y*D+A*E+J-v;t=n*+g[f+4>>2]+p*+g[f+8>>2]+u*+g[f+12>>2]+ +g[f+52>>2];u=n*+g[f+36>>2]+p*+g[f+40>>2]+u*+g[f+44>>2]+ +g[f+60>>2];p=w*x+y*z+A*B+I-t;n=w*F+y*G+A*H+K-u;if(p*p+o*o+n*n>1.1920928955078125e-07){s=1.0/+P(+(p*p+o*o+n*n));m=p*s;p=o*s;o=n*s}else{m=1.0;p=0.0;o=0.0}g[L+128>>2]=m;g[L+132>>2]=p;g[L+136>>2]=o;g[L+140>>2]=0.0;if(+O(+o)>.7071067690849304){r=o*o+p*p;s=1.0/+P(+r);n=-(s*o);o=s*p;j=-(m*o);l=m*n;p=r*s;m=0.0}else{r=m*m+p*p;l=1.0/+P(+r);s=-(p*l);n=l*m;j=o*s;l=r*l;p=-(o*n);o=0.0;m=s}g[L+144>>2]=m;g[L+148>>2]=n;g[L+152>>2]=o;g[L+160>>2]=p;g[L+164>>2]=j;g[L+168>>2]=l;p=x;o=C;n=F;m=z;l=D;j=G;h=B;k=E;d=H;q=I;r=J;s=K;f=0;while(1){M=c[b+28>>2]|0;g[L+80>>2]=+g[M+4>>2];g[L+84>>2]=+g[M+20>>2];g[L+88>>2]=+g[M+36>>2];g[L+92>>2]=0.0;g[L+96>>2]=+g[M+8>>2];g[L+100>>2]=+g[M+24>>2];g[L+104>>2]=+g[M+40>>2];g[L+108>>2]=0.0;g[L+112>>2]=+g[M+12>>2];g[L+116>>2]=+g[M+28>>2];g[L+120>>2]=+g[M+44>>2];g[L+124>>2]=0.0;g[L+32>>2]=p;g[L+36>>2]=o;g[L+40>>2]=n;g[L+44>>2]=0.0;g[L+48>>2]=m;g[L+52>>2]=l;g[L+56>>2]=j;g[L+60>>2]=0.0;g[L+64>>2]=h;g[L+68>>2]=k;g[L+72>>2]=d;g[L+76>>2]=0.0;o=v-+g[M+56>>2];p=u-+g[M+60>>2];g[L+16>>2]=t-+g[M+52>>2];g[L+20>>2]=o;g[L+24>>2]=p;g[L+28>>2]=0.0;g[L>>2]=w*x+y*z+A*B+I-q;g[L+4>>2]=w*C+y*D+A*E+J-r;g[L+8>>2]=w*F+y*G+A*H+K-s;g[L+12>>2]=0.0;Tq(b+(f*84|0)+48|0,L+80|0,L+32|0,L+16|0,L,L+128+(f<<4)|0,M+396|0,+g[M+344>>2],e+396|0,+g[e+344>>2]);f=f+1|0;if((f|0)==3)break a;e=c[b+32>>2]|0;p=+g[e+4>>2];o=+g[e+20>>2];n=+g[e+36>>2];m=+g[e+8>>2];l=+g[e+24>>2];j=+g[e+40>>2];h=+g[e+12>>2];k=+g[e+28>>2];d=+g[e+44>>2];q=+g[e+52>>2];r=+g[e+56>>2];s=+g[e+60>>2]}}while(0);d=+g[b+560>>2];j=+g[b+576>>2];k=+g[b+592>>2];if(+O(+k)>.7071067690849304){p=1.0/+P(+(j*j+k*k));h=d*-(k*p);l=0.0;m=-(k*p);n=j*p;o=(j*j+k*k)*p;p=-(d*(j*p))}else{p=1.0/+P(+(d*d+j*j));h=(d*d+j*j)*p;l=-(j*p);m=d*p;n=0.0;o=-(k*(d*p));p=k*-(j*p)}f=c[b+28>>2]|0;C=+g[f+4>>2];q=+g[f+8>>2];H=+g[f+12>>2];R=l*C+m*q+n*H;F=+g[f+20>>2];A=+g[f+24>>2];J=+g[f+28>>2];T=l*F+m*A+n*J;w=+g[f+36>>2];u=+g[f+40>>2];s=+g[f+44>>2];W=l*w+m*u+n*s;t=o*C+p*q+h*H;n=o*F+p*A+h*J;m=o*w+p*u+h*s;e=c[b+32>>2]|0;v=+g[e+4>>2];x=+g[e+20>>2];y=+g[e+36>>2];D=+g[e+8>>2];E=+g[e+24>>2];I=+g[e+40>>2];N=+g[e+12>>2];S=+g[e+28>>2];V=+g[e+44>>2];c[b+300>>2]=0;c[b+304>>2]=0;c[b+308>>2]=0;c[b+312>>2]=0;g[b+316>>2]=C*R+F*T+w*W;g[b+320>>2]=q*R+A*T+u*W;g[b+324>>2]=H*R+J*T+s*W;g[b+328>>2]=0.0;g[b+332>>2]=v*-R+x*-T+y*-W;g[b+336>>2]=D*-R+E*-T+I*-W;g[b+340>>2]=N*-R+S*-T+V*-W;g[b+344>>2]=0.0;r=(C*R+F*T+w*W)*+g[f+396>>2];o=(q*R+A*T+u*W)*+g[f+400>>2];p=(H*R+J*T+s*W)*+g[f+404>>2];g[b+348>>2]=r;g[b+352>>2]=o;g[b+356>>2]=p;g[b+360>>2]=0.0;B=(v*-R+x*-T+y*-W)*+g[e+396>>2];K=(D*-R+E*-T+I*-W)*+g[e+400>>2];X=(N*-R+S*-T+V*-W)*+g[e+404>>2];g[b+364>>2]=B;g[b+368>>2]=K;g[b+372>>2]=X;g[b+376>>2]=0.0;g[b+380>>2]=(C*R+F*T+w*W)*r+(q*R+A*T+u*W)*o+(H*R+J*T+s*W)*p+((v*-R+x*-T+y*-W)*B+(D*-R+E*-T+I*-W)*K+(N*-R+S*-T+V*-W)*X);e=c[b+28>>2]|0;X=+g[e+4>>2];W=+g[e+20>>2];V=+g[e+36>>2];T=+g[e+8>>2];S=+g[e+24>>2];R=+g[e+40>>2];N=+g[e+12>>2];K=+g[e+28>>2];I=+g[e+44>>2];f=c[b+32>>2]|0;E=+g[f+4>>2];D=+g[f+20>>2];B=+g[f+36>>2];y=+g[f+8>>2];x=+g[f+24>>2];v=+g[f+40>>2];p=+g[f+12>>2];o=+g[f+28>>2];r=+g[f+44>>2];c[b+384>>2]=0;c[b+388>>2]=0;c[b+392>>2]=0;c[b+396>>2]=0;g[b+400>>2]=t*X+n*W+m*V;g[b+404>>2]=t*T+n*S+m*R;g[b+408>>2]=t*N+n*K+m*I;g[b+412>>2]=0.0;g[b+416>>2]=E*-t+D*-n+B*-m;g[b+420>>2]=y*-t+x*-n+v*-m;g[b+424>>2]=p*-t+o*-n+r*-m;g[b+428>>2]=0.0;U=(t*X+n*W+m*V)*+g[e+396>>2];Q=(t*T+n*S+m*R)*+g[e+400>>2];G=(t*N+n*K+m*I)*+g[e+404>>2];g[b+432>>2]=U;g[b+436>>2]=Q;g[b+440>>2]=G;g[b+444>>2]=0.0;z=(E*-t+D*-n+B*-m)*+g[f+396>>2];h=(y*-t+x*-n+v*-m)*+g[f+400>>2];l=(p*-t+o*-n+r*-m)*+g[f+404>>2];g[b+448>>2]=z;g[b+452>>2]=h;g[b+456>>2]=l;g[b+460>>2]=0.0;g[b+464>>2]=(t*X+n*W+m*V)*U+(t*T+n*S+m*R)*Q+(t*N+n*K+m*I)*G+((E*-t+D*-n+B*-m)*z+(y*-t+x*-n+v*-m)*h+(p*-t+o*-n+r*-m)*l);f=c[b+28>>2]|0;l=+g[f+4>>2];m=+g[f+20>>2];r=+g[f+36>>2];n=+g[f+8>>2];o=+g[f+24>>2];t=+g[f+40>>2];p=+g[f+12>>2];h=+g[f+28>>2];v=+g[f+44>>2];e=c[b+32>>2]|0;x=+g[e+4>>2];y=+g[e+20>>2];z=+g[e+36>>2];B=+g[e+8>>2];D=+g[e+24>>2];E=+g[e+40>>2];G=+g[e+12>>2];I=+g[e+28>>2];K=+g[e+44>>2];c[b+468>>2]=0;c[b+472>>2]=0;c[b+476>>2]=0;c[b+480>>2]=0;r=(C*d+q*j+H*k)*l+(F*d+A*j+J*k)*m+(w*d+u*j+s*k)*r;t=(C*d+q*j+H*k)*n+(F*d+A*j+J*k)*o+(w*d+u*j+s*k)*t;v=(C*d+q*j+H*k)*p+(F*d+A*j+J*k)*h+(w*d+u*j+s*k)*v;g[b+484>>2]=r;g[b+488>>2]=t;g[b+492>>2]=v;g[b+496>>2]=0.0;H=-(C*d+q*j+H*k);J=-(F*d+A*j+J*k);h=-(w*d+u*j+s*k);g[b+500>>2]=x*H+y*J+z*h;g[b+504>>2]=B*H+D*J+E*h;g[b+508>>2]=G*H+I*J+K*h;g[b+512>>2]=0.0;s=r*+g[f+396>>2];u=t*+g[f+400>>2];w=v*+g[f+404>>2];g[b+516>>2]=s;g[b+520>>2]=u;g[b+524>>2]=w;g[b+528>>2]=0.0;A=(x*H+y*J+z*h)*+g[e+396>>2];F=(B*H+D*J+E*h)*+g[e+400>>2];d=(G*H+I*J+K*h)*+g[e+404>>2];g[b+532>>2]=A;g[b+536>>2]=F;g[b+540>>2]=d;g[b+544>>2]=0.0;g[b+548>>2]=r*s+t*u+v*w+((x*H+y*J+z*h)*A+(B*H+D*J+E*h)*F+(G*H+I*J+K*h)*d);g[b+724>>2]=0.0;e=c[b+28>>2]|0;f=c[b+32>>2]|0;d=+Lr(b,e+4|0,f+4|0);g[b+728>>2]=d;g[b+708>>2]=0.0;g[b+712>>2]=0.0;a[b+716>>0]=0;h=+g[b+692>>2];do if(h>=0.0){d=+$E(d-+g[b+688>>2],6.2831854820251465);if(!(d<-3.1415927410125732)){if(d>3.1415927410125732)d=d+-6.2831854820251465}else d=d+6.2831854820251465;if(d<-h){a[b+716>>0]=1;g[b+708>>2]=-(d+h);g[b+712>>2]=1.0;break}if(d>h){a[b+716>>0]=1;g[b+708>>2]=h-d;g[b+712>>2]=-1.0}}while(0);T=+g[b+560>>2];U=+g[b+576>>2];X=+g[b+592>>2];V=T*+g[e+4>>2]+U*+g[e+8>>2]+X*+g[e+12>>2];W=T*+g[e+20>>2]+U*+g[e+24>>2]+X*+g[e+28>>2];X=T*+g[e+36>>2]+U*+g[e+40>>2]+X*+g[e+44>>2];g[b+720>>2]=1.0/(V*(V*+g[e+264>>2]+W*+g[e+280>>2]+X*+g[e+296>>2])+W*(V*+g[e+268>>2]+W*+g[e+284>>2]+X*+g[e+300>>2])+X*(V*+g[e+272>>2]+W*+g[e+288>>2]+X*+g[e+304>>2])+(V*(V*+g[f+264>>2]+W*+g[f+280>>2]+X*+g[f+296>>2])+W*(V*+g[f+268>>2]+W*+g[f+284>>2]+X*+g[f+300>>2])+X*(V*+g[f+272>>2]+W*+g[f+288>>2]+X*+g[f+304>>2])));i=L;return}function Jr(b,d){b=b|0;d=d|0;var e=0.0,f=0.0,h=0;if(a[b+738>>0]|0){c[d>>2]=0;c[d+4>>2]=0;return}c[d>>2]=5;c[d+4>>2]=1;e=+Lr(b,(c[b+28>>2]|0)+4|0,(c[b+32>>2]|0)+4|0);g[b+728>>2]=e;g[b+708>>2]=0.0;g[b+712>>2]=0.0;a[b+716>>0]=0;f=+g[b+692>>2];do if(f>=0.0){e=+$E(e-+g[b+688>>2],6.2831854820251465);if(!(e<-3.1415927410125732)){if(e>3.1415927410125732)e=e+-6.2831854820251465}else e=e+6.2831854820251465;if(e<-f){a[b+716>>0]=1;g[b+708>>2]=-(e+f);g[b+712>>2]=1.0;break}if(e>f){a[b+716>>0]=1;g[b+708>>2]=f-e;g[b+712>>2]=-1.0}else h=12}else h=12;while(0);if((h|0)==12?(a[b+737>>0]|0)==0:0)return;c[d>>2]=6;c[d+4>>2]=0;return}function Kr(b,d){b=b|0;d=d|0;var e=0.0,f=0.0,h=0,j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0,q=0.0,r=0.0,s=0,t=0,u=0.0,v=0,w=0.0,x=0.0,y=0.0,z=0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0,_=0,$=0,aa=0;$=i;i=i+256|0;Z=c[b+28>>2]|0;_=c[b+32>>2]|0;v=c[d+24>>2]|0;if(!(a[b+739>>0]|0)){rp($+192|0,Z+4|0,b+552|0);rp($+128|0,_+4|0,b+616|0);f=+g[$+240>>2];l=+g[$+244>>2];e=+g[$+248>>2];m=+g[$+176>>2];n=+g[$+180>>2];o=+g[$+184>>2];p=(a[b+736>>0]|0)==0;if(p){h=c[d+8>>2]|0;g[h>>2]=1.0;g[h+(v+1<<2)>>2]=1.0;g[h+((v<<1)+2<<2)>>2]=1.0;h=c[d+16>>2]|0;g[h>>2]=-1.0;g[h+(v+1<<2)>>2]=-1.0;g[h+((v<<1)+2<<2)>>2]=-1.0;h=v<<1;j=v+1|0;k=(v<<1)+2|0}else{h=v<<1;j=v+1|0;k=(v<<1)+2|0}q=f-+g[Z+52>>2];Y=l-+g[Z+56>>2];X=e-+g[Z+60>>2];s=c[d+12>>2]|0;g[s>>2]=0.0;g[s+4>>2]=X;g[s+8>>2]=-Y;g[s+12>>2]=0.0;g[s+(v<<2)>>2]=-X;g[s+(j<<2)>>2]=0.0;g[s+(v+2<<2)>>2]=q;g[s+(v+3<<2)>>2]=0.0;g[s+(h<<2)>>2]=Y;aa=h|1;g[s+(aa<<2)>>2]=-q;g[s+(k<<2)>>2]=0.0;z=h+3|0;g[s+(z<<2)>>2]=0.0;q=m-+g[_+52>>2];Y=n-+g[_+56>>2];X=o-+g[_+60>>2];t=c[d+20>>2]|0;g[t>>2]=0.0;g[t+4>>2]=-X;g[t+8>>2]=Y;g[t+12>>2]=0.0;g[t+(v<<2)>>2]=X;g[t+(j<<2)>>2]=0.0;g[t+(v+2<<2)>>2]=-q;g[t+(v+3<<2)>>2]=0.0;g[t+(h<<2)>>2]=-Y;g[t+(aa<<2)>>2]=q;g[t+(k<<2)>>2]=0.0;g[t+(z<<2)>>2]=0.0;q=+g[d>>2]*+g[d+4>>2];k=c[d+28>>2]|0;if(p){g[k>>2]=q*(m-f);g[k+(v<<2)>>2]=q*(n-l);g[k+(v<<1<<2)>>2]=q*(o-e)}w=+g[$+200>>2];x=+g[$+216>>2];y=+g[$+232>>2];R=+g[$+192>>2];S=+g[$+208>>2];Q=+g[$+224>>2];U=+g[$+196>>2];W=+g[$+212>>2];T=+g[$+228>>2];v=c[d+24>>2]|0;g[s+(v*3<<2)>>2]=R;g[s+((v*3|0)+1<<2)>>2]=S;g[s+((v*3|0)+2<<2)>>2]=Q;g[s+(v<<2<<2)>>2]=U;g[s+((v<<2|1)<<2)>>2]=W;g[s+((v<<2|2)<<2)>>2]=T;g[t+(v*3<<2)>>2]=-R;g[t+((v*3|0)+1<<2)>>2]=-S;g[t+((v*3|0)+2<<2)>>2]=-Q;g[t+(v<<2<<2)>>2]=-U;g[t+((v<<2|1)<<2)>>2]=-W;g[t+((v<<2|2)<<2)>>2]=-T;X=+g[$+136>>2];V=+g[$+152>>2];Y=+g[$+168>>2];g[k+(v*3<<2)>>2]=q*(Q*(w*V-x*X)+(R*(x*Y-y*V)+S*(y*X-w*Y)));g[k+(v<<2<<2)>>2]=q*(T*(w*V-x*X)+(U*(x*Y-y*V)+W*(y*X-w*Y)));if(!(a[b+716>>0]|0)){z=0;u=0.0}else{u=+g[b+708>>2]*+g[b+732>>2];z=u>0.0?1:2}p=a[b+737>>0]|0;h=(z|0)!=0;if(!(p&255|z)){i=$;return}g[s+(v*5<<2)>>2]=w;g[s+((v*5|0)+1<<2)>>2]=x;g[s+((v*5|0)+2<<2)>>2]=y;g[t+(v*5<<2)>>2]=-w;g[t+((v*5|0)+1<<2)>>2]=-x;g[t+((v*5|0)+2<<2)>>2]=-y;e=+g[b+688>>2];l=+g[b+692>>2];f=+$E(e-l,6.2831854820251465);if(!(f<-3.1415927410125732))if(f>3.1415927410125732)r=f+-6.2831854820251465;else r=f;else r=f+6.2831854820251465;f=+$E(e+l,6.2831854820251465);if(!(f<-3.1415927410125732)){if(f>3.1415927410125732)f=f+-6.2831854820251465}else f=f+6.2831854820251465;j=r==f;s=k+(v*5<<2)|0;g[s>>2]=0.0;k=c[b+748>>2]|0;m=+g[((k&2|0)==0?d+4|0:b+760|0)>>2];if(!(h&j|p<<24>>24==0)){if(k&4)g[(c[d+32>>2]|0)+(v*5<<2)>>2]=+g[b+752>>2];o=+g[b+728>>2];n=+g[b+680>>2];p=r>f;do if(!(p|j)){q=n/(m*+g[d>>2]);if(q<0.0)if(o>=r&r-q>o){f=(r-o)/q;break}else{f=o<r?0.0:1.0;break}if(q>0.0)if(o<=f&f-q<o){f=(f-o)/q;break}else{f=o>f?0.0:1.0;break}else f=0.0}else f=p?1.0:0.0;while(0);g[s>>2]=f*n*+g[b+732>>2]+ +g[s>>2];g[(c[d+36>>2]|0)+(v*5<<2)>>2]=-+g[b+684>>2];g[(c[d+40>>2]|0)+(v*5<<2)>>2]=+g[b+684>>2]}if(!h){i=$;return}g[s>>2]=+g[s>>2]+u*(m*+g[d>>2]);if(k&1)g[(c[d+32>>2]|0)+(v*5<<2)>>2]=+g[b+756>>2];do if(!j){h=(c[d+36>>2]|0)+(v*5<<2)|0;if((z|0)==1){g[h>>2]=0.0;g[(c[d+40>>2]|0)+(v*5<<2)>>2]=3402823466385288598117041.0e14;break}else{g[h>>2]=-3402823466385288598117041.0e14;g[(c[d+40>>2]|0)+(v*5<<2)>>2]=0.0;break}}else{g[(c[d+36>>2]|0)+(v*5<<2)>>2]=-3402823466385288598117041.0e14;g[(c[d+40>>2]|0)+(v*5<<2)>>2]=3402823466385288598117041.0e14}while(0);f=+g[b+704>>2];do if(f>0.0){e=w*+g[Z+328>>2]+x*+g[Z+332>>2]+y*+g[Z+336>>2]-(w*+g[_+328>>2]+x*+g[_+332>>2]+y*+g[_+336>>2]);if((z|0)==1){if(!(e<0.0))break;if(!(+g[s>>2]<-(f*e)))break;g[s>>2]=-(f*e);break}else{if(!(e>0.0))break;if(!(+g[s>>2]>-(f*e)))break;g[s>>2]=-(f*e);break}}while(0);g[s>>2]=+g[b+700>>2]*+g[s>>2];i=$;return}rp($+64|0,Z+4|0,b+552|0);rp($,_+4|0,b+616|0);C=+g[$+48>>2];D=+g[$+112>>2];E=+g[$+52>>2];F=+g[$+116>>2];G=+g[$+56>>2];H=+g[$+120>>2];f=+g[(c[b+28>>2]|0)+344>>2];e=+g[(c[b+32>>2]|0)+344>>2];if(f<1.1920928955078125e-07)z=1;else z=e<1.1920928955078125e-07;if(f+e>0.0)B=e/(f+e);else B=.5;l=1.0-B;O=+g[$+72>>2];Q=+g[$+88>>2];R=+g[$+104>>2];S=+g[$+8>>2];T=+g[$+24>>2];U=+g[$+40>>2];V=B*O+l*S;W=B*Q+l*T;X=B*R+l*U;Y=1.0/+P(+(V*V+W*W+X*X));I=C-+g[_+52>>2];n=E-+g[_+56>>2];L=G-+g[_+60>>2];J=V*Y*(I*(V*Y)+n*(W*Y)+L*(X*Y));K=W*Y*(I*(V*Y)+n*(W*Y)+L*(X*Y));M=X*Y*(I*(V*Y)+n*(W*Y)+L*(X*Y));x=D-+g[Z+52>>2];o=F-+g[Z+56>>2];N=H-+g[Z+60>>2];u=V*Y*(V*Y*x+W*Y*o+X*Y*N);y=W*Y*(V*Y*x+W*Y*o+X*Y*N);q=X*Y*(V*Y*x+W*Y*o+X*Y*N);e=x-u+B*(u-J);A=o-y+B*(y-K);r=N-q+B*(q-M);f=I-J-l*(u-J);w=n-K-l*(y-K);m=L-M-l*(q-M);u=B*(I-J)+l*(x-u);y=B*(n-K)+l*(o-y);q=B*(L-M)+l*(N-q);if(u*u+y*y+q*q>1.1920928955078125e-07){L=1.0/+P(+(u*u+y*y+q*q));N=u*L;M=L*y;L=L*q}else{N=+g[$+68>>2];M=+g[$+84>>2];L=+g[$+100>>2]}I=W*Y*L-X*Y*M;J=X*Y*N-L*(V*Y);K=M*(V*Y)-W*Y*N;p=c[d+12>>2]|0;g[p>>2]=A*L-r*M;g[p+4>>2]=r*N-e*L;g[p+8>>2]=e*M-A*N;p=c[d+20>>2]|0;g[p>>2]=-(w*L-m*M);g[p+4>>2]=-(m*N-f*L);g[p+8>>2]=-(f*M-w*N);if(z?(a[b+716>>0]|0)!=0:0){y=l*(w*K-m*J);u=l*(m*I-f*K);q=l*(f*J-w*I);o=B*(A*K-r*J);n=B*(r*I-e*K);x=B*(e*J-A*I)}else{y=w*K-m*J;u=m*I-f*K;q=f*J-w*I;o=A*K-r*J;n=r*I-e*K;x=e*J-A*I}p=c[d+12>>2]|0;g[p+(v<<2)>>2]=o;g[p+(v+1<<2)>>2]=n;g[p+(v+2<<2)>>2]=x;p=c[d+20>>2]|0;g[p+(v<<2)>>2]=-y;g[p+(v+1<<2)>>2]=-u;g[p+(v+2<<2)>>2]=-q;if(z){x=l*(w*(X*Y)-m*(W*Y));n=l*(m*(V*Y)-f*(X*Y));o=l*(f*(W*Y)-w*(V*Y));q=B*(A*(X*Y)-r*(W*Y));u=B*(r*(V*Y)-e*(X*Y));y=B*(e*(W*Y)-A*(V*Y))}else{x=w*(X*Y)-m*(W*Y);n=m*(V*Y)-f*(X*Y);o=f*(W*Y)-w*(V*Y);q=A*(X*Y)-r*(W*Y);u=r*(V*Y)-e*(X*Y);y=e*(W*Y)-A*(V*Y)}j=c[d+12>>2]|0;g[j+(v<<1<<2)>>2]=q;g[j+((v<<1|1)<<2)>>2]=u;g[j+((v<<1)+2<<2)>>2]=y;j=c[d+20>>2]|0;g[j+(v<<1<<2)>>2]=-x;g[j+((v<<1|1)<<2)>>2]=-n;g[j+((v<<1)+2<<2)>>2]=-o;q=+g[d>>2]*+g[d+4>>2];if(!(a[b+736>>0]|0)){s=c[d+8>>2]|0;g[s>>2]=N;g[s+4>>2]=M;g[s+8>>2]=L;s=c[d+8>>2]|0;g[s+(v<<2)>>2]=I;g[s+(v+1<<2)>>2]=J;g[s+(v+2<<2)>>2]=K;s=c[d+8>>2]|0;g[s+(v<<1<<2)>>2]=V*Y;g[s+((v<<1|1)<<2)>>2]=W*Y;g[s+((v<<1)+2<<2)>>2]=X*Y;s=c[d+16>>2]|0;u=-N;g[s>>2]=u;n=-M;g[s+4>>2]=n;o=-L;g[s+8>>2]=o;g[s+(v<<2)>>2]=-I;g[s+(v+1<<2)>>2]=-J;g[s+(v+2<<2)>>2]=-K;g[s+(v<<1<<2)>>2]=-(V*Y);g[s+((v<<1|1)<<2)>>2]=-(W*Y);g[s+((v<<1)+2<<2)>>2]=-(X*Y);s=c[d+28>>2]|0;g[s>>2]=q*((C-D)*N+(E-F)*M+(G-H)*L);g[s+(v<<2)>>2]=q*((C-D)*I+(E-F)*J+(G-H)*K);g[s+(v<<1<<2)>>2]=q*((C-D)*(V*Y)+(E-F)*(W*Y)+(G-H)*(X*Y));q=n;n=-I;m=-J;f=-K;j=c[d+20>>2]|0}else{u=-N;q=-M;o=-L;n=-I;m=-J;f=-K;s=c[d+28>>2]|0}k=c[d+12>>2]|0;g[k+(v*3<<2)>>2]=N;g[k+((v*3|0)+1<<2)>>2]=M;g[k+((v*3|0)+2<<2)>>2]=L;g[k+(v<<2<<2)>>2]=I;g[k+((v<<2|1)<<2)>>2]=J;g[k+((v<<2|2)<<2)>>2]=K;g[j+(v*3<<2)>>2]=u;g[j+((v*3|0)+1<<2)>>2]=q;g[j+((v*3|0)+2<<2)>>2]=o;g[j+(v<<2<<2)>>2]=n;g[j+((v<<2|1)<<2)>>2]=m;g[j+((v<<2|2)<<2)>>2]=f;H=+g[d>>2]*+g[d+4>>2];g[s+(v*3<<2)>>2]=H*((Q*U-R*T)*N+(R*S-O*U)*M+(O*T-Q*S)*L);g[s+(v<<2<<2)>>2]=H*((Q*U-R*T)*I+(R*S-O*U)*J+(O*T-Q*S)*K);if(!(a[b+716>>0]|0)){z=0;u=0.0}else{u=+g[b+708>>2]*+g[b+732>>2];z=u>0.0?1:2}p=a[b+737>>0]|0;t=(z|0)!=0;if(!(p&255|z)){i=$;return}v=(c[d+24>>2]|0)*5|0;g[k+(v<<2)>>2]=V*Y;g[k+(v+1<<2)>>2]=W*Y;g[k+(v+2<<2)>>2]=X*Y;g[j+(v<<2)>>2]=-(V*Y);g[j+(v+1<<2)>>2]=-(W*Y);g[j+(v+2<<2)>>2]=-(X*Y);l=+g[b+688>>2];e=+g[b+692>>2];f=+$E(l-e,6.2831854820251465);if(!(f<-3.1415927410125732))if(f>3.1415927410125732)r=f+-6.2831854820251465;else r=f;else r=f+6.2831854820251465;f=+$E(l+e,6.2831854820251465);if(!(f<-3.1415927410125732)){if(f>3.1415927410125732)f=f+-6.2831854820251465}else f=f+6.2831854820251465;j=r==f;s=s+(v<<2)|0;g[s>>2]=0.0;k=c[b+748>>2]|0;m=+g[((k&2|0)==0?d+4|0:b+760|0)>>2];if(!(t&j|p<<24>>24==0)){if(k&4)g[(c[d+32>>2]|0)+(v<<2)>>2]=+g[b+752>>2];o=+g[b+728>>2];n=+g[b+680>>2];p=r>f;do if(!(p|j)){q=n/(m*+g[d>>2]);if(q<0.0)if(o>=r&r-q>o){f=(r-o)/q;break}else{f=o<r?0.0:1.0;break}if(q>0.0)if(o<=f&f-q<o){f=(f-o)/q;break}else{f=o>f?0.0:1.0;break}else f=0.0}else f=p?1.0:0.0;while(0);g[s>>2]=f*n*+g[b+732>>2]+ +g[s>>2];g[(c[d+36>>2]|0)+(v<<2)>>2]=-+g[b+684>>2];g[(c[d+40>>2]|0)+(v<<2)>>2]=+g[b+684>>2]}if(!t){i=$;return}g[s>>2]=+g[s>>2]+u*(m*+g[d>>2]);if(k&1)g[(c[d+32>>2]|0)+(v<<2)>>2]=+g[b+756>>2];do if(!j){h=(c[d+36>>2]|0)+(v<<2)|0;if((z|0)==1){g[h>>2]=0.0;g[(c[d+40>>2]|0)+(v<<2)>>2]=3402823466385288598117041.0e14;break}else{g[h>>2]=-3402823466385288598117041.0e14;g[(c[d+40>>2]|0)+(v<<2)>>2]=0.0;break}}else{g[(c[d+36>>2]|0)+(v<<2)>>2]=-3402823466385288598117041.0e14;g[(c[d+40>>2]|0)+(v<<2)>>2]=3402823466385288598117041.0e14}while(0);f=+g[b+704>>2];do if(f>0.0){e=+g[Z+328>>2]*(V*Y)+ +g[Z+332>>2]*(W*Y)+ +g[Z+336>>2]*(X*Y)-(V*Y*+g[_+328>>2]+W*Y*+g[_+332>>2]+X*Y*+g[_+336>>2]);if((z|0)==1){if(!(e<0.0))break;if(!(+g[s>>2]<-(f*e)))break;g[s>>2]=-(f*e);break}else{if(!(e>0.0))break;if(!(+g[s>>2]>-(f*e)))break;g[s>>2]=-(f*e);break}}while(0);g[s>>2]=+g[b+700>>2]*+g[s>>2];i=$;return}function Lr(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0;v=+g[a+552>>2];u=+g[a+568>>2];t=+g[a+584>>2];s=+g[b>>2];r=+g[b+4>>2];q=+g[b+8>>2];o=+g[b+16>>2];n=+g[b+20>>2];m=+g[b+24>>2];k=+g[b+32>>2];i=+g[b+36>>2];f=+g[b+40>>2];j=+g[a+556>>2];h=+g[a+572>>2];e=+g[a+588>>2];x=+g[a+620>>2];w=+g[a+636>>2];d=+g[a+652>>2];p=x*+g[c>>2]+w*+g[c+4>>2]+d*+g[c+8>>2];l=x*+g[c+16>>2]+w*+g[c+20>>2]+d*+g[c+24>>2];d=x*+g[c+32>>2]+w*+g[c+36>>2]+d*+g[c+40>>2];d=+X(+((v*s+u*r+t*q)*p+(v*o+u*n+t*m)*l+(v*k+u*i+t*f)*d),+((s*j+r*h+q*e)*p+(o*j+n*h+m*e)*l+(k*j+i*h+f*e)*d));return +(d*+g[a+732>>2])}function Mr(a,b,d,e){a=a|0;b=b|0;d=+d;e=e|0;if(!((e|0)==5|(e|0)==-1))return;if((b|0)==2){g[a+760>>2]=d;c[a+748>>2]=c[a+748>>2]|2;return}else if((b|0)==4){g[a+756>>2]=d;c[a+748>>2]=c[a+748>>2]|1;return}else if((b|0)==3){g[a+752>>2]=d;c[a+748>>2]=c[a+748>>2]|4;return}else return}function Nr(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0;do if((c|0)==5|(c|0)==-1)if((b|0)==4){d=+g[a+756>>2];break}else if((b|0)==3){d=+g[a+752>>2];break}else if((b|0)==2){d=+g[a+760>>2];break}else{d=0.0;break}else d=0.0;while(0);return +d}function Or(a,b,e){a=a|0;b=b|0;e=e|0;var f=0.0,h=0.0,i=0.0;kr(a,b,e)|0;g[b+52>>2]=+g[a+552>>2];g[b+56>>2]=+g[a+556>>2];g[b+60>>2]=+g[a+560>>2];g[b+64>>2]=+g[a+564>>2];g[b+68>>2]=+g[a+568>>2];g[b+72>>2]=+g[a+572>>2];g[b+76>>2]=+g[a+576>>2];g[b+80>>2]=+g[a+580>>2];g[b+84>>2]=+g[a+584>>2];g[b+88>>2]=+g[a+588>>2];g[b+92>>2]=+g[a+592>>2];g[b+96>>2]=+g[a+596>>2];g[b+100>>2]=+g[a+600>>2];g[b+104>>2]=+g[a+604>>2];g[b+108>>2]=+g[a+608>>2];g[b+112>>2]=+g[a+612>>2];g[b+116>>2]=+g[a+616>>2];g[b+120>>2]=+g[a+620>>2];g[b+124>>2]=+g[a+624>>2];g[b+128>>2]=+g[a+628>>2];g[b+132>>2]=+g[a+632>>2];g[b+136>>2]=+g[a+636>>2];g[b+140>>2]=+g[a+640>>2];g[b+144>>2]=+g[a+644>>2];g[b+148>>2]=+g[a+648>>2];g[b+152>>2]=+g[a+652>>2];g[b+156>>2]=+g[a+656>>2];g[b+160>>2]=+g[a+660>>2];g[b+164>>2]=+g[a+664>>2];g[b+168>>2]=+g[a+668>>2];g[b+172>>2]=+g[a+672>>2];g[b+176>>2]=+g[a+676>>2];c[b+184>>2]=d[a+736>>0];c[b+188>>2]=d[a+737>>0];g[b+196>>2]=+g[a+684>>2];g[b+192>>2]=+g[a+680>>2];c[b+180>>2]=d[a+740>>0];h=+g[a+688>>2];i=+g[a+692>>2];f=+$E(h-i,6.2831854820251465);if(!(f<-3.1415927410125732)){if(f>3.1415927410125732)f=f+-6.2831854820251465}else f=f+6.2831854820251465;g[b+200>>2]=f;f=+$E(h+i,6.2831854820251465);if(f<-3.1415927410125732){i=f+6.2831854820251465;e=b+204|0;g[e>>2]=i;e=a+696|0;i=+g[e>>2];e=b+208|0;g[e>>2]=i;e=a+700|0;i=+g[e>>2];e=b+212|0;g[e>>2]=i;a=a+704|0;i=+g[a>>2];a=b+216|0;g[a>>2]=i;return 4024}if(!(f>3.1415927410125732)){i=f;e=b+204|0;g[e>>2]=i;e=a+696|0;i=+g[e>>2];e=b+208|0;g[e>>2]=i;e=a+700|0;i=+g[e>>2];e=b+212|0;g[e>>2]=i;a=a+704|0;i=+g[a>>2];a=b+216|0;g[a>>2]=i;return 4024}i=f+-6.2831854820251465;e=b+204|0;g[e>>2]=i;e=a+696|0;i=+g[e>>2];e=b+208|0;g[e>>2]=i;e=a+700|0;i=+g[e>>2];e=b+212|0;g[e>>2]=i;a=a+704|0;i=+g[a>>2];a=b+216|0;g[a>>2]=i;return 4024}function Pr(a){a=a|0;return 220}function Qr(a){a=a|0;if(!a)return;c[5134]=(c[5134]|0)+1;_E(c[a+-4>>2]|0);return}function Rr(b){b=b|0;var d=0;c[b>>2]=4072;d=c[b+176>>2]|0;if(d){if(a[b+180>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+176>>2]=0}a[b+180>>0]=1;c[b+176>>2]=0;c[b+168>>2]=0;c[b+172>>2]=0;d=c[b+156>>2]|0;if(d){if(a[b+160>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+156>>2]=0}a[b+160>>0]=1;c[b+156>>2]=0;c[b+148>>2]=0;c[b+152>>2]=0;d=c[b+136>>2]|0;if(d){if(a[b+140>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+136>>2]=0}a[b+140>>0]=1;c[b+136>>2]=0;c[b+128>>2]=0;c[b+132>>2]=0;d=c[b+116>>2]|0;if(d){if(a[b+120>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+116>>2]=0}a[b+120>>0]=1;c[b+116>>2]=0;c[b+108>>2]=0;c[b+112>>2]=0;d=c[b+96>>2]|0;if(d){if(a[b+100>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=0;c[b+88>>2]=0;c[b+92>>2]=0;d=c[b+76>>2]|0;if(d){if(a[b+80>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+76>>2]=0}a[b+80>>0]=1;c[b+76>>2]=0;c[b+68>>2]=0;c[b+72>>2]=0;d=c[b+56>>2]|0;if(d){if(a[b+60>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+56>>2]=0}a[b+60>>0]=1;c[b+56>>2]=0;c[b+48>>2]=0;c[b+52>>2]=0;d=c[b+36>>2]|0;if(d){if(a[b+40>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;d=c[b+16>>2]|0;if(!d){a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;b=b+12|0;c[b>>2]=0;return}if(a[b+20>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+16>>2]=0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;b=b+12|0;c[b>>2]=0;return}function Sr(a){a=a|0;Rr(a);if(!a)return;c[5134]=(c[5134]|0)+1;_E(c[a+-4>>2]|0);return}function Tr(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;h=+g[d+100>>2];k=+g[d+16>>2];i=+g[d+20>>2];j=+g[d+24>>2];e=+g[d+108>>2];e=+g[d+112>>2]-h*+g[d+116>>2]-(k*+g[a+64>>2]+i*+g[a+68>>2]+j*+g[a+72>>2]+(+g[d>>2]*+g[a+80>>2]+ +g[d+4>>2]*+g[a+84>>2]+ +g[d+8>>2]*+g[a+88>>2]))*e-e*(+g[d+48>>2]*+g[b+64>>2]+ +g[d+52>>2]*+g[b+68>>2]+ +g[d+56>>2]*+g[b+72>>2]+(+g[d+32>>2]*+g[b+80>>2]+ +g[d+36>>2]*+g[b+84>>2]+ +g[d+40>>2]*+g[b+88>>2]));f=+g[d+120>>2];do if(!(h+e<f)){f=+g[d+124>>2];if(h+e>f){g[d+100>>2]=f;e=f-h;break}else{g[d+100>>2]=h+e;break}}else{g[d+100>>2]=f;e=f-h}while(0);if(c[a+240>>2]|0){i=e*(i*+g[a+132>>2])*+g[a+116>>2];j=e*(j*+g[a+136>>2])*+g[a+120>>2];g[a+64>>2]=+g[a+112>>2]*(e*(k*+g[a+128>>2]))+ +g[a+64>>2];g[a+68>>2]=i+ +g[a+68>>2];g[a+72>>2]=j+ +g[a+72>>2];j=e*+g[a+100>>2]*+g[d+68>>2];k=e*+g[a+104>>2]*+g[d+72>>2];g[a+80>>2]=e*+g[a+96>>2]*+g[d+64>>2]+ +g[a+80>>2];g[a+84>>2]=j+ +g[a+84>>2];g[a+88>>2]=k+ +g[a+88>>2]}if(!(c[b+240>>2]|0))return;k=e*(+g[d+52>>2]*+g[b+132>>2])*+g[b+116>>2];j=e*(+g[d+56>>2]*+g[b+136>>2])*+g[b+120>>2];g[b+64>>2]=+g[b+112>>2]*(e*(+g[d+48>>2]*+g[b+128>>2]))+ +g[b+64>>2];g[b+68>>2]=k+ +g[b+68>>2];g[b+72>>2]=j+ +g[b+72>>2];j=e*+g[b+100>>2]*+g[d+84>>2];k=e*+g[b+104>>2]*+g[d+88>>2];g[b+80>>2]=e*+g[b+96>>2]*+g[d+80>>2]+ +g[b+80>>2];g[b+84>>2]=j+ +g[b+84>>2];g[b+88>>2]=k+ +g[b+88>>2];return}function Ur(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0;f=+g[d+100>>2];k=+g[d+16>>2];i=+g[d+20>>2];j=+g[d+24>>2];h=+g[d+108>>2];h=+g[d+112>>2]-f*+g[d+116>>2]-(k*+g[a+64>>2]+i*+g[a+68>>2]+j*+g[a+72>>2]+(+g[d>>2]*+g[a+80>>2]+ +g[d+4>>2]*+g[a+84>>2]+ +g[d+8>>2]*+g[a+88>>2]))*h-h*(+g[d+48>>2]*+g[b+64>>2]+ +g[d+52>>2]*+g[b+68>>2]+ +g[d+56>>2]*+g[b+72>>2]+(+g[d+32>>2]*+g[b+80>>2]+ +g[d+36>>2]*+g[b+84>>2]+ +g[d+40>>2]*+g[b+88>>2]));e=+g[d+120>>2];if(f+h<e)l=e-f;else{l=h;e=f+h}g[d+100>>2]=e;if(c[a+240>>2]|0){i=l*(i*+g[a+132>>2])*+g[a+116>>2];j=l*(j*+g[a+136>>2])*+g[a+120>>2];g[a+64>>2]=+g[a+112>>2]*(l*(k*+g[a+128>>2]))+ +g[a+64>>2];g[a+68>>2]=i+ +g[a+68>>2];g[a+72>>2]=j+ +g[a+72>>2];j=l*+g[a+100>>2]*+g[d+68>>2];k=l*+g[a+104>>2]*+g[d+72>>2];g[a+80>>2]=l*+g[a+96>>2]*+g[d+64>>2]+ +g[a+80>>2];g[a+84>>2]=j+ +g[a+84>>2];g[a+88>>2]=k+ +g[a+88>>2]}if(!(c[b+240>>2]|0))return;k=l*(+g[d+52>>2]*+g[b+132>>2])*+g[b+116>>2];j=l*(+g[d+56>>2]*+g[b+136>>2])*+g[b+120>>2];g[b+64>>2]=+g[b+112>>2]*(l*(+g[d+48>>2]*+g[b+128>>2]))+ +g[b+64>>2];g[b+68>>2]=k+ +g[b+68>>2];g[b+72>>2]=j+ +g[b+72>>2];j=l*+g[b+100>>2]*+g[d+84>>2];k=l*+g[b+104>>2]*+g[d+88>>2];g[b+80>>2]=l*+g[b+96>>2]*+g[d+80>>2]+ +g[b+80>>2];g[b+84>>2]=j+ +g[b+84>>2];g[b+88>>2]=k+ +g[b+88>>2];return}function Vr(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0;e=+g[d+128>>2];if(!(e!=0.0))return;c[1014]=(c[1014]|0)+1;h=+g[d+96>>2];j=+g[d+16>>2];k=+g[d+20>>2];l=+g[d+24>>2];f=+g[d+108>>2];f=e-h*+g[d+116>>2]-(j*+g[a+144>>2]+k*+g[a+148>>2]+l*+g[a+152>>2]+(+g[d>>2]*+g[a+160>>2]+ +g[d+4>>2]*+g[a+164>>2]+ +g[d+8>>2]*+g[a+168>>2]))*f-f*(+g[d+48>>2]*+g[b+144>>2]+ +g[d+52>>2]*+g[b+148>>2]+ +g[d+56>>2]*+g[b+152>>2]+(+g[d+32>>2]*+g[b+160>>2]+ +g[d+36>>2]*+g[b+164>>2]+ +g[d+40>>2]*+g[b+168>>2]));e=+g[d+120>>2];if(h+f<e)i=e-h;else{i=f;e=h+f}g[d+96>>2]=e;if(c[a+240>>2]|0){h=i*(k*+g[a+132>>2])*+g[a+116>>2];k=i*(l*+g[a+136>>2])*+g[a+120>>2];g[a+144>>2]=+g[a+112>>2]*(i*(j*+g[a+128>>2]))+ +g[a+144>>2];g[a+148>>2]=h+ +g[a+148>>2];g[a+152>>2]=k+ +g[a+152>>2];k=i*+g[a+100>>2]*+g[d+68>>2];l=i*+g[a+104>>2]*+g[d+72>>2];g[a+160>>2]=i*+g[a+96>>2]*+g[d+64>>2]+ +g[a+160>>2];g[a+164>>2]=k+ +g[a+164>>2];g[a+168>>2]=l+ +g[a+168>>2]}if(!(c[b+240>>2]|0))return;l=i*(+g[d+52>>2]*+g[b+132>>2])*+g[b+116>>2];k=i*(+g[d+56>>2]*+g[b+136>>2])*+g[b+120>>2];g[b+144>>2]=+g[b+112>>2]*(i*(+g[d+48>>2]*+g[b+128>>2]))+ +g[b+144>>2];g[b+148>>2]=l+ +g[b+148>>2];g[b+152>>2]=k+ +g[b+152>>2];k=i*+g[b+100>>2]*+g[d+84>>2];l=i*+g[b+104>>2]*+g[d+88>>2];g[b+160>>2]=i*+g[b+96>>2]*+g[d+80>>2]+ +g[b+160>>2];g[b+164>>2]=k+ +g[b+164>>2];g[b+168>>2]=l+ +g[b+168>>2];return}function Wr(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0,m=0;if(!b)b=0;else b=(c[b+236>>2]&2|0)==0?0:b;c[a+64>>2]=0;c[a+68>>2]=0;c[a+72>>2]=0;c[a+76>>2]=0;c[a+80>>2]=0;c[a+84>>2]=0;c[a+88>>2]=0;c[a+92>>2]=0;c[a+144>>2]=0;c[a+148>>2]=0;c[a+152>>2]=0;c[a+156>>2]=0;c[a+160>>2]=0;c[a+164>>2]=0;c[a+168>>2]=0;c[a+172>>2]=0;if(!b){g[a>>2]=1.0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;c[a+16>>2]=0;g[a+20>>2]=1.0;c[a+24>>2]=0;c[a+28>>2]=0;c[a+32>>2]=0;c[a+36>>2]=0;g[a+40>>2]=1.0;c[a+44>>2]=0;c[a+48>>2]=0;c[a+52>>2]=0;c[a+56>>2]=0;c[a+60>>2]=0;c[a+240>>2]=0;c[a+128>>2]=0;c[a+132>>2]=0;c[a+136>>2]=0;c[a+140>>2]=0;g[a+96>>2]=1.0;g[a+100>>2]=1.0;g[a+104>>2]=1.0;g[a+108>>2]=0.0;g[a+112>>2]=1.0;g[a+116>>2]=1.0;g[a+120>>2]=1.0;g[a+124>>2]=0.0;b=a+176|0;e=b+60|0;do{c[b>>2]=0;b=b+4|0}while((b|0)<(e|0));a=a+236|0;g[a>>2]=0.0;return}else{e=b+4|0;c[a+0>>2]=c[e+0>>2];c[a+4>>2]=c[e+4>>2];c[a+8>>2]=c[e+8>>2];c[a+12>>2]=c[e+12>>2];e=b+20|0;c[a+16>>2]=c[e+0>>2];c[a+20>>2]=c[e+4>>2];c[a+24>>2]=c[e+8>>2];c[a+28>>2]=c[e+12>>2];e=b+36|0;c[a+32>>2]=c[e+0>>2];c[a+36>>2]=c[e+4>>2];c[a+40>>2]=c[e+8>>2];c[a+44>>2]=c[e+12>>2];e=b+52|0;c[a+48>>2]=c[e+0>>2];c[a+52>>2]=c[e+4>>2];c[a+56>>2]=c[e+8>>2];c[a+60>>2]=c[e+12>>2];e=b+344|0;k=+g[e>>2];l=b+348|0;j=k*+g[b+352>>2];i=k*+g[b+356>>2];g[a+128>>2]=k*+g[l>>2];g[a+132>>2]=j;g[a+136>>2]=i;g[a+140>>2]=0.0;c[a+240>>2]=b;m=b+544|0;c[a+96>>2]=c[m+0>>2];c[a+100>>2]=c[m+4>>2];c[a+104>>2]=c[m+8>>2];c[a+108>>2]=c[m+12>>2];c[a+112>>2]=c[l+0>>2];c[a+116>>2]=c[l+4>>2];c[a+120>>2]=c[l+8>>2];c[a+124>>2]=c[l+12>>2];l=b+312|0;c[a+176>>2]=c[l+0>>2];c[a+180>>2]=c[l+4>>2];c[a+184>>2]=c[l+8>>2];c[a+188>>2]=c[l+12>>2];l=b+328|0;c[a+192>>2]=c[l+0>>2];c[a+196>>2]=c[l+4>>2];c[a+200>>2]=c[l+8>>2];c[a+204>>2]=c[l+12>>2];i=+g[e>>2];j=i*+g[b+416>>2]*d;k=i*+g[b+420>>2]*d;g[a+208>>2]=i*+g[b+412>>2]*d;g[a+212>>2]=j;g[a+216>>2]=k;g[a+220>>2]=0.0;k=+g[b+428>>2];j=+g[b+432>>2];i=+g[b+436>>2];h=(k*+g[b+268>>2]+j*+g[b+284>>2]+i*+g[b+300>>2])*d;f=(k*+g[b+272>>2]+j*+g[b+288>>2]+i*+g[b+304>>2])*d;g[a+224>>2]=(+g[b+264>>2]*k+ +g[b+280>>2]*j+ +g[b+296>>2]*i)*d;g[a+228>>2]=h;g[a+232>>2]=f;a=a+236|0;g[a>>2]=0.0;return}}function Xr(a,b){a=a|0;b=b|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0;if(!a)return;if(!(c[a+180>>2]&1))return;p=+g[a+4>>2];r=+g[b>>2];m=+g[a+20>>2];q=+g[b+4>>2];j=+g[a+36>>2];d=+g[b+8>>2];o=+g[a+8>>2];l=+g[a+24>>2];h=+g[a+40>>2];n=+g[a+12>>2];k=+g[a+28>>2];e=+g[a+44>>2];i=(p*r+m*q+j*d)*+g[a+164>>2];f=(r*o+q*l+d*h)*+g[a+168>>2];d=(r*n+q*k+d*e)*+g[a+172>>2];g[b>>2]=p*i+o*f+n*d;g[b+4>>2]=m*i+l*f+k*d;g[b+8>>2]=j*i+h*f+e*d;g[b+12>>2]=0.0;return}function Yr(b,d,e,f,h,i,j,k,l,m,n){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;j=j|0;k=k|0;l=+l;m=+m;n=+n;var o=0,p=0,q=0.0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0,M=0.0,N=0.0,O=0.0,P=0.0;L=c[b+68>>2]|0;if((L|0)==(c[b+72>>2]|0)?(s=(L|0)==0?1:L<<1,(L|0)<(s|0)):0){if(!s){o=0;p=L}else{c[5132]=(c[5132]|0)+1;o=ZE((s*152|3)+16|0)|0;if(!o)o=0;else{c[(o+19&-16)+-4>>2]=o;o=o+19&-16}p=c[b+68>>2]|0}if((p|0)>0){r=0;do{fF(o+(r*152|0)|0,(c[b+76>>2]|0)+(r*152|0)|0,152)|0;r=r+1|0}while((r|0)!=(p|0))}p=c[b+76>>2]|0;if(p){if(a[b+80>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[p+-4>>2]|0)}c[b+76>>2]=0}a[b+80>>0]=1;c[b+76>>2]=o;c[b+72>>2]=s;o=c[b+68>>2]|0}else o=L;c[b+68>>2]=o+1;p=c[b+76>>2]|0;c[p+(L*152|0)+140>>2]=h;s=c[b+16>>2]|0;b=c[s+(e*244|0)+240>>2]|0;r=c[s+(f*244|0)+240>>2]|0;c[p+(L*152|0)+144>>2]=e;c[p+(L*152|0)+148>>2]=f;K=+g[i+84>>2];g[p+(L*152|0)+104>>2]=K;c[p+(L*152|0)+132>>2]=0;g[p+(L*152|0)+100>>2]=0.0;g[p+(L*152|0)+96>>2]=0.0;if(b){c[p+(L*152|0)+16>>2]=c[d+0>>2];c[p+(L*152|0)+20>>2]=c[d+4>>2];c[p+(L*152|0)+24>>2]=c[d+8>>2];c[p+(L*152|0)+28>>2]=c[d+12>>2];J=+g[j+4>>2];C=+g[p+(L*152|0)+24>>2];G=+g[j+8>>2];H=+g[p+(L*152|0)+20>>2];D=+g[p+(L*152|0)+16>>2];I=+g[j>>2];g[p+(L*152|0)>>2]=J*C-G*H;g[p+(L*152|0)+4>>2]=G*D-C*I;g[p+(L*152|0)+8>>2]=H*I-J*D;g[p+(L*152|0)+12>>2]=0.0;u=((J*C-G*H)*+g[b+264>>2]+ +g[b+268>>2]*(G*D-C*I)+(H*I-J*D)*+g[b+272>>2])*+g[b+544>>2];w=((J*C-G*H)*+g[b+280>>2]+(G*D-C*I)*+g[b+284>>2]+(H*I-J*D)*+g[b+288>>2])*+g[b+548>>2];v=((J*C-G*H)*+g[b+296>>2]+(G*D-C*I)*+g[b+300>>2]+(H*I-J*D)*+g[b+304>>2])*+g[b+552>>2];g[p+(L*152|0)+64>>2]=u;g[p+(L*152|0)+68>>2]=w;g[p+(L*152|0)+72>>2]=v;g[p+(L*152|0)+76>>2]=0.0;y=D;z=H;A=C;B=J*C-G*H;C=G*D-C*I;D=H*I-J*D}else{c[p+(L*152|0)+64>>2]=0;c[p+(L*152|0)+68>>2]=0;c[p+(L*152|0)+72>>2]=0;c[p+(L*152|0)+76>>2]=0;c[p+(L*152|0)+0>>2]=0;c[p+(L*152|0)+4>>2]=0;c[p+(L*152|0)+8>>2]=0;c[p+(L*152|0)+12>>2]=0;c[p+(L*152|0)+16>>2]=0;c[p+(L*152|0)+20>>2]=0;c[p+(L*152|0)+24>>2]=0;c[p+(L*152|0)+28>>2]=0;w=0.0;v=0.0;u=0.0;y=0.0;z=0.0;A=0.0;B=0.0;C=0.0;D=0.0}if(r){J=-+g[d>>2];N=-+g[d+4>>2];I=-+g[d+8>>2];g[p+(L*152|0)+48>>2]=J;g[p+(L*152|0)+52>>2]=N;g[p+(L*152|0)+56>>2]=I;g[p+(L*152|0)+60>>2]=0.0;M=+g[k+4>>2];P=+g[k+8>>2];O=+g[k>>2];g[p+(L*152|0)+32>>2]=M*I-P*N;g[p+(L*152|0)+36>>2]=P*J-O*I;g[p+(L*152|0)+40>>2]=O*N-M*J;g[p+(L*152|0)+44>>2]=0.0;t=((M*I-P*N)*+g[r+264>>2]+ +g[r+268>>2]*(P*J-O*I)+(O*N-M*J)*+g[r+272>>2])*+g[r+544>>2];q=((M*I-P*N)*+g[r+280>>2]+(P*J-O*I)*+g[r+284>>2]+(O*N-M*J)*+g[r+288>>2])*+g[r+548>>2];x=((M*I-P*N)*+g[r+296>>2]+(P*J-O*I)*+g[r+300>>2]+(O*N-M*J)*+g[r+304>>2])*+g[r+552>>2];g[p+(L*152|0)+80>>2]=t;g[p+(L*152|0)+84>>2]=q;g[p+(L*152|0)+88>>2]=x;g[p+(L*152|0)+92>>2]=0.0;E=J;F=N;G=I;H=M*I-P*N;I=P*J-O*I;J=O*N-M*J}else{c[p+(L*152|0)+80>>2]=0;c[p+(L*152|0)+84>>2]=0;c[p+(L*152|0)+88>>2]=0;c[p+(L*152|0)+92>>2]=0;c[p+(L*152|0)+32>>2]=0;c[p+(L*152|0)+36>>2]=0;c[p+(L*152|0)+40>>2]=0;c[p+(L*152|0)+44>>2]=0;c[p+(L*152|0)+48>>2]=0;c[p+(L*152|0)+52>>2]=0;c[p+(L*152|0)+56>>2]=0;c[p+(L*152|0)+60>>2]=0;t=0.0;q=0.0;x=0.0;E=0.0;F=0.0;G=0.0;H=0.0;I=0.0;J=0.0}if(b){N=+g[j+8>>2];O=+g[j+4>>2];P=+g[j>>2];w=+g[b+344>>2]+((w*N-v*O)*+g[d>>2]+(v*P-N*u)*+g[d+4>>2]+(O*u-w*P)*+g[d+8>>2])}else w=0.0;if(r){O=-t;q=-q;x=-x;M=+g[k+8>>2];N=+g[k+4>>2];P=+g[k>>2];q=+g[r+344>>2]+((M*q-N*x)*+g[d>>2]+(P*x-M*O)*+g[d+4>>2]+(N*O-P*q)*+g[d+8>>2])}else q=0.0;w=l/(w+q);g[p+(L*152|0)+108>>2]=w;if(b){t=+g[s+(e*244|0)+192>>2];u=+g[s+(e*244|0)+196>>2];v=+g[s+(e*244|0)+200>>2];q=(+g[s+(e*244|0)+176>>2]+ +g[s+(e*244|0)+208>>2])*y+(+g[s+(e*244|0)+180>>2]+ +g[s+(e*244|0)+212>>2])*z+(+g[s+(e*244|0)+184>>2]+ +g[s+(e*244|0)+216>>2])*A}else{t=0.0;u=0.0;v=0.0;q=y*0.0+z*0.0+A*0.0}q=q+(t*B+u*C+v*D);if(r){l=+g[s+(f*244|0)+192>>2];N=+g[s+(f*244|0)+196>>2];P=+g[s+(f*244|0)+200>>2];O=(+g[s+(f*244|0)+176>>2]+ +g[s+(f*244|0)+208>>2])*E+(+g[s+(f*244|0)+180>>2]+ +g[s+(f*244|0)+212>>2])*F+(+g[s+(f*244|0)+184>>2]+ +g[s+(f*244|0)+216>>2])*G;l=l*H;N=N*I;N=l+N;P=P*J;P=N+P;P=O+P;P=q+P;P=m-P;P=w*P;f=p+(L*152|0)+112|0;g[f>>2]=P;f=p+(L*152|0)+116|0;g[f>>2]=n;P=-K;f=p+(L*152|0)+120|0;g[f>>2]=P;f=p+(L*152|0)+124|0;g[f>>2]=K;return}else{l=0.0;N=0.0;P=0.0;O=E*0.0+F*0.0+G*0.0;l=l*H;N=N*I;N=l+N;P=P*J;P=N+P;P=O+P;P=q+P;P=m-P;P=w*P;f=p+(L*152|0)+112|0;g[f>>2]=P;f=p+(L*152|0)+116|0;g[f>>2]=n;P=-K;f=p+(L*152|0)+120|0;g[f>>2]=P;f=p+(L*152|0)+124|0;g[f>>2]=K;return}}function Zr(b,d,e,f,h,i){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;var j=0,k=0,l=0.0,m=0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0;A=c[b+88>>2]|0;if((A|0)==(c[b+92>>2]|0)?(n=(A|0)==0?1:A<<1,(A|0)<(n|0)):0){if(!n){j=0;k=A}else{c[5132]=(c[5132]|0)+1;j=ZE((n*152|3)+16|0)|0;if(!j)j=0;else{c[(j+19&-16)+-4>>2]=j;j=j+19&-16}k=c[b+88>>2]|0}if((k|0)>0){m=0;do{fF(j+(m*152|0)|0,(c[b+96>>2]|0)+(m*152|0)|0,152)|0;m=m+1|0}while((m|0)!=(k|0))}k=c[b+96>>2]|0;if(k){if(a[b+100>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[k+-4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=j;c[b+92>>2]=n;j=c[b+88>>2]|0}else j=A;c[b+88>>2]=j+1;m=c[b+96>>2]|0;c[m+(A*152|0)+140>>2]=h;c[m+(A*152|0)+16>>2]=0;c[m+(A*152|0)+20>>2]=0;c[m+(A*152|0)+24>>2]=0;c[m+(A*152|0)+28>>2]=0;g[m+(A*152|0)+48>>2]=-0.0;g[m+(A*152|0)+52>>2]=-0.0;g[m+(A*152|0)+56>>2]=-0.0;g[m+(A*152|0)+60>>2]=0.0;h=c[b+16>>2]|0;b=c[h+(e*244|0)+240>>2]|0;n=c[h+(f*244|0)+240>>2]|0;c[m+(A*152|0)+144>>2]=e;c[m+(A*152|0)+148>>2]=f;z=+g[i+88>>2];g[m+(A*152|0)+104>>2]=z;c[m+(A*152|0)+132>>2]=0;g[m+(A*152|0)+100>>2]=0.0;g[m+(A*152|0)+96>>2]=0.0;w=-+g[d>>2];x=-+g[d+4>>2];y=-+g[d+8>>2];g[m+(A*152|0)>>2]=w;g[m+(A*152|0)+4>>2]=x;g[m+(A*152|0)+8>>2]=y;g[m+(A*152|0)+12>>2]=0.0;if(b){l=(+g[b+264>>2]*w+ +g[b+268>>2]*x+ +g[b+272>>2]*y)*+g[b+544>>2];o=(+g[b+280>>2]*w+ +g[b+284>>2]*x+ +g[b+288>>2]*y)*+g[b+548>>2];p=(+g[b+296>>2]*w+ +g[b+300>>2]*x+ +g[b+304>>2]*y)*+g[b+552>>2]}else{l=0.0;o=0.0;p=0.0}g[m+(A*152|0)+64>>2]=l;g[m+(A*152|0)+68>>2]=o;g[m+(A*152|0)+72>>2]=p;g[m+(A*152|0)+76>>2]=0.0;t=+g[d>>2];u=+g[d+4>>2];v=+g[d+8>>2];s=+g[d+12>>2];g[m+(A*152|0)+32>>2]=t;g[m+(A*152|0)+36>>2]=u;g[m+(A*152|0)+40>>2]=v;g[m+(A*152|0)+44>>2]=s;if(n){p=(t*+g[n+264>>2]+u*+g[n+268>>2]+v*+g[n+272>>2])*+g[n+544>>2];o=(t*+g[n+280>>2]+u*+g[n+284>>2]+v*+g[n+288>>2])*+g[n+548>>2];l=(t*+g[n+296>>2]+u*+g[n+300>>2]+v*+g[n+304>>2])*+g[n+552>>2]}else{p=0.0;o=0.0;l=0.0}g[m+(A*152|0)+80>>2]=p;g[m+(A*152|0)+84>>2]=o;g[m+(A*152|0)+88>>2]=l;g[m+(A*152|0)+92>>2]=0.0;if(b){q=+g[b+264>>2]*w+ +g[b+268>>2]*x+ +g[b+272>>2]*y;p=+g[b+280>>2]*w+ +g[b+284>>2]*x+ +g[b+288>>2]*y;o=+g[b+296>>2]*w+ +g[b+300>>2]*x+ +g[b+304>>2]*y}else{q=0.0;p=0.0;o=0.0}if(n){l=+g[n+264>>2]*t+ +g[n+268>>2]*u+ +g[n+272>>2]*v;r=t*+g[n+280>>2]+u*+g[n+284>>2]+v*+g[n+288>>2];s=t*+g[n+296>>2]+u*+g[n+300>>2]+v*+g[n+304>>2]}else{l=0.0;r=0.0;s=0.0}s=1.0/(q*w+p*x+o*y+0.0+(l*t+r*u+s*v));g[m+(A*152|0)+108>>2]=s;if(b){o=+g[h+(e*244|0)+192>>2];l=+g[h+(e*244|0)+196>>2];q=+g[h+(e*244|0)+200>>2];p=(+g[h+(e*244|0)+176>>2]+ +g[h+(e*244|0)+208>>2])*0.0+(+g[h+(e*244|0)+180>>2]+ +g[h+(e*244|0)+212>>2])*0.0+(+g[h+(e*244|0)+184>>2]+ +g[h+(e*244|0)+216>>2])*0.0}else{o=0.0;l=0.0;q=0.0;p=0.0}l=p+(o*w+l*x+q*y);if(!n){r=0.0;q=0.0;y=0.0;x=-0.0;t=r*t;u=q*u;u=t+u;y=y*v;y=u+y;y=x+y;y=l+y;y=0.0-y;y=s*y;d=m+(A*152|0)+112|0;g[d>>2]=y;d=m+(A*152|0)+116|0;g[d>>2]=0.0;y=-z;d=m+(A*152|0)+120|0;g[d>>2]=y;d=m+(A*152|0)+124|0;g[d>>2]=z;return}r=+g[h+(f*244|0)+192>>2];q=+g[h+(f*244|0)+196>>2];y=+g[h+(f*244|0)+200>>2];x=(+g[h+(f*244|0)+176>>2]+ +g[h+(f*244|0)+208>>2])*-0.0+(+g[h+(f*244|0)+180>>2]+ +g[h+(f*244|0)+212>>2])*-0.0+(+g[h+(f*244|0)+184>>2]+ +g[h+(f*244|0)+216>>2])*-0.0;t=r*t;u=q*u;u=t+u;y=y*v;y=u+y;y=x+y;y=l+y;y=0.0-y;y=s*y;d=m+(A*152|0)+112|0;g[d>>2]=y;d=m+(A*152|0)+116|0;g[d>>2]=0.0;y=-z;d=m+(A*152|0)+120|0;g[d>>2]=y;d=m+(A*152|0)+124|0;g[d>>2]=z;return}function _r(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0,h=0;f=i;i=i+496|0;e=c[b+212>>2]|0;if((e|0)>-1){a=e;i=f;return a|0}h=(c[b+236>>2]&2|0)==0;e=h?0:b;do if(!h){if(!(+g[e+344>>2]!=0.0)?(c[e+204>>2]&2|0)==0:0)break;h=c[a+8>>2]|0;cF(f+244|0,0,244)|0;Wr(hs(a+4|0,f+244|0)|0,b,d);c[b+212>>2]=h;a=h;i=f;return a|0}while(0);e=c[a+188>>2]|0;if((e|0)>=0){a=e;i=f;return a|0}c[a+188>>2]=c[a+8>>2];cF(f|0,0,244)|0;Wr(hs(a+4|0,f)|0,0,d);a=c[a+188>>2]|0;i=f;return a|0}function $r(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,k=0,l=0.0,m=0.0,n=0,o=0.0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0,N=0,Q=0,R=0.0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0;ea=i;i=i+80|0;if((e|0)<=0){i=ea;return}ba=0;do{W=c[d+(ba<<2)>>2]|0;X=c[W+740>>2]|0;Y=c[W+744>>2]|0;Z=_r(b,X,+g[f+12>>2])|0;_=_r(b,Y,+g[f+12>>2])|0;$=c[b+16>>2]|0;if(!(((((+g[$+(Z*244|0)+128>>2]==0.0?+g[$+(Z*244|0)+132>>2]==0.0:0)?+g[$+(Z*244|0)+136>>2]==0.0:0)?+g[$+(_*244|0)+128>>2]==0.0:0)?+g[$+(_*244|0)+132>>2]==0.0:0)?+g[$+(_*244|0)+136>>2]==0.0:0))da=9;if((da|0)==9?(da=0,aa=c[W+748>>2]|0,(aa|0)>0):0){j=aa;ca=0;h=1;do{T=W+(ca*184|0)+4|0;p=W+(ca*184|0)+84|0;if(+g[p>>2]<=+g[W+756>>2]){U=c[b+28>>2]|0;if((U|0)==(c[b+32>>2]|0)?(V=(U|0)==0?1:U<<1,(U|0)<(V|0)):0){if(!V){j=0;k=U}else{c[5132]=(c[5132]|0)+1;j=ZE((V*152|3)+16|0)|0;if(!j)j=0;else{c[(j+19&-16)+-4>>2]=j;j=j+19&-16}k=c[b+28>>2]|0}if((k|0)>0){n=0;do{fF(j+(n*152|0)|0,(c[b+36>>2]|0)+(n*152|0)|0,152)|0;n=n+1|0}while((n|0)!=(k|0))}k=c[b+36>>2]|0;if(k){if(a[b+40>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[k+-4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=j;c[b+32>>2]=V;j=c[b+28>>2]|0}else j=U;c[b+28>>2]=j+1;S=c[b+36>>2]|0;j=(c[X+236>>2]&2|0)==0?0:X;n=(c[Y+236>>2]&2|0)==0?0:Y;c[S+(U*152|0)+144>>2]=Z;c[S+(U*152|0)+148>>2]=_;c[S+(U*152|0)+132>>2]=T;w=+g[W+(ca*184|0)+52>>2]-+g[X+52>>2];C=+g[W+(ca*184|0)+56>>2]-+g[X+56>>2];x=+g[W+(ca*184|0)+60>>2]-+g[X+60>>2];g[ea+64>>2]=w;g[ea+68>>2]=C;g[ea+72>>2]=x;g[ea+76>>2]=0.0;E=+g[W+(ca*184|0)+36>>2]-+g[Y+52>>2];F=+g[W+(ca*184|0)+40>>2]-+g[Y+56>>2];D=+g[W+(ca*184|0)+44>>2]-+g[Y+60>>2];g[ea+48>>2]=E;g[ea+52>>2]=F;g[ea+56>>2]=D;g[ea+60>>2]=0.0;if(!(c[$+(Z*244|0)+240>>2]|0)){u=0.0;l=0.0;o=0.0}else{l=+g[$+(Z*244|0)+192>>2]+ +g[$+(Z*244|0)+224>>2];R=+g[$+(Z*244|0)+196>>2]+ +g[$+(Z*244|0)+228>>2];o=+g[$+(Z*244|0)+200>>2]+ +g[$+(Z*244|0)+232>>2];u=+g[$+(Z*244|0)+184>>2]+ +g[$+(Z*244|0)+216>>2]+(l*C-R*w);l=+g[$+(Z*244|0)+180>>2]+ +g[$+(Z*244|0)+212>>2]+(o*w-l*x);o=+g[$+(Z*244|0)+176>>2]+ +g[$+(Z*244|0)+208>>2]+(R*x-o*C)}if(!(c[$+(_*244|0)+240>>2]|0)){t=0.0;s=0.0;m=0.0}else{s=+g[$+(_*244|0)+192>>2]+ +g[$+(_*244|0)+224>>2];R=+g[$+(_*244|0)+196>>2]+ +g[$+(_*244|0)+228>>2];m=+g[$+(_*244|0)+200>>2]+ +g[$+(_*244|0)+232>>2];t=+g[$+(_*244|0)+184>>2]+ +g[$+(_*244|0)+216>>2]+(s*F-R*E);s=+g[$+(_*244|0)+180>>2]+ +g[$+(_*244|0)+212>>2]+(m*E-s*D);m=+g[$+(_*244|0)+176>>2]+ +g[$+(_*244|0)+208>>2]+(R*D-m*F)}R=o-m;L=l-s;H=u-t;M=W+(ca*184|0)+68|0;I=+g[M>>2];N=W+(ca*184|0)+72|0;J=+g[N>>2];Q=W+(ca*184|0)+76|0;K=+g[Q>>2];k=c[b+16>>2]|0;r=c[k+(Z*244|0)+240>>2]|0;q=c[k+(_*244|0)+240>>2]|0;if(r){A=((C*K-x*J)*+g[r+264>>2]+(x*I-K*w)*+g[r+268>>2]+(J*w-C*I)*+g[r+272>>2])*+g[r+544>>2];y=((C*K-x*J)*+g[r+280>>2]+(x*I-K*w)*+g[r+284>>2]+(J*w-C*I)*+g[r+288>>2])*+g[r+548>>2];v=((C*K-x*J)*+g[r+296>>2]+(x*I-K*w)*+g[r+300>>2]+(J*w-C*I)*+g[r+304>>2])*+g[r+552>>2]}else{A=0.0;y=0.0;v=0.0}g[S+(U*152|0)+64>>2]=A;g[S+(U*152|0)+68>>2]=y;g[S+(U*152|0)+72>>2]=v;g[S+(U*152|0)+76>>2]=0.0;t=+g[Q>>2];z=+g[N>>2];o=+g[M>>2];if(q){B=(+g[q+264>>2]*-(F*t-D*z)+ +g[q+268>>2]*-(D*o-t*E)+ +g[q+272>>2]*-(z*E-F*o))*+g[q+544>>2];u=(+g[q+280>>2]*-(F*t-D*z)+ +g[q+284>>2]*-(D*o-t*E)+ +g[q+288>>2]*-(z*E-F*o))*+g[q+548>>2];s=(+g[q+296>>2]*-(F*t-D*z)+ +g[q+300>>2]*-(D*o-t*E)+ +g[q+304>>2]*-(z*E-F*o))*+g[q+552>>2]}else{B=0.0;u=0.0;s=0.0}g[S+(U*152|0)+80>>2]=B;g[S+(U*152|0)+84>>2]=u;g[S+(U*152|0)+88>>2]=s;g[S+(U*152|0)+92>>2]=0.0;if(r)y=+g[r+344>>2]+((y*x-v*C)*+g[M>>2]+(v*w-x*A)*+g[N>>2]+(C*A-y*w)*+g[Q>>2]);else y=0.0;if(q){G=-B;A=-u;B=-s;A=+g[q+344>>2]+((D*A-F*B)*+g[M>>2]+(E*B-D*G)*+g[N>>2]+(F*G-E*A)*+g[Q>>2])}else A=0.0;g[S+(U*152|0)+108>>2]=1.0/(y+A);if(r){c[S+(U*152|0)+16>>2]=c[M+0>>2];c[S+(U*152|0)+20>>2]=c[M+4>>2];c[S+(U*152|0)+24>>2]=c[M+8>>2];c[S+(U*152|0)+28>>2]=c[M+12>>2];g[S+(U*152|0)>>2]=C*K-x*J;g[S+(U*152|0)+4>>2]=x*I-K*w;g[S+(U*152|0)+8>>2]=J*w-C*I;g[S+(U*152|0)+12>>2]=0.0}else{c[S+(U*152|0)+0>>2]=0;c[S+(U*152|0)+4>>2]=0;c[S+(U*152|0)+8>>2]=0;c[S+(U*152|0)+12>>2]=0;c[S+(U*152|0)+16>>2]=0;c[S+(U*152|0)+20>>2]=0;c[S+(U*152|0)+24>>2]=0;c[S+(U*152|0)+28>>2]=0}if(q){B=-+g[N>>2];G=-+g[Q>>2];g[S+(U*152|0)+48>>2]=-+g[M>>2];g[S+(U*152|0)+52>>2]=B;g[S+(U*152|0)+56>>2]=G;g[S+(U*152|0)+60>>2]=0.0;g[S+(U*152|0)+32>>2]=-(F*t-D*z);g[S+(U*152|0)+36>>2]=-(D*o-t*E);g[S+(U*152|0)+40>>2]=-(z*E-F*o);g[S+(U*152|0)+44>>2]=0.0}else{c[S+(U*152|0)+32>>2]=0;c[S+(U*152|0)+36>>2]=0;c[S+(U*152|0)+40>>2]=0;c[S+(U*152|0)+44>>2]=0;c[S+(U*152|0)+48>>2]=0;c[S+(U*152|0)+52>>2]=0;c[S+(U*152|0)+56>>2]=0;c[S+(U*152|0)+60>>2]=0}G=+g[p>>2]+ +g[f+56>>2];if(r){t=+g[r+332>>2];o=+g[r+336>>2];B=+g[r+328>>2];A=t*x-o*C+ +g[r+312>>2];o=+g[r+316>>2]+(o*w-x*B);t=C*B-t*w+ +g[r+320>>2]}else{A=0.0;o=0.0;t=0.0}if(q){v=+g[q+332>>2];u=+g[q+336>>2];C=+g[q+328>>2];s=v*D-u*F+ +g[q+312>>2];u=+g[q+316>>2]+(u*E-D*C);v=F*C-v*E+ +g[q+320>>2]}else{s=0.0;u=0.0;v=0.0}B=+g[M>>2]*(A-s)+(o-u)*+g[N>>2]+(t-v)*+g[Q>>2];g[S+(U*152|0)+104>>2]=+g[W+(ca*184|0)+88>>2];B=B*+g[W+(ca*184|0)+96>>2];B=!(B>=-0.0)?-B:0.0;do if(!(c[f+64>>2]&4))g[S+(U*152|0)+100>>2]=0.0;else{u=+g[W+(ca*184|0)+124>>2]*+g[f+60>>2];g[S+(U*152|0)+100>>2]=u;do if(r){if(!(c[k+(Z*244|0)+240>>2]|0))break;F=u*(+g[S+(U*152|0)+20>>2]*+g[k+(Z*244|0)+132>>2]*+g[r+352>>2])*+g[k+(Z*244|0)+116>>2];E=u*(+g[S+(U*152|0)+24>>2]*+g[k+(Z*244|0)+136>>2]*+g[r+356>>2])*+g[k+(Z*244|0)+120>>2];g[k+(Z*244|0)+64>>2]=+g[k+(Z*244|0)+112>>2]*(u*(+g[S+(U*152|0)+16>>2]*+g[k+(Z*244|0)+128>>2]*+g[r+348>>2]))+ +g[k+(Z*244|0)+64>>2];g[k+(Z*244|0)+68>>2]=F+ +g[k+(Z*244|0)+68>>2];g[k+(Z*244|0)+72>>2]=E+ +g[k+(Z*244|0)+72>>2];E=u*+g[k+(Z*244|0)+100>>2]*+g[S+(U*152|0)+68>>2];F=u*+g[k+(Z*244|0)+104>>2]*+g[S+(U*152|0)+72>>2];g[k+(Z*244|0)+80>>2]=u*+g[k+(Z*244|0)+96>>2]*+g[S+(U*152|0)+64>>2]+ +g[k+(Z*244|0)+80>>2];g[k+(Z*244|0)+84>>2]=E+ +g[k+(Z*244|0)+84>>2];g[k+(Z*244|0)+88>>2]=F+ +g[k+(Z*244|0)+88>>2]}while(0);if(!q)break;s=+g[S+(U*152|0)+100>>2];if(!(c[k+(_*244|0)+240>>2]|0))break;F=+g[S+(U*152|0)+88>>2];E=+g[S+(U*152|0)+84>>2];D=+g[S+(U*152|0)+80>>2];A=s*(+g[S+(U*152|0)+52>>2]*+g[k+(_*244|0)+132>>2]*+g[q+352>>2])*+g[k+(_*244|0)+116>>2];C=s*(+g[S+(U*152|0)+56>>2]*+g[k+(_*244|0)+136>>2]*+g[q+356>>2])*+g[k+(_*244|0)+120>>2];g[k+(_*244|0)+64>>2]=+g[k+(_*244|0)+112>>2]*(s*(+g[S+(U*152|0)+48>>2]*+g[k+(_*244|0)+128>>2]*+g[q+348>>2]))+ +g[k+(_*244|0)+64>>2];g[k+(_*244|0)+68>>2]=A+ +g[k+(_*244|0)+68>>2];g[k+(_*244|0)+72>>2]=C+ +g[k+(_*244|0)+72>>2];E=E*(+g[k+(_*244|0)+100>>2]*-s);F=F*(+g[k+(_*244|0)+104>>2]*-s);g[k+(_*244|0)+80>>2]=+g[k+(_*244|0)+80>>2]-D*(+g[k+(_*244|0)+96>>2]*-s);g[k+(_*244|0)+84>>2]=+g[k+(_*244|0)+84>>2]-E;g[k+(_*244|0)+88>>2]=+g[k+(_*244|0)+88>>2]-F}while(0);g[S+(U*152|0)+96>>2]=0.0;if(!(c[k+(Z*244|0)+240>>2]|0)){v=0.0;u=0.0;s=0.0;t=0.0;o=0.0;m=0.0}else{v=+g[k+(Z*244|0)+208>>2];u=+g[k+(Z*244|0)+212>>2];s=+g[k+(Z*244|0)+216>>2];t=+g[k+(Z*244|0)+224>>2];o=+g[k+(Z*244|0)+228>>2];m=+g[k+(Z*244|0)+232>>2]}if(!(c[k+(_*244|0)+240>>2]|0)){l=0.0;w=0.0;x=0.0;y=0.0;z=0.0;A=0.0}else{l=+g[k+(_*244|0)+208>>2];w=+g[k+(_*244|0)+212>>2];x=+g[k+(_*244|0)+216>>2];y=+g[k+(_*244|0)+224>>2];z=+g[k+(_*244|0)+228>>2];A=+g[k+(_*244|0)+232>>2]}o=B-((v+ +g[k+(Z*244|0)+176>>2])*+g[S+(U*152|0)+16>>2]+(u+ +g[k+(Z*244|0)+180>>2])*+g[S+(U*152|0)+20>>2]+(s+ +g[k+(Z*244|0)+184>>2])*+g[S+(U*152|0)+24>>2]+((t+ +g[k+(Z*244|0)+192>>2])*+g[S+(U*152|0)>>2]+(o+ +g[k+(Z*244|0)+196>>2])*+g[S+(U*152|0)+4>>2]+(m+ +g[k+(Z*244|0)+200>>2])*+g[S+(U*152|0)+8>>2])+((l+ +g[k+(_*244|0)+176>>2])*+g[S+(U*152|0)+48>>2]+(w+ +g[k+(_*244|0)+180>>2])*+g[S+(U*152|0)+52>>2]+(x+ +g[k+(_*244|0)+184>>2])*+g[S+(U*152|0)+56>>2]+((y+ +g[k+(_*244|0)+192>>2])*+g[S+(U*152|0)+32>>2]+(z+ +g[k+(_*244|0)+196>>2])*+g[S+(U*152|0)+36>>2]+(A+ +g[k+(_*244|0)+200>>2])*+g[S+(U*152|0)+40>>2])));r=(c[f+44>>2]|0)==0;if(G>0.0){s=0.0;o=o-G/+g[f+12>>2]}else s=-(G*+g[(r|G>+g[f+48>>2]?f+32|0:f+36|0)>>2])/+g[f+12>>2];F=+g[S+(U*152|0)+108>>2];s=s*F;o=o*F;if(r|G>+g[f+48>>2]){g[S+(U*152|0)+112>>2]=s+o;g[S+(U*152|0)+128>>2]=0.0}else{g[S+(U*152|0)+112>>2]=o;g[S+(U*152|0)+128>>2]=s}g[S+(U*152|0)+116>>2]=0.0;g[S+(U*152|0)+120>>2]=0.0;g[S+(U*152|0)+124>>2]=1.0e10;c[S+(U*152|0)+140>>2]=c[b+68>>2];if(!j){u=0.0;l=0.0;v=0.0}else{u=+g[j+328>>2];l=+g[j+332>>2];v=+g[j+336>>2]}if(!n){s=0.0;t=0.0;o=0.0}else{s=+g[n+328>>2];t=+g[n+332>>2];o=+g[n+336>>2]}m=s-u;u=t-l;s=o-v;g[ea+32>>2]=m;g[ea+36>>2]=u;g[ea+40>>2]=s;g[ea+44>>2]=0.0;do if((h|0)>0?+g[W+(ca*184|0)+92>>2]>0.0:0){h=h+-1|0;o=+P(+(m*m+u*u+s*s));if(o>+g[f+80>>2]){l=m*(1.0/o);g[ea+32>>2]=l;m=u*(1.0/o);g[ea+36>>2]=m;o=s*(1.0/o);g[ea+40>>2]=o;do if(X){if(!(c[X+180>>2]&2))break;s=+g[X+4>>2];y=+g[X+20>>2];C=+g[X+36>>2];u=+g[X+8>>2];A=+g[X+24>>2];E=+g[X+40>>2];v=+g[X+12>>2];B=+g[X+28>>2];G=+g[X+44>>2];D=(s*l+y*m+o*C)*+g[X+164>>2];F=(l*u+m*A+o*E)*+g[X+168>>2];o=(l*v+m*B+o*G)*+g[X+172>>2];g[ea+32>>2]=s*D+u*F+v*o;g[ea+36>>2]=y*D+A*F+B*o;g[ea+40>>2]=C*D+E*F+G*o;g[ea+44>>2]=0.0;l=s*D+u*F+v*o;m=y*D+A*F+B*o;o=C*D+E*F+G*o}while(0);do if(Y){if(!(c[Y+180>>2]&2))break;y=+g[Y+4>>2];C=+g[Y+20>>2];s=+g[Y+36>>2];A=+g[Y+8>>2];E=+g[Y+24>>2];u=+g[Y+40>>2];B=+g[Y+12>>2];G=+g[Y+28>>2];v=+g[Y+44>>2];D=(y*l+C*m+s*o)*+g[Y+164>>2];F=(l*A+m*E+o*u)*+g[Y+168>>2];m=(l*B+m*G+o*v)*+g[Y+172>>2];g[ea+32>>2]=y*D+A*F+B*m;g[ea+36>>2]=C*D+E*F+G*m;g[ea+40>>2]=s*D+u*F+v*m;g[ea+44>>2]=0.0;o=s*D+u*F+v*m;l=y*D+A*F+B*m;m=C*D+E*F+G*m}while(0);if(!(+P(+(l*l+m*m+o*o))>.001))break;Zr(b,ea+32|0,Z,_,U,T);break}Zr(b,M,Z,_,U,T);o=+g[Q>>2];if(+O(+o)>.7071067690849304){m=+g[N>>2];G=1.0/+P(+(o*o+m*m));g[ea+16>>2]=0.0;g[ea+20>>2]=-(G*o);g[ea+24>>2]=G*m;g[ea>>2]=(o*o+m*m)*G;F=+g[M>>2];g[ea+4>>2]=-(F*(G*m));v=F*-(G*o);s=0.0;u=-(G*o);t=G*m;l=(o*o+m*m)*G;m=-(F*(G*m))}else{l=+g[M>>2];G=+g[N>>2];m=1.0/+P(+(l*l+G*G));g[ea+16>>2]=-(G*m);g[ea+20>>2]=m*l;g[ea+24>>2]=0.0;g[ea>>2]=-(o*(m*l));g[ea+4>>2]=o*-(G*m);v=(l*l+G*G)*m;s=-(G*m);u=m*l;t=0.0;l=-(o*(m*l));m=o*-(G*m)}g[ea+8>>2]=v;do if(X){if(!(c[X+180>>2]&2))break;x=+g[X+4>>2];y=+g[X+20>>2];C=+g[X+36>>2];o=+g[X+8>>2];A=+g[X+24>>2];E=+g[X+40>>2];z=+g[X+12>>2];B=+g[X+28>>2];G=+g[X+44>>2];D=(x*s+y*u+C*t)*+g[X+164>>2];F=(s*o+u*A+t*E)*+g[X+168>>2];t=(s*z+u*B+t*G)*+g[X+172>>2];g[ea+16>>2]=x*D+o*F+z*t;g[ea+20>>2]=y*D+A*F+B*t;g[ea+24>>2]=C*D+E*F+G*t;g[ea+28>>2]=0.0;s=x*D+o*F+z*t;u=y*D+A*F+B*t;t=C*D+E*F+G*t}while(0);do if(Y){if(!(c[Y+180>>2]&2))break;x=+g[Y+4>>2];y=+g[Y+20>>2];C=+g[Y+36>>2];o=+g[Y+8>>2];A=+g[Y+24>>2];E=+g[Y+40>>2];z=+g[Y+12>>2];B=+g[Y+28>>2];G=+g[Y+44>>2];D=(x*s+y*u+C*t)*+g[Y+164>>2];F=(s*o+u*A+t*E)*+g[Y+168>>2];t=(s*z+u*B+t*G)*+g[Y+172>>2];g[ea+16>>2]=x*D+o*F+z*t;g[ea+20>>2]=y*D+A*F+B*t;g[ea+24>>2]=C*D+E*F+G*t;g[ea+28>>2]=0.0;s=x*D+o*F+z*t;u=y*D+A*F+B*t;t=C*D+E*F+G*t}while(0);do if(!X)o=v;else{if(!(c[X+180>>2]&2)){o=v;break}w=+g[X+4>>2];y=+g[X+20>>2];C=+g[X+36>>2];x=+g[X+8>>2];A=+g[X+24>>2];E=+g[X+40>>2];z=+g[X+12>>2];B=+g[X+28>>2];G=+g[X+44>>2];D=(w*l+y*m+C*v)*+g[X+164>>2];F=(l*x+m*A+v*E)*+g[X+168>>2];o=(l*z+m*B+v*G)*+g[X+172>>2];g[ea>>2]=w*D+x*F+z*o;g[ea+4>>2]=y*D+A*F+B*o;g[ea+8>>2]=C*D+E*F+G*o;g[ea+12>>2]=0.0;l=w*D+x*F+z*o;m=y*D+A*F+B*o;o=C*D+E*F+G*o}while(0);do if(Y){if(!(c[Y+180>>2]&2))break;x=+g[Y+4>>2];y=+g[Y+20>>2];C=+g[Y+36>>2];z=+g[Y+8>>2];A=+g[Y+24>>2];E=+g[Y+40>>2];v=+g[Y+12>>2];B=+g[Y+28>>2];G=+g[Y+44>>2];D=(x*l+y*m+C*o)*+g[Y+164>>2];F=(l*z+m*A+o*E)*+g[Y+168>>2];o=(l*v+m*B+o*G)*+g[Y+172>>2];g[ea>>2]=x*D+z*F+v*o;g[ea+4>>2]=y*D+A*F+B*o;g[ea+8>>2]=C*D+E*F+G*o;g[ea+12>>2]=0.0;l=x*D+z*F+v*o;m=y*D+A*F+B*o;o=C*D+E*F+G*o}while(0);if(+P(+(s*s+u*u+t*t))>.001)Zr(b,ea+16|0,Z,_,U,T);if(!(+P(+(l*l+m*m+o*o))>.001))break;Zr(b,ea,Z,_,U,T)}while(0);do if(!(c[f+64>>2]&32))da=100;else{if(!(a[W+(ca*184|0)+120>>0]|0)){da=100;break}Yr(b,W+(ca*184|0)+156|0,Z,_,U,T,ea+64|0,ea+48|0,1.0,+g[W+(ca*184|0)+136>>2],+g[W+(ca*184|0)+144>>2]);if(!(c[f+64>>2]&16))break;Yr(b,W+(ca*184|0)+172|0,Z,_,U,T,ea+64|0,ea+48|0,1.0,+g[W+(ca*184|0)+140>>2],+g[W+(ca*184|0)+148>>2])}while(0);do if((da|0)==100){da=0;k=W+(ca*184|0)+156|0;v=+g[M>>2];t=+g[N>>2];m=+g[Q>>2];u=R-(R*I+L*J+H*K)*v;s=L-(R*I+L*J+H*K)*t;o=H-(R*I+L*J+H*K)*m;g[W+(ca*184|0)+156>>2]=u;r=W+(ca*184|0)+160|0;g[r>>2]=s;p=W+(ca*184|0)+164|0;g[p>>2]=o;g[W+(ca*184|0)+168>>2]=0.0;if((c[f+64>>2]&64|0)==0?u*u+s*s+o*o>1.1920928955078125e-07:0){R=1.0/+P(+(u*u+s*s+o*o));g[k>>2]=u*R;g[r>>2]=R*s;g[p>>2]=R*o;Xr(X,k);Xr(Y,k);Yr(b,k,Z,_,U,T,ea+64|0,ea+48|0,1.0,0.0,0.0);if(!(c[f+64>>2]&16))break;q=W+(ca*184|0)+172|0;H=+g[r>>2];E=+g[Q>>2];D=+g[p>>2];F=+g[N>>2];K=+g[M>>2];G=+g[k>>2];g[W+(ca*184|0)+172>>2]=H*E-D*F;g[W+(ca*184|0)+184>>2]=0.0;R=1.0/+P(+((H*E-D*F)*(H*E-D*F)+(D*K-E*G)*(D*K-E*G)+(F*G-H*K)*(F*G-H*K)));g[q>>2]=(H*E-D*F)*R;g[W+(ca*184|0)+176>>2]=(D*K-E*G)*R;g[W+(ca*184|0)+180>>2]=(F*G-H*K)*R;Xr(X,q);Xr(Y,q);Yr(b,q,Z,_,U,T,ea+64|0,ea+48|0,1.0,0.0,0.0);break}q=W+(ca*184|0)+172|0;if(+O(+m)>.7071067690849304){R=1.0/+P(+(m*m+t*t));g[k>>2]=0.0;g[r>>2]=-(R*m);g[p>>2]=R*t;l=-(v*(R*t));o=v*-(R*m);m=(m*m+t*t)*R}else{R=1.0/+P(+(v*v+t*t));g[k>>2]=-(t*R);g[r>>2]=R*v;g[p>>2]=0.0;l=m*-(t*R);o=(v*v+t*t)*R;m=-(m*(R*v))}g[q>>2]=m;g[W+(ca*184|0)+176>>2]=l;g[W+(ca*184|0)+180>>2]=o;Xr(X,k);Xr(Y,k);Yr(b,k,Z,_,U,T,ea+64|0,ea+48|0,1.0,0.0,0.0);j=c[f+64>>2]|0;if(j&16){Xr(X,q);Xr(Y,q);Yr(b,q,Z,_,U,T,ea+64|0,ea+48|0,1.0,0.0,0.0);j=c[f+64>>2]|0}if((j&80|0)!=80)break;a[W+(ca*184|0)+120>>0]=1}while(0);r=c[b+16>>2]|0;j=c[r+(Z*244|0)+240>>2]|0;n=c[r+(_*244|0)+240>>2]|0;p=c[S+(U*152|0)+140>>2]|0;q=c[b+76>>2]|0;k=c[f+64>>2]|0;do if(!(k&4))g[q+(p*152|0)+100>>2]=0.0;else{m=+g[W+(ca*184|0)+128>>2]*+g[f+60>>2];g[q+(p*152|0)+100>>2]=m;if(j){H=+g[j+344>>2];R=m*(H*+g[q+(p*152|0)+20>>2]*+g[j+352>>2])*+g[r+(Z*244|0)+116>>2];K=m*(H*+g[q+(p*152|0)+24>>2]*+g[j+356>>2])*+g[r+(Z*244|0)+120>>2];g[r+(Z*244|0)+64>>2]=+g[r+(Z*244|0)+112>>2]*(m*(H*+g[q+(p*152|0)+16>>2]*+g[j+348>>2]))+ +g[r+(Z*244|0)+64>>2];g[r+(Z*244|0)+68>>2]=R+ +g[r+(Z*244|0)+68>>2];g[r+(Z*244|0)+72>>2]=K+ +g[r+(Z*244|0)+72>>2];K=m*+g[r+(Z*244|0)+100>>2]*+g[q+(p*152|0)+68>>2];R=m*+g[r+(Z*244|0)+104>>2]*+g[q+(p*152|0)+72>>2];g[r+(Z*244|0)+80>>2]=m*+g[r+(Z*244|0)+96>>2]*+g[q+(p*152|0)+64>>2]+ +g[r+(Z*244|0)+80>>2];g[r+(Z*244|0)+84>>2]=K+ +g[r+(Z*244|0)+84>>2];g[r+(Z*244|0)+88>>2]=R+ +g[r+(Z*244|0)+88>>2]}if(!n)break;m=+g[n+344>>2];l=+g[q+(p*152|0)+100>>2];if(!(c[r+(_*244|0)+240>>2]|0))break;R=+g[q+(p*152|0)+88>>2];K=+g[q+(p*152|0)+84>>2];H=+g[q+(p*152|0)+80>>2];F=l*(m*+g[q+(p*152|0)+52>>2]*+g[n+352>>2])*+g[r+(_*244|0)+116>>2];G=l*(m*+g[q+(p*152|0)+56>>2]*+g[n+356>>2])*+g[r+(_*244|0)+120>>2];g[r+(_*244|0)+64>>2]=+g[r+(_*244|0)+112>>2]*(l*(m*+g[q+(p*152|0)+48>>2]*+g[n+348>>2]))+ +g[r+(_*244|0)+64>>2];g[r+(_*244|0)+68>>2]=F+ +g[r+(_*244|0)+68>>2];g[r+(_*244|0)+72>>2]=G+ +g[r+(_*244|0)+72>>2];K=K*(+g[r+(_*244|0)+100>>2]*-l);R=R*(+g[r+(_*244|0)+104>>2]*-l);g[r+(_*244|0)+80>>2]=+g[r+(_*244|0)+80>>2]-H*(+g[r+(_*244|0)+96>>2]*-l);g[r+(_*244|0)+84>>2]=+g[r+(_*244|0)+84>>2]-K;g[r+(_*244|0)+88>>2]=+g[r+(_*244|0)+88>>2]-R}while(0);do if(k&16){if(!(k&4)){g[q+((p+1|0)*152|0)+100>>2]=0.0;break}l=+g[W+(ca*184|0)+132>>2]*+g[f+60>>2];g[q+((p+1|0)*152|0)+100>>2]=l;do if(j){m=+g[j+344>>2];if(!(c[r+(Z*244|0)+240>>2]|0))break;R=l*(m*+g[q+((p+1|0)*152|0)+20>>2])*+g[r+(Z*244|0)+116>>2];K=l*(m*+g[q+((p+1|0)*152|0)+24>>2])*+g[r+(Z*244|0)+120>>2];g[r+(Z*244|0)+64>>2]=+g[r+(Z*244|0)+112>>2]*(l*(m*+g[q+((p+1|0)*152|0)+16>>2]))+ +g[r+(Z*244|0)+64>>2];g[r+(Z*244|0)+68>>2]=R+ +g[r+(Z*244|0)+68>>2];g[r+(Z*244|0)+72>>2]=K+ +g[r+(Z*244|0)+72>>2];K=l*+g[r+(Z*244|0)+100>>2]*+g[q+((p+1|0)*152|0)+68>>2];R=l*+g[r+(Z*244|0)+104>>2]*+g[q+((p+1|0)*152|0)+72>>2];g[r+(Z*244|0)+80>>2]=l*+g[r+(Z*244|0)+96>>2]*+g[q+((p+1|0)*152|0)+64>>2]+ +g[r+(Z*244|0)+80>>2];g[r+(Z*244|0)+84>>2]=K+ +g[r+(Z*244|0)+84>>2];g[r+(Z*244|0)+88>>2]=R+ +g[r+(Z*244|0)+88>>2]}while(0);if(!n)break;l=+g[n+344>>2];m=+g[q+((p+1|0)*152|0)+100>>2];if(!(c[r+(_*244|0)+240>>2]|0))break;R=+g[q+((p+1|0)*152|0)+88>>2];K=+g[q+((p+1|0)*152|0)+84>>2];H=+g[q+((p+1|0)*152|0)+80>>2];F=m*(l*+g[q+((p+1|0)*152|0)+52>>2])*+g[r+(_*244|0)+116>>2];G=m*(l*+g[q+((p+1|0)*152|0)+56>>2])*+g[r+(_*244|0)+120>>2];g[r+(_*244|0)+64>>2]=+g[r+(_*244|0)+112>>2]*(m*(l*+g[q+((p+1|0)*152|0)+48>>2]))+ +g[r+(_*244|0)+64>>2];g[r+(_*244|0)+68>>2]=F+ +g[r+(_*244|0)+68>>2];g[r+(_*244|0)+72>>2]=G+ +g[r+(_*244|0)+72>>2];K=K*(+g[r+(_*244|0)+100>>2]*-m);R=R*(+g[r+(_*244|0)+104>>2]*-m);g[r+(_*244|0)+80>>2]=+g[r+(_*244|0)+80>>2]-H*(+g[r+(_*244|0)+96>>2]*-m);g[r+(_*244|0)+84>>2]=+g[r+(_*244|0)+84>>2]-K;g[r+(_*244|0)+88>>2]=+g[r+(_*244|0)+88>>2]-R}while(0);j=c[W+748>>2]|0}ca=ca+1|0}while((ca|0)<(j|0))}ba=ba+1|0}while((ba|0)!=(e|0));i=ea;return}function as(b,d,e,f,h,j,k,l,m){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0.0,q=0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,Q=0.0,R=0,S=0,T=0,U=0,V=0,W=0,X=0;W=i;i=i+320|0;c[b+188>>2]=-1;jE(4128);c[b+184>>2]=0;if((e|0)>0){m=0;do{c[(c[d+(m<<2)>>2]|0)+212>>2]=-1;m=m+1|0}while((m|0)!=(e|0))}m=c[b+12>>2]|0;if((m|0)<(e+1|0)){if((e+1|0)!=0?(c[5132]=(c[5132]|0)+1,o=ZE(((e+1|0)*244|3)+16|0)|0,(o|0)!=0):0){c[(o+19&-16)+-4>>2]=o;n=o+19&-16}else n=0;m=c[b+8>>2]|0;if((m|0)>0){o=0;do{U=n+(o*244|0)|0;V=c[b+16>>2]|0;S=V+(o*244|0)|0;c[U+0>>2]=c[S+0>>2];c[U+4>>2]=c[S+4>>2];c[U+8>>2]=c[S+8>>2];c[U+12>>2]=c[S+12>>2];U=n+(o*244|0)+16|0;S=V+(o*244|0)+16|0;c[U+0>>2]=c[S+0>>2];c[U+4>>2]=c[S+4>>2];c[U+8>>2]=c[S+8>>2];c[U+12>>2]=c[S+12>>2];U=n+(o*244|0)+32|0;S=V+(o*244|0)+32|0;c[U+0>>2]=c[S+0>>2];c[U+4>>2]=c[S+4>>2];c[U+8>>2]=c[S+8>>2];c[U+12>>2]=c[S+12>>2];U=n+(o*244|0)+48|0;S=V+(o*244|0)+48|0;c[U+0>>2]=c[S+0>>2];c[U+4>>2]=c[S+4>>2];c[U+8>>2]=c[S+8>>2];c[U+12>>2]=c[S+12>>2];fF(n+(o*244|0)+64|0,V+(o*244|0)+64|0,180)|0;o=o+1|0}while((o|0)!=(m|0))}m=c[b+16>>2]|0;if(m){if(a[b+20>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[m+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=n;c[b+12>>2]=e+1;n=b+8|0;o=e+1|0}else{n=b+8|0;o=m}cF(W+56|0,0,244)|0;m=c[n>>2]|0;if((m|0)<0){if((o|0)<0){o=c[b+16>>2]|0;if(o){if(a[b+20>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[o+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=0;c[b+12>>2]=0}do{V=c[b+16>>2]|0;U=V+(m*244|0)|0;c[U+0>>2]=c[W+56>>2];c[U+4>>2]=c[W+60>>2];c[U+8>>2]=c[W+64>>2];c[U+12>>2]=c[W+68>>2];U=V+(m*244|0)+16|0;c[U+0>>2]=c[W+72>>2];c[U+4>>2]=c[W+76>>2];c[U+8>>2]=c[W+80>>2];c[U+12>>2]=c[W+84>>2];U=V+(m*244|0)+32|0;c[U+0>>2]=c[W+88>>2];c[U+4>>2]=c[W+92>>2];c[U+8>>2]=c[W+96>>2];c[U+12>>2]=c[W+100>>2];U=V+(m*244|0)+48|0;c[U+0>>2]=c[W+104>>2];c[U+4>>2]=c[W+108>>2];c[U+8>>2]=c[W+112>>2];c[U+12>>2]=c[W+116>>2];fF(V+(m*244|0)+64|0,W+120|0,180)|0;m=m+1|0}while((m|0)!=0)}c[n>>2]=0;if((e|0)>0){m=0;do{s=d+(m<<2)|0;r=_r(b,c[s>>2]|0,+g[l+12>>2])|0;s=c[s>>2]|0;s=(c[s+236>>2]&2|0)==0?0:s;if(((s|0)!=0?+g[s+344>>2]!=0.0:0)?(q=c[b+16>>2]|0,(c[s+504>>2]&2|0)!=0):0){p=+g[l+76>>2];I=1.0/+g[s+396>>2];M=1.0/+g[s+400>>2];t=1.0/+g[s+404>>2];E=+g[s+4>>2];F=+g[s+8>>2];G=+g[s+12>>2];H=+g[s+20>>2];K=+g[s+24>>2];Q=+g[s+28>>2];J=+g[s+36>>2];N=+g[s+40>>2];w=+g[s+44>>2];x=+g[s+328>>2];y=+g[s+332>>2];v=+g[s+336>>2];z=(E*(I*E)+F*(M*F)+G*(t*G))*x+(I*E*H+M*F*K+t*G*Q)*y+(I*E*J+M*F*N+t*G*w)*v;A=(E*(I*H)+F*(M*K)+G*(t*Q))*x+(H*(I*H)+K*(M*K)+Q*(t*Q))*y+(I*H*J+M*K*N+t*Q*w)*v;w=v*(J*(I*J)+N*(M*N)+w*(t*w))+(x*(E*(I*J)+F*(M*N)+G*(t*w))+y*(H*(I*J)+K*(M*N)+Q*(t*w)));t=(y*w-v*A)*(y*w-v*A)+(v*z-x*w)*(v*z-x*w)+(x*A-y*z)*(x*A-y*z);if(t>p*p){p=1.0/+P(+t)*p;u=(y*w-v*A)*p;t=p*(v*z-x*w);p=p*(x*A-y*z)}else{u=y*w-v*A;t=v*z-x*w;p=x*A-y*z}M=+g[l+12>>2];N=(u*+g[s+268>>2]+t*+g[s+284>>2]+p*+g[s+300>>2])*M;Q=M*(u*+g[s+272>>2]+t*+g[s+288>>2]+p*+g[s+304>>2]);g[q+(r*244|0)+224>>2]=+g[q+(r*244|0)+224>>2]-(u*+g[s+264>>2]+t*+g[s+280>>2]+p*+g[s+296>>2])*M;g[q+(r*244|0)+228>>2]=+g[q+(r*244|0)+228>>2]-N;g[q+(r*244|0)+232>>2]=+g[q+(r*244|0)+232>>2]-Q}m=m+1|0}while((m|0)!=(e|0))}if((k|0)>0){n=0;do{V=c[j+(n<<2)>>2]|0;Jb[c[(c[V>>2]|0)+8>>2]&255](V);g[V+36>>2]=0.0;n=n+1|0}while((n|0)<(k|0))}d=c[b+168>>2]|0;if((d|0)<(k|0)?(c[b+172>>2]|0)<(k|0):0){if(!k)n=0;else{c[5132]=(c[5132]|0)+1;n=ZE((k<<3|3)+16|0)|0;if(!n)n=0;else{c[(n+19&-16)+-4>>2]=n;n=n+19&-16}d=c[b+168>>2]|0}if((d|0)>0){o=0;do{m=n+(o<<3)|0;if(m){U=(c[b+176>>2]|0)+(o<<3)|0;V=c[U+4>>2]|0;c[m>>2]=c[U>>2];c[m+4>>2]=V}o=o+1|0}while((o|0)!=(d|0))}d=c[b+176>>2]|0;if(d){if(a[b+180>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+176>>2]=0}a[b+180>>0]=1;c[b+176>>2]=n;c[b+172>>2]=k}c[b+168>>2]=k;if((k|0)>0){s=0;n=0;do{q=c[b+176>>2]|0;r=q+(s<<3)|0;d=j+(s<<2)|0;m=c[d>>2]|0;o=c[m+44>>2]|0;if(o){m=o+0|0;o=m+64|0;do{c[m>>2]=0;m=m+4|0}while((m|0)<(o|0));m=c[d>>2]|0}if(!(a[m+20>>0]|0)){c[r>>2]=0;c[q+(s<<3)+4>>2]=0;m=0}else{Lb[c[(c[m>>2]|0)+16>>2]&127](m,r);m=c[r>>2]|0}n=m+n|0;s=s+1|0}while((s|0)<(k|0))}else n=0;o=c[b+48>>2]|0;if((o|0)<(n|0)?(c[b+52>>2]|0)<(n|0):0){if(!n)m=0;else{c[5132]=(c[5132]|0)+1;d=ZE((n*152|3)+16|0)|0;if(!d)m=0;else{c[(d+19&-16)+-4>>2]=d;m=d+19&-16}o=c[b+48>>2]|0}if((o|0)>0){d=0;do{fF(m+(d*152|0)|0,(c[b+56>>2]|0)+(d*152|0)|0,152)|0;d=d+1|0}while((d|0)!=(o|0))}o=c[b+56>>2]|0;if(o){if(a[b+60>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[o+-4>>2]|0)}c[b+56>>2]=0}a[b+60>>0]=1;c[b+56>>2]=m;c[b+52>>2]=n}c[b+48>>2]=n;if((k|0)>0){m=c[b+176>>2]|0;U=0;V=0;while(1){T=m+(V<<3)|0;if(!(c[T>>2]|0))o=0;else{m=c[b+56>>2]|0;o=j+(V<<2)|0;n=c[o>>2]|0;e=c[n+28>>2]|0;q=c[n+32>>2]|0;d=_r(b,e,+g[l+12>>2])|0;R=_r(b,q,+g[l+12>>2])|0;S=c[b+16>>2]|0;s=c[n+24>>2]|0;s=(s|0)>0?s:c[l+20>>2]|0;if((s|0)>(c[b+184>>2]|0))c[b+184>>2]=s;if((c[T>>2]|0)>0){r=0;do{X=r+U|0;cF(m+(X*152|0)|0,0,152)|0;g[m+(X*152|0)+120>>2]=-3402823466385288598117041.0e14;g[m+(X*152|0)+124>>2]=3402823466385288598117041.0e14;g[m+(X*152|0)+100>>2]=0.0;g[m+(X*152|0)+96>>2]=0.0;c[m+(X*152|0)+144>>2]=d;c[m+(X*152|0)+148>>2]=R;c[m+(X*152|0)+136>>2]=s;r=r+1|0}while((r|0)<(c[T>>2]|0))}c[S+(d*244|0)+64>>2]=0;c[S+(d*244|0)+68>>2]=0;c[S+(d*244|0)+72>>2]=0;c[S+(d*244|0)+76>>2]=0;c[S+(d*244|0)+80>>2]=0;c[S+(d*244|0)+84>>2]=0;c[S+(d*244|0)+88>>2]=0;c[S+(d*244|0)+92>>2]=0;c[S+(d*244|0)+144>>2]=0;c[S+(d*244|0)+148>>2]=0;c[S+(d*244|0)+152>>2]=0;c[S+(d*244|0)+156>>2]=0;c[S+(d*244|0)+160>>2]=0;c[S+(d*244|0)+164>>2]=0;c[S+(d*244|0)+168>>2]=0;c[S+(d*244|0)+172>>2]=0;c[S+(R*244|0)+64>>2]=0;c[S+(R*244|0)+68>>2]=0;c[S+(R*244|0)+72>>2]=0;c[S+(R*244|0)+76>>2]=0;c[S+(R*244|0)+80>>2]=0;c[S+(R*244|0)+84>>2]=0;c[S+(R*244|0)+88>>2]=0;c[S+(R*244|0)+92>>2]=0;c[S+(R*244|0)+144>>2]=0;c[S+(R*244|0)+148>>2]=0;c[S+(R*244|0)+152>>2]=0;c[S+(R*244|0)+156>>2]=0;c[S+(R*244|0)+160>>2]=0;c[S+(R*244|0)+164>>2]=0;c[S+(R*244|0)+168>>2]=0;c[S+(R*244|0)+172>>2]=0;g[W>>2]=1.0/+g[l+12>>2];g[W+4>>2]=+g[l+32>>2];c[W+8>>2]=m+(U*152|0)+16;c[W+12>>2]=m+(U*152|0);c[W+16>>2]=m+(U*152|0)+48;c[W+20>>2]=m+(U*152|0)+32;c[W+24>>2]=38;c[W+28>>2]=m+(U*152|0)+112;X=m+(U*152|0)+116|0;g[X>>2]=+g[l+40>>2];g[W+52>>2]=+g[l+4>>2];c[W+32>>2]=X;c[W+36>>2]=m+(U*152|0)+120;c[W+40>>2]=m+(U*152|0)+124;c[W+48>>2]=c[l+20>>2];X=c[o>>2]|0;Lb[c[(c[X>>2]|0)+20>>2]&127](X,W);if((c[T>>2]|0)>0){r=0;do{s=r+U|0;t=+g[(c[o>>2]|0)+16>>2];if(+g[m+(s*152|0)+124>>2]>=t)g[m+(s*152|0)+124>>2]=t;if(+g[m+(s*152|0)+120>>2]<=-t)g[m+(s*152|0)+120>>2]=-t;c[m+(s*152|0)+132>>2]=n;X=c[n+28>>2]|0;C=+g[m+(s*152|0)>>2];F=+g[m+(s*152|0)+4>>2];z=+g[m+(s*152|0)+8>>2];E=(C*+g[X+280>>2]+F*+g[X+284>>2]+z*+g[X+288>>2])*+g[X+548>>2];G=(C*+g[X+296>>2]+F*+g[X+300>>2]+z*+g[X+304>>2])*+g[X+552>>2];g[m+(s*152|0)+64>>2]=(+g[X+264>>2]*C+ +g[X+268>>2]*F+ +g[X+272>>2]*z)*+g[X+544>>2];g[m+(s*152|0)+68>>2]=E;g[m+(s*152|0)+72>>2]=G;g[m+(s*152|0)+76>>2]=0.0;X=c[n+32>>2]|0;G=+g[m+(s*152|0)+32>>2];E=+g[m+(s*152|0)+36>>2];z=+g[m+(s*152|0)+40>>2];F=(G*+g[X+280>>2]+E*+g[X+284>>2]+z*+g[X+288>>2])*+g[X+548>>2];C=(G*+g[X+296>>2]+E*+g[X+300>>2]+z*+g[X+304>>2])*+g[X+552>>2];g[m+(s*152|0)+80>>2]=(+g[X+264>>2]*G+ +g[X+268>>2]*E+ +g[X+272>>2]*z)*+g[X+544>>2];g[m+(s*152|0)+84>>2]=F;g[m+(s*152|0)+88>>2]=C;g[m+(s*152|0)+92>>2]=0.0;C=+g[e+344>>2];F=+g[m+(s*152|0)+16>>2];G=+g[m+(s*152|0)+20>>2];H=+g[m+(s*152|0)+24>>2];I=+g[m+(s*152|0)>>2];J=+g[m+(s*152|0)+4>>2];K=+g[m+(s*152|0)+8>>2];D=+g[q+344>>2];L=+g[m+(s*152|0)+48>>2];M=+g[m+(s*152|0)+52>>2];N=+g[m+(s*152|0)+56>>2];Q=+g[m+(s*152|0)+32>>2];z=F*(C*F)+G*(C*G)+H*(C*H)+(I*(+g[e+264>>2]*I+ +g[e+268>>2]*J+ +g[e+272>>2]*K)+J*(I*+g[e+280>>2]+J*+g[e+284>>2]+K*+g[e+288>>2])+K*(I*+g[e+296>>2]+J*+g[e+300>>2]+K*+g[e+304>>2]))+(L*(D*L)+M*(D*M)+N*(D*N))+(Q*(+g[q+264>>2]*Q+ +g[q+268>>2]*E+ +g[q+272>>2]*z)+E*(Q*+g[q+280>>2]+E*+g[q+284>>2]+z*+g[q+288>>2])+z*(Q*+g[q+296>>2]+E*+g[q+300>>2]+z*+g[q+304>>2]));if(+O(+z)>1.1920928955078125e-07)z=1.0/z;else z=0.0;g[m+(s*152|0)+108>>2]=z;if(!(c[S+(d*244|0)+240>>2]|0)){y=0.0;x=0.0;w=0.0;v=0.0;t=0.0;u=0.0}else{y=+g[S+(d*244|0)+208>>2];x=+g[S+(d*244|0)+212>>2];w=+g[S+(d*244|0)+216>>2];v=+g[S+(d*244|0)+224>>2];t=+g[S+(d*244|0)+228>>2];u=+g[S+(d*244|0)+232>>2]}if(!(c[S+(R*244|0)+240>>2]|0)){A=0.0;p=0.0;B=0.0;C=0.0;D=0.0;E=0.0}else{A=+g[S+(R*244|0)+208>>2];p=+g[S+(R*244|0)+212>>2];B=+g[S+(R*244|0)+216>>2];C=+g[S+(R*244|0)+224>>2];D=+g[S+(R*244|0)+228>>2];E=+g[S+(R*244|0)+232>>2]}g[m+(s*152|0)+112>>2]=+g[m+(s*152|0)+112>>2]*z+z*(0.0-+g[W+52>>2]*((y+ +g[e+312>>2])*F+(x+ +g[e+316>>2])*G+(w+ +g[e+320>>2])*H+((v+ +g[e+328>>2])*I+(t+ +g[e+332>>2])*J+(u+ +g[e+336>>2])*K)+((A+ +g[q+312>>2])*L+(p+ +g[q+316>>2])*M+(B+ +g[q+320>>2])*N+((C+ +g[q+328>>2])*Q+(D+ +g[q+332>>2])*+g[m+(s*152|0)+36>>2]+(E+ +g[q+336>>2])*+g[m+(s*152|0)+40>>2]))));g[m+(s*152|0)+100>>2]=0.0;r=r+1|0}while((r|0)<(c[T>>2]|0))}o=c[b+176>>2]|0;m=o;o=c[o+(V<<3)>>2]|0}V=V+1|0;if((V|0)>=(k|0))break;else U=o+U|0}}tc[c[(c[b>>2]|0)+28>>2]&127](b,f,h,l);s=c[b+48>>2]|0;r=c[b+28>>2]|0;e=c[b+68>>2]|0;d=c[b+128>>2]|0;if((d|0)<(s|0)?(c[b+132>>2]|0)<(s|0):0){if(!s)n=0;else{c[5132]=(c[5132]|0)+1;n=ZE((s<<2|3)+16|0)|0;if(!n)n=0;else{c[(n+19&-16)+-4>>2]=n;n=n+19&-16}d=c[b+128>>2]|0}if((d|0)>0){o=0;do{m=n+(o<<2)|0;if(m)c[m>>2]=c[(c[b+136>>2]|0)+(o<<2)>>2];o=o+1|0}while((o|0)!=(d|0))}d=c[b+136>>2]|0;if(d){if(a[b+140>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+136>>2]=0}a[b+140>>0]=1;c[b+136>>2]=n;c[b+132>>2]=s}c[b+128>>2]=s;if(!(c[l+64>>2]&16)){d=c[b+108>>2]|0;if((d|0)<(r|0)?(c[b+112>>2]|0)<(r|0):0){if(!r)n=0;else{c[5132]=(c[5132]|0)+1;n=ZE((r<<2|3)+16|0)|0;if(!n)n=0;else{c[(n+19&-16)+-4>>2]=n;n=n+19&-16}d=c[b+108>>2]|0}if((d|0)>0){m=0;do{o=n+(m<<2)|0;if(o)c[o>>2]=c[(c[b+116>>2]|0)+(m<<2)>>2];m=m+1|0}while((m|0)!=(d|0))}d=c[b+116>>2]|0;if(d){if(a[b+120>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+116>>2]=0}a[b+120>>0]=1;c[b+116>>2]=n;c[b+112>>2]=r}c[b+108>>2]=r}else{d=c[b+108>>2]|0;if((d|0)<(r<<1|0)?(c[b+112>>2]|0)<(r<<1|0):0){if(!r)n=0;else{c[5132]=(c[5132]|0)+1;n=ZE((r<<3|3)+16|0)|0;if(!n)n=0;else{c[(n+19&-16)+-4>>2]=n;n=n+19&-16}d=c[b+108>>2]|0}if((d|0)>0){m=0;do{o=n+(m<<2)|0;if(o)c[o>>2]=c[(c[b+116>>2]|0)+(m<<2)>>2];m=m+1|0}while((m|0)!=(d|0))}d=c[b+116>>2]|0;if(d){if(a[b+120>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+116>>2]=0}a[b+120>>0]=1;c[b+116>>2]=n;c[b+112>>2]=r<<1}c[b+108>>2]=r<<1}d=c[b+148>>2]|0;if((d|0)<(e|0)?(c[b+152>>2]|0)<(e|0):0){if(!e)n=0;else{c[5132]=(c[5132]|0)+1;n=ZE((e<<2|3)+16|0)|0;if(!n)n=0;else{c[(n+19&-16)+-4>>2]=n;n=n+19&-16}d=c[b+148>>2]|0}if((d|0)>0){m=0;do{o=n+(m<<2)|0;if(o)c[o>>2]=c[(c[b+156>>2]|0)+(m<<2)>>2];m=m+1|0}while((m|0)!=(d|0))}d=c[b+156>>2]|0;if(d){if(a[b+160>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+156>>2]=0}a[b+160>>0]=1;c[b+156>>2]=n;c[b+152>>2]=e}c[b+148>>2]=e;if((s|0)>0){n=c[b+136>>2]|0;d=0;do{c[n+(d<<2)>>2]=d;d=d+1|0}while((d|0)!=(s|0))}if((r|0)>0){n=c[b+116>>2]|0;d=0;do{c[n+(d<<2)>>2]=d;d=d+1|0}while((d|0)!=(r|0))}if((e|0)>0){d=c[b+156>>2]|0;n=0;do{c[d+(n<<2)>>2]=n;n=n+1|0}while((n|0)!=(e|0))}d=c[5128]|0;X=(c[d+16>>2]|0)+-1|0;c[d+16>>2]=X;if(X){i=W;return 0.0}do if(c[d+4>>2]|0){Cb(W+304|0,0)|0;X=c[5114]|0;g[d+8>>2]=+(((c[W+308>>2]|0)-(c[X+4>>2]|0)+(((c[W+304>>2]|0)-(c[X>>2]|0)|0)*1e6|0)-(c[d+12>>2]|0)|0)>>>0)/1.0e3+ +g[d+8>>2];if(!(c[d+16>>2]|0)){d=c[5128]|0;break}else{i=W;return 0.0}}while(0);c[5128]=c[d+20>>2];i=W;return 0.0}function bs(b,d,e,f,h,i,j,k,l,m){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0.0,p=0,q=0,r=0,s=0,t=0,u=0.0;n=c[b+48>>2]|0;q=c[b+28>>2]|0;r=c[b+68>>2]|0;if(c[l+64>>2]&1){if((n|0)>0){e=c[b+136>>2]|0;m=c[b+192>>2]|0;p=0;do{f=e+(p<<2)|0;i=c[f>>2]|0;p=p+1|0;m=($(m,1664525)|0)+1013904223|0;if(p>>>0<65537){h=m>>>16^m;if(p>>>0<257)if(p>>>0<17){h=(h>>>8^h)>>>4^(h>>>8^h);if(p>>>0<5)if(p>>>0<3)h=(h>>>2^h)>>>1^(h>>>2^h);else h=h>>>2^h}else h=h>>>8^h}else h=m;h=e+(((h>>>0)%(p>>>0)|0)<<2)|0;c[f>>2]=c[h>>2];c[h>>2]=i}while((p|0)!=(n|0));c[b+192>>2]=m}if((c[l+20>>2]|0)>(d|0)){if((q|0)>0){e=c[b+116>>2]|0;m=c[b+192>>2]|0;n=0;do{f=e+(n<<2)|0;i=c[f>>2]|0;n=n+1|0;m=($(m,1664525)|0)+1013904223|0;if(n>>>0<65537){h=m>>>16^m;if(n>>>0<257)if(n>>>0<17){h=(h>>>8^h)>>>4^(h>>>8^h);if(n>>>0<5)if(n>>>0<3)h=(h>>>2^h)>>>1^(h>>>2^h);else h=h>>>2^h}else h=h>>>8^h}else h=m;p=e+(((h>>>0)%(n>>>0)|0)<<2)|0;c[f>>2]=c[p>>2];c[p>>2]=i}while((n|0)!=(q|0));c[b+192>>2]=m}if((r|0)>0){e=c[b+156>>2]|0;m=c[b+192>>2]|0;n=0;do{f=e+(n<<2)|0;i=c[f>>2]|0;n=n+1|0;m=($(m,1664525)|0)+1013904223|0;if(n>>>0<65537){h=m>>>16^m;if(n>>>0<257)if(n>>>0<17){h=(h>>>8^h)>>>4^(h>>>8^h);if(n>>>0<5)if(n>>>0<3)h=(h>>>2^h)>>>1^(h>>>2^h);else h=h>>>2^h}else h=h>>>8^h}else h=m;q=e+(((h>>>0)%(n>>>0)|0)<<2)|0;c[f>>2]=c[q>>2];c[q>>2]=i}while((n|0)!=(r|0));c[b+192>>2]=m}}}e=c[b+48>>2]|0;if(!(c[l+64>>2]&256)){if((e|0)>0){n=0;do{f=c[(c[b+136>>2]|0)+(n<<2)>>2]|0;i=c[b+56>>2]|0;if((c[i+(f*152|0)+136>>2]|0)>(d|0)){e=c[b+16>>2]|0;Tr(e+((c[i+(f*152|0)+144>>2]|0)*244|0)|0,e+((c[i+(f*152|0)+148>>2]|0)*244|0)|0,i+(f*152|0)|0);e=c[b+48>>2]|0}n=n+1|0}while((n|0)<(e|0))}if((c[l+20>>2]|0)<=(d|0))return 0.0;if((k|0)>0){i=0;do{e=j+(i<<2)|0;f=c[e>>2]|0;if(a[f+20>>0]|0){r=_r(b,c[f+28>>2]|0,+g[l+12>>2])|0;t=_r(b,c[(c[e>>2]|0)+32>>2]|0,+g[l+12>>2])|0;d=c[b+16>>2]|0;q=c[e>>2]|0;oc[c[(c[q>>2]|0)+24>>2]&15](q,d+(r*244|0)|0,d+(t*244|0)|0,+g[l+12>>2])}i=i+1|0}while((i|0)!=(k|0))}n=c[b+28>>2]|0;if((n|0)>0){i=0;do{l=c[(c[b+116>>2]|0)+(i<<2)>>2]|0;k=c[b+36>>2]|0;j=c[b+16>>2]|0;Ur(j+((c[k+(l*152|0)+144>>2]|0)*244|0)|0,j+((c[k+(l*152|0)+148>>2]|0)*244|0)|0,k+(l*152|0)|0);i=i+1|0}while((i|0)!=(n|0))}f=c[b+68>>2]|0;if((f|0)>0){e=0;do{i=c[(c[b+156>>2]|0)+(e<<2)>>2]|0;n=c[b+76>>2]|0;o=+g[(c[b+36>>2]|0)+((c[n+(i*152|0)+140>>2]|0)*152|0)+100>>2];if(o>0.0){o=o*+g[n+(i*152|0)+104>>2];g[n+(i*152|0)+120>>2]=-o;g[n+(i*152|0)+124>>2]=o;l=c[b+16>>2]|0;Tr(l+((c[n+(i*152|0)+144>>2]|0)*244|0)|0,l+((c[n+(i*152|0)+148>>2]|0)*244|0)|0,n+(i*152|0)|0)}e=e+1|0}while((e|0)!=(f|0))}i=c[b+88>>2]|0;if((i|0)<=0)return 0.0;f=0;do{n=c[b+96>>2]|0;o=+g[(c[b+36>>2]|0)+((c[n+(f*152|0)+140>>2]|0)*152|0)+100>>2];if(o>0.0){u=+g[n+(f*152|0)+104>>2];o=o*u>u?u:o*u;g[n+(f*152|0)+120>>2]=-o;g[n+(f*152|0)+124>>2]=o;l=c[b+16>>2]|0;Tr(l+((c[n+(f*152|0)+144>>2]|0)*244|0)|0,l+((c[n+(f*152|0)+148>>2]|0)*244|0)|0,n+(f*152|0)|0)}f=f+1|0}while((f|0)!=(i|0));return 0.0}if((e|0)>0){h=0;do{f=c[(c[b+136>>2]|0)+(h<<2)>>2]|0;i=c[b+56>>2]|0;if((c[i+(f*152|0)+136>>2]|0)>(d|0)){e=c[b+16>>2]|0;Tr(e+((c[i+(f*152|0)+144>>2]|0)*244|0)|0,e+((c[i+(f*152|0)+148>>2]|0)*244|0)|0,i+(f*152|0)|0);e=c[b+48>>2]|0}h=h+1|0}while((h|0)<(e|0))}if((c[l+20>>2]|0)<=(d|0))return 0.0;if((k|0)>0){i=0;do{e=j+(i<<2)|0;f=c[e>>2]|0;if(a[f+20>>0]|0){q=_r(b,c[f+28>>2]|0,+g[l+12>>2])|0;d=_r(b,c[(c[e>>2]|0)+32>>2]|0,+g[l+12>>2])|0;r=c[b+16>>2]|0;p=c[e>>2]|0;oc[c[(c[p>>2]|0)+24>>2]&15](p,r+(q*244|0)|0,r+(d*244|0)|0,+g[l+12>>2])}i=i+1|0}while((i|0)!=(k|0))}e=c[l+64>>2]|0;h=c[b+28>>2]|0;if(e&512){if((h|0)<=0)return 0.0;m=0;do{f=c[(c[b+116>>2]|0)+(m<<2)>>2]|0;i=c[b+36>>2]|0;n=c[b+16>>2]|0;Ur(n+((c[i+(f*152|0)+144>>2]|0)*244|0)|0,n+((c[i+(f*152|0)+148>>2]|0)*244|0)|0,i+(f*152|0)|0);o=+g[i+(f*152|0)+100>>2];f=$(m,(e>>>4&1)+1|0)|0;i=c[(c[b+156>>2]|0)+(f<<2)>>2]|0;n=c[b+76>>2]|0;if(o>0.0){u=o*+g[n+(i*152|0)+104>>2];g[n+(i*152|0)+120>>2]=-u;g[n+(i*152|0)+124>>2]=u;k=c[b+16>>2]|0;Tr(k+((c[n+(i*152|0)+144>>2]|0)*244|0)|0,k+((c[n+(i*152|0)+148>>2]|0)*244|0)|0,n+(i*152|0)|0)}if((c[l+64>>2]&16|0)!=0?(s=c[(c[b+156>>2]|0)+(f+1<<2)>>2]|0,t=c[b+76>>2]|0,o>0.0):0){u=o*+g[t+(s*152|0)+104>>2];g[t+(s*152|0)+120>>2]=-u;g[t+(s*152|0)+124>>2]=u;k=c[b+16>>2]|0;Tr(k+((c[t+(s*152|0)+144>>2]|0)*244|0)|0,k+((c[t+(s*152|0)+148>>2]|0)*244|0)|0,t+(s*152|0)|0)}m=m+1|0}while((m|0)!=(h|0));return 0.0}if((h|0)>0){n=0;do{l=c[(c[b+116>>2]|0)+(n<<2)>>2]|0;k=c[b+36>>2]|0;j=c[b+16>>2]|0;Ur(j+((c[k+(l*152|0)+144>>2]|0)*244|0)|0,j+((c[k+(l*152|0)+148>>2]|0)*244|0)|0,k+(l*152|0)|0);n=n+1|0}while((n|0)!=(h|0))}f=c[b+68>>2]|0;if((f|0)>0){e=0;do{i=c[(c[b+156>>2]|0)+(e<<2)>>2]|0;n=c[b+76>>2]|0;o=+g[(c[b+36>>2]|0)+((c[n+(i*152|0)+140>>2]|0)*152|0)+100>>2];if(o>0.0){u=o*+g[n+(i*152|0)+104>>2];g[n+(i*152|0)+120>>2]=-u;g[n+(i*152|0)+124>>2]=u;l=c[b+16>>2]|0;Tr(l+((c[n+(i*152|0)+144>>2]|0)*244|0)|0,l+((c[n+(i*152|0)+148>>2]|0)*244|0)|0,n+(i*152|0)|0)}e=e+1|0}while((e|0)!=(f|0))}i=c[b+88>>2]|0;if((i|0)<=0)return 0.0;f=0;do{n=c[b+96>>2]|0;o=+g[(c[b+36>>2]|0)+((c[n+(f*152|0)+140>>2]|0)*152|0)+100>>2];if(o>0.0){u=+g[n+(f*152|0)+104>>2];u=o*u>u?u:o*u;g[n+(f*152|0)+120>>2]=-u;g[n+(f*152|0)+124>>2]=u;l=c[b+16>>2]|0;Tr(l+((c[n+(f*152|0)+144>>2]|0)*244|0)|0,l+((c[n+(f*152|0)+148>>2]|0)*244|0)|0,n+(f*152|0)|0)}f=f+1|0}while((f|0)!=(i|0));return 0.0}function cs(a,b,d,e,f,g,h,i,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;if(!(c[i+44>>2]|0))return;j=c[i+20>>2]|0;if(!(c[i+64>>2]&256)){if((j|0)<=0)return;b=0;do{g=c[a+28>>2]|0;if((g|0)>0){j=0;do{f=c[(c[a+116>>2]|0)+(j<<2)>>2]|0;h=c[a+36>>2]|0;d=c[a+16>>2]|0;Vr(d+((c[h+(f*152|0)+144>>2]|0)*244|0)|0,d+((c[h+(f*152|0)+148>>2]|0)*244|0)|0,h+(f*152|0)|0);j=j+1|0}while((j|0)!=(g|0));j=c[i+20>>2]|0}b=b+1|0}while((b|0)<(j|0));return}else{if((j|0)<=0)return;b=0;do{g=c[a+28>>2]|0;if((g|0)>0){j=0;do{f=c[(c[a+116>>2]|0)+(j<<2)>>2]|0;h=c[a+36>>2]|0;d=c[a+16>>2]|0;Vr(d+((c[h+(f*152|0)+144>>2]|0)*244|0)|0,d+((c[h+(f*152|0)+148>>2]|0)*244|0)|0,h+(f*152|0)|0);j=j+1|0}while((j|0)!=(g|0));j=c[i+20>>2]|0}b=b+1|0}while((b|0)<(j|0));return}}function ds(a,b,d,e,f,h,j,k,l){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0;o=i;i=i+16|0;jE(4160);cc[c[(c[a>>2]|0)+32>>2]&1](a,b,d,e,f,h,j,k,l);n=c[a+184>>2]|0;m=c[k+20>>2]|0;m=(n|0)>(m|0)?n:m;if((m|0)>0){n=0;do{+gc[c[(c[a>>2]|0)+40>>2]&3](a,n,b,d,e,f,h,j,k,l);n=n+1|0}while((n|0)<(m|0))}m=c[5128]|0;a=(c[m+16>>2]|0)+-1|0;c[m+16>>2]=a;if(a){i=o;return 0.0}do if(c[m+4>>2]|0){Cb(o|0,0)|0;a=c[5114]|0;g[m+8>>2]=+(((c[o+4>>2]|0)-(c[a+4>>2]|0)+(((c[o>>2]|0)-(c[a>>2]|0)|0)*1e6|0)-(c[m+12>>2]|0)|0)>>>0)/1.0e3+ +g[m+8>>2];if(!(c[m+16>>2]|0)){m=c[5128]|0;break}else{i=o;return 0.0}}while(0);c[5128]=c[m+20>>2];i=o;return 0.0}function es(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0,q=0,r=0,s=0.0,t=0.0;r=i;i=i+80|0;h=c[b+28>>2]|0;e=c[f+64>>2]|0;if((e&4|0)!=0&(h|0)>0){k=c[b+36>>2]|0;d=c[b+76>>2]|0;if(!(e&16)){e=0;do{p=c[k+(e*152|0)+132>>2]|0;g[p+120>>2]=+g[k+(e*152|0)+100>>2];g[p+124>>2]=+g[d+((c[k+(e*152|0)+140>>2]|0)*152|0)+100>>2];e=e+1|0}while((e|0)!=(h|0))}else{e=0;do{p=c[k+(e*152|0)+132>>2]|0;g[p+120>>2]=+g[k+(e*152|0)+100>>2];l=c[k+(e*152|0)+140>>2]|0;g[p+124>>2]=+g[d+(l*152|0)+100>>2];g[p+128>>2]=+g[d+((l+1|0)*152|0)+100>>2];e=e+1|0}while((e|0)!=(h|0))}}h=c[b+48>>2]|0;if((h|0)>0){l=0;do{d=c[b+56>>2]|0;j=c[d+(l*152|0)+132>>2]|0;k=c[j+44>>2]|0;e=d+(l*152|0)+100|0;if(k){o=+g[e>>2];p=c[j+28>>2]|0;n=1.0/+g[f+12>>2];m=o*+g[d+(l*152|0)+20>>2]*+g[p+352>>2]*n;s=o*+g[d+(l*152|0)+24>>2]*+g[p+356>>2]*n;g[k>>2]=+g[d+(l*152|0)+16>>2]*o*+g[p+348>>2]*n+ +g[k>>2];g[k+4>>2]=m+ +g[k+4>>2];g[k+8>>2]=s+ +g[k+8>>2];s=+g[e>>2];p=c[j+32>>2]|0;m=1.0/+g[f+12>>2];n=s*+g[d+(l*152|0)+52>>2]*+g[p+352>>2]*m;o=s*+g[d+(l*152|0)+56>>2]*+g[p+356>>2]*m;g[k+32>>2]=+g[d+(l*152|0)+48>>2]*s*+g[p+348>>2]*m+ +g[k+32>>2];g[k+36>>2]=n+ +g[k+36>>2];g[k+40>>2]=o+ +g[k+40>>2];p=c[j+28>>2]|0;o=+g[e>>2];n=1.0/+g[f+12>>2];m=+g[d+(l*152|0)+4>>2]*+g[p+548>>2]*o*n;s=o*(+g[d+(l*152|0)+8>>2]*+g[p+552>>2])*n;g[k+16>>2]=+g[d+(l*152|0)>>2]*+g[p+544>>2]*o*n+ +g[k+16>>2];g[k+20>>2]=m+ +g[k+20>>2];g[k+24>>2]=s+ +g[k+24>>2];p=c[j+32>>2]|0;s=+g[e>>2];m=1.0/+g[f+12>>2];n=+g[d+(l*152|0)+36>>2]*+g[p+548>>2]*s*m;o=s*(+g[d+(l*152|0)+40>>2]*+g[p+552>>2])*m;g[k+48>>2]=+g[d+(l*152|0)+32>>2]*+g[p+544>>2]*s*m+ +g[k+48>>2];g[k+52>>2]=n+ +g[k+52>>2];g[k+56>>2]=o+ +g[k+56>>2]}s=+g[e>>2];g[j+36>>2]=s;s=+O(+s);if(s>=+g[j+16>>2])a[j+20>>0]=0;l=l+1|0}while((l|0)!=(h|0))}e=c[b+8>>2]|0;if((e|0)>0){d=c[b+16>>2]|0;p=0;do{j=d+(p*244|0)|0;h=c[d+(p*244|0)+240>>2]|0;if(h){if(!(c[f+44>>2]|0)){l=d+(p*244|0)+176|0;n=+g[d+(p*244|0)+64>>2]+ +g[l>>2];g[l>>2]=n;l=d+(p*244|0)+180|0;m=+g[d+(p*244|0)+68>>2]+ +g[l>>2];g[l>>2]=m;l=d+(p*244|0)+184|0;o=+g[d+(p*244|0)+72>>2]+ +g[l>>2];g[l>>2]=o;l=d+(p*244|0)+192|0;g[l>>2]=+g[d+(p*244|0)+80>>2]+ +g[l>>2];l=d+(p*244|0)+196|0;g[l>>2]=+g[d+(p*244|0)+84>>2]+ +g[l>>2];l=d+(p*244|0)+200|0;g[l>>2]=+g[d+(p*244|0)+88>>2]+ +g[l>>2]}else{m=+g[f+12>>2];n=+g[f+52>>2];k=d+(p*244|0)+176|0;g[k>>2]=+g[d+(p*244|0)+64>>2]+ +g[k>>2];k=d+(p*244|0)+180|0;g[k>>2]=+g[d+(p*244|0)+68>>2]+ +g[k>>2];k=d+(p*244|0)+184|0;g[k>>2]=+g[d+(p*244|0)+72>>2]+ +g[k>>2];k=d+(p*244|0)+192|0;g[k>>2]=+g[d+(p*244|0)+80>>2]+ +g[k>>2];k=d+(p*244|0)+196|0;g[k>>2]=+g[d+(p*244|0)+84>>2]+ +g[k>>2];k=d+(p*244|0)+200|0;g[k>>2]=+g[d+(p*244|0)+88>>2]+ +g[k>>2];k=d+(p*244|0)+144|0;l=d+(p*244|0)+148|0;if(((((!(+g[k>>2]!=0.0)?!(+g[l>>2]!=0.0):0)?!(+g[d+(p*244|0)+152>>2]!=0.0):0)?!(+g[d+(p*244|0)+160>>2]!=0.0):0)?!(+g[d+(p*244|0)+164>>2]!=0.0):0)?!(+g[d+(p*244|0)+168>>2]!=0.0):0)e=d;else q=22;if((q|0)==22){q=0;o=+g[d+(p*244|0)+164>>2]*n;s=+g[d+(p*244|0)+168>>2]*n;g[r>>2]=+g[d+(p*244|0)+160>>2]*n;g[r+4>>2]=o;g[r+8>>2]=s;g[r+12>>2]=0.0;Jp(j,+g[k>>2],+g[l>>2],+g[d+(p*244|0)+152>>2],r,m,r+16|0);c[j+0>>2]=c[r+16>>2];c[j+4>>2]=c[r+20>>2];c[j+8>>2]=c[r+24>>2];c[j+12>>2]=c[r+28>>2];e=d+(p*244|0)+16|0;c[e+0>>2]=c[r+32>>2];c[e+4>>2]=c[r+36>>2];c[e+8>>2]=c[r+40>>2];c[e+12>>2]=c[r+44>>2];e=d+(p*244|0)+32|0;c[e+0>>2]=c[r+48>>2];c[e+4>>2]=c[r+52>>2];c[e+8>>2]=c[r+56>>2];c[e+12>>2]=c[r+60>>2];e=d+(p*244|0)+48|0;c[e+0>>2]=c[r+64>>2];c[e+4>>2]=c[r+68>>2];c[e+8>>2]=c[r+72>>2];c[e+12>>2]=c[r+76>>2];e=c[b+16>>2]|0}d=e;n=+g[e+(p*244|0)+176>>2];m=+g[e+(p*244|0)+180>>2];o=+g[e+(p*244|0)+184>>2];h=c[e+(p*244|0)+240>>2]|0}t=n+ +g[d+(p*244|0)+208>>2];s=m+ +g[d+(p*244|0)+212>>2];n=o+ +g[d+(p*244|0)+216>>2];k=h+260|0;c[k>>2]=(c[k>>2]|0)+1;g[h+312>>2]=t;g[h+316>>2]=s;g[h+320>>2]=n;g[h+324>>2]=0.0;k=c[b+16>>2]|0;l=c[k+(p*244|0)+240>>2]|0;n=+g[k+(p*244|0)+192>>2]+ +g[k+(p*244|0)+224>>2];o=+g[k+(p*244|0)+196>>2]+ +g[k+(p*244|0)+228>>2];s=+g[k+(p*244|0)+200>>2]+ +g[k+(p*244|0)+232>>2];c[l+260>>2]=(c[l+260>>2]|0)+1;g[l+328>>2]=n;g[l+332>>2]=o;g[l+336>>2]=s;g[l+340>>2]=0.0;if(c[f+44>>2]|0){k=c[b+16>>2]|0;l=c[k+(p*244|0)+240>>2]|0;j=k+(p*244|0)|0;c[l+260>>2]=(c[l+260>>2]|0)+1;c[l+4>>2]=c[j+0>>2];c[l+8>>2]=c[j+4>>2];c[l+12>>2]=c[j+8>>2];c[l+16>>2]=c[j+12>>2];j=k+(p*244|0)+16|0;c[l+20>>2]=c[j+0>>2];c[l+24>>2]=c[j+4>>2];c[l+28>>2]=c[j+8>>2];c[l+32>>2]=c[j+12>>2];j=k+(p*244|0)+32|0;c[l+36>>2]=c[j+0>>2];c[l+40>>2]=c[j+4>>2];c[l+44>>2]=c[j+8>>2];c[l+48>>2]=c[j+12>>2];k=k+(p*244|0)+48|0;c[l+52>>2]=c[k+0>>2];c[l+56>>2]=c[k+4>>2];c[l+60>>2]=c[k+8>>2];c[l+64>>2]=c[k+12>>2]}d=c[b+16>>2]|0;c[(c[d+(p*244|0)+240>>2]|0)+212>>2]=-1;e=c[b+8>>2]|0}p=p+1|0}while((p|0)<(e|0))}if((c[b+28>>2]|0)<0?(c[b+32>>2]|0)<0:0){d=c[b+36>>2]|0;if(d){if(a[b+40>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=0;c[b+32>>2]=0}c[b+28>>2]=0;if((c[b+48>>2]|0)<0?(c[b+52>>2]|0)<0:0){d=c[b+56>>2]|0;if(d){if(a[b+60>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+56>>2]=0}a[b+60>>0]=1;c[b+56>>2]=0;c[b+52>>2]=0}c[b+48>>2]=0;if((c[b+68>>2]|0)<0?(c[b+72>>2]|0)<0:0){d=c[b+76>>2]|0;if(d){if(a[b+80>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+76>>2]=0}a[b+80>>0]=1;c[b+76>>2]=0;c[b+72>>2]=0}c[b+68>>2]=0;if((c[b+88>>2]|0)<0?(c[b+92>>2]|0)<0:0){d=c[b+96>>2]|0;if(d){if(a[b+100>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=0;c[b+92>>2]=0}c[b+88>>2]=0;if((c[b+8>>2]|0)>=0){c[b+8>>2]=0;i=r;return 0.0}if((c[b+12>>2]|0)>=0){c[b+8>>2]=0;i=r;return 0.0}d=c[b+16>>2]|0;if(d){if(a[b+20>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[d+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=0;c[b+12>>2]=0;c[b+8>>2]=0;i=r;return 0.0}function fs(a,b,d,e,f,h,j,k,l,m){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0;n=i;i=i+16|0;jE(4200);+ic[c[(c[a>>2]|0)+44>>2]&3](a,b,d,e,f,h,j,k,l);+ic[c[(c[a>>2]|0)+48>>2]&3](a,b,d,e,f,h,j,k,l);+mc[c[(c[a>>2]|0)+36>>2]&1](a,b,d,k);m=c[5128]|0;a=(c[m+16>>2]|0)+-1|0;c[m+16>>2]=a;if(a){i=n;return 0.0}do if(c[m+4>>2]|0){Cb(n|0,0)|0;a=c[5114]|0;g[m+8>>2]=+(((c[n+4>>2]|0)-(c[a+4>>2]|0)+(((c[n>>2]|0)-(c[a>>2]|0)|0)*1e6|0)-(c[m+12>>2]|0)|0)>>>0)/1.0e3+ +g[m+8>>2];if(!(c[m+16>>2]|0)){m=c[5128]|0;break}else{i=n;return 0.0}}while(0);c[5128]=c[m+20>>2];i=n;return 0.0}function gs(a){a=a|0;c[a+192>>2]=0;return}function hs(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;i=c[b+4>>2]|0;if((i|0)==(c[b+8>>2]|0)?(h=(i|0)==0?1:i<<1,(i|0)<(h|0)):0){if(!h){e=0;f=i}else{c[5132]=(c[5132]|0)+1;e=ZE((h*244|3)+16|0)|0;if(!e)e=0;else{c[(e+19&-16)+-4>>2]=e;e=e+19&-16}f=c[b+4>>2]|0}if((f|0)>0){g=0;do{k=e+(g*244|0)|0;j=c[b+12>>2]|0;l=j+(g*244|0)|0;c[k+0>>2]=c[l+0>>2];c[k+4>>2]=c[l+4>>2];c[k+8>>2]=c[l+8>>2];c[k+12>>2]=c[l+12>>2];k=e+(g*244|0)+16|0;l=j+(g*244|0)+16|0;c[k+0>>2]=c[l+0>>2];c[k+4>>2]=c[l+4>>2];c[k+8>>2]=c[l+8>>2];c[k+12>>2]=c[l+12>>2];k=e+(g*244|0)+32|0;l=j+(g*244|0)+32|0;c[k+0>>2]=c[l+0>>2];c[k+4>>2]=c[l+4>>2];c[k+8>>2]=c[l+8>>2];c[k+12>>2]=c[l+12>>2];k=e+(g*244|0)+48|0;l=j+(g*244|0)+48|0;c[k+0>>2]=c[l+0>>2];c[k+4>>2]=c[l+4>>2];c[k+8>>2]=c[l+8>>2];c[k+12>>2]=c[l+12>>2];fF(e+(g*244|0)+64|0,j+(g*244|0)+64|0,180)|0;g=g+1|0}while((g|0)!=(f|0))}f=c[b+12>>2]|0;if(f){if(a[b+16>>0]|0){c[5134]=(c[5134]|0)+1;_E(c[f+-4>>2]|0)}c[b+12>>2]=0}a[b+16>>0]=1;c[b+12>>2]=e;c[b+8>>2]=h;e=c[b+4>>2]|0}else e=i;c[b+4>>2]=e+1;l=c[b+12>>2]|0;c[l+(i*244|0)+0>>2]=c[d+0>>2];c[l+(i*244|0)+4>>2]=c[d+4>>2];c[l+(i*244|0)+8>>2]=c[d+8>>2];c[l+(i*244|0)+12>>2]=c[d+12>>2];c[l+(i*244|0)+16>>2]=c[d+16>>2];c[l+(i*244|0)+20>>2]=c[d+20>>2];c[l+(i*244|0)+24>>2]=c[d+24>>2];c[l+(i*244|0)+28>>2]=c[d+28>>2];c[l+(i*244|0)+32>>2]=c[d+32>>2];c[l+(i*244|0)+36>>2]=c[d+36>>2];c[l+(i*244|0)+40>>2]=c[d+40>>2];c[l+(i*244|0)+44>>2]=c[d+44>>2];c[l+(i*244|0)+48>>2]=c[d+48>>2];c[l+(i*244|0)+52>>2]=c[d+52>>2];c[l+(i*244|0)+56>>2]=c[d+56>>2];c[l+(i*244|0)+60>>2]=c[d+60>>2];fF(l+(i*244|0)+64|0,d+64|0,180)|0;return (c[b+12>>2]|0)+(i*244|0)|0}function is(a){a=a|0;return 1}function js(a,b,c){a=a|0;b=b|0;c=c|0;return}function ks(a,b,c){a=a|0;b=b|0;c=c|0;return}
function nE(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0;L=i;i=i+160|0;do if((d-b|0)==1)f=c[(c[a+92>>2]|0)+(b<<2)>>2]|0;else if((d-b|0)==2){f=c[(c[a+92>>2]|0)+(b<<2)>>2]|0;k=c[f+88>>2]|0;l=c[f+200>>2]|0;j=c[f+92>>2]|0;h=c[f+204>>2]|0;if((k|0)==(l|0)){if((j|0)==(h|0))if((c[f+96>>2]|0)==(c[f+208>>2]|0))break;else g=j;else g=h;if((j|0)==(g|0)){J=(c[f+96>>2]|0)>(c[f+208>>2]|0);g=J?f+112|0:f;c[g>>2]=g;c[g+4>>2]=g;c[e>>2]=g;c[e+4>>2]=g;c[e+8>>2]=g;c[e+12>>2]=g;f=J?f:f+112|0}else{h=0;K=9}}else{g=h;h=(j|0)==(h|0);K=9}do if((K|0)==9){c[f>>2]=f+112;c[f+4>>2]=f+112;c[f+112>>2]=f;c[f+116>>2]=f;K=(j-g|0)<0;J=(k-l|0)<0|(k|0)==(l|0)&K;c[e>>2]=J?f:f+112|0;c[e+4>>2]=J?f+112|0:f;if(K|h&(k-l|0)<0){c[e+8>>2]=f;c[e+12>>2]=f+112;g=f;f=f+112|0;break}else{c[e+8>>2]=f+112;c[e+12>>2]=f;g=f;f=f+112|0;break}}while(0);a=mE(a,g,f)|0;c[a>>2]=a;c[a+4>>2]=a;c[g+8>>2]=a;a=c[a+8>>2]|0;c[a>>2]=a;c[a+4>>2]=a;c[f+8>>2]=a;i=L;return}else if(!(d-b|0)){c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;i=L;return}else{n=((d-b|0)/2|0)+b|0;m=c[a+92>>2]|0;h=c[m+(n+-1<<2)>>2]|0;k=c[h+88>>2]|0;j=c[h+92>>2]|0;h=c[h+96>>2]|0;a:do if((n|0)<(d|0)){f=n;while(1){g=c[m+(f<<2)>>2]|0;if((c[g+88>>2]|0)!=(k|0)){l=f;break a}if((c[g+92>>2]|0)!=(j|0)){l=f;break a}l=f+1|0;if((c[g+96>>2]|0)!=(h|0)){l=f;break a}if((l|0)<(d|0))f=l;else break}}else l=n;while(0);nE(a,b,n,e);c[L+136>>2]=0;c[L+140>>2]=0;c[L+144>>2]=0;c[L+148>>2]=0;nE(a,l,d,L+136|0);m=c[L+140>>2]|0;if(!m){i=L;return}v=c[e+4>>2]|0;if(!v){c[e+0>>2]=c[L+136>>2];c[e+4>>2]=c[L+140>>2];c[e+8>>2]=c[L+144>>2];c[e+12>>2]=c[L+148>>2];i=L;return}c[a+100>>2]=(c[a+100>>2]|0)+-1;g=c[e+12>>2]|0;j=c[L+144>>2]|0;h=c[g+88>>2]|0;b:do if((h|0)==(c[j+88>>2]|0)?(c[g+92>>2]|0)==(c[j+92>>2]|0):0){f=c[j+4>>2]|0;if((f|0)==(j|0)){f=c[j+8>>2]|0;if(f){j=c[f+12>>2]|0;h=c[j+88>>2]|0}k=c[j+96>>2]|0;l=h+1|0;h=j;break}h=c[j>>2]|0;c[f>>2]=h;c[h+4>>2]=f;c:do if((j|0)==(c[L+136>>2]|0)){l=c[h+88>>2]|0;k=c[f+88>>2]|0;do if((l|0)>=(k|0)){if((l|0)==(k|0)?(c[h+92>>2]|0)<(c[f+92>>2]|0):0)break;c[L+136>>2]=f;break c}while(0);c[L+136>>2]=h}while(0);if((j|0)==(m|0)){l=c[h+88>>2]|0;k=c[f+88>>2]|0;do if((l|0)<=(k|0)){if((l|0)==(k|0)?(c[h+92>>2]|0)>(c[f+92>>2]|0):0)break;c[L+140>>2]=f;m=f;K=39;break b}while(0);c[L+140>>2]=h;m=h;K=39}else K=39}else K=39;while(0);if((K|0)==39){y=c[e>>2]|0;x=c[L+136>>2]|0;b=0;w=1;d=v;H=0;n=m;h=0;d:while(1)while(1){s=c[d+88>>2]|0;o=$((c[n+88>>2]|0)-s|0,w)|0;e:do if((o|0)<=0){if((o|0)<0){t=(b|0)!=0;p=c[d+92>>2]|0;u=c[n+92>>2]|0;while(1){f=c[(t?n+4|0:n)>>2]|0;r=(f|0)==(n|0);s=n+88|0;while(1){q=d+88|0;j=u-p|0;if(!r?(C=c[f+88>>2]|0,E=$(C-(c[s>>2]|0)|0,w)|0,F=c[f+92>>2]|0,G=F-u|0,(G|0)>-1):0){if(!E)break;if((E|0)<0?($(G,o)|0)<=($(E,j)|0):0)break}g=c[(t?d+4|0:d)>>2]|0;if((g|0)==(d|0)){o=d;l=n;break e}B=c[g+88>>2]|0;l=$(B-(c[q>>2]|0)|0,w)|0;k=c[g+92>>2]|0;q=k-p|0;p=o;o=$((c[s>>2]|0)-B|0,w)|0;if(!((o|0)<0&(q|0)>0)){o=d;l=n;break e}if(!l){p=k;d=g;continue}if((l|0)>=0){o=d;l=n;break e}if(($(q,p)|0)>=($(l,j)|0)){o=d;l=n;break e}else{p=k;d=g}}u=F;o=$(C-(c[q>>2]|0)|0,w)|0;n=f}}l=c[d+92>>2]|0;q=(b|0)!=0;f:do if(q){o=d;while(1){k=c[o>>2]|0;if((k|0)==(d|0))break f;if((c[k+88>>2]|0)!=(s|0))break f;B=l;l=c[k+92>>2]|0;if((l|0)>(B|0))break;else o=k}}else{o=d;while(1){k=c[o+4>>2]|0;if((k|0)==(d|0))break f;if((c[k+88>>2]|0)!=(s|0))break f;B=l;l=c[k+92>>2]|0;if((l|0)>(B|0))break;else o=k}}while(0);k=c[n+92>>2]|0;if(q){l=n;while(1){d=c[l+4>>2]|0;if((d|0)==(n|0))break e;if((c[d+88>>2]|0)!=(s|0))break e;B=k;k=c[d+92>>2]|0;if((k|0)<(B|0))break;else l=d}}else{l=n;while(1){d=c[l>>2]|0;if((d|0)==(n|0))break e;if((c[d+88>>2]|0)!=(s|0))break e;B=k;k=c[d+92>>2]|0;if((k|0)<(B|0))break;else l=d}}}else{A=(b|0)!=0;z=c[n+92>>2]|0;while(1){B=n+88|0;l=d+88|0;q=c[d+92>>2]|0;k=z-q|0;p=c[(A?d:d+4|0)>>2]|0;g:do if((p|0)==(d|0)){s=l;j=o}else{s=c[d+88>>2]|0;f=o;while(1){j=s;s=c[p+88>>2]|0;j=$(s-j|0,w)|0;g=q;q=c[p+92>>2]|0;g=q-g|0;if((g|0)>=1){s=l;j=f;break g}if(j){if((j|0)>=0){s=l;j=f;break g}if(($(g,f)|0)>($(j,k)|0)){s=l;j=f;break g}}j=$((c[B>>2]|0)-s|0,w)|0;l=p+88|0;k=z-q|0;d=c[(A?p:p+4|0)>>2]|0;if((d|0)==(p|0)){s=l;d=p;break}else{u=p;p=d;f=j;d=u}}}while(0);q=c[(A?n:n+4|0)>>2]|0;if((q|0)==(n|0)){o=d;l=n;break e}o=c[q+88>>2]|0;p=$(o-(c[B>>2]|0)|0,w)|0;l=z;z=c[q+92>>2]|0;l=z-l|0;o=$(o-(c[s>>2]|0)|0,w)|0;if(!((o|0)>0&(l|0)<0)){o=d;l=n;break e}if(!p){n=q;continue}if((p|0)>=0){o=d;l=n;break e}if(($(l,j)|0)>=($(p,k)|0)){o=d;l=n;break}else n=q}}while(0);B=b;b=b+1|0;if(!B){w=-1;d=y;H=o;n=x;h=l;continue d}if((b|0)==2)break d;else{d=o;n=l}}c[o+4>>2]=l;c[l>>2]=o;c[H>>2]=h;c[h+4>>2]=H;if((c[x+88>>2]|0)<(c[y+88>>2]|0))c[e>>2]=x;if((c[m+88>>2]|0)>=(c[v+88>>2]|0))c[e+4>>2]=m;c[e+12>>2]=c[L+148>>2];u=c[h+88>>2]|0;n=c[H+88>>2]|0;t=c[h+92>>2]|0;s=c[H+92>>2]|0;r=c[h+96>>2]|0;m=c[H+96>>2]|0;f=((t-s|0)<0)<<31>>31;v=0-(u-n)|0;w=bF(0,0,v|0,((v|0)<0)<<31>>31|0)|0;w=pF(r-m|0,((r-m|0)<0)<<31>>31|0,w|0,D|0)|0;x=D;y=pF(r-m|0,((r-m|0)<0)<<31>>31|0,t-s|0,f|0)|0;z=D;l=pF(u-n|0,((u-n|0)<0)<<31>>31|0,v|0,((v|0)<0)<<31>>31|0)|0;B=D;A=pF(t-s|0,f|0,t-s|0,f|0)|0;A=bF(l|0,B|0,A|0,D|0)|0;B=D;l=c[H+8>>2]|0;c[L+104>>2]=0;if(!l)b=0;else{k=bF(0,0,t-s|0,f|0)|0;j=D;b=0;g=l;do{o=c[g+12>>2]|0;q=c[o+88>>2]|0;p=c[o+92>>2]|0;o=c[o+96>>2]|0;F=pF(p-s|0,((p-s|0)<0)<<31>>31|0,v|0,((v|0)<0)<<31>>31|0)|0;e=D;G=pF(q-n|0,((q-n|0)<0)<<31>>31|0,k|0,j|0)|0;h:do if((F|0)==(G|0)&(e|0)==(D|0)?(G=pF(q-n|0,((q-n|0)<0)<<31>>31|0,w|0,x|0)|0,F=D,e=pF(p-s|0,((p-s|0)<0)<<31>>31|0,y|0,z|0)|0,F=eF(e|0,D|0,G|0,F|0)|0,G=D,e=pF(o-m|0,((o-m|0)<0)<<31>>31|0,A|0,B|0)|0,e=eF(F|0,G|0,e|0,D|0)|0,G=D,(G|0)>0|(G|0)==0&e>>>0>0):0){do if(b){d=(c[b+4>>2]|0)==(g|0);if((c[b>>2]|0)!=(g|0))if(d)break;else break h;if(!d)break h;G=c[b+12>>2]|0;E=c[(c[g+8>>2]|0)+12>>2]|0;e=c[E+88>>2]|0;F=c[E+92>>2]|0;E=c[E+96>>2]|0;C=(c[G+96>>2]|0)-E|0;F=($(o-E|0,(c[G+92>>2]|0)-F|0)|0)-($(C,p-F|0)|0)|0;e=($(C,q-e|0)|0)-($(o-E|0,(c[G+88>>2]|0)-e|0)|0)|0;F=pF(F|0,((F|0)<0)<<31>>31|0,t-s|0,f|0)|0;G=D;e=pF(e|0,((e|0)<0)<<31>>31|0,v|0,((v|0)<0)<<31>>31|0)|0;e=eF(F|0,G|0,e|0,D|0)|0;G=D;if((G|0)>0|(G|0)==0&e>>>0>0)break h}while(0);c[L+104>>2]=g;b=g}while(0);g=c[g>>2]|0}while((g|0)!=(l|0))}n=c[h+8>>2]|0;c[L+100>>2]=0;if(!n)g=0;else{m=bF(0,0,t-s|0,f|0)|0;l=D;g=0;q=n;do{d=c[q+12>>2]|0;p=c[d+88>>2]|0;o=c[d+92>>2]|0;d=c[d+96>>2]|0;F=pF(o-t|0,((o-t|0)<0)<<31>>31|0,v|0,((v|0)<0)<<31>>31|0)|0;e=D;G=pF(p-u|0,((p-u|0)<0)<<31>>31|0,m|0,l|0)|0;do if((F|0)==(G|0)&(e|0)==(D|0)?(G=pF(p-u|0,((p-u|0)<0)<<31>>31|0,w|0,x|0)|0,F=D,e=pF(o-t|0,((o-t|0)<0)<<31>>31|0,y|0,z|0)|0,F=eF(e|0,D|0,G|0,F|0)|0,G=D,e=pF(d-r|0,((d-r|0)<0)<<31>>31|0,A|0,B|0)|0,e=eF(F|0,G|0,e|0,D|0)|0,G=D,(G|0)>0|(G|0)==0&e>>>0>0):0){if(g){if((c[g>>2]|0)!=(q|0))break;if((c[g+4>>2]|0)==(q|0)?(G=c[g+12>>2]|0,E=c[(c[q+8>>2]|0)+12>>2]|0,e=c[E+88>>2]|0,F=c[E+92>>2]|0,E=c[E+96>>2]|0,C=(c[G+96>>2]|0)-E|0,F=($(d-E|0,(c[G+92>>2]|0)-F|0)|0)-($(C,o-F|0)|0)|0,e=($(C,p-e|0)|0)-($(d-E|0,(c[G+88>>2]|0)-e|0)|0)|0,F=pF(F|0,((F|0)<0)<<31>>31|0,t-s|0,f|0)|0,G=D,e=pF(e|0,((e|0)<0)<<31>>31|0,v|0,((v|0)<0)<<31>>31|0)|0,e=eF(F|0,G|0,e|0,D|0)|0,G=D,!((G|0)>0|(G|0)==0&e>>>0>0)):0)break}c[L+100>>2]=q;g=q}while(0);q=c[q>>2]|0}while((q|0)!=(n|0))}if((b|0)!=0|(g|0)!=0){pE(a,H,h,L+104|0,L+100|0);g=c[L+104>>2]|0;if(!g)g=H;else g=c[g+12>>2]|0;f=c[L+100>>2]|0;if(f)h=c[f+12>>2]|0}else g=H;k=(c[h+96>>2]|0)+1|0;l=c[h+88>>2]|0}A=c[h+92>>2]|0;s=A;t=g;x=h;d=0;z=0;q=1;n=0;j=0;r=0;u=0;m=0;b=0;while(1){B=t+88|0;F=(c[x+88>>2]|0)-(c[B>>2]|0)|0;H=t+92|0;w=s-(c[H>>2]|0)|0;E=t+96|0;y=(c[x+96>>2]|0)-(c[E>>2]|0)|0;c[L+112>>2]=F;c[L+116>>2]=w;c[L+120>>2]=y;c[L+124>>2]=-1;B=l-(c[B>>2]|0)|0;H=A-(c[H>>2]|0)|0;E=k-(c[E>>2]|0)|0;C=($(y,H)|0)-($(w,E)|0)|0;E=($(F,E)|0)-($(y,B)|0)|0;H=($(w,B)|0)-($(F,H)|0)|0;c[L+72>>2]=C;c[L+76>>2]=((C|0)<0)<<31>>31;c[L+80>>2]=E;c[L+84>>2]=((E|0)<0)<<31>>31;c[L+88>>2]=H;c[L+92>>2]=((H|0)<0)<<31>>31;B=pF(H|0,((H|0)<0)<<31>>31|0,w|0,((w|0)<0)<<31>>31|0)|0;e=D;G=pF(y|0,((y|0)<0)<<31>>31|0,E|0,((E|0)<0)<<31>>31|0)|0;G=bF(B|0,e|0,G|0,D|0)|0;e=D;y=pF(C|0,((C|0)<0)<<31>>31|0,y|0,((y|0)<0)<<31>>31|0)|0;B=D;H=pF(F|0,((F|0)<0)<<31>>31|0,H|0,((H|0)<0)<<31>>31|0)|0;H=bF(y|0,B|0,H|0,D|0)|0;B=D;E=pF(F|0,((F|0)<0)<<31>>31|0,E|0,((E|0)<0)<<31>>31|0)|0;F=D;w=pF(C|0,((C|0)<0)<<31>>31|0,w|0,((w|0)<0)<<31>>31|0)|0;w=bF(E|0,F|0,w|0,D|0)|0;c[L+48>>2]=G;c[L+52>>2]=e;c[L+56>>2]=H;c[L+60>>2]=B;c[L+64>>2]=w;c[L+68>>2]=D;c[L+0>>2]=0;c[L+4>>2]=0;c[L+8>>2]=0;c[L+12>>2]=0;c[L+16>>2]=0;w=oE(a,0,t,L+112|0,L+72|0,L+48|0,L)|0;c[L+24>>2]=0;c[L+28>>2]=0;c[L+32>>2]=0;c[L+36>>2]=0;c[L+40>>2]=0;B=oE(a,1,x,L+112|0,L+72|0,L+48|0,L+24|0)|0;if(!((w|0)!=0|(B|0)!=0)){K=119;break}if((w|0)!=0&(B|0)!=0)y=lE(c[L>>2]|0,c[L+4>>2]|0,c[L+8>>2]|0,c[L+12>>2]|0,c[L+16>>2]|0,c[L+24>>2]|0,c[L+28>>2]|0,c[L+32>>2]|0,c[L+36>>2]|0,c[L+40>>2]|0)|0;else y=(w|0)!=0?-1:1;do if(!q){if((y|0)>-1)if((c[L+40>>2]|0)<0&((c[L+32>>2]|0)==0&(c[L+36>>2]|0)==0))