// Generated by Haxe 3.4.0
(function ($hx_exports, $global) { "use strict";
$hx_exports["wl"] = $hx_exports["wl"] || {};
$hx_exports["kvg"] = $hx_exports["kvg"] || {};
$hx_exports["kvg"]["core"] = $hx_exports["kvg"]["core"] || {};
var $estr = function() { return js_Boot.__string_rec(this,''); };
function $extend(from, fields) {
	function Inherit() {} Inherit.prototype = from; var proto = new Inherit();
	for (var name in fields) proto[name] = fields[name];
	if( fields.toString !== Object.prototype.toString ) proto.toString = fields.toString;
	return proto;
}
var wl_core_Signal = function() {
	this.callbacks = [];
};
wl_core_Signal.__name__ = ["wl","core","Signal"];
wl_core_Signal.prototype = {
	connect: function(callback) {
		this.callbacks.push(callback);
	}
	,disconnect: function(callback) {
		HxOverrides.remove(this.callbacks,callback);
	}
	,emit: function(param) {
		var _g = 0;
		var _g1 = this.callbacks;
		while(_g < _g1.length) {
			var cb = _g1[_g];
			++_g;
			cb(param);
		}
	}
	,__class__: wl_core_Signal
};
var DemoMain = function() {
};
DemoMain.__name__ = ["DemoMain"];
DemoMain.setup = function() {
	wl_core_Config.SONG_PATH = "soundtrack.ogg";
	wl_core_Config.BEATS_PER_MINUTE = 140;
	wl_core_Config.MUSIC_BEGIN = 500;
	wl_core_Config.FPS = -1;
	wl_core_Config.ENABLE_SHADOWS = true;
	wl_core_Config.DEBUG = false;
	wl_core_Config.CLEAR_COLOR = 0;
	wl_core_Config.SHADOW_MAP_SIZE = [2048,2048];
	wl_core_Config.ENABLE_FFT = true;
	wl_core_Config.TIMELINE = [new wl_demo_TimeLine(new blank_Blank(),new wl_core_TimeSig(0),new wl_core_TimeSig(0),"blank"),new wl_demo_TimeLine(new greets_Greets(true),new wl_core_TimeSig(0),new wl_core_TimeSig(16),"intro",false),new wl_demo_TimeLine(new raytrace_Raytrace(),new wl_core_TimeSig(0),new wl_core_TimeSig(16),"raytrace1"),new wl_demo_TimeLine(new greets_Greets(false),new wl_core_TimeSig(16),new wl_core_TimeSig(32),"greets"),new wl_demo_TimeLine(new ballvines_Ballvines(),new wl_core_TimeSig(32),new wl_core_TimeSig(48),"ballvines"),new wl_demo_TimeLine(new raytrace_Raytrace(true),new wl_core_TimeSig(48),new wl_core_TimeSig(56),"raytrace",false,null,null,true),new wl_demo_TimeLine(new credits_Credits(),new wl_core_TimeSig(48),new wl_core_TimeSig(56),"credits"),new wl_demo_TimeLine(new godrays_GodRays(),new wl_core_TimeSig(56),new wl_core_TimeSig(74),"godrays")];
	new THREE.FontLoader().load("font/BlackOpsOne_Regular.json",function(font) {
		DemoMain.font2 = font;
	},function() {
	},function() {
	});
};
DemoMain.prototype = {
	__class__: DemoMain
};
var HxOverrides = function() { };
HxOverrides.__name__ = ["HxOverrides"];
HxOverrides.cca = function(s,index) {
	var x = s.charCodeAt(index);
	if(x != x) {
		return undefined;
	}
	return x;
};
HxOverrides.substr = function(s,pos,len) {
	if(len == null) {
		len = s.length;
	} else if(len < 0) {
		if(pos == 0) {
			len = s.length + len;
		} else {
			return "";
		}
	}
	return s.substr(pos,len);
};
HxOverrides.remove = function(a,obj) {
	var i = a.indexOf(obj);
	if(i == -1) {
		return false;
	}
	a.splice(i,1);
	return true;
};
HxOverrides.iter = function(a) {
	return { cur : 0, arr : a, hasNext : function() {
		return this.cur < this.arr.length;
	}, next : function() {
		return this.arr[this.cur++];
	}};
};
var Main = function() { };
Main.__name__ = ["Main"];
Main.main = function() {
	$(window).ready(Main.windowReady);
};
Main.windowReady = function(e) {
	DemoMain.setup();
	$("#setup").css("display","none");
	Main.demo = new wl_core_Demo();
	if(!wl_core_Config.DEBUG) {
		$(".debug").css("display","none");
		$("#debug").find("input").attr("checked",null);
		$(".checkbox").css("display","none");
	}
	wl_sounds_SoundWL.onSoundLoaded.connect(Main.onSoundLoaded);
	wl_sounds_SoundWL.init();
};
Main.onSoundLoaded = function() {
	$("#setup").css("display","");
	wl_setup_Setup.init(Main.demo);
};
Math.__name__ = ["Math"];
var Reflect = function() { };
Reflect.__name__ = ["Reflect"];
Reflect.field = function(o,field) {
	try {
		return o[field];
	} catch( e ) {
		return null;
	}
};
Reflect.fields = function(o) {
	var a = [];
	if(o != null) {
		var hasOwnProperty = Object.prototype.hasOwnProperty;
		for( var f in o ) {
		if(f != "__id__" && f != "hx__closures__" && hasOwnProperty.call(o,f)) {
			a.push(f);
		}
		}
	}
	return a;
};
var Std = function() { };
Std.__name__ = ["Std"];
Std.string = function(s) {
	return js_Boot.__string_rec(s,"");
};
var StringTools = function() { };
StringTools.__name__ = ["StringTools"];
StringTools.replace = function(s,sub,by) {
	return s.split(sub).join(by);
};
var Type = function() { };
Type.__name__ = ["Type"];
Type.getClassName = function(c) {
	var a = c.__name__;
	if(a == null) {
		return null;
	}
	return a.join(".");
};
var wl_core_Part = function() {
	this.postProcessing = { };
	this.effects = [];
	this.autoClear = true;
	this.clearColor = 0;
	this.generateDepthMap = true;
	this.renderToScreen = false;
	this.inTransition = false;
	this.running = false;
	this.isActive = false;
};
wl_core_Part.__name__ = ["wl","core","Part"];
wl_core_Part.prototype = {
	init: function() {
		this.triggers = new haxe_ds_ObjectMap();
		if(this.generateDepthMap) {
			this.depthMap = wl_core_Graphics.instance.getRenderTarget();
		}
		this.renderTo = wl_core_Graphics.instance.getRenderTarget(this.renderFormat);
		this.effects = [];
	}
	,postInit: function() {
	}
	,setupDatGui: function(folder) {
		if(this.camera != null) {
			var cam = folder.addFolder("camera");
			cam.add(this.camera,"fov").onChange(($_=this.camera,$bind($_,$_.updateProjectionMatrix)));
			cam.add(this.camera,"near").onChange(($_=this.camera,$bind($_,$_.updateProjectionMatrix)));
			cam.add(this.camera,"far").onChange(($_=this.camera,$bind($_,$_.updateProjectionMatrix)));
		}
	}
	,start: function(ts) {
		this.running = true;
	}
	,stop: function() {
		this.running = false;
	}
	,setRenderToScreen: function(value) {
		this.renderToScreen = value;
	}
	,update: function(ts,partial,frameTime,delta) {
	}
	,render: function(ts,frameTime) {
		var r = wl_core_Graphics.instance.renderer;
		if(this.generateDepthMap) {
			r.autoClear = true;
			r.setClearColor(0,1.0);
			this.scene.overrideMaterial = wl_core_Graphics.instance.depthMaterial;
			wl_core_Graphics.instance.renderer.render(this.scene,this.camera,this.depthMap);
			this.scene.overrideMaterial = null;
		}
		r.autoClear = this.autoClear;
		r.setClearColor(this.clearColor,1.0);
		if(this.composer != null) {
			this.composer.render();
		} else {
			wl_core_Graphics.instance.renderer.render(this.scene,this.camera,this.renderTo);
		}
	}
	,addTrigger: function(timesig,handler) {
		if(this.triggers.h.__keys__[timesig.__id__] != null) {
			this.triggers.h[timesig.__id__].push(handler);
		} else {
			this.triggers.set(timesig,[handler]);
		}
	}
	,removeTrigger: function(handler,timesig) {
		if(timesig != null && this.triggers.h.__keys__[timesig.__id__] != null) {
			HxOverrides.remove(this.triggers.h[timesig.__id__],handler);
		} else {
			var t = this.triggers.iterator();
			while(t.hasNext()) {
				var t1 = t.next();
				while(t1.indexOf(handler) >= 0) HxOverrides.remove(t1,handler);
			}
		}
	}
	,addEffect: function(effect) {
		this.effects.push(effect);
	}
	,initStandardScene: function() {
		this.scene = new THREE.Scene();
		this.camera = new THREE.PerspectiveCamera(30,wl_core_Config.RESOLUTION[0] / wl_core_Config.RESOLUTION[1],0.1,1000);
		this.camera.position.y = 0;
		this.camera.position.x = 0;
		this.camera.position.z = 500;
		this.camera.lookAt(new THREE.Vector3(0,0,0));
		this.scene.autoUpdate = true;
		this.scene.add(this.camera);
		wl_debug_ManualControl.attachPart(this);
	}
	,getComposerList: function(post) {
		var list = [];
		if(post.dof) {
			list.push(this.postProcessing.dof = new wl_post_dof_DoF(this.depthMap.texture,this.camera));
		}
		if(post.bloom) {
			list.push(this.postProcessing.bloom = new wl_post_bloom_Bloom());
		}
		if(post.rgbShift) {
			list.push(this.postProcessing.rgbShift = new wl_post_rgbshift_RGBShift());
		}
		if(post.colorHilight) {
			list.push(this.postProcessing.colorHilight = new wl_post_colorhilight_ColorHilight());
		}
		if(post.pixelate) {
			list.push(this.postProcessing.pixelate = new wl_post_pixelate_Pixelate());
		}
		if(post.distortedTV) {
			list.push(this.postProcessing.distortedTV = new wl_post_distortedTv_DistortedTv());
		}
		if(post.standard) {
			list.push(this.postProcessing.standard = new wl_post_standard_StandardShader());
		}
		if(post.displacement) {
			var tmp = wl_core_Assets.getTexture("perlin-512.png");
			list.push(this.postProcessing.displacement = new wl_post_displacement_Displacement(tmp));
		}
		if(post.gray) {
			list.push(this.postProcessing.gray = new wl_post_gray_Gray(0));
		}
		return list;
	}
	,initComposer: function(postprocessingList,preventCopy,preventRender) {
		if(postprocessingList == null) {
			postprocessingList = this.getComposerList({ });
		}
		var g = wl_core_Graphics.instance;
		this.composer = new THREE.EffectComposer(g.renderer,this.renderTo);
		if(!preventRender) {
			this.renderPass = new THREE.RenderPass(this.scene,this.camera,null,new THREE.Color(this.clearColor),1);
			this.composer.addPass(this.renderPass);
		}
		var _g = 0;
		while(_g < postprocessingList.length) {
			var pass = postprocessingList[_g];
			++_g;
			this.composer.addPass(pass);
		}
		if(!preventCopy) {
			this.copyPass = new THREE.ShaderPass(THREE.CopyShader);
			this.copyPass.renderToScreen = false;
			this.composer.addPass(this.copyPass);
		}
	}
	,__class__: wl_core_Part
};
var ballvines_Ballvines = function() {
	this.oktoanim = false;
	this.speed = 0;
	this.useColors = [DemoMain.WHITE.getHex(),DemoMain.LIGHT.getHex(),DemoMain.HILIGHT.getHex(),DemoMain.GREEN.getHex(),DemoMain.BLUE.getHex()];
	this.vines = [];
	this.points = [];
	wl_core_Part.call(this);
};
ballvines_Ballvines.__name__ = ["ballvines","Ballvines"];
ballvines_Ballvines.__super__ = wl_core_Part;
ballvines_Ballvines.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.lookto = new THREE.Object3D();
		this.scene.add(this.lookto);
		this.initComposer(this.getComposerList({ dof : false, rgbShift : false, colorHilight : false, pixelate : false, distortedTV : true, standard : true, displacement : false, bloom : true, gray : false}));
		this.container = new THREE.Object3D();
		this.cubeCamera = new THREE.CubeCamera(1,400,512);
		this.container.add(this.cubeCamera);
		this.cubeCamera.position.y = 0.1;
		this.bgMat = new THREE.MeshBasicMaterial({ color : DemoMain.BLACK.getHex(), side : THREE.BackSide});
		var plane = new THREE.Mesh(new THREE.BoxGeometry(400,400,400),this.bgMat);
		this.container.add(plane);
		var cubegeometry = new THREE.DodecahedronGeometry(1,3);
		var cubemat = new THREE.MeshBasicMaterial({ color : DemoMain.WHITE.getHex()});
		var _g = 0;
		while(_g < 1) {
			++_g;
			var mesh = new THREE.Mesh(cubegeometry,cubemat);
			this.container.add(mesh);
			mesh.position.x = 0;
			mesh.position.z = 0;
			mesh.position.y = 0;
		}
		this.rootMesh = new THREE.Mesh(new THREE.SphereGeometry(1),new THREE.MeshBasicMaterial({ color : 16711680}));
		this.container.add(this.rootMesh);
		this.rootMesh.visible = false;
		var sprite = wl_core_Assets.getTexture("arrow.png");
		var _g1 = 0;
		var _g2 = this.useColors.length;
		while(_g1 < _g2) {
			var size = 3 * Math.pow(0.7,_g1++ + 1);
			var material = new THREE.PointsMaterial({ size : size, map : sprite, vertexColors : THREE.VertexColors, alphaTest : 0.5, transparent : true});
			var geometry = new THREE.Geometry();
			var balls = [];
			var colors = [];
			var _g21 = 0;
			while(_g21 < 50000) {
				var vertex = new THREE.Vector3(Math.random() * 100 - 50,Math.random() * -4 - 4,Math.random() * 100 - 50);
				balls.push(vertex);
				geometry.vertices.push(vertex);
				colors[_g21++] = new THREE.Color(DemoMain.BLACK.getHex());
			}
			geometry.colors = colors;
			var pointLayer = { };
			pointLayer.balls = balls;
			pointLayer.material = material;
			pointLayer.size = size;
			pointLayer.points = new THREE.Points(geometry,material);
			pointLayer.colors = colors;
			pointLayer.ind = 0;
			this.container.add(pointLayer.points);
			this.points.push(pointLayer);
		}
		this.camera.position.z = 15;
		this.camera.lookAt(new THREE.Vector3(0,0,0));
		this.scene.add(this.container);
		var ambient = new THREE.AmbientLight(3158064);
		this.scene.add(ambient);
		this.root = { };
		this.root.position = new THREE.Vector3();
		this.root.direction = new THREE.Vector3(0,1,0);
		this.root.size = 1;
		this.root.angleAdd = new THREE.Vector3();
		this.root.lvl = 0;
		this.vines.push(this.root);
		this.postProcessing.bloom.radius = 0.2;
		this.postProcessing.bloom.strength = 3;
		this.postProcessing.bloom.threshold = 0.3;
		this.postProcessing.distortedTV.set_distortAmount(6000);
		this.postProcessing.distortedTV.set_vignAmount(0.1);
		this.addTrigger(new wl_core_TimeSig(-1,0,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.cam));
		this.addTrigger(new wl_core_TimeSig(-1,1,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.cam));
		this.addTrigger(new wl_core_TimeSig(-1,2,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.cam));
		this.addTrigger(new wl_core_TimeSig(-1,3,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.cam));
		this.addTrigger(new wl_core_TimeSig(15,2,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.outro));
		this.addTrigger(new wl_core_TimeSig(0,2,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.startAnim));
		this.addTrigger(new wl_core_TimeSig(4,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.startZoom));
		this.cubeCamera.updateCubeMap(wl_core_Graphics.instance.renderer,this.scene);
		this.cc = new wl_demo_CameraController(this.camera);
		this.cc.initFollow(this.rootMesh,new THREE.Vector3(0,0,-34));
	}
	,outro: function(ts) {
		createjs.Tween.get(this.postProcessing.standard.uniforms.brightness).to({ value : -1.5},wl_core_TimeSig.milliseconds(0,2,0,0),createjs.Ease.quadOut);
	}
	,start: function(ts) {
		this.startTime = ts.toMilliseconds();
		wl_core_Part.prototype.start.call(this,ts);
		var tc = DemoMain.BLUE_DARK;
		createjs.Tween.get(this.bgMat.color).wait(wl_core_TimeSig.milliseconds(2,0,0,0)).to({ r : tc.r, g : tc.g, b : tc.b},wl_core_TimeSig.milliseconds(4,0,0,0));
		createjs.Tween.get(this.postProcessing.bloom).to({ strength : 1.4, radius : 0.2, threshold : 0.3},wl_core_TimeSig.milliseconds(0,0,6,0));
		var tmp = createjs.Tween.get(this.camera.position);
		var tmp1 = wl_core_TimeSig.milliseconds(0,2,0,0);
		var tmp2 = createjs.Ease.getBackInOut(2.5);
		tmp.to({ z : 8},tmp1,tmp2);
	}
	,startAnim: function(ts) {
		var _gthis = this;
		createjs.Tween.get(this.camera.position).wait(wl_core_TimeSig.milliseconds(0,8,0,0)).to({ z : 10},wl_core_TimeSig.milliseconds(2,0,0,0),createjs.Ease.linear);
		createjs.Tween.get(this.camera.position).wait(wl_core_TimeSig.milliseconds(0,4,0,0)).to({ y : 5},wl_core_TimeSig.milliseconds(3,2,0,0),createjs.Ease.linear);
		createjs.Tween.get(this.lookto.position,{ onChange : function() {
			_gthis.camera.lookAt(_gthis.lookto.position);
		}}).wait(wl_core_TimeSig.milliseconds(0,4,0,0)).to({ x : 3},wl_core_TimeSig.milliseconds(3,0,0,0),createjs.Ease.quadOut);
		createjs.Tween.get(this.lookto.position).wait(wl_core_TimeSig.milliseconds(0,4,0,0)).to({ y : 7},wl_core_TimeSig.milliseconds(3,2,0,0),createjs.Ease.quadOut);
		createjs.Tween.get(this.postProcessing.bloom).wait(wl_core_TimeSig.milliseconds(0,4,0,0)).to({ strength : 1.4, radius : 0.1, threshold : 0.3},wl_core_TimeSig.milliseconds(0,2,0,0));
		createjs.Tween.get(this).to({ speed : 1},wl_core_TimeSig.milliseconds(1,0,0,0));
		this.oktoanim = true;
	}
	,startZoom: function(ts) {
		this.addTrigger(new wl_core_TimeSig(-1,3,8,0,wl_core_TimeSig.PATTERN),$bind(this,this.prezoom));
		this.addTrigger(new wl_core_TimeSig(-1,0,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.changeZoom));
	}
	,prezoom: function(ts) {
		createjs.Tween.get(this.postProcessing.bloom).to({ strength : 3},wl_core_TimeSig.milliseconds(0,0,4,0));
	}
	,changeZoom: function(ts) {
		createjs.Tween.get(this.postProcessing.bloom).to({ strength : 1.4},wl_core_TimeSig.milliseconds(0,0,4,0));
		createjs.Tween.removeTweens(this.camera.position);
		createjs.Tween.removeTweens(this.lookto);
		var tmp = this.rootMesh.position.y + Math.random() * 2.5;
		this.camera.position.y = tmp - 2;
		var tmp1 = wl_util_Random.nextFloat();
		this.container.rotation.y = tmp1 * 3;
		var tmp2 = wl_util_Random.nextFloat() * 10;
		this.camera.position.z = 10 + tmp2;
		this.camera.lookAt(new THREE.Vector3(0,this.camera.position.y,0));
		createjs.Tween.get(this.camera.position).to({ y : this.camera.position.y - 0.5},wl_core_TimeSig.milliseconds(1,0,0,0));
	}
	,cam: function(ts) {
		this.spawnVine(this.root);
	}
	,spawn: function(ts) {
		var _g = 0;
		var _g1 = this.vines;
		while(_g < _g1.length) {
			var vine = _g1[_g];
			++_g;
			var points = this.points[vine.lvl];
			points.points.geometry.colorsNeedUpdate = true;
			points.points.geometry.verticesNeedUpdate = true;
			var ball = points.balls[points.ind];
			points.colors[points.ind].setHex(this.useColors[Math.min(vine.lvl,this.useColors.length - 1)]);
			points.ind = (points.ind + 1) % points.balls.length;
			ball.copy(vine.position);
		}
	}
	,spawnVine: function(parent) {
		if(parent.lvl >= this.useColors.length - 1) {
			return;
		}
		parent = this.cloneVine(parent);
		var vine = { };
		vine.position = parent.position.clone();
		vine.direction = parent.direction.clone();
		vine.direction.x += (wl_util_Random.nextFloat() * 0.2 - 0.1) * vine.direction.x;
		vine.direction.y += (wl_util_Random.nextFloat() * 0.2 - 0.1) * vine.direction.y;
		vine.direction.z += (wl_util_Random.nextFloat() * 0.2 - 0.1) * vine.direction.z;
		vine.direction.normalize();
		vine.size = parent.size / 2;
		vine.lifetime = vine.size * 200 + 150;
		vine.maxlife = vine.lifetime;
		vine.angleAdd = parent.angleAdd.clone();
		vine.lvl = parent.lvl + 1;
		this.vines.push(vine);
	}
	,render: function(ts,frameTime) {
		if(!this.running) {
			return;
		}
		var delta = frameTime / 16.666666666666668;
		if(this.oktoanim) {
			this.spawn(ts);
			this.rootMesh.position.copy(this.root.position);
			var remove = [];
			var ms = (ts.toMilliseconds() - this.startTime) * 0.001;
			this.root.angleAdd.x = Math.sin(ms) * 2;
			this.root.angleAdd.z = Math.cos(ms) * 2;
			this.root.angleAdd.y = ms * 0.06;
			this.root.angleAdd.normalize();
			var _g = 0;
			var _g1 = this.vines;
			while(_g < _g1.length) {
				var vine = _g1[_g];
				++_g;
				if(vine != this.root) {
					vine.angleAdd.x += Math.sin((vine.maxlife - vine.lifetime) * 0.05) * 0.1;
					vine.angleAdd.y += Math.sin((vine.maxlife - vine.lifetime) * 0.025) * 0.1;
					vine.angleAdd.z += Math.sin((vine.maxlife - vine.lifetime) * 0.045) * 0.1;
				}
				vine.direction.x += vine.angleAdd.x;
				vine.direction.y += vine.angleAdd.y;
				vine.direction.z += vine.angleAdd.z;
				vine.direction.normalize();
				vine.position.addScaledVector(vine.direction,delta * 0.12 * this.speed * vine.size);
				if(wl_util_Random.nextFloat() < 0.1 * this.speed * this.speed && vine != this.root && this.vines.length < 400) {
					this.spawnVine(vine);
				}
				vine.lifetime -= delta;
				if(vine.lifetime < 0 && vine != this.root) {
					remove.push(vine);
				}
			}
			var _g2 = 0;
			while(_g2 < remove.length) {
				var vine1 = remove[_g2];
				++_g2;
				HxOverrides.remove(this.vines,vine1);
			}
		}
		wl_core_Part.prototype.render.call(this,ts,frameTime);
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,cloneVine: function(vine) {
		return { position : vine.position.clone(), direction : vine.direction.clone(), size : vine.size, lifetime : vine.lifetime, angleAdd : vine.angleAdd.clone(), lvl : vine.lvl};
	}
	,__class__: ballvines_Ballvines
});
var blank_Blank = function() {
	wl_core_Part.call(this);
};
blank_Blank.__name__ = ["blank","Blank"];
blank_Blank.__super__ = wl_core_Part;
blank_Blank.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.initComposer();
	}
	,__class__: blank_Blank
});
var credits_Credits = function() {
	this.patternOn = false;
	this.patterns = [];
	this.lights = [];
	this.objects = [];
	this.h = 18;
	this.w = 32;
	wl_core_Part.call(this);
};
credits_Credits.__name__ = ["credits","Credits"];
credits_Credits.__super__ = wl_core_Part;
credits_Credits.prototype = $extend(wl_core_Part.prototype,{
	loadPatterns: function() {
		var files = ["code_exca.png","code_poro.png","music_eclipser.png"];
		var ctx = window.document.createElement("canvas").getContext("2d");
		var _g = 0;
		while(_g < files.length) {
			var file = files[_g];
			++_g;
			ctx.drawImage(wl_core_Assets.get(file),0,0,32,18,0,0,32,18);
			var array = ctx.getImageData(0,0,32,18).data;
			this.patterns.push(array);
		}
	}
	,init: function() {
		wl_core_Part.prototype.init.call(this);
		this.loadPatterns();
		this.initStandardScene();
		this.torus = new THREE.Mesh(new THREE.TorusGeometry(1,0.1),new THREE.MeshBasicMaterial({ color : DemoMain.HILIGHT.getHex(), transparent : true}));
		this.torus.rotation.x = 0.3;
		this.plane = new THREE.Mesh(new THREE.PlaneGeometry(this.w,this.h),new THREE.MeshBasicMaterial({ color : 16777215, map : wl_core_Demo.instance.getPart("raytrace").renderTo.texture, combine : THREE.AddOperation}));
		this.plane.position.y = 1;
		this.plane.rotation.x = Math.PI / 2;
		this.scene.add(this.plane);
		this.initComposer(this.getComposerList({ dof : false, rgbShift : true, colorHilight : false, pixelate : false, distortedTV : true, standard : false, displacement : false, bloom : true, gray : true}));
		var boxGeo = new THREE.BoxGeometry(1,1,0.05);
		var topmat = new THREE.MeshPhongMaterial({ shininess : 100, color : DemoMain.BLUE_DARK.getHex(), emissive : DemoMain.BLACK.getHex(), specular : 16777215});
		var bg = new THREE.BoxGeometry(3.5,3.5,3.5);
		this.ball = new THREE.Mesh(bg,new THREE.MeshBasicMaterial({ color : DemoMain.HILIGHT.getHex()}));
		this.ball.position.y = 5;
		this.ball.rotation.x = 2.3;
		this.ball.rotation.y = 0.7;
		this.ball.rotation.z = 1.6;
		this.ball.position.z = -0.1;
		this.ball.position.x = 0.1;
		this.torus.position.copy(this.ball.position);
		this.container = new THREE.Object3D();
		this.silhouette = new credits_SilhouetteVine(9,null,$bind(this,this.onVineSpawn));
		this.silhouette.rotation.x = Math.PI / 2;
		this.silhouette.position.y = -10;
		this.silhouette.position.z = -11;
		this.silhouette.position.x = -8;
		var pg = new THREE.Geometry();
		var ball = wl_core_Assets.getTexture("ball.png");
		var pm = new THREE.PointsMaterial({ color : DemoMain.HILIGHT.getHex(), size : 1, map : ball, transparent : true, alphaTest : 0.5});
		var _g = 0;
		while(_g < 1000) {
			var i = _g++;
			var v = new THREE.Vector3(wl_util_Random.nextFloat() * 40 - 20,wl_util_Random.nextFloat() * 20 - 10,wl_util_Random.nextFloat() * 20 - 10);
			pg.vertices.push(v);
		}
		this.grid = [];
		var _g1 = 0;
		var _g2 = this.w;
		while(_g1 < _g2) {
			var x = _g1++;
			var col = [];
			var _g3 = 0;
			var _g21 = this.h;
			while(_g3 < _g21) {
				var y = _g3++;
				var box = new THREE.Mesh(boxGeo,topmat);
				var bc = new THREE.Object3D();
				bc.position.y = 0;
				bc.position.x = x - this.w / 2 + 0.5;
				bc.position.z = y - this.h / 2 + 0.5;
				bc.add(box);
				this.container.add(bc);
				col.push(bc);
				this.objects.push(box);
			}
			this.grid.push(col);
		}
		var _g4 = 0;
		while(_g4 < 1) {
			var i1 = _g4++;
			var pl = new THREE.PointLight(DemoMain.LIGHT.getHex(),0.1,20,0.6);
			this.scene.add(pl);
			pl.position.y = -15;
			var tmp = -this.w / 2;
			var tmp1 = wl_util_Random.nextFloat() * 20;
			pl.position.x = tmp - tmp1;
			var tmp2 = i1 / 10 * this.w - this.w / 2 + wl_util_Random.nextFloat() * 2;
			pl.position.z = tmp2 - 1;
			pl.position.start = pl.position.x;
			var l = { };
			l.light = pl;
			this.lights.push(l);
		}
		this.camera.fov = 10;
		this.camera.updateProjectionMatrix();
		this.camera.position.y = -102;
		this.camera.position.x = 0;
		this.camera.position.z = 0;
		this.camera.lookAt(new THREE.Vector3(0,0,0));
		this.raycaster = new THREE.Raycaster();
		this.scene.add(this.container);
		this.postProcessing.bloom.radius = 0.23;
		this.postProcessing.bloom.strength = 0.37;
		this.postProcessing.bloom.threshold = 0.9;
		this.postProcessing.distortedTV.set_distortAmount(300);
		this.postProcessing.distortedTV.set_vignAmount(0);
		this.addTrigger(new wl_core_TimeSig(-1,0,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.changePattern));
		this.addTrigger(new wl_core_TimeSig(-1,1,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.clear));
		this.addTrigger(new wl_core_TimeSig(-1,2,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.random));
		this.addTrigger(new wl_core_TimeSig(-1,3,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.random));
		this.addTrigger(new wl_core_TimeSig(-1,1,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.random));
		this.addTrigger(new wl_core_TimeSig(-1,2,6,0,wl_core_TimeSig.PATTERN),$bind(this,this.random));
		this.addTrigger(new wl_core_TimeSig(-1,3,6,0,wl_core_TimeSig.PATTERN),$bind(this,this.random));
		this.addTrigger(new wl_core_TimeSig(-1,1,6,0,wl_core_TimeSig.PATTERN),$bind(this,this.random));
		this.addTrigger(new wl_core_TimeSig(7,2,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.goout));
	}
	,goout: function(ts) {
		createjs.Tween.get(this.torus.scale).wait(wl_core_TimeSig.milliseconds(0,0,3,0)).to({ x : 24, y : 24, z : 8},wl_core_TimeSig.milliseconds(0,1,9,0),createjs.Ease.quadOut);
		createjs.Tween.get(this.torus.material).wait(wl_core_TimeSig.milliseconds(0,0,6,0)).to({ opacity : 0},wl_core_TimeSig.milliseconds(0,1,6,0),createjs.Ease.quadIn);
		var tmp = createjs.Tween.get(this.ball.scale).wait(wl_core_TimeSig.milliseconds(0,0,6,0));
		var tmp1 = wl_core_TimeSig.milliseconds(0,1,6,0);
		var tmp2 = createjs.Ease.getBackOut(3);
		tmp.to({ x : 1, y : 1},tmp1,tmp2);
		createjs.Tween.get(this.postProcessing.distortedTV.uniforms.offsetAmount).wait(wl_core_TimeSig.milliseconds(0,1,6,0)).to({ value : 3},wl_core_TimeSig.milliseconds(0,0,6,0));
		createjs.Tween.get(this.postProcessing.bloom).to({ threshold : 0.2, strength : 0},wl_core_TimeSig.milliseconds(0,2,0,0));
		createjs.Tween.get(this.plane.position).to({ z : -this.h - 4},wl_core_TimeSig.milliseconds(0,2,0,0),createjs.Ease.quadIn);
		this.removeTrigger($bind(this,this.changePattern));
		this.removeTrigger($bind(this,this.clear));
		this.removeTrigger($bind(this,this.random));
		var _g1 = 0;
		var _g = this.grid.length;
		while(_g1 < _g) {
			var col = this.grid[_g1++];
			var _g3 = 0;
			var _g2 = col.length;
			while(_g3 < _g2) {
				var y = _g3++;
				var m = col[y];
				createjs.Tween.removeTweens(m.rotation);
				wl_util_Random.nextFloat();
				createjs.Tween.get(m.position).wait(wl_core_TimeSig.milliseconds(0,0,(2 + y) * 0.25,0)).to({ x : Math.PI / 2 + 99},wl_core_TimeSig.milliseconds(0,0,1,0));
			}
		}
	}
	,onVineSpawn: function(pos) {
		var world = new THREE.Vector3();
		world = this.silhouette.localToWorld(world);
		world.project(this.camera);
		world.x = Math.round((world.x + 1) * wl_core_Config.RESOLUTION[0] / 2);
		world.y = Math.round((-world.y + 1) * wl_core_Config.RESOLUTION[1] / 2);
		world.z = 0;
		this.raycaster.setFromCamera(world,this.camera);
		var intersects = this.raycaster.intersectObjects(this.objects,false);
		var _g = 0;
		while(_g < intersects.length) {
			var i = intersects[_g];
			++_g;
			i.object.locked = true;
		}
	}
	,start: function(ts) {
		wl_core_Part.prototype.start.call(this,ts);
		this.startTime = ts.toMilliseconds();
	}
	,randomizeParticle: function(pl) {
		pl.maxLife = Math.random() * 45 + 50;
		pl.lifetime = pl.maxLife;
		var tmp = wl_util_Random.nextFloat() * this.h;
		pl.light.position.z = tmp - this.h / 2;
		var tmp1 = wl_util_Random.nextFloat() * this.w;
		pl.light.position.x = tmp1 - this.w / 2;
		pl.startX = pl.light.position.x;
	}
	,clear: function(ts) {
		if(ts.bar % 2 == 1) {
			return;
		}
		if(!this.patternOn) {
			return;
		}
		this.patternOn = false;
		var _g1 = 0;
		var _g = this.grid.length;
		while(_g1 < _g) {
			var x = _g1++;
			var col = this.grid[x];
			var _g3 = 0;
			var _g2 = col.length;
			while(_g3 < _g2) {
				var y = _g3++;
				var m = col[y];
				createjs.Tween.removeTweens(m.rotation);
				var val = wl_util_Random.nextFloat();
				createjs.Tween.get(m.rotation).wait(wl_core_TimeSig.milliseconds(0,0,(2 + x + y) * 0.25,0)).to({ x : Math.PI / 2},wl_core_TimeSig.milliseconds(0,0,1,0)).to({ x : 0},wl_core_TimeSig.milliseconds(0,0,1,0)).to({ x : val < 0.25 ? Math.PI / 2 : 0},wl_core_TimeSig.milliseconds(0,0,1,0));
			}
		}
	}
	,random: function(ts) {
		if(this.patternOn) {
			return;
		}
		var _g1 = 0;
		var _g = this.grid.length;
		while(_g1 < _g) {
			var x = _g1++;
			var col = this.grid[x];
			var _g3 = 0;
			var _g2 = col.length;
			while(_g3 < _g2) {
				var y = _g3++;
				var m = col[y];
				var val = wl_util_Random.nextFloat();
				if(val < 0.25 || m.locked) {
					createjs.Tween.get(m.rotation).wait(wl_core_TimeSig.milliseconds(0,0,3,0) * wl_util_Random.nextFloat()).to({ x : Math.PI / 2},wl_core_TimeSig.milliseconds(0,0,3,0));
				} else {
					createjs.Tween.get(m.rotation).wait(wl_core_TimeSig.milliseconds(0,0,3,0) * wl_util_Random.nextFloat()).to({ x : 0},wl_core_TimeSig.milliseconds(0,0,3,0));
				}
			}
		}
	}
	,changePattern: function(ts) {
		this.silhouette.spawnFromRoot();
		var pattern = null;
		if(this.patterns.length > 0 && ts.bar > this.timeline.rtsOn.bar) {
			if(ts.bar % 2 == 1) {
				pattern = this.patterns.shift();
			}
		}
		if(pattern != null) {
			this.patternOn = true;
			var _g = 0;
			var _g1 = this.silhouette.materials;
			while(_g < _g1.length) {
				var m = _g1[_g];
				++_g;
				var orig = m.size;
				createjs.Tween.get(m).to({ size : orig * 0.25},wl_core_TimeSig.milliseconds(0,0,4,0)).to({ size : orig},wl_core_TimeSig.milliseconds(0,1,0,0));
			}
			this.postProcessing.bloom.strength = ts.beat == 0 ? 2 : 1;
			createjs.Tween.get(this.postProcessing.bloom).to({ strength : 0.1},wl_core_TimeSig.milliseconds(0,0,6,0));
			var _g11 = 0;
			var _g2 = this.grid.length;
			while(_g11 < _g2) {
				var x = _g11++;
				var col = this.grid[x];
				var _g3 = 0;
				var _g21 = col.length;
				while(_g3 < _g21) {
					var y = _g3++;
					var m1 = col[y];
					var val = wl_util_Random.nextFloat();
					if(pattern != null) {
						val = pattern[((this.h - y) * this.w + x) * 4] / 255;
					}
					if(val < 0.25 || m1.locked) {
						createjs.Tween.get(m1.rotation).wait(wl_core_TimeSig.milliseconds(0,0,6,0) * wl_util_Random.nextFloat()).to({ x : Math.PI / 2},wl_core_TimeSig.milliseconds(0,0,6,0));
					} else {
						createjs.Tween.get(m1.rotation).wait(wl_core_TimeSig.milliseconds(0,0,6,0) * wl_util_Random.nextFloat()).to({ x : 0},wl_core_TimeSig.milliseconds(0,0,6,0));
					}
				}
			}
		}
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
		var _g = 0;
		var _g1 = this.lights;
		while(_g < _g1.length) ++_g;
	}
	,render: function(ts,frameTime) {
		if(!this.running) {
			return;
		}
		this.silhouette.render((ts.toMilliseconds() - this.startTime) * 0.3 + 10000,frameTime);
		wl_core_Part.prototype.render.call(this,ts,frameTime);
	}
	,__class__: credits_Credits
});
var credits_SilhouetteVine = function(size,useColors,spawncallback) {
	this.materials = [];
	this.useColors = [DemoMain.BLACK.getHex(),DemoMain.BLACK.getHex(),DemoMain.BLACK.getHex(),DemoMain.BLACK.getHex(),DemoMain.BLACK.getHex()];
	this.spawned = [];
	this.resetToLevel = [];
	this.vines = [];
	this.points = [];
	THREE.Object3D.call(this);
	this.spawnCallback = spawncallback;
	this.size = size;
	if(useColors != null) {
		this.useColors = useColors;
	}
	this.init();
};
credits_SilhouetteVine.__name__ = ["credits","SilhouetteVine"];
credits_SilhouetteVine.__super__ = THREE.Object3D;
credits_SilhouetteVine.prototype = $extend(THREE.Object3D.prototype,{
	init: function() {
		var sprite = wl_core_Assets.getTexture("arrow.png");
		var _g1 = 0;
		var _g = this.useColors.length;
		while(_g1 < _g) {
			var i = _g1++;
			var size = this.size * Math.pow(0.6,i + 1);
			var material = new THREE.PointsMaterial({ size : size, map : sprite, vertexColors : THREE.VertexColors, alphaTest : 0.5, transparent : true});
			var geometry = new THREE.Geometry();
			var balls = [];
			var colors = [];
			var _g2 = 0;
			while(_g2 < 10000) {
				var vertex = new THREE.Vector3(Math.random() * 10 - 5,Math.random() * 10 + 20,Math.random() * 10 - 5);
				balls.push(vertex);
				geometry.vertices.push(vertex);
				colors[_g2++] = new THREE.Color(this.useColors[i]);
			}
			geometry.colors = colors;
			var pointLayer = { };
			pointLayer.balls = balls;
			pointLayer.material = material;
			pointLayer.size = size;
			pointLayer.points = new THREE.Points(geometry,material);
			pointLayer.colors = colors;
			pointLayer.ind = 0;
			this.add(pointLayer.points);
			this.points.push(pointLayer);
		}
		this.root = { };
		this.root.position = new THREE.Vector3();
		this.root.direction = new THREE.Vector3(0,1,0);
		this.root.size = this.size;
		this.root.angleAdd = new THREE.Vector3();
		this.root.lvl = 0;
		this.vines.push(this.root);
	}
	,spawnFromRoot: function() {
		this.spawnVine(this.root);
	}
	,spawn: function() {
		var _g = 0;
		var _g1 = this.vines;
		while(_g < _g1.length) {
			var vine = _g1[_g];
			++_g;
			var points = this.points[vine.lvl];
			points.points.geometry.verticesNeedUpdate = true;
			points.points.geometry.colorsNeedUpdate = true;
			var ball = points.balls[points.ind];
			points.colors[points.ind].setHex(DemoMain.HILIGHT.getHex());
			this.resetToLevel.push({ p : points, i : points.ind});
			points.ind = (points.ind + 1) % points.balls.length;
			ball.copy(vine.position);
			if(this.spawnCallback != null) {
				this.spawnCallback(ball);
			}
		}
	}
	,spawnVine: function(parent) {
		var _gthis = this;
		if(parent.lvl >= this.useColors.length - 1) {
			return;
		}
		parent = this.cloneVine(parent);
		haxe_Timer.delay(function() {
			var vine = { };
			vine.position = parent.position.clone();
			vine.direction = parent.direction.clone();
			vine.direction.x += (wl_util_Random.nextFloat() * 0.4 - 0.2) * vine.direction.x;
			vine.direction.y += (wl_util_Random.nextFloat() * 0.4 - 0.2) * vine.direction.y;
			vine.direction.z += (wl_util_Random.nextFloat() * 0.4 - 0.2) * vine.direction.z;
			vine.direction.normalize();
			vine.size = parent.size / 2;
			vine.lifetime = vine.size * 200 + 150;
			vine.maxlife = vine.lifetime;
			vine.angleAdd = parent.angleAdd.clone();
			vine.lvl = parent.lvl + 1;
			_gthis.vines.push(vine);
		},wl_core_TimeSig.milliseconds(0,0,4,0));
	}
	,render: function(time,frameTime) {
		var delta = frameTime / 16.666666666666668;
		var _g = 0;
		var _g1 = this.resetToLevel;
		while(_g < _g1.length) {
			var pt = _g1[_g];
			++_g;
			var pts = pt.p;
			pts.colors[pt.i].setHex(this.useColors[this.points.indexOf(pts)]);
			pts.points.geometry.colorsNeedUpdate = true;
		}
		this.resetToLevel = [];
		this.spawn();
		var remove = [];
		var ms = time * 0.001;
		this.root.angleAdd.x = Math.sin(ms) * 2;
		this.root.angleAdd.z = Math.cos(ms) * 2;
		this.root.angleAdd.y = ms * 0.06;
		this.root.angleAdd.normalize();
		var _g2 = 0;
		var _g11 = this.vines;
		while(_g2 < _g11.length) {
			var vine = _g11[_g2];
			++_g2;
			if(vine != this.root) {
				vine.angleAdd.x += Math.sin((vine.maxlife - vine.lifetime) * 0.05) * 0.1;
				vine.angleAdd.y += Math.abs(Math.sin((vine.maxlife - vine.lifetime) * 0.025) * 0.01);
				vine.angleAdd.z += Math.sin((vine.maxlife - vine.lifetime + Math.cos(vine.maxlife - vine.lifetime) * 0.4) * 0.045) * 0.1;
			}
			vine.direction.x += vine.angleAdd.x;
			vine.direction.y += vine.angleAdd.y;
			vine.direction.z += vine.angleAdd.z;
			vine.direction.normalize();
			vine.position.addScaledVector(vine.direction,delta * 0.05 * vine.size);
			if(wl_util_Random.nextFloat() < 0.015 && vine != this.root && this.vines.length < 500) {
				this.spawnVine(vine);
			}
			vine.lifetime -= delta;
			if(vine.lifetime < 0 && vine != this.root) {
				remove.push(vine);
			}
		}
		var _g3 = 0;
		while(_g3 < remove.length) {
			var vine1 = remove[_g3];
			++_g3;
			HxOverrides.remove(this.vines,vine1);
		}
	}
	,cloneVine: function(vine) {
		return { position : vine.position.clone(), direction : vine.direction.clone(), size : vine.size, lifetime : vine.lifetime, angleAdd : vine.angleAdd.clone(), lvl : vine.lvl};
	}
	,__class__: credits_SilhouetteVine
});
var dicethrow_DiceThrow = function() {
	this.startTime = 0;
	this.transformAux1 = new Ammo.btTransform();
	this.rigidBodies = [];
	wl_core_Part.call(this);
};
dicethrow_DiceThrow.__name__ = ["dicethrow","DiceThrow"];
dicethrow_DiceThrow.__super__ = wl_core_Part;
dicethrow_DiceThrow.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.initComposer(this.getComposerList({ dof : false, rgbShift : false, colorHilight : false, pixelate : false, distortedTV : false, standard : false, displacement : false, bloom : false, gray : false}));
		var sun = new THREE.PointLight(11447982,0.5);
		sun.position.set(30,100,30);
		this.scene.add(sun);
		this.scene.add(this.camera);
		this.initPhysics();
		this.buildScene();
		var outerbox = new THREE.Mesh(new THREE.BoxGeometry(250,250,250),new THREE.MeshPhongMaterial({ color : 16777215}));
		outerbox.material.side = THREE.BackSide;
		this.scene.add(outerbox);
	}
	,buildScene: function() {
		new Ammo.btCompoundShape();
		var dice = this.BuildDice();
		this.scene.add(dice);
		dice.position.x = 10;
		dice.rotateX(2.1);
		this.camera.position.set(50,30,50);
		this.camera.lookAt(new THREE.Vector3(0,5,0));
		var b = new THREE.Mesh(new THREE.BoxGeometry(4,4,4),new THREE.MeshBasicMaterial());
		b.position.set(2,2,2);
		this.createRigidBody(b,new Ammo.btBoxShape(new Ammo.btVector3(2,2,2)),1);
		this.scene.add(b);
		var groundMesh = new THREE.Mesh(new THREE.BoxGeometry(200,2,200),new THREE.MeshPhongMaterial({ color : 16777215}));
		groundMesh.position.set(0,0,0);
		var ground = this.createRigidBody(groundMesh,new Ammo.btBoxShape(new Ammo.btVector3(100,1,100)),0);
		this.scene.add(ground);
	}
	,BuildDice: function() {
		var m = new THREE.MeshPhongMaterial({ color : 15395562});
		var geo = new THREE.BoxGeometry(2,2,2);
		geo.computeBoundingBox();
		var size = geo.boundingBox.size();
		var boxshape = new Ammo.btBoxShape(new Ammo.btVector3(size.x * 0.5,size.y * 0.5,size.z * 0.5));
		var obu = new THREE.Object3D();
		var _g = 0;
		while(_g < 4) {
			var y = _g++;
			var _g1 = 0;
			while(_g1 < 4) {
				var x = _g1++;
				var _g2 = 0;
				while(_g2 < 4) {
					var mesh = new THREE.Mesh(geo,m);
					mesh.position.set(x * size.x,y * size.y + 10,_g2++ * size.z);
					mesh.add(mesh);
					mesh = this.createRigidBody(mesh,boxshape,1);
				}
			}
		}
		return obu;
	}
	,initPhysics: function() {
		var collisionConfiguration = new Ammo.btDefaultCollisionConfiguration();
		this.physicsWorld = new Ammo.btDiscreteDynamicsWorld(new Ammo.btCollisionDispatcher(collisionConfiguration),new Ammo.btDbvtBroadphase(),new Ammo.btSequentialImpulseConstraintSolver(),collisionConfiguration);
		this.physicsWorld.setGravity(new Ammo.btVector3(0,-5,0));
	}
	,createRigidBody: function(threeObject,physicsShape,mass) {
		var pos = threeObject.position;
		var quat = threeObject.quaternion;
		var transform = new Ammo.btTransform();
		var identity = new Ammo.btTransform();
		identity.setIdentity();
		transform.setIdentity();
		transform.setOrigin(new Ammo.btVector3(pos.x,pos.y,pos.z));
		transform.setRotation(new Ammo.btQuaternion(quat.x,quat.y,quat.z,quat.w));
		var motionState = new Ammo.btDefaultMotionState(transform,identity);
		var localInertia = new Ammo.btVector3(0,0,0);
		physicsShape.calculateLocalInertia(mass,localInertia);
		var body = new Ammo.btRigidBody(new Ammo.btRigidBodyConstructionInfo(mass,motionState,physicsShape,localInertia));
		threeObject.userData.physicsBody = body;
		if(mass > 0) {
			this.rigidBodies.push(threeObject);
			body.setActivationState(4);
		}
		this.physicsWorld.addRigidBody(body);
		return threeObject;
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,updatePhysics: function(deltaTime) {
		this.physicsWorld.stepSimulation(deltaTime,10);
		var _g1 = 0;
		var _g = this.rigidBodies.length;
		while(_g1 < _g) {
			var objThree = this.rigidBodies[_g1++];
			var ms = objThree.userData.physicsBody.getMotionState();
			if(ms != null) {
				ms.getWorldTransform(this.transformAux1);
				var p = this.transformAux1.getOrigin();
				var q = this.transformAux1.getRotation();
				objThree.position.set(p.x(),p.y(),p.z());
				objThree.quaternion.set(q.x(),q.y(),q.z(),q.w());
			}
		}
	}
	,render: function(ts,frameTime) {
		this.updatePhysics(ts.toMilliseconds() - this.startTime);
		wl_core_Part.prototype.render.call(this,ts,frameTime);
	}
	,__class__: dicethrow_DiceThrow
});
var examples_FillerCube = function(color) {
	wl_core_Part.call(this);
	this.color = color;
};
examples_FillerCube.__name__ = ["examples","FillerCube"];
examples_FillerCube.__super__ = wl_core_Part;
examples_FillerCube.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.initComposer(this.getComposerList({ dof : true, rgbShift : false, colorHilight : false, pixelate : false, distortedTV : false, standard : true, displacement : false, bloom : false, gray : false}));
		this.box = new THREE.Mesh(new THREE.BoxGeometry(5,5,5),new THREE.MeshStandardMaterial({ color : this.color}));
		this.scene.add(this.box);
		this.camera.position.z = -10;
		this.camera.position.y = 10;
		this.camera.lookAt(new THREE.Vector3(0,0,0));
		var sun = new THREE.PointLight(16777215);
		this.camera.add(sun);
	}
	,update: function(ts,partial,frameTime,delta) {
		this.box.rotateY(0.0001 * frameTime);
	}
	,__class__: examples_FillerCube
});
var godrays_AdditiveBlendingShader = function() {
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.scene = new THREE.Scene();
	this.uniforms = { tDiffuse : { type : "t"}, tAdd : { type : "t"}};
	this.enabled = true;
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, fragmentShader : haxe_Resource.getString("additiveblending.frag"), vertexShader : haxe_Resource.getString("additiveblending.vert")});
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
godrays_AdditiveBlendingShader.__name__ = ["godrays","AdditiveBlendingShader"];
godrays_AdditiveBlendingShader.prototype = {
	render: function(renderer,writeBuffer,readBuffer,delta) {
		this.uniforms.tDiffuse.value = readBuffer.texture;
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,__class__: godrays_AdditiveBlendingShader
};
var godrays_GodRays = function() {
	this.filters = [];
	this.started = false;
	this.stopped = false;
	this.lightPillars = [];
	wl_core_Part.call(this);
};
godrays_GodRays.__name__ = ["godrays","GodRays"];
godrays_GodRays.__super__ = wl_core_Part;
godrays_GodRays.prototype = $extend(wl_core_Part.prototype,{
	initanalyzer: function() {
		this.analyzer = new wl_sounds_SoundAnalyzer();
		this.analyzer.historySize = 12;
		this.filters = [];
		var filter = { lowLimit : 50, highLimit : 400, isolate : true};
		this.filters.push(filter);
		this.analyzer.filters.push(filter);
		var filter1 = { lowLimit : 7000, highLimit : 10000, isolate : true};
		this.filters.push(filter1);
		this.analyzer.filters.push(filter1);
	}
	,init: function() {
		this.renderFormat = THREE.RGBAFormat;
		wl_core_Part.prototype.init.call(this);
		this.initanalyzer();
		this.initStandardScene();
		this.occlusionScene = new THREE.Scene();
		var aspect = wl_core_Config.RESOLUTION[0] / wl_core_Config.RESOLUTION[1];
		var lp = new godrays_LightPillar();
		this.scene.add(lp);
		this.lightPillars.push(lp);
		this.scene.add(new THREE.AmbientLight(1052688));
		var blackMaterial = new THREE.MeshBasicMaterial({ color : 0});
		var whiteMaterial = new THREE.MeshBasicMaterial({ color : DemoMain.HILIGHT.getHex()});
		var actuallyWhiteMaterial = new THREE.MeshBasicMaterial({ color : DemoMain.WHITE.getHex()});
		var lpc = new godrays_LightPillar(blackMaterial);
		this.lightPillars.push(lpc);
		this.occlusionScene.add(lpc);
		var helper = new THREE.BoxHelper(lpc);
		this.camera.position.set(50,20,50);
		this.camera.lookAt(new THREE.Vector3(0,0,0));
		var geometry = helper.geometry;
		geometry.computeBoundingBox();
		var box = geometry.boundingBox.size();
		var size = box.multiplyScalar(0.7);
		this.lightCube = new THREE.Mesh(new THREE.BoxGeometry(size.x,10,size.z),whiteMaterial);
		console.log(size);
		this.occlusionScene.add(this.lightCube);
		this.lightCube.position.set(0,-60,0);
		this.addTrigger(new wl_core_TimeSig(0,0,1,0,wl_core_TimeSig.RELATIVE),$bind(this,this.launch));
		this.addTrigger(new wl_core_TimeSig(7,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.fadeout));
		this.addTrigger(new wl_core_TimeSig(14,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.end));
		this.occlusionCamera = this.camera.clone();
		this.setupPostprocessing();
		this.postProcessing.bloom.enabled = false;
		var boxmesh = new THREE.Mesh(new THREE.BoxGeometry(60,400,60),new THREE.MeshStandardMaterial({ color : DemoMain.WHITE.getHex()}));
		boxmesh.material.side = THREE.BackSide;
		boxmesh.receiveShadow = true;
		this.scene.add(boxmesh);
		this.oclusionpass.uniforms.exposure.value = 0;
	}
	,end: function(ts) {
		console.log("end is near");
		createjs.Tween.get(this.oclusionpass.uniforms.exposure).to({ value : 0},wl_core_TimeSig.milliseconds(2,0,0,0),createjs.Ease.quadIn);
		createjs.Tween.get(this.postProcessing.standard.uniforms.brightness).to({ value : 0},wl_core_TimeSig.milliseconds(2,0,0,0),createjs.Ease.quadIn);
		var _g = 0;
		var _g1 = this.lightPillars;
		while(_g < _g1.length) {
			var lpi = _g1[_g];
			++_g;
			var tmp = createjs.Tween.get(lpi.sun);
			var tmp1 = new wl_core_TimeSig(2,0,0,0,wl_core_TimeSig.RELATIVE).toMilliseconds();
			tmp.to({ intensity : 0},null,tmp1);
		}
		this.stopped = true;
	}
	,launch: function(ts) {
		var movement = new wl_core_TimeSig(7,2,0,0,wl_core_TimeSig.ABSOLUTE).toMilliseconds();
		createjs.Tween.get(this.lightCube.position).to({ y : 130},movement,createjs.Ease.quadInOut).to({ y : 0},movement,createjs.Ease.quadInOut);
		var _g = 0;
		var _g1 = this.lightPillars;
		while(_g < _g1.length) {
			var lpi = _g1[_g];
			++_g;
			lpi.start();
			var tmp = createjs.Tween.get(lpi.sun);
			var tmp1 = new wl_core_TimeSig(5,0,0,0,wl_core_TimeSig.RELATIVE).toMilliseconds();
			tmp.to({ distance : 50},null,tmp1);
		}
		createjs.Tween.get(this.oclusionpass.uniforms.exposure).to({ value : 0.21},wl_core_TimeSig.milliseconds(0,2,0,0),createjs.Ease.quadOut);
	}
	,fadeout: function(ts) {
		var _g = 0;
		var _g1 = this.lightPillars;
		while(_g < _g1.length) {
			var lpi = _g1[_g];
			++_g;
			var tmp = createjs.Tween.get(lpi.sun);
			var tmp1 = new wl_core_TimeSig(1,0,0,0,wl_core_TimeSig.RELATIVE).toMilliseconds();
			tmp.to({ distance : 30},null,tmp1);
		}
	}
	,update: function(ts,partial,frameTime,delta) {
		this.camera.lookAt(this.lightCube.position.clone().add(new THREE.Vector3((wl_util_Random.nextFloat() - 0.5) * 0.15 * (1 - partial),(wl_util_Random.nextFloat() - 0.5) * 0.15 * (1 - partial),(wl_util_Random.nextFloat() - 0.5) * 0.15 * (1 - partial))));
		var delta1 = ts.toMilliseconds() / 1000;
		this.oclusionpass.uniforms.lightPosition.value = wl_util_ScreenUtil.projectToNormalizedScreenPosition(this.lightCube.position,this.camera);
		this.occlusionCamera.position.copy(this.camera.position);
		this.occlusionCamera.quaternion.copy(this.camera.quaternion);
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta1);
	}
	,render: function(ts,frameTime) {
		this.analyzer.update();
		if(!this.stopped && this.started) {
			if(this.filters[0].triggered) {
				this.oclusionpass.set_exposure(this.filters[0].max + .1);
			} else {
				this.oclusionpass.set_exposure(0.21);
			}
		}
		wl_core_Graphics.instance.renderer.setClearColor(0);
		wl_core_Graphics.instance.renderer.setClearAlpha(0);
		this.occlusionComposer.render();
		wl_core_Part.prototype.render.call(this,ts,frameTime);
	}
	,setupPostprocessing: function() {
		this.occlusionRenderTarget = new THREE.WebGLRenderTarget(wl_core_Config.RESOLUTION[0],wl_core_Config.RESOLUTION[1]);
		this.occlusionComposer = new THREE.EffectComposer(wl_core_Graphics.instance.renderer,this.occlusionRenderTarget);
		var rp = new THREE.RenderPass(this.occlusionScene,this.occlusionCamera);
		this.occlusionComposer.addPass(rp);
		this.copyPass = new THREE.ShaderPass(THREE.CopyShader);
		this.copyPass.renderToScreen = true;
		this.oclusionpass = new godrays_VolumetricShader();
		this.oclusionpass.needsSwap = false;
		this.oclusionpass.renderToScreen = false;
		this.occlusionComposer.addPass(this.oclusionpass);
		var pass = new godrays_AdditiveBlendingShader();
		pass.uniforms.tAdd.value = this.occlusionRenderTarget.texture;
		pass.renderToScreen = false;
		var composerlist = [];
		composerlist.push(pass);
		var composerlist2 = this.getComposerList({ dof : false, rgbShift : false, colorHilight : false, pixelate : false, distortedTV : false, standard : true, displacement : false, bloom : true, gray : false});
		this.postProcessing.standard.set_gamma(1);
		var _g = 0;
		while(_g < composerlist2.length) {
			var p = composerlist2[_g];
			++_g;
			composerlist.push(p);
		}
		this.postProcessing.standard.enabled = true;
		this.initComposer(composerlist);
		this.renderPass.clearAlpha = 0;
	}
	,__class__: godrays_GodRays
});
var godrays_LightPillar = function(m) {
	this.movement = 10000;
	this.w = 2;
	THREE.Object3D.call(this);
	this.sun = new THREE.PointLight(DemoMain.HILIGHT.getHex(),2.0,10);
	this.sun.position.set(0,0,0);
	this.add(this.sun);
	var geo = new THREE.BoxGeometry(this.w,this.w,this.w);
	if(m == null) {
		m = new THREE.MeshStandardMaterial({ color : DemoMain.LIGHT.getHex()});
	}
	this.sun.castShadow = true;
	var _g = 0;
	while(_g < 40) {
		var y = _g++;
		var _g1 = -3;
		while(_g1 < 3) {
			var x = _g1++;
			var _g2 = -3;
			while(_g2 < 3) {
				var z = _g2++;
				if(x > -3 && x < 2 && z > -3 && z < 2) {
					continue;
				}
				if((y + 1) % 3 == 0) {
					continue;
				}
				var mesh = new THREE.Mesh(geo,m);
				mesh.castShadow = true;
				mesh.position.set(x * this.w,y * this.w,z * this.w);
				this.add(mesh);
			}
		}
	}
};
godrays_LightPillar.__name__ = ["godrays","LightPillar"];
godrays_LightPillar.__super__ = THREE.Object3D;
godrays_LightPillar.prototype = $extend(THREE.Object3D.prototype,{
	start: function() {
		var tmp = 40 * this.w;
		createjs.Tween.get(this.sun.position,{ loop : true}).to({ y : tmp},this.movement,createjs.Ease.quadInOut).to({ y : 0},this.movement,createjs.Ease.quadInOut);
	}
	,__class__: godrays_LightPillar
});
var godrays_VolumetricShader = function() {
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.uniforms = { tDiffuse : { type : "t"}, lightPosition : { type : "v2", value : new THREE.Vector2(0.5,0.5)}, exposure : { type : "f", value : 0.21}, decay : { type : "f", value : 0.96}, density : { type : "f", value : 0.55}, weight : { type : "f", value : 0.75}, samples : { type : "i", value : 70}, brigthness : { type : "f", value : 1}};
	this.lightPosition = new THREE.Vector2(0.5,0.5);
	this.samples = 70;
	this.weight = 0.75;
	this.density = 0.55;
	this.decay = 0.96;
	this.exposure = 0.21;
	this.enabled = true;
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, vertexShader : haxe_Resource.getString("volumetric.vert"), fragmentShader : haxe_Resource.getString("volumetric.frag")});
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
godrays_VolumetricShader.__name__ = ["godrays","VolumetricShader"];
godrays_VolumetricShader.prototype = {
	set_exposure: function(value) {
		this.exposure = value;
		this.uniforms.exposure.value = value;
		return value;
	}
	,set_decay: function(value) {
		this.decay = value;
		this.uniforms.decay.value = value;
		return value;
	}
	,set_density: function(value) {
		this.density = value;
		this.uniforms.density.value = value;
		return value;
	}
	,set_weight: function(value) {
		this.weight = value;
		this.uniforms.weight.value = value;
		return value;
	}
	,set_samples: function(value) {
		this.samples = value;
		this.uniforms.samples.value = value;
		return value;
	}
	,set_lightPosition: function(value) {
		this.lightPosition = value;
		this.uniforms.lightPosition.value = value;
		return value;
	}
	,setupDatGui: function(folder) {
		var _gthis = this;
		var f = folder.addFolder("Volumetric");
		f.add(this,"exposure").step(0.01).min(0).max(1).onChange(function(val) {
			_gthis.uniforms.exposure.value = _gthis.exposure;
		});
		f.add(this.lightPosition,"x").step(0.01).min(0).max(1).onChange(function(val1) {
			_gthis.uniforms.lightPosition.value = _gthis.lightPosition;
		});
		f.add(this.lightPosition,"y").step(0.01).min(0).max(1).onChange(function(val2) {
			_gthis.uniforms.lightPosition.value = _gthis.lightPosition;
		});
		f.add(this,"decay").step(0.01).min(0).max(1).onChange(function(val3) {
			_gthis.uniforms.decay.value = _gthis.decay;
		});
		f.add(this,"density").step(0.01).min(0).max(1).onChange(function(val4) {
			_gthis.uniforms.density.value = _gthis.density;
		});
		f.add(this,"weight").step(0.01).min(0).max(1).onChange(function(val5) {
			_gthis.uniforms.weight.value = _gthis.weight;
		});
		f.add(this,"samples").step(1).min(0).max(500).onChange(function(val6) {
			_gthis.uniforms.samples.value = _gthis.samples;
		});
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		this.uniforms.tDiffuse.value = readBuffer.texture;
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,__class__: godrays_VolumetricShader
};
var greets_Greets = function(intro) {
	this.camorder = [0,1,2,3,4,1,5,0];
	this.greetEmissive = 0;
	this.hiding = false;
	this.filters = [];
	this.arrowMaterials = [];
	this.intro = false;
	this.allArrows = [];
	this.baseVinj = 1;
	this.camOffset = 0;
	this.greetGeoms = [];
	this.greets = ["HBC","FGJ","ASD","API","MFX","CNCD","NPLI","ADAPT","EPOCH","ALUMNI","DAMONES","KEWLERS","MERCURY","SCENESAT","QUADTRIP","PARAGUAY","DARKLITE","TRACTION","HEDELMAE","DEKADENCE","FAIRLIGHT","PRIMITIVE","JUMALAUTA","BYTERAPERS","MEMORY LEEK","MATT CURRENT","ANANASMURSKA","ARTLINE DESIGNS","PYROTECH"];
	this.campos = new THREE.Vector3();
	this.cubes = [];
	this.lights = [];
	wl_core_Part.call(this);
	this.intro = intro;
};
greets_Greets.__name__ = ["greets","Greets"];
greets_Greets.__super__ = wl_core_Part;
greets_Greets.prototype = $extend(wl_core_Part.prototype,{
	initanalyzer: function() {
		this.analyzer = new wl_sounds_SoundAnalyzer();
		this.analyzer.historySize = 6;
		this.filters = [];
		var filter = { lowLimit : 50, highLimit : 400, isolate : true};
		this.filters.push(filter);
		this.analyzer.filters.push(filter);
		var filter1 = { lowLimit : 400, highLimit : 800, isolate : true};
		this.filters.push(filter1);
		this.analyzer.filters.push(filter1);
	}
	,init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initanalyzer();
		this.initStandardScene();
		this.initComposer(this.getComposerList({ dof : false, rgbShift : false, colorHilight : false, pixelate : false, distortedTV : true, standard : true, displacement : false, bloom : true, gray : false}));
		var xo = 0;
		var zo = 0;
		var boxgeometry = new THREE.DodecahedronGeometry(0.4,3);
		this.container = new THREE.Object3D();
		var halfspawnerJson = JSON.parse(haxe_Resource.getString("triangle.json"));
		var jsonloader = new THREE.OfflineJSONLoader();
		var triangleGeo = null;
		var callbackModel = function(geometry) {
			triangleGeo = geometry;
			triangleGeo.scale(1.5,1.5,1.5);
		};
		jsonloader.load(halfspawnerJson,callbackModel);
		this.arrowMaterials = [new THREE.MeshBasicMaterial({ color : DemoMain.BLUE_DARK.getHex()})];
		this.arrows = [];
		this.arrowC = new THREE.Object3D();
		var _g = 0;
		while(_g < 16) {
			var i = _g++;
			var ac = new THREE.Object3D();
			this.arrows.push(ac);
			var _g1 = 0;
			while(_g1 < 30) {
				var j = _g1++;
				var arrow = new THREE.Mesh(triangleGeo,this.arrowMaterials[i % this.arrowMaterials.length]);
				arrow.position.y = Math.sin(j / 30 * Math.PI * 2) * 15;
				arrow.position.x = Math.cos(j / 30 * Math.PI * 2) * 15;
				arrow.lookAt(new THREE.Vector3(Math.cos((j + 1) / 30 * Math.PI * 2) * 15,Math.sin((j + 1) / 30 * Math.PI * 2) * 15,0));
				ac.add(arrow);
				this.allArrows.push(arrow);
			}
			this.arrows.push(ac);
			this.arrowC.add(ac);
			ac.position.z = i * 3;
		}
		var boxmat = new THREE.MeshPhongMaterial({ color : DemoMain.HILIGHT.getHex(), emissive : 0});
		this.greetMat = boxmat;
		var _g2 = 0;
		var _g11 = this.greets;
		while(_g2 < _g11.length) {
			var greet = _g11[_g2];
			++_g2;
			var geometry1 = new THREE.TextGeometry(greet,{ font : DemoMain.font2, size : 0.8, height : 0.1, curveSegments : 12, bevelEnabled : false, bevelThickness : 10, bevelSize : 8, bevelSegments : 5});
			geometry1.center();
			if(greet == "QUADTRIP") {
				geometry1.translate(0,-0.1,0);
			}
			this.greetGeoms.push(geometry1);
		}
		this.greet = new THREE.Mesh(this.greetGeoms[0],boxmat);
		this.greet.rotateY(Math.PI / 2);
		this.greet.position.x = -0.8;
		this.greet.castShadow = true;
		this.scene.add(this.greet);
		var matprops = { };
		matprops.color = DemoMain.BLUE.clone().multiplyScalar(1.25).getHex();
		matprops.side = THREE.BackSide;
		var material = new THREE.MeshLambertMaterial(matprops);
		var geometry2 = new THREE.CylinderGeometry(2.5,2.5,80,20,1,true);
		geometry2.rotateX(Math.PI / 2);
		var mesh = new THREE.Mesh(geometry2,material);
		mesh.position.z = 0;
		mesh.receiveShadow = true;
		this.cylinder = mesh;
		this.container.add(this.cylinder);
		var _g3 = 0;
		while(_g3 < 201) {
			var i1 = _g3++;
			var rt = wl_core_Demo.instance.getPart("raytrace1");
			var props = { color : DemoMain.LIGHT.getHex()};
			boxmat = new THREE.MeshPhongMaterial(props);
			var box = new THREE.Mesh(boxgeometry,boxmat);
			box.receiveShadow = true;
			box.castShadow = true;
			var deg = i1 * 0.5;
			box.position.y = Math.sin(deg) * 1.5;
			box.position.x = Math.cos(deg) * 1.5;
			box.position.z = i1 * 0.25;
			box.lookAt(new THREE.Vector3(0,0,box.position.z));
			this.cubes.push(box);
			this.container.add(box);
		}
		this.camera.position.z = 5;
		this.camera.position.x = 6;
		this.campos.x = this.intro ? 8 : 6;
		this.campos.z = 5;
		this.camera.lookAt(new THREE.Vector3(0,0,0));
		var _g4 = 0;
		while(_g4 < 1) {
			var i2 = _g4++;
			var l = this.createLight(16777215);
			this.scene.add(l);
			this.lights.push(l);
			l.position.z = 0.7;
		}
		this.scene.add(this.container);
		var ambient = new THREE.AmbientLight(3158064);
		this.scene.add(ambient);
		this.scene.add(this.arrowC);
		this.cc = new wl_demo_CameraController(this.camera);
		this.cc.initBezier([new THREE.Vector3(10.32,0.73,7.46),new THREE.Vector3(10.31,0.73,10.46),new THREE.Vector3(10.3,0.73,14.86),new THREE.Vector3(10.29,0.73,18.26),new THREE.Vector3(10.28,0.73,22.36),new THREE.Vector3(10.27,0.73,26.26),new THREE.Vector3(10.26,0.73,29.76)],[new THREE.Vector3(-89.53,-4.67,7.16),new THREE.Vector3(-89.54,-4.67,10.16),new THREE.Vector3(-89.55,-4.67,14.56),new THREE.Vector3(-89.56,-4.67,17.96),new THREE.Vector3(-89.58,-4.67,22.06),new THREE.Vector3(-89.59,-4.67,25.96),new THREE.Vector3(-89.6,-4.67,29.46)]);
		this.postProcessing.bloom.radius = 0.0;
		this.postProcessing.bloom.strength = 2;
		this.postProcessing.bloom.threshold = 0.0;
		this.postProcessing.distortedTV.set_distortAmount(wl_core_Config.RESOLUTION[1]);
		this.addTrigger(new wl_core_TimeSig(0,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.trrssync));
		this.addTrigger(new wl_core_TimeSig(0,3,9,0,wl_core_TimeSig.RELATIVE),$bind(this,this.trrssync));
		this.addTrigger(new wl_core_TimeSig(1,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.trrssync));
		this.addTrigger(new wl_core_TimeSig(2,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.trrssync));
		this.addTrigger(new wl_core_TimeSig(2,1,9,0,wl_core_TimeSig.RELATIVE),$bind(this,this.trrssync));
		this.addTrigger(new wl_core_TimeSig(2,2,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.trrssync));
		this.addTrigger(new wl_core_TimeSig(2,3,9,0,wl_core_TimeSig.RELATIVE),$bind(this,this.trrssync));
		this.addTrigger(new wl_core_TimeSig(3,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.trrssync));
		this.addTrigger(new wl_core_TimeSig(4,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.trrssync));
		this.addTrigger(new wl_core_TimeSig(4,3,9,0,wl_core_TimeSig.RELATIVE),$bind(this,this.trrssync));
		this.addTrigger(new wl_core_TimeSig(5,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.trrssync));
		this.addTrigger(new wl_core_TimeSig(6,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.trrssync));
		this.addTrigger(new wl_core_TimeSig(6,1,9,0,wl_core_TimeSig.RELATIVE),$bind(this,this.trrssync));
		this.addTrigger(new wl_core_TimeSig(6,2,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.trrssync));
		this.addTrigger(new wl_core_TimeSig(6,3,9,0,wl_core_TimeSig.RELATIVE),$bind(this,this.trrssync));
		this.addTrigger(new wl_core_TimeSig(7,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.trrssync));
		this.addTrigger(new wl_core_TimeSig(7,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.trrssync));
		this.addTrigger(new wl_core_TimeSig(7,3,9,0,wl_core_TimeSig.RELATIVE),$bind(this,this.trrssync));
		this.addTrigger(new wl_core_TimeSig(8,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.trrssync));
		this.addTrigger(new wl_core_TimeSig(9,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.trrssync));
		this.addTrigger(new wl_core_TimeSig(9,1,9,0,wl_core_TimeSig.RELATIVE),$bind(this,this.trrssync));
		this.addTrigger(new wl_core_TimeSig(9,2,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.trrssync));
		this.addTrigger(new wl_core_TimeSig(9,3,9,0,wl_core_TimeSig.RELATIVE),$bind(this,this.trrssync));
		this.addTrigger(new wl_core_TimeSig(10,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.trrssync));
		this.addTrigger(new wl_core_TimeSig(11,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.trrssync));
		this.addTrigger(new wl_core_TimeSig(11,3,9,0,wl_core_TimeSig.RELATIVE),$bind(this,this.trrssync));
		this.addTrigger(new wl_core_TimeSig(12,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.trrssync));
		this.addTrigger(new wl_core_TimeSig(13,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.trrssync));
		this.addTrigger(new wl_core_TimeSig(13,1,9,0,wl_core_TimeSig.RELATIVE),$bind(this,this.trrssync));
		this.addTrigger(new wl_core_TimeSig(13,2,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.trrssync));
		this.addTrigger(new wl_core_TimeSig(13,3,9,0,wl_core_TimeSig.RELATIVE),$bind(this,this.trrssync));
		this.addTrigger(new wl_core_TimeSig(14,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.trrssync));
		this.addTrigger(new wl_core_TimeSig(15,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.trrssync));
		this.addTrigger(new wl_core_TimeSig(15,3,9,0,wl_core_TimeSig.RELATIVE),$bind(this,this.trrssync));
		this.addTrigger(new wl_core_TimeSig(8,2,6,0,wl_core_TimeSig.RELATIVE),$bind(this,this.trrssync));
		this.addTrigger(new wl_core_TimeSig(8,3,6,0,wl_core_TimeSig.RELATIVE),$bind(this,this.trrssync));
		this.addTrigger(new wl_core_TimeSig(7,2,6,0,wl_core_TimeSig.RELATIVE),$bind(this,this.trrssync));
		this.addTrigger(new wl_core_TimeSig(7,3,6,0,wl_core_TimeSig.RELATIVE),$bind(this,this.trrssync));
		this.addTrigger(new wl_core_TimeSig(-1,0,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.bounceCubes));
		this.addTrigger(new wl_core_TimeSig(-1,2,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.bounceCubes));
		this.addTrigger(new wl_core_TimeSig(-1,0,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.camswitch));
		if(!this.intro) {
			this.addTrigger(new wl_core_TimeSig(15,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.hideGreet));
		}
		this.scene.fog = new THREE.Fog(0,50,80);
		this.greet.visible = !this.intro;
		this.arrowC.visible = !this.intro;
	}
	,trrssync: function(ts) {
		this.postProcessing.standard.set_brightness(0.3);
		createjs.Tween.get(this.postProcessing.standard.uniforms.brightness).to({ value : 0},wl_core_TimeSig.milliseconds(0,0,3,0));
	}
	,hideGreet: function(ts) {
		this.arrowC.visible = false;
		var geo = this.greet.geometry;
		wl_util_ExplodeGeometry.explode(geo);
		geo.elementsNeedUpdate = true;
		geo.verticesNeedUpdate = true;
		this.hiding = true;
		var targetGeo = new THREE.DodecahedronGeometry(1,1);
		var c = 0;
		var _g = 0;
		var _g1 = geo.faces;
		while(_g < _g1.length) {
			var faces = _g1[_g];
			++_g;
			var v1 = geo.vertices[faces.a];
			var v2 = geo.vertices[faces.b];
			var v3 = geo.vertices[faces.c];
			var targetFace = targetGeo.faces[c % targetGeo.faces.length];
			++c;
			var tv1 = targetGeo.vertices[targetFace.a];
			var tv2 = targetGeo.vertices[targetFace.b];
			var tv3 = targetGeo.vertices[targetFace.c];
			var d1 = wl_core_TimeSig.milliseconds(0,0,wl_util_Random.next() % 10 + 1,0);
			var d2 = wl_core_TimeSig.milliseconds(0,0,wl_util_Random.next() % 10 + 1,0);
			var d3 = wl_core_TimeSig.milliseconds(0,0,wl_util_Random.next() % 10 + 1,0);
			createjs.Tween.get(v1).wait(d1).to({ x : v1.x * 2, y : v1.y * 2, z : v1.z * 4 + wl_util_Random.nextFloat() * 0.8},wl_core_TimeSig.milliseconds(0,2,0,0),createjs.Ease.quadInOut).to({ x : tv1.x, y : tv1.y, z : tv1.z},wl_core_TimeSig.milliseconds(0,2,0,0) - d1,createjs.Ease.quadInOut);
			createjs.Tween.get(v2).wait(d2).to({ x : v1.x * 2 + wl_util_Random.nextFloat() * 0.4, y : v1.y * 2 + wl_util_Random.nextFloat() * 0.4, z : v1.z * 4 + wl_util_Random.nextFloat() * 0.4},wl_core_TimeSig.milliseconds(0,2,0,0),createjs.Ease.quadInOut).to({ x : tv2.x, y : tv2.y, z : tv2.z},wl_core_TimeSig.milliseconds(0,2,0,0) - d2,createjs.Ease.quadInOut);
			createjs.Tween.get(v3).wait(d3).to({ x : v1.x * 2 + wl_util_Random.nextFloat() * 0.4, y : v1.y * 2 + wl_util_Random.nextFloat() * 0.4, z : v1.z * 4 + wl_util_Random.nextFloat() * 0.4},wl_core_TimeSig.milliseconds(0,2,0,0),createjs.Ease.quadInOut).to({ x : tv3.x, y : tv3.y, z : tv3.z},wl_core_TimeSig.milliseconds(0,2,0,0) - d3,createjs.Ease.quadInOut);
		}
		createjs.Tween.get(this).wait(wl_core_TimeSig.milliseconds(0,2,6,0)).to({ greetEmissive : 1},wl_core_TimeSig.milliseconds(0,0,6,0));
		var _g2 = 0;
		var _g11 = this.cubes;
		while(_g2 < _g11.length) {
			var b = _g11[_g2];
			++_g2;
			createjs.Tween.removeTweens(b.scale);
			createjs.Tween.get(b.scale).wait(wl_core_TimeSig.milliseconds(0,wl_util_Random.next() % 2 + 1,0,0)).to({ x : 0.01, y : 0.01, z : 0.01},wl_core_TimeSig.milliseconds(0,1,0,0));
		}
		createjs.Tween.get(this.lights[0]).to({ intensity : 0},wl_core_TimeSig.milliseconds(0,4,0,0));
		createjs.Tween.get(this.postProcessing.bloom).wait(wl_core_TimeSig.milliseconds(0,3,10,0)).to({ strength : 3, radius : 0.2, threshold : 0.3},wl_core_TimeSig.milliseconds(0,0,2,0));
		createjs.Tween.get(this.cylinder.material.color).to({ r : 0, b : 0, g : 0},wl_core_TimeSig.milliseconds(0,2,0,0));
	}
	,camswitch: function(ts) {
		if(ts.bar % 2 == 0 && this.camorder.length > 0) {
			this.camOffset = this.camorder.shift();
		}
	}
	,start: function(ts) {
		wl_core_Part.prototype.start.call(this,ts);
		if(!this.intro) {
			createjs.Tween.get(this.campos).to({ x : 14, z : 80},wl_core_TimeSig.milliseconds(16,0,0,0),createjs.Ease.linear);
		} else {
			createjs.Tween.get(this.campos).to({ z : 80},wl_core_TimeSig.milliseconds(16,0,0,0),createjs.Ease.linear);
		}
		createjs.Tween.get(this.postProcessing.bloom).to({ strength : 0.4, radius : 0.23, threshold : 0.95},wl_core_TimeSig.milliseconds(0,0,4,0));
	}
	,bounceCubes: function(ts) {
		var _gthis = this;
		if(this.greetGeoms.length > 0) {
			createjs.Tween.get(this.postProcessing.bloom).to({ radius : 2, strength : 2},wl_core_TimeSig.milliseconds(0,0,2,0)).call(function() {
				_gthis.greet.geometry = _gthis.greetGeoms.shift();
			}).to({ radius : 0.23, strength : 0.4},wl_core_TimeSig.milliseconds(0,0,2,0));
			createjs.Tween.get(this).to({ baseVinj : 0},wl_core_TimeSig.milliseconds(0,0,2,0)).to({ baseVinj : 1},wl_core_TimeSig.milliseconds(0,0,2,0));
			createjs.Tween.get(this.postProcessing.distortedTV.uniforms.offsetAmount).to({ value : 0.6},wl_core_TimeSig.milliseconds(0,0,2,0)).to({ value : 0},wl_core_TimeSig.milliseconds(0,0,2,0));
		}
		var _g = 0;
		var _g1 = this.cubes;
		while(_g < _g1.length) {
			var c = _g1[_g];
			++_g;
			var delta = (c.position.z - this.camera.position.z + 20) * 20;
			if(delta > 0) {
				haxe_Timer.delay(this.bouncecube(c),Math.floor(delta));
			} else {
				c.position.z += 50;
			}
		}
	}
	,bouncecube: function(c) {
		var _gthis = this;
		return function() {
			if(_gthis.hiding) {
				return;
			}
			var orig = 1;
			c.scale.x = c.scale.y = c.scale.z = c.scale.x * 1.3;
			var m = c.material;
			m.emissive.setHex(16777215);
			haxe_Timer.delay(function() {
				m.emissive.setHex(0);
			},80);
			createjs.Tween.get(c.scale).to({ x : orig, y : orig, z : orig},wl_core_TimeSig.milliseconds(0,2,0,0));
		};
	}
	,createLight: function(color) {
		var pointLight = new THREE.PointLight(color,2.5,100,0.4);
		pointLight.castShadow = true;
		pointLight.shadowMapHeight = wl_core_Config.SHADOW_MAP_SIZE[0];
		pointLight.shadowMapWidth = wl_core_Config.SHADOW_MAP_SIZE[1];
		pointLight.shadow.camera.near = 0.2;
		pointLight.shadow.camera.far = 50;
		pointLight.shadow.bias = 0.01;
		return pointLight;
	}
	,update: function(ts,partial,frameTime,delta) {
		this.analyzer.update();
		if(this.camOffset == 0 || this.intro) {
			this.camera.position.z = this.campos.z;
			this.camera.position.x = this.campos.x;
			this.camera.position.y = 0;
			this.camera.lookAt(new THREE.Vector3(0,0,this.camera.position.z));
			this.greet.position.z = this.camera.position.z;
		} else if(this.camOffset == 1) {
			this.camera.position.z = this.campos.z - 6;
			this.camera.position.x = this.campos.x;
			this.camera.position.y = 0;
			this.camera.lookAt(new THREE.Vector3(0,0,this.camera.position.z + 7));
			this.greet.position.z = this.camera.position.z + 7;
		} else if(this.camOffset == 2) {
			this.camera.position.z = this.campos.z;
			this.camera.position.x = this.campos.x;
			this.camera.position.y = 3;
			this.greet.position.z = this.camera.position.z;
			this.camera.lookAt(new THREE.Vector3(0,0,this.camera.position.z));
		} else if(this.camOffset == 3) {
			this.camera.position.z = this.campos.z + 5;
			this.camera.position.x = this.campos.x;
			this.camera.position.y = -3;
			this.greet.position.z = this.camera.position.z + 7;
			this.camera.lookAt(new THREE.Vector3(0,0,this.camera.position.z + 6));
		} else if(this.camOffset == 4) {
			this.camera.position.z = this.campos.z;
			this.camera.position.x = this.campos.x;
			this.camera.position.y = -3;
			this.greet.position.z = this.camera.position.z;
			this.camera.lookAt(new THREE.Vector3(0,0,this.camera.position.z));
		} else if(this.camOffset == 5) {
			this.camera.position.z = this.campos.z - 3;
			this.camera.position.x = this.campos.x - 3;
			this.camera.position.y = -3;
			this.greet.position.z = this.camera.position.z + 10;
			this.camera.lookAt(new THREE.Vector3(0,0,this.camera.position.z + 10));
		}
		this.arrowC.position.z = this.greet.position.z;
		var _g1 = 0;
		var _g = this.arrows.length;
		while(_g1 < _g) {
			var i = _g1++;
			this.arrows[i].rotation.z = -partial * 5 * Math.abs(0.5 + Math.sin(i) * 0.2);
		}
		this.lights[0].position.z = this.greet.position.z + Math.sin(partial * 18) * 2;
		this.cylinder.position.z = this.camera.position.z;
		if(this.hiding) {
			this.greet.geometry.verticesNeedUpdate = true;
			var hsl = this.greetMat.emissive.getHSL();
			this.greetMat.emissive.setHSL(hsl.h,hsl.s,hsl.l + (1 - hsl.l) * this.greetEmissive);
		}
	}
	,render: function(ts,frameTime) {
		this.postProcessing.distortedTV.set_vignAmount(this.baseVinj + (this.filters[0].triggered ? this.filters[0].max * 0.3 : 0));
		var tmp = this.filters[1].triggered && this.filters[1].max > 0.9 ? this.filters[1].max + 1 : 1;
		this.arrowMaterials[0].color.setHex(DemoMain.BLUE_DARK.clone().multiplyScalar(tmp).getHex());
		wl_core_Part.prototype.render.call(this,ts,frameTime);
	}
	,__class__: greets_Greets
});
var haxe_IMap = function() { };
haxe_IMap.__name__ = ["haxe","IMap"];
var haxe_Resource = function() { };
haxe_Resource.__name__ = ["haxe","Resource"];
haxe_Resource.getString = function(name) {
	var _g = 0;
	var _g1 = haxe_Resource.content;
	while(_g < _g1.length) {
		var x = _g1[_g];
		++_g;
		if(x.name == name) {
			if(x.str != null) {
				return x.str;
			}
			return haxe_crypto_Base64.decode(x.data).toString();
		}
	}
	return null;
};
var haxe_Timer = function(time_ms) {
	var me = this;
	this.id = setInterval(function() {
		me.run();
	},time_ms);
};
haxe_Timer.__name__ = ["haxe","Timer"];
haxe_Timer.delay = function(f,time_ms) {
	var t = new haxe_Timer(time_ms);
	t.run = function() {
		t.stop();
		f();
	};
	return t;
};
haxe_Timer.prototype = {
	stop: function() {
		if(this.id == null) {
			return;
		}
		clearInterval(this.id);
		this.id = null;
	}
	,run: function() {
	}
	,__class__: haxe_Timer
};
var haxe_io_Bytes = function(data) {
	this.length = data.byteLength;
	this.b = new Uint8Array(data);
	this.b.bufferValue = data;
	data.hxBytes = this;
	data.bytes = this.b;
};
haxe_io_Bytes.__name__ = ["haxe","io","Bytes"];
haxe_io_Bytes.ofString = function(s) {
	var a = [];
	var i = 0;
	while(i < s.length) {
		var c = s.charCodeAt(i++);
		if(55296 <= c && c <= 56319) {
			c = c - 55232 << 10 | s.charCodeAt(i++) & 1023;
		}
		if(c <= 127) {
			a.push(c);
		} else if(c <= 2047) {
			a.push(192 | c >> 6);
			a.push(128 | c & 63);
		} else if(c <= 65535) {
			a.push(224 | c >> 12);
			a.push(128 | c >> 6 & 63);
			a.push(128 | c & 63);
		} else {
			a.push(240 | c >> 18);
			a.push(128 | c >> 12 & 63);
			a.push(128 | c >> 6 & 63);
			a.push(128 | c & 63);
		}
	}
	return new haxe_io_Bytes(new Uint8Array(a).buffer);
};
haxe_io_Bytes.prototype = {
	getString: function(pos,len) {
		if(pos < 0 || len < 0 || pos + len > this.length) {
			throw new js__$Boot_HaxeError(haxe_io_Error.OutsideBounds);
		}
		var s = "";
		var b = this.b;
		var fcc = String.fromCharCode;
		var i = pos;
		var max = pos + len;
		while(i < max) {
			var c = b[i++];
			if(c < 128) {
				if(c == 0) {
					break;
				}
				s += fcc(c);
			} else if(c < 224) {
				s += fcc((c & 63) << 6 | b[i++] & 127);
			} else if(c < 240) {
				s += fcc((c & 31) << 12 | (b[i++] & 127) << 6 | b[i++] & 127);
			} else {
				var u = (c & 15) << 18 | (b[i++] & 127) << 12 | (b[i++] & 127) << 6 | b[i++] & 127;
				s += fcc((u >> 10) + 55232);
				s += fcc(u & 1023 | 56320);
			}
		}
		return s;
	}
	,toString: function() {
		return this.getString(0,this.length);
	}
	,__class__: haxe_io_Bytes
};
var haxe_crypto_Base64 = function() { };
haxe_crypto_Base64.__name__ = ["haxe","crypto","Base64"];
haxe_crypto_Base64.decode = function(str,complement) {
	if(complement == null) {
		complement = true;
	}
	if(complement) {
		while(HxOverrides.cca(str,str.length - 1) == 61) str = HxOverrides.substr(str,0,-1);
	}
	return new haxe_crypto_BaseCode(haxe_crypto_Base64.BYTES).decodeBytes(haxe_io_Bytes.ofString(str));
};
var haxe_crypto_BaseCode = function(base) {
	var len = base.length;
	var nbits = 1;
	while(len > 1 << nbits) ++nbits;
	if(nbits > 8 || len != 1 << nbits) {
		throw new js__$Boot_HaxeError("BaseCode : base length must be a power of two.");
	}
	this.base = base;
	this.nbits = nbits;
};
haxe_crypto_BaseCode.__name__ = ["haxe","crypto","BaseCode"];
haxe_crypto_BaseCode.prototype = {
	initTable: function() {
		var tbl = [];
		var _g = 0;
		while(_g < 256) tbl[_g++] = -1;
		var _g1 = 0;
		var _g2 = this.base.length;
		while(_g1 < _g2) {
			var i = _g1++;
			tbl[this.base.b[i]] = i;
		}
		this.tbl = tbl;
	}
	,decodeBytes: function(b) {
		var nbits = this.nbits;
		if(this.tbl == null) {
			this.initTable();
		}
		var tbl = this.tbl;
		var size = b.length * nbits >> 3;
		var out = new haxe_io_Bytes(new ArrayBuffer(size));
		var buf = 0;
		var curbits = 0;
		var pin = 0;
		var pout = 0;
		while(pout < size) {
			while(curbits < 8) {
				curbits += nbits;
				buf <<= nbits;
				var i = tbl[b.b[pin++]];
				if(i == -1) {
					throw new js__$Boot_HaxeError("BaseCode : invalid encoded char");
				}
				buf |= i;
			}
			curbits -= 8;
			out.b[pout++] = buf >> curbits & 255 & 255;
		}
		return out;
	}
	,__class__: haxe_crypto_BaseCode
};
var haxe_ds_ObjectMap = function() {
	this.h = { __keys__ : { }};
};
haxe_ds_ObjectMap.__name__ = ["haxe","ds","ObjectMap"];
haxe_ds_ObjectMap.__interfaces__ = [haxe_IMap];
haxe_ds_ObjectMap.prototype = {
	set: function(key,value) {
		var id = key.__id__ || (key.__id__ = ++haxe_ds_ObjectMap.count);
		this.h[id] = value;
		this.h.__keys__[id] = key;
	}
	,keys: function() {
		var a = [];
		for( var key in this.h.__keys__ ) {
		if(this.h.hasOwnProperty(key)) {
			a.push(this.h.__keys__[key]);
		}
		}
		return HxOverrides.iter(a);
	}
	,iterator: function() {
		return { ref : this.h, it : this.keys(), hasNext : function() {
			return this.it.hasNext();
		}, next : function() {
			var i = this.it.next();
			return this.ref[i.__id__];
		}};
	}
	,__class__: haxe_ds_ObjectMap
};
var haxe_ds_StringMap = function() {
	this.h = { };
};
haxe_ds_StringMap.__name__ = ["haxe","ds","StringMap"];
haxe_ds_StringMap.__interfaces__ = [haxe_IMap];
haxe_ds_StringMap.prototype = {
	setReserved: function(key,value) {
		if(this.rh == null) {
			this.rh = { };
		}
		this.rh["$" + key] = value;
	}
	,getReserved: function(key) {
		if(this.rh == null) {
			return null;
		} else {
			return this.rh["$" + key];
		}
	}
	,existsReserved: function(key) {
		if(this.rh == null) {
			return false;
		}
		return this.rh.hasOwnProperty("$" + key);
	}
	,__class__: haxe_ds_StringMap
};
var haxe_io_Error = { __ename__ : true, __constructs__ : ["Blocked","Overflow","OutsideBounds","Custom"] };
haxe_io_Error.Blocked = ["Blocked",0];
haxe_io_Error.Blocked.toString = $estr;
haxe_io_Error.Blocked.__enum__ = haxe_io_Error;
haxe_io_Error.Overflow = ["Overflow",1];
haxe_io_Error.Overflow.toString = $estr;
haxe_io_Error.Overflow.__enum__ = haxe_io_Error;
haxe_io_Error.OutsideBounds = ["OutsideBounds",2];
haxe_io_Error.OutsideBounds.toString = $estr;
haxe_io_Error.OutsideBounds.__enum__ = haxe_io_Error;
haxe_io_Error.Custom = function(e) { var $x = ["Custom",3,e]; $x.__enum__ = haxe_io_Error; $x.toString = $estr; return $x; };
var haxe_io_FPHelper = function() { };
haxe_io_FPHelper.__name__ = ["haxe","io","FPHelper"];
haxe_io_FPHelper.i32ToFloat = function(i) {
	var exp = i >>> 23 & 255;
	var sig = i & 8388607;
	if(sig == 0 && exp == 0) {
		return 0.0;
	}
	return (1 - (i >>> 31 << 1)) * (1 + Math.pow(2,-23) * sig) * Math.pow(2,exp - 127);
};
haxe_io_FPHelper.floatToI32 = function(f) {
	if(f == 0) {
		return 0;
	}
	var af = f < 0 ? -f : f;
	var exp = Math.floor(Math.log(af) / 0.6931471805599453);
	if(exp < -127) {
		exp = -127;
	} else if(exp > 128) {
		exp = 128;
	}
	var sig = Math.round((af / Math.pow(2,exp) - 1) * 8388608);
	if(sig == 8388608 && exp < 128) {
		sig = 0;
		++exp;
	}
	return (f < 0 ? -2147483648 : 0) | exp + 127 << 23 | sig;
};
var intro_Intro = function() {
	this.startTime = 0;
	wl_core_Part.call(this);
};
intro_Intro.__name__ = ["intro","Intro"];
intro_Intro.__super__ = wl_core_Part;
intro_Intro.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.initComposer(this.getComposerList({ dof : false, rgbShift : false, colorHilight : false, pixelate : false, distortedTV : false, standard : false, displacement : false, bloom : false, gray : false}));
		this.spawner = new shared_Spawner(new THREE.MeshStandardMaterial({ color : 9474192}));
		this.spawner.rotateX(Math.PI / 2);
		this.scene.add(this.spawner);
		this.camera.position.z = -10;
		this.camera.position.y = 10;
		this.camera.lookAt(new THREE.Vector3(0,0,0));
		var sun = new THREE.PointLight(16777215);
		this.camera.add(sun);
		this.addTrigger(new wl_core_TimeSig(0,0,1,0,wl_core_TimeSig.ABSOLUTE),$bind(this,this.launch));
		this.bg = new shared_BgQuad(this.camera);
		this.scene.add(this.bg);
	}
	,launch: function(ts) {
		createjs.Tween.get(this.spawner.position).to({ y : 15},25000);
	}
	,update: function(ts,partial,frameTime,delta) {
		this.spawner.update(ts.toMilliseconds() - this.startTime,frameTime);
		this.spawner.rotateX(0.02);
		this.bg.update(ts);
	}
	,createLandscape: function() {
		var landgeo = new THREE.BoxGeometry(2,2,2);
		var landmat = new THREE.MeshPhongMaterial({ depthWrite : true, color : DemoMain.WHITE.getHex()});
		var _g = -25;
		while(_g < 25) {
			var x = _g++;
			var _g1 = -25;
			while(_g1 < 25) {
				var b = new THREE.Mesh(landgeo,landmat);
				this.scene.add(b);
				b.position.set(x * 2,0.25 * Math.random(),_g1++ * 2);
			}
		}
	}
	,__class__: intro_Intro
});
var js__$Boot_HaxeError = function(val) {
	Error.call(this);
	this.val = val;
	this.message = String(val);
	if(Error.captureStackTrace) {
		Error.captureStackTrace(this,js__$Boot_HaxeError);
	}
};
js__$Boot_HaxeError.__name__ = ["js","_Boot","HaxeError"];
js__$Boot_HaxeError.wrap = function(val) {
	if((val instanceof Error)) {
		return val;
	} else {
		return new js__$Boot_HaxeError(val);
	}
};
js__$Boot_HaxeError.__super__ = Error;
js__$Boot_HaxeError.prototype = $extend(Error.prototype,{
	__class__: js__$Boot_HaxeError
});
var js_Boot = function() { };
js_Boot.__name__ = ["js","Boot"];
js_Boot.getClass = function(o) {
	if((o instanceof Array) && o.__enum__ == null) {
		return Array;
	} else {
		var cl = o.__class__;
		if(cl != null) {
			return cl;
		}
		var name = js_Boot.__nativeClassName(o);
		if(name != null) {
			return js_Boot.__resolveNativeClass(name);
		}
		return null;
	}
};
js_Boot.__string_rec = function(o,s) {
	if(o == null) {
		return "null";
	}
	if(s.length >= 5) {
		return "<...>";
	}
	var t = typeof(o);
	if(t == "function" && (o.__name__ || o.__ename__)) {
		t = "object";
	}
	switch(t) {
	case "function":
		return "<function>";
	case "object":
		if(o instanceof Array) {
			if(o.__enum__) {
				if(o.length == 2) {
					return o[0];
				}
				var str = o[0] + "(";
				s += "\t";
				var _g1 = 2;
				var _g = o.length;
				while(_g1 < _g) {
					var i = _g1++;
					if(i != 2) {
						str += "," + js_Boot.__string_rec(o[i],s);
					} else {
						str += js_Boot.__string_rec(o[i],s);
					}
				}
				return str + ")";
			}
			var l = o.length;
			var i1;
			var str1 = "[";
			s += "\t";
			var _g11 = 0;
			var _g2 = l;
			while(_g11 < _g2) {
				var i2 = _g11++;
				str1 += (i2 > 0 ? "," : "") + js_Boot.__string_rec(o[i2],s);
			}
			str1 += "]";
			return str1;
		}
		var tostr;
		try {
			tostr = o.toString;
		} catch( e ) {
			return "???";
		}
		if(tostr != null && tostr != Object.toString && typeof(tostr) == "function") {
			var s2 = o.toString();
			if(s2 != "[object Object]") {
				return s2;
			}
		}
		var k = null;
		var str2 = "{\n";
		s += "\t";
		var hasp = o.hasOwnProperty != null;
		for( var k in o ) {
		if(hasp && !o.hasOwnProperty(k)) {
			continue;
		}
		if(k == "prototype" || k == "__class__" || k == "__super__" || k == "__interfaces__" || k == "__properties__") {
			continue;
		}
		if(str2.length != 2) {
			str2 += ", \n";
		}
		str2 += s + k + " : " + js_Boot.__string_rec(o[k],s);
		}
		s = s.substring(1);
		str2 += "\n" + s + "}";
		return str2;
	case "string":
		return o;
	default:
		return String(o);
	}
};
js_Boot.__interfLoop = function(cc,cl) {
	if(cc == null) {
		return false;
	}
	if(cc == cl) {
		return true;
	}
	var intf = cc.__interfaces__;
	if(intf != null) {
		var _g1 = 0;
		var _g = intf.length;
		while(_g1 < _g) {
			var i = intf[_g1++];
			if(i == cl || js_Boot.__interfLoop(i,cl)) {
				return true;
			}
		}
	}
	return js_Boot.__interfLoop(cc.__super__,cl);
};
js_Boot.__instanceof = function(o,cl) {
	if(cl == null) {
		return false;
	}
	switch(cl) {
	case Array:
		if((o instanceof Array)) {
			return o.__enum__ == null;
		} else {
			return false;
		}
		break;
	case Bool:
		return typeof(o) == "boolean";
	case Dynamic:
		return true;
	case Float:
		return typeof(o) == "number";
	case Int:
		if(typeof(o) == "number") {
			return (o|0) === o;
		} else {
			return false;
		}
		break;
	case String:
		return typeof(o) == "string";
	default:
		if(o != null) {
			if(typeof(cl) == "function") {
				if(o instanceof cl) {
					return true;
				}
				if(js_Boot.__interfLoop(js_Boot.getClass(o),cl)) {
					return true;
				}
			} else if(typeof(cl) == "object" && js_Boot.__isNativeObj(cl)) {
				if(o instanceof cl) {
					return true;
				}
			}
		} else {
			return false;
		}
		if(cl == Class ? o.__name__ != null : false) {
			return true;
		}
		if(cl == Enum ? o.__ename__ != null : false) {
			return true;
		}
		return o.__enum__ == cl;
	}
};
js_Boot.__nativeClassName = function(o) {
	var name = js_Boot.__toStr.call(o).slice(8,-1);
	if(name == "Object" || name == "Function" || name == "Math" || name == "JSON") {
		return null;
	}
	return name;
};
js_Boot.__isNativeObj = function(o) {
	return js_Boot.__nativeClassName(o) != null;
};
js_Boot.__resolveNativeClass = function(name) {
	return $global[name];
};
var js_html_compat_ArrayBuffer = function(a) {
	if((a instanceof Array) && a.__enum__ == null) {
		this.a = a;
		this.byteLength = a.length;
	} else {
		var len = a;
		this.a = [];
		var _g1 = 0;
		var _g = len;
		while(_g1 < _g) this.a[_g1++] = 0;
		this.byteLength = len;
	}
};
js_html_compat_ArrayBuffer.__name__ = ["js","html","compat","ArrayBuffer"];
js_html_compat_ArrayBuffer.sliceImpl = function(begin,end) {
	var u = new Uint8Array(this,begin,end == null ? null : end - begin);
	var result = new ArrayBuffer(u.byteLength);
	new Uint8Array(result).set(u);
	return result;
};
js_html_compat_ArrayBuffer.prototype = {
	slice: function(begin,end) {
		return new js_html_compat_ArrayBuffer(this.a.slice(begin,end));
	}
	,__class__: js_html_compat_ArrayBuffer
};
var js_html_compat_Float32Array = function() { };
js_html_compat_Float32Array.__name__ = ["js","html","compat","Float32Array"];
js_html_compat_Float32Array._new = function(arg1,offset,length) {
	var arr;
	if(typeof(arg1) == "number") {
		arr = [];
		var _g1 = 0;
		var _g = arg1;
		while(_g1 < _g) {
			var i = _g1++;
			arr[i] = 0;
		}
		arr.byteLength = arr.length << 2;
		arr.byteOffset = 0;
		var _g2 = [];
		var _g21 = 0;
		var _g11 = arr.length << 2;
		while(_g21 < _g11) {
			var i1 = _g21++;
			_g2.push(0);
		}
		arr.buffer = new js_html_compat_ArrayBuffer(_g2);
	} else if(js_Boot.__instanceof(arg1,js_html_compat_ArrayBuffer)) {
		var buffer = arg1;
		if(offset == null) {
			offset = 0;
		}
		if(length == null) {
			length = buffer.byteLength - offset >> 2;
		}
		arr = [];
		var _g12 = 0;
		var _g3 = length;
		while(_g12 < _g3) {
			var i2 = _g12++;
			var val = buffer.a[offset++] | buffer.a[offset++] << 8 | buffer.a[offset++] << 16 | buffer.a[offset++] << 24;
			arr.push(haxe_io_FPHelper.i32ToFloat(val));
		}
		arr.byteLength = arr.length << 2;
		arr.byteOffset = offset;
		arr.buffer = buffer;
	} else if((arg1 instanceof Array) && arg1.__enum__ == null) {
		arr = arg1.slice();
		var buffer1 = [];
		var _g4 = 0;
		while(_g4 < arr.length) {
			var f = arr[_g4];
			++_g4;
			var i3 = haxe_io_FPHelper.floatToI32(f);
			buffer1.push(i3 & 255);
			buffer1.push(i3 >> 8 & 255);
			buffer1.push(i3 >> 16 & 255);
			buffer1.push(i3 >>> 24);
		}
		arr.byteLength = arr.length << 2;
		arr.byteOffset = 0;
		arr.buffer = new js_html_compat_ArrayBuffer(buffer1);
	} else {
		throw new js__$Boot_HaxeError("TODO " + Std.string(arg1));
	}
	arr.subarray = js_html_compat_Float32Array._subarray;
	arr.set = js_html_compat_Float32Array._set;
	return arr;
};
js_html_compat_Float32Array._set = function(arg,offset) {
	if(js_Boot.__instanceof(arg.buffer,js_html_compat_ArrayBuffer)) {
		var a = arg;
		if(arg.byteLength + offset > this.byteLength) {
			throw new js__$Boot_HaxeError("set() outside of range");
		}
		var _g1 = 0;
		var _g = arg.byteLength;
		while(_g1 < _g) {
			var i = _g1++;
			this[i + offset] = a[i];
		}
	} else if((arg instanceof Array) && arg.__enum__ == null) {
		var a1 = arg;
		if(a1.length + offset > this.byteLength) {
			throw new js__$Boot_HaxeError("set() outside of range");
		}
		var _g11 = 0;
		var _g2 = a1.length;
		while(_g11 < _g2) {
			var i1 = _g11++;
			this[i1 + offset] = a1[i1];
		}
	} else {
		throw new js__$Boot_HaxeError("TODO");
	}
};
js_html_compat_Float32Array._subarray = function(start,end) {
	var a = js_html_compat_Float32Array._new(this.slice(start,end));
	a.byteOffset = start * 4;
	return a;
};
var js_html_compat_Uint8Array = function() { };
js_html_compat_Uint8Array.__name__ = ["js","html","compat","Uint8Array"];
js_html_compat_Uint8Array._new = function(arg1,offset,length) {
	var arr;
	if(typeof(arg1) == "number") {
		arr = [];
		var _g1 = 0;
		var _g = arg1;
		while(_g1 < _g) {
			var i = _g1++;
			arr[i] = 0;
		}
		arr.byteLength = arr.length;
		arr.byteOffset = 0;
		arr.buffer = new js_html_compat_ArrayBuffer(arr);
	} else if(js_Boot.__instanceof(arg1,js_html_compat_ArrayBuffer)) {
		var buffer = arg1;
		if(offset == null) {
			offset = 0;
		}
		if(length == null) {
			length = buffer.byteLength - offset;
		}
		if(offset == 0) {
			arr = buffer.a;
		} else {
			arr = buffer.a.slice(offset,offset + length);
		}
		arr.byteLength = arr.length;
		arr.byteOffset = offset;
		arr.buffer = buffer;
	} else if((arg1 instanceof Array) && arg1.__enum__ == null) {
		arr = arg1.slice();
		arr.byteLength = arr.length;
		arr.byteOffset = 0;
		arr.buffer = new js_html_compat_ArrayBuffer(arr);
	} else {
		throw new js__$Boot_HaxeError("TODO " + Std.string(arg1));
	}
	arr.subarray = js_html_compat_Uint8Array._subarray;
	arr.set = js_html_compat_Uint8Array._set;
	return arr;
};
js_html_compat_Uint8Array._set = function(arg,offset) {
	if(js_Boot.__instanceof(arg.buffer,js_html_compat_ArrayBuffer)) {
		var a = arg;
		if(arg.byteLength + offset > this.byteLength) {
			throw new js__$Boot_HaxeError("set() outside of range");
		}
		var _g1 = 0;
		var _g = arg.byteLength;
		while(_g1 < _g) {
			var i = _g1++;
			this[i + offset] = a[i];
		}
	} else if((arg instanceof Array) && arg.__enum__ == null) {
		var a1 = arg;
		if(a1.length + offset > this.byteLength) {
			throw new js__$Boot_HaxeError("set() outside of range");
		}
		var _g11 = 0;
		var _g2 = a1.length;
		while(_g11 < _g2) {
			var i1 = _g11++;
			this[i1 + offset] = a1[i1];
		}
	} else {
		throw new js__$Boot_HaxeError("TODO");
	}
};
js_html_compat_Uint8Array._subarray = function(start,end) {
	var a = js_html_compat_Uint8Array._new(this.slice(start,end));
	a.byteOffset = start;
	return a;
};
var js_three_GPUParticleOptions = function() {
	this.sizeRandomness = 0;
	this.size = 0;
	this.lifetime = 0;
	this.turbulence = 0;
	this.colorRandomness = 0;
	this.color = 16777215;
	this.velocityRandomness = 0;
	this.positionRandomness = 0;
	this.velocity = new THREE.Vector3();
	this.position = new THREE.Vector3();
};
js_three_GPUParticleOptions.__name__ = ["js","three","GPUParticleOptions"];
js_three_GPUParticleOptions.prototype = {
	__class__: js_three_GPUParticleOptions
};
var js_three_GPUParticleSystemOptions = function(maxParticles,containerCount,particleNoiseTex,particleSpriteTex) {
	this.maxParticles = maxParticles;
	this.containerCount = containerCount;
	this.particleNoiseTex = particleNoiseTex;
	this.particleSpriteTex = particleSpriteTex;
};
js_three_GPUParticleSystemOptions.__name__ = ["js","three","GPUParticleSystemOptions"];
js_three_GPUParticleSystemOptions.prototype = {
	__class__: js_three_GPUParticleSystemOptions
};
var physicsTest_PhysicsTest = function() {
	this.transformAux1 = new Ammo.btTransform();
	this.rigidBodies = [];
	this.startTime = 0;
	wl_core_Part.call(this);
};
physicsTest_PhysicsTest.__name__ = ["physicsTest","PhysicsTest"];
physicsTest_PhysicsTest.__super__ = wl_core_Part;
physicsTest_PhysicsTest.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.initComposer(this.getComposerList({ dof : false, rgbShift : false, colorHilight : false, pixelate : false, distortedTV : false, standard : false, displacement : false, bloom : false, gray : false}));
		var options = { };
		options.format = THREE.RGBFormat;
		this.mirrorRT = new THREE.WebGLRenderTarget(1600,1600,options);
		var sun = new THREE.PointLight(11447982,0.5);
		sun.position.set(30,30,30);
		this.scene.add(sun);
		var sun1 = new THREE.PointLight(11447982,0.5);
		sun1.position.set(0,0,0);
		this.scene.add(sun1);
		this.scene.add(this.camera);
		this.reflectiveCamera = new THREE.OrthographicCamera(-100,100,-100,100,0.0001,500);
		this.reflectiveCamera.position.set(0,-2,0);
		this.reflectiveCamera.lookAt(new THREE.Vector3(0,0,0));
		this.scene.add(this.reflectiveCamera);
		this.initPhysics();
		this.buildScene();
	}
	,buildScene: function() {
		var geo;
		var m = new THREE.MeshPhongMaterial({ color : 15395562});
		geo = new THREE.BoxGeometry(2,2,2);
		geo.computeBoundingBox();
		var spawnersize = geo.boundingBox.size();
		var boxshape = new Ammo.btBoxShape(new Ammo.btVector3(spawnersize.x * 0.5,spawnersize.y * 0.5,spawnersize.z * 0.5));
		var _g = 0;
		while(_g < 7) {
			var y = _g++;
			var _g1 = -2;
			while(_g1 < 2) {
				var x = _g1++;
				var _g2 = -2;
				while(_g2 < 2) {
					var mesh = new THREE.Mesh(geo,m);
					mesh.rotateX(wl_util_Random.nextFloat() * Math.PI * 2);
					mesh.rotateY(wl_util_Random.nextFloat() * Math.PI * 2);
					mesh.rotateZ(wl_util_Random.nextFloat() * Math.PI * 2);
					mesh.position.set(x * spawnersize.x + wl_util_Random.nextFloat() - 0.5,y * spawnersize.y + y * 3 + wl_util_Random.nextFloat() - 0.5,_g2++ * spawnersize.z + wl_util_Random.nextFloat() - 0.5);
					this.createRigidBody(mesh,boxshape,5);
				}
			}
		}
		this.camera.position.set(30,30,30);
		this.camera.lookAt(new THREE.Vector3(0,5,0));
		var groundMaterialOptions = { color : 10000536, map : this.mirrorRT};
		var groundMesh = new THREE.Mesh(new THREE.BoxGeometry(200,2,200),new THREE.MeshPhongMaterial(groundMaterialOptions));
		groundMesh.position.set(0,-5,0);
		this.createRigidBody(groundMesh,new Ammo.btBoxShape(new Ammo.btVector3(100,1,100)),0);
	}
	,initPhysics: function() {
		var collisionConfiguration = new Ammo.btDefaultCollisionConfiguration();
		this.physicsWorld = new Ammo.btDiscreteDynamicsWorld(new Ammo.btCollisionDispatcher(collisionConfiguration),new Ammo.btDbvtBroadphase(),new Ammo.btSequentialImpulseConstraintSolver(),collisionConfiguration);
		this.physicsWorld.setGravity(new Ammo.btVector3(0,-1,0));
	}
	,createRigidBody: function(threeObject,physicsShape,mass) {
		var pos = threeObject.position;
		var quat = threeObject.quaternion;
		var transform = new Ammo.btTransform();
		var identity = new Ammo.btTransform();
		identity.setIdentity();
		transform.setIdentity();
		transform.setOrigin(new Ammo.btVector3(pos.x,pos.y,pos.z));
		transform.setRotation(new Ammo.btQuaternion(quat.x,quat.y,quat.z,quat.w));
		var motionState = new Ammo.btDefaultMotionState(transform,identity);
		var localInertia = new Ammo.btVector3(0,0,0);
		physicsShape.calculateLocalInertia(mass,localInertia);
		var body = new Ammo.btRigidBody(new Ammo.btRigidBodyConstructionInfo(mass,motionState,physicsShape,localInertia));
		threeObject.userData.physicsBody = body;
		if(mass > 0) {
			this.rigidBodies.push(threeObject);
			body.setActivationState(4);
		}
		this.scene.add(threeObject);
		this.physicsWorld.addRigidBody(body);
	}
	,update: function(ts,partial,frameTime,delta) {
		this.updatePhysics(ts.toMilliseconds() - this.startTime);
	}
	,updatePhysics: function(deltaTime) {
		this.physicsWorld.stepSimulation(deltaTime,10);
		var _g1 = 0;
		var _g = this.rigidBodies.length;
		while(_g1 < _g) {
			var objThree = this.rigidBodies[_g1++];
			var ms = objThree.userData.physicsBody.getMotionState();
			if(ms != null) {
				ms.getWorldTransform(this.transformAux1);
				var p = this.transformAux1.getOrigin();
				var q = this.transformAux1.getRotation();
				objThree.position.set(p.x(),p.y(),p.z());
				objThree.quaternion.set(q.x(),q.y(),q.z(),q.w());
			}
		}
	}
	,render: function(ts,frameTime) {
		var r = wl_core_Graphics.instance.renderer;
		r.setClearColor(16777215);
		r.render(this.scene,this.reflectiveCamera,this.mirrorRT);
		wl_core_Part.prototype.render.call(this,ts,frameTime);
	}
	,__class__: physicsTest_PhysicsTest
});
var raytrace_Raytrace = function(instantBloom) {
	this.limits = [0,0,0.42,0.42,0.4,0.4,0.4,0.4,0.26,0.26,0.25,0.25,0.25,0.25,0.25,0.25];
	this.thresholds = [0,0,0.04,0.04,0.04,0.04,0.1,0.1,0.2,0.2,0.4,0.4,1.4,1.4,1.4,1.4];
	this.blooms = [0,0,0.6,0.6,1.8,1.8,2.4,2.4,4,4,10,10,15,16,17,18];
	this.phase = 0;
	this.cams = [0,1,2,3,0,3,0,3,0,3];
	this.globalMP = 1;
	this.ending2 = false;
	this.ending = false;
	this.filters = [];
	this.startBloom = 0;
	this.bloomOn = false;
	this.swapcount = 0;
	this.camstate = 0;
	this.triangleMaterials = [];
	this.balls = [];
	this.tirangleMaterials = [];
	this.triangles = [];
	wl_core_Part.call(this);
	this.bloomOn = instantBloom;
};
raytrace_Raytrace.__name__ = ["raytrace","Raytrace"];
raytrace_Raytrace.__super__ = wl_core_Part;
raytrace_Raytrace.prototype = $extend(wl_core_Part.prototype,{
	initanalyzer: function() {
		this.analyzer = new wl_sounds_SoundAnalyzer();
		this.analyzer.historySize = 6;
		this.filters = [];
		var filter = { lowLimit : 50, highLimit : 400, isolate : true};
		this.filters.push(filter);
		this.analyzer.filters.push(filter);
		var filter1 = { lowLimit : 7000, highLimit : 10000, isolate : true};
		this.filters.push(filter1);
		this.analyzer.filters.push(filter1);
	}
	,init: function() {
		var _gthis = this;
		wl_core_Part.prototype.init.call(this);
		this.initanalyzer();
		this.initStandardScene();
		this.initComposer(this.getComposerList({ dof : false, rgbShift : false, colorHilight : false, pixelate : false, distortedTV : true, standard : false, displacement : false, bloom : true, gray : false}));
		this.plane = new THREE.Mesh(new THREE.PlaneGeometry(30,30 * wl_core_Config.RESOLUTION[1] / wl_core_Config.RESOLUTION[1]),new THREE.MeshBasicMaterial({ side : THREE.DoubleSide, color : 16777215, map : wl_core_Demo.instance.getPart("intro").renderTo.texture}));
		this.plane.position.z = 120;
		this.plane.rotation.x = Math.PI;
		this.plane.scale.x = this.plane.scale.y = 3.5;
		this.plane.scale.x = 4;
		this.scene.add(this.plane);
		this.plane.visible = false;
		this.container = new THREE.Object3D();
		this.scene.add(this.container);
		var halfspawnerJson = JSON.parse(haxe_Resource.getString("triangle.json"));
		var callbackModel = function(geometry) {
			_gthis.triangleGeo = geometry;
			_gthis.triangleGeo.rotateX(-Math.PI / 2);
			_gthis.triangleGeo.scale(14,14,14);
		};
		new THREE.OfflineJSONLoader().load(halfspawnerJson,callbackModel);
		var colors = [DemoMain.BLUE,DemoMain.BLUE_DARK,DemoMain.HILIGHT];
		var _g = 0;
		while(_g < 3) {
			var triangleMaterial = new THREE.MeshBasicMaterial({ color : colors[_g++ % colors.length].getHex(), side : THREE.DoubleSide});
			this.triangleMaterials.push(triangleMaterial);
		}
		var _g1 = 0;
		while(_g1 < 40) {
			var i = _g1++;
			var triangle = new THREE.Mesh(this.triangleGeo,this.triangleMaterials[i % this.triangleMaterials.length]);
			this.triangles.push(triangle);
			this.scene.add(triangle);
			triangle.position.z = i * 24;
		}
		this.ballGeo = new THREE.DodecahedronGeometry(1,4);
		var positions = [new THREE.Vector3(-1,0,-1 / Math.sqrt(2)),new THREE.Vector3(1,0,-1 / Math.sqrt(2)),new THREE.Vector3(0,1,1 / Math.sqrt(2)),new THREE.Vector3(0,-1,1 / Math.sqrt(2))];
		var _g2 = 0;
		while(_g2 < 4) {
			var i1 = _g2++;
			var ball = { };
			ball.cubecam = new THREE.CubeCamera(1,100,512);
			var ballmat = new THREE.MeshBasicMaterial({ envMap : ball.cubecam.renderTarget.texture, color : DemoMain.LIGHT.getHex()});
			ball.mesh = new THREE.Mesh(this.ballGeo,ballmat);
			this.container.add(ball.mesh);
			ball.mesh.position.copy(positions[i1 % 4]);
			ball.mesh.add(ball.cubecam);
			ball.origPos = positions[i1 % 4];
			this.balls.push(ball);
		}
		this.postProcessing.bloom.strength = 0.4;
		this.postProcessing.bloom.threshold = 0.7;
		if(this.bloomOn) {
			this.postProcessing.distortedTV.set_offsetAmount(1);
			this.postProcessing.distortedTV.set_distortAmount(wl_core_Config.RESOLUTION[1] * 2);
			this.postProcessing.distortedTV.set_vignAmount(0);
			this.addTrigger(new wl_core_TimeSig(-1,0,1,0,wl_core_TimeSig.PATTERN),$bind(this,this.switchCam));
			this.addTrigger(new wl_core_TimeSig(-1,0,2,0,wl_core_TimeSig.PATTERN),$bind(this,this.switchCam));
			this.addTrigger(new wl_core_TimeSig(-1,0,3,0,wl_core_TimeSig.PATTERN),$bind(this,this.switchCam));
			this.cams = [0,2,1,2,0,1,0,2,1,2,0,1,0,2,1,2,0,1,0,2,1,2,0,1,0,2,1,2,0,1,0,2,1,2,0,1,0,2,1,2,0,1,0,2,1,2,0,1];
			this.globalMP = 1.5;
		}
		this.camera.position.z = -10;
		this.camera.lookAt(new THREE.Vector3(0,0,0));
		this.addTrigger(new wl_core_TimeSig(-1,0,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.switchCam));
		this.addTrigger(new wl_core_TimeSig(14,2,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.outro));
		this.addTrigger(new wl_core_TimeSig(14,2,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.outro1));
	}
	,outro1: function(ts) {
		var _gthis = this;
		this.ending2 = true;
		createjs.Tween.removeTweens(this.postProcessing.bloom);
		createjs.Tween.get(this.postProcessing.bloom).to({ strength : 0.5, threshold : 0.3, radius : 0},wl_core_TimeSig.milliseconds(1,1,0,0),createjs.Ease.quadOut).call(function() {
			_gthis.postProcessing.bloom.strength = 0;
		});
	}
	,outro: function(ts) {
		this.container.visible = false;
		createjs.Tween.get(this.container.position).to({ y : -40},wl_core_TimeSig.milliseconds(0,2,0,0));
		createjs.Tween.get(this.postProcessing.bloom).wait(wl_core_TimeSig.milliseconds(1,1,6,0)).to({ strength : 2, threshold : 0, radius : 0},wl_core_TimeSig.milliseconds(0,0,6,0));
		this.ending = true;
		this.plane.visible = true;
	}
	,switchCam: function(ts) {
		if(this.ending) {
			return;
		}
		if(ts.bar % 2 == 0 || this.bloomOn) {
			this.swapcount++;
			if(this.cams.length == 0) {
				this.cams = [0,1,2,3];
			}
			if(this.cams.length > 0) {
				this.camstate = this.cams.shift();
			}
		}
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
		this.container.rotation.x = Math.sin(partial * 20) * 3 * this.globalMP;
		this.container.rotation.y = Math.sin(partial * 11) * 3 * this.globalMP;
		console.log(this.container.rotation);
	}
	,render: function(ts,frameTime) {
		var delta = frameTime / 16.666666666666668;
		var bd = 1;
		var tsc = 1;
		var space = 5;
		var speed = 0.05;
		var tAngle = 0;
		var tPhase = 0;
		var tPhaseMP = 1;
		var fov = 30;
		var bs = 1;
		var geo = this.ballGeo;
		var sbs = 1;
		if(this.ending) {
			this.camera.rotation.z = 0;
			this.camera.position.z = -6;
			this.camera.position.y = 0;
			this.camera.position.x = 0;
			this.camera.lookAt(new THREE.Vector3(0,0,0));
		} else if(this.camstate == 0) {
			tAngle = 0;
			tPhase = 0;
			space = 14;
			tsc = 1;
			bd = 1;
			fov = 30;
			this.camera.rotation.z = 0;
			this.camera.position.z = -6;
			this.camera.position.y = 0;
			this.camera.position.x = 0;
			this.camera.lookAt(new THREE.Vector3(0,0,0));
		} else if(this.camstate == 1) {
			tAngle = 3.7;
			tPhase = 0.1;
			space = 13;
			bd = 2.5;
			tsc = 1.4;
			speed = 0.05;
			tPhaseMP = 0.02;
			fov = 60;
			bs = 1;
			this.camera.rotation.z = Math.PI;
			this.camera.position.y = 0;
			this.camera.position.x = 0;
			this.camera.lookAt(new THREE.Vector3(0,0,0));
		} else if(this.camstate == 2) {
			tAngle = 0;
			tPhase = 0.1;
			space = 10;
			bd = 1;
			tsc = 3;
			speed = 0.01;
			tPhaseMP = 0.02;
			fov = 90;
			this.camera.position.z = -2.7;
			this.camera.position.y = 0;
			this.camera.position.x = 0;
			this.camera.lookAt(new THREE.Vector3(0,0,0));
		} else if(this.camstate == 3) {
			tAngle = 1.7;
			tPhase = 0.05;
			space = 25;
			bd = 1;
			tsc = 1;
			speed = 0.05;
			tPhaseMP = 0.02;
			fov = 30;
			bs = 1;
			geo = this.triangleGeo;
			bs = 1;
			sbs = 0.1;
			this.camera.position.z = 10;
			this.camera.position.y = 0;
			this.camera.position.x = 0;
			this.camera.lookAt(new THREE.Vector3(0,0,0));
		}
		if(this.bloomOn) {
			this.postProcessing.bloom.strength = this.blooms[10];
			this.postProcessing.bloom.radius = this.thresholds[10];
			this.postProcessing.bloom.threshold = this.limits[10];
		} else if(!this.ending2) {
			if(ts.bar < this.blooms.length) {
				this.postProcessing.bloom.strength = this.blooms[ts.bar] + (this.filters[1].triggered ? this.filters[1].max * 0.4 : 0);
				this.postProcessing.bloom.radius = this.thresholds[ts.bar];
				this.postProcessing.bloom.threshold = this.limits[ts.bar];
			}
		}
		this.container.scale.x = this.container.scale.y = this.container.scale.z = bs;
		this.camera.rotation.z = this.ending ? 0 : Math.PI / 2 * this.swapcount;
		this.camera.fov = fov;
		this.camera.updateProjectionMatrix();
		speed *= this.globalMP;
		this.phase += delta * speed;
		var _g1 = 0;
		var _g = this.triangles.length;
		while(_g1 < _g) {
			var i = _g1++;
			var t = this.triangles[i];
			if(this.ending) {
				t.scale.z = 8;
				t.position.z -= delta * 3.7;
			} else {
				t.position.z = -((i + this.phase) * space % (40 * space)) + 20 * space;
				t.scale.x = t.scale.y = t.scale.z = tsc;
			}
			t.rotation.z = Math.sin(i * tPhase + this.phase * tPhaseMP) * tAngle;
		}
		var _g2 = 0;
		var _g11 = this.balls;
		while(_g2 < _g11.length) {
			var b = _g11[_g2];
			++_g2;
			b.mesh.geometry = geo;
			b.mesh.scale.x = b.mesh.scale.y = b.mesh.scale.z = sbs;
			b.mesh.visible = false;
			b.mesh.position.set(b.origPos.x * bd,b.origPos.y * bd,b.origPos.z * bd);
			b.cubecam.updateCubeMap(wl_core_Graphics.instance.renderer,this.scene);
			b.mesh.visible = true;
		}
		this.analyzer.update();
		if(this.filters[0].triggered) {
			this.postProcessing.distortedTV.set_vignAmount(this.filters[0].max * 0.2 + 0.1);
		} else {
			this.postProcessing.distortedTV.set_vignAmount(0.1);
		}
		wl_core_Part.prototype.render.call(this,ts,frameTime);
	}
	,__class__: raytrace_Raytrace
});
var shared_BgQuad = function(camera) {
	THREE.Object3D.call(this);
	this.sm = new THREE.ShaderMaterial({ vertexShader : haxe_Resource.getString("bgQuad.vert"), fragmentShader : haxe_Resource.getString("bgQuad.frag"), uniforms : { time : { type : "f", value : 0.0}}});
	new THREE.MeshBasicMaterial({ color : 16777215});
	this.plane = new THREE.Mesh(new THREE.PlaneGeometry(1,1),this.sm);
	this.add(this.plane);
	this.plane.lookAt(camera.position);
	this.camera = camera;
};
shared_BgQuad.__name__ = ["shared","BgQuad"];
shared_BgQuad.__super__ = THREE.Object3D;
shared_BgQuad.prototype = $extend(THREE.Object3D.prototype,{
	update: function(ts) {
		this.sm.uniforms.time.value = ts.toMilliseconds() / 1000;
		this.plane.lookAt(this.camera.position);
		var lookAtVector = new THREE.Vector3(0,0,-1);
		lookAtVector.applyQuaternion(this.camera.quaternion);
		this.plane.position.copy(lookAtVector.multiplyScalar(this.camera.far * 0.5));
		var height = 2 * Math.tan(this.camera.fov * Math.PI / 180 / 2) * this.plane.position.distanceTo(this.camera.position);
		this.plane.scale.set(height * this.camera.aspect,height * this.camera.aspect,height * this.camera.aspect);
	}
	,__class__: shared_BgQuad
});
var shared_Spawner = function(m) {
	var _gthis = this;
	THREE.Object3D.call(this);
	var halfspawnerJson = JSON.parse(haxe_Resource.getString("halfSpawner.json"));
	var callbackModel = function(geometry) {
		_gthis.left = new THREE.Mesh(geometry,m);
		_gthis.right = new THREE.Mesh(geometry,m);
		_gthis.right.rotateY(Math.PI);
		_gthis.left.position.x = 0.5;
		_gthis.right.position.x = -0.5;
	};
	new THREE.OfflineJSONLoader().load(halfspawnerJson,callbackModel);
	this.add(this.left);
	this.add(this.right);
	var particle = wl_core_Assets.getTexture("particleTexture.png");
	this.particleSystem = new THREE.GPUParticleSystem(new js_three_GPUParticleSystemOptions(250000,1,wl_core_Assets.getTexture("perlin-512.png"),particle));
	this.particleSizeScale = wl_core_Graphics.instance.renderer.getSize().width / 1920;
	this.add(this.particleSystem);
	this.particleOptions = [];
	this.particleOptions.push(this.createSpawnOptions(new THREE.Vector3(1,1,0)));
	this.particleOptions.push(this.createSpawnOptions(new THREE.Vector3(-1,1,0)));
	this.particleOptions.push(this.createSpawnOptions(new THREE.Vector3(-1,-1,0)));
	this.particleOptions.push(this.createSpawnOptions(new THREE.Vector3(1,-1,0)));
	this.spawnPositions = [];
	var _g1 = 0;
	var _g = this.particleOptions.length;
	while(_g1 < _g) {
		var i = _g1++;
		var pspawner = this.createspawnPosition(this.particleOptions[i].position);
		var nextposition = this.particleOptions[(i + 1) % this.particleOptions.length].position;
		createjs.Tween.get(pspawner.position,{ loop : true}).to(nextposition,350,createjs.Ease.linear);
		this.spawnPositions.push(pspawner);
	}
	var light = new THREE.PointLight(DemoMain.COBALTBLUE.getHex(),0.6);
	createjs.Tween.get(light,{ loop : true}).to({ intensity : 0.5},2000,createjs.Ease.linear).to({ intensity : 0.6},2000,createjs.Ease.linear);
	this.add(light);
	var pointsmat = new THREE.PointsMaterial({ color : 16711680});
	new THREE.Points(new THREE.BoxGeometry(4,4,4,100,100,100),pointsmat).position.y = 4;
};
shared_Spawner.__name__ = ["shared","Spawner"];
shared_Spawner.__super__ = THREE.Object3D;
shared_Spawner.prototype = $extend(THREE.Object3D.prototype,{
	createspawnPosition: function(position) {
		var obu = new THREE.Object3D();
		obu.position.set(position.x,position.y,position.z);
		return obu;
	}
	,createSpawnOptions: function(position) {
		var options = new js_three_GPUParticleOptions();
		options.position = position;
		options.positionRandomness = 0.0;
		options.velocity = position.clone().multiplyScalar(-0.0001);
		options.velocityRandomness = 0.000;
		options.color = DemoMain.COBALTBLUE.getHex();
		options.colorRandomness = 0.05;
		options.turbulence = 100;
		options.lifetime = 3000;
		options.size = 70 * this.particleSizeScale;
		options.sizeRandomness = 10 * this.particleSizeScale;
		return options;
	}
	,update: function(time,frameTime) {
		this.particleSystem.update(time);
		var _g1 = 0;
		var _g = this.particleOptions.length;
		while(_g1 < _g) {
			var i = _g1++;
			this.particleSystem.spawnParticle(this.particleOptions[i]);
			var target = this.spawnPositions[i].position;
			this.particleOptions[i].position.set(target.x,target.y,target.z);
			this.particleOptions[i].velocity.set(-target.x / 5000,-target.y / 5000,-target.z / 5000);
		}
	}
	,__class__: shared_Spawner
});
var storage_Storage = function() {
	this.walls = [];
	this.lastWormPositionSavedAt = 0;
	this.trailpoints = [[new THREE.Vector3(1.36,13.11,48.98),new THREE.Vector3(-12.24,9.11,24.94),new THREE.Vector3(-17.14,7.83,11.89),new THREE.Vector3(-20.68,6.97,-7.68),new THREE.Vector3(-17.35,6.5,-22.25),new THREE.Vector3(-11.23,5.93,-33.56),new THREE.Vector3(1.7,4.93,-27.87),new THREE.Vector3(1.5,5.69,-13.9),new THREE.Vector3(0.73,6.09,-5.95),new THREE.Vector3(-0.01,6.55,2.01),new THREE.Vector3(-0.72,7.12,11.97),new THREE.Vector3(-6.84,7.38,41.51),new THREE.Vector3(-1.57,7.23,54.25),new THREE.Vector3(11.44,7.23,56.97),new THREE.Vector3(28.31,7.23,50.88),new THREE.Vector3(38.87,7.39,34.03)],[new THREE.Vector3(-1.93,-1.22,-49.94),new THREE.Vector3(-46.15,-0.01,-68.69),new THREE.Vector3(-52.27,-1.29,-81.29),new THREE.Vector3(-13.99,3.07,-107.38),new THREE.Vector3(14.12,4.78,-117.16),new THREE.Vector3(64.96,-1.89,-97.85),new THREE.Vector3(1.55,12.37,71.85),new THREE.Vector3(-4.32,10.08,85.84),new THREE.Vector3(-9.43,11.79,93.37),new THREE.Vector3(-7.13,12.24,101.59),new THREE.Vector3(-7.84,12.81,111.55),new THREE.Vector3(87.52,-0.44,73.7),new THREE.Vector3(58.28,1.15,-25.64),new THREE.Vector3(-13.86,4.64,-39.74),new THREE.Vector3(-29.91,12.49,-30.25),new THREE.Vector3(-43.17,10.47,-23.08)]];
	this.lightTrailparts = [];
	this.transformAux1 = new Ammo.btTransform();
	this.rigidBodies = [];
	this.startTime = 0;
	wl_core_Part.call(this);
};
storage_Storage.__name__ = ["storage","Storage"];
storage_Storage.__super__ = wl_core_Part;
storage_Storage.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.initComposer(this.getComposerList({ dof : false, rgbShift : false, colorHilight : false, pixelate : false, distortedTV : false, standard : false, displacement : false, bloom : false, gray : false}));
		wl_core_Graphics.instance.renderer.shadowMapEnabled = true;
		this.camera.position.set(20,35,25);
		this.camera.lookAt(new THREE.Vector3(0,10,0));
		var options = { };
		options.format = THREE.RGBFormat;
		this.mirrorRT = new THREE.WebGLRenderTarget(3200,3200,options);
		this.scene.add(this.camera);
		this.initPhysics();
		this.buildScene();
		var trailgeo = new THREE.SphereGeometry(0.9,10,10);
		var halfspawnerJson = JSON.parse(haxe_Resource.getString("triangle.json"));
		var callbackModel = function(geometry) {
			trailgeo = geometry;
			trailgeo.rotateX(-Math.PI / 2);
			trailgeo.scale(2,2,2);
			trailgeo.rotateX(Math.PI * 90 / 180);
		};
		new THREE.OfflineJSONLoader().load(halfspawnerJson,callbackModel);
		var trailmaterial = new THREE.MeshPhongMaterial({ color : DemoMain.HILIGHT.getHex()});
		trailmaterial.metal = false;
		this.lightTrail = new THREE.Mesh(trailgeo,trailmaterial);
		this.lightTrail.position.y = -2;
		trailgeo.computeBoundingBox();
		var trailPl = new THREE.PointLight(DemoMain.HILIGHT.getHex(),0.75,30,0.55);
		this.lightTrail.add(trailPl);
		this.scene.add(this.lightTrail);
		this.trailcontroller = new wl_demo_CameraController(this.lightTrail);
		this.trailcontroller.initBezier(this.trailpoints[0],this.trailpoints[1]);
		this.lightTrail.scale.set(0.8,0.8,0.8);
		var _g1 = 0;
		while(_g1 < 200) {
			var i = _g1++;
			var pm = new THREE.Mesh(trailgeo,trailmaterial);
			pm.castShadow = true;
			pm.position.set(this.lightTrail.position.x,this.lightTrail.position.y,this.lightTrail.position.z - 0.9 * i);
			var scale = 1 - Math.max(0.1,i / 200);
			pm.scale.set(scale,scale,scale);
			this.lightTrailparts.push(pm);
			this.scene.add(pm);
		}
		this.cameraController = new wl_demo_CameraController(this.camera);
		this.cameraController.initFollow(this.lightTrail,new THREE.Vector3(20,10,20));
		this.reflectiveCamera = new THREE.OrthographicCamera(-200,200,-200,200,2,500);
		this.reflectiveCamera.position.set(0,-2,0);
		this.reflectiveCamera.lookAt(new THREE.Vector3(0,0,0));
		this.scene.add(this.reflectiveCamera);
		this.scene.add(new THREE.AmbientLight(8421504));
	}
	,buildScene: function() {
		var pl = new THREE.SpotLight(16777215,1,120);
		pl.position.set(0,30,20);
		pl.lookAt(new THREE.Vector3(0,0,0));
		pl.castShadow = true;
		this.scene.add(pl);
		var pillarGeo = new THREE.SphereGeometry(1);
		var pillarMaterial = new THREE.MeshPhongMaterial({ color : DemoMain.GREEN.getHex()});
		var collisionshape = new Ammo.btSphereShape(1);
		pillarGeo.computeBoundingBox();
		var _g = 0;
		while(_g < 5) {
			var x = _g++;
			var _g1 = 0;
			while(_g1 < 6) this.createPillar(new THREE.Vector3(x,5,_g1++),pillarGeo,pillarMaterial,1,collisionshape,2);
		}
		var groundMaterialOptions = { color : DemoMain.HILIGHT.getHex()};
		var groundMesh = new THREE.Mesh(new THREE.BoxGeometry(400,1,400),new THREE.MeshPhongMaterial(groundMaterialOptions));
		groundMesh.position.set(0,0,0);
		groundMesh.receiveShadow = true;
		this.createRigidBody(groundMesh,new Ammo.btBoxShape(new Ammo.btVector3(100,0.5,100)),0);
		var wallshape = new Ammo.btBoxShape(new Ammo.btVector3(1,20,20));
		new THREE.BoxGeometry(1,40,10);
		new THREE.MeshBasicMaterial({ color : 16777215});
		var wall = new THREE.Object3D();
		wall.position.set(0,0,-1);
		wall.rotateY(Math.PI * 90 / 180);
		this.createRigidBody(wall,wallshape,0);
		this.walls.push(wall);
		var wall1 = new THREE.Object3D();
		wall1.position.set(0,0,12);
		wall1.rotateY(Math.PI * 90 / 180);
		this.createRigidBody(wall1,wallshape,0);
		this.walls.push(wall1);
		var wall2 = new THREE.Object3D();
		wall2.position.set(-5,0,5);
		this.createRigidBody(wall2,wallshape,0);
		this.walls.push(wall2);
		var wall3 = new THREE.Object3D();
		wall3.position.set(5,0,5);
		this.createRigidBody(wall3,wallshape,0);
		this.walls.push(wall3);
	}
	,createPillar: function(pos,geo,m,pillarwidth,collisionShape,mass) {
		var _g = 0;
		while(_g < 7) {
			var y = _g++;
			var _g1 = 0;
			while(_g1 < 1) {
				var z = _g1++;
				var _g2 = 0;
				while(_g2 < 1) {
					var m1 = new THREE.Mesh(geo,m);
					m1.castShadow = true;
					m1.position.set(pos.x + _g2++ * pillarwidth,pos.y + y * pillarwidth * 2,pos.z + z * pillarwidth);
					this.createRigidBody(m1,collisionShape,mass);
				}
			}
		}
	}
	,initPhysics: function() {
		var collisionConfiguration = new Ammo.btDefaultCollisionConfiguration();
		this.physicsWorld = new Ammo.btDiscreteDynamicsWorld(new Ammo.btCollisionDispatcher(collisionConfiguration),new Ammo.btDbvtBroadphase(),new Ammo.btSequentialImpulseConstraintSolver(),collisionConfiguration);
		this.physicsWorld.setGravity(new Ammo.btVector3(0,-1,0));
	}
	,createRigidBody: function(threeObject,physicsShape,mass) {
		var pos = threeObject.position;
		var quat = threeObject.quaternion;
		var transform = new Ammo.btTransform();
		var identity = new Ammo.btTransform();
		identity.setIdentity();
		transform.setIdentity();
		transform.setOrigin(new Ammo.btVector3(pos.x,pos.y,pos.z));
		transform.setRotation(new Ammo.btQuaternion(quat.x,quat.y,quat.z,quat.w));
		var motionState = new Ammo.btDefaultMotionState(transform,identity);
		var localInertia = new Ammo.btVector3(0,0,0);
		physicsShape.calculateLocalInertia(mass,localInertia);
		var body = new Ammo.btRigidBody(new Ammo.btRigidBodyConstructionInfo(mass,motionState,physicsShape,localInertia));
		threeObject.userData.physicsBody = body;
		if(mass > 0) {
			this.rigidBodies.push(threeObject);
			body.setActivationState(4);
		}
		this.scene.add(threeObject);
		this.physicsWorld.addRigidBody(body);
	}
	,start: function(ts) {
		wl_core_Part.prototype.start.call(this,ts);
		this.startTime = ts.toMilliseconds();
	}
	,update: function(ts,partial,frameTime,delta) {
		this.trailcontroller.update(partial);
		if(ts.toMilliseconds() - this.lastWormPositionSavedAt > 15) {
			this.lastWormPositionSavedAt = ts.toMilliseconds();
			var _g1 = 0;
			var _g = this.lightTrailparts.length;
			while(_g1 < _g) {
				var tpri = this.lightTrailparts.length - 1 - _g1++;
				var tp = this.lightTrailparts[tpri];
				if(tpri == 0) {
					tp.position.copy(this.lightTrail.position);
					tp.quaternion.copy(this.lightTrail.quaternion);
				} else {
					tp.position.copy(this.lightTrailparts[tpri - 1].position);
					tp.quaternion.copy(this.lightTrailparts[tpri - 1].quaternion);
				}
			}
		}
	}
	,render: function(ts,frameTime) {
		this.updatePhysics(ts.toMilliseconds() - this.startTime);
		wl_core_Graphics.instance.renderer.setClearColor(16777215);
		wl_core_Part.prototype.render.call(this,ts,frameTime);
	}
	,updatePhysics: function(deltaTime) {
		this.physicsWorld.stepSimulation(deltaTime,10);
		var _g1 = 0;
		var _g = this.rigidBodies.length;
		while(_g1 < _g) {
			var objThree = this.rigidBodies[_g1++];
			var objPhys = objThree.userData.physicsBody;
			var ms = objPhys.getMotionState();
			if(ms != null) {
				ms.getWorldTransform(this.transformAux1);
				var p = this.transformAux1.getOrigin();
				var q = this.transformAux1.getRotation();
				objThree.position.set(p.x(),p.y(),p.z());
				objThree.quaternion.set(q.x(),q.y(),q.z(),q.w());
			}
			if(this.lightTrail.position.distanceTo(objThree.position) < 5) {
				if(this.walls.length > 0) {
					var _g2 = 0;
					var _g3 = this.walls;
					while(_g2 < _g3.length) {
						var w = _g3[_g2];
						++_g2;
						this.physicsWorld.removeRigidBody(w.userData.physicsBody);
					}
					this.walls = [];
				}
				var cross = this.lightTrail.position.cross(objThree.position).normalize().multiplyScalar(25);
				cross.y += 5;
				objPhys.setLinearVelocity(new Ammo.btVector3(cross.x,cross.y,cross.z));
			}
		}
	}
	,__class__: storage_Storage
});
var toroidPhysics_ToroidPhysics = function() {
	this.lightCubeClones = [];
	this.partPos = 0;
	this.transformAux1 = new Ammo.btTransform();
	this.rigidBodies = [];
	this.startTime = 0;
	wl_core_Part.call(this);
};
toroidPhysics_ToroidPhysics.__name__ = ["toroidPhysics","ToroidPhysics"];
toroidPhysics_ToroidPhysics.__super__ = wl_core_Part;
toroidPhysics_ToroidPhysics.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		new THREE.MeshBasicMaterial({ color : 0});
		var whiteMaterial = new THREE.MeshBasicMaterial({ color : DemoMain.HILIGHT.getHex()});
		this.setupPostprocessing();
		this.lightCube = new THREE.Mesh(new THREE.BoxGeometry(8.4,10,8.4),whiteMaterial);
		this.lightCube.material.transparent = true;
		this.scene.add(this.lightCube);
		this.occlusionScene.add(this.lightCube);
		this.lightCube.position.set(0,140,0);
		this.camera.position.set(50,20,50);
		this.camera.lookAt(this.lightCube.position);
	}
	,setupPostprocessing: function() {
		this.occlusionCamera = this.camera.clone();
		this.occlusionScene = new THREE.Scene();
		this.occlusionRenderTarget = new THREE.WebGLRenderTarget(wl_core_Config.RESOLUTION[0],wl_core_Config.RESOLUTION[1]);
		this.occlusionComposer = new THREE.EffectComposer(wl_core_Graphics.instance.renderer,this.occlusionRenderTarget);
		var rp = new THREE.RenderPass(this.occlusionScene,this.occlusionCamera);
		this.occlusionComposer.addPass(rp);
		this.copyPass = new THREE.ShaderPass(THREE.CopyShader);
		this.copyPass.renderToScreen = true;
		this.oclusionpass = new godrays_VolumetricShader();
		this.oclusionpass.needsSwap = false;
		this.oclusionpass.renderToScreen = false;
		this.occlusionComposer.addPass(this.oclusionpass);
		var pass = new godrays_AdditiveBlendingShader();
		pass.uniforms.tAdd.value = this.occlusionRenderTarget.texture;
		pass.renderToScreen = false;
		var composerlist = this.getComposerList({ dof : false, rgbShift : false, colorHilight : false, pixelate : false, distortedTV : false, standard : true, displacement : false, bloom : true, gray : false});
		this.postProcessing.standard.set_gamma(1);
		composerlist.push(pass);
		this.postProcessing.standard.enabled = false;
		this.initComposer(composerlist);
		this.renderPass.clearAlpha = 0;
	}
	,update: function(ts,partial,frameTime,delta) {
		this.occlusionCamera.position.copy(this.camera.position);
		this.occlusionCamera.quaternion.copy(this.camera.quaternion);
	}
	,render: function(ts,frameTime) {
		wl_core_Graphics.instance.renderer.setClearColor(0);
		wl_core_Graphics.instance.renderer.setClearAlpha(0);
		this.occlusionComposer.render();
		this.camera.lookAt(this.lightCube.position);
		wl_core_Part.prototype.render.call(this,ts,frameTime);
	}
	,__class__: toroidPhysics_ToroidPhysics
});
var wl_core_Assets = $hx_exports["kvg"]["core"]["assets"] = function() {
};
wl_core_Assets.__name__ = ["wl","core","Assets"];
wl_core_Assets.register = function(id,type,data,compressed) {
	if(compressed) {
		throw new js__$Boot_HaxeError("Compression not implemented.");
	}
	if(type == "png" || type == "jpg") {
		var img = new Image();
		img.src = "data:image/" + (type == "jpg" ? "jpeg" : type) + ";base64," + data;
		var _this = wl_core_Assets._assets;
		if(__map_reserved[id] != null) {
			_this.setReserved(id,img);
		} else {
			_this.h[id] = img;
		}
	} else if(type == "mp3" || type == "ogg") {
		var _this1 = wl_core_Assets._assets;
		if(__map_reserved[id] != null) {
			_this1.setReserved(id,data);
		} else {
			_this1.h[id] = data;
		}
	} else if(type == "json") {
		var _this2 = wl_core_Assets._assets;
		var value = JSON.parse(data);
		if(__map_reserved[id] != null) {
			_this2.setReserved(id,value);
		} else {
			_this2.h[id] = value;
		}
	} else if(type == "object") {
		var _this3 = wl_core_Assets._assets;
		if(__map_reserved[id] != null) {
			_this3.setReserved(id,data);
		} else {
			_this3.h[id] = data;
		}
	}
};
wl_core_Assets.get = function(id) {
	var _this = wl_core_Assets._assets;
	if(!(__map_reserved[id] != null ? _this.existsReserved(id) : _this.h.hasOwnProperty(id))) {
		console.log("Asset " + id + " not found");
	}
	var _this1 = wl_core_Assets._assets;
	if(__map_reserved[id] != null) {
		return _this1.getReserved(id);
	} else {
		return _this1.h[id];
	}
};
wl_core_Assets.getTexture = function(id) {
	var img = wl_core_Assets.get(id);
	if(img == null) {
		throw new js__$Boot_HaxeError("Texture " + id + " not found.");
	}
	var tex = new THREE.Texture(img);
	tex.needsUpdate = true;
	return tex;
};
wl_core_Assets.prototype = {
	__class__: wl_core_Assets
};
var wl_core_Config = $hx_exports["wl"]["Config"] = function() {
	throw new js__$Boot_HaxeError("Config is static only.");
};
wl_core_Config.__name__ = ["wl","core","Config"];
wl_core_Config.prototype = {
	__class__: wl_core_Config
};
var wl_core_Demo = $hx_exports["Demo"] = function() {
	this.allowUpdate = false;
	this.previousUpdate = 0;
	this.partMap = new haxe_ds_StringMap();
	wl_core_Demo.instance = this;
};
wl_core_Demo.__name__ = ["wl","core","Demo"];
wl_core_Demo.prototype = {
	getPart: function(name) {
		var _this = this.partMap;
		if(__map_reserved[name] != null) {
			return _this.getReserved(name);
		} else {
			return _this.h[name];
		}
	}
	,init: function(container) {
		wl_util_Random.init(wl_core_Config.SEED);
		this.graphics = new wl_core_Graphics(container);
		wl_sounds_SoundWL.onSoundComplete.connect($bind(this,this.onSoundEnd));
		this.previousTS = wl_core_TimeSig.create(0);
		this.graphics.onRender.connect($bind(this,this.onRender));
		this.initializeParts();
		if(wl_core_Config.DEBUG) {
			this.initializeDebug();
		}
		createjs.Ticker.setPaused(true);
		this.initDemoComposer();
	}
	,initDemoComposer: function() {
		this.overlay = new THREE.Scene();
		var aspect = wl_core_Config.RESOLUTION[1] / wl_core_Config.RESOLUTION[0];
		this.overlayCamera = new THREE.OrthographicCamera(0,1,0,aspect,1,1000);
		this.demoComposer = new THREE.EffectComposer(this.graphics.renderer,this.graphics.getRenderTarget());
		this.texturePass = new THREE.TexturePass(null,1);
		this.demoComposer.addPass(this.texturePass);
		var copyPass = new THREE.ShaderPass(THREE.CopyShader);
		copyPass.renderToScreen = true;
		this.demoComposer.addPass(copyPass);
		this.overlayCamera.position.z = 10;
		this.overlayCamera.lookAt(new THREE.Vector3());
	}
	,onSoundEnd: function() {
		this.end();
	}
	,initializeDebug: function() {
		wl_debug_Debug.init(this);
		wl_debug_ManualControl.init();
	}
	,initializeParts: function() {
		this.parts = [];
		var _g = 0;
		var _g1 = wl_core_Config.TIMELINE;
		while(_g < _g1.length) {
			var tl = _g1[_g];
			++_g;
			var id;
			if(tl.partId == null) {
				var o = tl.part;
				id = Type.getClassName(o == null ? null : js_Boot.getClass(o));
			} else {
				id = tl.partId;
			}
			tl.part.name = id;
			var _this = this.partMap;
			var key = tl.partId;
			var value = tl.part;
			if(__map_reserved[key] != null) {
				_this.setReserved(key,value);
			} else {
				_this.h[key] = value;
			}
			this.parts.push(tl.part);
		}
		var _g2 = 0;
		var _g11 = this.parts;
		while(_g2 < _g11.length) {
			var part = _g11[_g2];
			++_g2;
			part.init();
		}
		var _g3 = 0;
		var _g12 = this.parts;
		while(_g3 < _g12.length) {
			var part1 = _g12[_g3];
			++_g3;
			part1.render(this.previousTS,0);
		}
		var _g4 = 0;
		var _g13 = this.parts;
		while(_g4 < _g13.length) ++_g4;
	}
	,start: function() {
		this.previousRts = this.parts[0];
		this.graphics.start();
		wl_sounds_SoundWL.start();
		this.allowUpdate = true;
		window.document.getElementById("demo").style.display = "block";
	}
	,end: function() {
		this.graphics.stop();
	}
	,onRender: function(time) {
		this.graphics.renderer.clear();
		createjs.Tween.tick(time,false);
		var rts = null;
		var _g = 0;
		var _g1 = this.parts;
		while(_g < _g1.length) {
			var p = _g1[_g];
			++_g;
			if(p.inTransition) {
				p.render(this.previousTS,time);
			} else if(p.running) {
				if(rts == null && p.renderToScreen) {
					rts = p;
				} else {
					p.render(this.previousTS,time);
				}
			}
		}
		if(rts == null) {
			rts = this.previousRts;
		}
		if(rts != null) {
			this.previousRts = rts;
			rts.render(this.previousTS,time);
		}
		this.texturePass.setTexture(rts.renderTo);
		this.demoComposer.render();
		this.graphics.renderer.autoClearColor = false;
		this.graphics.renderer.render(this.overlay,this.overlayCamera);
		this.graphics.renderer.autoClearColor = true;
		if(wl_core_Config.DEBUG) {
			wl_debug_Debug.onrender();
		}
		if(this.allowUpdate) {
			this.update();
		}
	}
	,update: function() {
		var ts = wl_sounds_SoundWL.getPosition();
		var ms = ts.toMilliseconds();
		var frameTime = ms - this.previousUpdate;
		var delta = frameTime / 16.666666666666668;
		this.previousUpdate = ms;
		var _g1 = 0;
		var _g = wl_core_Config.TIMELINE.length;
		while(_g1 < _g) {
			var tl = wl_core_Config.TIMELINE[_g1++];
			if(ts.isInside(tl.runOn,tl.runOff)) {
				var p = tl.part;
				p.timeline = tl;
				var inTransition = ts.isInside(tl.runOn,tl.rtsOn) || ts.isInside(tl.rtsOff,tl.runOff);
				p.setRenderToScreen(tl.renderToScreen && !inTransition);
				if(!p.running) {
					p.start(ts);
				}
				p.isActive = true;
			}
		}
		var _g2 = 0;
		var _g11 = this.parts;
		while(_g2 < _g11.length) {
			var p1 = _g11[_g2];
			++_g2;
			if(p1.isActive) {
				p1.update(ts,(ts.toMilliseconds() - p1.timeline.runOn.toMilliseconds()) / (p1.timeline.runOff.toMilliseconds() - p1.timeline.runOn.toMilliseconds()),wl_debug_Debug.paused ? 0 : frameTime,delta);
			} else if(p1.running) {
				p1.stop();
			}
			p1.isActive = false;
		}
		while(this.previousTS.isSmallerThan(ts)) {
			var _g3 = 0;
			var _g12 = this.parts;
			while(_g3 < _g12.length) {
				var p2 = _g12[_g3];
				++_g3;
				if(p2.running) {
					var key = p2.triggers.keys();
					while(key.hasNext()) {
						var key1 = key.next();
						var matches = key1.matchesPattern(this.previousTS,p2.timeline.runOn);
						if(matches && !key1.triggered) {
							var triggers = p2.triggers.h[key1.__id__];
							key1.triggered = true;
							var _g21 = 0;
							while(_g21 < triggers.length) {
								var toCall = triggers[_g21];
								++_g21;
								toCall(this.previousTS);
							}
						} else if(!matches) {
							key1.triggered = false;
						}
					}
				}
			}
			this.previousTS.addTicks(1);
		}
		if(wl_core_Config.DEBUG) {
			wl_debug_Debug.onupdate();
		}
	}
	,__class__: wl_core_Demo
};
var wl_core_Graphics = function(container) {
	this.last = 0;
	this.stopped = true;
	this.container = container;
	if(wl_core_Graphics.instance == null) {
		wl_core_Graphics.instance = this;
	} else {
		console.log("Creating multiple Graphics instances. Are you sure?");
	}
	this.initGraphics();
};
wl_core_Graphics.__name__ = ["wl","core","Graphics"];
wl_core_Graphics.prototype = {
	initGraphics: function() {
		this.onRender = new wl_core_Signal();
		this.interval = 1000 / wl_core_Config.FPS;
		var params = { };
		params.antialias = wl_core_Config.ANTIALIAS;
		this.renderer = new THREE.WebGLRenderer(params);
		this.renderer.setClearColor(wl_core_Config.CLEAR_COLOR);
		this.renderer.autoClear = false;
		this.renderer.shadowMap.enabled = wl_core_Config.ENABLE_SHADOWS;
		this.renderer.shadowMap.type = THREE.PCFSoftShadowMap;
		this.renderer.shadowMapCascade = true;
		this.renderer.setSize(wl_core_Config.RESOLUTION[0],wl_core_Config.RESOLUTION[1],true);
		this.canvas = this.renderer.domElement;
		this.canvas.id = "demoCanvas";
		this.depthMaterial = new THREE.MeshDepthMaterial();
	}
	,start: function() {
		this.last = 0;
		this.stopped = false;
		this.renderLoop(0);
	}
	,stop: function() {
		this.renderer.clear();
		this.stopped = true;
	}
	,renderLoop: function(time) {
		this.delta = time - this.last;
		if(wl_core_Config.FPS < 0 || this.delta >= this.interval) {
			this.last = time;
			this.onRender.emit(this.delta);
		}
		if(!this.stopped) {
			window.requestAnimationFrame($bind(this,this.renderLoop));
		}
	}
	,getRenderTarget: function(format) {
		var options = { };
		options.stencilBuffer = true;
		options.minFilter = THREE.LinearFilter;
		options.magFilter = THREE.LinearFilter;
		options.format = format == null ? THREE.RGBAFormat : format;
		return new THREE.WebGLRenderTarget(wl_core_Config.RESOLUTION[0],wl_core_Config.RESOLUTION[1],options);
	}
	,getRenderTargetCube: function() {
		return new THREE.WebGLRenderTargetCube(1024,1024,{ });
	}
	,__class__: wl_core_Graphics
};
var wl_core_TimeSig = $hx_exports["wl"]["TimeSig"] = function(bar,beat,tick,delay,pattern) {
	this.triggered = false;
	this.delay = 0;
	this.set_bar(bar == null ? 0 : bar);
	this.set_beat(beat == null ? 0 : beat);
	this.set_tick(tick == null ? 0 : tick);
	this.delay = delay == null ? 0 : delay;
	this.pattern = pattern == null ? wl_core_TimeSig.ABSOLUTE : pattern;
};
wl_core_TimeSig.__name__ = ["wl","core","TimeSig"];
wl_core_TimeSig.create = function(time) {
	return new wl_core_TimeSig().fromTime(time);
};
wl_core_TimeSig.milliseconds = function(bar,beat,tick,delay) {
	return (bar * wl_core_Config.BEATS_PER_BAR / wl_core_Config.BEATS_PER_MINUTE + beat / wl_core_Config.BEATS_PER_MINUTE + tick / wl_core_Config.TICKS_PER_BEAT / wl_core_Config.BEATS_PER_MINUTE) * 60 * 1000 + Math.floor(delay / 255 * (60000 / wl_core_Config.BEATS_PER_MINUTE / wl_core_Config.TICKS_PER_BEAT));
};
wl_core_TimeSig.prototype = {
	set_beat: function(value) {
		this.beat = value;
		return this.beat;
	}
	,set_bar: function(value) {
		this.bar = value;
		return this.bar;
	}
	,set_tick: function(value) {
		this.tick = value;
		return this.tick;
	}
	,adjust: function() {
	}
	,matchesPattern: function(time,begin) {
		if(this.pattern == wl_core_TimeSig.ABSOLUTE) {
			return this.equals(time);
		} else if(this.pattern == wl_core_TimeSig.RELATIVE) {
			if(time.bar == begin.bar + this.bar && time.beat == begin.beat + this.beat) {
				return time.tick == begin.tick + this.tick;
			} else {
				return false;
			}
		} else if(this.pattern == wl_core_TimeSig.PATTERN) {
			if((this.bar == -1 || time.bar % this.bar == 0) && (this.beat == -1 || time.beat % wl_core_Config.BEATS_PER_BAR == this.beat)) {
				if(this.tick != -1) {
					return time.tick % wl_core_Config.TICKS_PER_BEAT == this.tick;
				} else {
					return true;
				}
			} else {
				return false;
			}
		}
		return false;
	}
	,add: function(ts) {
		this.addBars(ts.bar);
		this.addBeats(ts.beat);
		this.addTicks(ts.tick);
	}
	,addBars: function(bars) {
		var _g = this;
		_g.set_bar(_g.bar + bars);
	}
	,addBeats: function(beats) {
		var _g = this;
		_g.set_beat(_g.beat + beats);
		var _g1 = this;
		_g1.set_bar(_g1.bar + Math.floor(this.beat / wl_core_Config.BEATS_PER_BAR));
		var _g2 = this;
		_g2.set_beat(_g2.beat % wl_core_Config.BEATS_PER_BAR);
	}
	,addTicks: function(ticks) {
		var _g = this;
		_g.set_tick(_g.tick + ticks);
		while(this.tick >= wl_core_Config.TICKS_PER_BEAT) {
			var _g1 = this;
			_g1.set_tick(_g1.tick - wl_core_Config.TICKS_PER_BEAT);
			var _g2 = this;
			_g2.set_beat(_g2.beat + 1);
		}
		while(this.beat >= wl_core_Config.BEATS_PER_BAR) {
			var _g3 = this;
			_g3.set_beat(_g3.beat - wl_core_Config.BEATS_PER_BAR);
			var _g4 = this;
			_g4.set_bar(_g4.bar + 1);
		}
	}
	,subtract: function(ts) {
		this.subtractBars(ts.bar);
		this.subtractBeats(ts.beat);
		this.subtractTicks(ts.tick);
	}
	,subtractBars: function(bars) {
		var _g = this;
		_g.set_bar(_g.bar - bars);
	}
	,subtractBeats: function(beats) {
		var _g = this;
		_g.set_beat(_g.beat - beats);
		while(this.beat < 0) {
			var _g1 = this;
			_g1.set_bar(_g1.bar - 1);
			var _g2 = this;
			_g2.set_beat(_g2.beat + wl_core_Config.BEATS_PER_BAR);
		}
	}
	,subtractTicks: function(ticks) {
		var _g = this;
		_g.set_tick(_g.tick - ticks);
		while(this.tick < 0) {
			var _g1 = this;
			_g1.set_tick(_g1.tick + wl_core_Config.TICKS_PER_BEAT);
			var _g2 = this;
			_g2.set_beat(_g2.beat - 1);
		}
		while(this.beat < 0) {
			var _g3 = this;
			_g3.set_bar(_g3.bar - 1);
			var _g4 = this;
			_g4.set_beat(_g4.beat + wl_core_Config.BEATS_PER_BAR);
		}
	}
	,fromTime: function(time) {
		var totalBeats = wl_core_Config.BEATS_PER_MINUTE * time;
		var comp = time < 0 ? Math.ceil : Math.floor;
		this.set_bar(comp(totalBeats / wl_core_Config.BEATS_PER_BAR));
		this.set_beat(comp(totalBeats % wl_core_Config.BEATS_PER_BAR));
		this.set_tick(comp((totalBeats - comp(totalBeats)) * wl_core_Config.TICKS_PER_BEAT));
		this.delay = 0;
		this.delay = Math.floor(255 * (time * 60 * 1000 - this.toMilliseconds()) / (60000 / wl_core_Config.BEATS_PER_MINUTE / wl_core_Config.TICKS_PER_BEAT) % 255);
		return this;
	}
	,isInside: function(begin,end) {
		if(this.isSmallerThan(end)) {
			return this.isLargerThan(begin);
		} else {
			return false;
		}
	}
	,isSmallerThan: function(other) {
		var ticks = this.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + this.beat * wl_core_Config.TICKS_PER_BEAT + this.tick;
		var tickso = other.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + other.beat * wl_core_Config.TICKS_PER_BEAT + other.tick;
		if(ticks >= tickso) {
			if(ticks == tickso) {
				return this.delay < other.delay;
			} else {
				return false;
			}
		} else {
			return true;
		}
	}
	,isLargerThan: function(other) {
		var ticks = this.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + this.beat * wl_core_Config.TICKS_PER_BEAT + this.tick;
		var tickso = other.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + other.beat * wl_core_Config.TICKS_PER_BEAT + other.tick;
		if(ticks <= tickso) {
			if(ticks == tickso) {
				return this.delay >= other.delay;
			} else {
				return false;
			}
		} else {
			return true;
		}
	}
	,toMilliseconds: function() {
		return (this.bar * wl_core_Config.BEATS_PER_BAR / wl_core_Config.BEATS_PER_MINUTE + this.beat / wl_core_Config.BEATS_PER_MINUTE + this.tick / wl_core_Config.TICKS_PER_BEAT / wl_core_Config.BEATS_PER_MINUTE) * 60 * 1000 + Math.floor(this.delay / 255 * (60000 / wl_core_Config.BEATS_PER_MINUTE / wl_core_Config.TICKS_PER_BEAT));
	}
	,equals: function(other) {
		return this.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + this.beat * wl_core_Config.TICKS_PER_BEAT + this.tick == other.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + other.beat * wl_core_Config.TICKS_PER_BEAT + other.tick;
	}
	,clone: function() {
		return new wl_core_TimeSig(this.bar,this.beat,this.tick,this.delay,this.pattern);
	}
	,toString: function(full) {
		return this.bar + ":" + this.beat + ":" + this.tick + (full ? " / " + this.delay + "\n[" + this.pattern + "]" : "");
	}
	,__class__: wl_core_TimeSig
};
var wl_debug_Debug = function() {
};
wl_debug_Debug.__name__ = ["wl","debug","Debug"];
wl_debug_Debug.init = function(demo) {
	wl_debug_Debug.gui = new dat.gui.GUI();
	window.document.addEventListener("keydown",wl_debug_Debug.onKeyDown);
	wl_debug_Debug.debugDiv = $(".debug");
	wl_debug_Debug.debugTimeSig = wl_debug_Debug.debugDiv.find("#debug_timesig");
	var tldiv = wl_debug_Debug.debugDiv.find("#timeline_parts");
	var _g = 0;
	var _g1 = wl_core_Config.TIMELINE;
	while(_g < _g1.length) {
		var tl = _g1[_g];
		++_g;
		var tlel = $("<li>" + Std.string(tl) + "</li>");
		tldiv.append(tlel);
		tlel.click(wl_debug_Debug.tlClick(tl));
		wl_debug_Debug.datGuiPart(tl.part);
	}
	wl_debug_Debug.stats = new Stats();
	wl_debug_Debug.stats.showPanel(1);
	wl_debug_Debug.stats.dom.style.position = "absolute";
	wl_debug_Debug.stats.dom.style.bottom = "0px";
	wl_debug_Debug.stats.dom.style.top = null;
	wl_debug_Debug.debugDiv.eq(0).append(wl_debug_Debug.stats.dom);
	wl_debug_Debug.stats.begin();
};
wl_debug_Debug.datGuiPart = function(part) {
	var name = part.name;
	while(wl_debug_Debug.usedFolderNames.indexOf(name) >= 0) name += ">";
	var folder = wl_debug_Debug.gui.addFolder(name);
	wl_debug_Debug.usedFolderNames.push(name);
	var composer = Reflect.field(part,"composer");
	if(composer != null) {
		var _g = 0;
		var _g1 = composer.passes;
		while(_g < _g1.length) {
			var pass = _g1[_g];
			++_g;
			if(pass.setupDatGui != null) {
				pass.setupDatGui(folder);
			}
		}
	}
	var occlusioncomposer = Reflect.field(part,"occlusionComposer");
	if(occlusioncomposer != null) {
		var _g2 = 0;
		var _g11 = occlusioncomposer.passes;
		while(_g2 < _g11.length) {
			var pass1 = _g11[_g2];
			++_g2;
			if(pass1.setupDatGui != null) {
				pass1.setupDatGui(folder);
			}
		}
	}
	part.setupDatGui(folder);
};
wl_debug_Debug.tlClick = function(tl) {
	return function() {
		var curtime = wl_sounds_SoundWL.instance.getPosition();
		var tlpos = tl.rtsOn.toMilliseconds();
		wl_sounds_SoundWL.instance.setPosition(tlpos);
		createjs.Tween.tick(Math.floor(tlpos - curtime),false);
		wl_core_Demo.instance.previousTS.fromTime(wl_sounds_SoundWL.instance.getPosition() / 1000 / 60 - wl_core_Config.MUSIC_BEGIN / 1000 / 60);
	};
};
wl_debug_Debug.onupdate = function() {
	var ts = wl_sounds_SoundWL.getPosition();
	wl_debug_Debug.debugTimeSig.html(StringTools.replace(ts.toString(),"\n","<br/>") + "<br/>" + Math.round(ts.toMilliseconds() / 100) / 10 + "s");
};
wl_debug_Debug.onrender = function() {
	wl_debug_Debug.stats.update();
	wl_debug_ManualControl.update();
};
wl_debug_Debug.onKeyDown = function(e) {
	if(e.keyCode == 90) {
		console.log("Time captured: " + Std.string(wl_core_Demo.instance.previousTS));
	}
	if(e.keyCode == 109 || e.keyCode == 188) {
		if(wl_sounds_SoundWL.instance != null) {
			wl_sounds_SoundWL.instance.setPosition(wl_sounds_SoundWL.instance.getPosition() - 5000);
			createjs.Tween.tick(-5000,false);
			wl_core_Demo.instance.previousTS.fromTime(wl_sounds_SoundWL.instance.getPosition() / 1000 / 60 - wl_core_Config.MUSIC_BEGIN / 1000 / 60);
		}
	}
	if(e.keyCode == 107 || e.keyCode == 190) {
		if(wl_sounds_SoundWL.instance != null) {
			wl_sounds_SoundWL.instance.setPosition(wl_sounds_SoundWL.instance.getPosition() + 5000);
			createjs.Tween.tick(5000,false);
			wl_core_Demo.instance.previousTS.fromTime(wl_sounds_SoundWL.instance.getPosition() / 1000 / 60 - wl_core_Config.MUSIC_BEGIN / 1000 / 60);
		}
	}
	if(e.keyCode == 32) {
		wl_debug_Debug.paused = !wl_debug_Debug.paused;
		wl_sounds_SoundWL.instance.paused = wl_debug_Debug.paused;
		createjs.Tween.removeAllTweens();
	}
};
wl_debug_Debug.prototype = {
	__class__: wl_debug_Debug
};
var wl_debug_ManualControl = function() {
	throw new js__$Boot_HaxeError("Manual control is static");
};
wl_debug_ManualControl.__name__ = ["wl","debug","ManualControl"];
wl_debug_ManualControl.init = function() {
	if(wl_debug_ManualControl.inited) {
		return;
	}
	wl_debug_ManualControl.inited = true;
	window.document.addEventListener("keydown",wl_debug_ManualControl.onKeyDown);
	window.document.getElementById("demo").addEventListener("mousedown",wl_debug_ManualControl.onMouseDown);
};
wl_debug_ManualControl.onMouseDown = function(event) {
	console.log("mouse down");
	window.document.getElementById("demo").childNodes[0].requestPointerLock();
	window.document.addEventListener("mouseup",wl_debug_ManualControl.onMouseUp);
	window.document.getElementById("demo").addEventListener("mouseup",wl_debug_ManualControl.onMouseUp);
	event.preventDefault();
	event.stopPropagation();
	var _g1 = 0;
	var _g = wl_debug_ManualControl.parts.length;
	while(_g1 < _g) {
		var i = _g1++;
		var p = wl_debug_ManualControl.parts[i];
		var control = wl_debug_ManualControl.fpsControls[i];
		var lookingTo = new THREE.Vector3(0,0,-1);
		lookingTo = p.camera.getWorldDirection();
		control.enabled = p.running;
		var lon = (270 + Math.atan2(lookingTo.x,lookingTo.z) * 180 / Math.PI) % 360 - 180;
		control.lat = 90 - Math.acos(lookingTo.y / 1) * 180 / Math.PI;
		control.lon = lon;
	}
};
wl_debug_ManualControl.onMouseUp = function(event) {
	console.log("Mouse up");
	window.document.exitPointerLock();
	var _g1 = 0;
	var _g = wl_debug_ManualControl.fpsControls.length;
	while(_g1 < _g) {
		var control = wl_debug_ManualControl.fpsControls[_g1++];
		control.enabled = false;
		control.movementSpeed = 1;
	}
	window.document.removeEventListener("mouseup",wl_debug_ManualControl.onMouseUp);
	window.document.getElementById("demo").removeEventListener("mouseup",wl_debug_ManualControl.onMouseUp);
};
wl_debug_ManualControl.onKeyDown = function(event) {
	wl_debug_ManualControl.ctrlDown = event.shiftKey;
	var _g1 = 0;
	var _g = wl_debug_ManualControl.parts.length;
	while(_g1 < _g) {
		var i = _g1++;
		var p = wl_debug_ManualControl.parts[i];
		if(!p.running) {
			continue;
		}
		var control = wl_debug_ManualControl.fpsControls[i];
		var camera = p.camera;
		var camdir = new THREE.Vector3(0,0,-100);
		camdir.applyQuaternion(camera.quaternion);
		control.movementSpeed = event.shiftKey ? 0.1 : 1;
		if(event.keyCode == 80) {
			wl_demo_CameraController.stopAllControl();
			console.log("--- " + camera.name + " ---");
			console.log("Pos: x: " + camera.position.x + " y: " + camera.position.y + " z: " + camera.position.z);
			console.log("Dir: " + camdir.x + ", " + camdir.y + ", " + camdir.z);
			console.log("Look at: ");
			var la = camera.position.clone().add(camdir);
			console.log(la.x + ", " + la.y + ", " + la.z);
			console.log("Camera rotations: x " + camera.rotation.x + " y " + camera.rotation.y + " z " + camera.rotation.z + " Array ( " + camera.rotation.x + "," + camera.rotation.y + "," + camera.rotation.z + " )");
		}
		if(event.keyCode == 81) {
			console.log("point stored");
			if(wl_debug_ManualControl.storedPoints[p.name] == null) {
				wl_debug_ManualControl.storedPoints[p.name] = { pos : [], rot : [], look : []};
			}
			var la1 = camera.position.clone().add(camdir);
			wl_debug_ManualControl.storedPoints[p.name].pos.push("new Vector3(" + Math.round(camera.position.x * 100) / 100 + "," + Math.round(camera.position.y * 100) / 100 + "," + Math.round(camera.position.z * 100) / 100 + ")");
			wl_debug_ManualControl.storedPoints[p.name].rot.push("new Vector3(" + Math.round(camera.rotation.x * 100) / 100 + "," + Math.round(camera.rotation.y * 100) / 100 + "," + Math.round(camera.rotation.z * 100) / 100 + ")\n");
			wl_debug_ManualControl.storedPoints[p.name].look.push("new Vector3(" + Math.round(la1.x * 100) / 100 + "," + Math.round(la1.y * 100) / 100 + "," + Math.round(la1.z * 100) / 100 + ")");
		}
		if(event.keyCode == 85) {
			console.log("------------------------");
			var _g2 = 0;
			var _g3 = Reflect.fields(wl_debug_ManualControl.storedPoints);
			while(_g2 < _g3.length) {
				var point = _g3[_g2];
				++_g2;
				console.log("--- " + point + " ---");
				console.log("[\r\n" + wl_debug_ManualControl.storedPoints[point].pos.join(",\r\n") + "],[\r\n" + wl_debug_ManualControl.storedPoints[point].look.join(",\r\n") + "]");
			}
			wl_debug_ManualControl.storedPoints = { };
		}
	}
};
wl_debug_ManualControl.update = function() {
	var _g = 0;
	var _g1 = wl_debug_ManualControl.fpsControls;
	while(_g < _g1.length) {
		var c = _g1[_g];
		++_g;
		if(c.enabled) {
			c.update(1);
		}
	}
};
wl_debug_ManualControl.attachPart = function(part) {
	if(!wl_core_Config.DEBUG) {
		return;
	}
	wl_debug_ManualControl.parts.push(part);
	var control = new THREE.FirstPersonControls(part.camera);
	control.enabled = false;
	wl_debug_ManualControl.fpsControls.push(control);
};
wl_debug_ManualControl.prototype = {
	__class__: wl_debug_ManualControl
};
var wl_demo_CameraController = function(camera) {
	this.ignoreStop = false;
	this.updateLook = true;
	this.updatePath = true;
	if(camera != null) {
		this.attachCamera(camera);
	}
};
wl_demo_CameraController.__name__ = ["wl","demo","CameraController"];
wl_demo_CameraController.stopAllControl = function() {
	wl_demo_CameraController.STOPPED = true;
};
wl_demo_CameraController.prototype = {
	attachCamera: function(camera) {
		this.camera = camera;
	}
	,set_mode: function(mode) {
		this.mode = mode;
		return mode;
	}
	,initStatic: function(position,lookAt) {
		this.position = position;
		this.lookAt = lookAt;
		this.set_mode(wl_demo_CameraController.STATIC);
	}
	,initFollow: function(target,followOffset,followLookOffset) {
		this.set_mode(wl_demo_CameraController.FOLLOW);
		this.follow = target;
		this.followOffset = followOffset == null ? new THREE.Vector3(0,0,0) : followOffset;
		this.followLookOffset = followLookOffset == null ? new THREE.Vector3(0,0,0) : followLookOffset;
	}
	,initLinear: function(points,lookAts) {
		this.set_mode(wl_demo_CameraController.LINEAR);
		this.points = points;
		this.lookAts = lookAts;
	}
	,initBezier: function(points,lookAts) {
		this.set_mode(wl_demo_CameraController.BEZIER);
		this.points = points;
		this.lookAts = lookAts;
		this.path = new THREE.SplineCurve3(points);
		this.lookPath = new THREE.SplineCurve3(lookAts);
	}
	,showbezierPaths: function(scene) {
		var _g = 0;
		var _g1 = this.points;
		while(_g < _g1.length) {
			var p = _g1[_g];
			++_g;
			var b = new THREE.Mesh(new THREE.BoxGeometry(2,2,2),new THREE.MeshBasicMaterial({ color : 16711680}));
			b.position.set(p.x,p.y,p.z);
			scene.add(b);
		}
		var _g2 = 0;
		var _g11 = this.lookAts;
		while(_g2 < _g11.length) {
			var p1 = _g11[_g2];
			++_g2;
			var b1 = new THREE.Mesh(new THREE.BoxGeometry(2,2,2),new THREE.MeshBasicMaterial({ color : 255}));
			b1.position.set(p1.x,p1.y,p1.z);
			scene.add(b1);
		}
		var geometry = new THREE.Geometry();
		var linematerial = new THREE.LineBasicMaterial({ color : 16711680, linewidth : 4});
		var lookAtGeometry = new THREE.Geometry();
		var lookAtLineMaterial = new THREE.LineBasicMaterial({ color : 255});
		var _g12 = 0;
		while(_g12 < 1200) {
			var k = _g12++;
			var p3 = this.path.getPointAt(k / 1200);
			geometry.vertices.push(p3.clone());
			lookAtGeometry.vertices.push(this.lookPath.getPointAt(k / 1200));
		}
		scene.add(new THREE.Line(geometry,linematerial));
		scene.add(new THREE.Line(lookAtGeometry,lookAtLineMaterial));
	}
	,update: function(phase) {
		if(wl_demo_CameraController.STOPPED && !this.ignoreStop) {
			return;
		}
		if(this.mode == wl_demo_CameraController.STATIC) {
			if(this.updatePath) {
				this.camera.position.x = this.position.x;
				this.camera.position.y = this.position.y;
				this.camera.position.z = this.position.z;
			}
			if(this.updateLook) {
				this.camera.lookAt(this.lookAt);
			}
		} else if(this.mode == wl_demo_CameraController.LINEAR) {
			if(this.updatePath) {
				var a = this.points[0];
				var b = this.points[1];
				var c = new THREE.Vector3();
				c.lerpVectors(a,b,phase);
				this.camera.position.x = c.x;
				this.camera.position.y = c.y;
				this.camera.position.z = c.z;
			}
			if(this.updateLook) {
				var a1 = this.lookAts[0];
				var b1 = this.lookAts[1];
				var c1 = new THREE.Vector3();
				c1.lerpVectors(a1,b1,phase);
				this.camera.lookAt(c1);
			}
		} else if(this.mode == wl_demo_CameraController.FOLLOW) {
			if(this.updatePath) {
				this.camera.position.x = this.follow.position.x + this.followOffset.x;
				this.camera.position.y = this.follow.position.y + this.followOffset.y;
				this.camera.position.z = this.follow.position.z + this.followOffset.z;
			}
			if(this.updateLook) {
				this.camera.lookAt(this.follow.position.add(this.followLookOffset));
			}
		} else if(this.mode == wl_demo_CameraController.BEZIER) {
			if(phase < 0) {
				phase = 0;
			} else if(phase > 1) {
				phase = 1;
			}
			if(this.updatePath) {
				var p = this.path.getPointAt(phase);
				this.camera.position.x = p.x;
				this.camera.position.y = p.y;
				this.camera.position.z = p.z;
			}
			if(this.updateLook) {
				var p1 = this.lookPath.getPointAt(phase);
				this.camera.lookAt(p1);
				this.lookAt = p1;
			}
			this.position = this.camera.position;
		}
	}
	,__class__: wl_demo_CameraController
};
var wl_demo_DustParticles = function(params) {
	THREE.Object3D.call(this);
	this.particles = new THREE.Object3D();
	this.p = params;
	this.particleMaterial = new THREE.SpriteMaterial({ map : new THREE.CanvasTexture(this.generateSprite()), blending : THREE.AdditiveBlending, transparent : true});
	var _g1 = 0;
	var _g = this.p.amount;
	while(_g1 < _g) {
		++_g1;
		var particle = new THREE.Sprite(this.particleMaterial);
		particle.position.set(wl_util_Random.range(this.p.minx,this.p.maxx),wl_util_Random.range(this.p.miny,this.p.maxy),wl_util_Random.range(-this.p.minz,this.p.maxz));
		this.particles.add(particle);
	}
	this.add(this.particles);
};
wl_demo_DustParticles.__name__ = ["wl","demo","DustParticles"];
wl_demo_DustParticles.__super__ = THREE.Object3D;
wl_demo_DustParticles.prototype = $extend(THREE.Object3D.prototype,{
	generateSprite: function() {
		var canvas = window.document.createElement("canvas");
		canvas.width = this.p.particleSize.x;
		canvas.height = this.p.particleSize.y;
		var context = canvas.getContext("2d");
		var gradient = context.createRadialGradient(canvas.width / 2,canvas.height / 2,0,canvas.width / 2,canvas.height / 2,canvas.width / 2);
		gradient.addColorStop(0,"rgba(255,255,255,1)");
		gradient.addColorStop(0.2,"rgba(0,255,255,1)");
		gradient.addColorStop(0.4,"rgba(0,0,64,1)");
		gradient.addColorStop(1,"rgba(0,0,0,1)");
		context.fillStyle = gradient;
		context.fillRect(0,0,canvas.width,canvas.height);
		return canvas;
	}
	,__class__: wl_demo_DustParticles
});
var wl_demo_DustParameters = function() {
};
wl_demo_DustParameters.__name__ = ["wl","demo","DustParameters"];
wl_demo_DustParameters.prototype = {
	__class__: wl_demo_DustParameters
};
var wl_demo_RandomCameraController = function(camera,cameraAmount,follow,seed,allowTypes,distanceRange,bounds) {
	this.distanceRange = [];
	this.cameraSwap = 0;
	this.current = 0;
	if(allowTypes.length == 0) {
		throw new js__$Boot_HaxeError("Random camera requires at least 1 type");
	}
	this.md = distanceRange[0];
	this.bounds = bounds;
	this.rnd = distanceRange[1] - distanceRange[0];
	this.distanceRange = distanceRange;
	this.random = new wl_util_Random(seed);
	this.follow = follow;
	this.camera = camera;
	this.ccs = [];
	var _g1 = 0;
	while(_g1 < cameraAmount) {
		++_g1;
		var cc = new wl_demo_CameraController(this.camera);
		var type = allowTypes[this.random.Next() % allowTypes.length];
		if(type == wl_demo_CameraController.FOLLOW) {
			this.initFollow(cc);
		} else if(type == wl_demo_CameraController.LINEAR) {
			this.initLinear(cc);
		} else if(type == wl_demo_CameraController.STATIC) {
			this.initStatic(cc);
		} else if(type == wl_demo_CameraController.BEZIER) {
			this.initBezier(cc);
		}
		this.ccs.push(cc);
	}
};
wl_demo_RandomCameraController.__name__ = ["wl","demo","RandomCameraController"];
wl_demo_RandomCameraController.prototype = {
	start: function() {
		this.cameraSwap = new Date().getTime();
	}
	,swap: function() {
		this.cameraSwap = new Date().getTime();
		this.current = (this.current + 1) % this.ccs.length;
	}
	,updatePartial: function(val) {
		this.ccs[this.current].update(val);
	}
	,updateLength: function(time) {
		var partial = (new Date().getTime() - this.cameraSwap) / time;
		this.ccs[this.current].update(partial);
	}
	,getRndPoint: function() {
		var v = this.bounds.min.clone();
		v = v.addScaledVector(this.bounds.max.clone().sub(this.bounds.min),this.random.NextFloat());
		return v;
	}
	,initFollow: function(cc) {
		var obj = this.follow.length > 0 ? this.follow[this.random.Next() % this.follow.length] : new THREE.Object3D();
		var dir = new THREE.Vector3(this.random.NextFloat() - 0.5,this.random.NextFloat() - 0.5,this.random.NextFloat() - 0.5);
		dir.normalize();
		dir.multiplyScalar(this.random.NextFloat() * this.rnd + this.md);
		cc.initFollow(obj,dir,new THREE.Vector3(this.random.NextFloat() * this.md / 10,this.random.NextFloat() * this.md / 10,this.random.NextFloat() * this.md / 10));
	}
	,initStatic: function(cc) {
		var obj = this.follow.length > 0 ? this.follow[this.random.Next() % this.follow.length] : new THREE.Object3D();
		cc.initStatic(this.getRndPoint(),obj.position);
	}
	,initLinear: function(cc) {
		var obj = this.follow.length > 0 ? this.follow[this.random.Next() % this.follow.length] : new THREE.Object3D();
		cc.initLinear([this.getRndPoint(),this.getRndPoint()],[obj.position.clone(),obj.position.clone().add(new THREE.Vector3(this.random.NextFloat() * 20 - 10,this.random.NextFloat() * 20 - 10,this.random.NextFloat() * 20 - 10))]);
	}
	,initBezier: function(cc) {
		var obj = this.follow.length > 0 ? this.follow[this.random.Next() % this.follow.length] : new THREE.Object3D();
		var start = this.getRndPoint();
		var end = this.getRndPoint();
		var pos = [start];
		var looks = [obj.position.clone(),obj.position.clone()];
		var dx = end.x - start.x;
		var dy = end.y - start.y;
		var dz = end.z - start.z;
		var _g = 1;
		while(_g < 6) {
			var i = _g++;
			looks.push(obj.position.clone());
			pos.push(new THREE.Vector3(this.random.NextFloat() * dx / 10 - dx / 20 + i / 6 * dx + start.x,this.random.NextFloat() * dy / 10 - dy / 20 + i / 6 * dy + start.y,this.random.NextFloat() * dz / 10 - dz / 20 + i / 6 * dz + start.z));
		}
		pos.push(end);
		cc.initBezier(pos,looks);
	}
	,__class__: wl_demo_RandomCameraController
};
var wl_demo_TimeLine = function(instance,runOn,runOff,partId,renderToScreen,rtsOn,rtsOff,forceNewPart,extra) {
	this.part = instance;
	this.partId = partId;
	this.runOn = runOn;
	this.runOff = runOff;
	this.rtsOn = rtsOn == null ? runOn.clone() : rtsOn;
	this.rtsOff = rtsOff == null ? runOff.clone() : rtsOff;
	this.renderToScreen = renderToScreen == null ? true : renderToScreen;
	this.forceNewPart = forceNewPart == null ? false : forceNewPart;
	this.extra = extra;
};
wl_demo_TimeLine.__name__ = ["wl","demo","TimeLine"];
wl_demo_TimeLine.prototype = {
	toString: function() {
		return this.part.name + ":" + this.rtsOn.toString() + " - " + this.rtsOff.toString();
	}
	,__class__: wl_demo_TimeLine
};
var wl_post_bloom_Bloom = function(resolution,strength,radius,threshold) {
	if(threshold == null) {
		threshold = 0;
	}
	if(radius == null) {
		radius = 0;
	}
	if(strength == null) {
		strength = 0.5;
	}
	this.nMips = 5;
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.uniforms = { };
	if(resolution == null) {
		resolution = new THREE.Vector2(2048,2048);
	}
	this.resolution = resolution;
	this.strength = strength;
	this.radius = radius;
	this.threshold = threshold;
	this.enabled = true;
	var pars = { minFilter : THREE.LinearFilter, magFilter : THREE.LinearFilter, format : THREE.RGBAFormat};
	this.renderTargetsHorizontal = [];
	this.renderTargetsVertical = [];
	this.nMips = 5;
	var resx = Math.round(this.resolution.x / 2);
	var resy = Math.round(this.resolution.y / 2);
	this.renderTargetBright = new THREE.WebGLRenderTarget(resx,resy,pars);
	this.renderTargetBright.texture.generateMipmaps = false;
	var _g1 = 0;
	var _g = this.nMips;
	while(_g1 < _g) {
		var i = _g1++;
		var renderTarget = new THREE.WebGLRenderTarget(resx,resy,pars);
		renderTarget.texture.generateMipmaps = false;
		this.renderTargetsHorizontal.push(renderTarget);
		var renderTarget1 = new THREE.WebGLRenderTarget(resx,resy,pars);
		renderTarget1.texture.generateMipmaps = false;
		this.renderTargetsVertical.push(renderTarget1);
		resx = Math.round(resx / 2);
		resy = Math.round(resy / 2);
	}
	if(THREE.LuminosityHighPassShader == null) {
		console.log("THREE.UnrealBloomPass relies on THREE.LuminosityHighPassShader");
	}
	var highPassShader = THREE.LuminosityHighPassShader;
	this.highPassUniforms = THREE.UniformsUtils.clone(highPassShader.uniforms);
	this.highPassUniforms.luminosityThreshold.value = threshold;
	this.highPassUniforms.smoothWidth.value = 0.01;
	this.materialHighPassFilter = new THREE.ShaderMaterial({ uniforms : this.highPassUniforms, vertexShader : highPassShader.vertexShader, fragmentShader : highPassShader.fragmentShader, defines : { }});
	this.separableBlurMaterials = [];
	var kernelSizeArray = [3,5,7,9,11];
	var resx1 = Math.round(this.resolution.x / 2);
	var resy1 = Math.round(this.resolution.y / 2);
	var _g11 = 0;
	var _g2 = this.nMips;
	while(_g11 < _g2) {
		var i1 = _g11++;
		this.separableBlurMaterials.push(this.getSeperableBlurMaterial(kernelSizeArray[i1]));
		this.separableBlurMaterials[i1].uniforms.texSize.value = new THREE.Vector2(resx1,resy1);
		resx1 = Math.round(resx1 / 2);
		resy1 = Math.round(resy1 / 2);
	}
	this.compositeMaterial = this.getCompositeMaterial(this.nMips);
	this.compositeMaterial.uniforms.blurTexture1.value = this.renderTargetsVertical[0].texture;
	this.compositeMaterial.uniforms.blurTexture2.value = this.renderTargetsVertical[1].texture;
	this.compositeMaterial.uniforms.blurTexture3.value = this.renderTargetsVertical[2].texture;
	this.compositeMaterial.uniforms.blurTexture4.value = this.renderTargetsVertical[3].texture;
	this.compositeMaterial.uniforms.blurTexture5.value = this.renderTargetsVertical[4].texture;
	this.compositeMaterial.uniforms.bloomStrength.value = strength;
	this.compositeMaterial.uniforms.bloomRadius.value = 0.1;
	this.compositeMaterial.needsUpdate = true;
	var bloomFactors = [1.0,0.8,0.6,0.4,0.2];
	this.compositeMaterial.uniforms.bloomFactors.value = bloomFactors;
	this.bloomTintColors = [new THREE.Vector3(1,1,1),new THREE.Vector3(1,1,1),new THREE.Vector3(1,1,1),new THREE.Vector3(1,1,1),new THREE.Vector3(1,1,1)];
	this.compositeMaterial.uniforms.bloomTintColors.value = this.bloomTintColors;
	if(THREE.CopyShader == null) {
		console.log("THREE.BloomPass relies on THREE.CopyShader");
	}
	var copyShader = THREE.CopyShader;
	this.copyUniforms = THREE.UniformsUtils.clone(copyShader.uniforms);
	this.copyUniforms.opacity.value = 1.0;
	this.materialCopy = new THREE.ShaderMaterial({ uniforms : this.copyUniforms, vertexShader : copyShader.vertexShader, fragmentShader : copyShader.fragmentShader, blending : THREE.AdditiveBlending, depthTest : false, depthWrite : false, transparent : true});
	this.enabled = true;
	this.needsSwap = false;
	this.oldClearColor = new THREE.Color();
	this.oldClearAlpha = 1;
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.scene = new THREE.Scene();
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene.add(this.quad);
};
wl_post_bloom_Bloom.__name__ = ["wl","post","bloom","Bloom"];
wl_post_bloom_Bloom.prototype = {
	setupDatGui: function(folder) {
		var f = folder.addFolder("Bloom");
		f.add(this,"strength").step(0.01);
		f.add(this,"radius").step(0.01);
		f.add(this,"threshold").step(0.01);
	}
	,setSize: function(width,height) {
		var resx = Math.round(width / 2);
		var resy = Math.round(height / 2);
		this.renderTargetBright.setSize(resx,resy);
		var _g1 = 0;
		var _g = this.nMips;
		while(_g1 < _g) {
			var i = _g1++;
			this.renderTargetsHorizontal[i].setSize(resx,resy);
			this.renderTargetsVertical[i].setSize(resx,resy);
			this.separableBlurMaterials[i].uniforms.texSize.value = new THREE.Vector2(resx,resy);
			resx = Math.round(resx / 2);
			resy = Math.round(resy / 2);
		}
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		this.oldClearColor.copy(renderer.getClearColor());
		this.oldClearAlpha = renderer.getClearAlpha();
		var oldAutoClear = renderer.autoClear;
		renderer.autoClear = false;
		renderer.setClearColor(new THREE.Color(0,0,0),0);
		this.highPassUniforms.tDiffuse.value = readBuffer.texture;
		this.highPassUniforms.luminosityThreshold.value = this.threshold;
		this.quad.material = this.materialHighPassFilter;
		renderer.render(this.scene,this.camera,this.renderTargetBright,true);
		var inputRenderTarget = this.renderTargetBright;
		var _g1 = 0;
		var _g = this.nMips;
		while(_g1 < _g) {
			var i = _g1++;
			this.quad.material = this.separableBlurMaterials[i];
			this.separableBlurMaterials[i].uniforms.colorTexture.value = inputRenderTarget.texture;
			this.separableBlurMaterials[i].uniforms.direction.value = wl_post_bloom_Bloom.BlurDirectionX;
			renderer.render(this.scene,this.camera,this.renderTargetsHorizontal[i],true);
			this.separableBlurMaterials[i].uniforms.colorTexture.value = this.renderTargetsHorizontal[i].texture;
			this.separableBlurMaterials[i].uniforms.direction.value = wl_post_bloom_Bloom.BlurDirectionY;
			renderer.render(this.scene,this.camera,this.renderTargetsVertical[i],true);
			inputRenderTarget = this.renderTargetsVertical[i];
		}
		this.quad.material = this.compositeMaterial;
		this.compositeMaterial.uniforms.bloomStrength.value = this.strength;
		this.compositeMaterial.uniforms.bloomRadius.value = this.radius;
		this.compositeMaterial.uniforms.bloomTintColors.value = this.bloomTintColors;
		renderer.render(this.scene,this.camera,this.renderTargetsHorizontal[0],true);
		this.quad.material = this.materialCopy;
		this.copyUniforms.tDiffuse.value = this.renderTargetsHorizontal[0].texture;
		renderer.render(this.scene,this.camera,readBuffer,false);
		renderer.setClearColor(this.oldClearColor,this.oldClearAlpha);
		renderer.autoClear = oldAutoClear;
	}
	,getSeperableBlurMaterial: function(kernelRadius) {
		var tmp = { value : new THREE.Vector2(0.5,0.5)};
		var tmp1 = { "colorTexture" : { value : null}, texSize : tmp, "direction" : { value : new THREE.Vector2(0.5,0.5)}};
		var tmp2 = ["varying vec2 vUv;","void main() {","\tvUv = uv;","\tgl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );","}"].join("\n");
		var tmp3 = ["#include <common>","varying vec2 vUv;","uniform sampler2D colorTexture;","uniform vec2 texSize;","uniform vec2 direction;","float gaussianPdf(in float x, in float sigma) {","\treturn 0.39894 * exp( -0.5 * x * x/( sigma * sigma))/sigma;","}","void main() {","\tvec2 invSize = 1.0 / texSize;","\tfloat fSigma = float(SIGMA);","\tfloat weightSum = gaussianPdf(0.0, fSigma);","\tvec3 diffuseSum = texture2D( colorTexture, vUv).rgb * weightSum;","\tfor( int i = 1; i < KERNEL_RADIUS; i ++ ) {","\t\tfloat x = float(i);","\t\tfloat w = gaussianPdf(x, fSigma);","\t\tvec2 uvOffset = direction * invSize * x;","\t\tvec3 sample1 = texture2D( colorTexture, vUv + uvOffset).rgb;","\t\tvec3 sample2 = texture2D( colorTexture, vUv - uvOffset).rgb;","\t\tdiffuseSum += (sample1 + sample2) * w;","\t\tweightSum += 2.0 * w;","\t}","\tgl_FragColor = vec4(diffuseSum/weightSum, 1.0);","}"].join("\n");
		return new THREE.ShaderMaterial({ defines : { "KERNEL_RADIUS" : kernelRadius, "SIGMA" : kernelRadius}, uniforms : tmp1, vertexShader : tmp2, fragmentShader : tmp3});
	}
	,getCompositeMaterial: function(nMips) {
		var tmp = ["varying vec2 vUv;","void main() {","\tvUv = uv;","\tgl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );","}"].join("\n");
		var tmp1 = ["varying vec2 vUv;","uniform sampler2D blurTexture1;","uniform sampler2D blurTexture2;","uniform sampler2D blurTexture3;","uniform sampler2D blurTexture4;","uniform sampler2D blurTexture5;","uniform sampler2D dirtTexture;","uniform float bloomStrength;","uniform float bloomRadius;","uniform float bloomFactors[NUM_MIPS];","uniform vec3 bloomTintColors[NUM_MIPS];","float lerpBloomFactor(const in float factor) { ","\tfloat mirrorFactor = 1.2 - factor;","\treturn mix(factor, mirrorFactor, bloomRadius);","}","void main() {","\tgl_FragColor = bloomStrength * ( lerpBloomFactor(bloomFactors[0]) * vec4(bloomTintColors[0], 1.0) * texture2D(blurTexture1, vUv) + ","\t \t\t\t\t\t\t\t lerpBloomFactor(bloomFactors[1]) * vec4(bloomTintColors[1], 1.0) * texture2D(blurTexture2, vUv) + ","\t\t\t\t\t\t\t\t lerpBloomFactor(bloomFactors[2]) * vec4(bloomTintColors[2], 1.0) * texture2D(blurTexture3, vUv) + ","\t\t\t\t\t\t\t\t lerpBloomFactor(bloomFactors[3]) * vec4(bloomTintColors[3], 1.0) * texture2D(blurTexture4, vUv) + ","\t\t\t\t\t\t\t\t lerpBloomFactor(bloomFactors[4]) * vec4(bloomTintColors[4], 1.0) * texture2D(blurTexture5, vUv) );","}"].join("\n");
		return new THREE.ShaderMaterial({ defines : { "NUM_MIPS" : nMips}, uniforms : { "blurTexture1" : { value : null}, "blurTexture2" : { value : null}, "blurTexture3" : { value : null}, "blurTexture4" : { value : null}, "blurTexture5" : { value : null}, "dirtTexture" : { value : null}, "bloomStrength" : { value : 1.0}, "bloomFactors" : { value : null}, "bloomTintColors" : { value : null}, "bloomRadius" : { value : 0.0}}, vertexShader : tmp, fragmentShader : tmp1});
	}
	,__class__: wl_post_bloom_Bloom
};
var wl_post_colorhilight_ColorHilight = function() {
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.sweep = 0;
	this.targetVal = 40;
	this.testSweep = false;
	this.color2 = 16777215;
	this.color1 = 16777215;
	this.original = 0.01;
	this.amount = 0.01;
	this.value2 = 0.01;
	this.value1 = 0.01;
	this.range = 0.01;
	this.uniforms = { range : { type : "f", value : 0.03}, value1 : { type : "f", value : 0.2}, value2 : { type : "f", value : 0.5}, amount : { type : "f", value : 0.0}, original : { type : "f", value : 1}, color1 : { type : "v4", value : [1.0,1.0,1.0,1]}, color2 : { type : "v4", value : [1.0,1.0,1.0,1]}, tile : { type : "v2", value : [1.0,1.0]}, tDiffuse : { type : "t"}};
	this.enabled = true;
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, fragmentShader : haxe_Resource.getString("colorhilight.frag"), vertexShader : haxe_Resource.getString("colorhilight.vert")});
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
wl_post_colorhilight_ColorHilight.__name__ = ["wl","post","colorhilight","ColorHilight"];
wl_post_colorhilight_ColorHilight.prototype = {
	set_range: function(value) {
		this.range = value;
		this.uniforms.range.value = value;
		return value;
	}
	,set_value1: function(value) {
		this.value1 = value;
		this.uniforms.value1.value = value;
		return value;
	}
	,set_value2: function(value) {
		this.value2 = value;
		this.uniforms.value2.value = value;
		return value;
	}
	,set_amount: function(value) {
		this.amount = value;
		this.uniforms.amount.value = value;
		return value;
	}
	,set_original: function(value) {
		this.original = value;
		this.uniforms.original.value = value;
		return value;
	}
	,set_color1: function(value) {
		this.color1 = value;
		this.uniforms.color1.value = [(value >> 16 & 255) / 255,(value >> 8 & 255) / 255,(value & 255) / 255,1];
		return value;
	}
	,set_color2: function(value) {
		this.color2 = value;
		this.uniforms.color2.value = [(value >> 16 & 255) / 255,(value >> 8 & 255) / 255,(value & 255) / 255,1];
		return value;
	}
	,setupDatGui: function(folder) {
		var _gthis = this;
		var f = folder.addFolder("Color hilight");
		f.add(this,"range").step(0.0001).min(0).max(1).onChange(function(value) {
			_gthis.set_range(value);
		});
		f.add(this,"value1").step(0.0001).min(0).max(1).onChange(function(value1) {
			_gthis.set_value1(value1);
		});
		f.add(this,"value2").step(0.0001).min(0).max(1).onChange(function(value2) {
			_gthis.set_value2(value2);
		});
		f.add(this,"amount").step(0.0001).min(0).max(1).onChange(function(value3) {
			_gthis.set_amount(value3);
		});
		f.addColor(this,"color1").onChange(function(value4) {
			_gthis.set_color1(value4);
		});
		f.addColor(this,"color2").onChange(function(value5) {
			_gthis.set_color2(value5);
		});
		f.add(this,"original").min(0).max(1).onChange(function(value6) {
			_gthis.set_original(value6);
		});
		f.add(this,"testSweep");
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		if(this.testSweep) {
			this.set_value1(wl_core_Demo.instance.previousTS.toMilliseconds() / 1000 % 1);
			this.set_value2((0.5 + wl_core_Demo.instance.previousTS.toMilliseconds() / 1000) % 1);
		}
		this.uniforms.tDiffuse.value = readBuffer.texture;
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,doSweep: function(time) {
		this.sweep = 0;
		createjs.Tween.get(this,{ onChange : $bind(this,this.sweepUpdate)}).to({ sweep : 1},time,createjs.Ease.quadInOut);
	}
	,sweepUpdate: function() {
		this.uniforms.amount.value = this.targetVal;
		this.uniforms.value1.value = this.sweep;
		this.uniforms.value2.value = (this.sweep + 0.5) % 1;
		this.uniforms.original.value = 1;
	}
	,__class__: wl_post_colorhilight_ColorHilight
};
var wl_post_displacement_Displacement = function(dispmap) {
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.zoom = 0.01;
	this.scaleY = 0.01;
	this.scaleX = 0.01;
	this.uniforms = { scaleX : { type : "f", value : 0.03}, scaleY : { type : "f", value : 0.03}, zoom : { type : "f", value : 1}, tDiffuse : { type : "t"}, tDispMap : { type : "t"}, offset : { type : "f2", value : [0,0]}};
	dispmap.wrapS = THREE.RepeatWrapping;
	dispmap.wrapT = THREE.RepeatWrapping;
	this.enabled = true;
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, fragmentShader : haxe_Resource.getString("displacement.frag"), vertexShader : haxe_Resource.getString("displacement.vert")});
	this.uniforms.tDispMap.value = dispmap;
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
wl_post_displacement_Displacement.__name__ = ["wl","post","displacement","Displacement"];
wl_post_displacement_Displacement.prototype = {
	set_scaleX: function(value) {
		this.scaleX = value;
		this.uniforms.scaleX.value = value;
		return value;
	}
	,set_scaleY: function(value) {
		this.scaleY = value;
		this.uniforms.scaleY.value = value;
		return value;
	}
	,set_zoom: function(value) {
		this.zoom = value;
		this.uniforms.zoom.value = value;
		return value;
	}
	,setupDatGui: function(folder) {
		var _gthis = this;
		var f = folder.addFolder("displacement (post)");
		f.add(this,"scaleX").step(0.0001).min(0).max(1).onChange(function(value) {
			_gthis.set_scaleX(value);
		});
		f.add(this,"scaleY").step(0.0001).min(0).max(1).onChange(function(value1) {
			_gthis.set_scaleY(value1);
		});
		f.add(this,"zoom").step(0.0001).min(0).max(100).onChange(function(value2) {
			_gthis.set_zoom(value2);
		});
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		this.uniforms.tDiffuse.value = readBuffer.texture;
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,__class__: wl_post_displacement_Displacement
};
var wl_post_distortedTv_DistortedTv = function() {
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.brightLimit = 1.00;
	this.brightMultiplier = 1.00;
	this.offsetAmount = 0.00;
	this.vignAmount = 1.00;
	this.blueamplify = 1.0;
	this.greenamplify = 1.0;
	this.distortAmount = 100;
	this.uniforms = { distortAmount : { type : "f", value : 100.1}, tDiffuse : { type : "t"}, greenamplify : { type : "f", value : 1}, blueamplify : { type : "f", value : 1}, vignAmount : { type : "f", value : 1.00}, time : { type : "f", value : 0.0}, offsetAmount : { type : "f", value : 0.0}, brightMultiplier : { type : "f", value : 1.0}, brightLimit : { type : "f", value : 1.0}};
	this.enabled = true;
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, fragmentShader : haxe_Resource.getString("distortedTv.frag"), vertexShader : haxe_Resource.getString("distortedTv.vert")});
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
wl_post_distortedTv_DistortedTv.__name__ = ["wl","post","distortedTv","DistortedTv"];
wl_post_distortedTv_DistortedTv.prototype = {
	set_distortAmount: function(value) {
		this.distortAmount = value;
		this.uniforms.distortAmount.value = value;
		return value;
	}
	,set_greenamplify: function(value) {
		this.greenamplify = value;
		this.uniforms.greenamplify.value = value;
		return value;
	}
	,set_blueamplify: function(value) {
		this.blueamplify = value;
		this.uniforms.blueamplify.value = value;
		return value;
	}
	,set_vignAmount: function(value) {
		this.vignAmount = value;
		this.uniforms.vignAmount.value = value;
		return value;
	}
	,set_offsetAmount: function(value) {
		this.offsetAmount = value;
		this.uniforms.offsetAmount.value = value;
		return value;
	}
	,set_brightMultiplier: function(value) {
		this.brightMultiplier = value;
		this.uniforms.brightMultiplier.value = value;
		return value;
	}
	,set_brightLimit: function(value) {
		this.brightLimit = value;
		this.uniforms.brightLimit.value = value;
		return value;
	}
	,setupDatGui: function(folder) {
		var _gthis = this;
		var f = folder.addFolder("Distorted tv");
		f.add(this,"distortAmount").step(0.01).onChange(function(value) {
			_gthis.set_distortAmount(value);
		});
		f.add(this,"greenamplify").step(0.01).onChange(function(value1) {
			_gthis.set_greenamplify(value1);
			console.log("green change " + value1);
		});
		f.add(this,"blueamplify").step(0.01).onChange(function(value2) {
			_gthis.set_blueamplify(value2);
		});
		f.add(this,"vignAmount").step(0.01).onChange(function(value3) {
			_gthis.set_vignAmount(value3);
		});
		f.add(this,"offsetAmount").step(0.01).onChange(function(value4) {
			_gthis.set_offsetAmount(value4);
		});
		f.add(this,"brightMultiplier").step(0.01).onChange(function(value5) {
			_gthis.set_brightMultiplier(value5);
		});
		f.add(this,"brightLimit").step(0.01).onChange(function(value6) {
			_gthis.set_brightLimit(value6);
		});
	}
	,setTime: function(t) {
		this.uniforms.time.value = t;
	}
	,setDistortion: function(t) {
		this.uniforms.distortAmount.value = t;
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		this.setTime(wl_core_Demo.instance.previousTS.toMilliseconds() / 1000);
		this.uniforms.tDiffuse.value = readBuffer.texture;
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,__class__: wl_post_distortedTv_DistortedTv
};
var wl_post_dof_DoF = function(depth,camera) {
	this.focusCoords = new THREE.Vector2(0.5,0.5);
	this.shaderFocus = true;
	this.pentagon = false;
	this.dithering = 0.00001;
	this.noise = false;
	this.fringe = 0;
	this.bias = 0;
	this.gain = 0;
	this.threshold = 0;
	this.depthblur = false;
	this.maxblur = 1;
	this.fstop = 1;
	this.focalLength = 90;
	this.focalDepth = 0;
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.uniforms = { "textureWidth" : { type : "f", value : 1.0}, "textureHeight" : { type : "f", value : 1.0}, "focalDepth" : { type : "f", value : 2.8}, "focalLength" : { type : "f", value : 35.0}, "fstop" : { type : "f", value : 2.2}, "tColor" : { type : "t", value : null}, "tDepth" : { type : "t", value : null}, "maxblur" : { type : "f", value : 1.0}, "depthblur" : { type : "b", value : 0}, "threshold" : { type : "f", value : 0.5}, "gain" : { type : "f", value : 2.0}, "bias" : { type : "f", value : 0.5}, "fringe" : { type : "f", value : 0.7}, "znear" : { type : "f", value : 0.1}, "zfar" : { type : "f", value : 100}, "noise" : { type : "b", value : 1}, "dithering" : { type : "f", value : 0.0001}, "pentagon" : { type : "b", value : 0}, "shaderFocus" : { type : "b", value : 1}, "focusCoords" : { type : "v2", value : new THREE.Vector2(0.5,0.5)}};
	this.sceneCamera = camera;
	var vert = haxe_Resource.getString("dof.vert");
	var frag = haxe_Resource.getString("dof.frag");
	this.uniforms.tDepth.value = depth;
	this.uniforms.textureWidth.value = wl_core_Config.RESOLUTION[0];
	this.uniforms.textureHeight.value = wl_core_Config.RESOLUTION[1];
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, vertexShader : vert, fragmentShader : frag});
	this.enabled = true;
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
wl_post_dof_DoF.__name__ = ["wl","post","dof","DoF"];
wl_post_dof_DoF.prototype = {
	set_focalDepth: function(value) {
		this.focalDepth = value;
		this.uniforms.focalDepth.value = value;
		return value;
	}
	,set_focalLength: function(value) {
		this.focalLength = value;
		this.uniforms.focalLength.value = value;
		return value;
	}
	,set_fstop: function(value) {
		this.fstop = value;
		this.uniforms.fstop.value = value;
		return value;
	}
	,set_maxblur: function(value) {
		this.maxblur = value;
		this.uniforms.maxblur.value = value;
		return value;
	}
	,set_depthblur: function(value) {
		this.depthblur = value;
		this.uniforms.depthblur.value = value;
		return value;
	}
	,set_threshold: function(value) {
		this.threshold = value;
		this.uniforms.threshold.value = value;
		return value;
	}
	,set_gain: function(value) {
		this.gain = value;
		this.uniforms.gain.value = value;
		return value;
	}
	,set_bias: function(value) {
		this.bias = value;
		this.uniforms.bias.value = value;
		return value;
	}
	,set_fringe: function(value) {
		this.fringe = value;
		this.uniforms.fringe.value = value;
		return value;
	}
	,set_noise: function(value) {
		this.noise = value;
		this.uniforms.noise.value = value;
		return value;
	}
	,set_dithering: function(value) {
		this.dithering = value;
		this.uniforms.dithering.value = value;
		return value;
	}
	,set_pentagon: function(value) {
		this.pentagon = value;
		this.uniforms.pentagon.value = value;
		return value;
	}
	,set_shaderFocus: function(value) {
		this.shaderFocus = value;
		this.uniforms.shaderFocus.value = value;
		return value;
	}
	,set_focusCoords: function(value) {
		this.focusCoords = value;
		this.uniforms.focusCoords.value = value;
		return value;
	}
	,setupDatGui: function(folder) {
		var _gthis = this;
		var f = folder.addFolder("DoF");
		f.add(this,"focalDepth").step(0.01).onChange(function(value) {
			_gthis.set_focalDepth(value);
		});
		f.add(this,"focalLength").step(0.01).onChange(function(value1) {
			_gthis.set_focalLength(value1);
		});
		f.add(this,"fstop").step(0.01).onChange(function(value2) {
			_gthis.set_fstop(value2);
		});
		f.add(this,"maxblur").step(0.01).onChange(function(value3) {
			_gthis.set_maxblur(value3);
		});
		f.add(this,"depthblur").onChange(function(value4) {
			_gthis.set_depthblur(value4);
		});
		f.add(this,"threshold").step(0.01).onChange(function(value5) {
			_gthis.set_threshold(value5);
		});
		f.add(this,"gain").step(0.01).onChange(function(value6) {
			_gthis.set_gain(value6);
		});
		f.add(this,"bias").step(0.01).onChange(function(value7) {
			_gthis.set_bias(value7);
		});
		f.add(this,"fringe").step(0.01).onChange(function(value8) {
			_gthis.set_fringe(value8);
		});
		f.add(this,"noise").onChange(function(value9) {
			_gthis.set_noise(value9);
		});
		f.add(this,"dithering").step(0.01).onChange(function(value10) {
			_gthis.set_dithering(value10);
		});
		f.add(this,"pentagon").onChange(function(value11) {
			_gthis.set_pentagon(value11);
		});
		f.add(this,"shaderFocus").onChange(function(value12) {
			_gthis.set_shaderFocus(value12);
		});
		f.add(this.focusCoords,"x").step(0.01).onChange(function(value13) {
			_gthis.uniforms.focusCoords.value[0] = value13;
		});
		f.add(this.focusCoords,"y").step(0.01).onChange(function(value14) {
			_gthis.uniforms.focusCoords.value[1] = value14;
		});
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		this.uniforms.zfar.value = this.sceneCamera.far;
		this.uniforms.znear.value = this.sceneCamera.near;
		this.uniforms.tColor.value = readBuffer.texture;
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,__class__: wl_post_dof_DoF
};
var wl_post_gray_Gray = function(gray) {
	this.gray = 0;
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.uniforms = { tDiffuse : { type : "t"}, gray : { type : "f"}};
	if(gray != null) {
		this.set_gray(gray);
	}
	this.enabled = true;
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, vertexShader : haxe_Resource.getString("gray.vert"), fragmentShader : haxe_Resource.getString("gray.frag")});
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
wl_post_gray_Gray.__name__ = ["wl","post","gray","Gray"];
wl_post_gray_Gray.prototype = {
	set_gray: function(value) {
		this.gray = value;
		this.uniforms.gray.value = value;
		return value;
	}
	,setupDatGui: function(folder) {
		var _gthis = this;
		folder.addFolder("Gray").add(this,"gray").step(0.01).min(0).max(1).onChange(function(val) {
			_gthis.uniforms.gray.value = _gthis.gray;
		});
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		this.uniforms.tDiffuse.value = readBuffer.texture;
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,__class__: wl_post_gray_Gray
};
var wl_post_pixelate_Pixelate = function(pixelamount) {
	this.pixelamount = new THREE.Vector2(128,72);
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.uniforms = { resolution : { type : "v2", value : new THREE.Vector2(1280,720)}, tDiffuse : { type : "t"}, pixelamount : { type : "v2", value : new THREE.Vector2(128,72)}};
	if(pixelamount != null) {
		this.uniforms.pixelamount.value = pixelamount;
	}
	this.enabled = true;
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, vertexShader : haxe_Resource.getString("pixelate.vert"), fragmentShader : haxe_Resource.getString("pixelate.frag")});
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
wl_post_pixelate_Pixelate.__name__ = ["wl","post","pixelate","Pixelate"];
wl_post_pixelate_Pixelate.prototype = {
	set_pixelamount: function(value) {
		this.pixelamount = value;
		this.uniforms.pixelamount.value = value;
		return value;
	}
	,setupDatGui: function(folder) {
		var _gthis = this;
		var f = folder.addFolder("Pixelate");
		f.add(this.pixelamount,"x").step(1).min(1).max(wl_core_Config.RESOLUTION[0]).onChange(function(val) {
			_gthis.uniforms.pixelamount.value = _gthis.pixelamount;
		});
		f.add(this.pixelamount,"y").step(1).min(1).max(wl_core_Config.RESOLUTION[1]).onChange(function(val1) {
			_gthis.uniforms.pixelamount.value = _gthis.pixelamount;
		});
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		this.uniforms.tDiffuse.value = readBuffer.texture;
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,__class__: wl_post_pixelate_Pixelate
};
var wl_post_rgbshift_RGBShift = function(rshift,gshift,bshift) {
	this.bshift = 0.0;
	this.rshift = 0.0;
	this.gshift = 0.0;
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.uniforms = { gshift : { type : "f", value : 0.04}, rshift : { type : "f", value : 0.04}, bshift : { type : "f", value : 0.0}, tDiffuse : { type : "t"}};
	if(rshift != null) {
		this.set_rshift(rshift);
	} else {
		this.set_rshift(this.rshift);
	}
	if(gshift != null) {
		this.set_gshift(gshift);
	} else {
		this.set_gshift(this.gshift);
	}
	if(bshift != null) {
		this.set_bshift(bshift);
	} else {
		this.set_bshift(this.bshift);
	}
	this.enabled = true;
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, vertexShader : haxe_Resource.getString("rgbshift.vert"), fragmentShader : haxe_Resource.getString("rgbshift.frag")});
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
wl_post_rgbshift_RGBShift.__name__ = ["wl","post","rgbshift","RGBShift"];
wl_post_rgbshift_RGBShift.prototype = {
	set_gshift: function(value) {
		this.gshift = value;
		this.uniforms.gshift.value = value;
		return value;
	}
	,set_rshift: function(value) {
		this.rshift = value;
		this.uniforms.rshift.value = value;
		return value;
	}
	,set_bshift: function(value) {
		this.bshift = value;
		this.uniforms.bshift.value = value;
		return value;
	}
	,setupDatGui: function(folder) {
		var _gthis = this;
		var f = folder.addFolder("RGB");
		f.add(this,"rshift").step(0.0001).min(-1).max(1).onChange(function(value) {
			_gthis.set_rshift(value);
		});
		f.add(this,"gshift").step(0.0001).min(-1).max(1).onChange(function(value1) {
			_gthis.set_gshift(value1);
		});
		f.add(this,"bshift").step(0.0001).min(-1).max(1).onChange(function(value2) {
			_gthis.set_bshift(value2);
		});
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		this.uniforms.tDiffuse.value = readBuffer.texture;
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,__class__: wl_post_rgbshift_RGBShift
};
var wl_post_standard_StandardShader = function(gamma) {
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.gamma = 1;
	this.brightness = 0;
	this.uniforms = { brightness : { type : "f", value : 0.0}, gamma : { type : "f", value : 0.0}, tDiffuse : { type : "t"}};
	if(gamma == null) {
		gamma = 1;
	}
	this.set_gamma(gamma);
	this.enabled = true;
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, vertexShader : haxe_Resource.getString("standard.vert"), fragmentShader : haxe_Resource.getString("standard.frag")});
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
wl_post_standard_StandardShader.__name__ = ["wl","post","standard","StandardShader"];
wl_post_standard_StandardShader.prototype = {
	set_brightness: function(val) {
		return this.uniforms.brightness.value = val;
	}
	,set_gamma: function(val) {
		return this.uniforms.gamma.value = val;
	}
	,setupDatGui: function(folder) {
		var _gthis = this;
		var f = folder.addFolder("Standard");
		f.add(this,"brightness").onChange(function(val) {
			_gthis.uniforms.brightness.value = _gthis.gamma;
		});
		f.add(this,"gamma").onChange(function(val1) {
			_gthis.uniforms.gamma.value = _gthis.gamma;
		});
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		this.uniforms.tDiffuse.value = readBuffer.texture;
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,__class__: wl_post_standard_StandardShader
};
var wl_setup_Setup = function() {
	throw new js__$Boot_HaxeError("Setup is static only.");
};
wl_setup_Setup.__name__ = ["wl","setup","Setup"];
wl_setup_Setup.init = function(demo) {
	wl_setup_Setup.setupDiv = $("#setup");
	wl_setup_Setup.demoDiv = $("#demo");
	wl_setup_Setup.resolution = wl_setup_Setup.setupDiv.find("#resolution");
	var fullscreen = wl_setup_Setup.setupDiv.find("#fullscreen");
	var start = wl_setup_Setup.setupDiv.find("#start");
	fullscreen.click(wl_setup_Setup.fullScreenClickHandler);
	start.click(wl_setup_Setup.startClickHandler);
	wl_setup_Setup.demo = demo;
	if(window.location.protocol.indexOf("file") >= 0) {
		$("#localWarning").css("display","");
	}
};
wl_setup_Setup.hideSetup = function() {
	wl_setup_Setup.setupDiv.remove();
};
wl_setup_Setup.startRun = function() {
	if(wl_setup_Setup.setupDiv.find("#muted").find("input")["is"](":checked")) {
		wl_core_Config.MUTED = true;
	}
	var debug = wl_setup_Setup.setupDiv.find("#debug").find("input")["is"](":checked");
	wl_core_Config.DEBUG = debug;
	if(debug) {
		$(".debug").css("display","block");
	} else {
		$(".debug").css("display","none");
	}
	wl_setup_Setup.demo.init(wl_setup_Setup.demoDiv[0]);
	wl_setup_Setup.demoDiv.append(wl_setup_Setup.demo.graphics.canvas);
	wl_setup_Setup.demo.start();
};
wl_setup_Setup.fullScreenClickHandler = function(e) {
	wl_setup_Setup.hideSetup();
	try {
		wl_setup_Setup.demoDiv[0].requestFullscreen();
	} catch( e1 ) {
		throw new js__$Boot_HaxeError("Full screen could not be initialized. Please reload and try again.");
	}
	var w = window.screen.width;
	var h = window.screen.height;
	var ratio = wl_core_Config.RATIO;
	var lockAspect = $("#aspectLock input").val() == "on";
	if(lockAspect && w / ratio < h) {
		h = w * 720 / 1280;
	} else if(lockAspect && h < w / ratio) {
		w = h * 1280 / 720;
	}
	wl_core_Config.RESOLUTION[0] = Math.floor(w);
	wl_core_Config.RESOLUTION[1] = Math.floor(h);
	wl_setup_Setup.demoDiv.css("background","black");
	haxe_Timer.delay(wl_setup_Setup.startRun,5000);
};
wl_setup_Setup.startClickHandler = function(e) {
	$("#demo").css("transform","").css("-webkit-transform","");
	var lockAspect = $("#aspectLock input").val() == "on";
	$("#muted input")["is"](":checked");
	var resolutionType = $("#resolution .active input[name='options']").val();
	wl_setup_Setup.hideSetup();
	var w = 1280;
	var h = 720;
	if(resolutionType == "b") {
		w = 1920;
		h = 1080;
	} else if(resolutionType == "c") {
		w = window.innerWidth;
		h = window.innerHeight;
		var ratio = wl_core_Config.RATIO;
		if(lockAspect && w / ratio < h) {
			h = w / ratio;
		} else if(lockAspect && h < w / ratio) {
			w = h * ratio;
		}
	}
	wl_core_Config.RESOLUTION[0] = w;
	wl_core_Config.RESOLUTION[1] = h;
	wl_setup_Setup.demoDiv.css("width",w + "px").css("height",h + "px");
	haxe_Timer.delay(wl_setup_Setup.startRun,500);
};
wl_setup_Setup.prototype = {
	__class__: wl_setup_Setup
};
var wl_sounds_SoundAnalyzer = function() {
	this.historySize = 6;
	this.filters = [];
	this.history = [];
	var _g1 = 0;
	var _g = wl_sounds_SoundWL.FFT_PRECISION;
	while(_g1 < _g) {
		++_g1;
		this.history.push([]);
	}
};
wl_sounds_SoundAnalyzer.__name__ = ["wl","sounds","SoundAnalyzer"];
wl_sounds_SoundAnalyzer.prototype = {
	update: function() {
		var _g = 0;
		var _g1 = this.filters;
		while(_g < _g1.length) {
			var filter = _g1[_g];
			++_g;
			filter.min = 1;
			filter.max = 0;
			filter.triggered = false;
		}
		var fft = wl_sounds_SoundWL.getFFT();
		var band = wl_sounds_SoundWL.sampleRate / wl_sounds_SoundWL.FFT_PRECISION;
		if(fft.frequency == null) {
			return;
		}
		var _g11 = 0;
		var _g2 = fft.frequency.length;
		while(_g11 < _g2) {
			var i = _g11++;
			var h = this.history[i];
			h.push(fft.frequency[i] / 255);
			while(h.length > this.historySize) h.shift();
			var sum = 0;
			var _g21 = 0;
			while(_g21 < h.length) {
				var v = h[_g21];
				++_g21;
				sum += v;
			}
			sum /= this.historySize;
			var hz = band * i;
			var _g22 = 0;
			var _g3 = this.filters;
			while(_g22 < _g3.length) {
				var filter1 = _g3[_g22];
				++_g22;
				if(filter1.isolate ? hz >= filter1.lowLimit && hz <= filter1.highLimit : hz > filter1.highLimit || hz < filter1.lowLimit) {
					filter1.min = filter1.min > sum ? sum : filter1.min;
					filter1.max = filter1.max < sum ? sum : filter1.max;
					filter1.triggered = true;
				}
			}
		}
		var _g4 = 0;
		var _g12 = this.filters;
		while(_g4 < _g12.length) ++_g4;
	}
	,__class__: wl_sounds_SoundAnalyzer
};
var wl_sounds_SoundWL = function() {
	throw new js__$Boot_HaxeError("Sound is static");
};
wl_sounds_SoundWL.__name__ = ["wl","sounds","SoundWL"];
wl_sounds_SoundWL.init = function() {
	wl_sounds_SoundWL.loadMusicFile();
};
wl_sounds_SoundWL.setVolume = function(volume) {
	wl_sounds_SoundWL.volume = volume;
	if(wl_sounds_SoundWL.instance != null) {
		wl_sounds_SoundWL.instance.volume = volume;
	}
};
wl_sounds_SoundWL.getPosition = function() {
	if(wl_sounds_SoundWL.instance != null) {
		wl_sounds_SoundWL.time.fromTime(wl_sounds_SoundWL.instance.getPosition() / 1000 / 60 - wl_core_Config.MUSIC_BEGIN / 1000 / 60);
	} else if(wl_sounds_SoundWL.context != null) {
		wl_sounds_SoundWL.time.fromTime((wl_sounds_SoundWL.context.currentTime - wl_sounds_SoundWL.startTime) / 60 - wl_core_Config.MUSIC_BEGIN / 1000 / 60);
	}
	return wl_sounds_SoundWL.time;
};
wl_sounds_SoundWL.getFFT = function() {
	return wl_sounds_SoundWL.FFT;
};
wl_sounds_SoundWL.updateFFT = function() {
	if((wl_sounds_SoundWL.instance != null || wl_sounds_SoundWL.context != null) && wl_core_Config.ENABLE_FFT && wl_sounds_SoundWL.analyserNode != null) {
		wl_sounds_SoundWL.analyserNode.getFloatFrequencyData(wl_sounds_SoundWL.freqFloatData);
		wl_sounds_SoundWL.analyserNode.getByteFrequencyData(wl_sounds_SoundWL.freqByteData);
		wl_sounds_SoundWL.analyserNode.getByteTimeDomainData(wl_sounds_SoundWL.timeByteData);
	}
};
wl_sounds_SoundWL.start = function() {
	wl_sounds_SoundWL.context = createjs.Sound.activePlugin.context;
	wl_sounds_SoundWL.sampleRate = createjs.Sound.activePlugin.context.sampleRate;
	wl_sounds_SoundWL.dynamicsCompressorNode = createjs.Sound.activePlugin.dynamicsCompressorNode;
	wl_sounds_SoundWL.instance = createjs.Sound.play("music");
	wl_sounds_SoundWL.instance.on("complete",wl_sounds_SoundWL.handleComplete);
	wl_sounds_SoundWL.instance.volume = wl_core_Config.MUTED ? 0 : wl_sounds_SoundWL.volume;
	if(wl_core_Config.ENABLE_FFT) {
		wl_sounds_SoundWL.initializeFFT();
	}
	wl_sounds_SoundWL.onSoundReady.emit();
};
wl_sounds_SoundWL.handleComplete = function() {
	wl_sounds_SoundWL.onSoundComplete.emit();
};
wl_sounds_SoundWL.loadMusicFile = function() {
	var sounds = [{ id : "music", src : wl_core_Config.SONG_PATH}];
	createjs.Sound.alternateExtensions = ["mp3"];
	createjs.Sound.addEventListener("fileload",wl_sounds_SoundWL.handleLoad);
	createjs.Sound.registerSounds(sounds);
};
wl_sounds_SoundWL.initializeFFT = function() {
	var context = wl_sounds_SoundWL.context;
	var fftsize = wl_sounds_SoundWL.FFT_PRECISION;
	if(context != null && $bind(context,context.createAnalyser) != null) {
		wl_sounds_SoundWL.analyserNode = context.createAnalyser();
		wl_sounds_SoundWL.analyserNode.fftSize = fftsize;
		wl_sounds_SoundWL.analyserNode.smoothingTimeConstant = 0.0;
		wl_sounds_SoundWL.analyserNode.connect(context.destination);
		var dynamicsNode = wl_sounds_SoundWL.dynamicsCompressorNode;
		dynamicsNode.disconnect();
		dynamicsNode.connect(wl_sounds_SoundWL.analyserNode);
		wl_sounds_SoundWL.freqFloatData = new Float32Array(wl_sounds_SoundWL.analyserNode.frequencyBinCount);
		wl_sounds_SoundWL.freqByteData = new Uint8Array(wl_sounds_SoundWL.analyserNode.frequencyBinCount);
		wl_sounds_SoundWL.timeByteData = new Uint8Array(wl_sounds_SoundWL.analyserNode.frequencyBinCount);
		wl_sounds_SoundWL.scriptProcessor = context.createScriptProcessor(wl_sounds_SoundWL.FFT_PRECISION * 2,2,2);
		wl_sounds_SoundWL.scriptProcessor.onaudioprocess = wl_sounds_SoundWL.updateFFT;
		wl_sounds_SoundWL.analyserNode.connect(wl_sounds_SoundWL.scriptProcessor);
		wl_sounds_SoundWL.scriptProcessor.connect(context.destination);
	} else {
		console.log("FFT could not be initialized.");
	}
	wl_sounds_SoundWL.FFT.db = wl_sounds_SoundWL.freqFloatData;
	wl_sounds_SoundWL.FFT.frequency = wl_sounds_SoundWL.freqByteData;
	wl_sounds_SoundWL.FFT.waveform = wl_sounds_SoundWL.timeByteData;
};
wl_sounds_SoundWL.handleLoad = function() {
	wl_sounds_SoundWL.loaded = true;
	wl_sounds_SoundWL.onSoundLoaded.emit();
};
wl_sounds_SoundWL.prototype = {
	__class__: wl_sounds_SoundWL
};
var wl_util_ExplodeGeometry = function() {
};
wl_util_ExplodeGeometry.__name__ = ["wl","util","ExplodeGeometry"];
wl_util_ExplodeGeometry.explode = function(geometry) {
	var vertices = [];
	var _g1 = 0;
	var _g = geometry.faces.length;
	while(_g1 < _g) {
		var n = vertices.length;
		var face = geometry.faces[_g1++];
		var vb = geometry.vertices[face.b];
		var vc = geometry.vertices[face.c];
		vertices.push(geometry.vertices[face.a].clone());
		vertices.push(vb.clone());
		vertices.push(vc.clone());
		face.a = n;
		face.b = n + 1;
		face.c = n + 2;
	}
	geometry.vertices = vertices;
};
wl_util_ExplodeGeometry.prototype = {
	__class__: wl_util_ExplodeGeometry
};
var wl_util_MathUtil = function() {
};
wl_util_MathUtil.__name__ = ["wl","util","MathUtil"];
wl_util_MathUtil.clamp = function(low,high,val) {
	if(val < low) {
		return low;
	} else if(val > high) {
		return high;
	} else {
		return val;
	}
};
wl_util_MathUtil.FromVector3 = function(position,sphereRadius) {
	return [(270 + Math.atan2(position.x,position.z) * 180 / Math.PI) % 360 - 180,90 - Math.acos(position.y / sphereRadius) * 180 / Math.PI];
};
wl_util_MathUtil.componentLerp = function(v1,v2,phase,easex,easey,easez,setTo) {
	if(setTo == null) {
		setTo = new THREE.Vector3();
	} else {
		setTo = setTo;
	}
	setTo.set(easex(1 - phase) * v1.x + easex(phase) * v2.x,easey(1 - phase) * v1.y + easey(phase) * v2.y,easez(1 - phase) * v1.z + easez(phase) * v2.z);
	return setTo;
};
wl_util_MathUtil.prototype = {
	__class__: wl_util_MathUtil
};
var wl_util_Random = function(seed) {
	this.seed = 123;
	this.Init(seed);
};
wl_util_Random.__name__ = ["wl","util","Random"];
wl_util_Random.init = function(seed) {
	wl_util_Random.instance.Init(seed);
};
wl_util_Random.next = function() {
	return wl_util_Random.instance.Next();
};
wl_util_Random.nextFloat = function() {
	return wl_util_Random.instance.NextFloat();
};
wl_util_Random.range = function(low,high) {
	return wl_util_Random.instance.Range(low,high);
};
wl_util_Random.prototype = {
	Init: function(seed) {
		this.seed = seed;
	}
	,Next: function() {
		var test = 16807 * Math.floor(this.seed % 127773) - 2836 * Math.floor(this.seed / 127773);
		if(test < 0) {
			test += 2147483647;
		}
		this.seed = test;
		return this.seed;
	}
	,NextFloat: function() {
		return this.Next() / 2147483647;
	}
	,Range: function(low,high) {
		return Math.floor(this.NextFloat() * (high - low) + low);
	}
	,__class__: wl_util_Random
};
var wl_util_ScreenUtil = function() {
};
wl_util_ScreenUtil.__name__ = ["wl","util","ScreenUtil"];
wl_util_ScreenUtil.projectToNormalizedScreenPosition = function(position,camera) {
	var widthHalf = wl_core_Config.RESOLUTION[0] * 0.5;
	var heightHalf = wl_core_Config.RESOLUTION[1] * 0.5;
	var vector = position.clone().project(camera);
	var r = new THREE.Vector2();
	r.x = vector.x * widthHalf + widthHalf;
	r.y = -(vector.y * heightHalf) + heightHalf;
	r.x /= widthHalf * 2;
	r.y /= heightHalf * 2;
	return r;
};
wl_util_ScreenUtil.prototype = {
	__class__: wl_util_ScreenUtil
};
var $_, $fid = 0;
function $bind(o,m) { if( m == null ) return null; if( m.__id__ == null ) m.__id__ = $fid++; var f; if( o.hx__closures__ == null ) o.hx__closures__ = {}; else f = o.hx__closures__[m.__id__]; if( f == null ) { f = function(){ return f.method.apply(f.scope, arguments); }; f.scope = o; f.method = m; o.hx__closures__[m.__id__] = f; } return f; }
String.prototype.__class__ = String;
String.__name__ = ["String"];
Array.__name__ = ["Array"];
Date.prototype.__class__ = Date;
Date.__name__ = ["Date"];
var Int = { __name__ : ["Int"]};
var Dynamic = { __name__ : ["Dynamic"]};
var Float = Number;
Float.__name__ = ["Float"];
var Bool = Boolean;
Bool.__ename__ = ["Bool"];
var Class = { __name__ : ["Class"]};
var Enum = { };
haxe_Resource.content = [{ name : "colorhilight.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "pixelate.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gdmVjMiBwaXhlbGFtb3VudDsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaWZmdXNlOw0KDQp2b2lkIG1haW4oKSB7DQoJdmVjMiB1diA9IHZVdjsNCgl1di54ID0gZmxvb3IodXYueCpwaXhlbGFtb3VudC54KS9waXhlbGFtb3VudC54Ow0KCXV2LnkgPSBmbG9vcih1di55KnBpeGVsYW1vdW50LnkpL3BpeGVsYW1vdW50Lnk7DQoJdmVjNCBjID0gdGV4dHVyZTJEKHREaWZmdXNlLHV2KTsNCglnbF9GcmFnQ29sb3IgPSBjOw0KfQ0K"},{ name : "halfSpawner.json", data : "ew0KICAgICJ1dnMiOltdLA0KICAgICJtZXRhZGF0YSI6ew0KICAgICAgICAidHlwZSI6Ikdlb21ldHJ5IiwNCiAgICAgICAgImdlbmVyYXRvciI6ImlvX3RocmVlIiwNCiAgICAgICAgInV2cyI6MCwNCiAgICAgICAgIm5vcm1hbHMiOjE4LA0KICAgICAgICAidmVyc2lvbiI6MywNCiAgICAgICAgInZlcnRpY2VzIjoxNiwNCiAgICAgICAgImZhY2VzIjoxOA0KICAgIH0sDQogICAgIm5vcm1hbHMiOlswLC0xLDAsLTAsMSwwLDEuODczMDdlLTA3LDQuNDExOTJlLTA4LDEsOC45ODE0MWUtMDgsNS4xMTM4NmUtMDgsMSwyLjAyNjI0ZS0wNyw0LjI4NDA5ZS0wOCwxLDcuMDc4MDVlLTA4LDEuNzQ2ODRlLTA3LDEsMSwyLjE0Mjk0ZS0wNyw4LjQ4ODc1ZS0wNiw3LjA2ODY4ZS0xNCwxLDkuOTg2NzZlLTA3LDguMTA5MTVlLTA4LC01LjQ3ODk0ZS0wOSwxLC0xLC0xLjkzNzE1ZS0wNywtMS40OTgwMWUtMDYsLTEuODczMDdlLTA3LC00LjQxMTkyZS0wOCwtMSwtNy4wNzgwNWUtMDgsLTUuMTEzODRlLTA4LC0xLDkuMzk3NDRlLTA5LC02LjA1MzZlLTA4LC0xLC01Ljk4NzZlLTA4LDguNzM3NmUtMDksLTEsLTAsLTEsMCwtNi40ODczMmUtMDgsMS4xMDc1MWUtMDcsLTEsLTEsMS42MzY0M2UtMDcsLTMuNDk1MzZlLTA2LC0xLDEuNjM2NDNlLTA3LC03LjQ5MDA3ZS0wNl0sDQogICAgImZhY2VzIjpbMzMsMCwxMiwxNCwxLDAsMCwwLDAsMzMsMiwzLDExLDksMSwxLDEsMSwzMiw1LDAsMiwyLDIsMiwzMiwyLDksOCwzLDMsMywzMiw3LDUsMiw0LDQsNCwzMiwyLDgsNyw1LDUsNSwzMywyLDAsMSwzLDYsNiw2LDYsMzMsNSw0LDE1LDEzLDcsNyw3LDcsMzMsMTIsMCw1LDEzLDgsOCw4LDgsMzMsNyw2LDQsNSw5LDksOSw5LDMyLDMsMSw0LDEwLDEwLDEwLDMyLDYsMTAsMTEsMTEsMTEsMTEsMzIsMyw0LDYsMTIsMTIsMTIsMzIsNiwxMSwzLDEzLDEzLDEzLDMzLDgsMTAsNiw3LDE0LDE0LDE0LDE0LDMzLDE0LDE1LDQsMSwxNSwxNSwxNSwxNSwzMywxMywxNSwxNCwxMiwxNiwxNiwxNiwxNiwzMyw5LDExLDEwLDgsMTcsMTcsMTcsMTddLA0KICAgICJ2ZXJ0aWNlcyI6WzAuNjM2NTg4LC0xLjE4MjEyLDAuMDI5ODQxOCwwLjYzNjU4OSwtMS4xODIxMiwtMC4wMjk4NDE4LDAuNjM2NTg4LDEuMTgyMTIsMC4wMjk4NDE3LDAuNjM2NTg4LDEuMTgyMTIsLTAuMDI5ODQxOSwwLjQ1NDQ3MSwtMSwtMC4wMjk4NDE4LDAuNDU0NDcxLC0xLDAuMDI5ODQxOSwwLjQ1NDQ3LDEsLTAuMDI5ODQxOSwwLjQ1NDQ3LDEsMC4wMjk4NDE4LC0wLjU0NTUzLDEsMC4wMjk4NDE4LC0wLjU0NTUzLDEuMTgyMTIsMC4wMjk4NDE4LC0wLjU0NTUzLDEsLTAuMDI5ODQxOSwtMC41NDU1MjksMS4xODIxMiwtMC4wMjk4NDE5LC0wLjU0NTUyOSwtMS4xODIxMiwwLjAyOTg0MTksLTAuNTQ1NTI5LC0xLDAuMDI5ODQxOSwtMC41NDU1MjksLTEuMTgyMTIsLTAuMDI5ODQxOCwtMC41NDU1MjksLTEsLTAuMDI5ODQxN10NCn0"},{ name : "volumetric.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaWZmdXNlOw0KdW5pZm9ybSB2ZWMyIGxpZ2h0UG9zaXRpb247DQp1bmlmb3JtIGZsb2F0IGV4cG9zdXJlOw0KdW5pZm9ybSBmbG9hdCBkZWNheTsNCnVuaWZvcm0gZmxvYXQgZGVuc2l0eTsNCnVuaWZvcm0gZmxvYXQgd2VpZ2h0Ow0KdW5pZm9ybSBpbnQgc2FtcGxlczsNCmNvbnN0IGludCBNQVhfU0FNUExFUyA9IDEwMDsNCg0Kdm9pZCBtYWluKCkNCnsNCgl2ZWMyIHRleENvb3JkID0gdlV2Ow0KICAgIHZlYzIgZGVsdGFUZXh0Q29vcmQgPSB0ZXhDb29yZCAtIGxpZ2h0UG9zaXRpb247DQogICAgZGVsdGFUZXh0Q29vcmQgKj0gMS4wIC8gZmxvYXQoc2FtcGxlcykgKiBkZW5zaXR5Ow0KICAgIHZlYzQgY29sb3IgPSB0ZXh0dXJlMkQodERpZmZ1c2UsIHRleENvb3JkKTsNCiAgICBmbG9hdCBpbGx1bWluYXRpb25EZWNheSA9IDEuMDsNCiAgICBmb3IoaW50IGk9MDsgaSA8IE1BWF9TQU1QTEVTOyBpKyspDQogICAgew0KICAgIGlmKGkgPT0gc2FtcGxlcyl7DQoJCWJyZWFrOw0KICAgICAgICB9DQoJCXRleENvb3JkIC09IGRlbHRhVGV4dENvb3JkOw0KICAgICAgICB2ZWM0IHNhbXBsZSA9IHRleHR1cmUyRCh0RGlmZnVzZSwgdGV4Q29vcmQpOw0KICAgICAgICBzYW1wbGUgKj0gaWxsdW1pbmF0aW9uRGVjYXkgKiB3ZWlnaHQ7DQogICAgICAgIGNvbG9yICs9IHNhbXBsZTsNCiAgICAgICAgaWxsdW1pbmF0aW9uRGVjYXkgKj0gZGVjYXk7DQogICAgfQ0KICAgIGdsX0ZyYWdDb2xvciA9IGNvbG9yICogZXhwb3N1cmU7DQp9DQo"},{ name : "colorhilight.frag", data : "dW5pZm9ybSBmbG9hdCByYW5nZTsNCnVuaWZvcm0gZmxvYXQgdmFsdWUxOw0KdW5pZm9ybSBmbG9hdCB2YWx1ZTI7DQp1bmlmb3JtIGZsb2F0IG9yaWdpbmFsOw0KdW5pZm9ybSBmbG9hdCBhbW91bnQ7DQp1bmlmb3JtIHZlYzQgY29sb3IxOw0KdW5pZm9ybSB2ZWM0IGNvbG9yMjsNCnVuaWZvcm0gdmVjMiB0aWxlOw0KdW5pZm9ybSBzYW1wbGVyMkQgdERpZmZ1c2U7DQp2YXJ5aW5nIHZlYzIgdlV2Ow0KDQp2b2lkIG1haW4oKSB7DQoJdmVjMiB1diA9IHZVdjsNCgl2ZWM0IGMgPSB0ZXh0dXJlMkQodERpZmZ1c2UsdXYqdGlsZSk7DQoJDQoJLy9NYWtlIGNvbnRpbnVvdXMgdHJpYW5nbGUgZnVuY3Rpb24NCglmbG9hdCB2YWwxID0gdmFsdWUxKjIuOw0KCXZhbDEgPSB2YWwxIDwgMS4gPyB2YWwxIDogMi4tdmFsMTsNCglmbG9hdCB2YWwyID0gdmFsdWUyKjIuOw0KCXZhbDEgPSB2YWwyIDwgMS4gPyB2YWwyIDogMi4tdmFsMjsNCgkNCglmbG9hdCB0aW1lb2ZmMSA9IG1vZCh2YWwxLCAxLiArIHJhbmdlKTsNCglmbG9hdCB0aW1lb2ZmMiA9IG1vZCh2YWwyLCAxLiArIHJhbmdlKTsNCgkNCglmbG9hdCBtcDEgPSAoYWJzKGMuciAtIHRpbWVvZmYxKSA+IHJhbmdlKSA/IDEuIDogMC47DQoJZmxvYXQgbXAyID0gKGFicyhjLmcgLSB0aW1lb2ZmMikgPiByYW5nZSkgPyAxLiA6IDAuOw0KCQ0KCWZsb2F0IGF2ZyA9IChjLnIrYy5nK2MuYikvMy47DQoJdmVjNCBhZHMxID0gY29sb3IxICogYWJzKGF2ZyAtIHRpbWVvZmYxKTsNCgl2ZWM0IGFkczIgPSBjb2xvcjIgKiBhYnMoYXZnIC0gdGltZW9mZjIpOw0KCQ0KCXZlYzQgY29sID0gKDEuLSBtcDEpICogYWRzMSArICgxLiAtIG1wMikqYWRzMjsNCgkNCglnbF9GcmFnQ29sb3IgPSBjKm9yaWdpbmFsICsgY29sKmFtb3VudDsNCn0NCg"},{ name : "bgQuad.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gZmxvYXQgdGltZTsNCnZvaWQgbWFpbigpDQp7DQoJdmVjMiB1diA9IHZVdjsNCiAgICANCiAgICB2ZWMzIGNvbHMgPSB2ZWMzKDEuLCAxLiwxLik7DQogICAgDQogICAgZmxvYXQgdiA9IDAuOw0KICAgIHZlYzMgYyA9IHZlYzMoMC4pOw0KICAgIGZvciggaW50IGkgPSAwOyBpIDwgMTA7IGkrKykNCiAgICB7DQogICAgIAlmbG9hdCB4cCA9IHNpbihmbG9hdChpKSozLit0aW1lKigwLjEyK2Zsb2F0KGkpKi4wMSkpKjIuOw0KICAgICAgICBmbG9hdCBkaXN0ID0gbWF4KDEwLjgsYWJzKHV2LngteHApKig0NS4rMTAuKnNpbih0aW1lKjAuMytmbG9hdChpKSkpKTsNCiAgICAgICAgDQogICAgICAgIGMrPW1heCh2ZWMzKDAuKSwxLi9kaXN0ICogY29scyooMS4wLXV2LnkqMC40NykqMC43KSoyLjsNCiAgICAgICAgDQogICAgICAgIHYrPXV2LngtMC41KnhwOw0KICAgICAgICANCiAgICB9DQogICAgDQogICAgZ2xfRnJhZ0NvbG9yID12ZWM0KHNtb290aHN0ZXAodmVjMygwLjQyKSwgdmVjMygwLjk5KSxjKSwxLikqdmVjNCgxLiwgMC40LDAuNCwwLjgpOw0KfQ"},{ name : "rgbshift.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "pixelate.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "gray.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaWZmdXNlOw0KdW5pZm9ybSBmbG9hdCBncmF5Ow0KDQp2b2lkIG1haW4oKSB7DQoJdmVjMiB1diA9IHZVdjsNCgl2ZWM0IGMgPSB0ZXh0dXJlMkQodERpZmZ1c2UsdXYpOw0KCWZsb2F0IGdyID0gZG90KGMucmdiLCB2ZWMzKDAuMjk5LCAwLjU4NywgMC4xMTQpKTsNCiAgICB2ZWMzIGZjID0gbWl4KGMucmdiLCB2ZWMzKGdyKSwgZ3JheSk7DQoJZ2xfRnJhZ0NvbG9yID12ZWM0KGZjLDEuKTsNCn0NCg"},{ name : "standard.frag", data : "dW5pZm9ybSBmbG9hdCBicmlnaHRuZXNzOw0KdW5pZm9ybSBmbG9hdCBnYW1tYTsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaWZmdXNlOw0KdmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzIgdXYgPSB2VXY7DQoJdmVjNCBjID0gdGV4dHVyZTJEKHREaWZmdXNlLHV2KTsNCgljID0gcG93KGMsIHZlYzQoMS4wL2dhbW1hKSk7DQoJYys9YnJpZ2h0bmVzczsNCglnbF9GcmFnQ29sb3IgPSBjOw0KfQ"},{ name : "rgbshift.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gZmxvYXQgcnNoaWZ0Ow0KdW5pZm9ybSBmbG9hdCBnc2hpZnQ7DQp1bmlmb3JtIGZsb2F0IGJzaGlmdDsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaWZmdXNlOw0KDQp2b2lkIG1haW4oKSB7DQoJdmVjNCBjID0gdGV4dHVyZTJEKHREaWZmdXNlLHZVdik7DQoJZmxvYXQgcm8gPSB0ZXh0dXJlMkQodERpZmZ1c2UsdmVjMih2VXYueC1yc2hpZnQsIHZVdi55KSkucjsNCglmbG9hdCBnbyA9IHRleHR1cmUyRCh0RGlmZnVzZSx2ZWMyKHZVdi54LWdzaGlmdCwgdlV2LnkpKS5nOw0KCWZsb2F0IGJvID0gdGV4dHVyZTJEKHREaWZmdXNlLHZlYzIodlV2LngtYnNoaWZ0LCB2VXYueSkpLmI7DQoJZ2xfRnJhZ0NvbG9yID0gdmVjNChybywgZ28sIGJvLCBjLncpOw0KfQ"},{ name : "dof.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ0KICAgIA"},{ name : "gray.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "dof.frag", data : "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"},{ name : "volumetric.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "triangle.json", data : "ew0KICAgICJtZXRhZGF0YSI6ew0KICAgICAgICAidHlwZSI6Ikdlb21ldHJ5IiwNCiAgICAgICAgInZlcnNpb24iOjMsDQogICAgICAgICJ1dnMiOjAsDQogICAgICAgICJub3JtYWxzIjoxNiwNCiAgICAgICAgImdlbmVyYXRvciI6ImlvX3RocmVlIiwNCiAgICAgICAgImZhY2VzIjoxNiwNCiAgICAgICAgInZlcnRpY2VzIjoxMg0KICAgIH0sDQogICAgIm5vcm1hbHMiOlswLjg2NjAyNSwwLC0wLjUsLTguNjAzMTllLTA4LDAsMSwzLjU0OTk5ZS0xNSwxLC01LjAxOTllLTA4LC0wLjg2NjAyNSwwLC0wLjUsNC43NTkyNGUtMDksLTEsNC4xOTU1N2UtMDgsLTYuNzY4NDFlLTA5LC0xLDMuODQ3NThlLTA4LC0xLjM1MzY4ZS0wOCwtMSw1LjAxOTllLTA4LDkuNTE4NTFlLTA5LC0xLDUuMDE5OWUtMDgsMy42NzA1MmUtMDgsLTcuNDUwNThlLTA4LC0xLC0wLjg2NjAyNSwtMi40NDcwMWUtMDcsMC41LDQuNzU5MjZlLTA5LDEsLTQuMTk1NTdlLTA4LC02Ljc2ODM4ZS0wOSwxLC0zLjg0NzU4ZS0wOCwtMS4zNTM2OGUtMDgsMSwtNS4wMTk5ZS0wOCw5LjUxODVlLTA5LDEsLTUuMDE5OWUtMDgsLTMuMDQyODVlLTE1LC0xLDUuMDE5OWUtMDgsMC44NjYwMjUsLTEuMjIzNTFlLTA3LDAuNV0sDQogICAgInV2cyI6W10sDQogICAgImZhY2VzIjpbMzMsMCwxLDMsMiwwLDAsMCwwLDMzLDIsMyw1LDQsMSwxLDEsMSwzMywzLDgsMTAsNSwyLDIsMiwyLDMzLDEsMCw0LDUsMywzLDMsMywzMiwwLDIsOSw0LDQsNCwzMiw3LDExLDQsNSw1LDUsMzIsMCw5LDcsNiw2LDYsMzIsMCw3LDQsNyw3LDcsMzMsMTEsMTAsOCw5LDgsOCw4LDgsMzMsOSw4LDYsNyw5LDksOSw5LDMyLDEsNSwxMCwxMCwxMCwxMCwzMiw2LDgsMywxMSwxMSwxMSwzMiwxLDEwLDYsMTIsMTIsMTIsMzIsNiwzLDEsMTMsMTMsMTMsMzMsNCwxMSw5LDIsMTQsMTQsMTQsMTQsMzMsNyw2LDEwLDExLDE1LDE1LDE1LDE1XSwNCiAgICAidmVydGljZXMiOlswLC0wLjEsLTEsMCwwLjA5OTk5OTksLTEsMC44NjYwMjUsLTAuMSwwLjUsMC44NjYwMjUsMC4xLDAuNSwtMC44NjYwMjUsLTAuMSwwLjUsLTAuODY2MDI1LDAuMSwwLjUsLTUuODk3NzJlLTA5LDAuMDk5OTk5OSwtMC43MDMxNTgsLTUuODk3NzJlLTA5LC0wLjEsLTAuNzAzMTU4LDAuNjA4OTUzLDAuMSwwLjM1MTU3OSwwLjYwODk1MywtMC4xLDAuMzUxNTc5LC0wLjYwODk1MywwLjEsMC4zNTE1NzksLTAuNjA4OTUzLC0wLjEsMC4zNTE1NzldDQp9"},{ name : "distortedTv.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "additiveblending.frag", data : "dW5pZm9ybSBzYW1wbGVyMkQgdERpZmZ1c2U7DQp1bmlmb3JtIHNhbXBsZXIyRCB0QWRkOw0KdmFyeWluZyB2ZWMyIHZVdjsNCnZvaWQgbWFpbigpIHsNCgl2ZWM0IGNvbG9yID0gdGV4dHVyZTJEKCB0RGlmZnVzZSwgdlV2ICk7DQogICAgdmVjNCBhZGQgPSB0ZXh0dXJlMkQoIHRBZGQsIHZVdiApOw0KICAgIGdsX0ZyYWdDb2xvciA9IGNvbG9yICsgYWRkOw0KfQ0K"},{ name : "standard.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "displacement.frag", data : "dW5pZm9ybSBmbG9hdCBzY2FsZVg7DQp1bmlmb3JtIGZsb2F0IHNjYWxlWTsNCnVuaWZvcm0gZmxvYXQgem9vbTsNCnVuaWZvcm0gdmVjMiBvZmZzZXQ7DQp1bmlmb3JtIHNhbXBsZXIyRCB0RGlmZnVzZTsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaXNwTWFwOw0KdmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzIgdXYgPSB2VXY7DQoJdmVjNCBjZCA9IHRleHR1cmUyRCh0RGlzcE1hcCwodXYrb2Zmc2V0KSp6b29tKTsNCgkNCgkvL2NhbGN1bGF0ZSBvZmZzZXQNCgl2ZWMyIG9mZnNldCA9dmVjMiggY2QuciAqIHNjYWxlWCwgY2QuZypzY2FsZVkpIC0gdmVjMihzY2FsZVgqMC41LHNjYWxlWSowLjUpOw0KCQ0KCXZlYzQgYyA9IHRleHR1cmUyRCh0RGlmZnVzZSx1ditvZmZzZXQpOw0KCQ0KCWdsX0ZyYWdDb2xvciA9IGM7DQp9DQo"},{ name : "worm.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaWZmdXNlOw0KdW5pZm9ybSB2ZWMyIGxpZ2h0UG9zaXRpb247DQp1bmlmb3JtIGZsb2F0IGV4cG9zdXJlOw0KdW5pZm9ybSBmbG9hdCBkZWNheTsNCnVuaWZvcm0gZmxvYXQgZGVuc2l0eTsNCnVuaWZvcm0gZmxvYXQgd2VpZ2h0Ow0KdW5pZm9ybSBpbnQgc2FtcGxlczsNCmNvbnN0IGludCBNQVhfU0FNUExFUyA9IDEwMDsNCg0Kdm9pZCBtYWluKCkNCnsNCglnbF9GcmFnQ29sb3IgPSB2ZWM0KDAuNSwgMC4wLCAwLjIsIDEuMCk7DQp9DQo"},{ name : "worm.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCS8vcC56ID0gcC56ICsgc2luKHAueSowLjMpKjQuOw0KCS8vcC54ID0gcC54ICsgc2luKHAueSowLjMpKjQuOw0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "bgQuad.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "distortedTv.frag", data : "dW5pZm9ybSBmbG9hdCBkaXN0b3J0QW1vdW50Ow0KdW5pZm9ybSBzYW1wbGVyMkQgdERpZmZ1c2U7DQp1bmlmb3JtIGZsb2F0IHRpbWU7DQp1bmlmb3JtIGZsb2F0IGdyZWVuYW1wbGlmeTsNCnVuaWZvcm0gZmxvYXQgYmx1ZWFtcGxpZnk7DQp1bmlmb3JtIGZsb2F0IHZpZ25BbW91bnQ7DQp1bmlmb3JtIGZsb2F0IG9mZnNldEFtb3VudDsNCnVuaWZvcm0gZmxvYXQgYnJpZ2h0TXVsdGlwbGllcjsNCnVuaWZvcm0gZmxvYXQgYnJpZ2h0TGltaXQ7DQp2YXJ5aW5nIHZlYzIgdlV2Ow0KDQp2b2lkIG1haW4oKQ0Kew0KCXZlYzIgdXYgPSB2VXY7DQogICAgZmxvYXQgb2Zmc2V0ID0gbW9kKGNlaWwodXYueSpkaXN0b3J0QW1vdW50K3RpbWUpKnRpbWUsMC4wMTIpOw0KICAgIHZlYzQgdENvbG9yID0gdGV4dHVyZTJEKHREaWZmdXNlLHZlYzIodXYueCtvZmZzZXRBbW91bnQqb2Zmc2V0LHV2LnkpKTsNCiAgICB0Q29sb3IuZyAqPSBncmVlbmFtcGxpZnk7DQogICAgdENvbG9yLmIgKj0gYmx1ZWFtcGxpZnk7DQogICAgZmxvYXQgdmlnbiA9IDEuMC1sZW5ndGgodmVjMigwLjUsMC41KS11dikqdmlnbkFtb3VudDsNCiAgICANCgl2ZWMzIGJyaWdodG5lc3MgPSB0Q29sb3IucmdiOw0KCXZlYzMgbXAgPSB2ZWMzKDEuKS1zbW9vdGhzdGVwKHZlYzMoYnJpZ2h0TGltaXQpLCB2ZWMzKDEuKSwgYnJpZ2h0bmVzcykqYnJpZ2h0TXVsdGlwbGllcjsNCgl0Q29sb3IqPXZlYzQobXAsMS4pOw0KCQ0KICAgIHRDb2xvciAqPSB2aWduOw0KCWdsX0ZyYWdDb2xvciA9IHRDb2xvcjsNCn0"},{ name : "displacement.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "additiveblending.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"}];
var __map_reserved = {}
var ArrayBuffer = $global.ArrayBuffer || js_html_compat_ArrayBuffer;
if(ArrayBuffer.prototype.slice == null) {
	ArrayBuffer.prototype.slice = js_html_compat_ArrayBuffer.sliceImpl;
}
var Float32Array = $global.Float32Array || js_html_compat_Float32Array._new;
var Uint8Array = $global.Uint8Array || js_html_compat_Uint8Array._new;
DemoMain.DEMO_READY = new wl_core_Signal();
DemoMain.HILIGHT = new THREE.Color(15219237);
DemoMain.LIGHT = new THREE.Color(16771491);
DemoMain.GREEN = new THREE.Color(2503240);
DemoMain.BLUE = new THREE.Color(17763);
DemoMain.BLUE_DARK = new THREE.Color(1645352);
DemoMain.COLOR1 = new THREE.Color(1904913);
DemoMain.COLOR2 = new THREE.Color(5063748);
DemoMain.WHITE = new THREE.Color(16777215);
DemoMain.BLACK = new THREE.Color(0);
DemoMain.COBALTBLUE = new THREE.Color(18347);
haxe_crypto_Base64.CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
haxe_crypto_Base64.BYTES = haxe_io_Bytes.ofString(haxe_crypto_Base64.CHARS);
haxe_ds_ObjectMap.count = 0;
js_Boot.__toStr = ({ }).toString;
js_html_compat_Float32Array.BYTES_PER_ELEMENT = 4;
js_html_compat_Uint8Array.BYTES_PER_ELEMENT = 1;
wl_core_Assets._assets = new haxe_ds_StringMap();
wl_core_Config.BEATS_PER_MINUTE = 104;
wl_core_Config.BEATS_PER_BAR = 4;
wl_core_Config.TICKS_PER_BEAT = 12;
wl_core_Config.MUSIC_BEGIN = 500;
wl_core_Config.SONG_PATH = "bg.ogg";
wl_core_Config.ENABLE_FFT = false;
wl_core_Config.MUTED = false;
wl_core_Config.FPS = 24;
wl_core_Config.RESOLUTION = [1280,720];
wl_core_Config.RATIO = 1.7777777777777777;
wl_core_Config.ANTIALIAS = true;
wl_core_Config.ENABLE_SHADOWS = false;
wl_core_Config.CLEAR_COLOR = 0;
wl_core_Config.SHADOW_MAP_SIZE = [512,512];
wl_core_Config.SEED = 123;
wl_core_Config.DEBUG = false;
wl_core_Config.TIMELINE = [];
wl_core_TimeSig.ABSOLUTE = "absolute";
wl_core_TimeSig.RELATIVE = "relative";
wl_core_TimeSig.PATTERN = "pattern";
wl_debug_Debug.paused = false;
wl_debug_Debug.usedFolderNames = [];
wl_debug_ManualControl.parts = [];
wl_debug_ManualControl.storedPoints = [];
wl_debug_ManualControl.fpsControls = [];
wl_demo_CameraController.STOPPED = false;
wl_demo_CameraController.STATIC = "static";
wl_demo_CameraController.LINEAR = "linear";
wl_demo_CameraController.BEZIER = "bezier";
wl_demo_CameraController.FOLLOW = "follow";
wl_post_bloom_Bloom.BlurDirectionX = new THREE.Vector2(1.0,0.0);
wl_post_bloom_Bloom.BlurDirectionY = new THREE.Vector2(0.0,1.0);
wl_sounds_SoundWL.FFT_PRECISION = 1024;
wl_sounds_SoundWL.onSoundLoaded = new wl_core_Signal();
wl_sounds_SoundWL.onSoundComplete = new wl_core_Signal();
wl_sounds_SoundWL.onSoundReady = new wl_core_Signal();
wl_sounds_SoundWL.time = new wl_core_TimeSig();
wl_sounds_SoundWL.volume = 1;
wl_sounds_SoundWL.startTime = 0;
wl_sounds_SoundWL.loaded = false;
wl_sounds_SoundWL.lastFFT = 0;
wl_sounds_SoundWL.FFT = { db : null, frequency : null, waveform : null, fftsize : 1024, sampleRate : 44100};
wl_util_Random.instance = new wl_util_Random(123);
Main.main();
})(typeof exports != "undefined" ? exports : typeof window != "undefined" ? window : typeof self != "undefined" ? self : this, typeof window != "undefined" ? window : typeof global != "undefined" ? global : typeof self != "undefined" ? self : this);
