// Generated by Haxe 3.3.0
(function ($hx_exports, $global) { "use strict";
$hx_exports["wl"] = $hx_exports["wl"] || {};
$hx_exports["kvg"] = $hx_exports["kvg"] || {};
$hx_exports["kvg"]["core"] = $hx_exports["kvg"]["core"] || {};
var $estr = function() { return js_Boot.__string_rec(this,''); };
function $extend(from, fields) {
	function Inherit() {} Inherit.prototype = from; var proto = new Inherit();
	for (var name in fields) proto[name] = fields[name];
	if( fields.toString !== Object.prototype.toString ) proto.toString = fields.toString;
	return proto;
}
var wl_core_Signal = function() {
	this.callbacks = [];
};
wl_core_Signal.__name__ = ["wl","core","Signal"];
wl_core_Signal.prototype = {
	connect: function(callback) {
		this.callbacks.push(callback);
	}
	,disconnect: function(callback) {
		HxOverrides.remove(this.callbacks,callback);
	}
	,emit: function(param) {
		var _g = 0;
		var _g1 = this.callbacks;
		while(_g < _g1.length) {
			var cb = _g1[_g];
			++_g;
			cb(param);
		}
	}
	,__class__: wl_core_Signal
};
var DemoMain = function() {
};
DemoMain.__name__ = ["DemoMain"];
DemoMain.setup = function() {
	wl_core_Config.SONG_PATH = "Konvergence_Koherent_soundtrack_minomus.mp3";
	wl_core_Config.BEATS_PER_MINUTE = 173;
	wl_core_Config.MUSIC_BEGIN = new wl_core_TimeSig(0,0,0,0).toMilliseconds();
	wl_core_Config.FPS = -1;
	wl_core_Config.ENABLE_SHADOWS = true;
	wl_core_Config.DEBUG = false;
	wl_core_Config.ENABLE_FFT = true;
	wl_core_Config.TIMELINE = [new wl_demo_TimeLine(new jalava_PartIntro(),new wl_core_TimeSig(0),new wl_core_TimeSig(32),null,true),new wl_demo_TimeLine(new hexagonfield_HexagonField(),new wl_core_TimeSig(32),new wl_core_TimeSig(48),"HexagonField",true),new wl_demo_TimeLine(new windows_Windows(),new wl_core_TimeSig(48),new wl_core_TimeSig(64),"Windows",true),new wl_demo_TimeLine(new jalava_Greetings(),new wl_core_TimeSig(64),new wl_core_TimeSig(76),null,true),new wl_demo_TimeLine(new transition1_KleinCube(),new wl_core_TimeSig(76),new wl_core_TimeSig(114,2)),new wl_demo_TimeLine(new endlogo_EndLogo(),new wl_core_TimeSig(114,2),new wl_core_TimeSig(128),"EndLogo",true)];
	DemoMain.font = new THREE.Font( JSON.parse( window.demofont.substring( 65, window.demofont.length - 2 ) ));
};
DemoMain.prototype = {
	__class__: DemoMain
};
var HxOverrides = function() { };
HxOverrides.__name__ = ["HxOverrides"];
HxOverrides.cca = function(s,index) {
	var x = s.charCodeAt(index);
	if(x != x) {
		return undefined;
	}
	return x;
};
HxOverrides.substr = function(s,pos,len) {
	if(len == null) {
		len = s.length;
	} else if(len < 0) {
		if(pos == 0) {
			len = s.length + len;
		} else {
			return "";
		}
	}
	return s.substr(pos,len);
};
HxOverrides.remove = function(a,obj) {
	var i = a.indexOf(obj);
	if(i == -1) {
		return false;
	}
	a.splice(i,1);
	return true;
};
HxOverrides.iter = function(a) {
	return { cur : 0, arr : a, hasNext : function() {
		return this.cur < this.arr.length;
	}, next : function() {
		return this.arr[this.cur++];
	}};
};
var Main = function() { };
Main.__name__ = ["Main"];
Main.main = function() {
	$(window).ready(Main.windowReady);
};
Main.windowReady = function(e) {
	DemoMain.setup();
	$("#setup").css("display","none");
	Main.demo = new wl_core_Demo();
	if(!wl_core_Config.DEBUG) {
		$(".debug").css("display","none");
		$("#debug").find("input").attr("checked",null);
		$(".checkbox").css("display","none");
	}
	wl_sounds_SoundWL.onSoundLoaded.connect(Main.onSoundLoaded);
	wl_sounds_SoundWL.init();
};
Main.onSoundLoaded = function() {
	$("#setup").css("display","");
	wl_setup_Setup.init(Main.demo);
};
Math.__name__ = ["Math"];
var Reflect = function() { };
Reflect.__name__ = ["Reflect"];
Reflect.field = function(o,field) {
	try {
		return o[field];
	} catch( e ) {
		return null;
	}
};
Reflect.fields = function(o) {
	var a = [];
	if(o != null) {
		var hasOwnProperty = Object.prototype.hasOwnProperty;
		for( var f in o ) {
		if(f != "__id__" && f != "hx__closures__" && hasOwnProperty.call(o,f)) {
			a.push(f);
		}
		}
	}
	return a;
};
var Std = function() { };
Std.__name__ = ["Std"];
Std.string = function(s) {
	return js_Boot.__string_rec(s,"");
};
var StringTools = function() { };
StringTools.__name__ = ["StringTools"];
StringTools.replace = function(s,sub,by) {
	return s.split(sub).join(by);
};
var Type = function() { };
Type.__name__ = ["Type"];
Type.getClassName = function(c) {
	var a = c.__name__;
	if(a == null) {
		return null;
	}
	return a.join(".");
};
var wl_core_Part = function() {
	this.postProcessing = { };
	this.effects = [];
	this.autoClear = true;
	this.clearColor = "#000";
	this.generateDepthMap = true;
	this.renderToScreen = false;
	this.inTransition = false;
	this.running = false;
	this.isActive = false;
};
wl_core_Part.__name__ = ["wl","core","Part"];
wl_core_Part.prototype = {
	init: function() {
		this.triggers = new haxe_ds_ObjectMap();
		if(this.generateDepthMap) {
			this.depthMap = wl_core_Graphics.instance.getRenderTarget();
		}
		this.renderTo = wl_core_Graphics.instance.getRenderTarget();
		this.effects = [];
	}
	,postInit: function() {
	}
	,setupDatGui: function(folder) {
	}
	,start: function(ts) {
		this.running = true;
	}
	,stop: function() {
		this.running = false;
	}
	,setRenderToScreen: function(value) {
		this.renderToScreen = value;
	}
	,update: function(ts,partial,frameTime) {
	}
	,render: function(ts,frameTime) {
		var r = wl_core_Graphics.instance.renderer;
		if(this.generateDepthMap) {
			r.autoClear = true;
			r.setClearColor(0,1.0);
			this.scene.overrideMaterial = wl_core_Graphics.instance.depthMaterial;
			wl_core_Graphics.instance.renderer.render(this.scene,this.camera,this.depthMap);
			this.scene.overrideMaterial = null;
		}
		r.autoClear = true;
		r.setClearColor(0,1.0);
		if(this.composer != null) {
			this.composer.render();
		} else {
			wl_core_Graphics.instance.renderer.render(this.scene,this.camera,this.renderTo);
		}
	}
	,addTrigger: function(timesig,handler) {
		if(this.triggers.h.__keys__[timesig.__id__] != null) {
			this.triggers.h[timesig.__id__].push(handler);
		} else {
			this.triggers.set(timesig,[handler]);
		}
	}
	,removeTrigger: function(handler,timesig) {
		if(timesig != null && this.triggers.h.__keys__[timesig.__id__] != null) {
			HxOverrides.remove(this.triggers.h[timesig.__id__],handler);
		} else {
			var tmp = this.triggers.iterator();
			while(tmp.hasNext()) HxOverrides.remove(tmp.next(),handler);
		}
	}
	,addEffect: function(effect) {
		this.effects.push(effect);
	}
	,initStandardScene: function() {
		this.scene = new THREE.Scene();
		this.camera = new THREE.PerspectiveCamera(30,wl_core_Config.RESOLUTION[0] / wl_core_Config.RESOLUTION[1],0.1,1000);
		this.camera.position.y = 0;
		this.camera.position.x = 0;
		this.camera.position.z = 500;
		this.camera.lookAt(new THREE.Vector3(0,0,0));
		this.scene.autoUpdate = true;
		this.scene.add(this.camera);
		wl_debug_ManualControl.attachPart(this);
	}
	,getComposerList: function(post) {
		var list = [];
		if(post.dof) {
			list.push(this.postProcessing.dof = new wl_post_dof_DoF(this.depthMap.texture,this.camera));
		}
		if(post.bloom) {
			list.push(this.postProcessing.bloom = new wl_post_bloom_Bloom());
		}
		if(post.rgbShift) {
			list.push(this.postProcessing.rgbShift = new wl_post_rgbshift_RGBShift());
		}
		if(post.colorHilight) {
			list.push(this.postProcessing.colorHilight = new wl_post_colorhilight_ColorHilight());
		}
		if(post.pixelate) {
			list.push(this.postProcessing.pixelate = new wl_post_pixelate_Pixelate());
		}
		if(post.distortedTV) {
			list.push(this.postProcessing.distortedTV = new wl_post_distortedTv_DistortedTv());
		}
		if(post.standard) {
			list.push(this.postProcessing.standard = new wl_post_standard_StandardShader());
		}
		if(post.displacement) {
			list.push(this.postProcessing.displacement = new wl_post_displacement_Displacement(wl_core_Assets.getTexture("perlin-512.png")));
		}
		return list;
	}
	,initComposer: function(postprocessingList,preventCopy,preventRender) {
		if(postprocessingList == null) {
			postprocessingList = this.getComposerList({ });
		}
		var g = wl_core_Graphics.instance;
		this.composer = new THREE.EffectComposer(g.renderer,this.renderTo);
		if(!preventRender) {
			this.renderPass = new THREE.RenderPass(this.scene,this.camera,null,0,0);
			this.composer.addPass(this.renderPass);
		}
		var _g = 0;
		while(_g < postprocessingList.length) {
			var pass = postprocessingList[_g];
			++_g;
			this.composer.addPass(pass);
		}
		if(!preventCopy) {
			this.copyPass = new THREE.ShaderPass(THREE.CopyShader);
			this.copyPass.renderToScreen = false;
			this.composer.addPass(this.copyPass);
		}
	}
	,__class__: wl_core_Part
};
var cubes_Cubes = function() {
	this.yspeed = 0;
	this.xspeed = 0;
	wl_core_Part.call(this);
};
cubes_Cubes.__name__ = ["cubes","Cubes"];
cubes_Cubes.__super__ = wl_core_Part;
cubes_Cubes.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.initComposer(this.getComposerList({ dof : true, bloom : true}));
		var pl = this.spotlight = new THREE.PointLight(16748592,0.3,80,0.4);
		pl.position.x = -10;
		pl.position.y = -10;
		pl.position.z = -20;
		this.scene.add(pl);
		var pl2 = this.spotlight2 = new THREE.PointLight(65424,0.2,80,1.0);
		pl2.position.x = 20;
		pl2.position.y = 20;
		pl2.position.z = -35;
		this.scene.add(pl2);
		this.camera.position.z = 0;
		this.camera.position.x = 0;
		this.camera.position.y = 40;
		this.camera.lookAt(new THREE.Vector3(0,0,0));
		this.scene.add(this.camera);
		this.addTrigger(new wl_core_TimeSig(-1,0,-1,-1,wl_core_TimeSig.PATTERN),$bind(this,this.onBeatTrigger));
		this.addTrigger(new wl_core_TimeSig(-1,-1,0,-1,wl_core_TimeSig.PATTERN),$bind(this,this.perBeat));
		var materialProps = { };
		this.boxMaterial = new THREE.MeshPhongMaterial(materialProps);
		this.box = new THREE.Mesh(new THREE.BoxGeometry(10,10,10),this.boxMaterial);
		this.scene.add(this.box);
	}
	,perBeat: function(t) {
		this.spotlight.color = new THREE.Color(Math.floor(Math.random() * 16777215));
		this.spotlight2.color = new THREE.Color(Math.floor(Math.random() * 16777215));
		this.postProcessing.dof.uniforms.focus.value = 0.1 + Math.random();
	}
	,updateEmissive: function() {
		this.boxMaterial.emissive = new THREE.Color(Math.floor(this.boxEmissive * 25));
	}
	,onBeatTrigger: function(t) {
		this.box.scale.x = this.box.scale.y = this.box.scale.z = 1.2;
		createjs.Tween.get(this.box.scale).to({ x : 1, y : 1, z : 1},wl_core_TimeSig.milliseconds(0,3,0,0),createjs.Ease.none);
		this.xspeed = Math.random() * 0.02 - 0.01;
		this.yspeed = Math.random() * 0.02 - 0.01;
		createjs.Tween.get(this).to({ xspeed : 0, yspeed : 0},wl_core_TimeSig.milliseconds(0,4,0,0),createjs.Ease.none);
		this.boxEmissive = 1;
		this.updateEmissive();
		createjs.Tween.get(this,{ onChange : $bind(this,this.updateEmissive)}).to({ boxEmissive : 0},wl_core_TimeSig.milliseconds(0,3,2,0));
	}
	,update: function(ts,partial,frameTime) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime);
		this.box.rotateX(this.xspeed);
		this.box.rotateY(this.yspeed);
	}
	,render: function(ts,frameTime) {
		wl_core_Part.prototype.render.call(this,ts,frameTime);
	}
	,__class__: cubes_Cubes
});
var endlogo_CubeWormEnd = function(geometry) {
	this.lastspawn = 0;
	this.pointHistory = [];
	this.cur = 0;
	THREE.Object3D.call(this);
	this.geometry = geometry;
	this.initializeControls();
};
endlogo_CubeWormEnd.__name__ = ["endlogo","CubeWormEnd"];
endlogo_CubeWormEnd.__super__ = THREE.Object3D;
endlogo_CubeWormEnd.prototype = $extend(THREE.Object3D.prototype,{
	initializeControls: function() {
		this.cubes = [];
		var params = { };
		params.color = 16777215;
		this.material = new THREE.MeshBasicMaterial(params);
		var _g = 0;
		while(_g < 200) {
			++_g;
			var m = new THREE.Mesh(this.geometry,this.material);
			this.add(m);
			m.visible = false;
			this.cubes.push(m);
		}
	}
	,start: function(ts) {
		this.lastspawn = ts.toMilliseconds();
	}
	,postinit: function() {
		this.material.envMap = wl_core_Demo.instance.getPart("Windows").cubecam.renderTarget.texture;
	}
	,spawn: function(position) {
		this.pointHistory.push(position);
		this.cur = (this.cur + 1) % this.cubes.length;
		var next = this.cubes[this.cur];
		next.position.copy(position);
		next.position.rndx = wl_util_Random.nextFloat() - 0.5;
		next.position.rndz = wl_util_Random.nextFloat() - 0.5;
		next.position.rndy = wl_util_Random.nextFloat() - 0.5;
		next.position.x += next.position.rndx;
		next.position.y += next.position.rndy;
		next.position.z += next.position.rndz;
		next.rotateX(wl_util_Random.nextFloat() * Math.PI);
		next.rotateY(wl_util_Random.nextFloat() * Math.PI);
		next.scale.x = next.scale.y = next.scale.z = 0.001;
		var ns = wl_util_Random.nextFloat() * 0.5 + 0.5;
		createjs.Tween.get(next.scale).to({ x : ns, y : ns, z : ns},wl_core_TimeSig.milliseconds(0,2,0,0),createjs.Ease.getBackOut(2));
		next.visible = true;
	}
	,tick: function(position,delta,ts) {
		while(ts - this.lastspawn > 30) {
			this.lastspawn = ts;
			this.spawn(position);
		}
		var _g = 0;
		var _g1 = this.cubes;
		while(_g < _g1.length) {
			var c = _g1[_g];
			++_g;
			c.rotateX(delta * 0.02 * c.scale.x);
			c.rotateY(-delta * 0.01);
		}
	}
	,__class__: endlogo_CubeWormEnd
});
var endlogo_EndLogo = function() {
	this.timesum = 0;
	this.logocolor = 0;
	this.endlook = new THREE.Vector3(-27.95,10.37,-28);
	this.followDivider = 0;
	this.campos = new THREE.Vector3();
	wl_core_Part.call(this);
};
endlogo_EndLogo.__name__ = ["endlogo","EndLogo"];
endlogo_EndLogo.__super__ = wl_core_Part;
endlogo_EndLogo.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.initComposer(this.getComposerList({ standard : true, bloom : true}));
		var logoGeo = new THREE.PlaneGeometry(1,0.5625);
		this.logoCredits = new THREE.Mesh(new THREE.PlaneGeometry(0.8,0.2),new THREE.MeshBasicMaterial({ transparent : true, color : 16777215, map : wl_core_Assets.getTexture("creditstransparent.png"), side : THREE.DoubleSide}));
		this.logoCredits.scale.setY(-1);
		this.logoCredits.material.opacity = 0;
		this.logoCredits.position.x = 0.5;
		this.logoCredits.position.y = 0.9 * wl_core_Config.RESOLUTION[1] / wl_core_Config.RESOLUTION[0];
		this.logo = new THREE.Mesh(logoGeo,new THREE.MeshBasicMaterial({ transparent : true, color : 16777215, map : wl_core_Assets.getTexture("koherent_final_fg.png"), side : THREE.DoubleSide}));
		this.logoBg = new THREE.Mesh(logoGeo,new THREE.MeshBasicMaterial({ transparent : true, color : 16777215, map : wl_core_Assets.getTexture("koherent_final_bg.png"), side : THREE.DoubleSide}));
		this.logoBg.position.z = -5;
		this.logo.material.opacity = 0;
		this.logo.position.x = 0.5;
		this.logo.position.y = 0.28125;
		this.logo.scale.setY(-1);
		this.logoBg.material.opacity = 0;
		this.logoBg.position.x = 0.5;
		this.logoBg.position.y = 0.28125;
		this.logoBg.scale.setY(-1);
		this.logoBg.material.opacity = 0;
		this.scene.add(new THREE.Mesh(new THREE.BoxGeometry(1000,1000,1000),new THREE.MeshBasicMaterial({ color : DemoMain.SURFACE.getHex(), side : THREE.DoubleSide})));
		this.addTrigger(new wl_core_TimeSig(8,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.fadelogoin));
		this.addTrigger(new wl_core_TimeSig(10,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.fadeout));
		this.addTrigger(new wl_core_TimeSig(126,0,0,0,wl_core_TimeSig.ABSOLUTE),$bind(this,this.fadenamein));
		this.camera.position.z = 0;
		this.camera.position.y = 0;
		this.camera.position.x = 0;
		this.camera.lookAt(new THREE.Vector3(0,0,0));
		this.postProcessing.bloom.strength = 0.14;
		this.addTrigger(new wl_core_TimeSig(2,0,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.onbar));
		this.wormPosition = new THREE.Object3D();
		this.wormPath = new wl_demo_CameraController(this.wormPosition);
		this.wormPath.initBezier([new THREE.Vector3(-10.04,23.29,96.78),new THREE.Vector3(-10.62,23.09,73.79),new THREE.Vector3(-2.63,22.53,49.07),new THREE.Vector3(-6.87,27.65,21.08),new THREE.Vector3(24.43,30.77,38.06),new THREE.Vector3(40.97,24.35,56.07),new THREE.Vector3(71.6,27.12,49.72),new THREE.Vector3(90.67,46.95,64.95),new THREE.Vector3(55.78,49.69,62.1),new THREE.Vector3(35.46,38.4,45.4),new THREE.Vector3(8.67,28.36,54.63),new THREE.Vector3(-18.37,22.48,58.06),new THREE.Vector3(-42.15,29.68,46.25),new THREE.Vector3(-72.82,27.78,50.5),new THREE.Vector3(-79.33,25.03,74.09),new THREE.Vector3(-38.15,31.88,94.36),new THREE.Vector3(-5.95,25.3,99.08),new THREE.Vector3(-9.31,19.56,74.5),new THREE.Vector3(-38.13,19.75,50.9),new THREE.Vector3(-52.35,21.15,28.01),new THREE.Vector3(-57.07,20.43,1.95),new THREE.Vector3(-55.08,19.48,-28.94),new THREE.Vector3(-44.87,19.03,-53.7),new THREE.Vector3(-26.51,18.89,-71.92),new THREE.Vector3(-1.69,19.51,-82.12),new THREE.Vector3(24.12,20.74,-83.39),new THREE.Vector3(50.58,22.07,-74.93),new THREE.Vector3(70.71,22.63,-58.66)],[new THREE.Vector3(2.22,24.6,-3.19),new THREE.Vector3(1.5,21.78,-26.2),new THREE.Vector3(-20.42,21.66,-49.33),new THREE.Vector3(-1.88,57.31,-74.29),new THREE.Vector3(97.62,-6.29,95.24),new THREE.Vector3(140.06,11.3,52.61),new THREE.Vector3(163.98,65.39,50.93),new THREE.Vector3(35.41,90,136.31),new THREE.Vector3(-16.53,12.23,4.07),new THREE.Vector3(-62.41,19.75,36.84),new THREE.Vector3(-58.8,-24.26,106.4),new THREE.Vector3(-105.69,16.81,9.66),new THREE.Vector3(-128.73,73.12,21.43),new THREE.Vector3(-154.45,-5.6,97.63),new THREE.Vector3(17.8,31.57,51.22),new THREE.Vector3(58.7,54.8,84.61),new THREE.Vector3(72.62,0.26,42.52),new THREE.Vector3(-101.6,9.97,37.21),new THREE.Vector3(-96.82,25.42,-29.87),new THREE.Vector3(-101.55,25.51,-58.94),new THREE.Vector3(-57.95,17.37,-98),new THREE.Vector3(-37.72,16.43,-127.37),new THREE.Vector3(11.05,18.6,-136.61),new THREE.Vector3(56.39,18.46,-127.84),new THREE.Vector3(96.03,23.87,-102.89),new THREE.Vector3(123.37,25.53,-72.09),new THREE.Vector3(137.79,25.12,-26.09),new THREE.Vector3(138.26,24.38,15.06)]);
		this.worm = new endlogo_CubeWormEnd(new THREE.BoxGeometry(10,10,10));
		this.scene.add(this.worm);
		this.addTrigger(new wl_core_TimeSig(6,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.slowworm));
	}
	,slowworm: function(ts) {
		createjs.Tween.get(this).to({ followDivider : 1},wl_core_TimeSig.milliseconds(2,0,0,0));
	}
	,postInit: function() {
		this.worm.postinit();
		wl_core_Part.prototype.postInit.call(this);
	}
	,onbar: function(ts) {
	}
	,fadelogoin: function(ts) {
		createjs.Tween.get(this,{ onChange : $bind(this,this.updateLogoColor)}).to({ logocolor : 1},wl_core_TimeSig.milliseconds(2,0,0,0));
	}
	,fadenamein: function(ts) {
		createjs.Tween.get(this.logoCredits.material).to({ opacity : 1},wl_core_TimeSig.milliseconds(0,3,0,0));
	}
	,fadeout: function(ts) {
		createjs.Tween.get(this.postProcessing.standard.uniforms.brightness).to({ value : -1},wl_core_TimeSig.milliseconds(2,0,0,0));
	}
	,updateLogoColor: function() {
		this.logoBg.material.opacity = this.logocolor;
		Math.floor(this.logocolor * 255);
	}
	,start: function(ts) {
		wl_core_Part.prototype.start.call(this,ts);
		createjs.Tween.get(this.logo.material).wait(wl_core_TimeSig.milliseconds(1,2,0,0)).to({ opacity : 1},wl_core_TimeSig.milliseconds(2,0,0,0));
		this.logo.material.opacity = 1;
		this.wormPath.update(0);
		this.campos.copy(this.wormPosition.position);
		wl_core_Demo.instance.overlay.add(this.logo);
		wl_core_Demo.instance.overlay.add(this.logoBg);
		wl_core_Demo.instance.overlay.add(this.logoCredits);
	}
	,update: function(ts,partial,frameTime) {
		this.wormPath.update(partial * 1.5);
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime);
	}
	,render: function(ts,frameTime) {
		var delta = frameTime / 16.666666666666668;
		var finalLook = this.wormPosition.position.clone().lerp(this.endlook,this.followDivider);
		this.campos.x += (finalLook.x - this.campos.x) / 80 * delta;
		this.campos.y += (finalLook.y - this.campos.y) / 80 * delta;
		this.campos.z += (finalLook.z - this.campos.z) / 80 * delta;
		this.camera.lookAt(this.campos);
		this.timesum += delta;
		this.worm.tick(this.wormPosition.position,delta,ts.toMilliseconds());
		wl_core_Part.prototype.render.call(this,ts,frameTime);
	}
	,__class__: endlogo_EndLogo
});
var haxe_IMap = function() { };
haxe_IMap.__name__ = ["haxe","IMap"];
var haxe_Resource = function() { };
haxe_Resource.__name__ = ["haxe","Resource"];
haxe_Resource.getString = function(name) {
	var _g = 0;
	var _g1 = haxe_Resource.content;
	while(_g < _g1.length) {
		var x = _g1[_g];
		++_g;
		if(x.name == name) {
			if(x.str != null) {
				return x.str;
			}
			return haxe_crypto_Base64.decode(x.data).toString();
		}
	}
	return null;
};
var haxe_Timer = function(time_ms) {
	var me = this;
	this.id = setInterval(function() {
		me.run();
	},time_ms);
};
haxe_Timer.__name__ = ["haxe","Timer"];
haxe_Timer.delay = function(f,time_ms) {
	var t = new haxe_Timer(time_ms);
	t.run = function() {
		t.stop();
		f();
	};
	return t;
};
haxe_Timer.prototype = {
	stop: function() {
		if(this.id == null) {
			return;
		}
		clearInterval(this.id);
		this.id = null;
	}
	,run: function() {
	}
	,__class__: haxe_Timer
};
var haxe_io_Bytes = function(data) {
	this.length = data.byteLength;
	this.b = new Uint8Array(data);
	this.b.bufferValue = data;
	data.hxBytes = this;
	data.bytes = this.b;
};
haxe_io_Bytes.__name__ = ["haxe","io","Bytes"];
haxe_io_Bytes.ofString = function(s) {
	var a = [];
	var i = 0;
	while(i < s.length) {
		var c = s.charCodeAt(i++);
		if(55296 <= c && c <= 56319) {
			c = c - 55232 << 10 | s.charCodeAt(i++) & 1023;
		}
		if(c <= 127) {
			a.push(c);
		} else if(c <= 2047) {
			a.push(192 | c >> 6);
			a.push(128 | c & 63);
		} else if(c <= 65535) {
			a.push(224 | c >> 12);
			a.push(128 | c >> 6 & 63);
			a.push(128 | c & 63);
		} else {
			a.push(240 | c >> 18);
			a.push(128 | c >> 12 & 63);
			a.push(128 | c >> 6 & 63);
			a.push(128 | c & 63);
		}
	}
	return new haxe_io_Bytes(new Uint8Array(a).buffer);
};
haxe_io_Bytes.prototype = {
	getString: function(pos,len) {
		if(pos < 0 || len < 0 || pos + len > this.length) {
			throw new js__$Boot_HaxeError(haxe_io_Error.OutsideBounds);
		}
		var s = "";
		var b = this.b;
		var fcc = String.fromCharCode;
		var i = pos;
		var max = pos + len;
		while(i < max) {
			var c = b[i++];
			if(c < 128) {
				if(c == 0) {
					break;
				}
				s += fcc(c);
			} else if(c < 224) {
				s += fcc((c & 63) << 6 | b[i++] & 127);
			} else if(c < 240) {
				s += fcc((c & 31) << 12 | (b[i++] & 127) << 6 | b[i++] & 127);
			} else {
				var u = (c & 15) << 18 | (b[i++] & 127) << 12 | (b[i++] & 127) << 6 | b[i++] & 127;
				s += fcc((u >> 10) + 55232);
				s += fcc(u & 1023 | 56320);
			}
		}
		return s;
	}
	,toString: function() {
		return this.getString(0,this.length);
	}
	,__class__: haxe_io_Bytes
};
var haxe_crypto_Base64 = function() { };
haxe_crypto_Base64.__name__ = ["haxe","crypto","Base64"];
haxe_crypto_Base64.decode = function(str,complement) {
	if(complement == null) {
		complement = true;
	}
	if(complement) {
		while(HxOverrides.cca(str,str.length - 1) == 61) str = HxOverrides.substr(str,0,-1);
	}
	return new haxe_crypto_BaseCode(haxe_crypto_Base64.BYTES).decodeBytes(haxe_io_Bytes.ofString(str));
};
var haxe_crypto_BaseCode = function(base) {
	var len = base.length;
	var nbits = 1;
	while(len > 1 << nbits) ++nbits;
	if(nbits > 8 || len != 1 << nbits) {
		throw new js__$Boot_HaxeError("BaseCode : base length must be a power of two.");
	}
	this.base = base;
	this.nbits = nbits;
};
haxe_crypto_BaseCode.__name__ = ["haxe","crypto","BaseCode"];
haxe_crypto_BaseCode.prototype = {
	initTable: function() {
		var tbl = [];
		var _g = 0;
		while(_g < 256) tbl[_g++] = -1;
		var _g1 = 0;
		var _g2 = this.base.length;
		while(_g1 < _g2) {
			var i = _g1++;
			tbl[this.base.b[i]] = i;
		}
		this.tbl = tbl;
	}
	,decodeBytes: function(b) {
		var nbits = this.nbits;
		if(this.tbl == null) {
			this.initTable();
		}
		var tbl = this.tbl;
		var size = b.length * nbits >> 3;
		var out = new haxe_io_Bytes(new ArrayBuffer(size));
		var buf = 0;
		var curbits = 0;
		var pin = 0;
		var pout = 0;
		while(pout < size) {
			while(curbits < 8) {
				curbits += nbits;
				buf <<= nbits;
				var i = tbl[b.b[pin++]];
				if(i == -1) {
					throw new js__$Boot_HaxeError("BaseCode : invalid encoded char");
				}
				buf |= i;
			}
			curbits -= 8;
			out.b[pout++] = buf >> curbits & 255 & 255;
		}
		return out;
	}
	,__class__: haxe_crypto_BaseCode
};
var haxe_ds_ObjectMap = function() {
	this.h = { __keys__ : { }};
};
haxe_ds_ObjectMap.__name__ = ["haxe","ds","ObjectMap"];
haxe_ds_ObjectMap.__interfaces__ = [haxe_IMap];
haxe_ds_ObjectMap.prototype = {
	set: function(key,value) {
		var id = key.__id__ || (key.__id__ = ++haxe_ds_ObjectMap.count);
		this.h[id] = value;
		this.h.__keys__[id] = key;
	}
	,keys: function() {
		var a = [];
		for( var key in this.h.__keys__ ) {
		if(this.h.hasOwnProperty(key)) {
			a.push(this.h.__keys__[key]);
		}
		}
		return HxOverrides.iter(a);
	}
	,iterator: function() {
		return { ref : this.h, it : this.keys(), hasNext : function() {
			return this.it.hasNext();
		}, next : function() {
			var i = this.it.next();
			return this.ref[i.__id__];
		}};
	}
	,__class__: haxe_ds_ObjectMap
};
var haxe_ds_StringMap = function() {
	this.h = { };
};
haxe_ds_StringMap.__name__ = ["haxe","ds","StringMap"];
haxe_ds_StringMap.__interfaces__ = [haxe_IMap];
haxe_ds_StringMap.prototype = {
	setReserved: function(key,value) {
		if(this.rh == null) {
			this.rh = { };
		}
		this.rh["$" + key] = value;
	}
	,getReserved: function(key) {
		if(this.rh == null) {
			return null;
		} else {
			return this.rh["$" + key];
		}
	}
	,existsReserved: function(key) {
		if(this.rh == null) {
			return false;
		}
		return this.rh.hasOwnProperty("$" + key);
	}
	,__class__: haxe_ds_StringMap
};
var haxe_io_Error = { __ename__ : true, __constructs__ : ["Blocked","Overflow","OutsideBounds","Custom"] };
haxe_io_Error.Blocked = ["Blocked",0];
haxe_io_Error.Blocked.toString = $estr;
haxe_io_Error.Blocked.__enum__ = haxe_io_Error;
haxe_io_Error.Overflow = ["Overflow",1];
haxe_io_Error.Overflow.toString = $estr;
haxe_io_Error.Overflow.__enum__ = haxe_io_Error;
haxe_io_Error.OutsideBounds = ["OutsideBounds",2];
haxe_io_Error.OutsideBounds.toString = $estr;
haxe_io_Error.OutsideBounds.__enum__ = haxe_io_Error;
haxe_io_Error.Custom = function(e) { var $x = ["Custom",3,e]; $x.__enum__ = haxe_io_Error; $x.toString = $estr; return $x; };
var haxe_io_FPHelper = function() { };
haxe_io_FPHelper.__name__ = ["haxe","io","FPHelper"];
haxe_io_FPHelper.i32ToFloat = function(i) {
	var sign = 1 - (i >>> 31 << 1);
	var exp = i >>> 23 & 255;
	var sig = i & 8388607;
	if(sig == 0 && exp == 0) {
		return 0.0;
	}
	return sign * (1 + Math.pow(2,-23) * sig) * Math.pow(2,exp - 127);
};
haxe_io_FPHelper.floatToI32 = function(f) {
	if(f == 0) {
		return 0;
	}
	var af = f < 0?-f:f;
	var exp = Math.floor(Math.log(af) / 0.6931471805599453);
	if(exp < -127) {
		exp = -127;
	} else if(exp > 128) {
		exp = 128;
	}
	return (f < 0?-2147483648:0) | exp + 127 << 23 | Math.round((af / Math.pow(2,exp) - 1) * 8388608) & 8388607;
};
var hexagonfield_CubeWormField = function(geometry) {
	this.lastspawn = 0;
	this.pointHistory = [];
	this.cur = 0;
	THREE.Object3D.call(this);
	this.geometry = geometry;
	this.initializeControls();
};
hexagonfield_CubeWormField.__name__ = ["hexagonfield","CubeWormField"];
hexagonfield_CubeWormField.__super__ = THREE.Object3D;
hexagonfield_CubeWormField.prototype = $extend(THREE.Object3D.prototype,{
	initializeControls: function() {
		this.cubes = [];
		var params = { };
		params.color = DemoMain.HILIGHT.getHex();
		params.side = THREE.DoubleSide;
		this.material = new THREE.MeshBasicMaterial(params);
		var _g = 0;
		while(_g < 200) {
			var i = _g++;
			var m = new THREE.Mesh(this.geometry,this.material);
			this.add(m);
			m.visible = false;
			this.cubes.push(m);
		}
	}
	,start: function(ts) {
		this.lastspawn = ts.toMilliseconds();
	}
	,postinit: function() {
		wl_core_Demo.instance.getPart("Windows");
	}
	,spawn: function(position) {
		this.pointHistory.push(position);
		this.cur = (this.cur + 1) % this.cubes.length;
		var next = this.cubes[this.cur];
		next.position.copy(position);
		next.position.rndx = wl_util_Random.nextFloat() - 0.5;
		next.position.rndz = wl_util_Random.nextFloat() - 0.5;
		next.position.rndy = wl_util_Random.nextFloat() - 0.5;
		next.position.x += next.position.rndx;
		next.position.y += next.position.rndy;
		next.position.z += next.position.rndz;
		next.rotateX(wl_util_Random.nextFloat() * Math.PI);
		next.rotateY(wl_util_Random.nextFloat() * Math.PI);
		next.scale.x = next.scale.y = next.scale.z = 0.001;
		var ns = wl_util_Random.nextFloat() * 0.5 + 0.5;
		createjs.Tween.get(next.scale).to({ x : ns, y : ns, z : ns},wl_core_TimeSig.milliseconds(0,2,0,0),createjs.Ease.getBackOut(2));
		next.visible = true;
	}
	,tick: function(position,delta,ts) {
		while(ts - this.lastspawn > 30) {
			this.lastspawn = ts;
			this.spawn(position);
		}
		var _g = 0;
		var _g1 = this.cubes;
		while(_g < _g1.length) {
			var c = _g1[_g];
			++_g;
			c.rotateX(delta * 0.02 * c.scale.x);
			c.rotateY(-delta * 0.01);
		}
	}
	,__class__: hexagonfield_CubeWormField
});
var hexagonfield_HexagonField = function() {
	this.wormstartTimes = [];
	this.wormpositions = [];
	this.wormpaths = [];
	this.worms = [];
	this.wormtrigger = 0;
	this.lights = [];
	this.cellsize = 8;
	this.zrot = 0;
	this.hexgrid = [];
	this.hexes = [];
	this.cubecam = new THREE.CubeCamera(10,400,1024);
	wl_core_Part.call(this);
};
hexagonfield_HexagonField.__name__ = ["hexagonfield","HexagonField"];
hexagonfield_HexagonField.__super__ = wl_core_Part;
hexagonfield_HexagonField.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		var _gthis = this;
		this.cubecam.position.y = 20;
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.initComposer(this.getComposerList({ dof : true, bloom : true, displacement : true, standard : true}));
		this.spotlight = new THREE.SpotLight(DemoMain.SURFACE.getHex());
		this.spotlight.position.y = 700;
		this.spotlight.position.x = 200;
		this.spotlight.position.z = 200;
		this.spotlight.lookAt(new THREE.Vector3(200,0,250));
		this.scene.add(this.spotlight);
		this.scene.fog = new THREE.Fog(DemoMain.DARK2.getHex(),0,6000);
		this.camera.position.z = 0;
		this.camera.position.x = 0;
		this.camera.position.y = 100;
		this.postProcessing.bloom.strength = 1.8;
		this.postProcessing.bloom.threshold = 0.45;
		this.postProcessing.bloom.radius = 0.36;
		this.postProcessing.displacement.set_scaleX(0.005);
		this.postProcessing.displacement.set_zoom(5);
		this.addTrigger(new wl_core_TimeSig(-1,0,-1,-1,wl_core_TimeSig.PATTERN),$bind(this,this.onBeatTrigger));
		this.addTrigger(new wl_core_TimeSig(-1,-1,0,-1,wl_core_TimeSig.PATTERN),$bind(this,this.perBeat));
		this.hexmaterial = new THREE.MeshPhongMaterial({ color : DemoMain.DARK1.getHex()});
		this.nconFactory = new hexagonfield_NgonFactory(6,this.cellsize,20,this.hexmaterial,null);
		this.addTrigger(new wl_core_TimeSig(32,2,0,0,wl_core_TimeSig.ABSOLUTE),$bind(this,this.swoosh));
		this.addTrigger(new wl_core_TimeSig(38,2,0,0,wl_core_TimeSig.ABSOLUTE),$bind(this,this.swoosh));
		this.addTrigger(new wl_core_TimeSig(43,0,0,0,wl_core_TimeSig.ABSOLUTE),$bind(this,this.swoosh));
		this.addTrigger(new wl_core_TimeSig(46,2,0,0,wl_core_TimeSig.ABSOLUTE),$bind(this,this.swoosh));
		var zAmount = 68;
		var xAmount = 52;
		var minY = 0;
		var maxY = 20;
		var time = 1500;
		var peakAt = xAmount * zAmount / 10;
		var _g1 = 0;
		var _g = xAmount;
		while(_g1 < _g) {
			var x = _g1++;
			var row = [];
			var _g3 = 0;
			var _g2 = zAmount;
			while(_g3 < _g2) {
				var z = _g3++;
				var hex = { };
				var hexagon = this.nconFactory.CreateMesh();
				hexagon.position.x = this.cellsize * 3 * x + this.cellsize * 1.5 * (z % 2) - this.cellsize * xAmount;
				hexagon.position.z = this.cellsize * z - this.cellsize * zAmount / 2;
				var position = x * z % peakAt / peakAt * time;
				if(Math.ceil(x * z / peakAt) % 2 == 1) {
					position = (peakAt - x * z % peakAt) / peakAt * time;
				}
				hex.mesh = hexagon;
				hex.x = x;
				hex.z = z;
				this.hexes.push(hex);
				row.push(hex);
				if(x == xAmount / 2 && z == zAmount / 2) {
					this.target = hex.mesh.position.clone();
				}
				this.scene.add(hexagon);
			}
			this.hexgrid.push(row);
		}
		this.scene.add(this.camera);
		this.createLight(31,30);
		this.createLight(40,44);
		this.createLight(51,42);
		this.createLight(50,19);
		this.createLight(40,34);
		wl_debug_ManualControl.init();
		wl_debug_ManualControl.attachPart(this);
		this.lightHouseTarget = new THREE.Object3D();
		this.lightHouse = new THREE.SpotLight(DemoMain.WHITE.getHex(),2,1600,Math.PI / 180 * 10);
		this.lightHouse.target = this.lightHouseTarget;
		var pos = this.hexgrid[1][1].mesh.position;
		this.lightHouse.position.x = pos.x;
		this.lightHouse.position.z = pos.z;
		this.camera.eulerOrder = "YXZ";
		this.postProcessing.standard.set_brightness(1);
		this.addTrigger(new wl_core_TimeSig(1,2,0,0,wl_core_TimeSig.RELATIVE),function(ts) {
			_gthis.boostLight(0);
		});
		this.addTrigger(new wl_core_TimeSig(3,2,0,0,wl_core_TimeSig.RELATIVE),function(ts1) {
			_gthis.boostLight(1);
		});
		this.addTrigger(new wl_core_TimeSig(4,0,0,0,wl_core_TimeSig.RELATIVE),function(ts2) {
			_gthis.boostLight(2);
		});
		this.addTrigger(new wl_core_TimeSig(5,0,0,0,wl_core_TimeSig.RELATIVE),function(ts3) {
			_gthis.boostLight(3);
		});
		this.addTrigger(new wl_core_TimeSig(8,0,0,0,wl_core_TimeSig.RELATIVE),function(ts4) {
			_gthis.boostLight(4);
		});
		this.addTrigger(new wl_core_TimeSig(15,0,0,0,wl_core_TimeSig.RELATIVE),function(ts5) {
			_gthis.dimall();
		});
	}
	,start: function(ts) {
		wl_core_Part.prototype.start.call(this,ts);
		this.hexmaterial.emissive = DemoMain.HILIGHT;
		wl_core_Graphics.instance.renderer.setClearColor(DemoMain.HILIGHT,1);
		this.cubecam.updateCubeMap(wl_core_Graphics.instance.renderer,this.scene);
		wl_core_Graphics.instance.renderer.setClearColor(DemoMain.BLACK,0);
		this.hexmaterial.emissive = DemoMain.BLACK;
		createjs.Tween.get(this.postProcessing.standard.uniforms.brightness).to({ value : 0},wl_core_TimeSig.milliseconds(1,0,0,0),createjs.Ease.cubicOut);
		var _g = 0;
		var _g1 = this.worms;
		while(_g < _g1.length) {
			var w = _g1[_g];
			++_g;
			w.material.envMap = this.cubecam.renderTarget.texture;
		}
	}
	,dimall: function() {
		var _g = 0;
		var _g1 = this.lights;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			createjs.Tween.get(l).to({ intensity : 0, distance : 0},1000);
		}
		createjs.Tween.get(this.spotlight).to({ intensity : 0, distance : 0},1000);
	}
	,boostLight: function(l) {
		var _gthis = this;
		createjs.Tween.get(this.lights[l]).to({ intensity : 46},4000).call(function() {
			_gthis.wormtrigger++;
			var tmp = _gthis.lights[l];
			var tmp1 = Math.PI / 180 * 120;
			createjs.Tween.get(tmp).wait(500).to({ angle : tmp1, intensity : 0},6000);
		});
	}
	,createLight: function(x,z) {
		var sl = new THREE.SpotLight(DemoMain.HILIGHT.getHex(),0,600,Math.PI / 180 * 5,1,4);
		var hext = this.hexgrid[x][z];
		sl.position.x = hext.mesh.position.x;
		sl.position.z = hext.mesh.position.z;
		sl.position.y = 200;
		sl.target = hext.mesh;
		this.lights.push(sl);
		this.scene.add(sl);
		var wormposition = new THREE.Object3D();
		var wormPath = new wl_demo_CameraController(wormposition);
		wormPath.initLinear([new THREE.Vector3(hext.mesh.position.x,-15,hext.mesh.position.z),new THREE.Vector3(hext.mesh.position.x,250,hext.mesh.position.z)],[new THREE.Vector3(hext.mesh.position.x,-15,hext.mesh.position.z),new THREE.Vector3(hext.mesh.position.x,250,hext.mesh.position.z)]);
		var worm = new hexagonfield_CubeWormField(new THREE.BoxGeometry(15,15,15));
		this.scene.add(worm);
		this.worms.push(worm);
		this.wormpaths.push(wormPath);
		this.wormpositions.push(wormposition);
	}
	,postInit: function() {
		var _g = 0;
		var _g1 = this.worms;
		while(_g < _g1.length) {
			var w = _g1[_g];
			++_g;
			w.postinit();
		}
		wl_core_Part.prototype.postInit.call(this);
	}
	,perBeat: function(t) {
	}
	,updateEmissive: function() {
	}
	,swoosh: function(ts) {
		createjs.Tween.get(this.postProcessing.displacement.uniforms.scaleX).to({ value : 0.085},wl_core_TimeSig.milliseconds(1,0,0,0)).to({ value : 0.005},wl_core_TimeSig.milliseconds(1,0,0,0));
	}
	,onBeatTrigger: function(t) {
	}
	,update: function(ts,partial,frameTime) {
		if(this.wormtrigger > this.wormstartTimes.length) {
			this.wormstartTimes.push(partial);
		}
		var i = 0;
		var _g = 0;
		var _g1 = this.wormpaths;
		while(_g < _g1.length) {
			var w = _g1[_g];
			++_g;
			var start = this.wormstartTimes[i];
			++i;
			w.update((partial - start) / ((1 - partial) * 0.5));
		}
		wl_debug_ManualControl.update();
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime);
	}
	,render: function(ts,frameTime) {
		var mp = ts.toMilliseconds() - 3500;
		var _g = 0;
		var _g1 = this.hexes;
		while(_g < _g1.length) {
			var h = _g1[_g];
			++_g;
			var lerpval = Math.sin(Math.sin(h.z * 0.2 + mp * 0.003) + mp * 0.001 + 0.2 * (h.x + h.z % 2 * 0.5)) * 0.5 + 0.5;
			h.mesh.position.y = lerpval * Math.pow(Math.sin((h.x + 0.5 * (h.z % 2) + Math.cos(h.z * h.x)) * 0.2 + mp * 0.001),7) * 20 + (1 - lerpval) * Math.cos(h.x - h.z - mp * 0.0015) * 3 + Math.cos(-h.x - h.z + mp * 0.002) * 1.5;
		}
		var delta = frameTime / 16.666666666666668;
		var xposinc = 0.40524 * delta;
		var i = 0;
		var _g2 = 0;
		var _g11 = this.worms;
		while(_g2 < _g11.length) {
			var w = _g11[_g2];
			++_g2;
			if(this.wormtrigger - 1 >= i) {
				var tmp = ts.toMilliseconds();
				w.tick(this.wormpositions[i].position,delta,tmp);
			}
			++i;
		}
		this.camera.position.y = this.hexes[0].mesh.position.y + 31.5;
		this.camera.position.x += xposinc;
		this.target.x += xposinc;
		this.camera.lookAt(this.target);
		this.zrot += 0.01 * delta;
		this.camera.rotation.z = Math.sin(this.zrot) / 2.5;
		this.lightHouseTarget.position.z = Math.cos(this.zrot * 3) * 300 + this.lightHouse.position.z;
		this.lightHouseTarget.position.x = Math.sin(this.zrot * 3) * 300 + this.lightHouse.position.x;
		wl_core_Part.prototype.render.call(this,ts,frameTime);
	}
	,__class__: hexagonfield_HexagonField
});
var hexagonfield_NgonFactory = function(ngon,radius,height,material,extrudeSettings) {
	THREE.Object3D.call(this);
	this.ngon = ngon;
	this.radius = radius;
	if(extrudeSettings == null) {
		extrudeSettings = { amount : height, bevelEnabled : true, bevelSegments : 0, steps : 1, bevelSize : 0.0, bevelThickness : 0.0};
	} else {
		extrudeSettings = extrudeSettings;
	}
	var verts = [];
	var _g1 = 0;
	while(_g1 < ngon) verts.push(this.createVertex(_g1++));
	var cellShape = new THREE.Shape();
	cellShape.moveTo(verts[0].x,verts[0].y);
	var _g11 = 0;
	var _g = this.ngon;
	while(_g11 < _g) {
		var i = _g11++;
		cellShape.lineTo(verts[i].x,verts[i].y);
	}
	cellShape.lineTo(verts[0].x,verts[0].y);
	cellShape.autoClose = true;
	this.ngonGeometry = new THREE.ExtrudeGeometry(cellShape,extrudeSettings);
	this.ngonMaterial = material;
};
hexagonfield_NgonFactory.__name__ = ["hexagonfield","NgonFactory"];
hexagonfield_NgonFactory.__super__ = THREE.Object3D;
hexagonfield_NgonFactory.prototype = $extend(THREE.Object3D.prototype,{
	CreateMesh: function() {
		var mesh = new THREE.Mesh(this.ngonGeometry,this.ngonMaterial);
		mesh.rotateOnAxis(new THREE.Vector3(1,0,0),Math.PI / 2);
		return mesh;
	}
	,createVertex: function(i) {
		var angle = 2 * Math.PI / this.ngon * i;
		return new THREE.Vector3(this.radius * Math.cos(angle),this.radius * Math.sin(angle),0);
	}
	,__class__: hexagonfield_NgonFactory
});
var jalava_CubeParticles = function() {
	this.yspeed = 0.01;
	this.xspeed = 0.02;
	wl_core_Part.call(this);
};
jalava_CubeParticles.__name__ = ["jalava","CubeParticles"];
jalava_CubeParticles.__super__ = wl_core_Part;
jalava_CubeParticles.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.initComposer(this.getComposerList({ dof : false, bloom : false}));
		var res = wl_core_Assets.getTexture("sphere.jpg");
		var cubeText = new THREE.EquirectangularToCubemap(wl_core_Graphics.instance.renderer).convert(res,1024);
		this.mesh = new THREE.Mesh(new THREE.TorusKnotGeometry(150,40,100,32),new THREE.MeshBasicMaterial({ envMap : cubeText}));
		this.scene.add(this.mesh);
	}
	,update: function(ts,partial,frameTime) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime);
		this.mesh.rotateX(this.xspeed);
		this.mesh.rotateY(this.yspeed);
	}
	,__class__: jalava_CubeParticles
});
var jalava_Greetings = function() {
	this.first = false;
	this.textGeos = [];
	this.offsets = [5.4,8.4,7.3,12.3,5.3,7.8,9,13,4,10.7,6,9,4.5,7.4,8.4,6.3,4.0,9,8,9,7,4,8];
	this.greets = ["Adapt","Paraguay","Primitive","Ananasmurska","Epoch","Pyrotech","Byterapers","Artline designs","MFX","Matt Current","Alumni","Jumalauta","Xplsv","Kewlers","Outracks","Traction","ASD","Accession","Fairlight","Farbrausch","Mercury","ISO","Conspiracy"];
	this.yspeed = 0;
	this.xspeed = 0;
	wl_core_Part.call(this);
};
jalava_Greetings.__name__ = ["jalava","Greetings"];
jalava_Greetings.__super__ = wl_core_Part;
jalava_Greetings.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.initComposer(this.getComposerList({ dof : true, bloom : true, standard : true}));
		var pl = this.spotlight = new THREE.PointLight(DemoMain.HILIGHT.getHex(),0.6,80,0.4);
		pl.position.x = -10;
		pl.position.y = -10;
		pl.position.z = 30;
		this.scene.add(pl);
		var pl2 = this.spotlight2 = new THREE.PointLight(DemoMain.SURFACE.getHex(),0.4,80,1.0);
		pl2.position.x = 20;
		pl2.position.y = 20;
		pl2.position.z = 45;
		this.scene.add(pl2);
		this.camera.position.z = 40;
		this.camera.position.x = 0;
		this.camera.position.y = 0;
		this.camera.lookAt(new THREE.Vector3(0,0,0));
		this.scene.add(this.camera);
		this.postProcessing.bloom.strength = 3.37;
		this.postProcessing.bloom.radius = 0.93;
		this.postProcessing.bloom.threshold = 0.22;
		this.addTrigger(new wl_core_TimeSig(-1,0,-1,-1,wl_core_TimeSig.PATTERN),$bind(this,this.onBeatTrigger));
		this.addTrigger(new wl_core_TimeSig(-1,2,-1,-1,wl_core_TimeSig.PATTERN),$bind(this,this.onBeatTrigger));
		this.addTrigger(new wl_core_TimeSig(-1,-1,0,-1,wl_core_TimeSig.PATTERN),$bind(this,this.perBeat));
		this.addTrigger(new wl_core_TimeSig(75,3,0,0,wl_core_TimeSig.ABSOLUTE),$bind(this,this.endfadeout));
		this.boxMaterial = new THREE.MeshPhongMaterial({ color : DemoMain.SURFACE.getHex(), specular : DemoMain.HILIGHT.getHex(), shininess : 1});
		this.box = new THREE.Mesh(new THREE.BoxGeometry(50,5,5),this.boxMaterial);
		this.scene.add(this.box);
		var _g = 0;
		var _g1 = this.greets;
		while(_g < _g1.length) {
			var i = _g1[_g];
			++_g;
			var geo = new THREE.TextGeometry(i,{ font : DemoMain.font, size : 3, height : 1, curveSegments : 4, bevelThickness : 0.4, bevelSize : 0.2, bevelEnabled : true, material : 0, extrudeMaterial : 1});
			this.textGeos.push(geo);
			geo.computeBoundingBox();
			geo.computeVertexNormals();
		}
		this.textGeo = this.textGeos[0];
		this.textMaterial = new THREE.MultiMaterial([new THREE.MeshPhongMaterial({ color : DemoMain.SURFACE.getHex(), shading : THREE.FlatShading}),new THREE.MeshPhongMaterial({ color : DemoMain.HILIGHT.getHex(), shading : THREE.SmoothShading})]);
		this.textMesh1 = new THREE.Mesh(this.textGeo,this.textMaterial);
		this.textMesh1.position.z = 10;
		this.textMesh1.position.x = -this.textGeo.boundingBox.max.x / 2;
		this.textMesh1.position.y = -this.textGeo.boundingBox.max.y / 2;
		this.textMesh1.rotation.x = 0;
		this.scene.add(this.textMesh1);
		this.textMesh1.visible = false;
	}
	,start: function(ts) {
		wl_core_Part.prototype.start.call(this,ts);
		this.first = true;
		console.log("start " + Std.string(ts));
		this.addTrigger(new wl_core_TimeSig(-1,3,-1,-1,wl_core_TimeSig.PATTERN),$bind(this,this.changeText));
		this.addTrigger(new wl_core_TimeSig(-1,1,-1,-1,wl_core_TimeSig.PATTERN),$bind(this,this.changeText));
	}
	,addfirst: function(ts) {
	}
	,endfadeout: function(ts) {
		createjs.Tween.get(this.postProcessing.standard.uniforms.brightness).to({ value : -5},wl_core_TimeSig.milliseconds(0,1,0,0));
	}
	,changeText: function(t) {
		if(t.bar < 64) {
			return;
		}
		if(this.textGeos.length > 0) {
			this.textMesh1.visible = true;
			this.textMesh1.geometry = this.textGeos.shift();
			var off = this.offsets.shift();
			this.textMesh1.position.x = 0 - off;
			if(this.textGeos.length == 0) {
				this.textMesh1.position.x = -off;
			}
			this.textMesh1.position.y = -this.textGeo.boundingBox.max.y / 2;
			this.textGeo.computeBoundingBox();
			this.textMesh1.scale.x = this.textMesh1.scale.y = this.textMesh1.scale.z = 1.05;
			createjs.Tween.get(this.textMesh1.scale).to({ x : 1, y : 1, z : 1},wl_core_TimeSig.milliseconds(0,1,0,0),createjs.Ease.linear);
		} else if(this.textMesh1.parent != null) {
			this.textMesh1.parent.remove(this.textMesh1);
		}
		this.first = false;
	}
	,perBeat: function(t) {
	}
	,updateEmissive: function() {
		this.boxMaterial.emissive = new THREE.Color(Math.floor(this.boxEmissive * 25));
	}
	,onBeatTrigger: function(t) {
		createjs.Tween.get(this.box.rotation).to({ x : this.box.rotation.x + Math.PI / 2},wl_core_TimeSig.milliseconds(0,2,0,0),createjs.Ease.cubicOut);
		this.box.scale.x = this.box.scale.y = this.box.scale.z = 1.2;
		createjs.Tween.get(this.box.scale).to({ x : 1, y : 1, z : 1},wl_core_TimeSig.milliseconds(0,2,0,0),createjs.Ease.none);
		createjs.Tween.get(this).to({ xspeed : 0, yspeed : 0},wl_core_TimeSig.milliseconds(0,2,0,0),createjs.Ease.none);
	}
	,update: function(ts,partial,frameTime) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime);
	}
	,render: function(ts,frameTime) {
		wl_core_Part.prototype.render.call(this,ts,frameTime);
	}
	,__class__: jalava_Greetings
});
var jalava_IntroWorm = function(geometry) {
	this.lastspawn = 0;
	this.pointHistory = [];
	this.cur = 0;
	THREE.Object3D.call(this);
	this.geometry = geometry;
	this.initializeControls();
};
jalava_IntroWorm.__name__ = ["jalava","IntroWorm"];
jalava_IntroWorm.__super__ = THREE.Object3D;
jalava_IntroWorm.prototype = $extend(THREE.Object3D.prototype,{
	initializeControls: function() {
		this.cubes = [];
		var params = { };
		params.color = 12330268;
		this.material = new THREE.MeshBasicMaterial(params);
		var _g = 0;
		while(_g < 100) {
			++_g;
			var m = new THREE.Mesh(this.geometry,this.material);
			this.add(m);
			m.visible = false;
			this.cubes.push(m);
		}
	}
	,start: function(ts) {
		this.lastspawn = ts.toMilliseconds();
	}
	,postinit: function() {
		this.material.envMap = wl_core_Demo.instance.getPart("Windows").cubecam.renderTarget.texture;
	}
	,spawn: function(position) {
		this.pointHistory.push(position);
		this.cur = (this.cur + 1) % this.cubes.length;
		var next = this.cubes[this.cur];
		createjs.Tween.removeTweens(next.scale);
		next.position.copy(position);
		next.position.rndx = wl_util_Random.nextFloat() - 0.5;
		next.position.rndz = wl_util_Random.nextFloat() - 0.5;
		next.position.rndy = wl_util_Random.nextFloat() - 0.5;
		next.position.x += next.position.rndx;
		next.position.y += next.position.rndy;
		next.position.z += next.position.rndz;
		next.rotateX(wl_util_Random.nextFloat() * Math.PI);
		next.rotateY(wl_util_Random.nextFloat() * Math.PI);
		next.scale.x = next.scale.y = next.scale.z = 0.001;
		var ns = wl_util_Random.nextFloat() * 0.5 + 0.5;
		createjs.Tween.get(next.scale).to({ x : ns, y : ns, z : ns},wl_core_TimeSig.milliseconds(0,1,0,0),createjs.Ease.getBackOut(2));
		var previous = this.cubes[(this.cur + 50) % this.cubes.length];
		createjs.Tween.get(previous.scale).to({ x : 0.001, y : 0.001, z : 0.001},wl_core_TimeSig.milliseconds(1,0,0,0),createjs.Ease.backIn);
		next.visible = true;
	}
	,tick: function(position,delta,ts) {
		while(ts - this.lastspawn > 30) {
			this.lastspawn = ts;
			this.spawn(position);
		}
		var _g = 0;
		var _g1 = this.cubes;
		while(_g < _g1.length) {
			var c = _g1[_g];
			++_g;
			c.rotateX(delta * 0.02 * c.scale.x);
			c.rotateY(-delta * 0.01);
		}
	}
	,__class__: jalava_IntroWorm
});
var jalava_MeshArray = function(inputMesh,countX,countY,countZ) {
	this._arrayChildren = [];
	this.outerOnly = true;
	this.ignoreInvert = false;
	this.ignoreList = [];
	this.scalingZ = 1;
	this.scalingY = 1;
	this.scalingX = 1;
	this.tZ = 0;
	this.tY = 0;
	this.tX = 0;
	this.countZ = 1;
	this.countY = 1;
	this.countX = 1;
	THREE.Object3D.call(this);
	this._inputObject = inputMesh;
	this.countX = countX;
	this.countY = countY;
	this.countZ = countZ;
	this.resetGeometry(true);
};
jalava_MeshArray.__name__ = ["jalava","MeshArray"];
jalava_MeshArray.__super__ = THREE.Object3D;
jalava_MeshArray.prototype = $extend(THREE.Object3D.prototype,{
	getChildren: function() {
		return this._arrayChildren.slice(0);
	}
	,resetGeometry: function(recreateChildren) {
		if(recreateChildren) {
			var _g1 = 0;
			var _g = this._arrayChildren.length;
			while(_g1 < _g) {
				var i = _g1++;
				if(this._arrayChildren[i] != null && this._arrayChildren[i].parent != null) {
					this._arrayChildren[i].parent.remove(this._arrayChildren[i]);
				}
			}
			this._arrayChildren.length = this.countX * this.countY * this.countZ;
		}
		var hx = (this.countX - 1) * this.tX / 2;
		var hy = (this.countY - 1) * this.tY / 2;
		var hz = (this.countZ - 1) * this.tZ / 2;
		var _g11 = 0;
		var _g2 = this.countX;
		while(_g11 < _g2) {
			var xc = _g11++;
			var _g3 = 0;
			var _g21 = this.countY;
			while(_g3 < _g21) {
				var yc = _g3++;
				var _g5 = 0;
				var _g4 = this.countZ;
				while(_g5 < _g4) {
					var zc = _g5++;
					var edgeCount = 0;
					edgeCount += xc == 0 || xc == this.countX - 1?1:0;
					edgeCount += yc == 0 || yc == this.countY - 1?1:0;
					edgeCount += zc == 0 || zc == this.countZ - 1?1:0;
					if(this.outerOnly && edgeCount == 0) {
						if(recreateChildren) {
							this._arrayChildren.push(null);
						}
						continue;
					}
					var obj;
					var ignore = false;
					var _g7 = 0;
					var _g6 = this.ignoreList.length;
					while(_g7 < _g6) {
						var j = _g7++;
						if(this.ignoreList[j][0] == xc && this.ignoreList[j][1] == yc && this.ignoreList[j][2] == zc) {
							ignore = true;
							break;
						}
					}
					if(this.ignoreInvert) {
						ignore = !ignore;
					}
					if(ignore) {
						continue;
					}
					if(recreateChildren) {
						obj = this._inputObject.clone();
					} else {
						obj = this._arrayChildren[xc * this.countY * this.countZ + yc * this.countZ + zc];
					}
					obj.position.x = xc * this.tX - hx;
					obj.position.y = yc * this.tY - hy;
					obj.position.z = zc * this.tZ - hz;
					obj.scale.x = this.scalingX;
					obj.scale.y = this.scalingY;
					obj.scale.z = this.scalingZ;
					obj.matrixAutoUpdate = false;
					obj.updateMatrix();
					if(recreateChildren) {
						this.add(obj);
						this._arrayChildren[xc * this.countY * this.countZ + yc * this.countZ + zc] = obj;
					}
				}
			}
		}
	}
	,__class__: jalava_MeshArray
});
var jalava_MeshRadialArray = function(inputMesh,radials,count,zCount,dist,firstDist,zTransform,twistAngle) {
	if(zTransform == null) {
		zTransform = 10;
	}
	if(firstDist == null) {
		firstDist = 0;
	}
	if(dist == null) {
		dist = 10;
	}
	if(zCount == null) {
		zCount = 1;
	}
	if(count == null) {
		count = 1;
	}
	if(radials == null) {
		radials = 4;
	}
	this.twistAngle = new THREE.Vector3();
	this._arrayChildren = [];
	this.zTransform = 0;
	this.angleJitter = 0;
	this.outerOnly = true;
	this.dist = 0;
	this.firstDist = 0;
	this.zCount = 1;
	this.count = 1;
	this.radials = 1;
	THREE.Group.call(this);
	this._inputObject = inputMesh;
	this.radials = radials;
	this.count = count;
	this.zCount = zCount;
	this.dist = dist;
	this.firstDist = firstDist;
	this.zTransform = zTransform;
	if(twistAngle != null) {
		this.twistAngle = twistAngle;
	}
	this.resetGeometry(true);
};
jalava_MeshRadialArray.__name__ = ["jalava","MeshRadialArray"];
jalava_MeshRadialArray.__super__ = THREE.Group;
jalava_MeshRadialArray.prototype = $extend(THREE.Group.prototype,{
	resetGeometry: function(recreateChildren) {
		if(recreateChildren) {
			var _g1 = 0;
			var _g = this._arrayChildren.length;
			while(_g1 < _g) {
				var i = _g1++;
				if(this._arrayChildren[i] != null) {
					this._arrayChildren[i].parent.remove(this._arrayChildren[i]);
				}
			}
			this._arrayChildren.length = this.radials * this.count * this.zCount;
		}
		var _g11 = 0;
		var _g2 = this.zCount;
		while(_g11 < _g2) {
			var zc = _g11++;
			var _g3 = 0;
			var _g21 = this.radials;
			while(_g3 < _g21) {
				var rad = _g3++;
				var angle = Math.PI * 2 * (rad / this.radials);
				var _g5 = 0;
				var _g4 = this.count;
				while(_g5 < _g4) {
					var cnt = _g5++;
					var obj = recreateChildren?this._inputObject.clone():this._arrayChildren[zc * this.radials * this.count + rad * this.count + cnt];
					var range = this.firstDist + cnt * this.dist;
					obj.rotation.z = -angle;
					obj.rotation.z += this.twistAngle.z;
					obj.rotation.y += this.twistAngle.y;
					obj.rotation.x += this.twistAngle.x;
					obj.position.x = range * Math.sin(angle);
					obj.position.y = range * Math.cos(angle);
					if(this.zTransform != 0) {
						var dist = zc * this.zTransform;
						obj.position.z = dist - this.zCount / 2 * this.zTransform;
					} else {
						obj.position.z = 0;
					}
					obj.matrixAutoUpdate = false;
					obj.updateMatrix();
					if(recreateChildren) {
						this.add(obj);
						this._arrayChildren[zc * this.radials * this.count + rad * this.count + cnt] = obj;
					}
				}
			}
		}
	}
	,__class__: jalava_MeshRadialArray
});
var jalava_PartIntro = function() {
	this.spawnCnt = 0;
	this.cubesMaterial = new THREE.MeshBasicMaterial({ color : 15488322});
	this.cubesGeometry = new THREE.BoxGeometry(3,3,3);
	this.cur = 0;
	this.cubes = [];
	this.phase = 0;
	this.secondWorms = [];
	this.wormNextPos = new THREE.Vector3();
	this.startTime = 0;
	this.step2on = false;
	this.spawn = true;
	this.meshCnt = 1;
	this.cnt = 0;
	wl_core_Part.call(this);
};
jalava_PartIntro.__name__ = ["jalava","PartIntro"];
jalava_PartIntro.__super__ = wl_core_Part;
jalava_PartIntro.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.initComposer(this.getComposerList({ dof : false, bloom : true, standard : true}));
		this.logo = new THREE.Mesh(new THREE.PlaneGeometry(0.8,0.2),new THREE.MeshBasicMaterial({ transparent : true, color : 16777215, map : wl_core_Assets.getTexture("konvergencefinaltransparent.png"), side : THREE.FrontSide}));
		this.logo.scale.setY(-1);
		this.logo.material.opacity = 0;
		this.logo.position.x = 0.5;
		this.logo.position.y = 0.5 * wl_core_Config.RESOLUTION[1] / wl_core_Config.RESOLUTION[0];
		var particle = wl_core_Assets.getTexture("particle2.png");
		var noise = wl_core_Assets.getTexture("perlin-512.png");
		this.particleSystem = new THREE.GPUParticleSystem(new js_three_GPUParticleSystemOptions(250000,1,noise,particle));
		this.particleSystem2 = new THREE.GPUParticleSystem(new js_three_GPUParticleSystemOptions(25000,10,noise,particle));
		this.particleSystem3 = new THREE.GPUParticleSystem(new js_three_GPUParticleSystemOptions(25000,10,noise,particle));
		var particleSizeScale = wl_core_Graphics.instance.renderer.getSize().width / 1920;
		this.postProcessing.bloom.strength = 1.76;
		this.postProcessing.bloom.radius = 0.18;
		this.postProcessing.bloom.threshold = 0.01;
		this.options = new js_three_GPUParticleOptions();
		this.options.position = new THREE.Vector3();
		this.options.positionRandomness = 0.3;
		this.options.velocity = new THREE.Vector3();
		this.options.velocityRandomness = 0.4;
		this.options.color = DemoMain.DARK1.getHex();
		this.options.colorRandomness = 0.05;
		this.options.turbulence = 100;
		this.options.lifetime = 10000;
		this.options.size = 7 * particleSizeScale;
		this.options.sizeRandomness = 3 * particleSizeScale;
		this.options2 = new js_three_GPUParticleOptions();
		this.options2.position = new THREE.Vector3();
		this.options2.positionRandomness = 0.8;
		this.options2.velocity = new THREE.Vector3(0.0,0.0,0);
		this.options2.velocityRandomness = 0.1;
		this.options2.color = DemoMain.DARK1.getHex();
		this.options2.colorRandomness = 0.05;
		this.options2.turbulence = 0;
		this.options2.lifetime = 100;
		this.options2.size = 9 * particleSizeScale;
		this.options2.sizeRandomness = 3 * particleSizeScale;
		this.options2.triggerRandomness = 0.5;
		var _g = 0;
		while(_g < 250) {
			var x = _g++;
			var _g1 = 0;
			while(_g1 < 100) {
				var y = _g1++;
				this.options.position.x = x * 2 - 250;
				this.options.position.y = y * 2 - 100;
				this.options.velocity.x = -Math.random() * 2;
				this.particleSystem.spawnParticle(this.options);
			}
		}
		this.scene.add(this.particleSystem);
		this.scene.add(this.particleSystem2);
		this.addTrigger(new wl_core_TimeSig(4,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.launchworm));
		this.addTrigger(new wl_core_TimeSig(8,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.showLogo));
		this.addTrigger(new wl_core_TimeSig(17,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.hideLogo));
		this.addTrigger(new wl_core_TimeSig(16,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.translate));
		this.addTrigger(new wl_core_TimeSig(24,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.step2));
		this.addTrigger(new wl_core_TimeSig(31,0,0,0,wl_core_TimeSig.ABSOLUTE),$bind(this,this.endfade));
		this.worm = new jalava_IntroWorm(new THREE.BoxGeometry(60,60,60));
		this.scene.add(this.worm);
		this.wormNextPos.x = -1800;
		var _g2 = 0;
		while(_g2 < 300) {
			++_g2;
			var m = new THREE.Mesh(this.cubesGeometry,this.cubesMaterial);
			this.scene.add(m);
			m.visible = false;
			this.cubes.push(m);
		}
		this.postProcessing.standard.set_brightness(-0.6);
		this.mesh = new THREE.Mesh(new THREE.BoxGeometry(3,60,10),new THREE.MeshBasicMaterial({ color : DemoMain.DARK2.getHex()}));
		var twistAngle = new THREE.Vector3(Math.PI / 8,0,Math.PI / 2 - Math.PI / 8);
		var twistAngle2 = new THREE.Vector3(-Math.PI / 8,0,-Math.PI / 2 - Math.PI / 8);
		this.circle1 = new jalava_MeshRadialArray(this.mesh,40,1,1,10,100,0,twistAngle);
		this.scene.add(this.circle1);
		this.circle2 = new jalava_MeshRadialArray(this.mesh,40,1,1,10,100,0,twistAngle2);
		this.circle2.scale.multiplyScalar(0.8);
		this.circle1.add(this.circle2);
		this.circle3 = new jalava_MeshRadialArray(this.mesh,40,1,1,10,100,0,twistAngle);
		this.circle3.scale.multiplyScalar(0.7);
		this.circle2.add(this.circle3);
		this.circle1.scale.y = this.circle1.scale.z = this.circle1.scale.x = 0.001;
	}
	,endfade: function(ts) {
		createjs.Tween.get(this.postProcessing.standard.uniforms.brightness).to({ value : 1},wl_core_TimeSig.milliseconds(1,0,0,0),createjs.Ease.cubicIn);
	}
	,launchworm: function(ts) {
		createjs.Tween.get(this.wormNextPos).to({ x : 350},wl_core_TimeSig.milliseconds(8,0,0,0));
	}
	,postInit: function() {
		this.worm.postinit();
		this.cubesMaterial.envMap = wl_core_Demo.instance.getPart("Windows").cubecam.renderTarget.texture;
		wl_core_Part.prototype.postInit.call(this);
	}
	,showLogo: function(t) {
		createjs.Tween.get(this.logo.material).to({ opacity : 1},wl_core_TimeSig.milliseconds(2,0,0,0));
		wl_core_Demo.instance.overlay.add(this.logo);
		this.phase = 1;
	}
	,hideLogo: function(t) {
	}
	,translate: function(t) {
		createjs.Tween.get(this.logo.scale).to({ y : 0.001, x : 0.001, z : 0.001},wl_core_TimeSig.milliseconds(0,3,0,0),createjs.Ease.getBackIn(1.3));
		createjs.Tween.get(this.circle1.scale).wait(wl_core_TimeSig.milliseconds(0,2,0,0)).to({ y : 1, x : 1, z : 1},wl_core_TimeSig.milliseconds(0,3,0,0),createjs.Ease.getBackOut(1.3));
		this.phase = 2;
	}
	,step2: function(t) {
		this.phase = 3;
		var _g1 = 0;
		while(_g1 < 3) {
			var i = _g1++;
			var light = new THREE.PointLight(DemoMain.DARK3.getHex(),10.7,600,0.1);
			var ang = Math.PI * 2 * i / 3;
			light.position.x = Math.sin(ang) * 400;
			light.position.z = Math.cos(ang) * 400;
			this.scene.add(light);
			light.position.y = -100 * i;
		}
		createjs.Tween.get(this.camera.position).to({ z : 20},wl_core_TimeSig.milliseconds(8,0,0,0),createjs.Ease.cubicInOut);
		createjs.Tween.get(this.postProcessing.bloom).to({ strength : 10, threshold : 0.05, radius : 0.34},wl_core_TimeSig.milliseconds(8,0,0,0),createjs.Ease.cubicIn);
		wl_core_Demo.instance.overlay.remove(this.logo);
	}
	,start: function(ts) {
		createjs.Tween.get(this.postProcessing.standard.uniforms.brightness).to({ value : 0},wl_core_TimeSig.milliseconds(4,0,0,0));
		this.startTime = ts.toMilliseconds();
		wl_core_Part.prototype.start.call(this,ts);
	}
	,stop: function() {
		wl_core_Part.prototype.stop.call(this);
		if(this.logo.parent != null) {
			wl_core_Demo.instance.overlay.remove(this.logo);
		}
	}
	,render: function(ts,frameTime) {
		var delta = frameTime / 16.666666666666668;
		if(this.phase < 2) {
			this.worm.tick(this.wormNextPos,delta,ts.toMilliseconds());
		}
		wl_core_Part.prototype.render.call(this,ts,frameTime);
	}
	,update: function(ts,partial,frameTime) {
		var delta = frameTime / 16.666666666666668;
		this.wormNextPos.y = Math.sin(partial) * 20;
		var time = ts.toMilliseconds() - this.startTime;
		this.particleSystem.update(time * 0.02);
		this.particleSystem2.update(time * 0.02);
		if(this.phase >= 2) {
			if(this.phase >= 3) {
				var cnt = wl_util_Random.nextFloat() < 0.2?400:40;
				var _g = 0;
				while(_g < 40) {
					var i = _g++;
					var r = 70;
					var phi = Math.random() * Math.PI * 2;
					var theta = Math.random() * Math.PI - Math.PI / 2;
					var x = r * Math.sin(theta) * Math.cos(phi);
					var y = r * Math.sin(theta) * Math.sin(phi);
					var z = r * Math.cos(theta);
					this.options2.position.x = x;
					this.options2.position.y = y;
					this.options2.position.z = z;
					this.options2.velocity.x = -x;
					this.options2.velocity.y = -y;
					this.options2.velocity.z = -z;
					this.options2.velocity.normalize();
					this.options2.velocity.multiplyScalar(4);
					this.particleSystem2.spawnParticle(this.options2);
					this.spawnCnt += 40;
				}
				if(wl_util_Random.nextFloat() < 0.5 && this.spawnCnt > 10) {
					this.cur = (this.cur + 1) % this.cubes.length;
					var next = this.cubes[this.cur];
					var scale = (time * 0.001 - 10) * 0.2;
					next.position.rndx = scale * wl_util_Random.nextFloat() - 0.5 * scale;
					next.position.rndz = scale * wl_util_Random.nextFloat() - 0.5 * scale;
					next.position.rndy = scale * wl_util_Random.nextFloat() - 0.5 * scale;
					next.position.x += next.position.rndx;
					next.position.y += next.position.rndy;
					next.position.z += next.position.rndz;
					next.rotateX(wl_util_Random.nextFloat() * Math.PI);
					next.rotateY(wl_util_Random.nextFloat() * Math.PI);
					if(wl_util_Random.nextFloat() < 0.10) {
						createjs.Tween.get(next.position).to({ z : 700, x : (Math.random() - 0.5) * 50, y : (Math.random() - 0.5) * 50},wl_core_TimeSig.milliseconds(3,0,0,0),createjs.Ease.cubicIn);
					}
					next.visible = true;
					this.cur++;
				}
				var _g1 = 0;
				var _g11 = this.cubes;
				while(_g1 < _g11.length) {
					var c = _g11[_g1];
					++_g1;
					c.rotateX(delta * 0.02 * c.scale.x);
					c.rotateY(-delta * 0.01);
				}
			}
			this.circle1.rotation.z = time * 0.0003;
			this.circle2.rotation.z = time * 0.0009;
			this.circle3.rotation.z = time * 0.0009;
			this.circle1.rotation.x = time * 0.0001;
			this.circle2.rotation.x = -time * 0.0003;
			this.circle3.rotation.x = time * 0.0006;
		} else {
			var _g2 = 0;
			while(_g2 < 20) {
				var i1 = _g2++;
				if(this.spawn) {
					this.options.position.x = 280;
					this.options.position.y = Math.random() * 200 - 100;
					this.options.position.z = Math.random() * 200 - 100;
					this.options.velocity.x = -Math.random() * 2;
				}
				this.options.turbulence = 100;
				this.options.triggerVelocity = new THREE.Vector3();
				this.options.triggerVelocity.x = Math.random() * 3 - 1.5;
				this.options.triggerVelocity.y = Math.random() * 3 - 1.5;
				this.options.triggerVelocity.z = Math.random() * 3 - 1.5;
				this.options.triggerTurbulence = 0;
				this.options.triggerRandomness = 0;
				this.particleSystem.spawnParticle(this.options);
			}
		}
	}
	,__class__: jalava_PartIntro
});
var jalava_TestMeshArray = function() {
	this.yspeed = 0.01;
	this.xspeed = 0.02;
	wl_core_Part.call(this);
};
jalava_TestMeshArray.__name__ = ["jalava","TestMeshArray"];
jalava_TestMeshArray.__super__ = wl_core_Part;
jalava_TestMeshArray.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.initComposer(this.getComposerList({ dof : false, bloom : false}));
		this.mesh = new THREE.Mesh(new THREE.BoxGeometry(5,5,5),new THREE.MeshNormalMaterial());
		var meshArray = new jalava_MeshArray(this.mesh,14,14,14);
		this.meshArray = meshArray;
		meshArray.tX = 7;
		meshArray.tY = 7;
		meshArray.tZ = 7;
		meshArray.resetGeometry(false);
		this.scene.add(meshArray);
	}
	,update: function(ts,partial,frameTime) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime);
		this.meshArray.rotateX(this.xspeed);
		this.meshArray.rotateY(this.yspeed);
	}
	,__class__: jalava_TestMeshArray
});
var jalava_TestRadialArray = function() {
	this.yspeed = 0.01;
	this.xspeed = 0.02;
	wl_core_Part.call(this);
};
jalava_TestRadialArray.__name__ = ["jalava","TestRadialArray"];
jalava_TestRadialArray.__super__ = wl_core_Part;
jalava_TestRadialArray.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.initComposer(this.getComposerList({ dof : false, bloom : false}));
		this.mesh = new THREE.Mesh(new THREE.BoxGeometry(5,5,5),new THREE.MeshNormalMaterial());
		var meshArray = new jalava_MeshRadialArray(this.mesh,20,8,5,10,8);
		this.meshArray = meshArray;
		this.scene.add(meshArray);
	}
	,update: function(ts,partial,frameTime) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime);
		this.meshArray.rotateX(this.xspeed);
		this.meshArray.rotateY(this.yspeed);
	}
	,__class__: jalava_TestRadialArray
});
var js__$Boot_HaxeError = function(val) {
	Error.call(this);
	this.val = val;
	this.message = String(val);
	if(Error.captureStackTrace) {
		Error.captureStackTrace(this,js__$Boot_HaxeError);
	}
};
js__$Boot_HaxeError.__name__ = ["js","_Boot","HaxeError"];
js__$Boot_HaxeError.wrap = function(val) {
	if((val instanceof Error)) {
		return val;
	} else {
		return new js__$Boot_HaxeError(val);
	}
};
js__$Boot_HaxeError.__super__ = Error;
js__$Boot_HaxeError.prototype = $extend(Error.prototype,{
	__class__: js__$Boot_HaxeError
});
var js_Boot = function() { };
js_Boot.__name__ = ["js","Boot"];
js_Boot.getClass = function(o) {
	if((o instanceof Array) && o.__enum__ == null) {
		return Array;
	} else {
		var cl = o.__class__;
		if(cl != null) {
			return cl;
		}
		var name = js_Boot.__nativeClassName(o);
		if(name != null) {
			return js_Boot.__resolveNativeClass(name);
		}
		return null;
	}
};
js_Boot.__string_rec = function(o,s) {
	if(o == null) {
		return "null";
	}
	if(s.length >= 5) {
		return "<...>";
	}
	var t = typeof(o);
	if(t == "function" && (o.__name__ || o.__ename__)) {
		t = "object";
	}
	switch(t) {
	case "function":
		return "<function>";
	case "object":
		if(o instanceof Array) {
			if(o.__enum__) {
				if(o.length == 2) {
					return o[0];
				}
				var str = o[0] + "(";
				s += "\t";
				var _g1 = 2;
				var _g = o.length;
				while(_g1 < _g) {
					var i = _g1++;
					if(i != 2) {
						str += "," + js_Boot.__string_rec(o[i],s);
					} else {
						str += js_Boot.__string_rec(o[i],s);
					}
				}
				return str + ")";
			}
			var l = o.length;
			var i1;
			var str1 = "[";
			s += "\t";
			var _g11 = 0;
			var _g2 = l;
			while(_g11 < _g2) {
				var i2 = _g11++;
				str1 += (i2 > 0?",":"") + js_Boot.__string_rec(o[i2],s);
			}
			str1 += "]";
			return str1;
		}
		var tostr;
		try {
			tostr = o.toString;
		} catch( e ) {
			return "???";
		}
		if(tostr != null && tostr != Object.toString && typeof(tostr) == "function") {
			var s2 = o.toString();
			if(s2 != "[object Object]") {
				return s2;
			}
		}
		var k = null;
		var str2 = "{\n";
		s += "\t";
		var hasp = o.hasOwnProperty != null;
		for( var k in o ) {
		if(hasp && !o.hasOwnProperty(k)) {
			continue;
		}
		if(k == "prototype" || k == "__class__" || k == "__super__" || k == "__interfaces__" || k == "__properties__") {
			continue;
		}
		if(str2.length != 2) {
			str2 += ", \n";
		}
		str2 += s + k + " : " + js_Boot.__string_rec(o[k],s);
		}
		s = s.substring(1);
		str2 += "\n" + s + "}";
		return str2;
	case "string":
		return o;
	default:
		return String(o);
	}
};
js_Boot.__interfLoop = function(cc,cl) {
	if(cc == null) {
		return false;
	}
	if(cc == cl) {
		return true;
	}
	var intf = cc.__interfaces__;
	if(intf != null) {
		var _g1 = 0;
		var _g = intf.length;
		while(_g1 < _g) {
			var i = intf[_g1++];
			if(i == cl || js_Boot.__interfLoop(i,cl)) {
				return true;
			}
		}
	}
	return js_Boot.__interfLoop(cc.__super__,cl);
};
js_Boot.__instanceof = function(o,cl) {
	if(cl == null) {
		return false;
	}
	switch(cl) {
	case Array:
		if((o instanceof Array)) {
			return o.__enum__ == null;
		} else {
			return false;
		}
		break;
	case Bool:
		return typeof(o) == "boolean";
	case Dynamic:
		return true;
	case Float:
		return typeof(o) == "number";
	case Int:
		if(typeof(o) == "number") {
			return (o|0) === o;
		} else {
			return false;
		}
		break;
	case String:
		return typeof(o) == "string";
	default:
		if(o != null) {
			if(typeof(cl) == "function") {
				if(o instanceof cl) {
					return true;
				}
				if(js_Boot.__interfLoop(js_Boot.getClass(o),cl)) {
					return true;
				}
			} else if(typeof(cl) == "object" && js_Boot.__isNativeObj(cl)) {
				if(o instanceof cl) {
					return true;
				}
			}
		} else {
			return false;
		}
		if(cl == Class && o.__name__ != null) {
			return true;
		}
		if(cl == Enum && o.__ename__ != null) {
			return true;
		}
		return o.__enum__ == cl;
	}
};
js_Boot.__nativeClassName = function(o) {
	var name = js_Boot.__toStr.call(o).slice(8,-1);
	if(name == "Object" || name == "Function" || name == "Math" || name == "JSON") {
		return null;
	}
	return name;
};
js_Boot.__isNativeObj = function(o) {
	return js_Boot.__nativeClassName(o) != null;
};
js_Boot.__resolveNativeClass = function(name) {
	return $global[name];
};
var js_html_compat_ArrayBuffer = function(a) {
	if((a instanceof Array) && a.__enum__ == null) {
		this.a = a;
		this.byteLength = a.length;
	} else {
		var len = a;
		this.a = [];
		var _g1 = 0;
		var _g = len;
		while(_g1 < _g) this.a[_g1++] = 0;
		this.byteLength = len;
	}
};
js_html_compat_ArrayBuffer.__name__ = ["js","html","compat","ArrayBuffer"];
js_html_compat_ArrayBuffer.sliceImpl = function(begin,end) {
	var u = new Uint8Array(this,begin,end == null?null:end - begin);
	var result = new ArrayBuffer(u.byteLength);
	new Uint8Array(result).set(u);
	return result;
};
js_html_compat_ArrayBuffer.prototype = {
	slice: function(begin,end) {
		return new js_html_compat_ArrayBuffer(this.a.slice(begin,end));
	}
	,__class__: js_html_compat_ArrayBuffer
};
var js_html_compat_Float32Array = function() { };
js_html_compat_Float32Array.__name__ = ["js","html","compat","Float32Array"];
js_html_compat_Float32Array._new = function(arg1,offset,length) {
	var arr;
	if(typeof(arg1) == "number") {
		arr = [];
		var _g1 = 0;
		var _g = arg1;
		while(_g1 < _g) {
			var i = _g1++;
			arr[i] = 0;
		}
		arr.byteLength = arr.length << 2;
		arr.byteOffset = 0;
		var _g2 = [];
		var _g21 = 0;
		var _g11 = arr.length << 2;
		while(_g21 < _g11) {
			var i1 = _g21++;
			_g2.push(0);
		}
		arr.buffer = new js_html_compat_ArrayBuffer(_g2);
	} else if(js_Boot.__instanceof(arg1,js_html_compat_ArrayBuffer)) {
		var buffer = arg1;
		if(offset == null) {
			offset = 0;
		}
		if(length == null) {
			length = buffer.byteLength - offset >> 2;
		}
		arr = [];
		var _g12 = 0;
		var _g3 = length;
		while(_g12 < _g3) {
			var i2 = _g12++;
			var val = buffer.a[offset++] | buffer.a[offset++] << 8 | buffer.a[offset++] << 16 | buffer.a[offset++] << 24;
			arr.push(haxe_io_FPHelper.i32ToFloat(val));
		}
		arr.byteLength = arr.length << 2;
		arr.byteOffset = offset;
		arr.buffer = buffer;
	} else if((arg1 instanceof Array) && arg1.__enum__ == null) {
		arr = arg1.slice();
		var buffer1 = [];
		var _g4 = 0;
		while(_g4 < arr.length) {
			var f = arr[_g4];
			++_g4;
			var i3 = haxe_io_FPHelper.floatToI32(f);
			buffer1.push(i3 & 255);
			buffer1.push(i3 >> 8 & 255);
			buffer1.push(i3 >> 16 & 255);
			buffer1.push(i3 >>> 24);
		}
		arr.byteLength = arr.length << 2;
		arr.byteOffset = 0;
		arr.buffer = new js_html_compat_ArrayBuffer(buffer1);
	} else {
		throw new js__$Boot_HaxeError("TODO " + Std.string(arg1));
	}
	arr.subarray = js_html_compat_Float32Array._subarray;
	arr.set = js_html_compat_Float32Array._set;
	return arr;
};
js_html_compat_Float32Array._set = function(arg,offset) {
	if(js_Boot.__instanceof(arg.buffer,js_html_compat_ArrayBuffer)) {
		var a = arg;
		if(arg.byteLength + offset > this.byteLength) {
			throw new js__$Boot_HaxeError("set() outside of range");
		}
		var _g1 = 0;
		var _g = arg.byteLength;
		while(_g1 < _g) {
			var i = _g1++;
			this[i + offset] = a[i];
		}
	} else if((arg instanceof Array) && arg.__enum__ == null) {
		var a1 = arg;
		if(a1.length + offset > this.byteLength) {
			throw new js__$Boot_HaxeError("set() outside of range");
		}
		var _g11 = 0;
		var _g2 = a1.length;
		while(_g11 < _g2) {
			var i1 = _g11++;
			this[i1 + offset] = a1[i1];
		}
	} else {
		throw new js__$Boot_HaxeError("TODO");
	}
};
js_html_compat_Float32Array._subarray = function(start,end) {
	var a = js_html_compat_Float32Array._new(this.slice(start,end));
	a.byteOffset = start * 4;
	return a;
};
var js_html_compat_Uint8Array = function() { };
js_html_compat_Uint8Array.__name__ = ["js","html","compat","Uint8Array"];
js_html_compat_Uint8Array._new = function(arg1,offset,length) {
	var arr;
	if(typeof(arg1) == "number") {
		arr = [];
		var _g1 = 0;
		var _g = arg1;
		while(_g1 < _g) {
			var i = _g1++;
			arr[i] = 0;
		}
		arr.byteLength = arr.length;
		arr.byteOffset = 0;
		arr.buffer = new js_html_compat_ArrayBuffer(arr);
	} else if(js_Boot.__instanceof(arg1,js_html_compat_ArrayBuffer)) {
		var buffer = arg1;
		if(offset == null) {
			offset = 0;
		}
		if(length == null) {
			length = buffer.byteLength - offset;
		}
		if(offset == 0) {
			arr = buffer.a;
		} else {
			arr = buffer.a.slice(offset,offset + length);
		}
		arr.byteLength = arr.length;
		arr.byteOffset = offset;
		arr.buffer = buffer;
	} else if((arg1 instanceof Array) && arg1.__enum__ == null) {
		arr = arg1.slice();
		arr.byteLength = arr.length;
		arr.byteOffset = 0;
		arr.buffer = new js_html_compat_ArrayBuffer(arr);
	} else {
		throw new js__$Boot_HaxeError("TODO " + Std.string(arg1));
	}
	arr.subarray = js_html_compat_Uint8Array._subarray;
	arr.set = js_html_compat_Uint8Array._set;
	return arr;
};
js_html_compat_Uint8Array._set = function(arg,offset) {
	if(js_Boot.__instanceof(arg.buffer,js_html_compat_ArrayBuffer)) {
		var a = arg;
		if(arg.byteLength + offset > this.byteLength) {
			throw new js__$Boot_HaxeError("set() outside of range");
		}
		var _g1 = 0;
		var _g = arg.byteLength;
		while(_g1 < _g) {
			var i = _g1++;
			this[i + offset] = a[i];
		}
	} else if((arg instanceof Array) && arg.__enum__ == null) {
		var a1 = arg;
		if(a1.length + offset > this.byteLength) {
			throw new js__$Boot_HaxeError("set() outside of range");
		}
		var _g11 = 0;
		var _g2 = a1.length;
		while(_g11 < _g2) {
			var i1 = _g11++;
			this[i1 + offset] = a1[i1];
		}
	} else {
		throw new js__$Boot_HaxeError("TODO");
	}
};
js_html_compat_Uint8Array._subarray = function(start,end) {
	var a = js_html_compat_Uint8Array._new(this.slice(start,end));
	a.byteOffset = start;
	return a;
};
var js_three_GPUParticleOptions = function() {
	this.sizeRandomness = 0;
	this.size = 0;
	this.lifetime = 0;
	this.turbulence = 0;
	this.colorRandomness = 0;
	this.color = 16777215;
	this.velocityRandomness = 0;
	this.positionRandomness = 0;
	this.velocity = new THREE.Vector3();
	this.position = new THREE.Vector3();
};
js_three_GPUParticleOptions.__name__ = ["js","three","GPUParticleOptions"];
js_three_GPUParticleOptions.prototype = {
	__class__: js_three_GPUParticleOptions
};
var js_three_GPUParticleSystemOptions = function(maxParticles,containerCount,particleNoiseTex,particleSpriteTex) {
	this.maxParticles = maxParticles;
	this.containerCount = containerCount;
	this.particleNoiseTex = particleNoiseTex;
	this.particleSpriteTex = particleSpriteTex;
};
js_three_GPUParticleSystemOptions.__name__ = ["js","three","GPUParticleSystemOptions"];
js_three_GPUParticleSystemOptions.prototype = {
	__class__: js_three_GPUParticleSystemOptions
};
var transition1_CubeGround = function(boxTopMaterial,boxBottomMaterial,part,layer,geometry) {
	this.spedup = false;
	this.halted = false;
	THREE.Object3D.call(this);
	this.boxGeometry = geometry;
	this.layer = layer;
	this.part = part;
	this.boxBottomMaterial = boxBottomMaterial;
	this.boxTopMaterial = boxTopMaterial;
	this.initialize();
};
transition1_CubeGround.__name__ = ["transition1","CubeGround"];
transition1_CubeGround.__super__ = THREE.Object3D;
transition1_CubeGround.prototype = $extend(THREE.Object3D.prototype,{
	initialize: function() {
		this.centerBoxes = [];
		this.boxes = [];
		var _g1 = 0;
		while(_g1 < 361) {
			var i = _g1++;
			var x = i % 19;
			var y = Math.floor(i / 19);
			var _g3 = 0;
			while(_g3 < 1) {
				var j = _g3++;
				var box = new THREE.Mesh(this.boxGeometry,this.boxBottomMaterial);
				var cont = new THREE.Object3D();
				cont.position.x = x * 10 - 95.;
				cont.position.z = y * 10 - 95.;
				var dx = i % 19 - 9.5;
				var dz = Math.floor(i / 19) - 9.5;
				var d = Math.max(Math.abs(dx),Math.abs(dz));
				d = Math.min(19,d);
				--d;
				cont.position.y = d * 0.7 + j * 10;
				cont.add(box);
				this.add(cont);
				var gb = { };
				gb.center = d <= 2;
				gb.mesh = box;
				gb.container = cont;
				gb.target = box.position.clone();
				gb.speed = 0;
				this.boxes.push(gb);
				gb.distance = d;
				if(d == 0) {
					this.centerBoxes.push(gb);
				}
				var top = new THREE.Mesh(this.boxGeometry,this.boxTopMaterial);
				top.scale.y = 0.1;
				top.position.y = 5.3;
				box.add(top);
			}
		}
		this.part.addTrigger(new wl_core_TimeSig(this.layer,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.centerOff));
		this.part.addTrigger(new wl_core_TimeSig(-1,0,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.onBar));
		this.part.addTrigger(new wl_core_TimeSig(110,2,0,0,wl_core_TimeSig.ABSOLUTE),$bind(this,this.onBar));
		this.part.addTrigger(new wl_core_TimeSig(112,2,0,0,wl_core_TimeSig.ABSOLUTE),$bind(this,this.onBar));
		this.part.addTrigger(new wl_core_TimeSig(95,3,11,0,wl_core_TimeSig.ABSOLUTE),$bind(this,this.onBar));
		this.part.addTrigger(new wl_core_TimeSig(95,0,3,0,wl_core_TimeSig.ABSOLUTE),$bind(this,this.onBar));
		this.part.addTrigger(new wl_core_TimeSig(95,2,0,0,wl_core_TimeSig.ABSOLUTE),$bind(this,this.onBar));
	}
	,halt: function(value) {
		this.halted = value;
		if(this.halted) {
			var _g = 0;
			var _g1 = this.boxes;
			while(_g < _g1.length) {
				var c = _g1[_g];
				++_g;
				createjs.Tween.get(c.container.position).to({ y : 0},wl_core_TimeSig.milliseconds(0,2,0,0));
			}
		}
	}
	,fastup: function() {
		this.spedup = true;
		this.part.addTrigger(new wl_core_TimeSig(-1,-1,0,-1,wl_core_TimeSig.PATTERN),$bind(this,this.onBeat));
		this.part.addTrigger(new wl_core_TimeSig(-1,-1,2,-1,wl_core_TimeSig.PATTERN),$bind(this,this.onBeat));
		this.part.addTrigger(new wl_core_TimeSig(-1,-1,1,-1,wl_core_TimeSig.PATTERN),$bind(this,this.onBeat));
		this.part.addTrigger(new wl_core_TimeSig(-1,-1,3,-1,wl_core_TimeSig.PATTERN),$bind(this,this.onBeat));
	}
	,cubeRender: function(on) {
		var _g = 0;
		var _g1 = this.boxes;
		while(_g < _g1.length) {
			var b = _g1[_g];
			++_g;
			b.container.visible = !on || b.distance == 1;
		}
	}
	,centerOff: function(ts) {
	}
	,onBar: function(ts) {
		var _gthis = this;
		this.layer--;
		if(this.halted) {
			return;
		}
		var amount = 0.5;
		if(!this.spedup && ts.bar % 2 == 1) {
			amount = 0.9;
		}
		var _g1 = 0;
		var _g = this.boxes.length;
		while(_g1 < _g) {
			var bg = [this.boxes[_g1++]];
			if(bg[0].center && this.layer <= -3) {
				createjs.Tween.get(bg[0].mesh.scale).wait(wl_core_TimeSig.milliseconds(0,0,3,0) * bg[0].distance).to({ x : 0.01, y : 0.01, z : 0.01},10).call((function(bg1) {
					return function() {
						_gthis.remove(bg1[0].container);
					};
				})(bg));
			} else {
				createjs.Tween.get(bg[0].mesh.scale).wait(wl_core_TimeSig.milliseconds(0,0,3,0) * bg[0].distance).to({ x : amount, y : amount, z : amount},10).to({ x : 1, z : 1, y : 1},wl_core_TimeSig.milliseconds(0,2,0,0),createjs.Ease.linear);
			}
		}
	}
	,onBeat: function(ts) {
		if(this.halted) {
			return;
		}
		var _g1 = 0;
		var _g = this.boxes.length;
		while(_g1 < _g) {
			var i = _g1++;
			if((ts.bar + ts.beat) % 5 == (Math.floor(i * 0.05 * ts.bar) + Math.floor(i / 2) + i % 3) % 5) {
				var bg = this.boxes[i];
				if(bg.center) {
					continue;
				}
				bg.mesh.position.y = 3 + wl_util_Random.nextFloat() * 10;
				createjs.Tween.get(bg.mesh.position).to({ y : bg.target.y},wl_core_TimeSig.milliseconds(0,2,0,0),createjs.Ease.circOut);
			}
		}
	}
	,__class__: transition1_CubeGround
});
var transition1_CubeWorm2 = function(geometry) {
	this.lastspawn = 0;
	this.pointHistory = [];
	this.cur = 0;
	THREE.Object3D.call(this);
	this.geometry = geometry;
	this.initializeControls();
};
transition1_CubeWorm2.__name__ = ["transition1","CubeWorm2"];
transition1_CubeWorm2.__super__ = THREE.Object3D;
transition1_CubeWorm2.prototype = $extend(THREE.Object3D.prototype,{
	initializeControls: function() {
		this.cubes = [];
		var params = { };
		params.color = 16777215;
		this.material = new THREE.MeshBasicMaterial(params);
		var _g = 0;
		while(_g < 100) {
			++_g;
			var m = new THREE.Mesh(this.geometry,this.material);
			this.add(m);
			m.visible = false;
			this.cubes.push(m);
		}
	}
	,start: function(ts) {
		this.lastspawn = ts.toMilliseconds();
	}
	,postinit: function() {
		this.material.envMap = wl_core_Demo.instance.getPart("Windows").cubecam.renderTarget.texture;
	}
	,spawn: function(position) {
		this.pointHistory.push(position);
		this.cur = (this.cur + 1) % this.cubes.length;
		var next = this.cubes[this.cur];
		next.position.copy(position);
		next.position.rndx = wl_util_Random.nextFloat() - 0.5;
		next.position.rndz = wl_util_Random.nextFloat() - 0.5;
		next.position.rndy = wl_util_Random.nextFloat() - 0.5;
		next.position.x += next.position.rndx;
		next.position.y += next.position.rndy;
		next.position.z += next.position.rndz;
		next.rotateX(wl_util_Random.nextFloat() * Math.PI);
		next.rotateY(wl_util_Random.nextFloat() * Math.PI);
		next.scale.x = next.scale.y = next.scale.z = 0.001;
		var ns = wl_util_Random.nextFloat() * 0.5 + 0.5;
		createjs.Tween.get(next.scale).to({ x : ns, y : ns, z : ns},wl_core_TimeSig.milliseconds(0,2,0,0),createjs.Ease.getBackOut(2));
		next.visible = true;
	}
	,tick: function(position,delta,ts) {
		while(ts - this.lastspawn > 30) {
			this.lastspawn = ts;
			this.spawn(position);
		}
		var _g = 0;
		var _g1 = this.cubes;
		while(_g < _g1.length) {
			var c = _g1[_g];
			++_g;
			c.rotateX(delta * 0.02 * c.scale.x);
			c.rotateY(-delta * 0.01);
		}
	}
	,__class__: transition1_CubeWorm2
});
var transition1_KleinCube = function() {
	this.rgbshiftVal = 0;
	this.wormVal = 0;
	this.blueunidistort = 0;
	this.camshakestart = 0;
	this.camshakeon = 0;
	this.allowDistort = false;
	this.wormison = false;
	this.wormOffset = 0;
	this.stopupd = false;
	this.firstSwapdone = false;
	wl_core_Part.call(this);
};
transition1_KleinCube.__name__ = ["transition1","KleinCube"];
transition1_KleinCube.__super__ = wl_core_Part;
transition1_KleinCube.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		var _gthis = this;
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.initComposer(this.getComposerList({ dof : true, bloom : true, pixelate : false, rgbShift : false, distortedTV : true, colorHilight : false, standard : true}));
		this.camera.far = 600;
		this.camera.near = 10;
		this.cameras = [new wl_demo_CameraController(this.camera),new wl_demo_CameraController(this.camera),new wl_demo_CameraController(this.camera),new wl_demo_CameraController(this.camera),new wl_demo_CameraController(this.camera),new wl_demo_CameraController(this.camera),new wl_demo_CameraController(this.camera),new wl_demo_CameraController(this.camera),new wl_demo_CameraController(this.camera),new wl_demo_CameraController(this.camera),new wl_demo_CameraController(this.camera),new wl_demo_CameraController(this.camera),new wl_demo_CameraController(this.camera),new wl_demo_CameraController(this.camera),new wl_demo_CameraController(this.camera)];
		var tmp = [new THREE.Vector3(0,110,0),new THREE.Vector3(0,0,0)];
		var tmp1 = new THREE.Vector3(0,-200,0);
		this.cameras[0].initLinear(tmp,[tmp1,new THREE.Vector3(0,-200,0)]);
		var tmp2 = [new THREE.Vector3(10.8,245.22,16.9),new THREE.Vector3(6.3,155.69,9.09),new THREE.Vector3(-1.88,66.64,-0.99),new THREE.Vector3(-11.63,0.02,-10.49),new THREE.Vector3(-16.99,-72.78,-20.72),new THREE.Vector3(-17.58,-141.36,-30.5),new THREE.Vector3(-18.06,-161.42,-34.82),new THREE.Vector3(-20.31,-169.2,-30.39)];
		var tmp3 = new THREE.Vector3(6.58,145.6,9.28);
		var tmp4 = new THREE.Vector3(-0.57,56.54,-2.01);
		var tmp5 = new THREE.Vector3(-14.3,-31.76,-13.73);
		var tmp6 = new THREE.Vector3(-26.1,-97.88,-24.82);
		var tmp7 = new THREE.Vector3(-30.24,-171.34,-34.2);
		var tmp8 = new THREE.Vector3(-50.91,-236.86,-51.1);
		var tmp9 = new THREE.Vector3(-58.27,-255.68,-57.8);
		this.cameras[1].initBezier(tmp2,[tmp3,tmp4,tmp5,tmp6,tmp7,tmp8,tmp9,new THREE.Vector3(-84.52,-237.08,-78.81)]);
		var tmp10 = [new THREE.Vector3(-4.67,-333.52,-0.89),new THREE.Vector3(-13.32,-319.35,8.72),new THREE.Vector3(-5.09,-319.35,14.4),new THREE.Vector3(-5.73,-332.3,15.43)];
		var tmp11 = new THREE.Vector3(1.77,-233.9,-6.76);
		var tmp12 = new THREE.Vector3(-6.98,-219.73,2.73);
		var tmp13 = new THREE.Vector3(1.9,-220.21,3.38);
		this.cameras[2].initBezier(tmp10,[tmp11,tmp12,tmp13,new THREE.Vector3(0.94,-233.27,3.22)]);
		var tmp14 = [new THREE.Vector3(-6.28,13.98,4.39),new THREE.Vector3(-10.28,11.98,4.25),new THREE.Vector3(-11.3,12.83,8.24)];
		var tmp15 = new THREE.Vector3(-5.84,17.91,-95.54);
		var tmp16 = new THREE.Vector3(-9.84,14.91,-95.67);
		this.cameras[3].initBezier(tmp14,[tmp15,tmp16,new THREE.Vector3(-2.86,13.75,-91.68)]);
		var tmp17 = [new THREE.Vector3(57.79,-83.92,49.36),new THREE.Vector3(57.79,-83.92,49.36),new THREE.Vector3(57.79,-83.92,49.36),new THREE.Vector3(57.79,-83.92,49.36),new THREE.Vector3(57.79,-79,48.47),new THREE.Vector3(57.78,-74.14,47.31),new THREE.Vector3(57.77,-70.12,43.08),new THREE.Vector3(57.78,-64.34,41.47)];
		var tmp18 = new THREE.Vector3(57.36,-101.28,-49.12);
		var tmp19 = new THREE.Vector3(57.36,-101.28,-49.12);
		var tmp20 = new THREE.Vector3(57.36,-101.28,-49.12);
		var tmp21 = new THREE.Vector3(58.22,-101.71,-49.04);
		var tmp22 = new THREE.Vector3(57.36,-96.79,-49.93);
		var tmp23 = new THREE.Vector3(56.94,-100.86,-49.05);
		var tmp24 = new THREE.Vector3(58.19,-96.84,-53.28);
		this.cameras[4].initBezier(tmp17,[tmp18,tmp19,tmp20,tmp21,tmp22,tmp23,tmp24,new THREE.Vector3(58.2,-91.06,-54.89)]);
		var tmp25 = [new THREE.Vector3(-11.3,25.58,-12.46),new THREE.Vector3(-11.3,25.58,-12.46),new THREE.Vector3(-11.3,25.58,-12.46),new THREE.Vector3(-11.3,25.58,-12.46)];
		var tmp26 = new THREE.Vector3(-74.1,-22.52,-73.64);
		var tmp27 = new THREE.Vector3(-78.04,-12.69,-76.35);
		var tmp28 = new THREE.Vector3(-79.33,-5.73,-78.73);
		this.cameras[5].initBezier(tmp25,[tmp26,tmp27,tmp28,new THREE.Vector3(-81.39,1.39,-79.56)]);
		var tmp29 = [new THREE.Vector3(12.1,267.47,13.65),new THREE.Vector3(18.39,224.64,-5.75),new THREE.Vector3(15.11,193.82,-5.81),new THREE.Vector3(4.7,131.89,-1.36),new THREE.Vector3(-6.47,82.05,8.31),new THREE.Vector3(-10.99,37.51,12.27),new THREE.Vector3(-16.99,-9,13.07),new THREE.Vector3(-23.06,-51.85,2.15),new THREE.Vector3(-16.14,-97.34,-20.59),new THREE.Vector3(-50.98,-156.6,-51.1),new THREE.Vector3(-66.16,-176.37,-14.74),new THREE.Vector3(-74.16,-182.63,23.89)];
		var tmp30 = new THREE.Vector3(5.88,167.85,7.54);
		var tmp31 = new THREE.Vector3(9.3,125.06,-6.78);
		var tmp32 = new THREE.Vector3(1.23,94.79,-4.84);
		var tmp33 = new THREE.Vector3(-14.07,34.55,11.78);
		var tmp34 = new THREE.Vector3(-25.71,-14.43,26.25);
		var tmp35 = new THREE.Vector3(-17.92,-62.11,17.55);
		var tmp36 = new THREE.Vector3(-37.19,-106.72,6.61);
		var tmp37 = new THREE.Vector3(-20.58,-144.41,-35.63);
		var tmp38 = new THREE.Vector3(-37.45,-189.9,-51.89);
		var tmp39 = new THREE.Vector3(-102.79,-221.22,4.95);
		var tmp40 = new THREE.Vector3(-92.25,-198.02,79.34);
		this.cameras[6].initBezier(tmp29,[tmp30,tmp31,tmp32,tmp33,tmp34,tmp35,tmp36,tmp37,tmp38,tmp39,tmp40,new THREE.Vector3(-87.58,-192.21,122.52)]);
		var tmp41 = [new THREE.Vector3(34.41,75.18,-35.22),new THREE.Vector3(16.68,56.74,-33.17),new THREE.Vector3(12.14,56.74,8.91),new THREE.Vector3(16.16,-12.93,-38.03),new THREE.Vector3(1.36,-74.6,-45.32),new THREE.Vector3(-21.26,-76.54,-18.72)];
		var tmp42 = new THREE.Vector3(-21.25,-1.7,-66.71);
		var tmp43 = new THREE.Vector3(-56.38,-7.54,-56.2);
		var tmp44 = new THREE.Vector3(-57.79,-11.78,29.29);
		var tmp45 = new THREE.Vector3(-29.88,-82.7,16.85);
		var tmp46 = new THREE.Vector3(-91.03,-112.87,-44.92);
		this.cameras[7].initBezier(tmp41,[tmp42,tmp43,tmp44,tmp45,tmp46,new THREE.Vector3(-75.49,-103.27,-98.37)]);
		var tmp47 = [new THREE.Vector3(93.09,14.92,58.51),new THREE.Vector3(93.09,14.92,58.51),new THREE.Vector3(93.09,14.92,58.51),new THREE.Vector3(93.09,14.92,58.51),new THREE.Vector3(93.09,14.92,58.51),new THREE.Vector3(93.09,14.92,58.51),new THREE.Vector3(93.09,14.92,58.51)];
		var tmp48 = new THREE.Vector3(-1.36,29,87.84);
		var tmp49 = new THREE.Vector3(-5.39,29,67.56);
		var tmp50 = new THREE.Vector3(-5.52,26.84,47.71);
		var tmp51 = new THREE.Vector3(0.28,26.41,23.34);
		var tmp52 = new THREE.Vector3(5.94,19.02,9.7);
		var tmp53 = new THREE.Vector3(5.47,10.73,10.44);
		this.cameras[8].initBezier(tmp47,[tmp48,tmp49,tmp50,tmp51,tmp52,tmp53,new THREE.Vector3(7.81,4.2,7.26)]);
		var tmp54 = [new THREE.Vector3(-87.1,-75.93,96.5),new THREE.Vector3(-87.1,-75.93,96.5),new THREE.Vector3(-91.91,-75.93,91.41),new THREE.Vector3(-67.36,-77.22,89.49),new THREE.Vector3(-68.65,-77.46,84.12),new THREE.Vector3(-53.24,-77.46,91.62),new THREE.Vector3(-65.98,-76.66,95.94),new THREE.Vector3(-65.98,-76.66,95.94),new THREE.Vector3(-65.98,-76.66,95.94),new THREE.Vector3(-65.98,-76.66,95.94)];
		var tmp55 = new THREE.Vector3(-29.21,-21.83,35.49);
		var tmp56 = new THREE.Vector3(-21.73,-36.86,31.69);
		var tmp57 = new THREE.Vector3(-17.53,-68.09,25.03);
		var tmp58 = new THREE.Vector3(-13.06,-85.07,5.88);
		var tmp59 = new THREE.Vector3(-5.84,-83.56,6.55);
		var tmp60 = new THREE.Vector3(-15.15,-87.04,-0.34);
		var tmp61 = new THREE.Vector3(-17.27,-84.51,8.96);
		var tmp62 = new THREE.Vector3(-1.78,-81.46,19.42);
		var tmp63 = new THREE.Vector3(-20.92,-88.85,7.5);
		this.cameras[9].initBezier(tmp54,[tmp55,tmp56,tmp57,tmp58,tmp59,tmp60,tmp61,tmp62,tmp63,new THREE.Vector3(-33.93,-84.07,1.51)]);
		this.activeCamera = this.cameras[0];
		var materialProps = { };
		materialProps.color = DemoMain.DARK3.getHex();
		materialProps.roughness = 1;
		materialProps.metalness = 0;
		var boxTopMaterial = new THREE.MeshStandardMaterial(materialProps);
		this.boxBottomMaterial = new THREE.MeshLambertMaterial({ color : DemoMain.HILIGHT.getHex()});
		this.layers = [];
		var boxGeometry = new THREE.BoxGeometry(10,10,10);
		var _g = 0;
		while(_g < 3) {
			var i = _g++;
			var ground = new transition1_CubeGround(boxTopMaterial,this.boxBottomMaterial,this,i,boxGeometry);
			this.scene.add(ground);
			this.layers.push(ground);
			ground.position.y = -i * 100;
		}
		this.lights = [];
		var _g1 = 0;
		while(_g1 < 3) {
			var i1 = _g1++;
			var light = new THREE.PointLight(DemoMain.DARK3.getHex(),10.7,600,0.5);
			var ang = Math.PI * 2 * i1 / 3;
			light.position.x = Math.sin(ang) * 0;
			light.position.z = Math.cos(ang) * 0;
			this.scene.add(light);
			light.position.y = -100 * i1;
		}
		this.postProcessing.dof.set_focalLength(90);
		this.postProcessing.dof.set_fstop(0.04);
		this.postProcessing.dof.set_maxblur(1);
		this.postProcessing.dof.set_bias(0.3);
		this.postProcessing.dof.set_gain(0.2);
		this.postProcessing.dof.set_threshold(0.3);
		this.postProcessing.bloom.strength = 2.18;
		this.postProcessing.bloom.radius = 0.60;
		this.postProcessing.bloom.threshold = 0.47;
		this.postProcessing.distortedTV.set_blueamplify(1);
		this.postProcessing.distortedTV.set_greenamplify(1);
		this.postProcessing.distortedTV.set_distortAmount(0);
		this.postProcessing.distortedTV.set_vignAmount(0);
		this.postProcessing.distortedTV.set_offsetAmount(0.5);
		this.cubecam = new THREE.CubeCamera(0,600,1024);
		this.cubeworm = new transition1_CubeWorm2(boxGeometry);
		this.scene.add(this.cubeworm);
		this.wormObject = new THREE.Object3D();
		this.wormPath = new wl_demo_CameraController(this.wormObject);
		this.wormPath.initBezier([new THREE.Vector3(-84.15,37.09,150.55),new THREE.Vector3(-65.49,33.78,125.67),new THREE.Vector3(-65.12,61.71,80.59),new THREE.Vector3(-66.44,57,73.05),new THREE.Vector3(-66.33,47.04,54.59),new THREE.Vector3(-62.1,38.55,42.11),new THREE.Vector3(-25.08,27.46,47.36),new THREE.Vector3(20.87,23.22,59.36),new THREE.Vector3(25.19,21.67,28.95),new THREE.Vector3(26.5,25.63,-19.07),new THREE.Vector3(-2.59,19.05,-28.39),new THREE.Vector3(-6.08,3.42,-2.45),new THREE.Vector3(-6.3,-21.87,9.2),new THREE.Vector3(-6.11,-40.9,31.65),new THREE.Vector3(-32.55,-63.1,39.51),new THREE.Vector3(-34.62,-81.58,18.58),new THREE.Vector3(-13.04,-96.64,7.53),new THREE.Vector3(-1.56,-122.42,1.68),new THREE.Vector3(-1.67,-147.15,4.35),new THREE.Vector3(17.58,-156.17,23.17),new THREE.Vector3(7.23,-163.19,10.41),new THREE.Vector3(0.46,-177.9,5.33),new THREE.Vector3(-11.9,-214.59,-2.45),new THREE.Vector3(-44.52,-231.13,-12.15),new THREE.Vector3(-85.54,-226.6,-6.05),new THREE.Vector3(-119.93,-209.17,2.18),new THREE.Vector3(-139.55,-195.71,-20.01),new THREE.Vector3(-154.32,-188.91,-44.05),new THREE.Vector3(-174.32,-185.91,-44.05)],[new THREE.Vector3(-69.55,21.45,52.87),new THREE.Vector3(-31.3,30.72,31.75),new THREE.Vector3(-84.65,6.88,-0.73),new THREE.Vector3(-68.76,10.82,-15.62),new THREE.Vector3(-68.16,-7.79,-29.02),new THREE.Vector3(5.54,-10.69,-12.66),new THREE.Vector3(71.58,16.57,70.56),new THREE.Vector3(79.39,8.87,-20.45),new THREE.Vector3(17.89,39.03,-69.26),new THREE.Vector3(-71.35,14.31,-36.32),new THREE.Vector3(-51.66,-25.57,46.46),new THREE.Vector3(-4.92,-71.19,64.13),new THREE.Vector3(-4.49,-107.36,61.04),new THREE.Vector3(-46.43,-105.18,96.79),new THREE.Vector3(-114.84,-114.23,14.75),new THREE.Vector3(30.74,-131.58,-38.23),new THREE.Vector3(50.89,-172.11,-7.23),new THREE.Vector3(24.24,-216.83,-18.84),new THREE.Vector3(54.67,-199.77,68.03),new THREE.Vector3(96.1,-192,-27.34),new THREE.Vector3(-61.59,-212.44,-42.87),new THREE.Vector3(-15.75,-275.53,-9.01),new THREE.Vector3(-69.08,-292.58,-27.91),new THREE.Vector3(-141.57,-241.15,-34.11),new THREE.Vector3(-104.07,-185.13,83.04),new THREE.Vector3(-178.77,-141.29,46.12),new THREE.Vector3(-216.98,-153.85,-67.46),new THREE.Vector3(-194.14,-183.67,-135.63),new THREE.Vector3(-194.14,-183.67,-135.63)]);
		this.addTrigger(new wl_core_TimeSig(4,0,0,0,wl_core_TimeSig.RELATIVE),function(ts) {
			_gthis.switchCamTo(2,ts,wl_core_TimeSig.milliseconds(2,0,0,0));
		});
		this.addTrigger(new wl_core_TimeSig(6,0,0,0,wl_core_TimeSig.RELATIVE),function(ts1) {
			_gthis.switchCamTo(1,ts1,wl_core_TimeSig.milliseconds(2,0,0,0));
		});
		this.addTrigger(new wl_core_TimeSig(8,0,0,0,wl_core_TimeSig.RELATIVE),function(ts2) {
			_gthis.switchCamTo(3,ts2,wl_core_TimeSig.milliseconds(4,0,0,0));
		});
		this.addTrigger(new wl_core_TimeSig(12,0,0,0,wl_core_TimeSig.RELATIVE),function(ts3) {
			_gthis.switchCamTo(4,ts3,wl_core_TimeSig.milliseconds(4,0,0,0));
		});
		this.addTrigger(new wl_core_TimeSig(16,0,0,0,wl_core_TimeSig.RELATIVE),function(ts4) {
			_gthis.switchCamTo(7,ts4,wl_core_TimeSig.milliseconds(4,0,0,0));
		});
		this.addTrigger(new wl_core_TimeSig(20,0,0,0,wl_core_TimeSig.RELATIVE),function(ts5) {
			_gthis.switchCamTo(5,ts5,wl_core_TimeSig.milliseconds(4,0,0,0));
		});
		this.addTrigger(new wl_core_TimeSig(24,0,0,0,wl_core_TimeSig.RELATIVE),function(ts6) {
			_gthis.switchCamTo(6,ts6,wl_core_TimeSig.milliseconds(4,0,0,0));
		});
		this.addTrigger(new wl_core_TimeSig(28,0,0,0,wl_core_TimeSig.RELATIVE),function(ts7) {
			_gthis.switchCamTo(8,ts7,wl_core_TimeSig.milliseconds(4,0,0,0));
		});
		this.addTrigger(new wl_core_TimeSig(32,0,0,0,wl_core_TimeSig.RELATIVE),function(ts8) {
			_gthis.switchCamTo(9,ts8,wl_core_TimeSig.milliseconds(3,0,0,0));
		});
		this.addTrigger(new wl_core_TimeSig(35,0,0,0,wl_core_TimeSig.RELATIVE),function(ts9) {
			_gthis.switchCamTo(2,ts9,wl_core_TimeSig.milliseconds(2,0,0,0));
		});
		this.addTrigger(new wl_core_TimeSig(84,0,0,0,wl_core_TimeSig.ABSOLUTE),$bind(this,this.rgbshiftsmall));
		this.addTrigger(new wl_core_TimeSig(85,2,0,0,wl_core_TimeSig.ABSOLUTE),$bind(this,this.rgbshiftsmall));
		this.addTrigger(new wl_core_TimeSig(86,0,0,0,wl_core_TimeSig.ABSOLUTE),$bind(this,this.rgbshiftsmall));
		this.addTrigger(new wl_core_TimeSig(95,0,3,0,wl_core_TimeSig.ABSOLUTE),$bind(this,this.camshake));
		this.addTrigger(new wl_core_TimeSig(95,2,0,0,wl_core_TimeSig.ABSOLUTE),$bind(this,this.camshake));
		this.addTrigger(new wl_core_TimeSig(81,2,0,0,wl_core_TimeSig.ABSOLUTE),$bind(this,this.rgbshift));
		this.addTrigger(new wl_core_TimeSig(81,3,0,0,wl_core_TimeSig.ABSOLUTE),$bind(this,this.rgbshift));
		this.addTrigger(new wl_core_TimeSig(101,2,0,0,wl_core_TimeSig.ABSOLUTE),$bind(this,this.rgbshift));
		this.addTrigger(new wl_core_TimeSig(101,3,0,0,wl_core_TimeSig.ABSOLUTE),$bind(this,this.rgbshift));
		this.addTrigger(new wl_core_TimeSig(36,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.outro));
		this.addTrigger(new wl_core_TimeSig(27,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.wormin));
		this.addTrigger(new wl_core_TimeSig(4,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.speedup));
		this.addTrigger(new wl_core_TimeSig(88,2,0,0,wl_core_TimeSig.ABSOLUTE),$bind(this,this.rabble));
		this.addTrigger(new wl_core_TimeSig(96,0,0,0,wl_core_TimeSig.ABSOLUTE),$bind(this,this.rabble));
	}
	,camshake: function(ts) {
		if(this.camshakestart == 0) {
			this.camshakestart = ts.toMilliseconds();
		}
		this.camshakeon++;
	}
	,rabble: function(ts) {
		createjs.Tween.get(this).to({ blueunidistort : 1},wl_core_TimeSig.milliseconds(1,0,0,0)).wait(wl_core_TimeSig.milliseconds(1,0,0,0)).to({ blueunidistort : 0},wl_core_TimeSig.milliseconds(2,0,0,0));
	}
	,wormin: function(ts) {
		this.wormison = true;
		this.wormSpawnTime = ts.toMilliseconds();
		createjs.Tween.get(this,{ onChange : $bind(this,this.updateWormin)}).wait(wl_core_TimeSig.milliseconds(3,0,0,0)).to({ wormVal : 1},wl_core_TimeSig.milliseconds(2,0,0,0)).call($bind(this,this.wormisin));
	}
	,postInit: function() {
		wl_core_Part.prototype.postInit.call(this);
		this.cubeworm.postinit();
	}
	,updateWormin: function() {
	}
	,wormisin: function() {
		createjs.Tween.removeTweens(this);
		this.wormVal = 1;
	}
	,switchCamTo: function(cam,ts,runtime) {
		this.currentCameraRunTime = runtime;
		this.camshakeon = 0;
		this.currentCamera = cam;
		this.activeCamera = this.cameras[this.currentCamera];
		this.activeCameraStart = ts.toMilliseconds();
	}
	,start: function(ts) {
		this.stopupd = false;
		var _g = 0;
		var _g1 = this.layers;
		while(_g < _g1.length) {
			var c = _g1[_g];
			++_g;
			c.halt(false);
		}
		wl_core_Part.prototype.start.call(this,ts);
		this.switchCamTo(0,ts,wl_core_TimeSig.milliseconds(5,0,0,0));
	}
	,speedup: function(ts) {
		this.allowDistort = true;
		var _g = 0;
		var _g1 = this.layers;
		while(_g < _g1.length) {
			var c = _g1[_g];
			++_g;
			c.fastup();
		}
		this.postProcessing.distortedTV.set_offsetAmount(0.0);
	}
	,outro: function(ts) {
		this.wormOffset = wl_core_TimeSig.milliseconds(1,0,0,0);
		createjs.Tween.get(this.postProcessing.bloom).wait(wl_core_TimeSig.milliseconds(1,0,0,0)).to({ strength : 5, radius : 1, threshold : 0},wl_core_TimeSig.milliseconds(1,0,0,0));
	}
	,rgbshift: function(ts) {
		this.rgbshiftVal = 1;
		this.updatergb();
		createjs.Tween.get(this,{ onChange : $bind(this,this.updatergb)}).to({ rgbshiftVal : 0},wl_core_TimeSig.milliseconds(0,2,0,0));
	}
	,rgbshiftsmall: function(ts) {
		this.rgbshiftVal = 0.7;
		this.updatergb();
		createjs.Tween.get(this,{ onChange : $bind(this,this.updatergb)}).to({ rgbshiftVal : 0},wl_core_TimeSig.milliseconds(0,1,2,0));
	}
	,updatergb: function() {
		this.postProcessing.distortedTV.set_distortAmount(90 * this.rgbshiftVal);
		this.postProcessing.distortedTV.set_offsetAmount(15 * this.rgbshiftVal);
	}
	,update: function(ts,partial,frameTime) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime);
	}
	,render: function(ts,frameTime) {
		var camupd = (ts.toMilliseconds() - this.activeCameraStart) / this.currentCameraRunTime;
		if(this.currentCamera == 6) {
			this.activeCamera.update(0.5 + Math.sin(camupd * 2.8 + 2) * 0.5);
		} else {
			this.activeCamera.update(camupd);
		}
		if(this.wormison) {
			this.wormPath.update((ts.toMilliseconds() - this.wormSpawnTime + this.wormOffset) / wl_core_TimeSig.milliseconds(11,0,0,0));
			this.cubeworm.tick(this.wormObject.position,frameTime / 16.666666666666668,ts.toMilliseconds());
		}
		var fft = wl_sounds_SoundWL.getFFT();
		var freq = fft.frequency;
		var vign = 0;
		if(freq != null) {
			var min = Math.floor(fft.fftsize * 85 / fft.sampleRate);
			var max = Math.ceil(fft.fftsize * 125 / fft.sampleRate);
			var freqsum = 0;
			var _g1 = min;
			while(_g1 < max) freqsum += freq[_g1++];
			freqsum /= max - min;
			if(freqsum > 240) {
				vign = (freqsum - 240) / 15;
			} else {
				vign = 0;
			}
		}
		this.postProcessing.distortedTV.set_brightMultiplier(vign * 0.15);
		this.postProcessing.distortedTV.set_brightLimit(0.85);
		if(!createjs.Tween.hasActiveTweens(this) && this.allowDistort) {
			this.postProcessing.distortedTV.set_distortAmount(vign * 40);
			this.postProcessing.distortedTV.set_offsetAmount(vign * 0.9);
		}
		if(this.blueunidistort > 0) {
			this.postProcessing.distortedTV.set_distortAmount(vign * 400 * this.blueunidistort);
			this.postProcessing.distortedTV.set_offsetAmount(vign * 3.3 * this.blueunidistort);
		} else {
			this.postProcessing.distortedTV.set_blueamplify(1);
		}
		if(this.camshakeon > 0) {
			var d = (ts.toMilliseconds() - this.camshakestart) * 0.05;
			this.camera.fov = 30 + d * 0.4;
			if(this.camshakeon == 2) {
				this.camera.fov = 30 + d * 0.8;
			}
			this.camera.updateProjectionMatrix();
			console.log(this.camera.fov);
		} else {
			this.camera.fov = 30;
			this.camera.updateProjectionMatrix();
		}
		wl_core_Part.prototype.render.call(this,ts,frameTime);
	}
	,__class__: transition1_KleinCube
});
var windows_CubeWorm = function() {
	this.cur = 0;
	THREE.Object3D.call(this);
	this.initializeControls();
};
windows_CubeWorm.__name__ = ["windows","CubeWorm"];
windows_CubeWorm.__super__ = THREE.Object3D;
windows_CubeWorm.prototype = $extend(THREE.Object3D.prototype,{
	initializeControls: function() {
		this.cubes = [];
		var params = { };
		params.color = 16777215;
		this.material = new THREE.MeshBasicMaterial(params);
		var box = new THREE.BoxGeometry(1,1,1);
		var _g = 0;
		while(_g < 100) {
			++_g;
			var m = new THREE.Mesh(box,this.material);
			this.add(m);
			m.visible = false;
			this.cubes.push(m);
		}
	}
	,postinit: function() {
		this.material.envMap = wl_core_Demo.instance.getPart("Windows").cubecam.renderTarget.texture;
	}
	,spawn: function(x,y,z,sadd) {
		var _g = 0;
		while(_g < 3) {
			var i = _g++;
			this.cur = (this.cur + 1) % this.cubes.length;
			var next = this.cubes[this.cur];
			next.position.x = i * 3;
			next.position.rndz = wl_util_Random.nextFloat() * 4 - 2;
			next.position.rndy = wl_util_Random.nextFloat() * 4 - 2;
			next.rotateX(wl_util_Random.nextFloat() * Math.PI);
			next.rotateY(wl_util_Random.nextFloat() * Math.PI);
			next.scale.x = next.scale.y = next.scale.z = 0.001;
			var ns = wl_util_Random.nextFloat() * 1.1 + 2;
			createjs.Tween.get(next.scale).to({ x : ns, y : ns, z : ns},wl_core_TimeSig.milliseconds(0,2,0,0),createjs.Ease.getBackOut(17));
			next.visible = true;
		}
	}
	,tick: function(delta,ts) {
		var i = 0;
		var _g = 0;
		var _g1 = this.cubes;
		while(_g < _g1.length) {
			var c = _g1[_g];
			++_g;
			++i;
			c.position.x -= 0.3 * delta;
			c.position.y = Math.sin(ts + c.position.x * 0.3) * 4 + c.position.rndy;
			c.position.z = Math.cos(ts + c.position.x * 0.2) * 8 + c.position.rndz;
			c.rotateX(delta * 0.02);
		}
	}
	,__class__: windows_CubeWorm
});
var windows_Windows = function() {
	this.curcam = 0;
	this.cameras = [];
	wl_core_Part.call(this);
};
windows_Windows.__name__ = ["windows","Windows"];
windows_Windows.__super__ = wl_core_Part;
windows_Windows.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.initComposer(this.getComposerList({ dof : true, bloom : true, standard : true, distortedTV : true}));
		this.cameras.push(new wl_demo_CameraController(this.camera));
		this.cameras.push(new wl_demo_CameraController(this.camera));
		this.cameras.push(new wl_demo_CameraController(this.camera));
		var tmp = new THREE.Vector3(0,0,-30);
		this.cameras[0].initStatic(tmp,new THREE.Vector3());
		var tmp1 = new THREE.Vector3(10,60,-30);
		this.cameras[1].initStatic(tmp1,new THREE.Vector3());
		var tmp2 = new THREE.Vector3(0,0,20);
		this.cameras[2].initStatic(tmp2,new THREE.Vector3());
		this.cubecam = new THREE.CubeCamera(10,400,1024);
		this.frameMaterial = new THREE.MeshBasicMaterial({ color : 0});
		this.windowMaterials = [];
		this.layers = [];
		var _g = 0;
		while(_g < 5) {
			var i = _g++;
			this.createLayer(i,i % 3 * 2,i % 3 * 3);
			var layer = this.layers[i];
			layer.container.scale.x = layer.container.scale.z = layer.container.scale.y = i * 0.3 + 0.4;
		}
		this.camera.position.z = 50;
		this.camera.lookAt(new THREE.Vector3());
		this.camera.far = 150;
		this.worm = new windows_CubeWorm();
		this.scene.add(this.worm);
		var om = { color : DemoMain.HILIGHT.clone().multiplyScalar(1).getHex(), side : THREE.DoubleSide};
		this.ccb = new THREE.Mesh(new THREE.BoxGeometry(220,220,220),new THREE.MeshBasicMaterial(om));
		this.scene.add(this.ccb);
		this.addTrigger(new wl_core_TimeSig(-1,0,-1,-1,wl_core_TimeSig.PATTERN),$bind(this,this.onHalfBar));
		this.addTrigger(new wl_core_TimeSig(-1,2,-1,-1,wl_core_TimeSig.PATTERN),$bind(this,this.onHalfBar));
		this.addTrigger(new wl_core_TimeSig(-1,0,-1,-1,wl_core_TimeSig.PATTERN),$bind(this,this.onbar));
		this.addTrigger(new wl_core_TimeSig(-1,-1,0,-1,wl_core_TimeSig.PATTERN),$bind(this,this.ontick));
		this.addTrigger(new wl_core_TimeSig(-1,-1,1,-1,wl_core_TimeSig.PATTERN),$bind(this,this.ontick));
		this.addTrigger(new wl_core_TimeSig(-1,-1,2,-1,wl_core_TimeSig.PATTERN),$bind(this,this.ontick));
		this.addTrigger(new wl_core_TimeSig(-1,-1,3,-1,wl_core_TimeSig.PATTERN),$bind(this,this.ontick));
		this.rcc = new wl_demo_RandomCameraController(this.camera,10,[this.worm],143,[wl_demo_CameraController.BEZIER],[40,100],new THREE.Box3(new THREE.Vector3(20,-30,-30),new THREE.Vector3(60,30,30)));
		this.postProcessing.bloom.strength = 1.8;
		this.postProcessing.bloom.threshold = 0.36;
		this.postProcessing.bloom.radius = 0.3;
		this.postProcessing.distortedTV.set_blueamplify(1);
		this.postProcessing.distortedTV.set_greenamplify(1);
		this.postProcessing.distortedTV.set_distortAmount(0);
		this.postProcessing.distortedTV.set_vignAmount(0);
		this.postProcessing.distortedTV.set_offsetAmount(0.0);
	}
	,onbar: function(ts) {
		this.rcc.swap();
		this.curcam = (this.curcam + 1) % this.cameras.length;
		this.camera.fov = [40,30,125][this.curcam];
		this.camera.updateProjectionMatrix();
		var _g = 0;
		var _g1 = this.layers;
		while(_g < _g1.length) ++_g;
	}
	,postInit: function() {
		wl_core_Part.prototype.postInit.call(this);
		this.worm.postinit();
	}
	,ontick: function(ts) {
		this.worm.spawn(Math.sin(ts.toMilliseconds() * 0.002) * 6.7,Math.sin(ts.toMilliseconds() * 0.001 + Math.cos(ts.toMilliseconds() * 0.003)) * 2,Math.cos(ts.toMilliseconds() * 0.001) * 7,Math.sin(ts.toMilliseconds() / 1000));
	}
	,createLayer: function(layer,rx,ry) {
		var wl1 = { };
		wl1.frames = [];
		wl1.speed = layer;
		wl1.windows = [];
		wl1.container = new THREE.Object3D();
		this.layers.push(wl1);
		var windowGeometry = new THREE.PlaneGeometry(1,1);
		var frameGeometry = new THREE.BoxGeometry(1,1,1);
		var _g = 0;
		while(_g < 15) {
			var j = _g++;
			var _g1 = 0;
			while(_g1 < 10) {
				var i = _g1++;
				var frame = new THREE.Object3D();
				var top = new THREE.Mesh(frameGeometry,this.frameMaterial);
				var bottom = new THREE.Mesh(frameGeometry,this.frameMaterial);
				var left = new THREE.Mesh(frameGeometry,this.frameMaterial);
				var wmp = { };
				wmp.opacity = 0.0;
				wmp.color = (wl_util_Random.next() % 4 == 0?DemoMain.HILIGHT:[DemoMain.SURFACE,DemoMain.WHITE,DemoMain.DARK1,DemoMain.DARK2][wl_util_Random.next() % 3]).getHex();
				wmp.side = THREE.DoubleSide;
				wmp.transparent = true;
				var wm = new THREE.MeshBasicMaterial(wmp);
				var $window = new THREE.Mesh(windowGeometry,wm);
				this.windowMaterials.push(wm);
				top.scale.x = 500;
				bottom.scale.x = 100;
				left.scale.y = 590;
				top.position.y = -5;
				bottom.position.y = 5;
				left.position.x = -5;
				$window.scale.x = 9;
				$window.scale.y = 9;
				frame.add($window);
				frame.position.z = layer * 20 - 50;
				if(frame.position.z == 0) {
					frame.position.z += 120;
				}
				frame.position.x = i * 10;
				frame.position.y = j * 10 - 50;
				wl1.container.add(frame);
				wl1.frames.push(frame);
			}
		}
		this.scene.add(wl1.container);
	}
	,onHalfBar: function(ts) {
		var _g = 0;
		while(_g < 70) {
			++_g;
			var mat = this.windowMaterials[wl_util_Random.next() % this.windowMaterials.length];
			mat.opacity = 1.0;
			createjs.Tween.removeTweens(mat);
			createjs.Tween.get(mat).to({ opacity : 0.0},wl_core_TimeSig.milliseconds(0,3,0,0),createjs.Ease.linear);
		}
	}
	,update: function(ts,partial,frameTime) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime);
	}
	,render: function(ts,frameTime) {
		this.ccb.visible = true;
		this.ccb.material.opacity = 1;
		this.worm.visible = false;
		wl_core_Graphics.instance.renderer.gammaOutput = false;
		this.cubecam.updateCubeMap(wl_core_Graphics.instance.renderer,this.scene);
		this.worm.visible = true;
		this.ccb.visible = false;
		this.rcc.updateLength(wl_core_TimeSig.milliseconds(1,0,0,0));
		this.worm.rotation.x = ts.toMilliseconds() * 0.001 + Math.cos(ts.toMilliseconds() * 0.002) * 2;
		this.worm.tick(frameTime / 16.666666666666668,ts.toMilliseconds() / 1000);
		var _g = 0;
		var _g1 = this.layers;
		while(_g < _g1.length) {
			var wl1 = _g1[_g];
			++_g;
			wl1.container.position.y = Math.sin(ts.toMilliseconds() * 0.001 + this.layers.indexOf(wl1)) * 3;
			var _g3 = 0;
			var _g2 = wl1.frames.length;
			while(_g3 < _g2) {
				var i = _g3++;
				var f = wl1.frames[i];
				f.position.x = (i % 15 * 10 + ts.toMilliseconds() * 0.02) % 150 - 75.;
			}
		}
		var fft = wl_sounds_SoundWL.getFFT();
		var freq = fft.frequency;
		var vign = 0;
		if(freq != null) {
			var min = Math.floor(fft.fftsize * 55 / fft.sampleRate);
			var max = Math.ceil(fft.fftsize * 85 / fft.sampleRate);
			var freqsum = 0;
			var _g11 = min;
			while(_g11 < max) freqsum += freq[_g11++];
			freqsum /= max - min;
			if(freqsum > 245) {
				vign = (freqsum - 245) / 10;
			} else {
				vign = 0;
			}
		}
		this.postProcessing.distortedTV.set_brightMultiplier(vign * 0.1);
		this.postProcessing.distortedTV.set_distortAmount(vign * 40);
		this.postProcessing.distortedTV.set_offsetAmount(vign * 0.45);
		this.postProcessing.distortedTV.set_brightLimit(0.35);
		wl_core_Part.prototype.render.call(this,ts,frameTime);
	}
	,__class__: windows_Windows
});
var wl_core_Assets = $hx_exports["kvg"]["core"]["assets"] = function() {
};
wl_core_Assets.__name__ = ["wl","core","Assets"];
wl_core_Assets.register = function(id,type,data,compressed) {
	if(compressed) {
		throw new js__$Boot_HaxeError("Compression not implemented.");
	}
	if(type == "png" || type == "jpg") {
		var img = new Image();
		img.src = "data:image/" + (type == "jpg"?"jpeg":type) + ";base64," + data;
		var _this = wl_core_Assets._assets;
		if(__map_reserved[id] != null) {
			_this.setReserved(id,img);
		} else {
			_this.h[id] = img;
		}
	} else if(type == "mp3" || type == "ogg") {
		var _this1 = wl_core_Assets._assets;
		if(__map_reserved[id] != null) {
			_this1.setReserved(id,data);
		} else {
			_this1.h[id] = data;
		}
	} else if(type == "json") {
		var _this2 = wl_core_Assets._assets;
		var value = JSON.parse(data);
		if(__map_reserved[id] != null) {
			_this2.setReserved(id,value);
		} else {
			_this2.h[id] = value;
		}
	} else if(type == "object") {
		var _this3 = wl_core_Assets._assets;
		if(__map_reserved[id] != null) {
			_this3.setReserved(id,data);
		} else {
			_this3.h[id] = data;
		}
	}
};
wl_core_Assets.get = function(id) {
	var _this = wl_core_Assets._assets;
	if(!(__map_reserved[id] != null?_this.existsReserved(id):_this.h.hasOwnProperty(id))) {
		console.log("Asset " + id + " not found");
	}
	var _this1 = wl_core_Assets._assets;
	if(__map_reserved[id] != null) {
		return _this1.getReserved(id);
	} else {
		return _this1.h[id];
	}
};
wl_core_Assets.getTexture = function(id) {
	var img = wl_core_Assets.get(id);
	if(img == null) {
		throw new js__$Boot_HaxeError("Texture " + id + " not found.");
	}
	var tex = new THREE.Texture(img);
	tex.needsUpdate = true;
	return tex;
};
wl_core_Assets.prototype = {
	__class__: wl_core_Assets
};
var wl_core_Config = $hx_exports["wl"]["Config"] = function() {
	throw new js__$Boot_HaxeError("Config is static only.");
};
wl_core_Config.__name__ = ["wl","core","Config"];
wl_core_Config.prototype = {
	__class__: wl_core_Config
};
var wl_core_Demo = $hx_exports["Demo"] = function() {
	this.previousUpdate = 0;
	this.partMap = new haxe_ds_StringMap();
	wl_core_Demo.instance = this;
};
wl_core_Demo.__name__ = ["wl","core","Demo"];
wl_core_Demo.prototype = {
	getPart: function(name) {
		var _this = this.partMap;
		if(__map_reserved[name] != null) {
			return _this.getReserved(name);
		} else {
			return _this.h[name];
		}
	}
	,init: function(container) {
		wl_util_Random.init(wl_core_Config.SEED);
		this.graphics = new wl_core_Graphics(container);
		wl_sounds_SoundWL.onSoundComplete.connect($bind(this,this.onSoundEnd));
		this.previousTS = wl_core_TimeSig.create(0);
		this.graphics.onRender.connect($bind(this,this.onRender));
		this.initializeParts();
		if(wl_core_Config.DEBUG) {
			this.initializeDebug();
		}
		createjs.Ticker.setPaused(true);
		this.initDemoComposer();
	}
	,initDemoComposer: function() {
		this.overlay = new THREE.Scene();
		var aspect = wl_core_Config.RESOLUTION[1] / wl_core_Config.RESOLUTION[0];
		this.overlayCamera = new THREE.OrthographicCamera(0,1,0,aspect,1,1000);
		this.demoComposer = new THREE.EffectComposer(this.graphics.renderer,this.graphics.getRenderTarget());
		this.texturePass = new THREE.TexturePass(null,1);
		this.demoComposer.addPass(this.texturePass);
		var copyPass = new THREE.ShaderPass(THREE.CopyShader);
		copyPass.renderToScreen = true;
		this.demoComposer.addPass(copyPass);
		this.overlayCamera.position.z = 10;
		this.overlayCamera.lookAt(new THREE.Vector3());
	}
	,onSoundEnd: function() {
		this.end();
	}
	,initializeDebug: function() {
		wl_debug_Debug.init(this);
		wl_debug_ManualControl.init();
	}
	,initializeParts: function() {
		this.parts = [];
		var _g = 0;
		var _g1 = wl_core_Config.TIMELINE;
		while(_g < _g1.length) {
			var tl = _g1[_g];
			++_g;
			var id;
			if(tl.partId == null) {
				var o = tl.part;
				id = Type.getClassName(o == null?null:js_Boot.getClass(o));
			} else {
				id = tl.partId;
			}
			tl.part.name = id;
			var _this = this.partMap;
			var key = tl.partId;
			var value = tl.part;
			if(__map_reserved[key] != null) {
				_this.setReserved(key,value);
			} else {
				_this.h[key] = value;
			}
			this.parts.push(tl.part);
		}
		var _g2 = 0;
		var _g11 = this.parts;
		while(_g2 < _g11.length) {
			var part = _g11[_g2];
			++_g2;
			part.init();
		}
		var _g3 = 0;
		var _g12 = this.parts;
		while(_g3 < _g12.length) {
			var part1 = _g12[_g3];
			++_g3;
			part1.render(this.previousTS,0);
		}
		var _g4 = 0;
		var _g13 = this.parts;
		while(_g4 < _g13.length) {
			var part2 = _g13[_g4];
			++_g4;
			part2.postInit();
		}
	}
	,start: function() {
		this.previousRts = this.parts[0];
		this.graphics.start();
		this.updateTimer = new haxe_Timer(Math.floor(1000 / wl_core_Config.FPS));
		this.updateTimer.run = $bind(this,this.update);
		wl_sounds_SoundWL.start();
		window.document.getElementById("demo").style.display = "block";
	}
	,end: function() {
		this.graphics.stop();
		this.updateTimer.stop();
	}
	,onRender: function(time) {
		createjs.Tween.tick(time,false);
		var rts = null;
		var _g = 0;
		var _g1 = this.parts;
		while(_g < _g1.length) {
			var p = _g1[_g];
			++_g;
			if(p.inTransition) {
				p.render(this.previousTS,time);
			} else if(p.running) {
				if(rts == null && p.renderToScreen) {
					rts = p;
				} else {
					p.render(this.previousTS,time);
				}
			}
		}
		if(rts == null) {
			rts = this.previousRts;
		}
		if(rts != null) {
			this.previousRts = rts;
			rts.render(this.previousTS,time);
		}
		this.texturePass.setTexture(rts.renderTo);
		this.demoComposer.render();
		this.graphics.renderer.autoClearColor = false;
		this.graphics.renderer.render(this.overlay,this.overlayCamera);
		this.graphics.renderer.autoClearColor = true;
		if(wl_core_Config.DEBUG) {
			wl_debug_Debug.onrender();
		}
	}
	,update: function() {
		var ts = wl_sounds_SoundWL.getPosition();
		var ms = ts.toMilliseconds();
		var frameTime = ms - this.previousUpdate;
		this.previousUpdate = ms;
		var _g1 = 0;
		var _g = wl_core_Config.TIMELINE.length;
		while(_g1 < _g) {
			var tl = wl_core_Config.TIMELINE[_g1++];
			if(ts.isInside(tl.runOn,tl.runOff)) {
				var p = tl.part;
				p.timeline = tl;
				var inTransition = ts.isInside(tl.runOn,tl.rtsOn) || ts.isInside(tl.rtsOff,tl.runOff);
				p.setRenderToScreen(tl.renderToScreen && !inTransition);
				if(!p.running) {
					p.start(ts);
				}
				p.isActive = true;
			}
		}
		var _g2 = 0;
		var _g11 = this.parts;
		while(_g2 < _g11.length) {
			var p1 = _g11[_g2];
			++_g2;
			if(p1.isActive) {
				var timespan = p1.timeline.runOff.toMilliseconds() - p1.timeline.runOn.toMilliseconds();
				p1.update(ts,(ts.toMilliseconds() - p1.timeline.runOn.toMilliseconds()) / timespan,frameTime);
			} else if(p1.running) {
				p1.stop();
			}
			p1.isActive = false;
		}
		while(this.previousTS.isSmallerThan(ts)) {
			var _g3 = 0;
			var _g12 = this.parts;
			while(_g3 < _g12.length) {
				var p2 = _g12[_g3];
				++_g3;
				if(p2.running) {
					var tmp = p2.triggers.keys();
					while(tmp.hasNext()) {
						var key = tmp.next();
						var matches = key.matchesPattern(this.previousTS,p2.timeline.runOn);
						if(matches && !key.triggered) {
							var triggers = p2.triggers.h[key.__id__];
							key.triggered = true;
							var _g21 = 0;
							while(_g21 < triggers.length) {
								var toCall = triggers[_g21];
								++_g21;
								toCall(this.previousTS);
							}
						} else if(!matches) {
							key.triggered = false;
						}
					}
				}
			}
			this.previousTS.addTicks(1);
		}
		if(wl_core_Config.DEBUG) {
			wl_debug_Debug.onupdate();
		}
	}
	,__class__: wl_core_Demo
};
var wl_core_Graphics = function(container) {
	this.last = 0;
	this.stopped = true;
	this.container = container;
	if(wl_core_Graphics.instance == null) {
		wl_core_Graphics.instance = this;
	} else {
		console.log("Creating multiple Graphics instances. Are you sure?");
	}
	this.initGraphics();
};
wl_core_Graphics.__name__ = ["wl","core","Graphics"];
wl_core_Graphics.prototype = {
	initGraphics: function() {
		this.onRender = new wl_core_Signal();
		this.interval = 1000 / wl_core_Config.FPS;
		var params = { };
		params.antialias = wl_core_Config.ANTIALIAS;
		params.logarithmicDepthBuffer = true;
		this.renderer = new THREE.WebGLRenderer(params);
		this.renderer.setClearColor(0);
		this.renderer.autoClear = false;
		this.renderer.shadowMap.enabled = wl_core_Config.ENABLE_SHADOWS;
		this.renderer.shadowMap.type = THREE.PCFShadowMap;
		this.renderer.setSize(wl_core_Config.RESOLUTION[0],wl_core_Config.RESOLUTION[1],true);
		this.canvas = this.renderer.domElement;
		this.canvas.id = "demoCanvas";
		this.depthMaterial = new THREE.MeshDepthMaterial();
	}
	,start: function() {
		this.last = 0;
		this.stopped = false;
		this.renderLoop(0);
	}
	,stop: function() {
		this.renderer.clear();
		this.stopped = true;
	}
	,renderLoop: function(time) {
		this.delta = time - this.last;
		if(wl_core_Config.FPS < 0 || this.delta >= this.interval) {
			this.last = time;
			this.onRender.emit(this.delta);
		}
		if(!this.stopped) {
			window.requestAnimationFrame($bind(this,this.renderLoop));
		}
	}
	,getRenderTarget: function() {
		var options = { };
		options.stencilBuffer = true;
		options.minFilter = THREE.LinearFilter;
		options.magFilter = THREE.LinearFilter;
		options.format = THREE.RGBFormat;
		return new THREE.WebGLRenderTarget(wl_core_Config.RESOLUTION[0],wl_core_Config.RESOLUTION[1],options);
	}
	,getRenderTargetCube: function() {
		return new THREE.WebGLRenderTargetCube(1024,1024,{ });
	}
	,__class__: wl_core_Graphics
};
var wl_core_TimeSig = $hx_exports["wl"]["TimeSig"] = function(bar,beat,tick,delay,pattern) {
	this.triggered = false;
	this.delay = 0;
	this.set_bar(bar == null?0:bar);
	this.set_beat(beat == null?0:beat);
	this.set_tick(tick == null?0:tick);
	this.delay = delay == null?0:delay;
	this.pattern = pattern == null?wl_core_TimeSig.ABSOLUTE:pattern;
};
wl_core_TimeSig.__name__ = ["wl","core","TimeSig"];
wl_core_TimeSig.create = function(time) {
	return new wl_core_TimeSig().fromTime(time);
};
wl_core_TimeSig.milliseconds = function(bar,beat,tick,delay) {
	return (bar * wl_core_Config.BEATS_PER_BAR / wl_core_Config.BEATS_PER_MINUTE + beat / wl_core_Config.BEATS_PER_MINUTE + tick / wl_core_Config.TICKS_PER_BEAT / wl_core_Config.BEATS_PER_MINUTE) * 60 * 1000 + Math.floor(delay / 255 * (60000 / wl_core_Config.BEATS_PER_MINUTE / wl_core_Config.TICKS_PER_BEAT));
};
wl_core_TimeSig.prototype = {
	set_beat: function(value) {
		this.beat = value;
		this.adjust();
		return this.beat;
	}
	,set_bar: function(value) {
		this.bar = value;
		this.adjust();
		return this.bar;
	}
	,set_tick: function(value) {
		this.tick = value;
		this.adjust();
		return this.tick;
	}
	,adjust: function() {
	}
	,matchesPattern: function(time,begin) {
		if(this.pattern == wl_core_TimeSig.ABSOLUTE) {
			return this.equals(time);
		} else if(this.pattern == wl_core_TimeSig.RELATIVE) {
			if(time.bar == begin.bar + this.bar && time.beat == begin.beat + this.beat) {
				return time.tick == begin.tick + this.tick;
			} else {
				return false;
			}
		} else if(this.pattern == wl_core_TimeSig.PATTERN) {
			if((this.bar == -1 || time.bar % this.bar == 0) && (this.beat == -1 || time.beat % wl_core_Config.BEATS_PER_BAR == this.beat)) {
				if(this.tick != -1) {
					return time.tick % wl_core_Config.TICKS_PER_BEAT == this.tick;
				} else {
					return true;
				}
			} else {
				return false;
			}
		}
		return false;
	}
	,add: function(ts) {
		this.addBars(ts.bar);
		this.addBeats(ts.beat);
		this.addTicks(ts.tick);
	}
	,addBars: function(bars) {
		var _g = this;
		_g.set_bar(_g.bar + bars);
	}
	,addBeats: function(beats) {
		var _g = this;
		_g.set_beat(_g.beat + beats);
		var _g1 = this;
		_g1.set_bar(_g1.bar + Math.floor(this.beat / wl_core_Config.BEATS_PER_BAR));
		var _g2 = this;
		_g2.set_beat(_g2.beat % wl_core_Config.BEATS_PER_BAR);
	}
	,addTicks: function(ticks) {
		var _g = this;
		_g.set_tick(_g.tick + ticks);
		while(this.tick >= wl_core_Config.TICKS_PER_BEAT) {
			var _g1 = this;
			_g1.set_tick(_g1.tick - wl_core_Config.TICKS_PER_BEAT);
			var _g2 = this;
			_g2.set_beat(_g2.beat + 1);
		}
		while(this.beat >= wl_core_Config.BEATS_PER_BAR) {
			var _g3 = this;
			_g3.set_beat(_g3.beat - wl_core_Config.BEATS_PER_BAR);
			var _g4 = this;
			_g4.set_bar(_g4.bar + 1);
		}
	}
	,subtract: function(ts) {
		this.subtractBars(ts.bar);
		this.subtractBeats(ts.beat);
		this.subtractTicks(ts.tick);
	}
	,subtractBars: function(bars) {
		var _g = this;
		_g.set_bar(_g.bar - bars);
	}
	,subtractBeats: function(beats) {
		var _g = this;
		_g.set_beat(_g.beat - beats);
		while(this.beat < 0) {
			var _g1 = this;
			_g1.set_bar(_g1.bar - 1);
			var _g2 = this;
			_g2.set_beat(_g2.beat + wl_core_Config.BEATS_PER_BAR);
		}
	}
	,subtractTicks: function(ticks) {
		var _g = this;
		_g.set_tick(_g.tick - ticks);
		while(this.tick < 0) {
			var _g1 = this;
			_g1.set_tick(_g1.tick + wl_core_Config.TICKS_PER_BEAT);
			var _g2 = this;
			_g2.set_beat(_g2.beat - 1);
		}
		while(this.beat < 0) {
			var _g3 = this;
			_g3.set_bar(_g3.bar - 1);
			var _g4 = this;
			_g4.set_beat(_g4.beat + wl_core_Config.BEATS_PER_BAR);
		}
	}
	,fromTime: function(time) {
		var totalBeats = wl_core_Config.BEATS_PER_MINUTE * time;
		var comp = time < 0?Math.ceil:Math.floor;
		this.set_bar(comp(totalBeats / wl_core_Config.BEATS_PER_BAR));
		this.set_beat(comp(totalBeats % wl_core_Config.BEATS_PER_BAR));
		this.set_tick(comp((totalBeats - comp(totalBeats)) * wl_core_Config.TICKS_PER_BEAT));
		this.delay = 0;
		this.delay = Math.floor(255 * (time * 60 * 1000 - this.toMilliseconds()) / (60000 / wl_core_Config.BEATS_PER_MINUTE / wl_core_Config.TICKS_PER_BEAT) % 255);
		return this;
	}
	,isInside: function(begin,end) {
		if(this.isSmallerThan(end)) {
			return this.isLargerThan(begin);
		} else {
			return false;
		}
	}
	,isSmallerThan: function(other) {
		var ticks = this.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + this.beat * wl_core_Config.TICKS_PER_BEAT + this.tick;
		var tickso = other.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + other.beat * wl_core_Config.TICKS_PER_BEAT + other.tick;
		if(ticks >= tickso) {
			if(ticks == tickso) {
				return this.delay < other.delay;
			} else {
				return false;
			}
		} else {
			return true;
		}
	}
	,isLargerThan: function(other) {
		var ticks = this.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + this.beat * wl_core_Config.TICKS_PER_BEAT + this.tick;
		var tickso = other.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + other.beat * wl_core_Config.TICKS_PER_BEAT + other.tick;
		if(ticks <= tickso) {
			if(ticks == tickso) {
				return this.delay >= other.delay;
			} else {
				return false;
			}
		} else {
			return true;
		}
	}
	,toMilliseconds: function() {
		return (this.bar * wl_core_Config.BEATS_PER_BAR / wl_core_Config.BEATS_PER_MINUTE + this.beat / wl_core_Config.BEATS_PER_MINUTE + this.tick / wl_core_Config.TICKS_PER_BEAT / wl_core_Config.BEATS_PER_MINUTE) * 60 * 1000 + Math.floor(this.delay / 255 * (60000 / wl_core_Config.BEATS_PER_MINUTE / wl_core_Config.TICKS_PER_BEAT));
	}
	,equals: function(other) {
		return this.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + this.beat * wl_core_Config.TICKS_PER_BEAT + this.tick == other.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + other.beat * wl_core_Config.TICKS_PER_BEAT + other.tick;
	}
	,clone: function() {
		return new wl_core_TimeSig(this.bar,this.beat,this.tick,this.delay,this.pattern);
	}
	,toString: function(full) {
		return this.bar + ":" + this.beat + ":" + this.tick + (full?" / " + this.delay + "\n[" + this.pattern + "]":"");
	}
	,__class__: wl_core_TimeSig
};
var wl_debug_Debug = function() {
};
wl_debug_Debug.__name__ = ["wl","debug","Debug"];
wl_debug_Debug.init = function(demo) {
	wl_debug_Debug.gui = new dat.gui.GUI();
	window.document.addEventListener("keydown",wl_debug_Debug.onKeyDown);
	wl_debug_Debug.debugDiv = $(".debug");
	wl_debug_Debug.debugTimeSig = wl_debug_Debug.debugDiv.find("#debug_timesig");
	var tldiv = wl_debug_Debug.debugDiv.find("#timeline_parts");
	var _g = 0;
	var _g1 = wl_core_Config.TIMELINE;
	while(_g < _g1.length) {
		var tl = _g1[_g];
		++_g;
		var tlel = $("<li>" + Std.string(tl) + "</li>");
		tldiv.append(tlel);
		tlel.click(wl_debug_Debug.tlClick(tl));
		wl_debug_Debug.datGuiPart(tl.part);
	}
	wl_debug_Debug.stats = new Stats();
	wl_debug_Debug.stats.showPanel(1);
	wl_debug_Debug.stats.dom.style.position = "absolute";
	wl_debug_Debug.stats.dom.style.bottom = "0px";
	wl_debug_Debug.stats.dom.style.top = null;
	wl_debug_Debug.debugDiv.eq(0).append(wl_debug_Debug.stats.dom);
	wl_debug_Debug.stats.begin();
};
wl_debug_Debug.datGuiPart = function(part) {
	var folder = wl_debug_Debug.gui.addFolder(part.name);
	var composer = Reflect.field(part,"composer");
	if(composer != null) {
		var _g = 0;
		var _g1 = composer.passes;
		while(_g < _g1.length) {
			var pass = _g1[_g];
			++_g;
			if(pass.setupDatGui != null) {
				pass.setupDatGui(folder);
			}
		}
	}
	part.setupDatGui(folder);
};
wl_debug_Debug.tlClick = function(tl) {
	return function() {
		var curtime = wl_sounds_SoundWL.instance.getPosition();
		var tlpos = tl.rtsOn.toMilliseconds();
		wl_sounds_SoundWL.instance.setPosition(tlpos);
		createjs.Tween.tick(Math.floor(tlpos - curtime),false);
		wl_core_Demo.instance.previousTS.fromTime(wl_sounds_SoundWL.instance.getPosition() / 1000 / 60 - wl_core_Config.MUSIC_BEGIN / 1000 / 60);
	};
};
wl_debug_Debug.onupdate = function() {
	var ts = wl_sounds_SoundWL.getPosition();
	wl_debug_Debug.debugTimeSig.html(StringTools.replace(ts.toString(),"\n","<br/>") + "<br/>" + Math.round(ts.toMilliseconds() / 100) / 10 + "s");
};
wl_debug_Debug.onrender = function() {
	wl_debug_Debug.stats.update();
	wl_debug_ManualControl.update();
};
wl_debug_Debug.onKeyDown = function(e) {
	if(e.keyCode == 90) {
		console.log("Time captured: " + Std.string(wl_core_Demo.instance.previousTS));
	}
	if(e.keyCode == 109 || e.keyCode == 188) {
		if(wl_sounds_SoundWL.instance != null) {
			wl_sounds_SoundWL.instance.setPosition(wl_sounds_SoundWL.instance.getPosition() - 5000);
			createjs.Tween.tick(-5000,false);
			wl_core_Demo.instance.previousTS.fromTime(wl_sounds_SoundWL.instance.getPosition() / 1000 / 60 - wl_core_Config.MUSIC_BEGIN / 1000 / 60);
		}
	}
	if(e.keyCode == 107 || e.keyCode == 190) {
		if(wl_sounds_SoundWL.instance != null) {
			wl_sounds_SoundWL.instance.setPosition(wl_sounds_SoundWL.instance.getPosition() + 5000);
			createjs.Tween.tick(5000,false);
			wl_core_Demo.instance.previousTS.fromTime(wl_sounds_SoundWL.instance.getPosition() / 1000 / 60 - wl_core_Config.MUSIC_BEGIN / 1000 / 60);
		}
	}
	if(e.keyCode == 32) {
		wl_debug_Debug.paused = !wl_debug_Debug.paused;
		wl_sounds_SoundWL.instance.paused = wl_debug_Debug.paused;
		createjs.Tween.removeAllTweens();
	}
};
wl_debug_Debug.prototype = {
	__class__: wl_debug_Debug
};
var wl_debug_ManualControl = function() {
	throw new js__$Boot_HaxeError("Manual control is static");
};
wl_debug_ManualControl.__name__ = ["wl","debug","ManualControl"];
wl_debug_ManualControl.init = function() {
	if(wl_debug_ManualControl.inited) {
		return;
	}
	wl_debug_ManualControl.inited = true;
	window.document.addEventListener("keydown",wl_debug_ManualControl.onKeyDown);
	window.document.getElementById("demo").addEventListener("mousedown",wl_debug_ManualControl.onMouseDown);
};
wl_debug_ManualControl.onMouseDown = function(event) {
	console.log("mouse down");
	window.document.getElementById("demo").childNodes[0].requestPointerLock();
	window.document.addEventListener("mouseup",wl_debug_ManualControl.onMouseUp);
	window.document.getElementById("demo").addEventListener("mouseup",wl_debug_ManualControl.onMouseUp);
	event.preventDefault();
	event.stopPropagation();
	var _g1 = 0;
	var _g = wl_debug_ManualControl.parts.length;
	while(_g1 < _g) {
		var i = _g1++;
		var p = wl_debug_ManualControl.parts[i];
		var control = wl_debug_ManualControl.fpsControls[i];
		var lookingTo = new THREE.Vector3(0,0,-1);
		lookingTo = p.camera.getWorldDirection();
		control.enabled = p.running;
		var x = lookingTo.x;
		var y = lookingTo.y;
		var z = lookingTo.z;
		var lat = 90 - Math.acos(y / 1) * 180 / Math.PI;
		var lon = (270 + Math.atan2(x,z) * 180 / Math.PI) % 360 - 180;
		control.lat = lat;
		control.lon = lon;
	}
};
wl_debug_ManualControl.onMouseUp = function(event) {
	console.log("Mouse up");
	window.document.exitPointerLock();
	var _g1 = 0;
	var _g = wl_debug_ManualControl.fpsControls.length;
	while(_g1 < _g) {
		var control = wl_debug_ManualControl.fpsControls[_g1++];
		control.enabled = false;
		control.movementSpeed = 1;
	}
	window.document.removeEventListener("mouseup",wl_debug_ManualControl.onMouseUp);
	window.document.getElementById("demo").removeEventListener("mouseup",wl_debug_ManualControl.onMouseUp);
};
wl_debug_ManualControl.onKeyDown = function(event) {
	wl_debug_ManualControl.ctrlDown = event.shiftKey;
	var _g1 = 0;
	var _g = wl_debug_ManualControl.parts.length;
	while(_g1 < _g) {
		var i = _g1++;
		var p = wl_debug_ManualControl.parts[i];
		if(!p.running) {
			continue;
		}
		var control = wl_debug_ManualControl.fpsControls[i];
		var camera = p.camera;
		var camdir = new THREE.Vector3(0,0,-100);
		camdir.applyQuaternion(camera.quaternion);
		control.movementSpeed = event.shiftKey?0.1:1;
		if(event.keyCode == 80) {
			wl_demo_CameraController.stopAllControl();
			console.log("--- " + camera.name + " ---");
			console.log("Pos: x: " + camera.position.x + " y: " + camera.position.y + " z: " + camera.position.z);
			console.log("Dir: " + camdir.x + ", " + camdir.y + ", " + camdir.z);
			console.log("Look at: ");
			var la = camera.position.clone().add(camdir);
			console.log(la.x + ", " + la.y + ", " + la.z);
			console.log("Camera rotations: x " + camera.rotation.x + " y " + camera.rotation.y + " z " + camera.rotation.z + " Array ( " + camera.rotation.x + "," + camera.rotation.y + "," + camera.rotation.z + " )");
		}
		if(event.keyCode == 81) {
			console.log("point stored");
			if(wl_debug_ManualControl.storedPoints[p.name] == null) {
				wl_debug_ManualControl.storedPoints[p.name] = { pos : [], rot : [], look : []};
			}
			var la1 = camera.position.clone().add(camdir);
			wl_debug_ManualControl.storedPoints[p.name].pos.push("new Vector3(" + Math.round(camera.position.x * 100) / 100 + "," + Math.round(camera.position.y * 100) / 100 + "," + Math.round(camera.position.z * 100) / 100 + ")");
			wl_debug_ManualControl.storedPoints[p.name].rot.push("new Vector3(" + Math.round(camera.rotation.x * 100) / 100 + "," + Math.round(camera.rotation.y * 100) / 100 + "," + Math.round(camera.rotation.z * 100) / 100 + ")\n");
			wl_debug_ManualControl.storedPoints[p.name].look.push("new Vector3(" + Math.round(la1.x * 100) / 100 + "," + Math.round(la1.y * 100) / 100 + "," + Math.round(la1.z * 100) / 100 + ")");
		}
		if(event.keyCode == 85) {
			console.log("------------------------");
			var _g2 = 0;
			var _g3 = Reflect.fields(wl_debug_ManualControl.storedPoints);
			while(_g2 < _g3.length) {
				var point = _g3[_g2];
				++_g2;
				console.log("--- " + point + " ---");
				console.log("[\r\n" + wl_debug_ManualControl.storedPoints[point].pos.join(",\r\n") + "],[\r\n" + wl_debug_ManualControl.storedPoints[point].look.join(",\r\n") + "]");
			}
			wl_debug_ManualControl.storedPoints = { };
		}
	}
};
wl_debug_ManualControl.update = function() {
	var _g = 0;
	var _g1 = wl_debug_ManualControl.fpsControls;
	while(_g < _g1.length) {
		var c = _g1[_g];
		++_g;
		if(c.enabled) {
			c.update(1);
		}
	}
};
wl_debug_ManualControl.attachPart = function(part) {
	if(!wl_core_Config.DEBUG) {
		return;
	}
	wl_debug_ManualControl.parts.push(part);
	var control = new THREE.FirstPersonControls(part.camera);
	control.enabled = false;
	wl_debug_ManualControl.fpsControls.push(control);
};
wl_debug_ManualControl.prototype = {
	__class__: wl_debug_ManualControl
};
var wl_demo_CameraController = function(camera) {
	this.ignoreStop = false;
	this.updateLook = true;
	this.updatePath = true;
	if(camera != null) {
		this.attachCamera(camera);
	}
};
wl_demo_CameraController.__name__ = ["wl","demo","CameraController"];
wl_demo_CameraController.stopAllControl = function() {
	wl_demo_CameraController.STOPPED = true;
};
wl_demo_CameraController.prototype = {
	attachCamera: function(camera) {
		this.camera = camera;
	}
	,set_mode: function(mode) {
		this.mode = mode;
		return mode;
	}
	,initStatic: function(position,lookAt) {
		this.position = position;
		this.lookAt = lookAt;
		this.set_mode(wl_demo_CameraController.STATIC);
	}
	,initFollow: function(target,followOffset,followLookOffset) {
		this.set_mode(wl_demo_CameraController.FOLLOW);
		this.follow = target;
		this.followOffset = followOffset == null?new THREE.Vector3(0,0,0):followOffset;
		this.followLookOffset = followLookOffset == null?new THREE.Vector3(0,0,0):followLookOffset;
	}
	,initLinear: function(points,lookAts) {
		this.set_mode(wl_demo_CameraController.LINEAR);
		this.points = points;
		this.lookAts = lookAts;
	}
	,initBezier: function(points,lookAts) {
		this.set_mode(wl_demo_CameraController.BEZIER);
		this.points = points;
		this.lookAts = lookAts;
		this.path = new THREE.SplineCurve3(points);
		this.lookPath = new THREE.SplineCurve3(lookAts);
	}
	,showbezierPaths: function(scene) {
		var _g = 0;
		var _g1 = this.points;
		while(_g < _g1.length) {
			var p = _g1[_g];
			++_g;
			var b = new THREE.Mesh(new THREE.BoxGeometry(2,2,2),new THREE.MeshBasicMaterial({ color : 16711680}));
			b.position.set(p.x,p.y,p.z);
			scene.add(b);
		}
		var _g2 = 0;
		var _g11 = this.lookAts;
		while(_g2 < _g11.length) {
			var p1 = _g11[_g2];
			++_g2;
			var b1 = new THREE.Mesh(new THREE.BoxGeometry(2,2,2),new THREE.MeshBasicMaterial({ color : 255}));
			b1.position.set(p1.x,p1.y,p1.z);
			scene.add(b1);
		}
		var geometry = new THREE.Geometry();
		var linematerial = new THREE.LineBasicMaterial({ color : 16711680, linewidth : 4});
		var lookAtGeometry = new THREE.Geometry();
		var lookAtLineMaterial = new THREE.LineBasicMaterial({ color : 255});
		var _g12 = 0;
		while(_g12 < 1200) {
			var k = _g12++;
			geometry.vertices.push(this.path.getPointAt(k / 1200).clone());
			lookAtGeometry.vertices.push(this.lookPath.getPointAt(k / 1200));
		}
		scene.add(new THREE.Line(geometry,linematerial));
		scene.add(new THREE.Line(lookAtGeometry,lookAtLineMaterial));
	}
	,update: function(phase) {
		if(wl_demo_CameraController.STOPPED && !this.ignoreStop) {
			return;
		}
		if(this.mode == wl_demo_CameraController.STATIC) {
			if(this.updatePath) {
				this.camera.position.x = this.position.x;
				this.camera.position.y = this.position.y;
				this.camera.position.z = this.position.z;
			}
			if(this.updateLook) {
				this.camera.lookAt(this.lookAt);
			}
		} else if(this.mode == wl_demo_CameraController.LINEAR) {
			if(this.updatePath) {
				var a = this.points[0];
				var b = this.points[1];
				var c = new THREE.Vector3();
				c.lerpVectors(a,b,phase);
				this.camera.position.x = c.x;
				this.camera.position.y = c.y;
				this.camera.position.z = c.z;
			}
			if(this.updateLook) {
				var a1 = this.lookAts[0];
				var b1 = this.lookAts[1];
				var c1 = new THREE.Vector3();
				c1.lerpVectors(a1,b1,phase);
				this.camera.lookAt(c1);
			}
		} else if(this.mode == wl_demo_CameraController.FOLLOW) {
			if(this.updatePath) {
				this.camera.position.x = this.follow.position.x + this.followOffset.x;
				this.camera.position.y = this.follow.position.y + this.followOffset.y;
				this.camera.position.z = this.follow.position.z + this.followOffset.z;
			}
			if(this.updateLook) {
				this.camera.lookAt(this.follow.position.add(this.followLookOffset));
			}
		} else if(this.mode == wl_demo_CameraController.BEZIER) {
			if(phase < 0) {
				phase = 0;
			} else if(phase > 1) {
				phase = 1;
			}
			if(this.updatePath) {
				var p = this.path.getPointAt(phase);
				this.camera.position.x = p.x;
				this.camera.position.y = p.y;
				this.camera.position.z = p.z;
			}
			if(this.updateLook) {
				var p1 = this.lookPath.getPointAt(phase);
				this.camera.lookAt(p1);
				this.lookAt = p1;
			}
			this.position = this.camera.position;
		}
	}
	,__class__: wl_demo_CameraController
};
var wl_demo_RandomCameraController = function(camera,cameraAmount,follow,seed,allowTypes,distanceRange,bounds) {
	this.distanceRange = [];
	this.cameraSwap = 0;
	this.current = 0;
	if(allowTypes.length == 0) {
		throw new js__$Boot_HaxeError("Random camera requires at least 1 type");
	}
	this.md = distanceRange[0];
	this.bounds = bounds;
	this.rnd = distanceRange[1] - distanceRange[0];
	this.distanceRange = distanceRange;
	this.random = new wl_util_Random(seed);
	this.follow = follow;
	this.camera = camera;
	this.ccs = [];
	var _g1 = 0;
	while(_g1 < cameraAmount) {
		++_g1;
		var cc = new wl_demo_CameraController(this.camera);
		var type = allowTypes[this.random.Next() % allowTypes.length];
		if(type == wl_demo_CameraController.FOLLOW) {
			this.initFollow(cc);
		} else if(type == wl_demo_CameraController.LINEAR) {
			this.initLinear(cc);
		} else if(type == wl_demo_CameraController.STATIC) {
			this.initStatic(cc);
		} else if(type == wl_demo_CameraController.BEZIER) {
			this.initBezier(cc);
		}
		this.ccs.push(cc);
	}
};
wl_demo_RandomCameraController.__name__ = ["wl","demo","RandomCameraController"];
wl_demo_RandomCameraController.prototype = {
	start: function() {
		this.cameraSwap = new Date().getTime();
	}
	,swap: function() {
		this.cameraSwap = new Date().getTime();
		this.current = (this.current + 1) % this.ccs.length;
	}
	,updatePartial: function(val) {
		this.ccs[this.current].update(val);
	}
	,updateLength: function(time) {
		var tmp = new Date().getTime() - this.cameraSwap;
		this.ccs[this.current].update(tmp / time);
	}
	,getRndPoint: function() {
		var v = this.bounds.min.clone();
		v = v.addScaledVector(this.bounds.max.clone().sub(this.bounds.min),wl_util_Random.nextFloat());
		return v;
	}
	,initFollow: function(cc) {
		var obj = this.follow.length > 0?this.follow[this.random.Next() % this.follow.length]:new THREE.Object3D();
		var dir = new THREE.Vector3(this.random.NextFloat() - 0.5,this.random.NextFloat() - 0.5,this.random.NextFloat() - 0.5);
		dir.normalize();
		dir.multiplyScalar(this.random.NextFloat() * this.rnd + this.md);
		cc.initFollow(obj,dir,new THREE.Vector3(this.random.NextFloat() * 10,this.random.NextFloat() * 10,this.random.NextFloat() * 10));
	}
	,initStatic: function(cc) {
		var obj = this.follow.length > 0?this.follow[this.random.Next() % this.follow.length]:new THREE.Object3D();
		cc.initStatic(this.getRndPoint(),obj.position);
	}
	,initLinear: function(cc) {
		var obj = this.follow.length > 0?this.follow[this.random.Next() % this.follow.length]:new THREE.Object3D();
		cc.initLinear([this.getRndPoint(),this.getRndPoint()],[obj.position.clone(),obj.position.clone().add(new THREE.Vector3(Math.random() * 20 - 10,Math.random() * 20 - 10,Math.random() * 20 - 10))]);
	}
	,initBezier: function(cc) {
		var obj = this.follow.length > 0?this.follow[this.random.Next() % this.follow.length]:new THREE.Object3D();
		var start = this.getRndPoint();
		var end = this.getRndPoint();
		var pos = [start];
		var looks = [obj.position.clone(),obj.position.clone()];
		var dx = end.x - start.x;
		var dy = end.y - start.y;
		var dz = end.z - start.z;
		var _g = 1;
		while(_g < 6) {
			var i = _g++;
			looks.push(obj.position.clone());
			pos.push(new THREE.Vector3(wl_util_Random.nextFloat() * dx / 10 - dx / 20 + i / 6 * dx + start.x,wl_util_Random.nextFloat() * dy / 10 - dy / 20 + i / 6 * dy + start.y,wl_util_Random.nextFloat() * dz / 10 - dz / 20 + i / 6 * dz + start.z));
		}
		pos.push(end);
		cc.initBezier(pos,looks);
	}
	,__class__: wl_demo_RandomCameraController
};
var wl_demo_TimeLine = function(instance,runOn,runOff,partId,renderToScreen,rtsOn,rtsOff,forceNewPart,extra) {
	this.part = instance;
	this.partId = partId;
	this.runOn = runOn;
	this.runOff = runOff;
	this.rtsOn = rtsOn == null?runOn.clone():rtsOn;
	this.rtsOff = rtsOff == null?runOff.clone():rtsOff;
	this.renderToScreen = renderToScreen == null?true:renderToScreen;
	this.forceNewPart = forceNewPart == null?false:forceNewPart;
	this.extra = extra;
};
wl_demo_TimeLine.__name__ = ["wl","demo","TimeLine"];
wl_demo_TimeLine.prototype = {
	toString: function() {
		return this.part.name + ":" + this.rtsOn.toString() + " - " + this.rtsOff.toString();
	}
	,__class__: wl_demo_TimeLine
};
var wl_post_bloom_Bloom = function(resolution,strength,radius,threshold) {
	if(threshold == null) {
		threshold = 0;
	}
	if(radius == null) {
		radius = 0;
	}
	if(strength == null) {
		strength = 0.5;
	}
	this.nMips = 5;
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.uniforms = { };
	if(resolution == null) {
		resolution = new THREE.Vector2(1024,1024);
	}
	this.resolution = resolution;
	this.strength = strength;
	this.radius = radius;
	this.threshold = threshold;
	this.enabled = true;
	var pars = { minFilter : THREE.LinearFilter, magFilter : THREE.LinearFilter, format : THREE.RGBAFormat};
	this.renderTargetsHorizontal = [];
	this.renderTargetsVertical = [];
	this.nMips = 5;
	var resx = Math.round(this.resolution.x / 2);
	var resy = Math.round(this.resolution.y / 2);
	this.renderTargetBright = new THREE.WebGLRenderTarget(resx,resy,pars);
	this.renderTargetBright.texture.generateMipmaps = false;
	var _g1 = 0;
	var _g = this.nMips;
	while(_g1 < _g) {
		var i = _g1++;
		var renderTarget = new THREE.WebGLRenderTarget(resx,resy,pars);
		renderTarget.texture.generateMipmaps = false;
		this.renderTargetsHorizontal.push(renderTarget);
		var renderTarget1 = new THREE.WebGLRenderTarget(resx,resy,pars);
		renderTarget1.texture.generateMipmaps = false;
		this.renderTargetsVertical.push(renderTarget1);
		resx = Math.round(resx / 2);
		resy = Math.round(resy / 2);
	}
	if(THREE.LuminosityHighPassShader == null) {
		console.log("THREE.UnrealBloomPass relies on THREE.LuminosityHighPassShader");
	}
	var highPassShader = THREE.LuminosityHighPassShader;
	this.highPassUniforms = THREE.UniformsUtils.clone(highPassShader.uniforms);
	this.highPassUniforms.luminosityThreshold.value = threshold;
	this.highPassUniforms.smoothWidth.value = 0.01;
	this.materialHighPassFilter = new THREE.ShaderMaterial({ uniforms : this.highPassUniforms, vertexShader : highPassShader.vertexShader, fragmentShader : highPassShader.fragmentShader, defines : { }});
	this.separableBlurMaterials = [];
	var kernelSizeArray = [3,5,7,9,11];
	var resx1 = Math.round(this.resolution.x / 2);
	var resy1 = Math.round(this.resolution.y / 2);
	var _g11 = 0;
	var _g2 = this.nMips;
	while(_g11 < _g2) {
		var i1 = _g11++;
		this.separableBlurMaterials.push(this.getSeperableBlurMaterial(kernelSizeArray[i1]));
		this.separableBlurMaterials[i1].uniforms.texSize.value = new THREE.Vector2(resx1,resy1);
		resx1 = Math.round(resx1 / 2);
		resy1 = Math.round(resy1 / 2);
	}
	this.compositeMaterial = this.getCompositeMaterial(this.nMips);
	this.compositeMaterial.uniforms.blurTexture1.value = this.renderTargetsVertical[0].texture;
	this.compositeMaterial.uniforms.blurTexture2.value = this.renderTargetsVertical[1].texture;
	this.compositeMaterial.uniforms.blurTexture3.value = this.renderTargetsVertical[2].texture;
	this.compositeMaterial.uniforms.blurTexture4.value = this.renderTargetsVertical[3].texture;
	this.compositeMaterial.uniforms.blurTexture5.value = this.renderTargetsVertical[4].texture;
	this.compositeMaterial.uniforms.bloomStrength.value = strength;
	this.compositeMaterial.uniforms.bloomRadius.value = 0.1;
	this.compositeMaterial.needsUpdate = true;
	var bloomFactors = [1.0,0.8,0.6,0.4,0.2];
	this.compositeMaterial.uniforms.bloomFactors.value = bloomFactors;
	this.bloomTintColors = [new THREE.Vector3(1,1,1),new THREE.Vector3(1,1,1),new THREE.Vector3(1,1,1),new THREE.Vector3(1,1,1),new THREE.Vector3(1,1,1)];
	this.compositeMaterial.uniforms.bloomTintColors.value = this.bloomTintColors;
	if(THREE.CopyShader == null) {
		console.log("THREE.BloomPass relies on THREE.CopyShader");
	}
	var copyShader = THREE.CopyShader;
	this.copyUniforms = THREE.UniformsUtils.clone(copyShader.uniforms);
	this.copyUniforms.opacity.value = 1.0;
	this.materialCopy = new THREE.ShaderMaterial({ uniforms : this.copyUniforms, vertexShader : copyShader.vertexShader, fragmentShader : copyShader.fragmentShader, blending : THREE.AdditiveBlending, depthTest : false, depthWrite : false, transparent : true});
	this.enabled = true;
	this.needsSwap = false;
	this.oldClearColor = new THREE.Color();
	this.oldClearAlpha = 1;
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.scene = new THREE.Scene();
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene.add(this.quad);
};
wl_post_bloom_Bloom.__name__ = ["wl","post","bloom","Bloom"];
wl_post_bloom_Bloom.prototype = {
	setupDatGui: function(folder) {
		var f = folder.addFolder("Bloom");
		f.add(this,"strength").step(0.01);
		f.add(this,"radius").step(0.01);
		f.add(this,"threshold").step(0.01);
	}
	,setSize: function(width,height) {
		var resx = Math.round(width / 2);
		var resy = Math.round(height / 2);
		this.renderTargetBright.setSize(resx,resy);
		var _g1 = 0;
		var _g = this.nMips;
		while(_g1 < _g) {
			var i = _g1++;
			this.renderTargetsHorizontal[i].setSize(resx,resy);
			this.renderTargetsVertical[i].setSize(resx,resy);
			this.separableBlurMaterials[i].uniforms.texSize.value = new THREE.Vector2(resx,resy);
			resx = Math.round(resx / 2);
			resy = Math.round(resy / 2);
		}
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		this.oldClearColor.copy(renderer.getClearColor());
		this.oldClearAlpha = renderer.getClearAlpha();
		var oldAutoClear = renderer.autoClear;
		renderer.autoClear = false;
		renderer.setClearColor(new THREE.Color(0,0,0),0);
		this.highPassUniforms.tDiffuse.value = readBuffer.texture;
		this.highPassUniforms.luminosityThreshold.value = this.threshold;
		this.quad.material = this.materialHighPassFilter;
		renderer.render(this.scene,this.camera,this.renderTargetBright,true);
		var inputRenderTarget = this.renderTargetBright;
		var _g1 = 0;
		var _g = this.nMips;
		while(_g1 < _g) {
			var i = _g1++;
			this.quad.material = this.separableBlurMaterials[i];
			this.separableBlurMaterials[i].uniforms.colorTexture.value = inputRenderTarget.texture;
			this.separableBlurMaterials[i].uniforms.direction.value = wl_post_bloom_Bloom.BlurDirectionX;
			renderer.render(this.scene,this.camera,this.renderTargetsHorizontal[i],true);
			this.separableBlurMaterials[i].uniforms.colorTexture.value = this.renderTargetsHorizontal[i].texture;
			this.separableBlurMaterials[i].uniforms.direction.value = wl_post_bloom_Bloom.BlurDirectionY;
			renderer.render(this.scene,this.camera,this.renderTargetsVertical[i],true);
			inputRenderTarget = this.renderTargetsVertical[i];
		}
		this.quad.material = this.compositeMaterial;
		this.compositeMaterial.uniforms.bloomStrength.value = this.strength;
		this.compositeMaterial.uniforms.bloomRadius.value = this.radius;
		this.compositeMaterial.uniforms.bloomTintColors.value = this.bloomTintColors;
		renderer.render(this.scene,this.camera,this.renderTargetsHorizontal[0],true);
		this.quad.material = this.materialCopy;
		this.copyUniforms.tDiffuse.value = this.renderTargetsHorizontal[0].texture;
		renderer.render(this.scene,this.camera,readBuffer,false);
		renderer.setClearColor(this.oldClearColor,this.oldClearAlpha);
		renderer.autoClear = oldAutoClear;
	}
	,getSeperableBlurMaterial: function(kernelRadius) {
		return new THREE.ShaderMaterial({ defines : { 'KERNEL_RADIUS' : kernelRadius, 'SIGMA' : kernelRadius}, uniforms : { 'colorTexture' : { value : null}, 'texSize' : { value : new THREE.Vector2(0.5,0.5)}, 'direction' : { value : new THREE.Vector2(0.5,0.5)}}, vertexShader : ["varying vec2 vUv;","void main() {","\tvUv = uv;","\tgl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );","}"].join("\n"), fragmentShader : ["#include <common>","varying vec2 vUv;","uniform sampler2D colorTexture;","uniform vec2 texSize;","uniform vec2 direction;","float gaussianPdf(in float x, in float sigma) {","\treturn 0.39894 * exp( -0.5 * x * x/( sigma * sigma))/sigma;","}","void main() {","\tvec2 invSize = 1.0 / texSize;","\tfloat fSigma = float(SIGMA);","\tfloat weightSum = gaussianPdf(0.0, fSigma);","\tvec3 diffuseSum = texture2D( colorTexture, vUv).rgb * weightSum;","\tfor( int i = 1; i < KERNEL_RADIUS; i ++ ) {","\t\tfloat x = float(i);","\t\tfloat w = gaussianPdf(x, fSigma);","\t\tvec2 uvOffset = direction * invSize * x;","\t\tvec3 sample1 = texture2D( colorTexture, vUv + uvOffset).rgb;","\t\tvec3 sample2 = texture2D( colorTexture, vUv - uvOffset).rgb;","\t\tdiffuseSum += (sample1 + sample2) * w;","\t\tweightSum += 2.0 * w;","\t}","\tgl_FragColor = vec4(diffuseSum/weightSum, 1.0);","}"].join("\n")});
	}
	,getCompositeMaterial: function(nMips) {
		return new THREE.ShaderMaterial({ defines : { 'NUM_MIPS' : nMips}, uniforms : { 'blurTexture1' : { value : null}, 'blurTexture2' : { value : null}, 'blurTexture3' : { value : null}, 'blurTexture4' : { value : null}, 'blurTexture5' : { value : null}, 'dirtTexture' : { value : null}, 'bloomStrength' : { value : 1.0}, 'bloomFactors' : { value : null}, 'bloomTintColors' : { value : null}, 'bloomRadius' : { value : 0.0}}, vertexShader : ["varying vec2 vUv;","void main() {","\tvUv = uv;","\tgl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );","}"].join("\n"), fragmentShader : ["varying vec2 vUv;","uniform sampler2D blurTexture1;","uniform sampler2D blurTexture2;","uniform sampler2D blurTexture3;","uniform sampler2D blurTexture4;","uniform sampler2D blurTexture5;","uniform sampler2D dirtTexture;","uniform float bloomStrength;","uniform float bloomRadius;","uniform float bloomFactors[NUM_MIPS];","uniform vec3 bloomTintColors[NUM_MIPS];","float lerpBloomFactor(const in float factor) { ","\tfloat mirrorFactor = 1.2 - factor;","\treturn mix(factor, mirrorFactor, bloomRadius);","}","void main() {","\tgl_FragColor = bloomStrength * ( lerpBloomFactor(bloomFactors[0]) * vec4(bloomTintColors[0], 1.0) * texture2D(blurTexture1, vUv) + ","\t \t\t\t\t\t\t\t lerpBloomFactor(bloomFactors[1]) * vec4(bloomTintColors[1], 1.0) * texture2D(blurTexture2, vUv) + ","\t\t\t\t\t\t\t\t lerpBloomFactor(bloomFactors[2]) * vec4(bloomTintColors[2], 1.0) * texture2D(blurTexture3, vUv) + ","\t\t\t\t\t\t\t\t lerpBloomFactor(bloomFactors[3]) * vec4(bloomTintColors[3], 1.0) * texture2D(blurTexture4, vUv) + ","\t\t\t\t\t\t\t\t lerpBloomFactor(bloomFactors[4]) * vec4(bloomTintColors[4], 1.0) * texture2D(blurTexture5, vUv) );","}"].join("\n")});
	}
	,__class__: wl_post_bloom_Bloom
};
var wl_post_colorhilight_ColorHilight = function() {
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.sweep = 0;
	this.targetVal = 40;
	this.testSweep = false;
	this.color2 = 16777215;
	this.color1 = 16777215;
	this.original = 0.01;
	this.amount = 0.01;
	this.value2 = 0.01;
	this.value1 = 0.01;
	this.range = 0.01;
	this.uniforms = { range : { type : "f", value : 0.03}, value1 : { type : "f", value : 0.2}, value2 : { type : "f", value : 0.5}, amount : { type : "f", value : 0.0}, original : { type : "f", value : 1}, color1 : { type : "v4", value : [1.0,1.0,1.0,1]}, color2 : { type : "v4", value : [1.0,1.0,1.0,1]}, tile : { type : "v2", value : [1.0,1.0]}, tDiffuse : { type : "t"}};
	this.enabled = true;
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, fragmentShader : haxe_Resource.getString("colorhilight.frag"), vertexShader : haxe_Resource.getString("colorhilight.vert")});
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
wl_post_colorhilight_ColorHilight.__name__ = ["wl","post","colorhilight","ColorHilight"];
wl_post_colorhilight_ColorHilight.prototype = {
	set_range: function(value) {
		this.range = value;
		this.uniforms.range.value = value;
		return value;
	}
	,set_value1: function(value) {
		this.value1 = value;
		this.uniforms.value1.value = value;
		return value;
	}
	,set_value2: function(value) {
		this.value2 = value;
		this.uniforms.value2.value = value;
		return value;
	}
	,set_amount: function(value) {
		this.amount = value;
		this.uniforms.amount.value = value;
		return value;
	}
	,set_original: function(value) {
		this.original = value;
		this.uniforms.original.value = value;
		return value;
	}
	,set_color1: function(value) {
		this.color1 = value;
		this.uniforms.color1.value = [(value >> 16 & 255) / 255,(value >> 8 & 255) / 255,(value & 255) / 255,1];
		return value;
	}
	,set_color2: function(value) {
		this.color2 = value;
		this.uniforms.color2.value = [(value >> 16 & 255) / 255,(value >> 8 & 255) / 255,(value & 255) / 255,1];
		return value;
	}
	,setupDatGui: function(folder) {
		var _gthis = this;
		var f = folder.addFolder("Color hilight");
		f.add(this,"range").step(0.0001).min(0).max(1).onChange(function(value) {
			_gthis.set_range(value);
		});
		f.add(this,"value1").step(0.0001).min(0).max(1).onChange(function(value1) {
			_gthis.set_value1(value1);
		});
		f.add(this,"value2").step(0.0001).min(0).max(1).onChange(function(value2) {
			_gthis.set_value2(value2);
		});
		f.add(this,"amount").step(0.0001).min(0).max(1).onChange(function(value3) {
			_gthis.set_amount(value3);
		});
		f.addColor(this,"color1").onChange(function(value4) {
			_gthis.set_color1(value4);
		});
		f.addColor(this,"color2").onChange(function(value5) {
			_gthis.set_color2(value5);
		});
		f.add(this,"original").min(0).max(1).onChange(function(value6) {
			_gthis.set_original(value6);
		});
		f.add(this,"testSweep");
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		if(this.testSweep) {
			this.set_value1(wl_core_Demo.instance.previousTS.toMilliseconds() / 1000 % 1);
			this.set_value2((0.5 + wl_core_Demo.instance.previousTS.toMilliseconds() / 1000) % 1);
		}
		this.uniforms.tDiffuse.value = readBuffer.texture;
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,doSweep: function(time) {
		this.sweep = 0;
		createjs.Tween.get(this,{ onChange : $bind(this,this.sweepUpdate)}).to({ sweep : 1},time,createjs.Ease.quadInOut);
	}
	,sweepUpdate: function() {
		this.uniforms.amount.value = this.targetVal;
		this.uniforms.value1.value = this.sweep;
		this.uniforms.value2.value = (this.sweep + 0.5) % 1;
		this.uniforms.original.value = 1;
	}
	,__class__: wl_post_colorhilight_ColorHilight
};
var wl_post_displacement_Displacement = function(dispmap) {
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.zoom = 0.01;
	this.scaleY = 0.01;
	this.scaleX = 0.01;
	this.uniforms = { scaleX : { type : "f", value : 0.03}, scaleY : { type : "f", value : 0.03}, zoom : { type : "f", value : 1}, tDiffuse : { type : "t"}, tDispMap : { type : "t"}};
	this.enabled = true;
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, fragmentShader : haxe_Resource.getString("displacement.frag"), vertexShader : haxe_Resource.getString("displacement.vert")});
	this.uniforms.tDispMap.value = dispmap;
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
wl_post_displacement_Displacement.__name__ = ["wl","post","displacement","Displacement"];
wl_post_displacement_Displacement.prototype = {
	set_scaleX: function(value) {
		this.scaleX = value;
		this.uniforms.scaleX.value = value;
		return value;
	}
	,set_scaleY: function(value) {
		this.scaleY = value;
		this.uniforms.scaleY.value = value;
		return value;
	}
	,set_zoom: function(value) {
		this.zoom = value;
		this.uniforms.zoom.value = value;
		return value;
	}
	,setupDatGui: function(folder) {
		var _gthis = this;
		var f = folder.addFolder("displacement (post)");
		f.add(this,"scaleX").step(0.0001).min(0).max(1).onChange(function(value) {
			_gthis.set_scaleX(value);
		});
		f.add(this,"scaleY").step(0.0001).min(0).max(1).onChange(function(value1) {
			_gthis.set_scaleY(value1);
		});
		f.add(this,"zoom").step(0.0001).min(0).max(100).onChange(function(value2) {
			_gthis.set_zoom(value2);
		});
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		this.uniforms.tDiffuse.value = readBuffer.texture;
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,__class__: wl_post_displacement_Displacement
};
var wl_post_distortedTv_DistortedTv = function() {
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.brightLimit = 1.00;
	this.brightMultiplier = 1.00;
	this.offsetAmount = 2.00;
	this.vignAmount = 2.00;
	this.blueamplify = 1.5;
	this.greenamplify = 1.5;
	this.distortAmount = 100;
	this.uniforms = { distortAmount : { type : "f", value : 100.1}, tDiffuse : { type : "t"}, greenamplify : { type : "f", value : 1.26}, blueamplify : { type : "f", value : 1.50}, vignAmount : { type : "f", value : 2.00}, time : { type : "f", value : 0.0}, offsetAmount : { type : "f", value : 0.0}, brightMultiplier : { type : "f", value : 1.0}, brightLimit : { type : "f", value : 1.0}};
	this.enabled = true;
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, fragmentShader : haxe_Resource.getString("distortedTv.frag"), vertexShader : haxe_Resource.getString("distortedTv.vert")});
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
wl_post_distortedTv_DistortedTv.__name__ = ["wl","post","distortedTv","DistortedTv"];
wl_post_distortedTv_DistortedTv.prototype = {
	set_distortAmount: function(value) {
		this.distortAmount = value;
		this.uniforms.distortAmount.value = value;
		return value;
	}
	,set_greenamplify: function(value) {
		this.greenamplify = value;
		this.uniforms.greenamplify.value = value;
		return value;
	}
	,set_blueamplify: function(value) {
		this.blueamplify = value;
		this.uniforms.blueamplify.value = value;
		return value;
	}
	,set_vignAmount: function(value) {
		this.vignAmount = value;
		this.uniforms.vignAmount.value = value;
		return value;
	}
	,set_offsetAmount: function(value) {
		this.offsetAmount = value;
		this.uniforms.offsetAmount.value = value;
		return value;
	}
	,set_brightMultiplier: function(value) {
		this.brightMultiplier = value;
		this.uniforms.brightMultiplier.value = value;
		return value;
	}
	,set_brightLimit: function(value) {
		this.brightLimit = value;
		this.uniforms.brightLimit.value = value;
		return value;
	}
	,setupDatGui: function(folder) {
		var _gthis = this;
		var f = folder.addFolder("Distorted tv");
		f.add(this,"distortAmount").step(0.01).onChange(function(value) {
			_gthis.set_distortAmount(value);
		});
		f.add(this,"greenamplify").step(0.01).onChange(function(value1) {
			_gthis.set_greenamplify(value1);
			console.log("green change " + value1);
		});
		f.add(this,"blueamplify").step(0.01).onChange(function(value2) {
			_gthis.set_blueamplify(value2);
		});
		f.add(this,"vignAmount").step(0.01).onChange(function(value3) {
			_gthis.set_vignAmount(value3);
		});
		f.add(this,"offsetAmount").step(0.01).onChange(function(value4) {
			_gthis.set_offsetAmount(value4);
		});
		f.add(this,"brightMultiplier").step(0.01).onChange(function(value5) {
			_gthis.set_brightMultiplier(value5);
		});
		f.add(this,"brightLimit").step(0.01).onChange(function(value6) {
			_gthis.set_brightLimit(value6);
		});
	}
	,setTime: function(t) {
		this.uniforms.time.value = t;
	}
	,setDistortion: function(t) {
		this.uniforms.distortAmount.value = t;
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		this.setTime(wl_core_Demo.instance.previousTS.toMilliseconds() / 1000);
		this.uniforms.tDiffuse.value = readBuffer.texture;
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,__class__: wl_post_distortedTv_DistortedTv
};
var wl_post_dof_DoF = function(depth,camera) {
	this.focusCoords = new THREE.Vector2(0.5,0.5);
	this.shaderFocus = true;
	this.pentagon = false;
	this.dithering = 0.00001;
	this.noise = false;
	this.fringe = 0;
	this.bias = 0;
	this.gain = 0;
	this.threshold = 0;
	this.depthblur = false;
	this.maxblur = 1;
	this.fstop = 1;
	this.focalLength = 90;
	this.focalDepth = 0;
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.uniforms = { 'textureWidth' : { type : "f", value : 1.0}, 'textureHeight' : { type : "f", value : 1.0}, 'focalDepth' : { type : "f", value : 2.8}, 'focalLength' : { type : "f", value : 35.0}, 'fstop' : { type : "f", value : 2.2}, 'tColor' : { type : "t", value : null}, 'tDepth' : { type : "t", value : null}, 'maxblur' : { type : "f", value : 1.0}, 'depthblur' : { type : "b", value : 0}, 'threshold' : { type : "f", value : 0.5}, 'gain' : { type : "f", value : 2.0}, 'bias' : { type : "f", value : 0.5}, 'fringe' : { type : "f", value : 0.7}, 'znear' : { type : "f", value : 0.1}, 'zfar' : { type : "f", value : 100}, 'noise' : { type : "b", value : 1}, 'dithering' : { type : "f", value : 0.0001}, 'pentagon' : { type : "b", value : 0}, 'shaderFocus' : { type : "b", value : 1}, 'focusCoords' : { type : "v2", value : new THREE.Vector2(0.5,0.5)}};
	this.sceneCamera = camera;
	var vert = haxe_Resource.getString("dof.vert");
	var frag = haxe_Resource.getString("dof.frag");
	this.uniforms.tDepth.value = depth;
	this.uniforms.textureWidth.value = wl_core_Config.RESOLUTION[0];
	this.uniforms.textureHeight.value = wl_core_Config.RESOLUTION[1];
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, vertexShader : vert, fragmentShader : frag});
	this.enabled = true;
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
wl_post_dof_DoF.__name__ = ["wl","post","dof","DoF"];
wl_post_dof_DoF.prototype = {
	set_focalDepth: function(value) {
		this.focalDepth = value;
		this.uniforms.focalDepth.value = value;
		return value;
	}
	,set_focalLength: function(value) {
		this.focalLength = value;
		this.uniforms.focalLength.value = value;
		return value;
	}
	,set_fstop: function(value) {
		this.fstop = value;
		this.uniforms.fstop.value = value;
		return value;
	}
	,set_maxblur: function(value) {
		this.maxblur = value;
		this.uniforms.maxblur.value = value;
		return value;
	}
	,set_depthblur: function(value) {
		this.depthblur = value;
		this.uniforms.depthblur.value = value;
		return value;
	}
	,set_threshold: function(value) {
		this.threshold = value;
		this.uniforms.threshold.value = value;
		return value;
	}
	,set_gain: function(value) {
		this.gain = value;
		this.uniforms.gain.value = value;
		return value;
	}
	,set_bias: function(value) {
		this.bias = value;
		this.uniforms.bias.value = value;
		return value;
	}
	,set_fringe: function(value) {
		this.fringe = value;
		this.uniforms.fringe.value = value;
		return value;
	}
	,set_noise: function(value) {
		this.noise = value;
		this.uniforms.noise.value = value;
		return value;
	}
	,set_dithering: function(value) {
		this.dithering = value;
		this.uniforms.dithering.value = value;
		return value;
	}
	,set_pentagon: function(value) {
		this.pentagon = value;
		this.uniforms.pentagon.value = value;
		return value;
	}
	,set_shaderFocus: function(value) {
		this.shaderFocus = value;
		this.uniforms.shaderFocus.value = value;
		return value;
	}
	,set_focusCoords: function(value) {
		this.focusCoords = value;
		this.uniforms.focusCoords.value = value;
		return value;
	}
	,setupDatGui: function(folder) {
		var _gthis = this;
		var f = folder.addFolder("DoF");
		f.add(this,"focalDepth").step(0.01).onChange(function(value) {
			_gthis.set_focalDepth(value);
		});
		f.add(this,"focalLength").step(0.01).onChange(function(value1) {
			_gthis.set_focalLength(value1);
		});
		f.add(this,"fstop").step(0.01).onChange(function(value2) {
			_gthis.set_fstop(value2);
		});
		f.add(this,"maxblur").step(0.01).onChange(function(value3) {
			_gthis.set_maxblur(value3);
		});
		f.add(this,"depthblur").onChange(function(value4) {
			_gthis.set_depthblur(value4);
		});
		f.add(this,"threshold").step(0.01).onChange(function(value5) {
			_gthis.set_threshold(value5);
		});
		f.add(this,"gain").step(0.01).onChange(function(value6) {
			_gthis.set_gain(value6);
		});
		f.add(this,"bias").step(0.01).onChange(function(value7) {
			_gthis.set_bias(value7);
		});
		f.add(this,"fringe").step(0.01).onChange(function(value8) {
			_gthis.set_fringe(value8);
		});
		f.add(this,"noise").onChange(function(value9) {
			_gthis.set_noise(value9);
		});
		f.add(this,"dithering").step(0.01).onChange(function(value10) {
			_gthis.set_dithering(value10);
		});
		f.add(this,"pentagon").onChange(function(value11) {
			_gthis.set_pentagon(value11);
		});
		f.add(this,"shaderFocus").onChange(function(value12) {
			_gthis.set_shaderFocus(value12);
		});
		f.add(this.focusCoords,"x").step(0.01).onChange(function(value13) {
			_gthis.uniforms.focusCoords.value[0] = value13;
		});
		f.add(this.focusCoords,"y").step(0.01).onChange(function(value14) {
			_gthis.uniforms.focusCoords.value[1] = value14;
		});
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		this.uniforms.zfar.value = this.sceneCamera.far;
		this.uniforms.znear.value = this.sceneCamera.near;
		this.uniforms.tColor.value = readBuffer.texture;
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,__class__: wl_post_dof_DoF
};
var wl_post_pixelate_Pixelate = function(pixelamount) {
	this.pixelamount = new THREE.Vector2(128,72);
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.uniforms = { resolution : { type : "v2", value : new THREE.Vector2(1280,720)}, tDiffuse : { type : "t"}, pixelamount : { type : "v2", value : new THREE.Vector2(128,72)}};
	if(pixelamount != null) {
		this.uniforms.pixelamount.value = pixelamount;
	}
	this.enabled = true;
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, vertexShader : haxe_Resource.getString("pixelate.vert"), fragmentShader : haxe_Resource.getString("pixelate.frag")});
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
wl_post_pixelate_Pixelate.__name__ = ["wl","post","pixelate","Pixelate"];
wl_post_pixelate_Pixelate.prototype = {
	set_pixelamount: function(value) {
		this.pixelamount = value;
		this.uniforms.pixelamount.value = value;
		return value;
	}
	,setupDatGui: function(folder) {
		var _gthis = this;
		var f = folder.addFolder("Pixelate");
		f.add(this.pixelamount,"x").step(1).min(1).max(wl_core_Config.RESOLUTION[0]).onChange(function(val) {
			_gthis.uniforms.pixelamount.value = _gthis.pixelamount;
		});
		f.add(this.pixelamount,"y").step(1).min(1).max(wl_core_Config.RESOLUTION[1]).onChange(function(val1) {
			_gthis.uniforms.pixelamount.value = _gthis.pixelamount;
		});
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		this.uniforms.tDiffuse.value = readBuffer.texture;
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,__class__: wl_post_pixelate_Pixelate
};
var wl_post_rgbshift_RGBShift = function(rshift,gshift,bshift) {
	this.bshift = 0.01;
	this.rshift = 0.01;
	this.gshift = 0.01;
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.uniforms = { gshift : { type : "f", value : 0.04}, rshift : { type : "f", value : 0.04}, bshift : { type : "f", value : 0.0}, tDiffuse : { type : "t"}};
	if(rshift != null) {
		this.set_rshift(rshift);
	}
	if(gshift != null) {
		this.set_gshift(gshift);
	}
	if(bshift != null) {
		this.set_bshift(bshift);
	}
	this.enabled = true;
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, vertexShader : haxe_Resource.getString("rgbshift.vert"), fragmentShader : haxe_Resource.getString("rgbshift.frag")});
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
wl_post_rgbshift_RGBShift.__name__ = ["wl","post","rgbshift","RGBShift"];
wl_post_rgbshift_RGBShift.prototype = {
	set_gshift: function(value) {
		this.gshift = value;
		this.uniforms.gshift.value = value;
		return value;
	}
	,set_rshift: function(value) {
		this.rshift = value;
		this.uniforms.rshift.value = value;
		return value;
	}
	,set_bshift: function(value) {
		this.bshift = value;
		this.uniforms.bshift.value = value;
		return value;
	}
	,setupDatGui: function(folder) {
		var _gthis = this;
		var f = folder.addFolder("RGB");
		f.add(this,"rshift").step(0.0001).min(-1).max(1).onChange(function(value) {
			_gthis.set_rshift(value);
		});
		f.add(this,"gshift").step(0.0001).min(-1).max(1).onChange(function(value1) {
			_gthis.set_gshift(value1);
		});
		f.add(this,"bshift").step(0.0001).min(-1).max(1).onChange(function(value2) {
			_gthis.set_bshift(value2);
		});
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		this.uniforms.tDiffuse.value = readBuffer.texture;
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,__class__: wl_post_rgbshift_RGBShift
};
var wl_post_standard_StandardShader = function(gamma) {
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.uniforms = { brightness : { type : "f", value : 0.0}, gamma : { type : "f", value : 0.0}, tDiffuse : { type : "t"}};
	if(gamma == null) {
		gamma = 1;
	}
	this.uniforms.gamma.value = gamma;
	this.enabled = true;
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, vertexShader : haxe_Resource.getString("standard.vert"), fragmentShader : haxe_Resource.getString("standard.frag")});
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
wl_post_standard_StandardShader.__name__ = ["wl","post","standard","StandardShader"];
wl_post_standard_StandardShader.prototype = {
	set_brightness: function(val) {
		return this.uniforms.brightness.value = val;
	}
	,set_gamma: function(val) {
		return this.uniforms.gamma.value = val;
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		this.uniforms.tDiffuse.value = readBuffer.texture;
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,__class__: wl_post_standard_StandardShader
};
var wl_setup_Setup = function() {
	throw new js__$Boot_HaxeError("Setup is static only.");
};
wl_setup_Setup.__name__ = ["wl","setup","Setup"];
wl_setup_Setup.init = function(demo) {
	wl_setup_Setup.setupDiv = $("#setup");
	wl_setup_Setup.demoDiv = $("#demo");
	wl_setup_Setup.resolution = wl_setup_Setup.setupDiv.find("#resolution");
	var fullscreen = wl_setup_Setup.setupDiv.find("#fullscreen");
	var start = wl_setup_Setup.setupDiv.find("#start");
	fullscreen.click(wl_setup_Setup.fullScreenClickHandler);
	start.click(wl_setup_Setup.startClickHandler);
	wl_setup_Setup.demo = demo;
	if(window.location.protocol.indexOf("file") >= 0) {
		$("#localWarning").css("display","");
	}
};
wl_setup_Setup.hideSetup = function() {
	wl_setup_Setup.setupDiv.remove();
};
wl_setup_Setup.startRun = function() {
	if(wl_setup_Setup.setupDiv.find("#muted").find("input")["is"](":checked")) {
		wl_core_Config.MUTED = true;
	}
	var debug = wl_setup_Setup.setupDiv.find("#debug").find("input")["is"](":checked");
	wl_core_Config.DEBUG = debug;
	if(debug) {
		$(".debug").css("display","block");
	} else {
		$(".debug").css("display","none");
	}
	wl_setup_Setup.demo.init(wl_setup_Setup.demoDiv[0]);
	wl_setup_Setup.demoDiv.append(wl_setup_Setup.demo.graphics.canvas);
	wl_setup_Setup.demo.start();
};
wl_setup_Setup.fullScreenClickHandler = function(e) {
	wl_setup_Setup.hideSetup();
	try {
		wl_setup_Setup.demoDiv[0].requestFullscreen();
	} catch( e1 ) {
		throw new js__$Boot_HaxeError("Full screen could not be initialized. Please reload and try again.");
	}
	var w = window.screen.width;
	var h = window.screen.height;
	var ratio = wl_core_Config.RATIO;
	var lockAspect = $("#aspectLock input").val() == "on";
	if(lockAspect && w / ratio < h) {
		h = w * 720 / 1280;
	} else if(lockAspect && h < w / ratio) {
		w = h * 1280 / 720;
	}
	wl_core_Config.RESOLUTION[0] = Math.floor(w);
	wl_core_Config.RESOLUTION[1] = Math.floor(h);
	wl_setup_Setup.demoDiv.css("background","black");
	haxe_Timer.delay(wl_setup_Setup.startRun,5000);
};
wl_setup_Setup.startClickHandler = function(e) {
	$("#demo").css("transform","").css("-webkit-transform","");
	var lockAspect = $("#aspectLock input").val() == "on";
	$("#muted input")["is"](":checked");
	var resolutionType = $("#resolution .active input[name='options']").val();
	wl_setup_Setup.hideSetup();
	var w = 1280;
	var h = 720;
	if(resolutionType == "b") {
		w = 1920;
		h = 1080;
	} else if(resolutionType == "c") {
		w = window.innerWidth;
		h = window.innerHeight;
		var ratio = wl_core_Config.RATIO;
		if(lockAspect && w / ratio < h) {
			h = w / ratio;
		} else if(lockAspect && h < w / ratio) {
			w = h * ratio;
		}
	}
	wl_core_Config.RESOLUTION[0] = w;
	wl_core_Config.RESOLUTION[1] = h;
	wl_setup_Setup.demoDiv.css("width",w + "px").css("height",h + "px");
	haxe_Timer.delay(wl_setup_Setup.startRun,500);
};
wl_setup_Setup.prototype = {
	__class__: wl_setup_Setup
};
var wl_sounds_SoundWL = function() {
	throw new js__$Boot_HaxeError("Sound is static");
};
wl_sounds_SoundWL.__name__ = ["wl","sounds","SoundWL"];
wl_sounds_SoundWL.init = function() {
	wl_sounds_SoundWL.loadMusicFile();
};
wl_sounds_SoundWL.setVolume = function(volume) {
	wl_sounds_SoundWL.volume = volume;
	if(wl_sounds_SoundWL.instance != null) {
		wl_sounds_SoundWL.instance.volume = volume;
	}
};
wl_sounds_SoundWL.getPosition = function() {
	if(wl_sounds_SoundWL.instance != null) {
		wl_sounds_SoundWL.time.fromTime(wl_sounds_SoundWL.instance.getPosition() / 1000 / 60 - wl_core_Config.MUSIC_BEGIN / 1000 / 60);
	} else if(wl_sounds_SoundWL.context != null) {
		wl_sounds_SoundWL.time.fromTime((wl_sounds_SoundWL.context.currentTime - wl_sounds_SoundWL.startTime) / 60 - wl_core_Config.MUSIC_BEGIN / 1000 / 60);
	}
	return wl_sounds_SoundWL.time;
};
wl_sounds_SoundWL.getFFT = function() {
	var position = 0;
	if(wl_sounds_SoundWL.instance != null) {
		position = wl_sounds_SoundWL.instance.getPosition();
	}
	if(wl_sounds_SoundWL.context != null) {
		position = wl_sounds_SoundWL.context.currentTime;
	}
	if(wl_sounds_SoundWL.lastFFT != position) {
		wl_sounds_SoundWL.lastFFT = position;
		if((wl_sounds_SoundWL.instance != null || wl_sounds_SoundWL.context != null) && wl_core_Config.ENABLE_FFT && wl_sounds_SoundWL.analyserNode != null) {
			wl_sounds_SoundWL.analyserNode.getFloatFrequencyData(wl_sounds_SoundWL.freqFloatData);
			wl_sounds_SoundWL.analyserNode.getByteFrequencyData(wl_sounds_SoundWL.freqByteData);
			wl_sounds_SoundWL.analyserNode.getByteTimeDomainData(wl_sounds_SoundWL.timeByteData);
		}
	}
	return wl_sounds_SoundWL.FFT;
};
wl_sounds_SoundWL.start = function() {
	wl_sounds_SoundWL.context = createjs.Sound.activePlugin.context;
	wl_sounds_SoundWL.dynamicsCompressorNode = createjs.Sound.activePlugin.dynamicsCompressorNode;
	wl_sounds_SoundWL.instance = createjs.Sound.play("music");
	wl_sounds_SoundWL.instance.on("complete",wl_sounds_SoundWL.handleComplete);
	wl_sounds_SoundWL.instance.volume = wl_core_Config.MUTED?0:wl_sounds_SoundWL.volume;
	if(wl_core_Config.ENABLE_FFT) {
		wl_sounds_SoundWL.initializeFFT();
	}
	wl_sounds_SoundWL.onSoundReady.emit();
};
wl_sounds_SoundWL.handleComplete = function() {
	wl_sounds_SoundWL.onSoundComplete.emit();
};
wl_sounds_SoundWL.loadMusicFile = function() {
	var sounds = [{ id : "music", src : wl_core_Config.SONG_PATH}];
	createjs.Sound.alternateExtensions = ["mp3"];
	createjs.Sound.addEventListener("fileload",wl_sounds_SoundWL.handleLoad);
	createjs.Sound.registerSounds(sounds);
};
wl_sounds_SoundWL.initializeFFT = function() {
	var context = wl_sounds_SoundWL.context;
	if(context != null && $bind(context,context.createAnalyser) != null) {
		wl_sounds_SoundWL.analyserNode = context.createAnalyser();
		wl_sounds_SoundWL.analyserNode.fftSize = 1024;
		wl_sounds_SoundWL.analyserNode.smoothingTimeConstant = 0.0;
		wl_sounds_SoundWL.analyserNode.connect(context.destination);
		var dynamicsNode = wl_sounds_SoundWL.dynamicsCompressorNode;
		dynamicsNode.disconnect();
		dynamicsNode.connect(wl_sounds_SoundWL.analyserNode);
		wl_sounds_SoundWL.freqFloatData = new Float32Array(wl_sounds_SoundWL.analyserNode.frequencyBinCount);
		wl_sounds_SoundWL.freqByteData = new Uint8Array(wl_sounds_SoundWL.analyserNode.frequencyBinCount);
		wl_sounds_SoundWL.timeByteData = new Uint8Array(wl_sounds_SoundWL.analyserNode.frequencyBinCount);
	} else {
		console.log("FFT could not be initialized.");
	}
	wl_sounds_SoundWL.FFT.db = wl_sounds_SoundWL.freqFloatData;
	wl_sounds_SoundWL.FFT.frequency = wl_sounds_SoundWL.freqByteData;
	wl_sounds_SoundWL.FFT.waveform = wl_sounds_SoundWL.timeByteData;
};
wl_sounds_SoundWL.handleLoad = function() {
	wl_sounds_SoundWL.loaded = true;
	wl_sounds_SoundWL.onSoundLoaded.emit();
};
wl_sounds_SoundWL.prototype = {
	__class__: wl_sounds_SoundWL
};
var wl_util_MathUtil = function() {
};
wl_util_MathUtil.__name__ = ["wl","util","MathUtil"];
wl_util_MathUtil.clamp = function(low,high,val) {
	if(val < low) {
		return low;
	} else if(val > high) {
		return high;
	} else {
		return val;
	}
};
wl_util_MathUtil.FromVector3 = function(position,sphereRadius) {
	var lat = 90 - Math.acos(position.y / sphereRadius) * 180 / Math.PI;
	return [(270 + Math.atan2(position.x,position.z) * 180 / Math.PI) % 360 - 180,lat];
};
wl_util_MathUtil.componentLerp = function(v1,v2,phase,easex,easey,easez,setTo) {
	if(setTo == null) {
		setTo = new THREE.Vector3();
	} else {
		setTo = setTo;
	}
	setTo.set(easex(1 - phase) * v1.x + easex(phase) * v2.x,easey(1 - phase) * v1.y + easey(phase) * v2.y,easez(1 - phase) * v1.z + easez(phase) * v2.z);
	return setTo;
};
wl_util_MathUtil.prototype = {
	__class__: wl_util_MathUtil
};
var wl_util_Random = function(seed) {
	this.seed = 123;
	this.Init(seed);
};
wl_util_Random.__name__ = ["wl","util","Random"];
wl_util_Random.init = function(seed) {
	wl_util_Random.instance.Init(seed);
};
wl_util_Random.next = function() {
	return wl_util_Random.instance.Next();
};
wl_util_Random.nextFloat = function() {
	return wl_util_Random.instance.NextFloat();
};
wl_util_Random.range = function(low,high) {
	return wl_util_Random.instance.Range(low,high);
};
wl_util_Random.prototype = {
	Init: function(seed) {
		this.seed = seed;
	}
	,Next: function() {
		var hi = Math.floor(this.seed / 127773);
		var test = 16807 * Math.floor(this.seed % 127773) - 2836 * hi;
		if(test < 0) {
			test += 2147483647;
		}
		this.seed = test;
		return this.seed;
	}
	,NextFloat: function() {
		return this.Next() / 2147483647;
	}
	,Range: function(low,high) {
		return Math.floor(this.NextFloat() * (high - low) + low);
	}
	,__class__: wl_util_Random
};
var $_, $fid = 0;
function $bind(o,m) { if( m == null ) return null; if( m.__id__ == null ) m.__id__ = $fid++; var f; if( o.hx__closures__ == null ) o.hx__closures__ = {}; else f = o.hx__closures__[m.__id__]; if( f == null ) { f = function(){ return f.method.apply(f.scope, arguments); }; f.scope = o; f.method = m; o.hx__closures__[m.__id__] = f; } return f; }
String.prototype.__class__ = String;
String.__name__ = ["String"];
Array.__name__ = ["Array"];
Date.prototype.__class__ = Date;
Date.__name__ = ["Date"];
var Int = { __name__ : ["Int"]};
var Dynamic = { __name__ : ["Dynamic"]};
var Float = Number;
Float.__name__ = ["Float"];
var Bool = Boolean;
Bool.__ename__ = ["Bool"];
var Class = { __name__ : ["Class"]};
var Enum = { };
haxe_Resource.content = [{ name : "colorhilight.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "pixelate.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gdmVjMiBwaXhlbGFtb3VudDsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaWZmdXNlOw0KDQp2b2lkIG1haW4oKSB7DQoJdmVjMiB1diA9IHZVdjsNCgl1di54ID0gZmxvb3IodXYueCpwaXhlbGFtb3VudC54KS9waXhlbGFtb3VudC54Ow0KCXV2LnkgPSBmbG9vcih1di55KnBpeGVsYW1vdW50LnkpL3BpeGVsYW1vdW50Lnk7DQoJdmVjNCBjID0gdGV4dHVyZTJEKHREaWZmdXNlLHV2KTsNCglnbF9GcmFnQ29sb3IgPSBjOw0KfQ0K"},{ name : "colorhilight.frag", data : "dW5pZm9ybSBmbG9hdCByYW5nZTsNCnVuaWZvcm0gZmxvYXQgdmFsdWUxOw0KdW5pZm9ybSBmbG9hdCB2YWx1ZTI7DQp1bmlmb3JtIGZsb2F0IG9yaWdpbmFsOw0KdW5pZm9ybSBmbG9hdCBhbW91bnQ7DQp1bmlmb3JtIHZlYzQgY29sb3IxOw0KdW5pZm9ybSB2ZWM0IGNvbG9yMjsNCnVuaWZvcm0gdmVjMiB0aWxlOw0KdW5pZm9ybSBzYW1wbGVyMkQgdERpZmZ1c2U7DQp2YXJ5aW5nIHZlYzIgdlV2Ow0KDQp2b2lkIG1haW4oKSB7DQoJdmVjMiB1diA9IHZVdjsNCgl2ZWM0IGMgPSB0ZXh0dXJlMkQodERpZmZ1c2UsdXYqdGlsZSk7DQoJDQoJLy9NYWtlIGNvbnRpbnVvdXMgdHJpYW5nbGUgZnVuY3Rpb24NCglmbG9hdCB2YWwxID0gdmFsdWUxKjIuOw0KCXZhbDEgPSB2YWwxIDwgMS4gPyB2YWwxIDogMi4tdmFsMTsNCglmbG9hdCB2YWwyID0gdmFsdWUyKjIuOw0KCXZhbDEgPSB2YWwyIDwgMS4gPyB2YWwyIDogMi4tdmFsMjsNCgkNCglmbG9hdCB0aW1lb2ZmMSA9IG1vZCh2YWwxLCAxLiArIHJhbmdlKTsNCglmbG9hdCB0aW1lb2ZmMiA9IG1vZCh2YWwyLCAxLiArIHJhbmdlKTsNCgkNCglmbG9hdCBtcDEgPSAoYWJzKGMuciAtIHRpbWVvZmYxKSA+IHJhbmdlKSA/IDEuIDogMC47DQoJZmxvYXQgbXAyID0gKGFicyhjLmcgLSB0aW1lb2ZmMikgPiByYW5nZSkgPyAxLiA6IDAuOw0KCQ0KCWZsb2F0IGF2ZyA9IChjLnIrYy5nK2MuYikvMy47DQoJdmVjNCBhZHMxID0gY29sb3IxICogYWJzKGF2ZyAtIHRpbWVvZmYxKTsNCgl2ZWM0IGFkczIgPSBjb2xvcjIgKiBhYnMoYXZnIC0gdGltZW9mZjIpOw0KCQ0KCXZlYzQgY29sID0gKDEuLSBtcDEpICogYWRzMSArICgxLiAtIG1wMikqYWRzMjsNCgkNCglnbF9GcmFnQ29sb3IgPSBjKm9yaWdpbmFsICsgY29sKmFtb3VudDsNCn0NCg"},{ name : "rgbshift.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "pixelate.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "standard.frag", data : "dW5pZm9ybSBmbG9hdCBicmlnaHRuZXNzOw0KdW5pZm9ybSBmbG9hdCBnYW1tYTsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaWZmdXNlOw0KdmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzIgdXYgPSB2VXY7DQoJdmVjNCBjID0gdGV4dHVyZTJEKHREaWZmdXNlLHV2KTsNCgljID0gcG93KGMsIHZlYzQoMS4wL2dhbW1hKSk7DQoJYys9YnJpZ2h0bmVzczsNCglnbF9GcmFnQ29sb3IgPSBjOw0KfQ"},{ name : "rgbshift.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gZmxvYXQgcnNoaWZ0Ow0KdW5pZm9ybSBmbG9hdCBnc2hpZnQ7DQp1bmlmb3JtIGZsb2F0IGJzaGlmdDsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaWZmdXNlOw0KDQp2b2lkIG1haW4oKSB7DQoJdmVjNCBjID0gdGV4dHVyZTJEKHREaWZmdXNlLHZVdik7DQoJZmxvYXQgcm8gPSB0ZXh0dXJlMkQodERpZmZ1c2UsdmVjMih2VXYueC1yc2hpZnQsIHZVdi55KSkucjsNCglmbG9hdCBnbyA9IHRleHR1cmUyRCh0RGlmZnVzZSx2ZWMyKHZVdi54LWdzaGlmdCwgdlV2LnkpKS5nOw0KCWZsb2F0IGJvID0gdGV4dHVyZTJEKHREaWZmdXNlLHZlYzIodlV2LngtYnNoaWZ0LCB2VXYueSkpLmI7DQoJZ2xfRnJhZ0NvbG9yID0gdmVjNChybywgZ28sIGJvLCBjLncpOw0KfQ"},{ name : "dof.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ0KICAgIA"},{ name : "dof.frag", data : "I2luY2x1ZGUgPGNvbW1vbj4NCg0KdmFyeWluZyB2ZWMyIHZVdjsNCg0KdW5pZm9ybSBzYW1wbGVyMkQgdENvbG9yOw0KdW5pZm9ybSBzYW1wbGVyMkQgdERlcHRoOw0KdW5pZm9ybSBmbG9hdCB0ZXh0dXJlV2lkdGg7DQp1bmlmb3JtIGZsb2F0IHRleHR1cmVIZWlnaHQ7DQoNCnVuaWZvcm0gZmxvYXQgZm9jYWxEZXB0aDsgIC8vZm9jYWwgZGlzdGFuY2UgdmFsdWUgaW4gbWV0ZXJzLCBidXQgeW91IG1heSB1c2UgYXV0b2ZvY3VzIG9wdGlvbiBiZWxvdw0KdW5pZm9ybSBmbG9hdCBmb2NhbExlbmd0aDsgLy9mb2NhbCBsZW5ndGggaW4gbW0NCnVuaWZvcm0gZmxvYXQgZnN0b3A7IC8vZi1zdG9wIHZhbHVlDQp1bmlmb3JtIGJvb2wgc2hvd0ZvY3VzOyAvL3Nob3cgZGVidWcgZm9jdXMgcG9pbnQgYW5kIGZvY2FsIHJhbmdlIChyZWQgPSBmb2NhbCBwb2ludCwgZ3JlZW4gPSBmb2NhbCByYW5nZSkNCg0KLyoNCm1ha2Ugc3VyZSB0aGF0IHRoZXNlIHR3byB2YWx1ZXMgYXJlIHRoZSBzYW1lIGZvciB5b3VyIGNhbWVyYSwgb3RoZXJ3aXNlIGRpc3RhbmNlcyB3aWxsIGJlIHdyb25nLg0KKi8NCg0KdW5pZm9ybSBmbG9hdCB6bmVhcjsgLy8gY2FtZXJhIGNsaXBwaW5nIHN0YXJ0DQp1bmlmb3JtIGZsb2F0IHpmYXI7IC8vIGNhbWVyYSBjbGlwcGluZyBlbmQNCg0KLy8tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0NCi8vdXNlciB2YXJpYWJsZXMNCg0KY29uc3QgaW50IHNhbXBsZXMgPSAxMDsgLy9zYW1wbGVzIG9uIHRoZSBmaXJzdCByaW5nDQpjb25zdCBpbnQgcmluZ3MgPSA0OyAvL3JpbmcgY291bnQNCg0KY29uc3QgaW50IG1heHJpbmdzYW1wbGVzID0gcmluZ3MgKiBzYW1wbGVzOw0KDQp1bmlmb3JtIGJvb2wgbWFudWFsZG9mOyAvLyBtYW51YWwgZG9mIGNhbGN1bGF0aW9uDQpmbG9hdCBuZG9mc3RhcnQgPSAxLjA7IC8vIG5lYXIgZG9mIGJsdXIgc3RhcnQNCmZsb2F0IG5kb2ZkaXN0ID0gMi4wOyAvLyBuZWFyIGRvZiBibHVyIGZhbGxvZmYgZGlzdGFuY2UNCmZsb2F0IGZkb2ZzdGFydCA9IDEuMDsgLy8gZmFyIGRvZiBibHVyIHN0YXJ0DQpmbG9hdCBmZG9mZGlzdCA9IDMuMDsgLy8gZmFyIGRvZiBibHVyIGZhbGxvZmYgZGlzdGFuY2UNCg0KZmxvYXQgQ29DID0gMC4wMzsgLy9jaXJjbGUgb2YgY29uZnVzaW9uIHNpemUgaW4gbW0gKDM1bW0gZmlsbSA9IDAuMDNtbSkNCg0KdW5pZm9ybSBib29sIHNoYWRlckZvY3VzOw0KLy8gZGlzYWJsZSBpZiB5b3UgdXNlIGV4dGVybmFsIGZvY2FsRGVwdGggdmFsdWUNCg0KdW5pZm9ybSB2ZWMyIGZvY3VzQ29vcmRzOw0KLy8gYXV0b2ZvY3VzIHBvaW50IG9uIHNjcmVlbiAoMC4wLDAuMCAtIGxlZnQgbG93ZXIgY29ybmVyLCAxLjAsMS4wIC0gdXBwZXIgcmlnaHQpDQovLyBpZiBjZW50ZXIgb2Ygc2NyZWVuIHVzZSB2ZWMyKDAuNSwgMC41KTsNCg0KdW5pZm9ybSBmbG9hdCBtYXhibHVyOw0KLy9jbGFtcCB2YWx1ZSBvZiBtYXggYmx1ciAoMC4wID0gbm8gYmx1ciwgMS4wIGRlZmF1bHQpDQoNCnVuaWZvcm0gZmxvYXQgdGhyZXNob2xkOyAvLyBoaWdobGlnaHQgdGhyZXNob2xkOw0KdW5pZm9ybSBmbG9hdCBnYWluOyAvLyBoaWdobGlnaHQgZ2FpbjsNCg0KdW5pZm9ybSBmbG9hdCBiaWFzOyAvLyBib2tlaCBlZGdlIGJpYXMNCnVuaWZvcm0gZmxvYXQgZnJpbmdlOyAvLyBib2tlaCBjaHJvbWF0aWMgYWJlcnJhdGlvbiAvIGZyaW5naW5nDQoNCnVuaWZvcm0gYm9vbCBub2lzZTsgLy91c2Ugbm9pc2UgaW5zdGVhZCBvZiBwYXR0ZXJuIGZvciBzYW1wbGUgZGl0aGVyaW5nDQoNCnVuaWZvcm0gZmxvYXQgZGl0aGVyaW5nOw0KDQp1bmlmb3JtIGJvb2wgZGVwdGhibHVyOyAvLyBibHVyIHRoZSBkZXB0aCBidWZmZXINCmZsb2F0IGRic2l6ZSA9IDEuMjU7IC8vIGRlcHRoIGJsdXIgc2l6ZQ0KDQovKg0KbmV4dCBwYXJ0IGlzIGV4cGVyaW1lbnRhbA0Kbm90IGxvb2tpbmcgZ29vZCB3aXRoIHNtYWxsIHNhbXBsZSBhbmQgcmluZyBjb3VudA0KbG9va3Mgb2theSBzdGFydGluZyBmcm9tIHNhbXBsZXMgPSA0LCByaW5ncyA9IDQNCiovDQoNCnVuaWZvcm0gYm9vbCBwZW50YWdvbjsgLy91c2UgcGVudGFnb24gYXMgYm9rZWggc2hhcGU/DQpmbG9hdCBmZWF0aGVyID0gMC40OyAvL3BlbnRhZ29uIHNoYXBlIGZlYXRoZXINCg0KLy8tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0NCg0KZmxvYXQgcGVudGEodmVjMiBjb29yZHMpIHsNCgkvL3BlbnRhZ29uYWwgc2hhcGUNCglmbG9hdCBzY2FsZSA9IGZsb2F0KHJpbmdzKSAtIDEuMzsNCgl2ZWM0ICBIUzAgPSB2ZWM0KCAxLjAsICAgICAgICAgMC4wLCAgICAgICAgIDAuMCwgIDEuMCk7DQoJdmVjNCAgSFMxID0gdmVjNCggMC4zMDkwMTY5OTQsIDAuOTUxMDU2NTE2LCAwLjAsICAxLjApOw0KCXZlYzQgIEhTMiA9IHZlYzQoLTAuODA5MDE2OTk0LCAwLjU4Nzc4NTI1MiwgMC4wLCAgMS4wKTsNCgl2ZWM0ICBIUzMgPSB2ZWM0KC0wLjgwOTAxNjk5NCwtMC41ODc3ODUyNTIsIDAuMCwgIDEuMCk7DQoJdmVjNCAgSFM0ID0gdmVjNCggMC4zMDkwMTY5OTQsLTAuOTUxMDU2NTE2LCAwLjAsICAxLjApOw0KCXZlYzQgIEhTNSA9IHZlYzQoIDAuMCAgICAgICAgLDAuMCAgICAgICAgICwgMS4wLCAgMS4wKTsNCg0KCXZlYzQgIG9uZSA9IHZlYzQoIDEuMCApOw0KDQoJdmVjNCBQID0gdmVjNCgoY29vcmRzKSx2ZWMyKHNjYWxlLCBzY2FsZSkpOw0KDQoJdmVjNCBkaXN0ID0gdmVjNCgwLjApOw0KCWZsb2F0IGlub3JvdXQgPSAtNC4wOw0KDQoJZGlzdC54ID0gZG90KCBQLCBIUzAgKTsNCglkaXN0LnkgPSBkb3QoIFAsIEhTMSApOw0KCWRpc3QueiA9IGRvdCggUCwgSFMyICk7DQoJZGlzdC53ID0gZG90KCBQLCBIUzMgKTsNCg0KCWRpc3QgPSBzbW9vdGhzdGVwKCAtZmVhdGhlciwgZmVhdGhlciwgZGlzdCApOw0KDQoJaW5vcm91dCArPSBkb3QoIGRpc3QsIG9uZSApOw0KDQoJZGlzdC54ID0gZG90KCBQLCBIUzQgKTsNCglkaXN0LnkgPSBIUzUudyAtIGFicyggUC56ICk7DQoNCglkaXN0ID0gc21vb3Roc3RlcCggLWZlYXRoZXIsIGZlYXRoZXIsIGRpc3QgKTsNCglpbm9yb3V0ICs9IGRpc3QueDsNCg0KCXJldHVybiBjbGFtcCggaW5vcm91dCwgMC4wLCAxLjAgKTsNCn0NCg0KZmxvYXQgYmRlcHRoKHZlYzIgY29vcmRzKSB7DQoJLy8gRGVwdGggYnVmZmVyIGJsdXINCglmbG9hdCBkID0gMC4wOw0KCWZsb2F0IGtlcm5lbFs5XTsNCgl2ZWMyIG9mZnNldFs5XTsNCg0KCXZlYzIgd2ggPSB2ZWMyKDEuMC90ZXh0dXJlV2lkdGgsMS4wL3RleHR1cmVIZWlnaHQpICogZGJzaXplOw0KDQoJb2Zmc2V0WzBdID0gdmVjMigtd2gueCwtd2gueSk7DQoJb2Zmc2V0WzFdID0gdmVjMiggMC4wLCAtd2gueSk7DQoJb2Zmc2V0WzJdID0gdmVjMiggd2gueCAtd2gueSk7DQoNCglvZmZzZXRbM10gPSB2ZWMyKC13aC54LCAgMC4wKTsNCglvZmZzZXRbNF0gPSB2ZWMyKCAwLjAsICAgMC4wKTsNCglvZmZzZXRbNV0gPSB2ZWMyKCB3aC54LCAgMC4wKTsNCg0KCW9mZnNldFs2XSA9IHZlYzIoLXdoLngsIHdoLnkpOw0KCW9mZnNldFs3XSA9IHZlYzIoIDAuMCwgIHdoLnkpOw0KCW9mZnNldFs4XSA9IHZlYzIoIHdoLngsIHdoLnkpOw0KDQoJa2VybmVsWzBdID0gMS4wLzE2LjA7ICAga2VybmVsWzFdID0gMi4wLzE2LjA7ICAga2VybmVsWzJdID0gMS4wLzE2LjA7DQoJa2VybmVsWzNdID0gMi4wLzE2LjA7ICAga2VybmVsWzRdID0gNC4wLzE2LjA7ICAga2VybmVsWzVdID0gMi4wLzE2LjA7DQoJa2VybmVsWzZdID0gMS4wLzE2LjA7ICAga2VybmVsWzddID0gMi4wLzE2LjA7ICAga2VybmVsWzhdID0gMS4wLzE2LjA7DQoNCg0KCWZvciggaW50IGk9MDsgaTw5OyBpKysgKSB7DQoJCWZsb2F0IHRtcCA9IHRleHR1cmUyRCh0RGVwdGgsIGNvb3JkcyArIG9mZnNldFtpXSkucjsNCgkJZCArPSB0bXAgKiBrZXJuZWxbaV07DQoJfQ0KDQoJcmV0dXJuIGQ7DQp9DQoNCg0KdmVjMyBjb2xvcih2ZWMyIGNvb3JkcyxmbG9hdCBibHVyKSB7DQoJLy9wcm9jZXNzaW5nIHRoZSBzYW1wbGUNCg0KCXZlYzMgY29sID0gdmVjMygwLjApOw0KCXZlYzIgdGV4ZWwgPSB2ZWMyKDEuMC90ZXh0dXJlV2lkdGgsMS4wL3RleHR1cmVIZWlnaHQpOw0KDQoJY29sLnIgPSB0ZXh0dXJlMkQodENvbG9yLGNvb3JkcyArIHZlYzIoMC4wLDEuMCkqdGV4ZWwqZnJpbmdlKmJsdXIpLnI7DQoJY29sLmcgPSB0ZXh0dXJlMkQodENvbG9yLGNvb3JkcyArIHZlYzIoLTAuODY2LC0wLjUpKnRleGVsKmZyaW5nZSpibHVyKS5nOw0KCWNvbC5iID0gdGV4dHVyZTJEKHRDb2xvcixjb29yZHMgKyB2ZWMyKDAuODY2LC0wLjUpKnRleGVsKmZyaW5nZSpibHVyKS5iOw0KDQoJdmVjMyBsdW1jb2VmZiA9IHZlYzMoMC4yOTksMC41ODcsMC4xMTQpOw0KCWZsb2F0IGx1bSA9IGRvdChjb2wucmdiLCBsdW1jb2VmZik7DQoJZmxvYXQgdGhyZXNoID0gbWF4KChsdW0tdGhyZXNob2xkKSpnYWluLCAwLjApOw0KCXJldHVybiBjb2wrbWl4KHZlYzMoMC4wKSxjb2wsdGhyZXNoKmJsdXIpOw0KfQ0KDQp2ZWMzIGRlYnVnRm9jdXModmVjMyBjb2wsIGZsb2F0IGJsdXIsIGZsb2F0IGRlcHRoKSB7DQoJZmxvYXQgZWRnZSA9IDAuMDAyKmRlcHRoOyAvL2Rpc3RhbmNlIGJhc2VkIGVkZ2Ugc21vb3RoaW5nDQoJZmxvYXQgbSA9IGNsYW1wKHNtb290aHN0ZXAoMC4wLGVkZ2UsYmx1ciksMC4wLDEuMCk7DQoJZmxvYXQgZSA9IGNsYW1wKHNtb290aHN0ZXAoMS4wLWVkZ2UsMS4wLGJsdXIpLDAuMCwxLjApOw0KDQoJY29sID0gbWl4KGNvbCx2ZWMzKDEuMCwwLjUsMC4wKSwoMS4wLW0pKjAuNik7DQoJY29sID0gbWl4KGNvbCx2ZWMzKDAuMCwwLjUsMS4wKSwoKDEuMC1lKS0oMS4wLW0pKSowLjIpOw0KDQoJcmV0dXJuIGNvbDsNCn0NCg0KZmxvYXQgbGluZWFyaXplKGZsb2F0IGRlcHRoKSB7DQoJcmV0dXJuIC16ZmFyICogem5lYXIgLyAoZGVwdGggKiAoemZhciAtIHpuZWFyKSAtIHpmYXIpOw0KfQ0KDQpmbG9hdCBnYXRoZXIoZmxvYXQgaSwgZmxvYXQgaiwgaW50IHJpbmdzYW1wbGVzLCBpbm91dCB2ZWMzIGNvbCwgZmxvYXQgdywgZmxvYXQgaCwgZmxvYXQgYmx1cikgew0KCWZsb2F0IHJpbmdzMiA9IGZsb2F0KHJpbmdzKTsNCglmbG9hdCBzdGVwID0gUEkqMi4wIC8gZmxvYXQocmluZ3NhbXBsZXMpOw0KCWZsb2F0IHB3ID0gY29zKGoqc3RlcCkqaTsNCglmbG9hdCBwaCA9IHNpbihqKnN0ZXApKmk7DQoJZmxvYXQgcCA9IDEuMDsNCglpZiAocGVudGFnb24pIHsNCgkJcCA9IHBlbnRhKHZlYzIocHcscGgpKTsNCgl9DQoJY29sICs9IGNvbG9yKHZVdi54eSArIHZlYzIocHcqdyxwaCpoKSwgYmx1cikgKiBtaXgoMS4wLCBpL3JpbmdzMiwgYmlhcykgKiBwOw0KCXJldHVybiAxLjAgKiBtaXgoMS4wLCBpIC9yaW5nczIsIGJpYXMpICogcDsNCn0NCg0Kdm9pZCBtYWluKCkgew0KCS8vc2NlbmUgZGVwdGggY2FsY3VsYXRpb24NCg0KCWZsb2F0IGRlcHRoID0gbGluZWFyaXplKHRleHR1cmUyRCh0RGVwdGgsdlV2Lnh5KS54KTsNCg0KCS8vIEJsdXIgZGVwdGg/DQoJaWYgKGRlcHRoYmx1cikgew0KCQlkZXB0aCA9IGxpbmVhcml6ZShiZGVwdGgodlV2Lnh5KSk7DQoJfQ0KDQoJLy9mb2NhbCBwbGFuZSBjYWxjdWxhdGlvbg0KDQoJZmxvYXQgZkRlcHRoID0gZm9jYWxEZXB0aDsNCg0KCWlmIChzaGFkZXJGb2N1cykgew0KDQoJCWZEZXB0aCA9IGxpbmVhcml6ZSh0ZXh0dXJlMkQodERlcHRoLGZvY3VzQ29vcmRzKS54KTsNCg0KCX0NCg0KCS8vIGRvZiBibHVyIGZhY3RvciBjYWxjdWxhdGlvbg0KDQoJZmxvYXQgYmx1ciA9IDAuMDsNCg0KCWlmIChtYW51YWxkb2YpIHsNCgkJZmxvYXQgYSA9IGRlcHRoLWZEZXB0aDsgLy8gRm9jYWwgcGxhbmUNCgkJZmxvYXQgYiA9IChhLWZkb2ZzdGFydCkvZmRvZmRpc3Q7IC8vIEZhciBEb0YNCgkJZmxvYXQgYyA9ICgtYS1uZG9mc3RhcnQpL25kb2ZkaXN0OyAvLyBOZWFyIERvZg0KCQlibHVyID0gKGE+MC4wKSA/IGIgOiBjOw0KCX0gZWxzZSB7DQoJCWZsb2F0IGYgPSBmb2NhbExlbmd0aDsgLy8gZm9jYWwgbGVuZ3RoIGluIG1tDQoJCWZsb2F0IGQgPSBmRGVwdGgqMTAwMC4wOyAvLyBmb2NhbCBwbGFuZSBpbiBtbQ0KCQlmbG9hdCBvID0gZGVwdGgqMTAwMC4wOyAvLyBkZXB0aCBpbiBtbQ0KDQoJCWZsb2F0IGEgPSAobypmKS8oby1mKTsNCgkJZmxvYXQgYiA9IChkKmYpLyhkLWYpOw0KCQlmbG9hdCBjID0gKGQtZikvKGQqZnN0b3AqQ29DKTsNCg0KCQlibHVyID0gYWJzKGEtYikqYzsNCgl9DQoNCglibHVyID0gY2xhbXAoYmx1ciwwLjAsMS4wKTsNCg0KCS8vIGNhbGN1bGF0aW9uIG9mIHBhdHRlcm4gZm9yIGRpdGhlcmluZw0KDQoJdmVjMiBub2lzZSA9IHZlYzIocmFuZCh2VXYueHkpLCByYW5kKCB2VXYueHkgKyB2ZWMyKCAwLjQsIDAuNiApICkgKSpkaXRoZXJpbmcqYmx1cjsNCg0KCS8vIGdldHRpbmcgYmx1ciB4IGFuZCB5IHN0ZXAgZmFjdG9yDQoNCglmbG9hdCB3ID0gKDEuMC90ZXh0dXJlV2lkdGgpKmJsdXIqbWF4Ymx1citub2lzZS54Ow0KCWZsb2F0IGggPSAoMS4wL3RleHR1cmVIZWlnaHQpKmJsdXIqbWF4Ymx1citub2lzZS55Ow0KDQoJLy8gY2FsY3VsYXRpb24gb2YgZmluYWwgY29sb3INCg0KCXZlYzMgY29sID0gdmVjMygwLjApOw0KDQoJaWYoYmx1ciA8IDAuMDUpIHsNCgkJLy9zb21lIG9wdGltaXphdGlvbiB0aGluZ3kNCgkJY29sID0gdGV4dHVyZTJEKHRDb2xvciwgdlV2Lnh5KS5yZ2I7DQoJfSBlbHNlIHsNCgkJY29sID0gdGV4dHVyZTJEKHRDb2xvciwgdlV2Lnh5KS5yZ2I7DQoJCWZsb2F0IHMgPSAxLjA7DQoJCWludCByaW5nc2FtcGxlczsNCg0KCQlmb3IgKGludCBpID0gMTsgaSA8PSByaW5nczsgaSsrKSB7DQoJCQkvKnVuYm94c3RhcnQqLw0KCQkJcmluZ3NhbXBsZXMgPSBpICogc2FtcGxlczsNCg0KCQkJZm9yIChpbnQgaiA9IDAgOyBqIDwgbWF4cmluZ3NhbXBsZXMgOyBqKyspIHsNCgkJCQlpZiAoaiA+PSByaW5nc2FtcGxlcykgYnJlYWs7DQoJCQkJcyArPSBnYXRoZXIoZmxvYXQoaSksIGZsb2F0KGopLCByaW5nc2FtcGxlcywgY29sLCB3LCBoLCBibHVyKTsNCgkJCX0NCgkJCS8qdW5ib3hlbmQqLw0KCQl9DQoNCgkJY29sIC89IHM7IC8vZGl2aWRlIGJ5IHNhbXBsZSBjb3VudA0KCX0NCg0KCWdsX0ZyYWdDb2xvci5yZ2IgPSBjb2w7DQoJZ2xfRnJhZ0NvbG9yLmEgPSAxLjA7DQp9IA0K"},{ name : "distortedTv.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "standard.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "displacement.frag", data : "dW5pZm9ybSBmbG9hdCBzY2FsZVg7DQp1bmlmb3JtIGZsb2F0IHNjYWxlWTsNCnVuaWZvcm0gZmxvYXQgem9vbTsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaWZmdXNlOw0KdW5pZm9ybSBzYW1wbGVyMkQgdERpc3BNYXA7DQp2YXJ5aW5nIHZlYzIgdlV2Ow0KDQp2b2lkIG1haW4oKSB7DQoJdmVjMiB1diA9IHZVdjsNCgl2ZWM0IGNkID0gdGV4dHVyZTJEKHREaXNwTWFwLG1vZCh1dip6b29tLHZlYzIoMS4sMS4pKSk7DQoJDQoJLy9jYWxjdWxhdGUgb2Zmc2V0DQoJdmVjMiBvZmZzZXQgPXZlYzIoIGNkLnIgKiBzY2FsZVgsIGNkLmcqc2NhbGVZKTsNCgkNCgl2ZWM0IGMgPSB0ZXh0dXJlMkQodERpZmZ1c2UsdXYrb2Zmc2V0KTsNCgkNCglnbF9GcmFnQ29sb3IgPSBjOw0KfQ0K"},{ name : "distortedTv.frag", data : "dW5pZm9ybSBmbG9hdCBkaXN0b3J0QW1vdW50Ow0KdW5pZm9ybSBzYW1wbGVyMkQgdERpZmZ1c2U7DQp1bmlmb3JtIGZsb2F0IHRpbWU7DQp1bmlmb3JtIGZsb2F0IGdyZWVuYW1wbGlmeTsNCnVuaWZvcm0gZmxvYXQgYmx1ZWFtcGxpZnk7DQp1bmlmb3JtIGZsb2F0IHZpZ25BbW91bnQ7DQp1bmlmb3JtIGZsb2F0IG9mZnNldEFtb3VudDsNCnVuaWZvcm0gZmxvYXQgYnJpZ2h0TXVsdGlwbGllcjsNCnVuaWZvcm0gZmxvYXQgYnJpZ2h0TGltaXQ7DQp2YXJ5aW5nIHZlYzIgdlV2Ow0KDQp2b2lkIG1haW4oKQ0Kew0KCXZlYzIgdXYgPSB2VXY7DQogICAgZmxvYXQgb2Zmc2V0ID0gbW9kKGNlaWwodXYueSpkaXN0b3J0QW1vdW50K3RpbWUpKnRpbWUsMC4wMTIpOw0KICAgIHZlYzQgdENvbG9yID0gdGV4dHVyZTJEKHREaWZmdXNlLHZlYzIodXYueCtvZmZzZXRBbW91bnQqb2Zmc2V0LHV2LnkpKTsNCiAgICB0Q29sb3IuZyAqPSBncmVlbmFtcGxpZnk7DQogICAgdENvbG9yLmIgKj0gYmx1ZWFtcGxpZnk7DQogICAgZmxvYXQgdmlnbiA9IDEuMC1sZW5ndGgodmVjMigwLjUsMC41KS11dikqdmlnbkFtb3VudDsNCiAgICANCgl2ZWMzIGJyaWdodG5lc3MgPSB0Q29sb3IucmdiOw0KCXZlYzMgbXAgPSB2ZWMzKDEuKS1zbW9vdGhzdGVwKHZlYzMoYnJpZ2h0TGltaXQpLCB2ZWMzKDEuKSwgYnJpZ2h0bmVzcykqYnJpZ2h0TXVsdGlwbGllcjsNCgl0Q29sb3IqPXZlYzQobXAsMS4pOw0KCQ0KICAgIHRDb2xvciAqPSB2aWduOw0KCWdsX0ZyYWdDb2xvciA9IHRDb2xvcjsNCn0"},{ name : "displacement.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"}];
var __map_reserved = {}
var ArrayBuffer = $global.ArrayBuffer || js_html_compat_ArrayBuffer;
if(ArrayBuffer.prototype.slice == null) {
	ArrayBuffer.prototype.slice = js_html_compat_ArrayBuffer.sliceImpl;
}
var Float32Array = $global.Float32Array || js_html_compat_Float32Array._new;
var Uint8Array = $global.Uint8Array || js_html_compat_Uint8Array._new;
DemoMain.DEMO_READY = new wl_core_Signal();
DemoMain.HILIGHT = new THREE.Color(14431522);
DemoMain.SURFACE = new THREE.Color(14273438);
DemoMain.DARK1 = new THREE.Color(3621184);
DemoMain.DARK2 = new THREE.Color(2763819);
DemoMain.DARK3 = new THREE.Color(1973792);
DemoMain.WHITE = new THREE.Color(16777215);
DemoMain.BLACK = new THREE.Color(0);
haxe_crypto_Base64.CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
haxe_crypto_Base64.BYTES = haxe_io_Bytes.ofString(haxe_crypto_Base64.CHARS);
haxe_ds_ObjectMap.count = 0;
js_Boot.__toStr = { }.toString;
js_html_compat_Float32Array.BYTES_PER_ELEMENT = 4;
js_html_compat_Uint8Array.BYTES_PER_ELEMENT = 1;
wl_core_Assets._assets = new haxe_ds_StringMap();
wl_core_Config.BEATS_PER_MINUTE = 104;
wl_core_Config.BEATS_PER_BAR = 4;
wl_core_Config.TICKS_PER_BEAT = 12;
wl_core_Config.MUSIC_BEGIN = 500;
wl_core_Config.SONG_PATH = "bg.ogg";
wl_core_Config.ENABLE_FFT = false;
wl_core_Config.MUTED = false;
wl_core_Config.FPS = 24;
wl_core_Config.RESOLUTION = [1280,720];
wl_core_Config.RATIO = 1.7777777777777777;
wl_core_Config.ANTIALIAS = true;
wl_core_Config.ENABLE_SHADOWS = false;
wl_core_Config.SEED = 123;
wl_core_Config.DEBUG = false;
wl_core_Config.TIMELINE = [];
wl_core_TimeSig.ABSOLUTE = "absolute";
wl_core_TimeSig.RELATIVE = "relative";
wl_core_TimeSig.PATTERN = "pattern";
wl_debug_Debug.paused = false;
wl_debug_ManualControl.parts = [];
wl_debug_ManualControl.storedPoints = [];
wl_debug_ManualControl.fpsControls = [];
wl_demo_CameraController.STOPPED = false;
wl_demo_CameraController.STATIC = "static";
wl_demo_CameraController.LINEAR = "linear";
wl_demo_CameraController.BEZIER = "bezier";
wl_demo_CameraController.FOLLOW = "follow";
wl_post_bloom_Bloom.BlurDirectionX = new THREE.Vector2(1.0,0.0);
wl_post_bloom_Bloom.BlurDirectionY = new THREE.Vector2(0.0,1.0);
wl_sounds_SoundWL.onSoundLoaded = new wl_core_Signal();
wl_sounds_SoundWL.onSoundComplete = new wl_core_Signal();
wl_sounds_SoundWL.onSoundReady = new wl_core_Signal();
wl_sounds_SoundWL.time = new wl_core_TimeSig();
wl_sounds_SoundWL.volume = 1;
wl_sounds_SoundWL.startTime = 0;
wl_sounds_SoundWL.loaded = false;
wl_sounds_SoundWL.lastFFT = 0;
wl_sounds_SoundWL.FFT = { db : null, frequency : null, waveform : null, fftsize : 1024, sampleRate : 44100};
wl_util_Random.instance = new wl_util_Random(123);
Main.main();
})(typeof exports != "undefined" ? exports : typeof window != "undefined" ? window : typeof self != "undefined" ? self : this, typeof window != "undefined" ? window : typeof global != "undefined" ? global : typeof self != "undefined" ? self : this);
