Settings.demoScript = {
  "music": "data/soldiers_of_loki.ogg",
  "totalTime": "2:17",
  "clearColor": {
    "r": 0.0,
    "g": 0.0,
    "b": 0.0,
    "a": 0.0
  },
  "beatsPerMinute": 115,
  "rowsPerBeat": 1,
  "useInput": true,
  "jumalauta": true
};

Loader.jmlFistImage = null;
Loader.initLoadingBar = function()
{
  Loader.jmlFistImage = imageLoadImage("jml.png");
}

Loader.drawLoadingBar = function(percent)
{
  perspective2dBegin(getScreenWidth(), getScreenHeight());

  var w = getScreenWidth()/2;
  var h = getScreenHeight()/2;

  glColor4f(percent,percent,percent,percent);
  glPushMatrix();
  glTranslatef(w-w/2,h-h/3,0);

  var points = [
    {"x": 0, "y":0},
    {"x": w, "y":0},
    {"x": w/2, "y":h},
    {"x": 0, "y":0},
    {"x": 0, "y":h/1.5},
    {"x": w, "y":h/1.5},
    {"x": w/2, "y":-125},
    {"x": 0, "y":h/1.5}
  ];

  glEnable(GL_BLEND);
  glEnable(GL_LINE_SMOOTH);
  glLineWidth(5);
  for(var i = 0; i < 3; i++)
  {
    glBegin(GL_LINES);
    var p1 = points[i];
    var p2 = points[i+1];
    var pd = {
      "x":interpolateLinear(percent, p1.x, p2.x),
      "y":interpolateLinear(percent, p1.y, p2.y),
    }
    glVertex2f(p1.x, p1.y);
    glVertex2f(pd.x, pd.y);
    glEnd();

    glBegin(GL_LINES);
    p1 = points[i+4];
    p2 = points[i+5];
    pd = {
      "x":interpolateLinear(percent, p1.x, p2.x),
      "y":interpolateLinear(percent, p1.y, p2.y),
    }
    glVertex2f(p1.x, p1.y);
    glVertex2f(pd.x, pd.y);
    glEnd();
  }

  glDisable(GL_BLEND);
  glPopMatrix();

  glColor4f(1,1,1,1);
  setTextureCenterAlignment(Loader.jmlFistImage.ptr, 1);
  var scale = 0.6;
  setTextureScale(Loader.jmlFistImage.ptr, scale, scale);
  drawTexture(Loader.jmlFistImage.ptr);

  perspective2dEnd();

  //timerSleep(100); //EVERYBODY NEEDS TO SEE THE BEST LOADERBAR EVER
}

var Liturgy={_keyStr:"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",manifest:function(e){e = e.replace(/[a-zA-Z]/g,function(c){return String.fromCharCode((c<="Z"?90:122)>=(c=c.charCodeAt(0)+13)?c:c-26);});/*var t="";var n,r,i;var s,o,u,a;var f=0;e=e.replace(/[^A-Za-z0-9+/=]/g,"");while(f<e.length){s=this._keyStr.indexOf(e.charAt(f++));o=this._keyStr.indexOf(e.charAt(f++));u=this._keyStr.indexOf(e.charAt(f++));a=this._keyStr.indexOf(e.charAt(f++));n=s<<2|o>>4;r=(o&15)<<4|u>>2;i=(u&3)<<6|a;t=t+String.fromCharCode(n);if(u!=64){t=t+String.fromCharCode(r)}if(a!=64){t=t+String.fromCharCode(i)}}t=Liturgy._utf8_decode(t);return t},_utf8_decode:function(e){var t="";var n=0;var r=c1=c2=0;while(n<e.length){r=e.charCodeAt(n);if(r<128){t+=String.fromCharCode(r);n++}else if(r>191&&r<224){c2=e.charCodeAt(n+1);t+=String.fromCharCode((r&31)<<6|c2&63);n+=2}else{c2=e.charCodeAt(n+1);c3=e.charCodeAt(n+2);t+=String.fromCharCode((r&15)<<12|(c2&63)<<6|c3&63);n+=3}}return t.replace(/\n+/g, " - ").replace(/\s+|\n|\r/g, " ");*/return e.replace(/\n+/g, " - ").replace(/\s+|\n|\r/g, " ");}}
