var Demo = function() {
	this.betterLoader = new Loader();
}

var juho88 = undefined;

var TICK;

Demo.prototype.init = function()
{
	TICK = timerGetBeatInSeconds();

	this.preInitJmlLogo(0,69*TICK);

	this.preInitMarch(25*TICK, 42*TICK);

	this.preInitGate(this.loader, 63*TICK,49*TICK);

	this.preInitVideoReel(112*TICK, 19*TICK);

	this.preInitBombScene(126*TICK,19*TICK);

	this.preInitTerritory(144*TICK, 32*TICK);

	this.preInitMoustacheGreetings(176*TICK, 46*TICK);

	this.preInitDedication(117,15);

	this.loader.addAnimation([
	{
		 "start":0, "duration": 300
		,"image": "data/vignette.png"
		,"layer": 500
		
	}]);
	this.loader.addAnimation([
    {
         "start": 0, "duration":300
        ,"layer": 501, "image": ["data/empty.png"]
				,"color":[{"a":0}]
		,"shader":{"name":"data/shader/noise.fs",
            "variable":[
                  {"name":"time","value":["{return getSceneTimeFromStart();}"]},
				  {"name":"alphaBlending","value":[0.05]}
            ]
        }
    }]);
}

var soldier = {};
var marchProgress = 0;
var marchPath = [];

function initMarch(animation)
{
	soldier.torso = imageLoadImage("soldier_torso.png");
	soldier.leg = imageLoadImage("soldier_leg.png");
	soldier.hand = [
		imageLoadImage("soldier_hand_jml.png"),
		imageLoadImage("soldier_hand_iso.png")
	];

	var ticks = 40;
	for(var tick = 0; tick <= ticks; tick++)
	{
		marchPath.push({
			"percent":tick/ticks, "x":tick/ticks
		});
	}
}

function drawSoldier(x, y, movementPercent, sequence)
{
	movementPercent = interpolateSmootherStep(movementPercent, 0.0, 1.0);

	var scale = 0.48;
	setTexturePivot(soldier.leg.ptr,
		-20, 130, 0);
	setTextureRotation(soldier.leg.ptr,
		0, 0, interpolateLinear(1-movementPercent, 15, -15),
		0, 0, 1);
	setTextureScale(soldier.leg.ptr, scale, scale);
	setTexturePosition(soldier.leg.ptr, 78+x, 55+y);
	drawTexture(soldier.leg.ptr);

	setTexturePivot(soldier.leg.ptr,
		-20, 130, 0);
	setTextureRotation(soldier.leg.ptr,
		0, 0, interpolateLinear(movementPercent, 15, -15),
		0, 0, 1);
	setTextureScale(soldier.leg.ptr, scale, scale);
	setTexturePosition(soldier.leg.ptr, 78+x, 55+y);
	drawTexture(soldier.leg.ptr);

	scale = 0.5;
	setTextureScale(soldier.torso.ptr, scale, scale);
	setTexturePosition(soldier.torso.ptr, 35+x, 345+y);
	drawTexture(soldier.torso.ptr);

	var hand = soldier.hand[sequence%2];
	setTexturePivot(hand.ptr,
		0, 100, 0);
	setTextureRotation(hand.ptr,
		0, 0, interpolateLinear(movementPercent, -15, 15),
		0, 0, 1);
	setTextureScale(hand.ptr, scale, scale);
	setTexturePosition(hand.ptr, 22+x, 235+y);
	drawTexture(hand.ptr);
}


function drawMarch(animation)
{
	perspective2dBegin(getScreenWidth(), getScreenHeight());

	var marchProgress = 0.0;
	var percent = (getSceneTimeFromStart()-animation.start)/animation.duration;
	for(var i = 0; i < marchPath.length-1; i++)
	{
		var p0 = marchPath[i];
		var p1 = marchPath[i+1];
		if (percent >= p0.percent && percent < p1.percent)
		{
			var duration = (percent-p0.percent)/(p1.percent-p0.percent);
			duration = interpolateSmootherStep(duration, 0.0, 1.0);
			marchProgress = interpolateLinear(duration, p0.x, p1.x);
			break;
		}

	}

	var x = -300+1100*marchProgress*2;
	var bodyMovement = (Math.sin(getSceneTimeFromStart()*6)+1)/2.;
	
	var soldiers = 10;
	for (var i = 0; i < soldiers; i++)
	{
		drawSoldier(x-(i*300), 80, bodyMovement, i);
	}

	perspective2dEnd();
}

Demo.prototype.preInitMarch = function(startTime, durationTime)
{
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"layer": 10
		,"passToFbo":{"name":"marchFbo", "beginLayer":0, "endLayer":10}
		,"initFunction":"{initMarch(animation);}"
		,"runFunction":"{drawMarch(animation);}"
	}]);

	var fade = TICK*2;
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "marchFbo.color.fbo"
		,"desaturateFade": 4*TICK
		,"layer": 50
		,"color":[{},{"duration":durationTime-fade},{"duration":fade,"a":0}]
		,"shader":{"name":"data/shader/desaturate.fs",
			"variable":[
				{"name":"colorPercent","value":["{var p = (getSceneTimeFromStart()-(animation.start+animation.duration-animation.desaturateFade*2))/animation.desaturateFade; return 1-Math.min(1, Math.max(0, p));}"]}
			]
		}
	}]);
}

var moustacheGroupImageNames = [
	"data/group_de_farbrausch.png",
	"data/group_de_mercury.png",
	"data/group_fi_epoch.png",
	"data/group_fi_iso.png",
	"data/group_fi_ivory_labs.png",
	"data/group_fi_paraguay.png",
	"data/group_fi_quadtrip.png",
	"data/group_hu_conspiracy.png",
	"data/group_it_spinning_kids.png",
	"data/group_jp_hackers.png",
	"data/group_jp_systemk.png",
	"data/group_moustache.png"
]
var moustacheGroupImages = [];
function initMoustacheGreetings(animation)
{
	for(var i = 0; i < moustacheGroupImageNames.length; i++)
	{
		moustacheGroupImages.push(imageLoadImage(moustacheGroupImageNames[i]));
	}
}

function drawMoustacheGreetings(animation)
{

	perspective2dBegin(getScreenWidth(), getScreenHeight());

	var scale = 0.2;

	var singleGreetLength = 4*TICK;

	var percent = (getSceneTimeFromStart()-animation.start)/animation.greetDuration;
	if (percent < 1)
	{
		var index = Math.floor(moustacheGroupImageNames.length*percent);

		var fade = TICK*2;
		var percent2 = (getSceneTimeFromStart()+fade-animation.start)/animation.greetDuration;
		var index2 = Math.floor(moustacheGroupImageNames.length*percent2);

		var alpha1 = 0.0;

		if (getSceneTimeFromStart()-animation.start < animation.fade)
		{
			alpha1 = 1-(getSceneTimeFromStart()-animation.start)/animation.fade;
		}
		if (index2 != index)
		{
			alpha1 = (getSceneTimeFromStart()-animation.start-index*singleGreetLength-fade)/fade;
			if (index2 < moustacheGroupImageNames.length)
			{
				var img = moustacheGroupImages[index2];
				glColor4f(1,1,1,alpha1);
				setTextureScale(img.ptr, scale, scale);
				setTexturePosition(img.ptr, 0, 120);
				setTextureCenterAlignment(img.ptr, 2);
				drawTexture(img.ptr);
			}
		}

		var img = moustacheGroupImages[index];

		glColor4f(1,1,1,1-alpha1);
		setTextureScale(img.ptr, scale, scale);
		setTexturePosition(img.ptr, 0, 120);
		setTextureCenterAlignment(img.ptr, 2);
		drawTexture(img.ptr);
	}

	perspective2dEnd();
}

Demo.prototype.preInitMoustacheGreetings = function(startTime, durationTime)
{
	var fade = 4*TICK;
	this.loader.addAnimation([
	{
		 "start": startTime-fade, "duration": durationTime+fade
		,"fade": fade
		,"image": "data/good_flag_background.png"
		,"layer": 5
		,"shader":{"name":"data/shader/blood.fs",
			"variable":[
				 {"name":"time","value":["{return getSceneTimeFromStart()*2;}"]}
				,{"name":"y","value":["{var p = (getSceneTimeFromStart()-animation.start)/animation.fade; return p;}"]}
			]
		}
	}]);

	var FADE_IN = TICK;
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/hitler_hair.png"
		,"layer": 10
		,"align": 2
		,"position":[{"y": 485}]
		,"color":[{"a":0},{"duration":FADE_IN,"a":255}]
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime, "greetDuration": moustacheGroupImageNames.length*4*TICK
		,"layer": 10
		,"fade": FADE_IN
		,"initFunction":"{initMoustacheGreetings(animation);}"
		,"runFunction":"{drawMoustacheGreetings(animation);}"
	}]);
}

Demo.prototype.preInitVideoReel = function(startTime, durationTime)
{
	var scale = 2.5;
	var speed = 0.9;
	var transmissionDuration = 6*TICK;
	var fadeDuration = TICK;
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": transmissionDuration
		,"image": {"name":"data/lies.ogv", "video":{"speed":speed} }
		,"scale": [{"uniform2d":scale}]
		,"color": [{"a":0},{"duration":fadeDuration,"a":255},{"duration":transmissionDuration-fadeDuration*2},{"duration":fadeDuration,"a":0}]
		,"layer": 1
	}]);
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": transmissionDuration
		,"image": {"name":"data/eu_stars.png"}
		,"scale": [{"uniform2d":1.25}]
		,"angle": [{},{"duration":transmissionDuration,"degreesZ":180}]
		,"color": [{"a":0},{"duration":fadeDuration,"a":200},{"duration":transmissionDuration-fadeDuration*2},{"duration":fadeDuration,"a":0}]
		,"layer": 1
	}]);

	var planningDuration = 4*TICK;
	this.loader.addAnimation([
	{
		 "start": startTime+5*TICK, "duration": planningDuration
		,"image": {"name":"data/hitler_planning.ogv", "video":{"speed":1.0} }
		,"scale": [{"uniform2d":scale}]
		,"color": [{"a":0},{"duration":fadeDuration,"a":255},{"duration":planningDuration-fadeDuration*2},{"duration":fadeDuration,"a":0}]
		,"layer": 1
	}]);

	var marchDuration = 6*TICK;
	this.loader.addAnimation([
	{
		 "start": startTime+8*TICK, "duration": marchDuration
		,"image": {"name":"data/nazi_marching.ogv", "video":{"speed":speed} }
		,"scale": [{"uniform2d":scale}]
		,"color": [{"a":0},{"duration":fadeDuration,"a":255},{"duration":marchDuration-fadeDuration*2},{"duration":fadeDuration,"a":0}]
		,"layer": 1
	}]);
}

Demo.prototype.addExplosion = function(startTime, durationTime, x, y)
{
	var explosions = [
		 "explosion_01.png"
		,"explosion_02.png"
		,"explosion_03.png"
		,"explosion_04.png"
		,"explosion_05.png"
	];

	for(var i = 0; i < 15; i++)
	{
		var dx = x + random()*50-25;
		var dy = y + random()*50-25;
		var dsize = 0.15+random()*0.15;
		var dstart = random()*TICK*4;

		this.loader.addAnimation([
		{
			 "start": startTime+dstart, "duration": durationTime
			,"image": explosions[Utils.getRandomArrayIndex(explosions)]
			,"layer": 7
			,"scale": [{"uniform2d":0.0},{"duration":TICK*2,"uniform2d":dsize}]
			,"color": [{"a":0},{"duration":TICK*2,"a":255},{"duration":TICK*0.5,"a":0}]
			,"position": [{"x":dx,"y":dy}]
		}]);
	}
}

Demo.prototype.preInitTerritory = function(startTime, durationTime)
{
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"layer": 1
		,"fbo":{"name":"territoryFbo","action":"begin"}
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/bad_flag_background.png"
		,"layer": 3
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/eu_stars.png"
		,"layer": 3
		,"scale": [{"x":0.9,"y":0.6}]
		,"position": [{"y":270}]
		,"align": 2
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"layer": 4
		,"fbo":{"name":"territoryFbo","action":"unbind"}
	}]);

	var planeDuration = 6*TICK;

	var FADE = TICK;
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": ["data/map_europe.png","territoryFbo.color.fbo","data/swastika.png"]
		,"layer": 6
		,"scale": [{"uniform2d":0.38},{"duration": planeDuration, "uniform2d":0.43}]
		,"color": [{"a":0},{"duration":TICK,"a":255},{"duration":durationTime-FADE-TICK},{"duration":FADE,"a":0}]
		,"territory": [
			 {"start":startTime+3*TICK,"duration":12*TICK,"spread":0.12}
			,{"start":startTime+2*TICK,"duration":14*TICK,"spread":0.2}
			,{"start":startTime+4*TICK,"duration":18*TICK,"spread":0.2}
			,{"start":startTime+4*TICK,"duration":16*TICK,"spread":0.2}
		]
		,"shader":{"name":"data/shader/territory.fs",
			"variable":[
				 {"name":"time","value":["{return getSceneTimeFromStart()*0.8;}"]}
				,{"name":"texture1","type":"int","value":[1]}
				,{"name":"texture2","type":"int","value":[2]}
				,{"name":"territory1","value":["{var spread = 0.0; var p = Math.max(Math.min((getSceneTimeFromStart()-animation.territory[0].start)/animation.territory[0].duration, 1.0), 0.0); if (p > 0) { spread = animation.territory[0].spread*p+(Math.sin(getSceneTimeFromStart()*0.8)+1)*0.01; } return spread;}"]}
				,{"name":"territory2","value":["{var spread = 0.0; var p = Math.max(Math.min((getSceneTimeFromStart()-animation.territory[1].start)/animation.territory[1].duration, 1.0), 0.0); if (p > 0) { spread = animation.territory[1].spread*p+(Math.sin(getSceneTimeFromStart()*0.8)+1)*0.01; } return spread;}"]}
				,{"name":"territory3","value":["{var spread = 0.0; var p = Math.max(Math.min((getSceneTimeFromStart()-animation.territory[2].start)/animation.territory[2].duration, 1.0), 0.0); if (p > 0) { spread = animation.territory[2].spread*p+(Math.sin(getSceneTimeFromStart()*0.8)+1)*0.01; } return spread;}"]}
				,{"name":"territory4","value":["{var spread = 0.0; var p = Math.max(Math.min((getSceneTimeFromStart()-animation.territory[3].start)/animation.territory[3].duration, 1.0), 0.0); if (p > 0) { spread = animation.territory[3].spread*p+(Math.sin(getSceneTimeFromStart()*0.8)+1)*0.01; } return spread;}"]}
			]
		}
	}]);

	this.addExplosion(startTime+TICK, durationTime, 330, 90);
	this.addExplosion(startTime+2*TICK, durationTime, 570, 270);
	this.addExplosion(startTime+3*TICK, durationTime, 860, 160);
	this.addExplosion(startTime+3*TICK, durationTime, 550, 550);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "clouds_01.png"
		,"scale": [{"uniform2d":0.7},{"duration": planeDuration, "uniform2d":0.8}]
		,"color": [{"a":0},{"duration":TICK,"a":60},{"duration":durationTime-FADE-TICK},{"duration":FADE,"a":0}]
		,"uvSpeed": 0.05
		,"uvMax": 2
		,"uv": {
			 "uMin": "{return (getSceneTimeFromStart()*animation.uvSpeed)%animation.uvMax-animation.uvMax;}"
			,"vMin": "{return (getSceneTimeFromStart()*animation.uvSpeed)%animation.uvMax-animation.uvMax;}"
			,"uMax": "{return (getSceneTimeFromStart()*animation.uvSpeed)%animation.uvMax;}"
			,"vMax": "{return (getSceneTimeFromStart()*animation.uvSpeed)%animation.uvMax;}"
		}
		,"layer": 7
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": planeDuration
		,"image": "plane_top.png"
		,"layer": 7
		,"scale": [{"uniform2d":0.4},{"duration": planeDuration, "uniform2d":0.1}]
		,"angle": [{"degreesZ":45}]
		,"position": [{"x":-400,"y":-100},{"duration": planeDuration, "x":getScreenWidth()-150, "y":getScreenHeight()+200}]
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": planeDuration
		,"image": "plane_top.png"
		,"layer": 7
		,"scale": [{"uniform2d":0.4},{"duration": planeDuration, "uniform2d":0.1}]
		,"angle": [{"degreesZ":45}]
		,"position": [{"x":-150,"y":-200},{"duration": planeDuration, "x":getScreenWidth()+100, "y":getScreenHeight()+100}]
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": planeDuration
		,"image": "plane_top.png"
		,"layer": 7
		,"scale": [{"uniform2d":0.4},{"duration": planeDuration, "uniform2d":0.1}]
		,"angle": [{"degreesZ":45}]
		,"position": [{"x":-150,"y":-450},{"duration": planeDuration, "x":getScreenWidth()+200, "y":getScreenHeight()-150}]
	}]);
}

Demo.prototype.preInitDedication = function(startTime, durationTime)
{
	var actualStart = 5;

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/white_background.png"
		,"layer": 10000
		,"color": [{"a":0},{"duration":1,"a":255},{"duration":actualStart},{"duration":2,"a":0}]
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime+actualStart, "duration": durationTime
		,"image": "data/white_background.png"
		,"layer": 1
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime+actualStart+2, "duration": durationTime
		,"image": "data/adolf_happy.png"
		,"layer": 1
		,"color": [{"a":0},{"duration":5,"a":70}]
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime+actualStart, "duration": durationTime
		,"image": "data/end_in_memory.png"
		,"layer": 1
		,"position": [{"y":600}]
		,"align":2
	}]);
	this.loader.addAnimation([
	{
		 "start": startTime+actualStart, "duration": durationTime
		,"image": "data/end_taidemaalari.png"
		,"layer": 1
		,"position": [{"y":500}]
		,"align":2
	}]);
	/*this.loader.addAnimation([
	{
		 "start": startTime+actualStart+2, "duration": durationTime
		,"image": "data/end_dob_dod.png"
		,"layer": 1
		,"position": [{"y":400}]
		,"color": [{"a":0},{"duration":5,"a":255}]
		,"align":2
	}]);*/

	this.loader.addAnimation([
	{
		 "start": startTime+actualStart+8, "duration": durationTime
		,"image": "data/end_devoted.png"
		,"layer": 1
		,"position": [{"y":200}]
		,"align":2
		,"color": [{"a":0},{"duration":1,"a":255}]
	}]);
	this.loader.addAnimation([
	{
		 "start": startTime+actualStart+10, "duration": durationTime
		,"image": "data/end_loving.png"
		,"layer": 1
		,"position": [{"y":130}]
		,"align":2
		,"color": [{"a":0},{"duration":1,"a":255}]
	}]);
}

// ***************************
// *** JML LOGO
// ***************************
Demo.prototype.preInitJmlLogo = function(startTime, durationTime)
{
	//red: dd0000
	//white: ffffff
	//black: 000000
	var startFade = 1;
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": startFade
		,"image": "data/bad_flag_background.png"
		,"layer": 10000
		,"color": [{"r":0,"g":0,"b":0},{"duration":startFade,"a":0}]
	}]);

	var logoTransitionStart = 17;
	var logoTransitionDuration = 2;
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/good_flag_background.png"
		,"layer": 1
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/bad_flag_background.png"
		,"layer": 1
		,"color": [{},{"duration":logoTransitionStart},{"duration":logoTransitionDuration,"a":0}]
	}]);
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/eu_stars.png"
		,"layer": 3
		,"color": [
			 {"a":0}
			,{"duration":4}
			,{"duration":1,"a":255}
			,{"duration":logoTransitionStart}
			,{"duration":logoTransitionDuration,"a":0}
		]
		,"scale": [{},{"duration":logoTransitionStart},{"duration":logoTransitionDuration,"uniform2d":4}]
		,"angle": [{},{"duration":logoTransitionStart},{"duration":logoTransitionDuration,"degreesZ":360}]
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/white_circle.png"
		,"scale": [{"uniform2d":0.62}]
		,"color": [{"a":0},{"duration":logoTransitionStart},{"duration":logoTransitionDuration,"a":255}]
		,"layer": 2
	}]);
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"logoStart": startTime+logoTransitionStart, "logoDuration": logoTransitionDuration
		,"layer": 5
		,"initFunction":"{initJmlLogo(animation);}"
		,"runFunction":"{drawJmlLogo(animation);}"

	}]);
}

function drawQuad(x,y,z)
{
	var size = 0.5;
	glBegin(GL_QUADS);
	glVertex3f(x+size,y+size,z);
	glVertex3f(x-size,y+size,z);
	glVertex3f(x-size,y-size,z);
	glVertex3f(x+size,y-size,z);
	glEnd();
}

function getPointLocation(img, i)
{
	var pixels = [
		[
			[0x00, 0x00, 0x05, 0x00, 0x00, 0x0D, 0x00, 0x0F, 0x00, 0x00, 0x06, 0x00, 0x00, ],
			[0x00, 0x00, 0x04, 0x00, 0x0C, 0x00, 0x0E, 0x00, 0x10, 0x00, 0x07, 0x00, 0x00, ],
			[0x01, 0x02, 0x03, 0x00, 0x0B, 0x00, 0x00, 0x00, 0x11, 0x00, 0x08, 0x09, 0x0A  ]
		],
		[
			[0x05, 0x00, 0x03, 0x02, 0x01, ],
			[0x06, 0x00, 0x04, 0x00, 0x00, ],
			[0x07, 0x08, 0x11, 0x0C, 0x0B, ],
			[0x00, 0x00, 0x10, 0x00, 0x0A, ],
			[0x0D, 0x0E, 0x0F, 0x00, 0x09  ]
		]
	];

	for(var y = 0; y < pixels[img].length; y++)
	{	
		var row = pixels[img][y];
		for(var x = 0; x < row.length; x++)
		{
			if (row[x] == i)
			{
				return {
					"x": x,
					"y": pixels[img].length-y,
					"z": 0
				};

			}
		}
	}

	return undefined;
}

var logoData = {
	"translate":[
		{"x":-6, "y":-1.5, "z":0},
		{"x":-2, "y":-3, "z":0}
	],
	"scale":[
		0.07,
		0.17
	],
	"angle":[
		{"degreesZ":-360*1},
		{"degreesZ":45}
	],
	"points":[]
};
function initJmlLogo(animation)
{

	for(var i = 1; i <= 0x11; i++)
	{
		var obj = {
			"p1": getPointLocation(0, i),
			"p2": getPointLocation(1, i)
		};

		logoData.points.push(obj);
	}
}

function drawJmlLogo(animation)
{
	var p = (getSceneTimeFromStart()-animation.logoStart)/animation.logoDuration;
	p = interpolateSmootherStep(p, 0.0, 1.0);

	glPushMatrix();
	var scale = interpolateLinear(p, logoData.scale[0], logoData.scale[1]);
	var rotZ = interpolateLinear(p, logoData.angle[0].degreesZ, logoData.angle[1].degreesZ);
	glRotatef(rotZ,0,0,1);
	glScalef(scale, scale, scale);
	var x = interpolateLinear(p, logoData.translate[0].x, logoData.translate[1].x);
	var y = interpolateLinear(p, logoData.translate[0].y, logoData.translate[1].y);
	var z = interpolateLinear(p, logoData.translate[0].z, logoData.translate[1].z);
	glTranslatef(x,y,z);
	glColor3f(0,0,0);

	for(var i = 0; i < logoData.points.length; i++)
	{
		var quad = {
			"x": interpolateLinear(p, logoData.points[i].p1.x, logoData.points[i].p2.x),
			"y": interpolateLinear(p, logoData.points[i].p1.y, logoData.points[i].p2.y),
			"z": interpolateLinear(p, logoData.points[i].p1.z, logoData.points[i].p2.z)
		};

		drawQuad(quad.x,quad.y,quad.z);
	}

	glPopMatrix();

}

// ***************************
// *** AUSCHWITZ GATE
// ***************************

var literatureReferences;
Demo.prototype.preInitGate = function(loader, startTime, durationTime)
{
	var scrollerStartTime = 10*TICK;
	if (juho88 !== true)
	{
		var scrollerText = "ARBEIT MACHT FREI ARBEIT MACHT FREI ARBEIT MACHT FREI GREETINGS TO ALL HAPPY CAMPERS AT VORTEX 2016. REMINDER FROM THE PARTY: ONLY BY MAKING PRODUCTIONS AND RELEASING THEM YOU CAN BE SET FREE.   ARBEIT MACHT FREI ARBEIT MACHT FREI ARBEIT MACHT FREI";
		loader.addAnimation([
		{
			 "start": startTime, "duration": durationTime
			,"layer": 21, "text":{"string":scrollerText}
			,"scale": [
				  {"uniform2d":1.5}
			]
			,"color":[{"r":0,"g":0,"b":0}]
			,"position": [
				  {"x":0,"y":45}
				 ,{"start":startTime+scrollerStartTime,"duration": durationTime, "x":-scrollerText.length*78}
			]
			,"align": Constants.Align.LEFT
			,"passToFbo":{"name":"gateTextFbo"}
		}]);
	}
	else
	{
		var textLengthPart = 10000;
		for(var i = 0; i < 1; i++)
		{
			var scrollerText = Liturgy.manifest(literatureReferences.substring(i*textLengthPart,textLengthPart));
			var scrollerPartDuration = 60*15;
			var xStart = getScreenWidth();
			if (i == 0)
			{
				xStart = 0;
			}
			loader.addAnimation([
			{
				 "start": startTime+scrollerPartDuration*i, "duration": scrollerPartDuration
				,"layer": 21, "text":{"string":scrollerText}
				,"scale": [
					  {"uniform2d":1.5}
				]
				,"color":[{"r":0,"g":0,"b":0}]
				,"position": [
					  {"x":xStart,"y":45}
					 ,{"start":scrollerStartTime+scrollerPartDuration*i,"duration": scrollerPartDuration, "x":-scrollerText.length*78}
				]
				,"align": Constants.Align.LEFT
				,"passToFbo":{"name":"gateTextFbo"}
			}]);
		}
	}

	loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"layer": 30
		,"fbo":{"name":"gateFbo","action":"begin"}
	}]);

	loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/aushwitz_gate.png"
		,"layer": 30
	}]);

	var scale = 0.60;
	loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"object":"gate","shape":{"type":"MATRIX"}
		,"layer": 31
		,"initFunction":"{initGateScroller(animation);}"
		,"runFunction":"{drawGateScroller(animation);}"
		,"position":[
			{"x":-0.13,"y":-0.078,"z":-0.0}
		]
		,"angle":[
			{"degreesY":60,"degreesZ":-15}
		]
		,"scale":[
			{"x":scale,"y":scale,"z":scale}
		]
	}]);

	var walkerStart = TICK*10;
	var walkDuration = TICK*10;
	var walkers = 18;
	if (loader === this.betterLoader) {
		walkers = 100;
	}
	var groupText = [
		 "PRIMITIVE"
		,"MATT CURRENT"
		,"KONVERGENCE"
		,"DAMONES"
		,"BYTERAPERS"
		,"FAG"
	];

	var walkerDelay = TICK*1.25;
	for (var i = 0; i < walkers; i++)
	{
		var zBias = 0;//Math.random()*0.25;
		var walkerImages = ["data/man.png","data/woman.png"];
		var imageName = walkerImages[Math.floor(Math.random()*walkerImages.length)];
		var randStart = Math.random()*0.6;
		var randDuration = Math.random()*0.25;
		loader.addAnimation([
		{
			 "start": startTime+walkerStart+i*walkerDelay+randStart+zBias, "duration": walkDuration+randDuration
			,"image": imageName, "perspective": "3d"
			,"layer": 32
			,"position":[{"z":-0.5+zBias,"y":-0.8,"x":-2},{"duration":walkDuration,"z":-2+zBias,"y":-1.3,"x":3.5}]
			,"angle":[{"degreesY":40,"degreesX":10},{"duration":walkDuration,"degreesY":90,"degreesX":10}]
			,"color":[{"a":240}]
		}]);

		if (loader !== this.betterLoader && groupText.length > 0 && i%3 == 0) {
			var groupName = groupText.pop();
			loader.addAnimation([
			{
				 "start": startTime+walkerStart+i*walkerDelay+randStart+zBias, "duration": walkDuration+randDuration
				,"layer": 32, "text":{"string":groupName, "perspective":"3d"}
				,"position":[{"z":-0.5,"y":-0.1,"x":-2},{"duration":walkDuration,"z":-2,"y":-0.6,"x":3.5}]
				,"angle":[{"degreesY":30,"degreesX":0,"degreesZ":-5},{"duration":walkDuration,"degreesY":10,"degreesX":10}]
				,"color":[{"a":0,"r":0x80,"g":0x80,"b":0x80},{"duration":TICK,"a":240},{"duration":walkDuration+randDuration-1.25},{"duration":1,"a":0}]
				,"scale": [
					  {"uniform2d":0.25}
				]
			}]);

		}
	}

	loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "data/aushwitz_gate_foreground.png"
		,"layer": 35
	}]);

	loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"layer": 35
		,"fbo":{"name":"gateFbo","action":"unbind"}
	}]);

	var zoomOutDuration = TICK*6;
	loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"image": "gateFbo.color.fbo"
		,"layer": 35
		,"scale":[{"uniform2d":5},{"duration":zoomOutDuration,"uniform2d":1}]
		,"position":[
			 {"x":-getScreenWidth()*0.70,"y":getScreenHeight()*1.9}
			,{"duration":zoomOutDuration,"x":getScreenWidth()/2,"y":getScreenHeight()/2}]
	}]);

}

var gateTextFbo;
var gateSplinePathDefinitionUpper = [];
var gateSplinePathDefinitionLower = [];
var gateSplinePathUpper;
var gateSplinePathLower;
function initGateScroller(animation)
{
	if (gateTextFbo != null)
	{
		return;
	}

	literatureReferences = readFile("data/onenationundergod.raw");

	gateTextFbo = fboInit("gateTextFbo");

	var stepCount = 20.0;
	var subStepPrecision = 10;

	for(var i = 0; i <= stepCount; i++)
	{
		var start = -1.5;
		var size = 3.1;
		var step = size/stepCount;
		gateSplinePathDefinitionUpper.push({"x":start+step*i, "y":0.65, "z":-1});
	}
	gateSplinePathDefinitionUpper[ 0].y += 0.00;
	gateSplinePathDefinitionUpper[ 1].y += 0.03;
	gateSplinePathDefinitionUpper[ 2].y += 0.05;
	gateSplinePathDefinitionUpper[ 3].y += 0.07;
	gateSplinePathDefinitionUpper[ 4].y += 0.09;
	gateSplinePathDefinitionUpper[ 5].y += 0.09;
	gateSplinePathDefinitionUpper[ 6].y += 0.15;
	gateSplinePathDefinitionUpper[ 7].y += 0.20;
	gateSplinePathDefinitionUpper[ 8].y += 0.22;
	gateSplinePathDefinitionUpper[ 9].y += 0.25;
	gateSplinePathDefinitionUpper[10].y += 0.22;
	gateSplinePathDefinitionUpper[11].y += 0.16;
	gateSplinePathDefinitionUpper[12].y += 0.09;
	gateSplinePathDefinitionUpper[13].y += 0.09;
	gateSplinePathDefinitionUpper[14].y += 0.10;
	gateSplinePathDefinitionUpper[15].y += 0.11;
	gateSplinePathDefinitionUpper[16].y += 0.11;
	gateSplinePathDefinitionUpper[17].y += 0.10;
	gateSplinePathDefinitionUpper[18].y += 0.09;
	gateSplinePathDefinitionUpper[19].y += 0.07;
	gateSplinePathDefinitionUpper[20].y += 0.07;

	var catmullRomPath = new CatmullRomSpline()
	gateSplinePathUpper = catmullRomPath.calculateSpline(gateSplinePathDefinitionUpper, subStepPrecision);

	for(var i = 0; i <= stepCount; i++)
	{
		var start = -1.5;
		var size = 3.1;
		var step = size/stepCount;
		gateSplinePathDefinitionLower.push({"x":start+step*i, "y":0.45, "z":-1});
	}
	gateSplinePathDefinitionLower[ 0].y += -0.01;
	gateSplinePathDefinitionLower[ 1].y += 0.03;
	gateSplinePathDefinitionLower[ 2].y += 0.06;
	gateSplinePathDefinitionLower[ 3].y += 0.08;
	gateSplinePathDefinitionLower[ 4].y += 0.10;
	gateSplinePathDefinitionLower[ 5].y += 0.10;
	gateSplinePathDefinitionLower[ 6].y += 0.12;
	gateSplinePathDefinitionLower[ 7].y += 0.17;
	gateSplinePathDefinitionLower[ 8].y += 0.22;
	gateSplinePathDefinitionLower[ 9].y += 0.24;
	gateSplinePathDefinitionLower[10].y += 0.18;
	gateSplinePathDefinitionLower[11].y += 0.12;
	gateSplinePathDefinitionLower[12].y += 0.09;
	gateSplinePathDefinitionLower[13].y += 0.10;
	gateSplinePathDefinitionLower[14].y += 0.10;
	gateSplinePathDefinitionLower[15].y += 0.11;
	gateSplinePathDefinitionLower[16].y += 0.12;
	gateSplinePathDefinitionLower[17].y += 0.11;
	gateSplinePathDefinitionLower[18].y += 0.09;
	gateSplinePathDefinitionLower[19].y += 0.07;
	gateSplinePathDefinitionLower[20].y += 0.03;

	var catmullRomPathLower = new CatmullRomSpline()
	gateSplinePathLower = catmullRomPathLower.calculateSpline(gateSplinePathDefinitionLower, subStepPrecision);
}

function drawGateScroller(animation)
{
	glPushMatrix();

	if (juho88 === undefined)
	{
		juho88 = false;
	}

	glEnable(GL_TEXTURE_2D);
	glEnable(GL_BLEND);
	fboBindTextures(gateTextFbo.ptr);

	for(var i = 0; i < gateSplinePathUpper.length-1; i+=1)
	{
		var pu0 = gateSplinePathUpper[i];
		var pu1 = gateSplinePathUpper[i+1];
		var pl0 = gateSplinePathLower[i];
		var pl1 = gateSplinePathLower[i+1];

		var percentStep = 1/(gateSplinePathUpper.length-1);
		var percent = (i+1)/(gateSplinePathUpper.length-1);

		var fontSize = 85;
		var uv = {
			"uMax": percent,
			"vMax": fontSize/getScreenHeight(),
			"uMin": percent-percentStep,
			"vMin": 0
		} 

		glBegin(GL_QUADS);
		glTexCoord2d(uv.uMax,uv.vMax);
		glVertex3d(pu1.x, pu1.y, pu1.z); 
		glTexCoord2d(uv.uMin,uv.vMax);
		glVertex3d(pu0.x, pu0.y, pu0.z); 
		glTexCoord2d(uv.uMin,uv.vMin);
		glVertex3d(pl0.x, pl0.y, pl0.z);
		glTexCoord2d(uv.uMax,uv.vMin);
		glVertex3d(pl1.x, pl1.y, pl1.z); 
		glEnd();
	}

	glDisable(GL_TEXTURE_2D);
	glDisable(GL_BLEND);

	glPopMatrix();
}

// ***************************
// *** BOMB SCENE
// ***************************

Demo.prototype.preInitBombScene = function(startTime, durationTime)
{
	var FADE = TICK;

	var dropStart = startTime+8*TICK;
	var dropTime = 6*TICK;

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"perspective":"3d"
		,"position": [{"z":-1.7},{"start":dropStart, "duration":dropTime, "z":-10.7}]
		,"angle": [{"degreesZ":40}]
		,"image": "plane_bottom.png"
		,"scale": [{"uniform2d":1.0}]
		,"color": [{"a":255},{"duration":durationTime-FADE},{"duration":FADE,"a":0}]
		,"layer": 7
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"perspective":"3d"
		,"position": [{"z":-1.7,"x":-1,"y":0},{"start":dropStart, "duration":dropTime, "z":-10.7}]
		,"angle": [{"degreesZ":40}]
		,"image": "plane_bottom.png"
		,"scale": [{"uniform2d":1.0}]
		,"color": [{"a":255},{"duration":durationTime-FADE},{"duration":FADE,"a":0}]
		,"layer": 7
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"perspective":"3d"
		,"position": [{"z":-1.7,"x":0.2,"y":-1},{"start":dropStart, "duration":dropTime, "z":-10.7}]
		,"angle": [{"degreesZ":40}]
		,"image": "plane_bottom.png"
		,"scale": [{"uniform2d":1.0}]
		,"color": [{"a":255},{"duration":durationTime-FADE},{"duration":FADE,"a":0}]
		,"layer": 7
	}]);


	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"perspective":"3d"
		,"position": [{"z":-1.0},{"start":dropStart, "duration":dropTime, "z":-10.0}]
		,"angle": [{"degreesX":-40, "degreesY":-10}]
		,"image": "clouds_01.png"
		,"scale": [{"uniform2d":20}]
		,"color": [{"a":155},{"duration":durationTime-FADE},{"duration":FADE,"a":0}]
		,"uvSpeed": 0.05
		,"uvMax": 2
		,"uv": {
			 "uMin": "{return (getSceneTimeFromStart()*animation.uvSpeed)%animation.uvMax-animation.uvMax;}"
			,"vMin": "{return (getSceneTimeFromStart()*animation.uvSpeed)%animation.uvMax-animation.uvMax;}"
			,"uMax": "{return (getSceneTimeFromStart()*animation.uvSpeed)%animation.uvMax;}"
			,"vMax": "{return (getSceneTimeFromStart()*animation.uvSpeed)%animation.uvMax;}"
		}
		,"layer": 7
	}]);

	this.loader.addAnimation([
	{
		 "start": dropStart, "duration": durationTime, "object":"dabomb.obj"
		,"layer": 20
		,"position": [{"z":-3},{"duration":dropTime*1.5,"z":8.0, "y":-2}]
		,"angle": [{"degreesZ":40}, {"duration":2*TICK, "degreesZ":10,"degreesX":-100}]
		,"scale": [{"uniform2d":0.0},{"duration":dropTime*1.5,"uniform2d":0.5}]
	}]);
}

var bestCounter = 0;
Demo.prototype.run = function()
{
	var loader = this.loader;
	if (juho88 === true)
	{
		loader = this.betterLoader;
	}

	this.player.drawAnimation(loader.animationLayers);

	while (Input.hasEvents())
	{
		var event = Input.pollEvent();
		if (event.type == Input.type.KEYUP && juho88 == false)
		{
			if (event.keyboard.symbol == Input.Keyboard.symbol.KEY_8)
			{
				bestCounter++;
			}
			else
			{
				bestCounter = 0;
			}
		}
	}

	if (bestCounter == 2)
	{
		juho88 = true;

		if (soundGetCurrentSong() == 0)
		{
			setPlaylistLength("999:99");
			timerInit(-1);
			this.preInitGate(this.betterLoader, 0,999999);
			this.betterLoader.processAnimation();
			debugPrint("better: " + JSON.stringify(this.betterLoader,null,2));
			soundStop();
			soundAddSongToPlaylist("data/horst_wessel_lied.ogg","",0);
			soundPlaySong(1);
		}
	}
}
