from drawingutils import DrawingUtils
from effects.effect_base import Effect

"""
from math import sin, cos, floor
from shader_base import Shader


def clamp(a, b, c):
    return min(max(a, b), c)


def rotateX(point, angle):
    sa = sin(angle)
    ca = cos(angle)
    return point[0], \
           ca * point[1] - sa * point[2], \
           sa * point[1] + ca * point[2]


def rotateY(point, angle):
    sa = sin(angle)
    ca = cos(angle)
    return ca * point[0] - sa * point[2],\
           point[1], \
           sa * point[0] + ca * point[2]


def rotateZ(point, angle):
    sa = sin(angle)
    ca = cos(angle)
    return ca * point[0] - sa * point[1],\
           sa * point[0] + ca * point[1], \
           point[2]


def modInterval1(p, size, start, stop):
    hs = size * 0.5
    c = floor((p + hs) / size)
    p = (p + hs) % size - hs
    if c > stop:
        p += size * (c - stop)
    elif c < start:
        p += size * (c - start)
    return p


def abs3(point):
    return abs(point[0]), abs(point[1]), abs(point[2])


def sub33(a, b):
    return a[0] - b[0], a[1] - b[1], a[2] - b[2]


def add33(a, b):
    return a[0] + b[0], a[1] + b[1], a[2] + b[2]


def scale3(a, b):
    return a[0] * b, a[1] * b, a[2] * b


def scale33(a, b):
    return a[0] * b[0], a[1] * b[1], a[2] * b[2]


def max3(a, bound):
    return max(a[0], bound), max(a[1], bound), max(a[2], bound)


def dot3(a, b):
    return a[0] * b[0] + a[1] * b[1] + a[2] * b[2]


def length3(a):
    return (a[0] * a[0] + a[1] * a[1] + a[2] * a[2]) ** 0.5


def normalize3(a):
    return scale3(a, 1.0 / length3(a))


def box(point, extents):
    d = sub33(abs3(point), extents)
    return min(max(d[0], max(d[1], d[2])), 0.0) + length3(max3(d, 0.0))


def sphere(point, radius):
    return length3(point) - radius


def topping(point):
    point = point[0], point[1] - 1.65, point[2]
    ln = length3(point)
    return max(-(ln - 1.9), max(box(point, (0.3, 6.0, 0.5)), ln - 2.0))


def rice(point):
    return sphere((point[0], point[1], modInterval1(point[2], 0.2, -1.0, 1.0)), 0.3)


def plank(point):
    main = box((point[0], point[1] - 0.35, point[2]), (1.2, 0.05, 0.8))
    legs = box((abs(point[0]) - 0.6, point[1] - 0.55, point[2]), (0.1, 0.1, 0.8))
    return min(main, legs)


def filling(point):
    return box(point, (0.1, 0.25, 0.1))


def rice_cylinder(point):
    height = (abs(point[1]) - 0.2)
    return max(height, length3((point[0], 0.0, point[2])) - 0.25)


def seaweed(point):
    height = (abs(point[1]) - 0.19)
    return max(height, length3((point[0], 0.0, point[2])) - 0.27)


import time


def fField(point):
    a = plank(point)
    id = 0

    def sushi1(point, a, id):
        b = rice(point)
        if b < a:
            a = b
            id = 1
        c = topping(point)
        if c < a:
            a = c
            id = 2
        return a, id

    def sushi2(point, a, id):
        d = filling(point)
        e = rice_cylinder(point)
        f = seaweed(point)
        if d < a:
            a = d
            id = 2
        if e < a:
            a = e
            id = 1
        if f < a:
            a = f
            id = 3
        return a, id

    b, id2 = sushi2(point, a, id)
    a, id = sushi1(point, a, id)
    w = sin(time.time()) * 0.5 + 0.5

    a = a * w + b * (1.0 - w)
    id = id * w + id2 * (1.0 - w)

    return a, id


def grad(point, lastD):  # lastD == fField(point), but we already know it
    return ((fField((point[0] + 0.01, point[1], point[2]))[0] - lastD) * 100.0,
            (fField((point[0], point[1] + 0.01, point[2]))[0] - lastD) * 100.0,
            (fField((point[0], point[1], point[2] + 0.01))[0] - lastD) * 100.0)


MAX_STEPS = 12
DIST = 4
NEAR_CLIP = DIST - 2.5
FAR_CLIP = DIST + 1
INV_CLIP = 1.0 / (FAR_CLIP - NEAR_CLIP)
EPSILON = 0.03
FOV = 0.1
COLORS = ((0.4, 0.15, 0.05), (0.8, 0.8, 0.75), (0.6, 0.1, 0.15), (0.1, 0.4, 0.3))

sunDir = normalize3((0.5, -1.0, 0.4))
bounceDir = (-0.3, 0.7, 0.3)
fillDir = (-0.3, -0.7, -0.5)

AMBIENT = (0.3, 0.4, 0.6)
SUN = (2.0, 1.4, 0.6)
BOUNCE = (1.0, 0.8, 0.2)
FILL = (0.0, 0.2, 0.2)

class Sushi(Shader):
    def pre_sample(self, alive):
        return (self._width / float(self._height),)

    def sample(self, alive, u, v, *args):
        uv = (u * 2.0 - 1.0) * args[0], v * 2.0 - 1.0

        origin = (0.0, 0.0, -DIST)
        direction = (0.0, 0.0, 1.0)
        direction = rotateY(direction, uv[0] * FOV)
        direction = rotateX(direction, -uv[1] * FOV)
        # tilt
        direction = rotateX(direction, -0.4)
        origin = rotateX(origin, -0.4)
        # orbit
        direction = rotateY(direction, alive)
        origin = rotateY(origin, alive)

        dist = NEAR_CLIP
        mtl = 0
        for i in xrange(MAX_STEPS):
            d, mtl = fField(add33(origin, scale3(direction, dist)))
            dist += d
            if dist > FAR_CLIP:
                return AMBIENT
            if d < EPSILON:
                break

        # fog = 1.0 / (-0.5 + dist)
        fog = 1.0 - (dist - NEAR_CLIP) * INV_CLIP
        if fog < 0.01:
            return (0.0, 0.0, 0.0)

        fraction = mtl % 1.0
        color = COLORS[int(mtl)]
        if fraction:
            iw = 1.0 - fraction
            color = (color[0] * iw + COLORS[int(mtl) + 1][0] * fraction,
                     color[1] * iw + COLORS[int(mtl) + 1][1] * fraction,
                     color[2] * iw + COLORS[int(mtl) + 1][2] * fraction)
        color = scale3(color, fog)

        # unlit mode saving 4 fField samples and a bunch of lighting maths
        # return scale3(color, fog * fog + 2.0)

        isect = add33(origin, scale3(direction, dist))
        normal = grad(isect, d)

        sun = max(dot3(normal, sunDir), 0.0)
        bounce = max(dot3(normal, bounceDir), 0.0)
        fill = max(dot3(normal, fillDir), 0.0)

        diffCl = add33(add33(scale3(SUN, sun), scale3(BOUNCE, bounce)), scale3(FILL, fill))
        shadow = fField(add33(isect, scale3(sunDir, 0.2)))[0]

        if shadow < 0.04:
            return scale33(AMBIENT, color)

        return scale33(add33(diffCl, AMBIENT), color)
"""

class SushiCPP(Effect):
    def __init__(self, maxTimeStep, width, height, scale=1):
        super(SushiCPP, self).__init__(width, height)
        self._maxTimeStep = maxTimeStep
        self._alive = 0.0
        self._scale = scale

    def render(self, alive, delta_time, buffer):
        self._alive += min(self._maxTimeStep, delta_time)
        DrawingUtils().sbDrawSushi(buffer.buffer(), self._alive,
                                   self._width, self._height,
                                   self._offset[0], self._offset[1])
        buffer.resizeRectangle(self._offset[0], self._offset[1], self._width, self._height,
                               self._offset[0], self._offset[1], int(self._width * self._scale), int(self._height * self._scale))