from math import sin, cos, pi
from drawingutils import ColorBrush


class WireCube(object):
    def render(self, alive, delta_time, buffer, width, height):
        # clear the background
        brush = ColorBrush(0.0, 0.0, 0.0)
        buffer.fillRectangle(brush, 0, 0, width, height)

        # Knoeki style rotating isometric wireframe cubes!
        brush = ColorBrush(1.0, 0.0, 0.0)
        data = [(10, 5, 8, 6, 1.0, alive * 2.0),
                (20, 5, 6, 10, 1.0, alive * 2.0),
                (15, 15, 14, 4, 0.25, alive * 2.0)]
        for ox, oy, size, height, aspect, angle, in data:
            px1, py1 = 0, 0
            for i in range(5):
                x1 = ox + int(sin(i * 0.5 * pi + angle) * size + size)
                y1 = oy + int(aspect * cos(i * 0.5 * pi + angle) * size + size)
                if i > 0:
                    buffer.drawLine(brush, x1, y1, x1, y1 + height)
                    buffer.drawLine(brush, px1, py1, x1, y1)
                    buffer.drawLine(brush, px1, py1 + height, x1, y1 + height)
                px1, py1 = x1, y1