from math import sin, cos

import image
from drawingutils import TextureBrush
from effects.effect_base import Effect


class SushiRotator(Effect):
    def __init__(self, *args):
        super(SushiRotator, self).__init__(*args)
        self.__brush = TextureBrush(*image.get_image('sushi'))
        self._speed = 0.1
    def render(self, alive, delta_time, buffer):
        hw = self._width * 0.5
        hh = self._height * 0.5
        halfSize = min(hw, hh) * 1.4
        ca = halfSize * cos(alive *self._speed)
        sa = halfSize * sin(alive * self._speed)

        x1, y1 = int(-ca + sa + hw), int(-sa - ca + hh)
        x2, y2 = int(ca + sa + hw), int(sa - ca + hh)
        x3, y3 = int(ca - sa + hw), int(sa + ca + hh)
        x4, y4 = int(-ca - sa + hw), int(-sa + ca + hh)

        buffer.fillRectangleI(int(0.3 * 255) | int(0.4 * 255) << 8 | int(0.6 * 255) << 16, 0, 0, self._width, self._height)
        buffer.drawTriangle(self.__brush, x1, y1, x2, y2, x3, y3, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0)
        buffer.drawTriangle(self.__brush, x1, y1, x3, y3, x4, y4, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0)


        self._speed += delta_time *0.01
        self._speed = self._speed if self._speed < 3 else 3