import vertexanimation
from drawingutils import TextureBrush
from effects.effect_base import Effect
import image
from math import sin, cos, pi

SCROLL_SPEED = 0.025


class Shoutouts(Effect):
    def __init__(self, *args, **kwargs):
        super(Shoutouts, self).__init__(*args, **kwargs)
        self.meshData = vertexanimation.load()
        self.shoutoutTextures = {'|group1|shoutout_01|shoutout_0Shape1': TextureBrush(*image.get_image('SystemK')),
                                 '|group1|shoutout_02|shoutout_0Shape2': TextureBrush(*image.get_image('ctrl-alt-test')),
                                 '|group1|shoutout_03|shoutout_0Shape3': TextureBrush(*image.get_image('DBB')),
                                 '|group1|shoutout_04|shoutout_0Shape4': TextureBrush(*image.get_image('Jugem-T')),
                                 '|group1|shoutout_05|shoutout_0Shape5': TextureBrush(*image.get_image('PandaCube')),
                                 '|group1|shoutout_06|shoutout_0Shape6': TextureBrush(*image.get_image('RBBS')),
                                 '|group1|shoutout_07|shoutout_0Shape7': TextureBrush(*image.get_image('dub')),
                                 '|group1|shoutout_08|shoutout_0Shape8': TextureBrush(*image.get_image('Inque')),
                                 '|group1|shoutout_09|shoutout_0Shape9': TextureBrush(*image.get_image('Mercury'))}

        self.__extraShoutouts = image.get_image('extrashoutouts')
        self.__zoom = 16
        self.__speed = 8
        self.__alive = None

    def render(self, alive, deltaTime, buffer):
        # cache starttime and make "alive" variable local!
        if self.__alive is None:
            self.__alive = alive
        alive -= self.__alive

        # clear buffer
        buffer.fillRectangleI(255 << 24, 0, 0, self._width, self._height)

        # animate some stuff
        angle = alive * 0.5
        space_base = 50
        space_deviation = 10
        offset = int(((angle / pi) % 1) * 2 * space_base - space_base)  # used in inline functions below
        space = int(space_base + space_deviation * sin(angle))

        # draw the grid
        def line(color, x, r, transform, hw, hh, flip=False):
            x1, y1 = x * transform[0] + r * transform[1], -r * transform[0] + x * transform[1]
            x2, y2 = x * transform[0] - r * transform[1], r * transform[0] + x * transform[1]
            if flip:
                x1, y1 = -y1, x1
                x2, y2 = -y2, x2
            buffer.drawLineI(color, int(x1) + hw + offset, int(y1) + hh, int(x2) + hw + offset, int(y2) + hh)

        def gridLine(color, x, r, transform, hw, hh):
            for state in range(2):
                line(color, x, r, transform, hw, hh, bool(state))
                line(color, -x, r, transform, hw, hh, bool(state))

        r = int((max(self._width, self._height) ** 2.0 * 2) ** 0.5)
        hw = self._width / 2
        hh = self._height / 2
        hr = r  # / 2

        transform = cos(angle), sin(angle)

        color = 140 << 16 | 120 << 8
        for x in range(space, hr, 2 * space):
            gridLine(color, x, hr, transform, hw, hh)
            gridLine(color, x + 0.65, hr, transform, hw, hh)

        color = 80 << 16 | 60 << 8
        for x in range(space / 4, hr, space / 2):
            gridLine(color, x, hr, transform, hw, hh)

        vertexanimation.sample(self.meshData, alive, buffer, self._offset, 255, self.__zoom, self.__speed, self.shoutoutTextures)

        x = int(self._width - ((alive * SCROLL_SPEED) % 1.0) * (self._width + 2 * self.__extraShoutouts[1]))
        buffer.drawImage(x, 0, self.__extraShoutouts[1], self.__extraShoutouts[2], 0, self.__extraShoutouts[0])
