from drawingutils import DrawingUtils
from effects.effect_base import Effect

from shader_base import Shader
from math import pow, sqrt, sin, cos


class ShaderBallPython(Shader):
    def pre_sample(self, alive):
        return (float(self._width) / float(self._height),)

    def sample(self, alive, x, y, aspect):
        def backGround(alive, rx, ry, rz):
            f = 0.73529411764
            lx = sin(alive) * f
            ly = 0.44117647058
            lz = cos(alive) * f
            sun = max(0.0, rx * lx + ry * ly + rz * lz)
            sky = max(0.0, ry)
            ground = max(0.0, -ry)
            a = pow(sun, 256.0) + 0.2 * sun * sun
            g = sqrt(ground)
            return min(max(2.0 * a + 0.4 * g + 0.5 * sky, 0.0), 1.0),\
                   min(max(1.6 * a + 0.3 * g + 0.6 * sky, 0.0), 1.0),\
                   min(max(1.0 * a + 0.2 * g + 0.8 * sky, 0.0), 1.0)

        u, v = (x * 2.0 - 1.0) * aspect, (y * 2.0 - 1.0) * -1

        roz = -3.0
        f = 1.0 / (u * u + v * v + 1.0)
        rx = u * f
        ry = v * f
        rz = f

        c = roz * roz - 1.0
        b = rz * roz
        d = (b * b) - c
        st = -b - sqrt(abs(d))
        t = -1.0
        if min(st, d) >= 0.0:
            t = st

        nx = -rx * t
        ny = -ry * t
        nz = -rz * t - roz
        f = 1.0 / (nx * nx + ny * ny + nz * nz)
        nx *= f
        ny *= f
        nz *= f

        if t < 0.0:
            return backGround(alive, rx, ry, rz)

        d2 = (nx * rx + ny * ry + nz * rz) * 2.0
        rx -= nx * d2
        ry -= ny * d2
        rz = -(rz - nz * d2)

        col = list(backGround(alive, rx, ry, rz))
        col[0] *= 0.9
        col[1] *= 0.8
        return col


class ShaderBall(Effect):
    def __init__(self, maxTimeStep, width, height, scale=1):
        super(ShaderBall, self).__init__(width, height)
        self._maxTimeStep = maxTimeStep
        self._alive = 0.0
        self._scale = scale

    def render(self, alive, delta_time, buffer):
        self._alive += min(self._maxTimeStep, delta_time)
        DrawingUtils().sbDrawShaderBall(buffer.buffer(), self._alive,
                                        self._width, self._height,
                                        self._offset[0], self._offset[1])
        buffer.resizeRectangle(self._offset[0], self._offset[1], self._width, self._height,
                               self._offset[0], self._offset[1], int(self._width * self._scale), int(self._height * self._scale))
