from drawingutils import DrawingUtils
from effects.effect_base import Effect

"""
from shader_base import Shader
from math import sin, cos, pi
class Plasma(Shader):
    '''
    http://www.bidouille.org/prog/plasma
    '''
    def pre_sample(self, alive):
        scale = 1.5, 1.5
        ox = scale[0] * 0.5 * sin(alive * 0.33333)
        oy = cos(alive * 0.5)
        return scale, ox, oy

    def sample(self, alive, u, v, *args):
        scale, ox, oy = args
        v = v * scale[1] - scale[1] * 0.5
        u = u * scale[0] - scale[0] * 0.5

        hv = v + alive * 0.5
        value = sin(u + alive)
        value += sin(hv)
        value += sin(u * 0.5 + hv)
        c = u + ox, v + oy
        value += sin((c[0] * c[0] + c[1] * c[1] + 1.0) + alive)
        value *= 0.5

        # color variations:
        # rgb = sin(pi * value), cos(pi * value), 0.0
        # rgb = 1.0, sin(pi * value), cos(pi * value)
        rgb = sin(pi * value), sin(pi * value + 2.0 * pi * 0.33333), sin(pi * value + 4.0 * pi * 0.333333)
        # rgb = sin(value * 5.0 * pi), sin(value * 5.0 * pi), sin(value * 5.0 * pi)

        return rgb
"""


class Plasma(Effect):
    def __init__(self, maxTimeStep, width, height, scale=1):
        super(Plasma, self).__init__(width, height)
        self._maxTimeStep = maxTimeStep
        self._alive = 0.0
        self._scale = scale

    def render(self, alive, delta_time, buffer):
        self._alive += min(self._maxTimeStep, delta_time)
        DrawingUtils().sbDrawPlasma(buffer.buffer(), self._alive,
                                    self._width, self._height,
                                    self._offset[0], self._offset[1])
        buffer.resizeRectangle(self._offset[0], self._offset[1], self._width, self._height,
                               self._offset[0], self._offset[1], int(self._width * self._scale), int(self._height * self._scale))