from effect_base import Effect
from drawingutils import rgb2packedInt
from effectUtils import excel_style
import ctypes
import random 
from globals import *

class FillScreen(Effect):
    def __init__(self, *args, **kwargs):
        self._color = rgb2packedInt(*kwargs.pop("color"), short = True )
        self._bgCol = rgb2packedInt(*kwargs.get("bgCol", (0,0,0)) )
        self._speed = kwargs.pop("speed")
        self._oneByOne = kwargs.get("oneByOne", False)
        self._flash = kwargs.get("flash", False)
        self._flashState = False 
        self._noFill = kwargs.get("noFill", False)
        super(FillScreen, self).__init__(*args, **kwargs)
        self._preList = range(self._width * self._height)
        self._buff = [0 for x in xrange( self._width * self._height)]
        self._timePassed = 0 

    def render( self, alive, delta_time, buffer):

        if self._oneByOne:
            for x in xrange( int(self._speed*int(alive))):
                if self._preList:
                    index = random.randint(0,len(self._preList)-1)
                    cellNr = int(self._preList[index])
                    del self._preList[index]
                    self._buff[cellNr] = self._color
        elif self._flash:
            if self._flashState:
                self._flashState = False 
                self._buff = [self._bgCol for x in xrange( self._width * self._height)]
            else:
                self._buff = [self._color for x in xrange( self._width * self._height)]

            if self._timePassed > self._speed:
                self._timePassed = 0
                self._flashState = not self._flashState
            else:
                self._timePassed+= delta_time
        else:
            self._buff = [self._color for x in xrange( self._width * self._height)]




        if self._lastPageOnly:
            if not self._oneByOne:
                s = excel_style(self._offset[0]+1, self._offset[1]+1)
                e = excel_style(self._width, self._height)
                self._sheets[2].Range("%s:%s"%(s,e)).Interior.ColorIndex = 0
                return 

            ## lelijk maar werkt om ff op de 3de page te tekenen. 
            for y in xrange(self._height):
                for x in xrange( self._width):
                    bufI = y * self._width+ x
                    i = (y+self._offset[1])*EXCEL_MAX_X + (x +self._offset[0])
                    col = self._buff[bufI]
                    if not col == 0:
                        self._renderer._excel.Application.Run("set_color_pixel", 3, i+1,col)
        else:
            buffer.drawImage(self._offset[0], self._offset[1], 
                                self._width , self._height, 0, 
                                (ctypes.c_int * (self._width * self._height))(*self._buff))


        
