#version 130
varying vec2 tCoord;
varying vec4 pos;
varying float distPosToCam;
uniform sampler2D iChannel0;
uniform vec2 iResolution;
uniform float iGlobalTime;
uniform float poppin;
uniform vec3 cameraPosition;
uniform float speed;
uniform float rotato;

#define MAX_STEPS 200.
#define MAX_DISTANCE 1.2
#define epsilon 0.00001
#define infinite 1e7
#define lightSize 2.2
#define powLight 128.
#define lightColor vec3(0.9,0.6,0.4)
vec3 lightSource = vec3(0.0,32.0,-6.0);

mat3 rotationMatrix(vec3 axis, float angle) {
    axis = normalize(axis);
    float s = sin(angle);
    float c = cos(angle);
    float oc = 1.0 - c;
    
    return mat3(oc * axis.x * axis.x + c,           oc * axis.x * axis.y - axis.z * s,  oc * axis.z * axis.x + axis.y * s,
                oc * axis.x * axis.y + axis.z * s,  oc * axis.y * axis.y + c,           oc * axis.y * axis.z - axis.x * s,
                oc * axis.z * axis.x - axis.y * s,  oc * axis.y * axis.z + axis.x * s,  oc * axis.z * axis.z + c);
}
float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}
float rand(float co){
    return rand(vec2(co));
}
float smin( float a, float b, float k ) {
    float res = exp( -k*a ) + exp( -k*b );
    return -log( res )/k;
}
float sdSphere( vec3 p, float s ){
  return length(p)-s;
}
float udRoundBox( vec3 p, vec3 b, float r ) {
  return length(max(abs(p)-b,0.0))-r;
}
float udBox( vec3 p, vec3 b )
{
  return length(max(abs(p)-b,0.0));
}
float sdBox( vec3 p, vec3 b )
{
  vec3 d = abs(p) - b;
  return min(max(d.x,max(d.y,d.z)),0.0) +
         length(max(d,0.0));
}
float sdHexPrism( vec3 p, vec2 h )
{
    vec3 q = abs(p);
    q=q.zxy;
    return max(q.z-h.y,max((q.x*0.866025+q.y*0.5),q.y)-h.x);
}

float length2( vec2 p ) {
    return sqrt( p.x*p.x + p.y*p.y );
}

float length6( vec2 p ) {
    p = p*p*p; p = p*p;
    return pow( p.x + p.y, 1.0/6.0 );
}

float length8( vec2 p ) {
    p = p*p; p = p*p; p = p*p;
    return pow( p.x + p.y, 1.0/8.0 );
}
float sdTorus88( vec3 p, vec2 t )
{
  vec2 q = vec2(length8(p.xz)-t.x,p.y);
  return length8(q)-t.y;
}
float sdTorus82( vec3 p, vec2 t )
{
  vec2 q = vec2(length2(p.xz)-t.x,p.y);
  return length8(q)-t.y;
}
float sdCappedCylinder( vec3 p, vec2 h )
{
  vec2 d = abs(vec2(length(p.xz),p.y)) - h;
  return min(max(d.x,d.y),0.0) + length(max(d,0.0));
}
float sdCapsule( vec3 p, vec3 a, vec3 b, float r )
{
    vec3 pa = p - a, ba = b - a;
    float h = clamp( dot(pa,ba)/dot(ba,ba), 0.0, 1.0 );
    return length( pa - ba*h ) - r;
}
mat3 rotY(in float a)
{
    return mat3( cos(a), 0.0, sin(a),
                 0.0,    1.0, 0.0,
                -sin(a), 0.0, cos(a)
                );
}

mat2 rotate(float Angle)
{
    mat2 rotation = mat2(
        vec2( cos(Angle),  sin(Angle)),
        vec2(-sin(Angle),  cos(Angle))
    );
    return rotation;
}
float getColorReflection( vec3 position, out vec3 color, out float reflectiveValue) {
    float TIME=iGlobalTime*4.*speed;
    vec3 _position = position;
    _position.y -= sin(_position.z)/3.;
    vec3 _position2 = _position;
    float dist = 1e5;
    float dist2 = 1e5;
    
    vec3 _position3=_position2;
    _position3.z=mod(_position3.z+TIME/4.,1.0)-0.5;
    
    dist = min(dist, sdBox(_position3-vec3(0.,0.,0.55),vec3(0.8,1.7,0.4) ) );
    dist = max(dist, -sdBox(_position3-vec3(0.,0.,0.55),vec3(0.78,0.2,0.5) ) );
    
    _position3.x=abs(_position3.x);
    dist = min(dist, sdHexPrism(_position3-vec3(0.5,-0.2,0.0),vec2(0.02-_position.y/2.+sin(_position2.z*4.+TIME*2.1)/12.,0.6) ));
    
    float a=(_position2.z*4.+TIME)+(_position2.x*2.);
    color = vec3(.15,.15,.25)+vec3(floor(mod(a*2.,2.))+.01)*vec3(1.,0.3,0.2)+vec3(floor(mod(a*1.4,2.))+.01)*vec3(0.0,0.8,0.8);
    color *=1.2;
    dist = min(dist, sdBox(_position-vec3(0.0,-8.5,0.0),vec3(6.,8.2+abs(_position.x)/4.+sin(TIME+rand(floor((_position.xz+vec2(0.0,TIME/4.))*9.))*3.14159*2.0+TIME/3.)/256.,11.)));
        
    reflectiveValue = 0.04;
    
    return dist;
}
float getDistance( in vec3 position) {
    float TIME=iGlobalTime*4.*speed;
    vec3 _position = position;
    _position.y -= sin(_position.z)/3.;
    vec3 _position2 = _position;
    float dist = 1e5;
    float dist2 = 1e5;
    
    vec3 _position3=_position2;
    _position3.z=mod(_position3.z+TIME/4.,1.0)-0.5;
    
    dist = min(dist, sdBox(_position3-vec3(0.,0.,0.55),vec3(0.8,0.26,0.4) ) );
    dist = max(dist, -sdBox(_position3-vec3(0.,0.,0.55),vec3(0.78,0.2,0.5) ) );
    
    _position3.x=abs(_position3.x);
    dist = min(dist, sdHexPrism(_position3-vec3(0.5,-0.2,0.0),vec2(0.02-_position.y/2.+sin(_position2.z*4.+TIME*2.1)/12.,0.6) ));
    
    dist = min(dist, sdBox(_position-vec3(0.0,-8.5,0.0),vec3(6.,8.2+abs(_position.x)/4.+sin(TIME/4.+rand(floor((_position.xz+vec2(0.0,TIME/4.))*9.))*3.14159*2.0+TIME/3.)/256.,11.)));
        
    
    return dist;
}
vec3 getSurfaceNormal(vec3 position) {
    float e=epsilon;
    vec3 normalVector = vec3(
                            getDistance(position+vec3( e,  0., 0.)) - getDistance(position+vec3(  -e,   0.,  0.)) ,
                            getDistance(position+vec3( 0., e,  0.)) - getDistance(position+vec3(   0., -e,   0.)) ,
                            getDistance(position+vec3( 0., 0., e)) - getDistance(position+vec3(    0.,  0., -e)) );
    normalVector = normalize(normalVector);
    return normalVector;
}
float traceToLight(vec3 rayPosition, vec3 normalVector, vec3 lightSource, float raylightdist){

    vec3 ro = rayPosition;
    vec3 rd = normalize(lightSource - rayPosition);
    float t = 0.4;
    float k = distance(lightSource, rayPosition)/4.;
    float res = 1.0;
    for( int i=0; i<11; i++ )
    {
        float h = getDistance(ro + rd*t);
        h = max( h, 0.0 );
        res = min( res, k*h/t );
        t += clamp( h, 0.001, 0.9 );
        if( h<0.01) break;
    }
    return clamp(res,0.07,9.0);
}
float fastTraceToLight(vec3 rayPosition, vec3 normalVector, vec3 lightSource, float raylightdist){

    vec3 ro = rayPosition;
    vec3 rd = normalize(lightSource - rayPosition);
    float t = 0.2;
    float k = distance(lightSource, rayPosition)/4.;
    float res = 1.0;
    for( int i=0; i<11; i++ )
    {
        float h = getDistance(ro + rd*t);
        h = max( h, 0.0 );
        res = min( res, k*h/t );
        t += clamp( h, 0.001, 0.9 );
        if( h<0.01) break;
    }
    return clamp(res,0.07,9.0);
}
float getSurfaceColor( vec3 curPosition, vec3 normalVector, vec3 lightSource, vec3 lightDirection) {
    float intensity = lightSize * pow( 0.001 + max(0.0, dot( lightDirection, normalVector)),  powLight);
    intensity = lightSize * pow( intensity / distance( curPosition, lightSource),  powLight);
    intensity += pow (max( dot( normalize( lightSource - curPosition), normalVector), 0.0), powLight);
    return intensity;
}
vec3 giTrace(vec3 rayOrigin, vec3 rayDirection) {
    vec3 endColorResult = vec3(0.0);
    vec3 origRayDirection=rayDirection;
    vec3 prevPosition = rayOrigin;
    vec3 curPosition = rayOrigin;
    vec3 normalVector;
    vec4 result=vec4( 0., 0., 0., 0.);
    vec3 finalLight = vec3(0.0);
    float dist = 0.0;
    int hit = 0;
    vec3 rna;
    #define maxSamples 2.
        for(float i =1.; i < maxSamples+1.; i++) {
                rna=rayDirection* 0.01 * i;
                vec3 curPosition = 
                    rayOrigin + normalize(rayDirection + rna );
                vec3 color = vec3( 0.0);
                float reflection = 0.0;
                getColorReflection( curPosition, color, reflection);
                normalVector = getSurfaceNormal( curPosition);
                
                float raylightdist = distance( curPosition, lightSource);
                float light = traceToLight( curPosition, normalVector, lightSource, raylightdist);
                vec3 lightDirection = normalize( lightSource - curPosition);
                lightDirection = normalize(lightDirection);
                float directLight = dot(normalVector, lightDirection);
                finalLight += light*max(lightSize*directLight,0.01);
                endColorResult +=  color * finalLight;
        }
    
    return endColorResult / maxSamples;
}
float circle(vec2 coord, vec2 pos, float size){
    return min(floor(distance(coord,pos)-size),0.);
}
float roundBox(vec2 coord, vec2 pos, vec2 b ){
  return length(max(abs(coord-pos)-b,0.0));
}
vec3 AO(vec3 rayOrigin, vec3 rayDirection) {
    float AO = 0.0;
    for(float i=1.0; i<6.0; i+=2.) {
        vec3 position =  rayOrigin + i * 0.04 * rayDirection;
        AO += getDistance( position);
    }
    return vec3(AO)*2.;
}
vec4 march(vec3 rayOrigin, vec3 rayDirection) {
    vec3 endColorResult = vec3(0.0);
    vec3 origRayDirection=rayDirection;
    vec3 prevPosition = rayOrigin;
    vec3 curPosition = rayOrigin;
    vec3 normalVector;
    vec4 result=vec4( 0., 0., 0., 0.);
    vec3 finalLight = vec3(0.0);
    float dist = 0.0;
    float storeColorStrength = 1.0;
    int hit = 0;
    float collisions = 0.;
    float distanceOfCollision = 1111110.;
        for(float i = 0.; i < MAX_STEPS; i++) {
            float stepable = getDistance( curPosition);
            dist += stepable;
            curPosition = prevPosition + dist * rayDirection;
           /*too far from begining point, call it an end*/
            if( abs( stepable) < epsilon + i*0.0001) {
                //if( reflection == 0.) {
                //    distanceOfCollision = distance(rayOrigin, curPosition);
                //}
                vec3 color = vec3( 0.0);
                float R = 0.0;
                getColorReflection( curPosition, color, R);
                normalVector = getSurfaceNormal( curPosition);
                
                float raylightdist = distance( curPosition, lightSource);
                float light = traceToLight( curPosition, normalVector, lightSource, raylightdist);
                vec3 lightDirection = normalize( lightSource - curPosition);
                lightDirection = normalize(lightDirection);
                float directLight = dot(normalVector, lightDirection);
                finalLight += light * max( lightSize * directLight,0.01);
                float surfaceBrightness = length(finalLight);
                vec3 lightColorInside = color + finalLight * lightColor;
               
                vec3 surfaceFinalColor = color * lightColor * storeColorStrength * finalLight;
                
                float surfLight = getSurfaceColor(curPosition, normalVector, lightSource, lightDirection);
                float surfLightBackSide = 0.3333;
                
                float scatterDeathDepth = 0.3333;
                vec3 backSide = vec3(0.0);

                endColorResult += storeColorStrength * pow(max(dot(normalize(lightSource-curPosition),normalVector),0.0),powLight);
                endColorResult += storeColorStrength * (backSide + surfaceFinalColor) / (1.0+surfLight+surfLightBackSide);
                endColorResult += storeColorStrength * (backSide + surfaceFinalColor) * pow(lightColor,vec3(powLight))/ (1.0+surfLight+surfLightBackSide+scatterDeathDepth+pow(distance(curPosition,lightSource),2.) ) ;
                endColorResult += storeColorStrength * (backSide + surfaceFinalColor) * ( (surfLight+surfLightBackSide) ) * R * surfaceFinalColor ;
               endColorResult += 0.2*storeColorStrength * (backSide + surfaceFinalColor) * giTrace(curPosition, normalVector) ;
               
                vec3 AOresult = log(AO(curPosition, normalVector)) ;
                endColorResult += storeColorStrength * AOresult /(1.0+(surfLight+surfLightBackSide));
                
                
                
                hit = 1;
                break;
            }
            /*too far from begining  point, call it an end*/
            if( length( curPosition*vec3(1.,1.2,.3)) > MAX_DISTANCE) {
                break;
            }
    }
    
    
    
    vec3 lightDir = (lightSource-rayOrigin);
    lightDir = normalize(lightDir);
    float directLight = dot(rayDirection, lightDir);
    vec3 backdrop=min(max( pow(directLight,40.0) * vec3(1.8,1.1,.9) * 0.6, 0.01),1.);
    backdrop+=min(max( pow(directLight,1.5) * vec3(0.8,0.9,1.0) * 1.6, 0.01),1.);
    backdrop+=(min(max( pow(directLight,80.0) * 1.6, 0.01),1.)*1.1);
    backdrop.r+=iGlobalTime/120.;
    vec3 farShoot=rayOrigin+origRayDirection*10.;
    backdrop*=min(max(farShoot.y+0.5,0.),1.);
    if(hit==0 ) endColorResult += backdrop ;
    endColorResult = max(endColorResult,vec3(0.0));
    return vec4(endColorResult,1.);
}
float resolveRaySphereIntersection(vec3 b, vec3 c, vec3 dir){
    vec3 OC=b-c;
    float P=dot(OC,dir);
    if(P<0.) return 1111.0;
    float d=sqrt(pow(length(OC),2.0)-pow(P,2.0));
    return d;
}
float trace(vec3 rayOrigin, vec3 rayDirection) {
    return resolveRaySphereIntersection(vec3(0.0,3.0,2.0), rayOrigin, rayDirection)*3.0;
}
float hash(float c){return fract(sin(dot(c,12.9898))*43758.5453);}

vec4 render( vec2 uv ) {  
     float aspect = iResolution.x / iResolution.y;
        vec3 cameraPosition = vec3( 0.,-0.4, 1.1);
        vec3 direction = normalize( vec3(.5 * uv * vec2( aspect, 1.0), 1. ) );
        direction *= rotationMatrix(vec3(0.0,0.0,1.0),sin(iGlobalTime)/5.);
        direction *= rotationMatrix(vec3(1.0,0.0,0.0),-0.2+sin(iGlobalTime*1.242424242)/8.);
        cameraPosition *= rotY(-3.14159*2.0*180./360.);
        direction *= rotY( 3.14159*2.0*180./360.);
        direction.z *= -1.0;
    
        vec4 color = march( cameraPosition, direction);

        return color;
        
}


//Reinhard based tone mapping
vec3 tone(vec3 color, float gamma)
{
    float white = 2.;
    float luma = dot(color, vec3(0.2126, 0.7152, 0.0722));
    float toneMappedLuma = luma * (1. + luma / (white*white)) / (1. + luma);
    color *= toneMappedLuma / luma;
    color = pow(color, vec3(1. / gamma));
    return color;
}

void main( ) {  
     vec2 p = gl_FragCoord.xy / iResolution.xy;
     vec2 uv = 2.0 * gl_FragCoord.xy / iResolution.xy - 1.0;
     float aspect = iResolution.x / iResolution.y;
        vec4 C=render( uv );
        C.rgb = C.rgb;
        C=min(max(C,vec4(0.)),vec4(1.));
        gl_FragColor =  C+(speed-1.)*3.0;
}
    