using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;

namespace Framefield.Core.ID6c152563_96d6_4502_8285_92f557776a00
{
    public class Class_ValueListGate : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            ValueIfFalse = 0,
            ValueIfTrue = 1,
            Values = 2,
            i = 3
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var ValueIfFalse = inputs[(int)InputId.ValueIfFalse].Eval(context).Value;
            var ValueIfTrue = inputs[(int)InputId.ValueIfTrue].Eval(context).Value;
            var Values = inputs[(int)InputId.Values].Eval(context).Text;
            var i = inputs[(int)InputId.i].Eval(context).Value;
            //<<< _params
            
            // create array
            var ValueChars = Values.Split(',');
            var length = ValueChars.Length;
            
            // default
            context.Value = ValueIfFalse;
            
            // check i against value-array
            for (var pos = 0; pos < length; pos++)
            {
                var val = -1;

                if ( Int32.TryParse(ValueChars[pos], out val) )
                {
                    if( i == val )
                    {
                        // override default
                        context.Value = ValueIfTrue;
                    }
                }
                
            }
            
            return context;            
        }
    }
}