//==========================================================
//
//	メインルーチン
//
//==========================================================

//#define MIN_WIDTH 800

//#define MIN_HEIGHT 600

function toggleFullScreen() {
  if (!document.fullscreenElement &&    // alternative standard method
      !document.mozFullScreenElement && !document.webkitFullscreenElement && !document.msFullscreenElement ) {  // current working methods
    if (document.documentElement.requestFullscreen) {
      document.documentElement.requestFullscreen();
    } else if (document.documentElement.msRequestFullscreen) {
      document.documentElement.msRequestFullscreen();
    } else if (document.documentElement.mozRequestFullScreen) {
      document.documentElement.mozRequestFullScreen();
    } else if (document.documentElement.webkitRequestFullscreen) {
      document.documentElement.webkitRequestFullscreen();
    }
  } else {
    if (document.exitFullscreen) {
      document.exitFullscreen();
    } else if (document.msExitFullscreen) {
      document.msExitFullscreen();
    } else if (document.mozCancelFullScreen) {
      document.mozCancelFullScreen();
    } else if (document.webkitExitFullscreen) {
      document.webkitExitFullscreen();
    }
  }
}



function BufferLoader(context, urlList, callback) {
  this.context = context;
  this.urlList = urlList;
  this.onload = callback;
  this.bufferList = new Array();
  this.loadCount = 0;
}

BufferLoader.prototype.loadBuffer = function(url, index) {
  // Load buffer asynchronously
  var request = new XMLHttpRequest();
 
  request.responseType = "arraybuffer";

  var loader = this;

  request.onload = function(e) {
    // Asynchronously decode the audio file data in request.response
    loader.context.decodeAudioData(
      request.response,
      function(buffer) {
        if (!buffer) {
          alert('error decoding file data: ' + url);
          return;
        }
        loader.bufferList[index] = buffer;
        if (++loader.loadCount == loader.urlList.length)
          loader.onload(loader.bufferList);
      },
      function(error) {
        console.error('decodeAudioData error', error);
      }
    );
  }

 request.onerror = function(e) {
   alert(request.statusText  );
  }

   request.open("GET", url, true);
  request.send();
}

BufferLoader.prototype.load = function() {
  for (var i = 0; i < this.urlList.length; ++i)
  this.loadBuffer(this.urlList[i], i);
}



var context;
var bufferLoader;
var gMusicTime = 0;


function init() {
  // Fix up prefixing
  window.AudioContext = window.AudioContext || window.webkitAudioContext;
  context = new AudioContext();

  bufferLoader = new BufferLoader(
    context,
    [
      "sound/Demo2016Short.wav",
    ],
    finishedLoading
    );

  bufferLoader.load();
}
var db = 0.0;
function finishedLoading(bufferList) {

  // Create two sources and play them both together.
  var source1 = context.createBufferSource();
//  var source2 = context.createBufferSource();
  source1.buffer = bufferList[0];
//  source2.buffer = bufferList[1];


// Create the instance of AnalyserNode
var analyser = context.createAnalyser();
// Create the instance of OscillatorNode
var oscillator = context.createOscillator();
// for legacy browsers
oscillator.start = oscillator.start || oscillator.noteOn;
oscillator.stop  = oscillator.stop  || oscillator.noteOff;
// OscillatorNode (Input) -> AnalyserNode (Visualization) -> AudioDestinationNode (Output)

//  source2.connect(context.destination);

source1.connect(analyser);
oscillator.connect(analyser);
analyser.connect(context.destination);
source1.start(0);

var cnt = 0;
analyser.fftSize = 2048;  // The default value
var intervalid = window.setInterval(function() {
    // Get data for drawing sound wave
    //var times = new Uint8Array(analyser.fftSize);
    //analyser.getByteTimeDomainData(times);
    var spectrums = new Float32Array(analyser.frequencyBinCount);
    analyser.getFloatFrequencyData(spectrums);
 
	var ddb = 0;
	var loop = spectrums.length/100;//1024
    for (var i =0, len = loop; i < len; i++) {
         ddb += (spectrums[i])/loop/50;  // 0 - 1
	}
	//console.log( "[" + cnt + "]" + spectrums.length );
    cnt++;
	ddb =2.+ddb;
	//console.log( "[" + cnt + "]" + ddb );
	if(cnt>5000) ddb_thres=0.95;
	else if  (cnt<500 ) ddb_thres=0.7;
	else ddb_thres=1.15;

	//console.log( "[" + cnt + "]" + ddb + "::::" +ddb_thres);

	if(ddb <ddb_thres) ddb=0.0 ;
	if (ddb>db) db=ddb;
	else db = db*0.95;

	gMusicTime += 10;
	
}, 10);


//  source2.start(0);
}


function main( cScenes )
{
	init();
    
	//document.getElementById("audiotag1").play();

    document.addEventListener("MSFullscreenError", function (evt) {
	  console.error("full screen error has occured " + evt.target);
	}, true);

	window.onresize = function() 
	{
	    renderer.setSize(window.innerWidth, window.innerHeight);
		
	    for( var i=0 ; i < cScenes.length ; i++ )
		{
			cScenes[i].camera.aspect = window.innerWidth / window.innerHeight;
			cScenes[i].camera.updateProjectionMatrix();
		}
	}

	 document.addEventListener("keydown", function(e) {
	  if (e.keyCode == 13) {
	    toggleFullScreen();	    
	  }
	}, false);

	toggleFullScreen();	   


    // レンダラの初期化
    var renderer = new THREE.WebGLRenderer({ antialias:true });
	renderer.setPixelRatio( window.devicePixelRatio );
    renderer.setSize(window.innerWidth, window.innerHeight);
    renderer.setClearColor(0x000000);
    document.body.appendChild(renderer.domElement);

	// レンダリングが必要な初期化
    for( var i=0 ; i < cScenes.length ; i++ )
	{
		if( 'enter' in cScenes[i] )
		{
			cScenes[i].enter( renderer , cScenes[i].scene , cScenes[i].camera );
		}
	}

	// シーン取得
    var currentIx = -1;
    var current = null;
    var localBaseTime = gMusicTime;	
   
      function render() 
      {
        if( currentIx == -1 || ( gMusicTime - localBaseTime ) / 1000 >= current.duration )
        {
			if( currentIx < cScenes.length - 1 )
			{
				currentIx++;
             	current = cScenes[currentIx];
                localBaseTime = gMusicTime;
			}
        }

        requestAnimationFrame(render);
		

		time = ( gMusicTime - localBaseTime );

		//console.log( "Music:" + gMusicTime + "  Local:" + time + "  Scene:" + currentIx );


		if( current.material.uniforms != null){
			if(current.material.uniforms.time != null )
			{
		        current.material.uniforms.time.value = time / 1000;
			}
			if(current.material.uniforms.sound != null )
			{
		        current.material.uniforms.sound.value = db;
			}
		}

		if( 'setSpectrum' in current )
		{
			current.setSpectrum( db );
		}

		if( 'calc' in current )
		{
			current.calc( current.scene, 
						  current.camera , 
						  time / 1000 );
		}

		if( 'render' in current )
		{
			current.render( renderer , current.scene, current.camera , gMusicTime  / 1000);

		}
		else
		{
			renderer.render( current.scene, current.camera);
		}
      };
      render();


}
