varying vec2 vTexCoord;
uniform sampler2D srcTex;

uniform vec2 texStep;
uniform float edgeFactor;

void main()
{
	vec3 colorMain = texture2D(srcTex, vTexCoord).rgb;
	vec3 color1 = texture2D(srcTex, vTexCoord-vec2(1,0)*texStep).rgb;
	vec3 color2 = texture2D(srcTex, vTexCoord-vec2(-1,0)*texStep).rgb;
	vec3 color3 = texture2D(srcTex, vTexCoord-vec2(0,1)*texStep).rgb;
	vec3 color4 = texture2D(srcTex, vTexCoord-vec2(0,-1)*texStep).rgb;

	vec3 grad1 = (color2 - color1);
	vec3 grad2 = (color4 - color3);
	vec3 avg = (grad1 + grad2) * 0.5;
	float l = length(avg);

	vec3 col = mix(colorMain, colorMain * l * 4, edgeFactor);
	col *= max(edgeFactor, 1.0);

	gl_FragColor = vec4(col, 1.0);
}
