"use strict";
function shuffle(array) {
	var currentIndex = array.length,temporaryValue,randomIndex;
	// http://stackoverflow.com/questions/2450954/how-to-randomize-shuffle-a-javascript-array
	// While there remain elements to shuffle...
	while (0 !== currentIndex) {

		// Pick a remaining element...
		randomIndex = Math.floor(Math.random() * currentIndex);
		currentIndex -= 1;

		// And swap it with the current element.
		temporaryValue = array[currentIndex];
		array[currentIndex] = array[randomIndex];
		array[randomIndex] = temporaryValue;
	}

	return array;
}



// Copyright 2013, 2015 David Gross
// Not for modification or distribution of any kind without explicit written permission.

// This should be rewritten into a class of it's own. --2015
// lolglobals

var gen_siz = 128;
var gen_sizp = 1024 / gen_siz;
var gen_tiles;

function gen_settile(x,y,v){
	if(x<0 || y<0 || x>=gen_siz || y>=gen_siz) return;
	if(gen_gettile(x,y)==2)return;
	gen_tiles[x+y*gen_siz] = v;
}
function gen_gettile(x,y){
	if(x<0 || y<0 || x>=gen_siz || y>=gen_siz) return;
	return gen_tiles[x+y*gen_siz];
}




var gen_rooms = 0;
var gen_rsiz = 12; // gen_room push gen_size in all directions.
//x, y, iterations, branch attempts
function gen_room(x, y, it, xo, yo){
	// We'll push in all directions
	var ls = (Math.random() * gen_rsiz) | 0 + 1;
	var rs = (Math.random() * gen_rsiz) | 0 + 1;
	var us = (Math.random() * gen_rsiz) | 0 + 1;
	var ds = (Math.random() * gen_rsiz) | 0 + 1;
	if(gen_rooms == 0){ls = 4; rs = 4; us = 4; ds = 4;}
	var a;
	for(a=1; a<ls; a+=1) if(gen_gettile(x-a, y)){ls = a-1; break;}
	for(a=1; a<rs; a+=1) if(gen_gettile(x+a, y)){rs = a-1; break;}
	for(a=1; a<us; a+=1) if(gen_gettile(x, y-a)){us = a-1; break;}
	for(a=1; a<ds; a+=1) if(gen_gettile(x, y+a)){ds = a-1; break;}
	
	var ret = 0;
	if(ls == 0) ret++;
	if(rs == 0) ret++;
	if(us == 0) ret++;
	if(ds == 0) ret++;
	if(ret > 1) return;
	
	var xx, yy;
	for(a=0; a<2; a+=1){
		for(yy = -(us+a); yy<=(ds+a); yy+=1)
		for(xx = -(ls+a); xx<=(rs+a); xx+=1){
			if(!gen_gettile(x + xx, y + yy)) gen_settile(x + xx, y + yy, 1 + a * 2);
		}
	}
	
	gen_rooms++;
	it--;
	
	if(xo || yo) gen_settile(x + xo, y + yo, 2);
	if(it == 0) return;
	
	var ar = [0,1,2,3];
	ar = shuffle(ar)
	//Lets randomize the door order, so things don't appear to always branch off in one side
	for(a=0; a<ar.length; a+=1){
		//left
		if(ar[a] == 0 && !((xo == -1) && (yo == 0))){
			xx = (x - ls) - 1;
			yy = (y - us) + ((Math.random() * (us + ds)) | 0);
			gen_room(xx - 1, yy, it, 1, 0);
		}
		//right
		if(ar[a] == 1 && !((xo == 1) && (yo == 0))){
			xx = (x + rs) + 1;
			yy = (y - us) + ((Math.random() * (us + ds)) | 0);
			gen_room(xx + 1, yy, it, -1, 0);
		}
		//up
		if(ar[a] == 2 && !((xo == 0) && (yo == -1))){
			xx = (x - ls) + ((Math.random() * (ls + rs)) | 0);
			yy = (y - us) - 1;
			gen_room(xx, yy - 1, it, 0, 1);
		}
		//down
		if(ar[a] == 3 && !((xo == 0) && (yo == 1))){
			xx = (x - ls) + ((Math.random() * (ls + rs)) | 0);
			yy = (y + ds) + 1;
			gen_room(xx, yy + 1, it, 0, -1);
		}
	}
}


function generate_tiles(size, roomsize, iterations){
	gen_rsiz = roomsize;
	gen_siz = size;
	
	gen_tiles = new Array(gen_siz*gen_siz);
	{for(var a=0; a<gen_tiles.length; a+=1) gen_tiles[a] = 0;}
	
	//canvas=document.getElementById("can");
	//context=canvas.getContext("2d");
	
	//document.onkeydown=onpress;
	//document.onkeyup=onrelease;
	gen_rooms = 0;
	gen_room(gen_siz/2|0, gen_siz/2|0, iterations, 0, 0);
	gen_settile(gen_siz/2|0, gen_siz/2|0, 4);
	
	return gen_tiles;
}
