///////////////////////////////////////////////
//
//  Copyright 2012 David Gross
//  Not for distribution of modification of any kind without explicit written permission!
//
//  Class type thing for some simple windows inside of a canvas
//

var windows = new Array();
var window_depth = 0; // Higher means on top.
var window_active = -1; // For moving windows/whatever
var window_dragging = 0; // If-true, we forwards mouse inputs to the window thing, instead of to the game
var window_img;
var window_order = new Array();
function window_push(index){
	var a;
	for(a in window_order) if(window_order[a] == index){
		window_order.splice(a, 1);
		window_order.push(index);
		return;
	}
	window_order.push(index);
}

function window_detect_click(x, y){
	var d = -1;
	var w = -1;
	var a;
	for(a in windows){
		if(windows[a].depth > d){
			if(windows[a].visible)
			if(x>=windows[a].x && x <= (windows[a].w + windows[a].x) && y >= windows[a].y && y <= (windows[a].h + windows[a].y)){
				d = windows[a].depth;
				w = a;
			}
		}
	}
	//if(w!=-1)alert("Detected");
	return w;
}

function mm_event(x, y, w, h, func, userdata){
	this.x = x;
	this.y = y;
	this.w = w;
	this.h = h;
	this.func = func;
	this.userdata = userdata;
}
mm_event.prototype.click = function(x, y){
	if(x >= this.x && (x <= (this.x + this.w)) && y >= this.y && (y <= (this.y + this.h))){
		if(this.func) this.func(this.userdata);
		return 1;
	}
	return 0;
}
function mm_window(w,h,name){
	//windows.push(this);
	//console.log("new window: "+name);
	this.index = windows.length;
	window_push(this.index);
	this.w = w;
	this.h = h;
	this.minw = 64;
	this.minh = 64;
	this.maxw = 768;
	this.maxh = 640;
	this.name = name;
	this.id = name; // ID could be used in the future, for things like private messages between users and stuff.
	this.visible = 1;
	this.depth = (window_depth++);
	this.canvas = document.createElement("canvas");
	this.context = this.canvas.getContext("2d");
	this.canvas.width = w;
	this.canvas.height = h;
	this.canclose = 0;
	
	this.font = "10pt monospace";
	this.fill = "#fff";
	this.context.font = this.font;
	this.context.fillStyle = this.fill;
	this.x = 0;
	this.y = 0;
	this.canresize = 1;
	this.canmove = 1;
	this.resizing = 0;// If resizing or not.
	
	this.usescrollbars = 1;
	this.scrollbartick = .1; //10%
	this.scrollbarloc = 0;//Math.random();//0; //top
	this.scrolldrag = 0;
	if(this.index == 2)this.scrollbarloc = 1.0;
	
	this.events = new Array();
	this.mouseover = null;
	this.mouseout = null;
	this.ismouseover = 0;
	
	
	this.redrawfunc = null; // Callback to fill the window with content. It sends the window index along with it.
	this.onclose = null; // Callback for when the close is called.
	
	this.grad = this.context.createLinearGradient(0, 0, 0, 384);
	this.grad.addColorStop(.0, '#ddd');
	this.grad.addColorStop(0.03125, '#fff');
	this.grad.addColorStop(0.03725, 'rgba(160,160,160,.87)');
	this.grad.addColorStop(.1, 'rgba(120,120,120,.87)');
	this.grad.addColorStop(.2, 'rgba(80,80,80,.87)');
	this.grad.addColorStop(.5, 'rgba(50,50,50,.87)');
	this.grad.addColorStop(1., 'rgba(0,0,0,.87)');
	this.context.fillStyle = this.grad;
	this.overlaydrawn = 0;
	this.useoverlay = 1;
	this.clear();
}
mm_window.prototype.clearevents = function(){
	this.events.splice(0, this.events.length);
}
mm_window.prototype.addevent = function(x, y, w, h, func, userdata){
	if(x + w < 0 && x > this.w && y + h < 0 && y > this.h) return; //No sense adding something we can't click!
	this.events.push(new mm_event(x, y, w, h, func, userdata));
}
mm_window.prototype.drawdebug = function(){
	var a;
	var b = 0;
	for(a in this.events){
		if(b == 0) this.context.fillStyle = "rgba(255,0,0,.5)";
		if(b == 1) this.context.fillStyle = "rgba(0,255,0,.5)";
		if(b == 2) this.context.fillStyle = "rgba(0,0,255,.5)";
		b = (b + 1) % 3;
		this.context.fillRect(this.events[a].x, this.events[a].y, this.events[a].w, this.events[a].h);
	}
	//this.redrawfunc(this.index);
}
mm_window.prototype.center = function(){
	this.x = Math.floor((canvas.width / 2) - (this.w / 2));
	this.y = Math.floor((canvas.height / 2) - (this.h / 2));
}
mm_window.prototype.unclick = function(x,y){
	this.resizing = 0;
	this.scrolldrag = 0;
}
mm_window.prototype.drawsprite = function(x,y,i,sx,sy,w,h){
	if(x + w < 0 && x > this.w && y + h < 0 && y > this.h) return; //No sense in drawing something we can't see!
	this.context.drawImage(imgs[i], sx, sy, w, h, Math.floor(x), Math.floor(y), w, h);
}
mm_window.prototype.drawtext = function(x,y,t,c){
	this.context.font = this.font;
	this.context.fillStyle = "#000";
	this.context.fillText(t, Math.floor(x + 2), Math.floor(y + 2));
	this.context.fillStyle = c;
	this.context.fillText(t,Math.floor(x), Math.floor(y));
}
mm_window.prototype.click = function(x,y){
	this.depth=(window_depth++);
	window_push(this.index);
	x -= this.x; y -= this.y;
	//Check to see if within window top.
	if(y < 16){
		if(this.canclose){
			if(x >= this.w - 16){
				this.onclose(this.index);
				return;
			}
		}
		if(this.canmove){
			window_dragging = 1;
			return;
		}
	}
	if(this.canresize){
		if(x > this.w - 16 && y > this.h - 16){
			window_dragging = 1;
			this.resizing = 1;
			return;
		}
	}
	if(this.usescrollbars && x > this.w - 16){
		if(y <= 32) this.scrollbarloc -= this.scrollbartick;
		if(y >= this.h - 32) this.scrollbarloc += this.scrollbartick;
		if(y > 32 && y < this.h - 32){
			window_dragging = 1;
			var s = this.h - 64 - 64;
			var t = s * this.scrollbarloc;
			if(y - 64 > t && y - 64 + 64 < t){}
			else{this.scrollbarloc = (y - 64) / s;}
			this.scrolldrag = 1;
		}
		this.scrollbarloc = Math.max(0.0, Math.min(this.scrollbarloc, 1.0));
		this.clear();
		return;
	}
	//Check to see if hit buttons

	//Check to see if hit elements
	var a;
	for(a in this.events){
		if(this.events[a].click(x, y)){
			return;
		}
	}
	//Else just drag the window
	window_dragging = 1;
}
mm_window.prototype.clear = function(){
	this.context.fillStyle = this.grad;
	this.context.clearRect(0, 0, this.w, this.h);
	if(this.useoverlay) this.context.fillRect(0, 0, this.w, this.h);
	this.overlaydrawn = 0;
	if(null != this.redrawfunc) this.redrawfunc(this.index);
}
mm_window.prototype.resize = function(w,h){
	this.w += w; this.h += h;
	this.w = this.w < this.minw ? this.minw : this.w > this.maxw ? this.maxw : this.w;
	this.h = this.h < this.minh ? this.minh : this.h > this.maxh ? this.maxh : this.h;
	this.canvas.width = this.w;
	this.canvas.height = this.h;
	this.clear();
}
mm_window.prototype.move = function(x,y){
	if(this.resizing){
		this.resize(x, y);
	}else if(this.scrolldrag){
		var s = this.h - 64 - 64;
		this.scrollbarloc += y / s;
		this.scrollbarloc = Math.max(0.0, Math.min(this.scrollbarloc, 1.0));
		this.clear();
	}else if(this.canmove){
		this.x += x;
		this.y += y;
	}
}
mm_window.prototype.scrollbars = function(){
	if(!this.usescrollbars) return;
	this.context.drawImage(window_img,0,0,16,16,this.w-16,16,16,16);
	this.context.drawImage(window_img,0,16,16,16,this.w-16,this.h-32,16,16);
	this.context.drawImage(window_img,0,32,16,16,this.w-16,32,16,this.h-64);
	var s = this.h - 64 - 64;
	if(s < 0) return;
	s *= this.scrollbarloc;
	this.context.drawImage(window_img,0,48,16,64,this.w-16,32+Math.floor(s),16,64);
	
	//this.context.drawImage(window_img,0,0,16,16,24,24,16,16);
	//destcontext.drawImage(srcimage, sourcex, sourcey, width, height, destx, desty, destwidth, destheight);
}
mm_window.prototype.scroll = function(d){
	this.scrollbarloc+=-d*this.scrollbartick;
	this.scrollbarloc=Math.max(0.0,Math.min(this.scrollbarloc,1.0));
	this.clear();
}
mm_window.prototype.overlay = function(){
	this.overlaydrawn=1;
	if(!this.useoverlay)return;
	
	this.context.drawImage(window_img,0,128,16,16,0,0,this.w,16);
	if(this.canresize)this.context.drawImage(window_img,0,112,16,16,this.w-16,this.h-16,16,16);
	if(this.canclose)this.context.drawImage(window_img,0,144,16,16,this.w-16,0,16,16);

	this.context.font="10pt monospace";
	this.context.fillStyle="#000";
	this.context.fillText(this.name,4,12);
	this.context.font=this.font;
	this.context.fillStyle=this.fill;


	this.scrollbars();
}
mm_window.prototype.draw = function(con){
	if(!this.visible)return;
	if(!this.overlaydrawn)this.overlay();
	con.drawImage(this.canvas,this.x,this.y);
}


/*windows.push(new mm_window(256,480,"Window 1"));
windows.push(new mm_window(384,256,"Window 2"));
windows.push(new mm_window(256,480,"Butt nuggets"));
windows[2].x=512;
windows[1].x=256;
windows[2].y=512;
windows[1].y=256;
*/












// HELPER FUNCTIONS





function window_addcheckbox(win, enabled, x, y, text, func, ud){
//160,170
	weit(
		win,
		x,
		y,
		window_img_index,
		0 ,
		160 + 16 * enabled,
		16,
		16,
		text,
		"#fff",
		8   ,
		12   ,
		func,
		ud);
}


function weit(win, x, y, img, ix, iy, w, h, t, c, txos, tyos, func, ud){//window_event_image_text
	//Draws an image, and text with said event, height of event is of the image height
	win.drawsprite(x, y, img, ix, iy, w, h);
	var ox = x; var oy = y;
	x += w + txos;
	y += tyos;
	win.drawtext(x, y, t, c);
	x += win.context.measureText(t).width;
	win.addevent(ox, oy, x - ox, h, func, ud);
}