
var bullet_model;


function bullet(pos,dir,owner,spd){
	if(bullet_model == null) bullet_model = drawables["cheesecracker"]; // CHANGE ME.
	this.pos = vec3.clone(pos);
	this.dir = vec3.clone(dir);
	this.rot = quat.create();
	quat.rotateZ(this.rot, no_rot, Math.atan2(dir[1], dir[0]));
	this.owner = owner;
	this.spd = spd;
	vec3.multiply(this.dir, this.dir, [spd,spd,spd]);
	this.dmg = 1;
	this.size = .25;
	
	this.life = 200;
}


bullet.prototype.tick = function(){
	var dir = vec3.clone(this.dir);
	vec3.add(this.pos, this.pos, dir);
	
	if(this.pos[0] - player.pos[0] < -food_dist) this.pos[0] += food_dist * 2;
	if(this.pos[0] - player.pos[0] >  food_dist) this.pos[0] -= food_dist * 2;
	if(this.pos[1] - player.pos[1] < -food_dist) this.pos[1] += food_dist * 2;
	if(this.pos[1] - player.pos[1] >  food_dist) this.pos[1] -= food_dist * 2;
	
	if(this.owner){// player owned.
		var a;
		for(a in glevel.actors){
			if(vec3.dist(glevel.actors[a].pos, this.pos) < this.size + glevel.actors[a].size){
				if(glevel.actors[a].hit) glevel.actors[a].hit(this);
				return 1;
			}
		}
	}else{// enemy owner
		//if(vec3.dist(player.pos, this.pos) < this.size + player.size) return 1;
	}
	
	if(this.life-- <= 0) return 1;
	
	quat.rotateZ(this.rot, this.rot, 0.05);
	
	return 0;
}

bullet.prototype.render = function(){
	if(bullet_model == null) return;
	bullet_model.color[3] = 1.0;
	bullet_model.render(this.pos, this.rot, [1,1,1]);
}