
var bullet_model;


function bullet(pos,dir,owner,spd,color){
	if(bullet_model == null) bullet_model = drawables["Cube"]; // CHANGE ME.
	this.pos = vec3.clone(pos);
	this.dir = vec3.clone(dir);
	this.rot = quat.create();
	quat.rotateZ(this.rot, no_rot, Math.atan2(dir[1], dir[0]));
	this.owner = owner;
	this.spd = spd;
	vec3.multiply(this.dir, this.dir, [spd,spd,spd]);
	this.dmg = 1;
	this.color = color;
	this.size = .5;
}


bullet.prototype.tick = function(){
	var dir = vec3.clone(this.dir);
	if(this.color == player.color) vec3.multiply(dir, dir, [.5, .5, .5]);
	vec3.add(this.pos, this.pos, dir);
	//var t = glevel.getz(this.pos[0], this.pos[1]);
	//if(t == null) {
//		return 1;
//	}
	//if(t[0] > this.pos[2]) return 1;
	
	if(this.owner){// player owned.
		var a;
		for(a in glevel.actors){
			if(vec3.dist(glevel.actors[a].pos, this.pos) < this.size + glevel.actors[a].size){
				if(glevel.actors[a].hit) glevel.actors[a].hit(this);
				return 1;
			}
		}
	}else{// enemy owner
		if(vec3.dist(player.pos, this.pos) < this.size + player.size) return 1;
	}
	
	return 0;
}

bullet.prototype.render = function(){
	if(bullet_model == null) return;
	if(this.color){
		bullet_model.color = [1,1,1,1];
	}else{
		bullet_model.color = [.2,.2,.2,1];
	}
	bullet_model.render(this.pos, this.rot, [.01,.01,.01]);
}