/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal;

import com.sun.org.apache.xalan.internal.extensions.ExpressionContext;
import com.sun.org.apache.xalan.internal.res.XSLMessages;
import com.sun.org.apache.xml.internal.dtm.DTM;
import com.sun.org.apache.xml.internal.dtm.DTMFilter;
import com.sun.org.apache.xml.internal.dtm.DTMIterator;
import com.sun.org.apache.xml.internal.dtm.DTMManager;
import com.sun.org.apache.xml.internal.dtm.DTMWSFilter;
import com.sun.org.apache.xml.internal.dtm.ref.DTMNodeIterator;
import com.sun.org.apache.xml.internal.dtm.ref.sax2dtm.SAX2RTFDTM;
import com.sun.org.apache.xml.internal.utils.DefaultErrorHandler;
import com.sun.org.apache.xml.internal.utils.IntStack;
import com.sun.org.apache.xml.internal.utils.NodeVector;
import com.sun.org.apache.xml.internal.utils.ObjectStack;
import com.sun.org.apache.xml.internal.utils.PrefixResolver;
import com.sun.org.apache.xml.internal.utils.QName;
import com.sun.org.apache.xml.internal.utils.XMLString;
import com.sun.org.apache.xpath.internal.SourceTreeManager;
import com.sun.org.apache.xpath.internal.VariableStack;
import com.sun.org.apache.xpath.internal.axes.OneStepIteratorForward;
import com.sun.org.apache.xpath.internal.axes.SubContextList;
import com.sun.org.apache.xpath.internal.objects.DTMXRTreeFrag;
import com.sun.org.apache.xpath.internal.objects.XMLStringFactoryImpl;
import com.sun.org.apache.xpath.internal.objects.XObject;
import com.sun.org.apache.xpath.internal.objects.XString;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.XMLReader;

public class XPathContext
extends DTMManager {
    IntStack m_last_pushed_rtfdtm = new IntStack();
    private Vector m_rtfdtm_stack = null;
    private int m_which_rtfdtm = -1;
    private SAX2RTFDTM m_global_rtfdtm = null;
    private HashMap m_DTMXRTreeFrags = null;
    private boolean m_isSecureProcessing = false;
    private boolean m_useServicesMechanism = true;
    protected DTMManager m_dtmManager = null;
    ObjectStack m_saxLocations = new ObjectStack(4096);
    private Object m_owner;
    private Method m_ownerGetErrorListener;
    private VariableStack m_variableStacks = new VariableStack();
    private SourceTreeManager m_sourceTreeManager = new SourceTreeManager();
    private ErrorListener m_errorListener;
    private ErrorListener m_defaultErrorListener;
    private URIResolver m_uriResolver;
    public XMLReader m_primaryReader;
    private Stack m_contextNodeLists = new Stack();
    public static final int RECURSIONLIMIT = 4096;
    private IntStack m_currentNodes = new IntStack(4096);
    private NodeVector m_iteratorRoots = new NodeVector();
    private NodeVector m_predicateRoots = new NodeVector();
    private IntStack m_currentExpressionNodes = new IntStack(4096);
    private IntStack m_predicatePos = new IntStack();
    private ObjectStack m_prefixResolvers = new ObjectStack(4096);
    private Stack m_axesIteratorStack = new Stack();
    XPathExpressionContext expressionContext = new XPathExpressionContext();

    public DTMManager getDTMManager() {
        return this.m_dtmManager;
    }

    public void setSecureProcessing(boolean bl) {
        this.m_isSecureProcessing = bl;
    }

    public boolean isSecureProcessing() {
        return this.m_isSecureProcessing;
    }

    @Override
    public DTM getDTM(Source source, boolean bl, DTMWSFilter dTMWSFilter, boolean bl2, boolean bl3) {
        return this.m_dtmManager.getDTM(source, bl, dTMWSFilter, bl2, bl3);
    }

    @Override
    public DTM getDTM(int n) {
        return this.m_dtmManager.getDTM(n);
    }

    @Override
    public int getDTMHandleFromNode(Node node) {
        return this.m_dtmManager.getDTMHandleFromNode(node);
    }

    @Override
    public int getDTMIdentity(DTM dTM) {
        return this.m_dtmManager.getDTMIdentity(dTM);
    }

    @Override
    public DTM createDocumentFragment() {
        return this.m_dtmManager.createDocumentFragment();
    }

    @Override
    public boolean release(DTM dTM, boolean bl) {
        if (this.m_rtfdtm_stack != null && this.m_rtfdtm_stack.contains(dTM)) {
            return false;
        }
        return this.m_dtmManager.release(dTM, bl);
    }

    @Override
    public DTMIterator createDTMIterator(Object object, int n) {
        return this.m_dtmManager.createDTMIterator(object, n);
    }

    @Override
    public DTMIterator createDTMIterator(String string, PrefixResolver prefixResolver) {
        return this.m_dtmManager.createDTMIterator(string, prefixResolver);
    }

    @Override
    public DTMIterator createDTMIterator(int n, DTMFilter dTMFilter, boolean bl) {
        return this.m_dtmManager.createDTMIterator(n, dTMFilter, bl);
    }

    @Override
    public DTMIterator createDTMIterator(int n) {
        OneStepIteratorForward oneStepIteratorForward = new OneStepIteratorForward(13);
        oneStepIteratorForward.setRoot(n, this);
        return oneStepIteratorForward;
    }

    public XPathContext() {
        this(true);
    }

    public XPathContext(boolean bl) {
        this.init(bl);
    }

    public XPathContext(Object object) {
        this.m_owner = object;
        try {
            this.m_ownerGetErrorListener = this.m_owner.getClass().getMethod("getErrorListener", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.init(true);
    }

    private void init(boolean bl) {
        this.m_prefixResolvers.push(null);
        this.m_currentNodes.push(-1);
        this.m_currentExpressionNodes.push(-1);
        this.m_saxLocations.push(null);
        this.m_useServicesMechanism = bl;
        this.m_dtmManager = DTMManager.newInstance(XMLStringFactoryImpl.getFactory());
    }

    public void reset() {
        this.releaseDTMXRTreeFrags();
        if (this.m_rtfdtm_stack != null) {
            Enumeration enumeration = this.m_rtfdtm_stack.elements();
            while (enumeration.hasMoreElements()) {
                this.m_dtmManager.release((DTM)enumeration.nextElement(), true);
            }
        }
        this.m_rtfdtm_stack = null;
        this.m_which_rtfdtm = -1;
        if (this.m_global_rtfdtm != null) {
            this.m_dtmManager.release(this.m_global_rtfdtm, true);
        }
        this.m_global_rtfdtm = null;
        this.m_dtmManager = DTMManager.newInstance(XMLStringFactoryImpl.getFactory());
        this.m_saxLocations.removeAllElements();
        this.m_axesIteratorStack.removeAllElements();
        this.m_contextNodeLists.removeAllElements();
        this.m_currentExpressionNodes.removeAllElements();
        this.m_currentNodes.removeAllElements();
        this.m_iteratorRoots.RemoveAllNoClear();
        this.m_predicatePos.removeAllElements();
        this.m_predicateRoots.RemoveAllNoClear();
        this.m_prefixResolvers.removeAllElements();
        this.m_prefixResolvers.push(null);
        this.m_currentNodes.push(-1);
        this.m_currentExpressionNodes.push(-1);
        this.m_saxLocations.push(null);
    }

    public void setSAXLocator(SourceLocator sourceLocator) {
        this.m_saxLocations.setTop(sourceLocator);
    }

    public void pushSAXLocator(SourceLocator sourceLocator) {
        this.m_saxLocations.push(sourceLocator);
    }

    public void pushSAXLocatorNull() {
        this.m_saxLocations.push(null);
    }

    public void popSAXLocator() {
        this.m_saxLocations.pop();
    }

    public SourceLocator getSAXLocator() {
        return (SourceLocator)this.m_saxLocations.peek();
    }

    public Object getOwnerObject() {
        return this.m_owner;
    }

    public final VariableStack getVarStack() {
        return this.m_variableStacks;
    }

    public final void setVarStack(VariableStack variableStack) {
        this.m_variableStacks = variableStack;
    }

    public final SourceTreeManager getSourceTreeManager() {
        return this.m_sourceTreeManager;
    }

    public void setSourceTreeManager(SourceTreeManager sourceTreeManager) {
        this.m_sourceTreeManager = sourceTreeManager;
    }

    public final ErrorListener getErrorListener() {
        if (null != this.m_errorListener) {
            return this.m_errorListener;
        }
        ErrorListener errorListener = null;
        try {
            if (null != this.m_ownerGetErrorListener) {
                errorListener = (ErrorListener)this.m_ownerGetErrorListener.invoke(this.m_owner, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null == errorListener) {
            if (null == this.m_defaultErrorListener) {
                this.m_defaultErrorListener = new DefaultErrorHandler();
            }
            errorListener = this.m_defaultErrorListener;
        }
        return errorListener;
    }

    public void setErrorListener(ErrorListener errorListener) throws IllegalArgumentException {
        if (errorListener == null) {
            throw new IllegalArgumentException(XSLMessages.createXPATHMessage("ER_NULL_ERROR_HANDLER", null));
        }
        this.m_errorListener = errorListener;
    }

    public final URIResolver getURIResolver() {
        return this.m_uriResolver;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.m_uriResolver = uRIResolver;
    }

    public final XMLReader getPrimaryReader() {
        return this.m_primaryReader;
    }

    public void setPrimaryReader(XMLReader xMLReader) {
        this.m_primaryReader = xMLReader;
    }

    public Stack getContextNodeListsStack() {
        return this.m_contextNodeLists;
    }

    public void setContextNodeListsStack(Stack stack) {
        this.m_contextNodeLists = stack;
    }

    public final DTMIterator getContextNodeList() {
        if (this.m_contextNodeLists.size() > 0) {
            return (DTMIterator)this.m_contextNodeLists.peek();
        }
        return null;
    }

    public final void pushContextNodeList(DTMIterator dTMIterator) {
        this.m_contextNodeLists.push(dTMIterator);
    }

    public final void popContextNodeList() {
        if (this.m_contextNodeLists.isEmpty()) {
            System.err.println("Warning: popContextNodeList when stack is empty!");
        } else {
            this.m_contextNodeLists.pop();
        }
    }

    public IntStack getCurrentNodeStack() {
        return this.m_currentNodes;
    }

    public void setCurrentNodeStack(IntStack intStack) {
        this.m_currentNodes = intStack;
    }

    public final int getCurrentNode() {
        return this.m_currentNodes.peek();
    }

    public final void pushCurrentNodeAndExpression(int n, int n2) {
        this.m_currentNodes.push(n);
        this.m_currentExpressionNodes.push(n);
    }

    public final void popCurrentNodeAndExpression() {
        this.m_currentNodes.quickPop(1);
        this.m_currentExpressionNodes.quickPop(1);
    }

    public final void pushExpressionState(int n, int n2, PrefixResolver prefixResolver) {
        this.m_currentNodes.push(n);
        this.m_currentExpressionNodes.push(n);
        this.m_prefixResolvers.push(prefixResolver);
    }

    public final void popExpressionState() {
        this.m_currentNodes.quickPop(1);
        this.m_currentExpressionNodes.quickPop(1);
        this.m_prefixResolvers.pop();
    }

    public final void pushCurrentNode(int n) {
        this.m_currentNodes.push(n);
    }

    public final void popCurrentNode() {
        this.m_currentNodes.quickPop(1);
    }

    public final void pushPredicateRoot(int n) {
        this.m_predicateRoots.push(n);
    }

    public final void popPredicateRoot() {
        this.m_predicateRoots.popQuick();
    }

    public final int getPredicateRoot() {
        return this.m_predicateRoots.peepOrNull();
    }

    public final void pushIteratorRoot(int n) {
        this.m_iteratorRoots.push(n);
    }

    public final void popIteratorRoot() {
        this.m_iteratorRoots.popQuick();
    }

    public final int getIteratorRoot() {
        return this.m_iteratorRoots.peepOrNull();
    }

    public IntStack getCurrentExpressionNodeStack() {
        return this.m_currentExpressionNodes;
    }

    public void setCurrentExpressionNodeStack(IntStack intStack) {
        this.m_currentExpressionNodes = intStack;
    }

    public final int getPredicatePos() {
        return this.m_predicatePos.peek();
    }

    public final void pushPredicatePos(int n) {
        this.m_predicatePos.push(n);
    }

    public final void popPredicatePos() {
        this.m_predicatePos.pop();
    }

    public final int getCurrentExpressionNode() {
        return this.m_currentExpressionNodes.peek();
    }

    public final void pushCurrentExpressionNode(int n) {
        this.m_currentExpressionNodes.push(n);
    }

    public final void popCurrentExpressionNode() {
        this.m_currentExpressionNodes.quickPop(1);
    }

    public final PrefixResolver getNamespaceContext() {
        return (PrefixResolver)this.m_prefixResolvers.peek();
    }

    public final void setNamespaceContext(PrefixResolver prefixResolver) {
        this.m_prefixResolvers.setTop(prefixResolver);
    }

    public final void pushNamespaceContext(PrefixResolver prefixResolver) {
        this.m_prefixResolvers.push(prefixResolver);
    }

    public final void pushNamespaceContextNull() {
        this.m_prefixResolvers.push(null);
    }

    public final void popNamespaceContext() {
        this.m_prefixResolvers.pop();
    }

    public Stack getAxesIteratorStackStacks() {
        return this.m_axesIteratorStack;
    }

    public void setAxesIteratorStackStacks(Stack stack) {
        this.m_axesIteratorStack = stack;
    }

    public final void pushSubContextList(SubContextList subContextList) {
        this.m_axesIteratorStack.push(subContextList);
    }

    public final void popSubContextList() {
        this.m_axesIteratorStack.pop();
    }

    public SubContextList getSubContextList() {
        return this.m_axesIteratorStack.isEmpty() ? null : (SubContextList)this.m_axesIteratorStack.peek();
    }

    public SubContextList getCurrentNodeList() {
        return this.m_axesIteratorStack.isEmpty() ? null : (SubContextList)this.m_axesIteratorStack.elementAt(0);
    }

    public final int getContextNode() {
        return this.getCurrentNode();
    }

    public final DTMIterator getContextNodes() {
        try {
            DTMIterator dTMIterator = this.getContextNodeList();
            if (null != dTMIterator) {
                return dTMIterator.cloneWithReset();
            }
            return null;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public ExpressionContext getExpressionContext() {
        return this.expressionContext;
    }

    public DTM getGlobalRTFDTM() {
        if (this.m_global_rtfdtm == null || this.m_global_rtfdtm.isTreeIncomplete()) {
            this.m_global_rtfdtm = (SAX2RTFDTM)this.m_dtmManager.getDTM(null, true, null, false, false);
        }
        return this.m_global_rtfdtm;
    }

    public DTM getRTFDTM() {
        SAX2RTFDTM sAX2RTFDTM;
        if (this.m_rtfdtm_stack == null) {
            this.m_rtfdtm_stack = new Vector();
            sAX2RTFDTM = (SAX2RTFDTM)this.m_dtmManager.getDTM(null, true, null, false, false);
            this.m_rtfdtm_stack.addElement(sAX2RTFDTM);
            ++this.m_which_rtfdtm;
        } else if (this.m_which_rtfdtm < 0) {
            sAX2RTFDTM = (SAX2RTFDTM)this.m_rtfdtm_stack.elementAt(++this.m_which_rtfdtm);
        } else {
            sAX2RTFDTM = (SAX2RTFDTM)this.m_rtfdtm_stack.elementAt(this.m_which_rtfdtm);
            if (sAX2RTFDTM.isTreeIncomplete()) {
                if (++this.m_which_rtfdtm < this.m_rtfdtm_stack.size()) {
                    sAX2RTFDTM = (SAX2RTFDTM)this.m_rtfdtm_stack.elementAt(this.m_which_rtfdtm);
                } else {
                    sAX2RTFDTM = (SAX2RTFDTM)this.m_dtmManager.getDTM(null, true, null, false, false);
                    this.m_rtfdtm_stack.addElement(sAX2RTFDTM);
                }
            }
        }
        return sAX2RTFDTM;
    }

    public void pushRTFContext() {
        this.m_last_pushed_rtfdtm.push(this.m_which_rtfdtm);
        if (null != this.m_rtfdtm_stack) {
            ((SAX2RTFDTM)this.getRTFDTM()).pushRewindMark();
        }
    }

    public void popRTFContext() {
        int n = this.m_last_pushed_rtfdtm.pop();
        if (null == this.m_rtfdtm_stack) {
            return;
        }
        if (this.m_which_rtfdtm == n) {
            if (n >= 0) {
                boolean bl = ((SAX2RTFDTM)this.m_rtfdtm_stack.elementAt(n)).popRewindMark();
            }
        } else {
            while (this.m_which_rtfdtm != n) {
                boolean bl = ((SAX2RTFDTM)this.m_rtfdtm_stack.elementAt(this.m_which_rtfdtm)).popRewindMark();
                --this.m_which_rtfdtm;
            }
        }
    }

    public DTMXRTreeFrag getDTMXRTreeFrag(int n) {
        if (this.m_DTMXRTreeFrags == null) {
            this.m_DTMXRTreeFrags = new HashMap();
        }
        if (this.m_DTMXRTreeFrags.containsKey(new Integer(n))) {
            return (DTMXRTreeFrag)this.m_DTMXRTreeFrags.get(new Integer(n));
        }
        DTMXRTreeFrag dTMXRTreeFrag = new DTMXRTreeFrag(n, this);
        this.m_DTMXRTreeFrags.put(new Integer(n), dTMXRTreeFrag);
        return dTMXRTreeFrag;
    }

    private final void releaseDTMXRTreeFrags() {
        if (this.m_DTMXRTreeFrags == null) {
            return;
        }
        Iterator iterator = this.m_DTMXRTreeFrags.values().iterator();
        while (iterator.hasNext()) {
            DTMXRTreeFrag dTMXRTreeFrag = (DTMXRTreeFrag)iterator.next();
            dTMXRTreeFrag.destruct();
            iterator.remove();
        }
        this.m_DTMXRTreeFrags = null;
    }

    public class XPathExpressionContext
    implements ExpressionContext {
        @Override
        public XPathContext getXPathContext() {
            return XPathContext.this;
        }

        public DTMManager getDTMManager() {
            return XPathContext.this.m_dtmManager;
        }

        @Override
        public Node getContextNode() {
            int n = XPathContext.this.getCurrentNode();
            return XPathContext.this.getDTM(n).getNode(n);
        }

        @Override
        public NodeIterator getContextNodes() {
            return new DTMNodeIterator(XPathContext.this.getContextNodeList());
        }

        @Override
        public ErrorListener getErrorListener() {
            return XPathContext.this.getErrorListener();
        }

        public boolean useServicesMechnism() {
            return XPathContext.this.m_useServicesMechanism;
        }

        public void setServicesMechnism(boolean bl) {
            XPathContext.this.m_useServicesMechanism = bl;
        }

        @Override
        public double toNumber(Node node) {
            int n = XPathContext.this.getDTMHandleFromNode(node);
            DTM dTM = XPathContext.this.getDTM(n);
            XString xString = (XString)dTM.getStringValue(n);
            return xString.num();
        }

        @Override
        public String toString(Node node) {
            int n = XPathContext.this.getDTMHandleFromNode(node);
            DTM dTM = XPathContext.this.getDTM(n);
            XMLString xMLString = dTM.getStringValue(n);
            return xMLString.toString();
        }

        @Override
        public final XObject getVariableOrParam(QName qName) throws TransformerException {
            return XPathContext.this.m_variableStacks.getVariableOrParam(XPathContext.this, qName);
        }
    }
}

