#pragma once
#define _USE_MATH_DEFINES
#include <string>
#include <map>
#include <vector>
#include "player.h"
#include "missile.h"

class Simulator
{
  public:
    Simulator(const char *name);
    ~Simulator();
    void update(std::vector<Player *> &players, std::vector<Missile *> &missiles, long start_tick);
    static Missile * createMissileBasedOnPlayer(Player *player, Missile::Type type);
    bool simulateMeShooting(int my_id, Missile::Type type, int num_ticks, bool *hit, int max_missile_age);
    bool simulateMeShootingAndTheyBoost(int my_id, Missile::Type type, int num_ticks);
    int simulatePlayerMoves(int player_id, const std::vector<std::string> &moves);
    std::map<int, int> simulateAllPlayersWithMoves(int my_id, int num_ticks, const std::map<int, std::vector<std::string> > &moves);
    bool fakeSimulateMeShooting(int my_id, Missile::Type type, int num_ticks);

  private:
    std::vector<Player *> m_org_players;
    std::vector<Missile *> m_org_missiles;
    std::string m_simulation_name;
    long m_start_tick;
    FILE *m_log_fp;
    
    void gameTick(std::vector<Player *> &m_players, std::vector<Missile *> &m_missiles);
    void startSimulation(std::string name, std::vector<Player *> &players, std::vector<Missile *> &missiles);
    void endSimulation(std::string name, std::vector<Player *> &players, std::vector<Missile *> &missiles, std::string result);
    void setEnemyCommand(std::string command, int my_id, std::vector<Player *> &players);
    void logPlayers(int my_id, std::vector<Player *> &players);
    void logMissiles(std::vector<Missile *> &missiles);
    void logVirtualMissile(Missile *m);
    void copyPlayers(std::vector<Player *> &new_players);
    void copyMissiles(std::vector<Missile *> &new_missiles);
    Player * getPlayerWithId(int id, std::vector<Player *> &players);
};
