#pragma once
#define _USE_MATH_DEFINES
#include <math.h>
#include "fake_qt.h"

class Missile
{
  public:
    enum Type {
      Normal,
      Mine,
      Seeking
    };

    Missile(Type type, QPointF start_position, int start_rotation, int owner);
    Missile(Type type, QPointF position, qreal rotation, qreal velocityX, qreal velocityY, int energy, int owner);

    QPointF position() { return m_position; }

    int rotation() { return static_cast<int>(m_rotation * 360 / (M_PI * 2)); }
    void setRotation(qreal rotation);

    void doMove();
    int energy() { return m_energy; }

    bool isAlive() { return m_alive; }
    Type type() { return m_type; }

    int owner() { return m_owner; }

    void deleteLater() { m_alive = false; }

    int getAge() { return m_age; }
  private:
    Type m_type;
    QPointF m_position;
    qreal m_rotation;
    qreal m_velocityX;
    qreal m_velocityY;
    int m_energy;
    bool m_alive;
    int m_owner;
    int m_age;
};
