import sys
sys.path.append("..")
sys.path.append("../py_simuli")

from optparse import OptionParser
from connector import GameConnector
from simuli import Simulate

# from coord import Coord
# from world import World
# from players import Players
# from mapwindow import MapWindow, MapWindowThread


class Bot(object):
    debug = False
    gui = True
    name = "zomgBot"
    gc = None
    # world = World(Coord(x=0, y=0), Coord(x=0, y=0), [], [], [])
    # players = Players(None, 0)
    shells = []
    items = []
    me = None
    commands = ['LEFT', 'RIGHT']
    # , 'ACCELERATE', 'MISSILE', 'SEEKING', 'MINE' ]
    mapwindow = None
    frame = 0

    def __init__(self, host, port):
        self.host = host
        self.port = port

        self.gc = GameConnector(self.name)

        self.gc.handler_updateself = self.updateSelf
        self.gc.handler_enemylist = self.enemyList
        self.gc.handler_commandrequest = self.makeChoice
        self.gc.handler_shelllist = self.missileList
        self.gc.handler_endround = self.endOfRound
        self.gc.handler_death = self.death

        self.gc.connect(self.host, self.port)

        # self.world.debug = self.debug
        # self.world.setPlayers(self.players)

    def run(self):
        self.gc.parsingLoop()

    def death(self):
        if self.debug:
            print "You died"

    def endOfRound(self):
        if self.debug:
            print "Round is over"

    def missileList(self, missiles):
        if self.debug:
            print "Missiles: {0}\n".format(missiles)

        # self.world.updateShells(shells)

    def convertToCFormat(self, objs):
        if(isinstance(objs, list)):
            res = {}
            for idx, obj in enumerate(objs):
                res[str(idx)] = self.getValues(obj)
            return res

        else:
            return self.getValues(objs)

    def getValues(self, obj):
        return [
            obj['energy'],
            obj['id'],
            obj['rotation'],
            obj['velocityX'],
            obj['velocityY'],
            obj['x'],
            obj['y']
        ]

    def makeChoice(self):
        self.frame += 1

        if self.debug:
            print "Making a choice"

        print "Me: {0}".format(self.convertToCFormat(self.me))
        print "Enemies: {0}".format(self.convertToCFormat(self.enemies))

        hits = Simulate(self.convertToCFormat(self.me),
                        self.convertToCFormat(self.enemies),
                        len(self.enemies), 16)

        # currentCommand = random.choice(self.commands)
        if hits > 0:
            currentCommand = 'MISSILE'
        else:
            currentCommand = 'RIGHT'

        return currentCommand

    def enemyList(self, enemies):
        if self.debug:
            print "Enemies: {0}".format(enemies)

        self.enemies = enemies

        # self.players.update(enemies)

    def updateSelf(self, me):
        if self.debug:
            print "I am {0}\n".format(me)

        if me is None:
            return

        self.me = me
        # self.players.update([me])
        # self.players.own_id = me['id']

if __name__ == "__main__":
    parser = OptionParser()
    parser.add_option("-p", "--port", dest="port", type="int", default=54321)
    parser.add_option("--host", dest="host", type="string", default="localhost")
    (options, args) = parser.parse_args()

    bot = Bot(options.host, options.port)
    bot.run()
