package aistuff;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;

public class Connection {
	int port;
	String host;
	Socket socket;
	PrintWriter dOut;
	DataInputStream dIn;
	
	
	public Connection(String theHost, int thePort){
		host = theHost;
		port = thePort;
		
		socket = new Socket();
		
	}
	
	
	
	public void connect(){
		try {
			socket.connect(new InetSocketAddress(host, port));
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			System.err.println("Connection failed.. Exiting");
		}
	}
	
	
	public void controller(String message){

		
		try {
//			dOut = new DataOutputStream(socket.getOutputStream());
			dOut = new PrintWriter(socket.getOutputStream(), true);
			
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		dOut.println(message);
	}
	
	public String listen(){
		try {
			dIn = new DataInputStream(socket.getInputStream());
		
			
			 String text = dIn.readUTF();
			System.err.println(text);
				return text;
			
		} catch (IOException e) {
			// TODO Auto-generated catch block
			return null;
		}

	}
	
	public void disconnect(){
		try {
			socket.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	public void shoot(String weapon){
		
	}

}
