/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class Connection {
    private final Socket socket = new Socket();
    private final JSONParser parser = new JSONParser();
    private PrintWriter out;
    private BufferedReader in;

    public Connection() {
        try {
            String s;
            this.socket.connect(new InetSocketAddress("127.0.0.1", 54321));
            this.out = new PrintWriter(this.socket.getOutputStream(), true);
            this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.out.println("NAME Exanyr");
            while ((s = this.in.readLine()) != null) {
                JSONObject msg = (JSONObject)this.parser.parse(s);
                String type = (String)msg.get("messagetype");
                if (type.equals("stateupdate")) {
                    JSONArray missiles;
                    JSONObject gamestate = (JSONObject)msg.get("gamestate");
                    JSONObject you = (JSONObject)gamestate.get("you");
                    double energy = Double.valueOf(you.get("energy").toString());
                    double id = Double.valueOf(you.get("id").toString());
                    double rotation = Double.valueOf(you.get("rotation").toString());
                    double velocityX = Double.valueOf(you.get("velocityX").toString());
                    double velocityY = Double.valueOf(you.get("velocityY").toString());
                    double x = Double.valueOf(you.get("x").toString());
                    double y = Double.valueOf(you.get("y").toString());
                    JSONArray others = (JSONArray)gamestate.get("others");
                    if (!others.isEmpty()) {
                        for (Object o : others) {
                            JSONObject other = (JSONObject)o;
                            double oenergy = Double.valueOf(other.get("energy").toString());
                            double oid = Double.valueOf(other.get("id").toString());
                            double orotation = Double.valueOf(other.get("rotation").toString());
                            double ovelocityX = Double.valueOf(other.get("velocityX").toString());
                            double ovelocityY = Double.valueOf(other.get("velocityY").toString());
                            double ox = Double.valueOf(other.get("x").toString());
                            double oy = Double.valueOf(other.get("y").toString());
                            double dz = Math.hypot(Math.abs(x - ox), Math.abs(y - oy)) / 0.05;
                            double dx = dz * ovelocityX;
                            double dy = dz * ovelocityY;
                            double ang = Math.toDegrees(Math.atan2(oy + dy - y, ox + dx - x));
                            double sunAng = Math.toDegrees(Math.atan2(0.0 - y, 0.0 - x));
                            if (ang - rotation > 0.0 && ang - rotation < 180.0 || ang + 360.0 - rotation > 0.0 && ang + 360.0 - rotation < 180.0) {
                                this.action(Action.RIGHT);
                                continue;
                            }
                            if (rotation - ang > 20.0 && rotation - ang < 180.0 || rotation + 360.0 - ang > 20.0 && rotation + 360.0 - ang < 180.0) {
                                this.action(Action.LEFT);
                                continue;
                            }
                            if (rotation - sunAng < 20.0 && rotation - sunAng > 0.0 || rotation + 360.0 - sunAng < 180.0 && rotation + 360.0 - sunAng > 20.0) {
                                this.action(Action.RIGHT);
                                continue;
                            }
                            this.action(Action.MISSILE);
                        }
                    }
                    if ((missiles = (JSONArray)gamestate.get("missiles")).isEmpty()) continue;
                    for (Object o : missiles) {
                        JSONObject jSONObject = (JSONObject)o;
                    }
                    continue;
                }
                if (type.equals("dead")) {
                    System.out.println("DEAD");
                    continue;
                }
                if (!type.equals("endofround")) continue;
                System.out.println("END OF ROUND");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void action(Action action) {
        this.out.println((Object)action);
    }

    public static void main(String[] args) {
        new Connection();
    }
}

