﻿#region License

// --------------------------------------------------
// Demonstration code for AI-compo gathering.org 2014
// By: Patrick Tørresvold, 2014
// Twitter: @2rsvold
// --------------------------------------------------

#endregion


using System;

using System.Collections.Generic;

using System.IO;

using System.Linq;

using System.Net.Sockets;

using System.Text;

using System.Threading;

using System.Web.Script.Serialization;


namespace AI
{
    internal class Program
    {

        private static readonly ASCIIEncoding Encoding = new ASCIIEncoding();


        private static void Main(string[] args)
        {

            if (args == null) throw new ArgumentNullException(nameof(args));

            var client = new TcpClient();

            Console.WriteLine("Welcome to Lbot");
            Console.WriteLine("Enter server hostname/ip");
            var host = Console.ReadLine();
            if (string.IsNullOrEmpty(host))
                host = "localhost";

            Console.Clear();
            Console.WriteLine("Welcome to Lbot");
            Console.WriteLine("Enter server port");
            int port;
            var portInput = Console.ReadLine();
            int.TryParse(portInput, out port);
            if(port == 0)
                port = 54321;

            Console.Clear();
            Console.WriteLine("Welcome to Lbot");
            

            try
            {
                Console.WriteLine("Connecting to " + host +":"+port);
                client.Connect(host, 54321);

                
                Thread.Sleep(100);

                
                if (client.Connected)
                {
                    Console.Clear();
                    Console.WriteLine("Welcome to Lbot");
                    Console.WriteLine("Connected :D");
                    Console.WriteLine("Waiting for game");
                    var writer = client.GetStream();
                    var reader = new StreamReader(client.GetStream(), System.Text.Encoding.UTF8);
                    Send(writer, "NAME Lbot");

                    while (client.Connected)
                    {

                        var line = reader.ReadLine();
                        //Console.WriteLine("Response: " + line+Environment.NewLine);

                        Console.Clear();
                        Console.WriteLine("Game on");


                        if (line == null)
                            continue;




                        try
                        {
                            var serializer = new JavaScriptSerializer();

                            var stateupdate = serializer.Deserialize<stateupdate>(line);

                            if (stateupdate != null)

                            {
                                //Console.WriteLine("message recived: " + line);
                            
                                if (stateupdate.messagetype == "stateupdate")
                                {
                                    var action = Analys(stateupdate);

                                    if (action == Action.Fire)
                                        Fire(stateupdate, writer);
                                    else if (action == Action.TurnLeft)
                                        Send(writer, "LEFT");
                                    else if (action == Action.TurnRight)
                                        Send(writer, "RIGHT");
                                }
                                else
                                {
                                    //Console.WriteLine(stateupdate.messagetype);

                                }

                            }

                        }
                        catch (Exception e)
                        {
                            Console.WriteLine(e.ToString());
                        }
                    }
                }
            }
            catch (Exception e) 
            {
                Console.WriteLine("Unable to connect to " + host + ":" + port);
                Console.WriteLine(e.ToString());
            }

            Console.WriteLine("Good bye...");
            Console.WriteLine("Press Any key to exit");
            Console.ReadKey();
        }


        private static void Fire(stateupdate stateupdate, NetworkStream writer)
        {

                foreach (var other in stateupdate.gamestate.others)
                {
                    CalculateOthersNextCord(other);
                }

                if (stateupdate.gamestate.you.rotation >= 270)
                {
                    if (stateupdate.gamestate.you.x > 0)//rigth
                    {
                        if (stateupdate.gamestate.you.y > 0)
                            stateupdate.gamestate.you.MissileMapCord = SimpleMapCord.TopRight;

                        if (stateupdate.gamestate.you.y < 0)//TOP
                            stateupdate.gamestate.you.MissileMapCord = SimpleMapCord.None;
                    }

                    if (stateupdate.gamestate.you.x < 0)
                    {
                        if (stateupdate.gamestate.you.y > 0)
                            stateupdate.gamestate.you.MissileMapCord = SimpleMapCord.BottomRight;

                        if (stateupdate.gamestate.you.y < 0)//TOP
                            stateupdate.gamestate.you.MissileMapCord = SimpleMapCord.TopRight;
                    }

                    //Console.WriteLine(stateupdate.gamestate.you.MissileMapCord);
                }


                if (stateupdate.gamestate.you.rotation >= 180 && stateupdate.gamestate.you.rotation <= 270 )
                {
                    if (stateupdate.gamestate.you.x > 0)//rigth
                    {
                        if (stateupdate.gamestate.you.y > 0)
                            stateupdate.gamestate.you.MissileMapCord = SimpleMapCord.TopRight;

                        if (stateupdate.gamestate.you.y < 0)//TOP
                            stateupdate.gamestate.you.MissileMapCord = SimpleMapCord.TopLeft;
                    }

                    if (stateupdate.gamestate.you.x < 0)
                    {
                        if (stateupdate.gamestate.you.y > 0)
                            stateupdate.gamestate.you.MissileMapCord = SimpleMapCord.TopLeft;
                        
                        if (stateupdate.gamestate.you.y < 0)//TOP
                            stateupdate.gamestate.you.MissileMapCord = SimpleMapCord.None;
                    }

                    //Console.WriteLine(stateupdate.gamestate.you.MissileMapCord);
                }





                if (stateupdate.gamestate.you.rotation >= 90 && stateupdate.gamestate.you.rotation <= 180)
                {
                    if (stateupdate.gamestate.you.x > 0)//rigth
                    {
                        if (stateupdate.gamestate.you.y > 0)
                            stateupdate.gamestate.you.MissileMapCord = SimpleMapCord.BottomLeft;

                        if (stateupdate.gamestate.you.y < 0)//TOP
                            stateupdate.gamestate.you.MissileMapCord = SimpleMapCord.TopRight;
                    }

                    if (stateupdate.gamestate.you.x < 0)
                    {
                        if (stateupdate.gamestate.you.y > 0)
                            stateupdate.gamestate.you.MissileMapCord = SimpleMapCord.None;

                        if (stateupdate.gamestate.you.y < 0)//TOP
                            stateupdate.gamestate.you.MissileMapCord = SimpleMapCord.BottomLeft;
                    }

                    //Console.WriteLine(stateupdate.gamestate.you.MissileMapCord);
                }


                if (stateupdate.gamestate.you.rotation >= 0 && stateupdate.gamestate.you.rotation <= 90)
                {
                    if (stateupdate.gamestate.you.x > 0)//rigth
                    {
                        if (stateupdate.gamestate.you.y > 0)
                            stateupdate.gamestate.you.MissileMapCord = SimpleMapCord.TopRight;

                        if (stateupdate.gamestate.you.y < 0) //TOP
                            stateupdate.gamestate.you.MissileMapCord = SimpleMapCord.None;
                    }

                    if (stateupdate.gamestate.you.x < 0)
                    {
                        if (stateupdate.gamestate.you.y > 0)
                            stateupdate.gamestate.you.MissileMapCord = SimpleMapCord.BottomRight;

                        if (stateupdate.gamestate.you.y < 0)//TOP
                            stateupdate.gamestate.you.MissileMapCord = SimpleMapCord.TopRight;
                    }

                    //Console.WriteLine(stateupdate.gamestate.you.MissileMapCord);
                }


                //ACTION

                if (stateupdate.gamestate.others.Any(o => o.NextMapCord == stateupdate.gamestate.you.MissileMapCord))
                {
                    //Console.WriteLine("FIRE");
                    Send(writer, "SEEKING\n");
                }
            
        }



        private static Action Analys(stateupdate stateupdate)
        {

            if (stateupdate.gamestate.you.x > 0)
            {
                if (stateupdate.gamestate.you.y > 0)
                    stateupdate.gamestate.you.MapCord = SimpleMapCord.BottomRight;
                
                if (stateupdate.gamestate.you.y < 0)
                    stateupdate.gamestate.you.MapCord = SimpleMapCord.TopRight;
            }
            else if (stateupdate.gamestate.you.x < 0)
            {
                if (stateupdate.gamestate.you.y > 0)
                    stateupdate.gamestate.you.MapCord = SimpleMapCord.BottomLeft;

                if (stateupdate.gamestate.you.y < 0)
                    stateupdate.gamestate.you.MapCord = SimpleMapCord.TopLeft;
            }


            //2 player turn to fire first
//            if (stateupdate.gamestate.others.Count == 1)
//            {
//                if (stateupdate.gamestate.you.rotation <= 270 && stateupdate.gamestate.you.rotation > 180)
//                    return Action.TurnLeft;
//
//                if (stateupdate.gamestate.you.rotation <= 90 && stateupdate.gamestate.you.rotation > 0)
//                    return Action.TurnLeft;
//
//            }

            //3 player
//            if (stateupdate.gamestate.others.Count == 2)
//            {
//                return Action.None;
//                //TODO
//
//            }



            //4player
            if (stateupdate.gamestate.others.Count > 0)
            {
                switch (stateupdate.gamestate.you.MapCord)
                {

                    case SimpleMapCord.TopRight:
                        {
                            if (stateupdate.gamestate.you.rotation > 270 || stateupdate.gamestate.you.rotation == 0)
                            {
                                return Action.TurnLeft;
                            }

                            if (stateupdate.gamestate.you.rotation <= 180 && stateupdate.gamestate.you.rotation > 90)
                            {
                                // do nothing
                            }

                            if (stateupdate.gamestate.you.rotation <= 270 && stateupdate.gamestate.you.rotation > 180)
                            {
                                // do nothing
                            }

                            if (stateupdate.gamestate.you.rotation <= 90 && stateupdate.gamestate.you.rotation > 0)
                            {
                                // do nothing
                            }


                            break;
                        }

                    case SimpleMapCord.BottomRight:
                    {
                            if (stateupdate.gamestate.you.rotation > 270 || stateupdate.gamestate.you.rotation == 0)
                            {
                                // do nothing
                            }

                            if (stateupdate.gamestate.you.rotation <= 180 && stateupdate.gamestate.you.rotation > 90)
                            {
                                // do nothing
                            }

                            if (stateupdate.gamestate.you.rotation <= 270 && stateupdate.gamestate.you.rotation > 180)
                            {
                                // do nothing
                            }


                            if (stateupdate.gamestate.you.rotation <= 90 && stateupdate.gamestate.you.rotation > 0)
                                return Action.TurnLeft;

                            break;
                    }

                    case SimpleMapCord.BottomLeft:
                        {

                            if (stateupdate.gamestate.you.rotation > 270 || stateupdate.gamestate.you.rotation == 0)
                            {
                                //DO nothing
                            }


                            if (stateupdate.gamestate.you.rotation <= 180 && stateupdate.gamestate.you.rotation > 90)
                            {
                                return Action.TurnLeft;

                            }

                            if (stateupdate.gamestate.you.rotation <= 270 && stateupdate.gamestate.you.rotation > 180)
                            {
                                //do nothing

                            }


                            if (stateupdate.gamestate.you.rotation <= 90 && stateupdate.gamestate.you.rotation > 0)
                            {
                                //do nothing

                            }

                            break;
                        }

                    case SimpleMapCord.TopLeft:
                    {

                        if (stateupdate.gamestate.you.rotation > 270 || stateupdate.gamestate.you.rotation == 0)
                        {
                            //Do nothing
                        }

                        if (stateupdate.gamestate.you.rotation <= 180 && stateupdate.gamestate.you.rotation > 90)
                        {
                            //Do nothing
                        }

                        if (stateupdate.gamestate.you.rotation <= 270 && stateupdate.gamestate.you.rotation > 180)
                        {
                           return Action.TurnLeft;
                        }


                        if (stateupdate.gamestate.you.rotation <= 90 && stateupdate.gamestate.you.rotation > 0)
                        {
                            //do nothing
                        }

                            break;
                    }
                }
            }



//            var otherMaxEnergy = stateupdate.gamestate.others.Select(other => other.energy).Concat(new[] {0}).Max();
//            var energyDiff = (otherMaxEnergy*100)/stateupdate.gamestate.you.energy;


            if (stateupdate.gamestate.you.energy > 150 && stateupdate.gamestate.you.energy < 1200 )
            {

                return Action.Fire;
            }


            return Action.None;
        }



        private static void CalculateOthersNextCord(Others other)
        {
            //Console.WriteLine("other: " + other.id);


            if (other.x < 0)
            {
                //Console.WriteLine("other.x <= 0");

                if (other.y < 0)
                {
                    //Console.WriteLine("-----------");
                    //Console.WriteLine("|  x |    |");
                    //Console.WriteLine("-----------");
                    //Console.WriteLine("|    |    |");
                    //Console.WriteLine("-----------");

                    if (other.velocityY < 0)
                    {
                        //Console.WriteLine("/\\");
                        //Console.WriteLine("||");

                        if (other.velocityX < 0)
                        {
                            // <-

                            other.NextMapCord = SimpleMapCord.BottomRight;
                            //Console.WriteLine(other.NextMapCord);
                        }
                        else if (other.velocityX > 0)
                        {
                            other.NextMapCord = SimpleMapCord.TopRight;
                            //Console.WriteLine(other.NextMapCord);
                        }

                        ////Console.WriteLine("FIRE");
                        //Send(Writer, "SEEKING\n");
                    }
                    if (other.velocityY > 0)
                    {
                        //Console.WriteLine("||");
                        //Console.WriteLine("\\/");

                        if (other.velocityX < 0)
                        {
                            //TODO sjekke om velocity dytter utover kanten

                            // <-
                            other.NextMapCord = SimpleMapCord.BottomLeft;
                            //Console.WriteLine(other.NextMapCord);
                        }

                        else if (other.velocityX < 0)
                        {
                            other.NextMapCord = SimpleMapCord.BottomLeft;
                            //Console.WriteLine(other.NextMapCord);
                        }
                    }
                }
                if (other.y > 0)
                {
                    //Console.WriteLine("-----------");
                    //Console.WriteLine("|    |    |");
                    //Console.WriteLine("-----------");
                    //Console.WriteLine("|  x |    |");
                    //Console.WriteLine("-----------");

                    if (other.velocityY < 0)
                    {
                        //Console.WriteLine("/\\");
                        //Console.WriteLine("||");


                        if (other.velocityX < 0)
                        {
                            // <-
                            other.NextMapCord = SimpleMapCord.TopLeft;
                            //Console.WriteLine(other.NextMapCord);
                        }

                        else if (other.velocityX < 0)
                        {
                            other.NextMapCord = SimpleMapCord.TopLeft;
                            //Console.WriteLine(other.NextMapCord);
                        }


                        ////Console.WriteLine("FIRE");
                        //Send(Writer, "SEEKING\n");
                    }
                    else if (other.velocityY > 0)
                    {
                        //Console.WriteLine("||");
                        //Console.WriteLine("\\/");

                        if (other.velocityX < 0)
                        {
                            //TODO sjekke om velocity dytter utover kanten

                            // <-
                            other.NextMapCord = SimpleMapCord.TopRight;
                            //Console.WriteLine(other.NextMapCord);
                        }

                        else if (other.velocityX < 0)
                        {
                            other.NextMapCord = SimpleMapCord.BottomRight;
                            //Console.WriteLine(other.NextMapCord);
                        }
                    }
                }
            }

            if (other.x > 0)
            {
                //Console.WriteLine("other.x >= 0");

                if (other.y < 0)
                {
                    //Console.WriteLine("-----------");
                    //Console.WriteLine("|    |  x |");
                    //Console.WriteLine("-----------");
                    //Console.WriteLine("|    |    |");
                    //Console.WriteLine("-----------");

                    if (other.velocityY < 0)
                    {
                        //Console.WriteLine("/\\");
                        //Console.WriteLine("||");

                        ////Console.WriteLine("FIRE");
                        //Send(Writer, "SEEKING\n");

                        if (other.velocityX < 0)
                        {
                            // <-

                            other.NextMapCord = SimpleMapCord.TopLeft;
                            //Console.WriteLine(other.NextMapCord);
                        }
                        else if (other.velocityX > 0)
                        {
                            //TODO sjekke om velocity dytter utover kanten

                            other.NextMapCord = SimpleMapCord.BottomLeft;
                            //Console.WriteLine(other.NextMapCord);
                        }
                    }
                    if (other.velocityY > 0)
                    {
                        //Console.WriteLine("||");
                        //Console.WriteLine("\\/");

                        if (other.velocityX < 0)
                        {
                            // <-

                            other.NextMapCord = SimpleMapCord.BottomRight;
                            //Console.WriteLine(other.NextMapCord);
                        }
                        else if (other.velocityX > 0)
                        {
                            other.NextMapCord = SimpleMapCord.BottomRight;
                            //Console.WriteLine(other.NextMapCord);
                        }
                    }
                }
                if (other.y >= 0)
                {
                    //Console.WriteLine("-----------");
                    //Console.WriteLine("|    |    |");
                    //Console.WriteLine("-----------");
                    //Console.WriteLine("|    |  x |");
                    //Console.WriteLine("-----------");

                    if (other.velocityY < 0)
                    {
                        //Console.WriteLine("/\\");
                        //Console.WriteLine("||");

                        ////Console.WriteLine("FIRE");
                        //Send(Writer, "SEEKING\n");

                        if (other.velocityX < 0)
                        {
                            // <-

                            other.NextMapCord = SimpleMapCord.BottomLeft;
                            //Console.WriteLine(other.NextMapCord);
                        }
                        else if (other.velocityX < 0)
                        {
                            //TODO sjekke om velocity dytter utover kanten

                            other.NextMapCord = SimpleMapCord.TopLeft;
                            //Console.WriteLine(other.NextMapCord);
                        }
                    }
                    if (other.velocityY > 0)
                    {
                        //Console.WriteLine("||");
                        //Console.WriteLine("\\/");

                        if (other.velocityX < 0)
                        {
                            // <-
                            other.NextMapCord = SimpleMapCord.BottomLeft;
                            //Console.WriteLine(other.NextMapCord);
                        }
                        else if (other.velocityX < 0)
                        {
                            other.NextMapCord = SimpleMapCord.TopLeft;
                            //Console.WriteLine(other.NextMapCord);
                        }
                    }
                }
            }
        }



        private static void Send(Stream writer, string data)
        {
            var dataArray = Encoding.GetBytes(data); 
            writer.Write(dataArray, 0, dataArray.Length);
        }



        static bool CloseEnoughForMe(double value1, double value2, double acceptableDifference)
        {
            return Math.Abs(value1 - value2) <= acceptableDifference;
        }
    }


    public enum Action
    {
        TurnLeft,
        TurnRight,
        Fire,

        None

    }

    public class Gamestate
    {
        public List<Missile> missiles { get; set; }
        public List<Others> others { get; set; }
        public You you { get; set; }
    }

    public class Missile
    {
        public int energy { get; set; }
        public int owner { get; set; }
        public double rotation { get; set; }
        public string type { get; set; }
        public double velocityX { get; set; }
        public double velocityY { get; set; }
        public double x { get; set; }
        public double y { get; set; }
    }

    public class Others
    {
        public int energy { get; set; }
        public int id { get; set; }
        public int rotation { get; set; }
        public double velocityX { get; set; }
        public double velocityY { get; set; }
        public double x { get; set; }
        public double y { get; set; }

        public SimpleMapCord NextMapCord { get; set; }
}


    public enum SimpleMapCord
    {
        None,
        TopLeft,
        TopRight,
        BottomRight,
        BottomLeft
    }
    public class You
    {
        public int energy { get; set; }
        public int id { get; set; }
        public int rotation { get; set; }
        public double velocityX { get; set; }
        public double velocityY { get; set; }
        public double x { get; set; }
        public double y { get; set; }

        public SimpleMapCord MapCord { get; set; }

        public SimpleMapCord MissileMapCord { get; set; }
    }

    public class stateupdate
    {
        public string messagetype { get; set; }
        public Gamestate gamestate { get; set; }
    }

    public class Connect
    {
        public string Name { get; set; }
    }
}
