#pragma once

#include <QtTest>

#include "State.h"

class TestSimulation : public QObject
{
	Q_OBJECT

	private slots:
		void singleShipSingleStepSimulation()
		{
			constexpr auto first = R"({"missiles":[],"others":[],"you":{"energy":922,"id":0,"rotation":90,"velocityX":-0.0094447613781784151,"velocityY":-0.023503488812164526,"x":-0.3995794747355087,"y":0.51819229472598938}})";
			constexpr auto second = R"({"missiles":[],"others":[],"you":{"energy":921,"id":0,"rotation":90,"velocityX":-0.0090113779999403364,"velocityY":-0.024065519500587509,"x":-0.40859085273544904,"y":0.49412677522540188}})";
			stepAndCompareFromJson(first, second);
		}

		void singleNormalMissileStepSimulation()
		{
			constexpr auto first = R"({"missiles":[{"energy":1000,"id":0,"owner":0,"rotation":90,"type":"NORMAL","velocityX":3.0616169978683832e-18,"velocityY":0.050000000000000003,"x":0.48603511239804242,"y":0.19839799857930138}],"others":[],"you":{"energy":993,"id":1,"rotation":270,"velocityX":0.0034824402745698693,"velocityY":-0.027970829181440067,"x":-0.48603511239804248,"y":-0.19839799857930129}})";
			constexpr auto second = R"({"missiles":[{"energy":950,"id":0,"owner":0,"rotation":90,"type":"NORMAL","velocityX":-0.00049530612679454203,"velocityY":0.050751556762602554,"x":0.48554907728564439,"y":0.24819960058072207}],"others":[],"you":{"energy":992,"id":1,"rotation":270,"velocityX":0.0039719016163604461,"velocityY":-0.027771032606838556,"x":-0.48206321078168202,"y":-0.22616903118613985}})";
			stepAndCompareFromJson(first, second);
		}

		void singleMineSingleStepSimulation()
		{
			constexpr auto first = R"({"missiles":[{"energy":5000,"id":2,"owner":0,"rotation":9,"type":"MINE","velocityX":0.0049274497137138861,"velocityY":0.00084866914567512455,"x":0.49700050100200399,"y":0.08559985694254231}],"others":[],"you":{"energy":997,"id":1,"rotation":270,"velocityX":0.0014994989979959868,"velocityY":-0.028485599828285198,"x":-0.49700050100200399,"y":-0.085599856942542241}})";
			constexpr auto second = R"({"missiles":[{"energy":4999,"id":2,"owner":0,"rotation":9,"type":"MINE","velocityX":0.0049231941840832709,"velocityY":0.00084793620330009473,"x":0.50143095021471584,"y":0.086362926231274895}],"others":[],"you":{"energy":996,"id":1,"rotation":270,"velocityX":0.0019979949869648973,"velocityY":-0.028399742399054965,"x":-0.49500250601503909,"y":-0.1139995993415972}})";
			stepAndCompareFromJson(first, second);
		}

		void singleSeekingMissileStepSimulation()
		{
			constexpr auto first = R"({"missiles":[{"energy":1000,"id":0,"owner":0,"rotation":90,"type":"SEEKING","velocityX":1.8369701987210296e-18,"velocityY":0.029999999999999999,"x":0.49500250601503909,"y":0.11399959934159727}],"others":[{"energy":981,"id":0,"rotation":90,"velocityX":-0.0019979949869649008,"velocityY":0.028399742399054965,"x":0.49500250601503909,"y":0.11399959934159727}],"you":{"energy":996,"id":1,"rotation":270,"velocityX":0.0019979949869648973,"velocityY":-0.028399742399054965,"x":-0.49500250601503909,"y":-0.1139995993415972}})";
			constexpr auto second = R"({"missiles":[{"energy":950,"id":0,"owner":0,"rotation":194,"type":"SEEKING","velocityX":-0.00049500250601503665,"velocityY":0.0393860004006584,"x":0.49450750350902406,"y":0.14388559974225568}],"others":[{"energy":980,"id":0,"rotation":90,"velocityX":-0.0025025846974797215,"velocityY":0.028283534856402979,"x":0.49249992131755937,"y":0.14228313419800026}],"you":{"energy":995,"id":1,"rotation":270,"velocityX":0.0024949854548514828,"velocityY":-0.028285284969997136,"x":-0.49250752056018759,"y":-0.14228488431159433}})";
			stepAndCompareFromJson(first, second);
		}

	private:
		void stepAndCompareFromJson(const char* first, const char* second)
		{
			const auto& firstStateObject = QJsonDocument::fromJson(first).object();
			State firstState;
			firstState.parse(firstStateObject);

			const auto& secondStateObject = QJsonDocument::fromJson(second).object();
			State secondState;
			secondState.parse(secondStateObject);

			firstState.step();
			if (firstState != secondState)
			{
				firstState.printHumanReadableDifference(secondState);
			}
			QCOMPARE(firstState, secondState);
		}
};
