#pragma once

#include <QtCore>

#include "Angle.h"
#include "Vec2D.h"

class Velocity : public Vec2D<double>
{
	public:
		constexpr Velocity()
			: Vec2D(0, 0)
		{}


		constexpr Velocity(double x, double y)
			: Vec2D(x, y)
		{}

		Angle angle() const
		{
			return Angle::fromRadians(qAtan2(y(), x()));
		}

		double magnitude() const
		{
			return qSqrt(x() * x() + y() * y());
		}

		constexpr void limitWithin(const Velocity& min, const Velocity& max)
		{
			setX(qBound(min.x(), x(), max.x()));
			setY(qBound(min.y(), y(), max.y()));
		}
};
