#pragma once

#include <QtCore>

template<typename T>
class Vec2D
{
	public:
		constexpr Vec2D(T x, T y)
			: m_x(x)
			, m_y(y)
		{}

		constexpr double x() const
		{
			return m_x;
		}

		constexpr Vec2D& setX(T x)
		{
			m_x = x;
			return *this;
		}

		constexpr double y() const
		{
			return m_y;
		}

		constexpr Vec2D& setY(T y)
		{
			m_y = y;
			return *this;
		}

		constexpr bool operator==(const Vec2D& other) const
		{
			return qFuzzyCompare(m_x, other.m_x) && qFuzzyCompare(m_y, other.m_y);
		}

		constexpr bool operator!=(const Vec2D& other) const
		{
			return !operator==(other);
		}

		constexpr void operator+=(const Vec2D& other)
		{
			m_x += other.m_x;
			m_y += other.m_y;
		}

		constexpr void operator-=(const Vec2D& other)
		{
			m_x -= other.m_x;
			m_y -= other.m_y;
		}

		constexpr void operator/=(const Vec2D& other)
		{
			m_x /= other.m_x;
			m_y /= other.m_y;
		}

	private:
		T m_x;
		T m_y;

	friend QDebug operator<<(QDebug debug, const Vec2D<double>& vec);
};

inline QDebug operator<<(QDebug debug, const Vec2D<double>& vec)
{
	debug << "x =" << vec.x() << ", y =" << vec.y();
	return debug;
}
