#pragma once

class Energy
{
	public:
		constexpr Energy()
			: m_energy(0)
		{}

		constexpr Energy(int amount)
			: m_energy(amount)
		{}

		constexpr void set(int amount)
		{
			m_energy = amount;
		}

		constexpr void drain(int amount)
		{
			m_energy -= amount;
		}

		constexpr bool isEmpty() const
		{
			return m_energy <= 0;
		}

		constexpr int value() const
		{
			return m_energy;
		}

		constexpr bool operator==(const Energy& other) const
		{
			return m_energy == other.m_energy;
		}

	private:
		int m_energy;
};
