#include "Bot.h"
#include "Event.h"
#include "State.h"

Action Bot::handle(const State &state)
{
	if (state.myShip().energy().value() < 100)
	{
		// Do nothing and hope for the best
		return Action::None;
	}

	// If I shoot now, will I hit anything within a reasonable time?
	const auto& chanceToFire = qrand() % 100;
	if (chanceToFire < 50 && state.myShip().energy().value() > 200)
	{
		if (state.simulateMissileLaunch(Missile::Type::Normal, 16) > 0)
		{
			return Action::FireNormalMissile;
		}

		if (state.simulateMissileLaunch(Missile::Type::Seeking, 24) > 0)
		{
			return Action::FireSeekingMissile;
		}

		if (state.simulateMissileLaunch(Missile::Type::Mine, 16) > 0)
		{
			return Action::DropMine;
		}
	}

	const auto& closestShip = state.closestEnemyShip();
	const auto& headingToClosestShip = state.myShip().headingTo(closestShip.position()).asDegrees() + 70;
	if (headingToClosestShip < -10)
	{
		return Action::TurnLeft;
	}
	else if(headingToClosestShip > 10)
	{
		return Action::TurnRight;
	}

	const auto& chance = qrand() % 100;
	if (chance < 20)
	{
		return Action::FireSeekingMissile;
	}

	return Action::None;
}
