﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace g23pax {
   public class Aggis  {
      private class Future {
         public int PredictionSteps { get; private set; }

         public Dictionary<int, LinkedList<Weapon>> Booomms { get; set; }

         public Dictionary<int, LinkedList<Someone>> Suckers { get; set; }
         public int Time { get; private set; }

         public Future(GameState state, int predictionSteps = 432, LinkedList<GameState.Decision> commis = null) {
            PredictionSteps = predictionSteps;
            Booomms = state.Missiles.ToDictionary(p => p.ID, p => new LinkedList<Weapon>(new[] { p }));
            Suckers = state.All.ToDictionary(p => p.ID, p => new LinkedList<Someone>(new[] { p }));
            var you = state.YouID;

            var miter = state.Missiles.Select(p => new LinkedList<Weapon>(new[] {p}).First).ToList();
            var piter = Suckers.Select(q => q.Value.First).ToArray();
            var citer = commis == null ? null : commis.First;

            for (int t = 0; t < PredictionSteps; t++) {
               for (int i = 0; i < miter.Count; i++) {
                  var m = miter[i];
                  if (m.Value != null) {
                     if (m.Next == null) {
                        var n = new Weapon(m.Value);
                        m.List.AddLast(n.DoMove() ? n : null);
                     }
                     var M = m.Next.Value;
                     if (M != null) {
                        var hit =
                           piter.FirstOrDefault(p => M.SqDistTo(p.Value) < C.SUN_RADIUS_SQ && M.Owner != p.Value.ID);
                        if (hit != null) {
                           var opfr = hit.Value;
                           if (opfr.HitBy == null)
                              opfr.HitBy = new List<int>();
                           opfr.HitBy.Add(M.ID);
                           opfr.Energy -= C.MISSILE_DAMAGE;
                           var owndby = piter.FirstOrDefault(q => q.Value != null && q.Value.ID == M.Owner);
                           if (owndby != null) {
                              owndby.Value.Energy += C.MISSILE_DAMAGE;
                              while (owndby.Next != null)
                                 owndby.List.RemoveLast();
                           }
                           m.Next.Value = null;
                        }
                     }
                     miter[i] = m.Next;
                  }
               }

               for (int i = 0; i < piter.Length; i++) {
                  var p = piter[i];
                  if (p.Value != null) {
                     if (p.Next == null) {
                        var n = new Someone(p.Value);
                        Suckers[n.ID].AddLast(n.DoMove(true) ? n : null);
                     }
                     var P = p.Next.Value;
                     if (P != null) {
                        if (P.ID == you) {
                           if (citer != null) {
                              if (citer.Value != null) {
                                 var m = P.Decide(citer.Value);
                                 if (m != null)
                                    miter.Add(new LinkedList<Weapon>(new[] {m}).First);
                              }
                              citer = citer.Next;
                           }
                        }
                        //TODO: estimate players gain
                        P.Energy -= 5;
                     }
                     piter[i] = p.Next;
                  }
               }
            }
         }
      }

      public GameState.Decision Think(GameState gamestate) {
         if(gamestate == null)
            return GameState.Decision.None;
         var start = DateTime.Now;

         var alea = new Future(gamestate, 321);
         var closed = new List<LinkedList<GameState.Decision>>(); 
         var open = new Queue<LinkedList<GameState.Decision>>();

         var bestEnergy = 0d;
         var bestCommi = GameState.Decision.None;
         var bestRounds = 0;
         var bestIdx = -1;

         var you = gamestate.You;
         if (!you.DoMove())
            return GameState.Decision.None;

         var addOpen = new Action<IEnumerable<GameState.Decision>, GameState.Decision>((q, p) => {
            LinkedList<GameState.Decision> foo;
            foo = new LinkedList<GameState.Decision>(q);
            foo.AddLast(p);
            open.Enqueue(foo);
         });

         var _miter = alea.Booomms.Where(q => q.Value.First.Value.Owner != you.ID).Select(q => q.Value.First).ToArray();
         var _piter = alea.Suckers.Where(q => q.Value.First.Value.ID != you.ID).Select(q => q.Value.First).ToArray();

         open.Enqueue(new LinkedList<GameState.Decision>(new[]{ GameState.Decision.M }));
         addOpen(new[] { GameState.Decision.None }, GameState.Decision.M);
         addOpen(new[] { GameState.Decision.A }, GameState.Decision.M);

         var l = new LinkedList<GameState.Decision>();
         var a = new LinkedList<GameState.Decision>();
         var r = new LinkedList<GameState.Decision>();
         for (int i = 1; i < 180; i++) {
            l.AddLast(GameState.Decision.L);
            a.AddLast(GameState.Decision.A);
            r.AddLast(GameState.Decision.R);
            addOpen(l, GameState.Decision.M);
            addOpen(a, GameState.Decision.M);
            addOpen(r, GameState.Decision.M);
         }

         int run = 0;
         do {
            run++;
            if (open.Count > 0) {
               var nuOnes = new LinkedList<Weapon>();
               var P = new Someone(you);
               P.HitBy = new List<int>();
               var miter = _miter.ToArray();
               var piter = _piter.ToArray();

               var commis = open.Dequeue();
               var citer = commis.First;
               int T = 0;
               for (T = 0; T < alea.PredictionSteps; T++) {
                  for (var nuiter = nuOnes.First; nuiter != null;) {
                     var m = nuiter.Value;
                     m.DoMove();
                     var hit = piter.FirstOrDefault(p => p.Value.SqDistTo(m) < C.SUN_RADIUS_SQ);
                     if (hit != null) {
                        var g = C.MISSILE_DAMAGE*(1.0001 - (T/(double) alea.PredictionSteps))*0.6;
                        P.Energy += (int) g;

                        var lst = nuiter.List;
                        var rm = nuiter;
                        nuiter = nuiter.Next;
                        lst.Remove(rm);
                     } else 
                        nuiter = nuiter.Next;
                  }

                  if (citer != null) {
                     var nuMiss = P.Decide(citer.Value);
                     if (nuMiss != null)
                        nuOnes.AddLast(nuMiss);
                     citer = citer.Next;
                  }

                  if (!P.DoMove(true)) {
                     break;
                  }
                  for (int i = 0; i < miter.Length; i++) {
                     var m = miter[i];
                     if (m != null && m.Value != null) {
                        var M = m.Value;
                        if (M.SqDistTo(P) < C.SUN_RADIUS_SQ) {
                           P.Energy -= C.MISSILE_DAMAGE;
                           miter[i] = null;
                        } else
                           miter[i] = m.Next;
                     }
                  }

                  for (int i = 0; i < piter.Length; i++) 
                     if (piter[i].Value != null) 
                        piter[i] = piter[i].Next;
               }

               if (P.Energy > bestEnergy) {
                  bestIdx = closed.Count;
                  closed.Add(commis);
                  bestEnergy = P.Energy;
                  bestCommi = commis.First.Value;
               }
            } else {
               if (bestIdx == -1) {
                  break;// TODO: what?
               } else {
                  var add = new LinkedList<GameState.Decision>(closed[bestIdx]);
                  add.AddFirst(add.First.Value);
                  open.Enqueue(add);
                  if (add.Count > 2) {
                     add = new LinkedList<GameState.Decision>(add);
                     add.RemoveFirst();
                     add.RemoveFirst();
                     open.Enqueue(add);
                  }

                  add = new LinkedList<GameState.Decision>(closed[bestIdx]);
                  add.AddLast(add.Last.Value);
                  open.Enqueue(add);
               }
            }
         } while (DateTime.Now.Subtract(start).TotalMilliseconds < 48);
         return bestCommi;
      }
   }
}
