var TheGoldenPath = require('./Navigator.js');
var navigator = new TheGoldenPath();

/**
 * Game state object
 * @param socket
 */
function gamestate(socket) {
    this.socket = socket;
    this.me = {};
}

/**
 *
 */
gamestate.prototype.Update = function(data) {
    // What happened?
    switch (data.messagetype) {
        case 'stateupdate':
            console.log('Message type: Stateupdate');
            break;

        case 'dead':
            console.log('Message type: Dead');
            return;
            break;

        case 'endofround':
            console.log('Message type: End of round');
            return;
            break;
    }

    // Update all the useful stuff
    this.me = data.gamestate.you;

    // Select a move
    var move = navigator.randAction()

    console.log('My position: y' + this.me.y +', x'+ this.me.x);
    console.log('I am pointing: '+ this.me.rotation);

    // Write our random move to server
    console.log('I did this: '+move);
    this.Write(move);
}

/**
 * Send something to the game server
 * @param input
 * @constructor
 */
gamestate.prototype.Write = function(input) {
    this.socket.write(input);
}


module.exports = gamestate;
