#version 330

layout (location = 0) out vec4 FragColor;
layout (location = 1) out vec4 BrightColor;

in vec2 texcoord;

uniform sampler2D img;
uniform sampler2D bright;
uniform int width;
uniform float time;

const float weight[9] = float[9](0.132980760, 0.125794409, 0.106482669, 0.080656908, 0.054670025, 0.033159046, 0.017996989, 0.008740630, 0.003798662);

const float num[9] = float[9](0.0, 3.0, 6.0, 9.0, 12.0, 15.0, 18.0, 21.0, 24.0);
void main(){
   vec2 heat = texcoord;
   if(heat.x > 0.1 && heat.x < 0.9){
   heat.x    = heat.x + sin(heat.y * 100.0 - (time * 20.0)) / 700.0;
   }
   FragColor = texture(img, heat);

   float dx = 1.0 / float(width);
   vec4 sum = texture(bright, heat) * weight[0];
   for(int i = 1; i < 9; i++){
      sum += texture(bright, heat + vec2(num[i] * dx, 0.0)) * weight[i];
      sum += texture(bright, heat - vec2(num[i] * dx, 0.0)) * weight[i];
   }
   BrightColor = sum;
}