#version 410 core

uniform vec2 resolution;

uniform sampler2D tex;

uniform float vignetteStrength;
uniform float vignetteSizeBias;
uniform float vignettePower;

uniform float fisheyeAmount;

uniform float radialBlurAmount;
uniform float radialBlurAberrationAmount;

in vec2 texCoords;

out vec4 FragColor;

vec3 fetchColor(vec2 pos)
{
    // Fisheye (applied to all texture reads)
    vec2 nv = pos * 2.0 - 1.0;

    float r2 = dot(nv, nv);
    float f = 1.0 + r2 * (fisheyeAmount * sqrt(r2) - fisheyeAmount);

    vec2 scaled = nv * f;
    vec2 uv = scaled * .5 + .5;

    if (uv.x >= 0.0 && uv.x < 1.0 && uv.y >= 0.0 && uv.y < 1.0)
    {
        return texture(tex, uv).xyz;
    }
    else
    {
        return vec3(0.0);
    }
}

void main()
{
    // Radial blur
    vec3 inputColor = vec3(0.0);
    const int radialBlurTaps = 20;
    for (int i = 0; i < radialBlurTaps; i++)
    {
        float f = float(i) / float(radialBlurTaps);
        vec2 nv = texCoords * 2.0 - 1.0;
        float d = length(nv);
        vec2 scaled = nv / d * (d * (1.0 - f * 0.3 * radialBlurAmount));
        vec2 uv = scaled * .5 + .5;
        vec3 tap = fetchColor(uv);
        inputColor += mix(tap, mix(vec3(tap.x, 0.0, 0.0), vec3(0.0, tap.yz), f) * 2.0, radialBlurAberrationAmount);
    }
    inputColor /= float(radialBlurTaps);

    // Vignette
    float d = clamp(length(texCoords * 2.0 - 1.0) - vignetteSizeBias, 0.0, 1.0);
    inputColor *= 1.0 - clamp(pow(d, vignettePower) * vignetteStrength, 0.0, 1.0);

    FragColor = vec4(inputColor, 1.0);
}
