#version 410 core

uniform vec2 resolution;

uniform sampler2D colorTex;
uniform sampler2D cocTex;

in vec2 texCoords;

layout(location = 0) out vec4 farColor;
layout(location = 1) out vec4 nearColor;

// Returns color in xyz, CoC in w
vec4 farFetchAndPremultiply(ivec2 uv)
{
    float coc = texelFetch(cocTex, uv, 0).x;
    return coc < 0.0 ? vec4(texelFetch(colorTex, uv, 0).xyz, coc) : vec4(0.0);
}

// Returns color in xyz, weight in w
vec4 getFarContribution(float originalCoc, ivec2 uv)
{
    const float edgeThreshold = .5;
    vec4 colorCoc = farFetchAndPremultiply(uv);
    float difference = abs(colorCoc.w - originalCoc);
    return difference < edgeThreshold ?
        vec4(colorCoc.xyz, 1.0) :
        vec4(0.0);
}

vec3 getFarColor(ivec2 baseUv)
{
    vec4 originalColorCoc = farFetchAndPremultiply(baseUv);
    float originalCoc = originalColorCoc.w;
    vec4 acc = vec4(originalColorCoc.xyz, 1.0);
    acc += getFarContribution(originalCoc, baseUv + ivec2(1, 0));
    acc += getFarContribution(originalCoc, baseUv + ivec2(0, 1));
    acc += getFarContribution(originalCoc, baseUv + ivec2(1, 1));
    return acc.xyz / acc.w;
}

// TODO: Refactor; code can be reused better here :P
// Returns color in xyz, CoC in w
vec4 nearFetchAndPremultiply(ivec2 uv)
{
    float coc = texelFetch(cocTex, uv, 0).x;
    return coc > 0.0 ? vec4(texelFetch(colorTex, uv, 0).xyz, coc) : vec4(0.0);
}

// Returns color in xyz, weight in w
vec4 getNearContribution(float originalCoc, ivec2 uv)
{
    const float edgeThreshold = .5;
    vec4 colorCoc = nearFetchAndPremultiply(uv);
    float difference = abs(colorCoc.w - originalCoc);
    return difference < edgeThreshold ?
        vec4(colorCoc.xyz, 1.0) :
        vec4(0.0);
}

vec3 getNearColor(ivec2 baseUv)
{
    vec4 originalColorCoc = nearFetchAndPremultiply(baseUv);
    float originalCoc = originalColorCoc.w;
    vec4 acc = vec4(originalColorCoc.xyz, 1.0);
    acc += getNearContribution(originalCoc, baseUv + ivec2(1, 0));
    acc += getNearContribution(originalCoc, baseUv + ivec2(0, 1));
    acc += getNearContribution(originalCoc, baseUv + ivec2(1, 1));
    return acc.xyz / acc.w;
}

void main()
{
    ivec2 baseUv = ivec2(texCoords * resolution) * 2;

    farColor = vec4(getFarColor(baseUv), 1.0);
    nearColor = vec4(getNearColor(baseUv), 1.0);
}
