#version 410 core

uniform vec2 resolution;
uniform sampler2D farColorTex;
uniform sampler2D nearColorTex;
uniform sampler2D cocTex;

uniform sampler2D fullResColorTex;

uniform sampler2D bloomTex;
uniform sampler2D bloomDirtTex;

uniform float bloomBias;
uniform float bloomMultiplier;
uniform float bloomPower;
uniform float bloomDirtAmount;
uniform float bloomAmount;

in vec2 texCoords;

out vec4 FragColor;

// Returns color in xyz, weight in w
/*vec4 getContribution(vec3 originalColor, ivec2 uv)
{
    const float edgeThreshold = .5;
    vec3 color = texelFetch(farColorTex, uv, 0).xyz;
    vec3 difference = abs(color - originalColor);
    float maxDifference = max(max(difference.x, difference.y), difference.z);
    return maxDifference < edgeThreshold ?
        vec4(color, 1.0) :
        vec4(0.0);
}*/

void main()
{
    vec2 currentPixelUv = texCoords;
    float currentPixelCoc = texture(cocTex, currentPixelUv).x;

    vec3 farColor;

    if (currentPixelCoc >= 0.0)
    {
        farColor = texture(fullResColorTex, currentPixelUv).xyz;
    }
    else
    {
        // TODO: Better upscale filter to reduce some edge artifacts (crytek slides say bilateral + bicubic)
        /*ivec2 baseUv = ivec2(gl_FragCoord.xy) / 2;
        vec3 originalColor = texelFetch(farColorTex, baseUv, 0).xyz;
        vec4 acc = vec4(originalColor, 1.0);
        acc += getContribution(originalColor, baseUv + ivec2(-1,  0));
        acc += getContribution(originalColor, baseUv + ivec2( 0,  1));
        acc += getContribution(originalColor, baseUv + ivec2( 0, -1));
        acc += getContribution(originalColor, baseUv + ivec2( 0,  1));
        farColor = acc.xyz / acc.w;*/
        farColor = texture(farColorTex, currentPixelUv).xyz;
        //farColor = texelFetch(farColorTex, ivec2(gl_FragCoord.xy) / 2, 0).xyz;

        if (currentPixelCoc > -1.0)
        {
            float blend = 1.0 - pow(1.0 - -currentPixelCoc, 8.0);
            farColor = mix(texture(fullResColorTex, currentPixelUv).xyz, farColor, blend);
        }
    }

    vec4 nearColor = texture(nearColorTex, currentPixelUv);

    vec3 dofColor = mix(farColor, nearColor.xyz, clamp(nearColor.w * 2.0, 0.0, 1.0));

    vec3 bloomDirtColor = mix(vec3(1.0), texture(bloomDirtTex, currentPixelUv).xyz, bloomDirtAmount);
    vec3 bloomColor = pow(max(texture(bloomTex, currentPixelUv).xyz * bloomMultiplier + bloomBias, 0.0), vec3(bloomPower)) * bloomDirtColor;

    FragColor = vec4(dofColor + bloomColor * bloomAmount, 1.0);
}
