var Demo = function() {
	this.loader = new Loader();
	this.player = new Player();
}

Demo.prototype.init = function()
{

this.loader.addAnimation([
		{
			 "start": 0, "duration": 300
			,"layer": 1000, "image": "jml_logo_mtv.png"
			,"color":[{"a":200}]
			,"scale": [{"uniform2d":0.3}]
			,"position": [{"x":1210, "y":50}]
		}
	]);

	var wavynessFadeOut = "{var p = (getSceneTimeFromStart()-(animation.start+animation.wavynessFadeStart))/animation.wavynessFadeDuration; return 1-Math.min(1, Math.max(0, p));}";

	this.loader.addAnimation([
		{
			 "start": 0, "duration": 30
			,"layer": "00008", "image": "nauha1.png"
			,"position": [{"x":120, "y":-500},{"duration": 4, "x":500,"y":360}
			,{"start": 6,"duration": 3, "x":640, "y":-100}]
			,"color":[{"a":255},{"start":26,"duration":0.5,"a":0}]
			,"wavynessFadeStart": 6
			,"wavynessFadeDuration": 4
			,"shader":{"name":"data/shader/wavy.fs"
				,"variable":[
					 {"name":"time","value":["{return getSceneTimeFromStart();}"]}
					,{"name":"type","type":"int", "value":[0]}
					,{"name":"wavyness","value":[wavynessFadeOut]}
				]
			}
		}
	]);

this.loader.addAnimation([
		{
			 "start": 0, "duration": 30
			,"layer": "00009", "image": "nauha2.png"
			,"position": [{"x":1100, "y":-500},{"duration": 4, "x":780, "y":360}
			,{"start": 6,"duration": 3, "x":640, "y":-100}]
			,"color":[{"a":255},{"start":26,"duration":0.5,"a":0}]
			,"wavynessFadeStart": 6
			,"wavynessFadeDuration": 4
			,"shader":{"name":"data/shader/wavy.fs"
				,"variable":[
					 {"name":"time","value":["{return getSceneTimeFromStart();}"]}
					,{"name":"type","type":"int", "value":[1]}
					,{"name":"wavyness","value":[wavynessFadeOut]}
				]
			}

			
		
		}
	]);


this.loader.addAnimation([
		{
			 "start": 6, "duration": 5
			,"layer": "00001", "image": "leatherbackground_1.png"
			,"position": [{"x":1280/2,"y":1100},{"duration": 3, "x":1280/2,"y":720/2}]
			,"color":[{"a":0},{"duration":3,"a":255},{"start": 9,"duration":2,"a":0}]
			
		
		}
	]);

this.loader.addAnimation([
		{
			 "start": 9, "duration": 21
			,"layer": "00002", "image": "leatherbackground_2.png"
			,"position": [{"x":1280/2,"y":720/2}]
			,"color":[{"a":0},{"duration":2,"a":255},{"duration":15},{"duration":1,"a":0}]
			
		
		}
	]);

this.loader.addAnimation([
		{
			 "start": 10, "duration": 20
			,"layer": "00011", "image": "nyrkki_6.png"
			,"position": [{"x":1280/2,"y":210}]
			,"color":[{"a":0},{"duration":1,"a":255},{"duration":15},{"duration":1,"a":0}]
			,"scale":[{"x":0.67, "y":0.67}]
			
		
		}
	]);

this.loader.addAnimation([
		{
			 "start": 11.5, "duration": 8
			,"layer": "00004", "image": "jml_sweet2016.png"
			,"position": [{"x":1280/2,"y":500}]
			,"color":[{"a":0},{"duration":2,"a":255},{"duration":5},{"duration":1,"a":0}]
			,"scale":[{"x":0, "y":0},{"duration":1.5,"x":0.65, "y":0.65}]
			
		
		}
	]);

this.loader.addAnimation([
		{
			 "start": 19.5, "duration": 6.5
			,"layer": "00004", "image": "september.png"
			,"position": [{"x":1280/2,"y":430}]
			,"color":[{"a":0},{"duration":2,"a":255},{"duration":3.5},{"duration":1,"a":0}]
			,"scale":[{"x":0, "y":0},{"duration":1.5,"x":0.65, "y":0.65}]
			
		
		}
	]);

this.loader.addAnimation([
		{
			 "start": 19.5, "duration": 6.5
			,"layer": "00004", "image": "finland.png"
			,"position": [{"x":1280/2,"y":520}]
			,"color":[{"a":0},{"duration":2,"a":255},{"duration":3.5},{"duration":1,"a":0}]
			,"scale":[{"x":0, "y":0},{"duration":1.5,"x":1, "y":1}]
			
		
		}
	]);




this.loader.addAnimation([
		{
			 "start": 13.5, "duration": 1.3
			,"layer": "00012", "image": "light_6.png"
			,"position": [{"x":745,"y":145}]
			,"color":[{"a":0},{"duration":0.5,"a":255},{"duration":0.3},{"duration":0.5,"a":0}]
			,"scale":[{"x":0, "y":0},{"duration":0.75,"x":3, "y":3},{"duration":0.5},{"duration":0.75,"x":0, "y":0}]
			,"angle":[{"degreesZ":0},{"duration":2,"degreesZ":360}]
		
		}
	]);

var lights = 100;
for(var i = 0; i < lights; i++)
{
	var duration = 3+random()*1.5;
	var scale = 1.0+random()*0.25;
	var startTime = 15.3+10*random();
	var lightNumber = Math.floor(random()*4)+1;

	var precision = getScreenWidth();
	var radius = getScreenWidth();
	var angle = (random()*precision+precision)*2*Math.PI/precision;
	var endX = Math.cos(angle) * radius;
	var endY = Math.sin(angle) * radius;

	this.loader.addAnimation([
		{
			 "start": startTime, "duration": duration
			,"layer": 10, "image": "light_"+lightNumber+".png"
			,"position": [{"x":1280/2,"y":210},{"duration":duration, "x":endX,"y":endY}]
			
		
		}
	]);	
}




//featuret

this.funkyBackground(26, 32, true);

this.loader.addAnimation([
		{
			 "start": 30, "duration": 30
			,"layer": 8, "image": "whitebackground.png"
			,"color":[{"a":0},{"duration":1.5,"a":220},{"duration":26},{"duration":2,"a":0}]
			,"scale": [{"x": 1, "y": 1.5}]
			
		
		}
	]);

this.loader.addAnimation([
		{
			 "start": 32, "duration": 19
			,"layer": "00009", "image": "features_01.png"
			,"position": [{"x":1280/2,"y":720/2}]
			,"color":[{"a":0},{"duration":1,"a":255},{"duration":1,"a":0}]
			
		
		}
	]);


this.loader.addAnimation([
		{
			 "start": 34, "duration": 19
			,"layer": 9, "image": "features_02.png"
			,"position": [{"x":1280/2,"y":720/2}]
			,"color":[{"a":0},{"duration":1,"a":255},{"duration":1,"a":0}]
			
		
		}
	]);

this.loader.addAnimation([
		{
			 "start": 36, "duration": 19
			,"layer": 9, "image": "features_03.png"
			,"position": [{"x":1280/2,"y":720/2}]
			,"color":[{"a":0},{"duration":1,"a":255},{"duration":1,"a":0}]
			
		
		}
	]);

this.loader.addAnimation([
		{
			 "start": 38, "duration": 19
			,"layer": 9, "image": "features_04.png"
			,"position": [{"x":1280/2,"y":720/2}]
			,"color":[{"a":0},{"duration":1,"a":255},{"duration":1,"a":0}]
			
		
		}
	]);

this.loader.addAnimation([
		{
			 "start": 40, "duration": 19
			,"layer": 9, "image": "features_05.png"
			,"position": [{"x":1280/2,"y":720/2}]
			,"color":[{"a":0},{"duration":1,"a":255},{"duration":1,"a":0}]
			
			
		
		}
	]);

this.loader.addAnimation([
		{
			 "start": 42, "duration": 19
			,"layer": 9, "image": "features_06.png"
			,"position": [{"x":1280/2,"y":720/2}]
			,"color":[{"a":0},{"duration":1,"a":255},{"duration":1,"a":0}]
			
			
		
		}
	]);

this.loader.addAnimation([
		{
			 "start": 44, "duration": 19
			,"layer": 9, "image": "features_07.png"
			,"position": [{"x":1280/2,"y":720/2}]
			,"color":[{"a":0},{"duration":1,"a":255},{"duration":1,"a":0}]
			
			
		
		}
	]);

this.loader.addAnimation([
		{
			 "start": 46, "duration": 19
			,"layer": 9, "image": "features_08.png"
			,"position": [{"x":1280/2,"y":720/2}]
			,"color":[{"a":0},{"duration":1,"a":255},{"duration":1,"a":0}]
			
			
		
		}
	]);

this.loader.addAnimation([
		{
			 "start": 48, "duration": 19
			,"layer": 9, "image": "features_09.png"
			,"position": [{"x":1280/2,"y":720/2}]
			,"color":[{"a":0},{"duration":1,"a":255},{"duration":1,"a":0}]
			
			
		
		}
	]);

this.loader.addAnimation([
		{
			 "start": 50, "duration": 19
			,"layer": 9, "image": "features_10.png"
			,"position": [{"x":1280/2,"y":720/2}]
			,"color":[{"a":0},{"duration":1,"a":255},{"duration":1,"a":0}]
			
		
		}
	]);

this.loader.addAnimation([
		{
			 "start": 52, "duration": 19
			,"layer": 9, "image": "features_11.png"
			,"position": [{"x":1280/2,"y":720/2}]
			,"color":[{"a":0},{"duration":1,"a":255},{"duration":1,"a":0}]
			
			
		
		}
	]);
this.loader.addAnimation([
		{
			 "start": 54, "duration": 19
			,"layer": 9, "image": "features_12.png"
			,"position": [{"x":1280/2,"y":720/2}]
			,"color":[{"a":0},{"duration":1,"a":255},{"duration":1,"a":0}]
			
			
		
		}
	]);
this.loader.addAnimation([
		{
			 "start": 56, "duration": 19
			,"layer": 9, "image": "features_13.png"
			,"position": [{"x":1280/2,"y":720/2}]
			,"color":[{"a":0},{"duration":1,"a":255},{"duration":1,"a":0}]
			
			
		
		}
	]);


// CREDITS

this.loader.addAnimation([
		{
			 "start": 58, "duration": 13
			,"layer": "00020", "image": "pinkktausta_2.png"
			,"position": [{"x":1280/2,"y":720/2}]
			,"color":[{"a":0},{"duration":2,"a":255},{"duration":10},{"duration":1,"a":0}]
			
		
		}
	]);

	this.loader.addAnimation([
	{
		 "start": 59, "duration": 10
		,"layer": "00020"
		,"initFunction":"{initHeartCurve(animation);}"
		,"runFunction":"{drawHeartCurve(animation);}"
	}]);

this.loader.addAnimation([
		{
			 "start": 59, "duration": 10
			,"layer": "00021", "image": "haluttu.png"
			,"position": [{"x":1280/2,"y":720/2}]
			,"color":[{"a":0},{"duration":1,"a":255},{"duration":8},{"duration":1,"a":0}]
			,"scale":[{"x":0, "y":0},{"duration":1.5,"x":1, "y":1}]
			
		
		}
	]);

this.loader.addAnimation([
		{
			 "start": 59, "duration": 10
			,"layer": "00021", "image": "burzum.png"
			,"position": [{"x":1280/2,"y":150}]
			,"color":[{"a":0},{"duration":1,"a":255},{"duration":8},{"duration":1,"a":0}]
			,"scale":[{"x":0, "y":0},{"duration":1.5,"x":1, "y":1}]
			
		
		}
	]);

this.loader.addAnimation([
		{
			 "start": 59, "duration": 10
			,"layer": "00021", "image": "CDK.png"
			,"position": [{"x":1280/2,"y":550}]
			,"color":[{"a":0},{"duration":1,"a":255},{"duration":8},{"duration":1,"a":0}]
			,"scale":[{"x":0, "y":0},{"duration":1.5,"x":1, "y":1}]
			
		
		}
	]);


//compos

this.funkyBackground(69, 22, false);

this.loader.addAnimation([
		{
			 "start": 69, "duration": 22
			,"layer": 8, "image": "whitebackground.png"
			,"color":[{"a":0},{"duration":1.5,"a":220},{"duration":19},{"duration":2,"a":0}]
			,"scale": [{"x": 1, "y": 1.5}]
			
		
		}
	]);

this.loader.addAnimation([
		{
			 "start": 71, "duration": 19
			,"layer": 9, "image": "compos_01.png"
			,"position": [{"x":1280/2,"y":720/2}]
			,"color":[{"a":0},{"duration":1,"a":255},{"duration":1,"a":0}]
			
			
		
		}
	]);


this.loader.addAnimation([
		{
			 "start": 73, "duration": 19
			,"layer": 9, "image": "compos_02.png"
			,"position": [{"x":1280/2,"y":720/2}]
			,"color":[{"a":0},{"duration":1,"a":255},{"duration":1,"a":0}]
			
			
		
		}
	]);

this.loader.addAnimation([
		{
			 "start": 75, "duration": 19
			,"layer": 9, "image": "compos_03.png"
			,"position": [{"x":1280/2,"y":720/2}]
			,"color":[{"a":0},{"duration":1,"a":255},{"duration":1,"a":0}]
			
			
		
		}
	]);

this.loader.addAnimation([
		{
			 "start": 77, "duration": 19
			,"layer": 9, "image": "compos_04.png"
			,"position": [{"x":1280/2,"y":720/2}]
			,"color":[{"a":0},{"duration":1,"a":255},{"duration":1,"a":0}]
			
			
		
		}
	]);

this.loader.addAnimation([
		{
			 "start": 79, "duration": 19
			,"layer": 9, "image": "compos_05.png"
			,"position": [{"x":1280/2,"y":720/2}]
			,"color":[{"a":0},{"duration":1,"a":255},{"duration":1,"a":0}]
			
			
		
		}
	]);

this.loader.addAnimation([
		{
			 "start": 81, "duration": 19
			,"layer": 9, "image": "compos_06.png"
			,"position": [{"x":1280/2,"y":720/2}]
			,"color":[{"a":0},{"duration":1,"a":255},{"duration":1,"a":0}]
			
			
		
		}
	]);

this.loader.addAnimation([
		{
			 "start": 83, "duration": 19
			,"layer": 9, "image": "compos_07.png"
			,"position": [{"x":1280/2,"y":720/2}]
			,"color":[{"a":0},{"duration":1,"a":255},{"duration":1,"a":0}]
			
			
		
		}
	]);

this.loader.addAnimation([
		{
			 "start": 85, "duration": 19
			,"layer": 9, "image": "compos_08.png"
			,"position": [{"x":1280/2,"y":720/2}]
			,"color":[{"a":0},{"duration":1,"a":255},{"duration":1,"a":0}]
			
			
		
		}
	]);

this.loader.addAnimation([
		{
			 "start": 87, "duration": 19
			,"layer": 9, "image": "compos_09.png"
			,"position": [{"x":1280/2,"y":720/2}]
			,"color":[{"a":0},{"duration":1,"a":255},{"duration":1,"a":0}]
			
			
		
		}
	]);


this.loader.addAnimation([
		{
			 "start": 89, "duration": 19
			,"layer": 9, "image": "compos_10.png"
			,"position": [{"x":1280/2,"y":720/2}]
			,"color":[{"a":0},{"duration":1,"a":255},{"duration":1,"a":0}]
			
			
		
		}
	]);

this.loader.addAnimation([
		{
			 "start": 91, "duration": 19
			,"layer": 9, "image": "compos_11.png"
			,"position": [{"x":1280/2,"y":720/2}]
			,"color":[{"a":0},{"duration":1,"a":255},{"duration":1,"a":0}]
			
		
		}
	]);


	this.ending(93, 15);

/*
	this.funkyBackground("0:00", "2:00");

	this.loader.addAnimation([
	{
		 "start": "0:00", "end": "1:31"
		,"layer": "00011"
		,"image": "nyrkki_6.png"
		,"scale": [
			{
				"x":"{return Math.sin(getSceneTimeFromStart()*4)*0.1+1.0}",
				"y":"{return Math.cos(getSceneTimeFromStart()*4)*0.1+1.0}"
			}]
		,"color":[{"a":200}]
	}]);

	this.loader.addAnimation([
	{
		 "start": "0:00", "end": "1:31"
		,"layer": "00012"
		,"initFunction":"{initHeartCurve(animation);}"
		,"runFunction":"{drawHeartCurve(animation);}"
	}]);

	this.preInitIntro("0:00", "0:20");

	this.preInitText("0:45", "1:00");
*/

	this.loader.processAnimation();
}

Demo.prototype.ending = function(startTime, durationTime)
{
	var startLayer = 100;
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"layer": startLayer
		,"image": "pinkktausta_2.png"
		,"color":[{"a":0},{"duration":1,"a":255},{"duration":durationTime-2},{"duration":1,"a":0}]
	}]);
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": 3
		,"layer": startLayer
		,"image": "bestpart.png"
		,"color":[{"a":0},{"duration":1,"a":255},{"duration":1},{"duration":1,"a":0}]
	}]);

	var textImages = [
		"you.png",
		"are.png",
		"not.png",
		"invited.png"
	];
	var textStart = startTime + 2;
	var fade = 0.2;
	var textDuration = 1;
	for (var i = 0; i < textImages.length; i++)
	{
		textStart += textDuration-fade;
		if (i == textImages.length-1)
		{
			textDuration *= 1.5;
		}

		this.loader.addAnimation([
		{
			 "start": textStart, "duration": textDuration
			,"layer": startLayer, "image": textImages[i]
			,"color":[{"a":0},{"duration":fade,"a":255},{"duration":textDuration-fade*2},{"duration":fade,"a":0}]
		}]);
	}
this.loader.addAnimation([
		{
			 "start": 100, "duration": 10
			,"layer": startLayer, "image": "nyrkki_6.png"
			,"position": [{"x":1280/2,"y":430}]
			,"color":[{"a":0},{"duration":1,"a":255}]
			,"scale":[{"x":0, "y":0},{"duration":1.5,"x":1, "y":1}]
			
			
		
		}
	]);

this.loader.addAnimation([
		{
			 "start": 102, "duration": 10
			,"layer": startLayer+1, "image": "tiara_2.png"
			,"position": [{"x":700,"y":-300},{"duration":1.5,"x":700,"y":150}]
			,"angle":[{"degreesZ":10}]
			,"scale":[{"x":0.6, "y":0.6}]
			
			
		
		}
	]);


}






Demo.prototype.funkyBackground = function(startTime, durationTime, isFeatureScene)
{



	/*var samples = 20;
	var spread = 0.025;
	var intensity = "{return 0.14*(0.5+(Math.sin(getSceneTimeFromStart())+1)/4);}";
	var alpha = 0.7;*/

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"layer": 1
		,"fbo":{"name":"kaleidoscopeFbo","action":"begin"}
	},
	{
		 "start": startTime, "duration": durationTime
		,"layer": 3
		,"fbo":{"name":"kaleidoscopeFbo","action":"unbind"}
	}/*,
	{
		 "start": startTime, "duration": durationTime
		,"layer": "00051"
		,"fbo":{"name":"fbo2","action":"begin"}
	},
	{
		 "start": startTime, "duration": durationTime
		,"layer": "00052"
		,"fbo":{"name":"fbo","action":"draw"}
		,"shader":{"name":"data/shader/glow.fs","variable":[
					 {"name":"direction","value":[1,0]}
					,{"name":"alpha","value":[1.0]}
					,{"name":"spread","value":[spread]}
					,{"name":"intensity","value":[intensity]}
					,{"name":"samples","type":"int","value":[samples]}
				]}
	},
	{
		 "start": startTime, "duration": durationTime
		,"layer": "00053"
		,"fbo":{"name":"fbo2","action":"unbind"}
	},
	{
		 "start": startTime, "duration": durationTime
		,"layer": "00055"
		,"fbo":{"name":"fbo2","action":"draw"}
		,"shader":{"name":"data/shader/glow.fs","variable":[
					 {"name":"direction","value":[0,1]}
					,{"name":"alpha","value":[alpha]}
					,{"name":"spread","value":[spread]}
					,{"name":"intensity","value":[intensity]}
					,{"name":"samples","type":"int","value":[samples]}
				]}
	}*/
	]);

	if (isFeatureScene === true)
	{
		this.loader.addAnimation([
		{
			 "start": startTime, "duration": durationTime
			,"layer": "00002", "image": "pinkktausta.png"
			,"color":[{"a":0},{"duration":1,"a":255},{"duration": durationTime-2},{"duration":1,"a":0}]
		
		}
		]);


		var images = [
			"pinkdiamond.png",
			"bow.png",
			"rose.png",
			"nyrkki_6_pieni.png",
			"kakku.png",
			"light_6.png",
			"pinkki_auto_1.png",
			"tiara_1.png",
			"tiara_2.png",
			"pinkki_kenka.png",
			"mekko_1.png"

		];

		var kaleidoObjects = 100;
		for(var i = 0; i < kaleidoObjects; i++)
		{
			var precision = 90;
			var radius = getScreenWidth();
			var angle = (random()*precision+precision)*Math.PI/precision;
			var endX = Math.cos(angle) * radius;
			var endY = Math.sin(angle) * radius;

			var start = startTime+(i/kaleidoObjects)*(durationTime-2);
			var kaleidoObjectDuration = 4+random()*2;
			if (start+kaleidoObjectDuration > startTime+durationTime)
			{
				continue;
			}
			this.loader.addAnimation([{
				 "start": start, "duration": kaleidoObjectDuration
				,"layer": 2, "image": images[Utils.getRandomArrayIndex(images)]
				,"position": [{"x": 1280+300,"y":-300}, {"duration": kaleidoObjectDuration, "x":endX,"y":720-endY}]
				,"angle":[{"degreesZ": 0},{"duration":kaleidoObjectDuration,"degreesZ":360}]	
			}]);
		}
	}
	else
	{
		this.loader.addAnimation([
			{
				 "start": startTime, "duration": durationTime
				,"layer": 2, "image": ["data/pinkki_leopardi_tausta.png","data/turkoosi_leopardi_tausta.png"]
				,"scale":[{"uniform2d":3}]
				,"shader":{"name":"data/shader/funkyBackground.fs",
					"variable":[
						 {"name":"texture1","type":"int","value":[1]}
						,{"name":"transition","value":["{return (Math.sin(getSceneTimeFromStart()*2.0)+1)/2;}"]}
					]
				}
			}
		]);
	}


	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"layer": 3
		,"initFunction":"{kaleidoscopeInit(animation);}"
		,"runFunction":"{kaleidoscopeRun(animation);}"
	}]);
}

var kaleidoscopeFbo = {};
function kaleidoscopeInit(animation)
{
	kaleidoscopeFbo.ref = fboInit("kaleidoscopeFbo");
}

function kaleidoscopeRun(animation)
{
	fboBindTextures(kaleidoscopeFbo.ref.ptr);

	glColor4f(1,1,1,1);
	/*if (kaleidoscopeFbo.ref.color !== void null)
	{
		setTextureSizeToScreenSize(kaleidoscopeFbo.ref.color.ptr);
	}
	if (kaleidoscopeFbo.ref.depth !== void null)
	{
		setTextureSizeToScreenSize(kaleidoscopeFbo.ref.depth.ptr);
	}
	drawTexture(kaleidoscopeFbo.ref.color.ptr);
	
	fboBindTextures();*/
	var w=getScreenWidth()/2;
	var h=getScreenHeight()/2;

	perspective2dBegin(getScreenWidth(),getScreenHeight());
	var kaleidoScreens = [
		 {"w":w,"h":h,"x":0,"y":0,"uMax":1.0,"uMin":0.0,"vMax":1.0,"vMin":0.0}
		,{"w":w,"h":h,"x":w,"y":0,"uMax":-1.0,"uMin":0.0,"vMax":1.0,"vMin":0.0}
		,{"w":w,"h":h,"x":w,"y":h,"uMax":-1.0,"uMin":0.0,"vMax":-1.0,"vMin":0.0}
		,{"w":w,"h":h,"x":0,"y":h,"uMax":1.0,"uMin":0.0,"vMax":-1.0,"vMin":0.0}
	];
	for(var i = 0; i < kaleidoScreens.length; i++)
	{
		var kaleidoScreen = kaleidoScreens[i];
		w=kaleidoScreen.w;
		h=kaleidoScreen.h;
		var x=kaleidoScreen.x;
		var y=kaleidoScreen.y;
		var uMax = kaleidoScreen.uMax;
		var vMax = kaleidoScreen.vMax;
		var uMin = kaleidoScreen.uMin;
		var vMin = kaleidoScreen.vMin;

		//debugPrint(JSON.stringify(kaleidoScreen,null,2));

		glBegin(GL_QUADS);
		glTexCoord2f(uMax,vMax);
		glVertex3d(x+w,y+h,0);
		glTexCoord2f(uMin,vMax);
		glVertex3d(x,y+h,0);
		glTexCoord2f(uMin,vMin);
		glVertex3d(x,y,0);
		glTexCoord2f(uMax,vMin);
		glVertex3d(x+w,y,0);
		glEnd();
	}

	perspective2dEnd();
}

function getPaletteColorAsVec4Uniform(colorIndex)
{
	var pal1 = colorPalette[colorIndex];
	return [pal1.r/255.0, pal1.g/255.0, pal1.b/255.0, pal1.a/255.0];
}

var TICK = timerGetBeatInSeconds();

Demo.prototype.preInitIntro = function(startTime, durationTime)
{
	var layer = "00050";
	var textDuration = TICK*10;
	var fadeDuration = TICK*2;

	var fistDuration = textDuration*5;
	/*this.loader.addAnimation([
		{
			 "start": startTime, "duration": fistDuration
			,"layer": layer, "image": "data/pinkki_leopardi_tausta.png"
			,"color": [
				 {"a":150}
			]
		}
	]);*/

	/*this.loader.addAnimation([
		{
			 "start": startTime, "duration": fistDuration
			,"layer": layer, "image": "data/nyrkki_6.png"
			,"scale": [{"x":1.5,"y":1.5}]
			,"color": [
				 {"a":0}
				,{"duration":fadeDuration,"a":255}
				,{"duration":fistDuration-fadeDuration*2}
				,{"duration":fadeDuration,"a":0}
			]
		}
	]);*/

	this.loader.addAnimation([
		{
			 "start": startTime, "duration": textDuration
			,"layer": layer, "image": "data/finland.png"
			,"color": [
				 {"a":0}
				,{"duration":fadeDuration,"a":255}
				,{"duration":textDuration-fadeDuration*2}
				,{"duration":fadeDuration,"a":0}
			]
		}
	]);

	this.loader.addAnimation([
		{
			 "start": startTime+textDuration-fadeDuration, "duration": textDuration
			,"layer": layer, "image": "data/september.png"
			,"color": [
				 {"a":0}
				,{"duration":fadeDuration,"a":255}
				,{"duration":textDuration-fadeDuration*2}
				,{"duration":fadeDuration,"a":0}
			]
		}
	]);

	this.loader.addAnimation([
		{
			 "start": startTime+textDuration*2, "duration": durationTime
			,"layer": layer, "image": "data/jml_sweet2016.png"
			,"color": [
				 {"a":0}
				,{"duration":fadeDuration,"a":255}
				,{"duration":textDuration*2-fadeDuration*2}
				,{"duration":fadeDuration,"a":0}
			]
		}
	]);
}

// HEART START *************************
var heartParticleContainer;
var heartParticleX = 0;
var heartParticleY = 0;
function heartParticleInit(particleContainer, particle)
{
	var scale = 0.05+random()*0.1;	
	setParticleScaleRange(particle.ptr, scale, scale, 0, scale, scale, 0);
	
	var precision = getScreenHeight();
	var radius = 20;
	setParticleAngleRange(particle.ptr, 0, 0, random()*90*(random()*2-1), 0, 0, random()*90*(random()*2-1));

	var starW = 512;
	var starH = 512;
	var x = heartParticleX;
	var y = heartParticleY;
	var angle = (random()*precision+precision)*2*Math.PI/precision;
	var endX = x;//+Math.cos(angle) * radius;
	var endY = y;//+Math.sin(angle) * radius;
	setParticlePositionRange(particle.ptr, x, y, 0, endX, endY, 0);
	
	var lifeSeconds = 0.55;	
	var startTime = getSceneTimeFromStart()+random()*lifeSeconds*2;
	var duration = lifeSeconds;
	if (heartParticleX == 0) {duration = 0;}
	setParticleTime(particle.ptr, startTime, duration);
	
	var color = colorPalette[Utils.getRandomArrayIndex(colorPalette)];
	particle.color = color;
	setParticleColor(particle.ptr, color.r/255, color.g/255, color.b/255, 1);
}

function initHeartParticles(animation)
{



	heartParticleContainer = initParticleContainer();
	setParticleContainerTime(heartParticleContainer.ptr, animation.start, animation.duration);
	setParticleContainerPerspective3d(heartParticleContainer.ptr, 0);
	bindParticleContainerInitParticleFunction(heartParticleContainer.ptr, "heartParticleInit");
	setParticleContainerDefaultTextureList(heartParticleContainer.ptr,
		[
			 imageLoadImage("data/heart2.png").ptr
			,imageLoadImage("data/heart3.png").ptr
			,imageLoadImage("data/heart4.png").ptr
			,imageLoadImage("data/heart5.png").ptr
		]
	);
	initParticleContainerParticles(heartParticleContainer.ptr, 0, 600);
}
function initHeartCurve(animation)
{
	initHeartParticles(animation);
}

function drawHeartCurve(animation)
{
	//perspective2dBegin(getScreenWidth(), getScreenHeight());
	
	glColor3f(1,1,1);
	
	var time = getSceneTimeFromStart()-animation.start;
	
	var precision = 100;
	var radius = 20;
	var x = getScreenWidth()/2.0;
	var y = getScreenHeight()/2.0;

	var i = precision*time/20.;
	var angle = (i+precision)*20*Math.PI/precision;
	var x1 = x + Math.sin(angle) * radius;
	var y1 = y + Math.cos(angle) * radius;

	var x1 = x + 15*Math.pow(Math.sin(angle),3) * radius + Math.cos(time*14)*40;
	var y1 = y + (13*Math.cos(angle) - 5*Math.cos(angle*2) - 2*Math.cos(angle*3) - Math.cos(angle*4)) * radius + Math.pow(Math.sin(time*9)*20,1);
	glVertex2f(x1,y1);
	
	heartParticleX = x1;
	heartParticleY = y1;
	glBlendFunc(GL_SRC_ALPHA,GL_ONE);
	drawParticleContainer(heartParticleContainer.ptr);
}

var colorPalette = [
	 {"r":234,"g":53,"b":86,"a":0xFF}
	,{"r":0xd4,"g":0x03,"b":0x1e,"a":0xFF}
	,{"r":0xf0,"g":0x19,"b":0x69,"a":0xFF}
	,{"r":0xf8,"g":0xb4,"b":0xb1,"a":0xFF}
	,{"r":0xfd,"g":0x03,"b":0x79,"a":0xFF}
	,{"r":0xf7,"g":0xbd,"b":0xaf,"a":0xFF}
];

// HEART END ********************************

var txtImages = [[],[]]

function featuresInit(animation)
{
	var featuresCount = 13;
	for(var i = 1; i <= featuresCount; i++)
	{
		txtImages[0].push(imageLoadImage("features_" + i + ".png"));
	}
}

Demo.prototype.preInitText = function(startTime, durationTime)
{
	Sync.addSync([
	{
		 "name":"txt1.type"
		,"type":"rocket"
	}]);
	Sync.addSync([
	{
		 "name":"txt1.i"
		,"type":"rocket"
	}]);
	Sync.addSync([
	{
		 "name":"txt1.scale"
		,"type":"rocket"
	}]);
	Sync.addSync([
	{
		 "name":"txt1.angle"
		,"type":"rocket"
	}]);
	Sync.addSync([
	{
		 "name":"txt1.alpha"
		,"type":"rocket"
	}]);

	Sync.addSync([
	{
		 "name":"txt2.type"
		,"type":"rocket"
	}]);
	Sync.addSync([
	{
		 "name":"txt2.i"
		,"type":"rocket"
	}]);
	Sync.addSync([
	{
		 "name":"txt2.scale"
		,"type":"rocket"
	}]);
	Sync.addSync([
	{
		 "name":"txt2.angle"
		,"type":"rocket"
	}]);
	Sync.addSync([
	{
		 "name":"txt2.alpha"
		,"type":"rocket"
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"layer": "00000"
		,"initFunction":"{featuresInit(animation);}"
	}]);
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"layer": "00000"
		,"initFunction":"{composInit(animation);}"
	}]);

	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"layer": "00100"
		,"type":"{return Sync.getSyncValue('txt1.type');}"
		,"i":"{return Sync.getSyncValue('txt1.i');}"
		,"scale":"{return Sync.getSyncValue('txt1.scale');}"
		,"degreesZ":"{return Sync.getSyncValue('txt1.angle');}"
		,"alpha":"{return Sync.getSyncValue('txt1.alpha');}"
		,"runFunction":"{drawPartyText(animation);}"
	}]);
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"layer": "00100"
		,"type":"{return Sync.getSyncValue('txt2.type');}"
		,"i":"{return Sync.getSyncValue('txt2.i');}"
		,"scale":"{return Sync.getSyncValue('txt2.scale');}"
		,"degreesZ":"{return Sync.getSyncValue('txt2.angle');}"
		,"alpha":"{return Sync.getSyncValue('txt2.alpha');}"
		,"runFunction":"{drawPartyText(animation);}"
	}]);
}

function composInit(animation)
{
	var composCount = 11;
	for(var i = 1; i <= composCount; i++)
	{
		txtImages[1].push(imageLoadImage("compos_" + i + ".png"));
	}
}

function drawPartyText(animation)
{
	var ref = txtImages[Utils.evaluateVariable(animation, animation.type)][Utils.evaluateVariable(animation, animation.i)];
	perspective2dBegin(getScreenWidth(), getScreenHeight());

	glColor4f(1,1,1,Utils.evaluateVariable(animation, animation.alpha));
	setTextureDefaults(ref.ptr);
	setTextureCenterAlignment(ref.ptr, 1);
	setTextureRotation(ref.ptr, 0, 0, Utils.evaluateVariable(animation, animation.degreesZ), 0, 0, 1);
	//setTexturePosition(ref.ptr, x, y, 0);
	var scale = Utils.evaluateVariable(animation, animation.scale);
	setTextureScale(ref.ptr, scale, scale);

	drawTexture(ref.ptr);	
	perspective2dEnd();
}

// *********************
var cubeObject2 = {};
//var gridPic;
function initCubes2(animation)
{
	cubeObject2.ref = loadObject("dabomb.obj");
	//gridPic = imageLoadImage("dabombtex.png");
	useObjectLighting(cubeObject2.ref.ptr, 0);
	useObjectCamera(cubeObject2.ref.ptr, 0);
	useObjectNormals(cubeObject2.ref.ptr, 1);
	useObjectTextureCoordinates(cubeObject2.ref.ptr, 1);
}

function drawCubes2(animation)
{
	//glEnable(GL_TEXTURE_2D);
	//glEnable(GL_DEPTH_TEST);
	//glBindTexture(GL_TEXTURE_2D, gridPic.id);
	drawObject(cubeObject2.ref.ptr, "Camera01", 0, 0);
}



Demo.prototype.run = function()
{
	this.player.drawAnimation(this.loader.animationLayers);
}

Demo.prototype.deinit = function()
{
}

/*************************
 * Generic/common stuff
 *************************/

var colorPalette = [
	{"r":0xF7,"g":0xCA,"b":0xC9,"a":0xFF}, //0 - rose quartz - pink
	{"r":0xF7,"g":0x78,"b":0x6B,"a":0xFF}, //1 - peach echo - light redish
	{"r":0x91,"g":0xA8,"b":0xD0,"a":0xFF}, //2 - serenity - light blueish
	{"r":0x03,"g":0x4F,"b":0x84,"a":0xFF}, //3 - snorkel blue - dark blueish
	{"r":0xFA,"g":0xE0,"b":0x3C,"a":0xFF}, //4 - buttercup - yellow
	{"r":0x98,"g":0xDD,"b":0xDE,"a":0xFF}, //5 - limpet shell - light blueish
	{"r":0x98,"g":0x96,"b":0xA4,"a":0xFF}, //6 - lilac gray - gray purpleish
	{"r":0xDD,"g":0x41,"b":0x32,"a":0xFF}, //7 - fiesta - dark redish
	{"r":0xB1,"g":0x8F,"b":0x6A,"a":0xFF}, //8 - iced coffee - brownish
	{"r":0x79,"g":0xC7,"b":0x53,"a":0xFF}  //9 - green flash - greenish
];

function glPaletteColor(percent, color1, color2, alpha, brightness)
{
	if (alpha === void null)
	{
		alpha = 1.0;
	}

	if (brightness === void null)
	{
		brightness = 1.0;
	}

	var pal1 = colorPalette[color1];
	var pal2 = colorPalette[color2];
	glColor4ub(
		(pal2.r*percent+pal1.r*(1-percent))*brightness,
		(pal2.g*percent+pal1.g*(1-percent))*brightness,
		(pal2.b*percent+pal1.b*(1-percent))*brightness,
		255*alpha
	);
}

/*************************
 * Model drawing scene
 *************************/

Demo.prototype.preInitModelDrawing = function(startTime, durationTime)
{
	this.loader.addAnimation([
	{
		 "start": startTime, "duration": durationTime
		,"layer": "00011"
		,"initFunction":"{initModelDrawing(animation);}"
		,"objectFunction":"{drawModelDrawing(animation);}"
	}]);
}

var linePoints; 
var modelSplineContainer;
function initModelDrawing(animation)
{
	modelSplineContainer = loadSplineContainerFromFile("data/model_drawing.dat");
	
	linePoints = [
		 {"x":50,"y":50}
		,{"x":100,"y":100}
		,{"x":150,"y":125}
		,{"x":200,"y":100}
		,{"x":200,"y":50}
	];
}

function drawModelDrawing(animation)
{
	var animationProgress = (getSceneTimeFromStart()-animation.start)/animation.duration;
	
		glLineWidth(1);
		
	perspective2dBegin(getScreenWidth(), getScreenHeight());
	glColor3f(1,0,0);
	drawSplineContainer(modelSplineContainer.ptr, 0.0, animationProgress);

	perspective2dEnd();
}

/*********************
 * Garment print scene
 *********************/

Demo.prototype.preInitGarmentPrint = function(startTime, durationTime)
{
	this.loader.addAnimation([
		{
			 "start": startTime, "duration": durationTime
			,"layer": "00010", "image": "data/consult.png"
			,"scale": [{"x":0.9,"y":0.9}]
			,"position": [
				{"x":0,"y":0}
			]
			,"color": [
				 {"a":0}
				,{"duration":0.5,"a":255}
			]
		}
	]);

	this.loader.addAnimation([
		{
			 "start": startTime, "duration": durationTime
			,"layer": "00010", "image": ["data/model.png","data/noise.png"]
			,"scale": [{"x":0.9,"y":0.9}]
			,"position": [
				{"x":getScreenWidth()/2,"y":0}
			]
			,"color": [
				 {"a":0}
				,{"duration":0.5,"a":255}
			]
			,"shader":{"name":"Dress",
				"variable":[
					 {"name":"texture1","type":"int","value":[1]}
					,{"name":"color1","value":getPaletteColorAsVec4Uniform(0)}
					,{"name":"color2","value":getPaletteColorAsVec4Uniform(1)}
					/*
					POLKA_DOTS 1
					HALF_CIRCLE_WAVES 2
					DIAGONAL_WAVES 3
					VERTICAL_LINES 4
					HORIZONTAL_LINES 5
					SQUARE_DOTS 6
					LARGE_WAVY 7
					*/
					,{"name":"garmentTexture1","value":[5]}
					,{"name":"garmentTexture2","value":[7]}
					,{"name":"garmentTransition","value":["{return (Math.sin(getSceneTimeFromStart()*1.0)+1)/2;}"]}
				]
			}
		}
	]);
}
