// A nice little scroll text routine
Scroller = function( container, x, y, w, h, speed )
{
	this.interval = false;
	
	this.setup( container, x, y, w, h, speed );
}
	
// Setup the canvas and all arrays
Scroller.prototype.setup = function( container, x, y, w, h, speed )
{
	container.className = 'scroller pixelled';
	if( !speed ) speed = 1;
	var t = document.createElement( 'div' );
	t.style.width = w + 'px';
	t.style.height = h + 'px';
	t.style.top = y + 'px';
	t.style.left = x + 'px';
	t.style.position = 'absolute';
	t.style.overflow = 'hidden';
	t.style.transform = 'zrotate(0deg)';
	container.appendChild( t );
	this.domElement = t;
	this.letters = [];
	this.textPos = 0;
	this.domNodes = [];
}
Scroller.prototype.setText = function( text )
{
	this.text = [];
	for( var a = 0; a < text.length; a++ )
	{
		var w = 23;
		/*switch( text[a].toLowerCase() )
		{
			case '.':
			case ',':
			case '!':
			case 'i':
			case 'l':
			case 'j':
				w = 10;
				break;
		}*/
		this.text.push( {
			letter: text[a],
			width: w
		} );
	}
}
Scroller.prototype.start = function()
{
	this.time = ( new Date() ).getTime();
}
Scroller.prototype.move = function()
{
	var timeNow = ( new Date() ).getTime();
	var phase = ( timeNow - this.time ) / 5;
	if( phase > this.text[this.textPos].width )
	{
		this.time = ( new Date() ).getTime();
		
		// Emit the letter
		var l = document.createElement( 'div' );
		l.className = 'letter pixelled';
		l.innerHTML = this.text[this.textPos].letter;
		l.style.position = 'absolute';
		l.style.left = this.domElement.offsetWidth + 'px';
		l.style.top = '0px';
		l.style.width = this.text[this.textPos].width + 'px';
		l.time = ( new Date() ).getTime();
		this.domElement.appendChild( l );
		this.domNodes.push( l );
		this.textPos++;
		// Wrap around
		if( this.textPos >= this.text.length )
		{
			this.textPos = 0;
		}
	}
	
	// Move the emitted letters
	for( var a = 0; a < this.domNodes.length; a++ )
	{
		var n = this.domNodes[a];
		var multiplier = ( timeNow - n.time ) / 4000;
		var left = Math.floor( this.domElement.offsetWidth - ( this.domElement.offsetWidth * multiplier ) );
		if( left < -30 )
		{
			var o = [];
			for( var a = 0; a < this.domNodes.length; a++ )
			{
				if( this.domNodes[a] != n )
					o.push( this.domNodes[a] );
			}
			this.domNodes = o;
			n.parentNode.removeChild( n );
		}
		n.style.left = left + 'px';
	}
}

