/*
 * Paraguay collor correction pipe by rimina
 */

THREE.ParaguayColorCorrect = {

	uniforms: {

		"tDiffuse":   { type: "t", value: null },
		"brightness": { type: "f", value: 0 },
        "negate":   { type: "i", value: 0},
        "gamma": {type: "v3", value: new THREE.Vector3(1.7, 1.7, 1.7)}

	},

	vertexShader: [

		"varying vec2 vUv;",
		"void main() {",
			"vUv = uv;",
			"gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );",
		"}"

	].join("\n"),

	fragmentShader: [

        "uniform sampler2D tDiffuse;",
        "uniform float brightness;",
        "uniform int negate;",
        "uniform vec3 gamma;",

        "varying vec2 vUv;",

        "void main() {",
            "vec4 c = texture2D( tDiffuse, vUv );",

            //Brightness
            "c.rgb += brightness;",
            "c.rgb = clamp(c.rgb, vec3(0.), vec3(1.));",

            //negate
            "if(negate == 1){",
                "c.rgb = vec3(1.)-c.rgb;",
            "}",

            "float vigentOffset = .005;",
            "float darkness = .4;",
            "float dist = distance( vUv, vec2( 0.5 ) );",
            "c.rgb *= smoothstep( 0.8, vigentOffset * 0.799, dist *( darkness + vigentOffset ) );",
            
            "c.rbg = pow(c.rbg, 1./gamma);",

            "gl_FragColor = c;",
        "}"

	].join("\n")

};
