#version 120

uniform sampler2D flowmap;
uniform sampler2D sourcefeed;
uniform sampler2D sourceimage;

uniform float coloramount;
uniform float feedbackamount;
varying vec2 texturecoordinate;

void main(void)
{
//	vec4 noisetexel = texture2D(randomtexture, texturecoordinate);
	vec4 flowmaptexel = texture2D(flowmap, texturecoordinate);
	flowmaptexel *= 2*3.141592;
	vec2 displaceR = vec2(sin(flowmaptexel.r), cos(flowmaptexel.r)) * flowmaptexel.a * 0.1;
	vec2 displaceG = vec2(sin(flowmaptexel.g), cos(flowmaptexel.g)) * flowmaptexel.a * 0.1;
	vec2 displaceB = vec2(sin(flowmaptexel.b), cos(flowmaptexel.b)) * flowmaptexel.a * 0.1;

	vec4 originaltexel = texture2D(sourceimage, texturecoordinate); 
	vec4 feedbackR = texture2D(sourcefeed, texturecoordinate + displaceR); 
	vec4 feedbackG = texture2D(sourcefeed, texturecoordinate + displaceG); 
	vec4 feedbackB = texture2D(sourcefeed, texturecoordinate + displaceB); 

//	vec4 texel = originaltexel * 0.05 + feedbackR * 0.95; 

	vec4 texel = originaltexel * (1.0 - feedbackamount) + mix(feedbackR, vec4(feedbackR.x, feedbackG.y, feedbackB.z, feedbackR.a), coloramount) * feedbackamount; 
	gl_FragColor = texel;
}