var Lentokentta = function(){
    PartBase.call(this);
    PartBase.prototype.initScene.call(this);
    this.video = document.getElementById( 'tikkurila' );
    
    this.scene.fog = new THREE.Fog(0xFFFFFF, 100, 800);

    this.texture = TDEMO.textures.tikkurila;
    this.tunnel = this.createLentokentta(this.texture);
    this.scene.add(this.tunnel);
};

Lentokentta.prototype = PartBase.prototype.inheritance();

Lentokentta.prototype.prepare = function(){
    PartBase.prototype.prepare.call(this);
    
    this.edge = new THREE.ShaderPass( THREE.EdgeShader2 );
    this.edge.uniforms[ "resolution" ].value =  new THREE.Vector2(TDEMO.width, TDEMO.height);
    TDEMO.composer.insertPass(this.edge, 1);
    
    this.bloom = new THREE.BloomPass(3);
    this.bloom.renderToScreen = true;
    TDEMO.composer.insertPass(this.bloom, 2);
    
    this.copy = new THREE.ShaderPass(THREE.CopyShader);
    TDEMO.composer.insertPass(this.copy, 3);
    
    this.dof = new THREE.BokehPass(this.scene, this.camera, {
        focus : 1.0,
        width: TDEMO.width,
        height: TDEMO.height,
        maxblur: 0.5,
        aperture: 0.005
    });
    this.dof.renderToScreen = true;
    TDEMO.composer.addPass(this.dof);
    TDEMO.copyPass.enabled = false;
    
    this.video.currentTime = 0;
    this.video.play();
};

Lentokentta.prototype.finish = function(){
   PartBase.prototype.finish.call(this);
   this.edge.enabled = false;
   this.bloom.enabled = false;
   this.copy.enabled = false;
   this.dof.enabled = false;
   TDEMO.copyPass.enabled = true;
   
   this.video.pause();
};

Lentokentta.prototype.animate = function(elapsedTime, delta){
  PartBase.prototype.animate.call(this, elapsedTime, delta);
};

Lentokentta.prototype.createLentokentta = function(texture){
    var geometry = new THREE.BoxGeometry(40, 80, 1000);
    
    var material1 = new THREE.MeshBasicMaterial({
        side : THREE.DoubleSide,
        map : texture
    });
    
    var material2 = new THREE.MeshBasicMaterial({
        side : THREE.DoubleSide,
        color : 0xFFFFFF,
        map : TDEMO.textures.taivas
    });
    
    for (var i = 0; i < geometry.faces.length; i++){
        if( i == 6 || i == 7 || i == 4 || i == 5){
            geometry.faces[ i ].materialIndex = 1;
        }
        else{
            geometry.faces[ i ].materialIndex = 0;
        }
    }
    
    var material = new THREE.MultiMaterial([material1, material2]);
    var tunnel = new THREE.Mesh(geometry, material);
    return tunnel;
};