var Chaos = function(){
    PartBase.call(this);
    PartBase.prototype.initScene.call(this);
    
    this.scene.fog = new THREE.Fog(0xFFFFFF, 100, 800);
    
    this.pointLight = new THREE.PointLight(0x808080);
    this.scene.add(this.pointLight);
    
    var sky = this.createSky();
    this.scene.add(sky);
    
    this.kissat();
    this.cats.position.z = -30;
    
    this.ground = this.createHeightMap();
    this.ground.position.y = -60;
    this.scene.add(this.ground);
};


Chaos.prototype = PartBase.prototype.inheritance();

Chaos.prototype.prepare = function(){
    PartBase.prototype.prepare.call(this);
    
    this.edge = new THREE.ShaderPass( THREE.EdgeShader2 );
    this.edge.uniforms[ "resolution" ].value =  new THREE.Vector2(TDEMO.width, TDEMO.height);
    TDEMO.composer.insertPass(this.edge, 1);
    
    this.bloom = new THREE.BloomPass(2);
    this.bloom.renderToScreen = true;
    TDEMO.composer.insertPass(this.bloom, 4);
    
    this.copy = new THREE.ShaderPass(THREE.CopyShader);
    TDEMO.composer.insertPass(this.copy, 3);
    
    this.dof = new THREE.BokehPass(this.scene, this.camera, {
        focus : 1.0,
        width: TDEMO.width,
        height: TDEMO.height,
        maxblur: 2.0,
        aperture: 0.002
    });
    this.dof.renderToScreen = true;
    TDEMO.composer.addPass(this.dof);
    TDEMO.copyPass.enabled = false;
};

Chaos.prototype.finish = function(){
   PartBase.prototype.finish.call(this);
   this.edge.enabled = false;
   this.bloom.enabled = false;
   this.copy.enabled = false;
   this.dof.enabled = false;
   TDEMO.copyPass.enabled = true;
};


Chaos.prototype.animateCats = function(elapsedTime) {
  for(var i=0; i<this.catArray.length; i++) {
    var c = this.catArray[i];
    c.position.y = (Math.sin(elapsedTime)*(c.position.z*0.1+1)+Math.cos(elapsedTime)*(0.1*c.position.x-1));
  }
};

Chaos.prototype.moveCats = function(elapsedTime) {
  var catRot = SYNC.getObjRotation();
  var catPos = SYNC.getObjPosition();
  
  this.cats.position.x = catPos.x;
  this.cats.position.y = catPos.y;
  this.cats.position.z = catPos.z;
  
  this.cats.rotation.x = catRot.x;
  this.cats.rotation.y = catRot.y;
  this.cats.rotation.z = catRot.z;
};

Chaos.prototype.animate = function(elapsedTime, delta){
  PartBase.prototype.animate.call(this, elapsedTime, delta);
  this.pointLight.position.set(this.camera.position.clone());
  var rot = delta/8;
  this.animateCats(elapsedTime);
  this.moveCats();
};



Chaos.prototype.kissat = function() {
  var kissat = kissalauma();
  this.cats = kissat["cats"];
  this.catArray = kissat["catArray"];
  this.scene.add(this.cats);
  this.cats.position.set(0,-30,0);
  this.cats.rotation.y = Math.PI / 6;
};


Chaos.prototype.createPyramids = function(){

    var material = new THREE.MeshBasicMaterial({
        color : 0xFFFFFF,
        envMap : TDEMO.textures.env_taivas
    });
    var geometry = new THREE.OctahedronGeometry(100);
    var pyramids = new THREE.Object3D();
    
    var posX = -600;
    var deltaX = 200;
    for(var i = 0; i < 6; ++i){
        var p = new THREE.Mesh(geometry,material);
        p.position.x = posX;
        pyramids.add(p);
        posX += deltaX;
        p.rotation.y = -Math.PI/3;
    }
    return pyramids;
};

Chaos.prototype.createHeightMap = function(){
    var geometry = TDEMO.heightGeometry();
    var material = new THREE.MeshDepthMaterial();
    
    var ground = new THREE.Mesh( geometry, material );
    ground.rotation.x = -Math.PI/2;
    
    var pyramids = this.createPyramids();
    pyramids.position.z = -300;
    var gourndGroup = new THREE.Object3D();
    gourndGroup.add(ground);
    gourndGroup.add(pyramids);
    
    return gourndGroup;
};

Chaos.prototype.createSky = function(){
    var geometry = new THREE.SphereGeometry(400, 64, 64);
    var material = new THREE.MeshBasicMaterial({
        map: TDEMO.textures.taivas,
        color: 0x00AAAA,
        side : THREE.BackSide
    });
    
    var sky = new THREE.Mesh(geometry, material);
    return sky;
};
