var Heart = function(heartMaterial, bloodMaterial, sizeH, vertices, rings){
    
    
    var geometry = new THREE.SphereGeometry(sizeH, vertices, vertices, rings);
    var h1 = new THREE.Points(geometry, heartMaterial);
    h1.scale.y = 0.5;
    var h2 = h1.clone();
    
    h1.position.x = sizeH*0.4;
    h2.position.x = -sizeH*0.4;
    h1.rotation.z = Math.PI*0.3;
    h2.rotation.z = -Math.PI*0.3;
    
    var sizeD = 0.6*sizeH;
    var heart = new THREE.Object3D();
    heart.add(h1);
    heart.add(h2);
    
    
    var diamond = false;
    if(bloodMaterial !== false){
        var meshGeometry = new THREE.OctahedronGeometry(sizeD);
        diamond =  new THREE.Mesh(meshGeometry,bloodMaterial);
        diamond.position.y = -0.5*sizeD;
        heart.add(diamond);
    }
    return {heart : heart, diamond : diamond};
};