﻿//Base part


//duration: part length in ms
//startTime: the absolute time when the part starts
//endTime: time that part need for end effect in ms
var PartBase = function(){
  this.elapsed = 0;
  this.startTime = false;
  this.deltaFrame = 0;
  this.effects = [];
};

//scene is initialized before demo starts
PartBase.prototype.initScene = function(par){
    var p = par || {};
    
    this.scene = p.scene !== undefined ? p.scene : new THREE.Scene();
    
    this.camera = p.camera !== undefined ? p.camera : new THREE.PerspectiveCamera(TDEMO.fov, TDEMO.aspect, TDEMO.near, TDEMO.far);
    this.scene.add(this.camera);

    this.renderPass = p.rendererPass !== undefined ? p.rendererPass : new THREE.RenderPass(this.scene, this.camera);
    this.renderPass.enabled = false;
};

//prepare is called just before first rendering
PartBase.prototype.prepare = function(elapsedTime, rtt){
    this.startTime = elapsedTime;
    TDEMO.composer.insertPass(this.renderPass, 0);
    this.renderPass.enabled = true;
};

PartBase.prototype.finish = function(){
    this.renderPass.enabled = false;
    TDEMO.composer.passes.splice(0, 1);
    TDEMO.renderer.clearTarget();
};

//rendering function for rendering the scene to framebuffer otherwise the scene is rendered just with the composer
PartBase.prototype.render = function(renderer, rtt){
    renderer.render(this.scene, this.camera, rtt);  
};

//animation
PartBase.prototype.animate = function(elapsedTime, delta){
    if(this.startTime !== false){
        this.elapsed = elapsedTime-this.startTime;
    }
    else{
        this.elapsed = 0;
    }
    this.deltaFrame = delta;
    
    var camp = SYNC.getCameraPosition();
    this.camera.position.x = camp.x;
    this.camera.position.y = camp.y;
    this.camera.position.z = camp.z;
    
    var camr = SYNC.getCameraRotation();
    this.camera.rotation.x = camr.x;
    this.camera.rotation.y = camr.y;
    this.camera.rotation.z = camr.z;
};

//Switches animation function
PartBase.prototype.switchAnimation = function(animation){
    this.animate = animation;
};

//--------------------------------------------------
// PROTOTYPAL INHERITANCE FUNCTION
//--------------------------------------------------
PartBase.prototype.inheritance = function(){
    function PartBasePrototype(){};
    PartBasePrototype.prototype = this;
    var created = new PartBasePrototype();
    return created;
};
