#version 330 core

// inputz
in vec2 UV;
uniform sampler2D source;
uniform vec2 blurvec;
uniform int nSamples;

// outputz
out vec4 color;

void main() {
    color = vec4(0.0,0.0,0.0,1.0);
    float amount = 0.0;
    for (int i = 0; i < nSamples; i++) {
        vec2 pos = UV + (float(i) - float(nSamples)/2.0) * blurvec;
        float tmp = texture(source, pos).x;
        color.x += tmp;
        color.y += tmp * tmp;
        amount += 1.0;
    }
    color.rg /= amount;
    color.b = amount;
    color.a = 1.0;
}
