#version 330 core
in vec2 UV;
in vec3 n;
layout(location = 0) out vec4 color;
layout(location = 1) out vec4 outnormal;
uniform sampler2D env;
uniform sampler2D ambienttex;
uniform sampler2D reflectivitytex;
uniform float reflc;
uniform float textureType;

const float a = 0.9999;

void main() {
	vec2 lut = vec2(0.0);
	vec3 normal = n;
	if ((abs(normal.x) > abs(normal.y)) && (abs(normal.x) > abs(normal.z))) {
		lut = (normal.yz + vec2(1.0)) / abs(normal.x) / 2.0;
	}
	else if ((abs(normal.y) > abs(normal.x)) && (abs(normal.y) > abs(normal.z))) {
		lut = (normal.xz + vec2(1.0)) / abs(normal.y) / 2.0;
	}
	else {
		lut = (normal.xy + vec2(1.0)) / abs(normal.z) / 2.0;
	}

	vec4 texval = mix(texture(env, lut), texture(ambienttex, vec2(UV.x, 1.0 - UV.y)), vec4(textureType));
	float normalfactor = max(0.0, dot(n, normalize(vec3(0.0, 0.5, -4.0)))); // was float normalfactor = max(0.0, dot(n, normalize(vec3(2.0, 0.5, -1.0))));
	color = texval; // can't remember really :D
	color.a = texture(reflectivitytex, UV).x * reflc;
	outnormal = vec4(n, 1.0);
}
